/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler;

import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class RunSender {
    public String sender = "";
    public int max = 0;
    public int progress = 0;
    public int maxThreads = 0;
    public int waitOnLoad = 0;
    public Date startZeit = new Date();
    public Date endZeit = new Date();
    public boolean fertig = false;
    public final ConcurrentHashMap<Count, AtomicLong> counter = new ConcurrentHashMap();

    public RunSender(String sender, int max, int progress) {
        this.sender = sender;
        this.max = max;
        this.progress = progress;
        for (Count item : EnumSet.allOf(Count.class)) {
            this.counter.put(item, new AtomicLong(0L));
        }
    }

    public static String getStringZaehler(long z) {
        return z == 0L ? "0" : (z / 1000000L == 0L ? "<1" : String.valueOf(z / 1000000L));
    }

    public String getLaufzeitMinuten() {
        String ret = "";
        if (this.startZeit != null) {
            int sekunden = Math.round((this.endZeit.getTime() - this.startZeit.getTime()) / 1000L);
            String min = String.valueOf(sekunden / 60);
            String sek = String.valueOf(sekunden % 60);
            if (sek.length() == 1) {
                sek = '0' + sek;
            }
            ret = min + ':' + sek;
        }
        return ret;
    }

    public int getLaufzeitSekunden() {
        int sekunden = 0;
        if (this.startZeit != null && this.endZeit != null) {
            sekunden = Math.round((this.endZeit.getTime() - this.startZeit.getTime()) / 1000L);
        }
        return sekunden;
    }

    public static enum Count {
        ANZAHL("Seiten"),
        FILME("Filme"),
        FEHLER("Fehler"),
        FEHLVERSUCHE("FVers"),
        WARTEZEIT_FEHLVERSUCHE("ZeitFV[s]"),
        PROXY("Proxy"),
        SUM_DATA_BYTE("sumData"),
        SUM_TRAFFIC_BYTE("sumTraffic"),
        SUM_TRAFFIC_LOADART_NIX("trNix"),
        GET_SIZE_SUM("getSize"),
        GET_SIZE_PROXY("gS-proxy");

        private final String name;

        private Count(String name) {
            this.name = name;
        }

        public static String[] getNames() {
            ArrayList<String> enumNames = new ArrayList<String>();
            for (Count name : EnumSet.allOf(Count.class)) {
                enumNames.add(name.toString());
            }
            return enumNames.toArray(new String[enumNames.size()]);
        }

        public String toString() {
            return this.name;
        }
    }
}

