/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.tool.Log;
import de.mediathekview.mlib.tool.MSStringBuilder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import mServer.crawler.CrawlerTool;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.GetUrl;
import mServer.crawler.sender.MediathekReader;
import org.apache.commons.lang3.StringEscapeUtils;

public class MediathekSrf
extends MediathekReader {
    public static final String SENDERNAME = "SRF";
    private static final int MAX_SEITEN_THEMA = 5;
    private static final int MAX_FILME_KURZ = 6;
    private static final String URL1_M3U8 = "https://srfvodhd-vh.akamaihd.net";
    private static final String URL2_M3U8 = "http://srfvodhd-vh.akamaihd.net";
    private static final String URL3_M3U8 = "http://hdvodsrforigin-f.akamaihd.net";
    private static final String HTTPS = "https";
    private static final String HTTP = "http";
    private static final String SRF_TOPIC_PAGE_URL = "http://www.srf.ch/play/v2/tv/topicList?layout=json";
    private static final String SRF_DATA_BLOCK_BEGIN_PATTERN = "data-teaser=\"";
    private static final char SRF_DATA_BLOCK_END = '\"';

    public MediathekSrf(FilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 3, 100, startPrio);
    }

    @Override
    public void addToList() {
        String muster = "{\"id\":\"";
        MSStringBuilder seite = new MSStringBuilder(65536);
        this.listeThemen.clear();
        this.meldungStart();
        GetUrl getUrlIo = new GetUrl(this.getWartenSeiteLaden());
        seite = getUrlIo.getUri_Utf(SENDERNAME, SRF_TOPIC_PAGE_URL, seite, "");
        int pos = 0;
        while ((pos = seite.indexOf("{\"id\":\"", pos)) != -1) {
            String id;
            int pos1 = seite.indexOf("\"", pos += "{\"id\":\"".length());
            if (pos1 == -1 || (id = seite.substring(pos, pos1)).length() < 10 || id.isEmpty()) continue;
            String thema = seite.extract("\"title\":\"", "\"", pos1);
            thema = StringEscapeUtils.unescapeJava((String)thema).trim();
            this.listeThemen.addUrl(new String[]{id, thema});
        }
        if (Config.getStop() || this.listeThemen.isEmpty()) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size());
            for (int t = 0; t < this.getMaxThreadLaufen(); ++t) {
                ThemaLaden th = new ThemaLaden();
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    private class ThemaLaden
    extends Thread {
        private final GetUrl getUrl;
        private MSStringBuilder overviewPageFilm;
        private MSStringBuilder filmPage;
        private MSStringBuilder m3u8Page;
        private final ArrayList<String> urlList;
        private final ArrayList<String> filmList;

        private ThemaLaden() {
            this.getUrl = new GetUrl(MediathekSrf.this.getWartenSeiteLaden());
            this.overviewPageFilm = new MSStringBuilder(65536);
            this.filmPage = new MSStringBuilder(65536);
            this.m3u8Page = new MSStringBuilder(65536);
            this.urlList = new ArrayList();
            this.filmList = new ArrayList();
        }

        @Override
        public void run() {
            try {
                String[] link;
                MediathekSrf.this.meldungAddThread();
                while (!Config.getStop() && (link = MediathekSrf.this.listeThemen.getListeThemen()) != null) {
                    MediathekSrf.this.meldungProgress(link[0]);
                    this.addFilme(link[0], link[1]);
                }
            }
            catch (Exception ex) {
                Log.errorLog((int)832002877, (Exception)ex);
            }
            MediathekSrf.this.meldungThreadUndFertig();
        }

        private void addFilme(String urlThema, String thema) {
            try {
                String urlFeed = "http://www.srf.ch/play/v2/tv/topic/" + urlThema + "/latest";
                this.overviewPageFilm = new MSStringBuilder();
                this.overviewPageFilm.append(this.extractSrfTopicData(this.getUrl.getUri_Utf(MediathekSrf.SENDERNAME, urlFeed, this.overviewPageFilm, "").substring(0)).toCharArray());
                this.addFilmsFromPage(this.overviewPageFilm, thema, urlFeed);
            }
            catch (Exception ex) {
                Log.errorLog((int)195926364, (Exception)ex);
            }
        }

        private String extractSrfTopicData(String aPageContent) {
            int dataBlockBegin = aPageContent.indexOf(MediathekSrf.SRF_DATA_BLOCK_BEGIN_PATTERN) + MediathekSrf.SRF_DATA_BLOCK_BEGIN_PATTERN.length();
            String tempData = aPageContent.substring(dataBlockBegin);
            return StringEscapeUtils.unescapeHtml4((String)tempData.substring(0, tempData.indexOf(34)));
        }

        private void addFilmsFromPage(MSStringBuilder page, String thema, String themePageUrl) {
            String baseUrlJson = "http://il.srgssr.ch/integrationlayer/1.0/ue/srf/video/play/";
            String endUrlJson = ".jsonp";
            int count = 0;
            this.filmList.clear();
            page.extractList("{\"id\":\"", "?id=", "\"", this.filmList);
            for (String id : this.filmList) {
                if (Config.getStop() || !CrawlerTool.loadLongMax() && ++count > 6) break;
                String jsonMovieUrl = "http://il.srgssr.ch/integrationlayer/1.0/ue/srf/video/play/" + id + ".jsonp";
                this.addFilms(jsonMovieUrl, themePageUrl, thema);
            }
        }

        private void addFilms(String jsonMovieUrl, String themePageUrl, String theme) {
            String index0 = "index_0_av.m3u8";
            String index1 = "index_1_av.m3u8";
            String index2 = "index_2_av.m3u8";
            String index3 = "index_3_av.m3u8";
            String index4 = "index_4_av.m3u8";
            String index5 = "index_5_av.m3u8";
            MediathekSrf.this.meldung(jsonMovieUrl);
            this.filmPage = this.getUrl.getUri_Utf(MediathekSrf.SENDERNAME, jsonMovieUrl, this.filmPage, "");
            try {
                String url3u8;
                String dateStr = "";
                String time = "";
                Date date = this.extractDateAndTime(this.filmPage);
                if (date != null) {
                    SimpleDateFormat dfDayMonthYear = new SimpleDateFormat("dd.MM.yyyy");
                    dateStr = dfDayMonthYear.format(date);
                    dfDayMonthYear = new SimpleDateFormat("HH:mm:ss");
                    time = dfDayMonthYear.format(date);
                }
                long duration = this.extractDuration(this.filmPage);
                String description = this.filmPage.extract("\"description\": \"", "\"");
                description = StringEscapeUtils.unescapeJava((String)description).trim();
                String title = this.filmPage.extract("AssetMetadatas", "\"title\": \"", "\"");
                String urlThema = this.filmPage.extract("\"homepageUrl\": \"", "\"");
                if (urlThema.isEmpty()) {
                    urlThema = "http://www.srf.ch/play/tv/sendungen";
                }
                String subtitle = this.filmPage.extract("\"TTMLUrl\": \"", "\"");
                String urlHD = this.getUrl(this.filmPage, "\"@quality\": \"HD\"", "\"text\": \"");
                String urlNormal = this.getUrl(this.filmPage, "\"@quality\": \"SD\"", "\"text\": \"");
                String urlSmall = "";
                String string = url3u8 = urlHD.endsWith("m3u8") ? urlHD : urlNormal;
                if (url3u8.endsWith("m3u8")) {
                    this.getM3u8(url3u8);
                    if (url3u8.contains("q50,q60")) {
                        if (this.m3u8Page.indexOf("index_5_av.m3u8") != -1) {
                            urlHD = this.getUrlFromM3u8(url3u8, "index_5_av.m3u8");
                        }
                        if (this.m3u8Page.indexOf("index_4_av.m3u8") != -1) {
                            urlNormal = this.getUrlFromM3u8(url3u8, "index_4_av.m3u8");
                        } else if (this.m3u8Page.indexOf("index_3_av.m3u8") != -1) {
                            urlNormal = this.getUrlFromM3u8(url3u8, "index_3_av.m3u8");
                        }
                        if (this.m3u8Page.indexOf("index_2_av.m3u8") != -1) {
                            urlSmall = this.getUrlFromM3u8(url3u8, "index_2_av.m3u8");
                        } else if (this.m3u8Page.indexOf("index_1_av.m3u8") != -1) {
                            urlSmall = this.getUrlFromM3u8(url3u8, "index_1_av.m3u8");
                        }
                    } else {
                        if (this.m3u8Page.indexOf("index_0_av.m3u8") != -1) {
                            urlNormal = this.getUrlFromM3u8(url3u8, "index_0_av.m3u8");
                        }
                        if (this.m3u8Page.indexOf("index_3_av.m3u8") != -1) {
                            urlSmall = this.getUrlFromM3u8(url3u8, "index_3_av.m3u8");
                        } else if (this.m3u8Page.indexOf("index_2_av.m3u8") != -1) {
                            urlSmall = this.getUrlFromM3u8(url3u8, "index_2_av.m3u8");
                        }
                    }
                }
                if (urlNormal.isEmpty() && !urlSmall.isEmpty()) {
                    urlNormal = urlSmall;
                    urlSmall = "";
                }
                if (urlNormal.startsWith(MediathekSrf.HTTPS)) {
                    urlNormal = urlNormal.replaceFirst(MediathekSrf.HTTPS, MediathekSrf.HTTP);
                }
                if (urlSmall.startsWith(MediathekSrf.HTTPS)) {
                    urlSmall = urlSmall.replaceFirst(MediathekSrf.HTTPS, MediathekSrf.HTTP);
                }
                if (urlHD.startsWith(MediathekSrf.HTTPS)) {
                    urlHD = urlHD.replaceFirst(MediathekSrf.HTTPS, MediathekSrf.HTTP);
                }
                if (urlNormal.isEmpty()) {
                    Log.errorLog((int)962101451, (String)("Keine URL: " + jsonMovieUrl));
                } else {
                    urlHD = this.checkUrl(urlHD);
                    urlNormal = this.checkUrl(urlNormal);
                    urlSmall = this.checkUrl(urlSmall);
                    DatenFilm film = new DatenFilm(MediathekSrf.SENDERNAME, theme, urlThema, title, urlNormal, "", dateStr, time, duration, description);
                    if (!urlHD.isEmpty()) {
                        CrawlerTool.addUrlHd(film, urlHD, "");
                    }
                    if (!urlSmall.isEmpty()) {
                        CrawlerTool.addUrlKlein(film, urlSmall, "");
                    }
                    if (!subtitle.isEmpty()) {
                        CrawlerTool.addUrlSubtitle(film, subtitle);
                    }
                    MediathekSrf.this.addFilm(film);
                }
            }
            catch (Exception ex) {
                Log.errorLog((int)556320087, (Exception)ex);
            }
        }

        private void getM3u8(String url3u8) {
            String url3u8Temp;
            this.m3u8Page = this.getUrl.getUri_Utf(MediathekSrf.SENDERNAME, url3u8, this.m3u8Page, "");
            if (this.m3u8Page.length() == 0 && url3u8.startsWith(MediathekSrf.URL1_M3U8)) {
                url3u8Temp = url3u8.replaceFirst(MediathekSrf.URL1_M3U8, MediathekSrf.URL3_M3U8);
                this.m3u8Page = this.getUrl.getUri_Utf(MediathekSrf.SENDERNAME, url3u8Temp, this.m3u8Page, "");
            }
            if (this.m3u8Page.length() == 0 && url3u8.startsWith(MediathekSrf.URL2_M3U8)) {
                url3u8Temp = url3u8.replaceFirst(MediathekSrf.URL2_M3U8, MediathekSrf.URL3_M3U8);
                this.m3u8Page = this.getUrl.getUri_Utf(MediathekSrf.SENDERNAME, url3u8Temp, this.m3u8Page, "");
            }
        }

        private String checkUrl(String url) {
            String urlTemp = url.replaceFirst(MediathekSrf.URL1_M3U8, MediathekSrf.URL3_M3U8);
            return urlTemp.replaceFirst(MediathekSrf.URL2_M3U8, MediathekSrf.URL3_M3U8);
        }

        private String getUrl(MSStringBuilder filmPage, String s1, String s2) {
            String url = "";
            String m3u8 = "";
            this.urlList.clear();
            filmPage.extractList(s1, s2, "\"", this.urlList);
            for (String u : this.urlList) {
                if (!u.endsWith("m3u8") && !u.endsWith("mp4")) continue;
                if (u.endsWith("m3u8")) {
                    m3u8 = u;
                }
                if (!u.endsWith("mp4")) continue;
                url = u;
                break;
            }
            if (url.isEmpty()) {
                url = m3u8;
            }
            return url;
        }

        private String getUrlFromM3u8(String m3u8Url, String qualityIndex) {
            String csmil = "csmil/";
            return m3u8Url.substring(0, m3u8Url.indexOf("csmil/")) + "csmil/" + qualityIndex;
        }

        private long extractDuration(MSStringBuilder page) {
            long duration = 0L;
            String patternDuration = "\"duration\":";
            String d = page.extract("\"duration\":", ",").trim();
            try {
                if (!d.isEmpty()) {
                    duration = Long.parseLong(d);
                    duration /= 1000L;
                }
            }
            catch (NumberFormatException ex) {
                Log.errorLog((int)646490237, (Exception)ex);
            }
            return duration;
        }

        private Date extractDateAndTime(MSStringBuilder page) {
            String patternDateTime = "\"publishedDate\": \"";
            String patternEnd = "\"";
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
            String dateStr = page.extract("\"AssetMetadatas\"", "\"publishedDate\": \"", "\"");
            Date date = null;
            try {
                date = formatter.parse(dateStr);
            }
            catch (ParseException ex) {
                Log.errorLog((int)784512304, (Exception)ex, (String)("Date_STR " + dateStr));
            }
            return date;
        }
    }
}

