/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.arte;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import mServer.crawler.sender.arte.ArteCategoryFilmsDTO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArteCategoryFilmListDeserializer
implements JsonDeserializer<ArteCategoryFilmsDTO> {
    private static final String JSON_ELEMENT_META = "meta";
    private static final String JSON_ELEMENT_PAGES = "pages";
    private static final String JSON_ELEMENT_VIDEOS = "videos";
    private static final String JSON_ELEMENT_URL = "url";
    private static final Logger LOG = LogManager.getLogger(ArteCategoryFilmListDeserializer.class);

    public ArteCategoryFilmsDTO deserialize(JsonElement aJsonElement, Type aType, JsonDeserializationContext aContext) throws JsonParseException {
        ArteCategoryFilmsDTO dto = new ArteCategoryFilmsDTO();
        for (JsonElement jsonElement : aJsonElement.getAsJsonObject().get(JSON_ELEMENT_VIDEOS).getAsJsonArray()) {
            String url = jsonElement.getAsJsonObject().get(JSON_ELEMENT_URL).getAsString();
            String programId = ArteCategoryFilmListDeserializer.parseUrl(url);
            if (programId == null) continue;
            dto.addProgramId(programId);
        }
        dto.setPages(ArteCategoryFilmListDeserializer.getPages(aJsonElement.getAsJsonObject()));
        return dto;
    }

    private static int getPages(JsonObject aJsonObject) {
        JsonElement videos;
        int pages = 0;
        JsonElement meta = aJsonObject.get(JSON_ELEMENT_META);
        if (!meta.isJsonNull() && !(videos = meta.getAsJsonObject().get(JSON_ELEMENT_VIDEOS)).isJsonNull()) {
            pages = videos.getAsJsonObject().get(JSON_ELEMENT_PAGES).getAsInt();
        }
        return pages;
    }

    private static String parseUrl(String aUrl) {
        String[] urlParts = aUrl.split("/");
        if (urlParts.length >= 5) {
            return urlParts[urlParts.length - 2];
        }
        LOG.error("URL contains invalid parts: " + aUrl);
        return null;
    }
}

