/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.br;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.TimeUnit;
import mServer.crawler.CrawlerTool;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.sender.MediathekReader;
import mServer.crawler.sender.br.BrAllSendungenTask;
import mServer.crawler.sender.br.BrMissedSendungsFolgenTask;
import mServer.crawler.sender.br.BrSendungDetailsTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrCrawler
extends MediathekReader {
    public static final String SENDERNAME = "BR";
    public static final String BASE_URL = "https://www.br.de/mediathek/";
    private static final Logger LOG = LogManager.getLogger(BrCrawler.class);
    private final ForkJoinPool forkJoinPool = new ForkJoinPool(Runtime.getRuntime().availableProcessors() * 4);

    public BrCrawler(FilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 0, 100, startPrio);
    }

    @Override
    protected void addToList() {
        this.meldungStart();
        try {
            RecursiveTask<Set<DatenFilm>> filmTask = this.createCrawlerTask();
            Set<DatenFilm> films = this.forkJoinPool.invoke(filmTask);
            LOG.info("BR Filme einsortieren...");
            films.forEach(film -> {
                if (!Config.getStop()) {
                    this.addFilm((DatenFilm)film);
                }
            });
            LOG.info("BR Film einsortieren fertig");
        }
        finally {
            this.shutdownAndAwaitTermination(this.forkJoinPool, 60L, TimeUnit.SECONDS);
        }
        LOG.info("BR fertig");
        this.meldungThreadUndFertig();
    }

    void shutdownAndAwaitTermination(ExecutorService pool, long delay, TimeUnit delayUnit) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(delay, delayUnit)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(delay, delayUnit)) {
                    LOG.info("Pool nicht beendet");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private RecursiveTask<Set<String>> createAllSendungenOverviewCrawler() {
        return new BrAllSendungenTask(this, this.forkJoinPool);
    }

    private Callable<Set<String>> createMissedFilmsCrawler() {
        int maximumDays = CrawlerTool.loadLongMax() ? 21 : 7;
        return new BrMissedSendungsFolgenTask(this, maximumDays);
    }

    protected RecursiveTask<Set<DatenFilm>> createCrawlerTask() {
        Callable<Set<String>> missedFilmsTask = this.createMissedFilmsCrawler();
        RecursiveTask<Set<String>> sendungenFilmsTask = this.createAllSendungenOverviewCrawler();
        Future missedFilmIds = this.forkJoinPool.submit(missedFilmsTask);
        this.forkJoinPool.execute(sendungenFilmsTask);
        ConcurrentLinkedQueue<String> brFilmIds = new ConcurrentLinkedQueue<String>();
        try {
            brFilmIds.addAll((Collection)missedFilmIds.get());
            LOG.debug("BR Anzahl verpasste Sendungen: " + ((Set)missedFilmIds.get()).size());
        }
        catch (InterruptedException | ExecutionException exception) {
            LOG.fatal("Something wen't terrible wrong on gathering the missed Films", (Throwable)exception);
        }
        brFilmIds.addAll((Collection)sendungenFilmsTask.join());
        LOG.debug("BR Anzahl: " + ((Set)sendungenFilmsTask.join()).size());
        int max = brFilmIds.size() / 50 + 1;
        this.meldungAddMax(max);
        return new BrSendungDetailsTask(this, brFilmIds);
    }
}

