/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.newsearch;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.mediathekview.mlib.tool.Log;
import java.lang.reflect.Type;
import java.util.Iterator;
import mServer.crawler.sender.newsearch.DownloadDTO;
import mServer.crawler.sender.newsearch.GeoLocations;
import mServer.crawler.sender.newsearch.Qualities;

public class ZDFDownloadDTODeserializer
implements JsonDeserializer<DownloadDTO> {
    private static final String JSON_ELEMENT_ATTRIBUTES = "attributes";
    private static final String JSON_ELEMENT_AUDIO = "audio";
    private static final String JSON_ELEMENT_CAPTIONS = "captions";
    private static final String JSON_ELEMENT_FORMITAET = "formitaeten";
    private static final String JSON_ELEMENT_GEOLOCATION = "geoLocation";
    private static final String JSON_ELEMENT_HD = "hd";
    private static final String JSON_ELEMENT_MIMETYPE = "mimeType";
    private static final String JSON_ELEMENT_PRIORITYLIST = "priorityList";
    private static final String JSON_ELEMENT_QUALITIES = "qualities";
    private static final String JSON_ELEMENT_QUALITY = "quality";
    private static final String JSON_ELEMENT_TRACKS = "tracks";
    private static final String JSON_ELEMENT_URI = "uri";
    private static final String JSON_PROPERTY_VALUE = "value";
    private static final String GEO_LOCATION_DACH = "dach";
    private static final String GEO_LOCATION_DE = "de";
    private static final String GEO_LOCATION_EBU = "ebu";
    private static final String RELEVANT_MIME_TYPE = "video/mp4";
    private static final String RELEVANT_SUBTITLE_TYPE = ".xml";

    public DownloadDTO deserialize(JsonElement aJsonElement, Type aTypeOfT, JsonDeserializationContext aJsonDeserializationContext) throws JsonParseException {
        try {
            DownloadDTO dto = new DownloadDTO();
            JsonObject rootNode = aJsonElement.getAsJsonObject();
            this.parseVideoUrls(dto, rootNode);
            this.parseSubtitle(dto, rootNode);
            this.parseGeoLocation(dto, rootNode);
            return dto;
        }
        catch (Exception ex) {
            Log.errorLog((int)496583257, (Exception)ex);
            return null;
        }
    }

    private void parseGeoLocation(DownloadDTO dto, JsonObject rootNode) {
        JsonElement geoValue;
        JsonElement geoLocation;
        JsonElement attributes = rootNode.get(JSON_ELEMENT_ATTRIBUTES);
        if (attributes != null && (geoLocation = attributes.getAsJsonObject().get(JSON_ELEMENT_GEOLOCATION)) != null && (geoValue = geoLocation.getAsJsonObject().get(JSON_PROPERTY_VALUE)) != null) {
            switch (geoValue.getAsString()) {
                case "dach": {
                    dto.setGeoLocation(GeoLocations.GEO_DE_AT_CH);
                    break;
                }
                case "de": {
                    dto.setGeoLocation(GeoLocations.GEO_DE);
                    break;
                }
                case "ebu": {
                    dto.setGeoLocation(GeoLocations.GEO_DE_AT_CH_EU);
                }
            }
        }
    }

    private void parseVideoUrls(DownloadDTO dto, JsonObject rootNode) {
        JsonArray priorityList = rootNode.getAsJsonArray(JSON_ELEMENT_PRIORITYLIST);
        Iterator priorityIterator = priorityList.iterator();
        while (priorityIterator.hasNext()) {
            JsonObject priority = ((JsonElement)priorityIterator.next()).getAsJsonObject();
            if (priority == null) continue;
            JsonArray formitaetList = priority.getAsJsonArray(JSON_ELEMENT_FORMITAET);
            Iterator formitaetIterator = formitaetList.iterator();
            while (formitaetIterator.hasNext()) {
                JsonObject formitaet = ((JsonElement)formitaetIterator.next()).getAsJsonObject();
                JsonElement mimeType = formitaet.get(JSON_ELEMENT_MIMETYPE);
                if (mimeType == null || !mimeType.getAsString().equalsIgnoreCase(RELEVANT_MIME_TYPE)) continue;
                JsonArray qualityList = formitaet.getAsJsonArray(JSON_ELEMENT_QUALITIES);
                Iterator qualityIterator = qualityList.iterator();
                while (qualityIterator.hasNext()) {
                    String uri = null;
                    JsonObject quality = ((JsonElement)qualityIterator.next()).getAsJsonObject();
                    Qualities qualityValue = this.parseVideoQuality(quality);
                    JsonElement audio = quality.get(JSON_ELEMENT_AUDIO);
                    if (audio != null) {
                        JsonArray tracks = audio.getAsJsonObject().getAsJsonArray(JSON_ELEMENT_TRACKS);
                        if (tracks.size() != 1) {
                            throw new RuntimeException("tracks size not 1, that's not implemented so far");
                        }
                        JsonObject track = tracks.get(0).getAsJsonObject();
                        uri = track.get(JSON_ELEMENT_URI).getAsString();
                    }
                    if (qualityValue != null && uri != null) {
                        dto.addUrl(qualityValue, uri);
                        continue;
                    }
                    throw new RuntimeException("either quality or uri is null");
                }
            }
        }
    }

    private Qualities parseVideoQuality(JsonObject quality) {
        Qualities qualityValue = null;
        JsonElement hd = quality.get(JSON_ELEMENT_HD);
        if (hd != null && hd.getAsBoolean()) {
            qualityValue = Qualities.HD;
        } else {
            String zdfQuality;
            switch (zdfQuality = quality.get(JSON_ELEMENT_QUALITY).getAsString()) {
                case "low": {
                    qualityValue = Qualities.SMALL;
                    break;
                }
                case "med": {
                    qualityValue = Qualities.SMALL;
                    break;
                }
                case "high": {
                    qualityValue = Qualities.SMALL;
                    break;
                }
                case "veryhigh": {
                    qualityValue = Qualities.NORMAL;
                    break;
                }
                default: {
                    throw new RuntimeException("quality not supported: " + zdfQuality);
                }
            }
        }
        return qualityValue;
    }

    private void parseSubtitle(DownloadDTO dto, JsonObject rootNode) {
        JsonArray captionList = rootNode.getAsJsonArray(JSON_ELEMENT_CAPTIONS);
        Iterator captionIterator = captionList.iterator();
        while (captionIterator.hasNext()) {
            JsonObject caption = ((JsonElement)captionIterator.next()).getAsJsonObject();
            JsonElement uri = caption.get(JSON_ELEMENT_URI);
            if (uri == null) continue;
            String uriValue = uri.getAsString();
            if (uriValue.endsWith(RELEVANT_SUBTITLE_TYPE)) {
                dto.setSubTitleUrl(uriValue);
                break;
            }
            if (!dto.getSubTitleUrl().isEmpty()) continue;
            dto.setSubTitleUrl(uriValue);
        }
    }
}

