/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.tool.Log;
import de.mediathekview.mlib.tool.MSStringBuilder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mServer.crawler.CrawlerTool;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.GetUrl;
import mServer.crawler.sender.MediathekReader;
import mServer.crawler.sender.ard.ArdVideoDTO;
import mServer.crawler.sender.ard.ArdVideoDeserializer;
import mServer.crawler.sender.newsearch.Qualities;
import mServer.tool.M3U8Utils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MediathekArd
extends MediathekReader {
    private static final Logger LOG = LogManager.getLogger(MediathekArd.class);
    private static final String SENDERNAME = "ARD";
    private static final String THEMA_TAGE = "TAGE";
    private static final String ADRESSE_THEMA = "http://www.ardmediathek.de/tv";
    private static final String MUSTER_URL_THEMA = "<a href=\"/tv/sendungen-a-z?buchstabe=";
    private static final String MUSTER_FEED_SUCHEN = "<div class=\"media mediaA\">";
    private static final String M3U8_PATTERN_START = "_quality\":\"auto\",\"_server\":\"\",\"_cdn\":\"flashls\",\"_stream\":\"";
    private static final String M3U8_PATTERN_END = "\"";
    private static final String TEXT_START_HTTP = "http";
    private static final String URL_GET_PARAMETER = "\\?.*";
    private static final String URL_PART_NORMAL = "960";
    private static final String URL_PART_HD = "1280";
    private MSStringBuilder seiteFeed = new MSStringBuilder(65536);

    public MediathekArd(FilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 8, 50, startPrio);
    }

    private void addThema() {
        this.listeThemen.clear();
        MSStringBuilder seite = new MSStringBuilder(65536);
        this.meldungStart();
        GetUrl getUrlIo = new GetUrl(this.getWartenSeiteLaden());
        seite = getUrlIo.getUri(SENDERNAME, ADRESSE_THEMA, StandardCharsets.UTF_8, 5, seite, "");
        if (seite.length() == 0) {
            Log.sysLog((String)"ARD: Versuch 2");
            this.warten(120L);
            seite = getUrlIo.getUri(SENDERNAME, ADRESSE_THEMA, StandardCharsets.UTF_8, 5, seite, "");
            if (seite.length() == 0) {
                Log.errorLog((int)104689736, (String)"wieder nichts gefunden");
            }
        }
        int pos = 0;
        String url = "";
        while (!Config.getStop() && (pos = seite.indexOf(MUSTER_URL_THEMA, pos)) != -1) {
            try {
                int pos1 = pos += MUSTER_URL_THEMA.length();
                int pos2 = seite.indexOf(M3U8_PATTERN_END, pos);
                if (pos1 != -1 && pos2 != -1) {
                    url = seite.substring(pos1, pos2);
                }
                if (url.isEmpty()) continue;
                url = "http://www.ardmediathek.de/tv/sendungen-a-z?buchstabe=" + url;
                this.feedSuchen1(url);
            }
            catch (Exception ex) {
                Log.errorLog((int)698732167, (Exception)ex, (String)"kein Thema");
            }
        }
    }

    private void feedSuchen1(String strUrlFeed) {
        GetUrl getUrlIo = new GetUrl(this.getWartenSeiteLaden());
        this.seiteFeed = getUrlIo.getUri(SENDERNAME, strUrlFeed, StandardCharsets.UTF_8, 2, this.seiteFeed, "");
        if (this.seiteFeed.length() == 0) {
            Log.errorLog((int)207956317, (String)("Leere Seite: " + strUrlFeed));
            return;
        }
        int pos = this.seiteFeed.indexOf(MUSTER_FEED_SUCHEN);
        pos += MUSTER_FEED_SUCHEN.length();
        while (!Config.getStop() && (pos = this.seiteFeed.indexOf(MUSTER_FEED_SUCHEN, pos)) != -1) {
            try {
                String url = this.seiteFeed.extract("<a href=\"/tv/", M3U8_PATTERN_END, pos += MUSTER_FEED_SUCHEN.length());
                if (url.isEmpty()) continue;
                url = "http://www.ardmediathek.de/tv/" + url;
                String thema = this.seiteFeed.extract("<h4 class=\"headline\">", "<", pos);
                if (thema.isEmpty()) {
                    thema = this.seiteFeed.extract("title=\"", M3U8_PATTERN_END, pos);
                    Log.errorLog((int)132326564, (String)("Thema: " + strUrlFeed));
                }
                String[] add = new String[]{url, thema};
                this.listeThemen.addUrl(add);
            }
            catch (Exception ex) {
                Log.errorLog((int)732154698, (Exception)ex, (String)"Weitere Seiten suchen");
            }
        }
    }

    private Map<Qualities, String> searchForUrlsWithM3U8(MSStringBuilder aSeiteStringExtractor) {
        EnumMap<Qualities, String> urls = new EnumMap<Qualities, String>(Qualities.class);
        ArrayList patternMatches = new ArrayList();
        aSeiteStringExtractor.extractList(M3U8_PATTERN_START, M3U8_PATTERN_END, patternMatches);
        String m3u8Url = null;
        for (String patternMatch : patternMatches) {
            if (!patternMatch.startsWith(TEXT_START_HTTP)) continue;
            m3u8Url = patternMatch;
            break;
        }
        if (m3u8Url != null) {
            if ((m3u8Url = m3u8Url.replaceAll(URL_GET_PARAMETER, "")).contains("adaptiv.wdr.de/i/medp/")) {
                urls.putAll(M3U8Utils.gatherUrlsFromWdrM3U8(m3u8Url));
            } else {
                urls.put(Qualities.NORMAL, m3u8Url);
            }
        }
        return urls;
    }

    private void warten(long i) {
        try {
            Thread.sleep(i * 1000L);
        }
        catch (Exception ex) {
            Log.errorLog((int)369502367, (Exception)ex, (String)"2. Versuch");
        }
    }

    @Override
    protected void addToList() {
        this.listeThemen.clear();
        this.addThema();
        this.listeThemen.addUrl(new String[]{THEMA_TAGE, ""});
        if (Config.getStop() || this.listeThemen.isEmpty()) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size());
            MediathekArd.listeSort(this.listeThemen, 1);
            for (int t = 0; t < this.getMaxThreadLaufen(); ++t) {
                ThemaLaden th = new ThemaLaden();
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    private class ThemaLaden
    extends Thread {
        private static final String DAUER_REGEX_PATERN = "\\d+";
        private static final String THEMA_ALPHA_CENTAURI = "alpha-Centauri";
        private static final String MUSTER_ADD_TAGE = "<span class=\"date\">";
        private static final String MUSTER_FILM_SUCHEN1 = "<div class=\"mediaCon\">";
        private static final String MUSTER_START_FILM_SUCHEN1 = "Beitr\u00e4ge der Sendung";
        private final ArrayList<String> liste = new ArrayList();
        private MSStringBuilder seite1 = new MSStringBuilder(65536);
        private MSStringBuilder seite2 = new MSStringBuilder(65536);
        private MSStringBuilder seite3 = new MSStringBuilder(65536);

        private ThemaLaden() {
        }

        @Override
        public void run() {
            try {
                String[] link;
                MediathekArd.this.meldungAddThread();
                while (!Config.getStop() && (link = MediathekArd.this.listeThemen.getListeThemen()) != null) {
                    MediathekArd.this.meldungProgress(link[0]);
                    if (link[0].equals(MediathekArd.THEMA_TAGE)) {
                        this.addTage();
                        continue;
                    }
                    this.filmSuchen1(link[0], link[1], true);
                }
            }
            catch (Exception ex) {
                Log.errorLog((int)487326921, (Exception)ex);
            }
            MediathekArd.this.meldungThreadUndFertig();
        }

        private void addTage() {
            for (int i = 0; i <= 6 && !Config.getStop(); ++i) {
                String urlTage = "http://www.ardmediathek.de/tv/sendungVerpasst?tag=" + i;
                GetUrl getUrl = new GetUrl(MediathekArd.this.getWartenSeiteLaden());
                this.seite1 = getUrl.getUri(MediathekArd.SENDERNAME, urlTage, StandardCharsets.UTF_8, 2, this.seite1, "");
                if (this.seite1.length() == 0) {
                    Log.errorLog((int)765323214, (String)("Leere Seite: " + urlTage));
                    return;
                }
                int pos = 0;
                String zeit = "";
                long d = 0L;
                while (!Config.getStop() && (pos = this.seite1.indexOf(MUSTER_ADD_TAGE, pos)) != -1) {
                    String urlSendung;
                    zeit = this.seite1.extract(MUSTER_ADD_TAGE, "<", pos) + ":00";
                    String url = this.seite1.extract("documentId=", "&", pos += MUSTER_ADD_TAGE.length());
                    if (url.contains(MediathekArd.M3U8_PATTERN_END)) {
                        url = url.substring(0, url.indexOf(34));
                    }
                    if (url.isEmpty()) continue;
                    url = url.replace("&amp;", "&");
                    String thema = this.seite1.extract("<span class=\"titel\">", "<", pos);
                    if (thema.endsWith("Uhr") && thema.contains(",")) {
                        thema = thema.substring(0, thema.indexOf(44));
                    }
                    String datum = this.seite1.extract("<title>Videos (TV-Sendungen) des Senders Das Erste vom", "- ARD").trim();
                    String titel = this.seite1.extract("<h4 class=\"headline\">", "<", pos);
                    String dauer = this.seite1.extract("<p class=\"subtitle\">", "<", pos);
                    try {
                        Matcher dauerMatcher = Pattern.compile(DAUER_REGEX_PATERN).matcher(dauer);
                        if (dauerMatcher.find()) {
                            d = Long.parseLong(dauerMatcher.group()) * 60L;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (d == 0L) {
                        Log.errorLog((int)915263621, (String)("Dauer==0: " + urlTage));
                    }
                    if (!(urlSendung = this.seite1.extract("<a href=\"/tv/", MediathekArd.M3U8_PATTERN_END, pos)).isEmpty()) {
                        urlSendung = "http://www.ardmediathek.de/tv/" + urlSendung;
                        urlSendung = urlSendung.replace("&amp;", "&");
                    }
                    this.filmSuchen2(url, thema, titel, d, datum, zeit, urlSendung);
                }
            }
        }

        private String beschreibung(String strUrlFeed) {
            GetUrl getUrl = new GetUrl(MediathekArd.this.getWartenSeiteLaden());
            this.seite3 = getUrl.getUri(MediathekArd.SENDERNAME, strUrlFeed, StandardCharsets.UTF_8, 1, this.seite3, "");
            if (this.seite3.length() == 0) {
                Log.errorLog((int)784512036, (String)("Leere Seite: " + strUrlFeed));
                return "";
            }
            return this.seite3.extract("<p class=\"subtitle\">", "<p class=\"teasertext\" itemprop=\"description\">", "<");
        }

        private Set<String> buildPossibleHdUrls(String path, String fileName) {
            String hdFileName1 = fileName.replace(MediathekArd.URL_PART_NORMAL, MediathekArd.URL_PART_HD);
            String hdFileName2 = hdFileName1.endsWith("_1.mp4") ? hdFileName1.replace("_1", "") : hdFileName1.replace(".mp4", "_1.mp4");
            HashSet<String> urls = new HashSet<String>();
            urls.add(path + hdFileName1);
            urls.add(path + hdFileName2);
            return urls;
        }

        private String determineHdFromNormal(String urlNormal) {
            String urlHd = "";
            int indexLastSlash = urlNormal.lastIndexOf(47);
            if (indexLastSlash > 0) {
                String fileName = urlNormal.substring(indexLastSlash + 1);
                String path = urlNormal.substring(0, indexLastSlash + 1);
                if (fileName.startsWith(MediathekArd.URL_PART_NORMAL)) {
                    Set<String> urls = this.buildPossibleHdUrls(path, fileName);
                    for (String url : urls) {
                        if (!MediathekReader.urlExists(url)) continue;
                        urlHd = url;
                        break;
                    }
                }
            }
            return urlHd;
        }

        private void filmSuchen_old(String urlSendung, String thema, String titel, long dauer, String datum, String zeit) {
            try {
                MediathekArd.this.meldung(urlSendung);
                GetUrl getUrl = new GetUrl(MediathekArd.this.getWartenSeiteLaden());
                this.seite2 = getUrl.getUri(MediathekArd.SENDERNAME, urlSendung, StandardCharsets.UTF_8, 1, this.seite2, "");
                if (this.seite2.length() == 0) {
                    Log.errorLog((int)612031478, (String)("Leere Seite: " + urlSendung));
                    return;
                }
                String url = this.seite2.extract("</li><li data-ctrl-", "http://", ".m3u8");
                if (!url.isEmpty()) {
                    url = "http://" + url + ".m3u8";
                }
                if (!url.isEmpty()) {
                    String beschreibung = this.beschreibung(urlSendung);
                    DatenFilm f = new DatenFilm(MediathekArd.SENDERNAME, thema, urlSendung, titel, url, "", datum, zeit, dauer, beschreibung);
                    MediathekArd.this.addFilm(f);
                } else {
                    Log.errorLog((int)974125698, (String)("keine URL: " + urlSendung));
                }
            }
            catch (Exception ex) {
                Log.errorLog((int)102054784, (Exception)ex);
            }
        }

        private void filmSuchen1(String strUrlFeed, String thema, boolean weiter) {
            GetUrl getUrl = new GetUrl(MediathekArd.this.getWartenSeiteLaden());
            this.seite1 = getUrl.getUri(MediathekArd.SENDERNAME, strUrlFeed, StandardCharsets.UTF_8, 2, this.seite1, "");
            if (this.seite1.length() == 0) {
                Log.errorLog((int)765323214, (String)("Leere Seite: " + strUrlFeed));
                return;
            }
            String zeit = "";
            long d = 0L;
            int count = 0;
            int pos = this.seite1.indexOf(MUSTER_START_FILM_SUCHEN1);
            if (pos != -1) {
                pos += MUSTER_START_FILM_SUCHEN1.length();
            } else {
                return;
            }
            while (!Config.getStop() && (pos = this.seite1.indexOf(MUSTER_FILM_SUCHEN1, pos)) != -1 && (CrawlerTool.loadLongMax() || ++count <= 5 || thema.equalsIgnoreCase(THEMA_ALPHA_CENTAURI))) {
                String urlSendung;
                String url = this.seite1.extract("documentId=", "&", pos += MUSTER_FILM_SUCHEN1.length());
                if (url.contains(MediathekArd.M3U8_PATTERN_END)) {
                    url = url.substring(0, url.indexOf(34));
                }
                if (url.equals("")) continue;
                url = url.replace("&amp;", "&");
                String datum = this.seite1.extract("<p class=\"dachzeile\">", "<", pos);
                if ((datum = datum.replace("Uhr", "").trim()).contains("|")) {
                    zeit = datum.substring(datum.indexOf("|") + 1).trim();
                    zeit = zeit + ":00";
                    datum = datum.substring(0, datum.indexOf("|")).trim();
                }
                String titel = this.seite1.extract("<h4 class=\"headline\">", "<", pos);
                String dauer = this.seite1.extract("<p class=\"subtitle\">", "<", pos);
                try {
                    Matcher dauerMatcher = Pattern.compile(DAUER_REGEX_PATERN).matcher(dauer);
                    if (dauerMatcher.find()) {
                        d = Long.parseLong(dauerMatcher.group()) * 60L;
                    }
                }
                catch (Exception ex) {
                    LOG.debug("Die dauer konnte nicht als long geparsed werden.", (Throwable)ex);
                }
                if (d == 0L) {
                    Log.errorLog((int)915263621, (String)("Dauer==0: " + strUrlFeed));
                }
                if (!(urlSendung = this.seite1.extract("<a href=\"/tv/", MediathekArd.M3U8_PATTERN_END, pos)).isEmpty()) {
                    urlSendung = "http://www.ardmediathek.de/tv/" + urlSendung;
                    urlSendung = urlSendung.replace("&amp;", "&");
                }
                this.filmSuchen2(url, thema, titel, d, datum, zeit, urlSendung);
            }
            if (!Config.getStop() && weiter && (CrawlerTool.loadLongMax() || thema.equalsIgnoreCase(THEMA_ALPHA_CENTAURI))) {
                int maxWeiter = 0;
                int maxTh = 10;
                String urlWeiter = strUrlFeed + "&mcontents=page.";
                int i = 2;
                while (i < 10 && this.seite1.indexOf("&amp;mcontents=page." + i) != -1) {
                    maxWeiter = i++;
                }
                for (i = 2; i < 10 && !Config.getStop() && i <= maxWeiter; ++i) {
                    this.filmSuchen1(urlWeiter + i, thema, false);
                }
            }
        }

        private void filmSuchen2(String urlFilm_, String thema, String titel, long dauer, String datum, String zeit, String urlSendung) {
            try {
                String subtitle;
                String urlFilm = "http://www.ardmediathek.de/play/media/" + urlFilm_ + "?devicetype=pc&features=flash";
                MediathekArd.this.meldung(urlFilm);
                GetUrl getUrl = new GetUrl(MediathekArd.this.getWartenSeiteLaden());
                this.seite2 = getUrl.getUri(MediathekArd.SENDERNAME, urlFilm, StandardCharsets.UTF_8, 2, this.seite2, "");
                if (this.seite2.length() == 0) {
                    Log.errorLog((int)915263621, (String)("Leere Seite: " + urlFilm));
                    return;
                }
                String jsonString = this.seite2.substring(0);
                if (jsonString.contains("Leider liegt eine St\u00f6rung vor.")) {
                    Log.errorLog((int)915263622, (String)("Seite wegen St\u00f6rung nicht geladen: " + urlFilm));
                    return;
                }
                String url = "";
                String urlMid = "";
                String urlKl = "";
                String urlHD = "";
                this.liste.clear();
                Gson gson = new GsonBuilder().registerTypeAdapter(ArdVideoDTO.class, (Object)new ArdVideoDeserializer()).create();
                ArdVideoDTO dto = (ArdVideoDTO)gson.fromJson(jsonString, ArdVideoDTO.class);
                if (dto.getUrl(Qualities.SMALL) != null) {
                    urlKl = dto.getUrl(Qualities.SMALL);
                }
                if (dto.getUrl(Qualities.NORMAL) != null) {
                    url = dto.getUrl(Qualities.NORMAL);
                }
                if (dto.getUrl(Qualities.HD) != null) {
                    urlHD = dto.getUrl(Qualities.HD);
                } else if (!url.isEmpty()) {
                    urlHD = this.determineHdFromNormal(url);
                }
                if (url.isEmpty()) {
                    url = this.getUrl(this.seite2);
                }
                if (this.isAllTextsEmpty(url, urlHD, urlMid, urlKl)) {
                    Map urls = MediathekArd.this.searchForUrlsWithM3U8(this.seite2);
                    if (urls.containsKey((Object)Qualities.SMALL)) {
                        urlKl = (String)urls.get((Object)Qualities.SMALL);
                    }
                    if (urls.containsKey((Object)Qualities.NORMAL)) {
                        urlMid = (String)urls.get((Object)Qualities.NORMAL);
                    }
                    if (urls.containsKey((Object)Qualities.HD)) {
                        urlHD = (String)urls.get((Object)Qualities.HD);
                    }
                }
                if (url.isEmpty()) {
                    url = urlMid;
                    urlMid = "";
                }
                if (url.isEmpty()) {
                    url = urlKl;
                    urlKl = "";
                }
                if (url.isEmpty() && !urlHD.isEmpty()) {
                    url = urlHD;
                    urlHD = "";
                }
                if (urlKl.isEmpty()) {
                    urlKl = urlMid;
                }
                if (!(subtitle = this.seite2.extract("subtitleUrl\":\"", MediathekArd.M3U8_PATTERN_END)).isEmpty() && !subtitle.startsWith("http://www.ardmediathek.de")) {
                    subtitle = "http://www.ardmediathek.de" + subtitle;
                }
                if (!url.isEmpty()) {
                    if (url.contains("?url=")) {
                        url = url.substring(0, url.indexOf("?url="));
                    }
                    if (urlKl.contains("?url=")) {
                        urlKl = urlKl.substring(0, urlKl.indexOf("?url="));
                    }
                    if (urlHD.contains("?url=")) {
                        urlHD = urlHD.substring(0, urlHD.indexOf("?url="));
                    }
                    String beschreibung = this.beschreibung(urlSendung);
                    DatenFilm f = new DatenFilm(MediathekArd.SENDERNAME, thema, urlSendung, titel, url, "", datum, zeit, dauer, beschreibung);
                    if (!urlKl.isEmpty()) {
                        CrawlerTool.addUrlKlein(f, urlKl, "");
                    }
                    if (!urlHD.isEmpty() && !urlHD.equals(url)) {
                        CrawlerTool.addUrlHd(f, urlHD, "");
                    }
                    if (!subtitle.isEmpty()) {
                        CrawlerTool.addUrlSubtitle(f, subtitle);
                    }
                    MediathekArd.this.addFilm(f);
                } else {
                    this.filmSuchen_old(urlSendung, thema, titel, dauer, datum, zeit);
                }
            }
            catch (Exception ex) {
                Log.errorLog((int)762139874, (Exception)ex);
            }
        }

        private String getUrl(MSStringBuilder seite) {
            String ret = "";
            seite.extractList("\"_quality\":2,\"_stream\":[", "]", this.liste);
            for (String s : this.liste) {
                if ((s = s.replace(MediathekArd.M3U8_PATTERN_END, "")).contains(",")) {
                    String[] ar;
                    for (String ss : ar = s.split(",")) {
                        if (!ss.startsWith(MediathekArd.TEXT_START_HTTP)) continue;
                        ret = ss;
                    }
                }
                if (ret.isEmpty()) continue;
                break;
            }
            this.liste.clear();
            return ret;
        }

        private boolean isAllTextsEmpty(String ... aTexts) {
            Boolean isAllTextsEmpty = null;
            for (String text : aTexts) {
                isAllTextsEmpty = (isAllTextsEmpty == null || isAllTextsEmpty != false) && StringUtils.isEmpty((CharSequence)text);
            }
            return isAllTextsEmpty == null || isAllTextsEmpty != false;
        }
    }
}

