/*
 * Decompiled with CFR 0.152.
 */
package mServer.upload;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import mServer.daten.MserverDatenUpload;
import mServer.tool.MserverLog;

public class MserverCopy {
    public static boolean copy(String srcPathFile, String destFileName, MserverDatenUpload datenUpload) {
        boolean ret = false;
        try {
            MserverLog.systemMeldung("");
            MserverLog.systemMeldung("UploadCopy");
            new File(datenUpload.getDestDir()).mkdirs();
            String dest = datenUpload.getFilmlisteDestPfadName(destFileName);
            MserverCopy.copy(srcPathFile, dest);
            ret = true;
        }
        catch (Exception ex) {
            MserverLog.fehlerMeldung(747452360, MserverCopy.class.getName(), "copy", ex);
        }
        return ret;
    }

    public static void copy(String srcPathFile, String destPathFile) {
        MserverLog.systemMeldung("");
        MserverLog.systemMeldung("----------------------");
        MserverLog.systemMeldung("Copy start");
        MserverLog.systemMeldung("src: " + srcPathFile);
        MserverLog.systemMeldung("dest: " + destPathFile);
        try {
            String dest_tmp = destPathFile + "__";
            String dest_old = destPathFile + "_old";
            MserverLog.systemMeldung("Copy Filmliste (rename): " + destPathFile);
            Files.copy(Paths.get(srcPathFile, new String[0]), Paths.get(dest_tmp, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            if (Files.exists(Paths.get(destPathFile, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
                MserverLog.systemMeldung("Rename alte Filmliste: " + dest_tmp);
                Files.move(Paths.get(destPathFile, new String[0]), Paths.get(dest_old, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            MserverLog.systemMeldung("Rename neue Filmliste: " + destPathFile);
            Files.move(Paths.get(dest_tmp, new String[0]), Paths.get(destPathFile, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            MserverLog.systemMeldung("====================================");
        }
        catch (Exception ex) {
            MserverLog.fehlerMeldung(832164870, MserverCopy.class.getName(), "MvSCopy.copy", ex);
        }
    }
}

