/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.tool.Log;
import de.mediathekview.mlib.tool.MSStringBuilder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import mServer.crawler.CrawlerTool;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.GetUrl;
import mServer.crawler.sender.MediathekReader;
import mServer.tool.MserverDaten;
import org.apache.commons.lang3.StringEscapeUtils;

public class MediathekBr
extends MediathekReader {
    public static final String SENDERNAME = "BR";
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy, HH:mm", Locale.ENGLISH);
    private final SimpleDateFormat sdfOutTime = new SimpleDateFormat("HH:mm:ss");
    private final SimpleDateFormat sdfOutDay = new SimpleDateFormat("dd.MM.yyyy");
    private final MediathekReader.LinkedListUrl listeTage = new MediathekReader.LinkedListUrl();
    private static final String PATTERN_VERY_SMALL = "<asset type=\"STANDARD\">";
    private static final String PATTERN_SMALL = "<asset type=\"LARGE\">";
    private static final String PATTERN_NORMAL = "<asset type=\"PREMIUM\">";
    private static final String PATTERN_HD = "<asset type=\"HD\">";
    private static final String PATTERN_DLURL = "<downloadUrl>";
    private static final String PATTERN_END = "<";
    private final LinkedList<String> listeAlleThemen = new LinkedList();
    private final LinkedList<String> listeAlleThemenCount = new LinkedList();
    private final LinkedList<String> listeAlleThemenCount_ = new LinkedList();

    public MediathekBr(FilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 4, 100, startPrio);
    }

    private void startArchiveThreads() {
        ArchivLaden thArchiv;
        if (CrawlerTool.loadLongMax()) {
            thArchiv = new ArchivLaden(1, 50);
            thArchiv.start();
            thArchiv = new ArchivLaden(51, 100);
            thArchiv.start();
            thArchiv = new ArchivLaden(101, 150);
            thArchiv.start();
            thArchiv = new ArchivLaden(151, 200);
            thArchiv.start();
        }
        if (CrawlerTool.loadMax()) {
            thArchiv = new ArchivLaden(201, 250);
            thArchiv.start();
            thArchiv = new ArchivLaden(251, 300);
            thArchiv.start();
            thArchiv = new ArchivLaden(301, 350);
            thArchiv.start();
            thArchiv = new ArchivLaden(351, 400);
            thArchiv.start();
        }
    }

    private void startKlassikThread() {
        KlassikLaden thKlassik = new KlassikLaden();
        thKlassik.setName("BR-Klassik");
        thKlassik.start();
    }

    private void startCrawlerThreads() {
        for (int t = 0; t <= this.getMaxThreadLaufen(); ++t) {
            ThemaLaden th = new ThemaLaden();
            th.setName(SENDERNAME + t);
            th.start();
        }
    }

    @Override
    protected void addToList() {
        this.mlibFilmeSuchen.listeFilmeAlt.getThema(this.getSendername(), this.listeAlleThemenCount_);
        this.meldungStart();
        this.getTheman();
        this.getTage();
        if (Config.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.isEmpty() && this.listeTage.isEmpty()) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size() + this.listeTage.size());
            this.startArchiveThreads();
            this.startKlassikThread();
            this.startCrawlerThreads();
        }
    }

    private void getTheman() {
        String ADRESSE = "http://www.br.de/mediathek/video/sendungen/index.html";
        String MUSTER_URL = "<a href=\"/mediathek/video/";
        String MUSTER_URL_1 = "sendungen/";
        String MUSTER_URL_2 = "video/";
        this.listeThemen.clear();
        MSStringBuilder seite = new MSStringBuilder(65536);
        GetUrl getUrlIo = new GetUrl(this.getWartenSeiteLaden());
        seite = getUrlIo.getUri(SENDERNAME, "http://www.br.de/mediathek/video/sendungen/index.html", StandardCharsets.UTF_8, 5, seite, "");
        String url = "";
        int pos1 = seite.indexOf("<ul class=\"clearFix\">");
        if (pos1 != -1) {
            while ((pos1 = seite.indexOf("<a href=\"/mediathek/video/", pos1)) != -1 && !Config.getStop()) {
                try {
                    int pos2 = seite.indexOf("\"", pos1 += "<a href=\"/mediathek/video/".length());
                    if (pos2 != -1) {
                        url = seite.substring(pos1, pos2);
                    }
                    String thema = seite.extract("<span>", PATTERN_END, pos1);
                    thema = StringEscapeUtils.unescapeXml((String)thema.trim());
                    if (!this.listeAlleThemen.contains(thema = StringEscapeUtils.unescapeHtml4((String)thema.trim()))) {
                        this.listeAlleThemen.add(thema);
                    }
                    if (url.isEmpty() || !url.startsWith("sendungen/") && !url.startsWith("video/")) continue;
                    String[] add = new String[]{"http://www.br.de/mediathek/video/" + url, thema};
                    this.listeThemen.addUrl(add);
                }
                catch (Exception ex) {
                    Log.errorLog((int)821213698, (Exception)ex);
                }
            }
        }
    }

    private void getTage() {
        String ADRESSE = "http://www.br.de/mediathek/video/programm/index.html";
        String MUSTER = "http://www.br.de/mediathek/video/programm/mediathek-programm-100~_date-";
        this.listeTage.clear();
        MSStringBuilder seite1 = new MSStringBuilder(65536);
        MSStringBuilder seite2 = new MSStringBuilder(65536);
        ArrayList al = new ArrayList();
        try {
            GetUrl getUrlIo = new GetUrl(this.getWartenSeiteLaden());
            seite1 = getUrlIo.getUri(SENDERNAME, "http://www.br.de/mediathek/video/programm/index.html", StandardCharsets.UTF_8, 5, seite1, "");
            int max_ = CrawlerTool.loadLongMax() ? 21 : 7;
            for (int i = 0; i < max_ && !Config.getStop(); ++i) {
                String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date().getTime() - (long)(i * 86400000));
                String url = seite1.extract("/mediathek/video/programm/mediathek-programm-100~_date-" + date, "\"");
                if (url.isEmpty()) continue;
                url = "http://www.br.de/mediathek/video/programm/mediathek-programm-100~_date-" + date + url;
                seite2 = getUrlIo.getUri_Utf(SENDERNAME, url, seite2, "");
                seite2.extractList("<div class=\"epgContainer\"", "<h3>Legende</h3>", "<a href=\"/mediathek/video/", "\"", "http://www.br.de/mediathek/video/", al);
            }
            for (String s : al) {
                String[] add = new String[]{s, ""};
                if (this.istInListe(this.listeTage, add[0], 0)) continue;
                this.listeTage.add(add);
            }
        }
        catch (Exception ex) {
            Log.errorLog((int)821213698, (Exception)ex);
        }
    }

    @Override
    protected synchronized void meldungThreadUndFertig() {
        if (this.getThreads() <= 1) {
            this.mlibFilmeSuchen.listeFilmeNeu.checkThema(this.getSendername(), this.listeAlleThemenCount_, this.getSendername());
        }
        super.meldungThreadUndFertig();
    }

    private void loadXml(MSStringBuilder seite, String urlXml, String urlThema, String thema, String titel, String description, String datum, String zeit) {
        long duration = 0L;
        GetUrl getUrlIo = new GetUrl(this.getWartenSeiteLaden());
        seite = getUrlIo.getUri_Utf(SENDERNAME, urlXml, seite, "");
        if (seite.length() == 0) {
            Log.errorLog((int)820139701, (String)urlXml);
            return;
        }
        try {
            String dauer = seite.extract("<duration>", PATTERN_END);
            if (!dauer.isEmpty()) {
                String[] parts = dauer.split(":");
                duration = 0L;
                long power = 1L;
                for (int i = parts.length - 1; i >= 0; --i) {
                    duration += Long.parseLong(parts[i]) * power;
                    power *= 60L;
                }
            }
        }
        catch (NumberFormatException ex) {
            Log.errorLog((int)735216703, (Exception)ex, (String)urlThema);
        }
        if (description.isEmpty()) {
            description = seite.extract("<desc>", "</desc>");
        }
        String subtitle = seite.extract("<dataTimedText url=\"", "\"");
        String urlVerySmall = this.getUrl(seite, PATTERN_VERY_SMALL);
        String urlSmall = this.getUrl(seite, PATTERN_SMALL);
        String urlNormal = this.getUrl(seite, PATTERN_NORMAL);
        String urlHd = this.getUrl(seite, PATTERN_HD);
        if (urlNormal.isEmpty()) {
            if (!urlSmall.isEmpty()) {
                urlNormal = urlSmall;
                urlSmall = "";
            } else if (!urlVerySmall.isEmpty()) {
                urlNormal = urlVerySmall;
                urlVerySmall = "";
            }
        }
        if (urlVerySmall.isEmpty()) {
            urlVerySmall = urlSmall;
        }
        if (!urlNormal.isEmpty()) {
            if (thema.equals(SENDERNAME) && (thema = seite.extract("<broadcast>", PATTERN_END)).equals(titel)) {
                titel = seite.extract("<title>", PATTERN_END);
            }
            if (!thema.isEmpty()) {
                if (!this.listeAlleThemenCount.contains(thema)) {
                    this.listeAlleThemenCount.add(thema);
                } else if (!this.listeAlleThemenCount_.contains(thema)) {
                    this.listeAlleThemenCount_.add(thema);
                }
            }
            DatenFilm film = new DatenFilm(SENDERNAME, thema, urlThema, titel, urlNormal, "", datum, zeit, duration, description);
            if (!urlVerySmall.isEmpty()) {
                CrawlerTool.addUrlKlein(film, urlVerySmall, "");
            }
            if (!urlHd.isEmpty()) {
                CrawlerTool.addUrlHd(film, urlHd, "");
            }
            if (!subtitle.isEmpty()) {
                subtitle = "http://www.br.de" + subtitle;
                CrawlerTool.addUrlSubtitle(film, subtitle);
            }
            this.addFilm(film);
            this.meldung(film.arr[14]);
        } else {
            Log.errorLog((int)612136978, (String)("keine URL: " + urlXml));
        }
    }

    private String getUrl(MSStringBuilder seiteXml, String pattern) {
        return seiteXml.extract(pattern, PATTERN_DLURL, PATTERN_END);
    }

    private String checkThema(String thema) {
        thema = StringEscapeUtils.unescapeXml((String)thema.trim());
        thema = StringEscapeUtils.unescapeHtml4((String)thema.trim());
        for (String s : this.listeAlleThemen) {
            if (!thema.equalsIgnoreCase(s)) continue;
            return s;
        }
        for (String s : this.listeAlleThemen) {
            if (!thema.toLowerCase().startsWith(s.toLowerCase())) continue;
            return s;
        }
        return this.getSendername();
    }

    private class ArchivLaden
    extends Thread {
        private final int anfang;
        private final int ende;
        private final MSStringBuilder seiteXml = new MSStringBuilder(65536);
        private static final String MUSTER_ADRESSE_1 = "http://www.br.de/service/suche/archiv102.html?documentTypes=video&page=";
        private static final String MUSTER_ADRESSE_2 = "&sort=date";
        private static final String MUSTER_START = "<div class=\"teaser search_result\">";

        public ArchivLaden(int aanfang, int eende) {
            this.anfang = aanfang;
            this.ende = eende;
            this.setName("BR_Archiv_Laden_" + aanfang + '_' + eende);
        }

        @Override
        public void run() {
            MediathekBr.this.meldungAddMax(this.ende - this.anfang);
            MediathekBr.this.meldungAddThread();
            try {
                this.archivSuchen(this.anfang, this.ende);
            }
            catch (Exception ex) {
                Log.errorLog((int)203069877, (Exception)ex);
            }
            MediathekBr.this.meldungThreadUndFertig();
        }

        private void archivSuchen(int start, int ende) {
            MSStringBuilder seiteArchiv1 = new MSStringBuilder(65536);
            MSStringBuilder seiteArchiv2 = new MSStringBuilder(65536);
            GetUrl getUrl = new GetUrl(MediathekBr.this.getWartenSeiteLaden());
            for (int i = start; i <= ende && !Config.getStop(); ++i) {
                String adresse = MUSTER_ADRESSE_1 + i + MUSTER_ADRESSE_2;
                MediathekBr.this.meldungProgress(adresse);
                seiteArchiv1 = getUrl.getUri(MediathekBr.SENDERNAME, adresse, StandardCharsets.UTF_8, 2, seiteArchiv1, "");
                int pos = 0;
                while (!Config.getStop() && (pos = seiteArchiv1.indexOf(MUSTER_START, pos)) != -1) {
                    int stop = seiteArchiv1.indexOf(MUSTER_START, pos += MUSTER_START.length());
                    String url = seiteArchiv1.extract("<a href=\"", "\"", pos, stop);
                    String thema = seiteArchiv1.extract("teaser_overline\">", MediathekBr.PATTERN_END, pos, stop).trim();
                    if (thema.endsWith(":")) {
                        thema = thema.substring(0, thema.lastIndexOf(58));
                    }
                    thema = MediathekBr.this.checkThema(thema);
                    String titel = seiteArchiv1.extract("teaser_title\">", MediathekBr.PATTERN_END, pos, stop);
                    String datum = seiteArchiv1.extract("search_date\">", MediathekBr.PATTERN_END, pos, stop);
                    if (datum.contains("|")) {
                        datum = datum.substring(0, datum.indexOf(124)).trim();
                    }
                    String beschreibung = seiteArchiv1.extract("<p>", MediathekBr.PATTERN_END, pos, stop);
                    if (url.isEmpty()) continue;
                    url = "http://www.br.de" + url;
                    this.archivAdd1(getUrl, seiteArchiv2, url, thema, titel, datum, beschreibung);
                }
            }
        }

        private void archivAdd1(GetUrl getUrl, MSStringBuilder seiteArchiv2, String urlThema, String thema, String titel, String datum, String beschreibung) {
            MediathekBr.this.meldung(urlThema);
            seiteArchiv2 = getUrl.getUri(MediathekBr.SENDERNAME, urlThema, StandardCharsets.UTF_8, 1, seiteArchiv2, "");
            String xmlUrl = seiteArchiv2.extract("setup({dataURL:'", "'");
            if (beschreibung.isEmpty()) {
                beschreibung = seiteArchiv2.extract("<meta property=\"og:description\" content=\"", "\"");
            }
            if (beschreibung.isEmpty()) {
                beschreibung = seiteArchiv2.extract("<div class=\"bcastContent\">", "<p>", "</p>");
            }
            if (!xmlUrl.isEmpty()) {
                xmlUrl = "http://www.br.de" + xmlUrl;
                MediathekBr.this.loadXml(this.seiteXml, xmlUrl, urlThema, thema, titel, beschreibung, datum, "");
            }
        }
    }

    private class KlassikLaden
    extends Thread {
        private final MSStringBuilder seite1 = new MSStringBuilder(65536);
        private final MSStringBuilder seite2 = new MSStringBuilder(65536);
        private final MSStringBuilder seite3 = new MSStringBuilder(65536);
        private final MSStringBuilder seiteXml = new MSStringBuilder(65536);

        private KlassikLaden() {
        }

        @Override
        public void run() {
            try {
                MediathekBr.this.meldungAddThread();
                this.laden();
            }
            catch (Exception ex) {
                Log.errorLog((int)954123458, (Exception)ex);
            }
            MediathekBr.this.meldungThreadUndFertig();
        }

        private void laden() {
            MSStringBuilder seite = this.seite1;
            GetUrl getUrlIo = new GetUrl(MediathekBr.this.getWartenSeiteLaden());
            getUrlIo.getUri_Utf(MediathekBr.SENDERNAME, "http://www.br.de/mediathek/video/br-klassik-mediathek-100.html", seite, "");
            if (seite.length() == 0) {
                return;
            }
            String thema = "BR-Klassik";
            String zeit = "";
            String u = seite.extract("<a class=\"button large\" href=\"", "\"");
            if (!u.isEmpty()) {
                u = "http://www.br.de" + u;
                getUrlIo.getUri_Utf(MediathekBr.SENDERNAME, u, this.seite2, "");
                if (this.seite2.length() != 0) {
                    seite = this.seite2;
                }
            }
            ArrayList result = new ArrayList();
            seite.extractList("<h2 id=\"inhalt\" class=\"hidden\">Inhalt</h2>", "<div class=\"teaserBundleMore\">", "<a href=\"/mediathek/video/", "\"", "http://www.br.de/mediathek/video/", result);
            MediathekBr.this.meldungAddMax(result.size());
            int count = 0;
            for (String url : result) {
                if (Config.getStop() || !CrawlerTool.loadLongMax() && ++count > 20) break;
                MediathekBr.this.meldungProgress(url);
                getUrlIo.getUri_Utf(MediathekBr.SENDERNAME, url, this.seite3, url);
                String titel = this.seite3.extract("<h3>", MediathekBr.PATTERN_END);
                String datum = this.seite3.extract("<time class=\"start\" datetime=\"", ">", MediathekBr.PATTERN_END);
                datum = datum.replace("Uhr", "").trim();
                if (!datum.isEmpty()) {
                    zeit = this.convertTime(datum);
                    datum = this.convertDatum(datum);
                }
                String description1 = this.seite3.extract("<li class=\"title\">", MediathekBr.PATTERN_END);
                description1 = description1 + "\n";
                String description2 = this.seite3.extract("<div class=\"bcastContent\">", "</p>");
                description2 = description2.replaceFirst("\n", "");
                description2 = description2.replaceFirst("<p>", "");
                description2 = description2.replaceAll("<br/>", "\n");
                String urlXml = this.seite3.extract("{dataURL:'", "'");
                if (urlXml.isEmpty()) {
                    Log.errorLog((int)815263987, (String)("keine URL: " + url));
                    continue;
                }
                urlXml = "http://www.br.de" + urlXml;
                MediathekBr.this.loadXml(this.seiteXml, urlXml, url, "BR-Klassik", titel, description1 + description2, datum, zeit);
            }
        }

        private String convertDatum(String datum) {
            try {
                Date filmDate = MediathekBr.this.sdf.parse(datum);
                datum = MediathekBr.this.sdfOutDay.format(filmDate);
            }
            catch (ParseException ex) {
                Log.errorLog((int)915364789, (Exception)ex, (String)("Datum: " + datum));
            }
            return datum;
        }

        private String convertTime(String zeit) {
            try {
                Date filmDate = MediathekBr.this.sdf.parse(zeit);
                zeit = MediathekBr.this.sdfOutTime.format(filmDate);
            }
            catch (ParseException ex) {
                Log.errorLog((int)312154879, (Exception)ex, (String)("Time: " + zeit));
            }
            return zeit;
        }
    }

    private class ThemaLaden
    extends Thread {
        GetUrl getUrl;
        private final MSStringBuilder seite1;
        private final MSStringBuilder seite2;
        private MSStringBuilder seite3;
        private final MSStringBuilder seiteXml;

        private ThemaLaden() {
            this.getUrl = new GetUrl(MediathekBr.this.getWartenSeiteLaden());
            this.seite1 = new MSStringBuilder(65536);
            this.seite2 = new MSStringBuilder(65536);
            this.seite3 = new MSStringBuilder(65536);
            this.seiteXml = new MSStringBuilder(65536);
        }

        @Override
        public void run() {
            try {
                String[] link;
                MediathekBr.this.meldungAddThread();
                while (!Config.getStop() && (link = MediathekBr.this.listeThemen.getListeThemen()) != null) {
                    MediathekBr.this.meldungProgress(link[0]);
                    this.laden(link[0], link[1], this.seite1, true);
                }
                while (!Config.getStop() && (link = MediathekBr.this.listeTage.getListeThemen()) != null) {
                    MediathekBr.this.meldungProgress(link[0]);
                    this.laden(link[0], link[1], this.seite1, false);
                }
            }
            catch (Exception ex) {
                Log.errorLog((int)989632147, (Exception)ex);
            }
            MediathekBr.this.meldungThreadUndFertig();
        }

        private void laden(String urlThema, String thema, MSStringBuilder seite, boolean weitersuchen) {
            String urlXml;
            String description;
            String urlSeite;
            GetUrl getUrlIo = new GetUrl(MediathekBr.this.getWartenSeiteLaden());
            seite = getUrlIo.getUri_Utf(MediathekBr.SENDERNAME, urlThema, seite, "");
            if (seite.length() == 0) {
                return;
            }
            String zeit = "";
            if (seite.indexOf("<p class=\"noVideo\">Zur Sendung \"") != -1 && seite.indexOf("\" liegen momentan keine Videos vor</p>") != -1) {
                return;
            }
            String thema_ = seite.extract("<h3>", MediathekBr.PATTERN_END).trim();
            if (thema.isEmpty()) {
                thema = MediathekBr.this.checkThema(thema_);
            }
            String titel = !thema.equals(thema_) ? thema_ : seite.extract("<li class=\"title\">", MediathekBr.PATTERN_END);
            String datum = seite.extract("<time class=\"start\" datetime=\"", ">", MediathekBr.PATTERN_END);
            if (!(datum = datum.replace("Uhr", "").trim()).isEmpty()) {
                zeit = this.convertTime(datum);
                datum = this.convertDatum(datum);
            }
            if ((urlSeite = seite.extract("id=\"fieldLink\" value=\"", "\"")).isEmpty()) {
                Log.errorLog((int)912030145, (String)("urlSeite leer: " + urlThema));
                urlSeite = urlThema;
            }
            if ((description = seite.extract("<meta property=\"og:description\" content=\"", "\"")).isEmpty()) {
                description = seite.extract("<div class=\"bcastContent\">", "<p>", "</p>");
            }
            if ((urlXml = seite.extract("{dataURL:'", "'")).isEmpty()) {
                Log.errorLog((int)915263478, (String)("keine URL: " + urlThema));
            } else {
                urlXml = "http://www.br.de" + urlXml;
                MediathekBr.this.loadXml(this.seiteXml, urlXml, urlSeite, thema, titel, description, datum, zeit);
            }
            if (!weitersuchen) {
                return;
            }
            int count = 0;
            int max = CrawlerTool.loadLongMax() ? 20 : 0;
            String STOP = "<h3>Besucher, die dieses Video angesehen haben, sahen auch</h3>";
            int stop = seite.indexOf("<h3>Besucher, die dieses Video angesehen haben, sahen auch</h3>");
            if (max > 0) {
                String u;
                if (urlThema.equals("http://www.br.de/mediathek/video/sendungen/spielfilme-im-br/spielfilme-im-br110.html") || urlThema.equals("http://www.br.de/mediathek/video/sendungen/alpha-centauri/alpha-centauri104.html")) {
                    max = 60;
                }
                if (!(u = seite.extract("<a class=\"button large\" href=\"", "\"", 0, stop)).isEmpty()) {
                    u = "http://www.br.de" + u;
                    this.seite3 = getUrlIo.getUri_Utf(MediathekBr.SENDERNAME, u, seite, "");
                    if (this.seite3.length() != 0) {
                        seite = this.seite3;
                        stop = seite.indexOf("<h3>Besucher, die dieses Video angesehen haben, sahen auch</h3>");
                    }
                }
            }
            String MUSTER_URL = "<a href=\"/mediathek/video/";
            int pos1 = seite.indexOf("<h3>Mehr von <strong>");
            if (pos1 != -1) {
                while (!(Config.getStop() || (pos1 = seite.indexOf("<a href=\"/mediathek/video/", pos1)) == -1 || stop > 0 && pos1 > stop)) {
                    String urlWeiter = seite.extract("<a href=\"/mediathek/video/", "\"", pos1);
                    pos1 += "<a href=\"/mediathek/video/".length();
                    if (urlWeiter.isEmpty() || (urlWeiter = "http://www.br.de/mediathek/video/" + urlWeiter).contains("livestream")) continue;
                    if (++count > max) break;
                    this.laden(urlWeiter, thema, this.seite2, false);
                }
            }
        }

        private String convertDatum(String datum) {
            block2: {
                try {
                    Date filmDate = MediathekBr.this.sdf.parse(datum);
                    datum = MediathekBr.this.sdfOutDay.format(filmDate);
                }
                catch (ParseException ex) {
                    if (!MserverDaten.debug) break block2;
                    Log.errorLog((int)915364789, (Exception)ex, (String)("Datum: " + datum));
                }
            }
            return datum;
        }

        private String convertTime(String zeit) {
            block2: {
                try {
                    Date filmDate = MediathekBr.this.sdf.parse(zeit);
                    zeit = MediathekBr.this.sdfOutTime.format(filmDate);
                }
                catch (ParseException ex) {
                    if (!MserverDaten.debug) break block2;
                    Log.errorLog((int)312154879, (Exception)ex, (String)("Time: " + zeit));
                }
            }
            return zeit;
        }
    }
}

