/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.tool.Log;
import de.mediathekview.mlib.tool.MSStringBuilder;
import java.text.SimpleDateFormat;
import java.util.Date;
import mServer.crawler.CrawlerTool;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.GetUrl;
import mServer.crawler.sender.MediathekReader;
import mServer.crawler.sender.MediathekZdf;

public class Mediathek3Sat
extends MediathekReader {
    public static final String SENDERNAME = "3Sat";
    private static final String[] QU_WIDTH_HD = new String[]{"1280"};
    private static final String[] QU_WIDTH = new String[]{"1024", "852", "720", "688", "480", "432", "320"};
    private static final String[] QU_WIDTH_KL = new String[]{"688", "480", "432", "320"};
    private static final String BESCHREIBUNG = "<detail>";
    private static final String LAENGE_SEC = "<lengthSec>";
    private static final String LAENGE = "<length>";
    private static final String DATUM = "<airtime>";
    private static final String THEMA = "<originChannelTitle>";
    private static final String checkUrlHD_String = "http://www.metafilegenerator.de/ondemand/zdf/hbbtv/";
    private static final String URL_ANFANG = "<formitaet basetype=\"h264_aac_mp4_http_na_na\"";
    private static final String URL_ENDE = "</formitaet>";
    private static final String URL = "<url>";
    private static final String WIDTH = "<width>";

    public Mediathek3Sat(FilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 2, 200, startPrio);
    }

    @Override
    protected void addToList() {
        this.listeThemen.clear();
        this.meldungStart();
        this.sendungenLaden();
        this.tageLaden();
        if (Config.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.isEmpty()) {
            this.meldungThreadUndFertig();
        } else {
            Mediathek3Sat.listeSort(this.listeThemen, 1);
            this.meldungAddMax(this.listeThemen.size());
            for (int t = 0; t < this.getMaxThreadLaufen(); ++t) {
                ThemaLaden th = new ThemaLaden();
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    private void tageLaden() {
        for (int i = 0; i < (CrawlerTool.loadLongMax() ? 21 : 7); ++i) {
            String date = new SimpleDateFormat("yyyyMMdd").format(new Date().getTime() - (long)(i * 86400000));
            String url = "https://www.3sat.de/mediathek/index.php?datum=" + date + "&cx=134";
            this.listeThemen.add(new String[]{url, ""});
        }
    }

    private void sendungenLaden() {
        String ADRESSE = "http://www.3sat.de/mediathek/";
        String MUSTER_URL = "<a class=\"SubItem\" href=\"//www.3sat.de/mediathek/?red=";
        MSStringBuilder seite = new MSStringBuilder(65536);
        GetUrl getUrlIo = new GetUrl(this.getWartenSeiteLaden());
        seite = getUrlIo.getUri_Utf(SENDERNAME, "http://www.3sat.de/mediathek/", seite, "");
        int pos1 = 0;
        String url = "";
        String thema = "";
        while ((pos1 = seite.indexOf("<a class=\"SubItem\" href=\"//www.3sat.de/mediathek/?red=", pos1)) != -1) {
            try {
                int pos2 = seite.indexOf("\"", pos1 += "<a class=\"SubItem\" href=\"//www.3sat.de/mediathek/?red=".length());
                if (pos2 != -1) {
                    url = seite.substring(pos1, pos2);
                }
                if (url.isEmpty()) continue;
                if ((pos1 = seite.indexOf(">", pos1)) != -1 && (pos2 = seite.indexOf("<", ++pos1)) != -1) {
                    thema = seite.substring(pos1, pos2);
                }
                String[] add = new String[]{"http://www.3sat.de/mediathek/?red=" + url + "&type=1", thema};
                this.listeThemen.addUrl(add);
            }
            catch (Exception ex) {
                Log.errorLog((int)915237874, (Exception)ex);
            }
        }
    }

    private String extractBeschreibung(MSStringBuilder strBuffer, String urlId) {
        String beschreibung = strBuffer.extract(BESCHREIBUNG, "<");
        if (beschreibung.isEmpty()) {
            beschreibung = strBuffer.extract(BESCHREIBUNG, "</");
            beschreibung = beschreibung.replace("<![CDATA[", "");
            if ((beschreibung = beschreibung.replace("]]>", "")).isEmpty()) {
                Log.errorLog((int)945123074, (String)("url: " + urlId));
            }
        }
        return beschreibung;
    }

    private long extractLaenge(MSStringBuilder strBuffer) {
        long laengeL;
        String laenge = strBuffer.extract(LAENGE_SEC, "<");
        if (!laenge.isEmpty()) {
            laengeL = Mediathek3Sat.extractDurationSec(laenge);
        } else {
            laenge = strBuffer.extract(LAENGE, "<");
            if (laenge.contains(".")) {
                laenge = laenge.substring(0, laenge.indexOf(46));
            }
            laengeL = Mediathek3Sat.extractDuration(laenge);
        }
        return laengeL;
    }

    private String extractSubtitle(MSStringBuilder strBuffer) {
        String subtitle = strBuffer.extract("<caption>", "<url>http://", "<", "http://");
        if (subtitle.isEmpty()) {
            subtitle = strBuffer.extract("<caption>", "<url>https://", "<", "https://");
        }
        return subtitle;
    }

    private DatenFilm filmHolenId(MSStringBuilder strBuffer, String sender, String thema, String titel, String filmWebsite, String urlId) {
        String urlKlein;
        String zeit = "";
        GetUrl getUrl = new GetUrl(this.getWartenSeiteLaden());
        strBuffer = getUrl.getUri_Utf(sender, urlId, strBuffer, "URL-Filmwebsite: " + filmWebsite);
        if (strBuffer.length() == 0) {
            Log.errorLog((int)398745601, (String)("url: " + urlId));
            return null;
        }
        String subtitle = this.extractSubtitle(strBuffer);
        String beschreibung = this.extractBeschreibung(strBuffer, urlId);
        if (thema.isEmpty()) {
            thema = strBuffer.extract(THEMA, "<");
        }
        long laengeL = this.extractLaenge(strBuffer);
        String datum = strBuffer.extract(DATUM, "<");
        if (datum.contains(" ")) {
            zeit = datum.substring(datum.lastIndexOf(32)).trim() + ":00";
            datum = datum.substring(0, datum.lastIndexOf(32)).trim();
        }
        String urlHd = this.getUrl(strBuffer, QU_WIDTH_HD, true);
        String url = this.getUrl(strBuffer, QU_WIDTH, true);
        if (url.equals(urlKlein = this.getUrl(strBuffer, QU_WIDTH_KL, false))) {
            urlKlein = "";
        }
        if (url.isEmpty()) {
            url = urlKlein;
            urlKlein = "";
        }
        if (url.isEmpty()) {
            Log.errorLog((int)397002891, (String)("keine URL: " + filmWebsite));
            return null;
        }
        DatenFilm film = new DatenFilm(sender, thema, filmWebsite, titel, url, "", datum, zeit, laengeL, beschreibung);
        if (!subtitle.isEmpty()) {
            CrawlerTool.addUrlSubtitle(film, subtitle);
        }
        CrawlerTool.addUrlKlein(film, urlKlein, "");
        CrawlerTool.addUrlHd(film, urlHd, "");
        return film;
    }

    private String getUrl(MSStringBuilder strBuffer, String[] arr, boolean hd) {
        String ret = "";
        block0: for (String qual : arr) {
            int posEnde;
            int posAnfang = 0;
            while ((posAnfang = strBuffer.indexOf(URL_ANFANG, posAnfang)) != -1 && (posEnde = strBuffer.indexOf(URL_ENDE, posAnfang += URL_ANFANG.length())) != -1) {
                String tmp = strBuffer.extract(URL, "<", posAnfang, posEnde);
                if (!strBuffer.extract(WIDTH, "<", posAnfang, posEnde).equals(qual) || (ret = hd ? this.checkUrlHD(tmp) : this.checkUrl(tmp)).isEmpty()) continue;
                break block0;
            }
        }
        if (ret.startsWith("http://tvdl.zdf.de")) {
            ret = ret.replace("http://tvdl.zdf.de", "http://nrodl.zdf.de");
        }
        return ret;
    }

    private String checkUrlHD(String url) {
        String ret = "";
        if (url.startsWith("http") && url.endsWith("mp4") && (ret = url).startsWith(checkUrlHD_String)) {
            ret = ret.replaceFirst(checkUrlHD_String, "http://nrodl.zdf.de/");
        }
        return ret;
    }

    private String checkUrl(String url) {
        String ret = "";
        if (url.startsWith("http") && url.endsWith("mp4") && !url.startsWith("http://www.metafilegenerator.de/")) {
            ret = url;
        }
        return ret;
    }

    private class ThemaLaden
    extends Thread {
        private final MSStringBuilder seite2 = new MSStringBuilder(65536);
        private MSStringBuilder seite1 = new MSStringBuilder(65536);

        private ThemaLaden() {
        }

        @Override
        public void run() {
            try {
                String[] link;
                Mediathek3Sat.this.meldungAddThread();
                while (!Config.getStop() && (link = Mediathek3Sat.this.listeThemen.getListeThemen()) != null) {
                    Mediathek3Sat.this.meldungProgress(link[0]);
                    this.laden(link[0], link[1], true);
                }
            }
            catch (Exception ex) {
                Log.errorLog((int)987452384, (Exception)ex);
            }
            Mediathek3Sat.this.meldungThreadUndFertig();
        }

        private void laden(String urlThema, String thema, boolean weiter) {
            String MUSTER_START = "<div class=\"BoxPicture MediathekListPic\">";
            for (int i = 0; i < (CrawlerTool.loadLongMax() ? 40 : 5); ++i) {
                String url;
                if (thema.isEmpty()) {
                    url = urlThema;
                    i = 9999;
                } else {
                    weiter = false;
                    url = urlThema + "&mode=verpasst" + i;
                }
                Mediathek3Sat.this.meldung(url);
                GetUrl getUrlIo = new GetUrl(Mediathek3Sat.this.getWartenSeiteLaden());
                this.seite1 = getUrlIo.getUri_Utf(Mediathek3Sat.SENDERNAME, url, this.seite1, "");
                if (this.seite1.indexOf("<div class=\"BoxPicture MediathekListPic\">") == -1) break;
                int pos1 = 0;
                while ((pos1 = this.seite1.indexOf("<div class=\"BoxPicture MediathekListPic\">", pos1)) != -1) {
                    DatenFilm film;
                    boolean ok = false;
                    String titel = this.seite1.extract("<a class=\"MediathekLink\"  title='Video abspielen:", "'", pos1 += "<div class=\"BoxPicture MediathekListPic\">".length()).trim();
                    String urlId = this.seite1.extract("href=\"//www.3sat.de/mediathek/?mode=play&amp;obj=", "\"", pos1);
                    if (urlId.isEmpty()) {
                        urlId = this.seite1.extract("href=\"?obj=", "\"", pos1);
                    }
                    String urlFilm = "http://www.3sat.de/mediathek/?mode=play&obj=" + urlId;
                    if (!urlId.isEmpty() && (film = Mediathek3Sat.this.filmHolenId(this.seite2, Mediathek3Sat.SENDERNAME, thema, titel, urlFilm, urlId = "http://www.3sat.de/mediathek/xmlservice/web/beitragsDetails?ak=web&id=" + urlId)) != null) {
                        MediathekZdf.urlTauschen(film, url, Mediathek3Sat.this.mlibFilmeSuchen);
                        Mediathek3Sat.this.addFilm(film);
                        ok = true;
                    }
                    if (ok) continue;
                    Log.errorLog((int)462313269, (String)("Thema: " + url));
                }
            }
            if (weiter && this.seite1.indexOf("mode=verpasst1") != -1) {
                this.laden(urlThema + "&mode=verpasst1", thema, false);
            }
        }
    }
}

