/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.br;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.Optional;
import mServer.crawler.sender.MediathekReader;
import mServer.crawler.sender.br.BrIdsDTO;

public class BrSendungsFolgenDeserializer
implements JsonDeserializer<BrIdsDTO> {
    private static final String JSON_ELEMENT_EDGES = "edges";
    private static final String JSON_ELEMENT_CLIPS_ONLY = "clipsOnly";
    private static final String JSON_ELEMENT_PREVIOUS_EPISODES = "previousEpisodes";
    private static final String JSON_ELEMENT_SERIES = "series";
    private static final String JSON_ELEMENT_VIEWER = "viewer";
    private static final String JSON_ELEMENT_DATA = "data";
    private static final String JSON_ELEMENT_ID = "id";
    private static final String JSON_ELEMENT_NODE = "node";
    private final MediathekReader crawler;

    public BrSendungsFolgenDeserializer(MediathekReader aCrawler) {
        this.crawler = aCrawler;
    }

    public BrIdsDTO deserialize(JsonElement aElement, Type aType, JsonDeserializationContext aContext) {
        BrIdsDTO results = new BrIdsDTO();
        JsonObject baseObject = aElement.getAsJsonObject();
        Optional<JsonObject> series = this.getSeries(baseObject);
        if (series.isPresent()) {
            Optional<JsonArray> clipsEdges = this.getClipsEdges(series.get());
            this.addToResult(results, clipsEdges);
            Optional<JsonArray> previosEpisodesEdges = this.getPreviousEpisodesEdges(series.get());
            this.addToResult(results, previosEpisodesEdges);
        }
        return results;
    }

    private void addToResult(BrIdsDTO results, Optional<JsonArray> aEdges) {
        if (aEdges.isPresent()) {
            for (JsonElement edge : aEdges.get()) {
                JsonObject node;
                JsonObject ebdgeObj = edge.getAsJsonObject();
                if (!ebdgeObj.has(JSON_ELEMENT_NODE) || !(node = ebdgeObj.getAsJsonObject(JSON_ELEMENT_NODE)).has(JSON_ELEMENT_ID)) continue;
                results.add(node.get(JSON_ELEMENT_ID).getAsString());
            }
        }
    }

    private Optional<JsonArray> getClipsEdges(JsonObject aSeries) {
        return this.getEdges(aSeries, JSON_ELEMENT_CLIPS_ONLY);
    }

    private Optional<JsonArray> getEdges(JsonObject aSeries, String aEdgesParentElementId) {
        if (!aSeries.has(aEdgesParentElementId)) {
            return Optional.empty();
        }
        JsonObject edgesParent = aSeries.getAsJsonObject(aEdgesParentElementId);
        if (!edgesParent.has(JSON_ELEMENT_EDGES)) {
            return Optional.empty();
        }
        return Optional.of(edgesParent.getAsJsonArray(JSON_ELEMENT_EDGES));
    }

    private Optional<JsonArray> getPreviousEpisodesEdges(JsonObject aSeries) {
        return this.getEdges(aSeries, JSON_ELEMENT_PREVIOUS_EPISODES);
    }

    private Optional<JsonObject> getSeries(JsonObject aBaseObject) {
        if (!aBaseObject.has(JSON_ELEMENT_DATA)) {
            return Optional.empty();
        }
        JsonObject data = aBaseObject.getAsJsonObject(JSON_ELEMENT_DATA);
        if (!data.has(JSON_ELEMENT_VIEWER)) {
            return Optional.empty();
        }
        JsonObject viewer = data.getAsJsonObject(JSON_ELEMENT_VIEWER);
        if (!viewer.has(JSON_ELEMENT_SERIES)) {
            return Optional.empty();
        }
        return Optional.of(viewer.getAsJsonObject(JSON_ELEMENT_SERIES));
    }
}

