/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.orf;

import java.time.Duration;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

public final class HtmlDocumentUtils {
    private static final Logger LOG = LogManager.getLogger(HtmlDocumentUtils.class);
    private static final String DAUER_REGEX_PATTERN = "\\d+:\\d+";

    private HtmlDocumentUtils() {
    }

    public static Optional<String> getElementAttributeString(String aElementSelector, String aAttributeKey, Document aDocument) {
        Elements selected = aDocument.select(aElementSelector);
        if (!selected.isEmpty() && selected.first().hasAttr(aAttributeKey)) {
            return Optional.of(selected.first().attr(aAttributeKey));
        }
        return Optional.empty();
    }

    public static Optional<String> getElementString(String aElementSelector, Document aDocument) {
        Elements selected = aDocument.select(aElementSelector);
        if (!selected.isEmpty()) {
            return Optional.of(selected.first().text());
        }
        return Optional.empty();
    }

    public static Optional<Duration> parseDuration(Optional<String> aDauerText) {
        return aDauerText.isPresent() ? HtmlDocumentUtils.parseDuration(aDauerText.get()) : Optional.empty();
    }

    public static Optional<Duration> parseDuration(String aDauerText) {
        String[] dauerSplits;
        Matcher dauerMatcher = Pattern.compile(DAUER_REGEX_PATTERN).matcher(aDauerText);
        if (dauerMatcher.find() && 2 == (dauerSplits = dauerMatcher.group().split(":")).length) {
            try {
                return Optional.of(Duration.ofMinutes(Long.parseLong(dauerSplits[0])).withSeconds(Long.parseLong(dauerSplits[1])));
            }
            catch (NumberFormatException numberFormatException) {
                LOG.error("A duration for can't be parsed.", (Throwable)numberFormatException);
            }
        }
        return Optional.empty();
    }
}

