/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.wdr;

import mServer.crawler.CrawlerTool;
import mServer.crawler.sender.wdr.WdrDeserializerBase;
import mServer.crawler.sender.wdr.WdrSendungDto;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class WdrSendungOverviewDeserializer
extends WdrDeserializerBase {
    private static final String QUERY_URL = "div.hideTeasertext > a";
    private static final String QUERY_URL_LOKALZEIT_VIDEO_TEASER = "div.teaser.video > a";
    private static final String QUERY_URL_LOKALZEIT_MEHR = "h3.headline > a";
    private static final String QUERY_URL_ROCKPALAST_YEARS = "div.entries > div";
    private static final String QUERY_URL_ROCKPALAST_YEARS_ENTRIES = "div.entry > a";
    private static final String QUERY_URL_TYPE = "p.teasertext > strong";

    public WdrSendungDto deserialize(Document document) {
        WdrSendungDto dto = new WdrSendungDto();
        this.addUrls(dto, document, QUERY_URL, WdrDeserializerBase.UrlType.VideoPage);
        this.addUrls(dto, document, QUERY_URL_LOKALZEIT_VIDEO_TEASER, WdrDeserializerBase.UrlType.VideoPage);
        this.addUrls(dto, document, QUERY_URL_LOKALZEIT_MEHR, WdrDeserializerBase.UrlType.VideoPage);
        if (this.checkParseRockpalastYears(document)) {
            this.addUrls(dto, document, QUERY_URL_ROCKPALAST_YEARS_ENTRIES, WdrDeserializerBase.UrlType.OverviewPage);
        }
        return dto;
    }

    private void addUrls(WdrSendungDto dto, Document document, String query, WdrDeserializerBase.UrlType defaultUrlType) {
        Elements urlElements = document.select(query);
        urlElements.forEach(urlElement -> {
            String url = urlElement.attr("href");
            if (url != null && !url.isEmpty()) {
                url = this.addDomainIfNecessary(url);
                switch (this.getUrlType((Element)urlElement, defaultUrlType)) {
                    case OverviewPage: {
                        dto.addOverviewUrls(url);
                        break;
                    }
                    case VideoPage: {
                        dto.addVideoUrl(url);
                    }
                }
            }
        });
    }

    private WdrDeserializerBase.UrlType getUrlType(Element sendungElement, WdrDeserializerBase.UrlType defaultUrlType) {
        Element typeElement = sendungElement.select(QUERY_URL_TYPE).first();
        if (typeElement != null) {
            switch (typeElement.text()) {
                case "mehr": {
                    return WdrDeserializerBase.UrlType.OverviewPage;
                }
                case "video": {
                    return WdrDeserializerBase.UrlType.VideoPage;
                }
            }
        }
        return defaultUrlType;
    }

    private boolean checkParseRockpalastYears(Document document) {
        Element firstYearElement;
        Elements yearElements;
        if (CrawlerTool.loadLongMax() && (yearElements = document.select(QUERY_URL_ROCKPALAST_YEARS)) != null && (firstYearElement = yearElements.first()) != null) {
            return firstYearElement.classNames().contains("active");
        }
        return false;
    }
}

