/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.arte;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.Calendar;
import mServer.crawler.sender.arte.ArteVideoDeserializer;
import mServer.crawler.sender.arte.ArteVideoDetailsDTO;
import mServer.crawler.sender.newsearch.GeoLocations;
import mServer.tool.DateWithoutTimeComparer;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArteVideoDetailsDeserializer
implements JsonDeserializer<ArteVideoDetailsDTO> {
    private static final String JSON_ELEMENT_KEY_CATEGORY = "category";
    private static final String JSON_ELEMENT_KEY_SUBCATEGORY = "subcategory";
    private static final String JSON_ELEMENT_KEY_NAME = "name";
    private static final String JSON_ELEMENT_KEY_TITLE = "title";
    private static final String JSON_ELEMENT_KEY_SUBTITLE = "subtitle";
    private static final String JSON_ELEMENT_KEY_URL = "url";
    private static final String JSON_ELEMENT_KEY_PROGRAM_ID = "programId";
    private static final String JSON_ELEMENT_KEY_SHORT_DESCRIPTION = "shortDescription";
    private static final String JSON_ELEMENT_BROADCAST_ELTERNKNOTEN_1 = "programs";
    private static final String JSON_ELEMENT_BROADCAST_ELTERNKNOTEN_2 = "broadcastProgrammings";
    private static final String JSON_ELEMENT_BROADCAST = "broadcastBeginRounded";
    private static final String JSON_ELEMENT_BROADCASTTYPE = "broadcastType";
    private static final String JSON_ELEMENT_BROADCAST_VIDEORIGHTS_BEGIN = "videoRightsBegin";
    private static final String JSON_ELEMENT_BROADCAST_CATCHUPRIGHTS_BEGIN = "catchupRightsBegin";
    private static final String JSON_ELEMENT_BROADCAST_CATCHUPRIGHTS_END = "catchupRightsEnd";
    private static final String BROADCASTTTYPE_FIRST = "FIRST_BROADCAST";
    private static final String BROADCASTTTYPE_MINOR_RE = "MINOR_REBROADCAST";
    private static final String BROADCASTTTYPE_MAJOR_RE = "MAJOR_REBROADCAST";
    private static final Logger LOG = LogManager.getLogger(ArteVideoDeserializer.class);
    private final FastDateFormat broadcastDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ssX");
    private final Calendar today;

    public ArteVideoDetailsDeserializer(Calendar aToday) {
        this.today = aToday;
    }

    public ArteVideoDetailsDTO deserialize(JsonElement aJsonElement, Type aType, JsonDeserializationContext aContext) throws JsonParseException {
        ArteVideoDetailsDTO detailsDTO = new ArteVideoDetailsDTO();
        if (aJsonElement.isJsonObject() && aJsonElement.getAsJsonObject().get(JSON_ELEMENT_BROADCAST_ELTERNKNOTEN_1).getAsJsonArray().size() > 0) {
            JsonObject programElement = aJsonElement.getAsJsonObject().get(JSON_ELEMENT_BROADCAST_ELTERNKNOTEN_1).getAsJsonArray().get(0).getAsJsonObject();
            String titel = ArteVideoDetailsDeserializer.getTitle(programElement);
            String thema = ArteVideoDetailsDeserializer.getSubject(programElement);
            String beschreibung = ArteVideoDetailsDeserializer.getElementValue(programElement, JSON_ELEMENT_KEY_SHORT_DESCRIPTION);
            String urlWeb = ArteVideoDetailsDeserializer.getElementValue(programElement, JSON_ELEMENT_KEY_URL);
            detailsDTO.setDescription(beschreibung);
            detailsDTO.setTheme(thema);
            detailsDTO.setTitle(titel);
            detailsDTO.setWebsite(urlWeb);
            JsonArray broadcastArray = programElement.get(JSON_ELEMENT_BROADCAST_ELTERNKNOTEN_2).getAsJsonArray();
            if (broadcastArray.size() > 0) {
                detailsDTO.setBroadcastBegin(this.getBroadcastDate(broadcastArray));
            } else {
                String begin = ArteVideoDetailsDeserializer.getElementValue(programElement, JSON_ELEMENT_BROADCAST_CATCHUPRIGHTS_BEGIN);
                if (begin.isEmpty()) {
                    begin = ArteVideoDetailsDeserializer.getElementValue(programElement, JSON_ELEMENT_BROADCAST_VIDEORIGHTS_BEGIN);
                }
                detailsDTO.setBroadcastBegin(begin);
            }
            detailsDTO.setGeoLocation(this.getGeoLocation(programElement));
        }
        return detailsDTO;
    }

    private static String getSubject(JsonObject programObject) {
        JsonElement subcatElement;
        String category = "";
        String subcategory = "";
        JsonElement catElement = programObject.get(JSON_ELEMENT_KEY_CATEGORY);
        if (!catElement.isJsonNull()) {
            JsonObject catObject = catElement.getAsJsonObject();
            String string = category = catObject != null ? ArteVideoDetailsDeserializer.getElementValue(catObject, JSON_ELEMENT_KEY_NAME) : "";
        }
        if (!(subcatElement = programObject.get(JSON_ELEMENT_KEY_SUBCATEGORY)).isJsonNull()) {
            JsonObject subcatObject = subcatElement.getAsJsonObject();
            subcategory = subcatObject != null ? ArteVideoDetailsDeserializer.getElementValue(subcatObject, JSON_ELEMENT_KEY_NAME) : "";
        }
        String subject = !category.equals(subcategory) && !subcategory.isEmpty() ? category + " - " + subcategory : category;
        return subject;
    }

    private static String getTitle(JsonObject programObject) {
        String subtitle;
        String title = ArteVideoDetailsDeserializer.getElementValue(programObject, JSON_ELEMENT_KEY_TITLE);
        if (!title.equals(subtitle = ArteVideoDetailsDeserializer.getElementValue(programObject, JSON_ELEMENT_KEY_SUBTITLE)) && !subtitle.isEmpty()) {
            title = title + " - " + subtitle;
        }
        return title;
    }

    private static boolean isValidProgramObject(JsonObject programObject) {
        return programObject.has(JSON_ELEMENT_KEY_TITLE) && programObject.has(JSON_ELEMENT_KEY_PROGRAM_ID) && programObject.has(JSON_ELEMENT_KEY_URL) && !programObject.get(JSON_ELEMENT_KEY_TITLE).isJsonNull() && !programObject.get(JSON_ELEMENT_KEY_PROGRAM_ID).isJsonNull() && !programObject.get(JSON_ELEMENT_KEY_URL).isJsonNull();
    }

    private static String getElementValue(JsonObject jsonObject, String elementName) {
        return !jsonObject.get(elementName).isJsonNull() ? jsonObject.get(elementName).getAsString() : "";
    }

    private GeoLocations getGeoLocation(JsonObject programElement) {
        JsonObject geoObject;
        JsonElement geoElement;
        GeoLocations geo = GeoLocations.GEO_NONE;
        if (programElement.has("geoblocking") && !(geoElement = programElement.get("geoblocking")).isJsonNull() && !(geoObject = geoElement.getAsJsonObject()).isJsonNull() && geoObject.has("code")) {
            String code;
            switch (code = geoObject.get("code").getAsString()) {
                case "DE_FR": 
                case "EUR_DE_FR": {
                    geo = GeoLocations.GEO_DE_FR;
                    break;
                }
                case "SAT": {
                    geo = GeoLocations.GEO_DE_AT_CH_EU;
                    break;
                }
                case "ALL": {
                    geo = GeoLocations.GEO_NONE;
                    break;
                }
                default: {
                    LOG.debug("New ARTE GeoLocation: " + code);
                }
            }
        }
        return geo;
    }

    private String getBroadcastDate(JsonArray broadcastArray) {
        String broadcastDate = "";
        String broadcastBeginFirst = "";
        String broadcastBeginMajor = "";
        String broadcastBeginMinor = "";
        block10: for (int i = 0; i < broadcastArray.size(); ++i) {
            String type;
            String value;
            JsonObject broadcastObject = broadcastArray.get(i).getAsJsonObject();
            if (!broadcastObject.has(JSON_ELEMENT_BROADCASTTYPE) || !broadcastObject.has(JSON_ELEMENT_BROADCAST) || (value = this.getBroadcastDateConsideringCatchupRights(broadcastObject)).isEmpty()) continue;
            switch (type = broadcastObject.get(JSON_ELEMENT_BROADCASTTYPE).getAsString()) {
                case "FIRST_BROADCAST": {
                    broadcastBeginFirst = value;
                    continue block10;
                }
                case "MAJOR_REBROADCAST": {
                    broadcastBeginMajor = value;
                    continue block10;
                }
                case "MINOR_REBROADCAST": {
                    broadcastBeginMinor = value;
                    continue block10;
                }
                default: {
                    LOG.debug("New broadcasttype: " + type);
                }
            }
        }
        if (!broadcastBeginFirst.isEmpty()) {
            broadcastDate = broadcastBeginFirst;
        } else if (!broadcastBeginMajor.isEmpty()) {
            broadcastDate = broadcastBeginMajor;
        } else if (!broadcastBeginMinor.isEmpty()) {
            broadcastDate = broadcastBeginMinor;
        }
        if (broadcastDate.isEmpty()) {
            broadcastDate = ArteVideoDetailsDeserializer.getBroadcastDateIgnoringCatchupRights(broadcastArray, BROADCASTTTYPE_FIRST);
        }
        if (broadcastDate.isEmpty()) {
            broadcastDate = ArteVideoDetailsDeserializer.getBroadcastDateIgnoringCatchupRights(broadcastArray, BROADCASTTTYPE_MAJOR_RE);
        }
        return broadcastDate;
    }

    private String getBroadcastDateConsideringCatchupRights(JsonObject broadcastObject) {
        String broadcastDate = "";
        JsonElement elementBegin = broadcastObject.get(JSON_ELEMENT_BROADCAST_CATCHUPRIGHTS_BEGIN);
        JsonElement elementEnd = broadcastObject.get(JSON_ELEMENT_BROADCAST_CATCHUPRIGHTS_END);
        if (!elementBegin.isJsonNull() && !elementEnd.isJsonNull()) {
            String begin = elementBegin.getAsString();
            String end = elementEnd.getAsString();
            try {
                Calendar beginDate = Calendar.getInstance();
                beginDate.setTime(this.broadcastDateFormat.parse(begin));
                Calendar endDate = Calendar.getInstance();
                endDate.setTime(this.broadcastDateFormat.parse(end));
                if (DateWithoutTimeComparer.compare(this.today, beginDate) >= 0 && DateWithoutTimeComparer.compare(this.today, endDate) <= 0 || DateWithoutTimeComparer.compare(this.today, beginDate) < 0) {
                    broadcastDate = broadcastObject.get(JSON_ELEMENT_BROADCAST).getAsString();
                }
            }
            catch (ParseException ex) {
                LOG.debug((Object)ex);
            }
        } else {
            String broadcast = broadcastObject.get(JSON_ELEMENT_BROADCAST).getAsString();
            try {
                Calendar broadcastCal = Calendar.getInstance();
                broadcastCal.setTime(this.broadcastDateFormat.parse(broadcast));
                broadcastDate = broadcast;
            }
            catch (ParseException ex) {
                LOG.debug((Object)ex);
            }
        }
        return broadcastDate;
    }

    private static String getBroadcastDateIgnoringCatchupRights(JsonArray broadcastArray, String broadcastType) {
        String broadcastDate = "";
        for (int i = 0; i < broadcastArray.size(); ++i) {
            String type;
            JsonObject broadcastObject = broadcastArray.get(i).getAsJsonObject();
            if (!broadcastObject.has(JSON_ELEMENT_BROADCASTTYPE) || !broadcastObject.has(JSON_ELEMENT_BROADCAST) || !(type = broadcastObject.get(JSON_ELEMENT_BROADCASTTYPE).getAsString()).equals(broadcastType) || broadcastObject.get(JSON_ELEMENT_BROADCAST).isJsonNull()) continue;
            broadcastDate = broadcastObject.get(JSON_ELEMENT_BROADCAST).getAsString();
        }
        return broadcastDate;
    }
}

