/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.gui;

import de.mediathekview.mlib.filmesuchen.ListenerFilmeLaden;
import de.mediathekview.mlib.filmesuchen.ListenerFilmeLadenEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import mServer.crawler.CrawlerConfig;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.gui.Data;

public class MSearchLoad {
    public FilmeSuchen msFilmeSuchen;
    private final EventListenerList listeners = new EventListenerList();
    private boolean istAmLaufen = false;

    public MSearchLoad() {
        this.msFilmeSuchen = new FilmeSuchen();
        this.msFilmeSuchen.addAdListener(new ListenerFilmeLaden(){

            public synchronized void start(ListenerFilmeLadenEvent event) {
                MSearchLoad.this.notifyStart(event);
            }

            public synchronized void progress(ListenerFilmeLadenEvent event) {
                MSearchLoad.this.notifyProgress(event);
            }

            public synchronized void fertig(ListenerFilmeLadenEvent event) {
                Data.listeFilme = MSearchLoad.this.msFilmeSuchen.listeFilmeNeu;
                MSearchLoad.this.undEnde(event);
            }
        });
    }

    public void filmeBeimSenderSuchen(boolean filmlisteUpdate) {
        if (!this.istAmLaufen) {
            this.istAmLaufen = true;
            CrawlerConfig.updateFilmliste = filmlisteUpdate;
            this.msFilmeSuchen.filmeBeimSenderLaden(Data.listeFilme);
        }
    }

    public void updateSender(String[] sender) {
        if (!this.istAmLaufen) {
            this.istAmLaufen = true;
            this.msFilmeSuchen.updateSender(sender, Data.listeFilme);
        }
    }

    public String[] getSenderNamen() {
        return FilmeSuchen.getNamenSender();
    }

    private void undEnde(ListenerFilmeLadenEvent event) {
        this.istAmLaufen = false;
        this.notifyFertig(event);
        System.gc();
    }

    public void addAdListener(ListenerFilmeLaden listener) {
        this.listeners.add(ListenerFilmeLaden.class, listener);
    }

    private void notifyStart(ListenerFilmeLadenEvent event) {
        for (ListenerFilmeLaden l : (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
            this.run_(new Start(l, event, ListenerMelden.START));
        }
    }

    private void notifyProgress(ListenerFilmeLadenEvent event) {
        for (ListenerFilmeLaden l : (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
            this.run_(new Start(l, event, ListenerMelden.PROGRESS));
        }
    }

    private void notifyFertig(ListenerFilmeLadenEvent event) {
        for (ListenerFilmeLaden l : (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
            this.run_(new Start(l, event, ListenerMelden.FINISHED));
        }
    }

    private void run_(Runnable r) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class Start
    implements Runnable {
        private final ListenerFilmeLaden listenerFilmeLaden;
        private final ListenerFilmeLadenEvent event;
        private final ListenerMelden listenerMelden;

        public Start(ListenerFilmeLaden llistenerFilmeLaden, ListenerFilmeLadenEvent eevent, ListenerMelden lliListenerMelden) {
            this.listenerFilmeLaden = llistenerFilmeLaden;
            this.event = eevent;
            this.listenerMelden = lliListenerMelden;
        }

        @Override
        public synchronized void run() {
            switch (this.listenerMelden) {
                case START: {
                    this.listenerFilmeLaden.start(this.event);
                    break;
                }
                case PROGRESS: {
                    this.listenerFilmeLaden.progress(this.event);
                    break;
                }
                case FINISHED: {
                    this.listenerFilmeLaden.fertig(this.event);
                }
            }
        }
    }

    private static enum ListenerMelden {
        START,
        PROGRESS,
        FINISHED;

    }
}

