/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.gui;

import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.stage.FileChooser;
import mServer.crawler.gui.Data;

public class PanelToolController
implements Initializable {
    @FXML
    private Button btnCheck;
    @FXML
    private Button btnPlay;
    @FXML
    private Button btnPath;
    @FXML
    private Button btnStop;
    @FXML
    private TextField txtPlay;
    @FXML
    private MediaView mv;
    private MediaPlayer mediaPlayer;

    public void initialize(URL url, ResourceBundle rb) {
        this.initPanelTool();
    }

    private void initPanelTool() {
        this.btnCheck.setOnAction(e -> Data.listeFilme.check());
        this.btnPlay.setOnAction(e -> this.play());
        this.btnPath.setOnAction(e -> this.getPath());
        this.btnStop.setOnAction(e -> this.stop());
        this.txtPlay.setText("/tmp/film.mp4");
    }

    private void play() {
        File file = new File(this.txtPlay.getText());
        String MEDIA_URL = file.toURI().toString();
        Media media = new Media(MEDIA_URL);
        this.mediaPlayer = new MediaPlayer(media);
        this.mv.setMediaPlayer(this.mediaPlayer);
        this.mediaPlayer.play();
    }

    private void stop() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.stop();
        }
    }

    private void getPath() {
        FileChooser chooser = new FileChooser();
        chooser.setInitialDirectory(new File(System.getProperty("user.home")));
        File f = chooser.showOpenDialog(null);
        if (f != null) {
            try {
                this.txtPlay.setText(f.getAbsolutePath());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

