/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender;

import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.daten.ListeFilme;
import de.mediathekview.mlib.tool.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.sender.MediathekReader;
import mServer.crawler.sender.hr.HrSendungOverviewCallable;
import mServer.crawler.sender.hr.HrSendungenDto;
import mServer.crawler.sender.hr.HrSendungenListDeserializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class MediathekHr
extends MediathekReader {
    public static final String SENDERNAME = "HR";
    private static final String URL_SENDUNGEN = "http://www.hr-fernsehen.de/sendungen-a-z/index.html";
    private static final Logger LOG = LogManager.getLogger(MediathekHr.class);

    public MediathekHr(FilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 2, 200, startPrio);
    }

    @Override
    public void addToList() {
        this.meldungStart();
        List<Object> dtos = new ArrayList();
        try {
            Document document = Jsoup.connect((String)URL_SENDUNGEN).get();
            HrSendungenListDeserializer deserializer = new HrSendungenListDeserializer();
            dtos = deserializer.deserialize(document);
        }
        catch (IOException ex) {
            Log.errorLog((int)894651554, (Exception)ex);
        }
        this.meldungAddMax(dtos.size());
        ArrayList futureFilme = new ArrayList();
        dtos.forEach(dto -> {
            ExecutorService executor = Executors.newCachedThreadPool();
            futureFilme.add(executor.submit(new HrSendungOverviewCallable((HrSendungenDto)dto)));
            this.meldungProgress(dto.getUrl());
        });
        futureFilme.forEach(e -> {
            try {
                ListeFilme filmList = (ListeFilme)e.get();
                if (filmList != null) {
                    filmList.forEach(film -> {
                        if (film != null) {
                            this.addFilm((DatenFilm)film);
                        }
                    });
                }
            }
            catch (Exception exception) {
                LOG.error("Es ist ein Fehler beim lesen der HR Filme aufgetreten.", (Throwable)exception);
            }
        });
        this.meldungThreadUndFertig();
    }
}

