/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.tool.Log;
import de.mediathekview.mlib.tool.MSStringBuilder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import mServer.crawler.CrawlerTool;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.GetUrl;
import mServer.crawler.sender.MediathekReader;

public class MediathekMdr
extends MediathekReader {
    public static final String SENDERNAME = "MDR";
    private final LinkedList<String> listeTage = new LinkedList();
    private final LinkedList<String[]> listeGesucht = new LinkedList();

    public MediathekMdr(FilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 3, 200, startPrio);
    }

    @Override
    public void addToList() {
        int pos2;
        int pos1;
        String URL_SENDUNGEN = "http://www.mdr.de/mediathek/fernsehen/a-z/index.html";
        String MUSTER = "<a href=\"/mediathek/fernsehen/a-z/sendungenabisz100_inheritancecontext-header_letter";
        String MUSTER_ADD = "http://www.mdr.de/mediathek/fernsehen/a-z/sendungenabisz100_inheritancecontext-header_letter";
        String URL_TAGE = "http://www.mdr.de/mediathek/fernsehen/index.html";
        String MUSTER_TAGE = "<a href=\"/mediathek/fernsehen/sendung-verpasst--100_date-";
        String MUSTER_ADD_TAGE = "http://www.mdr.de/mediathek/fernsehen/sendung-verpasst--100_date-";
        MSStringBuilder seite = new MSStringBuilder(65536);
        this.listeThemen.clear();
        this.listeTage.clear();
        this.listeGesucht.clear();
        this.meldungStart();
        GetUrl getUrlIo = new GetUrl(this.getWartenSeiteLaden());
        seite = getUrlIo.getUri_Utf(SENDERNAME, "http://www.mdr.de/mediathek/fernsehen/a-z/index.html", seite, "");
        int pos = 0;
        String url = "";
        while ((pos = seite.indexOf("<a href=\"/mediathek/fernsehen/a-z/sendungenabisz100_inheritancecontext-header_letter", pos)) != -1) {
            pos1 = pos += "<a href=\"/mediathek/fernsehen/a-z/sendungenabisz100_inheritancecontext-header_letter".length();
            pos2 = seite.indexOf("\"", pos);
            if (pos1 != -1 && pos2 != -1) {
                url = seite.substring(pos1, pos2);
            }
            if (url.isEmpty()) {
                Log.errorLog((int)889216307, (String)"keine URL");
                continue;
            }
            url = "http://www.mdr.de/mediathek/fernsehen/a-z/sendungenabisz100_inheritancecontext-header_letter" + url;
            if (url.contains("#")) {
                url = url.substring(0, url.indexOf(35));
            }
            this.listeThemen.addUrl(new String[]{url});
        }
        seite = getUrlIo.getUri_Utf(SENDERNAME, "http://www.mdr.de/mediathek/fernsehen/index.html", seite, "");
        pos = 0;
        url = "";
        while ((pos = seite.indexOf("<a href=\"/mediathek/fernsehen/sendung-verpasst--100_date-", pos)) != -1) {
            pos1 = pos += "<a href=\"/mediathek/fernsehen/sendung-verpasst--100_date-".length();
            pos2 = seite.indexOf("\"", pos);
            if (pos1 != -1 && pos2 != -1) {
                url = seite.substring(pos1, pos2);
            }
            if (url.isEmpty()) {
                Log.errorLog((int)461225808, (String)"keine URL");
                continue;
            }
            url = "http://www.mdr.de/mediathek/fernsehen/sendung-verpasst--100_date-" + url;
            assert (this.istInListe(this.listeTage, url) == this.listeTage.contains(url));
            if (this.istInListe(this.listeTage, url)) continue;
            this.listeTage.add(url);
        }
        if (Config.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.isEmpty() && this.listeTage.isEmpty()) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size() + this.listeTage.size());
            MediathekMdr.listeSort(this.listeThemen, 0);
            for (int t = 0; t < this.getMaxThreadLaufen(); ++t) {
                ThemaLaden th = new ThemaLaden();
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    @Override
    public void clear() {
        this.listeThemen.clear();
        this.listeTage.clear();
        this.listeGesucht.clear();
    }

    private String convertDatumXml(String datum) {
        try {
            SimpleDateFormat sdfIn = new SimpleDateFormat("dd.MM.yyyy HH:mm");
            Date filmDate = sdfIn.parse(datum);
            SimpleDateFormat sdfOut = new SimpleDateFormat("dd.MM.yyyy");
            datum = sdfOut.format(filmDate);
        }
        catch (Exception ex) {
            Log.errorLog((int)435209987, (Exception)ex);
        }
        return datum;
    }

    private String convertZeitXml(String datum) {
        try {
            SimpleDateFormat sdfIn = new SimpleDateFormat("dd.MM.yyyy HH:mm");
            Date filmDate = sdfIn.parse(datum);
            SimpleDateFormat sdfOut = new SimpleDateFormat("HH:mm:ss");
            datum = sdfOut.format(filmDate);
        }
        catch (Exception ex) {
            Log.errorLog((int)102658736, (Exception)ex);
        }
        return datum;
    }

    private synchronized String getListeTage() {
        return this.listeTage.pollFirst();
    }

    private synchronized boolean existiertSchon(String thema, String titel, String datum, String zeit) {
        boolean gefunden = false;
        for (String[] k : this.listeGesucht) {
            if (!k[0].equalsIgnoreCase(thema) || !k[1].equalsIgnoreCase(titel) || !k[2].equalsIgnoreCase(datum) || !k[3].equalsIgnoreCase(zeit)) continue;
            gefunden = true;
        }
        if (!gefunden) {
            this.listeGesucht.add(new String[]{thema, titel, datum, zeit});
        }
        return gefunden;
    }

    private class ThemaLaden
    extends Thread {
        private final GetUrl getUrl;
        private MSStringBuilder seite1;
        private MSStringBuilder seiteTage;
        private MSStringBuilder seite2;
        private MSStringBuilder seite3;
        private MSStringBuilder seite4;

        private ThemaLaden() {
            this.getUrl = new GetUrl(MediathekMdr.this.getWartenSeiteLaden());
            this.seite1 = new MSStringBuilder(65536);
            this.seiteTage = new MSStringBuilder(65536);
            this.seite2 = new MSStringBuilder(65536);
            this.seite3 = new MSStringBuilder(65536);
            this.seite4 = new MSStringBuilder(65536);
        }

        @Override
        public void run() {
            try {
                String url;
                String[] link;
                MediathekMdr.this.meldungAddThread();
                while (!Config.getStop() && (link = MediathekMdr.this.listeThemen.getListeThemen()) != null) {
                    MediathekMdr.this.meldungProgress(link[0]);
                    this.addThema(link[0]);
                }
                while (!Config.getStop() && (url = MediathekMdr.this.getListeTage()) != null) {
                    MediathekMdr.this.meldungProgress(url);
                    this.addTage(url);
                }
            }
            catch (Exception ex) {
                Log.errorLog((int)115896304, (Exception)ex);
            }
            MediathekMdr.this.meldungThreadUndFertig();
        }

        private void addThema(String strUrlFeed) {
            String MUSTER = "<div class=\"media mediaA \">";
            int pos = 0;
            String url = "";
            try {
                this.seite1 = this.getUrl.getUri(MediathekMdr.SENDERNAME, strUrlFeed, StandardCharsets.UTF_8, 2, this.seite1, "");
                while (!Config.getStop() && (pos = this.seite1.indexOf("<div class=\"media mediaA \">", pos)) != -1) {
                    url = this.seite1.extract("<a href=\"", "\"", pos += "<div class=\"media mediaA \">".length());
                    String thema = this.seite1.extract(" class=\"headline\" title=\"\">", "<", pos);
                    if (url.isEmpty()) {
                        Log.errorLog((int)952136547, (String)("keine URL: " + strUrlFeed));
                        continue;
                    }
                    if (url.startsWith("http")) continue;
                    MediathekMdr.this.meldung(url);
                    url = "http://www.mdr.de" + url;
                    this.addSendugen(strUrlFeed, thema, url);
                }
                if (url.isEmpty()) {
                    Log.errorLog((int)766250249, (String)("keine URL: " + strUrlFeed));
                }
            }
            catch (Exception ex) {
                Log.errorLog((int)316874602, (Exception)ex);
            }
        }

        private void addTage(String urlSeite) {
            String MUSTER = "<div class=\"media mediaA \">";
            int pos = 0;
            String url = "";
            try {
                this.seiteTage = this.getUrl.getUri(MediathekMdr.SENDERNAME, urlSeite, StandardCharsets.UTF_8, 2, this.seiteTage, "");
                while (!Config.getStop() && (pos = this.seiteTage.indexOf("<div class=\"media mediaA \">", pos)) != -1) {
                    url = this.seiteTage.extract("<a href=\"/mediathek/", "\"", pos += "<div class=\"media mediaA \">".length());
                    String thema = this.seiteTage.extract(" class=\"headline\" title=\"\">", "<", pos);
                    if (url.isEmpty()) {
                        Log.errorLog((int)975401478, (String)("keine URL: " + urlSeite));
                        continue;
                    }
                    MediathekMdr.this.meldung(url);
                    url = "http://www.mdr.de/mediathek/" + url;
                    this.addSendug(urlSeite, thema, url);
                }
                if (url.isEmpty()) {
                    Log.errorLog((int)930215470, (String)("keine URL: " + urlSeite));
                }
            }
            catch (Exception ex) {
                Log.errorLog((int)102540897, (Exception)ex);
            }
        }

        private void addSendugen(String strUrlFeed, String thema, String urlThema) {
            this.seite2 = this.getUrl.getUri(MediathekMdr.SENDERNAME, urlThema, StandardCharsets.UTF_8, 2, this.seite2, "Thema: " + thema);
            String muster = this.seite2.indexOf("div class=\"media mediaA \">") != -1 ? "div class=\"media mediaA \">" : "<span class=\"broadcastSeriesTitle\">";
            int pos = 0;
            int count = 0;
            String url = "";
            while ((pos = this.seite2.indexOf(muster, pos)) != -1) {
                if (!CrawlerTool.loadLongMax() && ++count > 5) {
                    return;
                }
                url = this.seite2.extract("<a href=\"/mediathek/fernsehen/a-z", "\"", pos += muster.length());
                if (url.isEmpty()) {
                    Log.errorLog((int)915263421, (String[])new String[]{"keine URL: " + urlThema, "Thema: " + thema, "UrlFeed: " + strUrlFeed});
                    continue;
                }
                url = "http://www.mdr.de/mediathek/fernsehen/a-z" + url;
                this.addSendug(strUrlFeed, thema, url);
            }
            if (url.isEmpty()) {
                Log.errorLog((int)765213014, (String[])new String[]{"keine URL: " + urlThema, "Thema: " + thema, "UrlFeed: " + strUrlFeed});
            }
        }

        private void addSendug(String strUrlFeed, String thema, String urlSendung) {
            String MUSTER_XML = "'playerXml':'";
            String MUSTER_ADD = "http://www.mdr.de";
            this.seite3 = this.getUrl.getUri_Utf(MediathekMdr.SENDERNAME, urlSendung, this.seite3, "Thema: " + thema);
            int pos = 0;
            String url = "";
            int stop = this.seite3.indexOf("Meistgeklickt");
            while ((pos = this.seite3.indexOf("'playerXml':'", pos)) != -1 && (stop <= 0 || pos <= stop)) {
                int pos1 = pos += "'playerXml':'".length();
                int pos2 = this.seite3.indexOf("'", pos);
                if (pos2 != -1) {
                    url = this.seite3.substring(pos1, pos2);
                }
                if (url.isEmpty()) {
                    Log.errorLog((int)256987304, (String[])new String[]{"keine URL: " + urlSendung, "Thema: " + thema, "UrlFeed: " + strUrlFeed});
                    continue;
                }
                url = url.replace("\\", "");
                url = "http://www.mdr.de" + url;
                this.addXml(strUrlFeed, thema, url, urlSendung);
            }
            if (url.isEmpty()) {
                Log.errorLog((int)256987304, (String[])new String[]{"keine URL: " + urlSendung, "Thema: " + thema, "UrlFeed: " + strUrlFeed});
            }
        }

        private void addXml(String strUrlFeed, String thema, String xmlSite, String filmSite) {
            String MUSTER_URL_MP4 = "<progressiveDownloadUrl>";
            try {
                this.seite4 = this.getUrl.getUri_Utf(MediathekMdr.SENDERNAME, xmlSite, this.seite4, "Thema: " + thema);
                if (this.seite4.length() == 0) {
                    Log.errorLog((int)903656532, (String)xmlSite);
                    return;
                }
                long duration = 0L;
                try {
                    String d = this.seite4.extract("<duration>", "<");
                    if (!d.isEmpty()) {
                        String[] parts = d.split(":");
                        duration = 0L;
                        long power = 1L;
                        for (int i = parts.length - 1; i >= 0; --i) {
                            duration += Long.parseLong(parts[i]) * power;
                            power *= 60L;
                        }
                    }
                }
                catch (Exception ex) {
                    Log.errorLog((int)313698749, (Exception)ex, (String)xmlSite);
                }
                String titel = this.seite4.extract("<title>", "<");
                String description = this.seite4.extract("<teaserText>", "<");
                String subtitle = this.seite4.extract("<videoSubtitleUrl>", "<");
                String datum = this.seite4.extract("<broadcastStartDate>", "<");
                if (datum.isEmpty()) {
                    datum = this.seite4.extract("<datetimeOfBroadcasting>", "<");
                }
                if (datum.isEmpty()) {
                    datum = this.seite4.extract("<webTime>", "<");
                }
                String zeit = MediathekMdr.this.convertZeitXml(datum);
                datum = MediathekMdr.this.convertDatumXml(datum);
                String urlSendung = this.seite4.extract("<htmlUrl>", "<");
                if (urlSendung.isEmpty()) {
                    urlSendung = filmSite;
                }
                String urlHD = this.seite4.extract("| 1280x720", "<progressiveDownloadUrl>", "<");
                String urlMp4 = this.seite4.extract("| 960x540", "<progressiveDownloadUrl>", "<");
                if (urlMp4.isEmpty()) {
                    urlMp4 = this.seite4.extract("| MP4 Web L+ |", "<progressiveDownloadUrl>", "<");
                }
                String urlMp4_klein = this.seite4.extract("| 512x288", "<progressiveDownloadUrl>", "<");
                if (urlMp4.isEmpty()) {
                    urlMp4 = urlMp4_klein;
                    urlMp4_klein = "";
                }
                if (urlMp4.isEmpty()) {
                    Log.errorLog((int)326541230, (String[])new String[]{"keine URL: " + xmlSite, "Thema: " + thema, " UrlFeed: " + strUrlFeed});
                } else if (!MediathekMdr.this.existiertSchon(thema, titel, datum, zeit)) {
                    MediathekMdr.this.meldung(urlMp4);
                    DatenFilm film = new DatenFilm(MediathekMdr.SENDERNAME, thema, urlSendung, titel, urlMp4, "", datum, zeit, duration, description);
                    CrawlerTool.addUrlKlein(film, urlMp4_klein, "");
                    CrawlerTool.addUrlHd(film, urlHD, "");
                    CrawlerTool.addUrlSubtitle(film, subtitle);
                    MediathekMdr.this.addFilm(film);
                }
            }
            catch (Exception ex) {
                Log.errorLog((int)446286970, (Exception)ex);
            }
        }
    }
}

