/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender;

import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.tool.GermanStringSorter;
import de.mediathekview.mlib.tool.Log;
import de.mediathekview.mlib.tool.MVHttpClient;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import mServer.crawler.CrawlerTool;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.RunSender;
import mServer.crawler.sender.newsearch.GeoLocations;
import okhttp3.Request;
import okhttp3.Response;

public abstract class MediathekReader
extends Thread {
    private final String sendername;
    private final int maxThreadLaufen;
    private final int wartenSeiteLaden;
    private final int startPrio;
    protected LinkedListUrl listeThemen;
    protected FilmeSuchen mlibFilmeSuchen;
    private int threads;
    private int max;
    private int progress;

    public MediathekReader(FilmeSuchen aMSearchFilmeSuchen, String aSendername, int aSenderMaxThread, int aSenderWartenSeiteLaden, int aStartPrio) {
        this.mlibFilmeSuchen = aMSearchFilmeSuchen;
        this.maxThreadLaufen = aSenderMaxThread;
        this.wartenSeiteLaden = aSenderWartenSeiteLaden;
        this.startPrio = aStartPrio;
        this.sendername = aSendername;
        this.threads = 0;
        this.max = 0;
        this.progress = 0;
        this.listeThemen = new LinkedListUrl();
    }

    public static boolean urlExists(String url) {
        if (!url.toLowerCase().startsWith("http")) {
            return false;
        }
        Request request = new Request.Builder().url(url).head().build();
        boolean result = false;
        try (Response response = MVHttpClient.getInstance().getReducedTimeOutClient().newCall(request).execute();){
            if (response.isSuccessful()) {
                result = true;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            result = false;
        }
        return result;
    }

    protected static void listeSort(LinkedList<String[]> liste, int stelle) {
        GermanStringSorter sorter = GermanStringSorter.getInstance();
        if (liste != null) {
            for (int i = 1; i < liste.size(); ++i) {
                String str2;
                String str1;
                for (int k = i; k > 0 && sorter.compare(str1 = liste.get(k - 1)[stelle], str2 = liste.get(k)[stelle]) > 0; --k) {
                    liste.add(k - 1, liste.remove(k));
                }
            }
        }
    }

    protected static long extractDuration(String dauer) {
        long dauerInSeconds = 0L;
        if (dauer.isEmpty()) {
            return 0L;
        }
        try {
            if (dauer.contains("min")) {
                dauer = dauer.replace("min", "").trim();
                dauerInSeconds = Long.parseLong(dauer) * 60L;
            } else {
                String[] parts = dauer.split(":");
                long power = 1L;
                for (int i = parts.length - 1; i >= 0; --i) {
                    dauerInSeconds += Long.parseLong(parts[i]) * power;
                    power *= 60L;
                }
            }
        }
        catch (Exception ex) {
            return 0L;
        }
        return dauerInSeconds;
    }

    protected static long extractDurationSec(String dauer) {
        long dauerInSeconds;
        if (dauer.isEmpty()) {
            return 0L;
        }
        try {
            dauerInSeconds = Long.parseLong(dauer);
        }
        catch (Exception ex) {
            return 0L;
        }
        return dauerInSeconds;
    }

    public String getSendername() {
        return this.sendername;
    }

    public int getMaxThreadLaufen() {
        return this.maxThreadLaufen;
    }

    public int getWartenSeiteLaden() {
        return this.wartenSeiteLaden;
    }

    public int getMax() {
        return this.max;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getStartPrio() {
        return this.startPrio;
    }

    public int getThreads() {
        return this.threads;
    }

    public boolean checkNameSenderFilmliste(String name) {
        return this.getSendername().equalsIgnoreCase(name);
    }

    public void clear() {
    }

    @Override
    public void run() {
        try {
            this.threads = 0;
            this.addToList();
        }
        catch (Exception ex) {
            Log.errorLog((int)397543600, (Exception)ex, (String)this.getSendername());
        }
    }

    protected abstract void addToList();

    protected void addFilm(DatenFilm film, boolean urlPruefen) {
        if (urlPruefen) {
            if (this.mlibFilmeSuchen.listeFilmeNeu.getFilmByUrl(film.arr[14]) == null) {
                this.addFilm(film);
            }
        } else {
            this.addFilm(film);
        }
    }

    protected void addFilm(DatenFilm film) {
        film.setFileSize();
        this.upgradeUrl(film);
        film.setUrlHistory();
        this.setGeo(film);
        if (this.mlibFilmeSuchen.listeFilmeNeu.addFilmVomSender(film)) {
            FilmeSuchen.listeSenderLaufen.inc(film.arr[1], RunSender.Count.FILME);
        }
    }

    private void processArd(DatenFilm film) {
        if (film.arr[14].startsWith("http://mvideos-geo.daserste.de/") || film.arr[14].startsWith("http://media.ndr.de/progressive_geo/") || film.arr[14].startsWith("http://mediandr-a.akamaihd.net//progressive_geo/") || film.arr[14].startsWith("https://pdodswr-a.akamaihd.net/swr/geo/de/") || film.arr[14].startsWith("http://mediandr-a.akamaihd.net/progressive_geo") || film.arr[14].startsWith("http://cdn-storage.br.de/geo/") || film.arr[14].startsWith("http://cdn-sotschi.br.de/geo/b7/") || film.arr[14].startsWith("https://cdn-storage.br.de/geo/") || film.arr[14].startsWith("https://cdn-sotschi.br.de/geo/b7/") || film.arr[14].startsWith("http://pd-ondemand.swr.de/geo/de/") || film.arr[14].startsWith("http://ondemandgeo.mdr.de/") || film.arr[14].startsWith("http://ondemand-de.wdr.de/") || film.arr[14].startsWith("http://wdr_fs_geo-lh.akamaihd.net") || film.arr[14].startsWith("http://adaptiv.wdr.de/i/medp/de/") || film.arr[14].startsWith("http://wdradaptiv-vh.akamaihd.net/i/medp/ondemand/de/") || film.arr[14].startsWith("http://wdrmedien-a.akamaihd.net/medp/ondemand/de/") || film.arr[14].startsWith("http://pd-videos.daserste.de/de/") || film.arr[14].startsWith("https://pdvideosdaserste-a.akamaihd.net/de/") || film.arr[14].startsWith("https://odgeomdr-a.akamaihd.net/")) {
            film.arr[13] = "DE";
        }
        if (film.arr[14].startsWith("http://ondemand-dach.wdr.de/") || film.arr[14].startsWith("http://wdradaptiv-vh.akamaihd.net/i/medp/ondemand/dach/") || film.arr[14].startsWith("http://wdrmedien-a.akamaihd.net/medp/ondemand/dach/") || film.arr[14].startsWith("http://adaptiv.wdr.de/i/medp/dach/")) {
            film.arr[13] = GeoLocations.GEO_DE_AT_CH.getDescription();
        }
    }

    private void processZdfPart(DatenFilm film) {
        if (film.arr[14].startsWith("http://rodl.zdf.de/de/") || film.arr[14].startsWith("http://nrodl.zdf.de/de/") || film.arr[14].startsWith("https://rodlzdf-a.akamaihd.net/de/") || film.arr[14].startsWith("https://nrodlzdf-a.akamaihd.net/de/")) {
            film.arr[13] = "DE";
        } else if (film.arr[14].startsWith("http://rodl.zdf.de/dach/") || film.arr[14].startsWith("http://nrodl.zdf.de/dach/") || film.arr[14].startsWith("https://rodlzdf-a.akamaihd.net/dach") || film.arr[14].startsWith("https://nrodlzdf-a.akamaihd.net/dach")) {
            film.arr[13] = "DE-AT-CH";
        } else if (film.arr[14].startsWith("http://rodl.zdf.de/ebu/") || film.arr[14].startsWith("http://nrodl.zdf.de/ebu/") || film.arr[14].startsWith("https://rodlzdf-a.akamaihd.net/ebu/") || film.arr[14].startsWith("https://nrodlzdf-a.akamaihd.net/ebu/")) {
            film.arr[13] = "DE-AT-CH-EU";
        }
    }

    private void processSrfPodcast(DatenFilm film) {
        if (film.arr[14].startsWith("http://podcasts.srf.ch/ch/audio/")) {
            film.arr[13] = "CH";
        }
    }

    private void processOrf(DatenFilm film) {
        if (film.arr[14].contains("/cms-austria")) {
            film.arr[13] = "AT";
        }
    }

    private void processKiKa(DatenFilm film) {
        if (film.arr[14].startsWith("http://pmdgeo.kika.de/") || film.arr[14].startsWith("https://pmdgeokika-a.akamaihd.net/") || film.arr[14].startsWith("http://kika_geo-lh.akamaihd.net")) {
            film.arr[13] = "DE";
        }
    }

    private void setGeo(DatenFilm film) {
        switch (film.arr[1]) {
            case "ARD": 
            case "WDR": 
            case "NDR": 
            case "SWR": 
            case "MDR": 
            case "BR": {
                this.processArd(film);
                break;
            }
            case "ZDF-tivi": 
            case "3Sat": {
                this.processZdfPart(film);
                break;
            }
            case "ORF": {
                this.processOrf(film);
                break;
            }
            case "SRF.Podcast": {
                this.processSrfPodcast(film);
                break;
            }
            case "KiKA": {
                this.processKiKa(film);
            }
        }
    }

    boolean istInListe(LinkedList<String[]> liste, String str, int nr) {
        Optional<String[]> opt = liste.parallelStream().filter(f -> f[nr].equals(str)).findAny();
        return opt.isPresent();
    }

    boolean istInListe(LinkedList<String> liste, String str) {
        Optional<String> opt = liste.parallelStream().filter(f -> f.equals(str)).findAny();
        return opt.isPresent();
    }

    protected synchronized void meldungStart() {
        this.max = 0;
        this.progress = 0;
        Log.sysLog((String)"===============================================================");
        Log.sysLog((String)("Starten[" + (CrawlerTool.loadLongMax() ? "alles" : "update") + "] " + this.getSendername() + ": " + new SimpleDateFormat("HH:mm:ss").format(new Date())));
        Log.sysLog((String)("   maxThreadLaufen: " + this.getMaxThreadLaufen()));
        Log.sysLog((String)("   wartenSeiteLaden: " + this.getWartenSeiteLaden()));
        Log.sysLog((String)"");
        RunSender runSender = this.mlibFilmeSuchen.melden(this.getSendername(), this.getMax(), this.getProgress(), "");
        runSender.maxThreads = this.getMaxThreadLaufen();
        runSender.waitOnLoad = this.getWartenSeiteLaden();
    }

    protected synchronized void meldungAddMax(int mmax) {
        this.max += mmax;
        this.mlibFilmeSuchen.melden(this.getSendername(), this.getMax(), this.getProgress(), "");
    }

    protected synchronized void meldungAddThread() {
        ++this.threads;
        this.mlibFilmeSuchen.melden(this.getSendername(), this.getMax(), this.getProgress(), "");
    }

    public synchronized void meldungProgress(String text) {
        ++this.progress;
        this.mlibFilmeSuchen.melden(this.getSendername(), this.getMax(), this.getProgress(), text);
    }

    protected synchronized void meldung(String text) {
        this.mlibFilmeSuchen.melden(this.getSendername(), this.getMax(), this.getProgress(), text);
    }

    protected synchronized void meldungThreadUndFertig() {
        --this.threads;
        if (this.getThreads() <= 0) {
            this.mlibFilmeSuchen.meldenFertig(this.getSendername());
        } else {
            this.mlibFilmeSuchen.melden(this.getSendername(), this.getMax(), this.getProgress(), "");
        }
    }

    private void upgradeUrl(DatenFilm film) {
        String to;
        String from;
        if (film.isHD()) {
            return;
        }
        if (film.arr[14].startsWith("http://media.ndr.de") && film.arr[14].endsWith(".hq.mp4")) {
            from = film.arr[14];
            to = film.arr[14].replace(".hq.mp4", ".hd.mp4");
            this.updateHd(from, to, film);
        }
        if (film.arr[14].startsWith("http://cdn-storage.br.de") && film.arr[14].endsWith("_C.mp4")) {
            from = film.arr[14];
            to = film.arr[14].replace("_C.mp4", "_X.mp4");
            this.updateHd(from, to, film);
        }
        if (film.arr[14].startsWith("http://pd-ondemand.swr.de") && film.arr[14].endsWith(".l.mp4")) {
            from = film.arr[14];
            to = film.arr[14].replace(".l.mp4", ".xl.mp4");
            this.updateHd(from, to, film);
        }
    }

    private void updateHd(String from, String to, DatenFilm film) {
        if (film.arr[22].isEmpty() && film.arr[14].endsWith(from)) {
            String url_ = film.arr[14].substring(0, film.arr[14].lastIndexOf(from)) + to;
            if (MediathekReader.urlExists(url_)) {
                CrawlerTool.addUrlHd(film, url_, "");
            } else {
                Log.errorLog((int)945120347, (String)("upgradeUrl: " + from));
            }
        }
    }

    protected class LinkedListUrl
    extends LinkedList<String[]> {
        protected LinkedListUrl() {
        }

        synchronized boolean addUrl(String[] e) {
            if (!MediathekReader.this.istInListe(this, e[0], 0)) {
                return this.add(e);
            }
            return false;
        }

        public synchronized String[] getListeThemen() {
            return (String[])this.pollFirst();
        }
    }

    class HashSetUrl
    extends HashSet<String[]> {
        HashSetUrl() {
        }

        public synchronized boolean addUrl(String[] e) {
            return this.add(e);
        }

        public synchronized String[] getListeThemen() {
            String[] res = null;
            Iterator it = this.iterator();
            if (it.hasNext()) {
                res = (String[])it.next();
                this.remove(res);
            }
            return res;
        }
    }
}

