/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.arte;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.mediathekview.mlib.daten.DatenFilm;
import java.io.IOException;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.concurrent.Callable;
import mServer.crawler.CrawlerTool;
import mServer.crawler.sender.arte.ArteHttpClient;
import mServer.crawler.sender.arte.ArteVideoDTO;
import mServer.crawler.sender.arte.ArteVideoDeserializer;
import mServer.crawler.sender.arte.ArteVideoDetailsDTO;
import mServer.crawler.sender.arte.ArteVideoDetailsDeserializer;
import mServer.crawler.sender.newsearch.GeoLocations;
import mServer.crawler.sender.newsearch.Qualities;
import mServer.tool.MserverDatumZeit;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArteProgramIdToDatenFilmCallable
implements Callable<DatenFilm> {
    private static final Logger LOG = LogManager.getLogger(ArteProgramIdToDatenFilmCallable.class);
    private static final String ARTE_VIDEO_INFORMATION_URL_PATTERN = "https://api.arte.tv/api/player/v1/config/%s/%s?platform=ARTE_NEXT";
    private static final String ARTE_VIDEO_INFORMATION_URL_PATTERN_2 = "https://api.arte.tv/api/opa/v3/programs/%s/%s";
    private final FastDateFormat broadcastDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ssX");
    private final String programId;
    private final String langCode;
    private final String senderName;
    private final Calendar today;

    public ArteProgramIdToDatenFilmCallable(String aProgramId, String aLangCode, String aSenderName) {
        this.programId = aProgramId;
        this.langCode = aLangCode;
        this.senderName = aSenderName;
        this.today = Calendar.getInstance();
    }

    @Override
    public DatenFilm call() throws Exception {
        DatenFilm film = null;
        Gson gson = new GsonBuilder().registerTypeAdapter(ArteVideoDTO.class, (Object)new ArteVideoDeserializer()).registerTypeAdapter(ArteVideoDetailsDTO.class, (Object)new ArteVideoDetailsDeserializer(this.today)).create();
        String videosUrl = String.format(ARTE_VIDEO_INFORMATION_URL_PATTERN, this.langCode, this.programId);
        ArteVideoDTO video = ArteHttpClient.executeRequest(LOG, gson, videosUrl, ArteVideoDTO.class);
        if (video != null) {
            LocalTime durationAsTime = this.durationAsTime(video.getDurationInSeconds());
            if (video.getVideoUrls().containsKey((Object)Qualities.NORMAL)) {
                ArteVideoDetailsDTO details = this.getVideoDetails(gson, this.programId);
                if (details != null) {
                    film = this.createFilm(details.getTheme(), details.getWebsite(), details.getTitle(), video, details, durationAsTime, details.getDescription());
                }
            } else {
                LOG.debug(String.format("Keine \"normale\" Video URL f\u00fcr den Film \"%s\"", this.programId));
            }
        }
        return film;
    }

    private ArteVideoDetailsDTO getVideoDetails(Gson gson, String programId) throws IOException {
        String videosUrlVideoDetails2 = String.format(ARTE_VIDEO_INFORMATION_URL_PATTERN_2, this.langCode, programId);
        ArteVideoDetailsDTO details = ArteHttpClient.executeRequest(LOG, gson, videosUrlVideoDetails2, ArteVideoDetailsDTO.class);
        return details;
    }

    private DatenFilm createFilm(String thema, String urlWeb, String titel, ArteVideoDTO video, ArteVideoDetailsDTO details, LocalTime durationAsTime, String beschreibung) {
        String broadcastBegin = details.getBroadcastBegin();
        String date = MserverDatumZeit.formatDate(broadcastBegin, this.broadcastDateFormat);
        String time = MserverDatumZeit.formatTime(broadcastBegin, this.broadcastDateFormat);
        DatenFilm film = new DatenFilm(this.senderName, thema, urlWeb, titel, video.getUrl(Qualities.NORMAL), "", date, time, (long)durationAsTime.toSecondOfDay(), beschreibung);
        if (video.getVideoUrls().containsKey((Object)Qualities.HD)) {
            CrawlerTool.addUrlHd(film, video.getUrl(Qualities.HD), "");
        }
        if (video.getVideoUrls().containsKey((Object)Qualities.SMALL)) {
            CrawlerTool.addUrlKlein(film, video.getUrl(Qualities.SMALL), "");
        }
        if (details.getGeoLocation() != GeoLocations.GEO_NONE) {
            film.arr[13] = details.getGeoLocation().getDescription();
        }
        return film;
    }

    private LocalTime durationAsTime(long aDurationInSeconds) {
        LocalTime localTime = LocalTime.MIN;
        localTime = localTime.plusSeconds(aDurationInSeconds);
        return localTime;
    }
}

