/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.hr;

import java.util.ArrayList;
import java.util.List;
import mServer.crawler.sender.MediathekReader;
import mServer.crawler.sender.hr.HrSendungenDto;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HrSendungenListDeserializer {
    private static final String QUERY_SENDUNG_LINK = "a.c-teaser__headlineLink";
    private static final String QUERY_SENDUNG_THEME = "span.c-teaser__headline";
    private static final String HTML_ATTRIBUTE_HREF = "href";

    public List<HrSendungenDto> deserialize(Document document) {
        ArrayList<HrSendungenDto> dtos = new ArrayList<HrSendungenDto>();
        Elements elements = document.select(QUERY_SENDUNG_LINK);
        elements.forEach(element -> {
            String theme = "";
            String url = element.attr(HTML_ATTRIBUTE_HREF);
            Element headlineElement = element.select(QUERY_SENDUNG_THEME).first();
            if (headlineElement != null) {
                theme = headlineElement.text();
            }
            if (!url.contains("daserste")) {
                HrSendungenDto dto = new HrSendungenDto();
                dto.setTheme(theme);
                dto.setUrl(this.prepareUrl(theme, url));
                dtos.add(dto);
            }
        });
        return dtos;
    }

    private String prepareUrl(String theme, String url) {
        if (theme.contains("hessenschau")) {
            return "http://www.hessenschau.de/tv-sendung/sendungsarchiv/index.html";
        }
        String preparedUrl = url.replaceAll("index.html", "sendungen/index.html");
        if (MediathekReader.urlExists(preparedUrl)) {
            return preparedUrl;
        }
        return url;
    }
}

