/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.orf.tasks;

import de.mediathekview.mlib.tool.Log;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import mServer.crawler.sender.MediathekReader;
import mServer.crawler.sender.orf.CrawlerUrlDTO;
import mServer.crawler.sender.orf.tasks.AbstractUrlTask;
import org.jsoup.HttpStatusException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public abstract class AbstractDocumentTask<T, D extends CrawlerUrlDTO>
extends AbstractUrlTask<T, D> {
    private static final long serialVersionUID = -4124779055395250981L;
    private static final String LOAD_DOCUMENT_HTTPERROR = "Some HTTP error happened while crawl the %s page \"%s\".";

    public AbstractDocumentTask(MediathekReader aCrawler, ConcurrentLinkedQueue<D> aUrlToCrawlDTOs) {
        super(aCrawler, aUrlToCrawlDTOs);
    }

    protected abstract void processDocument(D var1, Document var2);

    @Override
    protected void processElement(D aUrlDTO) {
        try {
            Document document = Jsoup.connect((String)((CrawlerUrlDTO)aUrlDTO).getUrl()).maxBodySize(0).get();
            this.processDocument(aUrlDTO, document);
        }
        catch (HttpStatusException httpStatusError) {
            Log.sysLog((String)String.format(LOAD_DOCUMENT_HTTPERROR, this.crawler.getSendername(), ((CrawlerUrlDTO)aUrlDTO).getUrl()));
            Log.errorLog((int)96459855, (String)(this.crawler.getSendername() + ": crawlerDocumentLoadError: " + ((CrawlerUrlDTO)aUrlDTO).getUrl() + ", " + httpStatusError.getStatusCode()));
        }
        catch (IOException ioException) {
            Log.errorLog((int)96459856, (Exception)ioException);
        }
    }
}

