/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.phoenix.parser;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.Optional;
import mServer.crawler.sender.orf.JsonUtils;
import mServer.crawler.sender.phoenix.parser.PhoenixFilmDetailDto;

public class PhoenixFilmDetailDeserializer
implements JsonDeserializer<Optional<PhoenixFilmDetailDto>> {
    private static final String ELEMENT_ABSAETZE = "absaetze";
    private static final String ELEMENT_BASENAME = "basename";
    private static final String ELEMENT_CANONICAL = "canonical";
    private static final String ELEMENT_META = "meta";
    private static final String ELEMENT_SUBTITLE = "subtitel";
    private static final String ELEMENT_TITLE = "titel";
    private static final String ELEMENT_TYP = "typ";
    private static final String ELEMENT_VORSPANN = "vorspann";
    private static final String TYP_VIDEO = "video-smubl";

    public Optional<PhoenixFilmDetailDto> deserialize(JsonElement aJsonElement, Type aType, JsonDeserializationContext aContext) {
        JsonObject jsonObject = aJsonElement.getAsJsonObject();
        Optional<String> topic = JsonUtils.getAttributeAsString(jsonObject, ELEMENT_TITLE);
        Optional<String> title = JsonUtils.getAttributeAsString(jsonObject, ELEMENT_SUBTITLE);
        Optional<String> description = JsonUtils.getAttributeAsString(jsonObject, ELEMENT_VORSPANN);
        Optional<String> baseName = this.parseBaseName(jsonObject);
        Optional<String> website = this.parseWebsite(jsonObject);
        if (!(topic.isPresent() && title.isPresent() && baseName.isPresent())) {
            return Optional.empty();
        }
        PhoenixFilmDetailDto dto = new PhoenixFilmDetailDto();
        dto.setBaseName(baseName.get());
        dto.setTopic(topic.get());
        dto.setTitle(title.get());
        description.ifPresent(dto::setDescription);
        website.ifPresent(dto::setWebsite);
        return Optional.of(dto);
    }

    private Optional<String> parseWebsite(JsonObject aJsonObject) {
        if (!aJsonObject.has(ELEMENT_META)) {
            return Optional.empty();
        }
        JsonObject absatzObject = aJsonObject.get(ELEMENT_META).getAsJsonObject();
        Optional<String> website = JsonUtils.getAttributeAsString(absatzObject, ELEMENT_CANONICAL);
        if (website.isPresent()) {
            return Optional.of(website.get().replace("backend.phoenix.de", "www.phoenix.de"));
        }
        return Optional.empty();
    }

    private Optional<String> parseBaseName(JsonObject aJsonObject) {
        if (!aJsonObject.has(ELEMENT_ABSAETZE)) {
            return Optional.empty();
        }
        JsonArray absatzArray = aJsonObject.get(ELEMENT_ABSAETZE).getAsJsonArray();
        for (JsonElement absatzElement : absatzArray) {
            JsonObject absatzObject;
            Optional<String> typ;
            if (absatzElement.isJsonNull() || !(typ = JsonUtils.getAttributeAsString(absatzObject = absatzElement.getAsJsonObject(), ELEMENT_TYP)).isPresent() || !TYP_VIDEO.equals(typ.get())) continue;
            return JsonUtils.getAttributeAsString(absatzObject, ELEMENT_BASENAME);
        }
        return Optional.empty();
    }
}

