/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.phoenix.tasks;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.ws.rs.client.WebTarget;
import mServer.crawler.sender.MediathekReader;
import mServer.crawler.sender.orf.CrawlerUrlDTO;
import mServer.crawler.sender.orf.tasks.AbstractRecursivConverterTask;
import mServer.crawler.sender.phoenix.SendungOverviewDto;
import mServer.crawler.sender.phoenix.parser.PhoenixSendungOverviewDeserializer;
import mServer.crawler.sender.phoenix.tasks.ZdfTaskBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhoenixOverviewTask
extends ZdfTaskBase<CrawlerUrlDTO, CrawlerUrlDTO> {
    private static final Logger LOG = LogManager.getLogger(PhoenixOverviewTask.class);
    private static final Type OPTIONAL_OVERVIEW_DTO_TYPE_TOKEN = new TypeToken<Optional<SendungOverviewDto>>(){}.getType();
    private final String baseUrl;
    private final int subpage;

    public PhoenixOverviewTask(MediathekReader aCrawler, ConcurrentLinkedQueue<CrawlerUrlDTO> aUrlToCrawlDtos, Optional<String> aAuthKey, String aBaseUrl) {
        this(aCrawler, aUrlToCrawlDtos, aAuthKey, aBaseUrl, 0);
    }

    public PhoenixOverviewTask(MediathekReader aCrawler, ConcurrentLinkedQueue<CrawlerUrlDTO> aUrlToCrawlDtos, Optional<String> aAuthKey, String aBaseUrl, int aSubpage) {
        super(aCrawler, aUrlToCrawlDtos, aAuthKey);
        this.baseUrl = aBaseUrl;
        this.subpage = aSubpage;
        this.registerJsonDeserializer(OPTIONAL_OVERVIEW_DTO_TYPE_TOKEN, new PhoenixSendungOverviewDeserializer());
    }

    @Override
    protected void processRestTarget(CrawlerUrlDTO aDTO, WebTarget aTarget) {
        Optional overviewDtoOptional = this.deserializeOptional(aTarget, OPTIONAL_OVERVIEW_DTO_TYPE_TOKEN);
        if (!overviewDtoOptional.isPresent()) {
            LOG.fatal("PhoenixOverviewTask: error processing url " + aDTO.getUrl());
            return;
        }
        SendungOverviewDto overviewDto = (SendungOverviewDto)overviewDtoOptional.get();
        this.addResults(overviewDto.getUrls());
        if (overviewDto.getNextPageId().isPresent()) {
            this.taskResults.addAll((Collection)this.createNewOwnInstance(this.baseUrl + overviewDto.getNextPageId().get()).invoke());
        }
    }

    private void addResults(Collection<CrawlerUrlDTO> aUrls) {
        for (CrawlerUrlDTO url : aUrls) {
            this.taskResults.add(new CrawlerUrlDTO(this.baseUrl + url.getUrl()));
        }
    }

    @Override
    protected AbstractRecursivConverterTask<CrawlerUrlDTO, CrawlerUrlDTO> createNewOwnInstance(ConcurrentLinkedQueue<CrawlerUrlDTO> aElementsToProcess) {
        return new PhoenixOverviewTask(this.crawler, aElementsToProcess, this.authKey, this.baseUrl, this.subpage + 1);
    }

    private AbstractRecursivConverterTask<CrawlerUrlDTO, CrawlerUrlDTO> createNewOwnInstance(String aUrl) {
        ConcurrentLinkedQueue<CrawlerUrlDTO> queue = new ConcurrentLinkedQueue<CrawlerUrlDTO>();
        queue.add(new CrawlerUrlDTO(aUrl));
        return this.createNewOwnInstance(queue);
    }
}

