/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.br;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.RecursiveTask;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.RunSender;
import mServer.crawler.sender.MediathekReader;
import mServer.crawler.sender.br.BrIdsDTO;
import mServer.crawler.sender.br.BrSendungenIdsDeserializer;
import mServer.crawler.sender.br.BrSendungsFolgenTask;
import mServer.crawler.sender.br.BrWebAccessHelper;
import mServer.crawler.sender.br.WebAccessHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrAllSendungenTask
extends RecursiveTask<Set<String>> {
    private static final Logger LOG = LogManager.getLogger(BrAllSendungenTask.class);
    private static final long serialVersionUID = 8178190311832356223L;
    private static final String QUERY = "{\"query\":\"query SeriesIndexRefetchQuery(\\n  $seriesFilter: SeriesFilter\\n) {\\n  viewer {\\n    ...SeriesIndex_viewer_19SNIy\\n    id\\n  }\\n}\\n\\nfragment SeriesIndex_viewer_19SNIy on Viewer {\\n  seriesIndexAllSeries: allSeries(first: 1000, orderBy: TITLE_ASC, filter: $seriesFilter) {\\n    edges {\\n      node {\\n        __typename\\n        id\\n        title\\n        ...SeriesTeaserBox_node\\n        ...TeaserListItem_node\\n      }\\n    }\\n  }\\n}\\n\\nfragment SeriesTeaserBox_node on Node {\\n  __typename\\n  id\\n  ... on CreativeWorkInterface {\\n    ...TeaserImage_creativeWorkInterface\\n  }\\n  ... on SeriesInterface {\\n    ...SubscribeAction_series\\n    subscribed\\n    title\\n  }\\n}\\n\\nfragment TeaserListItem_node on Node {\\n  __typename\\n  id\\n  ... on CreativeWorkInterface {\\n    ...TeaserImage_creativeWorkInterface\\n  }\\n  ... on ClipInterface {\\n    title\\n  }\\n}\\n\\nfragment TeaserImage_creativeWorkInterface on CreativeWorkInterface {\\n  id\\n  kicker\\n  title\\n   }\\n\\nfragment SubscribeAction_series on SeriesInterface {\\n  id\\n  subscribed\\n}\\n\",\"variables\":{\"seriesFilter\":{\"title\":{\"startsWith\":\"*\"},\"audioOnly\":{\"eq\":false},\"status\":{\"id\":{\"eq\":\"Status:http://ard.de/ontologies/lifeCycle#published\"}}}}}";
    private final transient ForkJoinPool forkJoinPool;
    private final transient MediathekReader crawler;
    private BrIdsDTO allSendungen;

    public BrAllSendungenTask(MediathekReader aCrawler, ForkJoinPool aForkJoinPool) {
        this.crawler = aCrawler;
        this.forkJoinPool = aForkJoinPool;
    }

    private Set<String> getAllSendungenIds() {
        this.allSendungen = new BrIdsDTO();
        BrWebAccessHelper.handleWebAccessExecution(LOG, this.crawler, () -> {
            Gson gson = new GsonBuilder().registerTypeAdapter(BrIdsDTO.class, (Object)new BrSendungenIdsDeserializer()).create();
            String response = WebAccessHelper.getJsonResultFromPostAccess(new URL("https://proxy-base.master.mango.express/graphql"), QUERY);
            this.allSendungen = (BrIdsDTO)gson.fromJson(response, BrIdsDTO.class);
        });
        LOG.debug("BR Anzahl Sendungen: " + this.allSendungen.getIds().size());
        return this.allSendungen.getIds();
    }

    @Override
    protected Set<String> compute() {
        ConcurrentHashMap.KeySetView results = ConcurrentHashMap.newKeySet();
        try {
            Set<String> sendungenIds = this.getAllSendungenIds();
            ArrayList<Future> futureSendungsfolgenTasks = new ArrayList<Future>();
            for (String string : sendungenIds) {
                futureSendungsfolgenTasks.add(this.forkJoinPool.submit((Callable)new BrSendungsFolgenTask(this.crawler, string)));
            }
            for (ForkJoinTask forkJoinTask : futureSendungsfolgenTasks) {
                results.addAll((Collection)forkJoinTask.get());
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            LOG.error("Something wen't terrible wrong while getting the Folgen for a BR Sendung.", (Throwable)exception);
            FilmeSuchen.listeSenderLaufen.inc(this.crawler.getSendername(), RunSender.Count.FEHLER);
        }
        return results;
    }
}

