/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.br;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.mediathekview.mlib.daten.DatenFilm;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mServer.crawler.CrawlerTool;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.RunSender;
import mServer.crawler.sender.MediathekReader;
import mServer.crawler.sender.br.BrUrlDTO;
import mServer.crawler.sender.br.Resolution;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrFilmDeserializer
implements JsonDeserializer<Optional<DatenFilm>> {
    private static final String ERROR_NO_START_TEMPLATE = "The BR film \"%s - %s\" has no broadcast start so it will using the actual date and time.";
    private static final String HD = "HD";
    private static final String FILM_WEBSITE_TEMPLATE = "%s/video/%s";
    private static final String ERROR_MISSING_DETAIL_TEMPLATE = "A BR film can't be created because of missing details. The JSON element \"%s\" is missing.";
    private static final Logger LOG = LogManager.getLogger(BrFilmDeserializer.class);
    private static final String JSON_ELEMENT_DATA = "data";
    private static final String JSON_ELEMENT_VIEWER = "viewer";
    private static final String JSON_ELEMENT_CLIP = "clip";
    private static final String JSON_ELEMENT_VIDEO_FILES = "videoFiles";
    private static final String JSON_ELEMENT_EDGES = "edges";
    private static final String JSON_ELEMENT_NODE = "node";
    private static final String JSON_ELEMENT_ID = "id";
    private static final String JSON_ELEMENT_CAPTION_FILES = "captionFiles";
    private static final String JSON_ELEMENT_EPISODEOF = "episodeOf";
    private static final String JSON_ELEMENT_DETAIL_CLIP = "detailClip";
    private static final String JSON_ELEMENT_TITLE = "title";
    private static final String JSON_ELEMENT_KICKER = "kicker";
    private static final String JSON_ELEMENT_DURATION = "duration";
    private static final String JSON_ELEMENT_BROADCASTS = "broadcasts";
    private static final String JSON_ELEMENT_START = "start";
    private static final String JSON_ELEMENT_SHORT_DESCRIPTION = "shortDescription";
    private static final String JSON_ELEMENT_DESCRIPTION = "description";
    private static final String JSON_ELEMENT_PUBLIC_LOCATION = "publicLocation";
    private static final String JSON_ELEMENT_VIDEO_PROFILE = "videoProfile";
    private static final String JSON_ELEMENT_WIDTH = "width";
    private static final ZoneId ZONE_ID = ZoneId.of("Europe/Berlin");
    private final MediathekReader crawler;
    private final String filmId;
    private final DateTimeFormatter dateFormatDatenFilm = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private final DateTimeFormatter timeFormatDatenFilm = DateTimeFormatter.ofPattern("HH:mm:ss");

    public BrFilmDeserializer(MediathekReader aCrawler, String aFilmId) {
        this.crawler = aCrawler;
        this.filmId = aFilmId;
    }

    public Optional<DatenFilm> deserialize(JsonElement aElement, Type aType, JsonDeserializationContext aContext) {
        try {
            Optional<JsonObject> viewer = this.getViewer(aElement.getAsJsonObject());
            if (viewer.isPresent()) {
                Optional<JsonObject> detailClip = this.getDetailClip(viewer.get());
                return this.buildFilm(detailClip, viewer.get());
            }
            this.printMissingDetails(JSON_ELEMENT_VIEWER);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOG.error("BR: A needed JSON element is JsonNull.", (Throwable)unsupportedOperationException);
            FilmeSuchen.listeSenderLaufen.inc(this.crawler.getSendername(), RunSender.Count.FEHLER);
        }
        return Optional.empty();
    }

    private String getDescriptions(JsonObject aDetailClip) {
        String description = "";
        if (aDetailClip.has(JSON_ELEMENT_DESCRIPTION) && !aDetailClip.get(JSON_ELEMENT_DESCRIPTION).isJsonNull()) {
            description = aDetailClip.get(JSON_ELEMENT_DESCRIPTION).getAsString();
        } else if (aDetailClip.has(JSON_ELEMENT_SHORT_DESCRIPTION) && !aDetailClip.get(JSON_ELEMENT_SHORT_DESCRIPTION).isJsonNull()) {
            description = aDetailClip.get(JSON_ELEMENT_SHORT_DESCRIPTION).getAsString();
        }
        return description;
    }

    private Map<Resolution, String> getUrls(JsonObject viewer) {
        HashMap<Resolution, String> urlMap = new HashMap<Resolution, String>();
        Set<BrUrlDTO> urls = this.edgesToUrls(viewer);
        if (!urls.isEmpty()) {
            List bestUrls = urls.stream().sorted(Comparator.comparingInt(BrUrlDTO::getWidth).reversed()).limit(3L).collect(Collectors.toList());
            for (int id = 0; id < bestUrls.size(); ++id) {
                Resolution resolution = Resolution.getResolutionFromArdAudioVideoOrdinalsByProfileName(((BrUrlDTO)bestUrls.get(id)).getVideoProfile());
                String url = ((BrUrlDTO)bestUrls.get(id)).getUrl();
                if (url == null || url.isEmpty() || urlMap.containsKey((Object)resolution)) continue;
                urlMap.put(resolution, url);
            }
        }
        return urlMap;
    }

    private Optional<DatenFilm> buildFilm(Optional<JsonObject> detailClip, JsonObject viewer) {
        if (detailClip.isPresent()) {
            String description = this.getDescriptions(detailClip.get());
            Map<Resolution, String> urls = this.getUrls(viewer);
            if (urls.containsKey((Object)Resolution.NORMAL) && MediathekReader.urlExists(urls.get((Object)Resolution.NORMAL))) {
                Optional<String> subTitle = this.getSubtitleUrl(viewer);
                Optional<DatenFilm> newFilm = this.createFilm(detailClip.get(), description, subTitle, urls);
                return newFilm;
            }
        } else {
            this.printMissingDetails(JSON_ELEMENT_DETAIL_CLIP);
        }
        return Optional.empty();
    }

    private Optional<String> getSubtitleUrl(JsonObject viewer) {
        JsonArray edges;
        JsonObject captionFiles;
        JsonObject clip;
        String subtitle = "";
        if (viewer.has(JSON_ELEMENT_CLIP) && (clip = viewer.getAsJsonObject(JSON_ELEMENT_CLIP)).has(JSON_ELEMENT_CAPTION_FILES) && (captionFiles = clip.getAsJsonObject(JSON_ELEMENT_CAPTION_FILES)).has(JSON_ELEMENT_EDGES) && (edges = captionFiles.getAsJsonArray(JSON_ELEMENT_EDGES)).size() > 0) {
            for (JsonElement edge : edges) {
                JsonObject node;
                if (!edge.getAsJsonObject().has(JSON_ELEMENT_NODE) || !(node = edge.getAsJsonObject().getAsJsonObject(JSON_ELEMENT_NODE)).has(JSON_ELEMENT_PUBLIC_LOCATION)) continue;
                String value = node.get(JSON_ELEMENT_PUBLIC_LOCATION).getAsString();
                if (subtitle.isEmpty()) {
                    subtitle = value;
                    continue;
                }
                if (!value.endsWith(".ttml")) continue;
                subtitle = value;
            }
        }
        if (!subtitle.isEmpty()) {
            return Optional.of(subtitle);
        }
        return Optional.empty();
    }

    private String getTheme(JsonObject aDetailClip) {
        JsonObject episodeOf;
        JsonElement element;
        String theme = "";
        if (aDetailClip.has(JSON_ELEMENT_EPISODEOF) && !(element = aDetailClip.get(JSON_ELEMENT_EPISODEOF)).isJsonNull() && (episodeOf = aDetailClip.getAsJsonObject(JSON_ELEMENT_EPISODEOF)).has(JSON_ELEMENT_TITLE)) {
            theme = episodeOf.get(JSON_ELEMENT_TITLE).getAsString();
        }
        if (theme.isEmpty()) {
            theme = aDetailClip.get(JSON_ELEMENT_KICKER).getAsString();
        }
        return theme;
    }

    private Optional<DatenFilm> createFilm(JsonObject aDetailClip, String aDescription, Optional<String> aSubTitle, Map<Resolution, String> aUrls) {
        Optional<JsonElement> start = this.getBroadcastStart(aDetailClip);
        if (aDetailClip.has(JSON_ELEMENT_TITLE) && aDetailClip.has(JSON_ELEMENT_KICKER) && aDetailClip.has(JSON_ELEMENT_DURATION)) {
            String timeValue;
            String dateValue;
            String title = aDetailClip.get(JSON_ELEMENT_TITLE).getAsString();
            String thema = this.getTheme(aDetailClip);
            if (start.isPresent()) {
                LocalDateTime time = this.toTime(start.get().getAsString());
                dateValue = time.format(this.dateFormatDatenFilm);
                timeValue = time.format(this.timeFormatDatenFilm);
            } else {
                LOG.debug(String.format(ERROR_NO_START_TEMPLATE, thema, title));
                dateValue = "";
                timeValue = "";
            }
            Duration duration = this.toDuration(aDetailClip.get(JSON_ELEMENT_DURATION).getAsLong());
            String website = String.format(FILM_WEBSITE_TEMPLATE, "https://www.br.de/mediathek/", this.filmId);
            DatenFilm film = new DatenFilm("BR", thema, website, title, aUrls.get((Object)Resolution.NORMAL), "", dateValue, timeValue, duration.getSeconds(), aDescription);
            if (aUrls.containsKey((Object)Resolution.SMALL)) {
                CrawlerTool.addUrlKlein(film, aUrls.get((Object)Resolution.SMALL), "");
            }
            if (aUrls.containsKey((Object)Resolution.HD)) {
                CrawlerTool.addUrlHd(film, aUrls.get((Object)Resolution.HD), "");
            }
            if (aSubTitle.isPresent()) {
                CrawlerTool.addUrlSubtitle(film, aSubTitle.get());
            }
            return Optional.of(film);
        }
        if (!aDetailClip.has(JSON_ELEMENT_TITLE)) {
            this.printMissingDetails(JSON_ELEMENT_TITLE);
        }
        if (!aDetailClip.has(JSON_ELEMENT_KICKER)) {
            this.printMissingDetails(JSON_ELEMENT_KICKER);
        }
        if (!aDetailClip.has(JSON_ELEMENT_DURATION)) {
            this.printMissingDetails(JSON_ELEMENT_DURATION);
        }
        return Optional.empty();
    }

    private Set<BrUrlDTO> edgesToUrls(JsonObject viewer) {
        HashSet<BrUrlDTO> urls = new HashSet<BrUrlDTO>();
        Optional<JsonArray> edges = this.getVideoFileEdges(viewer);
        if (edges.isPresent()) {
            for (JsonElement edge : edges.get()) {
                JsonObject node;
                Optional<BrUrlDTO> url;
                JsonObject ebdgeObj = edge.getAsJsonObject();
                if (!ebdgeObj.has(JSON_ELEMENT_NODE) || !(url = this.nodeToUrl(node = ebdgeObj.getAsJsonObject(JSON_ELEMENT_NODE))).isPresent()) continue;
                urls.add(url.get());
            }
        }
        return urls;
    }

    private Optional<JsonElement> getBroadcastStart(JsonObject aDetailClip) {
        if (!aDetailClip.has(JSON_ELEMENT_BROADCASTS)) {
            return Optional.empty();
        }
        JsonObject broadcast = aDetailClip.getAsJsonObject(JSON_ELEMENT_BROADCASTS);
        if (!broadcast.has(JSON_ELEMENT_EDGES)) {
            return Optional.empty();
        }
        JsonArray edges = broadcast.getAsJsonArray(JSON_ELEMENT_EDGES);
        if (edges.size() <= 0) {
            return Optional.empty();
        }
        JsonObject arrayItem = edges.get(0).getAsJsonObject();
        if (!arrayItem.has(JSON_ELEMENT_NODE)) {
            return Optional.empty();
        }
        JsonObject node = arrayItem.getAsJsonObject(JSON_ELEMENT_NODE);
        if (!node.has(JSON_ELEMENT_START)) {
            return Optional.empty();
        }
        return Optional.of(node.get(JSON_ELEMENT_START));
    }

    private Optional<JsonObject> getDetailClip(JsonObject aViewer) {
        if (!aViewer.has(JSON_ELEMENT_DETAIL_CLIP)) {
            return Optional.empty();
        }
        return Optional.of(aViewer.getAsJsonObject(JSON_ELEMENT_DETAIL_CLIP));
    }

    private Optional<JsonArray> getVideoFileEdges(JsonObject aViewer) {
        if (!aViewer.has(JSON_ELEMENT_CLIP)) {
            return Optional.empty();
        }
        JsonObject clip = aViewer.getAsJsonObject(JSON_ELEMENT_CLIP);
        if (!clip.has(JSON_ELEMENT_VIDEO_FILES)) {
            return Optional.empty();
        }
        JsonObject videoFiles = clip.getAsJsonObject(JSON_ELEMENT_VIDEO_FILES);
        if (!videoFiles.has(JSON_ELEMENT_EDGES)) {
            return Optional.empty();
        }
        return Optional.of(videoFiles.getAsJsonArray(JSON_ELEMENT_EDGES));
    }

    private Optional<JsonObject> getViewer(JsonObject aBaseObject) {
        if (!aBaseObject.has(JSON_ELEMENT_DATA)) {
            return Optional.empty();
        }
        JsonObject data = aBaseObject.getAsJsonObject(JSON_ELEMENT_DATA);
        if (!data.has(JSON_ELEMENT_VIEWER)) {
            return Optional.empty();
        }
        return Optional.of(data.getAsJsonObject(JSON_ELEMENT_VIEWER));
    }

    private Optional<BrUrlDTO> nodeToUrl(JsonObject aNode) {
        if (aNode.has(JSON_ELEMENT_PUBLIC_LOCATION)) {
            if (aNode.has(JSON_ELEMENT_VIDEO_PROFILE)) {
                JsonObject videoProfile = aNode.getAsJsonObject(JSON_ELEMENT_VIDEO_PROFILE);
                if (videoProfile.has(JSON_ELEMENT_ID)) {
                    if (videoProfile.has(JSON_ELEMENT_WIDTH)) {
                        if (!videoProfile.get(JSON_ELEMENT_WIDTH).isJsonNull() && !videoProfile.get(JSON_ELEMENT_ID).isJsonNull()) {
                            return Optional.of(new BrUrlDTO(aNode.get(JSON_ELEMENT_PUBLIC_LOCATION).getAsString(), videoProfile.get(JSON_ELEMENT_WIDTH).getAsInt(), videoProfile.get(JSON_ELEMENT_ID).getAsString()));
                        }
                    } else {
                        this.printMissingDetails("videoProfile -> width");
                    }
                } else {
                    this.printMissingDetails("videoProfile -> id");
                }
            } else {
                this.printMissingDetails(JSON_ELEMENT_VIDEO_PROFILE);
            }
        } else {
            this.printMissingDetails(JSON_ELEMENT_PUBLIC_LOCATION);
        }
        return Optional.empty();
    }

    private void printMissingDetails(String aMissingJsonElement) {
        LOG.error(String.format(ERROR_MISSING_DETAIL_TEMPLATE, aMissingJsonElement));
    }

    private Duration toDuration(long aSeconds) {
        return Duration.of(aSeconds, ChronoUnit.SECONDS);
    }

    private LocalDateTime toTime(String aStart) {
        LocalDateTime local = LocalDateTime.parse(aStart, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        ZonedDateTime zoned = local.atZone(ZONE_ID);
        int hoursToAdd = zoned.getOffset().getTotalSeconds() / 3600;
        return local.plusHours(hoursToAdd);
    }
}

