/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.orf;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.tool.Log;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.TimeUnit;
import mServer.crawler.CrawlerTool;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.sender.MediathekReader;
import mServer.crawler.sender.orf.CrawlerUrlDTO;
import mServer.crawler.sender.orf.TopicUrlDTO;
import mServer.crawler.sender.orf.tasks.OrfDayTask;
import mServer.crawler.sender.orf.tasks.OrfFilmDetailTask;
import mServer.crawler.sender.orf.tasks.OrfLetterPageTask;

public class OrfCrawler
extends MediathekReader {
    public static final String SENDERNAME = "ORF";
    private final ForkJoinPool forkJoinPool = new ForkJoinPool(Runtime.getRuntime().availableProcessors() * 4);

    public OrfCrawler(FilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 0, 1, startPrio);
    }

    @Override
    protected void addToList() {
        this.meldungStart();
        try {
            RecursiveTask<Set<DatenFilm>> filmTask = this.createCrawlerTask();
            Set<DatenFilm> films = this.forkJoinPool.invoke(filmTask);
            Log.sysLog((String)"ORF Filme einsortieren...");
            films.forEach(film -> {
                if (!Config.getStop()) {
                    this.addFilm((DatenFilm)film);
                }
            });
            Log.sysLog((String)"ORF Film einsortieren fertig");
        }
        finally {
            this.shutdownAndAwaitTermination(this.forkJoinPool, 60L, TimeUnit.SECONDS);
        }
        Log.sysLog((String)"ORF fertig");
        this.meldungThreadUndFertig();
    }

    void shutdownAndAwaitTermination(ExecutorService pool, long delay, TimeUnit delayUnit) {
        pool.shutdown();
        Log.sysLog((String)"ORF shutdown pool...");
        try {
            if (!pool.awaitTermination(delay, delayUnit)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(delay, delayUnit)) {
                    Log.sysLog((String)"ORF: Pool nicht beendet");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private Set<TopicUrlDTO> getDaysEntries() throws InterruptedException, ExecutionException {
        OrfDayTask dayTask = new OrfDayTask((MediathekReader)this, this.getDayUrls());
        Set<TopicUrlDTO> shows = this.forkJoinPool.submit(dayTask).get();
        Log.sysLog((String)("ORF: Anzahl Sendungen aus Verpasst: " + shows.size()));
        return shows;
    }

    private ConcurrentLinkedQueue<CrawlerUrlDTO> getDayUrls() {
        int maximumDaysForSendungVerpasstSection = 8;
        boolean maximumDaysForSendungVerpasstSectionFuture = false;
        ConcurrentLinkedQueue<CrawlerUrlDTO> urls = new ConcurrentLinkedQueue<CrawlerUrlDTO>();
        for (int i = 0; i < 8; ++i) {
            urls.add(new CrawlerUrlDTO("https://tvthek.orf.at/schedule/" + LocalDateTime.now().plus(0L, ChronoUnit.DAYS).minus(i, ChronoUnit.DAYS).format(DateTimeFormatter.ofPattern("dd.MM.yyyy"))));
        }
        return urls;
    }

    private ConcurrentLinkedQueue<TopicUrlDTO> getLetterEntries() throws InterruptedException, ExecutionException {
        OrfLetterPageTask letterTask = new OrfLetterPageTask();
        ConcurrentLinkedQueue shows = (ConcurrentLinkedQueue)((ForkJoinTask)this.forkJoinPool.submit((Callable)letterTask)).get();
        Log.sysLog((String)("ORF: Anzahl Sendungen nach Buchstaben: " + shows.size()));
        return shows;
    }

    protected RecursiveTask<Set<DatenFilm>> createCrawlerTask() {
        ConcurrentLinkedQueue<TopicUrlDTO> shows = new ConcurrentLinkedQueue<TopicUrlDTO>();
        try {
            if (CrawlerTool.loadLongMax()) {
                shows.addAll(this.getLetterEntries());
            }
            this.getDaysEntries().forEach(show -> {
                if (!shows.contains(show)) {
                    shows.add((TopicUrlDTO)show);
                }
            });
        }
        catch (InterruptedException | ExecutionException exception) {
            Log.errorLog((int)56146546, (Exception)exception);
        }
        Log.sysLog((String)("ORF Anzahl: " + shows.size()));
        this.meldungAddMax(shows.size());
        return new OrfFilmDetailTask((MediathekReader)this, shows);
    }
}

