/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.ListeFilme;
import de.mediathekview.mlib.filmesuchen.ListenerFilmeLaden;
import de.mediathekview.mlib.filmesuchen.ListenerFilmeLadenEvent;
import de.mediathekview.mlib.filmlisten.FilmlisteLesen;
import de.mediathekview.mlib.filmlisten.WriteFilmlistJson;
import de.mediathekview.mlib.tool.Log;
import java.util.concurrent.TimeUnit;
import mServer.crawler.AddToFilmlist;
import mServer.crawler.CrawlerConfig;
import mServer.crawler.CrawlerTool;
import mServer.crawler.FilmeSuchen;
import mServer.tool.HashFileWriter;

public class Crawler
implements Runnable {
    private ListeFilme listeFilme = new ListeFilme();
    private final FilmeSuchen filmeSuchen = new FilmeSuchen();
    private boolean serverLaufen = false;

    @Override
    public synchronized void run() {
        this.serverLaufen = true;
        Config.setStop((boolean)false);
        if (CrawlerConfig.dirFilme.isEmpty()) {
            Log.sysLog((String)"Kein Pfad der Filmlisten angegeben");
            System.exit(-1);
        }
        CrawlerTool.startMsg();
        Log.sysLog((String)"");
        Log.sysLog((String)"");
        this.filmeSuchen.addAdListener(new ListenerFilmeLaden(){

            public void fertig(ListenerFilmeLadenEvent event) {
                Crawler.this.serverLaufen = false;
            }
        });
        new FilmlisteLesen().readFilmListe(CrawlerTool.getPathFilmlist_json_akt(false), this.listeFilme, 0);
        if (CrawlerConfig.nurSenderLaden == null) {
            this.filmeSuchen.filmeBeimSenderLaden(this.listeFilme);
        } else {
            this.filmeSuchen.updateSender(CrawlerConfig.nurSenderLaden, this.listeFilme);
        }
        try {
            while (this.serverLaufen) {
                TimeUnit.SECONDS.timedWait(this, 5L);
            }
        }
        catch (Exception ex) {
            Log.errorLog((int)496378742, (String)"run()");
        }
        this.undTschuess();
    }

    public void stop() {
        if (this.serverLaufen) {
            Config.setStop((boolean)true);
        }
    }

    public ListeFilme getListeFilme() {
        return this.listeFilme;
    }

    private void importLive(ListeFilme tmpListe, String importUrl) {
        Log.sysLog((String)("Live-Streams importieren von: " + importUrl));
        tmpListe.clear();
        new FilmlisteLesen().readFilmListe(importUrl, tmpListe, 0);
        Log.sysLog((String)("--> von  Anz. Filme: " + this.listeFilme.size()));
        new AddToFilmlist(this.listeFilme, tmpListe).addLiveStream();
        Log.sysLog((String)("--> nach Anz. Filme: " + this.listeFilme.size()));
        tmpListe.clear();
        System.gc();
        this.listeFilme.sort();
    }

    private void importUrl(ListeFilme tmpListe, String importUrl) {
        Log.sysLog((String)("Filmliste importieren von: " + importUrl));
        tmpListe.clear();
        new FilmlisteLesen().readFilmListe(importUrl, tmpListe, 0);
        Log.sysLog((String)("--> von  Anz. Filme: " + this.listeFilme.size()));
        this.listeFilme.updateListe(tmpListe, false, false);
        Log.sysLog((String)("--> nach Anz. Filme: " + this.listeFilme.size()));
        tmpListe.clear();
        System.gc();
        this.listeFilme.sort();
    }

    private void importOld(ListeFilme tmpListe, String importUrl) {
        Log.sysLog((String)("Alte Filmliste importieren von: " + importUrl));
        tmpListe.clear();
        new FilmlisteLesen().readFilmListe(importUrl, tmpListe, 0);
        Log.sysLog((String)("--> von  Anz. Filme: " + this.listeFilme.size()));
        int anz = new AddToFilmlist(this.listeFilme, tmpListe).addOldList();
        Log.sysLog((String)("    gefunden: " + anz));
        Log.sysLog((String)("--> nach Anz. Filme: " + this.listeFilme.size()));
        tmpListe.clear();
        System.gc();
        this.listeFilme.sort();
    }

    private void undTschuess() {
        ListeFilme diff;
        Config.setStop((boolean)false);
        this.listeFilme = this.filmeSuchen.listeFilmeNeu;
        ListeFilme tmpListe = new ListeFilme();
        Log.sysLog((String)"");
        if (!CrawlerConfig.importLive.isEmpty()) {
            Log.sysLog((String)"");
            Log.sysLog((String)"============================================================================");
            Log.sysLog((String)"Live-Streams importieren");
            this.importLive(tmpListe, CrawlerConfig.importLive);
            Log.sysLog((String)"");
        }
        if (!CrawlerConfig.importUrl_1__anhaengen.isEmpty()) {
            Log.sysLog((String)"");
            Log.sysLog((String)"============================================================================");
            Log.sysLog((String)"Filmliste Import 1");
            this.importUrl(tmpListe, CrawlerConfig.importUrl_1__anhaengen);
            Log.sysLog((String)"");
        }
        if (!CrawlerConfig.importUrl_2__anhaengen.isEmpty()) {
            Log.sysLog((String)"");
            Log.sysLog((String)"============================================================================");
            Log.sysLog((String)"Filmliste Import 2");
            this.importUrl(tmpListe, CrawlerConfig.importUrl_2__anhaengen);
            Log.sysLog((String)"");
        }
        if (!CrawlerConfig.importAkt.isEmpty()) {
            Log.sysLog((String)"");
            Log.sysLog((String)"============================================================================");
            Log.sysLog((String)"Filmliste Import akt");
            this.importUrl(tmpListe, CrawlerConfig.importAkt);
            Log.sysLog((String)"");
        }
        if (!CrawlerConfig.importOld.isEmpty() && CrawlerTool.loadLongMax()) {
            Log.sysLog((String)"");
            Log.sysLog((String)"============================================================================");
            Log.sysLog((String)"Filmliste OLD importieren");
            this.importOld(tmpListe, CrawlerConfig.importOld);
            Log.sysLog((String)"");
        }
        Log.sysLog((String)"");
        Log.sysLog((String)"");
        Log.sysLog((String)"============================================================================");
        Log.sysLog((String)"============================================================================");
        Log.sysLog((String)("Filmeliste fertig: " + this.listeFilme.size() + " Filme"));
        Log.sysLog((String)"============================================================================");
        Log.sysLog((String)"");
        Log.sysLog((String)"   --> und schreiben:");
        WriteFilmlistJson writer = new WriteFilmlistJson();
        writer.filmlisteSchreibenJson(CrawlerTool.getPathFilmlist_json_akt(false), this.listeFilme);
        writer.filmlisteSchreibenJson(CrawlerTool.getPathFilmlist_json_akt(true), this.listeFilme);
        writer.filmlisteSchreibenJsonCompressed(CrawlerTool.getPathFilmlist_json_akt_xz(), this.listeFilme);
        new HashFileWriter(CrawlerConfig.dirFilme).writeHash(this.listeFilme.getId());
        Log.sysLog((String)"");
        if (CrawlerConfig.orgFilmlisteErstellen) {
            Log.sysLog((String)"");
            Log.sysLog((String)"============================================================================");
            Log.sysLog((String)("Org-Lilste schreiben: " + CrawlerTool.getPathFilmlist_json_org()));
            writer.filmlisteSchreibenJson(CrawlerTool.getPathFilmlist_json_org(), this.listeFilme);
            writer.filmlisteSchreibenJsonCompressed(CrawlerTool.getPathFilmlist_json_org_xz(), this.listeFilme);
        }
        String org = CrawlerConfig.orgFilmliste.isEmpty() ? CrawlerTool.getPathFilmlist_json_org() : CrawlerConfig.orgFilmliste;
        Log.sysLog((String)"");
        Log.sysLog((String)"============================================================================");
        Log.sysLog((String)("Diff erzeugen, von: " + org + " nach: " + CrawlerTool.getPathFilmlist_json_diff()));
        tmpListe.clear();
        new FilmlisteLesen().readFilmListe(org, tmpListe, 0);
        if (tmpListe.isEmpty()) {
            Log.sysLog((String)"   --> Lesefehler der Orgliste: Diff bleibt leer!");
            diff = new ListeFilme();
        } else if (tmpListe.isOlderThan(86400)) {
            Log.sysLog((String)"   --> Orgliste zu alt: Diff bleibt leer!");
            diff = new ListeFilme();
        } else {
            diff = this.listeFilme.neueFilme(tmpListe);
        }
        Log.sysLog((String)"   --> und schreiben:");
        writer.filmlisteSchreibenJson(CrawlerTool.getPathFilmlist_json_diff(), diff);
        writer.filmlisteSchreibenJsonCompressed(CrawlerTool.getPathFilmlist_json_diff_xz(), diff);
        Log.sysLog((String)("   --> Anz. Filme Diff: " + diff.size()));
        Log.endMsg();
    }
}

