/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.phoenix.parser;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class PhoenixFilmXmlHandler
extends DefaultHandler {
    private static final String ELEMENT_BASENAME = "basename";
    private static final String ELEMENT_AIRTIME = "airtime";
    private static final String ELEMENT_LENGTH = "length";
    private static final int ELEMENT_BASENAME_ACTIVE = 1;
    private static final int ELEMENT_AIRTIME_ACTIVE = 2;
    private static final int ELEMENT_LENGTH_ACTIVE = 3;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm");
    private String baseName;
    private LocalDateTime time;
    private Duration duration;
    private int activeElement;

    public String getBaseName() {
        return this.baseName;
    }

    public LocalDateTime getTime() {
        return this.time;
    }

    public Duration getDuration() {
        return this.duration;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        switch (qName.toLowerCase()) {
            case "basename": {
                this.activeElement = 1;
                return;
            }
            case "airtime": {
                this.activeElement = 2;
                return;
            }
            case "length": {
                this.activeElement = 3;
                return;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.activeElement = 0;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.activeElement == 0) {
            return;
        }
        String value = new String(ch, start, length);
        switch (this.activeElement) {
            case 2: {
                this.time = LocalDateTime.parse(value, DATE_TIME_FORMATTER);
                return;
            }
            case 1: {
                this.baseName = value;
                return;
            }
            case 3: {
                this.parseDuration(value);
                return;
            }
        }
    }

    private void parseDuration(String aValue) {
        String[] parts;
        int end = aValue.indexOf(46);
        if (end < 0) {
            end = aValue.length();
        }
        int durationValue = 0;
        for (String part : parts = aValue.substring(0, end).split(":")) {
            durationValue = durationValue * 60 + Integer.parseInt(part);
        }
        this.duration = Duration.ofSeconds(durationValue - 3600);
    }
}

