/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender;

import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.daten.DatenFilm;
import de.mediathekview.mlib.daten.ListeFilme;
import de.mediathekview.mlib.tool.Log;
import de.mediathekview.mlib.tool.MSStringBuilder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import mServer.crawler.FilmeSuchen;
import mServer.crawler.GetUrl;
import mServer.crawler.sender.MediathekReader;
import mServer.crawler.sender.wdr.WdrDayPageCallable;
import mServer.crawler.sender.wdr.WdrLetterPageCallable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MediathekWdr
extends MediathekReader {
    public static final String SENDERNAME = "WDR";
    private final LinkedList<String> dayUrls = new LinkedList();
    private final LinkedList<String> letterPageUrls = new LinkedList();
    private MSStringBuilder seite_1 = new MSStringBuilder(65536);
    Collection<Future<ListeFilme>> futureFilme = new ArrayList<Future<ListeFilme>>();
    private static final Logger LOG = LogManager.getLogger(MediathekWdr.class);

    public MediathekWdr(FilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 3, 100, startPrio);
    }

    @Override
    public synchronized void addToList() {
        this.clearLists();
        this.meldungStart();
        this.fillLists();
        if (Config.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.letterPageUrls.isEmpty() && this.dayUrls.isEmpty()) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.letterPageUrls.size() + this.dayUrls.size());
            this.startLetterPages();
            this.startDayPages();
            this.addFilms();
            this.meldungThreadUndFertig();
        }
    }

    private void addFilms() {
        this.futureFilme.forEach(e -> {
            try {
                ListeFilme filmList = (ListeFilme)e.get();
                if (filmList != null) {
                    filmList.forEach(film -> {
                        if (film != null) {
                            this.addFilm((DatenFilm)film);
                        }
                    });
                }
            }
            catch (Exception exception) {
                LOG.error("Es ist ein Fehler beim lesen der WDR Filme aufgetreten.", (Throwable)exception);
            }
        });
    }

    private void fillLists() {
        this.addLetterPages();
        this.addDayPages();
    }

    private void clearLists() {
        this.letterPageUrls.clear();
        this.dayUrls.clear();
    }

    private void startLetterPages() {
        this.letterPageUrls.forEach(url -> {
            ExecutorService executor = Executors.newCachedThreadPool();
            this.futureFilme.add(executor.submit(new WdrLetterPageCallable((String)url)));
            this.meldungProgress((String)url);
        });
    }

    private void startDayPages() {
        this.dayUrls.forEach(url -> {
            ExecutorService executor = Executors.newCachedThreadPool();
            this.futureFilme.add(executor.submit(new WdrDayPageCallable((String)url)));
            this.meldungProgress((String)url);
        });
    }

    private void addDayPages() {
        SimpleDateFormat formatter = new SimpleDateFormat("ddMMyyyy");
        for (int i = 0; i < 14; ++i) {
            String URL2 = "http://www1.wdr.de/mediathek/video/sendungverpasst/sendung-verpasst-100~_tag-";
            String tag = formatter.format(new Date().getTime() - (long)(86400000 * i));
            String urlString = "http://www1.wdr.de/mediathek/video/sendungverpasst/sendung-verpasst-100~_tag-" + tag + ".html";
            this.dayUrls.add(urlString);
        }
    }

    private void addLetterPages() {
        String URL2 = "http://www1.wdr.de/mediathek/video/sendungen-a-z/index.html";
        String MUSTER_URL = "<a href=\"/mediathek/video/sendungen-a-z/";
        GetUrl getUrlIo = new GetUrl(this.getWartenSeiteLaden());
        this.seite_1 = getUrlIo.getUri_Iso(SENDERNAME, "http://www1.wdr.de/mediathek/video/sendungen-a-z/index.html", this.seite_1, "");
        this.letterPageUrls.add("http://www1.wdr.de/mediathek/video/sendungen-a-z/index.html");
        int pos1 = this.seite_1.indexOf("<strong>A</strong>");
        while (!Config.getStop() && (pos1 = this.seite_1.indexOf("<a href=\"/mediathek/video/sendungen-a-z/", pos1)) != -1) {
            String url;
            int pos2 = this.seite_1.indexOf("\"", pos1 += "<a href=\"/mediathek/video/sendungen-a-z/".length());
            if (pos2 == -1 || (url = this.seite_1.substring(pos1, pos2)).equals("index.html")) continue;
            if (url.isEmpty()) {
                Log.errorLog((int)995122047, (String)"keine URL");
                continue;
            }
            url = "http://www1.wdr.de/mediathek/video/sendungen-a-z/" + url;
            this.letterPageUrls.add(url);
        }
    }
}

