/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.newsearch;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import de.mediathekview.mlib.Config;
import de.mediathekview.mlib.tool.Log;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.RecursiveTask;
import mServer.crawler.sender.newsearch.VideoDTO;
import mServer.crawler.sender.newsearch.ZDFEntryDTO;
import mServer.crawler.sender.newsearch.ZDFEntryDTODeserializer;
import mServer.crawler.sender.newsearch.ZDFEntryTask;
import mServer.tool.MserverDaten;

public class ZDFSearchPageTask
extends RecursiveTask<Collection<VideoDTO>> {
    private static final long serialVersionUID = 1L;
    private static final String JSON_ELEMENT_RESULTS = "http://zdf.de/rels/search/results";
    private final JsonObject searchResult;
    private final Gson gson;
    private static final Type ZDFENTRYDTO_COLLECTION_TYPE = new TypeToken<Collection<ZDFEntryDTO>>(){}.getType();

    public ZDFSearchPageTask(JsonObject aSearchResult) {
        this.searchResult = aSearchResult;
        this.gson = new GsonBuilder().registerTypeAdapter(ZDFEntryDTO.class, (Object)new ZDFEntryDTODeserializer()).create();
    }

    @Override
    protected Collection<VideoDTO> compute() {
        ArrayList<VideoDTO> filmList = new ArrayList<VideoDTO>();
        if (!Config.getStop()) {
            ArrayList subTasks = new ArrayList();
            Collection zdfEntryDTOList = (Collection)this.gson.fromJson((JsonElement)this.searchResult.getAsJsonArray(JSON_ELEMENT_RESULTS), ZDFENTRYDTO_COLLECTION_TYPE);
            zdfEntryDTOList.forEach(zdfEntryDTO -> {
                if (zdfEntryDTO != null) {
                    ZDFEntryTask entryTask = new ZDFEntryTask((ZDFEntryDTO)zdfEntryDTO);
                    entryTask.fork();
                    subTasks.add(entryTask);
                    if (MserverDaten.debug) {
                        Log.sysLog((String)("EntryTask " + entryTask.hashCode() + " added."));
                    }
                }
            });
            subTasks.forEach(t -> filmList.add((VideoDTO)t.join()));
            if (MserverDaten.debug) {
                Log.sysLog((String)"All EntryTasks finished.");
            }
        }
        return filmList;
    }
}

