/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.orf.parser;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.mediathekview.mlib.tool.Log;
import java.lang.reflect.Type;
import java.util.Optional;
import mServer.crawler.sender.newsearch.Qualities;
import mServer.crawler.sender.orf.OrfVideoInfoDTO;

public class OrfVideoDetailDeserializer
implements JsonDeserializer<Optional<OrfVideoInfoDTO>> {
    private static final String WRONG_HTTPS_URL_PART = ".apa.";
    private static final String RIGHT_HTTPS_URL_PART = ".sf.apa.";
    private static final String ELEMENT_PLAYLIST = "playlist";
    private static final String ELEMENT_VIDEOS = "videos";
    private static final String ELEMENT_SUBTITLES = "subtitles";
    private static final String ELEMENT_SOURCES = "sources";
    private static final String ATTRIBUTE_DELIVERY = "delivery";
    private static final String ATTRIBUTE_PROTOCOL = "protocol";
    private static final String ATTRIBUTE_QUALITY = "quality";
    private static final String ATTRIBUTE_SRC = "src";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String RELEVANT_DELIVERY = "progressive";
    private static final String RELEVANT_PROTOCOL = "http";
    private static final String RELEVANT_SUBTITLE_TYPE = "ttml";
    private static final String RELEVANT_VIDEO_TYPE = "video/mp4";

    private static String fixHttpsURL(String url) {
        if (url.contains(RIGHT_HTTPS_URL_PART)) {
            return url;
        }
        return url.replace(WRONG_HTTPS_URL_PART, RIGHT_HTTPS_URL_PART);
    }

    private static Optional<Qualities> getQuality(String aQuality) {
        switch (aQuality) {
            case "Q1A": {
                return Optional.empty();
            }
            case "Q4A": {
                return Optional.of(Qualities.SMALL);
            }
            case "Q6A": {
                return Optional.of(Qualities.NORMAL);
            }
            case "Q8C": {
                return Optional.of(Qualities.HD);
            }
        }
        Log.sysLog((String)("ORF: unknown quality: " + aQuality));
        return Optional.empty();
    }

    private static void parseSubtitles(JsonElement aSubtitlesElement, OrfVideoInfoDTO dto) {
        if (aSubtitlesElement.isJsonArray()) {
            aSubtitlesElement.getAsJsonArray().forEach(subtitleElement -> {
                String type;
                JsonObject subtitleObject = subtitleElement.getAsJsonObject();
                if (subtitleObject.has(ATTRIBUTE_SRC) && subtitleObject.has(ATTRIBUTE_TYPE) && (type = subtitleObject.get(ATTRIBUTE_TYPE).getAsString()).equalsIgnoreCase(RELEVANT_SUBTITLE_TYPE)) {
                    String url = OrfVideoDetailDeserializer.fixHttpsURL(subtitleObject.get(ATTRIBUTE_SRC).getAsString());
                    dto.setSubtitleUrl(url);
                }
            });
        }
    }

    private static void parseVideo(JsonElement aVideoElement, OrfVideoInfoDTO dto) {
        if (aVideoElement.isJsonArray()) {
            aVideoElement.getAsJsonArray().forEach(videoElement -> {
                JsonObject videoObject = videoElement.getAsJsonObject();
                if (videoObject.has(ATTRIBUTE_PROTOCOL) && videoObject.has(ATTRIBUTE_QUALITY) && videoObject.has(ATTRIBUTE_SRC) && videoObject.has(ATTRIBUTE_TYPE)) {
                    String type = videoObject.get(ATTRIBUTE_TYPE).getAsString();
                    String protocol = videoObject.get(ATTRIBUTE_PROTOCOL).getAsString();
                    String delivery = videoObject.get(ATTRIBUTE_DELIVERY).getAsString();
                    if (type.equalsIgnoreCase(RELEVANT_VIDEO_TYPE) && protocol.equalsIgnoreCase(RELEVANT_PROTOCOL) && delivery.equalsIgnoreCase(RELEVANT_DELIVERY)) {
                        String quality = videoObject.get(ATTRIBUTE_QUALITY).getAsString();
                        String url = OrfVideoDetailDeserializer.fixHttpsURL(videoObject.get(ATTRIBUTE_SRC).getAsString());
                        Optional<Qualities> resolution = OrfVideoDetailDeserializer.getQuality(quality);
                        if (resolution.isPresent()) {
                            dto.put(resolution.get(), url);
                        }
                    }
                }
            });
        }
    }

    public Optional<OrfVideoInfoDTO> deserialize(JsonElement aJsonElement, Type aType, JsonDeserializationContext aContext) throws JsonParseException {
        JsonObject playlistObject;
        JsonObject jsonObject = aJsonElement.getAsJsonObject();
        if (jsonObject.has(ELEMENT_PLAYLIST) && (playlistObject = jsonObject.get(ELEMENT_PLAYLIST).getAsJsonObject()).has(ELEMENT_VIDEOS)) {
            JsonObject videoObject = playlistObject.get(ELEMENT_VIDEOS).getAsJsonArray().get(0).getAsJsonObject();
            return this.deserializeVideoObject(videoObject);
        }
        return Optional.empty();
    }

    public Optional<OrfVideoInfoDTO> deserializeVideoObject(JsonObject aVideoObject) {
        OrfVideoInfoDTO dto = new OrfVideoInfoDTO();
        if (aVideoObject.has(ELEMENT_SOURCES)) {
            OrfVideoDetailDeserializer.parseVideo(aVideoObject.get(ELEMENT_SOURCES), dto);
        }
        if (aVideoObject.has(ELEMENT_SUBTITLES)) {
            OrfVideoDetailDeserializer.parseSubtitles(aVideoObject.get(ELEMENT_SUBTITLES), dto);
        }
        return Optional.of(dto);
    }
}

