/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.phoenix.parser;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Optional;
import mServer.crawler.sender.newsearch.GeoLocations;
import mServer.crawler.sender.newsearch.Qualities;
import mServer.crawler.sender.phoenix.DownloadDto;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ZdfDownloadDtoDeserializer
implements JsonDeserializer<Optional<DownloadDto>> {
    private static final String ZDF_QUALITY_VERYHIGH = "veryhigh";
    private static final String ZDF_QUALITY_HIGH = "high";
    private static final String ZDF_QUALITY_MED = "med";
    private static final String ZDF_QUALITY_LOW = "low";
    private static final Logger LOG = LogManager.getLogger(ZdfDownloadDtoDeserializer.class);
    private static final String JSON_ELEMENT_ATTRIBUTES = "attributes";
    private static final String JSON_ELEMENT_AUDIO = "audio";
    private static final String JSON_ELEMENT_CAPTIONS = "captions";
    private static final String JSON_ELEMENT_FORMITAET = "formitaeten";
    private static final String JSON_ELEMENT_GEOLOCATION = "geoLocation";
    private static final String JSON_ELEMENT_HD = "hd";
    private static final String JSON_ELEMENT_MIMETYPE = "mimeType";
    private static final String JSON_ELEMENT_PRIORITYLIST = "priorityList";
    private static final String JSON_ELEMENT_QUALITY = "quality";
    private static final String JSON_ELEMENT_TRACKS = "tracks";
    private static final String JSON_ELEMENT_URI = "uri";
    private static final String JSON_PROPERTY_VALUE = "value";
    private static final String RELEVANT_MIME_TYPE = "video/mp4";
    private static final String RELEVANT_SUBTITLE_TYPE = ".xml";
    private static final String JSON_ELEMENT_QUALITIES = "qualities";

    public Optional<DownloadDto> deserialize(JsonElement aJsonElement, Type aTypeOfT, JsonDeserializationContext aJsonDeserializationContext) {
        DownloadDto dto = new DownloadDto();
        try {
            JsonObject rootNode = aJsonElement.getAsJsonObject();
            this.parseVideoUrls(dto, rootNode);
            this.parseSubtitle(dto, rootNode);
            this.parseGeoLocation(dto, rootNode);
            return Optional.of(dto);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOG.error("ZDF: A needed JSON element is JsonNull.", (Throwable)unsupportedOperationException);
            return Optional.empty();
        }
    }

    private void parseFormitaet(DownloadDto dto, JsonElement formitaet) {
        JsonElement mimeType = formitaet.getAsJsonObject().get(JSON_ELEMENT_MIMETYPE);
        if (mimeType != null && mimeType.getAsString().equalsIgnoreCase(RELEVANT_MIME_TYPE)) {
            JsonArray qualityList = formitaet.getAsJsonObject().getAsJsonArray(JSON_ELEMENT_QUALITIES);
            for (JsonElement quality : qualityList) {
                String uri = null;
                Qualities qualityValue = this.parseVideoQuality(quality.getAsJsonObject());
                JsonElement audio = quality.getAsJsonObject().get(JSON_ELEMENT_AUDIO);
                if (audio != null) {
                    JsonArray tracks = audio.getAsJsonObject().getAsJsonArray(JSON_ELEMENT_TRACKS);
                    JsonObject track = tracks.get(0).getAsJsonObject();
                    uri = track.get(JSON_ELEMENT_URI).getAsString();
                }
                if (qualityValue == null || uri == null) continue;
                dto.addUrl(qualityValue, uri);
            }
        }
    }

    private void parseGeoLocation(DownloadDto dto, JsonObject rootNode) {
        JsonElement geoValue;
        JsonElement geoLocation;
        JsonElement attributes = rootNode.get(JSON_ELEMENT_ATTRIBUTES);
        if (attributes != null && (geoLocation = attributes.getAsJsonObject().get(JSON_ELEMENT_GEOLOCATION)) != null && (geoValue = geoLocation.getAsJsonObject().get(JSON_PROPERTY_VALUE)) != null && !geoValue.getAsString().toUpperCase().equals("NONE")) {
            switch (geoValue.getAsString().toUpperCase()) {
                case "DE": {
                    dto.setGeoLocation(GeoLocations.GEO_DE);
                    break;
                }
                default: {
                    LOG.debug(String.format("Can't find a GeoLocation for \"%s", geoValue.getAsString()));
                }
            }
        }
    }

    private void parsePriority(DownloadDto dto, JsonElement priority) {
        if (priority != null) {
            JsonArray formitaetList = priority.getAsJsonObject().getAsJsonArray(JSON_ELEMENT_FORMITAET);
            for (JsonElement formitaet : formitaetList) {
                this.parseFormitaet(dto, formitaet);
            }
        }
    }

    private void parseSubtitle(DownloadDto dto, JsonObject rootNode) {
        JsonArray captionList = rootNode.getAsJsonArray(JSON_ELEMENT_CAPTIONS);
        Iterator captionIterator = captionList.iterator();
        while (captionIterator.hasNext()) {
            JsonObject caption = ((JsonElement)captionIterator.next()).getAsJsonObject();
            JsonElement uri = caption.get(JSON_ELEMENT_URI);
            if (uri == null) continue;
            String uriValue = uri.getAsString();
            if (uriValue.endsWith(RELEVANT_SUBTITLE_TYPE)) {
                dto.setSubTitleUrl(uriValue);
                break;
            }
            if (!dto.getSubTitleUrl().isPresent()) continue;
            dto.setSubTitleUrl(uriValue);
        }
    }

    private Qualities parseVideoQuality(JsonObject quality) {
        Qualities qualityValue;
        JsonElement hd = quality.get(JSON_ELEMENT_HD);
        if (hd != null && hd.getAsBoolean()) {
            qualityValue = Qualities.HD;
        } else {
            String zdfQuality;
            switch (zdfQuality = quality.get(JSON_ELEMENT_QUALITY).getAsString()) {
                case "low": {
                    qualityValue = Qualities.SMALL;
                    break;
                }
                case "med": {
                    qualityValue = Qualities.SMALL;
                    break;
                }
                case "high": {
                    qualityValue = Qualities.SMALL;
                    break;
                }
                case "veryhigh": {
                    qualityValue = Qualities.NORMAL;
                    break;
                }
                default: {
                    qualityValue = Qualities.SMALL;
                }
            }
        }
        return qualityValue;
    }

    private void parseVideoUrls(DownloadDto dto, JsonObject rootNode) {
        JsonArray priorityList = rootNode.getAsJsonArray(JSON_ELEMENT_PRIORITYLIST);
        for (JsonElement priority : priorityList) {
            this.parsePriority(dto, priority);
        }
    }
}

