/*
 * Decompiled with CFR 0.152.
 */
package mServer.crawler.sender.phoenix.tasks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import mServer.crawler.sender.MediathekReader;
import mServer.crawler.sender.orf.CrawlerUrlDTO;
import mServer.crawler.sender.phoenix.tasks.AbstractRestTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ZdfTaskBase<T, D extends CrawlerUrlDTO>
extends AbstractRestTask<T, D> {
    private static final String HEADER_AUTHENTIFICATION = "Api-Auth";
    private static final Logger LOG = LogManager.getLogger(ZdfTaskBase.class);
    private final GsonBuilder gsonBuilder = new GsonBuilder();

    public ZdfTaskBase(MediathekReader aCrawler, ConcurrentLinkedQueue<D> aUrlToCrawlDtos, Optional<String> aAuthKey) {
        super(aCrawler, aUrlToCrawlDtos, aAuthKey);
    }

    protected void registerJsonDeserializer(Type aType, Object aDeserializer) {
        this.gsonBuilder.registerTypeAdapter(aType, aDeserializer);
    }

    protected <T> Optional<T> deserializeOptional(WebTarget aTarget, Type aType) {
        Gson gson = this.gsonBuilder.create();
        Response response = this.executeRequest(aTarget);
        if (response.getStatus() == 200) {
            String jsonOutput = (String)response.readEntity(String.class);
            return (Optional)gson.fromJson(jsonOutput, aType);
        }
        LOG.error("ZdfTaskBase: request of url " + aTarget.getUri().toString() + " failed: " + response.getStatus());
        return Optional.empty();
    }

    protected <T> T deserialize(WebTarget aTarget, Type aType) {
        Gson gson = this.gsonBuilder.create();
        Response response = this.executeRequest(aTarget);
        if (response.getStatus() == 200) {
            String jsonOutput = (String)response.readEntity(String.class);
            return (T)gson.fromJson(jsonOutput, aType);
        }
        LOG.error("ZdfTaskBase: request of url " + aTarget.getUri().toString() + " failed: " + response.getStatus());
        return null;
    }

    private Response executeRequest(WebTarget aTarget) {
        Invocation.Builder request = aTarget.request();
        if (this.authKey.isPresent()) {
            request = request.header(HEADER_AUTHENTIFICATION, (Object)("Bearer " + (String)this.authKey.get()));
        }
        return request.header("Accept-Encoding", (Object)"gzip").get();
    }
}

