/*
 * Decompiled with CFR 0.152.
 */
package de.mehtrick.bjoern.base;

import de.mehtrick.bjoern.base.BjoernMissingPropertyException;
import de.mehtrick.bjoern.base.NotSupportedJunitVersionException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.BeforeEach;

public class BjoernGeneratorConfig {
    private final String PROPERTY_PACKAGE = "package";
    private final String PROPERTY_FOLDER = "folder";
    private final String PROPERTY_PATH = "path";
    private final String PROPERTY_GENDIR = "gendir";
    private final String PROPERTY_EXTENDED_TESTCLASS = "extendedTestclass";
    private final String PROPERTY_DOCDIR = "docdir";
    private final String PROPERTY_TEMPLATE = "template";
    private final String PROPERTY_TEMPLATE_FOLDER = "templateFolder";
    private final String PROPERTY_DOC_EXTENSION = "docExtension";
    private final String PROPERTY_JUNIT_VERSION = "junitVersion";
    private final String PROPERTY_ENCODING = "encoding";
    private String path;
    private String folder;
    private String pckg;
    private String gendir;
    private String extendedTestclass;
    private String docdir;
    private String template = "/asciidoc.ftlh";
    private String templateFolder;
    private String docExtension = "adoc";
    private SupportedJunitVersion junitVersion = SupportedJunitVersion.junit4;
    private Charset encoding = StandardCharsets.UTF_8;

    public BjoernGeneratorConfig() {
    }

    public BjoernGeneratorConfig(String[] args) throws NotSupportedJunitVersionException {
        this.setPath(this.findPropertyInArgs("path", args));
        this.setFolder(this.findPropertyInArgs("folder", args));
        this.setPckg(this.findPropertyInArgs("package", args));
        this.setGendir(this.findPropertyInArgs("gendir", args));
        this.setExtendedTestclass(this.findPropertyInArgs("extendedTestclass", args));
        this.setDocdir(this.findPropertyInArgs("docdir", args));
        this.setTemplate(this.findPropertyInArgs("template", args));
        this.setTemplateFolder(this.findPropertyInArgs("templateFolder", args));
        this.setDocExtension(this.findPropertyInArgs("docExtension", args));
        this.setJunitVersion(this.findPropertyInArgs("junitVersion", args));
        this.setEncoding(this.findPropertyInArgs("encoding", args));
    }

    public void validate() throws BjoernMissingPropertyException {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.path, this.folder})) {
            throw new BjoernMissingPropertyException("Please configure a path or folder");
        }
    }

    private String findPropertyInArgs(String propertyname, String[] args) {
        for (String arg : args) {
            if (!arg.startsWith(propertyname + "=")) continue;
            return StringUtils.substringAfter((String)arg, (String)"=");
        }
        return null;
    }

    public SupportedJunitVersion getJunitVersion() {
        return this.junitVersion;
    }

    public void setJunitVersion(String junitVersion) throws NotSupportedJunitVersionException {
        if (StringUtils.isNotBlank((CharSequence)junitVersion)) {
            this.junitVersion = SupportedJunitVersion.getByVersionnumber(junitVersion);
        }
    }

    public boolean isFoldersSet() {
        return this.folder != null;
    }

    public String getPath() {
        return this.path;
    }

    public String getPckg() {
        return this.pckg;
    }

    public void setPckg(String pckg) {
        this.pckg = pckg;
    }

    public String getGendir() {
        return this.gendir;
    }

    public void setGendir(String gendir) {
        this.gendir = gendir;
    }

    public String getExtendedTestclass() {
        return this.extendedTestclass;
    }

    public void setExtendedTestclass(String extendedTestclass) {
        this.extendedTestclass = extendedTestclass;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        if (folder != null && !folder.isEmpty()) {
            this.folder = folder;
        }
    }

    public String getDocdir() {
        return this.docdir;
    }

    public void setDocdir(String docdir) {
        this.docdir = docdir;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        if (StringUtils.isNotBlank((CharSequence)template)) {
            this.template = template;
        }
    }

    public String getDocExtension() {
        return this.docExtension;
    }

    public void setDocExtension(String docExtension) {
        if (StringUtils.isNotBlank((CharSequence)docExtension)) {
            this.docExtension = docExtension;
        }
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTemplateFolder() {
        return this.templateFolder;
    }

    public void setTemplateFolder(String templateFolder) {
        this.templateFolder = templateFolder;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        if (StringUtils.isNotBlank((CharSequence)encoding)) {
            this.encoding = Charset.forName(encoding);
        }
    }

    public static enum SupportedJunitVersion {
        junit4(4, Test.class, Before.class),
        junit5(5, org.junit.jupiter.api.Test.class, BeforeEach.class);

        private final int junitVersion;
        private final Class<?> testAnnotationClass;
        private final Class<?> beforeAnnotationClass;

        private SupportedJunitVersion(int versionnumber, Class<?> testAnnotationClass, Class<?> beforeAnnotationClass) {
            this.junitVersion = versionnumber;
            this.testAnnotationClass = testAnnotationClass;
            this.beforeAnnotationClass = beforeAnnotationClass;
        }

        public static SupportedJunitVersion getByVersionnumber(String versionNumber) throws NotSupportedJunitVersionException {
            return Arrays.stream(SupportedJunitVersion.values()).filter(js -> Objects.equals(versionNumber, String.valueOf(js.junitVersion))).findFirst().orElseThrow(NotSupportedJunitVersionException::new);
        }

        public static Set<String> getSupportedVersionNumbers() {
            return Arrays.stream(SupportedJunitVersion.values()).map(js -> String.valueOf(js.junitVersion)).collect(Collectors.toSet());
        }

        public Class<?> getTestAnnotationClass() {
            return this.testAnnotationClass;
        }

        public Class<?> getBeforeAnnotationClass() {
            return this.beforeAnnotationClass;
        }
    }
}

