const bytecoder = {
    imports: {
        "java.lang.System": {
            J$currentTimeMillis$$: function () {
                return Date.now();
            },
        },
        "java.lang.Object": {
            Ljava$lang$Class$$getClass$$: function (inst) {
                return inst.constructor.$rt;
            },
        },
        "java.lang.NullPointerException": {
            Ljava$lang$String$$getExtendedNPEMessage$$: function(inst) {
                return null;
            }
        },
        "jdk.internal.misc.ScopedMemoryAccess": {
            V$registerNatives$$: function () {
            },
        },
        "java.lang.Float": {
            I$floatToRawIntBits$F: function (value) {
                let fl = new Float32Array(1);
                fl[0] = value;
                let br = new Int32Array(fl.buffer);
                return br[0];
            },
            Z$isNaN$D: function (a) {
                return isNaN(a) ? 1 : 0
            },
            Z$isNaN$F: function (a) {
                return isNaN(a) ? 1 : 0
            },
            Z$isInfinite$F: function (a) {
                return (a === Number.POSITIVE_INFINITY || a === Number.NEGATIVE_INFINITY) ? 1 : 0
            },
            Ljava$lang$String$$toString$F: function (value) {
                let str = value.toString();
                if (str.indexOf(".") < 0) {
                    str += '.0';
                }
                return bytecoder.toBytecoderString(str);
            },
            F$parseFloat$Ljava$lang$String$: function (value) {
                return parseFloat(value.nativeObject);
            },
        },
        "java.lang.Math": {
            I$min$I$I: function (a, b) {
                return Math.min(a, b);
            },
            J$min$J$J: function (a, b) {
                return Math.min(a, b);
            },
            D$min$D$D: function (a, b) {
                return Math.min(a, b);
            },
            F$min$F$F: function (a, b) {
                return Math.min(a, b);
            },
            D$max$D$D: function (a, b) {
                return Math.max(a, b);
            },
            I$max$I$I: function (a, b) {
                return Math.max(a, b);
            },
            J$max$J$J: function (a, b) {
                return Math.max(a, b);
            },
            D$floor$D: function (a) {
                return Math.floor(a);
            },
            F$floor$F: function (a) {
                return Math.floor(a);
            },
            D$ceil$D: function (a) {
                return Math.ceil(a);
            },
            F$ceil$F: function (a) {
                return Math.ceil(a);
            },
            D$toRadians$D: function (a) {
                return a * (Math.PI / 180.0);
            },
            D$toDegrees$D: function (a) {
                return a * (180. / Math.PI);
            },
            D$cos$D: function (a) {
                return Math.cos(a);
            },
            D$sin$D: function (a) {
                return Math.sin(a);
            },
            D$tan$D: function (a) {
                return Math.tan(a);
            },
            D$sqrt$D: function (a) {
                return Math.sqrt(a);
            },
            D$cbrt$D: function (a) {
                return Math.cbrt(a);
            },
            D$log$D: function (a) {
                return Math.log(a);
            },
            D$random$$: function () {
                return Math.random();
            },
        },
        "java.lang.StrictMath": {
            D$sqrt$D: function (a) {
                return Math.sqrt(a);
            },
            I$round$F: function(a) {
                return Math.round(a);
            },
            D$sin$D: function(a) {
                return Math.sin(a);
            },
            D$cos$D: function(a) {
                return Math.sin(a);
            }
        },
        "java.lang.reflect.Array": {
            Ljava$lang$Object$$newArray$Ljava$lang$Class$$I: function (t, l) {
                return bytecoder.newarray(l, null);
            },
        },
        "jdk.internal.misc.CDS": {
            Z$isDumpingClassList0$$: function () {
                return 0;
            },
            Z$isDumpingArchive0$$: function () {
                return 0;
            },
            Z$isSharingEnabled0$$: function () {
                return 0;
            },
            V$initializeFromArchive$Ljava$lang$Class$: function (cls) {
            },
            J$getRandomSeedForDumping$$: function(cls) {
                return Math.trunc(Math.random() * 10000000);
            },
        },
        "java.io.UnixFileSystem": {
            I$getBooleanAttributes0$Ljava$lang$String$: function (fsref, path) {
                let jsPath = bytecoder.toJSString(path);
                try {
                    let request = new XMLHttpRequest();
                    request.open('HEAD', jsPath, false);
                    request.send(null);
                    if (request.status === 200) {
                        let length = request.getResponseHeader('content-length');
                        return 0x01;
                    }
                    return 0;
                } catch (e) {
                    return 0;
                }
            },
        },
        "java.lang.Class": {
            Ljava$lang$ClassLoader$$getClassLoader$$: function (classRef) {
                return null;
            },
            Ljava$lang$Class$$forName$Ljava$lang$String$$Z$Ljava$lang$ClassLoader$: function(className, initialize, classLoader) {
                throw 'Not supported class for reflective access';
            },
            Z$desiredAssertionStatus$$: function(classRef) {
                return false;
            }
        },
        "java.io.FileInputStream": {
            I$open0$Ljava$io$FileDescriptor$$Ljava$lang$String$: function (fis, fdd, name) {
                let fd = bytecoder.openForRead(bytecoder.toJSString(name));
                if (fd >= 0) {
                    bytecoder.exports["setFileDescriptorHandle"].call(fdd, fd);
                }
                return fd;
            },
            J$skip0$Ljava$io$FileDescriptor$$I: function (fis, fdd, amount) {
                let fd = bytecoder.exports["getFileDescriptorHandle"].call(fdd);
                let x = bytecoder.filehandles[fd];
                return x.J$skip0$I(fd, amount);
            },
            I$available0$Ljava$io$FileDescriptor$: function (fis, fdd) {
                let fd = bytecoder.exports["getFileDescriptorHandle"].call(fdd);
                let x = bytecoder.filehandles[fd];
                return x.I$available0$$(fd);
            },
            I$read0$Ljava$io$FileDescriptor$: function (fis, fdd) {
                let fd = bytecoder.exports["getFileDescriptorHandle"].call(fdd);
                let x = bytecoder.filehandles[fd];
                return x.I$read0$$(fd);
            },
            I$readBytes$Ljava$io$FileDescriptor$$$B$I$I: function (fis, fdd, b, off, len) {
                let fd = bytecoder.exports["getFileDescriptorHandle"].call(fdd);
                let x = bytecoder.filehandles[fd];
                return x.I$readBytes$$B$I$I(fd, b, off, len);
            },
        },
        "java.io.FileOutputStream": {
            V$writeBytes$Ljava$io$FileDescriptor$$$B$I$I: function (fis, fdd, b, off, len) {
                let fd = bytecoder.exports["getFileDescriptorHandle"].call(fdd);
                let x = bytecoder.filehandles[fd];
                x.V$writeBytes$$B$I$I(fd, b, off, len);
            },
            V$writeInt$Ljava$io$FileDescriptor$$I: function (fis, fdd, cp) {
                let fd = bytecoder.exports["getFileDescriptorHandle"].call(fdd);
                let x = bytecoder.filehandles[fd];
                x.V$writeInt$I(fd, cp);
            },
            V$close0$Ljava$io$FileDescriptor$: function(fis, fdd) {
                let fd = bytecoder.exports["getFileDescriptorHandle"].call(fdd);
                bytecoder.filehandles[fd] = null;
            }
        },
        "de.mirkosertic.bytecoder.classlib.BytecoderCharsetDecoder": {
            $C$decodeFromBytes$Ljava$lang$String$$$B: function (decoder, charsetName, data) {
                let targetCharacterSet = charsetName.nativeObject;
                let byteData = new Uint8Array(data.data);
                let dec = new TextDecoder(targetCharacterSet);

                let str = dec.decode(byteData);

                let charArray = bytecoder.newarray(str.length, 0);
                for (let i = 0; i < str.length; i++) {
                    charArray.data[i] = str.codePointAt(i);
                }
                return charArray;
            },
        },
        "de.mirkosertic.bytecoder.classlib.BytecoderCharsetEncoder": {
            $B$encodeToBytes$Ljava$lang$String$$$C: function (encoder, charsetName, data) {
                let str = '';
                for (var i = 0; i < data.data.length; i++) {
                    str += String.fromCodePoint(data.data[i]);
                }

                let targetCharacterSet = charsetName.nativeObject;
                if (targetCharacterSet !== 'UTF-8') {
                    throw 'Not supported character set!';
                }

                let enc = new TextEncoder();
                let byteData = enc.encode(str);

                let bytes = bytecoder.newarray(byteData.length, 0);
                for (var i = 0; i < byteData.length; i++) {
                    bytes.data[i] = byteData[i];
                }

                return bytes;
            },
        },
        "java.lang.StringBuffer": {
            V$initializeWith$I: function (buffer, size) {
                buffer.nativeObject = '';
            },
            Ljava$lang$StringBuffer$$append$Ljava$lang$String$: function (buffer, str) {
                buffer.nativeObject += str.nativeObject;
            },
            Ljava$lang$String$$toString$$: function (buffer) {
                return bytecoder.toBytecoderString(buffer.nativeObject);
            },
        },
        "java.lang.StringBuilder": {
            V$initializeWith$I: function (builder, size) {
                builder.nativeObject = '';
            },
            Ljava$lang$StringBuilder$$append$Ljava$lang$String$: function (builder, str) {
                builder.nativeObject += str.nativeObject;
                return builder;
            },
            Ljava$lang$StringBuilder$$append$Ljava$lang$CharSequence$$I$I: function (builder, str, start, end) {
                builder.nativeObject += str.nativeObject.substring(start, end);
                return builder;
            },
            Ljava$lang$String$$toString$$: function (builder) {
                return bytecoder.toBytecoderString(builder.nativeObject);
            },
            I$length$$: function (builder) {
                return builder.nativeObject.length;
            },
            V$setLength$I: function (builder, size) {
            },
            Ljava$lang$StringBuilder$$append$$C$I$I: function (builder, chars, offset, count) {
                for (let i = offset; i < offset + count; i++) {
                    builder.nativeObject += String.fromCodePoint(chars.data[i]);
                }
                return builder;
            },
            Ljava$lang$StringBuilder$$deleteCharAt$I: function(builder, index) {
                const current = builder.nativeObject;
                builder.nativeObject = current.slice(0, index) + current.slice(index + 1);
                return builder;
            },
            V$setCharAt$I$C: function(builder, index, char) {
                const current = builder.nativeObject;
                builder.nativeObject = current.slice(0, index) + String.fromCodePoint(char) + current.slice(index + 1);
            },
            Ljava$lang$StringBuilder$$insert$I$C: function(builder, index, char) {
                const current = builder.nativeObject;
                builder.nativeObject = current.slice(0, index) + String.fromCodePoint(char) + current.slice(index);
                return builder
            },
            C$charAt$I: function(builder, index) {
                const current = builder.nativeObject;
                return current.codePointAt(index);
            }
        },
        "java.lang.String": {
            C$charAt$I: function (str, index) {
                return str.nativeObject.codePointAt(index);
            },
            I$length$$: function (str) {
                return str.nativeObject.length;
            },
            V$getChars$I$I$$C$I: function (str, srcBegin, srcEnd, dst, dstBegin) {
                let dstOffset = dstBegin;
                let s = str.nativeObject;
                for (let i = srcBegin; i < srcEnd; i++) {
                    dst.data[dstOffset] = s.codePointAt(i);
                    dstOffset++;
                }
            },
            I$indexOf$I: function (str, cp) {
                if (cp >= 0) {
                    return str.nativeObject.indexOf(String.fromCodePoint(cp));
                }
                return -1;
            },
            I$lastIndexOf$I: function (str, cp) {
                if (cp >= 0) {
                    const a = bytecoder.toJSString(str);
                    return a.lastIndexOf(String.fromCodePoint(cp));
                }
                return -1;
            },
            Z$startsWith$Ljava$lang$String$: function (str, otherstr) {
                const a = bytecoder.toJSString(str);
                const b = bytecoder.toJSString(otherstr);
                if (a.startsWith(b)) {
                    return 1;
                }
                return 0;
            },
            Z$endsWith$Ljava$lang$String$: function (str, otherstr) {
                const a = bytecoder.toJSString(str);
                const b = bytecoder.toJSString(otherstr);
                if (a.endsWith(b)) {
                    return 1;
                }
                return 0;
            },
            Ljava$lang$String$$replaceAll$Ljava$lang$String$$Ljava$lang$String$(str, regex, replacement) {
                return str;
            },
            I$lastIndexOf$Ljava$lang$String$: function (str, s) {
                return str.nativeObject.lastIndexOf(s.nativeObject);
            },
            Ljava$lang$String$$trim$$: function (str) {
                return bytecoder.toBytecoderString(str.nativeObject.trim());
            },
            Ljava$lang$String$$substring$I: function(str, i) {
                return bytecoder.toBytecoderString(str.nativeObject.substring(i));
            },
            Ljava$lang$String$$substring$I$I: function(str, i, b) {
                return bytecoder.toBytecoderString(str.nativeObject.substring(i, b));
            },
            Ljava$lang$String$$repeat$I: function (str, amount) {
                return bytecoder.toBytecoderString(str.nativeObject.repeat(amount));
            },
            Z$equals0$Ljava$lang$String$: function (str, otherstr) {
                if (str.nativeObject === otherstr.nativeObject) {
                    return 1;
                }
                return 0;
            },
            Z$equalsIgnoreCase$Ljava$lang$String$: function (str, otherstr) {
                if (str == null) {
                    return 0;
                }
                if (otherstr == null) {
                    return 0;
                }
                if (str.nativeObject.toUpperCase() === otherstr.nativeObject.toUpperCase()) {
                    return 1;
                }
                return 0;
            },
            V$initializeWith$$C$I$I: function (str, chars, offset, count) {
                str.nativeObject = '';
                for (let i = offset; i < offset + count; i++) {
                    str.nativeObject += String.fromCodePoint(chars.data[i]);
                }
            },
            V$initializeWith$$I$I$I: function (str, points, offset, count) {
                str.nativeObject = '';
                for (let i = offset; i < offset + count; i++) {
                    str.nativeObject += String.fromCodePoint(points.data[i]);
                }
            },
            $C$toCharArray$$: function (str) {
                let arr = bytecoder.newarray(str.nativeObject.length, 0);
                for (let i = 0; i < str.nativeObject.length; i++) {
                    arr.data[i] = str.nativeObject.codePointAt(i);
                }
                return arr;
            },
            V$initializeWith$Ljava$lang$String$: function (str, otherstr) {
                str.nativeObject = otherstr.nativeObject;
            },
            V$initializeWith$$B$I$I$B: function(str, bytes, index, count, coder) {
                const arr = new Uint8Array(bytecoder.exports.byteArrayLength(bytes))
                for (var i = index; i < index + count; i++) {
                    arr[i - index] = bytecoder.exports.getByteArrayEntry(bytes, i);
                }
                const jsstr = new TextDecoder().decode(arr);
                str.nativeObject = jsstr;
            },
            $B$getBytes$$: function(str) {
                const jsstr = str.nativeObject;
                const bytes = new TextEncoder().encode(jsstr);

                const arr = bytecoder.exports.newByteArray(bytes.length);
                for (var i = 0; i < bytes.length; i++) {
                    bytecoder.exports.setByteArrayEntry(arr, i, bytes[i]);
                }

                return arr;
            },
            Ljava$lang$String$$toUpperCase$$: function(str) {
                return bytecoder.toBytecoderString(str.nativeObject.toUpperCase());
            },
            Ljava$lang$String$$toLowerCase$$: function(str) {
                return bytecoder.toBytecoderString(str.nativeObject.toLowerCase());
            }
        },
        "java.lang.Character": {
            Z$isDigit$C: function (char) {
                if ("0123456789".indexOf(String.fromCodePoint(char)) >= 0) {
                    return 1;
                }
                return 0;
            },
            Z$isLowerCase$C: function (char) {
                let str = String.fromCodePoint(char);
                if (str.toLowerCase() === str) {
                    return 1;
                }
                return 0;
            },
            Z$isUpperCase$C: function (char) {
                let str = String.fromCodePoint(char);
                if (str.toUpperCase() === str) {
                    return 1;
                }
                return 0;
            },
            C$toLowerCase$C: function (char) {
                let str = String.fromCodePoint(char).toLowerCase();
                return str.codePointAt(0);
            },
            C$toUpperCase$C: function (char) {
                let str = String.fromCodePoint(char).toUpperCase();
                return str.codePointAt(0);
            },
            I$digit$C$I: function (char, radix) {
                let str = String.fromCodePoint(char).toUpperCase();
                if ('0' === str) {
                    return 0;
                }
                if ('1' === str) {
                    return 1;
                }
                if ('2' === str) {
                    return 2;
                }
                if ('3' === str) {
                    return 3;
                }
                if ('4' === str) {
                    return 4;
                }
                if ('5' === str) {
                    return 5;
                }
                if ('6' === str) {
                    return 6;
                }
                if ('7' === str) {
                    return 7;
                }
                if ('8' === str) {
                    return 8;
                }
                if ('9' === str) {
                    return 9;
                }
                if ('A' === str) {
                    return 10;
                }
                if ('B' === str) {
                    return 11;
                }
                if ('C' === str) {
                    return 12;
                }
                if ('D' === str) {
                    return 13;
                }
                if ('E' === str) {
                    return 14;
                }
                if ('15' === str) {
                    return 15;
                }
                return -1;
            },
            Ljava$lang$String$$toString$C: function (char) {
                return bytecoder.toBytecoderString(String.fromCodePoint(char));
            },
        },
        "java.lang.Byte": {
            Ljava$lang$String$$toString$B$I: function (value, radix) {
                return bytecoder.toBytecoderString(value.toString(radix));
            },
            B$parseByte$Ljava$lang$String$: function (str) {
                return parseInt(str.nativeObject);Ljava$lang$String$$replaceAll$Ljava$lang$String$$Ljava$lang$String$
            },
        },
        "java.lang.Short": {
            Ljava$lang$String$$toString$S$I: function (value, radix) {
                return bytecoder.toBytecoderString(value.toString(radix));
            },
            S$parseShort$Ljava$lang$String$$I: function (value, radix) {
                return parseInt(value.nativeObject, radix);
            },
        },
        "java.lang.Integer": {
            Ljava$lang$String$$toString$I$I: function (value, radix) {
                return bytecoder.toBytecoderString(value.toString(radix));
            },
            Ljava$lang$String$$toHexString$I: function (value) {
                return bytecoder.toBytecoderString(value.toString(16));
            },
            I$parseInt$Ljava$lang$String$$I: function (value, radix) {
                return parseInt(value.nativeObject, radix);
            },
        },
        "java.lang.Long": {
            Ljava$lang$String$$toString$J$I: function (value, radix) {
                return bytecoder.toBytecoderString(value.toString(radix));
            },
            J$parseLong$Ljava$lang$String$$I: function (value, radix) {
                return parseInt(value.nativeObject, radix);
            },
        },
        "java.lang.Double": {
            Ljava$lang$String$$toString$D: function (value) {
                let str = value.toString();
                if (str.indexOf(".") < 0) {
                    str += '.0';
                }
                return bytecoder.toBytecoderString(str);
            },
            D$parseDouble$Ljava$lang$String$: function (str) {
                return parseFloat(str.nativeObject);
            },
            Z$isNaN$D: function (d) {
                return isNaN(d) ? 1 : 0;
            },
            Z$isInfinite$D: function (d) {
                return isFinite(d) ? 1 : 0;
            }
        },
        "runtime": {
            nativeconsole: function() {
                return console;
            },
            nativewindow: function() {
                return window;
            },
            nativedocument: function() {
                return document;
            }
        },
        "de.mirkosertic.bytecoder.api.web.OpaqueArrays": {
            Lde$mirkosertic$bytecoder$api$web$FloatArray$$createFloatArray$I: function(length) {
                return new Float32Array(length);
            },
            'Lde$mirkosertic$bytecoder$api$web$IntArray$$createIntArray$I': function(length) {
                return new Int32Array(length);
            },
            'Lde$mirkosertic$bytecoder$api$web$Int16Array$$createInt16Array$I': function(length) {
                return new Int16Array(length);
            },
            'Lde$mirkosertic$bytecoder$api$web$Int8Array$$createInt8Array$I': function(length) {
                return new Int8Array(length);
            },
            'Lde$mirkosertic$bytecoder$api$web$OpaqueReferenceArray$$createObjectArray$$': function(length) {
                return [];
            }
        },
    },
    exports: {},
    filehandles : [],
    stringconstants: [],
    generated: [],
    cmp: function(a,b) {
        if (a > b) return 1;
        if (a < b) return -1;
        return 0;
    },
    instanceOf: function(a,b) {
        if (a) {
            let rt = a.constructor.$rt;
            return rt.instanceOf(a, b);
        }
        return 0;
    },
    registerStack: function(exception, stack) {
        exception.stack = stack;
        return exception;
    },
    toJSString: function(str) {
        if (str) {
            return str.nativeObject;
        }
        return '';
    },
    newarray: function(len, defaultvalue) {
        let x = new de$mirkosertic$bytecoder$classlib$Array();
        x.data = new Array(len);
        x.data.fill(defaultvalue);
        return x;
    },
    toBytecoderString: function(jsstring) {
        const x = new java$lang$String();
        x.V$$init$$$.call(x);
        x.nativeObject = jsstring;
        return x;
    },
    toBytecoderBoolean: function(v) {
        return v ? 1: 0;
    },
    instanceWithLambdaImpl: function(instType, lambdaImpl) {
        let inst = new instType();
        inst.$lambdaimpl = lambdaImpl.bind(inst);
        return inst;
    },
    primitives: {
        byte: {
        },
        char: {
        },
        short: {
        },
        int: {
        },
        float: {
        },
        double: {
        },
        long: {
        },
        boolean: {
        },
        void: {
        }
    },
    openForRead :  function(path) {
        try {
            let request = new XMLHttpRequest();
            request.open('GET',path,false);
            request.overrideMimeType('text/plain; charset=x-user-defined');
            request.send(null);
            if (request.status === 200) {
                let length = request.getResponseHeader('content-length');
                let responsetext = request.response;
                let buf = new ArrayBuffer(responsetext.length);
                let bufView = new Uint8Array(buf);
                let i = 0;
                const strLen = responsetext.length;
                for (; i < strLen; i++) {
                    bufView[i] = responsetext.charCodeAt(i) & 0xff;
                }
                let handle = bytecoder.filehandles.length;
                bytecoder.filehandles[handle] = {
                    currentpos: 0,
                    data: bufView,
                    size: length,
                    J$skip0$I: function(fd, amount) {
                        let remaining = this.size - this.currentpos;
                        let possible = Math.min(remaining, amount);
                        this.currentpos += possible;
                        return possible;
                    },
                    I$available0$$: function(fd) {
                        return this.size - this.currentpos;
                    },
                    I$read0$$: function(fd) {
                        return this.data[this.currentpos++];
                    },
                    I$readBytes$$B$I$I: function(fd, target, offset, length) {
                        if (length === 0) {return 0;}
                        let remaining = this.size - this.currentpos;
                        let possible = Math.min(remaining, length);
                        if (possible === 0) {return -1;}
                        for (let j=0; j<possible; j++) {
                            target.data[offset++] = this.data[this.currentpos++];
                        }
                        return possible;
                    }
                };
                return handle;
            }
            return -1;
        } catch(e) {
            return -1;
        }
    },
    newRuntimeClassFor: function(type,supportedtypes) {
        return {
            Ljava$lang$ClassLoader$$getClassLoader$$: function() {
                return null;
            },
            Ljava$lang$ClassLoader$$getClassLoader0$$: function() {
                return null;
            },
            Z$desiredAssertionStatus$$: function() {
                return false;
            },
            Ljava$lang$Object$$newInstance$$: function() {
                const x = new type.$i();
                x.V$$init$$$();
                return x;
            },
            $Ljava$lang$Object$$getEnumConstants$$: function() {
                return type.$i.$VALUES;
            },
            instanceOf: function(a, b) {
                if (supportedtypes.includes(b)) {
                    return 1;
                }
                return 0;
            },
        };
    },
    wrapNativeIntoTypeInstance: function(instType, value) {
        let inst = new instType();
        inst.nativeObject = value;
        return inst;
    }
};

bytecoder.filehandles[1] = {
    V$writeBytes$$B$I$I: function(fd, b, off, len) {
        let decoder = new TextDecoder();
        let arr = new Uint8Array(b.data.slice(off, off +  len));
        console.log(decoder.decode(arr).replace('\n', ''));
    },
    V$writeInt$I: function(fd, cp) {
        let decoder = new TextDecoder();
        let arr = new Uint8Array([cp]);
        console.log(decoder.decode(arr).replace('\n', ''));
    },
};

bytecoder.imports["java.lang.Class"]["Ljava$lang$Class$$forName$Ljava$lang$String$$Z$Ljava$lang$ClassLoader$"] = function(className, initialize, classLoader) {
  throw 'Not supported class for reflective access';
};


class java$lang$Object {
  nativeObject = null;
  constructor() {
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Object,[java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  Ljava$lang$String$$toString$$() {
    // source file is Object.java
    // line number 36
    return bytecoder.stringconstants[1];
  }

  Z$equals$Ljava$lang$Object$(arg0) {
    // source file is Object.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var phi3 = null;
    var phi4 = null;
    var phi5 = 0;
    var0 = arg0;
    // line number 40
    var1 = var0;
    If_9_0: {
     if (this != var1) {
      phi3 = this;
      phi4 = var0;
      phi5 = (0) | 0;
      break If_9_0;
     } else {
      var2 = (1) | 0;
      // Here was a goto statement
      phi3 = this;
      phi4 = var0;
      phi5 = (var2) | 0;
      break If_9_0;
     }
    }
    return phi5;
  }

  V$$init$$$() {
    // source file is Object.java
    return;
  }

  Ljava$lang$Object$$clone$$() {
    // source file is Object.java
    var var0 = null;
    // line number 48
    var0 = new java$lang$CloneNotSupportedException();
    java$lang$CloneNotSupportedException.prototype.V$$init$$$.call(var0);
    throw bytecoder.registerStack(var0, new Error().stack);
  }

  I$hashCode$$() {
    // source file is Object.java
    // line number 44
    return 0;
  }
}


class org$jbox2d$collision$TimeOfImpact extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;
  static toiCalls = 0;
  static toiIters = 0;
  static toiMaxIters = 0;
  static toiRootIters = 0;
  static toiMaxRootIters = 0;
  cache = null;
  distanceInput = null;
  xfA = null;
  xfB = null;
  distanceOutput = null;
  fcn = null;
  indexes = null;
  sweepA = null;
  sweepB = null;
  pool = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$collision$TimeOfImpact,[org$jbox2d$collision$TimeOfImpact,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is TimeOfImpact.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    // line number 42
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(org$jbox2d$collision$TimeOfImpact.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    org$jbox2d$collision$TimeOfImpact.$i;
    org$jbox2d$collision$TimeOfImpact.$assertionsDisabled = phi2;
    // line number 45
    org$jbox2d$collision$TimeOfImpact.toiCalls = 0;
    // line number 46
    org$jbox2d$collision$TimeOfImpact.toiIters = 0;
    // line number 47
    org$jbox2d$collision$TimeOfImpact.toiMaxIters = 0;
    // line number 48
    org$jbox2d$collision$TimeOfImpact.toiRootIters = 0;
    // line number 49
    org$jbox2d$collision$TimeOfImpact.toiMaxRootIters = 0;
    return;
  }

  V$$init$$Lorg$jbox2d$pooling$IWorldPool$(arg0) {
    // source file is TimeOfImpact.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var0 = arg0;
    // line number 96
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 83
    var1 = this;
    var2 = new org$jbox2d$collision$Distance$SimplexCache();
    org$jbox2d$collision$Distance$SimplexCache.prototype.V$$init$$$.call(var2);
    var1.cache = var2;
    // line number 84
    var3 = this;
    var4 = new org$jbox2d$collision$DistanceInput();
    org$jbox2d$collision$DistanceInput.prototype.V$$init$$$.call(var4);
    var3.distanceInput = var4;
    // line number 85
    var5 = this;
    org$jbox2d$common$Transform.$i;
    var6 = new org$jbox2d$common$Transform();
    org$jbox2d$common$Transform.prototype.V$$init$$$.call(var6);
    var5.xfA = var6;
    // line number 86
    var7 = this;
    var8 = new org$jbox2d$common$Transform();
    org$jbox2d$common$Transform.prototype.V$$init$$$.call(var8);
    var7.xfB = var8;
    // line number 87
    var9 = this;
    var10 = new org$jbox2d$collision$DistanceOutput();
    org$jbox2d$collision$DistanceOutput.prototype.V$$init$$$.call(var10);
    var9.distanceOutput = var10;
    // line number 88
    var11 = this;
    org$jbox2d$collision$SeparationFunction.$i;
    var12 = new org$jbox2d$collision$SeparationFunction();
    org$jbox2d$collision$SeparationFunction.prototype.V$$init$$$.call(var12);
    var11.fcn = var12;
    // line number 89
    var13 = this;
    var14 = bytecoder.newarray((2),0);
    var13.indexes = var14;
    // line number 90
    var15 = this;
    org$jbox2d$common$Sweep.$i;
    var16 = new org$jbox2d$common$Sweep();
    org$jbox2d$common$Sweep.prototype.V$$init$$$.call(var16);
    var15.sweepA = var16;
    // line number 91
    var17 = this;
    var18 = new org$jbox2d$common$Sweep();
    org$jbox2d$common$Sweep.prototype.V$$init$$$.call(var18);
    var17.sweepB = var18;
    // line number 97
    var19 = this;
    var19.pool = var0;
    // line number 98
    return;
  }

  V$timeOfImpact$Lorg$jbox2d$collision$TimeOfImpact$TOIOutput$$Lorg$jbox2d$collision$TimeOfImpact$TOIInput$(arg0,arg1) {
    // source file is TimeOfImpact.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = .0;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = .0;
    var var17 = .0;
    var var18 = .0;
    var var19 = .0;
    var var20 = .0;
    var var21 = .0;
    var var22 = .0;
    var var23 = 0;
    var var24 = .0;
    var var25 = 0;
    var var26 = null;
    var phi27 = null;
    var phi28 = null;
    var phi29 = null;
    var phi30 = null;
    var phi31 = null;
    var phi32 = .0;
    var phi33 = .0;
    var phi34 = .0;
    var phi35 = .0;
    var var36 = .0;
    var var37 = null;
    var var38 = null;
    var var39 = null;
    var var40 = null;
    var var41 = null;
    var var42 = null;
    var var43 = null;
    var var44 = null;
    var var45 = null;
    var var46 = null;
    var var47 = null;
    var var48 = null;
    var phi49 = .0;
    var phi50 = 0;
    var var51 = null;
    var var52 = null;
    var var53 = null;
    var var54 = null;
    var var55 = .0;
    var var56 = null;
    var var57 = null;
    var var58 = null;
    var var59 = null;
    var var60 = .0;
    var var61 = null;
    var var62 = null;
    var var63 = null;
    var var64 = null;
    var var65 = null;
    var var66 = null;
    var var67 = null;
    var var68 = null;
    var var69 = null;
    var var70 = null;
    var var71 = null;
    var var72 = null;
    var var73 = null;
    var var74 = null;
    var var75 = null;
    var var76 = null;
    var var77 = null;
    var var78 = null;
    var var79 = null;
    var var80 = .0;
    var var81 = 0;
    var var82 = null;
    var var83 = null;
    var var84 = null;
    var var85 = 0;
    var var86 = 0;
    var var87 = 0;
    var var88 = null;
    var var89 = null;
    var var90 = .0;
    var var91 = .0;
    var var92 = .0;
    var var93 = .0;
    var var94 = 0;
    var var95 = null;
    var var96 = null;
    var var97 = null;
    var var98 = .0;
    var var99 = null;
    var var100 = null;
    var var101 = null;
    var var102 = null;
    var var103 = null;
    var var104 = null;
    var var105 = null;
    var var106 = null;
    var var107 = null;
    var var108 = null;
    var var109 = .0;
    var var110 = .0;
    var var111 = .0;
    var phi112 = 0;
    var phi113 = .0;
    var phi114 = 0;
    var var115 = null;
    var var116 = null;
    var var117 = null;
    var var118 = null;
    var var119 = .0;
    var var120 = .0;
    var var121 = .0;
    var var122 = .0;
    var var123 = .0;
    var var124 = 0;
    var var125 = null;
    var var126 = null;
    var var127 = null;
    var var128 = .0;
    var phi129 = 0;
    var phi130 = .0;
    var var131 = 0;
    var var132 = 0;
    var var133 = 0;
    var var134 = 0;
    var var135 = null;
    var var136 = null;
    var var137 = null;
    var var138 = .0;
    var var139 = .0;
    var var140 = .0;
    var var141 = .0;
    var var142 = 0;
    var var143 = .0;
    var var144 = null;
    var var145 = null;
    var var146 = null;
    var var147 = null;
    var var148 = 0;
    var var149 = null;
    var var150 = null;
    var var151 = 0;
    var var152 = .0;
    var var153 = .0;
    var var154 = .0;
    var var155 = .0;
    var var156 = .0;
    var var157 = 0;
    var var158 = null;
    var var159 = null;
    var var160 = null;
    var var161 = .0;
    var var162 = .0;
    var var163 = .0;
    var var164 = .0;
    var var165 = 0;
    var var166 = null;
    var var167 = null;
    var var168 = null;
    var var169 = .0;
    var var170 = 0;
    var var171 = .0;
    var var172 = .0;
    var phi173 = .0;
    var phi174 = .0;
    var phi175 = 0;
    var phi176 = .0;
    var phi177 = .0;
    var var178 = 0;
    var var179 = 0;
    var var180 = .0;
    var var181 = .0;
    var var182 = .0;
    var var183 = .0;
    var var184 = .0;
    var var185 = .0;
    var var186 = .0;
    var var187 = .0;
    var var188 = .0;
    var var189 = .0;
    var var190 = .0;
    var var191 = .0;
    var var192 = .0;
    var phi193 = .0;
    var var194 = null;
    var var195 = null;
    var var196 = null;
    var var197 = null;
    var var198 = 0;
    var var199 = null;
    var var200 = null;
    var var201 = 0;
    var var202 = .0;
    var var203 = .0;
    var var204 = .0;
    var var205 = .0;
    var var206 = .0;
    var var207 = .0;
    var var208 = 0;
    var var209 = .0;
    var phi210 = .0;
    var phi211 = .0;
    var var212 = 0;
    var var213 = 0;
    var var214 = 0;
    var var215 = 0;
    var var216 = .0;
    var var217 = 0;
    var var218 = .0;
    var var219 = .0;
    var phi220 = .0;
    var phi221 = .0;
    var phi222 = .0;
    var var223 = 0;
    var var224 = 0;
    var var225 = 0;
    var var226 = .0;
    var var227 = .0;
    var var228 = .0;
    var var229 = .0;
    var var230 = .0;
    var var231 = .0;
    var0 = arg0;
    // line number 113
    org$jbox2d$collision$TimeOfImpact.$i;
    var1 = ((org$jbox2d$collision$TimeOfImpact.toiCalls)) | 0;
    var2 = ((var1 + 1)) | 0;
    org$jbox2d$collision$TimeOfImpact.toiCalls = var2;
    // line number 115
    org$jbox2d$collision$TimeOfImpact$TOIOutputState.$i;
    var3 = (org$jbox2d$collision$TimeOfImpact$TOIOutputState.UNKNOWN);
    var0.state = var3;
    // line number 116
    var4 = arg1;
    var5 = (var4.tMax);
    var0.t = var5;
    // line number 118
    var6 = (arg1.proxyA);
    // line number 119
    var7 = (arg1.proxyB);
    // line number 121
    var8 = (this.sweepA);
    var9 = (arg1.sweepA);
    var10 = (org$jbox2d$common$Sweep.prototype.Lorg$jbox2d$common$Sweep$$set$Lorg$jbox2d$common$Sweep$.call(var8,var9));
    // line number 122
    var11 = (this.sweepB);
    var12 = (arg1.sweepB);
    var13 = (org$jbox2d$common$Sweep.prototype.Lorg$jbox2d$common$Sweep$$set$Lorg$jbox2d$common$Sweep$.call(var11,var12));
    // line number 126
    var14 = (this.sweepA);
    org$jbox2d$common$Sweep.prototype.V$normalize$$.call(var14);
    // line number 127
    var15 = (this.sweepB);
    org$jbox2d$common$Sweep.prototype.V$normalize$$.call(var15);
    // line number 129
    var16 = (arg1.tMax);
    // line number 131
    var17 = (var6.m_radius);
    var18 = (var7.m_radius);
    var19 = (var17 + var18);
    // line number 133
    var20 = 0.015;
    var21 = (var19 - var20);
    org$jbox2d$common$MathUtils.$i;
    var22 = (org$jbox2d$common$MathUtils.F$max$F$F(0.005,var21));
    // line number 134
    // line number 136
    var23 = (org$jbox2d$collision$TimeOfImpact.$assertionsDisabled);
    If_118_0: {
     if (var23 != 0) {
      phi27 = this;
      phi28 = var0;
      phi29 = arg1;
      phi30 = var6;
      phi31 = var7;
      phi32 = var16;
      phi33 = var19;
      phi34 = var22;
      phi35 = 0.00125;
      break If_118_0;
     } else {
      var24 = var22;
      var25 = (bytecoder.cmp(var24,0.00125)) | 0;
      if (var25 > 0) {
       phi27 = this;
       phi28 = var0;
       phi29 = arg1;
       phi30 = var6;
       phi31 = var7;
       phi32 = var16;
       phi33 = var19;
       phi34 = var22;
       phi35 = 0.00125;
       break If_118_0;
      } else {
       var26 = new java$lang$AssertionError();
       java$lang$AssertionError.prototype.V$$init$$$.call(var26);
       throw bytecoder.registerStack(var26, new Error().stack);
      }
     }
    }
    // line number 138
    var36 = 0.0;
    // line number 139
    // line number 141
    var37 = phi27;
    var38 = (var37.cache);
    var38.count = 0;
    // line number 142
    var39 = phi27;
    var40 = (var39.distanceInput);
    var41 = phi29;
    var42 = (var41.proxyA);
    var40.proxyA = var42;
    // line number 143
    var43 = phi27;
    var44 = (var43.distanceInput);
    var45 = phi29;
    var46 = (var45.proxyB);
    var44.proxyB = var46;
    // line number 144
    var47 = phi27;
    var48 = (var47.distanceInput);
    var48.useRadii = 0;
    phi49 = var36;
    phi50 = (0) | 0;
    L221064458: while(true) {
     // line number 149
     var51 = phi27;
     var52 = (var51.sweepA);
     var53 = phi27;
     var54 = (var53.xfA);
     var55 = phi49;
     org$jbox2d$common$Sweep.prototype.V$getTransform$Lorg$jbox2d$common$Transform$$F.call(var52,var54,var55);
     // line number 150
     var56 = phi27;
     var57 = (var56.sweepB);
     var58 = phi27;
     var59 = (var58.xfB);
     var60 = phi49;
     org$jbox2d$common$Sweep.prototype.V$getTransform$Lorg$jbox2d$common$Transform$$F.call(var57,var59,var60);
     // line number 155
     var61 = phi27;
     var62 = (var61.distanceInput);
     var63 = phi27;
     var64 = (var63.xfA);
     var62.transformA = var64;
     // line number 156
     var65 = phi27;
     var66 = (var65.distanceInput);
     var67 = phi27;
     var68 = (var67.xfB);
     var66.transformB = var68;
     // line number 157
     var69 = phi27;
     var70 = (var69.pool);
     var71 = (var70.Lorg$jbox2d$collision$Distance$$getDistance$$());
     var72 = phi27;
     var73 = (var72.distanceOutput);
     var74 = phi27;
     var75 = (var74.cache);
     var76 = phi27;
     var77 = (var76.distanceInput);
     org$jbox2d$collision$Distance.prototype.V$distance$Lorg$jbox2d$collision$DistanceOutput$$Lorg$jbox2d$collision$Distance$SimplexCache$$Lorg$jbox2d$collision$DistanceInput$.call(var71,var73,var75,var77);
     // line number 165
     var78 = phi27;
     var79 = (var78.distanceOutput);
     var80 = (var79.distance);
     var81 = (bytecoder.cmp(var80,0.0)) | 0;
     If_297_0: {
      if (var81 > 0) {
       // line number 173
       var88 = phi27;
       var89 = (var88.distanceOutput);
       var90 = (var89.distance);
       var91 = phi34;
       var92 = phi35;
       var93 = (var91 + var92);
       var94 = (bytecoder.cmp(var90,var93)) | 0;
       if (var94 >= 0) {
        // line number 182
        var99 = phi27;
        var100 = (var99.fcn);
        var101 = phi27;
        var102 = (var101.cache);
        var103 = phi30;
        var104 = phi27;
        var105 = (var104.sweepA);
        var106 = phi31;
        var107 = phi27;
        var108 = (var107.sweepB);
        var109 = phi49;
        var110 = (org$jbox2d$collision$SeparationFunction.prototype.F$initialize$Lorg$jbox2d$collision$Distance$SimplexCache$$Lorg$jbox2d$collision$Distance$DistanceProxy$$Lorg$jbox2d$common$Sweep$$Lorg$jbox2d$collision$Distance$DistanceProxy$$Lorg$jbox2d$common$Sweep$$F.call(var100,var102,var103,var105,var106,var108,var109));
        // line number 187
        // line number 188
        var111 = phi32;
        // line number 189
        phi112 = (0) | 0;
        phi113 = var111;
        phi114 = (0) | 0;
        L767070566: while(true) {
         // line number 193
         var115 = phi27;
         var116 = (var115.fcn);
         var117 = phi27;
         var118 = (var117.indexes);
         var119 = phi113;
         var120 = (org$jbox2d$collision$SeparationFunction.prototype.F$findMinSeparation$$I$F.call(var116,var118,var119));
         // line number 196
         var121 = phi34;
         var122 = phi35;
         var123 = (var121 + var122);
         var124 = (bytecoder.cmp(var120,var123)) | 0;
         If_454_0: {
          if (var124 <= 0) {
           // line number 206
           var139 = phi34;
           var140 = phi35;
           var141 = (var139 - var140);
           var142 = (bytecoder.cmp(var120,var141)) | 0;
           if (var142 <= 0) {
            // line number 214
            var144 = phi27;
            var145 = (var144.fcn);
            var146 = phi27;
            var147 = (var146.indexes);
            var148 = ((var147.data[0])) | 0;
            var149 = phi27;
            var150 = (var149.indexes);
            var151 = ((var150.data[1])) | 0;
            var152 = phi49;
            var153 = (org$jbox2d$collision$SeparationFunction.prototype.F$evaluate$I$I$F.call(var145,var148,var151,var152));
            // line number 219
            var154 = phi34;
            var155 = phi35;
            var156 = (var154 - var155);
            var157 = (bytecoder.cmp(var153,var156)) | 0;
            if (var157 >= 0) {
             // line number 228
             var162 = phi34;
             var163 = phi35;
             var164 = (var162 + var163);
             var165 = (bytecoder.cmp(var153,var164)) | 0;
             if (var165 > 0) {
              // line number 238
              // line number 239
              var171 = phi49;
              var172 = phi113;
              phi173 = var120;
              phi174 = var153;
              phi175 = (0) | 0;
              phi176 = var171;
              phi177 = var172;
              L936668133: while(true) {
               // line number 243
               var178 = (phi175) | 0;
               var179 = ((var178 & 1)) | 0;
               If_697_0: {
                if (var179 != 1) {
                 // line number 248
                 var228 = phi176;
                 var229 = phi177;
                 var230 = (var228 + var229);
                 var231 = (0.5 * var230);
                 phi193 = var231;
                 break If_697_0;
                } else {
                 // line number 245
                 var180 = phi176;
                 var181 = phi34;
                 var182 = phi174;
                 var183 = (var181 - var182);
                 var184 = phi177;
                 var185 = phi176;
                 var186 = (var184 - var185);
                 var187 = (var183 * var186);
                 var188 = phi173;
                 var189 = phi174;
                 var190 = (var188 - var189);
                 var191 = (var187 / var190);
                 var192 = (var180 + var191);
                 // Here was a goto statement
                 phi193 = var192;
                 break If_697_0;
                }
               }
               // line number 251
               var194 = phi27;
               var195 = (var194.fcn);
               var196 = phi27;
               var197 = (var196.indexes);
               var198 = ((var197.data[0])) | 0;
               var199 = phi27;
               var200 = (var199.indexes);
               var201 = ((var200.data[1])) | 0;
               var202 = phi193;
               var203 = (org$jbox2d$collision$SeparationFunction.prototype.F$evaluate$I$I$F.call(var195,var198,var201,var202));
               // line number 253
               var204 = phi34;
               var205 = (var203 - var204);
               var206 = (org$jbox2d$common$MathUtils.F$abs$F(var205));
               var207 = phi35;
               var208 = (bytecoder.cmp(var206,var207)) | 0;
               If_783_0: {
                if (var208 >= 0) {
                 // line number 260
                 var216 = phi34;
                 var217 = (bytecoder.cmp(var203,var216)) | 0;
                 If_837_0: {
                  if (var217 <= 0) {
                   // line number 264
                   var226 = phi193;
                   // line number 265
                   var227 = var203;
                   phi173 = var227;
                   phi220 = phi174;
                   phi221 = phi176;
                   phi177 = var226;
                   phi222 = var203;
                   break If_837_0;
                  } else {
                   // line number 261
                   var218 = phi193;
                   // line number 262
                   var219 = var203;
                   // Here was a goto statement
                   phi220 = var219;
                   phi221 = var218;
                   phi222 = var203;
                   break If_837_0;
                  }
                 }
                 // line number 268
                 phi175 = ((phi175 + 1)) | 0;
                 // line number 269
                 var223 = ((org$jbox2d$collision$TimeOfImpact.toiRootIters)) | 0;
                 var224 = ((var223 + 1)) | 0;
                 org$jbox2d$collision$TimeOfImpact.toiRootIters = var224;
                 // line number 272
                 var225 = (phi175) | 0;
                 if (var225 != 50) {
                  // line number 275
                  // Here was a goto statement
                  phi174 = phi220;
                  phi176 = phi221;
                  continue L936668133;
                 } else {
                  // line number 273
                  // Here was a goto statement
                  phi210 = phi113;
                  phi174 = phi220;
                  phi176 = phi221;
                  phi211 = phi222;
                  break If_783_0;
                 }
                } else {
                 // line number 255
                 var209 = phi193;
                 // line number 256
                 // Here was a goto statement
                 phi210 = var209;
                 phi211 = var203;
                 break If_783_0;
                }
               }
               // line number 277
               var212 = ((org$jbox2d$collision$TimeOfImpact.toiMaxRootIters)) | 0;
               var213 = (phi175) | 0;
               var214 = ((org$jbox2d$common$MathUtils.I$max$I$I(var212,var213))) | 0;
               org$jbox2d$collision$TimeOfImpact.toiMaxRootIters = var214;
               // line number 279
               phi114 = ((phi114 + 1)) | 0;
               // line number 281
               var215 = (phi114) | 0;
               if (var215 != 8) {
                // line number 284
                // Here was a goto statement
                phi113 = phi210;
                continue L767070566;
               } else {
                // line number 282
                // Here was a goto statement
                phi129 = (phi112) | 0;
                phi113 = phi210;
                phi130 = phi173;
                break If_454_0;
               }
              }
             } else {
              // line number 231
              var166 = phi28;
              var167 = (org$jbox2d$collision$TimeOfImpact$TOIOutputState.TOUCHING);
              var166.state = var167;
              // line number 232
              var168 = phi28;
              var169 = phi49;
              var168.t = var169;
              // line number 233
              var170 = (1) | 0;
              // line number 234
              // Here was a goto statement
              phi129 = (var170) | 0;
              phi130 = var120;
              break If_454_0;
             }
            } else {
             // line number 221
             var158 = phi28;
             var159 = (org$jbox2d$collision$TimeOfImpact$TOIOutputState.FAILED);
             var158.state = var159;
             // line number 222
             var160 = phi28;
             var161 = phi49;
             var160.t = var161;
             // line number 223
             // line number 224
             // Here was a goto statement
             phi129 = (1) | 0;
             phi130 = var120;
             break If_454_0;
            }
           } else {
            // line number 209
            var143 = phi113;
            // line number 210
            // Here was a goto statement
            phi49 = var143;
            phi129 = (phi112) | 0;
            phi130 = var120;
            break If_454_0;
           }
          } else {
           // line number 199
           var125 = phi28;
           var126 = (org$jbox2d$collision$TimeOfImpact$TOIOutputState.SEPARATED);
           var125.state = var126;
           // line number 200
           var127 = phi28;
           var128 = phi32;
           var127.t = var128;
           // line number 201
           // line number 202
           // Here was a goto statement
           phi129 = (1) | 0;
           phi130 = var120;
           break If_454_0;
          }
         }
         // line number 286
         phi50 = ((phi50 + 1)) | 0;
         // line number 287
         var131 = ((org$jbox2d$collision$TimeOfImpact.toiIters)) | 0;
         var132 = ((var131 + 1)) | 0;
         org$jbox2d$collision$TimeOfImpact.toiIters = var132;
         // line number 289
         var133 = (phi129) | 0;
         if (var133 == 0) {
          // line number 294
          var134 = (phi50) | 0;
          if (var134 != 1000) {
           // line number 301
           // Here was a goto statement
           continue L221064458;
          } else {
           // line number 297
           var135 = phi28;
           var136 = (org$jbox2d$collision$TimeOfImpact$TOIOutputState.FAILED);
           var135.state = var136;
           // line number 298
           var137 = phi28;
           var138 = phi49;
           var137.t = var138;
           // line number 299
           // Here was a goto statement
           break If_297_0;
          }
         } else {
          // line number 291
          // Here was a goto statement
          break If_297_0;
         }
        }
       } else {
        // line number 176
        var95 = phi28;
        var96 = (org$jbox2d$collision$TimeOfImpact$TOIOutputState.TOUCHING);
        var95.state = var96;
        // line number 177
        var97 = phi28;
        var98 = phi49;
        var97.t = var98;
        // line number 178
        // Here was a goto statement
        break If_297_0;
       }
      } else {
       // line number 168
       var82 = phi28;
       var83 = (org$jbox2d$collision$TimeOfImpact$TOIOutputState.OVERLAPPED);
       var82.state = var83;
       // line number 169
       var84 = phi28;
       var84.t = 0.0;
       // line number 170
       // Here was a goto statement
       break If_297_0;
      }
     }
     // line number 304
     var85 = ((org$jbox2d$collision$TimeOfImpact.toiMaxIters)) | 0;
     var86 = (phi50) | 0;
     var87 = ((org$jbox2d$common$MathUtils.I$max$I$I(var85,var86))) | 0;
     org$jbox2d$collision$TimeOfImpact.toiMaxIters = var87;
     // line number 305
     return;
    }
  }
}


class java$lang$invoke$CallSite extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$invoke$CallSite,[java$lang$invoke$CallSite,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.Ljava$lang$invoke$MethodHandle$$getTarget$$ = impl;
  }

  V$$init$$$() {
    // source file is CallSite.java
    // line number 23
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class de$mirkosertic$bytecoder$classlib$java$lang$TThreadGroup extends java$lang$Object {
  nativeObject = null;

  name = null;
  parent = null;
  static SYSTEM = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(de$mirkosertic$bytecoder$classlib$java$lang$TThreadGroup,[de$mirkosertic$bytecoder$classlib$java$lang$TThreadGroup,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is TThreadGroup.java
    var var0 = null;
    // line number 23
    de$mirkosertic$bytecoder$classlib$java$lang$TThreadGroup.$i;
    var0 = new de$mirkosertic$bytecoder$classlib$java$lang$TThreadGroup();
    de$mirkosertic$bytecoder$classlib$java$lang$TThreadGroup.prototype.V$$init$$$.call(var0);
    de$mirkosertic$bytecoder$classlib$java$lang$TThreadGroup.SYSTEM = var0;
    return;
  }

  V$$init$$$() {
    // source file is TThreadGroup.java
    var var0 = null;
    var var1 = null;
    // line number 28
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 29
    var0 = this;
    var0.name = bytecoder.stringconstants[42];
    // line number 30
    var1 = this;
    var1.parent = null;
    // line number 31
    return;
  }
}


class org$jbox2d$dynamics$contacts$ContactVelocityConstraint extends java$lang$Object {
  nativeObject = null;

  points = null;
  normal = null;
  normalMass = null;
  K = null;
  friction = 0.0;
  restitution = 0.0;
  tangentSpeed = 0.0;
  indexA = 0;
  indexB = 0;
  invMassA = 0.0;
  invMassB = 0.0;
  invIA = 0.0;
  invIB = 0.0;
  contactIndex = 0;
  pointCount = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$dynamics$contacts$ContactVelocityConstraint,[org$jbox2d$dynamics$contacts$ContactVelocityConstraint,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is ContactVelocityConstraint.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var phi9 = null;
    var phi10 = 0;
    var var11 = 0;
    var var12 = null;
    var var13 = null;
    var var14 = 0;
    var var15 = null;
    var var16 = null;
    var var17 = 0;
    var var18 = null;
    // line number 45
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 31
    var0 = this;
    var1 = bytecoder.newarray((2),null);
    var0.points = var1;
    // line number 32
    var2 = this;
    org$jbox2d$common$Vec2.$i;
    var3 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var3);
    var2.normal = var3;
    // line number 33
    var4 = this;
    org$jbox2d$common$Mat22.$i;
    var5 = new org$jbox2d$common$Mat22();
    org$jbox2d$common$Mat22.prototype.V$$init$$$.call(var5);
    var4.normalMass = var5;
    // line number 34
    var6 = this;
    var7 = new org$jbox2d$common$Mat22();
    org$jbox2d$common$Mat22.prototype.V$$init$$$.call(var7);
    var6.K = var7;
    // line number 46
    var8 = (0) | 0;
    phi9 = this;
    phi10 = (var8) | 0;
    L112024400: while(true) {
     var11 = (phi10) | 0;
     var12 = phi9;
     var13 = (var12.points);
     var14 = (var13.data.length) | 0;
     if (var11 >= var14) {
      // line number 49
      return;
     } else {
      // line number 47
      var15 = phi9;
      var16 = (var15.points);
      var17 = (phi10) | 0;
      var18 = new org$jbox2d$dynamics$contacts$ContactVelocityConstraint$VelocityConstraintPoint();
      org$jbox2d$dynamics$contacts$ContactVelocityConstraint$VelocityConstraintPoint.prototype.V$$init$$$.call(var18);
      var16.data[var17] = var18;
      // line number 46
      phi10 = ((phi10 + 1)) | 0;
      // Here was a goto statement
      continue L112024400;
     }
    }
  }
}


class de$mirkosertic$bytecoder$classlib$java$lang$TMath$FloatExponents extends java$lang$Object {
  nativeObject = null;

  static exponents = null;
  static negativeExponents = null;
  static negativeExponents2 = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(de$mirkosertic$bytecoder$classlib$java$lang$TMath$FloatExponents,[de$mirkosertic$bytecoder$classlib$java$lang$TMath$FloatExponents,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is TMath.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = null;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = null;
    var var17 = 0;
    var var18 = 0;
    var var19 = 0;
    var var20 = 0;
    var var21 = 0;
    var var22 = 0;
    var var23 = 0;
    // line number 28
    var0 = bytecoder.newarray((7),0);
    var1 = (0) | 0;
    var0.data[var1] = 2.0;
    var2 = (1) | 0;
    var0.data[var2] = 4.0;
    var3 = (2) | 0;
    var0.data[var3] = 16.0;
    var4 = (3) | 0;
    var0.data[var4] = 256.0;
    var5 = (4) | 0;
    var0.data[var5] = 65536.0;
    var6 = (5) | 0;
    var0.data[var6] = 4.2949673E9;
    var7 = (6) | 0;
    var0.data[var7] = 1.8446744E19;
    de$mirkosertic$bytecoder$classlib$java$lang$TMath$FloatExponents.$i;
    de$mirkosertic$bytecoder$classlib$java$lang$TMath$FloatExponents.exponents = var0;
    // line number 29
    var8 = bytecoder.newarray((7),0);
    var9 = (0) | 0;
    var8.data[var9] = 0.5;
    var10 = (1) | 0;
    var8.data[var10] = 0.25;
    var11 = (2) | 0;
    var8.data[var11] = 0.0625;
    var12 = (3) | 0;
    var8.data[var12] = 0.00390625;
    var13 = (4) | 0;
    var8.data[var13] = 1.5258789E-5;
    var14 = (5) | 0;
    var8.data[var14] = 2.3283064E-10;
    var15 = (6) | 0;
    var8.data[var15] = 5.421011E-20;
    de$mirkosertic$bytecoder$classlib$java$lang$TMath$FloatExponents.negativeExponents = var8;
    // line number 31
    var16 = bytecoder.newarray((7),0);
    var17 = (0) | 0;
    var16.data[var17] = 1.0;
    var18 = (1) | 0;
    var16.data[var18] = 0.5;
    var19 = (2) | 0;
    var16.data[var19] = 0.125;
    var20 = (3) | 0;
    var16.data[var20] = 0.0078125;
    var21 = (4) | 0;
    var16.data[var21] = 3.0517578E-5;
    var22 = (5) | 0;
    var16.data[var22] = 4.656613E-10;
    var23 = (6) | 0;
    var16.data[var23] = 1.0842022E-19;
    de$mirkosertic$bytecoder$classlib$java$lang$TMath$FloatExponents.negativeExponents2 = var16;
    return;
  }

  V$$init$$$() {
    // source file is TMath.java
    // line number 27
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class org$jbox2d$dynamics$SolverData extends java$lang$Object {
  nativeObject = null;

  step = null;
  positions = null;
  velocities = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$dynamics$SolverData,[org$jbox2d$dynamics$SolverData,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is SolverData.java
    // line number 29
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class org$jbox2d$collision$Collision$ClipVertex extends java$lang$Object {
  nativeObject = null;

  v = null;
  id = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$collision$Collision$ClipVertex,[org$jbox2d$collision$Collision$ClipVertex,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is Collision.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    // line number 1000
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 1001
    var0 = this;
    org$jbox2d$common$Vec2.$i;
    var1 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var1);
    var0.v = var1;
    // line number 1002
    var2 = this;
    var3 = new org$jbox2d$collision$ContactID();
    org$jbox2d$collision$ContactID.prototype.V$$init$$$.call(var3);
    var2.id = var3;
    // line number 1003
    return;
  }

  V$set$Lorg$jbox2d$collision$Collision$ClipVertex$(arg0) {
    // source file is Collision.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = .0;
    var var4 = null;
    var var5 = .0;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = 0;
    var var13 = null;
    var var14 = 0;
    var0 = arg0;
    // line number 1006
    var1 = (var0.v);
    // line number 1007
    var2 = (this.v);
    var3 = (var1.x);
    var2.x = var3;
    // line number 1008
    var4 = (this.v);
    var5 = (var1.y);
    var4.y = var5;
    // line number 1009
    var6 = (var0.id);
    // line number 1010
    var7 = (this.id);
    var8 = (var6.indexA);
    var7.indexA = var8;
    // line number 1011
    var9 = (this.id);
    var10 = (var6.indexB);
    var9.indexB = var10;
    // line number 1012
    var11 = (this.id);
    var12 = (var6.typeA);
    var11.typeA = var12;
    // line number 1013
    var13 = (this.id);
    var14 = (var6.typeB);
    var13.typeB = var14;
    // line number 1014
    return;
  }
}


class org$jbox2d$collision$Collision$EPAxis extends java$lang$Object {
  nativeObject = null;

  type = null;
  index = 0;
  separation = 0.0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$collision$Collision$EPAxis,[org$jbox2d$collision$Collision$EPAxis,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is Collision.java
    // line number 1044
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 1045
    return;
  }
}


class org$jbox2d$dynamics$contacts$ContactSolver extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;
  tangent = null;
  temp1 = null;
  temp2 = null;
  P = null;
  temp = null;
  xfA = null;
  xfB = null;
  worldManifold = null;
  a = null;
  b = null;
  dv1 = null;
  dv2 = null;
  x = null;
  d = null;
  P1 = null;
  P2 = null;
  psolver = null;
  rA = null;
  rB = null;
  m_positionConstraints = null;
  m_velocityConstraints = null;
  m_step = null;
  m_count = 0;
  m_positions = null;
  m_velocities = null;
  m_contacts = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$dynamics$contacts$ContactSolver,[org$jbox2d$dynamics$contacts$ContactSolver,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is ContactSolver.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    // line number 44
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(org$jbox2d$dynamics$contacts$ContactSolver.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    org$jbox2d$dynamics$contacts$ContactSolver.$i;
    org$jbox2d$dynamics$contacts$ContactSolver.$assertionsDisabled = phi2;
    return;
  }

  V$$init$$$() {
    // source file is ContactSolver.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = null;
    var var37 = null;
    var var38 = null;
    var var39 = null;
    var var40 = null;
    var var41 = null;
    var var42 = 0;
    var phi43 = null;
    var phi44 = 0;
    var var45 = 0;
    var var46 = null;
    var var47 = null;
    var var48 = 0;
    var var49 = null;
    var var50 = null;
    var var51 = null;
    var var52 = 0;
    var var53 = null;
    // line number 67
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 77
    var0 = this;
    org$jbox2d$common$Vec2.$i;
    var1 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var1);
    var0.tangent = var1;
    // line number 78
    var2 = this;
    var3 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var3);
    var2.temp1 = var3;
    // line number 79
    var4 = this;
    var5 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var5);
    var4.temp2 = var5;
    // line number 183
    var6 = this;
    var7 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var7);
    var6.P = var7;
    // line number 184
    var8 = this;
    var9 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var9);
    var8.temp = var9;
    // line number 226
    var10 = this;
    org$jbox2d$common$Transform.$i;
    var11 = new org$jbox2d$common$Transform();
    org$jbox2d$common$Transform.prototype.V$$init$$$.call(var11);
    var10.xfA = var11;
    // line number 227
    var12 = this;
    var13 = new org$jbox2d$common$Transform();
    org$jbox2d$common$Transform.prototype.V$$init$$$.call(var13);
    var12.xfB = var13;
    // line number 228
    var14 = this;
    var15 = new org$jbox2d$collision$WorldManifold();
    org$jbox2d$collision$WorldManifold.prototype.V$$init$$$.call(var15);
    var14.worldManifold = var15;
    // line number 336
    var16 = this;
    var17 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var17);
    var16.a = var17;
    // line number 337
    var18 = this;
    var19 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var19);
    var18.b = var19;
    // line number 338
    var20 = this;
    var21 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var21);
    var20.dv1 = var21;
    // line number 339
    var22 = this;
    var23 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var23);
    var22.dv2 = var23;
    // line number 340
    var24 = this;
    var25 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var25);
    var24.x = var25;
    // line number 341
    var26 = this;
    var27 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var27);
    var26.d = var27;
    // line number 342
    var28 = this;
    var29 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var29);
    var28.P1 = var29;
    // line number 343
    var30 = this;
    var31 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var31);
    var30.P2 = var31;
    // line number 809
    var32 = this;
    org$jbox2d$dynamics$contacts$PositionSolverManifold.$i;
    var33 = new org$jbox2d$dynamics$contacts$PositionSolverManifold();
    org$jbox2d$dynamics$contacts$PositionSolverManifold.prototype.V$$init$$$.call(var33);
    var32.psolver = var33;
    // line number 810
    var34 = this;
    var35 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var35);
    var34.rA = var35;
    // line number 811
    var36 = this;
    var37 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var37);
    var36.rB = var37;
    // line number 68
    var38 = this;
    var39 = bytecoder.newarray((256),null);
    var38.m_positionConstraints = var39;
    // line number 69
    var40 = this;
    var41 = bytecoder.newarray((256),null);
    var40.m_velocityConstraints = var41;
    // line number 70
    var42 = (0) | 0;
    phi43 = this;
    phi44 = (var42) | 0;
    L1229679778: while(true) {
     var45 = (phi44) | 0;
     if (var45 >= 256) {
      // line number 74
      return;
     } else {
      // line number 71
      var46 = phi43;
      var47 = (var46.m_positionConstraints);
      var48 = (phi44) | 0;
      var49 = new org$jbox2d$dynamics$contacts$ContactPositionConstraint();
      org$jbox2d$dynamics$contacts$ContactPositionConstraint.prototype.V$$init$$$.call(var49);
      var47.data[var48] = var49;
      // line number 72
      var50 = phi43;
      var51 = (var50.m_velocityConstraints);
      var52 = (phi44) | 0;
      var53 = new org$jbox2d$dynamics$contacts$ContactVelocityConstraint();
      org$jbox2d$dynamics$contacts$ContactVelocityConstraint.prototype.V$$init$$$.call(var53);
      var51.data[var52] = var53;
      // line number 70
      phi44 = ((phi44 + 1)) | 0;
      // Here was a goto statement
      continue L1229679778;
     }
    }
  }

  V$init$Lorg$jbox2d$dynamics$contacts$ContactSolver$ContactSolverDef$(arg0) {
    // source file is ContactSolver.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = 0;
    var var19 = 0;
    var phi20 = null;
    var phi21 = null;
    var phi22 = null;
    var phi23 = 0;
    var var24 = 0;
    var var25 = null;
    var var26 = null;
    var var27 = 0;
    var var28 = null;
    var var29 = null;
    var var30 = 0;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = 0;
    var var35 = null;
    var var36 = 0;
    var var37 = null;
    var var38 = null;
    var var39 = null;
    var var40 = 0;
    var var41 = 0;
    var var42 = null;
    var var43 = 0;
    var var44 = 0;
    var var45 = null;
    var var46 = null;
    var var47 = null;
    var var48 = null;
    var var49 = 0;
    var var50 = 0;
    var phi51 = null;
    var phi52 = 0;
    var var53 = 0;
    var var54 = null;
    var var55 = null;
    var var56 = 0;
    var var57 = null;
    var var58 = null;
    var var59 = 0;
    var var60 = null;
    var var61 = null;
    var var62 = null;
    var var63 = null;
    var var64 = null;
    var var65 = null;
    var var66 = null;
    var var67 = null;
    var var68 = null;
    var var69 = null;
    var var70 = 0;
    var phi71 = 0;
    var var72 = 0;
    var var73 = null;
    var var74 = 0;
    var var75 = null;
    var var76 = null;
    var var77 = 0;
    var var78 = null;
    var var79 = null;
    var var80 = null;
    var var81 = null;
    var var82 = null;
    var var83 = .0;
    var var84 = .0;
    var var85 = null;
    var var86 = null;
    var var87 = null;
    var var88 = 0;
    var var89 = 0;
    var var90 = 0;
    var var91 = null;
    var phi92 = null;
    var phi93 = null;
    var phi94 = null;
    var phi95 = null;
    var phi96 = null;
    var phi97 = .0;
    var phi98 = .0;
    var phi99 = null;
    var phi100 = null;
    var phi101 = null;
    var phi102 = 0;
    var var103 = null;
    var var104 = null;
    var var105 = 0;
    var var106 = null;
    var var107 = null;
    var var108 = .0;
    var var109 = null;
    var var110 = .0;
    var var111 = null;
    var var112 = .0;
    var var113 = null;
    var var114 = 0;
    var var115 = null;
    var var116 = 0;
    var var117 = null;
    var var118 = .0;
    var var119 = null;
    var var120 = .0;
    var var121 = null;
    var var122 = .0;
    var var123 = null;
    var var124 = .0;
    var var125 = 0;
    var var126 = 0;
    var var127 = null;
    var var128 = null;
    var var129 = null;
    var var130 = null;
    var var131 = 0;
    var var132 = null;
    var var133 = null;
    var var134 = 0;
    var var135 = null;
    var var136 = 0;
    var var137 = null;
    var var138 = .0;
    var var139 = null;
    var var140 = .0;
    var var141 = null;
    var var142 = null;
    var var143 = null;
    var var144 = null;
    var var145 = null;
    var var146 = null;
    var var147 = null;
    var var148 = null;
    var var149 = null;
    var var150 = null;
    var var151 = null;
    var var152 = .0;
    var var153 = null;
    var var154 = .0;
    var var155 = null;
    var var156 = null;
    var var157 = null;
    var var158 = null;
    var var159 = null;
    var var160 = null;
    var var161 = null;
    var var162 = null;
    var var163 = 0;
    var var164 = .0;
    var var165 = .0;
    var var166 = null;
    var var167 = null;
    var var168 = 0;
    var phi169 = null;
    var phi170 = null;
    var phi171 = 0;
    var var172 = 0;
    var var173 = 0;
    var var174 = null;
    var var175 = null;
    var var176 = 0;
    var var177 = null;
    var var178 = null;
    var var179 = null;
    var var180 = 0;
    var var181 = null;
    var var182 = null;
    var var183 = null;
    var var184 = 0;
    var var185 = null;
    var var186 = null;
    var var187 = .0;
    var var188 = .0;
    var var189 = .0;
    var var190 = null;
    var var191 = null;
    var var192 = .0;
    var var193 = .0;
    var var194 = .0;
    var phi195 = null;
    var phi196 = null;
    var var197 = null;
    var var198 = null;
    var var199 = null;
    var var200 = null;
    var var201 = null;
    var var202 = null;
    var var203 = null;
    var var204 = null;
    var var205 = null;
    var var206 = 0;
    var var207 = null;
    var var208 = null;
    var var209 = null;
    var var210 = .0;
    var var211 = null;
    var var212 = null;
    var var213 = 0;
    var var214 = null;
    var var215 = null;
    var var216 = null;
    var var217 = .0;
    var0 = this;
    // line number 83
    var1 = arg0;
    var2 = (var1.step);
    var0.m_step = var2;
    // line number 84
    var3 = arg0;
    var4 = ((var3.count)) | 0;
    var0.m_count = var4;
    // line number 86
    var5 = (var0.m_positionConstraints);
    var6 = (var5.data.length) | 0;
    var7 = ((var0.m_count)) | 0;
    If_32_0: {
     if (var6 >= var7) {
      phi20 = var0;
      phi21 = arg0;
      break If_32_0;
     } else {
      // line number 87
      var8 = (var0.m_positionConstraints);
      // line number 88
      var9 = var8;
      var10 = (var9.data.length) | 0;
      var11 = ((var10 * 2)) | 0;
      var12 = ((var0.m_count)) | 0;
      org$jbox2d$common$MathUtils.$i;
      var13 = ((org$jbox2d$common$MathUtils.I$max$I$I(var11,var12))) | 0;
      var14 = bytecoder.newarray((var13),null);
      var0.m_positionConstraints = var14;
      // line number 89
      var15 = var0;
      var16 = (var15.m_positionConstraints);
      var17 = var8;
      var18 = (var17.data.length) | 0;
      java$lang$System.V$arraycopy$Ljava$lang$Object$$I$Ljava$lang$Object$$I$I(var8,0,var16,0,var18);
      // line number 90
      var19 = (var8.data.length) | 0;
      phi20 = var0;
      phi21 = arg0;
      phi22 = var8;
      phi23 = (var19) | 0;
      L550753122: while(true) {
       var24 = (phi23) | 0;
       var25 = phi20;
       var26 = (var25.m_positionConstraints);
       var27 = (var26.data.length) | 0;
       if (var24 >= var27) {
        break If_32_0;
       } else {
        // line number 91
        var28 = phi20;
        var29 = (var28.m_positionConstraints);
        var30 = (phi23) | 0;
        var31 = new org$jbox2d$dynamics$contacts$ContactPositionConstraint();
        org$jbox2d$dynamics$contacts$ContactPositionConstraint.prototype.V$$init$$$.call(var31);
        var29.data[var30] = var31;
        // line number 90
        phi23 = ((phi23 + 1)) | 0;
        // Here was a goto statement
        continue L550753122;
       }
      }
     }
    }
    // line number 95
    var32 = phi20;
    var33 = (var32.m_velocityConstraints);
    var34 = (var33.data.length) | 0;
    var35 = phi20;
    var36 = ((var35.m_count)) | 0;
    If_139_0: {
     if (var34 >= var36) {
      phi51 = phi22;
      phi52 = (phi23) | 0;
      break If_139_0;
     } else {
      // line number 96
      var37 = phi20;
      var38 = (var37.m_velocityConstraints);
      // line number 97
      var39 = phi20;
      var40 = (var38.data.length) | 0;
      var41 = ((var40 * 2)) | 0;
      var42 = phi20;
      var43 = ((var42.m_count)) | 0;
      org$jbox2d$common$MathUtils.$i;
      var44 = ((org$jbox2d$common$MathUtils.I$max$I$I(var41,var43))) | 0;
      var45 = bytecoder.newarray((var44),null);
      var39.m_velocityConstraints = var45;
      // line number 98
      var46 = phi20;
      var47 = (var46.m_velocityConstraints);
      var48 = var38;
      var49 = (var48.data.length) | 0;
      java$lang$System.V$arraycopy$Ljava$lang$Object$$I$Ljava$lang$Object$$I$I(var38,0,var47,0,var49);
      // line number 99
      var50 = (var38.data.length) | 0;
      phi51 = var38;
      phi52 = (var50) | 0;
      L2107815775: while(true) {
       var53 = (phi52) | 0;
       var54 = phi20;
       var55 = (var54.m_velocityConstraints);
       var56 = (var55.data.length) | 0;
       if (var53 >= var56) {
        break If_139_0;
       } else {
        // line number 100
        var57 = phi20;
        var58 = (var57.m_velocityConstraints);
        var59 = (phi52) | 0;
        var60 = new org$jbox2d$dynamics$contacts$ContactVelocityConstraint();
        org$jbox2d$dynamics$contacts$ContactVelocityConstraint.prototype.V$$init$$$.call(var60);
        var58.data[var59] = var60;
        // line number 99
        phi52 = ((phi52 + 1)) | 0;
        // Here was a goto statement
        continue L2107815775;
       }
      }
     }
    }
    // line number 104
    var61 = phi20;
    var62 = phi21;
    var63 = (var62.positions);
    var61.m_positions = var63;
    // line number 105
    var64 = phi20;
    var65 = phi21;
    var66 = (var65.velocities);
    var64.m_velocities = var66;
    // line number 106
    var67 = phi20;
    var68 = phi21;
    var69 = (var68.contacts);
    var67.m_contacts = var69;
    // line number 108
    var70 = (0) | 0;
    phi71 = (var70) | 0;
    L187008016: while(true) {
     var72 = (phi71) | 0;
     var73 = phi20;
     var74 = ((var73.m_count)) | 0;
     if (var72 >= var74) {
      // line number 180
      return;
     } else {
      // line number 110
      var75 = phi20;
      var76 = (var75.m_contacts);
      var77 = (phi71) | 0;
      var78 = (var76.data[var77]);
      // line number 112
      var79 = (var78.m_fixtureA);
      // line number 113
      var80 = (var78.m_fixtureB);
      // line number 114
      var81 = (org$jbox2d$dynamics$Fixture.prototype.Lorg$jbox2d$collision$shapes$Shape$$getShape$$.call(var79));
      // line number 115
      var82 = (org$jbox2d$dynamics$Fixture.prototype.Lorg$jbox2d$collision$shapes$Shape$$getShape$$.call(var80));
      // line number 116
      var83 = (var81.m_radius);
      // line number 117
      var84 = (var82.m_radius);
      // line number 118
      var85 = (org$jbox2d$dynamics$Fixture.prototype.Lorg$jbox2d$dynamics$Body$$getBody$$.call(var79));
      // line number 119
      var86 = (org$jbox2d$dynamics$Fixture.prototype.Lorg$jbox2d$dynamics$Body$$getBody$$.call(var80));
      // line number 120
      var87 = (org$jbox2d$dynamics$contacts$Contact.prototype.Lorg$jbox2d$collision$Manifold$$getManifold$$.call(var78));
      // line number 122
      var88 = ((var87.pointCount)) | 0;
      // line number 123
      org$jbox2d$dynamics$contacts$ContactSolver.$i;
      var89 = (org$jbox2d$dynamics$contacts$ContactSolver.$assertionsDisabled);
      If_347_0: {
       if (var89 != 0) {
        phi92 = var78;
        phi93 = var79;
        phi94 = var80;
        phi95 = var81;
        phi96 = var82;
        phi97 = var83;
        phi98 = var84;
        phi99 = var85;
        phi100 = var86;
        phi101 = var87;
        phi102 = (var88) | 0;
        break If_347_0;
       } else {
        var90 = (var88) | 0;
        if (var90 > 0) {
         phi92 = var78;
         phi93 = var79;
         phi94 = var80;
         phi95 = var81;
         phi96 = var82;
         phi97 = var83;
         phi98 = var84;
         phi99 = var85;
         phi100 = var86;
         phi101 = var87;
         phi102 = (var88) | 0;
         break If_347_0;
        } else {
         var91 = new java$lang$AssertionError();
         java$lang$AssertionError.prototype.V$$init$$$.call(var91);
         throw bytecoder.registerStack(var91, new Error().stack);
        }
       }
      }
      // line number 125
      var103 = phi20;
      var104 = (var103.m_velocityConstraints);
      var105 = (phi71) | 0;
      var106 = (var104.data[var105]);
      // line number 126
      var107 = phi92;
      var108 = (var107.m_friction);
      var106.friction = var108;
      // line number 127
      var109 = phi92;
      var110 = (var109.m_restitution);
      var106.restitution = var110;
      // line number 128
      var111 = phi92;
      var112 = (var111.m_tangentSpeed);
      var106.tangentSpeed = var112;
      // line number 129
      var113 = phi99;
      var114 = ((var113.m_islandIndex)) | 0;
      var106.indexA = var114;
      // line number 130
      var115 = phi100;
      var116 = ((var115.m_islandIndex)) | 0;
      var106.indexB = var116;
      // line number 131
      var117 = phi99;
      var118 = (var117.m_invMass);
      var106.invMassA = var118;
      // line number 132
      var119 = phi100;
      var120 = (var119.m_invMass);
      var106.invMassB = var120;
      // line number 133
      var121 = phi99;
      var122 = (var121.m_invI);
      var106.invIA = var122;
      // line number 134
      var123 = phi100;
      var124 = (var123.m_invI);
      var106.invIB = var124;
      // line number 135
      var125 = (phi71) | 0;
      var106.contactIndex = var125;
      // line number 136
      var126 = (phi102) | 0;
      var106.pointCount = var126;
      // line number 137
      var127 = (var106.K);
      org$jbox2d$common$Mat22.prototype.V$setZero$$.call(var127);
      // line number 138
      var128 = (var106.normalMass);
      org$jbox2d$common$Mat22.prototype.V$setZero$$.call(var128);
      // line number 140
      var129 = phi20;
      var130 = (var129.m_positionConstraints);
      var131 = (phi71) | 0;
      var132 = (var130.data[var131]);
      // line number 141
      var133 = phi99;
      var134 = ((var133.m_islandIndex)) | 0;
      var132.indexA = var134;
      // line number 142
      var135 = phi100;
      var136 = ((var135.m_islandIndex)) | 0;
      var132.indexB = var136;
      // line number 143
      var137 = phi99;
      var138 = (var137.m_invMass);
      var132.invMassA = var138;
      // line number 144
      var139 = phi100;
      var140 = (var139.m_invMass);
      var132.invMassB = var140;
      // line number 145
      var141 = (var132.localCenterA);
      var142 = phi99;
      var143 = (var142.m_sweep);
      var144 = (var143.localCenter);
      var145 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var141,var144));
      // line number 146
      var146 = (var132.localCenterB);
      var147 = phi100;
      var148 = (var147.m_sweep);
      var149 = (var148.localCenter);
      var150 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var146,var149));
      // line number 147
      var151 = phi99;
      var152 = (var151.m_invI);
      var132.invIA = var152;
      // line number 148
      var153 = phi100;
      var154 = (var153.m_invI);
      var132.invIB = var154;
      // line number 149
      var155 = (var132.localNormal);
      var156 = phi101;
      var157 = (var156.localNormal);
      var158 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var155,var157));
      // line number 150
      var159 = (var132.localPoint);
      var160 = phi101;
      var161 = (var160.localPoint);
      var162 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var159,var161));
      // line number 151
      var163 = (phi102) | 0;
      var132.pointCount = var163;
      // line number 152
      var164 = phi97;
      var132.radiusA = var164;
      // line number 153
      var165 = phi98;
      var132.radiusB = var165;
      // line number 154
      var166 = phi101;
      var167 = (var166.type);
      var132.type = var167;
      // line number 157
      var168 = (0) | 0;
      phi169 = var106;
      phi170 = var132;
      phi171 = (var168) | 0;
      L1573719142: while(true) {
       var172 = (phi171) | 0;
       var173 = (phi102) | 0;
       if (var172 >= var173) {
        // line number 108
        phi71 = ((phi71 + 1)) | 0;
        // Here was a goto statement
        continue L187008016;
       } else {
        // line number 158
        var174 = phi101;
        var175 = (var174.points);
        var176 = (phi171) | 0;
        var177 = (var175.data[var176]);
        // line number 159
        var178 = phi169;
        var179 = (var178.points);
        var180 = (phi171) | 0;
        var181 = (var179.data[var180]);
        // line number 161
        var182 = phi20;
        var183 = (var182.m_step);
        var184 = (var183.warmStarting);
        If_671_0: {
         if (var184 == 0) {
          // line number 167
          var181.normalImpulse = 0.0;
          // line number 168
          var181.tangentImpulse = 0.0;
          phi195 = var177;
          phi196 = var181;
          break If_671_0;
         } else {
          // line number 164
          var185 = phi20;
          var186 = (var185.m_step);
          var187 = (var186.dtRatio);
          var188 = (var177.normalImpulse);
          var189 = (var187 * var188);
          var181.normalImpulse = var189;
          // line number 165
          var190 = phi20;
          var191 = (var190.m_step);
          var192 = (var191.dtRatio);
          var193 = (var177.tangentImpulse);
          var194 = (var192 * var193);
          var181.tangentImpulse = var194;
          // Here was a goto statement
          phi195 = var177;
          phi196 = var181;
          break If_671_0;
         }
        }
        // line number 171
        var197 = phi196;
        var198 = (var197.rA);
        org$jbox2d$common$Vec2.prototype.V$setZero$$.call(var198);
        // line number 172
        var199 = phi196;
        var200 = (var199.rB);
        org$jbox2d$common$Vec2.prototype.V$setZero$$.call(var200);
        // line number 173
        var201 = phi196;
        var201.normalMass = 0.0;
        // line number 174
        var202 = phi196;
        var202.tangentMass = 0.0;
        // line number 175
        var203 = phi196;
        var203.velocityBias = 0.0;
        // line number 176
        var204 = phi170;
        var205 = (var204.localPoints);
        var206 = (phi171) | 0;
        var207 = (var205.data[var206]);
        var208 = phi195;
        var209 = (var208.localPoint);
        var210 = (var209.x);
        var207.x = var210;
        // line number 177
        var211 = phi170;
        var212 = (var211.localPoints);
        var213 = (phi171) | 0;
        var214 = (var212.data[var213]);
        var215 = phi195;
        var216 = (var215.localPoint);
        var217 = (var216.y);
        var214.y = var217;
        // line number 157
        phi171 = ((phi171 + 1)) | 0;
        // Here was a goto statement
        continue L1573719142;
       }
      }
     }
    }
  }

  V$initializeVelocityConstraints$$() {
    // source file is ContactSolver.java
    var phi0 = null;
    var phi1 = 0;
    var var2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = 0;
    var var12 = null;
    var var13 = .0;
    var var14 = .0;
    var var15 = null;
    var var16 = null;
    var var17 = 0;
    var var18 = null;
    var var19 = null;
    var var20 = 0;
    var var21 = 0;
    var var22 = .0;
    var var23 = .0;
    var var24 = .0;
    var var25 = .0;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = null;
    var var35 = .0;
    var var36 = null;
    var var37 = null;
    var var38 = null;
    var var39 = null;
    var var40 = null;
    var var41 = null;
    var var42 = null;
    var var43 = .0;
    var var44 = null;
    var var45 = null;
    var var46 = null;
    var var47 = null;
    var var48 = null;
    var var49 = null;
    var var50 = null;
    var var51 = .0;
    var var52 = null;
    var var53 = null;
    var var54 = null;
    var var55 = null;
    var var56 = null;
    var var57 = null;
    var var58 = null;
    var var59 = .0;
    var var60 = 0;
    var var61 = null;
    var var62 = 0;
    var var63 = null;
    var phi64 = null;
    var phi65 = null;
    var phi66 = .0;
    var phi67 = .0;
    var phi68 = null;
    var phi69 = 0;
    var phi70 = 0;
    var phi71 = .0;
    var phi72 = .0;
    var phi73 = .0;
    var phi74 = .0;
    var phi75 = null;
    var phi76 = null;
    var phi77 = null;
    var phi78 = .0;
    var phi79 = null;
    var phi80 = .0;
    var phi81 = null;
    var phi82 = .0;
    var phi83 = null;
    var phi84 = .0;
    var var85 = null;
    var var86 = null;
    var var87 = null;
    var var88 = .0;
    var var89 = null;
    var var90 = null;
    var var91 = null;
    var var92 = null;
    var var93 = .0;
    var var94 = null;
    var var95 = null;
    var var96 = null;
    var var97 = null;
    var var98 = null;
    var var99 = .0;
    var var100 = null;
    var var101 = null;
    var var102 = null;
    var var103 = .0;
    var var104 = null;
    var var105 = .0;
    var var106 = .0;
    var var107 = null;
    var var108 = null;
    var var109 = null;
    var var110 = .0;
    var var111 = null;
    var var112 = .0;
    var var113 = .0;
    var var114 = .0;
    var var115 = .0;
    var var116 = null;
    var var117 = null;
    var var118 = null;
    var var119 = null;
    var var120 = .0;
    var var121 = null;
    var var122 = null;
    var var123 = null;
    var var124 = .0;
    var var125 = null;
    var var126 = .0;
    var var127 = .0;
    var var128 = null;
    var var129 = null;
    var var130 = null;
    var var131 = .0;
    var var132 = null;
    var var133 = .0;
    var var134 = .0;
    var var135 = .0;
    var var136 = .0;
    var var137 = null;
    var var138 = null;
    var var139 = null;
    var var140 = null;
    var var141 = .0;
    var var142 = null;
    var var143 = null;
    var var144 = null;
    var var145 = .0;
    var var146 = null;
    var var147 = .0;
    var var148 = .0;
    var var149 = null;
    var var150 = null;
    var var151 = null;
    var var152 = .0;
    var var153 = null;
    var var154 = .0;
    var var155 = .0;
    var var156 = .0;
    var var157 = .0;
    var var158 = null;
    var var159 = null;
    var var160 = null;
    var var161 = null;
    var var162 = .0;
    var var163 = null;
    var var164 = null;
    var var165 = null;
    var var166 = .0;
    var var167 = null;
    var var168 = .0;
    var var169 = .0;
    var var170 = null;
    var var171 = null;
    var var172 = null;
    var var173 = .0;
    var var174 = null;
    var var175 = .0;
    var var176 = .0;
    var var177 = .0;
    var var178 = .0;
    var var179 = null;
    var var180 = null;
    var var181 = null;
    var var182 = null;
    var var183 = null;
    var var184 = .0;
    var var185 = null;
    var var186 = null;
    var var187 = .0;
    var var188 = null;
    var var189 = null;
    var var190 = null;
    var var191 = null;
    var var192 = null;
    var var193 = null;
    var var194 = null;
    var var195 = 0;
    var var196 = 0;
    var phi197 = 0;
    var phi198 = 0;
    var var199 = 0;
    var var200 = 0;
    var var201 = null;
    var var202 = null;
    var var203 = 0;
    var var204 = null;
    var var205 = null;
    var var206 = null;
    var var207 = null;
    var var208 = null;
    var var209 = 0;
    var var210 = null;
    var var211 = null;
    var var212 = null;
    var var213 = null;
    var var214 = null;
    var var215 = null;
    var var216 = null;
    var var217 = null;
    var var218 = 0;
    var var219 = null;
    var var220 = null;
    var var221 = null;
    var var222 = null;
    var var223 = null;
    var var224 = .0;
    var var225 = null;
    var var226 = null;
    var var227 = .0;
    var var228 = .0;
    var var229 = null;
    var var230 = .0;
    var var231 = null;
    var var232 = null;
    var var233 = .0;
    var var234 = .0;
    var var235 = .0;
    var var236 = null;
    var var237 = .0;
    var var238 = null;
    var var239 = null;
    var var240 = .0;
    var var241 = .0;
    var var242 = null;
    var var243 = .0;
    var var244 = null;
    var var245 = null;
    var var246 = .0;
    var var247 = .0;
    var var248 = .0;
    var var249 = .0;
    var var250 = .0;
    var var251 = .0;
    var var252 = .0;
    var var253 = .0;
    var var254 = .0;
    var var255 = .0;
    var var256 = .0;
    var var257 = .0;
    var var258 = .0;
    var var259 = .0;
    var var260 = .0;
    var var261 = 0;
    var var262 = .0;
    var var263 = .0;
    var phi264 = null;
    var phi265 = .0;
    var phi266 = .0;
    var phi267 = .0;
    var phi268 = null;
    var phi269 = .0;
    var var270 = null;
    var var271 = null;
    var var272 = .0;
    var var273 = .0;
    var var274 = null;
    var var275 = null;
    var var276 = .0;
    var var277 = .0;
    var var278 = null;
    var var279 = null;
    var var280 = .0;
    var var281 = .0;
    var var282 = null;
    var var283 = null;
    var var284 = .0;
    var var285 = .0;
    var var286 = .0;
    var var287 = null;
    var var288 = null;
    var var289 = .0;
    var var290 = .0;
    var var291 = null;
    var var292 = null;
    var var293 = .0;
    var var294 = .0;
    var var295 = .0;
    var var296 = .0;
    var var297 = .0;
    var var298 = .0;
    var var299 = .0;
    var var300 = .0;
    var var301 = .0;
    var var302 = .0;
    var var303 = .0;
    var var304 = .0;
    var var305 = .0;
    var var306 = .0;
    var var307 = null;
    var var308 = 0;
    var var309 = .0;
    var var310 = .0;
    var phi311 = .0;
    var phi312 = .0;
    var phi313 = .0;
    var phi314 = .0;
    var phi315 = .0;
    var phi316 = null;
    var phi317 = .0;
    var var318 = null;
    var var319 = null;
    var var320 = .0;
    var var321 = .0;
    var var322 = .0;
    var var323 = null;
    var var324 = null;
    var var325 = .0;
    var var326 = .0;
    var var327 = .0;
    var var328 = null;
    var var329 = .0;
    var var330 = .0;
    var var331 = .0;
    var var332 = .0;
    var var333 = null;
    var var334 = null;
    var var335 = .0;
    var var336 = .0;
    var var337 = .0;
    var var338 = null;
    var var339 = .0;
    var var340 = .0;
    var var341 = null;
    var var342 = null;
    var var343 = .0;
    var var344 = .0;
    var var345 = .0;
    var var346 = null;
    var var347 = .0;
    var var348 = .0;
    var var349 = .0;
    var var350 = null;
    var var351 = null;
    var var352 = .0;
    var var353 = .0;
    var var354 = .0;
    var var355 = null;
    var var356 = null;
    var var357 = .0;
    var var358 = .0;
    var var359 = null;
    var var360 = null;
    var var361 = .0;
    var var362 = .0;
    var var363 = .0;
    var var364 = 0;
    var var365 = null;
    var var366 = null;
    var var367 = .0;
    var var368 = .0;
    var var369 = .0;
    var phi370 = .0;
    var phi371 = .0;
    var phi372 = .0;
    var var373 = null;
    var var374 = 0;
    var var375 = null;
    var var376 = null;
    var var377 = null;
    var var378 = null;
    var var379 = null;
    var var380 = null;
    var var381 = null;
    var var382 = null;
    var var383 = null;
    var var384 = .0;
    var var385 = null;
    var var386 = null;
    var var387 = null;
    var var388 = .0;
    var var389 = null;
    var var390 = null;
    var var391 = null;
    var var392 = .0;
    var var393 = null;
    var var394 = null;
    var var395 = null;
    var var396 = .0;
    var var397 = .0;
    var var398 = .0;
    var var399 = .0;
    var var400 = .0;
    var var401 = .0;
    var var402 = .0;
    var var403 = .0;
    var var404 = .0;
    var var405 = .0;
    var var406 = .0;
    var var407 = .0;
    var var408 = .0;
    var var409 = .0;
    var var410 = .0;
    var var411 = .0;
    var var412 = .0;
    var var413 = .0;
    var var414 = .0;
    var var415 = .0;
    var var416 = .0;
    var var417 = .0;
    var var418 = .0;
    var var419 = .0;
    var var420 = .0;
    var var421 = .0;
    var var422 = .0;
    var var423 = .0;
    var var424 = .0;
    var var425 = .0;
    var var426 = .0;
    var var427 = .0;
    var var428 = .0;
    var var429 = .0;
    var var430 = .0;
    var var431 = .0;
    var var432 = .0;
    var var433 = .0;
    var var434 = .0;
    var var435 = .0;
    var var436 = .0;
    var var437 = .0;
    var var438 = 0;
    var var439 = null;
    var var440 = null;
    var var441 = null;
    var var442 = .0;
    var var443 = null;
    var var444 = null;
    var var445 = null;
    var var446 = null;
    var var447 = .0;
    var var448 = null;
    var var449 = null;
    var var450 = null;
    var var451 = null;
    var var452 = null;
    var phi453 = null;
    var phi454 = null;
    var phi455 = .0;
    var phi456 = .0;
    var phi457 = .0;
    var phi458 = .0;
    var phi459 = .0;
    var phi460 = .0;
    var phi461 = .0;
    var var462 = null;
    // line number 233
    phi0 = this;
    phi1 = (0) | 0;
    L180589013: while(true) {
     var2 = (phi1) | 0;
     var3 = phi0;
     var4 = ((var3.m_count)) | 0;
     if (var2 >= var4) {
      // line number 333
      return;
     } else {
      // line number 234
      var5 = phi0;
      var6 = (var5.m_velocityConstraints);
      var7 = (phi1) | 0;
      var8 = (var6.data[var7]);
      // line number 235
      var9 = phi0;
      var10 = (var9.m_positionConstraints);
      var11 = (phi1) | 0;
      var12 = (var10.data[var11]);
      // line number 237
      var13 = (var12.radiusA);
      // line number 238
      var14 = (var12.radiusB);
      // line number 239
      var15 = phi0;
      var16 = (var15.m_contacts);
      var17 = ((var8.contactIndex)) | 0;
      var18 = (var16.data[var17]);
      var19 = (org$jbox2d$dynamics$contacts$Contact.prototype.Lorg$jbox2d$collision$Manifold$$getManifold$$.call(var18));
      // line number 241
      var20 = ((var8.indexA)) | 0;
      // line number 242
      var21 = ((var8.indexB)) | 0;
      // line number 244
      var22 = (var8.invMassA);
      // line number 245
      var23 = (var8.invMassB);
      // line number 246
      var24 = (var8.invIA);
      // line number 247
      var25 = (var8.invIB);
      // line number 248
      var26 = (var12.localCenterA);
      // line number 249
      var27 = (var12.localCenterB);
      // line number 251
      var28 = phi0;
      var29 = (var28.m_positions);
      var30 = (var29.data[var20]);
      var31 = (var30.c);
      // line number 252
      var32 = phi0;
      var33 = (var32.m_positions);
      var34 = (var33.data[var20]);
      var35 = (var34.a);
      // line number 253
      var36 = phi0;
      var37 = (var36.m_velocities);
      var38 = (var37.data[var20]);
      var39 = (var38.v);
      // line number 254
      var40 = phi0;
      var41 = (var40.m_velocities);
      var42 = (var41.data[var20]);
      var43 = (var42.w);
      // line number 256
      var44 = phi0;
      var45 = (var44.m_positions);
      var46 = (var45.data[var21]);
      var47 = (var46.c);
      // line number 257
      var48 = phi0;
      var49 = (var48.m_positions);
      var50 = (var49.data[var21]);
      var51 = (var50.a);
      // line number 258
      var52 = phi0;
      var53 = (var52.m_velocities);
      var54 = (var53.data[var21]);
      var55 = (var54.v);
      // line number 259
      var56 = phi0;
      var57 = (var56.m_velocities);
      var58 = (var57.data[var21]);
      var59 = (var58.w);
      // line number 261
      org$jbox2d$dynamics$contacts$ContactSolver.$i;
      var60 = (org$jbox2d$dynamics$contacts$ContactSolver.$assertionsDisabled);
      If_219_0: {
       if (var60 != 0) {
        phi64 = var8;
        phi65 = var12;
        phi66 = var13;
        phi67 = var14;
        phi68 = var19;
        phi69 = (var20) | 0;
        phi70 = (var21) | 0;
        phi71 = var22;
        phi72 = var23;
        phi73 = var24;
        phi74 = var25;
        phi75 = var26;
        phi76 = var27;
        phi77 = var31;
        phi78 = var35;
        phi79 = var39;
        phi80 = var43;
        phi81 = var47;
        phi82 = var51;
        phi83 = var55;
        phi84 = var59;
        break If_219_0;
       } else {
        var61 = var19;
        var62 = ((var61.pointCount)) | 0;
        if (var62 > 0) {
         phi64 = var8;
         phi65 = var12;
         phi66 = var13;
         phi67 = var14;
         phi68 = var19;
         phi69 = (var20) | 0;
         phi70 = (var21) | 0;
         phi71 = var22;
         phi72 = var23;
         phi73 = var24;
         phi74 = var25;
         phi75 = var26;
         phi76 = var27;
         phi77 = var31;
         phi78 = var35;
         phi79 = var39;
         phi80 = var43;
         phi81 = var47;
         phi82 = var51;
         phi83 = var55;
         phi84 = var59;
         break If_219_0;
        } else {
         var63 = new java$lang$AssertionError();
         java$lang$AssertionError.prototype.V$$init$$$.call(var63);
         throw bytecoder.registerStack(var63, new Error().stack);
        }
       }
      }
      // line number 263
      var85 = phi0;
      var86 = (var85.xfA);
      var87 = (var86.q);
      var88 = phi78;
      var89 = (org$jbox2d$common$Rot.prototype.Lorg$jbox2d$common$Rot$$set$F.call(var87,var88));
      // line number 264
      var90 = phi0;
      var91 = (var90.xfB);
      var92 = (var91.q);
      var93 = phi82;
      var94 = (org$jbox2d$common$Rot.prototype.Lorg$jbox2d$common$Rot$$set$F.call(var92,var93));
      // line number 265
      var95 = phi0;
      var96 = (var95.xfA);
      var97 = (var96.p);
      var98 = phi77;
      var99 = (var98.x);
      var100 = phi0;
      var101 = (var100.xfA);
      var102 = (var101.q);
      var103 = (var102.c);
      var104 = phi75;
      var105 = (var104.x);
      var106 = (var103 * var105);
      var107 = phi0;
      var108 = (var107.xfA);
      var109 = (var108.q);
      var110 = (var109.s);
      var111 = phi75;
      var112 = (var111.y);
      var113 = (var110 * var112);
      var114 = (var106 - var113);
      var115 = (var99 - var114);
      var97.x = var115;
      // line number 266
      var116 = phi0;
      var117 = (var116.xfA);
      var118 = (var117.p);
      var119 = phi77;
      var120 = (var119.y);
      var121 = phi0;
      var122 = (var121.xfA);
      var123 = (var122.q);
      var124 = (var123.s);
      var125 = phi75;
      var126 = (var125.x);
      var127 = (var124 * var126);
      var128 = phi0;
      var129 = (var128.xfA);
      var130 = (var129.q);
      var131 = (var130.c);
      var132 = phi75;
      var133 = (var132.y);
      var134 = (var131 * var133);
      var135 = (var127 + var134);
      var136 = (var120 - var135);
      var118.y = var136;
      // line number 267
      var137 = phi0;
      var138 = (var137.xfB);
      var139 = (var138.p);
      var140 = phi81;
      var141 = (var140.x);
      var142 = phi0;
      var143 = (var142.xfB);
      var144 = (var143.q);
      var145 = (var144.c);
      var146 = phi76;
      var147 = (var146.x);
      var148 = (var145 * var147);
      var149 = phi0;
      var150 = (var149.xfB);
      var151 = (var150.q);
      var152 = (var151.s);
      var153 = phi76;
      var154 = (var153.y);
      var155 = (var152 * var154);
      var156 = (var148 - var155);
      var157 = (var141 - var156);
      var139.x = var157;
      // line number 268
      var158 = phi0;
      var159 = (var158.xfB);
      var160 = (var159.p);
      var161 = phi81;
      var162 = (var161.y);
      var163 = phi0;
      var164 = (var163.xfB);
      var165 = (var164.q);
      var166 = (var165.s);
      var167 = phi76;
      var168 = (var167.x);
      var169 = (var166 * var168);
      var170 = phi0;
      var171 = (var170.xfB);
      var172 = (var171.q);
      var173 = (var172.c);
      var174 = phi76;
      var175 = (var174.y);
      var176 = (var173 * var175);
      var177 = (var169 + var176);
      var178 = (var162 - var177);
      var160.y = var178;
      // line number 270
      var179 = phi0;
      var180 = (var179.worldManifold);
      var181 = phi68;
      var182 = phi0;
      var183 = (var182.xfA);
      var184 = phi66;
      var185 = phi0;
      var186 = (var185.xfB);
      var187 = phi67;
      org$jbox2d$collision$WorldManifold.prototype.V$initialize$Lorg$jbox2d$collision$Manifold$$Lorg$jbox2d$common$Transform$$F$Lorg$jbox2d$common$Transform$$F.call(var180,var181,var183,var184,var186,var187);
      // line number 272
      var188 = phi64;
      var189 = (var188.normal);
      var190 = phi0;
      var191 = (var190.worldManifold);
      var192 = (var191.normal);
      var193 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var189,var192));
      // line number 274
      var194 = phi64;
      var195 = ((var194.pointCount)) | 0;
      // line number 275
      var196 = (0) | 0;
      phi197 = (var195) | 0;
      phi198 = (var196) | 0;
      L1681307764: while(true) {
       var199 = (phi198) | 0;
       var200 = (phi197) | 0;
       if (var199 >= var200) {
        // line number 309
        var373 = phi64;
        var374 = ((var373.pointCount)) | 0;
        If_1117_0: {
         if (var374 != 2) {
          phi453 = phi198;
          break If_1117_0;
         } else {
          // line number 310
          var375 = phi64;
          var376 = (var375.points);
          var377 = (var376.data[0]);
          // line number 311
          var378 = phi64;
          var379 = (var378.points);
          var380 = (var379.data[1]);
          // line number 313
          var381 = (var377.rA);
          var382 = phi64;
          var383 = (var382.normal);
          org$jbox2d$common$Vec2.$i;
          var384 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var381,var383));
          // line number 314
          var385 = (var377.rB);
          var386 = phi64;
          var387 = (var386.normal);
          var388 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var385,var387));
          // line number 315
          var389 = (var380.rA);
          var390 = phi64;
          var391 = (var390.normal);
          var392 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var389,var391));
          // line number 316
          var393 = (var380.rB);
          var394 = phi64;
          var395 = (var394.normal);
          var396 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var393,var395));
          // line number 318
          var397 = phi71;
          var398 = phi72;
          var399 = (var397 + var398);
          var400 = phi73;
          var401 = (var400 * var384);
          var402 = (var401 * var384);
          var403 = (var399 + var402);
          var404 = phi74;
          var405 = (var404 * var388);
          var406 = (var405 * var388);
          var407 = (var403 + var406);
          // line number 319
          var408 = phi71;
          var409 = phi72;
          var410 = (var408 + var409);
          var411 = phi73;
          var412 = (var411 * var392);
          var413 = (var412 * var392);
          var414 = (var410 + var413);
          var415 = phi74;
          var416 = (var415 * var396);
          var417 = (var416 * var396);
          var418 = (var414 + var417);
          // line number 320
          var419 = phi71;
          var420 = phi72;
          var421 = (var419 + var420);
          var422 = phi73;
          var423 = (var422 * var384);
          var424 = (var423 * var392);
          var425 = (var421 + var424);
          var426 = phi74;
          var427 = (var426 * var388);
          var428 = (var427 * var396);
          var429 = (var425 + var428);
          // line number 321
          var430 = var407;
          var431 = (var407 * var430);
          var432 = var407;
          var433 = (var432 * var418);
          var434 = var429;
          var435 = (var429 * var434);
          var436 = (var433 - var435);
          var437 = (100.0 * var436);
          var438 = (bytecoder.cmp(var431,var437)) | 0;
          if (var438 >= 0) {
           // line number 329
           var462 = phi64;
           var462.pointCount = 1;
           phi453 = var377;
           phi454 = var380;
           phi455 = var384;
           phi456 = var388;
           phi457 = var392;
           phi458 = var396;
           phi459 = var407;
           phi460 = var418;
           phi461 = var429;
           break If_1117_0;
          } else {
           // line number 323
           var439 = phi64;
           var440 = (var439.K);
           var441 = (var440.ex);
           var442 = var429;
           var443 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$F$F.call(var441,var407,var442));
           // line number 324
           var444 = phi64;
           var445 = (var444.K);
           var446 = (var445.ey);
           var447 = var418;
           var448 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$F$F.call(var446,var429,var447));
           // line number 325
           var449 = phi64;
           var450 = (var449.K);
           var451 = phi64;
           var452 = (var451.normalMass);
           org$jbox2d$common$Mat22.prototype.V$invertToOut$Lorg$jbox2d$common$Mat22$.call(var450,var452);
           // Here was a goto statement
           phi453 = var377;
           phi454 = var380;
           phi455 = var384;
           phi456 = var388;
           phi457 = var392;
           phi458 = var396;
           phi459 = var407;
           phi460 = var418;
           phi461 = var429;
           break If_1117_0;
          }
         }
        }
        // line number 233
        phi1 = ((phi1 + 1)) | 0;
        // Here was a goto statement
        continue L180589013;
       } else {
        // line number 276
        var201 = phi64;
        var202 = (var201.points);
        var203 = (phi198) | 0;
        var204 = (var202.data[var203]);
        // line number 278
        var205 = (var204.rA);
        var206 = phi0;
        var207 = (var206.worldManifold);
        var208 = (var207.points);
        var209 = (phi198) | 0;
        var210 = (var208.data[var209]);
        var211 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var205,var210));
        var212 = phi77;
        var213 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var211,var212));
        // line number 279
        var214 = (var204.rB);
        var215 = phi0;
        var216 = (var215.worldManifold);
        var217 = (var216.points);
        var218 = (phi198) | 0;
        var219 = (var217.data[var218]);
        var220 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var214,var219));
        var221 = phi81;
        var222 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var220,var221));
        // line number 281
        var223 = (var204.rA);
        var224 = (var223.x);
        var225 = phi64;
        var226 = (var225.normal);
        var227 = (var226.y);
        var228 = (var224 * var227);
        var229 = (var204.rA);
        var230 = (var229.y);
        var231 = phi64;
        var232 = (var231.normal);
        var233 = (var232.x);
        var234 = (var230 * var233);
        var235 = (var228 - var234);
        // line number 282
        var236 = (var204.rB);
        var237 = (var236.x);
        var238 = phi64;
        var239 = (var238.normal);
        var240 = (var239.y);
        var241 = (var237 * var240);
        var242 = (var204.rB);
        var243 = (var242.y);
        var244 = phi64;
        var245 = (var244.normal);
        var246 = (var245.x);
        var247 = (var243 * var246);
        var248 = (var241 - var247);
        // line number 284
        var249 = phi71;
        var250 = phi72;
        var251 = (var249 + var250);
        var252 = phi73;
        var253 = (var252 * var235);
        var254 = (var253 * var235);
        var255 = (var251 + var254);
        var256 = phi74;
        var257 = (var256 * var248);
        var258 = (var257 * var248);
        var259 = (var255 + var258);
        // line number 286
        var260 = var259;
        var261 = (bytecoder.cmp(var260,0.0)) | 0;
        If_774_0: {
         if (var261 <= 0) {
          phi264 = var204;
          phi265 = var235;
          phi266 = var248;
          phi267 = var259;
          phi268 = var204;
          phi269 = 0.0;
          break If_774_0;
         } else {
          var262 = 1.0;
          var263 = (var262 / var259);
          // Here was a goto statement
          phi264 = var204;
          phi265 = var235;
          phi266 = var248;
          phi267 = var259;
          phi268 = var204;
          phi269 = var263;
          break If_774_0;
         }
        }
        phi268.normalMass = phi269;
        // line number 288
        var270 = phi64;
        var271 = (var270.normal);
        var272 = (var271.y);
        var273 = (1.0 * var272);
        // line number 289
        var274 = phi64;
        var275 = (var274.normal);
        var276 = (var275.x);
        var277 = (-1.0 * var276);
        // line number 291
        var278 = phi264;
        var279 = (var278.rA);
        var280 = (var279.x);
        var281 = (var280 * var277);
        var282 = phi264;
        var283 = (var282.rA);
        var284 = (var283.y);
        var285 = (var284 * var273);
        var286 = (var281 - var285);
        // line number 292
        var287 = phi264;
        var288 = (var287.rB);
        var289 = (var288.x);
        var290 = (var289 * var277);
        var291 = phi264;
        var292 = (var291.rB);
        var293 = (var292.y);
        var294 = (var293 * var273);
        var295 = (var290 - var294);
        // line number 294
        var296 = phi71;
        var297 = phi72;
        var298 = (var296 + var297);
        var299 = phi73;
        var300 = (var299 * var286);
        var301 = (var300 * var286);
        var302 = (var298 + var301);
        var303 = phi74;
        var304 = (var303 * var295);
        var305 = (var304 * var295);
        var306 = (var302 + var305);
        // line number 296
        var307 = phi264;
        var308 = (bytecoder.cmp(var306,0.0)) | 0;
        If_914_0: {
         if (var308 <= 0) {
          phi311 = var273;
          phi312 = var277;
          phi313 = var286;
          phi314 = var295;
          phi315 = var306;
          phi316 = var307;
          phi317 = 0.0;
          break If_914_0;
         } else {
          var309 = 1.0;
          var310 = (var309 / var306);
          // Here was a goto statement
          phi311 = var273;
          phi312 = var277;
          phi313 = var286;
          phi314 = var295;
          phi315 = var306;
          phi316 = var307;
          phi317 = var310;
          break If_914_0;
         }
        }
        phi316.tangentMass = phi317;
        // line number 299
        var318 = phi264;
        var318.velocityBias = 0.0;
        // line number 300
        var319 = phi83;
        var320 = (var319.x);
        var321 = phi84;
        var322 = (0 - var321);
        var323 = phi264;
        var324 = (var323.rB);
        var325 = (var324.y);
        var326 = (var322 * var325);
        var327 = (var320 + var326);
        var328 = phi79;
        var329 = (var328.x);
        var330 = (var327 - var329);
        var331 = phi80;
        var332 = (0 - var331);
        var333 = phi264;
        var334 = (var333.rA);
        var335 = (var334.y);
        var336 = (var332 * var335);
        var337 = (var330 - var336);
        // line number 301
        var338 = phi83;
        var339 = (var338.y);
        var340 = phi84;
        var341 = phi264;
        var342 = (var341.rB);
        var343 = (var342.x);
        var344 = (var340 * var343);
        var345 = (var339 + var344);
        var346 = phi79;
        var347 = (var346.y);
        var348 = (var345 - var347);
        var349 = phi80;
        var350 = phi264;
        var351 = (var350.rA);
        var352 = (var351.x);
        var353 = (var349 * var352);
        var354 = (var348 - var353);
        // line number 302
        var355 = phi64;
        var356 = (var355.normal);
        var357 = (var356.x);
        var358 = (var357 * var337);
        var359 = phi64;
        var360 = (var359.normal);
        var361 = (var360.y);
        var362 = (var361 * var354);
        var363 = (var358 + var362);
        // line number 303
        var364 = (bytecoder.cmp(var363,-1.0)) | 0;
        If_1073_0: {
         if (var364 >= 0) {
          phi370 = var337;
          phi371 = var354;
          phi372 = var363;
          break If_1073_0;
         } else {
          // line number 304
          var365 = phi264;
          var366 = phi64;
          var367 = (var366.restitution);
          var368 = (0 - var367);
          var369 = (var368 * var363);
          var365.velocityBias = var369;
          phi370 = var337;
          phi371 = var354;
          phi372 = var363;
          break If_1073_0;
         }
        }
        // line number 275
        phi198 = ((phi198 + 1)) | 0;
        // Here was a goto statement
        continue L1681307764;
       }
      }
     }
    }
  }

  V$warmStart$$() {
    // source file is ContactSolver.java
    var phi0 = null;
    var phi1 = 0;
    var var2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = 0;
    var var10 = 0;
    var var11 = .0;
    var var12 = .0;
    var var13 = .0;
    var var14 = .0;
    var var15 = 0;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = .0;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = null;
    var var31 = .0;
    var var32 = null;
    var var33 = null;
    var var34 = .0;
    var var35 = .0;
    var var36 = null;
    var var37 = .0;
    var var38 = .0;
    var var39 = 0;
    var phi40 = null;
    var phi41 = 0;
    var phi42 = 0;
    var phi43 = .0;
    var phi44 = .0;
    var phi45 = .0;
    var phi46 = .0;
    var phi47 = 0;
    var phi48 = null;
    var phi49 = .0;
    var phi50 = null;
    var phi51 = .0;
    var phi52 = null;
    var phi53 = .0;
    var phi54 = .0;
    var phi55 = 0;
    var var56 = 0;
    var var57 = 0;
    var var58 = null;
    var var59 = null;
    var var60 = 0;
    var var61 = null;
    var var62 = .0;
    var var63 = .0;
    var var64 = .0;
    var var65 = null;
    var var66 = .0;
    var var67 = .0;
    var var68 = .0;
    var var69 = .0;
    var var70 = .0;
    var var71 = .0;
    var var72 = .0;
    var var73 = null;
    var var74 = .0;
    var var75 = .0;
    var var76 = .0;
    var var77 = .0;
    var var78 = .0;
    var var79 = .0;
    var var80 = null;
    var var81 = .0;
    var var82 = .0;
    var var83 = null;
    var var84 = .0;
    var var85 = .0;
    var var86 = .0;
    var var87 = .0;
    var var88 = .0;
    var var89 = null;
    var var90 = .0;
    var var91 = .0;
    var var92 = .0;
    var var93 = .0;
    var var94 = null;
    var var95 = .0;
    var var96 = .0;
    var var97 = .0;
    var var98 = .0;
    var var99 = .0;
    var var100 = .0;
    var var101 = null;
    var var102 = .0;
    var var103 = .0;
    var var104 = null;
    var var105 = .0;
    var var106 = .0;
    var var107 = .0;
    var var108 = .0;
    var var109 = .0;
    var var110 = null;
    var var111 = .0;
    var var112 = .0;
    var var113 = .0;
    var var114 = .0;
    var var115 = null;
    var var116 = .0;
    var var117 = .0;
    var var118 = .0;
    var var119 = .0;
    var var120 = null;
    var var121 = null;
    var var122 = 0;
    var var123 = null;
    var var124 = .0;
    var var125 = null;
    var var126 = null;
    var var127 = 0;
    var var128 = null;
    var var129 = .0;
    // line number 188
    phi0 = this;
    phi1 = (0) | 0;
    L1989193621: while(true) {
     var2 = (phi1) | 0;
     var3 = phi0;
     var4 = ((var3.m_count)) | 0;
     if (var2 >= var4) {
      // line number 223
      return;
     } else {
      // line number 189
      var5 = phi0;
      var6 = (var5.m_velocityConstraints);
      var7 = (phi1) | 0;
      var8 = (var6.data[var7]);
      // line number 191
      var9 = ((var8.indexA)) | 0;
      // line number 192
      var10 = ((var8.indexB)) | 0;
      // line number 193
      var11 = (var8.invMassA);
      // line number 194
      var12 = (var8.invIA);
      // line number 195
      var13 = (var8.invMassB);
      // line number 196
      var14 = (var8.invIB);
      // line number 197
      var15 = ((var8.pointCount)) | 0;
      // line number 199
      var16 = phi0;
      var17 = (var16.m_velocities);
      var18 = (var17.data[var9]);
      var19 = (var18.v);
      // line number 200
      var20 = phi0;
      var21 = (var20.m_velocities);
      var22 = (var21.data[var9]);
      var23 = (var22.w);
      // line number 201
      var24 = phi0;
      var25 = (var24.m_velocities);
      var26 = (var25.data[var10]);
      var27 = (var26.v);
      // line number 202
      var28 = phi0;
      var29 = (var28.m_velocities);
      var30 = (var29.data[var10]);
      var31 = (var30.w);
      // line number 204
      var32 = (var8.normal);
      // line number 205
      var33 = var32;
      var34 = (var33.y);
      var35 = (1.0 * var34);
      // line number 206
      var36 = var32;
      var37 = (var36.x);
      var38 = (-1.0 * var37);
      // line number 208
      var39 = (0) | 0;
      phi40 = var8;
      phi41 = (var9) | 0;
      phi42 = (var10) | 0;
      phi43 = var11;
      phi44 = var12;
      phi45 = var13;
      phi46 = var14;
      phi47 = (var15) | 0;
      phi48 = var19;
      phi49 = var23;
      phi50 = var27;
      phi51 = var31;
      phi52 = var32;
      phi53 = var35;
      phi54 = var38;
      phi55 = (var39) | 0;
      L239182307: while(true) {
       var56 = (phi55) | 0;
       var57 = (phi47) | 0;
       if (var56 >= var57) {
        // line number 220
        var120 = phi0;
        var121 = (var120.m_velocities);
        var122 = (phi41) | 0;
        var123 = (var121.data[var122]);
        var124 = phi49;
        var123.w = var124;
        // line number 221
        var125 = phi0;
        var126 = (var125.m_velocities);
        var127 = (phi42) | 0;
        var128 = (var126.data[var127]);
        var129 = phi51;
        var128.w = var129;
        // line number 188
        phi1 = ((phi1 + 1)) | 0;
        // Here was a goto statement
        continue L1989193621;
       } else {
        // line number 209
        var58 = phi40;
        var59 = (var58.points);
        var60 = (phi55) | 0;
        var61 = (var59.data[var60]);
        // line number 210
        var62 = phi53;
        var63 = (var61.tangentImpulse);
        var64 = (var62 * var63);
        var65 = phi52;
        var66 = (var65.x);
        var67 = (var61.normalImpulse);
        var68 = (var66 * var67);
        var69 = (var64 + var68);
        // line number 211
        var70 = phi54;
        var71 = (var61.tangentImpulse);
        var72 = (var70 * var71);
        var73 = phi52;
        var74 = (var73.y);
        var75 = (var61.normalImpulse);
        var76 = (var74 * var75);
        var77 = (var72 + var76);
        // line number 213
        var78 = phi49;
        var79 = phi44;
        var80 = (var61.rA);
        var81 = (var80.x);
        var82 = (var81 * var77);
        var83 = (var61.rA);
        var84 = (var83.y);
        var85 = (var84 * var69);
        var86 = (var82 - var85);
        var87 = (var79 * var86);
        var88 = (var78 - var87);
        // line number 214
        var89 = phi48;
        var90 = (var89.x);
        var91 = phi43;
        var92 = (var69 * var91);
        var93 = (var90 - var92);
        var89.x = var93;
        // line number 215
        var94 = phi48;
        var95 = (var94.y);
        var96 = phi43;
        var97 = (var77 * var96);
        var98 = (var95 - var97);
        var94.y = var98;
        // line number 216
        var99 = phi51;
        var100 = phi46;
        var101 = (var61.rB);
        var102 = (var101.x);
        var103 = (var102 * var77);
        var104 = (var61.rB);
        var105 = (var104.y);
        var106 = (var105 * var69);
        var107 = (var103 - var106);
        var108 = (var100 * var107);
        var109 = (var99 + var108);
        // line number 217
        var110 = phi50;
        var111 = (var110.x);
        var112 = phi45;
        var113 = (var69 * var112);
        var114 = (var111 + var113);
        var110.x = var114;
        // line number 218
        var115 = phi50;
        var116 = (var115.y);
        var117 = phi45;
        var118 = (var77 * var117);
        var119 = (var116 + var118);
        var115.y = var119;
        // line number 208
        phi55 = ((phi55 + 1)) | 0;
        // Here was a goto statement
        phi49 = var88;
        phi51 = var109;
        continue L239182307;
       }
      }
     }
    }
  }

  V$solveVelocityConstraints$$() {
    // source file is ContactSolver.java
    var phi0 = null;
    var phi1 = 0;
    var var2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = 0;
    var var10 = 0;
    var var11 = .0;
    var var12 = .0;
    var var13 = .0;
    var var14 = .0;
    var var15 = 0;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = .0;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = null;
    var var31 = .0;
    var var32 = null;
    var var33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = null;
    var var37 = .0;
    var var38 = .0;
    var var39 = null;
    var var40 = null;
    var var41 = null;
    var var42 = null;
    var var43 = .0;
    var var44 = .0;
    var var45 = .0;
    var var46 = 0;
    var var47 = 0;
    var var48 = 0;
    var var49 = null;
    var phi50 = null;
    var phi51 = 0;
    var phi52 = 0;
    var phi53 = .0;
    var phi54 = .0;
    var phi55 = .0;
    var phi56 = .0;
    var phi57 = 0;
    var phi58 = null;
    var phi59 = .0;
    var phi60 = null;
    var phi61 = .0;
    var phi62 = null;
    var phi63 = .0;
    var var64 = 0;
    var phi65 = 0;
    var var66 = 0;
    var var67 = 0;
    var var68 = null;
    var var69 = null;
    var var70 = 0;
    var var71 = null;
    var var72 = null;
    var var73 = .0;
    var var74 = .0;
    var var75 = null;
    var var76 = .0;
    var var77 = .0;
    var var78 = null;
    var var79 = .0;
    var var80 = .0;
    var var81 = null;
    var var82 = .0;
    var var83 = .0;
    var var84 = .0;
    var var85 = .0;
    var var86 = .0;
    var var87 = .0;
    var var88 = .0;
    var var89 = null;
    var var90 = .0;
    var var91 = .0;
    var var92 = null;
    var var93 = .0;
    var var94 = .0;
    var var95 = null;
    var var96 = .0;
    var var97 = .0;
    var var98 = .0;
    var var99 = .0;
    var var100 = .0;
    var var101 = .0;
    var var102 = null;
    var var103 = null;
    var var104 = .0;
    var var105 = .0;
    var var106 = null;
    var var107 = null;
    var var108 = .0;
    var var109 = .0;
    var var110 = .0;
    var var111 = null;
    var var112 = .0;
    var var113 = .0;
    var var114 = .0;
    var var115 = .0;
    var var116 = .0;
    var var117 = .0;
    var var118 = .0;
    var var119 = .0;
    var var120 = .0;
    var var121 = .0;
    var var122 = .0;
    var var123 = .0;
    var var124 = null;
    var var125 = .0;
    var var126 = .0;
    var var127 = .0;
    var var128 = null;
    var var129 = null;
    var var130 = .0;
    var var131 = .0;
    var var132 = null;
    var var133 = null;
    var var134 = .0;
    var var135 = .0;
    var var136 = null;
    var var137 = .0;
    var var138 = .0;
    var var139 = .0;
    var var140 = .0;
    var var141 = null;
    var var142 = .0;
    var var143 = .0;
    var var144 = .0;
    var var145 = .0;
    var var146 = .0;
    var var147 = .0;
    var var148 = null;
    var var149 = .0;
    var var150 = .0;
    var var151 = null;
    var var152 = .0;
    var var153 = .0;
    var var154 = .0;
    var var155 = .0;
    var var156 = .0;
    var var157 = null;
    var var158 = .0;
    var var159 = .0;
    var var160 = .0;
    var var161 = .0;
    var var162 = null;
    var var163 = .0;
    var var164 = .0;
    var var165 = .0;
    var var166 = .0;
    var var167 = .0;
    var var168 = .0;
    var var169 = null;
    var var170 = .0;
    var var171 = .0;
    var var172 = null;
    var var173 = .0;
    var var174 = .0;
    var var175 = .0;
    var var176 = .0;
    var var177 = .0;
    var var178 = null;
    var var179 = 0;
    var var180 = null;
    var var181 = null;
    var var182 = null;
    var var183 = .0;
    var var184 = .0;
    var var185 = null;
    var var186 = .0;
    var var187 = .0;
    var var188 = null;
    var var189 = .0;
    var var190 = .0;
    var var191 = null;
    var var192 = .0;
    var var193 = .0;
    var var194 = .0;
    var var195 = null;
    var var196 = .0;
    var var197 = .0;
    var var198 = .0;
    var var199 = .0;
    var var200 = null;
    var var201 = .0;
    var var202 = .0;
    var var203 = null;
    var var204 = .0;
    var var205 = .0;
    var var206 = null;
    var var207 = .0;
    var var208 = .0;
    var var209 = .0;
    var var210 = null;
    var var211 = .0;
    var var212 = .0;
    var var213 = .0;
    var var214 = null;
    var var215 = .0;
    var var216 = .0;
    var var217 = null;
    var var218 = .0;
    var var219 = .0;
    var var220 = .0;
    var var221 = .0;
    var var222 = .0;
    var var223 = null;
    var var224 = .0;
    var var225 = .0;
    var var226 = .0;
    var var227 = .0;
    var var228 = .0;
    var var229 = 0;
    var var230 = .0;
    var phi231 = null;
    var phi232 = .0;
    var phi233 = .0;
    var phi234 = .0;
    var phi235 = .0;
    var phi236 = .0;
    var phi237 = .0;
    var var238 = .0;
    var var239 = null;
    var var240 = .0;
    var var241 = .0;
    var var242 = null;
    var var243 = null;
    var var244 = .0;
    var var245 = .0;
    var var246 = null;
    var var247 = .0;
    var var248 = .0;
    var var249 = null;
    var var250 = .0;
    var var251 = .0;
    var var252 = .0;
    var var253 = .0;
    var var254 = null;
    var var255 = .0;
    var var256 = .0;
    var var257 = .0;
    var var258 = .0;
    var var259 = .0;
    var var260 = .0;
    var var261 = null;
    var var262 = null;
    var var263 = .0;
    var var264 = .0;
    var var265 = null;
    var var266 = null;
    var var267 = .0;
    var var268 = .0;
    var var269 = .0;
    var var270 = .0;
    var var271 = .0;
    var var272 = null;
    var var273 = .0;
    var var274 = .0;
    var var275 = .0;
    var var276 = .0;
    var var277 = null;
    var var278 = .0;
    var var279 = .0;
    var var280 = .0;
    var var281 = .0;
    var var282 = .0;
    var var283 = .0;
    var var284 = null;
    var var285 = null;
    var var286 = .0;
    var var287 = .0;
    var var288 = null;
    var var289 = null;
    var var290 = .0;
    var var291 = .0;
    var var292 = .0;
    var var293 = .0;
    var var294 = .0;
    var phi295 = .0;
    var phi296 = .0;
    var phi297 = .0;
    var phi298 = .0;
    var var299 = null;
    var var300 = null;
    var var301 = 0;
    var var302 = null;
    var var303 = .0;
    var var304 = null;
    var var305 = null;
    var var306 = 0;
    var var307 = null;
    var var308 = .0;
    var var309 = null;
    var var310 = null;
    var var311 = null;
    var var312 = null;
    var var313 = null;
    var var314 = null;
    var var315 = null;
    var var316 = null;
    var var317 = .0;
    var var318 = null;
    var var319 = null;
    var var320 = .0;
    var var321 = 0;
    var var322 = null;
    var var323 = null;
    var var324 = .0;
    var var325 = 0;
    var var326 = null;
    var var327 = null;
    var var328 = .0;
    var var329 = 0;
    var phi330 = null;
    var phi331 = null;
    var var332 = null;
    var phi333 = null;
    var phi334 = null;
    var var335 = null;
    var var336 = null;
    var var337 = .0;
    var var338 = .0;
    var var339 = null;
    var var340 = null;
    var var341 = .0;
    var var342 = .0;
    var var343 = null;
    var var344 = .0;
    var var345 = .0;
    var var346 = null;
    var var347 = .0;
    var var348 = .0;
    var var349 = .0;
    var var350 = null;
    var var351 = null;
    var var352 = .0;
    var var353 = .0;
    var var354 = .0;
    var var355 = null;
    var var356 = null;
    var var357 = .0;
    var var358 = null;
    var var359 = null;
    var var360 = .0;
    var var361 = .0;
    var var362 = null;
    var var363 = .0;
    var var364 = .0;
    var var365 = null;
    var var366 = .0;
    var var367 = .0;
    var var368 = .0;
    var var369 = null;
    var var370 = null;
    var var371 = .0;
    var var372 = .0;
    var var373 = .0;
    var var374 = null;
    var var375 = null;
    var var376 = .0;
    var var377 = .0;
    var var378 = null;
    var var379 = null;
    var var380 = .0;
    var var381 = .0;
    var var382 = null;
    var var383 = .0;
    var var384 = .0;
    var var385 = null;
    var var386 = .0;
    var var387 = .0;
    var var388 = .0;
    var var389 = null;
    var var390 = null;
    var var391 = .0;
    var var392 = .0;
    var var393 = .0;
    var var394 = null;
    var var395 = null;
    var var396 = .0;
    var var397 = null;
    var var398 = null;
    var var399 = .0;
    var var400 = .0;
    var var401 = null;
    var var402 = .0;
    var var403 = .0;
    var var404 = null;
    var var405 = .0;
    var var406 = .0;
    var var407 = .0;
    var var408 = null;
    var var409 = null;
    var var410 = .0;
    var var411 = .0;
    var var412 = .0;
    var var413 = null;
    var var414 = null;
    var var415 = .0;
    var var416 = null;
    var var417 = .0;
    var var418 = .0;
    var var419 = null;
    var var420 = null;
    var var421 = .0;
    var var422 = null;
    var var423 = .0;
    var var424 = .0;
    var var425 = .0;
    var var426 = null;
    var var427 = null;
    var var428 = .0;
    var var429 = null;
    var var430 = .0;
    var var431 = .0;
    var var432 = null;
    var var433 = null;
    var var434 = .0;
    var var435 = null;
    var var436 = .0;
    var var437 = .0;
    var var438 = .0;
    var var439 = null;
    var var440 = null;
    var var441 = null;
    var var442 = .0;
    var var443 = .0;
    var var444 = null;
    var var445 = null;
    var var446 = null;
    var var447 = .0;
    var var448 = .0;
    var var449 = null;
    var var450 = null;
    var var451 = null;
    var var452 = null;
    var var453 = .0;
    var var454 = null;
    var var455 = .0;
    var var456 = null;
    var var457 = null;
    var var458 = .0;
    var var459 = .0;
    var var460 = null;
    var var461 = .0;
    var var462 = null;
    var var463 = null;
    var var464 = .0;
    var var465 = .0;
    var var466 = .0;
    var var467 = .0;
    var var468 = null;
    var var469 = null;
    var var470 = .0;
    var var471 = null;
    var var472 = .0;
    var var473 = null;
    var var474 = null;
    var var475 = .0;
    var var476 = .0;
    var var477 = null;
    var var478 = .0;
    var var479 = null;
    var var480 = null;
    var var481 = .0;
    var var482 = .0;
    var var483 = .0;
    var var484 = .0;
    var var485 = null;
    var var486 = null;
    var var487 = null;
    var var488 = null;
    var var489 = null;
    var var490 = null;
    var var491 = null;
    var var492 = null;
    var var493 = .0;
    var var494 = .0;
    var var495 = null;
    var var496 = null;
    var var497 = .0;
    var var498 = .0;
    var var499 = null;
    var var500 = null;
    var var501 = .0;
    var var502 = 0;
    var var503 = null;
    var var504 = null;
    var var505 = .0;
    var var506 = 0;
    var var507 = null;
    var var508 = null;
    var var509 = null;
    var var510 = null;
    var var511 = null;
    var var512 = null;
    var var513 = null;
    var var514 = null;
    var var515 = null;
    var var516 = null;
    var var517 = null;
    var var518 = null;
    var var519 = null;
    var var520 = null;
    var var521 = .0;
    var var522 = null;
    var var523 = null;
    var var524 = null;
    var var525 = null;
    var var526 = null;
    var var527 = null;
    var var528 = null;
    var var529 = .0;
    var var530 = null;
    var var531 = null;
    var var532 = null;
    var var533 = null;
    var var534 = null;
    var var535 = null;
    var var536 = null;
    var var537 = null;
    var var538 = null;
    var var539 = null;
    var var540 = null;
    var var541 = null;
    var var542 = null;
    var var543 = null;
    var var544 = .0;
    var var545 = null;
    var var546 = null;
    var var547 = null;
    var var548 = null;
    var var549 = null;
    var var550 = null;
    var var551 = null;
    var var552 = null;
    var var553 = null;
    var var554 = null;
    var var555 = .0;
    var var556 = null;
    var var557 = null;
    var var558 = null;
    var var559 = null;
    var var560 = null;
    var var561 = .0;
    var var562 = .0;
    var var563 = null;
    var var564 = null;
    var var565 = null;
    var var566 = null;
    var var567 = .0;
    var var568 = null;
    var var569 = null;
    var var570 = null;
    var var571 = null;
    var var572 = .0;
    var var573 = .0;
    var var574 = .0;
    var var575 = .0;
    var var576 = .0;
    var var577 = .0;
    var var578 = null;
    var var579 = null;
    var var580 = null;
    var var581 = null;
    var var582 = .0;
    var var583 = null;
    var var584 = null;
    var var585 = null;
    var var586 = null;
    var var587 = .0;
    var var588 = .0;
    var var589 = .0;
    var var590 = .0;
    var var591 = null;
    var var592 = null;
    var var593 = null;
    var var594 = .0;
    var var595 = null;
    var var596 = null;
    var var597 = null;
    var var598 = .0;
    var phi599 = .0;
    var phi600 = .0;
    var phi601 = null;
    var var602 = null;
    var var603 = null;
    var var604 = null;
    var var605 = .0;
    var var606 = .0;
    var var607 = null;
    var var608 = null;
    var var609 = .0;
    var var610 = .0;
    var var611 = null;
    var var612 = null;
    var var613 = .0;
    var var614 = null;
    var var615 = null;
    var var616 = null;
    var var617 = .0;
    var var618 = null;
    var var619 = null;
    var var620 = .0;
    var var621 = .0;
    var var622 = null;
    var var623 = null;
    var var624 = .0;
    var var625 = .0;
    var var626 = null;
    var var627 = null;
    var var628 = .0;
    var var629 = 0;
    var var630 = .0;
    var var631 = 0;
    var var632 = null;
    var var633 = null;
    var var634 = null;
    var var635 = null;
    var var636 = null;
    var var637 = null;
    var var638 = null;
    var var639 = null;
    var var640 = null;
    var var641 = null;
    var var642 = null;
    var var643 = null;
    var var644 = null;
    var var645 = null;
    var var646 = .0;
    var var647 = null;
    var var648 = null;
    var var649 = null;
    var var650 = null;
    var var651 = null;
    var var652 = null;
    var var653 = null;
    var var654 = .0;
    var var655 = null;
    var var656 = null;
    var var657 = null;
    var var658 = null;
    var var659 = null;
    var var660 = null;
    var var661 = null;
    var var662 = null;
    var var663 = null;
    var var664 = null;
    var var665 = null;
    var var666 = null;
    var var667 = null;
    var var668 = null;
    var var669 = .0;
    var var670 = null;
    var var671 = null;
    var var672 = null;
    var var673 = null;
    var var674 = null;
    var var675 = null;
    var var676 = null;
    var var677 = null;
    var var678 = null;
    var var679 = null;
    var var680 = .0;
    var var681 = null;
    var var682 = null;
    var var683 = null;
    var var684 = null;
    var var685 = null;
    var var686 = .0;
    var var687 = .0;
    var var688 = null;
    var var689 = null;
    var var690 = null;
    var var691 = null;
    var var692 = .0;
    var var693 = null;
    var var694 = null;
    var var695 = null;
    var var696 = null;
    var var697 = .0;
    var var698 = .0;
    var var699 = .0;
    var var700 = .0;
    var var701 = .0;
    var var702 = .0;
    var var703 = null;
    var var704 = null;
    var var705 = null;
    var var706 = null;
    var var707 = .0;
    var var708 = null;
    var var709 = null;
    var var710 = null;
    var var711 = null;
    var var712 = .0;
    var var713 = .0;
    var var714 = .0;
    var var715 = .0;
    var var716 = null;
    var var717 = null;
    var var718 = null;
    var var719 = .0;
    var var720 = null;
    var var721 = null;
    var var722 = null;
    var var723 = .0;
    var phi724 = .0;
    var phi725 = .0;
    var var726 = null;
    var var727 = null;
    var var728 = null;
    var var729 = null;
    var var730 = null;
    var var731 = .0;
    var var732 = .0;
    var var733 = null;
    var var734 = null;
    var var735 = .0;
    var var736 = .0;
    var var737 = null;
    var var738 = null;
    var var739 = null;
    var var740 = .0;
    var var741 = null;
    var var742 = null;
    var var743 = .0;
    var var744 = .0;
    var var745 = null;
    var var746 = null;
    var var747 = .0;
    var var748 = .0;
    var var749 = .0;
    var var750 = null;
    var var751 = null;
    var var752 = .0;
    var var753 = 0;
    var var754 = .0;
    var var755 = 0;
    var var756 = null;
    var var757 = null;
    var var758 = null;
    var var759 = null;
    var var760 = null;
    var var761 = null;
    var var762 = null;
    var var763 = null;
    var var764 = null;
    var var765 = null;
    var var766 = null;
    var var767 = null;
    var var768 = null;
    var var769 = null;
    var var770 = .0;
    var var771 = null;
    var var772 = null;
    var var773 = null;
    var var774 = null;
    var var775 = null;
    var var776 = null;
    var var777 = null;
    var var778 = .0;
    var var779 = null;
    var var780 = null;
    var var781 = null;
    var var782 = null;
    var var783 = null;
    var var784 = null;
    var var785 = null;
    var var786 = null;
    var var787 = null;
    var var788 = null;
    var var789 = null;
    var var790 = null;
    var var791 = null;
    var var792 = null;
    var var793 = .0;
    var var794 = null;
    var var795 = null;
    var var796 = null;
    var var797 = null;
    var var798 = null;
    var var799 = null;
    var var800 = null;
    var var801 = null;
    var var802 = null;
    var var803 = null;
    var var804 = .0;
    var var805 = null;
    var var806 = null;
    var var807 = null;
    var var808 = null;
    var var809 = null;
    var var810 = .0;
    var var811 = .0;
    var var812 = null;
    var var813 = null;
    var var814 = null;
    var var815 = null;
    var var816 = .0;
    var var817 = null;
    var var818 = null;
    var var819 = null;
    var var820 = null;
    var var821 = .0;
    var var822 = .0;
    var var823 = .0;
    var var824 = .0;
    var var825 = .0;
    var var826 = .0;
    var var827 = null;
    var var828 = null;
    var var829 = null;
    var var830 = null;
    var var831 = .0;
    var var832 = null;
    var var833 = null;
    var var834 = null;
    var var835 = null;
    var var836 = .0;
    var var837 = .0;
    var var838 = .0;
    var var839 = .0;
    var var840 = null;
    var var841 = null;
    var var842 = null;
    var var843 = .0;
    var var844 = null;
    var var845 = null;
    var var846 = null;
    var var847 = .0;
    var phi848 = .0;
    var phi849 = .0;
    var var850 = null;
    var var851 = null;
    var var852 = null;
    var var853 = null;
    var var854 = null;
    var var855 = null;
    var var856 = .0;
    var var857 = null;
    var var858 = null;
    var var859 = .0;
    var var860 = 0;
    var var861 = .0;
    var var862 = 0;
    var var863 = null;
    var var864 = null;
    var var865 = null;
    var var866 = null;
    var var867 = null;
    var var868 = null;
    var var869 = null;
    var var870 = null;
    var var871 = null;
    var var872 = null;
    var var873 = null;
    var var874 = null;
    var var875 = null;
    var var876 = null;
    var var877 = .0;
    var var878 = null;
    var var879 = null;
    var var880 = null;
    var var881 = null;
    var var882 = null;
    var var883 = null;
    var var884 = null;
    var var885 = .0;
    var var886 = null;
    var var887 = null;
    var var888 = null;
    var var889 = null;
    var var890 = null;
    var var891 = null;
    var var892 = null;
    var var893 = null;
    var var894 = null;
    var var895 = null;
    var var896 = null;
    var var897 = null;
    var var898 = null;
    var var899 = null;
    var var900 = .0;
    var var901 = null;
    var var902 = null;
    var var903 = null;
    var var904 = null;
    var var905 = null;
    var var906 = null;
    var var907 = null;
    var var908 = null;
    var var909 = null;
    var var910 = null;
    var var911 = .0;
    var var912 = null;
    var var913 = null;
    var var914 = null;
    var var915 = null;
    var var916 = null;
    var var917 = .0;
    var var918 = .0;
    var var919 = null;
    var var920 = null;
    var var921 = null;
    var var922 = null;
    var var923 = .0;
    var var924 = null;
    var var925 = null;
    var var926 = null;
    var var927 = null;
    var var928 = .0;
    var var929 = .0;
    var var930 = .0;
    var var931 = .0;
    var var932 = .0;
    var var933 = .0;
    var var934 = null;
    var var935 = null;
    var var936 = null;
    var var937 = null;
    var var938 = .0;
    var var939 = null;
    var var940 = null;
    var var941 = null;
    var var942 = null;
    var var943 = .0;
    var var944 = .0;
    var var945 = .0;
    var var946 = .0;
    var var947 = null;
    var var948 = null;
    var var949 = null;
    var var950 = .0;
    var var951 = null;
    var var952 = null;
    var var953 = null;
    var var954 = .0;
    // line number 346
    phi0 = this;
    phi1 = (0) | 0;
    L995760210: while(true) {
     var2 = (phi1) | 0;
     var3 = phi0;
     var4 = ((var3.m_count)) | 0;
     if (var2 >= var4) {
      // line number 754
      return;
     } else {
      // line number 347
      var5 = phi0;
      var6 = (var5.m_velocityConstraints);
      var7 = (phi1) | 0;
      var8 = (var6.data[var7]);
      // line number 349
      var9 = ((var8.indexA)) | 0;
      // line number 350
      var10 = ((var8.indexB)) | 0;
      // line number 352
      var11 = (var8.invMassA);
      // line number 353
      var12 = (var8.invMassB);
      // line number 354
      var13 = (var8.invIA);
      // line number 355
      var14 = (var8.invIB);
      // line number 356
      var15 = ((var8.pointCount)) | 0;
      // line number 358
      var16 = phi0;
      var17 = (var16.m_velocities);
      var18 = (var17.data[var9]);
      var19 = (var18.v);
      // line number 359
      var20 = phi0;
      var21 = (var20.m_velocities);
      var22 = (var21.data[var9]);
      var23 = (var22.w);
      // line number 360
      var24 = phi0;
      var25 = (var24.m_velocities);
      var26 = (var25.data[var10]);
      var27 = (var26.v);
      // line number 361
      var28 = phi0;
      var29 = (var28.m_velocities);
      var30 = (var29.data[var10]);
      var31 = (var30.w);
      // line number 363
      var32 = (var8.normal);
      // line number 364
      var33 = phi0;
      var34 = (var33.tangent);
      var35 = var8;
      var36 = (var35.normal);
      var37 = (var36.y);
      var38 = (1.0 * var37);
      var34.x = var38;
      // line number 365
      var39 = phi0;
      var40 = (var39.tangent);
      var41 = var8;
      var42 = (var41.normal);
      var43 = (var42.x);
      var44 = (-1.0 * var43);
      var40.y = var44;
      // line number 366
      var45 = (var8.friction);
      // line number 368
      org$jbox2d$dynamics$contacts$ContactSolver.$i;
      var46 = (org$jbox2d$dynamics$contacts$ContactSolver.$assertionsDisabled);
      If_174_0: {
       if (var46 != 0) {
        phi50 = var8;
        phi51 = (var9) | 0;
        phi52 = (var10) | 0;
        phi53 = var11;
        phi54 = var12;
        phi55 = var13;
        phi56 = var14;
        phi57 = (var15) | 0;
        phi58 = var19;
        phi59 = var23;
        phi60 = var27;
        phi61 = var31;
        phi62 = var32;
        phi63 = var45;
        break If_174_0;
       } else {
        var47 = (var15) | 0;
        if (var47 == 1) {
         phi50 = var8;
         phi51 = (var9) | 0;
         phi52 = (var10) | 0;
         phi53 = var11;
         phi54 = var12;
         phi55 = var13;
         phi56 = var14;
         phi57 = (var15) | 0;
         phi58 = var19;
         phi59 = var23;
         phi60 = var27;
         phi61 = var31;
         phi62 = var32;
         phi63 = var45;
         break If_174_0;
        } else {
         var48 = (var15) | 0;
         if (var48 == 2) {
          phi50 = var8;
          phi51 = (var9) | 0;
          phi52 = (var10) | 0;
          phi53 = var11;
          phi54 = var12;
          phi55 = var13;
          phi56 = var14;
          phi57 = (var15) | 0;
          phi58 = var19;
          phi59 = var23;
          phi60 = var27;
          phi61 = var31;
          phi62 = var32;
          phi63 = var45;
          break If_174_0;
         } else {
          var49 = new java$lang$AssertionError();
          java$lang$AssertionError.prototype.V$$init$$$.call(var49);
          throw bytecoder.registerStack(var49, new Error().stack);
         }
        }
       }
      }
      // line number 371
      var64 = (0) | 0;
      phi65 = (var64) | 0;
      L1873141276: while(true) {
       var66 = (phi65) | 0;
       var67 = (phi57) | 0;
       if (var66 >= var67) {
        // line number 406
        var178 = phi50;
        var179 = ((var178.pointCount)) | 0;
        If_581_0: {
         if (var179 != 1) {
          // line number 478
          var309 = phi50;
          var310 = (var309.points);
          var311 = (var310.data[0]);
          // line number 479
          var312 = phi50;
          var313 = (var312.points);
          var314 = (var313.data[1]);
          // line number 480
          var315 = phi0;
          var316 = (var315.a);
          var317 = (var311.normalImpulse);
          var316.x = var317;
          // line number 481
          var318 = phi0;
          var319 = (var318.a);
          var320 = (var314.normalImpulse);
          var319.y = var320;
          // line number 483
          var321 = (org$jbox2d$dynamics$contacts$ContactSolver.$assertionsDisabled);
          If_1025_0: {
           if (var321 != 0) {
            phi333 = var311;
            phi334 = var314;
            break If_1025_0;
           } else {
            var322 = phi0;
            var323 = (var322.a);
            var324 = (var323.x);
            var325 = (bytecoder.cmp(var324,0.0)) | 0;
            If_1040_0: {
             if (var325 < 0) {
              phi330 = var311;
              phi331 = var314;
              break If_1040_0;
             } else {
              var326 = phi0;
              var327 = (var326.a);
              var328 = (var327.y);
              var329 = (bytecoder.cmp(var328,0.0)) | 0;
              if (var329 >= 0) {
               phi333 = var311;
               phi334 = var314;
               break If_1025_0;
              } else {
               phi330 = var311;
               phi331 = var314;
               break If_1040_0;
              }
             }
            }
            var332 = new java$lang$AssertionError();
            java$lang$AssertionError.prototype.V$$init$$$.call(var332);
            throw bytecoder.registerStack(var332, new Error().stack);
           }
          }
          // line number 486
          var335 = phi0;
          var336 = (var335.dv1);
          var337 = phi61;
          var338 = (0 - var337);
          var339 = phi333;
          var340 = (var339.rB);
          var341 = (var340.y);
          var342 = (var338 * var341);
          var343 = phi60;
          var344 = (var343.x);
          var345 = (var342 + var344);
          var346 = phi58;
          var347 = (var346.x);
          var348 = (var345 - var347);
          var349 = phi59;
          var350 = phi333;
          var351 = (var350.rA);
          var352 = (var351.y);
          var353 = (var349 * var352);
          var354 = (var348 + var353);
          var336.x = var354;
          // line number 487
          var355 = phi0;
          var356 = (var355.dv1);
          var357 = phi61;
          var358 = phi333;
          var359 = (var358.rB);
          var360 = (var359.x);
          var361 = (var357 * var360);
          var362 = phi60;
          var363 = (var362.y);
          var364 = (var361 + var363);
          var365 = phi58;
          var366 = (var365.y);
          var367 = (var364 - var366);
          var368 = phi59;
          var369 = phi333;
          var370 = (var369.rA);
          var371 = (var370.x);
          var372 = (var368 * var371);
          var373 = (var367 - var372);
          var356.y = var373;
          // line number 490
          var374 = phi0;
          var375 = (var374.dv2);
          var376 = phi61;
          var377 = (0 - var376);
          var378 = phi334;
          var379 = (var378.rB);
          var380 = (var379.y);
          var381 = (var377 * var380);
          var382 = phi60;
          var383 = (var382.x);
          var384 = (var381 + var383);
          var385 = phi58;
          var386 = (var385.x);
          var387 = (var384 - var386);
          var388 = phi59;
          var389 = phi334;
          var390 = (var389.rA);
          var391 = (var390.y);
          var392 = (var388 * var391);
          var393 = (var387 + var392);
          var375.x = var393;
          // line number 491
          var394 = phi0;
          var395 = (var394.dv2);
          var396 = phi61;
          var397 = phi334;
          var398 = (var397.rB);
          var399 = (var398.x);
          var400 = (var396 * var399);
          var401 = phi60;
          var402 = (var401.y);
          var403 = (var400 + var402);
          var404 = phi58;
          var405 = (var404.y);
          var406 = (var403 - var405);
          var407 = phi59;
          var408 = phi334;
          var409 = (var408.rA);
          var410 = (var409.x);
          var411 = (var407 * var410);
          var412 = (var406 - var411);
          var395.y = var412;
          // line number 494
          var413 = phi0;
          var414 = (var413.dv1);
          var415 = (var414.x);
          var416 = phi62;
          var417 = (var416.x);
          var418 = (var415 * var417);
          var419 = phi0;
          var420 = (var419.dv1);
          var421 = (var420.y);
          var422 = phi62;
          var423 = (var422.y);
          var424 = (var421 * var423);
          var425 = (var418 + var424);
          // line number 495
          var426 = phi0;
          var427 = (var426.dv2);
          var428 = (var427.x);
          var429 = phi62;
          var430 = (var429.x);
          var431 = (var428 * var430);
          var432 = phi0;
          var433 = (var432.dv2);
          var434 = (var433.y);
          var435 = phi62;
          var436 = (var435.y);
          var437 = (var434 * var436);
          var438 = (var431 + var437);
          // line number 497
          var439 = phi0;
          var440 = (var439.b);
          var441 = phi333;
          var442 = (var441.velocityBias);
          var443 = (var425 - var442);
          var440.x = var443;
          // line number 498
          var444 = phi0;
          var445 = (var444.b);
          var446 = phi334;
          var447 = (var446.velocityBias);
          var448 = (var438 - var447);
          var445.y = var448;
          // line number 502
          var449 = phi50;
          var450 = (var449.K);
          // line number 503
          var451 = phi0;
          var452 = (var451.b);
          var453 = (var452.x);
          var454 = (var450.ex);
          var455 = (var454.x);
          var456 = phi0;
          var457 = (var456.a);
          var458 = (var457.x);
          var459 = (var455 * var458);
          var460 = (var450.ey);
          var461 = (var460.x);
          var462 = phi0;
          var463 = (var462.a);
          var464 = (var463.y);
          var465 = (var461 * var464);
          var466 = (var459 + var465);
          var467 = (var453 - var466);
          var452.x = var467;
          // line number 504
          var468 = phi0;
          var469 = (var468.b);
          var470 = (var469.y);
          var471 = (var450.ex);
          var472 = (var471.y);
          var473 = phi0;
          var474 = (var473.a);
          var475 = (var474.x);
          var476 = (var472 * var475);
          var477 = (var450.ey);
          var478 = (var477.y);
          var479 = phi0;
          var480 = (var479.a);
          var481 = (var480.y);
          var482 = (var478 * var481);
          var483 = (var476 + var482);
          var484 = (var470 - var483);
          var469.y = var484;
          // line number 520
          var485 = phi50;
          var486 = (var485.normalMass);
          var487 = phi0;
          var488 = (var487.b);
          var489 = phi0;
          var490 = (var489.x);
          org$jbox2d$common$Mat22.$i;
          org$jbox2d$common$Mat22.V$mulToOutUnsafe$Lorg$jbox2d$common$Mat22$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var486,var488,var490);
          // line number 521
          var491 = phi0;
          var492 = (var491.x);
          var493 = (var492.x);
          var494 = (var493 * -1.0);
          var492.x = var494;
          // line number 522
          var495 = phi0;
          var496 = (var495.x);
          var497 = (var496.y);
          var498 = (var497 * -1.0);
          var496.y = var498;
          // line number 524
          var499 = phi0;
          var500 = (var499.x);
          var501 = (var500.x);
          var502 = (bytecoder.cmp(var501,0.0)) | 0;
          If_1569_0: {
           if (var502 < 0) {
            phi599 = var425;
            phi600 = var438;
            phi601 = var450;
            break If_1569_0;
           } else {
            var503 = phi0;
            var504 = (var503.x);
            var505 = (var504.y);
            var506 = (bytecoder.cmp(var505,0.0)) | 0;
            if (var506 < 0) {
             phi599 = var425;
             phi600 = var438;
             phi601 = var450;
             break If_1569_0;
            } else {
             // line number 528
             var507 = phi0;
             var508 = (var507.d);
             var509 = phi0;
             var510 = (var509.x);
             var511 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var508,var510));
             var512 = phi0;
             var513 = (var512.a);
             var514 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var511,var513));
             // line number 533
             var515 = phi0;
             var516 = (var515.P1);
             var517 = phi62;
             var518 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var516,var517));
             var519 = phi0;
             var520 = (var519.d);
             var521 = (var520.x);
             var522 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var518,var521));
             // line number 534
             var523 = phi0;
             var524 = (var523.P2);
             var525 = phi62;
             var526 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var524,var525));
             var527 = phi0;
             var528 = (var527.d);
             var529 = (var528.y);
             var530 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var526,var529));
             // line number 542
             var531 = phi0;
             var532 = (var531.temp1);
             var533 = phi0;
             var534 = (var533.P1);
             var535 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var532,var534));
             var536 = phi0;
             var537 = (var536.P2);
             var538 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var535,var537));
             // line number 543
             var539 = phi0;
             var540 = (var539.temp2);
             var541 = phi0;
             var542 = (var541.temp1);
             var543 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var540,var542));
             var544 = phi53;
             var545 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var543,var544));
             // line number 544
             var546 = phi58;
             var547 = phi0;
             var548 = (var547.temp2);
             var549 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var546,var548));
             // line number 545
             var550 = phi0;
             var551 = (var550.temp2);
             var552 = phi0;
             var553 = (var552.temp1);
             var554 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var551,var553));
             var555 = phi54;
             var556 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var554,var555));
             // line number 546
             var557 = phi60;
             var558 = phi0;
             var559 = (var558.temp2);
             var560 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var557,var559));
             // line number 548
             var561 = phi59;
             var562 = phi55;
             var563 = phi333;
             var564 = (var563.rA);
             var565 = phi0;
             var566 = (var565.P1);
             org$jbox2d$common$Vec2.$i;
             var567 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var564,var566));
             var568 = phi334;
             var569 = (var568.rA);
             var570 = phi0;
             var571 = (var570.P2);
             var572 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var569,var571));
             var573 = (var567 + var572);
             var574 = (var562 * var573);
             var575 = (var561 - var574);
             // line number 549
             var576 = phi61;
             var577 = phi56;
             var578 = phi333;
             var579 = (var578.rB);
             var580 = phi0;
             var581 = (var580.P1);
             var582 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var579,var581));
             var583 = phi334;
             var584 = (var583.rB);
             var585 = phi0;
             var586 = (var585.P2);
             var587 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var584,var586));
             var588 = (var582 + var587);
             var589 = (var577 * var588);
             var590 = (var576 + var589);
             // line number 552
             var591 = phi333;
             var592 = phi0;
             var593 = (var592.x);
             var594 = (var593.x);
             var591.normalImpulse = var594;
             // line number 553
             var595 = phi334;
             var596 = phi0;
             var597 = (var596.x);
             var598 = (var597.y);
             var595.normalImpulse = var598;
             // line number 577
             // Here was a goto statement
             phi295 = var575;
             phi296 = var590;
             phi231 = phi333;
             phi233 = var425;
             phi234 = var438;
             break If_581_0;
            }
           }
          }
          // line number 586
          var602 = phi0;
          var603 = (var602.x);
          var604 = phi333;
          var605 = (var604.normalMass);
          var606 = (0 - var605);
          var607 = phi0;
          var608 = (var607.b);
          var609 = (var608.x);
          var610 = (var606 * var609);
          var603.x = var610;
          // line number 587
          var611 = phi0;
          var612 = (var611.x);
          var612.y = 0.0;
          // line number 588
          var613 = 0.0;
          // line number 589
          var614 = phi50;
          var615 = (var614.K);
          var616 = (var615.ex);
          var617 = (var616.y);
          var618 = phi0;
          var619 = (var618.x);
          var620 = (var619.x);
          var621 = (var617 * var620);
          var622 = phi0;
          var623 = (var622.b);
          var624 = (var623.y);
          var625 = (var621 + var624);
          // line number 591
          var626 = phi0;
          var627 = (var626.x);
          var628 = (var627.x);
          var629 = (bytecoder.cmp(var628,0.0)) | 0;
          If_1953_0: {
           if (var629 < 0) {
            phi724 = var613;
            phi725 = var625;
            break If_1953_0;
           } else {
            var630 = var625;
            var631 = (bytecoder.cmp(var630,0.0)) | 0;
            if (var631 < 0) {
             phi724 = var613;
             phi725 = var625;
             break If_1953_0;
            } else {
             // line number 594
             var632 = phi0;
             var633 = (var632.d);
             var634 = phi0;
             var635 = (var634.x);
             var636 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var633,var635));
             var637 = phi0;
             var638 = (var637.a);
             var639 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var636,var638));
             // line number 599
             var640 = phi0;
             var641 = (var640.P1);
             var642 = phi62;
             var643 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var641,var642));
             var644 = phi0;
             var645 = (var644.d);
             var646 = (var645.x);
             var647 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var643,var646));
             // line number 600
             var648 = phi0;
             var649 = (var648.P2);
             var650 = phi62;
             var651 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var649,var650));
             var652 = phi0;
             var653 = (var652.d);
             var654 = (var653.y);
             var655 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var651,var654));
             // line number 609
             var656 = phi0;
             var657 = (var656.temp1);
             var658 = phi0;
             var659 = (var658.P1);
             var660 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var657,var659));
             var661 = phi0;
             var662 = (var661.P2);
             var663 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var660,var662));
             // line number 610
             var664 = phi0;
             var665 = (var664.temp2);
             var666 = phi0;
             var667 = (var666.temp1);
             var668 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var665,var667));
             var669 = phi53;
             var670 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var668,var669));
             // line number 611
             var671 = phi58;
             var672 = phi0;
             var673 = (var672.temp2);
             var674 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var671,var673));
             // line number 612
             var675 = phi0;
             var676 = (var675.temp2);
             var677 = phi0;
             var678 = (var677.temp1);
             var679 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var676,var678));
             var680 = phi54;
             var681 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var679,var680));
             // line number 613
             var682 = phi60;
             var683 = phi0;
             var684 = (var683.temp2);
             var685 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var682,var684));
             // line number 615
             var686 = phi59;
             var687 = phi55;
             var688 = phi333;
             var689 = (var688.rA);
             var690 = phi0;
             var691 = (var690.P1);
             org$jbox2d$common$Vec2.$i;
             var692 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var689,var691));
             var693 = phi334;
             var694 = (var693.rA);
             var695 = phi0;
             var696 = (var695.P2);
             var697 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var694,var696));
             var698 = (var692 + var697);
             var699 = (var687 * var698);
             var700 = (var686 - var699);
             // line number 616
             var701 = phi61;
             var702 = phi56;
             var703 = phi333;
             var704 = (var703.rB);
             var705 = phi0;
             var706 = (var705.P1);
             var707 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var704,var706));
             var708 = phi334;
             var709 = (var708.rB);
             var710 = phi0;
             var711 = (var710.P2);
             var712 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var709,var711));
             var713 = (var707 + var712);
             var714 = (var702 * var713);
             var715 = (var701 + var714);
             // line number 619
             var716 = phi333;
             var717 = phi0;
             var718 = (var717.x);
             var719 = (var718.x);
             var716.normalImpulse = var719;
             // line number 620
             var720 = phi334;
             var721 = phi0;
             var722 = (var721.x);
             var723 = (var722.y);
             var720.normalImpulse = var723;
             // line number 639
             // Here was a goto statement
             phi295 = var700;
             phi296 = var715;
             phi231 = phi333;
             phi233 = var613;
             phi234 = var625;
             break If_581_0;
            }
           }
          }
          // line number 648
          var726 = phi0;
          var727 = (var726.x);
          var727.x = 0.0;
          // line number 649
          var728 = phi0;
          var729 = (var728.x);
          var730 = phi334;
          var731 = (var730.normalMass);
          var732 = (0 - var731);
          var733 = phi0;
          var734 = (var733.b);
          var735 = (var734.y);
          var736 = (var732 * var735);
          var729.y = var736;
          // line number 650
          var737 = phi50;
          var738 = (var737.K);
          var739 = (var738.ey);
          var740 = (var739.x);
          var741 = phi0;
          var742 = (var741.x);
          var743 = (var742.y);
          var744 = (var740 * var743);
          var745 = phi0;
          var746 = (var745.b);
          var747 = (var746.x);
          var748 = (var744 + var747);
          // line number 651
          var749 = 0.0;
          // line number 653
          var750 = phi0;
          var751 = (var750.x);
          var752 = (var751.y);
          var753 = (bytecoder.cmp(var752,0.0)) | 0;
          If_2329_0: {
           if (var753 < 0) {
            phi848 = var748;
            phi849 = var749;
            break If_2329_0;
           } else {
            var754 = var748;
            var755 = (bytecoder.cmp(var754,0.0)) | 0;
            if (var755 < 0) {
             phi848 = var748;
             phi849 = var749;
             break If_2329_0;
            } else {
             // line number 656
             var756 = phi0;
             var757 = (var756.d);
             var758 = phi0;
             var759 = (var758.x);
             var760 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var757,var759));
             var761 = phi0;
             var762 = (var761.a);
             var763 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var760,var762));
             // line number 666
             var764 = phi0;
             var765 = (var764.P1);
             var766 = phi62;
             var767 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var765,var766));
             var768 = phi0;
             var769 = (var768.d);
             var770 = (var769.x);
             var771 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var767,var770));
             // line number 667
             var772 = phi0;
             var773 = (var772.P2);
             var774 = phi62;
             var775 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var773,var774));
             var776 = phi0;
             var777 = (var776.d);
             var778 = (var777.y);
             var779 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var775,var778));
             // line number 669
             var780 = phi0;
             var781 = (var780.temp1);
             var782 = phi0;
             var783 = (var782.P1);
             var784 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var781,var783));
             var785 = phi0;
             var786 = (var785.P2);
             var787 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var784,var786));
             // line number 670
             var788 = phi0;
             var789 = (var788.temp2);
             var790 = phi0;
             var791 = (var790.temp1);
             var792 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var789,var791));
             var793 = phi53;
             var794 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var792,var793));
             // line number 671
             var795 = phi58;
             var796 = phi0;
             var797 = (var796.temp2);
             var798 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var795,var797));
             // line number 672
             var799 = phi0;
             var800 = (var799.temp2);
             var801 = phi0;
             var802 = (var801.temp1);
             var803 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var800,var802));
             var804 = phi54;
             var805 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var803,var804));
             // line number 673
             var806 = phi60;
             var807 = phi0;
             var808 = (var807.temp2);
             var809 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var806,var808));
             // line number 675
             var810 = phi59;
             var811 = phi55;
             var812 = phi333;
             var813 = (var812.rA);
             var814 = phi0;
             var815 = (var814.P1);
             org$jbox2d$common$Vec2.$i;
             var816 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var813,var815));
             var817 = phi334;
             var818 = (var817.rA);
             var819 = phi0;
             var820 = (var819.P2);
             var821 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var818,var820));
             var822 = (var816 + var821);
             var823 = (var811 * var822);
             var824 = (var810 - var823);
             // line number 676
             var825 = phi61;
             var826 = phi56;
             var827 = phi333;
             var828 = (var827.rB);
             var829 = phi0;
             var830 = (var829.P1);
             var831 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var828,var830));
             var832 = phi334;
             var833 = (var832.rB);
             var834 = phi0;
             var835 = (var834.P2);
             var836 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var833,var835));
             var837 = (var831 + var836);
             var838 = (var826 * var837);
             var839 = (var825 + var838);
             // line number 679
             var840 = phi333;
             var841 = phi0;
             var842 = (var841.x);
             var843 = (var842.x);
             var840.normalImpulse = var843;
             // line number 680
             var844 = phi334;
             var845 = phi0;
             var846 = (var845.x);
             var847 = (var846.y);
             var844.normalImpulse = var847;
             // line number 699
             // Here was a goto statement
             phi295 = var824;
             phi296 = var839;
             phi231 = phi333;
             phi233 = var748;
             phi234 = var749;
             break If_581_0;
            }
           }
          }
          // line number 707
          var850 = phi0;
          var851 = (var850.x);
          var851.x = 0.0;
          // line number 708
          var852 = phi0;
          var853 = (var852.x);
          var853.y = 0.0;
          // line number 709
          var854 = phi0;
          var855 = (var854.b);
          var856 = (var855.x);
          // line number 710
          var857 = phi0;
          var858 = (var857.b);
          var859 = (var858.y);
          // line number 712
          var860 = (bytecoder.cmp(var856,0.0)) | 0;
          if (var860 < 0) {
           phi295 = phi59;
           phi296 = phi61;
           phi231 = phi333;
           phi233 = var856;
           phi234 = var859;
           break If_581_0;
          } else {
           var861 = var859;
           var862 = (bytecoder.cmp(var861,0.0)) | 0;
           if (var862 < 0) {
            phi295 = phi59;
            phi296 = phi61;
            phi231 = phi333;
            phi233 = var856;
            phi234 = var859;
            break If_581_0;
           } else {
            // line number 715
            var863 = phi0;
            var864 = (var863.d);
            var865 = phi0;
            var866 = (var865.x);
            var867 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var864,var866));
            var868 = phi0;
            var869 = (var868.a);
            var870 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var867,var869));
            // line number 725
            var871 = phi0;
            var872 = (var871.P1);
            var873 = phi62;
            var874 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var872,var873));
            var875 = phi0;
            var876 = (var875.d);
            var877 = (var876.x);
            var878 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var874,var877));
            // line number 726
            var879 = phi0;
            var880 = (var879.P2);
            var881 = phi62;
            var882 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var880,var881));
            var883 = phi0;
            var884 = (var883.d);
            var885 = (var884.y);
            var886 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var882,var885));
            // line number 728
            var887 = phi0;
            var888 = (var887.temp1);
            var889 = phi0;
            var890 = (var889.P1);
            var891 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var888,var890));
            var892 = phi0;
            var893 = (var892.P2);
            var894 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var891,var893));
            // line number 729
            var895 = phi0;
            var896 = (var895.temp2);
            var897 = phi0;
            var898 = (var897.temp1);
            var899 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var896,var898));
            var900 = phi53;
            var901 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var899,var900));
            // line number 730
            var902 = phi58;
            var903 = phi0;
            var904 = (var903.temp2);
            var905 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var902,var904));
            // line number 731
            var906 = phi0;
            var907 = (var906.temp2);
            var908 = phi0;
            var909 = (var908.temp1);
            var910 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var907,var909));
            var911 = phi54;
            var912 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var910,var911));
            // line number 732
            var913 = phi60;
            var914 = phi0;
            var915 = (var914.temp2);
            var916 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var913,var915));
            // line number 734
            var917 = phi59;
            var918 = phi55;
            var919 = phi333;
            var920 = (var919.rA);
            var921 = phi0;
            var922 = (var921.P1);
            org$jbox2d$common$Vec2.$i;
            var923 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var920,var922));
            var924 = phi334;
            var925 = (var924.rA);
            var926 = phi0;
            var927 = (var926.P2);
            var928 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var925,var927));
            var929 = (var923 + var928);
            var930 = (var918 * var929);
            var931 = (var917 - var930);
            // line number 735
            var932 = phi61;
            var933 = phi56;
            var934 = phi333;
            var935 = (var934.rB);
            var936 = phi0;
            var937 = (var936.P1);
            var938 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var935,var937));
            var939 = phi334;
            var940 = (var939.rB);
            var941 = phi0;
            var942 = (var941.P2);
            var943 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var940,var942));
            var944 = (var938 + var943);
            var945 = (var933 * var944);
            var946 = (var932 + var945);
            // line number 738
            var947 = phi333;
            var948 = phi0;
            var949 = (var948.x);
            var950 = (var949.x);
            var947.normalImpulse = var950;
            // line number 739
            var951 = phi334;
            var952 = phi0;
            var953 = (var952.x);
            var954 = (var953.y);
            var951.normalImpulse = var954;
            phi295 = var931;
            phi296 = var946;
            phi231 = phi333;
            phi233 = var856;
            phi234 = var859;
            break If_581_0;
           }
          }
         } else {
          // line number 407
          var180 = phi50;
          var181 = (var180.points);
          var182 = (var181.data[0]);
          // line number 412
          var183 = phi61;
          var184 = (0 - var183);
          var185 = (var182.rB);
          var186 = (var185.y);
          var187 = (var184 * var186);
          var188 = phi60;
          var189 = (var188.x);
          var190 = (var187 + var189);
          var191 = phi58;
          var192 = (var191.x);
          var193 = (var190 - var192);
          var194 = phi59;
          var195 = (var182.rA);
          var196 = (var195.y);
          var197 = (var194 * var196);
          var198 = (var193 + var197);
          // line number 413
          var199 = phi61;
          var200 = (var182.rB);
          var201 = (var200.x);
          var202 = (var199 * var201);
          var203 = phi60;
          var204 = (var203.y);
          var205 = (var202 + var204);
          var206 = phi58;
          var207 = (var206.y);
          var208 = (var205 - var207);
          var209 = phi59;
          var210 = (var182.rA);
          var211 = (var210.x);
          var212 = (var209 * var211);
          var213 = (var208 - var212);
          // line number 416
          var214 = phi62;
          var215 = (var214.x);
          var216 = (var198 * var215);
          var217 = phi62;
          var218 = (var217.y);
          var219 = (var213 * var218);
          var220 = (var216 + var219);
          // line number 417
          var221 = (var182.normalMass);
          var222 = (0 - var221);
          var223 = var182;
          var224 = (var223.velocityBias);
          var225 = (var220 - var224);
          var226 = (var222 * var225);
          // line number 420
          var227 = (var182.normalImpulse);
          var228 = (var227 + var226);
          // line number 421
          var229 = (bytecoder.cmp(var228,0.0)) | 0;
          If_737_0: {
           if (var229 <= 0) {
            phi231 = var182;
            phi232 = var198;
            phi233 = var213;
            phi234 = var220;
            phi235 = var226;
            phi236 = var228;
            phi237 = 0.0;
            break If_737_0;
           } else {
            var230 = var228;
            // Here was a goto statement
            phi231 = var182;
            phi232 = var198;
            phi233 = var213;
            phi234 = var220;
            phi235 = var226;
            phi236 = var228;
            phi237 = var230;
            break If_737_0;
           }
          }
          var238 = phi237;
          // line number 422
          var239 = phi231;
          var240 = (var239.normalImpulse);
          var241 = (var238 - var240);
          // line number 423
          var242 = phi231;
          var242.normalImpulse = var238;
          // line number 426
          var243 = phi62;
          var244 = (var243.x);
          var245 = (var244 * var241);
          // line number 427
          var246 = phi62;
          var247 = (var246.y);
          var248 = (var247 * var241);
          // line number 430
          var249 = phi58;
          var250 = (var249.x);
          var251 = phi53;
          var252 = (var245 * var251);
          var253 = (var250 - var252);
          var249.x = var253;
          // line number 431
          var254 = phi58;
          var255 = (var254.y);
          var256 = phi53;
          var257 = (var248 * var256);
          var258 = (var255 - var257);
          var254.y = var258;
          // line number 432
          var259 = phi59;
          var260 = phi55;
          var261 = phi231;
          var262 = (var261.rA);
          var263 = (var262.x);
          var264 = (var263 * var248);
          var265 = phi231;
          var266 = (var265.rA);
          var267 = (var266.y);
          var268 = (var267 * var245);
          var269 = (var264 - var268);
          var270 = (var260 * var269);
          var271 = (var259 - var270);
          // line number 435
          var272 = phi60;
          var273 = (var272.x);
          var274 = phi54;
          var275 = (var245 * var274);
          var276 = (var273 + var275);
          var272.x = var276;
          // line number 436
          var277 = phi60;
          var278 = (var277.y);
          var279 = phi54;
          var280 = (var248 * var279);
          var281 = (var278 + var280);
          var277.y = var281;
          // line number 437
          var282 = phi61;
          var283 = phi56;
          var284 = phi231;
          var285 = (var284.rB);
          var286 = (var285.x);
          var287 = (var286 * var248);
          var288 = phi231;
          var289 = (var288.rB);
          var290 = (var289.y);
          var291 = (var290 * var245);
          var292 = (var287 - var291);
          var293 = (var283 * var292);
          var294 = (var282 + var293);
          // line number 438
          // Here was a goto statement
          phi295 = var271;
          phi296 = var294;
          phi297 = var238;
          phi298 = var248;
          break If_581_0;
         }
        }
        // line number 750
        var299 = phi0;
        var300 = (var299.m_velocities);
        var301 = (phi51) | 0;
        var302 = (var300.data[var301]);
        var303 = phi295;
        var302.w = var303;
        // line number 752
        var304 = phi0;
        var305 = (var304.m_velocities);
        var306 = (phi52) | 0;
        var307 = (var305.data[var306]);
        var308 = phi296;
        var307.w = var308;
        // line number 346
        phi1 = ((phi1 + 1)) | 0;
        // Here was a goto statement
        continue L995760210;
       } else {
        // line number 372
        var68 = phi50;
        var69 = (var68.points);
        var70 = (phi65) | 0;
        var71 = (var69.data[var70]);
        // line number 373
        var72 = (var71.rA);
        // line number 374
        var73 = phi61;
        var74 = (0 - var73);
        var75 = (var71.rB);
        var76 = (var75.y);
        var77 = (var74 * var76);
        var78 = phi60;
        var79 = (var78.x);
        var80 = (var77 + var79);
        var81 = phi58;
        var82 = (var81.x);
        var83 = (var80 - var82);
        var84 = phi59;
        var85 = (var72.y);
        var86 = (var84 * var85);
        var87 = (var83 + var86);
        // line number 375
        var88 = phi61;
        var89 = (var71.rB);
        var90 = (var89.x);
        var91 = (var88 * var90);
        var92 = phi60;
        var93 = (var92.y);
        var94 = (var91 + var93);
        var95 = phi58;
        var96 = (var95.y);
        var97 = (var94 - var96);
        var98 = phi59;
        var99 = (var72.x);
        var100 = (var98 * var99);
        var101 = (var97 - var100);
        // line number 378
        var102 = phi0;
        var103 = (var102.tangent);
        var104 = (var103.x);
        var105 = (var87 * var104);
        var106 = phi0;
        var107 = (var106.tangent);
        var108 = (var107.y);
        var109 = (var101 * var108);
        var110 = (var105 + var109);
        var111 = phi50;
        var112 = (var111.tangentSpeed);
        var113 = (var110 - var112);
        // line number 379
        var114 = (var71.tangentMass);
        var115 = (0 - var113);
        var116 = (var114 * var115);
        // line number 382
        var117 = phi63;
        var118 = (var71.normalImpulse);
        var119 = (var117 * var118);
        // line number 383
        var120 = (var71.tangentImpulse);
        var121 = (var120 + var116);
        var122 = (0 - var119);
        org$jbox2d$common$MathUtils.$i;
        var123 = (org$jbox2d$common$MathUtils.F$clamp$F$F$F(var121,var122,var119));
        // line number 385
        var124 = var71;
        var125 = (var124.tangentImpulse);
        var126 = (var123 - var125);
        // line number 386
        var127 = var123;
        var71.tangentImpulse = var127;
        // line number 391
        var128 = phi0;
        var129 = (var128.tangent);
        var130 = (var129.x);
        var131 = (var130 * var126);
        // line number 392
        var132 = phi0;
        var133 = (var132.tangent);
        var134 = (var133.y);
        var135 = (var134 * var126);
        // line number 395
        var136 = phi58;
        var137 = (var136.x);
        var138 = phi53;
        var139 = (var131 * var138);
        var140 = (var137 - var139);
        var136.x = var140;
        // line number 396
        var141 = phi58;
        var142 = (var141.y);
        var143 = phi53;
        var144 = (var135 * var143);
        var145 = (var142 - var144);
        var141.y = var145;
        // line number 397
        var146 = phi59;
        var147 = phi55;
        var148 = (var71.rA);
        var149 = (var148.x);
        var150 = (var149 * var135);
        var151 = (var71.rA);
        var152 = (var151.y);
        var153 = (var152 * var131);
        var154 = (var150 - var153);
        var155 = (var147 * var154);
        var156 = (var146 - var155);
        // line number 400
        var157 = phi60;
        var158 = (var157.x);
        var159 = phi54;
        var160 = (var131 * var159);
        var161 = (var158 + var160);
        var157.x = var161;
        // line number 401
        var162 = phi60;
        var163 = (var162.y);
        var164 = phi54;
        var165 = (var135 * var164);
        var166 = (var163 + var165);
        var162.y = var166;
        // line number 402
        var167 = phi61;
        var168 = phi56;
        var169 = (var71.rB);
        var170 = (var169.x);
        var171 = (var170 * var135);
        var172 = (var71.rB);
        var173 = (var172.y);
        var174 = (var173 * var131);
        var175 = (var171 - var174);
        var176 = (var168 * var175);
        var177 = (var167 + var176);
        // line number 371
        phi65 = ((phi65 + 1)) | 0;
        // Here was a goto statement
        phi59 = var156;
        phi61 = var177;
        continue L1873141276;
       }
      }
     }
    }
  }

  V$storeImpulses$$() {
    // source file is ContactSolver.java
    var phi0 = null;
    var phi1 = 0;
    var var2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = 0;
    var var12 = null;
    var var13 = null;
    var var14 = 0;
    var phi15 = null;
    var phi16 = null;
    var phi17 = 0;
    var var18 = 0;
    var var19 = null;
    var var20 = 0;
    var var21 = null;
    var var22 = null;
    var var23 = 0;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = 0;
    var var28 = null;
    var var29 = .0;
    var var30 = null;
    var var31 = null;
    var var32 = 0;
    var var33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = 0;
    var var37 = null;
    var var38 = .0;
    // line number 757
    phi0 = this;
    phi1 = (0) | 0;
    L1192351572: while(true) {
     var2 = (phi1) | 0;
     var3 = phi0;
     var4 = ((var3.m_count)) | 0;
     if (var2 >= var4) {
      // line number 766
      return;
     } else {
      // line number 758
      var5 = phi0;
      var6 = (var5.m_velocityConstraints);
      var7 = (phi1) | 0;
      var8 = (var6.data[var7]);
      // line number 759
      var9 = phi0;
      var10 = (var9.m_contacts);
      var11 = ((var8.contactIndex)) | 0;
      var12 = (var10.data[var11]);
      var13 = (org$jbox2d$dynamics$contacts$Contact.prototype.Lorg$jbox2d$collision$Manifold$$getManifold$$.call(var12));
      // line number 761
      var14 = (0) | 0;
      phi15 = var8;
      phi16 = var13;
      phi17 = (var14) | 0;
      L982584744: while(true) {
       var18 = (phi17) | 0;
       var19 = phi15;
       var20 = ((var19.pointCount)) | 0;
       if (var18 >= var20) {
        // line number 757
        phi1 = ((phi1 + 1)) | 0;
        // Here was a goto statement
        continue L1192351572;
       } else {
        // line number 762
        var21 = phi16;
        var22 = (var21.points);
        var23 = (phi17) | 0;
        var24 = (var22.data[var23]);
        var25 = phi15;
        var26 = (var25.points);
        var27 = (phi17) | 0;
        var28 = (var26.data[var27]);
        var29 = (var28.normalImpulse);
        var24.normalImpulse = var29;
        // line number 763
        var30 = phi16;
        var31 = (var30.points);
        var32 = (phi17) | 0;
        var33 = (var31.data[var32]);
        var34 = phi15;
        var35 = (var34.points);
        var36 = (phi17) | 0;
        var37 = (var35.data[var36]);
        var38 = (var37.tangentImpulse);
        var33.tangentImpulse = var38;
        // line number 761
        phi17 = ((phi17 + 1)) | 0;
        // Here was a goto statement
        continue L982584744;
       }
      }
     }
    }
  }

  Z$solvePositionConstraints$$() {
    // source file is ContactSolver.java
    var phi0 = null;
    var phi1 = .0;
    var phi2 = 0;
    var var3 = 0;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = 0;
    var var12 = .0;
    var var13 = .0;
    var var14 = null;
    var var15 = .0;
    var var16 = .0;
    var var17 = null;
    var var18 = 0;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = .0;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = .0;
    var var35 = 0;
    var phi36 = null;
    var phi37 = 0;
    var phi38 = 0;
    var phi39 = .0;
    var phi40 = .0;
    var phi41 = null;
    var phi42 = .0;
    var phi43 = .0;
    var phi44 = null;
    var phi45 = 0;
    var phi46 = null;
    var phi47 = .0;
    var phi48 = null;
    var phi49 = .0;
    var phi50 = 0;
    var var51 = 0;
    var var52 = 0;
    var var53 = null;
    var var54 = null;
    var var55 = null;
    var var56 = .0;
    var var57 = null;
    var var58 = null;
    var var59 = null;
    var var60 = null;
    var var61 = .0;
    var var62 = null;
    var var63 = null;
    var var64 = null;
    var var65 = null;
    var var66 = null;
    var var67 = null;
    var var68 = null;
    var var69 = null;
    var var70 = null;
    var var71 = null;
    var var72 = null;
    var var73 = null;
    var var74 = null;
    var var75 = null;
    var var76 = null;
    var var77 = null;
    var var78 = null;
    var var79 = null;
    var var80 = null;
    var var81 = null;
    var var82 = null;
    var var83 = null;
    var var84 = null;
    var var85 = null;
    var var86 = null;
    var var87 = null;
    var var88 = null;
    var var89 = null;
    var var90 = null;
    var var91 = null;
    var var92 = null;
    var var93 = null;
    var var94 = null;
    var var95 = null;
    var var96 = 0;
    var var97 = null;
    var var98 = null;
    var var99 = .0;
    var var100 = null;
    var var101 = null;
    var var102 = null;
    var var103 = null;
    var var104 = null;
    var var105 = null;
    var var106 = null;
    var var107 = null;
    var var108 = null;
    var var109 = null;
    var var110 = .0;
    var var111 = .0;
    var var112 = .0;
    var var113 = .0;
    var var114 = .0;
    var var115 = .0;
    var var116 = .0;
    var var117 = null;
    var var118 = null;
    var var119 = .0;
    var var120 = null;
    var var121 = null;
    var var122 = .0;
    var var123 = .0;
    var var124 = .0;
    var var125 = .0;
    var var126 = .0;
    var var127 = .0;
    var var128 = .0;
    var var129 = .0;
    var var130 = .0;
    var var131 = .0;
    var var132 = .0;
    var var133 = .0;
    var var134 = 0;
    var var135 = .0;
    var var136 = .0;
    var var137 = .0;
    var phi138 = .0;
    var phi139 = null;
    var phi140 = null;
    var phi141 = null;
    var phi142 = .0;
    var phi143 = .0;
    var phi144 = .0;
    var phi145 = .0;
    var phi146 = .0;
    var phi147 = .0;
    var var148 = .0;
    var var149 = null;
    var var150 = null;
    var var151 = null;
    var var152 = null;
    var var153 = null;
    var var154 = null;
    var var155 = null;
    var var156 = null;
    var var157 = null;
    var var158 = null;
    var var159 = null;
    var var160 = .0;
    var var161 = null;
    var var162 = null;
    var var163 = .0;
    var var164 = .0;
    var var165 = null;
    var var166 = null;
    var var167 = null;
    var var168 = null;
    var var169 = .0;
    var var170 = .0;
    var var171 = .0;
    var var172 = null;
    var var173 = null;
    var var174 = null;
    var var175 = null;
    var var176 = null;
    var var177 = null;
    var var178 = .0;
    var var179 = null;
    var var180 = null;
    var var181 = .0;
    var var182 = .0;
    var var183 = null;
    var var184 = null;
    var var185 = null;
    var var186 = null;
    var var187 = .0;
    var var188 = .0;
    var var189 = .0;
    var var190 = null;
    var var191 = null;
    var var192 = 0;
    var var193 = null;
    var var194 = .0;
    var var195 = null;
    var var196 = null;
    var var197 = 0;
    var var198 = null;
    var var199 = .0;
    var var200 = .0;
    var var201 = 0;
    var var202 = 0;
    var phi203 = 0;
    // line number 817
    // line number 819
    phi0 = this;
    phi1 = 0.0;
    phi2 = (0) | 0;
    L1377145511: while(true) {
     var3 = (phi2) | 0;
     var4 = phi0;
     var5 = ((var4.m_count)) | 0;
     if (var3 >= var5) {
      // line number 891
      var200 = phi1;
      var201 = (bytecoder.cmp(var200,-0.015)) | 0;
      If_626_0: {
       if (var201 < 0) {
        phi203 = (0) | 0;
        break If_626_0;
       } else {
        var202 = (1) | 0;
        // Here was a goto statement
        phi203 = (var202) | 0;
        break If_626_0;
       }
      }
      return phi203;
     } else {
      // line number 820
      var6 = phi0;
      var7 = (var6.m_positionConstraints);
      var8 = (phi2) | 0;
      var9 = (var7.data[var8]);
      // line number 822
      var10 = ((var9.indexA)) | 0;
      // line number 823
      var11 = ((var9.indexB)) | 0;
      // line number 825
      var12 = (var9.invMassA);
      // line number 826
      var13 = (var9.invIA);
      // line number 827
      var14 = (var9.localCenterA);
      // line number 828
      var15 = (var9.invMassB);
      // line number 829
      var16 = (var9.invIB);
      // line number 830
      var17 = (var9.localCenterB);
      // line number 831
      var18 = ((var9.pointCount)) | 0;
      // line number 833
      var19 = phi0;
      var20 = (var19.m_positions);
      var21 = (var20.data[var10]);
      var22 = (var21.c);
      // line number 834
      var23 = phi0;
      var24 = (var23.m_positions);
      var25 = (var24.data[var10]);
      var26 = (var25.a);
      // line number 835
      var27 = phi0;
      var28 = (var27.m_positions);
      var29 = (var28.data[var11]);
      var30 = (var29.c);
      // line number 836
      var31 = phi0;
      var32 = (var31.m_positions);
      var33 = (var32.data[var11]);
      var34 = (var33.a);
      // line number 839
      var35 = (0) | 0;
      phi36 = var9;
      phi37 = (var10) | 0;
      phi38 = (var11) | 0;
      phi39 = var12;
      phi40 = var13;
      phi41 = var14;
      phi42 = var15;
      phi43 = var16;
      phi44 = var17;
      phi45 = (var18) | 0;
      phi46 = var22;
      phi47 = var26;
      phi48 = var30;
      phi49 = var34;
      phi50 = (var35) | 0;
      L1273712774: while(true) {
       var51 = (phi50) | 0;
       var52 = (phi45) | 0;
       if (var51 >= var52) {
        // line number 883
        var190 = phi0;
        var191 = (var190.m_positions);
        var192 = (phi37) | 0;
        var193 = (var191.data[var192]);
        var194 = phi47;
        var193.a = var194;
        // line number 886
        var195 = phi0;
        var196 = (var195.m_positions);
        var197 = (phi38) | 0;
        var198 = (var196.data[var197]);
        var199 = phi49;
        var198.a = var199;
        // line number 819
        phi2 = ((phi2 + 1)) | 0;
        // Here was a goto statement
        continue L1377145511;
       } else {
        // line number 840
        var53 = phi0;
        var54 = (var53.xfA);
        var55 = (var54.q);
        var56 = phi47;
        var57 = (org$jbox2d$common$Rot.prototype.Lorg$jbox2d$common$Rot$$set$F.call(var55,var56));
        // line number 841
        var58 = phi0;
        var59 = (var58.xfB);
        var60 = (var59.q);
        var61 = phi49;
        var62 = (org$jbox2d$common$Rot.prototype.Lorg$jbox2d$common$Rot$$set$F.call(var60,var61));
        // line number 842
        var63 = phi0;
        var64 = (var63.xfA);
        var65 = (var64.q);
        var66 = phi41;
        var67 = phi0;
        var68 = (var67.xfA);
        var69 = (var68.p);
        org$jbox2d$common$Rot.$i;
        org$jbox2d$common$Rot.V$mulToOutUnsafe$Lorg$jbox2d$common$Rot$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var65,var66,var69);
        // line number 843
        var70 = phi0;
        var71 = (var70.xfA);
        var72 = (var71.p);
        var73 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$negateLocal$$.call(var72));
        var74 = phi46;
        var75 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var73,var74));
        // line number 844
        var76 = phi0;
        var77 = (var76.xfB);
        var78 = (var77.q);
        var79 = phi44;
        var80 = phi0;
        var81 = (var80.xfB);
        var82 = (var81.p);
        org$jbox2d$common$Rot.V$mulToOutUnsafe$Lorg$jbox2d$common$Rot$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var78,var79,var82);
        // line number 845
        var83 = phi0;
        var84 = (var83.xfB);
        var85 = (var84.p);
        var86 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$negateLocal$$.call(var85));
        var87 = phi48;
        var88 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var86,var87));
        // line number 847
        var89 = phi0;
        var90 = (var89.psolver);
        // line number 848
        var91 = phi36;
        var92 = phi0;
        var93 = (var92.xfA);
        var94 = phi0;
        var95 = (var94.xfB);
        var96 = (phi50) | 0;
        org$jbox2d$dynamics$contacts$PositionSolverManifold.prototype.V$initialize$Lorg$jbox2d$dynamics$contacts$ContactPositionConstraint$$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$common$Transform$$I.call(var90,var91,var93,var95,var96);
        // line number 849
        var97 = (var90.normal);
        // line number 851
        var98 = (var90.point);
        // line number 852
        var99 = (var90.separation);
        // line number 854
        var100 = phi0;
        var101 = (var100.rA);
        var102 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var101,var98));
        var103 = phi46;
        var104 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var102,var103));
        // line number 855
        var105 = phi0;
        var106 = (var105.rB);
        var107 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var106,var98));
        var108 = phi48;
        var109 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var107,var108));
        // line number 858
        var110 = phi1;
        org$jbox2d$common$MathUtils.$i;
        var111 = (org$jbox2d$common$MathUtils.F$min$F$F(var110,var99));
        // line number 861
        var112 = var99;
        var113 = (var112 + 0.005);
        var114 = (0.2 * var113);
        var115 = 0.0;
        var116 = (org$jbox2d$common$MathUtils.F$clamp$F$F$F(var114,-0.2,var115));
        // line number 866
        var117 = phi0;
        var118 = (var117.rA);
        org$jbox2d$common$Vec2.$i;
        var119 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var118,var97));
        // line number 867
        var120 = phi0;
        var121 = (var120.rB);
        var122 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var121,var97));
        // line number 868
        var123 = phi39;
        var124 = phi42;
        var125 = (var123 + var124);
        var126 = phi40;
        var127 = (var126 * var119);
        var128 = (var127 * var119);
        var129 = (var125 + var128);
        var130 = phi43;
        var131 = (var130 * var122);
        var132 = (var131 * var122);
        var133 = (var129 + var132);
        // line number 871
        var134 = (bytecoder.cmp(var133,0.0)) | 0;
        If_428_0: {
         if (var134 <= 0) {
          phi138 = var111;
          phi139 = var90;
          phi140 = var97;
          phi141 = var98;
          phi142 = var99;
          phi143 = var116;
          phi144 = var119;
          phi145 = var122;
          phi146 = var133;
          phi147 = 0.0;
          break If_428_0;
         } else {
          var135 = var116;
          var136 = (0 - var135);
          var137 = (var136 / var133);
          // Here was a goto statement
          phi138 = var111;
          phi139 = var90;
          phi140 = var97;
          phi141 = var98;
          phi142 = var99;
          phi143 = var116;
          phi144 = var119;
          phi145 = var122;
          phi146 = var133;
          phi147 = var137;
          break If_428_0;
         }
        }
        var148 = phi147;
        // line number 873
        var149 = phi0;
        var150 = (var149.P);
        var151 = phi140;
        var152 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var150,var151));
        var153 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var152,var148));
        // line number 875
        var154 = phi46;
        var155 = phi0;
        var156 = (var155.temp);
        var157 = phi0;
        var158 = (var157.P);
        var159 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var156,var158));
        var160 = phi39;
        var161 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var159,var160));
        var162 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var154,var161));
        // line number 876
        var163 = phi47;
        var164 = phi40;
        var165 = phi0;
        var166 = (var165.rA);
        var167 = phi0;
        var168 = (var167.P);
        var169 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var166,var168));
        var170 = (var164 * var169);
        var171 = (var163 - var170);
        // line number 878
        var172 = phi48;
        var173 = phi0;
        var174 = (var173.temp);
        var175 = phi0;
        var176 = (var175.P);
        var177 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var174,var176));
        var178 = phi42;
        var179 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var177,var178));
        var180 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var172,var179));
        // line number 879
        var181 = phi49;
        var182 = phi43;
        var183 = phi0;
        var184 = (var183.rB);
        var185 = phi0;
        var186 = (var185.P);
        var187 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var184,var186));
        var188 = (var182 * var187);
        var189 = (var181 + var188);
        // line number 839
        phi50 = ((phi50 + 1)) | 0;
        // Here was a goto statement
        phi1 = phi138;
        phi47 = var171;
        phi49 = var189;
        continue L1273712774;
       }
      }
     }
    }
  }

  Z$solveTOIPositionConstraints$I$I(arg0,arg1) {
    // source file is ContactSolver.java
    var var0 = 0;
    var phi1 = null;
    var phi2 = 0;
    var phi3 = 0;
    var phi4 = .0;
    var phi5 = 0;
    var var6 = 0;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = null;
    var var11 = 0;
    var var12 = null;
    var var13 = 0;
    var var14 = 0;
    var var15 = null;
    var var16 = null;
    var var17 = 0;
    var var18 = .0;
    var var19 = .0;
    var var20 = 0;
    var var21 = 0;
    var var22 = 0;
    var phi23 = null;
    var phi24 = 0;
    var phi25 = 0;
    var phi26 = null;
    var phi27 = null;
    var phi28 = 0;
    var phi29 = .0;
    var phi30 = .0;
    var var31 = null;
    var var32 = .0;
    var var33 = null;
    var var34 = .0;
    var phi35 = .0;
    var phi36 = .0;
    var var37 = .0;
    var var38 = .0;
    var var39 = 0;
    var var40 = 0;
    var var41 = 0;
    var var42 = 0;
    var phi43 = .0;
    var phi44 = .0;
    var var45 = null;
    var var46 = .0;
    var var47 = null;
    var var48 = .0;
    var phi49 = .0;
    var phi50 = .0;
    var var51 = null;
    var var52 = null;
    var var53 = 0;
    var var54 = null;
    var var55 = null;
    var var56 = null;
    var var57 = null;
    var var58 = 0;
    var var59 = null;
    var var60 = .0;
    var var61 = null;
    var var62 = null;
    var var63 = 0;
    var var64 = null;
    var var65 = null;
    var var66 = null;
    var var67 = null;
    var var68 = 0;
    var var69 = null;
    var var70 = .0;
    var var71 = 0;
    var phi72 = null;
    var phi73 = .0;
    var phi74 = null;
    var phi75 = .0;
    var phi76 = 0;
    var var77 = 0;
    var var78 = 0;
    var var79 = null;
    var var80 = null;
    var var81 = null;
    var var82 = .0;
    var var83 = null;
    var var84 = null;
    var var85 = null;
    var var86 = null;
    var var87 = .0;
    var var88 = null;
    var var89 = null;
    var var90 = null;
    var var91 = null;
    var var92 = null;
    var var93 = null;
    var var94 = null;
    var var95 = null;
    var var96 = null;
    var var97 = null;
    var var98 = null;
    var var99 = null;
    var var100 = null;
    var var101 = null;
    var var102 = null;
    var var103 = null;
    var var104 = null;
    var var105 = null;
    var var106 = null;
    var var107 = null;
    var var108 = null;
    var var109 = null;
    var var110 = null;
    var var111 = null;
    var var112 = null;
    var var113 = null;
    var var114 = null;
    var var115 = null;
    var var116 = null;
    var var117 = null;
    var var118 = null;
    var var119 = null;
    var var120 = null;
    var var121 = null;
    var var122 = 0;
    var var123 = null;
    var var124 = null;
    var var125 = .0;
    var var126 = null;
    var var127 = null;
    var var128 = null;
    var var129 = null;
    var var130 = null;
    var var131 = null;
    var var132 = null;
    var var133 = null;
    var var134 = null;
    var var135 = null;
    var var136 = .0;
    var var137 = .0;
    var var138 = .0;
    var var139 = .0;
    var var140 = .0;
    var var141 = .0;
    var var142 = .0;
    var var143 = null;
    var var144 = null;
    var var145 = .0;
    var var146 = null;
    var var147 = null;
    var var148 = .0;
    var var149 = .0;
    var var150 = .0;
    var var151 = .0;
    var var152 = .0;
    var var153 = .0;
    var var154 = .0;
    var var155 = .0;
    var var156 = .0;
    var var157 = .0;
    var var158 = .0;
    var var159 = .0;
    var var160 = 0;
    var var161 = .0;
    var var162 = .0;
    var var163 = .0;
    var phi164 = .0;
    var phi165 = null;
    var phi166 = null;
    var phi167 = null;
    var phi168 = .0;
    var phi169 = .0;
    var phi170 = .0;
    var phi171 = .0;
    var phi172 = .0;
    var phi173 = .0;
    var var174 = .0;
    var var175 = null;
    var var176 = null;
    var var177 = null;
    var var178 = null;
    var var179 = null;
    var var180 = null;
    var var181 = null;
    var var182 = null;
    var var183 = null;
    var var184 = null;
    var var185 = null;
    var var186 = .0;
    var var187 = null;
    var var188 = null;
    var var189 = .0;
    var var190 = .0;
    var var191 = null;
    var var192 = null;
    var var193 = null;
    var var194 = null;
    var var195 = .0;
    var var196 = .0;
    var var197 = .0;
    var var198 = null;
    var var199 = null;
    var var200 = null;
    var var201 = null;
    var var202 = null;
    var var203 = null;
    var var204 = .0;
    var var205 = null;
    var var206 = null;
    var var207 = .0;
    var var208 = .0;
    var var209 = null;
    var var210 = null;
    var var211 = null;
    var var212 = null;
    var var213 = .0;
    var var214 = .0;
    var var215 = .0;
    var var216 = null;
    var var217 = null;
    var var218 = 0;
    var var219 = null;
    var var220 = .0;
    var var221 = null;
    var var222 = null;
    var var223 = 0;
    var var224 = null;
    var var225 = .0;
    var var226 = .0;
    var var227 = 0;
    var var228 = 0;
    var phi229 = 0;
    var0 = (arg0) | 0;
    // line number 896
    // line number 898
    phi1 = this;
    phi2 = (var0) | 0;
    phi3 = (arg1) | 0;
    phi4 = 0.0;
    phi5 = (0) | 0;
    L1189022735: while(true) {
     var6 = (phi5) | 0;
     var7 = phi1;
     var8 = ((var7.m_count)) | 0;
     if (var6 >= var8) {
      // line number 980
      var226 = phi4;
      var227 = (bytecoder.cmp(var226,-0.0075)) | 0;
      If_702_0: {
       if (var227 < 0) {
        phi229 = (0) | 0;
        break If_702_0;
       } else {
        var228 = (1) | 0;
        // Here was a goto statement
        phi229 = (var228) | 0;
        break If_702_0;
       }
      }
      return phi229;
     } else {
      // line number 899
      var9 = phi1;
      var10 = (var9.m_positionConstraints);
      var11 = (phi5) | 0;
      var12 = (var10.data[var11]);
      // line number 901
      var13 = ((var12.indexA)) | 0;
      // line number 902
      var14 = ((var12.indexB)) | 0;
      // line number 903
      var15 = (var12.localCenterA);
      // line number 904
      var16 = (var12.localCenterB);
      // line number 905
      var17 = ((var12.pointCount)) | 0;
      // line number 907
      var18 = 0.0;
      // line number 908
      var19 = 0.0;
      // line number 909
      var20 = (phi2) | 0;
      If_79_0: {
       If_79_1: {
        if (var13 == var20) {
         phi23 = var12;
         phi24 = (var13) | 0;
         phi25 = (var14) | 0;
         phi26 = var15;
         phi27 = var16;
         phi28 = (var17) | 0;
         phi29 = var18;
         phi30 = var19;
         break If_79_1;
        } else {
         var21 = (var13) | 0;
         var22 = (phi3) | 0;
         if (var21 != var22) {
          phi23 = var12;
          phi24 = (var13) | 0;
          phi25 = (var14) | 0;
          phi26 = var15;
          phi27 = var16;
          phi28 = (var17) | 0;
          phi35 = var18;
          phi36 = var19;
          break If_79_0;
         } else {
          phi23 = var12;
          phi24 = (var13) | 0;
          phi25 = (var14) | 0;
          phi26 = var15;
          phi27 = var16;
          phi28 = (var17) | 0;
          phi29 = var18;
          phi30 = var19;
          break If_79_1;
         }
        }
       }
       // line number 910
       var31 = phi23;
       var32 = (var31.invMassA);
       // line number 911
       var33 = phi23;
       var34 = (var33.invIA);
       phi35 = var32;
       phi36 = var34;
       break If_79_0;
      }
      // line number 914
      var37 = 0.0;
      // line number 915
      var38 = 0.0;
      // line number 916
      var39 = (phi25) | 0;
      var40 = (phi2) | 0;
      If_129_0: {
       If_129_1: {
        if (var39 == var40) {
         phi43 = var37;
         phi44 = var38;
         break If_129_1;
        } else {
         var41 = (phi25) | 0;
         var42 = (phi3) | 0;
         if (var41 != var42) {
          phi49 = var37;
          phi50 = var38;
          break If_129_0;
         } else {
          phi43 = var37;
          phi44 = var38;
          break If_129_1;
         }
        }
       }
       // line number 917
       var45 = phi23;
       var46 = (var45.invMassB);
       // line number 918
       var47 = phi23;
       var48 = (var47.invIB);
       phi49 = var46;
       phi50 = var48;
       break If_129_0;
      }
      // line number 921
      var51 = phi1;
      var52 = (var51.m_positions);
      var53 = (phi24) | 0;
      var54 = (var52.data[var53]);
      var55 = (var54.c);
      // line number 922
      var56 = phi1;
      var57 = (var56.m_positions);
      var58 = (phi24) | 0;
      var59 = (var57.data[var58]);
      var60 = (var59.a);
      // line number 924
      var61 = phi1;
      var62 = (var61.m_positions);
      var63 = (phi25) | 0;
      var64 = (var62.data[var63]);
      var65 = (var64.c);
      // line number 925
      var66 = phi1;
      var67 = (var66.m_positions);
      var68 = (phi25) | 0;
      var69 = (var67.data[var68]);
      var70 = (var69.a);
      // line number 928
      var71 = (0) | 0;
      phi72 = var55;
      phi73 = var60;
      phi74 = var65;
      phi75 = var70;
      phi76 = (var71) | 0;
      L153762730: while(true) {
       var77 = (phi76) | 0;
       var78 = (phi28) | 0;
       if (var77 >= var78) {
        // line number 972
        var216 = phi1;
        var217 = (var216.m_positions);
        var218 = (phi24) | 0;
        var219 = (var217.data[var218]);
        var220 = phi73;
        var219.a = var220;
        // line number 975
        var221 = phi1;
        var222 = (var221.m_positions);
        var223 = (phi25) | 0;
        var224 = (var222.data[var223]);
        var225 = phi75;
        var224.a = var225;
        // line number 898
        phi5 = ((phi5 + 1)) | 0;
        // Here was a goto statement
        continue L1189022735;
       } else {
        // line number 929
        var79 = phi1;
        var80 = (var79.xfA);
        var81 = (var80.q);
        var82 = phi73;
        var83 = (org$jbox2d$common$Rot.prototype.Lorg$jbox2d$common$Rot$$set$F.call(var81,var82));
        // line number 930
        var84 = phi1;
        var85 = (var84.xfB);
        var86 = (var85.q);
        var87 = phi75;
        var88 = (org$jbox2d$common$Rot.prototype.Lorg$jbox2d$common$Rot$$set$F.call(var86,var87));
        // line number 931
        var89 = phi1;
        var90 = (var89.xfA);
        var91 = (var90.q);
        var92 = phi26;
        var93 = phi1;
        var94 = (var93.xfA);
        var95 = (var94.p);
        org$jbox2d$common$Rot.$i;
        org$jbox2d$common$Rot.V$mulToOutUnsafe$Lorg$jbox2d$common$Rot$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var91,var92,var95);
        // line number 932
        var96 = phi1;
        var97 = (var96.xfA);
        var98 = (var97.p);
        var99 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$negateLocal$$.call(var98));
        var100 = phi72;
        var101 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var99,var100));
        // line number 933
        var102 = phi1;
        var103 = (var102.xfB);
        var104 = (var103.q);
        var105 = phi27;
        var106 = phi1;
        var107 = (var106.xfB);
        var108 = (var107.p);
        org$jbox2d$common$Rot.V$mulToOutUnsafe$Lorg$jbox2d$common$Rot$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var104,var105,var108);
        // line number 934
        var109 = phi1;
        var110 = (var109.xfB);
        var111 = (var110.p);
        var112 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$negateLocal$$.call(var111));
        var113 = phi74;
        var114 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var112,var113));
        // line number 936
        var115 = phi1;
        var116 = (var115.psolver);
        // line number 937
        var117 = phi23;
        var118 = phi1;
        var119 = (var118.xfA);
        var120 = phi1;
        var121 = (var120.xfB);
        var122 = (phi76) | 0;
        org$jbox2d$dynamics$contacts$PositionSolverManifold.prototype.V$initialize$Lorg$jbox2d$dynamics$contacts$ContactPositionConstraint$$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$common$Transform$$I.call(var116,var117,var119,var121,var122);
        // line number 938
        var123 = (var116.normal);
        // line number 940
        var124 = (var116.point);
        // line number 941
        var125 = (var116.separation);
        // line number 943
        var126 = phi1;
        var127 = (var126.rA);
        var128 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var127,var124));
        var129 = phi72;
        var130 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var128,var129));
        // line number 944
        var131 = phi1;
        var132 = (var131.rB);
        var133 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var132,var124));
        var134 = phi74;
        var135 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var133,var134));
        // line number 947
        var136 = phi4;
        org$jbox2d$common$MathUtils.$i;
        var137 = (org$jbox2d$common$MathUtils.F$min$F$F(var136,var125));
        // line number 950
        var138 = var125;
        var139 = (var138 + 0.005);
        var140 = (0.75 * var139);
        var141 = 0.0;
        var142 = (org$jbox2d$common$MathUtils.F$clamp$F$F$F(var140,-0.2,var141));
        // line number 955
        var143 = phi1;
        var144 = (var143.rA);
        org$jbox2d$common$Vec2.$i;
        var145 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var144,var123));
        // line number 956
        var146 = phi1;
        var147 = (var146.rB);
        var148 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var147,var123));
        // line number 957
        var149 = phi35;
        var150 = phi49;
        var151 = (var149 + var150);
        var152 = phi36;
        var153 = (var152 * var145);
        var154 = (var153 * var145);
        var155 = (var151 + var154);
        var156 = phi50;
        var157 = (var156 * var148);
        var158 = (var157 * var148);
        var159 = (var155 + var158);
        // line number 960
        var160 = (bytecoder.cmp(var159,0.0)) | 0;
        If_504_0: {
         if (var160 <= 0) {
          phi164 = var137;
          phi165 = var116;
          phi166 = var123;
          phi167 = var124;
          phi168 = var125;
          phi169 = var142;
          phi170 = var145;
          phi171 = var148;
          phi172 = var159;
          phi173 = 0.0;
          break If_504_0;
         } else {
          var161 = var142;
          var162 = (0 - var161);
          var163 = (var162 / var159);
          // Here was a goto statement
          phi164 = var137;
          phi165 = var116;
          phi166 = var123;
          phi167 = var124;
          phi168 = var125;
          phi169 = var142;
          phi170 = var145;
          phi171 = var148;
          phi172 = var159;
          phi173 = var163;
          break If_504_0;
         }
        }
        var174 = phi173;
        // line number 962
        var175 = phi1;
        var176 = (var175.P);
        var177 = phi166;
        var178 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var176,var177));
        var179 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var178,var174));
        // line number 964
        var180 = phi72;
        var181 = phi1;
        var182 = (var181.temp);
        var183 = phi1;
        var184 = (var183.P);
        var185 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var182,var184));
        var186 = phi35;
        var187 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var185,var186));
        var188 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var180,var187));
        // line number 965
        var189 = phi73;
        var190 = phi36;
        var191 = phi1;
        var192 = (var191.rA);
        var193 = phi1;
        var194 = (var193.P);
        var195 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var192,var194));
        var196 = (var190 * var195);
        var197 = (var189 - var196);
        // line number 967
        var198 = phi74;
        var199 = phi1;
        var200 = (var199.temp);
        var201 = phi1;
        var202 = (var201.P);
        var203 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var200,var202));
        var204 = phi49;
        var205 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var203,var204));
        var206 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var198,var205));
        // line number 968
        var207 = phi75;
        var208 = phi50;
        var209 = phi1;
        var210 = (var209.rB);
        var211 = phi1;
        var212 = (var211.P);
        var213 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var210,var212));
        var214 = (var208 * var213);
        var215 = (var207 + var214);
        // line number 928
        phi76 = ((phi76 + 1)) | 0;
        // Here was a goto statement
        phi4 = phi164;
        phi73 = var197;
        phi75 = var215;
        continue L153762730;
       }
      }
     }
    }
  }
}


class java$lang$Iterable extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Iterable,[java$lang$Iterable,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class org$jbox2d$dynamics$joints$Joint$1 extends java$lang$Object {
  nativeObject = null;

  static $SwitchMap$org$jbox2d$dynamics$joints$JointType = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$dynamics$joints$Joint$1,[org$jbox2d$dynamics$joints$Joint$1,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is Joint.java
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var phi3 = null;
    var phi4 = null;
    var phi5 = null;
    var phi6 = null;
    var phi7 = null;
    var phi8 = null;
    var phi9 = null;
    var phi10 = null;
    var phi11 = null;
    var phi12 = null;
    var phi13 = null;
    var phi14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = 0;
    var var18 = null;
    var var19 = null;
    var var20 = 0;
    var var21 = null;
    var var22 = null;
    var var23 = 0;
    var var24 = null;
    var var25 = null;
    var var26 = 0;
    var var27 = null;
    var var28 = null;
    var var29 = 0;
    var var30 = null;
    var var31 = null;
    var var32 = 0;
    var var33 = null;
    var var34 = null;
    var var35 = 0;
    var var36 = null;
    var var37 = null;
    var var38 = 0;
    var var39 = null;
    var var40 = null;
    var var41 = 0;
    var var42 = null;
    var var43 = null;
    var var44 = 0;
    var var45 = null;
    var var46 = null;
    var var47 = 0;
    var var48 = null;
    var var49 = null;
    var var50 = 0;
    // line number 43
    org$jbox2d$dynamics$joints$JointType.$i;
    var0 = (org$jbox2d$dynamics$joints$JointType.$Lorg$jbox2d$dynamics$joints$JointType$$values$$());
    var1 = (var0.data.length) | 0;
    var2 = bytecoder.newarray((var1),0);
    org$jbox2d$dynamics$joints$Joint$1.$i;
    org$jbox2d$dynamics$joints$Joint$1.$SwitchMap$org$jbox2d$dynamics$joints$JointType = var2;
    TryCatch_17_0: {
     TryCatch_17_1: {
      try {
       var48 = (org$jbox2d$dynamics$joints$Joint$1.$SwitchMap$org$jbox2d$dynamics$joints$JointType);
       var49 = (org$jbox2d$dynamics$joints$JointType.MOUSE);
       var50 = ((var49.I$ordinal$$())) | 0;
       var48.data[var50] = 1;
       break TryCatch_17_1;
      } catch (__ex) {
       if (__ex instanceof java$lang$NoSuchFieldError) {
        phi3 = __ex;
        break TryCatch_17_0;
       }
       throw __ex;
      }
     }
     // Here was a goto statement
     break TryCatch_17_0;
    }
    TryCatch_22_0: {
     TryCatch_22_1: {
      try {
       var45 = (org$jbox2d$dynamics$joints$Joint$1.$SwitchMap$org$jbox2d$dynamics$joints$JointType);
       var46 = (org$jbox2d$dynamics$joints$JointType.DISTANCE);
       var47 = ((var46.I$ordinal$$())) | 0;
       var45.data[var47] = 2;
       break TryCatch_22_1;
      } catch (__ex) {
       if (__ex instanceof java$lang$NoSuchFieldError) {
        phi4 = __ex;
        break TryCatch_22_0;
       }
       throw __ex;
      }
     }
     // Here was a goto statement
     phi4 = phi3;
     break TryCatch_22_0;
    }
    TryCatch_27_0: {
     TryCatch_27_1: {
      try {
       var42 = (org$jbox2d$dynamics$joints$Joint$1.$SwitchMap$org$jbox2d$dynamics$joints$JointType);
       var43 = (org$jbox2d$dynamics$joints$JointType.PRISMATIC);
       var44 = ((var43.I$ordinal$$())) | 0;
       var42.data[var44] = 3;
       break TryCatch_27_1;
      } catch (__ex) {
       if (__ex instanceof java$lang$NoSuchFieldError) {
        phi5 = __ex;
        break TryCatch_27_0;
       }
       throw __ex;
      }
     }
     // Here was a goto statement
     phi5 = phi4;
     break TryCatch_27_0;
    }
    TryCatch_32_0: {
     TryCatch_32_1: {
      try {
       var39 = (org$jbox2d$dynamics$joints$Joint$1.$SwitchMap$org$jbox2d$dynamics$joints$JointType);
       var40 = (org$jbox2d$dynamics$joints$JointType.REVOLUTE);
       var41 = ((var40.I$ordinal$$())) | 0;
       var39.data[var41] = 4;
       break TryCatch_32_1;
      } catch (__ex) {
       if (__ex instanceof java$lang$NoSuchFieldError) {
        phi6 = __ex;
        break TryCatch_32_0;
       }
       throw __ex;
      }
     }
     // Here was a goto statement
     phi6 = phi5;
     break TryCatch_32_0;
    }
    TryCatch_37_0: {
     TryCatch_37_1: {
      try {
       var36 = (org$jbox2d$dynamics$joints$Joint$1.$SwitchMap$org$jbox2d$dynamics$joints$JointType);
       var37 = (org$jbox2d$dynamics$joints$JointType.WELD);
       var38 = ((var37.I$ordinal$$())) | 0;
       var36.data[var38] = 5;
       break TryCatch_37_1;
      } catch (__ex) {
       if (__ex instanceof java$lang$NoSuchFieldError) {
        phi7 = __ex;
        break TryCatch_37_0;
       }
       throw __ex;
      }
     }
     // Here was a goto statement
     phi7 = phi6;
     break TryCatch_37_0;
    }
    TryCatch_42_0: {
     TryCatch_42_1: {
      try {
       var33 = (org$jbox2d$dynamics$joints$Joint$1.$SwitchMap$org$jbox2d$dynamics$joints$JointType);
       var34 = (org$jbox2d$dynamics$joints$JointType.FRICTION);
       var35 = ((var34.I$ordinal$$())) | 0;
       var33.data[var35] = 6;
       break TryCatch_42_1;
      } catch (__ex) {
       if (__ex instanceof java$lang$NoSuchFieldError) {
        phi8 = __ex;
        break TryCatch_42_0;
       }
       throw __ex;
      }
     }
     // Here was a goto statement
     phi8 = phi7;
     break TryCatch_42_0;
    }
    TryCatch_47_0: {
     TryCatch_47_1: {
      try {
       var30 = (org$jbox2d$dynamics$joints$Joint$1.$SwitchMap$org$jbox2d$dynamics$joints$JointType);
       var31 = (org$jbox2d$dynamics$joints$JointType.WHEEL);
       var32 = ((var31.I$ordinal$$())) | 0;
       var30.data[var32] = 7;
       break TryCatch_47_1;
      } catch (__ex) {
       if (__ex instanceof java$lang$NoSuchFieldError) {
        phi9 = __ex;
        break TryCatch_47_0;
       }
       throw __ex;
      }
     }
     // Here was a goto statement
     phi9 = phi8;
     break TryCatch_47_0;
    }
    TryCatch_52_0: {
     TryCatch_52_1: {
      try {
       var27 = (org$jbox2d$dynamics$joints$Joint$1.$SwitchMap$org$jbox2d$dynamics$joints$JointType);
       var28 = (org$jbox2d$dynamics$joints$JointType.GEAR);
       var29 = ((var28.I$ordinal$$())) | 0;
       var27.data[var29] = 8;
       break TryCatch_52_1;
      } catch (__ex) {
       if (__ex instanceof java$lang$NoSuchFieldError) {
        phi10 = __ex;
        break TryCatch_52_0;
       }
       throw __ex;
      }
     }
     // Here was a goto statement
     phi10 = phi9;
     break TryCatch_52_0;
    }
    TryCatch_57_0: {
     TryCatch_57_1: {
      try {
       var24 = (org$jbox2d$dynamics$joints$Joint$1.$SwitchMap$org$jbox2d$dynamics$joints$JointType);
       var25 = (org$jbox2d$dynamics$joints$JointType.PULLEY);
       var26 = ((var25.I$ordinal$$())) | 0;
       var24.data[var26] = 9;
       break TryCatch_57_1;
      } catch (__ex) {
       if (__ex instanceof java$lang$NoSuchFieldError) {
        phi11 = __ex;
        break TryCatch_57_0;
       }
       throw __ex;
      }
     }
     // Here was a goto statement
     phi11 = phi10;
     break TryCatch_57_0;
    }
    TryCatch_62_0: {
     TryCatch_62_1: {
      try {
       var21 = (org$jbox2d$dynamics$joints$Joint$1.$SwitchMap$org$jbox2d$dynamics$joints$JointType);
       var22 = (org$jbox2d$dynamics$joints$JointType.CONSTANT_VOLUME);
       var23 = ((var22.I$ordinal$$())) | 0;
       var21.data[var23] = 10;
       break TryCatch_62_1;
      } catch (__ex) {
       if (__ex instanceof java$lang$NoSuchFieldError) {
        phi12 = __ex;
        break TryCatch_62_0;
       }
       throw __ex;
      }
     }
     // Here was a goto statement
     phi12 = phi11;
     break TryCatch_62_0;
    }
    TryCatch_67_0: {
     TryCatch_67_1: {
      try {
       var18 = (org$jbox2d$dynamics$joints$Joint$1.$SwitchMap$org$jbox2d$dynamics$joints$JointType);
       var19 = (org$jbox2d$dynamics$joints$JointType.ROPE);
       var20 = ((var19.I$ordinal$$())) | 0;
       var18.data[var20] = 11;
       break TryCatch_67_1;
      } catch (__ex) {
       if (__ex instanceof java$lang$NoSuchFieldError) {
        phi13 = __ex;
        break TryCatch_67_0;
       }
       throw __ex;
      }
     }
     // Here was a goto statement
     phi13 = phi12;
     break TryCatch_67_0;
    }
    TryCatch_72_0: {
     TryCatch_72_1: {
      try {
       var15 = (org$jbox2d$dynamics$joints$Joint$1.$SwitchMap$org$jbox2d$dynamics$joints$JointType);
       var16 = (org$jbox2d$dynamics$joints$JointType.UNKNOWN);
       var17 = ((var16.I$ordinal$$())) | 0;
       var15.data[var17] = 12;
       break TryCatch_72_1;
      } catch (__ex) {
       if (__ex instanceof java$lang$NoSuchFieldError) {
        phi14 = __ex;
        break TryCatch_72_0;
       }
       throw __ex;
      }
     }
     // Here was a goto statement
     phi14 = phi13;
     break TryCatch_72_0;
    }
    return;
  }
}


class org$jbox2d$dynamics$contacts$Contact extends java$lang$Object {
  nativeObject = null;

  m_flags = 0;
  m_fixtureA = null;
  m_fixtureB = null;
  m_indexA = 0;
  m_indexB = 0;
  m_next = null;
  m_prev = null;
  m_nodeA = null;
  m_nodeB = null;
  m_manifold = null;
  oldManifold = null;
  pool = null;
  m_friction = 0.0;
  m_restitution = 0.0;
  m_tangentSpeed = 0.0;
  m_toiCount = 0.0;
  m_toi = 0.0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$dynamics$contacts$Contact,[org$jbox2d$dynamics$contacts$Contact,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.V$evaluate$Lorg$jbox2d$collision$Manifold$$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$common$Transform$ = impl;
  }

  V$flagForFiltering$$() {
    // source file is Contact.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var0 = this;
    // line number 256
    var1 = var0;
    var2 = ((var1.m_flags)) | 0;
    var3 = ((var2 | 8)) | 0;
    var0.m_flags = var3;
    // line number 257
    return;
  }

  Lorg$jbox2d$dynamics$Fixture$$getFixtureA$$() {
    // source file is Contact.java
    var var0 = null;
    // line number 198
    var0 = (this.m_fixtureA);
    return var0;
  }

  Lorg$jbox2d$dynamics$Fixture$$getFixtureB$$() {
    // source file is Contact.java
    var var0 = null;
    // line number 211
    var0 = (this.m_fixtureB);
    return var0;
  }

  I$getChildIndexA$$() {
    // source file is Contact.java
    var var0 = 0;
    // line number 202
    var0 = ((this.m_indexA)) | 0;
    return var0;
  }

  I$getChildIndexB$$() {
    // source file is Contact.java
    var var0 = 0;
    // line number 215
    var0 = ((this.m_indexB)) | 0;
    return var0;
  }

  Lorg$jbox2d$dynamics$contacts$Contact$$getNext$$() {
    // source file is Contact.java
    var var0 = null;
    // line number 189
    var0 = (this.m_next);
    return var0;
  }

  Z$isTouching$$() {
    // source file is Contact.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var phi3 = null;
    var phi4 = 0;
    // line number 157
    var0 = ((this.m_flags)) | 0;
    var1 = ((var0 & 2)) | 0;
    If_12_0: {
     if (var1 != 2) {
      phi3 = this;
      phi4 = (0) | 0;
      break If_12_0;
     } else {
      var2 = (1) | 0;
      // Here was a goto statement
      phi3 = this;
      phi4 = (var2) | 0;
      break If_12_0;
     }
    }
    return phi4;
  }

  V$update$Lorg$jbox2d$callbacks$ContactListener$(arg0) {
    // source file is Contact.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var phi9 = null;
    var phi10 = null;
    var phi11 = 0;
    var phi12 = 0;
    var var13 = 0;
    var var14 = null;
    var var15 = null;
    var var16 = 0;
    var var17 = null;
    var var18 = null;
    var var19 = 0;
    var var20 = 0;
    var phi21 = 0;
    var phi22 = 0;
    var phi23 = 0;
    var phi24 = 0;
    var var25 = 0;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = null;
    var var37 = null;
    var var38 = null;
    var var39 = null;
    var var40 = null;
    var var41 = null;
    var var42 = null;
    var var43 = null;
    var var44 = 0;
    var var45 = null;
    var var46 = 0;
    var var47 = null;
    var var48 = 0;
    var var49 = null;
    var var50 = null;
    var phi51 = 0;
    var phi52 = 0;
    var phi53 = null;
    var phi54 = null;
    var phi55 = null;
    var phi56 = null;
    var phi57 = null;
    var var58 = 0;
    var var59 = null;
    var var60 = 0;
    var var61 = 0;
    var var62 = null;
    var var63 = 0;
    var var64 = 0;
    var var65 = null;
    var var66 = null;
    var var67 = 0;
    var var68 = 0;
    var var69 = null;
    var var70 = null;
    var var71 = 0;
    var var72 = 0;
    var var73 = null;
    var var74 = null;
    var var75 = null;
    var var76 = null;
    var var77 = null;
    var var78 = 0;
    var var79 = 0;
    var var80 = null;
    var var81 = null;
    var var82 = null;
    var var83 = null;
    var var84 = null;
    var var85 = null;
    var var86 = 0;
    var var87 = 0;
    var phi88 = 0;
    var phi89 = null;
    var phi90 = null;
    var phi91 = null;
    var phi92 = null;
    var phi93 = 0;
    var var94 = 0;
    var var95 = 0;
    var phi96 = 0;
    var phi97 = 0;
    var var98 = 0;
    var var99 = null;
    var var100 = null;
    var var101 = 0;
    var var102 = null;
    var var103 = null;
    var var104 = null;
    var var105 = 0;
    var var106 = null;
    var var107 = null;
    var var108 = 0;
    var phi109 = null;
    var phi110 = null;
    var phi111 = 0;
    var var112 = 0;
    var var113 = null;
    var var114 = null;
    var var115 = 0;
    var var116 = null;
    var var117 = null;
    var var118 = null;
    var var119 = 0;
    var var120 = null;
    var var121 = null;
    var var122 = null;
    var var123 = 0;
    var var124 = null;
    var var125 = .0;
    var var126 = null;
    var var127 = .0;
    var var128 = 0;
    var var129 = 0;
    var var130 = null;
    var var131 = null;
    var0 = arg0;
    // line number 264
    var1 = (this.oldManifold);
    var2 = (this.m_manifold);
    org$jbox2d$collision$Manifold.prototype.V$set$Lorg$jbox2d$collision$Manifold$.call(var1,var2);
    // line number 267
    var3 = this;
    var4 = ((var3.m_flags)) | 0;
    var5 = ((var4 | 4)) | 0;
    var3.m_flags = var5;
    // line number 269
    // line number 270
    var6 = ((this.m_flags)) | 0;
    var7 = ((var6 & 2)) | 0;
    If_39_0: {
     if (var7 != 2) {
      phi9 = this;
      phi10 = var0;
      phi11 = (0) | 0;
      phi12 = (0) | 0;
      break If_39_0;
     } else {
      var8 = (1) | 0;
      // Here was a goto statement
      phi9 = this;
      phi10 = var0;
      phi11 = (0) | 0;
      phi12 = (var8) | 0;
      break If_39_0;
     }
    }
    var13 = (phi12) | 0;
    // line number 272
    var14 = phi9;
    var15 = (var14.m_fixtureA);
    var16 = (org$jbox2d$dynamics$Fixture.prototype.Z$isSensor$$.call(var15));
    // line number 273
    var17 = phi9;
    var18 = (var17.m_fixtureB);
    var19 = (org$jbox2d$dynamics$Fixture.prototype.Z$isSensor$$.call(var18));
    // line number 274
    If_75_0: {
     If_75_1: {
      if (var16 != 0) {
       phi21 = (var13) | 0;
       phi22 = var16;
       phi23 = var19;
       break If_75_1;
      } else {
       var20 = var19;
       if (var20 == 0) {
        phi21 = (var13) | 0;
        phi22 = var16;
        phi23 = var19;
        phi24 = (0) | 0;
        break If_75_0;
       } else {
        phi21 = (var13) | 0;
        phi22 = var16;
        phi23 = var19;
        break If_75_1;
       }
      }
     }
     // Here was a goto statement
     phi24 = (1) | 0;
     break If_75_0;
    }
    var25 = (phi24) | 0;
    // line number 276
    var26 = phi9;
    var27 = (var26.m_fixtureA);
    var28 = (org$jbox2d$dynamics$Fixture.prototype.Lorg$jbox2d$dynamics$Body$$getBody$$.call(var27));
    // line number 277
    var29 = phi9;
    var30 = (var29.m_fixtureB);
    var31 = (org$jbox2d$dynamics$Fixture.prototype.Lorg$jbox2d$dynamics$Body$$getBody$$.call(var30));
    // line number 278
    var32 = (org$jbox2d$dynamics$Body.prototype.Lorg$jbox2d$common$Transform$$getTransform$$.call(var28));
    // line number 279
    var33 = (org$jbox2d$dynamics$Body.prototype.Lorg$jbox2d$common$Transform$$getTransform$$.call(var31));
    // line number 283
    If_127_0: {
     if (var25 == 0) {
      // line number 291
      var80 = phi9;
      var81 = phi9;
      var82 = (var81.m_manifold);
      var83 = var33;
      var80.V$evaluate$Lorg$jbox2d$collision$Manifold$$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$common$Transform$(var82,var32,var83);
      // line number 292
      var84 = phi9;
      var85 = (var84.m_manifold);
      var86 = ((var85.pointCount)) | 0;
      If_330_0: {
       if (var86 <= 0) {
        phi88 = (var25) | 0;
        phi89 = var28;
        phi90 = var31;
        phi91 = var32;
        phi92 = var33;
        phi93 = (0) | 0;
        break If_330_0;
       } else {
        var87 = (1) | 0;
        // Here was a goto statement
        phi88 = (var25) | 0;
        phi89 = var28;
        phi90 = var31;
        phi91 = var32;
        phi92 = var33;
        phi93 = (var87) | 0;
        break If_330_0;
       }
      }
      var94 = (phi93) | 0;
      // line number 296
      var95 = (0) | 0;
      phi96 = (var94) | 0;
      phi97 = (var95) | 0;
      L541318531: while(true) {
       var98 = (phi97) | 0;
       var99 = phi9;
       var100 = (var99.m_manifold);
       var101 = ((var100.pointCount)) | 0;
       if (var98 >= var101) {
        // line number 313
        var128 = (phi96) | 0;
        var129 = (phi21) | 0;
        if (var128 == var129) {
         phi51 = phi96;
         phi52 = (phi88) | 0;
         phi53 = phi89;
         phi54 = phi90;
         phi55 = phi91;
         phi56 = phi92;
         phi57 = phi97;
         break If_127_0;
        } else {
         // line number 314
         var130 = phi89;
         org$jbox2d$dynamics$Body.prototype.V$setAwake$Z.call(var130,1);
         // line number 315
         var131 = phi90;
         org$jbox2d$dynamics$Body.prototype.V$setAwake$Z.call(var131,1);
         phi51 = phi96;
         phi52 = (phi88) | 0;
         phi53 = phi89;
         phi54 = phi90;
         phi55 = phi91;
         phi56 = phi92;
         phi57 = phi97;
         break If_127_0;
        }
       } else {
        // line number 297
        var102 = phi9;
        var103 = (var102.m_manifold);
        var104 = (var103.points);
        var105 = (phi97) | 0;
        var106 = (var104.data[var105]);
        // line number 298
        var106.normalImpulse = 0.0;
        // line number 299
        var106.tangentImpulse = 0.0;
        // line number 300
        var107 = (var106.id);
        // line number 302
        var108 = (0) | 0;
        phi109 = var106;
        phi110 = var107;
        phi111 = (var108) | 0;
        L1211232375: while(true) {
         var112 = (phi111) | 0;
         var113 = phi9;
         var114 = (var113.oldManifold);
         var115 = ((var114.pointCount)) | 0;
         If_416_0: {
          if (var112 >= var115) {
           break If_416_0;
          } else {
           // line number 303
           var116 = phi9;
           var117 = (var116.oldManifold);
           var118 = (var117.points);
           var119 = (phi111) | 0;
           var120 = (var118.data[var119]);
           // line number 305
           var121 = (var120.id);
           var122 = phi110;
           var123 = (org$jbox2d$collision$ContactID.prototype.Z$isEqual$Lorg$jbox2d$collision$ContactID$.call(var121,var122));
           if (var123 == 0) {
            // line number 302
            phi111 = ((phi111 + 1)) | 0;
            // Here was a goto statement
            continue L1211232375;
           } else {
            // line number 306
            var124 = phi109;
            var125 = (var120.normalImpulse);
            var124.normalImpulse = var125;
            // line number 307
            var126 = phi109;
            var127 = (var120.tangentImpulse);
            var126.tangentImpulse = var127;
            // line number 308
            // Here was a goto statement
            break If_416_0;
           }
          }
         }
         // line number 296
         phi97 = ((phi97 + 1)) | 0;
         // Here was a goto statement
         continue L541318531;
        }
       }
      }
     } else {
      // line number 284
      var34 = phi9;
      var35 = (var34.m_fixtureA);
      var36 = (org$jbox2d$dynamics$Fixture.prototype.Lorg$jbox2d$collision$shapes$Shape$$getShape$$.call(var35));
      // line number 285
      var37 = phi9;
      var38 = (var37.m_fixtureB);
      var39 = (org$jbox2d$dynamics$Fixture.prototype.Lorg$jbox2d$collision$shapes$Shape$$getShape$$.call(var38));
      // line number 286
      var40 = phi9;
      var41 = (var40.pool);
      var42 = (var41.Lorg$jbox2d$collision$Collision$$getCollision$$());
      var43 = phi9;
      var44 = ((var43.m_indexA)) | 0;
      var45 = phi9;
      var46 = ((var45.m_indexB)) | 0;
      var47 = var33;
      var48 = (org$jbox2d$collision$Collision.prototype.Z$testOverlap$Lorg$jbox2d$collision$shapes$Shape$$I$Lorg$jbox2d$collision$shapes$Shape$$I$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$common$Transform$.call(var42,var36,var44,var39,var46,var32,var47));
      // line number 289
      var49 = phi9;
      var50 = (var49.m_manifold);
      var50.pointCount = 0;
      // line number 290
      // Here was a goto statement
      phi51 = var48;
      phi52 = (var25) | 0;
      phi53 = var28;
      phi54 = var31;
      phi55 = var32;
      phi56 = var33;
      phi57 = var36;
      break If_127_0;
     }
    }
    // line number 319
    var58 = phi51;
    If_199_0: {
     if (var58 == 0) {
      // line number 322
      var77 = phi9;
      var78 = ((var77.m_flags)) | 0;
      var79 = ((var78 & -3)) | 0;
      var77.m_flags = var79;
      break If_199_0;
     } else {
      // line number 320
      var59 = phi9;
      var60 = ((var59.m_flags)) | 0;
      var61 = ((var60 | 2)) | 0;
      var59.m_flags = var61;
      // Here was a goto statement
      break If_199_0;
     }
    }
    // line number 325
    var62 = phi10;
    if (var62 != null) {
     // line number 329
     var63 = (phi21) | 0;
     If_230_0: {
      if (var63 != 0) {
       break If_230_0;
      } else {
       var64 = phi51;
       if (var64 != 1) {
        break If_230_0;
       } else {
        // line number 330
        var65 = phi10;
        var66 = phi9;
        var65.V$beginContact$Lorg$jbox2d$dynamics$contacts$Contact$(var66);
        break If_230_0;
       }
      }
     }
     // line number 333
     var67 = (phi21) | 0;
     If_251_0: {
      if (var67 != 1) {
       break If_251_0;
      } else {
       var68 = phi51;
       if (var68 != 0) {
        break If_251_0;
       } else {
        // line number 334
        var69 = phi10;
        var70 = phi9;
        var69.V$endContact$Lorg$jbox2d$dynamics$contacts$Contact$(var70);
        break If_251_0;
       }
      }
     }
     // line number 337
     var71 = (phi52) | 0;
     If_270_0: {
      if (var71 != 0) {
       break If_270_0;
      } else {
       var72 = phi51;
       if (var72 == 0) {
        break If_270_0;
       } else {
        // line number 338
        var73 = phi10;
        var74 = phi9;
        var75 = phi9;
        var76 = (var75.oldManifold);
        var73.V$preSolve$Lorg$jbox2d$dynamics$contacts$Contact$$Lorg$jbox2d$collision$Manifold$(var74,var76);
        break If_270_0;
       }
      }
     }
     // line number 340
     return;
    } else {
     // line number 326
     return;
    }
  }

  Z$isEnabled$$() {
    // source file is Contact.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var phi3 = null;
    var phi4 = 0;
    // line number 180
    var0 = ((this.m_flags)) | 0;
    var1 = ((var0 & 4)) | 0;
    If_12_0: {
     if (var1 != 4) {
      phi3 = this;
      phi4 = (0) | 0;
      break If_12_0;
     } else {
      var2 = (1) | 0;
      // Here was a goto statement
      phi3 = this;
      phi4 = (var2) | 0;
      break If_12_0;
     }
    }
    return phi4;
  }

  Lorg$jbox2d$collision$Manifold$$getManifold$$() {
    // source file is Contact.java
    var var0 = null;
    // line number 135
    var0 = (this.m_manifold);
    return var0;
  }

  V$setEnabled$Z(arg0) {
    // source file is Contact.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var phi4 = null;
    var phi5 = 0;
    var var6 = null;
    var var7 = 0;
    var var8 = 0;
    var0 = arg0;
    // line number 167
    If_7_0: {
     if (var0 == 0) {
      // line number 170
      var6 = this;
      var7 = ((var6.m_flags)) | 0;
      var8 = ((var7 & -5)) | 0;
      var6.m_flags = var8;
      phi4 = this;
      phi5 = var0;
      break If_7_0;
     } else {
      // line number 168
      var1 = this;
      var2 = ((var1.m_flags)) | 0;
      var3 = ((var2 | 4)) | 0;
      var1.m_flags = var3;
      // Here was a goto statement
      phi4 = this;
      phi5 = var0;
      break If_7_0;
     }
    }
    // line number 172
    return;
  }

  V$$init$$Lorg$jbox2d$pooling$IWorldPool$(arg0) {
    // source file is Contact.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var0 = arg0;
    // line number 90
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 69
    var1 = this;
    var1.m_nodeA = null;
    // line number 70
    var2 = this;
    var2.m_nodeB = null;
    // line number 260
    var3 = this;
    var4 = new org$jbox2d$collision$Manifold();
    org$jbox2d$collision$Manifold.prototype.V$$init$$$.call(var4);
    var3.oldManifold = var4;
    // line number 91
    var5 = this;
    var5.m_fixtureA = null;
    // line number 92
    var6 = this;
    var6.m_fixtureB = null;
    // line number 93
    var7 = this;
    var8 = new org$jbox2d$dynamics$contacts$ContactEdge();
    org$jbox2d$dynamics$contacts$ContactEdge.prototype.V$$init$$$.call(var8);
    var7.m_nodeA = var8;
    // line number 94
    var9 = this;
    var10 = new org$jbox2d$dynamics$contacts$ContactEdge();
    org$jbox2d$dynamics$contacts$ContactEdge.prototype.V$$init$$$.call(var10);
    var9.m_nodeB = var10;
    // line number 95
    var11 = this;
    var12 = new org$jbox2d$collision$Manifold();
    org$jbox2d$collision$Manifold.prototype.V$$init$$$.call(var12);
    var11.m_manifold = var12;
    // line number 96
    var13 = this;
    var13.pool = var0;
    // line number 97
    return;
  }

  V$init$Lorg$jbox2d$dynamics$Fixture$$I$Lorg$jbox2d$dynamics$Fixture$$I(arg0,arg1,arg2,arg3) {
    // source file is Contact.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = .0;
    var var18 = .0;
    var var19 = .0;
    var var20 = .0;
    var var21 = .0;
    var var22 = .0;
    var0 = this;
    var1 = (arg1) | 0;
    var2 = (arg3) | 0;
    // line number 101
    var3 = (0) | 0;
    var0.m_flags = var3;
    // line number 103
    var4 = arg0;
    var0.m_fixtureA = var4;
    // line number 104
    var5 = arg2;
    var0.m_fixtureB = var5;
    // line number 106
    var6 = (var1) | 0;
    var0.m_indexA = var6;
    // line number 107
    var7 = (var2) | 0;
    var0.m_indexB = var7;
    // line number 109
    var8 = (var0.m_manifold);
    var8.pointCount = 0;
    // line number 111
    var0.m_prev = null;
    // line number 112
    var0.m_next = null;
    // line number 114
    var9 = (var0.m_nodeA);
    var9.contact = null;
    // line number 115
    var10 = (var0.m_nodeA);
    var10.prev = null;
    // line number 116
    var11 = (var0.m_nodeA);
    var11.next = null;
    // line number 117
    var12 = (var0.m_nodeA);
    var12.other = null;
    // line number 119
    var13 = (var0.m_nodeB);
    var13.contact = null;
    // line number 120
    var14 = (var0.m_nodeB);
    var14.prev = null;
    // line number 121
    var15 = (var0.m_nodeB);
    var15.next = null;
    // line number 122
    var16 = (var0.m_nodeB);
    var16.other = null;
    // line number 124
    var0.m_toiCount = 0.0;
    // line number 125
    var17 = (arg0.m_friction);
    var18 = (arg2.m_friction);
    var19 = (org$jbox2d$dynamics$contacts$Contact.F$mixFriction$F$F(var17,var18));
    var0.m_friction = var19;
    // line number 126
    var20 = (arg0.m_restitution);
    var21 = (arg2.m_restitution);
    var22 = (org$jbox2d$dynamics$contacts$Contact.F$mixRestitution$F$F(var20,var21));
    var0.m_restitution = var22;
    // line number 128
    var0.m_tangentSpeed = 0.0;
    // line number 129
    return;
  }

  static F$mixFriction$F$F(arg0,arg1) {
    // source file is Contact.java
    var var0 = .0;
    var var1 = .0;
    var var2 = .0;
    var var3 = .0;
    var0 = arg1;
    // line number 351
    var1 = var0;
    var2 = (arg0 * var1);
    org$jbox2d$common$MathUtils.$i;
    var3 = (org$jbox2d$common$MathUtils.F$sqrt$F(var2));
    return var3;
  }

  static F$mixRestitution$F$F(arg0,arg1) {
    // source file is Contact.java
    var var0 = .0;
    var var1 = .0;
    var var2 = 0;
    var var3 = .0;
    var phi4 = .0;
    var phi5 = .0;
    var phi6 = .0;
    var0 = arg1;
    // line number 363
    var1 = var0;
    var2 = (bytecoder.cmp(arg0,var1)) | 0;
    If_12_0: {
     if (var2 <= 0) {
      phi4 = arg0;
      phi5 = var0;
      phi6 = var0;
      break If_12_0;
     } else {
      var3 = arg0;
      // Here was a goto statement
      phi4 = arg0;
      phi5 = var0;
      phi6 = var3;
      break If_12_0;
     }
    }
    return phi6;
  }
}


class java$nio$charset$CharsetDecoder extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;
  static stateNames = null;
  malformedInputAction = null;
  unmappableCharacterAction = null;
  maxCharsPerByte = 0.0;
  state = 0;
  replacement = null;
  charset = null;
  averageCharsPerByte = 0.0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$nio$charset$CharsetDecoder,[java$nio$charset$CharsetDecoder,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
    this.Ljava$nio$charset$CoderResult$$decodeLoop$Ljava$nio$ByteBuffer$$Ljava$nio$CharBuffer$ = impl;
  }

  static V$$clinit$$$() {
    // source file is CharsetDecoder.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    // line number 137
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(java$nio$charset$CharsetDecoder.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    java$nio$charset$CharsetDecoder.$i;
    java$nio$charset$CharsetDecoder.$assertionsDisabled = phi2;
    // line number 158
    var3 = bytecoder.newarray((4),null);
    var4 = (0) | 0;
    var3.data[var4] = bytecoder.stringconstants[19];
    var5 = (1) | 0;
    var3.data[var5] = bytecoder.stringconstants[20];
    var6 = (2) | 0;
    var3.data[var6] = bytecoder.stringconstants[21];
    var7 = (3) | 0;
    var3.data[var7] = bytecoder.stringconstants[22];
    java$nio$charset$CharsetDecoder.stateNames = var3;
    return;
  }

  Ljava$nio$charset$CharsetDecoder$$onMalformedInput$Ljava$nio$charset$CodingErrorAction$(arg0) {
    // source file is CharsetDecoder.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var0 = arg0;
    // line number 381
    if (var0 != null) {
     // line number 383
     var3 = this;
     var3.malformedInputAction = var0;
     // line number 384
     var4 = var0;
     java$nio$charset$CharsetDecoder.prototype.V$implOnMalformedInput$Ljava$nio$charset$CodingErrorAction$.call(this,var4);
     // line number 385
     return this;
    } else {
     // line number 382
     var1 = new java$lang$IllegalArgumentException();
     var2 = bytecoder.stringconstants[26];
     java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var1,var2);
     throw bytecoder.registerStack(var1, new Error().stack);
    }
  }

  V$implOnMalformedInput$Ljava$nio$charset$CodingErrorAction$(arg0) {
    // source file is CharsetDecoder.java
    var var0 = null;
    var0 = arg0;
    // line number 397
    return;
  }

  Ljava$nio$charset$CharsetDecoder$$onUnmappableCharacter$Ljava$nio$charset$CodingErrorAction$(arg0) {
    // source file is CharsetDecoder.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var0 = arg0;
    // line number 425
    if (var0 != null) {
     // line number 427
     var3 = this;
     var3.unmappableCharacterAction = var0;
     // line number 428
     var4 = var0;
     java$nio$charset$CharsetDecoder.prototype.V$implOnUnmappableCharacter$Ljava$nio$charset$CodingErrorAction$.call(this,var4);
     // line number 429
     return this;
    } else {
     // line number 426
     var1 = new java$lang$IllegalArgumentException();
     var2 = bytecoder.stringconstants[26];
     java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var1,var2);
     throw bytecoder.registerStack(var1, new Error().stack);
    }
  }

  V$implOnUnmappableCharacter$Ljava$nio$charset$CodingErrorAction$(arg0) {
    // source file is CharsetDecoder.java
    var var0 = null;
    var0 = arg0;
    // line number 441
    return;
  }

  F$maxCharsPerByte$$() {
    // source file is CharsetDecoder.java
    var var0 = .0;
    // line number 471
    var0 = (this.maxCharsPerByte);
    return var0;
  }

  Ljava$nio$charset$CoderResult$$decode$Ljava$nio$ByteBuffer$$Ljava$nio$CharBuffer$$Z(arg0,arg1,arg2) {
    // source file is CharsetDecoder.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var phi3 = null;
    var phi4 = null;
    var phi5 = null;
    var phi6 = 0;
    var phi7 = 0;
    var var8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = 0;
    var var13 = 0;
    var var14 = null;
    var var15 = 0;
    var phi16 = 0;
    var var17 = null;
    var var18 = null;
    var var19 = 0;
    var var20 = 0;
    var var21 = null;
    var var22 = 0;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = 0;
    var var30 = 0;
    var var31 = 0;
    var var32 = null;
    var var33 = 0;
    var var34 = null;
    var var35 = 0;
    var var36 = null;
    var phi37 = null;
    var var38 = null;
    var var39 = null;
    var var40 = 0;
    var var41 = null;
    var var42 = null;
    var phi43 = null;
    var var44 = null;
    var var45 = null;
    var var46 = null;
    var var47 = null;
    var var48 = null;
    var var49 = null;
    var var50 = 0;
    var var51 = null;
    var var52 = null;
    var var53 = 0;
    var var54 = null;
    var var55 = null;
    var var56 = null;
    var var57 = null;
    var var58 = null;
    var var59 = null;
    var var60 = null;
    var var61 = null;
    var var62 = null;
    var var63 = null;
    var var64 = null;
    var var65 = 0;
    var var66 = null;
    var var67 = 0;
    var var68 = 0;
    var var69 = null;
    var var70 = 0;
    var var71 = null;
    var var72 = null;
    var var73 = 0;
    var var74 = null;
    var var75 = null;
    var var76 = 0;
    var var77 = null;
    var var78 = null;
    var var79 = null;
    var phi80 = null;
    var var81 = null;
    var0 = arg0;
    var1 = arg2;
    // line number 575
    If_11_0: {
     if (var1 == 0) {
      phi3 = this;
      phi4 = var0;
      phi5 = arg1;
      phi6 = var1;
      phi7 = (1) | 0;
      break If_11_0;
     } else {
      var2 = (2) | 0;
      // Here was a goto statement
      phi3 = this;
      phi4 = var0;
      phi5 = arg1;
      phi6 = var1;
      phi7 = (var2) | 0;
      break If_11_0;
     }
    }
    var8 = (phi7) | 0;
    // line number 576
    var9 = phi3;
    var10 = ((var9.state)) | 0;
    If_34_0: {
     if (var10 == 0) {
      phi16 = (var8) | 0;
      break If_34_0;
     } else {
      var11 = phi3;
      var12 = ((var11.state)) | 0;
      if (var12 == 1) {
       phi16 = (var8) | 0;
       break If_34_0;
      } else {
       var13 = phi6;
       If_47_0: {
        if (var13 == 0) {
         phi16 = (var8) | 0;
         break If_47_0;
        } else {
         var14 = phi3;
         var15 = ((var14.state)) | 0;
         if (var15 == 2) {
          phi16 = (var8) | 0;
          break If_34_0;
         } else {
          phi16 = (var8) | 0;
          break If_47_0;
         }
        }
       }
       // line number 578
       var17 = phi3;
       var18 = phi3;
       var19 = ((var18.state)) | 0;
       var20 = (phi16) | 0;
       java$nio$charset$CharsetDecoder.prototype.V$throwIllegalStateException$I$I.call(var17,var19,var20);
       break If_34_0;
      }
     }
    }
    // line number 579
    var21 = phi3;
    var22 = (phi16) | 0;
    var21.state = var22;
    TryCatch_80: while(true) {
     TryCatch_80_0: {
      try {
       // line number 585
       var25 = phi3;
       var26 = phi4;
       var27 = phi5;
       var28 = (var25.Ljava$nio$charset$CoderResult$$decodeLoop$Ljava$nio$ByteBuffer$$Ljava$nio$CharBuffer$(var26,var27));
       break TryCatch_80_0;
      } catch (__ex) {
       if (__ex instanceof java$lang$RuntimeException) {
        // line number 586
        // line number 587
        var23 = new java$nio$charset$CoderMalfunctionError();
        var24 = __ex;
        java$nio$charset$CoderMalfunctionError.prototype.V$$init$$Ljava$lang$Exception$.call(var23,var24);
        throw bytecoder.registerStack(var23, new Error().stack);
       }
       throw __ex;
      }
     }
     // line number 588
     // Here was a goto statement
     // line number 590
     var29 = (java$nio$charset$CoderResult.prototype.Z$isOverflow$$.call(var28));
     if (var29 == 0) {
      // line number 593
      var30 = (java$nio$charset$CoderResult.prototype.Z$isUnderflow$$.call(var28));
      If_128_0: {
       if (var30 == 0) {
        phi37 = var28;
        break If_128_0;
       } else {
        // line number 594
        var31 = phi6;
        If_135_0: {
         if (var31 == 0) {
          phi80 = var28;
          break If_135_0;
         } else {
          var32 = phi4;
          var33 = (var32.Z$hasRemaining$$());
          if (var33 == 0) {
           phi80 = var28;
           break If_135_0;
          } else {
           // line number 595
           var34 = phi4;
           var35 = ((var34.I$remaining$$())) | 0;
           java$nio$charset$CoderResult.$i;
           var36 = (java$nio$charset$CoderResult.Ljava$nio$charset$CoderResult$$malformedForLength$I(var35));
           // Here was a goto statement
           phi37 = var36;
           break If_128_0;
          }
         }
        }
        // line number 598
        var81 = phi80;
        return var81;
       }
      }
      // line number 602
      var38 = null;
      // line number 603
      var39 = phi37;
      var40 = (java$nio$charset$CoderResult.prototype.Z$isMalformed$$.call(var39));
      If_173_0: {
       if (var40 == 0) {
        // line number 605
        var72 = phi37;
        var73 = (java$nio$charset$CoderResult.prototype.Z$isUnmappable$$.call(var72));
        if (var73 == 0) {
         // line number 608
         java$nio$charset$CharsetDecoder.$i;
         var76 = (java$nio$charset$CharsetDecoder.$assertionsDisabled);
         if (var76 != 0) {
          phi43 = var38;
          break If_173_0;
         } else {
          var77 = new java$lang$AssertionError();
          var78 = phi37;
          var79 = (java$nio$charset$CoderResult.prototype.Ljava$lang$String$$toString$$.call(var78));
          java$lang$AssertionError.prototype.V$$init$$Ljava$lang$Object$.call(var77,var79);
          throw bytecoder.registerStack(var77, new Error().stack);
         }
        } else {
         // line number 606
         var74 = phi3;
         var75 = (var74.unmappableCharacterAction);
         // Here was a goto statement
         phi43 = var75;
         break If_173_0;
        }
       } else {
        // line number 604
        var41 = phi3;
        var42 = (var41.malformedInputAction);
        // Here was a goto statement
        phi43 = var42;
        break If_173_0;
       }
      }
      // line number 610
      var44 = phi43;
      java$nio$charset$CodingErrorAction.$i;
      var45 = (java$nio$charset$CodingErrorAction.REPORT);
      if (var44 != var45) {
       // line number 613
       var47 = phi43;
       var48 = (java$nio$charset$CodingErrorAction.REPLACE);
       If_211_0: {
        if (var47 != var48) {
         break If_211_0;
        } else {
         // line number 614
         var49 = phi5;
         var50 = ((var49.I$remaining$$())) | 0;
         var51 = phi3;
         var52 = (var51.replacement);
         var53 = ((java$lang$String.prototype.I$length$$.call(var52))) | 0;
         if (var50 >= var53) {
          // line number 616
          var55 = phi5;
          var56 = phi3;
          var57 = (var56.replacement);
          var58 = (java$nio$CharBuffer.prototype.Ljava$nio$CharBuffer$$put$Ljava$lang$String$.call(var55,var57));
          break If_211_0;
         } else {
          // line number 615
          java$nio$charset$CoderResult.$i;
          var54 = (java$nio$charset$CoderResult.OVERFLOW);
          return var54;
         }
        }
       }
       // line number 619
       var59 = phi43;
       var60 = (java$nio$charset$CodingErrorAction.IGNORE);
       If_259_0: {
        if (var59 == var60) {
         break If_259_0;
        } else {
         var61 = phi43;
         var62 = (java$nio$charset$CodingErrorAction.REPLACE);
         if (var61 != var62) {
          // line number 626
          java$nio$charset$CharsetDecoder.$i;
          var70 = (java$nio$charset$CharsetDecoder.$assertionsDisabled);
          if (var70 != 0) {
           // line number 627
           // Here was a goto statement
           continue TryCatch_80;
          } else {
           var71 = new java$lang$AssertionError();
           java$lang$AssertionError.prototype.V$$init$$$.call(var71);
           throw bytecoder.registerStack(var71, new Error().stack);
          }
         } else {
          break If_259_0;
         }
        }
       }
       // line number 622
       var63 = phi4;
       var64 = phi4;
       var65 = ((var64.I$position$$())) | 0;
       var66 = phi37;
       var67 = ((java$nio$charset$CoderResult.prototype.I$length$$.call(var66))) | 0;
       var68 = ((var65 + var67)) | 0;
       var69 = (java$nio$ByteBuffer.prototype.Ljava$nio$ByteBuffer$$position$I.call(var63,var68));
       // line number 623
       // Here was a goto statement
       continue TryCatch_80;
      } else {
       // line number 611
       var46 = phi37;
       return var46;
      }
     } else {
      // line number 591
      return var28;
     }
    }
  }

  V$throwIllegalStateException$I$I(arg0,arg1) {
    // source file is CharsetDecoder.java
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var0 = (arg0) | 0;
    // line number 996
    var1 = new java$lang$IllegalStateException();
    var2 = new java$lang$StringBuilder();
    java$lang$StringBuilder.prototype.V$$init$$$.call(var2);
    var3 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var2,bytecoder.stringconstants[86]));
    java$nio$charset$CharsetDecoder.$i;
    var4 = (java$nio$charset$CharsetDecoder.stateNames);
    var5 = (var4.data[var0]);
    var6 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var3,var5));
    var7 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var6,bytecoder.stringconstants[87]));
    var8 = (java$nio$charset$CharsetDecoder.stateNames);
    var9 = (var8.data[arg1]);
    var10 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var7,var9));
    var11 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var10));
    java$lang$IllegalStateException.prototype.V$$init$$Ljava$lang$String$.call(var1,var11);
    throw bytecoder.registerStack(var1, new Error().stack);
  }

  Ljava$nio$charset$CharsetDecoder$$reset$$() {
    // source file is CharsetDecoder.java
    var var0 = null;
    // line number 713
    java$nio$charset$CharsetDecoder.prototype.V$implReset$$.call(this);
    // line number 714
    var0 = this;
    var0.state = 0;
    // line number 715
    return this;
  }

  V$implReset$$() {
    // source file is CharsetDecoder.java
    // line number 724
    return;
  }

  V$$init$$Ljava$nio$charset$Charset$$F$F(arg0,arg1,arg2) {
    // source file is CharsetDecoder.java
    var var0 = null;
    var var1 = .0;
    var var2 = null;
    var var3 = .0;
    var0 = arg0;
    var1 = arg2;
    // line number 233
    var2 = var0;
    var3 = var1;
    java$nio$charset$CharsetDecoder.prototype.V$$init$$Ljava$nio$charset$Charset$$F$F$Ljava$lang$String$.call(this,var2,arg1,var3,bytecoder.stringconstants[111]);
    // line number 236
    return;
  }

  V$$init$$Ljava$nio$charset$Charset$$F$F$Ljava$lang$String$(arg0,arg1,arg2,arg3) {
    // source file is CharsetDecoder.java
    var var0 = null;
    var var1 = .0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = .0;
    var var9 = 0;
    var var10 = null;
    var var11 = null;
    var var12 = .0;
    var var13 = 0;
    var var14 = null;
    var var15 = null;
    var var16 = 0;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var0 = arg0;
    var1 = arg2;
    // line number 190
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 144
    var2 = this;
    java$nio$charset$CodingErrorAction.$i;
    var3 = (java$nio$charset$CodingErrorAction.REPORT);
    var2.malformedInputAction = var3;
    // line number 146
    var4 = this;
    var5 = (java$nio$charset$CodingErrorAction.REPORT);
    var4.unmappableCharacterAction = var5;
    // line number 156
    var6 = this;
    var6.state = 0;
    // line number 191
    var7 = this;
    var7.charset = var0;
    // line number 193
    var8 = 0.0;
    var9 = (bytecoder.cmp(arg1,var8)) | 0;
    if (var9 > 0) {
     // line number 197
     var12 = 0.0;
     var13 = (bytecoder.cmp(var1,var12)) | 0;
     if (var13 > 0) {
      // line number 200
      var16 = (bytecoder.cmp(arg1,var1)) | 0;
      if (var16 <= 0) {
       // line number 204
       var19 = this;
       var19.replacement = arg3;
       // line number 205
       var20 = this;
       var20.averageCharsPerByte = arg1;
       // line number 206
       var21 = this;
       var21.maxCharsPerByte = var1;
       // line number 207
       var22 = arg3;
       var23 = (java$nio$charset$CharsetDecoder.prototype.Ljava$nio$charset$CharsetDecoder$$replaceWith$Ljava$lang$String$.call(this,var22));
       // line number 208
       return;
      } else {
       // line number 201
       var17 = new java$lang$IllegalArgumentException();
       var18 = bytecoder.stringconstants[114];
       java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var17,var18);
       throw bytecoder.registerStack(var17, new Error().stack);
      }
     } else {
      // line number 198
      var14 = new java$lang$IllegalArgumentException();
      var15 = bytecoder.stringconstants[113];
      java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var14,var15);
      throw bytecoder.registerStack(var14, new Error().stack);
     }
    } else {
     // line number 194
     var10 = new java$lang$IllegalArgumentException();
     var11 = bytecoder.stringconstants[112];
     java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var10,var11);
     throw bytecoder.registerStack(var10, new Error().stack);
    }
  }

  Ljava$nio$charset$CharsetDecoder$$replaceWith$Ljava$lang$String$(arg0) {
    // source file is CharsetDecoder.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = .0;
    var var6 = .0;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var0 = arg0;
    // line number 287
    if (var0 != null) {
     // line number 289
     var3 = ((java$lang$String.prototype.I$length$$.call(var0))) | 0;
     // line number 290
     if (var3 != 0) {
      // line number 292
      var5 = var3;
      var6 = (this.maxCharsPerByte);
      var7 = (bytecoder.cmp(var5,var6)) | 0;
      if (var7 <= 0) {
       // line number 295
       var9 = this;
       var9.replacement = var0;
       // line number 302
       var10 = this;
       var11 = (var10.replacement);
       java$nio$charset$CharsetDecoder.prototype.V$implReplaceWith$Ljava$lang$String$.call(this,var11);
       // line number 303
       return this;
      } else {
       // line number 293
       var8 = new java$lang$IllegalArgumentException();
       java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var8,bytecoder.stringconstants[81]);
       throw bytecoder.registerStack(var8, new Error().stack);
      }
     } else {
      // line number 291
      var4 = new java$lang$IllegalArgumentException();
      java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var4,bytecoder.stringconstants[80]);
      throw bytecoder.registerStack(var4, new Error().stack);
     }
    } else {
     // line number 288
     var1 = new java$lang$IllegalArgumentException();
     var2 = bytecoder.stringconstants[79];
     java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var1,var2);
     throw bytecoder.registerStack(var1, new Error().stack);
    }
  }

  V$implReplaceWith$Ljava$lang$String$(arg0) {
    // source file is CharsetDecoder.java
    var var0 = null;
    var0 = arg0;
    // line number 316
    return;
  }

  Ljava$nio$charset$Charset$$charset$$() {
    // source file is CharsetDecoder.java
    var var0 = null;
    // line number 244
    var0 = (this.charset);
    return var0;
  }
}


class org$jbox2d$collision$ManifoldPoint extends java$lang$Object {
  nativeObject = null;

  localPoint = null;
  normalImpulse = 0.0;
  tangentImpulse = 0.0;
  id = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$collision$ManifoldPoint,[org$jbox2d$collision$ManifoldPoint,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$set$Lorg$jbox2d$collision$ManifoldPoint$(arg0) {
    // source file is ManifoldPoint.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = .0;
    var var6 = null;
    var var7 = .0;
    var var8 = null;
    var var9 = null;
    var0 = arg0;
    // line number 99
    var1 = (this.localPoint);
    var2 = (var0.localPoint);
    var3 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var1,var2));
    // line number 100
    var4 = this;
    var5 = (var0.normalImpulse);
    var4.normalImpulse = var5;
    // line number 101
    var6 = this;
    var7 = (var0.tangentImpulse);
    var6.tangentImpulse = var7;
    // line number 102
    var8 = (this.id);
    var9 = (var0.id);
    org$jbox2d$collision$ContactID.prototype.V$set$Lorg$jbox2d$collision$ContactID$.call(var8,var9);
    // line number 103
    return;
  }

  V$$init$$$() {
    // source file is ManifoldPoint.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = .0;
    var var5 = null;
    var var6 = null;
    // line number 77
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 78
    var0 = this;
    org$jbox2d$common$Vec2.$i;
    var1 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var1);
    var0.localPoint = var1;
    // line number 79
    var2 = this;
    var3 = this;
    var4 = 0.0;
    var3.tangentImpulse = var4;
    var2.normalImpulse = 0.0;
    // line number 80
    var5 = this;
    var6 = new org$jbox2d$collision$ContactID();
    org$jbox2d$collision$ContactID.prototype.V$$init$$$.call(var6);
    var5.id = var6;
    // line number 81
    return;
  }
}


class org$jbox2d$dynamics$Body extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;
  m_xf = null;
  m_sweep = null;
  m_linearVelocity = null;
  m_angularVelocity = 0.0;
  m_force = null;
  m_torque = 0.0;
  fixDef = null;
  pmd = null;
  pxf = null;
  m_flags = 0;
  m_world = null;
  m_jointList = null;
  m_contactList = null;
  m_prev = null;
  m_next = null;
  m_linearDamping = 0.0;
  m_angularDamping = 0.0;
  m_gravityScale = 0.0;
  m_sleepTime = 0.0;
  m_type = null;
  m_mass = 0.0;
  m_invMass = 0.0;
  m_I = 0.0;
  m_invI = 0.0;
  m_userData = null;
  m_fixtureList = null;
  m_fixtureCount = 0;
  m_islandIndex = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$dynamics$Body,[org$jbox2d$dynamics$Body,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is Body.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    // line number 43
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(org$jbox2d$dynamics$Body.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    org$jbox2d$dynamics$Body.$i;
    org$jbox2d$dynamics$Body.$assertionsDisabled = phi2;
    return;
  }

  V$$init$$Lorg$jbox2d$dynamics$BodyDef$$Lorg$jbox2d$dynamics$World$(arg0,arg1) {
    // source file is Body.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = 0;
    var var18 = null;
    var var19 = null;
    var var20 = 0;
    var var21 = null;
    var phi22 = null;
    var phi23 = null;
    var phi24 = null;
    var var25 = 0;
    var var26 = null;
    var var27 = null;
    var var28 = 0;
    var var29 = null;
    var var30 = 0;
    var var31 = null;
    var var32 = .0;
    var var33 = 0;
    var var34 = null;
    var var35 = 0;
    var var36 = null;
    var var37 = .0;
    var var38 = 0;
    var var39 = null;
    var var40 = 0;
    var var41 = null;
    var var42 = .0;
    var var43 = 0;
    var var44 = null;
    var var45 = null;
    var var46 = null;
    var var47 = 0;
    var var48 = null;
    var var49 = 0;
    var var50 = 0;
    var var51 = null;
    var var52 = 0;
    var var53 = null;
    var var54 = 0;
    var var55 = 0;
    var var56 = null;
    var var57 = 0;
    var var58 = null;
    var var59 = 0;
    var var60 = 0;
    var var61 = null;
    var var62 = 0;
    var var63 = null;
    var var64 = 0;
    var var65 = 0;
    var var66 = null;
    var var67 = 0;
    var var68 = null;
    var var69 = 0;
    var var70 = 0;
    var var71 = null;
    var var72 = null;
    var var73 = null;
    var var74 = null;
    var var75 = null;
    var var76 = null;
    var var77 = null;
    var var78 = null;
    var var79 = null;
    var var80 = null;
    var var81 = null;
    var var82 = null;
    var var83 = .0;
    var var84 = null;
    var var85 = null;
    var var86 = null;
    var var87 = null;
    var var88 = null;
    var var89 = null;
    var var90 = null;
    var var91 = null;
    var var92 = null;
    var var93 = null;
    var var94 = null;
    var var95 = null;
    var var96 = null;
    var var97 = null;
    var var98 = null;
    var var99 = null;
    var var100 = null;
    var var101 = null;
    var var102 = null;
    var var103 = null;
    var var104 = null;
    var var105 = .0;
    var var106 = null;
    var var107 = null;
    var var108 = null;
    var var109 = .0;
    var var110 = null;
    var var111 = null;
    var var112 = null;
    var var113 = null;
    var var114 = null;
    var var115 = null;
    var var116 = null;
    var var117 = null;
    var var118 = null;
    var var119 = null;
    var var120 = null;
    var var121 = null;
    var var122 = null;
    var var123 = .0;
    var var124 = null;
    var var125 = null;
    var var126 = .0;
    var var127 = null;
    var var128 = null;
    var var129 = .0;
    var var130 = null;
    var var131 = null;
    var var132 = .0;
    var var133 = null;
    var var134 = null;
    var var135 = null;
    var var136 = null;
    var var137 = null;
    var var138 = null;
    var var139 = null;
    var var140 = null;
    var var141 = null;
    var var142 = null;
    var var143 = null;
    var var144 = null;
    var var145 = null;
    var var146 = null;
    var var147 = null;
    var var148 = null;
    var var149 = null;
    var var150 = null;
    var var151 = null;
    var var152 = null;
    var var153 = null;
    var0 = arg0;
    // line number 98
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 61
    var1 = this;
    org$jbox2d$common$Transform.$i;
    var2 = new org$jbox2d$common$Transform();
    org$jbox2d$common$Transform.prototype.V$$init$$$.call(var2);
    var1.m_xf = var2;
    // line number 66
    var3 = this;
    org$jbox2d$common$Sweep.$i;
    var4 = new org$jbox2d$common$Sweep();
    org$jbox2d$common$Sweep.prototype.V$$init$$$.call(var4);
    var3.m_sweep = var4;
    // line number 68
    var5 = this;
    org$jbox2d$common$Vec2.$i;
    var6 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var6);
    var5.m_linearVelocity = var6;
    // line number 69
    var7 = this;
    var7.m_angularVelocity = 0.0;
    // line number 71
    var8 = this;
    var9 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var9);
    var8.m_force = var9;
    // line number 72
    var10 = this;
    var10.m_torque = 0.0;
    // line number 213
    var11 = this;
    var12 = new org$jbox2d$dynamics$FixtureDef();
    org$jbox2d$dynamics$FixtureDef.prototype.V$$init$$$.call(var12);
    var11.fixDef = var12;
    // line number 652
    var13 = this;
    var14 = new org$jbox2d$collision$shapes$MassData();
    org$jbox2d$collision$shapes$MassData.prototype.V$$init$$$.call(var14);
    var13.pmd = var14;
    // line number 1111
    var15 = this;
    var16 = new org$jbox2d$common$Transform();
    org$jbox2d$common$Transform.prototype.V$$init$$$.call(var16);
    var15.pxf = var16;
    // line number 99
    org$jbox2d$dynamics$Body.$i;
    var17 = (org$jbox2d$dynamics$Body.$assertionsDisabled);
    If_103_0: {
     if (var17 != 0) {
      phi22 = this;
      phi23 = var0;
      phi24 = arg1;
      break If_103_0;
     } else {
      var18 = var0;
      var19 = (var18.position);
      var20 = (org$jbox2d$common$Vec2.prototype.Z$isValid$$.call(var19));
      if (var20 != 0) {
       phi22 = this;
       phi23 = var0;
       phi24 = arg1;
       break If_103_0;
      } else {
       var21 = new java$lang$AssertionError();
       java$lang$AssertionError.prototype.V$$init$$$.call(var21);
       throw bytecoder.registerStack(var21, new Error().stack);
      }
     }
    }
    // line number 100
    var25 = (org$jbox2d$dynamics$Body.$assertionsDisabled);
    If_134_0: {
     if (var25 != 0) {
      break If_134_0;
     } else {
      var26 = phi23;
      var27 = (var26.linearVelocity);
      var28 = (org$jbox2d$common$Vec2.prototype.Z$isValid$$.call(var27));
      if (var28 != 0) {
       break If_134_0;
      } else {
       var29 = new java$lang$AssertionError();
       java$lang$AssertionError.prototype.V$$init$$$.call(var29);
       throw bytecoder.registerStack(var29, new Error().stack);
      }
     }
    }
    // line number 101
    var30 = (org$jbox2d$dynamics$Body.$assertionsDisabled);
    If_161_0: {
     if (var30 != 0) {
      break If_161_0;
     } else {
      var31 = phi23;
      var32 = (var31.gravityScale);
      var33 = (bytecoder.cmp(var32,0.0)) | 0;
      if (var33 >= 0) {
       break If_161_0;
      } else {
       var34 = new java$lang$AssertionError();
       java$lang$AssertionError.prototype.V$$init$$$.call(var34);
       throw bytecoder.registerStack(var34, new Error().stack);
      }
     }
    }
    // line number 102
    var35 = (org$jbox2d$dynamics$Body.$assertionsDisabled);
    If_189_0: {
     if (var35 != 0) {
      break If_189_0;
     } else {
      var36 = phi23;
      var37 = (var36.angularDamping);
      var38 = (bytecoder.cmp(var37,0.0)) | 0;
      if (var38 >= 0) {
       break If_189_0;
      } else {
       var39 = new java$lang$AssertionError();
       java$lang$AssertionError.prototype.V$$init$$$.call(var39);
       throw bytecoder.registerStack(var39, new Error().stack);
      }
     }
    }
    // line number 103
    var40 = (org$jbox2d$dynamics$Body.$assertionsDisabled);
    If_217_0: {
     if (var40 != 0) {
      break If_217_0;
     } else {
      var41 = phi23;
      var42 = (var41.linearDamping);
      var43 = (bytecoder.cmp(var42,0.0)) | 0;
      if (var43 >= 0) {
       break If_217_0;
      } else {
       var44 = new java$lang$AssertionError();
       java$lang$AssertionError.prototype.V$$init$$$.call(var44);
       throw bytecoder.registerStack(var44, new Error().stack);
      }
     }
    }
    // line number 105
    var45 = phi22;
    var45.m_flags = 0;
    // line number 107
    var46 = phi23;
    var47 = (var46.bullet);
    If_252_0: {
     if (var47 == 0) {
      break If_252_0;
     } else {
      // line number 108
      var48 = phi22;
      var49 = ((var48.m_flags)) | 0;
      var50 = ((var49 | 8)) | 0;
      var48.m_flags = var50;
      break If_252_0;
     }
    }
    // line number 110
    var51 = phi23;
    var52 = (var51.fixedRotation);
    If_275_0: {
     if (var52 == 0) {
      break If_275_0;
     } else {
      // line number 111
      var53 = phi22;
      var54 = ((var53.m_flags)) | 0;
      var55 = ((var54 | 16)) | 0;
      var53.m_flags = var55;
      break If_275_0;
     }
    }
    // line number 113
    var56 = phi23;
    var57 = (var56.allowSleep);
    If_298_0: {
     if (var57 == 0) {
      break If_298_0;
     } else {
      // line number 114
      var58 = phi22;
      var59 = ((var58.m_flags)) | 0;
      var60 = ((var59 | 4)) | 0;
      var58.m_flags = var60;
      break If_298_0;
     }
    }
    // line number 116
    var61 = phi23;
    var62 = (var61.awake);
    If_321_0: {
     if (var62 == 0) {
      break If_321_0;
     } else {
      // line number 117
      var63 = phi22;
      var64 = ((var63.m_flags)) | 0;
      var65 = ((var64 | 2)) | 0;
      var63.m_flags = var65;
      break If_321_0;
     }
    }
    // line number 119
    var66 = phi23;
    var67 = (var66.active);
    If_344_0: {
     if (var67 == 0) {
      break If_344_0;
     } else {
      // line number 120
      var68 = phi22;
      var69 = ((var68.m_flags)) | 0;
      var70 = ((var69 | 32)) | 0;
      var68.m_flags = var70;
      break If_344_0;
     }
    }
    // line number 123
    var71 = phi22;
    var72 = phi24;
    var71.m_world = var72;
    // line number 125
    var73 = phi22;
    var74 = (var73.m_xf);
    var75 = (var74.p);
    var76 = phi23;
    var77 = (var76.position);
    var78 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var75,var77));
    // line number 126
    var79 = phi22;
    var80 = (var79.m_xf);
    var81 = (var80.q);
    var82 = phi23;
    var83 = (var82.angle);
    var84 = (org$jbox2d$common$Rot.prototype.Lorg$jbox2d$common$Rot$$set$F.call(var81,var83));
    // line number 128
    var85 = phi22;
    var86 = (var85.m_sweep);
    var87 = (var86.localCenter);
    org$jbox2d$common$Vec2.prototype.V$setZero$$.call(var87);
    // line number 129
    var88 = phi22;
    var89 = (var88.m_sweep);
    var90 = (var89.c0);
    var91 = phi22;
    var92 = (var91.m_xf);
    var93 = (var92.p);
    var94 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var90,var93));
    // line number 130
    var95 = phi22;
    var96 = (var95.m_sweep);
    var97 = (var96.c);
    var98 = phi22;
    var99 = (var98.m_xf);
    var100 = (var99.p);
    var101 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var97,var100));
    // line number 131
    var102 = phi22;
    var103 = (var102.m_sweep);
    var104 = phi23;
    var105 = (var104.angle);
    var103.a0 = var105;
    // line number 132
    var106 = phi22;
    var107 = (var106.m_sweep);
    var108 = phi23;
    var109 = (var108.angle);
    var107.a = var109;
    // line number 133
    var110 = phi22;
    var111 = (var110.m_sweep);
    var111.alpha0 = 0.0;
    // line number 135
    var112 = phi22;
    var112.m_jointList = null;
    // line number 136
    var113 = phi22;
    var113.m_contactList = null;
    // line number 137
    var114 = phi22;
    var114.m_prev = null;
    // line number 138
    var115 = phi22;
    var115.m_next = null;
    // line number 140
    var116 = phi22;
    var117 = (var116.m_linearVelocity);
    var118 = phi23;
    var119 = (var118.linearVelocity);
    var120 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var117,var119));
    // line number 141
    var121 = phi22;
    var122 = phi23;
    var123 = (var122.angularVelocity);
    var121.m_angularVelocity = var123;
    // line number 143
    var124 = phi22;
    var125 = phi23;
    var126 = (var125.linearDamping);
    var124.m_linearDamping = var126;
    // line number 144
    var127 = phi22;
    var128 = phi23;
    var129 = (var128.angularDamping);
    var127.m_angularDamping = var129;
    // line number 145
    var130 = phi22;
    var131 = phi23;
    var132 = (var131.gravityScale);
    var130.m_gravityScale = var132;
    // line number 147
    var133 = phi22;
    var134 = (var133.m_force);
    org$jbox2d$common$Vec2.prototype.V$setZero$$.call(var134);
    // line number 148
    var135 = phi22;
    var135.m_torque = 0.0;
    // line number 150
    var136 = phi22;
    var136.m_sleepTime = 0.0;
    // line number 152
    var137 = phi22;
    var138 = phi23;
    var139 = (var138.type);
    var137.m_type = var139;
    // line number 154
    var140 = phi22;
    var141 = (var140.m_type);
    org$jbox2d$dynamics$BodyType.$i;
    var142 = (org$jbox2d$dynamics$BodyType.DYNAMIC);
    If_612_0: {
     if (var141 != var142) {
      // line number 158
      var152 = phi22;
      var152.m_mass = 0.0;
      // line number 159
      var153 = phi22;
      var153.m_invMass = 0.0;
      break If_612_0;
     } else {
      // line number 155
      var143 = phi22;
      var143.m_mass = 1.0;
      // line number 156
      var144 = phi22;
      var144.m_invMass = 1.0;
      // Here was a goto statement
      break If_612_0;
     }
    }
    // line number 162
    var145 = phi22;
    var145.m_I = 0.0;
    // line number 163
    var146 = phi22;
    var146.m_invI = 0.0;
    // line number 165
    var147 = phi22;
    var148 = phi23;
    var149 = (var148.userData);
    var147.m_userData = var149;
    // line number 167
    var150 = phi22;
    var150.m_fixtureList = null;
    // line number 168
    var151 = phi22;
    var151.m_fixtureCount = 0;
    // line number 169
    return;
  }

  Lorg$jbox2d$dynamics$Fixture$$createFixture$Lorg$jbox2d$dynamics$FixtureDef$(arg0) {
    // source file is Body.java
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var phi6 = null;
    var phi7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = 0;
    var var16 = 0;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var phi24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = null;
    var var31 = 0;
    var var32 = 0;
    var var33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = .0;
    var var37 = 0;
    var var38 = null;
    var var39 = null;
    var var40 = null;
    var var41 = 0;
    var var42 = 0;
    var var43 = null;
    var0 = arg0;
    // line number 181
    org$jbox2d$dynamics$Body.$i;
    var1 = (org$jbox2d$dynamics$Body.$assertionsDisabled);
    If_12_0: {
     if (var1 != 0) {
      phi6 = this;
      phi7 = var0;
      break If_12_0;
     } else {
      var2 = this;
      var3 = (var2.m_world);
      var4 = (org$jbox2d$dynamics$World.prototype.Z$isLocked$$.call(var3));
      if (var4 == 0) {
       phi6 = this;
       phi7 = var0;
       break If_12_0;
      } else {
       var5 = new java$lang$AssertionError();
       java$lang$AssertionError.prototype.V$$init$$$.call(var5);
       throw bytecoder.registerStack(var5, new Error().stack);
      }
     }
    }
    // line number 183
    var8 = phi6;
    var9 = (var8.m_world);
    var10 = (org$jbox2d$dynamics$World.prototype.Z$isLocked$$.call(var9));
    if (var10 != 1) {
     // line number 187
     org$jbox2d$dynamics$Fixture.$i;
     var11 = new org$jbox2d$dynamics$Fixture();
     org$jbox2d$dynamics$Fixture.prototype.V$$init$$$.call(var11);
     // line number 188
     var12 = phi6;
     var13 = phi7;
     org$jbox2d$dynamics$Fixture.prototype.V$create$Lorg$jbox2d$dynamics$Body$$Lorg$jbox2d$dynamics$FixtureDef$.call(var11,var12,var13);
     // line number 190
     var14 = phi6;
     var15 = ((var14.m_flags)) | 0;
     var16 = ((var15 & 32)) | 0;
     If_81_0: {
      if (var16 != 32) {
       phi24 = var11;
       break If_81_0;
      } else {
       // line number 191
       var17 = phi6;
       var18 = (var17.m_world);
       var19 = (var18.m_contactManager);
       var20 = (var19.m_broadPhase);
       // line number 192
       var21 = var20;
       var22 = phi6;
       var23 = (var22.m_xf);
       org$jbox2d$dynamics$Fixture.prototype.V$createProxies$Lorg$jbox2d$collision$broadphase$BroadPhase$$Lorg$jbox2d$common$Transform$.call(var11,var21,var23);
       phi24 = var11;
       break If_81_0;
      }
     }
     // line number 195
     var25 = phi24;
     var26 = phi6;
     var27 = (var26.m_fixtureList);
     var25.m_next = var27;
     // line number 196
     var28 = phi6;
     var29 = phi24;
     var28.m_fixtureList = var29;
     // line number 197
     var30 = phi6;
     var31 = ((var30.m_fixtureCount)) | 0;
     var32 = ((var31 + 1)) | 0;
     var30.m_fixtureCount = var32;
     // line number 199
     var33 = phi24;
     var34 = phi6;
     var33.m_body = var34;
     // line number 202
     var35 = phi24;
     var36 = (var35.m_density);
     var37 = (bytecoder.cmp(var36,0.0)) | 0;
     If_155_0: {
      if (var37 <= 0) {
       break If_155_0;
      } else {
       // line number 203
       var38 = phi6;
       org$jbox2d$dynamics$Body.prototype.V$resetMassData$$.call(var38);
       break If_155_0;
      }
     }
     // line number 208
     var39 = phi6;
     var40 = (var39.m_world);
     var41 = ((var40.m_flags)) | 0;
     var42 = ((var41 | 1)) | 0;
     var40.m_flags = var42;
     // line number 210
     var43 = phi24;
     return var43;
    } else {
     // line number 184
     return null;
    }
  }

  V$resetMassData$$() {
    // source file is Body.java
    var var0 = null;
    var var1 = .0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var phi9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = .0;
    var var29 = 0;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var phi34 = null;
    var var35 = null;
    var var36 = null;
    var var37 = null;
    var var38 = null;
    var var39 = null;
    var var40 = null;
    var var41 = null;
    var var42 = null;
    var var43 = null;
    var var44 = null;
    var var45 = null;
    var var46 = null;
    var phi47 = null;
    var phi48 = null;
    var phi49 = null;
    var phi50 = null;
    var var51 = null;
    var var52 = null;
    var var53 = .0;
    var var54 = 0;
    var var55 = null;
    var var56 = null;
    var var57 = null;
    var var58 = null;
    var var59 = null;
    var var60 = .0;
    var var61 = null;
    var var62 = .0;
    var var63 = .0;
    var var64 = null;
    var var65 = null;
    var var66 = null;
    var var67 = null;
    var var68 = null;
    var var69 = .0;
    var var70 = null;
    var var71 = null;
    var var72 = null;
    var var73 = null;
    var var74 = null;
    var var75 = .0;
    var var76 = null;
    var var77 = .0;
    var var78 = .0;
    var var79 = null;
    var var80 = .0;
    var var81 = 0;
    var var82 = null;
    var var83 = null;
    var var84 = .0;
    var var85 = .0;
    var var86 = null;
    var var87 = null;
    var var88 = .0;
    var var89 = null;
    var var90 = null;
    var var91 = .0;
    var var92 = 0;
    var var93 = null;
    var var94 = 0;
    var var95 = 0;
    var var96 = null;
    var var97 = .0;
    var var98 = null;
    var var99 = .0;
    var var100 = null;
    var var101 = null;
    var var102 = .0;
    var var103 = .0;
    var var104 = .0;
    var var105 = 0;
    var var106 = null;
    var var107 = .0;
    var var108 = 0;
    var var109 = null;
    var var110 = null;
    var var111 = null;
    var var112 = .0;
    var var113 = .0;
    var var114 = null;
    var var115 = null;
    var var116 = null;
    var var117 = null;
    var var118 = null;
    var var119 = null;
    var var120 = null;
    var var121 = null;
    var var122 = null;
    var var123 = null;
    var var124 = null;
    var var125 = null;
    var var126 = null;
    var var127 = null;
    var var128 = null;
    var var129 = null;
    var var130 = null;
    var var131 = null;
    var var132 = null;
    var var133 = null;
    var var134 = null;
    var var135 = null;
    var var136 = null;
    var var137 = null;
    var var138 = null;
    var var139 = null;
    var var140 = null;
    var var141 = null;
    var var142 = null;
    var var143 = null;
    var var144 = null;
    var var145 = null;
    var var146 = null;
    var var147 = null;
    var var148 = null;
    var var149 = null;
    var var150 = .0;
    var var151 = null;
    var var152 = null;
    var var153 = null;
    var var154 = null;
    var var155 = null;
    var var156 = null;
    var var157 = null;
    var var158 = null;
    var var159 = null;
    var var160 = null;
    var var161 = null;
    var0 = this;
    // line number 661
    var1 = 0.0;
    var0.m_mass = var1;
    // line number 662
    var0.m_invMass = 0.0;
    // line number 663
    var0.m_I = 0.0;
    // line number 664
    var0.m_invI = 0.0;
    // line number 665
    var2 = (var0.m_sweep);
    var3 = (var2.localCenter);
    org$jbox2d$common$Vec2.prototype.V$setZero$$.call(var3);
    // line number 668
    var4 = (var0.m_type);
    org$jbox2d$dynamics$BodyType.$i;
    var5 = (org$jbox2d$dynamics$BodyType.STATIC);
    If_41_0: {
     if (var4 == var5) {
      phi9 = var0;
      break If_41_0;
     } else {
      var6 = var0;
      var7 = (var6.m_type);
      var8 = (org$jbox2d$dynamics$BodyType.KINEMATIC);
      if (var7 != var8) {
       // line number 676
       org$jbox2d$dynamics$Body.$i;
       var29 = (org$jbox2d$dynamics$Body.$assertionsDisabled);
       If_125_0: {
        if (var29 != 0) {
         phi34 = var0;
         break If_125_0;
        } else {
         var30 = var0;
         var31 = (var30.m_type);
         var32 = (org$jbox2d$dynamics$BodyType.DYNAMIC);
         if (var31 == var32) {
          phi34 = var0;
          break If_125_0;
         } else {
          var33 = new java$lang$AssertionError();
          java$lang$AssertionError.prototype.V$$init$$$.call(var33);
          throw bytecoder.registerStack(var33, new Error().stack);
         }
        }
       }
       // line number 679
       var35 = phi34;
       var36 = (var35.m_world);
       var37 = (org$jbox2d$dynamics$World.prototype.Lorg$jbox2d$pooling$IWorldPool$$getPool$$.call(var36));
       var38 = (var37.Lorg$jbox2d$common$Vec2$$popVec2$$());
       // line number 680
       org$jbox2d$common$Vec2.prototype.V$setZero$$.call(var38);
       // line number 681
       var39 = phi34;
       var40 = (var39.m_world);
       var41 = (org$jbox2d$dynamics$World.prototype.Lorg$jbox2d$pooling$IWorldPool$$getPool$$.call(var40));
       var42 = (var41.Lorg$jbox2d$common$Vec2$$popVec2$$());
       // line number 682
       var43 = phi34;
       var44 = (var43.pmd);
       // line number 683
       var45 = phi34;
       var46 = (var45.m_fixtureList);
       phi47 = var38;
       phi48 = var42;
       phi49 = var44;
       phi50 = var46;
       L1405549619: while(true) {
        var51 = phi50;
        if (var51 == null) {
         // line number 696
         var79 = phi34;
         var80 = (var79.m_mass);
         var81 = (bytecoder.cmp(var80,0.0)) | 0;
         If_308_0: {
          if (var81 <= 0) {
           // line number 701
           var160 = phi34;
           var160.m_mass = 1.0;
           // line number 702
           var161 = phi34;
           var161.m_invMass = 1.0;
           break If_308_0;
          } else {
           // line number 697
           var82 = phi34;
           var83 = phi34;
           var84 = (var83.m_mass);
           var85 = (1.0 / var84);
           var82.m_invMass = var85;
           // line number 698
           var86 = phi47;
           var87 = phi34;
           var88 = (var87.m_invMass);
           var89 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var86,var88));
           // Here was a goto statement
           break If_308_0;
          }
         }
         // line number 705
         var90 = phi34;
         var91 = (var90.m_I);
         var92 = (bytecoder.cmp(var91,0.0)) | 0;
         If_350_0: {
          If_350_1: {
           if (var92 <= 0) {
            break If_350_1;
           } else {
            var93 = phi34;
            var94 = ((var93.m_flags)) | 0;
            var95 = ((var94 & 16)) | 0;
            if (var95 != 0) {
             break If_350_1;
            } else {
             // line number 707
             var96 = phi34;
             var97 = (var96.m_I);
             var98 = phi34;
             var99 = (var98.m_mass);
             var100 = phi47;
             var101 = phi47;
             org$jbox2d$common$Vec2.$i;
             var102 = (org$jbox2d$common$Vec2.F$dot$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var100,var101));
             var103 = (var99 * var102);
             var104 = (var97 - var103);
             var96.m_I = var104;
             // line number 708
             var105 = (org$jbox2d$dynamics$Body.$assertionsDisabled);
             If_399_0: {
              if (var105 != 0) {
               break If_399_0;
              } else {
               var106 = phi34;
               var107 = (var106.m_I);
               var108 = (bytecoder.cmp(var107,0.0)) | 0;
               if (var108 > 0) {
                break If_399_0;
               } else {
                var109 = new java$lang$AssertionError();
                java$lang$AssertionError.prototype.V$$init$$$.call(var109);
                throw bytecoder.registerStack(var109, new Error().stack);
               }
              }
             }
             // line number 709
             var110 = phi34;
             var111 = phi34;
             var112 = (var111.m_I);
             var113 = (1.0 / var112);
             var110.m_invI = var113;
             // Here was a goto statement
             break If_350_0;
            }
           }
          }
          // line number 711
          var158 = phi34;
          var158.m_I = 0.0;
          // line number 712
          var159 = phi34;
          var159.m_invI = 0.0;
          break If_350_0;
         }
         // line number 715
         var114 = phi34;
         var115 = (var114.m_world);
         var116 = (org$jbox2d$dynamics$World.prototype.Lorg$jbox2d$pooling$IWorldPool$$getPool$$.call(var115));
         var117 = (var116.Lorg$jbox2d$common$Vec2$$popVec2$$());
         // line number 717
         var118 = phi34;
         var119 = (var118.m_sweep);
         var120 = (var119.c);
         var121 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var117,var120));
         // line number 718
         var122 = phi34;
         var123 = (var122.m_sweep);
         var124 = (var123.localCenter);
         var125 = phi47;
         var126 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var124,var125));
         // line number 720
         var127 = phi34;
         var128 = (var127.m_xf);
         var129 = phi34;
         var130 = (var129.m_sweep);
         var131 = (var130.localCenter);
         var132 = phi34;
         var133 = (var132.m_sweep);
         var134 = (var133.c0);
         org$jbox2d$common$Transform.$i;
         org$jbox2d$common$Transform.V$mulToOutUnsafe$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var128,var131,var134);
         // line number 721
         var135 = phi34;
         var136 = (var135.m_sweep);
         var137 = (var136.c);
         var138 = phi34;
         var139 = (var138.m_sweep);
         var140 = (var139.c0);
         var141 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var137,var140));
         // line number 725
         var142 = phi48;
         var143 = phi34;
         var144 = (var143.m_sweep);
         var145 = (var144.c);
         var146 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var142,var145));
         var147 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var146,var117));
         // line number 727
         var148 = var117;
         // line number 728
         var149 = phi34;
         var150 = (var149.m_angularVelocity);
         var151 = phi48;
         org$jbox2d$common$Vec2.$i;
         org$jbox2d$common$Vec2.V$crossToOutUnsafe$F$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var150,var151,var148);
         // line number 729
         var152 = phi34;
         var153 = (var152.m_linearVelocity);
         var154 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var153,var148));
         // line number 731
         var155 = phi34;
         var156 = (var155.m_world);
         var157 = (org$jbox2d$dynamics$World.prototype.Lorg$jbox2d$pooling$IWorldPool$$getPool$$.call(var156));
         var157.V$pushVec2$I(3);
         // line number 732
         return;
        } else {
         // line number 684
         var52 = phi50;
         var53 = (var52.m_density);
         var54 = (bytecoder.cmp(var53,0.0)) | 0;
         If_212_0: {
          if (var54 != 0) {
           // line number 687
           var57 = phi50;
           var58 = phi49;
           org$jbox2d$dynamics$Fixture.prototype.V$getMassData$Lorg$jbox2d$collision$shapes$MassData$.call(var57,var58);
           // line number 688
           var59 = phi34;
           var60 = (var59.m_mass);
           var61 = phi49;
           var62 = (var61.mass);
           var63 = (var60 + var62);
           var59.m_mass = var63;
           // line number 690
           var64 = phi48;
           var65 = phi49;
           var66 = (var65.center);
           var67 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var64,var66));
           var68 = phi49;
           var69 = (var68.mass);
           var70 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var67,var69));
           // line number 691
           var71 = phi47;
           var72 = phi48;
           var73 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var71,var72));
           // line number 692
           var74 = phi34;
           var75 = (var74.m_I);
           var76 = phi49;
           var77 = (var76.I);
           var78 = (var75 + var77);
           var74.m_I = var78;
           break If_212_0;
          } else {
           // line number 685
           // Here was a goto statement
           break If_212_0;
          }
         }
         // line number 683
         var55 = phi50;
         var56 = (var55.m_next);
         // Here was a goto statement
         phi50 = var56;
         continue L1405549619;
        }
       }
      } else {
       phi9 = var0;
       break If_41_0;
      }
     }
    }
    // line number 670
    var10 = phi9;
    var11 = (var10.m_sweep);
    var12 = (var11.c0);
    var13 = phi9;
    var14 = (var13.m_xf);
    var15 = (var14.p);
    var16 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var12,var15));
    // line number 671
    var17 = phi9;
    var18 = (var17.m_sweep);
    var19 = (var18.c);
    var20 = phi9;
    var21 = (var20.m_xf);
    var22 = (var21.p);
    var23 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var19,var22));
    // line number 672
    var24 = phi9;
    var25 = (var24.m_sweep);
    var26 = phi9;
    var27 = (var26.m_sweep);
    var28 = (var27.a);
    var25.a0 = var28;
    // line number 673
    return;
  }

  Lorg$jbox2d$common$Vec2$$getWorldCenter$$() {
    // source file is Body.java
    var var0 = null;
    var var1 = null;
    // line number 367
    var0 = (this.m_sweep);
    var1 = (var0.c);
    return var1;
  }

  Lorg$jbox2d$common$Vec2$$getLocalPoint$Lorg$jbox2d$common$Vec2$(arg0) {
    // source file is Body.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    // line number 777
    org$jbox2d$common$Vec2.$i;
    var1 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var1);
    // line number 778
    var2 = var0;
    org$jbox2d$dynamics$Body.prototype.V$getLocalPointToOut$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$.call(this,var2,var1);
    // line number 779
    return var1;
  }

  V$getLocalPointToOut$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(arg0,arg1) {
    // source file is Body.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    // line number 783
    var1 = (this.m_xf);
    var2 = arg1;
    org$jbox2d$common$Transform.$i;
    org$jbox2d$common$Transform.V$mulTransToOut$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var1,var0,var2);
    // line number 784
    return;
  }

  Lorg$jbox2d$common$Transform$$getTransform$$() {
    // source file is Body.java
    var var0 = null;
    // line number 342
    var0 = (this.m_xf);
    return var0;
  }

  Lorg$jbox2d$dynamics$contacts$ContactEdge$$getContactList$$() {
    // source file is Body.java
    var var0 = null;
    // line number 1083
    var0 = (this.m_contactList);
    return var0;
  }

  V$applyTorque$F(arg0) {
    // source file is Body.java
    var var0 = .0;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var phi5 = null;
    var phi6 = .0;
    var var7 = null;
    var var8 = .0;
    var var9 = .0;
    var var10 = .0;
    var0 = arg0;
    // line number 500
    var1 = (this.m_type);
    org$jbox2d$dynamics$BodyType.$i;
    var2 = (org$jbox2d$dynamics$BodyType.DYNAMIC);
    if (var1 == var2) {
     // line number 504
     var3 = (org$jbox2d$dynamics$Body.prototype.Z$isAwake$$.call(this));
     If_26_0: {
      if (var3 != 0) {
       phi5 = this;
       phi6 = var0;
       break If_26_0;
      } else {
       // line number 505
       var4 = (1) | 0;
       org$jbox2d$dynamics$Body.prototype.V$setAwake$Z.call(this,var4);
       phi5 = this;
       phi6 = var0;
       break If_26_0;
      }
     }
     // line number 508
     var7 = phi5;
     var8 = (var7.m_torque);
     var9 = phi6;
     var10 = (var8 + var9);
     var7.m_torque = var10;
     // line number 509
     return;
    } else {
     // line number 501
     return;
    }
  }

  Z$isAwake$$() {
    // source file is Body.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var phi3 = null;
    var phi4 = 0;
    // line number 981
    var0 = ((this.m_flags)) | 0;
    var1 = ((var0 & 2)) | 0;
    If_12_0: {
     if (var1 != 2) {
      phi3 = this;
      phi4 = (0) | 0;
      break If_12_0;
     } else {
      var2 = (1) | 0;
      // Here was a goto statement
      phi3 = this;
      phi4 = (var2) | 0;
      break If_12_0;
     }
    }
    return phi4;
  }

  V$setAwake$Z(arg0) {
    // source file is Body.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var var6 = null;
    var phi7 = null;
    var phi8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = 0;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var0 = arg0;
    // line number 960
    If_7_0: {
     if (var0 == 0) {
      // line number 966
      var9 = this;
      var10 = ((var9.m_flags)) | 0;
      var11 = ((var10 & -3)) | 0;
      var9.m_flags = var11;
      // line number 967
      var12 = this;
      var12.m_sleepTime = 0.0;
      // line number 968
      var13 = (this.m_linearVelocity);
      org$jbox2d$common$Vec2.prototype.V$setZero$$.call(var13);
      // line number 969
      var14 = this;
      var14.m_angularVelocity = 0.0;
      // line number 970
      var15 = (this.m_force);
      org$jbox2d$common$Vec2.prototype.V$setZero$$.call(var15);
      // line number 971
      var16 = this;
      var16.m_torque = 0.0;
      phi7 = this;
      phi8 = var0;
      break If_7_0;
     } else {
      // line number 961
      var1 = ((this.m_flags)) | 0;
      var2 = ((var1 & 2)) | 0;
      if (var2 != 0) {
       phi7 = this;
       phi8 = var0;
       break If_7_0;
      } else {
       // line number 962
       var3 = this;
       var4 = ((var3.m_flags)) | 0;
       var5 = ((var4 | 2)) | 0;
       var3.m_flags = var5;
       // line number 963
       var6 = this;
       var6.m_sleepTime = 0.0;
       // Here was a goto statement
       phi7 = this;
       phi8 = var0;
       break If_7_0;
      }
     }
    }
    // line number 973
    return;
  }

  Z$shouldCollide$Lorg$jbox2d$dynamics$Body$(arg0) {
    // source file is Body.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var phi6 = null;
    var phi7 = null;
    var var8 = null;
    var var9 = null;
    var phi10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = 0;
    var var18 = null;
    var var19 = null;
    var0 = arg0;
    // line number 1156
    var1 = (this.m_type);
    org$jbox2d$dynamics$BodyType.$i;
    var2 = (org$jbox2d$dynamics$BodyType.DYNAMIC);
    If_15_0: {
     if (var1 == var2) {
      phi6 = this;
      phi7 = var0;
      break If_15_0;
     } else {
      var3 = var0;
      var4 = (var3.m_type);
      var5 = (org$jbox2d$dynamics$BodyType.DYNAMIC);
      if (var4 == var5) {
       phi6 = this;
       phi7 = var0;
       break If_15_0;
      } else {
       // line number 1157
       return 0;
      }
     }
    }
    // line number 1161
    var8 = phi6;
    var9 = (var8.m_jointList);
    phi10 = var9;
    L732693459: while(true) {
     var11 = phi10;
     if (var11 == null) {
      // line number 1169
      return 1;
     } else {
      // line number 1162
      var12 = phi10;
      var13 = (var12.other);
      var14 = phi7;
      If_58_0: {
       if (var13 != var14) {
        break If_58_0;
       } else {
        // line number 1163
        var15 = phi10;
        var16 = (var15.joint);
        var17 = (org$jbox2d$dynamics$joints$Joint.prototype.Z$getCollideConnected$$.call(var16));
        if (var17 != 0) {
         break If_58_0;
        } else {
         // line number 1164
         return 0;
        }
       }
      }
      // line number 1161
      var18 = phi10;
      var19 = (var18.next);
      // Here was a goto statement
      phi10 = var19;
      continue L732693459;
     }
    }
  }

  Z$isActive$$() {
    // source file is Body.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var phi3 = null;
    var phi4 = 0;
    // line number 1039
    var0 = ((this.m_flags)) | 0;
    var1 = ((var0 & 32)) | 0;
    If_12_0: {
     if (var1 != 32) {
      phi3 = this;
      phi4 = (0) | 0;
      break If_12_0;
     } else {
      var2 = (1) | 0;
      // Here was a goto statement
      phi3 = this;
      phi4 = (var2) | 0;
      break If_12_0;
     }
    }
    return phi4;
  }

  Lorg$jbox2d$dynamics$BodyType$$getType$$() {
    // source file is Body.java
    var var0 = null;
    // line number 862
    var0 = (this.m_type);
    return var0;
  }

  V$synchronizeTransform$$() {
    // source file is Body.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = .0;
    var var4 = .0;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = .0;
    var var9 = .0;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = .0;
    var var19 = .0;
    var var20 = .0;
    var var21 = .0;
    var var22 = .0;
    var var23 = .0;
    var var24 = .0;
    var var25 = .0;
    var var26 = .0;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = null;
    var var31 = .0;
    var var32 = .0;
    var var33 = .0;
    var var34 = .0;
    var var35 = .0;
    var var36 = .0;
    var var37 = .0;
    var var38 = .0;
    var var39 = .0;
    // line number 1139
    var0 = (this.m_xf);
    var1 = (var0.q);
    var2 = (this.m_sweep);
    var3 = (var2.a);
    org$jbox2d$common$MathUtils.$i;
    var4 = (org$jbox2d$common$MathUtils.F$sin$F(var3));
    var1.s = var4;
    // line number 1140
    var5 = (this.m_xf);
    var6 = (var5.q);
    var7 = (this.m_sweep);
    var8 = (var7.a);
    var9 = (org$jbox2d$common$MathUtils.F$cos$F(var8));
    var6.c = var9;
    // line number 1141
    var10 = (this.m_xf);
    var11 = (var10.q);
    // line number 1142
    var12 = (this.m_sweep);
    var13 = (var12.localCenter);
    // line number 1143
    var14 = (this.m_xf);
    var15 = (var14.p);
    var16 = (this.m_sweep);
    var17 = (var16.c);
    var18 = (var17.x);
    var19 = (var11.c);
    var20 = (var13.x);
    var21 = (var19 * var20);
    var22 = (var18 - var21);
    var23 = (var11.s);
    var24 = (var13.y);
    var25 = (var23 * var24);
    var26 = (var22 + var25);
    var15.x = var26;
    // line number 1144
    var27 = (this.m_xf);
    var28 = (var27.p);
    var29 = (this.m_sweep);
    var30 = (var29.c);
    var31 = (var30.y);
    var32 = (var11.s);
    var33 = (var13.x);
    var34 = (var32 * var33);
    var35 = (var31 - var34);
    var36 = (var11.c);
    var37 = (var13.y);
    var38 = (var36 * var37);
    var39 = (var35 - var38);
    var28.y = var39;
    // line number 1145
    return;
  }

  Lorg$jbox2d$dynamics$Body$$getNext$$() {
    // source file is Body.java
    var var0 = null;
    // line number 1088
    var0 = (this.m_next);
    return var0;
  }

  V$synchronizeFixtures$$() {
    // source file is Body.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = .0;
    var var4 = .0;
    var var5 = null;
    var var6 = null;
    var var7 = .0;
    var var8 = .0;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = .0;
    var var13 = null;
    var var14 = .0;
    var var15 = null;
    var var16 = null;
    var var17 = .0;
    var var18 = .0;
    var var19 = .0;
    var var20 = null;
    var var21 = .0;
    var var22 = null;
    var var23 = null;
    var var24 = .0;
    var var25 = .0;
    var var26 = .0;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = .0;
    var var31 = null;
    var var32 = .0;
    var var33 = null;
    var var34 = null;
    var var35 = .0;
    var var36 = .0;
    var var37 = .0;
    var var38 = null;
    var var39 = .0;
    var var40 = null;
    var var41 = null;
    var var42 = .0;
    var var43 = .0;
    var var44 = .0;
    var var45 = null;
    var phi46 = null;
    var phi47 = null;
    var phi48 = null;
    var var49 = null;
    var var50 = null;
    var var51 = null;
    var var52 = null;
    var var53 = null;
    var var54 = null;
    var var55 = null;
    var var56 = null;
    var var57 = null;
    var var58 = null;
    var var59 = null;
    // line number 1114
    var0 = (this.pxf);
    // line number 1121
    var1 = (var0.q);
    var2 = (this.m_sweep);
    var3 = (var2.a0);
    org$jbox2d$common$MathUtils.$i;
    var4 = (org$jbox2d$common$MathUtils.F$sin$F(var3));
    var1.s = var4;
    // line number 1122
    var5 = (var0.q);
    var6 = (this.m_sweep);
    var7 = (var6.a0);
    var8 = (org$jbox2d$common$MathUtils.F$cos$F(var7));
    var5.c = var8;
    // line number 1123
    var9 = (var0.p);
    var10 = (this.m_sweep);
    var11 = (var10.c0);
    var12 = (var11.x);
    var13 = (var0.q);
    var14 = (var13.c);
    var15 = (this.m_sweep);
    var16 = (var15.localCenter);
    var17 = (var16.x);
    var18 = (var14 * var17);
    var19 = (var12 - var18);
    var20 = (var0.q);
    var21 = (var20.s);
    var22 = (this.m_sweep);
    var23 = (var22.localCenter);
    var24 = (var23.y);
    var25 = (var21 * var24);
    var26 = (var19 + var25);
    var9.x = var26;
    // line number 1124
    var27 = (var0.p);
    var28 = (this.m_sweep);
    var29 = (var28.c0);
    var30 = (var29.y);
    var31 = (var0.q);
    var32 = (var31.s);
    var33 = (this.m_sweep);
    var34 = (var33.localCenter);
    var35 = (var34.x);
    var36 = (var32 * var35);
    var37 = (var30 - var36);
    var38 = (var0.q);
    var39 = (var38.c);
    var40 = (this.m_sweep);
    var41 = (var40.localCenter);
    var42 = (var41.y);
    var43 = (var39 * var42);
    var44 = (var37 - var43);
    var27.y = var44;
    // line number 1127
    var45 = (this.m_fixtureList);
    phi46 = this;
    phi47 = var0;
    phi48 = var45;
    L553809368: while(true) {
     var49 = phi48;
     if (var49 == null) {
      // line number 1130
      return;
     } else {
      // line number 1128
      var50 = phi48;
      var51 = phi46;
      var52 = (var51.m_world);
      var53 = (var52.m_contactManager);
      var54 = (var53.m_broadPhase);
      var55 = phi47;
      var56 = phi46;
      var57 = (var56.m_xf);
      org$jbox2d$dynamics$Fixture.prototype.V$synchronize$Lorg$jbox2d$collision$broadphase$BroadPhase$$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$common$Transform$.call(var50,var54,var55,var57);
      // line number 1127
      var58 = phi48;
      var59 = (var58.m_next);
      // Here was a goto statement
      phi48 = var59;
      continue L553809368;
     }
    }
  }

  Z$isBullet$$() {
    // source file is Body.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var phi3 = null;
    var phi4 = 0;
    // line number 918
    var0 = ((this.m_flags)) | 0;
    var1 = ((var0 & 8)) | 0;
    If_12_0: {
     if (var1 != 8) {
      phi3 = this;
      phi4 = (0) | 0;
      break If_12_0;
     } else {
      var2 = (1) | 0;
      // Here was a goto statement
      phi3 = this;
      phi4 = (var2) | 0;
      break If_12_0;
     }
    }
    return phi4;
  }

  V$advance$F(arg0) {
    // source file is Body.java
    var var0 = .0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = .0;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = .0;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var0 = arg0;
    // line number 1174
    var1 = (this.m_sweep);
    org$jbox2d$common$Sweep.prototype.V$advance$F.call(var1,var0);
    // line number 1175
    var2 = (this.m_sweep);
    var3 = (var2.c);
    var4 = (this.m_sweep);
    var5 = (var4.c0);
    var6 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var3,var5));
    // line number 1176
    var7 = (this.m_sweep);
    var8 = (this.m_sweep);
    var9 = (var8.a0);
    var7.a = var9;
    // line number 1177
    var10 = (this.m_xf);
    var11 = (var10.q);
    var12 = (this.m_sweep);
    var13 = (var12.a);
    var14 = (org$jbox2d$common$Rot.prototype.Lorg$jbox2d$common$Rot$$set$F.call(var11,var13));
    // line number 1179
    var15 = (this.m_xf);
    var16 = (var15.q);
    var17 = (this.m_sweep);
    var18 = (var17.localCenter);
    var19 = (this.m_xf);
    var20 = (var19.p);
    org$jbox2d$common$Rot.$i;
    org$jbox2d$common$Rot.V$mulToOutUnsafe$Lorg$jbox2d$common$Rot$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var16,var18,var20);
    // line number 1180
    var21 = (this.m_xf);
    var22 = (var21.p);
    var23 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var22,-1.0));
    var24 = (this.m_sweep);
    var25 = (var24.c);
    var26 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var23,var25));
    // line number 1181
    return;
  }

  Lorg$jbox2d$common$Vec2$$getPosition$$() {
    // source file is Body.java
    var var0 = null;
    var var1 = null;
    // line number 351
    var0 = (this.m_xf);
    var1 = (var0.p);
    return var1;
  }

  F$getAngle$$() {
    // source file is Body.java
    var var0 = null;
    var var1 = .0;
    // line number 360
    var0 = (this.m_sweep);
    var1 = (var0.a);
    return var1;
  }

  Lorg$jbox2d$dynamics$Fixture$$getFixtureList$$() {
    // source file is Body.java
    var var0 = null;
    // line number 1068
    var0 = (this.m_fixtureList);
    return var0;
  }

  F$getMass$$() {
    // source file is Body.java
    var var0 = .0;
    // line number 564
    var0 = (this.m_mass);
    return var0;
  }
}


class org$jbox2d$collision$AABB extends java$lang$Object {
  nativeObject = null;

  lowerBound = null;
  upperBound = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$collision$AABB,[org$jbox2d$collision$AABB,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is AABB.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    // line number 42
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 43
    var0 = this;
    org$jbox2d$common$Vec2.$i;
    var1 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var1);
    var0.lowerBound = var1;
    // line number 44
    var2 = this;
    var3 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var3);
    var2.upperBound = var3;
    // line number 45
    return;
  }

  F$getPerimeter$$() {
    // source file is AABB.java
    var var0 = null;
    var var1 = .0;
    var var2 = null;
    var var3 = .0;
    var var4 = .0;
    var var5 = null;
    var var6 = .0;
    var var7 = .0;
    var var8 = null;
    var var9 = .0;
    var var10 = .0;
    var var11 = .0;
    // line number 156
    var0 = (this.upperBound);
    var1 = (var0.x);
    var2 = (this.lowerBound);
    var3 = (var2.x);
    var4 = (var1 - var3);
    var5 = (this.upperBound);
    var6 = (var5.y);
    var7 = (var4 + var6);
    var8 = (this.lowerBound);
    var9 = (var8.y);
    var10 = (var7 - var9);
    var11 = (2.0 * var10);
    return var11;
  }

  V$combine$Lorg$jbox2d$collision$AABB$$Lorg$jbox2d$collision$AABB$(arg0,arg1) {
    // source file is AABB.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = .0;
    var var4 = null;
    var var5 = .0;
    var var6 = 0;
    var var7 = null;
    var var8 = null;
    var var9 = .0;
    var phi10 = null;
    var phi11 = null;
    var phi12 = null;
    var phi13 = null;
    var phi14 = .0;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = .0;
    var var20 = null;
    var var21 = null;
    var var22 = .0;
    var var23 = 0;
    var var24 = null;
    var var25 = null;
    var var26 = .0;
    var phi27 = null;
    var phi28 = .0;
    var var29 = null;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = .0;
    var var34 = null;
    var var35 = null;
    var var36 = .0;
    var var37 = 0;
    var var38 = null;
    var var39 = null;
    var var40 = .0;
    var phi41 = null;
    var phi42 = .0;
    var var43 = null;
    var var44 = null;
    var var45 = null;
    var var46 = null;
    var var47 = .0;
    var var48 = null;
    var var49 = null;
    var var50 = .0;
    var var51 = 0;
    var var52 = null;
    var var53 = null;
    var var54 = .0;
    var phi55 = null;
    var phi56 = .0;
    var var57 = null;
    var var58 = null;
    var var59 = .0;
    var var60 = null;
    var var61 = null;
    var var62 = .0;
    var var63 = null;
    var var64 = null;
    var var65 = .0;
    var var66 = null;
    var var67 = .0;
    var0 = arg0;
    // line number 144
    var1 = (this.lowerBound);
    var2 = (var0.lowerBound);
    var3 = (var2.x);
    var4 = (arg1.lowerBound);
    var5 = (var4.x);
    var6 = (bytecoder.cmp(var3,var5)) | 0;
    If_26_0: {
     if (var6 >= 0) {
      var66 = (arg1.lowerBound);
      var67 = (var66.x);
      phi10 = this;
      phi11 = var0;
      phi12 = arg1;
      phi13 = var1;
      phi14 = var67;
      break If_26_0;
     } else {
      var7 = var0;
      var8 = (var7.lowerBound);
      var9 = (var8.x);
      // Here was a goto statement
      phi10 = this;
      phi11 = var0;
      phi12 = arg1;
      phi13 = var1;
      phi14 = var9;
      break If_26_0;
     }
    }
    phi13.x = phi14;
    // line number 145
    var15 = phi10;
    var16 = (var15.lowerBound);
    var17 = phi11;
    var18 = (var17.lowerBound);
    var19 = (var18.y);
    var20 = phi12;
    var21 = (var20.lowerBound);
    var22 = (var21.y);
    var23 = (bytecoder.cmp(var19,var22)) | 0;
    If_72_0: {
     if (var23 >= 0) {
      var63 = phi12;
      var64 = (var63.lowerBound);
      var65 = (var64.y);
      phi27 = var16;
      phi28 = var65;
      break If_72_0;
     } else {
      var24 = phi11;
      var25 = (var24.lowerBound);
      var26 = (var25.y);
      // Here was a goto statement
      phi27 = var16;
      phi28 = var26;
      break If_72_0;
     }
    }
    phi27.y = phi28;
    // line number 146
    var29 = phi10;
    var30 = (var29.upperBound);
    var31 = phi11;
    var32 = (var31.upperBound);
    var33 = (var32.x);
    var34 = phi12;
    var35 = (var34.upperBound);
    var36 = (var35.x);
    var37 = (bytecoder.cmp(var33,var36)) | 0;
    If_115_0: {
     if (var37 <= 0) {
      var60 = phi12;
      var61 = (var60.upperBound);
      var62 = (var61.x);
      phi41 = var30;
      phi42 = var62;
      break If_115_0;
     } else {
      var38 = phi11;
      var39 = (var38.upperBound);
      var40 = (var39.x);
      // Here was a goto statement
      phi41 = var30;
      phi42 = var40;
      break If_115_0;
     }
    }
    phi41.x = phi42;
    // line number 147
    var43 = phi10;
    var44 = (var43.upperBound);
    var45 = phi11;
    var46 = (var45.upperBound);
    var47 = (var46.y);
    var48 = phi12;
    var49 = (var48.upperBound);
    var50 = (var49.y);
    var51 = (bytecoder.cmp(var47,var50)) | 0;
    If_158_0: {
     if (var51 <= 0) {
      var57 = phi12;
      var58 = (var57.upperBound);
      var59 = (var58.y);
      phi55 = var44;
      phi56 = var59;
      break If_158_0;
     } else {
      var52 = phi11;
      var53 = (var52.upperBound);
      var54 = (var53.y);
      // Here was a goto statement
      phi55 = var44;
      phi56 = var54;
      break If_158_0;
     }
    }
    phi55.y = phi56;
    // line number 148
    return;
  }

  static Z$testOverlap$Lorg$jbox2d$collision$AABB$$Lorg$jbox2d$collision$AABB$(arg0,arg1) {
    // source file is AABB.java
    var var0 = null;
    var var1 = null;
    var var2 = .0;
    var var3 = null;
    var var4 = .0;
    var var5 = .0;
    var var6 = 0;
    var var7 = null;
    var var8 = null;
    var var9 = .0;
    var var10 = null;
    var var11 = .0;
    var var12 = .0;
    var var13 = 0;
    var phi14 = null;
    var phi15 = null;
    var var16 = null;
    var var17 = .0;
    var var18 = null;
    var var19 = .0;
    var var20 = .0;
    var var21 = 0;
    var var22 = null;
    var var23 = null;
    var var24 = .0;
    var var25 = null;
    var var26 = .0;
    var var27 = .0;
    var var28 = 0;
    var phi29 = null;
    var phi30 = null;
    var0 = arg1;
    // line number 310
    var1 = (var0.lowerBound);
    var2 = (var1.x);
    var3 = (arg0.upperBound);
    var4 = (var3.x);
    var5 = (var2 - var4);
    var6 = (bytecoder.cmp(var5,0.0)) | 0;
    If_26_0: {
     if (var6 > 0) {
      phi14 = arg0;
      phi15 = var0;
      break If_26_0;
     } else {
      var7 = var0;
      var8 = (var7.lowerBound);
      var9 = (var8.y);
      var10 = (arg0.upperBound);
      var11 = (var10.y);
      var12 = (var9 - var11);
      var13 = (bytecoder.cmp(var12,0.0)) | 0;
      if (var13 <= 0) {
       // line number 314
       var16 = (arg0.lowerBound);
       var17 = (var16.x);
       var18 = (var0.upperBound);
       var19 = (var18.x);
       var20 = (var17 - var19);
       var21 = (bytecoder.cmp(var20,0.0)) | 0;
       If_82_0: {
        if (var21 > 0) {
         phi29 = arg0;
         phi30 = var0;
         break If_82_0;
        } else {
         var22 = arg0;
         var23 = (var22.lowerBound);
         var24 = (var23.y);
         var25 = (var0.upperBound);
         var26 = (var25.y);
         var27 = (var24 - var26);
         var28 = (bytecoder.cmp(var27,0.0)) | 0;
         if (var28 <= 0) {
          // line number 318
          return 1;
         } else {
          phi29 = arg0;
          phi30 = var0;
          break If_82_0;
         }
        }
       }
       // line number 315
       return 0;
      } else {
       phi14 = arg0;
       phi15 = var0;
       break If_26_0;
      }
     }
    }
    // line number 311
    return 0;
  }

  Ljava$lang$String$$toString$$() {
    // source file is AABB.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    // line number 323
    var0 = new java$lang$StringBuilder();
    java$lang$StringBuilder.prototype.V$$init$$$.call(var0);
    var1 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var0,bytecoder.stringconstants[135]));
    var2 = (this.lowerBound);
    var3 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$Object$.call(var1,var2));
    var4 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var3,bytecoder.stringconstants[136]));
    var5 = (this.upperBound);
    var6 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$Object$.call(var4,var5));
    var7 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var6,bytecoder.stringconstants[109]));
    var8 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var7));
    // line number 324
    return var8;
  }
}


class java$nio$charset$CoderResult$Cache extends java$lang$Object {
  nativeObject = null;

  unmappable = null;
  malformed = null;
  static INSTANCE = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$nio$charset$CoderResult$Cache,[java$nio$charset$CoderResult$Cache,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is CoderResult.java
    var var0 = null;
    // line number 194
    java$nio$charset$CoderResult$Cache.$i;
    var0 = new java$nio$charset$CoderResult$Cache();
    java$nio$charset$CoderResult$Cache.prototype.V$$init$$$.call(var0);
    java$nio$charset$CoderResult$Cache.INSTANCE = var0;
    return;
  }

  V$$init$$$() {
    // source file is CoderResult.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    // line number 195
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 197
    var0 = this;
    var1 = new java$util$concurrent$ConcurrentHashMap();
    java$util$concurrent$ConcurrentHashMap.prototype.V$$init$$$.call(var1);
    var0.unmappable = var1;
    // line number 198
    var2 = this;
    var3 = new java$util$concurrent$ConcurrentHashMap();
    java$util$concurrent$ConcurrentHashMap.prototype.V$$init$$$.call(var3);
    var2.malformed = var3;
    // line number 195
    return;
  }
}


class java$lang$AutoCloseable extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$AutoCloseable,[java$lang$AutoCloseable,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class org$jbox2d$collision$TimeOfImpact$TOIOutput extends java$lang$Object {
  nativeObject = null;

  state = null;
  t = 0.0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$collision$TimeOfImpact$TOIOutput,[org$jbox2d$collision$TimeOfImpact$TOIOutput,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is TimeOfImpact.java
    // line number 76
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class java$util$Map extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$Map,[java$util$Map,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  Ljava$lang$Object$$computeIfAbsent$Ljava$lang$Object$$Ljava$util$function$Function$(arg0,arg1) {
    // source file is Map.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var phi9 = null;
    var phi10 = null;
    var phi11 = null;
    var phi12 = null;
    var var13 = null;
    var0 = arg0;
    // line number 1048
    var1 = (java$util$Objects.Ljava$lang$Object$$requireNonNull$Ljava$lang$Object$(arg1));
    // line number 1050
    var2 = (this.Ljava$lang$Object$$get$Ljava$lang$Object$(var0));
    var3 = var2;
    If_21_0: {
     if (var2 != null) {
      phi9 = this;
      phi10 = var0;
      phi11 = arg1;
      phi12 = var3;
      break If_21_0;
     } else {
      // line number 1052
      var4 = var0;
      var5 = (arg1.Ljava$lang$Object$$apply$Ljava$lang$Object$(var4));
      var6 = var5;
      if (var5 == null) {
       phi9 = this;
       phi10 = var0;
       phi11 = arg1;
       phi12 = var3;
       break If_21_0;
      } else {
       // line number 1053
       var7 = var0;
       var8 = (this.Ljava$lang$Object$$put$Ljava$lang$Object$$Ljava$lang$Object$(var7,var6));
       // line number 1054
       return var6;
      }
     }
    }
    // line number 1058
    var13 = phi12;
    return var13;
  }
}


class org$jbox2d$collision$Collision$TempPolygon extends java$lang$Object {
  nativeObject = null;

  vertices = null;
  normals = null;
  count = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$collision$Collision$TempPolygon,[org$jbox2d$collision$Collision$TempPolygon,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is Collision.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var phi4 = null;
    var phi5 = 0;
    var var6 = 0;
    var var7 = null;
    var var8 = null;
    var var9 = 0;
    var var10 = null;
    var var11 = null;
    var var12 = 0;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = 0;
    var var17 = null;
    // line number 1062
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 1058
    var0 = this;
    var1 = bytecoder.newarray((8),null);
    var0.vertices = var1;
    // line number 1059
    var2 = this;
    var3 = bytecoder.newarray((8),null);
    var2.normals = var3;
    // line number 1063
    phi4 = this;
    phi5 = (0) | 0;
    L2093057246: while(true) {
     var6 = (phi5) | 0;
     var7 = phi4;
     var8 = (var7.vertices);
     var9 = (var8.data.length) | 0;
     if (var6 >= var9) {
      // line number 1067
      return;
     } else {
      // line number 1064
      var10 = phi4;
      var11 = (var10.vertices);
      var12 = (phi5) | 0;
      org$jbox2d$common$Vec2.$i;
      var13 = new org$jbox2d$common$Vec2();
      org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var13);
      var11.data[var12] = var13;
      // line number 1065
      var14 = phi4;
      var15 = (var14.normals);
      var16 = (phi5) | 0;
      var17 = new org$jbox2d$common$Vec2();
      org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var17);
      var15.data[var16] = var17;
      // line number 1063
      phi5 = ((phi5 + 1)) | 0;
      // Here was a goto statement
      continue L2093057246;
     }
    }
  }
}


class org$jbox2d$dynamics$contacts$Velocity extends java$lang$Object {
  nativeObject = null;

  v = null;
  w = 0.0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$dynamics$contacts$Velocity,[org$jbox2d$dynamics$contacts$Velocity,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is Velocity.java
    var var0 = null;
    var var1 = null;
    // line number 28
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 29
    var0 = this;
    org$jbox2d$common$Vec2.$i;
    var1 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var1);
    var0.v = var1;
    return;
  }
}


class org$jbox2d$collision$WorldManifold$1 extends java$lang$Object {
  nativeObject = null;

  static $SwitchMap$org$jbox2d$collision$Manifold$ManifoldType = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$collision$WorldManifold$1,[org$jbox2d$collision$WorldManifold$1,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is WorldManifold.java
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var phi3 = null;
    var phi4 = null;
    var phi5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = null;
    var var11 = 0;
    var var12 = null;
    var var13 = null;
    var var14 = 0;
    // line number 65
    org$jbox2d$collision$Manifold$ManifoldType.$i;
    var0 = (org$jbox2d$collision$Manifold$ManifoldType.$Lorg$jbox2d$collision$Manifold$ManifoldType$$values$$());
    var1 = (var0.data.length) | 0;
    var2 = bytecoder.newarray((var1),0);
    org$jbox2d$collision$WorldManifold$1.$i;
    org$jbox2d$collision$WorldManifold$1.$SwitchMap$org$jbox2d$collision$Manifold$ManifoldType = var2;
    TryCatch_17_0: {
     TryCatch_17_1: {
      try {
       var12 = (org$jbox2d$collision$WorldManifold$1.$SwitchMap$org$jbox2d$collision$Manifold$ManifoldType);
       var13 = (org$jbox2d$collision$Manifold$ManifoldType.CIRCLES);
       var14 = ((var13.I$ordinal$$())) | 0;
       var12.data[var14] = 1;
       break TryCatch_17_1;
      } catch (__ex) {
       if (__ex instanceof java$lang$NoSuchFieldError) {
        phi3 = __ex;
        break TryCatch_17_0;
       }
       throw __ex;
      }
     }
     // Here was a goto statement
     break TryCatch_17_0;
    }
    TryCatch_22_0: {
     TryCatch_22_1: {
      try {
       var9 = (org$jbox2d$collision$WorldManifold$1.$SwitchMap$org$jbox2d$collision$Manifold$ManifoldType);
       var10 = (org$jbox2d$collision$Manifold$ManifoldType.FACE_A);
       var11 = ((var10.I$ordinal$$())) | 0;
       var9.data[var11] = 2;
       break TryCatch_22_1;
      } catch (__ex) {
       if (__ex instanceof java$lang$NoSuchFieldError) {
        phi4 = __ex;
        break TryCatch_22_0;
       }
       throw __ex;
      }
     }
     // Here was a goto statement
     phi4 = phi3;
     break TryCatch_22_0;
    }
    TryCatch_27_0: {
     TryCatch_27_1: {
      try {
       var6 = (org$jbox2d$collision$WorldManifold$1.$SwitchMap$org$jbox2d$collision$Manifold$ManifoldType);
       var7 = (org$jbox2d$collision$Manifold$ManifoldType.FACE_B);
       var8 = ((var7.I$ordinal$$())) | 0;
       var6.data[var8] = 3;
       break TryCatch_27_1;
      } catch (__ex) {
       if (__ex instanceof java$lang$NoSuchFieldError) {
        phi5 = __ex;
        break TryCatch_27_0;
       }
       throw __ex;
      }
     }
     // Here was a goto statement
     phi5 = phi4;
     break TryCatch_27_0;
    }
    return;
  }
}


class org$jbox2d$dynamics$contacts$ContactEdge extends java$lang$Object {
  nativeObject = null;

  other = null;
  contact = null;
  next = null;
  prev = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$dynamics$contacts$ContactEdge,[org$jbox2d$dynamics$contacts$ContactEdge,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is ContactEdge.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    // line number 35
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 40
    var0 = this;
    var0.other = null;
    // line number 45
    var1 = this;
    var1.contact = null;
    // line number 50
    var2 = this;
    var2.prev = null;
    // line number 55
    var3 = this;
    var3.next = null;
    return;
  }
}


class org$jbox2d$callbacks$ContactListener extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$callbacks$ContactListener,[org$jbox2d$callbacks$ContactListener,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class java$io$Flushable extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$io$Flushable,[java$io$Flushable,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class java$util$function$Function extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$function$Function,[java$util$function$Function,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.Ljava$lang$Object$$apply$Ljava$lang$Object$ = impl;
  }
}


class jdk$internal$access$SharedSecrets extends java$lang$Object {
  nativeObject = null;

  static javaIOPrintStreamAccess = null;
  static javaNioAccess = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(jdk$internal$access$SharedSecrets,[jdk$internal$access$SharedSecrets,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  static V$setJavaIOCPrintStreamAccess$Ljdk$internal$access$JavaIOPrintStreamAccess$(arg0) {
    // source file is SharedSecrets.java
    // line number 297
    jdk$internal$access$SharedSecrets.javaIOPrintStreamAccess = arg0;
    // line number 298
    return;
  }

  static V$setJavaNioAccess$Ljdk$internal$access$JavaNioAccess$(arg0) {
    // source file is SharedSecrets.java
    // line number 256
    jdk$internal$access$SharedSecrets.javaNioAccess = arg0;
    // line number 257
    return;
  }

  V$$init$$$() {
    // source file is SharedSecrets.java
    // line number 57
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class org$jbox2d$pooling$IDynamicStack extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$pooling$IDynamicStack,[org$jbox2d$pooling$IDynamicStack,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class org$jbox2d$dynamics$FixtureDef extends java$lang$Object {
  nativeObject = null;

  shape = null;
  userData = null;
  friction = 0.0;
  restitution = 0.0;
  density = 0.0;
  filter = null;
  isSensor = false;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$dynamics$FixtureDef,[org$jbox2d$dynamics$FixtureDef,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is FixtureDef.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    // line number 73
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 40
    var0 = this;
    var0.shape = null;
    // line number 74
    var1 = this;
    var1.shape = null;
    // line number 75
    var2 = this;
    var2.userData = null;
    // line number 76
    var3 = this;
    var3.friction = 0.2;
    // line number 77
    var4 = this;
    var4.restitution = 0.0;
    // line number 78
    var5 = this;
    var5.density = 0.0;
    // line number 79
    var6 = this;
    var7 = new org$jbox2d$dynamics$Filter();
    org$jbox2d$dynamics$Filter.prototype.V$$init$$$.call(var7);
    var6.filter = var7;
    // line number 80
    var8 = this;
    var8.isSensor = 0;
    // line number 81
    return;
  }
}


class java$lang$ThreadGroup extends java$lang$Object {
  nativeObject = null;

  name = null;
  parent = null;
  static SYSTEM = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$ThreadGroup,[java$lang$ThreadGroup,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is ThreadGroup.java
    var var0 = null;
    // line number 23
    java$lang$ThreadGroup.$i;
    var0 = new java$lang$ThreadGroup();
    java$lang$ThreadGroup.prototype.V$$init$$$.call(var0);
    java$lang$ThreadGroup.SYSTEM = var0;
    return;
  }

  V$$init$$$() {
    // source file is ThreadGroup.java
    var var0 = null;
    var var1 = null;
    // line number 28
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 29
    var0 = this;
    var0.name = bytecoder.stringconstants[42];
    // line number 30
    var1 = this;
    var1.parent = null;
    // line number 31
    return;
  }

  V$$init$$Ljava$lang$ThreadGroup$$Ljava$lang$String$(arg0,arg1) {
    // source file is ThreadGroup.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    // line number 38
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 39
    var1 = this;
    var1.name = arg1;
    // line number 40
    var2 = this;
    var2.parent = var0;
    // line number 41
    return;
  }
}


class java$nio$Buffer extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;
  static UNSAFE = null;
  static SCOPED_MEMORY_ACCESS = null;
  mark = 0;
  position = 0;
  capacity = 0;
  segment = null;
  limit = 0;
  address = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$nio$Buffer,[java$nio$Buffer,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
    this.Z$isReadOnly$$ = impl;
  }

  static V$$clinit$$$() {
    // source file is Buffer.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    // line number 197
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(java$nio$Buffer.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    java$nio$Buffer.$i;
    java$nio$Buffer.$assertionsDisabled = phi2;
    // line number 201
    jdk$internal$misc$Unsafe.$i;
    var3 = (jdk$internal$misc$Unsafe.Ljdk$internal$misc$Unsafe$$getUnsafe$$());
    java$nio$Buffer.UNSAFE = var3;
    // line number 203
    jdk$internal$misc$ScopedMemoryAccess.$i;
    var4 = (jdk$internal$misc$ScopedMemoryAccess.Ljdk$internal$misc$ScopedMemoryAccess$$getScopedMemoryAccess$$());
    java$nio$Buffer.SCOPED_MEMORY_ACCESS = var4;
    // line number 781
    var5 = new java$nio$Buffer$1();
    java$nio$Buffer$1.prototype.V$$init$$$.call(var5);
    jdk$internal$access$SharedSecrets.V$setJavaNioAccess$Ljdk$internal$access$JavaNioAccess$(var5);
    // line number 894
    return;
  }

  static Ljava$lang$IllegalArgumentException$$createCapacityException$I(arg0) {
    // source file is Buffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var phi4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    // line number 283
    java$nio$Buffer.$i;
    var0 = (java$nio$Buffer.$assertionsDisabled);
    If_9_0: {
     if (var0 != 0) {
      phi4 = (arg0) | 0;
      break If_9_0;
     } else {
      var1 = (arg0) | 0;
      if (var1 < 0) {
       phi4 = (arg0) | 0;
       break If_9_0;
      } else {
       var2 = new java$lang$AssertionError();
       var3 = bytecoder.stringconstants[27];
       java$lang$AssertionError.prototype.V$$init$$Ljava$lang$Object$.call(var2,var3);
       throw bytecoder.registerStack(var2, new Error().stack);
      }
     }
    }
    // line number 284
    var5 = new java$lang$IllegalArgumentException();
    var6 = new java$lang$StringBuilder();
    java$lang$StringBuilder.prototype.V$$init$$$.call(var6);
    var7 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var6,bytecoder.stringconstants[28]));
    var8 = (phi4) | 0;
    var9 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var7,var8));
    var10 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var9,bytecoder.stringconstants[29]));
    var11 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var10));
    java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var5,var11);
    return var5;
  }

  V$$init$$I$I$I$I$Ljava$lang$foreign$MemorySegment$(arg0,arg1,arg2,arg3,arg4) {
    // source file is Buffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = 0;
    var var10 = null;
    var var11 = 0;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var phi21 = null;
    var phi22 = 0;
    var phi23 = 0;
    var phi24 = 0;
    var phi25 = 0;
    var phi26 = null;
    var0 = (arg0) | 0;
    var1 = (arg2) | 0;
    var2 = arg4;
    // line number 245
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 213
    var3 = this;
    var3.mark = -1;
    // line number 214
    var4 = this;
    var4.position = 0;
    // line number 246
    if (arg3 >= 0) {
     // line number 248
     var6 = this;
     var6.capacity = arg3;
     // line number 249
     var7 = this;
     var7.segment = var2;
     // line number 250
     var8 = (this.Ljava$nio$Buffer$$limit$I(var1));
     // line number 251
     var9 = (arg1) | 0;
     var10 = (this.Ljava$nio$Buffer$$position$I(var9));
     // line number 252
     If_66_0: {
      if (var0 < 0) {
       phi21 = this;
       phi22 = (var0) | 0;
       phi23 = (arg1) | 0;
       phi24 = (var1) | 0;
       phi25 = (arg3) | 0;
       phi26 = var2;
       break If_66_0;
      } else {
       // line number 253
       var11 = (arg1) | 0;
       if (var0 <= var11) {
        // line number 256
        var20 = this;
        var20.mark = var0;
        phi21 = this;
        phi22 = (var0) | 0;
        phi23 = (arg1) | 0;
        phi24 = (var1) | 0;
        phi25 = (arg3) | 0;
        phi26 = var2;
        break If_66_0;
       } else {
        // line number 254
        var12 = new java$lang$IllegalArgumentException();
        var13 = new java$lang$StringBuilder();
        java$lang$StringBuilder.prototype.V$$init$$$.call(var13);
        var14 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var13,bytecoder.stringconstants[38]));
        var15 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var14,var0));
        var16 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var15,bytecoder.stringconstants[31]));
        var17 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var16,arg1));
        var18 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var17,bytecoder.stringconstants[32]));
        var19 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var18));
        java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var12,var19);
        throw bytecoder.registerStack(var12, new Error().stack);
       }
      }
     }
     // line number 258
     return;
    } else {
     // line number 247
     java$nio$Buffer.$i;
     var5 = (java$nio$Buffer.Ljava$lang$IllegalArgumentException$$createCapacityException$I(arg3));
     throw bytecoder.registerStack(var5, new Error().stack);
    }
  }

  Ljava$nio$Buffer$$limit$I(arg0) {
    // source file is Buffer.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var phi4 = null;
    var phi5 = 0;
    var phi6 = 0;
    var var7 = 0;
    var var8 = 0;
    var phi9 = 0;
    var var10 = 0;
    var var11 = null;
    var var12 = 0;
    var var13 = null;
    var var14 = null;
    var var15 = 0;
    var var16 = null;
    var var17 = 0;
    var var18 = 0;
    var var19 = null;
    var var20 = 0;
    var var21 = null;
    var var22 = 0;
    var var23 = 0;
    var var24 = null;
    var var25 = null;
    var0 = (arg0) | 0;
    // line number 373
    var1 = this;
    var2 = ((var1.capacity)) | 0;
    If_12_0: {
     if (var0 <= var2) {
      phi4 = this;
      phi5 = (var0) | 0;
      phi6 = (0) | 0;
      break If_12_0;
     } else {
      var3 = (1) | 0;
      // Here was a goto statement
      phi4 = this;
      phi5 = (var0) | 0;
      phi6 = (var3) | 0;
      break If_12_0;
     }
    }
    var7 = (phi5) | 0;
    If_25_0: {
     if (var7 >= 0) {
      phi9 = (0) | 0;
      break If_25_0;
     } else {
      var8 = (1) | 0;
      // Here was a goto statement
      phi9 = (var8) | 0;
      break If_25_0;
     }
    }
    var10 = ((phi6 | phi9)) | 0;
    if (var10 == 0) {
     // line number 375
     var14 = phi4;
     var15 = (phi5) | 0;
     var14.limit = var15;
     // line number 376
     var16 = phi4;
     var17 = ((var16.position)) | 0;
     var18 = (phi5) | 0;
     If_68_0: {
      if (var17 <= var18) {
       break If_68_0;
      } else {
       var19 = phi4;
       var20 = (phi5) | 0;
       var19.position = var20;
       break If_68_0;
      }
     }
     // line number 377
     var21 = phi4;
     var22 = ((var21.mark)) | 0;
     var23 = (phi5) | 0;
     If_85_0: {
      if (var22 <= var23) {
       break If_85_0;
      } else {
       var24 = phi4;
       var24.mark = -1;
       break If_85_0;
      }
     }
     // line number 378
     var25 = phi4;
     return var25;
    } else {
     // line number 374
     var11 = phi4;
     var12 = (phi5) | 0;
     var13 = (java$nio$Buffer.prototype.Ljava$lang$IllegalArgumentException$$createLimitException$I.call(var11,var12));
     throw bytecoder.registerStack(var13, new Error().stack);
    }
  }

  Ljava$lang$IllegalArgumentException$$createLimitException$I(arg0) {
    // source file is Buffer.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var phi11 = null;
    var phi12 = 0;
    var phi13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = 0;
    var var17 = 0;
    var var18 = null;
    var var19 = null;
    var phi20 = null;
    var phi21 = 0;
    var phi22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = 0;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var0 = (arg0) | 0;
    // line number 391
    // line number 393
    var1 = this;
    var2 = ((var1.capacity)) | 0;
    If_15_0: {
     if (var0 <= var2) {
      // line number 396
      java$nio$Buffer.$i;
      var16 = (java$nio$Buffer.$assertionsDisabled);
      If_73_0: {
       if (var16 != 0) {
        phi20 = this;
        phi21 = (var0) | 0;
        phi22 = null;
        break If_73_0;
       } else {
        var17 = (var0) | 0;
        if (var17 < 0) {
         phi20 = this;
         phi21 = (var0) | 0;
         phi22 = null;
         break If_73_0;
        } else {
         var18 = new java$lang$AssertionError();
         var19 = bytecoder.stringconstants[33];
         java$lang$AssertionError.prototype.V$$init$$Ljava$lang$Object$.call(var18,var19);
         throw bytecoder.registerStack(var18, new Error().stack);
        }
       }
      }
      // line number 397
      var23 = new java$lang$StringBuilder();
      java$lang$StringBuilder.prototype.V$$init$$$.call(var23);
      var24 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var23,bytecoder.stringconstants[34]));
      var25 = (phi21) | 0;
      var26 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var24,var25));
      var27 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var26,bytecoder.stringconstants[29]));
      var28 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var27));
      phi11 = phi20;
      phi12 = (phi21) | 0;
      phi13 = var28;
      break If_15_0;
     } else {
      // line number 394
      var3 = new java$lang$StringBuilder();
      java$lang$StringBuilder.prototype.V$$init$$$.call(var3);
      var4 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var3,bytecoder.stringconstants[30]));
      var5 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var4,var0));
      var6 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var5,bytecoder.stringconstants[31]));
      var7 = ((this.capacity)) | 0;
      var8 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var6,var7));
      var9 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var8,bytecoder.stringconstants[32]));
      var10 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var9));
      // Here was a goto statement
      phi11 = this;
      phi12 = (var0) | 0;
      phi13 = var10;
      break If_15_0;
     }
    }
    // line number 400
    var14 = new java$lang$IllegalArgumentException();
    var15 = phi13;
    java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var14,var15);
    return var14;
  }

  Ljava$nio$Buffer$$position$I(arg0) {
    // source file is Buffer.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var phi4 = null;
    var phi5 = 0;
    var phi6 = 0;
    var var7 = 0;
    var var8 = 0;
    var phi9 = 0;
    var var10 = 0;
    var var11 = null;
    var var12 = 0;
    var var13 = null;
    var var14 = null;
    var var15 = 0;
    var var16 = 0;
    var var17 = null;
    var var18 = null;
    var var19 = 0;
    var var20 = null;
    var0 = (arg0) | 0;
    // line number 320
    var1 = this;
    var2 = ((var1.limit)) | 0;
    If_12_0: {
     if (var0 <= var2) {
      phi4 = this;
      phi5 = (var0) | 0;
      phi6 = (0) | 0;
      break If_12_0;
     } else {
      var3 = (1) | 0;
      // Here was a goto statement
      phi4 = this;
      phi5 = (var0) | 0;
      phi6 = (var3) | 0;
      break If_12_0;
     }
    }
    var7 = (phi5) | 0;
    If_25_0: {
     if (var7 >= 0) {
      phi9 = (0) | 0;
      break If_25_0;
     } else {
      var8 = (1) | 0;
      // Here was a goto statement
      phi9 = (var8) | 0;
      break If_25_0;
     }
    }
    var10 = ((phi6 | phi9)) | 0;
    if (var10 == 0) {
     // line number 322
     var14 = phi4;
     var15 = ((var14.mark)) | 0;
     var16 = (phi5) | 0;
     If_61_0: {
      if (var15 <= var16) {
       break If_61_0;
      } else {
       var17 = phi4;
       var17.mark = -1;
       break If_61_0;
      }
     }
     // line number 323
     var18 = phi4;
     var19 = (phi5) | 0;
     var18.position = var19;
     // line number 324
     var20 = phi4;
     return var20;
    } else {
     // line number 321
     var11 = phi4;
     var12 = (phi5) | 0;
     var13 = (java$nio$Buffer.prototype.Ljava$lang$IllegalArgumentException$$createPositionException$I.call(var11,var12));
     throw bytecoder.registerStack(var13, new Error().stack);
    }
  }

  Ljava$lang$IllegalArgumentException$$createPositionException$I(arg0) {
    // source file is Buffer.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var phi11 = null;
    var phi12 = 0;
    var phi13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = 0;
    var var17 = 0;
    var var18 = null;
    var var19 = null;
    var phi20 = null;
    var phi21 = 0;
    var phi22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = 0;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var0 = (arg0) | 0;
    // line number 337
    // line number 339
    var1 = this;
    var2 = ((var1.limit)) | 0;
    If_15_0: {
     if (var0 <= var2) {
      // line number 342
      java$nio$Buffer.$i;
      var16 = (java$nio$Buffer.$assertionsDisabled);
      If_73_0: {
       if (var16 != 0) {
        phi20 = this;
        phi21 = (var0) | 0;
        phi22 = null;
        break If_73_0;
       } else {
        var17 = (var0) | 0;
        if (var17 < 0) {
         phi20 = this;
         phi21 = (var0) | 0;
         phi22 = null;
         break If_73_0;
        } else {
         var18 = new java$lang$AssertionError();
         var19 = bytecoder.stringconstants[36];
         java$lang$AssertionError.prototype.V$$init$$Ljava$lang$Object$.call(var18,var19);
         throw bytecoder.registerStack(var18, new Error().stack);
        }
       }
      }
      // line number 343
      var23 = new java$lang$StringBuilder();
      java$lang$StringBuilder.prototype.V$$init$$$.call(var23);
      var24 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var23,bytecoder.stringconstants[37]));
      var25 = (phi21) | 0;
      var26 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var24,var25));
      var27 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var26,bytecoder.stringconstants[29]));
      var28 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var27));
      phi11 = phi20;
      phi12 = (phi21) | 0;
      phi13 = var28;
      break If_15_0;
     } else {
      // line number 340
      var3 = new java$lang$StringBuilder();
      java$lang$StringBuilder.prototype.V$$init$$$.call(var3);
      var4 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var3,bytecoder.stringconstants[35]));
      var5 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var4,var0));
      var6 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var5,bytecoder.stringconstants[31]));
      var7 = ((this.limit)) | 0;
      var8 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var6,var7));
      var9 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var8,bytecoder.stringconstants[32]));
      var10 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var9));
      // Here was a goto statement
      phi11 = this;
      phi12 = (var0) | 0;
      phi13 = var10;
      break If_15_0;
     }
    }
    // line number 346
    var14 = new java$lang$IllegalArgumentException();
    var15 = phi13;
    java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var14,var15);
    return var14;
  }

  I$remaining$$() {
    // source file is Buffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var phi4 = null;
    var phi5 = 0;
    var phi6 = 0;
    // line number 512
    var0 = ((this.limit)) | 0;
    var1 = ((this.position)) | 0;
    var2 = ((var0 - var1)) | 0;
    // line number 513
    If_15_0: {
     if (var2 <= 0) {
      phi4 = this;
      phi5 = (var2) | 0;
      phi6 = (0) | 0;
      break If_15_0;
     } else {
      var3 = (var2) | 0;
      // Here was a goto statement
      phi4 = this;
      phi5 = (var2) | 0;
      phi6 = (var3) | 0;
      break If_15_0;
     }
    }
    return phi6;
  }

  Z$hasRemaining$$() {
    // source file is Buffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var phi3 = null;
    var phi4 = 0;
    // line number 524
    var0 = ((this.position)) | 0;
    var1 = ((this.limit)) | 0;
    If_10_0: {
     if (var0 >= var1) {
      phi3 = this;
      phi4 = (0) | 0;
      break If_10_0;
     } else {
      var2 = (1) | 0;
      // Here was a goto statement
      phi3 = this;
      phi4 = (var2) | 0;
      break If_10_0;
     }
    }
    return phi4;
  }

  I$position$$() {
    // source file is Buffer.java
    var var0 = 0;
    // line number 303
    var0 = ((this.position)) | 0;
    return var0;
  }

  V$checkSession$$() {
    // source file is Buffer.java
    return;
  }

  I$limit$$() {
    // source file is Buffer.java
    var var0 = 0;
    // line number 355
    var0 = ((this.limit)) | 0;
    return var0;
  }

  I$nextPutIndex$$() {
    // source file is Buffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    // line number 725
    var0 = ((this.position)) | 0;
    // line number 726
    var1 = ((this.limit)) | 0;
    if (var0 < var1) {
     // line number 728
     var3 = this;
     var4 = ((var0 + 1)) | 0;
     var3.position = var4;
     // line number 729
     return var0;
    } else {
     // line number 727
     var2 = new java$nio$BufferOverflowException();
     java$nio$BufferOverflowException.prototype.V$$init$$$.call(var2);
     throw bytecoder.registerStack(var2, new Error().stack);
    }
  }

  Ljdk$internal$foreign$MemorySessionImpl$$session$$() {
    // source file is Buffer.java
    var var0 = null;
    var0 = null;
    return var0;
  }

  I$capacity$$() {
    // source file is Buffer.java
    var var0 = 0;
    // line number 294
    var0 = ((this.capacity)) | 0;
    return var0;
  }

  I$checkIndex$I(arg0) {
    // source file is Buffer.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var0 = (arg0) | 0;
    // line number 746
    var1 = this;
    var2 = ((var1.limit)) | 0;
    var3 = ((java$util$Objects.I$checkIndex$I$I(var0,var2))) | 0;
    return var3;
  }
}


class java$util$ImmutableCollections extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;
  static SALT32L = 0;
  static REVERSE = false;
  static archivedObjects = null;
  static EMPTY = null;
  static EMPTY_LIST = null;
  static EMPTY_LIST_NULLS = null;
  static EMPTY_SET = null;
  static EMPTY_MAP = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$ImmutableCollections,[java$util$ImmutableCollections,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is ImmutableCollections.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var phi7 = 0;
    var phi8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = 0;
    var var17 = 0;
    var var18 = 0;
    var var19 = 0;
    var phi20 = 0;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = 0;
    var var25 = null;
    var var26 = null;
    var var27 = 0;
    var var28 = null;
    var var29 = null;
    var var30 = 0;
    var var31 = null;
    var var32 = null;
    var var33 = 0;
    var var34 = null;
    var var35 = null;
    var var36 = 0;
    var var37 = null;
    var var38 = 0;
    var var39 = null;
    var var40 = null;
    var var41 = null;
    var var42 = null;
    var var43 = null;
    var var44 = null;
    var var45 = null;
    var var46 = null;
    var var47 = null;
    var var48 = null;
    var var49 = null;
    var var50 = null;
    var var51 = null;
    var var52 = null;
    var var53 = null;
    var var54 = null;
    var var55 = null;
    var var56 = null;
    // line number 51
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(java$util$ImmutableCollections.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    java$util$ImmutableCollections.$i;
    java$util$ImmutableCollections.$assertionsDisabled = phi2;
    // line number 74
    // line number 80
    jdk$internal$misc$CDS.$i;
    var3 = (jdk$internal$misc$CDS.J$getRandomSeedForDumping$$());
    // line number 81
    var4 = 0;
    var5 = (bytecoder.cmp(var3,var4)) | 0;
    If_38_0: {
     if (var5 != 0) {
      phi7 = 2611923443488327891;
      phi8 = var3;
      break If_38_0;
     } else {
      // line number 82
      java$lang$System.$i;
      var6 = (java$lang$System.J$nanoTime$$());
      phi7 = 2611923443488327891;
      phi8 = var6;
      break If_38_0;
     }
    }
    // line number 84
    var9 = phi7;
    var10 = phi8;
    var11 = (var9 * var10);
    var12 = (var11 >> 16);
    var13 = ((var12 | 0)) | 0;
    var14 = (var13 | 0);
    var15 = (var14 & 4294967295);
    java$util$ImmutableCollections.SALT32L = var15;
    // line number 86
    var16 = (java$util$ImmutableCollections.SALT32L);
    var17 = (var16 & 1);
    var18 = (bytecoder.cmp(var17,0)) | 0;
    If_90_0: {
     if (var18 != 0) {
      phi20 = (0) | 0;
      break If_90_0;
     } else {
      var19 = (1) | 0;
      // Here was a goto statement
      phi20 = (var19) | 0;
      break If_90_0;
     }
    }
    java$util$ImmutableCollections.REVERSE = phi20;
    // line number 102
    jdk$internal$misc$CDS.V$initializeFromArchive$Ljava$lang$Class$(java$util$ImmutableCollections.$rt);
    // line number 103
    var21 = (java$util$ImmutableCollections.archivedObjects);
    If_113_0: {
     if (var21 != null) {
      // line number 112
      var43 = (java$util$ImmutableCollections.archivedObjects);
      var44 = (var43.data[0]);
      java$util$ImmutableCollections.EMPTY = var44;
      // line number 113
      var45 = (java$util$ImmutableCollections.archivedObjects);
      var46 = (var45.data[1]);
      var47 = var46;
      java$util$ImmutableCollections.EMPTY_LIST = var47;
      // line number 114
      var48 = (java$util$ImmutableCollections.archivedObjects);
      var49 = (var48.data[2]);
      var50 = var49;
      java$util$ImmutableCollections.EMPTY_LIST_NULLS = var50;
      // line number 115
      var51 = (java$util$ImmutableCollections.archivedObjects);
      var52 = (var51.data[3]);
      var53 = var52;
      java$util$ImmutableCollections.EMPTY_SET = var53;
      // line number 116
      var54 = (java$util$ImmutableCollections.archivedObjects);
      var55 = (var54.data[4]);
      var56 = var55;
      java$util$ImmutableCollections.EMPTY_MAP = var56;
      break If_113_0;
     } else {
      // line number 104
      var22 = new java$lang$Object();
      java$lang$Object.prototype.V$$init$$$.call(var22);
      java$util$ImmutableCollections.EMPTY = var22;
      // line number 105
      var23 = new java$util$ImmutableCollections$ListN();
      var24 = (0) | 0;
      var25 = bytecoder.newarray((var24),null);
      java$util$ImmutableCollections$ListN.prototype.V$$init$$$Ljava$lang$Object$$Z.call(var23,var25,0);
      java$util$ImmutableCollections.EMPTY_LIST = var23;
      // line number 106
      var26 = new java$util$ImmutableCollections$ListN();
      var27 = (0) | 0;
      var28 = bytecoder.newarray((var27),null);
      java$util$ImmutableCollections$ListN.prototype.V$$init$$$Ljava$lang$Object$$Z.call(var26,var28,1);
      java$util$ImmutableCollections.EMPTY_LIST_NULLS = var26;
      // line number 107
      var29 = new java$util$ImmutableCollections$SetN();
      var30 = (0) | 0;
      var31 = bytecoder.newarray((var30),null);
      java$util$ImmutableCollections$SetN.prototype.V$$init$$$Ljava$lang$Object$.call(var29,var31);
      java$util$ImmutableCollections.EMPTY_SET = var29;
      // line number 108
      var32 = new java$util$ImmutableCollections$MapN();
      var33 = (0) | 0;
      var34 = bytecoder.newarray((var33),null);
      java$util$ImmutableCollections$MapN.prototype.V$$init$$$Ljava$lang$Object$.call(var32,var34);
      java$util$ImmutableCollections.EMPTY_MAP = var32;
      // line number 109
      var35 = bytecoder.newarray((5),null);
      var36 = (0) | 0;
      var37 = (java$util$ImmutableCollections.EMPTY);
      var35.data[var36] = var37;
      var38 = (1) | 0;
      var39 = (java$util$ImmutableCollections.EMPTY_LIST);
      var35.data[var38] = var39;
      var40 = (java$util$ImmutableCollections.EMPTY_LIST_NULLS);
      var35.data[2] = var40;
      var41 = (java$util$ImmutableCollections.EMPTY_SET);
      var35.data[3] = var41;
      var42 = (java$util$ImmutableCollections.EMPTY_MAP);
      var35.data[4] = var42;
      java$util$ImmutableCollections.archivedObjects = var35;
      // Here was a goto statement
      break If_113_0;
     }
    }
    // line number 118
    return;
  }

  static Ljava$util$List$$listFromArray$$Ljava$lang$Object$(arg0) {
    // source file is ImmutableCollections.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var phi3 = null;
    var phi4 = null;
    var phi5 = 0;
    var var6 = 0;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = 0;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    // line number 188
    var0 = (arg0.data.length) | 0;
    var1 = bytecoder.newarray((var0),null);
    // line number 189
    var2 = (0) | 0;
    phi3 = arg0;
    phi4 = var1;
    phi5 = (var2) | 0;
    L1546995326: while(true) {
     var6 = (phi5) | 0;
     var7 = phi3;
     var8 = (var7.data.length) | 0;
     if (var6 >= var8) {
      // line number 192
      var15 = new java$util$ImmutableCollections$ListN();
      var16 = phi4;
      java$util$ImmutableCollections$ListN.prototype.V$$init$$$Ljava$lang$Object$$Z.call(var15,var16,0);
      return var15;
     } else {
      // line number 190
      var9 = phi4;
      var10 = (phi5) | 0;
      var11 = phi3;
      var12 = (phi5) | 0;
      var13 = (var11.data[var12]);
      var14 = (java$util$Objects.Ljava$lang$Object$$requireNonNull$Ljava$lang$Object$(var13));
      var9.data[var10] = var14;
      // line number 189
      phi5 = ((phi5 + 1)) | 0;
      // Here was a goto statement
      continue L1546995326;
     }
    }
  }

  static Ljava$lang$UnsupportedOperationException$$uoe$$() {
    // source file is ImmutableCollections.java
    var var0 = null;
    // line number 142
    var0 = new java$lang$UnsupportedOperationException();
    java$lang$UnsupportedOperationException.prototype.V$$init$$$.call(var0);
    return var0;
  }

  V$$init$$$() {
    // source file is ImmutableCollections.java
    // line number 134
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class org$jbox2d$dynamics$contacts$ContactVelocityConstraint$VelocityConstraintPoint extends java$lang$Object {
  nativeObject = null;

  rA = null;
  rB = null;
  normalImpulse = 0.0;
  tangentImpulse = 0.0;
  normalMass = 0.0;
  tangentMass = 0.0;
  velocityBias = 0.0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$dynamics$contacts$ContactVelocityConstraint$VelocityConstraintPoint,[org$jbox2d$dynamics$contacts$ContactVelocityConstraint$VelocityConstraintPoint,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is ContactVelocityConstraint.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    // line number 51
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 52
    var0 = this;
    org$jbox2d$common$Vec2.$i;
    var1 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var1);
    var0.rA = var1;
    // line number 53
    var2 = this;
    var3 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var3);
    var2.rB = var3;
    return;
  }
}


class org$jbox2d$collision$Distance$DistanceProxy extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;
  m_vertices = null;
  m_buffer = null;
  m_count = 0;
  m_radius = 0.0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$collision$Distance$DistanceProxy,[org$jbox2d$collision$Distance$DistanceProxy,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is Distance.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    // line number 475
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(org$jbox2d$collision$Distance.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    org$jbox2d$collision$Distance$DistanceProxy.$i;
    org$jbox2d$collision$Distance$DistanceProxy.$assertionsDisabled = phi2;
    return;
  }

  V$$init$$$() {
    // source file is Distance.java
    var var0 = null;
    var var1 = null;
    var phi2 = null;
    var phi3 = 0;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    // line number 481
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 482
    var0 = this;
    var1 = bytecoder.newarray((8),null);
    var0.m_vertices = var1;
    // line number 483
    phi2 = this;
    phi3 = (0) | 0;
    L1998436857: while(true) {
     var4 = (phi3) | 0;
     var5 = phi2;
     var6 = (var5.m_vertices);
     var7 = (var6.data.length) | 0;
     if (var4 >= var7) {
      // line number 486
      var12 = phi2;
      var13 = bytecoder.newarray((2),null);
      var12.m_buffer = var13;
      // line number 487
      var14 = phi2;
      var14.m_count = 0;
      // line number 488
      var15 = phi2;
      var15.m_radius = 0.0;
      // line number 489
      return;
     } else {
      // line number 484
      var8 = phi2;
      var9 = (var8.m_vertices);
      var10 = (phi3) | 0;
      org$jbox2d$common$Vec2.$i;
      var11 = new org$jbox2d$common$Vec2();
      org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var11);
      var9.data[var10] = var11;
      // line number 483
      phi3 = ((phi3 + 1)) | 0;
      // Here was a goto statement
      continue L1998436857;
     }
    }
  }

  V$set$Lorg$jbox2d$collision$shapes$Shape$$I(arg0,arg1) {
    // source file is Distance.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = .0;
    var phi17 = null;
    var phi18 = null;
    var phi19 = 0;
    var var20 = null;
    var var21 = 0;
    var var22 = 0;
    var var23 = 0;
    var var24 = 0;
    var phi25 = null;
    var phi26 = null;
    var phi27 = 0;
    var phi28 = null;
    var var29 = null;
    var phi30 = null;
    var phi31 = null;
    var phi32 = 0;
    var phi33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = null;
    var var37 = null;
    var var38 = 0;
    var var39 = null;
    var var40 = 0;
    var var41 = 0;
    var var42 = null;
    var var43 = 0;
    var var44 = null;
    var var45 = null;
    var var46 = null;
    var var47 = null;
    var var48 = 0;
    var var49 = 0;
    var var50 = null;
    var var51 = null;
    var var52 = null;
    var var53 = null;
    var var54 = null;
    var var55 = null;
    var var56 = null;
    var var57 = null;
    var var58 = null;
    var var59 = null;
    var var60 = null;
    var var61 = null;
    var var62 = null;
    var var63 = null;
    var var64 = null;
    var var65 = null;
    var var66 = null;
    var var67 = null;
    var var68 = .0;
    var var69 = null;
    var var70 = null;
    var var71 = null;
    var var72 = null;
    var var73 = null;
    var var74 = null;
    var var75 = null;
    var var76 = 0;
    var var77 = null;
    var var78 = .0;
    var phi79 = null;
    var phi80 = null;
    var phi81 = 0;
    var phi82 = null;
    var phi83 = 0;
    var var84 = 0;
    var var85 = null;
    var var86 = 0;
    var var87 = null;
    var var88 = null;
    var var89 = 0;
    var var90 = null;
    var var91 = null;
    var var92 = null;
    var var93 = 0;
    var var94 = null;
    var var95 = null;
    var var96 = null;
    var var97 = null;
    var var98 = null;
    var var99 = null;
    var var100 = null;
    var var101 = null;
    var var102 = null;
    var var103 = .0;
    var var104 = 0;
    var var105 = null;
    var0 = arg0;
    // line number 496
    org$jbox2d$collision$Distance$1.$i;
    var1 = (org$jbox2d$collision$Distance$1.$SwitchMap$org$jbox2d$collision$shapes$ShapeType);
    var2 = (org$jbox2d$collision$shapes$Shape.prototype.Lorg$jbox2d$collision$shapes$ShapeType$$getType$$.call(var0));
    var3 = ((var2.I$ordinal$$())) | 0;
    var4 = ((var1.data[var3])) | 0;
    TableSwitch_22_0: {
     if ((var4) >= 1 && (var4) <= 4) switch ((var4) - 1) {
      case 0: {
       // line number 498
       var96 = var0;
       // line number 499
       var97 = (this.m_vertices);
       var98 = (var97.data[0]);
       var99 = (var96.m_p);
       var100 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var98,var99));
       // line number 500
       var101 = this;
       var101.m_count = 1;
       // line number 501
       var102 = this;
       var103 = (var96.m_radius);
       var102.m_radius = var103;
       // line number 503
       // Here was a goto statement
       phi17 = this;
       phi18 = var0;
       phi19 = (arg1) | 0;
       break TableSwitch_22_0;
      }
      case 1: {
       // line number 505
       var74 = var0;
       // line number 506
       var75 = this;
       var76 = ((var74.m_count)) | 0;
       var75.m_count = var76;
       // line number 507
       var77 = this;
       var78 = (var74.m_radius);
       var77.m_radius = var78;
       // line number 508
       phi79 = this;
       phi80 = var0;
       phi81 = (arg1) | 0;
       phi82 = var74;
       phi83 = (0) | 0;
       L704178202: while(true) {
        var84 = (phi83) | 0;
        var85 = phi79;
        var86 = ((var85.m_count)) | 0;
        if (var84 >= var86) {
         // line number 511
         // Here was a goto statement
         phi17 = phi79;
         phi18 = phi80;
         phi19 = (phi81) | 0;
         break TableSwitch_22_0;
        } else {
         // line number 509
         var87 = phi79;
         var88 = (var87.m_vertices);
         var89 = (phi83) | 0;
         var90 = (var88.data[var89]);
         var91 = phi82;
         var92 = (var91.m_vertices);
         var93 = (phi83) | 0;
         var94 = (var92.data[var93]);
         var95 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var90,var94));
         // line number 508
         phi83 = ((phi83 + 1)) | 0;
         // Here was a goto statement
         continue L704178202;
        }
       }
      }
      case 2: {
       // line number 513
       var20 = var0;
       // line number 514
       org$jbox2d$collision$Distance$DistanceProxy.$i;
       var21 = (org$jbox2d$collision$Distance$DistanceProxy.$assertionsDisabled);
       If_96_0: {
        if (var21 != 0) {
         phi30 = this;
         phi31 = var0;
         phi32 = (arg1) | 0;
         phi33 = var20;
         break If_96_0;
        } else {
         var22 = (0) | 0;
         If_102_0: {
          if (var22 > arg1) {
           phi25 = this;
           phi26 = var0;
           phi27 = (arg1) | 0;
           phi28 = var20;
           break If_102_0;
          } else {
           var23 = (arg1) | 0;
           var24 = ((var20.m_count)) | 0;
           if (var23 < var24) {
            phi30 = this;
            phi31 = var0;
            phi32 = (arg1) | 0;
            phi33 = var20;
            break If_96_0;
           } else {
            phi25 = this;
            phi26 = var0;
            phi27 = (arg1) | 0;
            phi28 = var20;
            break If_102_0;
           }
          }
         }
         var29 = new java$lang$AssertionError();
         java$lang$AssertionError.prototype.V$$init$$$.call(var29);
         throw bytecoder.registerStack(var29, new Error().stack);
        }
       }
       // line number 516
       var34 = phi30;
       var35 = (var34.m_buffer);
       var36 = phi33;
       var37 = (var36.m_vertices);
       var38 = (phi32) | 0;
       var39 = (var37.data[var38]);
       var35.data[0] = var39;
       // line number 517
       var40 = (phi32) | 0;
       var41 = ((var40 + 1)) | 0;
       var42 = phi33;
       var43 = ((var42.m_count)) | 0;
       If_161_0: {
        if (var41 >= var43) {
         // line number 520
         var69 = phi30;
         var70 = (var69.m_buffer);
         var71 = phi33;
         var72 = (var71.m_vertices);
         var73 = (var72.data[0]);
         var70.data[1] = var73;
         break If_161_0;
        } else {
         // line number 518
         var44 = phi30;
         var45 = (var44.m_buffer);
         var46 = phi33;
         var47 = (var46.m_vertices);
         var48 = (phi32) | 0;
         var49 = ((var48 + 1)) | 0;
         var50 = (var47.data[var49]);
         var45.data[1] = var50;
         // Here was a goto statement
         break If_161_0;
        }
       }
       // line number 523
       var51 = phi30;
       var52 = (var51.m_vertices);
       var53 = (var52.data[0]);
       var54 = phi30;
       var55 = (var54.m_buffer);
       var56 = (var55.data[0]);
       var57 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var53,var56));
       // line number 524
       var58 = phi30;
       var59 = (var58.m_vertices);
       var60 = (var59.data[1]);
       var61 = phi30;
       var62 = (var61.m_buffer);
       var63 = (var62.data[1]);
       var64 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var60,var63));
       // line number 525
       var65 = phi30;
       var65.m_count = 2;
       // line number 526
       var66 = phi30;
       var67 = phi33;
       var68 = (var67.m_radius);
       var66.m_radius = var68;
       // line number 527
       // Here was a goto statement
       phi17 = phi30;
       phi18 = phi31;
       phi19 = (phi32) | 0;
       break TableSwitch_22_0;
      }
      case 3: {
       // line number 529
       var5 = var0;
       // line number 530
       var6 = (this.m_vertices);
       var7 = (var6.data[0]);
       var8 = (var5.m_vertex1);
       var9 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var7,var8));
       // line number 531
       var10 = (this.m_vertices);
       var11 = (var10.data[1]);
       var12 = (var5.m_vertex2);
       var13 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var11,var12));
       // line number 532
       var14 = this;
       var14.m_count = 2;
       // line number 533
       var15 = this;
       var16 = (var5.m_radius);
       var15.m_radius = var16;
       // line number 534
       // Here was a goto statement
       phi17 = this;
       phi18 = var0;
       phi19 = (arg1) | 0;
       break TableSwitch_22_0;
      }
     } else {
      // line number 536
      org$jbox2d$collision$Distance$DistanceProxy.$i;
      var104 = (org$jbox2d$collision$Distance$DistanceProxy.$assertionsDisabled);
      if (var104 != 0) {
       phi17 = this;
       phi18 = var0;
       phi19 = (arg1) | 0;
       break TableSwitch_22_0;
      } else {
       var105 = new java$lang$AssertionError();
       java$lang$AssertionError.prototype.V$$init$$$.call(var105);
       throw bytecoder.registerStack(var105, new Error().stack);
      }
     }
    }
    // line number 538
    return;
  }

  Lorg$jbox2d$common$Vec2$$getVertex$I(arg0) {
    // source file is Distance.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var phi5 = null;
    var phi6 = 0;
    var var7 = null;
    var phi8 = null;
    var phi9 = 0;
    var var10 = null;
    var var11 = null;
    var var12 = 0;
    var var13 = null;
    var0 = (arg0) | 0;
    // line number 596
    org$jbox2d$collision$Distance$DistanceProxy.$i;
    var1 = (org$jbox2d$collision$Distance$DistanceProxy.$assertionsDisabled);
    If_12_0: {
     if (var1 != 0) {
      phi8 = this;
      phi9 = (var0) | 0;
      break If_12_0;
     } else {
      var2 = (0) | 0;
      If_18_0: {
       if (var2 > var0) {
        phi5 = this;
        phi6 = (var0) | 0;
        break If_18_0;
       } else {
        var3 = (var0) | 0;
        var4 = ((this.m_count)) | 0;
        if (var3 < var4) {
         phi8 = this;
         phi9 = (var0) | 0;
         break If_12_0;
        } else {
         phi5 = this;
         phi6 = (var0) | 0;
         break If_18_0;
        }
       }
      }
      var7 = new java$lang$AssertionError();
      java$lang$AssertionError.prototype.V$$init$$$.call(var7);
      throw bytecoder.registerStack(var7, new Error().stack);
     }
    }
    // line number 597
    var10 = phi8;
    var11 = (var10.m_vertices);
    var12 = (phi9) | 0;
    var13 = (var11.data[var12]);
    return var13;
  }

  I$getSupport$Lorg$jbox2d$common$Vec2$(arg0) {
    // source file is Distance.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = .0;
    var phi4 = null;
    var phi5 = null;
    var phi6 = 0;
    var phi7 = .0;
    var phi8 = 0;
    var var9 = 0;
    var var10 = null;
    var var11 = 0;
    var var12 = null;
    var var13 = null;
    var var14 = 0;
    var var15 = null;
    var var16 = null;
    var var17 = .0;
    var var18 = .0;
    var var19 = 0;
    var var20 = 0;
    var var21 = .0;
    var phi22 = 0;
    var phi23 = .0;
    var phi24 = .0;
    var var25 = 0;
    var0 = arg0;
    // line number 547
    // line number 548
    var1 = (this.m_vertices);
    var2 = (var1.data[0]);
    org$jbox2d$common$Vec2.$i;
    var3 = (org$jbox2d$common$Vec2.F$dot$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var2,var0));
    // line number 549
    phi4 = this;
    phi5 = var0;
    phi6 = (0) | 0;
    phi7 = var3;
    phi8 = (1) | 0;
    L1311421234: while(true) {
     var9 = (phi8) | 0;
     var10 = phi4;
     var11 = ((var10.m_count)) | 0;
     if (var9 >= var11) {
      // line number 557
      var25 = (phi6) | 0;
      return var25;
     } else {
      // line number 550
      var12 = phi4;
      var13 = (var12.m_vertices);
      var14 = (phi8) | 0;
      var15 = (var13.data[var14]);
      var16 = phi5;
      var17 = (org$jbox2d$common$Vec2.F$dot$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var15,var16));
      // line number 551
      var18 = phi7;
      var19 = (bytecoder.cmp(var17,var18)) | 0;
      If_66_0: {
       if (var19 <= 0) {
        phi22 = (phi6) | 0;
        phi23 = phi7;
        phi24 = var17;
        break If_66_0;
       } else {
        // line number 552
        var20 = (phi8) | 0;
        // line number 553
        var21 = var17;
        phi22 = (var20) | 0;
        phi23 = var21;
        phi24 = var17;
        break If_66_0;
       }
      }
      // line number 549
      phi8 = ((phi8 + 1)) | 0;
      // Here was a goto statement
      phi6 = (phi22) | 0;
      phi7 = phi23;
      continue L1311421234;
     }
    }
  }
}


class org$jbox2d$callbacks$PairCallback extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$callbacks$PairCallback,[org$jbox2d$callbacks$PairCallback,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.V$addPair$Ljava$lang$Object$$Ljava$lang$Object$ = impl;
  }
}


class org$jbox2d$callbacks$ContactImpulse extends java$lang$Object {
  nativeObject = null;

  normalImpulses = null;
  tangentImpulses = null;
  count = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$callbacks$ContactImpulse,[org$jbox2d$callbacks$ContactImpulse,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is ContactImpulse.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    // line number 38
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 39
    var0 = this;
    var1 = bytecoder.newarray((2),0);
    var0.normalImpulses = var1;
    // line number 40
    var2 = this;
    var3 = bytecoder.newarray((2),0);
    var2.tangentImpulses = var3;
    return;
  }
}


class jdk$internal$misc$VM extends java$lang$Object {
  nativeObject = null;

  static lock = null;
  static directMemory = 0;
  static initLevel = 0;
  static savedProps = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(jdk$internal$misc$VM,[jdk$internal$misc$VM,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is VM.java
    var var0 = null;
    var var1 = null;
    // line number 37
    var0 = new java$lang$Object();
    java$lang$Object.prototype.V$$init$$$.call(var0);
    jdk$internal$misc$VM.$i;
    jdk$internal$misc$VM.lock = var0;
    // line number 76
    jdk$internal$misc$VM.directMemory = 67108864;
    // line number 183
    var1 = new java$util$HashMap();
    java$util$HashMap.prototype.V$$init$$$.call(var1);
    jdk$internal$misc$VM.V$saveProperties$Ljava$util$Map$(var1);
    // line number 184
    return;
  }

  static V$saveProperties$Ljava$util$Map$(arg0) {
    // source file is VM.java
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var phi4 = null;
    // line number 113
    jdk$internal$misc$VM.$i;
    var0 = ((jdk$internal$misc$VM.I$initLevel$$())) | 0;
    if (var0 == 0) {
     // line number 118
     var3 = (jdk$internal$misc$VM.savedProps);
     If_31_0: {
      if (var3 != null) {
       phi4 = arg0;
       break If_31_0;
      } else {
       // line number 119
       jdk$internal$misc$VM.savedProps = arg0;
       phi4 = arg0;
       break If_31_0;
      }
     }
     // line number 121
     return;
    } else {
     // line number 114
     var1 = new java$lang$IllegalStateException();
     var2 = bytecoder.stringconstants[41];
     java$lang$IllegalStateException.prototype.V$$init$$Ljava$lang$String$.call(var1,var2);
     throw bytecoder.registerStack(var1, new Error().stack);
    }
  }

  static I$initLevel$$() {
    // source file is VM.java
    var var0 = 0;
    // line number 49
    jdk$internal$misc$VM.$i;
    var0 = ((jdk$internal$misc$VM.initLevel)) | 0;
    return var0;
  }

  static Z$isBooted$$() {
    // source file is VM.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    // line number 65
    jdk$internal$misc$VM.$i;
    var0 = ((jdk$internal$misc$VM.initLevel)) | 0;
    If_9_0: {
     if (var0 < 4) {
      phi2 = (0) | 0;
      break If_9_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_9_0;
     }
    }
    return phi2;
  }

  V$$init$$$() {
    // source file is VM.java
    // line number 25
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class java$io$Serializable extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$io$Serializable,[java$io$Serializable,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class java$nio$charset$CoderResult extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;
  static names = null;
  type = 0;
  length = 0;
  static UNDERFLOW = null;
  static OVERFLOW = null;
  static malformed4 = null;
  static unmappable4 = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$nio$charset$CoderResult,[java$nio$charset$CoderResult,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is CoderResult.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = null;
    var var9 = 0;
    var var10 = null;
    var var11 = 0;
    var var12 = null;
    var var13 = 0;
    var var14 = null;
    var var15 = 0;
    var var16 = 0;
    var var17 = null;
    var var18 = 0;
    var var19 = 0;
    var var20 = null;
    var var21 = 0;
    var var22 = 0;
    var var23 = null;
    var var24 = 0;
    var var25 = null;
    var var26 = 0;
    var var27 = null;
    var var28 = 0;
    var var29 = null;
    var var30 = 0;
    var var31 = null;
    var var32 = 0;
    var var33 = null;
    var var34 = 0;
    // line number 84
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(java$nio$charset$CoderResult.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    java$nio$charset$CoderResult.$i;
    java$nio$charset$CoderResult.$assertionsDisabled = phi2;
    // line number 92
    var3 = bytecoder.newarray((4),null);
    var4 = (0) | 0;
    var3.data[var4] = bytecoder.stringconstants[82];
    var5 = (1) | 0;
    var3.data[var5] = bytecoder.stringconstants[83];
    var6 = (2) | 0;
    var3.data[var6] = bytecoder.stringconstants[84];
    var7 = (3) | 0;
    var3.data[var7] = bytecoder.stringconstants[85];
    java$nio$charset$CoderResult.names = var3;
    // line number 183
    var8 = new java$nio$charset$CoderResult();
    var9 = (0) | 0;
    java$nio$charset$CoderResult.prototype.V$$init$$I$I.call(var8,var9,0);
    java$nio$charset$CoderResult.UNDERFLOW = var8;
    // line number 190
    var10 = new java$nio$charset$CoderResult();
    var11 = (1) | 0;
    java$nio$charset$CoderResult.prototype.V$$init$$I$I.call(var10,var11,0);
    java$nio$charset$CoderResult.OVERFLOW = var10;
    // line number 201
    var12 = bytecoder.newarray((4),null);
    var13 = (0) | 0;
    var14 = new java$nio$charset$CoderResult();
    var15 = (2) | 0;
    java$nio$charset$CoderResult.prototype.V$$init$$I$I.call(var14,var15,1);
    var12.data[var13] = var14;
    var16 = (1) | 0;
    var17 = new java$nio$charset$CoderResult();
    var18 = (2) | 0;
    java$nio$charset$CoderResult.prototype.V$$init$$I$I.call(var17,var18,2);
    var12.data[var16] = var17;
    var19 = (2) | 0;
    var20 = new java$nio$charset$CoderResult();
    var21 = (2) | 0;
    java$nio$charset$CoderResult.prototype.V$$init$$I$I.call(var20,var21,3);
    var12.data[var19] = var20;
    var22 = (3) | 0;
    var23 = new java$nio$charset$CoderResult();
    var24 = (4) | 0;
    java$nio$charset$CoderResult.prototype.V$$init$$I$I.call(var23,2,var24);
    var12.data[var22] = var23;
    java$nio$charset$CoderResult.malformed4 = var12;
    // line number 226
    var25 = bytecoder.newarray((4),null);
    var26 = (0) | 0;
    var27 = new java$nio$charset$CoderResult();
    var28 = (1) | 0;
    java$nio$charset$CoderResult.prototype.V$$init$$I$I.call(var27,3,var28);
    var25.data[var26] = var27;
    var29 = new java$nio$charset$CoderResult();
    var30 = (2) | 0;
    java$nio$charset$CoderResult.prototype.V$$init$$I$I.call(var29,3,var30);
    var25.data[1] = var29;
    var31 = new java$nio$charset$CoderResult();
    var32 = (3) | 0;
    java$nio$charset$CoderResult.prototype.V$$init$$I$I.call(var31,3,var32);
    var25.data[2] = var31;
    var33 = new java$nio$charset$CoderResult();
    var34 = (4) | 0;
    java$nio$charset$CoderResult.prototype.V$$init$$I$I.call(var33,3,var34);
    var25.data[3] = var33;
    java$nio$charset$CoderResult.unmappable4 = var25;
    return;
  }

  V$$init$$I$I(arg0,arg1) {
    // source file is CoderResult.java
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var0 = (arg0) | 0;
    // line number 98
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 99
    var1 = this;
    var1.type = var0;
    // line number 100
    var2 = this;
    var2.length = arg1;
    // line number 101
    return;
  }

  Z$isOverflow$$() {
    // source file is CoderResult.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    // line number 128
    var0 = ((this.type)) | 0;
    If_8_0: {
     if (var0 != 1) {
      phi2 = this;
      phi3 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = this;
      phi3 = (var1) | 0;
      break If_8_0;
     }
    }
    return phi3;
  }

  Z$isUnderflow$$() {
    // source file is CoderResult.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    // line number 119
    var0 = ((this.type)) | 0;
    If_7_0: {
     if (var0 != 0) {
      phi2 = this;
      phi3 = (0) | 0;
      break If_7_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = this;
      phi3 = (var1) | 0;
      break If_7_0;
     }
    }
    return phi3;
  }

  static Ljava$nio$charset$CoderResult$$malformedForLength$I(arg0) {
    // source file is CoderResult.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    // line number 218
    if (arg0 > 0) {
     // line number 220
     var2 = (4) | 0;
     if (arg0 > var2) {
      // line number 222
      java$nio$charset$CoderResult$Cache.$i;
      var7 = (java$nio$charset$CoderResult$Cache.INSTANCE);
      var8 = (var7.malformed);
      java$lang$Integer.$i;
      var9 = (java$lang$Integer.Ljava$lang$Integer$$valueOf$I(arg0));
      var10 = bytecoder.instanceWithLambdaImpl(java$util$function$Function, function(arg0) { return java$nio$charset$CoderResult.Ljava$nio$charset$CoderResult$$lambda$malformedForLength$0$Ljava$lang$Integer$.call(this, arg0);});
      var11 = (var8.Ljava$lang$Object$$computeIfAbsent$Ljava$lang$Object$$Ljava$util$function$Function$(var9,var10));
      var12 = var11;
      return var12;
     } else {
      // line number 221
      java$nio$charset$CoderResult.$i;
      var3 = (java$nio$charset$CoderResult.malformed4);
      var4 = (1) | 0;
      var5 = ((arg0 - var4)) | 0;
      var6 = (var3.data[var5]);
      return var6;
     }
    } else {
     // line number 219
     var0 = new java$lang$IllegalArgumentException();
     var1 = bytecoder.stringconstants[88];
     java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var0,var1);
     throw bytecoder.registerStack(var0, new Error().stack);
    }
  }

  static Ljava$nio$charset$CoderResult$$lambda$malformedForLength$0$Ljava$lang$Integer$(arg0) {
    // source file is CoderResult.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    // line number 223
    java$nio$charset$CoderResult.$i;
    var0 = new java$nio$charset$CoderResult();
    var1 = (2) | 0;
    var2 = ((java$lang$Integer.prototype.I$intValue$$.call(arg0))) | 0;
    java$nio$charset$CoderResult.prototype.V$$init$$I$I.call(var0,var1,var2);
    return var0;
  }

  Z$isMalformed$$() {
    // source file is CoderResult.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    // line number 148
    var0 = ((this.type)) | 0;
    If_8_0: {
     if (var0 != 2) {
      phi2 = this;
      phi3 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = this;
      phi3 = (var1) | 0;
      break If_8_0;
     }
    }
    return phi3;
  }

  I$length$$() {
    // source file is CoderResult.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    // line number 173
    var0 = (java$nio$charset$CoderResult.prototype.Z$isError$$.call(this));
    if (var0 != 0) {
     // line number 175
     var2 = ((this.length)) | 0;
     return var2;
    } else {
     // line number 174
     var1 = new java$lang$UnsupportedOperationException();
     java$lang$UnsupportedOperationException.prototype.V$$init$$$.call(var1);
     throw bytecoder.registerStack(var1, new Error().stack);
    }
  }

  Z$isError$$() {
    // source file is CoderResult.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    // line number 138
    var0 = ((this.type)) | 0;
    If_8_0: {
     if (var0 < 2) {
      phi2 = this;
      phi3 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = this;
      phi3 = (var1) | 0;
      break If_8_0;
     }
    }
    return phi3;
  }

  Z$isUnmappable$$() {
    // source file is CoderResult.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    // line number 159
    var0 = ((this.type)) | 0;
    If_8_0: {
     if (var0 != 3) {
      phi2 = this;
      phi3 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = this;
      phi3 = (var1) | 0;
      break If_8_0;
     }
    }
    return phi3;
  }

  Ljava$lang$String$$toString$$() {
    // source file is CoderResult.java
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var phi11 = null;
    var phi12 = null;
    var phi13 = null;
    // line number 109
    java$nio$charset$CoderResult.$i;
    var0 = (java$nio$charset$CoderResult.names);
    var1 = ((this.type)) | 0;
    var2 = (var0.data[var1]);
    // line number 110
    var3 = (java$nio$charset$CoderResult.prototype.Z$isError$$.call(this));
    If_20_0: {
     if (var3 == 0) {
      phi11 = this;
      phi12 = var2;
      phi13 = var2;
      break If_20_0;
     } else {
      var4 = new java$lang$StringBuilder();
      java$lang$StringBuilder.prototype.V$$init$$$.call(var4);
      var5 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var4,var2));
      var6 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var5,bytecoder.stringconstants[108]));
      var7 = ((this.length)) | 0;
      var8 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var6,var7));
      var9 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var8,bytecoder.stringconstants[109]));
      var10 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var9));
      // Here was a goto statement
      phi11 = this;
      phi12 = var2;
      phi13 = var10;
      break If_20_0;
     }
    }
    return phi13;
  }
}


class java$util$RandomAccess extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$RandomAccess,[java$util$RandomAccess,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class org$jbox2d$collision$TimeOfImpact$TOIInput extends java$lang$Object {
  nativeObject = null;

  proxyA = null;
  proxyB = null;
  sweepA = null;
  sweepB = null;
  tMax = 0.0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$collision$TimeOfImpact$TOIInput,[org$jbox2d$collision$TimeOfImpact$TOIInput,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is TimeOfImpact.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    // line number 56
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 57
    var0 = this;
    org$jbox2d$collision$Distance$DistanceProxy.$i;
    var1 = new org$jbox2d$collision$Distance$DistanceProxy();
    org$jbox2d$collision$Distance$DistanceProxy.prototype.V$$init$$$.call(var1);
    var0.proxyA = var1;
    // line number 58
    var2 = this;
    var3 = new org$jbox2d$collision$Distance$DistanceProxy();
    org$jbox2d$collision$Distance$DistanceProxy.prototype.V$$init$$$.call(var3);
    var2.proxyB = var3;
    // line number 59
    var4 = this;
    org$jbox2d$common$Sweep.$i;
    var5 = new org$jbox2d$common$Sweep();
    org$jbox2d$common$Sweep.prototype.V$$init$$$.call(var5);
    var4.sweepA = var5;
    // line number 60
    var6 = this;
    var7 = new org$jbox2d$common$Sweep();
    org$jbox2d$common$Sweep.prototype.V$$init$$$.call(var7);
    var6.sweepB = var7;
    return;
  }
}


class org$jbox2d$dynamics$contacts$ContactPositionConstraint extends java$lang$Object {
  nativeObject = null;

  localPoints = null;
  localNormal = null;
  localPoint = null;
  localCenterA = null;
  localCenterB = null;
  indexA = 0;
  indexB = 0;
  invMassA = 0.0;
  invMassB = 0.0;
  invIA = 0.0;
  invIB = 0.0;
  pointCount = 0;
  radiusA = 0.0;
  radiusB = 0.0;
  type = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$dynamics$contacts$ContactPositionConstraint,[org$jbox2d$dynamics$contacts$ContactPositionConstraint,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is ContactPositionConstraint.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = 0;
    var phi11 = null;
    var phi12 = 0;
    var var13 = 0;
    var var14 = null;
    var var15 = null;
    var var16 = 0;
    var var17 = null;
    var var18 = null;
    var var19 = 0;
    var var20 = null;
    // line number 44
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 31
    var0 = this;
    var1 = bytecoder.newarray((2),null);
    var0.localPoints = var1;
    // line number 32
    var2 = this;
    org$jbox2d$common$Vec2.$i;
    var3 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var3);
    var2.localNormal = var3;
    // line number 33
    var4 = this;
    var5 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var5);
    var4.localPoint = var5;
    // line number 37
    var6 = this;
    var7 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var7);
    var6.localCenterA = var7;
    // line number 38
    var8 = this;
    var9 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var9);
    var8.localCenterB = var9;
    // line number 45
    var10 = (0) | 0;
    phi11 = this;
    phi12 = (var10) | 0;
    L1579920716: while(true) {
     var13 = (phi12) | 0;
     var14 = phi11;
     var15 = (var14.localPoints);
     var16 = (var15.data.length) | 0;
     if (var13 >= var16) {
      // line number 48
      return;
     } else {
      // line number 46
      var17 = phi11;
      var18 = (var17.localPoints);
      var19 = (phi12) | 0;
      var20 = new org$jbox2d$common$Vec2();
      org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var20);
      var18.data[var19] = var20;
      // line number 45
      phi12 = ((phi12 + 1)) | 0;
      // Here was a goto statement
      continue L1579920716;
     }
    }
  }
}


class java$nio$charset$CodingErrorAction extends java$lang$Object {
  nativeObject = null;

  name = null;
  static IGNORE = null;
  static REPLACE = null;
  static REPORT = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$nio$charset$CodingErrorAction,[java$nio$charset$CodingErrorAction,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is CodingErrorAction.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    // line number 55
    java$nio$charset$CodingErrorAction.$i;
    var0 = new java$nio$charset$CodingErrorAction();
    var1 = bytecoder.stringconstants[23];
    java$nio$charset$CodingErrorAction.prototype.V$$init$$Ljava$lang$String$.call(var0,var1);
    java$nio$charset$CodingErrorAction.IGNORE = var0;
    // line number 63
    var2 = new java$nio$charset$CodingErrorAction();
    java$nio$charset$CodingErrorAction.prototype.V$$init$$Ljava$lang$String$.call(var2,bytecoder.stringconstants[24]);
    java$nio$charset$CodingErrorAction.REPLACE = var2;
    // line number 72
    var3 = new java$nio$charset$CodingErrorAction();
    java$nio$charset$CodingErrorAction.prototype.V$$init$$Ljava$lang$String$.call(var3,bytecoder.stringconstants[25]);
    java$nio$charset$CodingErrorAction.REPORT = var3;
    return;
  }

  V$$init$$Ljava$lang$String$(arg0) {
    // source file is CodingErrorAction.java
    var var0 = null;
    var var1 = null;
    var0 = arg0;
    // line number 47
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 48
    var1 = this;
    var1.name = var0;
    // line number 49
    return;
  }

  Ljava$lang$String$$toString$$() {
    // source file is CodingErrorAction.java
    var var0 = null;
    // line number 81
    var0 = (this.name);
    return var0;
  }
}


class java$util$Iterator extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$Iterator,[java$util$Iterator,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class org$jbox2d$dynamics$FixtureProxy extends java$lang$Object {
  nativeObject = null;

  aabb = null;
  fixture = null;
  proxyId = 0;
  childIndex = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$dynamics$FixtureProxy,[org$jbox2d$dynamics$FixtureProxy,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is FixtureProxy.java
    var var0 = null;
    var var1 = null;
    // line number 33
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 34
    var0 = this;
    var1 = new org$jbox2d$collision$AABB();
    org$jbox2d$collision$AABB.prototype.V$$init$$$.call(var1);
    var0.aabb = var1;
    return;
  }
}


class org$jbox2d$collision$SeparationFunction$1 extends java$lang$Object {
  nativeObject = null;

  static $SwitchMap$org$jbox2d$collision$Type = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$collision$SeparationFunction$1,[org$jbox2d$collision$SeparationFunction$1,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is TimeOfImpact.java
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var phi3 = null;
    var phi4 = null;
    var phi5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = null;
    var var11 = 0;
    var var12 = null;
    var var13 = null;
    var var14 = 0;
    // line number 435
    org$jbox2d$collision$Type.$i;
    var0 = (org$jbox2d$collision$Type.$Lorg$jbox2d$collision$Type$$values$$());
    var1 = (var0.data.length) | 0;
    var2 = bytecoder.newarray((var1),0);
    org$jbox2d$collision$SeparationFunction$1.$i;
    org$jbox2d$collision$SeparationFunction$1.$SwitchMap$org$jbox2d$collision$Type = var2;
    TryCatch_17_0: {
     TryCatch_17_1: {
      try {
       var12 = (org$jbox2d$collision$SeparationFunction$1.$SwitchMap$org$jbox2d$collision$Type);
       var13 = (org$jbox2d$collision$Type.POINTS);
       var14 = ((var13.I$ordinal$$())) | 0;
       var12.data[var14] = 1;
       break TryCatch_17_1;
      } catch (__ex) {
       if (__ex instanceof java$lang$NoSuchFieldError) {
        phi3 = __ex;
        break TryCatch_17_0;
       }
       throw __ex;
      }
     }
     // Here was a goto statement
     break TryCatch_17_0;
    }
    TryCatch_22_0: {
     TryCatch_22_1: {
      try {
       var9 = (org$jbox2d$collision$SeparationFunction$1.$SwitchMap$org$jbox2d$collision$Type);
       var10 = (org$jbox2d$collision$Type.FACE_A);
       var11 = ((var10.I$ordinal$$())) | 0;
       var9.data[var11] = 2;
       break TryCatch_22_1;
      } catch (__ex) {
       if (__ex instanceof java$lang$NoSuchFieldError) {
        phi4 = __ex;
        break TryCatch_22_0;
       }
       throw __ex;
      }
     }
     // Here was a goto statement
     phi4 = phi3;
     break TryCatch_22_0;
    }
    TryCatch_27_0: {
     TryCatch_27_1: {
      try {
       var6 = (org$jbox2d$collision$SeparationFunction$1.$SwitchMap$org$jbox2d$collision$Type);
       var7 = (org$jbox2d$collision$Type.FACE_B);
       var8 = ((var7.I$ordinal$$())) | 0;
       var6.data[var8] = 3;
       break TryCatch_27_1;
      } catch (__ex) {
       if (__ex instanceof java$lang$NoSuchFieldError) {
        phi5 = __ex;
        break TryCatch_27_0;
       }
       throw __ex;
      }
     }
     // Here was a goto statement
     phi5 = phi4;
     break TryCatch_27_0;
    }
    return;
  }
}


class org$jbox2d$dynamics$Profile extends java$lang$Object {
  nativeObject = null;

  collide = 0.0;
  solveInit = 0.0;
  solveVelocity = 0.0;
  solvePosition = 0.0;
  broadphase = 0.0;
  solve = 0.0;
  solveTOI = 0.0;
  step = 0.0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$dynamics$Profile,[org$jbox2d$dynamics$Profile,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is Profile.java
    // line number 28
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class de$mirkosertic$bytecoder$classlib$java$lang$ref$TReference extends java$lang$Object {
  nativeObject = null;

  referent = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(de$mirkosertic$bytecoder$classlib$java$lang$ref$TReference,[de$mirkosertic$bytecoder$classlib$java$lang$ref$TReference,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Ljava$lang$Object$(arg0) {
    // source file is TReference.java
    var var0 = null;
    var var1 = null;
    var0 = arg0;
    // line number 30
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 31
    var1 = this;
    var1.referent = var0;
    // line number 32
    return;
  }
}


class org$jbox2d$callbacks$ContactFilter extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$callbacks$ContactFilter,[org$jbox2d$callbacks$ContactFilter,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is ContactFilter.java
    // line number 38
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }

  Z$shouldCollide$Lorg$jbox2d$dynamics$Fixture$$Lorg$jbox2d$dynamics$Fixture$(arg0,arg1) {
    // source file is ContactFilter.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var phi9 = null;
    var phi10 = null;
    var phi11 = null;
    var phi12 = null;
    var phi13 = null;
    var phi14 = 0;
    var phi15 = null;
    var phi16 = null;
    var phi17 = null;
    var phi18 = null;
    var phi19 = null;
    var var20 = null;
    var var21 = 0;
    var var22 = null;
    var var23 = 0;
    var var24 = 0;
    var var25 = null;
    var var26 = 0;
    var var27 = null;
    var var28 = 0;
    var var29 = 0;
    var var30 = 0;
    var phi31 = 0;
    var var32 = 0;
    var0 = arg0;
    // line number 48
    var1 = (org$jbox2d$dynamics$Fixture.prototype.Lorg$jbox2d$dynamics$Filter$$getFilterData$$.call(var0));
    // line number 49
    var2 = (org$jbox2d$dynamics$Fixture.prototype.Lorg$jbox2d$dynamics$Filter$$getFilterData$$.call(arg1));
    // line number 51
    var3 = ((var1.groupIndex)) | 0;
    var4 = ((var2.groupIndex)) | 0;
    If_24_0: {
     if (var3 != var4) {
      phi15 = this;
      phi16 = var0;
      phi17 = arg1;
      phi18 = var1;
      phi19 = var2;
      break If_24_0;
     } else {
      var5 = var1;
      var6 = ((var5.groupIndex)) | 0;
      if (var6 == 0) {
       phi15 = this;
       phi16 = var0;
       phi17 = arg1;
       phi18 = var1;
       phi19 = var2;
       break If_24_0;
      } else {
       // line number 52
       var7 = ((var1.groupIndex)) | 0;
       If_39_0: {
        if (var7 <= 0) {
         phi9 = this;
         phi10 = var0;
         phi11 = arg1;
         phi12 = var1;
         phi13 = var2;
         phi14 = (0) | 0;
         break If_39_0;
        } else {
         var8 = (1) | 0;
         // Here was a goto statement
         phi9 = this;
         phi10 = var0;
         phi11 = arg1;
         phi12 = var1;
         phi13 = var2;
         phi14 = (var8) | 0;
         break If_39_0;
        }
       }
       return phi14;
      }
     }
    }
    // line number 55
    var20 = phi18;
    var21 = ((var20.maskBits)) | 0;
    var22 = phi19;
    var23 = ((var22.categoryBits)) | 0;
    var24 = ((var21 & var23)) | 0;
    If_79_0: {
     If_79_1: {
      if (var24 == 0) {
       break If_79_1;
      } else {
       var25 = phi18;
       var26 = ((var25.categoryBits)) | 0;
       var27 = phi19;
       var28 = ((var27.maskBits)) | 0;
       var29 = ((var26 & var28)) | 0;
       if (var29 == 0) {
        break If_79_1;
       } else {
        var30 = (1) | 0;
        // Here was a goto statement
        phi31 = (var30) | 0;
        break If_79_0;
       }
      }
     }
     phi31 = (0) | 0;
     break If_79_0;
    }
    var32 = (phi31) | 0;
    // line number 57
    return var32;
  }
}


class org$jbox2d$collision$Collision extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;
  static d = null;
  input = null;
  cache = null;
  output = null;
  temp = null;
  results1 = null;
  results2 = null;
  incidentEdge = null;
  localTangent = null;
  localNormal = null;
  planePoint = null;
  tangent = null;
  v11 = null;
  v12 = null;
  clipPoints1 = null;
  clipPoints2 = null;
  Q = null;
  e = null;
  cf = null;
  e1 = null;
  P = null;
  n = null;
  collider = null;
  pool = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$collision$Collision,[org$jbox2d$collision$Collision,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is Collision.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    var var3 = null;
    // line number 46
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(org$jbox2d$collision$Collision.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    org$jbox2d$collision$Collision.$i;
    org$jbox2d$collision$Collision.$assertionsDisabled = phi2;
    // line number 191
    org$jbox2d$common$Vec2.$i;
    var3 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var3);
    org$jbox2d$collision$Collision.d = var3;
    return;
  }

  V$$init$$Lorg$jbox2d$pooling$IWorldPool$(arg0) {
    // source file is Collision.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = null;
    var var37 = null;
    var var38 = null;
    var var39 = null;
    var var40 = null;
    var var41 = null;
    var var42 = null;
    var var43 = null;
    var var44 = null;
    var var45 = null;
    var var46 = null;
    var var47 = null;
    var var48 = null;
    var var49 = null;
    var var50 = null;
    var var51 = null;
    var var52 = null;
    var var53 = null;
    var var54 = null;
    var var55 = null;
    var var56 = null;
    var var57 = null;
    var0 = arg0;
    // line number 51
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 61
    var1 = this;
    var2 = new org$jbox2d$collision$DistanceInput();
    org$jbox2d$collision$DistanceInput.prototype.V$$init$$$.call(var2);
    var1.input = var2;
    // line number 62
    var3 = this;
    var4 = new org$jbox2d$collision$Distance$SimplexCache();
    org$jbox2d$collision$Distance$SimplexCache.prototype.V$$init$$$.call(var4);
    var3.cache = var4;
    // line number 63
    var5 = this;
    var6 = new org$jbox2d$collision$DistanceOutput();
    org$jbox2d$collision$DistanceOutput.prototype.V$$init$$$.call(var6);
    var5.output = var6;
    // line number 506
    var7 = this;
    org$jbox2d$common$Vec2.$i;
    var8 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var8);
    var7.temp = var8;
    // line number 676
    var9 = this;
    var10 = new org$jbox2d$collision$Collision$EdgeResults();
    org$jbox2d$collision$Collision$EdgeResults.prototype.V$$init$$Lorg$jbox2d$collision$Collision$1$.call(var10,null);
    var9.results1 = var10;
    // line number 677
    var11 = this;
    var12 = new org$jbox2d$collision$Collision$EdgeResults();
    org$jbox2d$collision$Collision$EdgeResults.prototype.V$$init$$Lorg$jbox2d$collision$Collision$1$.call(var12,null);
    var11.results2 = var12;
    // line number 678
    var13 = this;
    var14 = bytecoder.newarray((2),null);
    var13.incidentEdge = var14;
    // line number 679
    var15 = this;
    var16 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var16);
    var15.localTangent = var16;
    // line number 680
    var17 = this;
    var18 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var18);
    var17.localNormal = var18;
    // line number 681
    var19 = this;
    var20 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var20);
    var19.planePoint = var20;
    // line number 682
    var21 = this;
    var22 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var22);
    var21.tangent = var22;
    // line number 683
    var23 = this;
    var24 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var24);
    var23.v11 = var24;
    // line number 684
    var25 = this;
    var26 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var26);
    var25.v12 = var26;
    // line number 685
    var27 = this;
    var28 = bytecoder.newarray((2),null);
    var27.clipPoints1 = var28;
    // line number 686
    var29 = this;
    var30 = bytecoder.newarray((2),null);
    var29.clipPoints2 = var30;
    // line number 843
    var31 = this;
    var32 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var32);
    var31.Q = var32;
    // line number 844
    var33 = this;
    var34 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var34);
    var33.e = var34;
    // line number 845
    var35 = this;
    var36 = new org$jbox2d$collision$ContactID();
    org$jbox2d$collision$ContactID.prototype.V$$init$$$.call(var36);
    var35.cf = var36;
    // line number 846
    var37 = this;
    var38 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var38);
    var37.e1 = var38;
    // line number 847
    var39 = this;
    var40 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var40);
    var39.P = var40;
    // line number 848
    var41 = this;
    var42 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var42);
    var41.n = var42;
    // line number 976
    var43 = this;
    var44 = new org$jbox2d$collision$Collision$EPCollider();
    org$jbox2d$collision$Collision$EPCollider.prototype.V$$init$$$.call(var44);
    var43.collider = var44;
    // line number 52
    var45 = (this.incidentEdge);
    var46 = new org$jbox2d$collision$Collision$ClipVertex();
    org$jbox2d$collision$Collision$ClipVertex.prototype.V$$init$$$.call(var46);
    var45.data[0] = var46;
    // line number 53
    var47 = (this.incidentEdge);
    var48 = new org$jbox2d$collision$Collision$ClipVertex();
    org$jbox2d$collision$Collision$ClipVertex.prototype.V$$init$$$.call(var48);
    var47.data[1] = var48;
    // line number 54
    var49 = (this.clipPoints1);
    var50 = new org$jbox2d$collision$Collision$ClipVertex();
    org$jbox2d$collision$Collision$ClipVertex.prototype.V$$init$$$.call(var50);
    var49.data[0] = var50;
    // line number 55
    var51 = (this.clipPoints1);
    var52 = new org$jbox2d$collision$Collision$ClipVertex();
    org$jbox2d$collision$Collision$ClipVertex.prototype.V$$init$$$.call(var52);
    var51.data[1] = var52;
    // line number 56
    var53 = (this.clipPoints2);
    var54 = new org$jbox2d$collision$Collision$ClipVertex();
    org$jbox2d$collision$Collision$ClipVertex.prototype.V$$init$$$.call(var54);
    var53.data[0] = var54;
    // line number 57
    var55 = (this.clipPoints2);
    var56 = new org$jbox2d$collision$Collision$ClipVertex();
    org$jbox2d$collision$Collision$ClipVertex.prototype.V$$init$$$.call(var56);
    var55.data[1] = var56;
    // line number 58
    var57 = this;
    var57.pool = var0;
    // line number 59
    return;
  }

  Z$testOverlap$Lorg$jbox2d$collision$shapes$Shape$$I$Lorg$jbox2d$collision$shapes$Shape$$I$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$common$Transform$(arg0,arg1,arg2,arg3,arg4,arg5) {
    // source file is Collision.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = .0;
    var var24 = 0;
    var var25 = 0;
    var phi26 = null;
    var phi27 = null;
    var phi28 = 0;
    var phi29 = null;
    var phi30 = 0;
    var phi31 = null;
    var phi32 = null;
    var phi33 = 0;
    var0 = arg0;
    var1 = arg2;
    var2 = arg4;
    // line number 76
    var3 = (this.input);
    var4 = (var3.proxyA);
    var5 = (arg1) | 0;
    org$jbox2d$collision$Distance$DistanceProxy.prototype.V$set$Lorg$jbox2d$collision$shapes$Shape$$I.call(var4,var0,var5);
    // line number 77
    var6 = (this.input);
    var7 = (var6.proxyB);
    var8 = (arg3) | 0;
    org$jbox2d$collision$Distance$DistanceProxy.prototype.V$set$Lorg$jbox2d$collision$shapes$Shape$$I.call(var7,var1,var8);
    // line number 78
    var9 = (this.input);
    var10 = (var9.transformA);
    var11 = (org$jbox2d$common$Transform.prototype.Lorg$jbox2d$common$Transform$$set$Lorg$jbox2d$common$Transform$.call(var10,var2));
    // line number 79
    var12 = (this.input);
    var13 = (var12.transformB);
    var14 = (org$jbox2d$common$Transform.prototype.Lorg$jbox2d$common$Transform$$set$Lorg$jbox2d$common$Transform$.call(var13,arg5));
    // line number 80
    var15 = (this.input);
    var15.useRadii = 1;
    // line number 82
    var16 = (this.cache);
    var16.count = 0;
    // line number 84
    var17 = (this.pool);
    var18 = (var17.Lorg$jbox2d$collision$Distance$$getDistance$$());
    var19 = (this.output);
    var20 = (this.cache);
    var21 = (this.input);
    org$jbox2d$collision$Distance.prototype.V$distance$Lorg$jbox2d$collision$DistanceOutput$$Lorg$jbox2d$collision$Distance$SimplexCache$$Lorg$jbox2d$collision$DistanceInput$.call(var18,var19,var20,var21);
    // line number 86
    var22 = (this.output);
    var23 = (var22.distance);
    var24 = (bytecoder.cmp(var23,1.1920929E-6)) | 0;
    If_102_0: {
     if (var24 >= 0) {
      phi26 = this;
      phi27 = var0;
      phi28 = (arg1) | 0;
      phi29 = var1;
      phi30 = (arg3) | 0;
      phi31 = var2;
      phi32 = arg5;
      phi33 = (0) | 0;
      break If_102_0;
     } else {
      var25 = (1) | 0;
      // Here was a goto statement
      phi26 = this;
      phi27 = var0;
      phi28 = (arg1) | 0;
      phi29 = var1;
      phi30 = (arg3) | 0;
      phi31 = var2;
      phi32 = arg5;
      phi33 = (var25) | 0;
      break If_102_0;
     }
    }
    return phi33;
  }

  V$collideEdgeAndCircle$Lorg$jbox2d$collision$Manifold$$Lorg$jbox2d$collision$shapes$EdgeShape$$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$collision$shapes$CircleShape$$Lorg$jbox2d$common$Transform$(arg0,arg1,arg2,arg3,arg4) {
    // source file is Collision.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = .0;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = .0;
    var var27 = .0;
    var var28 = .0;
    var var29 = .0;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = 0;
    var var34 = 0;
    var var35 = .0;
    var var36 = 0;
    var var37 = null;
    var var38 = null;
    var var39 = null;
    var var40 = null;
    var var41 = null;
    var var42 = null;
    var var43 = null;
    var var44 = .0;
    var var45 = .0;
    var var46 = .0;
    var var47 = 0;
    var var48 = 0;
    var var49 = null;
    var var50 = null;
    var var51 = null;
    var var52 = null;
    var var53 = null;
    var var54 = null;
    var var55 = null;
    var var56 = null;
    var var57 = null;
    var var58 = null;
    var var59 = .0;
    var var60 = 0;
    var phi61 = null;
    var phi62 = null;
    var phi63 = null;
    var phi64 = null;
    var phi65 = null;
    var phi66 = null;
    var phi67 = null;
    var phi68 = null;
    var phi69 = .0;
    var phi70 = .0;
    var phi71 = .0;
    var phi72 = null;
    var phi73 = .0;
    var phi74 = null;
    var var75 = null;
    var var76 = null;
    var var77 = null;
    var var78 = null;
    var var79 = null;
    var var80 = 0;
    var var81 = 0;
    var var82 = null;
    var var83 = null;
    var var84 = null;
    var var85 = null;
    var var86 = null;
    var var87 = null;
    var var88 = null;
    var var89 = null;
    var var90 = null;
    var var91 = null;
    var var92 = null;
    var var93 = null;
    var var94 = null;
    var var95 = null;
    var var96 = null;
    var var97 = null;
    var var98 = null;
    var var99 = null;
    var var100 = null;
    var var101 = null;
    var var102 = null;
    var var103 = null;
    var var104 = .0;
    var var105 = 0;
    var var106 = null;
    var var107 = null;
    var var108 = null;
    var var109 = null;
    var var110 = null;
    var var111 = null;
    var var112 = null;
    var var113 = .0;
    var var114 = .0;
    var var115 = .0;
    var var116 = 0;
    var var117 = 0;
    var var118 = null;
    var var119 = null;
    var var120 = null;
    var var121 = null;
    var var122 = null;
    var var123 = null;
    var var124 = null;
    var var125 = null;
    var var126 = null;
    var var127 = null;
    var var128 = .0;
    var var129 = 0;
    var phi130 = null;
    var phi131 = null;
    var phi132 = null;
    var phi133 = null;
    var phi134 = null;
    var phi135 = null;
    var phi136 = null;
    var phi137 = null;
    var phi138 = .0;
    var phi139 = .0;
    var phi140 = .0;
    var phi141 = null;
    var phi142 = .0;
    var phi143 = null;
    var phi144 = .0;
    var var145 = null;
    var var146 = null;
    var var147 = null;
    var var148 = null;
    var var149 = null;
    var var150 = 0;
    var var151 = 0;
    var var152 = null;
    var var153 = null;
    var var154 = null;
    var var155 = null;
    var var156 = null;
    var var157 = null;
    var var158 = null;
    var var159 = null;
    var var160 = null;
    var var161 = null;
    var var162 = null;
    var var163 = null;
    var var164 = null;
    var var165 = null;
    var var166 = null;
    var var167 = null;
    var var168 = null;
    var var169 = null;
    var var170 = null;
    var var171 = null;
    var var172 = null;
    var var173 = null;
    var var174 = null;
    var var175 = null;
    var var176 = .0;
    var var177 = 0;
    var var178 = .0;
    var var179 = 0;
    var var180 = null;
    var phi181 = null;
    var phi182 = null;
    var phi183 = null;
    var phi184 = null;
    var phi185 = null;
    var phi186 = null;
    var phi187 = null;
    var phi188 = null;
    var phi189 = .0;
    var phi190 = .0;
    var phi191 = .0;
    var phi192 = .0;
    var var193 = null;
    var var194 = null;
    var var195 = null;
    var var196 = null;
    var var197 = .0;
    var var198 = null;
    var var199 = null;
    var var200 = null;
    var var201 = null;
    var var202 = null;
    var var203 = .0;
    var var204 = null;
    var var205 = null;
    var var206 = null;
    var var207 = null;
    var var208 = .0;
    var var209 = .0;
    var var210 = null;
    var var211 = null;
    var var212 = null;
    var var213 = null;
    var var214 = null;
    var var215 = null;
    var var216 = null;
    var var217 = null;
    var var218 = null;
    var var219 = null;
    var var220 = .0;
    var var221 = .0;
    var var222 = .0;
    var var223 = .0;
    var var224 = 0;
    var var225 = null;
    var var226 = null;
    var var227 = null;
    var var228 = null;
    var var229 = .0;
    var var230 = .0;
    var var231 = null;
    var var232 = null;
    var var233 = null;
    var var234 = null;
    var var235 = .0;
    var var236 = null;
    var var237 = null;
    var var238 = null;
    var var239 = null;
    var var240 = null;
    var var241 = null;
    var var242 = null;
    var var243 = null;
    var var244 = null;
    var var245 = .0;
    var var246 = 0;
    var var247 = null;
    var var248 = null;
    var var249 = null;
    var var250 = null;
    var var251 = .0;
    var var252 = .0;
    var var253 = null;
    var var254 = null;
    var var255 = .0;
    var var256 = .0;
    var var257 = null;
    var phi258 = .0;
    var var259 = null;
    var var260 = null;
    var var261 = .0;
    var var262 = null;
    var var263 = null;
    var var264 = null;
    var var265 = null;
    var var266 = null;
    var var267 = 0;
    var var268 = 0;
    var var269 = null;
    var var270 = null;
    var var271 = null;
    var var272 = null;
    var var273 = null;
    var var274 = null;
    var var275 = null;
    var var276 = null;
    var var277 = null;
    var var278 = null;
    var var279 = null;
    var var280 = null;
    var var281 = null;
    var var282 = null;
    var var283 = null;
    var var284 = null;
    var var285 = null;
    var var286 = null;
    var var287 = null;
    var var288 = null;
    var var289 = null;
    var var290 = null;
    var var291 = null;
    var var292 = null;
    var var293 = null;
    var0 = arg0;
    var1 = arg2;
    var2 = arg4;
    // line number 854
    var3 = (0) | 0;
    var0.pointCount = var3;
    // line number 859
    var4 = arg3;
    var5 = (var4.m_p);
    var6 = (this.temp);
    org$jbox2d$common$Transform.$i;
    org$jbox2d$common$Transform.V$mulToOutUnsafe$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var2,var5,var6);
    // line number 860
    var7 = this;
    var8 = (var7.temp);
    var9 = (this.Q);
    org$jbox2d$common$Transform.V$mulTransToOutUnsafe$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var1,var8,var9);
    // line number 862
    var10 = (arg1.m_vertex1);
    // line number 863
    var11 = (arg1.m_vertex2);
    // line number 864
    var12 = (this.e);
    var13 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var12,var11));
    var14 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var13,var10));
    // line number 867
    var15 = (this.e);
    var16 = (this.temp);
    var17 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var16,var11));
    var18 = (this.Q);
    var19 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var17,var18));
    org$jbox2d$common$Vec2.$i;
    var20 = (org$jbox2d$common$Vec2.F$dot$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var15,var19));
    // line number 868
    var21 = (this.e);
    var22 = (this.temp);
    var23 = (this.Q);
    var24 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var22,var23));
    var25 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var24,var10));
    var26 = (org$jbox2d$common$Vec2.F$dot$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var21,var25));
    // line number 870
    var27 = (arg1.m_radius);
    var28 = (arg3.m_radius);
    var29 = (var27 + var28);
    // line number 873
    var30 = (this.cf);
    var30.indexB = 0;
    // line number 874
    var31 = (this.cf);
    org$jbox2d$collision$ContactID$Type.$i;
    var32 = (org$jbox2d$collision$ContactID$Type.VERTEX);
    var33 = ((var32.I$ordinal$$())) | 0;
    var34 = var33;
    var31.typeB = var34;
    // line number 877
    var35 = 0.0;
    var36 = (bytecoder.cmp(var26,var35)) | 0;
    if (var36 > 0) {
     // line number 911
     var104 = 0.0;
     var105 = (bytecoder.cmp(var20,var104)) | 0;
     if (var105 > 0) {
      // line number 946
      var174 = (this.e);
      var175 = (this.e);
      var176 = (org$jbox2d$common$Vec2.F$dot$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var174,var175));
      // line number 947
      org$jbox2d$collision$Collision.$i;
      var177 = (org$jbox2d$collision$Collision.$assertionsDisabled);
      If_655_0: {
       if (var177 != 0) {
        phi181 = this;
        phi182 = var0;
        phi183 = arg1;
        phi184 = var1;
        phi185 = arg3;
        phi186 = var2;
        phi187 = var10;
        phi188 = var11;
        phi189 = var20;
        phi190 = var26;
        phi191 = var29;
        phi192 = var176;
        break If_655_0;
       } else {
        var178 = var176;
        var179 = (bytecoder.cmp(var178,0.0)) | 0;
        if (var179 > 0) {
         phi181 = this;
         phi182 = var0;
         phi183 = arg1;
         phi184 = var1;
         phi185 = arg3;
         phi186 = var2;
         phi187 = var10;
         phi188 = var11;
         phi189 = var20;
         phi190 = var26;
         phi191 = var29;
         phi192 = var176;
         break If_655_0;
        } else {
         var180 = new java$lang$AssertionError();
         java$lang$AssertionError.prototype.V$$init$$$.call(var180);
         throw bytecoder.registerStack(var180, new Error().stack);
        }
       }
      }
      // line number 950
      var193 = phi181;
      var194 = (var193.P);
      var195 = phi187;
      var196 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var194,var195));
      var197 = phi189;
      var198 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var196,var197));
      var199 = phi181;
      var200 = (var199.temp);
      var201 = phi188;
      var202 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var200,var201));
      var203 = phi190;
      var204 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var202,var203));
      var205 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var198,var204));
      // line number 951
      var206 = phi181;
      var207 = (var206.P);
      var208 = phi192;
      var209 = (1.0 / var208);
      var210 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var207,var209));
      // line number 952
      var211 = (org$jbox2d$collision$Collision.d);
      var212 = phi181;
      var213 = (var212.Q);
      var214 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var211,var213));
      var215 = phi181;
      var216 = (var215.P);
      var217 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var214,var216));
      // line number 953
      var218 = (org$jbox2d$collision$Collision.d);
      var219 = (org$jbox2d$collision$Collision.d);
      var220 = (org$jbox2d$common$Vec2.F$dot$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var218,var219));
      // line number 954
      var221 = phi191;
      var222 = phi191;
      var223 = (var221 * var222);
      var224 = (bytecoder.cmp(var220,var223)) | 0;
      if (var224 <= 0) {
       // line number 958
       var225 = phi181;
       var226 = (var225.n);
       var227 = phi181;
       var228 = (var227.e);
       var229 = (var228.y);
       var230 = (0 - var229);
       var226.x = var230;
       // line number 959
       var231 = phi181;
       var232 = (var231.n);
       var233 = phi181;
       var234 = (var233.e);
       var235 = (var234.x);
       var232.y = var235;
       // line number 960
       var236 = phi181;
       var237 = (var236.n);
       var238 = phi181;
       var239 = (var238.temp);
       var240 = phi181;
       var241 = (var240.Q);
       var242 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var239,var241));
       var243 = phi187;
       var244 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var242,var243));
       var245 = (org$jbox2d$common$Vec2.F$dot$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var237,var244));
       var246 = (bytecoder.cmp(var245,0.0)) | 0;
       If_861_0: {
        if (var246 >= 0) {
         phi258 = var220;
         break If_861_0;
        } else {
         // line number 961
         var247 = phi181;
         var248 = (var247.n);
         var249 = phi181;
         var250 = (var249.n);
         var251 = (var250.x);
         var252 = (0 - var251);
         var253 = phi181;
         var254 = (var253.n);
         var255 = (var254.y);
         var256 = (0 - var255);
         var257 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$F$F.call(var248,var252,var256));
         phi258 = var220;
         break If_861_0;
        }
       }
       // line number 963
       var259 = phi181;
       var260 = (var259.n);
       var261 = (org$jbox2d$common$Vec2.prototype.F$normalize$$.call(var260));
       // line number 965
       var262 = phi181;
       var263 = (var262.cf);
       var263.indexA = 0;
       // line number 966
       var264 = phi181;
       var265 = (var264.cf);
       var266 = (org$jbox2d$collision$ContactID$Type.FACE);
       var267 = ((var266.I$ordinal$$())) | 0;
       var268 = var267;
       var265.typeA = var268;
       // line number 967
       var269 = phi182;
       var269.pointCount = 1;
       // line number 968
       var270 = phi182;
       org$jbox2d$collision$Manifold$ManifoldType.$i;
       var271 = (org$jbox2d$collision$Manifold$ManifoldType.FACE_A);
       var270.type = var271;
       // line number 969
       var272 = phi182;
       var273 = (var272.localNormal);
       var274 = phi181;
       var275 = (var274.n);
       var276 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var273,var275));
       // line number 970
       var277 = phi182;
       var278 = (var277.localPoint);
       var279 = phi187;
       var280 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var278,var279));
       // line number 972
       var281 = phi182;
       var282 = (var281.points);
       var283 = (var282.data[0]);
       var284 = (var283.id);
       var285 = phi181;
       var286 = (var285.cf);
       org$jbox2d$collision$ContactID.prototype.V$set$Lorg$jbox2d$collision$ContactID$.call(var284,var286);
       // line number 973
       var287 = phi182;
       var288 = (var287.points);
       var289 = (var288.data[0]);
       var290 = (var289.localPoint);
       var291 = phi185;
       var292 = (var291.m_p);
       var293 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var290,var292));
       // line number 974
       return;
      } else {
       // line number 955
       return;
      }
     } else {
      // line number 912
      var106 = var11;
      // line number 913
      org$jbox2d$collision$Collision.$i;
      var107 = (org$jbox2d$collision$Collision.d);
      var108 = (this.Q);
      var109 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var107,var108));
      var110 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var109,var106));
      // line number 914
      var111 = (org$jbox2d$collision$Collision.d);
      var112 = (org$jbox2d$collision$Collision.d);
      var113 = (org$jbox2d$common$Vec2.F$dot$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var111,var112));
      // line number 915
      var114 = var29;
      var115 = (var114 * var29);
      var116 = (bytecoder.cmp(var113,var115)) | 0;
      if (var116 <= 0) {
       // line number 920
       var117 = (arg1.m_hasVertex3);
       If_456_0: {
        if (var117 == 0) {
         phi130 = this;
         phi131 = var0;
         phi132 = arg1;
         phi133 = var1;
         phi134 = arg3;
         phi135 = var2;
         phi136 = var10;
         phi137 = var11;
         phi138 = var20;
         phi139 = var26;
         phi140 = var29;
         phi141 = var106;
         phi142 = var113;
         break If_456_0;
        } else {
         // line number 921
         var118 = (arg1.m_vertex3);
         // line number 922
         var119 = var11;
         // line number 923
         var120 = (this.e1);
         // line number 924
         var121 = var118;
         var122 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var120,var121));
         var123 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var122,var119));
         // line number 925
         var124 = (this.temp);
         var125 = (this.Q);
         var126 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var124,var125));
         var127 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var126,var119));
         var128 = (org$jbox2d$common$Vec2.F$dot$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var120,var127));
         // line number 928
         var129 = (bytecoder.cmp(var128,0.0)) | 0;
         if (var129 <= 0) {
          phi130 = this;
          phi131 = var0;
          phi132 = arg1;
          phi133 = var1;
          phi134 = arg3;
          phi135 = var2;
          phi136 = var10;
          phi137 = var11;
          phi138 = var20;
          phi139 = var26;
          phi140 = var29;
          phi141 = var106;
          phi142 = var113;
          phi143 = var119;
          phi144 = var128;
          break If_456_0;
         } else {
          // line number 929
          return;
         }
        }
       }
       // line number 933
       var145 = phi130;
       var146 = (var145.cf);
       var146.indexA = 1;
       // line number 934
       var147 = phi130;
       var148 = (var147.cf);
       var149 = (org$jbox2d$collision$ContactID$Type.VERTEX);
       var150 = ((var149.I$ordinal$$())) | 0;
       var151 = var150;
       var148.typeA = var151;
       // line number 935
       var152 = phi131;
       var152.pointCount = 1;
       // line number 936
       var153 = phi131;
       org$jbox2d$collision$Manifold$ManifoldType.$i;
       var154 = (org$jbox2d$collision$Manifold$ManifoldType.CIRCLES);
       var153.type = var154;
       // line number 937
       var155 = phi131;
       var156 = (var155.localNormal);
       org$jbox2d$common$Vec2.prototype.V$setZero$$.call(var156);
       // line number 938
       var157 = phi131;
       var158 = (var157.localPoint);
       var159 = phi141;
       var160 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var158,var159));
       // line number 940
       var161 = phi131;
       var162 = (var161.points);
       var163 = (var162.data[0]);
       var164 = (var163.id);
       var165 = phi130;
       var166 = (var165.cf);
       org$jbox2d$collision$ContactID.prototype.V$set$Lorg$jbox2d$collision$ContactID$.call(var164,var166);
       // line number 941
       var167 = phi131;
       var168 = (var167.points);
       var169 = (var168.data[0]);
       var170 = (var169.localPoint);
       var171 = phi134;
       var172 = (var171.m_p);
       var173 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var170,var172));
       // line number 942
       return;
      } else {
       // line number 916
       return;
      }
     }
    } else {
     // line number 878
     var37 = var10;
     // line number 879
     org$jbox2d$collision$Collision.$i;
     var38 = (org$jbox2d$collision$Collision.d);
     var39 = (this.Q);
     var40 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var38,var39));
     var41 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var40,var37));
     // line number 880
     var42 = (org$jbox2d$collision$Collision.d);
     var43 = (org$jbox2d$collision$Collision.d);
     var44 = (org$jbox2d$common$Vec2.F$dot$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var42,var43));
     // line number 881
     var45 = var29;
     var46 = (var45 * var29);
     var47 = (bytecoder.cmp(var44,var46)) | 0;
     if (var47 <= 0) {
      // line number 886
      var48 = (arg1.m_hasVertex0);
      If_210_0: {
       if (var48 == 0) {
        phi61 = this;
        phi62 = var0;
        phi63 = arg1;
        phi64 = var1;
        phi65 = arg3;
        phi66 = var2;
        phi67 = var10;
        phi68 = var11;
        phi69 = var20;
        phi70 = var26;
        phi71 = var29;
        phi72 = var37;
        phi73 = var44;
        break If_210_0;
       } else {
        // line number 887
        var49 = (arg1.m_vertex0);
        // line number 888
        var50 = var10;
        // line number 889
        var51 = (this.e1);
        var52 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var51,var50));
        var53 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var52,var49));
        // line number 890
        var54 = (this.e1);
        var55 = (this.temp);
        var56 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var55,var50));
        var57 = (this.Q);
        var58 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var56,var57));
        var59 = (org$jbox2d$common$Vec2.F$dot$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var54,var58));
        // line number 893
        var60 = (bytecoder.cmp(var59,0.0)) | 0;
        if (var60 <= 0) {
         phi61 = this;
         phi62 = var0;
         phi63 = arg1;
         phi64 = var1;
         phi65 = arg3;
         phi66 = var2;
         phi67 = var10;
         phi68 = var11;
         phi69 = var20;
         phi70 = var26;
         phi71 = var29;
         phi72 = var37;
         phi73 = var44;
         phi74 = var50;
         break If_210_0;
        } else {
         // line number 894
         return;
        }
       }
      }
      // line number 898
      var75 = phi61;
      var76 = (var75.cf);
      var76.indexA = 0;
      // line number 899
      var77 = phi61;
      var78 = (var77.cf);
      var79 = (org$jbox2d$collision$ContactID$Type.VERTEX);
      var80 = ((var79.I$ordinal$$())) | 0;
      var81 = var80;
      var78.typeA = var81;
      // line number 900
      var82 = phi62;
      var82.pointCount = 1;
      // line number 901
      var83 = phi62;
      org$jbox2d$collision$Manifold$ManifoldType.$i;
      var84 = (org$jbox2d$collision$Manifold$ManifoldType.CIRCLES);
      var83.type = var84;
      // line number 902
      var85 = phi62;
      var86 = (var85.localNormal);
      org$jbox2d$common$Vec2.prototype.V$setZero$$.call(var86);
      // line number 903
      var87 = phi62;
      var88 = (var87.localPoint);
      var89 = phi72;
      var90 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var88,var89));
      // line number 905
      var91 = phi62;
      var92 = (var91.points);
      var93 = (var92.data[0]);
      var94 = (var93.id);
      var95 = phi61;
      var96 = (var95.cf);
      org$jbox2d$collision$ContactID.prototype.V$set$Lorg$jbox2d$collision$ContactID$.call(var94,var96);
      // line number 906
      var97 = phi62;
      var98 = (var97.points);
      var99 = (var98.data[0]);
      var100 = (var99.localPoint);
      var101 = phi65;
      var102 = (var101.m_p);
      var103 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var100,var102));
      // line number 907
      return;
     } else {
      // line number 882
      return;
     }
    }
  }

  V$collideCircles$Lorg$jbox2d$collision$Manifold$$Lorg$jbox2d$collision$shapes$CircleShape$$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$collision$shapes$CircleShape$$Lorg$jbox2d$common$Transform$(arg0,arg1,arg2,arg3,arg4) {
    // source file is Collision.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = .0;
    var var8 = .0;
    var var9 = .0;
    var var10 = null;
    var var11 = .0;
    var var12 = .0;
    var var13 = .0;
    var var14 = .0;
    var var15 = null;
    var var16 = .0;
    var var17 = .0;
    var var18 = null;
    var var19 = .0;
    var var20 = .0;
    var var21 = .0;
    var var22 = null;
    var var23 = .0;
    var var24 = .0;
    var var25 = .0;
    var var26 = .0;
    var var27 = null;
    var var28 = .0;
    var var29 = .0;
    var var30 = null;
    var var31 = .0;
    var var32 = .0;
    var var33 = .0;
    var var34 = null;
    var var35 = .0;
    var var36 = .0;
    var var37 = .0;
    var var38 = .0;
    var var39 = null;
    var var40 = .0;
    var var41 = .0;
    var var42 = null;
    var var43 = .0;
    var var44 = .0;
    var var45 = .0;
    var var46 = null;
    var var47 = .0;
    var var48 = .0;
    var var49 = .0;
    var var50 = .0;
    var var51 = null;
    var var52 = .0;
    var var53 = .0;
    var var54 = .0;
    var var55 = .0;
    var var56 = .0;
    var var57 = .0;
    var var58 = .0;
    var var59 = .0;
    var var60 = .0;
    var var61 = .0;
    var var62 = .0;
    var var63 = .0;
    var var64 = .0;
    var var65 = .0;
    var var66 = .0;
    var var67 = .0;
    var var68 = 0;
    var var69 = null;
    var var70 = null;
    var var71 = null;
    var var72 = null;
    var var73 = null;
    var var74 = null;
    var var75 = null;
    var var76 = null;
    var var77 = null;
    var var78 = null;
    var var79 = null;
    var0 = arg0;
    var1 = arg2;
    var2 = arg4;
    // line number 204
    var3 = (0) | 0;
    var0.pointCount = var3;
    // line number 212
    var4 = (arg1.m_p);
    // line number 213
    var5 = (arg3.m_p);
    // line number 214
    var6 = (var1.q);
    var7 = (var6.c);
    var8 = (var4.x);
    var9 = (var7 * var8);
    var10 = (var1.q);
    var11 = (var10.s);
    var12 = (var4.y);
    var13 = (var11 * var12);
    var14 = (var9 - var13);
    var15 = (var1.p);
    var16 = (var15.x);
    var17 = (var14 + var16);
    // line number 215
    var18 = (var1.q);
    var19 = (var18.s);
    var20 = (var4.x);
    var21 = (var19 * var20);
    var22 = (var1.q);
    var23 = (var22.c);
    var24 = (var4.y);
    var25 = (var23 * var24);
    var26 = (var21 + var25);
    var27 = (var1.p);
    var28 = (var27.y);
    var29 = (var26 + var28);
    // line number 216
    var30 = (var2.q);
    var31 = (var30.c);
    var32 = (var5.x);
    var33 = (var31 * var32);
    var34 = (var2.q);
    var35 = (var34.s);
    var36 = (var5.y);
    var37 = (var35 * var36);
    var38 = (var33 - var37);
    var39 = (var2.p);
    var40 = (var39.x);
    var41 = (var38 + var40);
    // line number 217
    var42 = (var2.q);
    var43 = (var42.s);
    var44 = (var5.x);
    var45 = (var43 * var44);
    var46 = (var2.q);
    var47 = (var46.c);
    var48 = (var5.y);
    var49 = (var47 * var48);
    var50 = (var45 + var49);
    var51 = (var2.p);
    var52 = (var51.y);
    var53 = (var50 + var52);
    // line number 218
    var54 = var17;
    var55 = (var41 - var54);
    // line number 219
    var56 = var29;
    var57 = (var53 - var56);
    // line number 220
    var58 = var55;
    var59 = (var55 * var58);
    var60 = var57;
    var61 = (var57 * var60);
    var62 = (var59 + var61);
    // line number 223
    var63 = (arg1.m_radius);
    var64 = (arg3.m_radius);
    var65 = (var63 + var64);
    // line number 224
    var66 = var65;
    var67 = (var66 * var65);
    var68 = (bytecoder.cmp(var62,var67)) | 0;
    if (var68 <= 0) {
     // line number 228
     org$jbox2d$collision$Manifold$ManifoldType.$i;
     var69 = (org$jbox2d$collision$Manifold$ManifoldType.CIRCLES);
     var0.type = var69;
     // line number 229
     var70 = (var0.localPoint);
     var71 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var70,var4));
     // line number 230
     var72 = (var0.localNormal);
     org$jbox2d$common$Vec2.prototype.V$setZero$$.call(var72);
     // line number 231
     var0.pointCount = 1;
     // line number 233
     var73 = (var0.points);
     var74 = (var73.data[0]);
     var75 = (var74.localPoint);
     var76 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var75,var5));
     // line number 234
     var77 = (var0.points);
     var78 = (var77.data[0]);
     var79 = (var78.id);
     org$jbox2d$collision$ContactID.prototype.V$zero$$.call(var79);
     // line number 235
     return;
    } else {
     // line number 225
     return;
    }
  }

  V$collideEdgeAndPolygon$Lorg$jbox2d$collision$Manifold$$Lorg$jbox2d$collision$shapes$EdgeShape$$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$(arg0,arg1,arg2,arg3,arg4) {
    // source file is Collision.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var0 = arg0;
    var1 = arg2;
    var2 = arg4;
    // line number 980
    var3 = (this.collider);
    var4 = arg1;
    var5 = arg3;
    org$jbox2d$collision$Collision$EPCollider.prototype.V$collide$Lorg$jbox2d$collision$Manifold$$Lorg$jbox2d$collision$shapes$EdgeShape$$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$.call(var3,var0,var4,var1,var5,var2);
    // line number 981
    return;
  }

  static I$clipSegmentToLine$$Lorg$jbox2d$collision$Collision$ClipVertex$$$Lorg$jbox2d$collision$Collision$ClipVertex$$Lorg$jbox2d$common$Vec2$$F$I(arg0,arg1,arg2,arg3,arg4) {
    // source file is Collision.java
    var var0 = null;
    var var1 = .0;
    var var2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = .0;
    var var10 = .0;
    var var11 = null;
    var var12 = .0;
    var var13 = .0;
    var var14 = 0;
    var var15 = 0;
    var var16 = 0;
    var var17 = null;
    var phi18 = null;
    var phi19 = null;
    var phi20 = null;
    var phi21 = .0;
    var phi22 = 0;
    var phi23 = 0;
    var phi24 = null;
    var phi25 = null;
    var phi26 = null;
    var phi27 = null;
    var phi28 = .0;
    var phi29 = .0;
    var var30 = .0;
    var var31 = 0;
    var var32 = null;
    var var33 = 0;
    var var34 = null;
    var var35 = null;
    var var36 = .0;
    var var37 = .0;
    var var38 = .0;
    var var39 = 0;
    var var40 = .0;
    var var41 = .0;
    var var42 = .0;
    var var43 = .0;
    var var44 = .0;
    var var45 = null;
    var var46 = 0;
    var var47 = null;
    var var48 = null;
    var var49 = null;
    var var50 = .0;
    var var51 = null;
    var var52 = .0;
    var var53 = null;
    var var54 = .0;
    var var55 = .0;
    var var56 = .0;
    var var57 = .0;
    var var58 = null;
    var var59 = null;
    var var60 = .0;
    var var61 = null;
    var var62 = .0;
    var var63 = null;
    var var64 = .0;
    var var65 = .0;
    var var66 = .0;
    var var67 = .0;
    var var68 = null;
    var var69 = 0;
    var var70 = 0;
    var var71 = null;
    var var72 = null;
    var var73 = null;
    var var74 = 0;
    var var75 = null;
    var var76 = null;
    var var77 = 0;
    var var78 = 0;
    var var79 = null;
    var var80 = null;
    var var81 = 0;
    var var82 = 0;
    var phi83 = null;
    var var84 = 0;
    var0 = arg1;
    var1 = arg3;
    // line number 149
    // line number 150
    var2 = (0) | 0;
    var3 = (var0.data[var2]);
    // line number 151
    var4 = (1) | 0;
    var5 = (var0.data[var4]);
    // line number 152
    var6 = (var3.v);
    // line number 153
    var7 = (var5.v);
    // line number 156
    var8 = var6;
    org$jbox2d$common$Vec2.$i;
    var9 = (org$jbox2d$common$Vec2.F$dot$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(arg2,var8));
    var10 = (var9 - var1);
    // line number 157
    var11 = var7;
    var12 = (org$jbox2d$common$Vec2.F$dot$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(arg2,var11));
    var13 = (var12 - var1);
    // line number 160
    var14 = (bytecoder.cmp(var10,0.0)) | 0;
    If_68_0: {
     if (var14 > 0) {
      phi18 = arg0;
      phi19 = var0;
      phi20 = arg2;
      phi21 = var1;
      phi22 = (arg4) | 0;
      phi23 = (0) | 0;
      phi24 = var3;
      phi25 = var5;
      phi26 = var6;
      phi27 = var7;
      phi28 = var10;
      phi29 = var13;
      break If_68_0;
     } else {
      // line number 161
      var15 = (0) | 0;
      var16 = ((0 + 1)) | 0;
      var17 = (arg0.data[var15]);
      org$jbox2d$collision$Collision$ClipVertex.prototype.V$set$Lorg$jbox2d$collision$Collision$ClipVertex$.call(var17,var3);
      phi18 = arg0;
      phi19 = var0;
      phi20 = arg2;
      phi21 = var1;
      phi22 = (arg4) | 0;
      phi23 = (var16) | 0;
      phi24 = var3;
      phi25 = var5;
      phi26 = var6;
      phi27 = var7;
      phi28 = var10;
      phi29 = var13;
      break If_68_0;
     }
    }
    // line number 163
    var30 = phi29;
    var31 = (bytecoder.cmp(var30,0.0)) | 0;
    If_104_0: {
     if (var31 > 0) {
      break If_104_0;
     } else {
      // line number 164
      var32 = phi18;
      var33 = (phi23) | 0;
      phi23 = ((phi23 + 1)) | 0;
      var34 = (var32.data[var33]);
      var35 = phi25;
      org$jbox2d$collision$Collision$ClipVertex.prototype.V$set$Lorg$jbox2d$collision$Collision$ClipVertex$.call(var34,var35);
      break If_104_0;
     }
    }
    // line number 168
    var36 = phi28;
    var37 = phi29;
    var38 = (var36 * var37);
    var39 = (bytecoder.cmp(var38,0.0)) | 0;
    If_136_0: {
     if (var39 >= 0) {
      break If_136_0;
     } else {
      // line number 170
      var40 = phi28;
      var41 = phi28;
      var42 = phi29;
      var43 = (var41 - var42);
      var44 = (var40 / var43);
      // line number 172
      var45 = phi18;
      var46 = (phi23) | 0;
      var47 = (var45.data[var46]);
      // line number 174
      var48 = (var47.v);
      var49 = phi26;
      var50 = (var49.x);
      var51 = phi27;
      var52 = (var51.x);
      var53 = phi26;
      var54 = (var53.x);
      var55 = (var52 - var54);
      var56 = (var44 * var55);
      var57 = (var50 + var56);
      var48.x = var57;
      // line number 175
      var58 = (var47.v);
      var59 = phi26;
      var60 = (var59.y);
      var61 = phi27;
      var62 = (var61.y);
      var63 = phi26;
      var64 = (var63.y);
      var65 = (var62 - var64);
      var66 = (var44 * var65);
      var67 = (var60 + var66);
      var58.y = var67;
      // line number 178
      var68 = (var47.id);
      var69 = (phi22) | 0;
      var70 = var69;
      var68.indexA = var70;
      // line number 179
      var71 = (var47.id);
      var72 = phi24;
      var73 = (var72.id);
      var74 = (var73.indexB);
      var71.indexB = var74;
      // line number 180
      var75 = (var47.id);
      org$jbox2d$collision$ContactID$Type.$i;
      var76 = (org$jbox2d$collision$ContactID$Type.VERTEX);
      var77 = ((var76.I$ordinal$$())) | 0;
      var78 = var77;
      var75.typeA = var78;
      // line number 181
      var79 = (var47.id);
      var80 = (org$jbox2d$collision$ContactID$Type.FACE);
      var81 = ((var80.I$ordinal$$())) | 0;
      var82 = var81;
      var79.typeB = var82;
      // line number 182
      phi23 = ((phi23 + 1)) | 0;
      phi83 = var47;
      break If_136_0;
     }
    }
    // line number 185
    var84 = (phi23) | 0;
    return var84;
  }

  V$collidePolygons$Lorg$jbox2d$collision$Manifold$$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$(arg0,arg1,arg2,arg3,arg4) {
    // source file is Collision.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = .0;
    var var5 = .0;
    var var6 = .0;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = .0;
    var var12 = 0;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = .0;
    var var18 = 0;
    var var19 = .0;
    var var20 = null;
    var var21 = .0;
    var var22 = null;
    var var23 = null;
    var var24 = .0;
    var var25 = .0;
    var var26 = .0;
    var var27 = 0;
    var var28 = null;
    var var29 = null;
    var var30 = null;
    var var31 = 0;
    var var32 = null;
    var phi33 = null;
    var phi34 = null;
    var phi35 = null;
    var phi36 = null;
    var phi37 = null;
    var phi38 = null;
    var phi39 = .0;
    var phi40 = null;
    var phi41 = null;
    var phi42 = null;
    var phi43 = null;
    var phi44 = 0;
    var phi45 = 0;
    var phi46 = .0;
    var phi47 = .0;
    var var48 = null;
    var var49 = null;
    var var50 = null;
    var var51 = null;
    var var52 = null;
    var var53 = null;
    var var54 = null;
    var var55 = 0;
    var var56 = null;
    var var57 = null;
    var var58 = null;
    var var59 = 0;
    var var60 = null;
    var var61 = null;
    var var62 = 0;
    var var63 = 0;
    var var64 = 0;
    var var65 = 0;
    var var66 = 0;
    var phi67 = null;
    var phi68 = 0;
    var phi69 = null;
    var phi70 = 0;
    var phi71 = 0;
    var var72 = 0;
    var var73 = null;
    var var74 = null;
    var var75 = null;
    var var76 = 0;
    var var77 = null;
    var var78 = null;
    var var79 = null;
    var var80 = null;
    var var81 = null;
    var var82 = null;
    var var83 = null;
    var var84 = null;
    var var85 = null;
    var var86 = null;
    var var87 = null;
    var var88 = .0;
    var var89 = null;
    var var90 = null;
    var var91 = .0;
    var var92 = .0;
    var var93 = null;
    var var94 = null;
    var var95 = null;
    var var96 = null;
    var var97 = .0;
    var var98 = null;
    var var99 = null;
    var var100 = .0;
    var var101 = .0;
    var var102 = null;
    var var103 = null;
    var var104 = .0;
    var var105 = null;
    var var106 = null;
    var var107 = null;
    var var108 = null;
    var var109 = .0;
    var var110 = .0;
    var var111 = null;
    var var112 = null;
    var var113 = null;
    var var114 = null;
    var var115 = .0;
    var var116 = .0;
    var var117 = null;
    var var118 = null;
    var var119 = null;
    var var120 = null;
    var var121 = .0;
    var var122 = null;
    var var123 = null;
    var var124 = .0;
    var var125 = .0;
    var var126 = .0;
    var var127 = null;
    var var128 = null;
    var var129 = null;
    var var130 = null;
    var var131 = .0;
    var var132 = null;
    var var133 = null;
    var var134 = .0;
    var var135 = .0;
    var var136 = .0;
    var var137 = null;
    var var138 = null;
    var var139 = null;
    var var140 = .0;
    var var141 = null;
    var var142 = null;
    var var143 = .0;
    var var144 = .0;
    var var145 = null;
    var var146 = .0;
    var var147 = null;
    var var148 = null;
    var var149 = .0;
    var var150 = .0;
    var var151 = .0;
    var var152 = null;
    var var153 = null;
    var var154 = null;
    var var155 = .0;
    var var156 = null;
    var var157 = null;
    var var158 = .0;
    var var159 = .0;
    var var160 = null;
    var var161 = .0;
    var var162 = null;
    var var163 = null;
    var var164 = .0;
    var var165 = .0;
    var var166 = .0;
    var var167 = null;
    var var168 = null;
    var var169 = .0;
    var var170 = .0;
    var var171 = null;
    var var172 = null;
    var var173 = .0;
    var var174 = .0;
    var var175 = null;
    var var176 = null;
    var var177 = null;
    var var178 = null;
    var var179 = null;
    var var180 = null;
    var var181 = null;
    var var182 = null;
    var var183 = null;
    var var184 = null;
    var var185 = null;
    var var186 = null;
    var var187 = .0;
    var var188 = .0;
    var var189 = null;
    var var190 = null;
    var var191 = .0;
    var var192 = .0;
    var var193 = .0;
    var var194 = null;
    var var195 = null;
    var var196 = .0;
    var var197 = null;
    var var198 = null;
    var var199 = .0;
    var var200 = .0;
    var var201 = null;
    var var202 = null;
    var var203 = .0;
    var var204 = null;
    var var205 = null;
    var var206 = .0;
    var var207 = .0;
    var var208 = .0;
    var var209 = .0;
    var var210 = .0;
    var var211 = .0;
    var var212 = null;
    var var213 = null;
    var var214 = .0;
    var var215 = null;
    var var216 = null;
    var var217 = .0;
    var var218 = .0;
    var var219 = null;
    var var220 = null;
    var var221 = .0;
    var var222 = null;
    var var223 = null;
    var var224 = .0;
    var var225 = .0;
    var var226 = .0;
    var var227 = .0;
    var var228 = .0;
    var var229 = null;
    var var230 = null;
    var var231 = null;
    var var232 = null;
    var var233 = null;
    var var234 = null;
    var var235 = null;
    var var236 = null;
    var var237 = null;
    var var238 = 0;
    var var239 = 0;
    var var240 = null;
    var var241 = null;
    var var242 = null;
    var var243 = null;
    var var244 = null;
    var var245 = null;
    var var246 = null;
    var var247 = null;
    var var248 = null;
    var var249 = 0;
    var var250 = 0;
    var var251 = null;
    var var252 = null;
    var var253 = null;
    var var254 = null;
    var var255 = null;
    var var256 = null;
    var var257 = null;
    var var258 = null;
    var var259 = null;
    var var260 = null;
    var var261 = 0;
    var var262 = 0;
    var phi263 = .0;
    var phi264 = .0;
    var phi265 = .0;
    var phi266 = .0;
    var phi267 = 0;
    var phi268 = 0;
    var var269 = 0;
    var var270 = .0;
    var var271 = null;
    var var272 = null;
    var var273 = 0;
    var var274 = null;
    var var275 = null;
    var var276 = .0;
    var var277 = .0;
    var var278 = .0;
    var var279 = null;
    var var280 = null;
    var var281 = 0;
    var var282 = null;
    var var283 = null;
    var var284 = .0;
    var var285 = .0;
    var var286 = .0;
    var var287 = .0;
    var var288 = .0;
    var var289 = .0;
    var var290 = 0;
    var var291 = null;
    var var292 = null;
    var var293 = 0;
    var var294 = null;
    var var295 = null;
    var var296 = null;
    var var297 = null;
    var var298 = 0;
    var var299 = null;
    var var300 = null;
    var var301 = .0;
    var var302 = null;
    var var303 = null;
    var var304 = .0;
    var var305 = .0;
    var var306 = null;
    var var307 = null;
    var var308 = 0;
    var var309 = null;
    var var310 = null;
    var var311 = .0;
    var var312 = null;
    var var313 = null;
    var var314 = .0;
    var var315 = .0;
    var var316 = null;
    var var317 = null;
    var var318 = .0;
    var var319 = .0;
    var var320 = null;
    var var321 = null;
    var var322 = .0;
    var var323 = .0;
    var var324 = .0;
    var var325 = null;
    var var326 = null;
    var var327 = .0;
    var var328 = .0;
    var var329 = .0;
    var var330 = null;
    var var331 = null;
    var var332 = .0;
    var var333 = .0;
    var var334 = .0;
    var var335 = null;
    var var336 = null;
    var var337 = null;
    var var338 = 0;
    var var339 = null;
    var var340 = null;
    var var341 = 0;
    var var342 = null;
    var phi343 = .0;
    var phi344 = null;
    var phi345 = null;
    var phi346 = .0;
    var phi347 = .0;
    var var348 = null;
    var var349 = 0;
    var var350 = null;
    var var351 = null;
    var var352 = null;
    var var353 = null;
    var var354 = null;
    var var355 = 0;
    var var356 = null;
    var var357 = 0;
    var0 = arg0;
    var1 = arg2;
    var2 = arg4;
    // line number 707
    var3 = (0) | 0;
    var0.pointCount = var3;
    // line number 708
    var4 = (arg1.m_radius);
    var5 = (arg3.m_radius);
    var6 = (var4 + var5);
    // line number 710
    var7 = this;
    var8 = (var7.results1);
    var9 = arg3;
    org$jbox2d$collision$Collision.prototype.V$findMaxSeparation$Lorg$jbox2d$collision$Collision$EdgeResults$$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$.call(this,var8,arg1,var1,var9,var2);
    // line number 711
    var10 = (this.results1);
    var11 = (var10.separation);
    var12 = (bytecoder.cmp(var11,var6)) | 0;
    if (var12 <= 0) {
     // line number 715
     var13 = this;
     var14 = (var13.results2);
     var15 = arg1;
     org$jbox2d$collision$Collision.prototype.V$findMaxSeparation$Lorg$jbox2d$collision$Collision$EdgeResults$$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$.call(this,var14,arg3,var2,var15,var1);
     // line number 716
     var16 = (this.results2);
     var17 = (var16.separation);
     var18 = (bytecoder.cmp(var17,var6)) | 0;
     if (var18 <= 0) {
      // line number 725
      var19 = 0.98;
      // line number 726
      // line number 728
      var20 = (this.results2);
      var21 = (var20.separation);
      var22 = this;
      var23 = (var22.results1);
      var24 = (var23.separation);
      var25 = (0.98 * var24);
      var26 = (var25 + 0.001);
      var27 = (bytecoder.cmp(var21,var26)) | 0;
      If_121_0: {
       if (var27 <= 0) {
        // line number 737
        var350 = arg1;
        // line number 738
        var351 = arg3;
        // line number 739
        var352 = var1;
        // line number 740
        var353 = var2;
        // line number 741
        var354 = (this.results1);
        var355 = ((var354.edgeIndex)) | 0;
        // line number 742
        org$jbox2d$collision$Manifold$ManifoldType.$i;
        var356 = (org$jbox2d$collision$Manifold$ManifoldType.FACE_A);
        var0.type = var356;
        // line number 743
        var357 = (0) | 0;
        phi33 = this;
        phi34 = var0;
        phi35 = arg1;
        phi36 = var1;
        phi37 = arg3;
        phi38 = var2;
        phi39 = var6;
        phi40 = var350;
        phi41 = var351;
        phi42 = var352;
        phi43 = var353;
        phi44 = (var355) | 0;
        phi45 = (var357) | 0;
        phi46 = var19;
        phi47 = 0.001;
        break If_121_0;
       } else {
        // line number 729
        // line number 730
        // line number 731
        var28 = var2;
        // line number 732
        var29 = var1;
        // line number 733
        var30 = (this.results2);
        var31 = ((var30.edgeIndex)) | 0;
        // line number 734
        org$jbox2d$collision$Manifold$ManifoldType.$i;
        var32 = (org$jbox2d$collision$Manifold$ManifoldType.FACE_B);
        var0.type = var32;
        // line number 735
        // Here was a goto statement
        phi33 = this;
        phi34 = var0;
        phi35 = arg1;
        phi36 = var1;
        phi37 = arg3;
        phi38 = var2;
        phi39 = var6;
        phi40 = arg3;
        phi41 = arg1;
        phi42 = var28;
        phi43 = var29;
        phi44 = (var31) | 0;
        phi45 = (1) | 0;
        phi46 = var19;
        phi47 = 0.001;
        break If_121_0;
       }
      }
      // line number 745
      var48 = phi42;
      var49 = (var48.q);
      // line number 747
      var50 = phi33;
      var51 = phi33;
      var52 = (var51.incidentEdge);
      var53 = phi40;
      var54 = phi42;
      var55 = (phi44) | 0;
      var56 = phi41;
      var57 = phi43;
      org$jbox2d$collision$Collision.prototype.V$findIncidentEdge$$Lorg$jbox2d$collision$Collision$ClipVertex$$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$$I$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$.call(var50,var52,var53,var54,var55,var56,var57);
      // line number 749
      var58 = phi40;
      var59 = ((var58.m_count)) | 0;
      // line number 750
      var60 = phi40;
      var61 = (var60.m_vertices);
      // line number 752
      var62 = (phi44) | 0;
      // line number 753
      var63 = (phi44) | 0;
      var64 = ((var63 + 1)) | 0;
      If_226_0: {
       if (var64 >= var59) {
        phi67 = var49;
        phi68 = (var59) | 0;
        phi69 = var61;
        phi70 = (var62) | 0;
        phi71 = (0) | 0;
        break If_226_0;
       } else {
        var65 = (phi44) | 0;
        var66 = ((var65 + 1)) | 0;
        // Here was a goto statement
        phi67 = var49;
        phi68 = (var59) | 0;
        phi69 = var61;
        phi70 = (var62) | 0;
        phi71 = (var66) | 0;
        break If_226_0;
       }
      }
      var72 = (phi71) | 0;
      // line number 754
      var73 = phi33;
      var74 = (var73.v11);
      var75 = phi69;
      var76 = (phi70) | 0;
      var77 = (var75.data[var76]);
      var78 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var74,var77));
      // line number 755
      var79 = phi33;
      var80 = (var79.v12);
      var81 = phi69;
      var82 = (var81.data[var72]);
      var83 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var80,var82));
      // line number 756
      var84 = phi33;
      var85 = (var84.localTangent);
      var86 = phi33;
      var87 = (var86.v12);
      var88 = (var87.x);
      var89 = phi33;
      var90 = (var89.v11);
      var91 = (var90.x);
      var92 = (var88 - var91);
      var85.x = var92;
      // line number 757
      var93 = phi33;
      var94 = (var93.localTangent);
      var95 = phi33;
      var96 = (var95.v12);
      var97 = (var96.y);
      var98 = phi33;
      var99 = (var98.v11);
      var100 = (var99.y);
      var101 = (var97 - var100);
      var94.y = var101;
      // line number 758
      var102 = phi33;
      var103 = (var102.localTangent);
      var104 = (org$jbox2d$common$Vec2.prototype.F$normalize$$.call(var103));
      // line number 761
      var105 = phi33;
      var106 = (var105.localNormal);
      var107 = phi33;
      var108 = (var107.localTangent);
      var109 = (var108.y);
      var110 = (1.0 * var109);
      var106.x = var110;
      // line number 762
      var111 = phi33;
      var112 = (var111.localNormal);
      var113 = phi33;
      var114 = (var113.localTangent);
      var115 = (var114.x);
      var116 = (-1.0 * var115);
      var112.y = var116;
      // line number 765
      var117 = phi33;
      var118 = (var117.planePoint);
      var119 = phi33;
      var120 = (var119.v11);
      var121 = (var120.x);
      var122 = phi33;
      var123 = (var122.v12);
      var124 = (var123.x);
      var125 = (var121 + var124);
      var126 = (var125 * 0.5);
      var118.x = var126;
      // line number 766
      var127 = phi33;
      var128 = (var127.planePoint);
      var129 = phi33;
      var130 = (var129.v11);
      var131 = (var130.y);
      var132 = phi33;
      var133 = (var132.v12);
      var134 = (var133.y);
      var135 = (var131 + var134);
      var136 = (var135 * 0.5);
      var128.y = var136;
      // line number 769
      var137 = phi33;
      var138 = (var137.tangent);
      var139 = phi67;
      var140 = (var139.c);
      var141 = phi33;
      var142 = (var141.localTangent);
      var143 = (var142.x);
      var144 = (var140 * var143);
      var145 = phi67;
      var146 = (var145.s);
      var147 = phi33;
      var148 = (var147.localTangent);
      var149 = (var148.y);
      var150 = (var146 * var149);
      var151 = (var144 - var150);
      var138.x = var151;
      // line number 770
      var152 = phi33;
      var153 = (var152.tangent);
      var154 = phi67;
      var155 = (var154.s);
      var156 = phi33;
      var157 = (var156.localTangent);
      var158 = (var157.x);
      var159 = (var155 * var158);
      var160 = phi67;
      var161 = (var160.c);
      var162 = phi33;
      var163 = (var162.localTangent);
      var164 = (var163.y);
      var165 = (var161 * var164);
      var166 = (var159 + var165);
      var153.y = var166;
      // line number 773
      var167 = phi33;
      var168 = (var167.tangent);
      var169 = (var168.y);
      var170 = (1.0 * var169);
      // line number 774
      var171 = phi33;
      var172 = (var171.tangent);
      var173 = (var172.x);
      var174 = (-1.0 * var173);
      // line number 777
      var175 = phi42;
      var176 = phi33;
      var177 = (var176.v11);
      var178 = phi33;
      var179 = (var178.v11);
      org$jbox2d$common$Transform.$i;
      org$jbox2d$common$Transform.V$mulToOut$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var175,var177,var179);
      // line number 778
      var180 = phi42;
      var181 = phi33;
      var182 = (var181.v12);
      var183 = phi33;
      var184 = (var183.v12);
      org$jbox2d$common$Transform.V$mulToOut$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var180,var182,var184);
      // line number 784
      var185 = phi33;
      var186 = (var185.v11);
      var187 = (var186.x);
      var188 = (var170 * var187);
      var189 = phi33;
      var190 = (var189.v11);
      var191 = (var190.y);
      var192 = (var174 * var191);
      var193 = (var188 + var192);
      // line number 789
      var194 = phi33;
      var195 = (var194.tangent);
      var196 = (var195.x);
      var197 = phi33;
      var198 = (var197.v11);
      var199 = (var198.x);
      var200 = (var196 * var199);
      var201 = phi33;
      var202 = (var201.tangent);
      var203 = (var202.y);
      var204 = phi33;
      var205 = (var204.v11);
      var206 = (var205.y);
      var207 = (var203 * var206);
      var208 = (var200 + var207);
      var209 = (0 - var208);
      var210 = phi39;
      var211 = (var209 + var210);
      // line number 790
      var212 = phi33;
      var213 = (var212.tangent);
      var214 = (var213.x);
      var215 = phi33;
      var216 = (var215.v12);
      var217 = (var216.x);
      var218 = (var214 * var217);
      var219 = phi33;
      var220 = (var219.tangent);
      var221 = (var220.y);
      var222 = phi33;
      var223 = (var222.v12);
      var224 = (var223.y);
      var225 = (var221 * var224);
      var226 = (var218 + var225);
      var227 = phi39;
      var228 = (var226 + var227);
      // line number 799
      var229 = phi33;
      var230 = (var229.tangent);
      var231 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$negateLocal$$.call(var230));
      // line number 800
      var232 = phi33;
      var233 = (var232.clipPoints1);
      var234 = phi33;
      var235 = (var234.incidentEdge);
      var236 = phi33;
      var237 = (var236.tangent);
      var238 = (phi70) | 0;
      org$jbox2d$collision$Collision.$i;
      var239 = ((org$jbox2d$collision$Collision.I$clipSegmentToLine$$Lorg$jbox2d$collision$Collision$ClipVertex$$$Lorg$jbox2d$collision$Collision$ClipVertex$$Lorg$jbox2d$common$Vec2$$F$I(var233,var235,var237,var211,var238))) | 0;
      // line number 801
      var240 = phi33;
      var241 = (var240.tangent);
      var242 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$negateLocal$$.call(var241));
      // line number 803
      if (var239 >= 2) {
       // line number 808
       var243 = phi33;
       var244 = (var243.clipPoints2);
       var245 = phi33;
       var246 = (var245.clipPoints1);
       var247 = phi33;
       var248 = (var247.tangent);
       var249 = (var72) | 0;
       var250 = ((org$jbox2d$collision$Collision.I$clipSegmentToLine$$Lorg$jbox2d$collision$Collision$ClipVertex$$$Lorg$jbox2d$collision$Collision$ClipVertex$$Lorg$jbox2d$common$Vec2$$F$I(var244,var246,var248,var228,var249))) | 0;
       // line number 810
       if (var250 >= 2) {
        // line number 815
        var251 = phi34;
        var252 = (var251.localNormal);
        var253 = phi33;
        var254 = (var253.localNormal);
        var255 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var252,var254));
        // line number 816
        var256 = phi34;
        var257 = (var256.localPoint);
        var258 = phi33;
        var259 = (var258.planePoint);
        var260 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var257,var259));
        // line number 818
        var261 = (0) | 0;
        // line number 819
        var262 = (0) | 0;
        phi263 = var170;
        phi264 = var174;
        phi265 = var193;
        phi266 = var228;
        phi267 = (var261) | 0;
        phi268 = (var262) | 0;
        L1086103176: while(true) {
         var269 = (phi268) | 0;
         if (var269 >= 2) {
          // line number 840
          var348 = phi34;
          var349 = (phi267) | 0;
          var348.pointCount = var349;
          // line number 841
          return;
         } else {
          // line number 821
          var270 = phi263;
          var271 = phi33;
          var272 = (var271.clipPoints2);
          var273 = (phi268) | 0;
          var274 = (var272.data[var273]);
          var275 = (var274.v);
          var276 = (var275.x);
          var277 = (var270 * var276);
          var278 = phi264;
          var279 = phi33;
          var280 = (var279.clipPoints2);
          var281 = (phi268) | 0;
          var282 = (var280.data[var281]);
          var283 = (var282.v);
          var284 = (var283.y);
          var285 = (var278 * var284);
          var286 = (var277 + var285);
          var287 = phi265;
          var288 = (var286 - var287);
          // line number 823
          var289 = phi39;
          var290 = (bytecoder.cmp(var288,var289)) | 0;
          If_912_0: {
           if (var290 > 0) {
            phi343 = var288;
            break If_912_0;
           } else {
            // line number 824
            var291 = phi34;
            var292 = (var291.points);
            var293 = (phi267) | 0;
            var294 = (var292.data[var293]);
            // line number 826
            var295 = (var294.localPoint);
            // line number 827
            var296 = phi33;
            var297 = (var296.clipPoints2);
            var298 = (phi268) | 0;
            var299 = (var297.data[var298]);
            var300 = (var299.v);
            var301 = (var300.x);
            var302 = phi43;
            var303 = (var302.p);
            var304 = (var303.x);
            var305 = (var301 - var304);
            // line number 828
            var306 = phi33;
            var307 = (var306.clipPoints2);
            var308 = (phi268) | 0;
            var309 = (var307.data[var308]);
            var310 = (var309.v);
            var311 = (var310.y);
            var312 = phi43;
            var313 = (var312.p);
            var314 = (var313.y);
            var315 = (var311 - var314);
            // line number 829
            var316 = phi43;
            var317 = (var316.q);
            var318 = (var317.c);
            var319 = (var318 * var305);
            var320 = phi43;
            var321 = (var320.q);
            var322 = (var321.s);
            var323 = (var322 * var315);
            var324 = (var319 + var323);
            var295.x = var324;
            // line number 830
            var325 = phi43;
            var326 = (var325.q);
            var327 = (var326.s);
            var328 = (0 - var327);
            var329 = (var328 * var305);
            var330 = phi43;
            var331 = (var330.q);
            var332 = (var331.c);
            var333 = (var332 * var315);
            var334 = (var329 + var333);
            var295.y = var334;
            // line number 831
            var335 = (var294.id);
            var336 = phi33;
            var337 = (var336.clipPoints2);
            var338 = (phi268) | 0;
            var339 = (var337.data[var338]);
            var340 = (var339.id);
            org$jbox2d$collision$ContactID.prototype.V$set$Lorg$jbox2d$collision$ContactID$.call(var335,var340);
            // line number 832
            var341 = (phi45) | 0;
            If_1072_0: {
             if (var341 == 0) {
              phi343 = var288;
              phi344 = var294;
              phi345 = var295;
              phi346 = var305;
              phi347 = var315;
              break If_1072_0;
             } else {
              // line number 834
              var342 = (var294.id);
              org$jbox2d$collision$ContactID.prototype.V$flip$$.call(var342);
              phi343 = var288;
              phi344 = var294;
              phi345 = var295;
              phi346 = var305;
              phi347 = var315;
              break If_1072_0;
             }
            }
            // line number 836
            phi267 = ((phi267 + 1)) | 0;
            break If_912_0;
           }
          }
          // line number 819
          phi268 = ((phi268 + 1)) | 0;
          // Here was a goto statement
          continue L1086103176;
         }
        }
       } else {
        // line number 811
        return;
       }
      } else {
       // line number 804
       return;
      }
     } else {
      // line number 717
      return;
     }
    } else {
     // line number 712
     return;
    }
  }

  V$findMaxSeparation$Lorg$jbox2d$collision$Collision$EdgeResults$$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$(arg0,arg1,arg2,arg3,arg4) {
    // source file is Collision.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = .0;
    var var10 = .0;
    var var11 = .0;
    var var12 = .0;
    var var13 = .0;
    var var14 = .0;
    var var15 = .0;
    var var16 = null;
    var var17 = .0;
    var var18 = .0;
    var var19 = .0;
    var var20 = .0;
    var var21 = .0;
    var var22 = .0;
    var var23 = .0;
    var var24 = .0;
    var var25 = .0;
    var var26 = null;
    var var27 = .0;
    var var28 = .0;
    var var29 = null;
    var var30 = .0;
    var var31 = .0;
    var var32 = .0;
    var var33 = .0;
    var var34 = .0;
    var var35 = .0;
    var var36 = .0;
    var var37 = null;
    var var38 = .0;
    var var39 = .0;
    var var40 = .0;
    var var41 = null;
    var var42 = .0;
    var var43 = .0;
    var var44 = .0;
    var var45 = .0;
    var var46 = .0;
    var var47 = .0;
    var var48 = .0;
    var var49 = null;
    var var50 = .0;
    var var51 = .0;
    var var52 = .0;
    var var53 = .0;
    var var54 = .0;
    var var55 = .0;
    var var56 = .0;
    var var57 = .0;
    var var58 = .0;
    var var59 = .0;
    var var60 = .0;
    var var61 = .0;
    var var62 = .0;
    var var63 = .0;
    var var64 = 0;
    var var65 = .0;
    var var66 = 0;
    var phi67 = null;
    var phi68 = null;
    var phi69 = null;
    var phi70 = null;
    var phi71 = null;
    var phi72 = null;
    var phi73 = 0;
    var phi74 = null;
    var phi75 = null;
    var phi76 = null;
    var phi77 = .0;
    var phi78 = .0;
    var phi79 = .0;
    var phi80 = 0;
    var phi81 = .0;
    var phi82 = 0;
    var var83 = 0;
    var var84 = 0;
    var var85 = null;
    var var86 = 0;
    var var87 = null;
    var var88 = .0;
    var var89 = .0;
    var var90 = .0;
    var var91 = .0;
    var var92 = .0;
    var var93 = .0;
    var var94 = .0;
    var var95 = .0;
    var var96 = 0;
    var var97 = .0;
    var var98 = 0;
    var phi99 = 0;
    var phi100 = .0;
    var phi101 = .0;
    var phi102 = null;
    var var103 = null;
    var var104 = null;
    var var105 = null;
    var var106 = 0;
    var var107 = null;
    var var108 = null;
    var var109 = .0;
    var var110 = 0;
    var var111 = 0;
    var var112 = 0;
    var var113 = 0;
    var phi114 = .0;
    var phi115 = 0;
    var var116 = 0;
    var var117 = null;
    var var118 = null;
    var var119 = null;
    var var120 = null;
    var var121 = null;
    var var122 = .0;
    var var123 = 0;
    var var124 = 0;
    var var125 = 0;
    var var126 = 0;
    var var127 = 0;
    var phi128 = 0;
    var phi129 = .0;
    var phi130 = 0;
    var var131 = 0;
    var var132 = null;
    var var133 = null;
    var var134 = null;
    var var135 = null;
    var var136 = null;
    var var137 = .0;
    var var138 = .0;
    var var139 = .0;
    var var140 = 0;
    var var141 = .0;
    var var142 = 0;
    var var143 = 0;
    var var144 = 0;
    var var145 = .0;
    var phi146 = 0;
    var phi147 = .0;
    var phi148 = 0;
    var phi149 = .0;
    var phi150 = 0;
    var var151 = 0;
    var var152 = 0;
    var var153 = 0;
    var var154 = 0;
    var var155 = 0;
    var phi156 = 0;
    var var157 = 0;
    var phi158 = 0;
    var var159 = null;
    var var160 = null;
    var var161 = null;
    var var162 = 0;
    var var163 = null;
    var var164 = null;
    var var165 = .0;
    var var166 = .0;
    var var167 = 0;
    var var168 = 0;
    var var169 = .0;
    var var170 = null;
    var var171 = 0;
    var var172 = null;
    var var173 = .0;
    var var174 = 0;
    var var175 = 0;
    var var176 = 0;
    var var177 = 0;
    var var178 = 0;
    var var179 = 0;
    var var180 = 0;
    var phi181 = 0;
    var var182 = 0;
    var phi183 = 0;
    var phi184 = .0;
    var var185 = .0;
    var var186 = .0;
    var var187 = 0;
    var var188 = 0;
    var var189 = 0;
    var var190 = .0;
    var var191 = null;
    var var192 = 0;
    var var193 = null;
    var var194 = .0;
    var var195 = 0;
    var var196 = 0;
    var0 = arg0;
    var1 = arg2;
    var2 = arg4;
    // line number 520
    var3 = ((arg1.m_count)) | 0;
    // line number 521
    var4 = (arg1.m_normals);
    // line number 523
    var5 = (arg1.m_centroid);
    // line number 524
    var6 = (arg3.m_centroid);
    // line number 525
    var7 = (var2.q);
    // line number 526
    var8 = (var1.q);
    // line number 535
    var9 = (var7.c);
    var10 = (var6.x);
    var11 = (var9 * var10);
    var12 = (var7.s);
    var13 = (var6.y);
    var14 = (var12 * var13);
    var15 = (var11 - var14);
    var16 = (var2.p);
    var17 = (var16.x);
    var18 = (var15 + var17);
    // line number 536
    var19 = (var7.s);
    var20 = (var6.x);
    var21 = (var19 * var20);
    var22 = (var7.c);
    var23 = (var6.y);
    var24 = (var22 * var23);
    var25 = (var21 + var24);
    var26 = (var2.p);
    var27 = (var26.y);
    var28 = (var25 + var27);
    // line number 537
    var29 = var8;
    var30 = (var29.c);
    var31 = (var5.x);
    var32 = (var30 * var31);
    var33 = (var8.s);
    var34 = (var5.y);
    var35 = (var33 * var34);
    var36 = (var32 - var35);
    var37 = (var1.p);
    var38 = (var37.x);
    var39 = (var36 + var38);
    var40 = (var18 - var39);
    // line number 538
    var41 = var8;
    var42 = (var41.s);
    var43 = (var5.x);
    var44 = (var42 * var43);
    var45 = (var8.c);
    var46 = (var5.y);
    var47 = (var45 * var46);
    var48 = (var44 + var47);
    var49 = (var1.p);
    var50 = (var49.y);
    var51 = (var48 + var50);
    var52 = (var28 - var51);
    // line number 540
    var53 = (var8.c);
    var54 = (var53 * var40);
    var55 = (var8.s);
    var56 = (var55 * var52);
    var57 = (var54 + var56);
    // line number 541
    var58 = (var8.s);
    var59 = (0 - var58);
    var60 = (var59 * var40);
    var61 = (var8.c);
    var62 = (var61 * var52);
    var63 = (var60 + var62);
    // line number 545
    var64 = (0) | 0;
    // line number 547
    var65 = -3.4028235E38;
    // line number 548
    var66 = (0) | 0;
    phi67 = this;
    phi68 = var0;
    phi69 = arg1;
    phi70 = var1;
    phi71 = arg3;
    phi72 = var2;
    phi73 = (var3) | 0;
    phi74 = var4;
    phi75 = var6;
    phi76 = var8;
    phi77 = var52;
    phi78 = var57;
    phi79 = var63;
    phi80 = (var64) | 0;
    phi81 = var65;
    phi82 = (var66) | 0;
    L1552903458: while(true) {
     var83 = (phi82) | 0;
     var84 = (phi73) | 0;
     if (var83 >= var84) {
      // line number 558
      var103 = phi67;
      var104 = phi69;
      var105 = phi70;
      var106 = (phi80) | 0;
      var107 = phi71;
      var108 = phi72;
      var109 = (org$jbox2d$collision$Collision.prototype.F$edgeSeparation$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$$I$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$.call(var103,var104,var105,var106,var107,var108));
      // line number 561
      var110 = (phi80) | 0;
      var111 = ((var110 - 1)) | 0;
      If_342_0: {
       if (var111 < 0) {
        var195 = (phi73) | 0;
        var196 = ((var195 - 1)) | 0;
        phi114 = var109;
        phi115 = (var196) | 0;
        break If_342_0;
       } else {
        var112 = (phi80) | 0;
        var113 = ((var112 - 1)) | 0;
        // Here was a goto statement
        phi114 = var109;
        phi115 = (var113) | 0;
        break If_342_0;
       }
      }
      var116 = (phi115) | 0;
      // line number 562
      var117 = phi67;
      var118 = phi69;
      var119 = phi70;
      var120 = phi71;
      var121 = phi72;
      var122 = (org$jbox2d$collision$Collision.prototype.F$edgeSeparation$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$$I$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$.call(var117,var118,var119,var116,var120,var121));
      // line number 565
      var123 = (phi80) | 0;
      var124 = ((var123 + 1)) | 0;
      var125 = (phi73) | 0;
      If_383_0: {
       if (var124 >= var125) {
        phi128 = (var116) | 0;
        phi129 = var122;
        phi130 = (0) | 0;
        break If_383_0;
       } else {
        var126 = (phi80) | 0;
        var127 = ((var126 + 1)) | 0;
        // Here was a goto statement
        phi128 = (var116) | 0;
        phi129 = var122;
        phi130 = (var127) | 0;
        break If_383_0;
       }
      }
      var131 = (phi130) | 0;
      // line number 566
      var132 = phi67;
      var133 = phi69;
      var134 = phi70;
      var135 = phi71;
      var136 = phi72;
      var137 = (org$jbox2d$collision$Collision.prototype.F$edgeSeparation$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$$I$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$.call(var132,var133,var134,var131,var135,var136));
      // line number 572
      var138 = phi129;
      var139 = phi114;
      var140 = (bytecoder.cmp(var138,var139)) | 0;
      If_423_0: {
       If_423_1: {
        if (var140 <= 0) {
         phi183 = (var131) | 0;
         phi184 = var137;
         break If_423_1;
        } else {
         var141 = phi129;
         var142 = (bytecoder.cmp(var141,var137)) | 0;
         if (var142 <= 0) {
          phi183 = (var131) | 0;
          phi184 = var137;
          break If_423_1;
         } else {
          // line number 573
          var143 = (-1) | 0;
          // line number 574
          var144 = (phi128) | 0;
          // line number 575
          var145 = phi129;
          // Here was a goto statement
          phi146 = (var131) | 0;
          phi147 = var137;
          phi148 = (var144) | 0;
          phi149 = var145;
          phi150 = (var143) | 0;
          break If_423_0;
         }
        }
       }
       // line number 576
       var185 = phi184;
       var186 = phi114;
       var187 = (bytecoder.cmp(var185,var186)) | 0;
       if (var187 <= 0) {
        // line number 581
        var191 = phi68;
        var192 = (phi80) | 0;
        var191.edgeIndex = var192;
        // line number 582
        var193 = phi68;
        var194 = phi114;
        var193.separation = var194;
        // line number 583
        return;
       } else {
        // line number 577
        var188 = (1) | 0;
        // line number 578
        var189 = (phi183) | 0;
        // line number 579
        var190 = phi184;
        // Here was a goto statement
        phi146 = (phi183) | 0;
        phi147 = phi184;
        phi148 = (var189) | 0;
        phi149 = var190;
        phi150 = (var188) | 0;
        break If_423_0;
       }
      }
      L1391851734: while(true) {
       // line number 588
       var151 = (phi150) | 0;
       If_460_0: {
        if (var151 != -1) {
         // line number 591
         var176 = (phi148) | 0;
         var177 = ((var176 + 1)) | 0;
         var178 = (phi73) | 0;
         If_561_0: {
          if (var177 >= var178) {
           phi181 = (0) | 0;
           break If_561_0;
          } else {
           var179 = (phi148) | 0;
           var180 = ((var179 + 1)) | 0;
           // Here was a goto statement
           phi181 = (var180) | 0;
           break If_561_0;
          }
         }
         var182 = (phi181) | 0;
         phi158 = (var182) | 0;
         break If_460_0;
        } else {
         // line number 589
         var152 = (phi148) | 0;
         var153 = ((var152 - 1)) | 0;
         If_470_0: {
          if (var153 < 0) {
           var174 = (phi73) | 0;
           var175 = ((var174 - 1)) | 0;
           phi156 = (var175) | 0;
           break If_470_0;
          } else {
           var154 = (phi148) | 0;
           var155 = ((var154 - 1)) | 0;
           // Here was a goto statement
           phi156 = (var155) | 0;
           break If_470_0;
          }
         }
         var157 = (phi156) | 0;
         // Here was a goto statement
         phi158 = (var157) | 0;
         break If_460_0;
        }
       }
       // line number 594
       var159 = phi67;
       var160 = phi69;
       var161 = phi70;
       var162 = (phi158) | 0;
       var163 = phi71;
       var164 = phi72;
       var165 = (org$jbox2d$collision$Collision.prototype.F$edgeSeparation$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$$I$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$.call(var159,var160,var161,var162,var163,var164));
       // line number 596
       var166 = phi149;
       var167 = (bytecoder.cmp(var165,var166)) | 0;
       if (var167 <= 0) {
        // line number 604
        var170 = phi68;
        var171 = (phi148) | 0;
        var170.edgeIndex = var171;
        // line number 605
        var172 = phi68;
        var173 = phi149;
        var172.separation = var173;
        // line number 606
        return;
       } else {
        // line number 597
        var168 = (phi158) | 0;
        // line number 598
        var169 = var165;
        // Here was a goto statement
        phi80 = (phi158) | 0;
        phi114 = var165;
        phi148 = (var168) | 0;
        phi149 = var169;
        continue L1391851734;
       }
      }
     } else {
      // line number 549
      var85 = phi74;
      var86 = (phi82) | 0;
      var87 = (var85.data[var86]);
      // line number 550
      var88 = (var87.x);
      var89 = phi78;
      var90 = (var88 * var89);
      var91 = (var87.y);
      var92 = phi79;
      var93 = (var91 * var92);
      var94 = (var90 + var93);
      // line number 551
      var95 = phi81;
      var96 = (bytecoder.cmp(var94,var95)) | 0;
      If_294_0: {
       if (var96 <= 0) {
        phi99 = (phi80) | 0;
        phi100 = var94;
        phi101 = phi81;
        phi102 = var87;
        break If_294_0;
       } else {
        // line number 552
        var97 = var94;
        // line number 553
        var98 = (phi82) | 0;
        phi99 = (var98) | 0;
        phi100 = var94;
        phi101 = var97;
        phi102 = var87;
        break If_294_0;
       }
      }
      // line number 548
      phi82 = ((phi82 + 1)) | 0;
      // Here was a goto statement
      phi80 = (phi99) | 0;
      phi81 = phi101;
      continue L1552903458;
     }
    }
  }

  F$edgeSeparation$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$$I$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$(arg0,arg1,arg2,arg3,arg4) {
    // source file is Collision.java
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = null;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var phi11 = null;
    var phi12 = null;
    var phi13 = null;
    var phi14 = 0;
    var phi15 = null;
    var phi16 = null;
    var phi17 = 0;
    var phi18 = null;
    var phi19 = null;
    var phi20 = 0;
    var phi21 = null;
    var var22 = null;
    var phi23 = null;
    var phi24 = null;
    var phi25 = null;
    var phi26 = 0;
    var phi27 = null;
    var phi28 = null;
    var phi29 = 0;
    var phi30 = null;
    var phi31 = null;
    var phi32 = 0;
    var phi33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = null;
    var var37 = null;
    var var38 = null;
    var var39 = null;
    var var40 = 0;
    var var41 = null;
    var var42 = .0;
    var var43 = .0;
    var var44 = .0;
    var var45 = .0;
    var var46 = .0;
    var var47 = .0;
    var var48 = .0;
    var var49 = .0;
    var var50 = .0;
    var var51 = .0;
    var var52 = .0;
    var var53 = .0;
    var var54 = .0;
    var var55 = .0;
    var var56 = null;
    var var57 = .0;
    var var58 = .0;
    var var59 = .0;
    var var60 = .0;
    var var61 = .0;
    var var62 = .0;
    var var63 = .0;
    var var64 = .0;
    var var65 = .0;
    var var66 = .0;
    var var67 = .0;
    var var68 = 0;
    var var69 = .0;
    var var70 = 0;
    var phi71 = null;
    var phi72 = null;
    var phi73 = null;
    var phi74 = .0;
    var phi75 = .0;
    var phi76 = .0;
    var phi77 = .0;
    var phi78 = 0;
    var phi79 = .0;
    var phi80 = 0;
    var var81 = 0;
    var var82 = 0;
    var var83 = null;
    var var84 = 0;
    var var85 = null;
    var var86 = .0;
    var var87 = .0;
    var var88 = .0;
    var var89 = .0;
    var var90 = .0;
    var var91 = .0;
    var var92 = .0;
    var var93 = .0;
    var var94 = 0;
    var var95 = .0;
    var var96 = 0;
    var phi97 = 0;
    var phi98 = .0;
    var phi99 = null;
    var phi100 = .0;
    var var101 = null;
    var var102 = 0;
    var var103 = null;
    var var104 = null;
    var var105 = .0;
    var var106 = .0;
    var var107 = .0;
    var var108 = null;
    var var109 = .0;
    var var110 = .0;
    var var111 = .0;
    var var112 = .0;
    var var113 = null;
    var var114 = null;
    var var115 = .0;
    var var116 = .0;
    var var117 = null;
    var var118 = .0;
    var var119 = .0;
    var var120 = .0;
    var var121 = null;
    var var122 = .0;
    var var123 = .0;
    var var124 = .0;
    var var125 = .0;
    var var126 = null;
    var var127 = null;
    var var128 = .0;
    var var129 = .0;
    var var130 = null;
    var var131 = 0;
    var var132 = null;
    var var133 = null;
    var var134 = .0;
    var var135 = .0;
    var var136 = .0;
    var var137 = null;
    var var138 = .0;
    var var139 = .0;
    var var140 = .0;
    var var141 = .0;
    var var142 = null;
    var var143 = null;
    var var144 = .0;
    var var145 = .0;
    var var146 = .0;
    var var147 = null;
    var var148 = .0;
    var var149 = .0;
    var var150 = .0;
    var var151 = null;
    var var152 = .0;
    var var153 = .0;
    var var154 = .0;
    var var155 = .0;
    var var156 = null;
    var var157 = null;
    var var158 = .0;
    var var159 = .0;
    var var160 = .0;
    var var161 = .0;
    var var162 = .0;
    var var163 = .0;
    var var164 = .0;
    var var165 = .0;
    var0 = arg0;
    var1 = (arg2) | 0;
    var2 = arg4;
    // line number 440
    var3 = ((var0.m_count)) | 0;
    // line number 441
    var4 = (var0.m_vertices);
    // line number 442
    var5 = (var0.m_normals);
    // line number 444
    var6 = ((arg3.m_count)) | 0;
    // line number 445
    var7 = (arg3.m_vertices);
    // line number 447
    org$jbox2d$collision$Collision.$i;
    var8 = (org$jbox2d$collision$Collision.$assertionsDisabled);
    If_45_0: {
     if (var8 != 0) {
      phi23 = this;
      phi24 = var0;
      phi25 = arg1;
      phi26 = (var1) | 0;
      phi27 = arg3;
      phi28 = var2;
      phi29 = (var3) | 0;
      phi30 = var4;
      phi31 = var5;
      phi32 = (var6) | 0;
      phi33 = var7;
      break If_45_0;
     } else {
      var9 = (0) | 0;
      If_51_0: {
       if (var9 > var1) {
        phi11 = this;
        phi12 = var0;
        phi13 = arg1;
        phi14 = (var1) | 0;
        phi15 = arg3;
        phi16 = var2;
        phi17 = (var3) | 0;
        phi18 = var4;
        phi19 = var5;
        phi20 = (var6) | 0;
        phi21 = var7;
        break If_51_0;
       } else {
        var10 = (var1) | 0;
        if (var10 < var3) {
         phi23 = this;
         phi24 = var0;
         phi25 = arg1;
         phi26 = (var1) | 0;
         phi27 = arg3;
         phi28 = var2;
         phi29 = (var3) | 0;
         phi30 = var4;
         phi31 = var5;
         phi32 = (var6) | 0;
         phi33 = var7;
         break If_45_0;
        } else {
         phi11 = this;
         phi12 = var0;
         phi13 = arg1;
         phi14 = (var1) | 0;
         phi15 = arg3;
         phi16 = var2;
         phi17 = (var3) | 0;
         phi18 = var4;
         phi19 = var5;
         phi20 = (var6) | 0;
         phi21 = var7;
         break If_51_0;
        }
       }
      }
      var22 = new java$lang$AssertionError();
      java$lang$AssertionError.prototype.V$$init$$$.call(var22);
      throw bytecoder.registerStack(var22, new Error().stack);
     }
    }
    // line number 459
    var34 = phi25;
    var35 = (var34.q);
    // line number 460
    var36 = phi28;
    var37 = (var36.q);
    // line number 461
    var38 = var35;
    // line number 462
    var39 = phi31;
    var40 = (phi26) | 0;
    var41 = (var39.data[var40]);
    // line number 463
    var42 = (var38.c);
    var43 = (var41.x);
    var44 = (var42 * var43);
    var45 = (var38.s);
    var46 = (var41.y);
    var47 = (var45 * var46);
    var48 = (var44 - var47);
    // line number 464
    var49 = (var38.s);
    var50 = (var41.x);
    var51 = (var49 * var50);
    var52 = (var38.c);
    var53 = (var41.y);
    var54 = (var52 * var53);
    var55 = (var51 + var54);
    // line number 465
    var56 = var37;
    // line number 466
    var57 = (var56.c);
    var58 = (var57 * var48);
    var59 = (var56.s);
    var60 = (var59 * var55);
    var61 = (var58 + var60);
    // line number 467
    var62 = (var56.s);
    var63 = (0 - var62);
    var64 = (var63 * var48);
    var65 = (var56.c);
    var66 = (var65 * var55);
    var67 = (var64 + var66);
    // line number 471
    var68 = (0) | 0;
    // line number 472
    var69 = 3.4028235E38;
    // line number 474
    var70 = (0) | 0;
    phi71 = var35;
    phi72 = var37;
    phi73 = var41;
    phi74 = var48;
    phi75 = var55;
    phi76 = var61;
    phi77 = var67;
    phi78 = (var68) | 0;
    phi79 = var69;
    phi80 = (var70) | 0;
    L389985918: while(true) {
     var81 = (phi80) | 0;
     var82 = (phi32) | 0;
     if (var81 >= var82) {
      // line number 493
      var101 = phi30;
      var102 = (phi26) | 0;
      var103 = (var101.data[var102]);
      // line number 494
      var104 = phi71;
      var105 = (var104.c);
      var106 = (var103.x);
      var107 = (var105 * var106);
      var108 = phi71;
      var109 = (var108.s);
      var110 = (var103.y);
      var111 = (var109 * var110);
      var112 = (var107 - var111);
      var113 = phi25;
      var114 = (var113.p);
      var115 = (var114.x);
      var116 = (var112 + var115);
      // line number 495
      var117 = phi71;
      var118 = (var117.s);
      var119 = (var103.x);
      var120 = (var118 * var119);
      var121 = phi71;
      var122 = (var121.c);
      var123 = (var103.y);
      var124 = (var122 * var123);
      var125 = (var120 + var124);
      var126 = phi25;
      var127 = (var126.p);
      var128 = (var127.y);
      var129 = (var125 + var128);
      // line number 496
      var130 = phi33;
      var131 = (phi78) | 0;
      var132 = (var130.data[var131]);
      // line number 497
      var133 = phi72;
      var134 = (var133.c);
      var135 = (var132.x);
      var136 = (var134 * var135);
      var137 = phi72;
      var138 = (var137.s);
      var139 = (var132.y);
      var140 = (var138 * var139);
      var141 = (var136 - var140);
      var142 = phi28;
      var143 = (var142.p);
      var144 = (var143.x);
      var145 = (var141 + var144);
      var146 = (var145 - var116);
      // line number 498
      var147 = phi72;
      var148 = (var147.s);
      var149 = (var132.x);
      var150 = (var148 * var149);
      var151 = phi72;
      var152 = (var151.c);
      var153 = (var132.y);
      var154 = (var152 * var153);
      var155 = (var150 + var154);
      var156 = phi28;
      var157 = (var156.p);
      var158 = (var157.y);
      var159 = (var155 + var158);
      var160 = (var159 - var129);
      // line number 500
      var161 = phi74;
      var162 = (var146 * var161);
      var163 = phi75;
      var164 = (var160 * var163);
      var165 = (var162 + var164);
      // line number 501
      return var165;
     } else {
      // line number 475
      var83 = phi33;
      var84 = (phi80) | 0;
      var85 = (var83.data[var84]);
      // line number 476
      var86 = (var85.x);
      var87 = phi76;
      var88 = (var86 * var87);
      var89 = (var85.y);
      var90 = phi77;
      var91 = (var89 * var90);
      var92 = (var88 + var91);
      // line number 477
      var93 = phi79;
      var94 = (bytecoder.cmp(var92,var93)) | 0;
      If_273_0: {
       if (var94 >= 0) {
        phi97 = (phi78) | 0;
        phi98 = phi79;
        phi99 = var85;
        phi100 = var92;
        break If_273_0;
       } else {
        // line number 478
        var95 = var92;
        // line number 479
        var96 = (phi80) | 0;
        phi97 = (var96) | 0;
        phi98 = var95;
        phi99 = var85;
        phi100 = var92;
        break If_273_0;
       }
      }
      // line number 474
      phi80 = ((phi80 + 1)) | 0;
      // Here was a goto statement
      phi78 = (phi97) | 0;
      phi79 = phi98;
      continue L389985918;
     }
    }
  }

  V$findIncidentEdge$$Lorg$jbox2d$collision$Collision$ClipVertex$$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$$I$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$(arg0,arg1,arg2,arg3,arg4,arg5) {
    // source file is Collision.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var phi11 = null;
    var phi12 = null;
    var phi13 = null;
    var phi14 = null;
    var phi15 = 0;
    var phi16 = null;
    var phi17 = null;
    var phi18 = 0;
    var phi19 = null;
    var phi20 = 0;
    var phi21 = null;
    var phi22 = null;
    var var23 = null;
    var phi24 = null;
    var phi25 = null;
    var phi26 = null;
    var phi27 = null;
    var phi28 = 0;
    var phi29 = null;
    var phi30 = null;
    var phi31 = 0;
    var phi32 = null;
    var phi33 = 0;
    var phi34 = null;
    var phi35 = null;
    var var36 = null;
    var var37 = null;
    var var38 = null;
    var var39 = null;
    var var40 = null;
    var var41 = null;
    var var42 = null;
    var var43 = null;
    var var44 = null;
    var var45 = 0;
    var var46 = null;
    var var47 = .0;
    var var48 = .0;
    var var49 = .0;
    var var50 = .0;
    var var51 = .0;
    var var52 = .0;
    var var53 = .0;
    var var54 = .0;
    var var55 = .0;
    var var56 = .0;
    var var57 = .0;
    var var58 = .0;
    var var59 = .0;
    var var60 = .0;
    var var61 = .0;
    var var62 = .0;
    var var63 = .0;
    var var64 = .0;
    var var65 = .0;
    var var66 = .0;
    var var67 = .0;
    var var68 = .0;
    var var69 = .0;
    var var70 = .0;
    var var71 = .0;
    var var72 = 0;
    var var73 = .0;
    var var74 = 0;
    var phi75 = null;
    var phi76 = null;
    var phi77 = null;
    var phi78 = .0;
    var phi79 = .0;
    var phi80 = .0;
    var phi81 = 0;
    var phi82 = .0;
    var phi83 = 0;
    var var84 = 0;
    var var85 = 0;
    var var86 = null;
    var var87 = 0;
    var var88 = null;
    var var89 = .0;
    var var90 = .0;
    var var91 = .0;
    var var92 = .0;
    var var93 = .0;
    var var94 = .0;
    var var95 = .0;
    var var96 = .0;
    var var97 = 0;
    var var98 = .0;
    var var99 = 0;
    var phi100 = 0;
    var phi101 = .0;
    var phi102 = null;
    var phi103 = .0;
    var var104 = 0;
    var var105 = 0;
    var var106 = 0;
    var var107 = 0;
    var var108 = 0;
    var phi109 = 0;
    var phi110 = 0;
    var var111 = 0;
    var var112 = null;
    var var113 = 0;
    var var114 = null;
    var var115 = null;
    var var116 = null;
    var var117 = null;
    var var118 = .0;
    var var119 = .0;
    var var120 = .0;
    var var121 = null;
    var var122 = .0;
    var var123 = .0;
    var var124 = .0;
    var var125 = .0;
    var var126 = null;
    var var127 = null;
    var var128 = .0;
    var var129 = .0;
    var var130 = null;
    var var131 = .0;
    var var132 = .0;
    var var133 = .0;
    var var134 = null;
    var var135 = .0;
    var var136 = .0;
    var var137 = .0;
    var var138 = .0;
    var var139 = null;
    var var140 = null;
    var var141 = .0;
    var var142 = .0;
    var var143 = null;
    var var144 = null;
    var var145 = 0;
    var var146 = 0;
    var var147 = null;
    var var148 = null;
    var var149 = 0;
    var var150 = 0;
    var var151 = null;
    var var152 = null;
    var var153 = null;
    var var154 = 0;
    var var155 = 0;
    var var156 = null;
    var var157 = null;
    var var158 = null;
    var var159 = 0;
    var var160 = 0;
    var var161 = null;
    var var162 = null;
    var var163 = null;
    var var164 = null;
    var var165 = null;
    var var166 = .0;
    var var167 = .0;
    var var168 = .0;
    var var169 = null;
    var var170 = .0;
    var var171 = .0;
    var var172 = .0;
    var var173 = .0;
    var var174 = null;
    var var175 = null;
    var var176 = .0;
    var var177 = .0;
    var var178 = null;
    var var179 = .0;
    var var180 = .0;
    var var181 = .0;
    var var182 = null;
    var var183 = .0;
    var var184 = .0;
    var var185 = .0;
    var var186 = .0;
    var var187 = null;
    var var188 = null;
    var var189 = .0;
    var var190 = .0;
    var var191 = null;
    var var192 = null;
    var var193 = 0;
    var var194 = 0;
    var var195 = null;
    var var196 = null;
    var var197 = 0;
    var var198 = null;
    var var199 = null;
    var var200 = null;
    var var201 = 0;
    var var202 = 0;
    var var203 = null;
    var var204 = null;
    var var205 = null;
    var var206 = 0;
    var var207 = 0;
    var0 = arg0;
    var1 = arg2;
    var2 = arg4;
    // line number 611
    var3 = ((arg1.m_count)) | 0;
    // line number 612
    var4 = (arg1.m_normals);
    // line number 614
    var5 = ((var2.m_count)) | 0;
    // line number 615
    var6 = (var2.m_vertices);
    // line number 616
    var7 = (var2.m_normals);
    // line number 618
    org$jbox2d$collision$Collision.$i;
    var8 = (org$jbox2d$collision$Collision.$assertionsDisabled);
    If_46_0: {
     if (var8 != 0) {
      phi24 = this;
      phi25 = var0;
      phi26 = arg1;
      phi27 = var1;
      phi28 = (arg3) | 0;
      phi29 = var2;
      phi30 = arg5;
      phi31 = (var3) | 0;
      phi32 = var4;
      phi33 = (var5) | 0;
      phi34 = var6;
      phi35 = var7;
      break If_46_0;
     } else {
      var9 = (0) | 0;
      If_52_0: {
       if (var9 > arg3) {
        phi11 = this;
        phi12 = var0;
        phi13 = arg1;
        phi14 = var1;
        phi15 = (arg3) | 0;
        phi16 = var2;
        phi17 = arg5;
        phi18 = (var3) | 0;
        phi19 = var4;
        phi20 = (var5) | 0;
        phi21 = var6;
        phi22 = var7;
        break If_52_0;
       } else {
        var10 = (arg3) | 0;
        if (var10 < var3) {
         phi24 = this;
         phi25 = var0;
         phi26 = arg1;
         phi27 = var1;
         phi28 = (arg3) | 0;
         phi29 = var2;
         phi30 = arg5;
         phi31 = (var3) | 0;
         phi32 = var4;
         phi33 = (var5) | 0;
         phi34 = var6;
         phi35 = var7;
         break If_46_0;
        } else {
         phi11 = this;
         phi12 = var0;
         phi13 = arg1;
         phi14 = var1;
         phi15 = (arg3) | 0;
         phi16 = var2;
         phi17 = arg5;
         phi18 = (var3) | 0;
         phi19 = var4;
         phi20 = (var5) | 0;
         phi21 = var6;
         phi22 = var7;
         break If_52_0;
        }
       }
      }
      var23 = new java$lang$AssertionError();
      java$lang$AssertionError.prototype.V$$init$$$.call(var23);
      throw bytecoder.registerStack(var23, new Error().stack);
     }
    }
    // line number 620
    var36 = phi25;
    var37 = (var36.data[0]);
    // line number 621
    var38 = phi25;
    var39 = (var38.data[1]);
    // line number 622
    var40 = phi27;
    var41 = (var40.q);
    // line number 623
    var42 = phi30;
    var43 = (var42.q);
    // line number 631
    var44 = phi32;
    var45 = (phi28) | 0;
    var46 = (var44.data[var45]);
    // line number 632
    var47 = (var41.c);
    var48 = (var46.x);
    var49 = (var47 * var48);
    var50 = (var41.s);
    var51 = (var46.y);
    var52 = (var50 * var51);
    var53 = (var49 - var52);
    // line number 633
    var54 = (var41.s);
    var55 = (var46.x);
    var56 = (var54 * var55);
    var57 = (var41.c);
    var58 = (var46.y);
    var59 = (var57 * var58);
    var60 = (var56 + var59);
    // line number 634
    var61 = (var43.c);
    var62 = (var61 * var53);
    var63 = (var43.s);
    var64 = (var63 * var60);
    var65 = (var62 + var64);
    // line number 635
    var66 = (var43.s);
    var67 = (0 - var66);
    var68 = (var67 * var53);
    var69 = (var43.c);
    var70 = (var69 * var60);
    var71 = (var68 + var70);
    // line number 640
    var72 = (0) | 0;
    // line number 641
    var73 = 3.4028235E38;
    // line number 642
    var74 = (0) | 0;
    phi75 = var37;
    phi76 = var39;
    phi77 = var43;
    phi78 = var53;
    phi79 = var65;
    phi80 = var71;
    phi81 = (var72) | 0;
    phi82 = var73;
    phi83 = (var74) | 0;
    L1155314414: while(true) {
     var84 = (phi83) | 0;
     var85 = (phi33) | 0;
     if (var84 >= var85) {
      // line number 652
      var104 = (phi81) | 0;
      // line number 653
      var105 = ((var104 + 1)) | 0;
      var106 = (phi33) | 0;
      If_318_0: {
       if (var105 >= var106) {
        phi109 = (var104) | 0;
        phi110 = (0) | 0;
        break If_318_0;
       } else {
        var107 = (var104) | 0;
        var108 = ((var107 + 1)) | 0;
        // Here was a goto statement
        phi109 = (var104) | 0;
        phi110 = (var108) | 0;
        break If_318_0;
       }
      }
      var111 = (phi110) | 0;
      // line number 656
      var112 = phi34;
      var113 = (phi109) | 0;
      var114 = (var112.data[var113]);
      // line number 657
      var115 = phi75;
      var116 = (var115.v);
      // line number 658
      var117 = phi77;
      var118 = (var117.c);
      var119 = (var114.x);
      var120 = (var118 * var119);
      var121 = phi77;
      var122 = (var121.s);
      var123 = (var114.y);
      var124 = (var122 * var123);
      var125 = (var120 - var124);
      var126 = phi30;
      var127 = (var126.p);
      var128 = (var127.x);
      var129 = (var125 + var128);
      var116.x = var129;
      // line number 659
      var130 = phi77;
      var131 = (var130.s);
      var132 = (var114.x);
      var133 = (var131 * var132);
      var134 = phi77;
      var135 = (var134.c);
      var136 = (var114.y);
      var137 = (var135 * var136);
      var138 = (var133 + var137);
      var139 = phi30;
      var140 = (var139.p);
      var141 = (var140.y);
      var142 = (var138 + var141);
      var116.y = var142;
      // line number 660
      var143 = phi75;
      var144 = (var143.id);
      var145 = (phi28) | 0;
      var146 = var145;
      var144.indexA = var146;
      // line number 661
      var147 = phi75;
      var148 = (var147.id);
      var149 = (phi109) | 0;
      var150 = var149;
      var148.indexB = var150;
      // line number 662
      var151 = phi75;
      var152 = (var151.id);
      org$jbox2d$collision$ContactID$Type.$i;
      var153 = (org$jbox2d$collision$ContactID$Type.FACE);
      var154 = ((var153.I$ordinal$$())) | 0;
      var155 = var154;
      var152.typeA = var155;
      // line number 663
      var156 = phi75;
      var157 = (var156.id);
      var158 = (org$jbox2d$collision$ContactID$Type.VERTEX);
      var159 = ((var158.I$ordinal$$())) | 0;
      var160 = var159;
      var157.typeB = var160;
      // line number 666
      var161 = phi34;
      var162 = (var161.data[var111]);
      // line number 667
      var163 = phi76;
      var164 = (var163.v);
      // line number 668
      var165 = phi77;
      var166 = (var165.c);
      var167 = (var162.x);
      var168 = (var166 * var167);
      var169 = phi77;
      var170 = (var169.s);
      var171 = (var162.y);
      var172 = (var170 * var171);
      var173 = (var168 - var172);
      var174 = phi30;
      var175 = (var174.p);
      var176 = (var175.x);
      var177 = (var173 + var176);
      var164.x = var177;
      // line number 669
      var178 = phi77;
      var179 = (var178.s);
      var180 = (var162.x);
      var181 = (var179 * var180);
      var182 = phi77;
      var183 = (var182.c);
      var184 = (var162.y);
      var185 = (var183 * var184);
      var186 = (var181 + var185);
      var187 = phi30;
      var188 = (var187.p);
      var189 = (var188.y);
      var190 = (var186 + var189);
      var164.y = var190;
      // line number 670
      var191 = phi76;
      var192 = (var191.id);
      var193 = (phi28) | 0;
      var194 = var193;
      var192.indexA = var194;
      // line number 671
      var195 = phi76;
      var196 = (var195.id);
      var197 = var111;
      var196.indexB = var197;
      // line number 672
      var198 = phi76;
      var199 = (var198.id);
      var200 = (org$jbox2d$collision$ContactID$Type.FACE);
      var201 = ((var200.I$ordinal$$())) | 0;
      var202 = var201;
      var199.typeA = var202;
      // line number 673
      var203 = phi76;
      var204 = (var203.id);
      var205 = (org$jbox2d$collision$ContactID$Type.VERTEX);
      var206 = ((var205.I$ordinal$$())) | 0;
      var207 = var206;
      var204.typeB = var207;
      // line number 674
      return;
     } else {
      // line number 643
      var86 = phi35;
      var87 = (phi83) | 0;
      var88 = (var86.data[var87]);
      // line number 644
      var89 = phi79;
      var90 = (var88.x);
      var91 = (var89 * var90);
      var92 = phi80;
      var93 = (var88.y);
      var94 = (var92 * var93);
      var95 = (var91 + var94);
      // line number 645
      var96 = phi82;
      var97 = (bytecoder.cmp(var95,var96)) | 0;
      If_283_0: {
       if (var97 >= 0) {
        phi100 = (phi81) | 0;
        phi101 = phi82;
        phi102 = var88;
        phi103 = var95;
        break If_283_0;
       } else {
        // line number 646
        var98 = var95;
        // line number 647
        var99 = (phi83) | 0;
        phi100 = (var99) | 0;
        phi101 = var98;
        phi102 = var88;
        phi103 = var95;
        break If_283_0;
       }
      }
      // line number 642
      phi83 = ((phi83 + 1)) | 0;
      // Here was a goto statement
      phi81 = (phi100) | 0;
      phi82 = phi101;
      continue L1155314414;
     }
    }
  }

  V$collidePolygonAndCircle$Lorg$jbox2d$collision$Manifold$$Lorg$jbox2d$collision$shapes$PolygonShape$$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$collision$shapes$CircleShape$$Lorg$jbox2d$common$Transform$(arg0,arg1,arg2,arg3,arg4) {
    // source file is Collision.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = .0;
    var var8 = .0;
    var var9 = .0;
    var var10 = .0;
    var var11 = .0;
    var var12 = .0;
    var var13 = .0;
    var var14 = null;
    var var15 = .0;
    var var16 = .0;
    var var17 = .0;
    var var18 = .0;
    var var19 = .0;
    var var20 = .0;
    var var21 = .0;
    var var22 = .0;
    var var23 = .0;
    var var24 = null;
    var var25 = .0;
    var var26 = .0;
    var var27 = null;
    var var28 = null;
    var var29 = .0;
    var var30 = .0;
    var var31 = null;
    var var32 = null;
    var var33 = .0;
    var var34 = .0;
    var var35 = .0;
    var var36 = .0;
    var var37 = .0;
    var var38 = .0;
    var var39 = .0;
    var var40 = .0;
    var var41 = .0;
    var var42 = .0;
    var var43 = .0;
    var var44 = .0;
    var var45 = .0;
    var var46 = 0;
    var var47 = .0;
    var var48 = .0;
    var var49 = .0;
    var var50 = .0;
    var var51 = 0;
    var var52 = null;
    var var53 = null;
    var var54 = 0;
    var phi55 = null;
    var phi56 = null;
    var phi57 = null;
    var phi58 = null;
    var phi59 = null;
    var phi60 = .0;
    var phi61 = .0;
    var phi62 = .0;
    var phi63 = .0;
    var phi64 = 0;
    var phi65 = .0;
    var phi66 = .0;
    var phi67 = 0;
    var phi68 = null;
    var phi69 = null;
    var phi70 = 0;
    var var71 = 0;
    var var72 = 0;
    var var73 = null;
    var var74 = 0;
    var var75 = null;
    var var76 = .0;
    var var77 = .0;
    var var78 = .0;
    var var79 = .0;
    var var80 = .0;
    var var81 = .0;
    var var82 = null;
    var var83 = 0;
    var var84 = null;
    var var85 = .0;
    var var86 = .0;
    var var87 = null;
    var var88 = 0;
    var var89 = null;
    var var90 = .0;
    var var91 = .0;
    var var92 = .0;
    var var93 = .0;
    var var94 = 0;
    var var95 = .0;
    var var96 = 0;
    var var97 = .0;
    var var98 = 0;
    var phi99 = 0;
    var phi100 = .0;
    var phi101 = .0;
    var phi102 = null;
    var phi103 = .0;
    var phi104 = .0;
    var var105 = 0;
    var var106 = 0;
    var var107 = 0;
    var var108 = 0;
    var var109 = 0;
    var phi110 = 0;
    var phi111 = 0;
    var var112 = 0;
    var var113 = null;
    var var114 = 0;
    var var115 = null;
    var var116 = null;
    var var117 = null;
    var var118 = .0;
    var var119 = 0;
    var var120 = null;
    var var121 = null;
    var var122 = null;
    var var123 = null;
    var var124 = 0;
    var var125 = null;
    var var126 = null;
    var var127 = null;
    var var128 = .0;
    var var129 = null;
    var var130 = null;
    var var131 = .0;
    var var132 = null;
    var var133 = null;
    var var134 = .0;
    var var135 = .0;
    var var136 = .0;
    var var137 = .0;
    var var138 = null;
    var var139 = null;
    var var140 = .0;
    var var141 = .0;
    var var142 = .0;
    var var143 = .0;
    var var144 = null;
    var var145 = null;
    var var146 = null;
    var var147 = null;
    var var148 = null;
    var var149 = .0;
    var var150 = null;
    var var151 = null;
    var var152 = .0;
    var var153 = null;
    var var154 = .0;
    var var155 = .0;
    var var156 = .0;
    var var157 = .0;
    var var158 = .0;
    var var159 = .0;
    var var160 = .0;
    var var161 = .0;
    var var162 = .0;
    var var163 = .0;
    var var164 = .0;
    var var165 = .0;
    var var166 = .0;
    var var167 = .0;
    var var168 = .0;
    var var169 = .0;
    var var170 = .0;
    var var171 = .0;
    var var172 = .0;
    var var173 = .0;
    var var174 = .0;
    var var175 = .0;
    var var176 = .0;
    var var177 = .0;
    var var178 = .0;
    var var179 = .0;
    var var180 = .0;
    var var181 = .0;
    var var182 = .0;
    var var183 = .0;
    var var184 = .0;
    var var185 = .0;
    var var186 = .0;
    var var187 = .0;
    var var188 = 0;
    var var189 = .0;
    var var190 = .0;
    var var191 = .0;
    var var192 = .0;
    var var193 = .0;
    var var194 = .0;
    var var195 = .0;
    var var196 = .0;
    var var197 = .0;
    var var198 = .0;
    var var199 = .0;
    var var200 = .0;
    var var201 = .0;
    var var202 = .0;
    var var203 = 0;
    var var204 = null;
    var var205 = null;
    var var206 = null;
    var var207 = null;
    var var208 = null;
    var var209 = .0;
    var var210 = .0;
    var var211 = .0;
    var var212 = null;
    var var213 = null;
    var var214 = .0;
    var var215 = .0;
    var var216 = .0;
    var var217 = null;
    var var218 = null;
    var var219 = .0;
    var var220 = null;
    var var221 = null;
    var var222 = null;
    var var223 = null;
    var var224 = null;
    var var225 = null;
    var var226 = null;
    var var227 = null;
    var var228 = null;
    var var229 = null;
    var var230 = null;
    var var231 = null;
    var var232 = null;
    var phi233 = 0;
    var phi234 = null;
    var phi235 = null;
    var phi236 = .0;
    var phi237 = .0;
    var phi238 = .0;
    var phi239 = .0;
    var phi240 = .0;
    var phi241 = .0;
    var phi242 = .0;
    var phi243 = .0;
    var phi244 = .0;
    var phi245 = .0;
    var phi246 = .0;
    var phi247 = .0;
    var var248 = 0;
    var var249 = .0;
    var var250 = .0;
    var var251 = .0;
    var var252 = .0;
    var var253 = .0;
    var var254 = .0;
    var var255 = .0;
    var var256 = .0;
    var var257 = .0;
    var var258 = .0;
    var var259 = .0;
    var var260 = .0;
    var var261 = .0;
    var var262 = .0;
    var var263 = 0;
    var var264 = null;
    var var265 = null;
    var var266 = null;
    var var267 = null;
    var var268 = null;
    var var269 = .0;
    var var270 = .0;
    var var271 = .0;
    var var272 = null;
    var var273 = null;
    var var274 = .0;
    var var275 = .0;
    var var276 = .0;
    var var277 = null;
    var var278 = null;
    var var279 = .0;
    var var280 = null;
    var var281 = null;
    var var282 = null;
    var var283 = null;
    var var284 = null;
    var var285 = null;
    var var286 = null;
    var var287 = null;
    var var288 = null;
    var var289 = null;
    var var290 = null;
    var var291 = null;
    var var292 = null;
    var var293 = .0;
    var var294 = .0;
    var var295 = .0;
    var var296 = .0;
    var var297 = .0;
    var var298 = .0;
    var var299 = .0;
    var var300 = .0;
    var var301 = .0;
    var var302 = .0;
    var var303 = .0;
    var var304 = .0;
    var var305 = null;
    var var306 = 0;
    var var307 = null;
    var var308 = null;
    var var309 = .0;
    var var310 = .0;
    var var311 = null;
    var var312 = .0;
    var var313 = .0;
    var var314 = .0;
    var var315 = .0;
    var var316 = 0;
    var var317 = null;
    var var318 = null;
    var var319 = null;
    var var320 = null;
    var var321 = null;
    var var322 = null;
    var var323 = 0;
    var var324 = null;
    var var325 = null;
    var var326 = null;
    var var327 = null;
    var var328 = null;
    var var329 = null;
    var var330 = null;
    var var331 = null;
    var var332 = null;
    var var333 = null;
    var var334 = null;
    var var335 = null;
    var var336 = null;
    var var337 = null;
    var var338 = null;
    var var339 = null;
    var0 = arg0;
    var1 = arg2;
    var2 = arg4;
    // line number 250
    var3 = (0) | 0;
    var0.pointCount = var3;
    // line number 260
    var4 = (arg3.m_p);
    // line number 261
    var5 = (var2.q);
    // line number 262
    var6 = (var1.q);
    // line number 263
    var7 = (var5.c);
    var8 = (var4.x);
    var9 = (var7 * var8);
    var10 = (var5.s);
    var11 = (var4.y);
    var12 = (var10 * var11);
    var13 = (var9 - var12);
    var14 = (var2.p);
    var15 = (var14.x);
    var16 = (var13 + var15);
    // line number 264
    var17 = (var5.s);
    var18 = (var4.x);
    var19 = (var17 * var18);
    var20 = (var5.c);
    var21 = (var4.y);
    var22 = (var20 * var21);
    var23 = (var19 + var22);
    var24 = (var2.p);
    var25 = (var24.y);
    var26 = (var23 + var25);
    // line number 265
    var27 = var1;
    var28 = (var27.p);
    var29 = (var28.x);
    var30 = (var16 - var29);
    // line number 266
    var31 = var1;
    var32 = (var31.p);
    var33 = (var32.y);
    var34 = (var26 - var33);
    // line number 267
    var35 = (var6.c);
    var36 = (var35 * var30);
    var37 = (var6.s);
    var38 = (var37 * var34);
    var39 = (var36 + var38);
    // line number 268
    var40 = (var6.s);
    var41 = (0 - var40);
    var42 = (var41 * var30);
    var43 = (var6.c);
    var44 = (var43 * var34);
    var45 = (var42 + var44);
    // line number 272
    var46 = (0) | 0;
    // line number 273
    var47 = -3.4028235E38;
    // line number 274
    var48 = (arg1.m_radius);
    var49 = (arg3.m_radius);
    var50 = (var48 + var49);
    // line number 275
    var51 = ((arg1.m_count)) | 0;
    // line number 277
    var52 = (arg1.m_vertices);
    // line number 278
    var53 = (arg1.m_normals);
    // line number 280
    var54 = (0) | 0;
    phi55 = var0;
    phi56 = var1;
    phi57 = var2;
    phi58 = var4;
    phi59 = var6;
    phi60 = var26;
    phi61 = var34;
    phi62 = var39;
    phi63 = var45;
    phi64 = (var46) | 0;
    phi65 = var47;
    phi66 = var50;
    phi67 = (var51) | 0;
    phi68 = var52;
    phi69 = var53;
    phi70 = (var54) | 0;
    L748602138: while(true) {
     var71 = (phi70) | 0;
     var72 = (phi67) | 0;
     if (var71 >= var72) {
      // line number 303
      var105 = (phi64) | 0;
      // line number 304
      var106 = ((var105 + 1)) | 0;
      var107 = (phi67) | 0;
      If_344_0: {
       if (var106 >= var107) {
        phi110 = (var105) | 0;
        phi111 = (0) | 0;
        break If_344_0;
       } else {
        var108 = (var105) | 0;
        var109 = ((var108 + 1)) | 0;
        // Here was a goto statement
        phi110 = (var105) | 0;
        phi111 = (var109) | 0;
        break If_344_0;
       }
      }
      var112 = (phi111) | 0;
      // line number 305
      var113 = phi68;
      var114 = (phi110) | 0;
      var115 = (var113.data[var114]);
      // line number 306
      var116 = phi68;
      var117 = (var116.data[var112]);
      // line number 309
      var118 = phi65;
      var119 = (bytecoder.cmp(var118,1.1920929E-7)) | 0;
      if (var119 >= 0) {
       // line number 341
       var154 = phi62;
       var155 = (var115.x);
       var156 = (var154 - var155);
       // line number 342
       var157 = phi63;
       var158 = (var115.y);
       var159 = (var157 - var158);
       // line number 343
       var160 = (var117.x);
       var161 = (var115.x);
       var162 = (var160 - var161);
       // line number 344
       var163 = (var117.y);
       var164 = (var115.y);
       var165 = (var163 - var164);
       // line number 345
       var166 = var162;
       var167 = (var156 * var166);
       var168 = var165;
       var169 = (var159 * var168);
       var170 = (var167 + var169);
       // line number 347
       var171 = phi62;
       var172 = (var117.x);
       var173 = (var171 - var172);
       // line number 348
       var174 = phi63;
       var175 = (var117.y);
       var176 = (var174 - var175);
       // line number 349
       var177 = (var115.x);
       var178 = (var117.x);
       var179 = (var177 - var178);
       // line number 350
       var180 = (var115.y);
       var181 = (var117.y);
       var182 = (var180 - var181);
       // line number 351
       var183 = var179;
       var184 = (var173 * var183);
       var185 = var182;
       var186 = (var176 * var185);
       var187 = (var184 + var186);
       // line number 354
       var188 = (bytecoder.cmp(var170,0.0)) | 0;
       If_638_0: {
        if (var188 > 0) {
         var248 = (bytecoder.cmp(var187,0.0)) | 0;
         if (var248 > 0) {
          // line number 406
          var293 = (var115.x);
          var294 = (var117.x);
          var295 = (var293 + var294);
          var296 = (var295 * 0.5);
          // line number 407
          var297 = (var115.y);
          var298 = (var117.y);
          var299 = (var297 + var298);
          var300 = (var299 * 0.5);
          // line number 409
          var301 = phi62;
          var302 = (var301 - var296);
          // line number 410
          var303 = phi63;
          var304 = (var303 - var300);
          // line number 411
          var305 = phi69;
          var306 = (phi110) | 0;
          var307 = (var305.data[var306]);
          // line number 412
          var308 = var307;
          var309 = (var308.x);
          var310 = (var302 * var309);
          var311 = var307;
          var312 = (var311.y);
          var313 = (var304 * var312);
          var314 = (var310 + var313);
          // line number 413
          var315 = phi66;
          var316 = (bytecoder.cmp(var314,var315)) | 0;
          if (var316 <= 0) {
           // line number 418
           var317 = phi55;
           var317.pointCount = 1;
           // line number 419
           var318 = phi55;
           org$jbox2d$collision$Manifold$ManifoldType.$i;
           var319 = (org$jbox2d$collision$Manifold$ManifoldType.FACE_A);
           var318.type = var319;
           // line number 420
           var320 = phi55;
           var321 = (var320.localNormal);
           var322 = phi69;
           var323 = (phi110) | 0;
           var324 = (var322.data[var323]);
           var325 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var321,var324));
           // line number 421
           var326 = phi55;
           var327 = (var326.localPoint);
           var327.x = var296;
           // line number 422
           var328 = phi55;
           var329 = (var328.localPoint);
           var329.y = var300;
           // line number 423
           var330 = phi55;
           var331 = (var330.points);
           var332 = (var331.data[0]);
           var333 = (var332.localPoint);
           var334 = phi58;
           var335 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var333,var334));
           // line number 424
           var336 = phi55;
           var337 = (var336.points);
           var338 = (var337.data[0]);
           var339 = (var338.id);
           org$jbox2d$collision$ContactID.prototype.V$zero$$.call(var339);
           phi65 = var314;
           phi233 = (var112) | 0;
           phi234 = var115;
           phi235 = var117;
           phi236 = var156;
           phi237 = var159;
           phi238 = var162;
           phi239 = var165;
           phi240 = var170;
           phi241 = var173;
           phi242 = var176;
           phi243 = var179;
           phi244 = var182;
           phi245 = var187;
           phi246 = var296;
           phi247 = var300;
           break If_638_0;
          } else {
           // line number 414
           return;
          }
         } else {
          // line number 376
          var249 = phi62;
          var250 = (var117.x);
          var251 = (var249 - var250);
          // line number 377
          var252 = phi63;
          var253 = (var117.y);
          var254 = (var252 - var253);
          // line number 378
          var255 = var251;
          var256 = (var251 * var255);
          var257 = var254;
          var258 = (var254 * var257);
          var259 = (var256 + var258);
          var260 = phi66;
          var261 = phi66;
          var262 = (var260 * var261);
          var263 = (bytecoder.cmp(var259,var262)) | 0;
          if (var263 <= 0) {
           // line number 382
           var264 = phi55;
           var264.pointCount = 1;
           // line number 383
           var265 = phi55;
           org$jbox2d$collision$Manifold$ManifoldType.$i;
           var266 = (org$jbox2d$collision$Manifold$ManifoldType.FACE_A);
           var265.type = var266;
           // line number 387
           var267 = phi55;
           var268 = (var267.localNormal);
           var269 = phi62;
           var270 = (var117.x);
           var271 = (var269 - var270);
           var268.x = var271;
           // line number 388
           var272 = phi55;
           var273 = (var272.localNormal);
           var274 = phi63;
           var275 = (var117.y);
           var276 = (var274 - var275);
           var273.y = var276;
           // line number 390
           var277 = phi55;
           var278 = (var277.localNormal);
           var279 = (org$jbox2d$common$Vec2.prototype.F$normalize$$.call(var278));
           // line number 391
           var280 = phi55;
           var281 = (var280.localPoint);
           var282 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var281,var117));
           // line number 392
           var283 = phi55;
           var284 = (var283.points);
           var285 = (var284.data[0]);
           var286 = (var285.localPoint);
           var287 = phi58;
           var288 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var286,var287));
           // line number 393
           var289 = phi55;
           var290 = (var289.points);
           var291 = (var290.data[0]);
           var292 = (var291.id);
           org$jbox2d$collision$ContactID.prototype.V$zero$$.call(var292);
           // line number 394
           // Here was a goto statement
           phi233 = (var112) | 0;
           phi234 = var115;
           phi235 = var117;
           phi236 = var156;
           phi237 = var159;
           phi238 = var162;
           phi239 = var165;
           phi240 = var170;
           phi241 = var173;
           phi242 = var176;
           phi243 = var179;
           phi244 = var182;
           phi245 = var187;
           phi246 = var251;
           phi247 = var254;
           break If_638_0;
          } else {
           // line number 379
           return;
          }
         }
        } else {
         // line number 356
         var189 = phi62;
         var190 = (var115.x);
         var191 = (var189 - var190);
         // line number 357
         var192 = phi63;
         var193 = (var115.y);
         var194 = (var192 - var193);
         // line number 358
         var195 = var191;
         var196 = (var191 * var195);
         var197 = var194;
         var198 = (var194 * var197);
         var199 = (var196 + var198);
         var200 = phi66;
         var201 = phi66;
         var202 = (var200 * var201);
         var203 = (bytecoder.cmp(var199,var202)) | 0;
         if (var203 <= 0) {
          // line number 362
          var204 = phi55;
          var204.pointCount = 1;
          // line number 363
          var205 = phi55;
          org$jbox2d$collision$Manifold$ManifoldType.$i;
          var206 = (org$jbox2d$collision$Manifold$ManifoldType.FACE_A);
          var205.type = var206;
          // line number 367
          var207 = phi55;
          var208 = (var207.localNormal);
          var209 = phi62;
          var210 = (var115.x);
          var211 = (var209 - var210);
          var208.x = var211;
          // line number 368
          var212 = phi55;
          var213 = (var212.localNormal);
          var214 = phi63;
          var215 = (var115.y);
          var216 = (var214 - var215);
          var213.y = var216;
          // line number 370
          var217 = phi55;
          var218 = (var217.localNormal);
          var219 = (org$jbox2d$common$Vec2.prototype.F$normalize$$.call(var218));
          // line number 371
          var220 = phi55;
          var221 = (var220.localPoint);
          var222 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var221,var115));
          // line number 372
          var223 = phi55;
          var224 = (var223.points);
          var225 = (var224.data[0]);
          var226 = (var225.localPoint);
          var227 = phi58;
          var228 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var226,var227));
          // line number 373
          var229 = phi55;
          var230 = (var229.points);
          var231 = (var230.data[0]);
          var232 = (var231.id);
          org$jbox2d$collision$ContactID.prototype.V$zero$$.call(var232);
          // line number 374
          // Here was a goto statement
          phi233 = (var112) | 0;
          phi234 = var115;
          phi235 = var117;
          phi236 = var156;
          phi237 = var159;
          phi238 = var162;
          phi239 = var165;
          phi240 = var170;
          phi241 = var173;
          phi242 = var176;
          phi243 = var179;
          phi244 = var182;
          phi245 = var187;
          phi246 = var191;
          phi247 = var194;
          break If_638_0;
         } else {
          // line number 359
          return;
         }
        }
       }
       // line number 426
       return;
      } else {
       // line number 310
       var120 = phi55;
       var120.pointCount = 1;
       // line number 311
       var121 = phi55;
       org$jbox2d$collision$Manifold$ManifoldType.$i;
       var122 = (org$jbox2d$collision$Manifold$ManifoldType.FACE_A);
       var121.type = var122;
       // line number 318
       var123 = phi69;
       var124 = (phi64) | 0;
       var125 = (var123.data[var124]);
       // line number 319
       var126 = phi55;
       var127 = (var126.localNormal);
       var128 = (var125.x);
       var127.x = var128;
       // line number 320
       var129 = phi55;
       var130 = (var129.localNormal);
       var131 = (var125.y);
       var130.y = var131;
       // line number 321
       var132 = phi55;
       var133 = (var132.localPoint);
       var134 = (var115.x);
       var135 = (var117.x);
       var136 = (var134 + var135);
       var137 = (var136 * 0.5);
       var133.x = var137;
       // line number 322
       var138 = phi55;
       var139 = (var138.localPoint);
       var140 = (var115.y);
       var141 = (var117.y);
       var142 = (var140 + var141);
       var143 = (var142 * 0.5);
       var139.y = var143;
       // line number 323
       var144 = phi55;
       var145 = (var144.points);
       var146 = (var145.data[0]);
       // line number 324
       var147 = (var146.localPoint);
       var148 = phi58;
       var149 = (var148.x);
       var147.x = var149;
       // line number 325
       var150 = (var146.localPoint);
       var151 = phi58;
       var152 = (var151.y);
       var150.y = var152;
       // line number 326
       var153 = (var146.id);
       org$jbox2d$collision$ContactID.prototype.V$zero$$.call(var153);
       // line number 329
       return;
      }
     } else {
      // line number 285
      var73 = phi68;
      var74 = (phi70) | 0;
      var75 = (var73.data[var74]);
      // line number 286
      var76 = phi62;
      var77 = (var75.x);
      var78 = (var76 - var77);
      // line number 287
      var79 = phi63;
      var80 = (var75.y);
      var81 = (var79 - var80);
      // line number 288
      var82 = phi69;
      var83 = (phi70) | 0;
      var84 = (var82.data[var83]);
      var85 = (var84.x);
      var86 = (var85 * var78);
      var87 = phi69;
      var88 = (phi70) | 0;
      var89 = (var87.data[var88]);
      var90 = (var89.y);
      var91 = (var90 * var81);
      var92 = (var86 + var91);
      // line number 291
      var93 = phi66;
      var94 = (bytecoder.cmp(var92,var93)) | 0;
      if (var94 <= 0) {
       // line number 296
       var95 = phi65;
       var96 = (bytecoder.cmp(var92,var95)) | 0;
       If_307_0: {
        if (var96 <= 0) {
         phi99 = (phi64) | 0;
         phi100 = phi65;
         phi101 = var92;
         phi102 = var75;
         phi103 = var78;
         phi104 = var81;
         break If_307_0;
        } else {
         // line number 297
         var97 = var92;
         // line number 298
         var98 = (phi70) | 0;
         phi99 = (var98) | 0;
         phi100 = var97;
         phi101 = var92;
         phi102 = var75;
         phi103 = var78;
         phi104 = var81;
         break If_307_0;
        }
       }
       // line number 280
       phi70 = ((phi70 + 1)) | 0;
       // Here was a goto statement
       phi64 = (phi99) | 0;
       phi65 = phi100;
       continue L748602138;
      } else {
       // line number 293
       return;
      }
     }
    }
  }
}


class org$jbox2d$collision$RayCastInput extends java$lang$Object {
  nativeObject = null;

  p1 = null;
  p2 = null;
  maxFraction = 0.0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$collision$RayCastInput,[org$jbox2d$collision$RayCastInput,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is RayCastInput.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    // line number 36
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 37
    var0 = this;
    org$jbox2d$common$Vec2.$i;
    var1 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var1);
    var0.p1 = var1;
    // line number 38
    var2 = this;
    var3 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var3);
    var2.p2 = var3;
    // line number 39
    var4 = this;
    var4.maxFraction = 0.0;
    // line number 40
    return;
  }
}


class java$lang$StrictMath extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$StrictMath,[java$lang$StrictMath,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  static I$round$F(arg0) {
    return bytecoder.imports['java.lang.StrictMath'].I$round$F(arg0);
  }

  static D$sin$D(arg0) {
    return bytecoder.imports['java.lang.StrictMath'].D$sin$D(arg0);
  }

  static D$cos$D(arg0) {
    return bytecoder.imports['java.lang.StrictMath'].D$cos$D(arg0);
  }

  static D$sqrt$D(arg0) {
    return bytecoder.imports['java.lang.StrictMath'].D$sqrt$D(arg0);
  }

  V$$init$$$() {
    // source file is StrictMath.java
    // line number 22
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class java$nio$ByteOrder extends java$lang$Object {
  nativeObject = null;

  name = null;
  static BIG_ENDIAN = null;
  static LITTLE_ENDIAN = null;
  static NATIVE_ORDER = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$nio$ByteOrder,[java$nio$ByteOrder,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is ByteOrder.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var phi6 = null;
    var var7 = null;
    // line number 50
    java$nio$ByteOrder.$i;
    var0 = new java$nio$ByteOrder();
    var1 = bytecoder.stringconstants[39];
    java$nio$ByteOrder.prototype.V$$init$$Ljava$lang$String$.call(var0,var1);
    java$nio$ByteOrder.BIG_ENDIAN = var0;
    // line number 58
    var2 = new java$nio$ByteOrder();
    java$nio$ByteOrder.prototype.V$$init$$Ljava$lang$String$.call(var2,bytecoder.stringconstants[40]);
    java$nio$ByteOrder.LITTLE_ENDIAN = var2;
    // line number 64
    jdk$internal$misc$Unsafe.$i;
    var3 = (jdk$internal$misc$Unsafe.Ljdk$internal$misc$Unsafe$$getUnsafe$$());
    var4 = (jdk$internal$misc$Unsafe.prototype.Z$isBigEndian$$.call(var3));
    If_34_0: {
     if (var4 == 0) {
      var7 = (java$nio$ByteOrder.LITTLE_ENDIAN);
      phi6 = var7;
      break If_34_0;
     } else {
      // line number 65
      var5 = (java$nio$ByteOrder.BIG_ENDIAN);
      // Here was a goto statement
      phi6 = var5;
      break If_34_0;
     }
    }
    java$nio$ByteOrder.NATIVE_ORDER = phi6;
    // line number 63
    return;
  }

  V$$init$$Ljava$lang$String$(arg0) {
    // source file is ByteOrder.java
    var var0 = null;
    var var1 = null;
    var0 = arg0;
    // line number 42
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 43
    var1 = this;
    var1.name = var0;
    // line number 44
    return;
  }

  static Ljava$nio$ByteOrder$$nativeOrder$$() {
    // source file is ByteOrder.java
    var var0 = null;
    // line number 79
    java$nio$ByteOrder.$i;
    var0 = (java$nio$ByteOrder.NATIVE_ORDER);
    return var0;
  }

  Ljava$lang$String$$toString$$() {
    // source file is ByteOrder.java
    var var0 = null;
    // line number 92
    var0 = (this.name);
    return var0;
  }
}


class java$util$function$BiFunction extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$function$BiFunction,[java$util$function$BiFunction,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.Ljava$lang$Object$$apply$Ljava$lang$Object$$Ljava$lang$Object$ = impl;
  }
}


class jdk$internal$util$Preconditions extends java$lang$Object {
  nativeObject = null;

  static SIOOBE_FORMATTER = null;
  static AIOOBE_FORMATTER = null;
  static IOOBE_FORMATTER = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(jdk$internal$util$Preconditions,[jdk$internal$util$Preconditions,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is Preconditions.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    // line number 52
    var0 = new jdk$internal$util$Preconditions$1();
    jdk$internal$util$Preconditions$1.prototype.V$$init$$$.call(var0);
    jdk$internal$util$Preconditions.$i;
    var1 = (jdk$internal$util$Preconditions.Ljava$util$function$BiFunction$$outOfBoundsExceptionFormatter$Ljava$util$function$Function$(var0));
    jdk$internal$util$Preconditions.SIOOBE_FORMATTER = var1;
    // line number 60
    var2 = new jdk$internal$util$Preconditions$2();
    jdk$internal$util$Preconditions$2.prototype.V$$init$$$.call(var2);
    var3 = (jdk$internal$util$Preconditions.Ljava$util$function$BiFunction$$outOfBoundsExceptionFormatter$Ljava$util$function$Function$(var2));
    jdk$internal$util$Preconditions.AIOOBE_FORMATTER = var3;
    // line number 68
    var4 = new jdk$internal$util$Preconditions$3();
    jdk$internal$util$Preconditions$3.prototype.V$$init$$$.call(var4);
    var5 = (jdk$internal$util$Preconditions.Ljava$util$function$BiFunction$$outOfBoundsExceptionFormatter$Ljava$util$function$Function$(var4));
    jdk$internal$util$Preconditions.IOOBE_FORMATTER = var5;
    return;
  }

  static Ljava$util$function$BiFunction$$outOfBoundsExceptionFormatter$Ljava$util$function$Function$(arg0) {
    // source file is Preconditions.java
    var var0 = null;
    var var1 = null;
    // line number 210
    var0 = new jdk$internal$util$Preconditions$4();
    var1 = arg0;
    jdk$internal$util$Preconditions$4.prototype.V$$init$$Ljava$util$function$Function$.call(var0,var1);
    return var0;
  }

  static I$checkFromIndexSize$I$I$I$Ljava$util$function$BiFunction$(arg0,arg1,arg2,arg3) {
    // source file is Preconditions.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var phi8 = 0;
    var phi9 = 0;
    var phi10 = 0;
    var phi11 = null;
    var var12 = null;
    var var13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = null;
    var0 = (arg1) | 0;
    var1 = arg3;
    // line number 396
    var2 = (arg0) | 0;
    var3 = ((arg2 | var2)) | 0;
    var4 = ((var3 | var0)) | 0;
    If_19_0: {
     if (var4 < 0) {
      phi8 = (arg0) | 0;
      phi9 = (var0) | 0;
      phi10 = (arg2) | 0;
      phi11 = var1;
      break If_19_0;
     } else {
      var5 = (var0) | 0;
      var6 = (arg0) | 0;
      var7 = ((arg2 - var6)) | 0;
      if (var5 <= var7) {
       // line number 398
       return arg0;
      } else {
       phi8 = (arg0) | 0;
       phi9 = (var0) | 0;
       phi10 = (arg2) | 0;
       phi11 = var1;
       break If_19_0;
      }
     }
    }
    // line number 397
    var12 = phi11;
    var13 = (phi8) | 0;
    var14 = (phi9) | 0;
    var15 = (phi10) | 0;
    jdk$internal$util$Preconditions.$i;
    var16 = (jdk$internal$util$Preconditions.Ljava$lang$RuntimeException$$outOfBoundsCheckFromIndexSize$Ljava$util$function$BiFunction$$I$I$I(var12,var13,var14,var15));
    throw bytecoder.registerStack(var16, new Error().stack);
  }

  static Ljava$lang$RuntimeException$$outOfBoundsCheckFromIndexSize$Ljava$util$function$BiFunction$$I$I$I(arg0,arg1,arg2,arg3) {
    // source file is Preconditions.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = 0;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = null;
    var0 = (arg1) | 0;
    var1 = (arg3) | 0;
    // line number 118
    var2 = bytecoder.stringconstants[90];
    var3 = bytecoder.newarray((3),null);
    var4 = (0) | 0;
    java$lang$Integer.$i;
    var5 = (java$lang$Integer.Ljava$lang$Integer$$valueOf$I(var0));
    var3.data[var4] = var5;
    var6 = (1) | 0;
    var7 = (java$lang$Integer.Ljava$lang$Integer$$valueOf$I(arg2));
    var3.data[var6] = var7;
    var8 = (2) | 0;
    var9 = (java$lang$Integer.Ljava$lang$Integer$$valueOf$I(var1));
    var3.data[var8] = var9;
    jdk$internal$util$Preconditions.$i;
    var10 = (jdk$internal$util$Preconditions.Ljava$lang$RuntimeException$$outOfBounds$Ljava$util$function$BiFunction$$Ljava$lang$String$$$Ljava$lang$Number$(arg0,var2,var3));
    return var10;
  }

  static Ljava$lang$RuntimeException$$outOfBounds$Ljava$util$function$BiFunction$$Ljava$lang$String$$$Ljava$lang$Number$(arg0,arg1,arg2) {
    // source file is Preconditions.java
    var var0 = null;
    var var1 = null;
    var phi2 = null;
    var phi3 = null;
    var phi4 = null;
    var phi5 = null;
    var phi6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var phi12 = null;
    var phi13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var0 = arg1;
    // line number 96
    var1 = (java$util$List.Ljava$util$List$$of$$Ljava$lang$Object$(arg2));
    // line number 97
    If_15_0: {
     if (arg0 != null) {
      var14 = var0;
      var15 = (arg0.Ljava$lang$Object$$apply$Ljava$lang$Object$$Ljava$lang$Object$(var14,var1));
      var16 = var15;
      phi2 = arg0;
      phi3 = var0;
      phi4 = arg2;
      phi5 = var1;
      phi6 = var16;
      break If_15_0;
     } else {
      // line number 98
      // Here was a goto statement
      phi2 = arg0;
      phi3 = var0;
      phi4 = arg2;
      phi5 = var1;
      phi6 = null;
      break If_15_0;
     }
    }
    var7 = phi6;
    // line number 99
    If_32_0: {
     if (var7 != null) {
      phi12 = var7;
      phi13 = var7;
      break If_32_0;
     } else {
      // line number 100
      var8 = new java$lang$IndexOutOfBoundsException();
      var9 = phi3;
      var10 = phi5;
      jdk$internal$util$Preconditions.$i;
      var11 = (jdk$internal$util$Preconditions.Ljava$lang$String$$outOfBoundsMessage$Ljava$lang$String$$Ljava$util$List$(var9,var10));
      java$lang$IndexOutOfBoundsException.prototype.V$$init$$Ljava$lang$String$.call(var8,var11);
      // Here was a goto statement
      phi12 = var7;
      phi13 = var8;
      break If_32_0;
     }
    }
    // line number 99
    return phi13;
  }

  static Ljava$lang$String$$outOfBoundsMessage$Ljava$lang$String$$Ljava$util$List$(arg0,arg1) {
    // source file is Preconditions.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var phi5 = null;
    var phi6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = 0;
    var var15 = null;
    var var16 = 0;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = 0;
    var var21 = null;
    var var22 = 0;
    var phi23 = 0;
    var phi24 = null;
    var phi25 = 0;
    var var26 = 0;
    var var27 = 0;
    var phi28 = 0;
    var var29 = null;
    var var30 = 0;
    var var31 = 0;
    var var32 = null;
    var phi33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = 0;
    var phi37 = null;
    var phi38 = 0;
    var var39 = 0;
    var var40 = 0;
    var var41 = null;
    var var42 = 0;
    var var43 = null;
    var var44 = null;
    var var45 = 0;
    var var46 = null;
    var var47 = null;
    var var48 = 0;
    var var49 = null;
    var var50 = null;
    var var51 = null;
    var var52 = 0;
    var var53 = null;
    var var54 = 0;
    var var55 = null;
    var var56 = null;
    var var57 = 0;
    var var58 = null;
    var var59 = null;
    var var60 = 0;
    var var61 = null;
    var var62 = null;
    var var63 = null;
    var var64 = 0;
    var var65 = null;
    var var66 = 0;
    var var67 = null;
    var var68 = null;
    var var69 = 0;
    var var70 = null;
    var var71 = null;
    var var72 = null;
    var var73 = 0;
    var var74 = null;
    var var75 = 0;
    var var76 = null;
    var var77 = 0;
    var var78 = null;
    var var79 = null;
    var var80 = null;
    var var81 = 0;
    var var82 = 0;
    var var83 = null;
    var var84 = 0;
    var var85 = 0;
    var var86 = 0;
    var var87 = 0;
    var var88 = null;
    var var89 = 0;
    var var90 = 0;
    var var91 = 0;
    var var92 = 0;
    var var93 = 0;
    var var94 = 0;
    var var95 = 0;
    var0 = arg1;
    // line number 219
    If_7_0: {
     if (arg0 != null) {
      phi5 = arg0;
      phi6 = var0;
      break If_7_0;
     } else {
      var1 = var0;
      if (var1 != null) {
       phi5 = arg0;
       phi6 = var0;
       break If_7_0;
      } else {
       // line number 220
       var2 = (0) | 0;
       var3 = bytecoder.newarray((var2),null);
       var4 = (java$lang$String.Ljava$lang$String$$format$Ljava$lang$String$$$Ljava$lang$Object$(bytecoder.stringconstants[100],var3));
       return var4;
      }
     }
    }
    // line number 221
    var7 = phi5;
    if (var7 != null) {
     // line number 223
     var13 = phi6;
     if (var13 != null) {
      // line number 227
      // line number 228
      var19 = phi5;
      var20 = (-1) | 0;
      var21 = var19;
      var22 = ((java$lang$String.prototype.I$hashCode$$.call(var21))) | 0;
      LookupSwitch_100_0: {
       switch (var22) {
        case 1844394469: {
         var92 = (java$lang$String.prototype.Z$equals$Ljava$lang$Object$.call(var19,bytecoder.stringconstants[106]));
         if (var92 == 0) {
          phi23 = (0) | 0;
          phi24 = var19;
          phi25 = (var20) | 0;
          break LookupSwitch_100_0;
         } else {
          var93 = (1) | 0;
          // Here was a goto statement
          phi23 = (0) | 0;
          phi24 = var19;
          phi25 = (var93) | 0;
          break LookupSwitch_100_0;
         }
        }
        case -538822486: {
         var94 = (java$lang$String.prototype.Z$equals$Ljava$lang$Object$.call(var19,bytecoder.stringconstants[107]));
         if (var94 == 0) {
          phi23 = (0) | 0;
          phi24 = var19;
          phi25 = (var20) | 0;
          break LookupSwitch_100_0;
         } else {
          var95 = (0) | 0;
          // Here was a goto statement
          phi23 = (0) | 0;
          phi24 = var19;
          phi25 = (var95) | 0;
          break LookupSwitch_100_0;
         }
        }
        case 1848935233: {
         var90 = (java$lang$String.prototype.Z$equals$Ljava$lang$Object$.call(var19,bytecoder.stringconstants[90]));
         if (var90 == 0) {
          phi23 = (0) | 0;
          phi24 = var19;
          phi25 = (var20) | 0;
          break LookupSwitch_100_0;
         } else {
          var91 = (2) | 0;
          phi23 = (0) | 0;
          phi24 = var19;
          phi25 = (var91) | 0;
          break LookupSwitch_100_0;
         }
        }
        default: {
         phi23 = (0) | 0;
         phi24 = var19;
         phi25 = (var20) | 0;
         break LookupSwitch_100_0;
        }
       }
      }
      var26 = (phi25) | 0;
      TableSwitch_108_0: {
       if ((var26) >= 0 && (var26) <= 2) switch ((var26) - 0) {
        case 0: {
         // line number 230
         var89 = (2) | 0;
         // line number 231
         // Here was a goto statement
         phi28 = (var89) | 0;
         break TableSwitch_108_0;
        }
        case 1: {
         // line number 234
         var27 = (3) | 0;
         // line number 235
         // Here was a goto statement
         phi28 = (var27) | 0;
         break TableSwitch_108_0;
        }
        case 2: {
         // line number 234
         var27 = (3) | 0;
         // line number 235
         // Here was a goto statement
         phi28 = (var27) | 0;
         break TableSwitch_108_0;
        }
       } else {
        phi28 = (phi23) | 0;
        break TableSwitch_108_0;
       }
      }
      // line number 240
      var29 = phi6;
      var30 = ((var29.I$size$$())) | 0;
      var31 = (phi28) | 0;
      If_129_0: {
       if (var30 == var31) {
        var88 = phi5;
        phi33 = var88;
        break If_129_0;
       } else {
        var32 = bytecoder.stringconstants[1];
        // Here was a goto statement
        phi33 = var32;
        break If_129_0;
       }
      }
      var34 = phi33;
      var35 = var34;
      var36 = ((java$lang$String.prototype.I$hashCode$$.call(var35))) | 0;
      LookupSwitch_146_0: {
       switch (var36) {
        case 1848935233: {
         var80 = bytecoder.stringconstants[90];
         var81 = (java$lang$String.prototype.Z$equals$Ljava$lang$Object$.call(var34,var80));
         if (var81 == 0) {
          phi37 = var34;
          phi38 = (-1) | 0;
          break LookupSwitch_146_0;
         } else {
          var82 = (2) | 0;
          phi37 = var34;
          phi38 = (var82) | 0;
          break LookupSwitch_146_0;
         }
        }
        case 1844394469: {
         var83 = bytecoder.stringconstants[106];
         var84 = (java$lang$String.prototype.Z$equals$Ljava$lang$Object$.call(var34,var83));
         if (var84 == 0) {
          phi37 = var34;
          phi38 = (-1) | 0;
          break LookupSwitch_146_0;
         } else {
          var85 = (1) | 0;
          // Here was a goto statement
          phi37 = var34;
          phi38 = (var85) | 0;
          break LookupSwitch_146_0;
         }
        }
        case -538822486: {
         var86 = (java$lang$String.prototype.Z$equals$Ljava$lang$Object$.call(var34,bytecoder.stringconstants[107]));
         if (var86 == 0) {
          phi37 = var34;
          phi38 = (-1) | 0;
          break LookupSwitch_146_0;
         } else {
          var87 = (0) | 0;
          // Here was a goto statement
          phi37 = var34;
          phi38 = (var87) | 0;
          break LookupSwitch_146_0;
         }
        }
        default: {
         phi37 = var34;
         phi38 = (-1) | 0;
         break LookupSwitch_146_0;
        }
       }
      }
      var39 = (phi38) | 0;
      if ((var39) >= 0 && (var39) <= 2) switch ((var39) - 0) {
       case 0: {
        // line number 242
        var64 = (2) | 0;
        var65 = bytecoder.newarray((var64),null);
        var66 = (0) | 0;
        var67 = phi6;
        // line number 243
        var68 = (var67.Ljava$lang$Object$$get$I(0));
        var65.data[var66] = var68;
        var69 = (1) | 0;
        var70 = phi6;
        var71 = (var70.Ljava$lang$Object$$get$I(1));
        var65.data[var69] = var71;
        // line number 242
        var72 = (java$lang$String.Ljava$lang$String$$format$Ljava$lang$String$$$Ljava$lang$Object$(bytecoder.stringconstants[104],var65));
        return var72;
       }
       case 1: {
        // line number 245
        var52 = (3) | 0;
        var53 = bytecoder.newarray((var52),null);
        var54 = (0) | 0;
        var55 = phi6;
        // line number 246
        var56 = (var55.Ljava$lang$Object$$get$I(0));
        var53.data[var54] = var56;
        var57 = (1) | 0;
        var58 = phi6;
        var59 = (var58.Ljava$lang$Object$$get$I(1));
        var53.data[var57] = var59;
        var60 = (2) | 0;
        var61 = phi6;
        var62 = (var61.Ljava$lang$Object$$get$I(2));
        var53.data[var60] = var62;
        // line number 245
        var63 = (java$lang$String.Ljava$lang$String$$format$Ljava$lang$String$$$Ljava$lang$Object$(bytecoder.stringconstants[103],var53));
        return var63;
       }
       case 2: {
        // line number 248
        var40 = (3) | 0;
        var41 = bytecoder.newarray((var40),null);
        var42 = (0) | 0;
        var43 = phi6;
        // line number 249
        var44 = (var43.Ljava$lang$Object$$get$I(0));
        var41.data[var42] = var44;
        var45 = (1) | 0;
        var46 = phi6;
        var47 = (var46.Ljava$lang$Object$$get$I(1));
        var41.data[var45] = var47;
        var48 = (2) | 0;
        var49 = phi6;
        var50 = (var49.Ljava$lang$Object$$get$I(2));
        var41.data[var48] = var50;
        // line number 248
        var51 = (java$lang$String.Ljava$lang$String$$format$Ljava$lang$String$$$Ljava$lang$Object$(bytecoder.stringconstants[102],var41));
        return var51;
       }
      } else {
       // line number 251
       var73 = (2) | 0;
       var74 = bytecoder.newarray((var73),null);
       var75 = (0) | 0;
       var76 = phi5;
       var74.data[var75] = var76;
       var77 = (1) | 0;
       var78 = phi6;
       var74.data[var77] = var78;
       var79 = (java$lang$String.Ljava$lang$String$$format$Ljava$lang$String$$$Ljava$lang$Object$(bytecoder.stringconstants[105],var74));
       return var79;
      }
     } else {
      // line number 224
      var14 = (1) | 0;
      var15 = bytecoder.newarray((var14),null);
      var16 = (0) | 0;
      var17 = phi5;
      var15.data[var16] = var17;
      var18 = (java$lang$String.Ljava$lang$String$$format$Ljava$lang$String$$$Ljava$lang$Object$(bytecoder.stringconstants[101],var15));
      return var18;
     }
    } else {
     // line number 222
     var8 = (1) | 0;
     var9 = bytecoder.newarray((var8),null);
     var10 = (0) | 0;
     var11 = phi6;
     var9.data[var10] = var11;
     var12 = (java$lang$String.Ljava$lang$String$$format$Ljava$lang$String$$$Ljava$lang$Object$(bytecoder.stringconstants[101],var9));
     return var12;
    }
  }

  static I$checkIndex$I$I$Ljava$util$function$BiFunction$(arg0,arg1,arg2) {
    // source file is Preconditions.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    var phi3 = 0;
    var phi4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var var8 = null;
    var0 = (arg1) | 0;
    // line number 301
    If_8_0: {
     if (arg0 < 0) {
      phi2 = (arg0) | 0;
      phi3 = (var0) | 0;
      phi4 = arg2;
      break If_8_0;
     } else {
      var1 = (arg0) | 0;
      if (var1 < var0) {
       // line number 303
       return arg0;
      } else {
       phi2 = (arg0) | 0;
       phi3 = (var0) | 0;
       phi4 = arg2;
       break If_8_0;
      }
     }
    }
    // line number 302
    var5 = phi4;
    var6 = (phi2) | 0;
    var7 = (phi3) | 0;
    jdk$internal$util$Preconditions.$i;
    var8 = (jdk$internal$util$Preconditions.Ljava$lang$RuntimeException$$outOfBoundsCheckIndex$Ljava$util$function$BiFunction$$I$I(var5,var6,var7));
    throw bytecoder.registerStack(var8, new Error().stack);
  }

  static Ljava$lang$RuntimeException$$outOfBoundsCheckIndex$Ljava$util$function$BiFunction$$I$I(arg0,arg1,arg2) {
    // source file is Preconditions.java
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var0 = (arg1) | 0;
    // line number 106
    var1 = bytecoder.stringconstants[107];
    var2 = bytecoder.newarray((2),null);
    var3 = (0) | 0;
    java$lang$Integer.$i;
    var4 = (java$lang$Integer.Ljava$lang$Integer$$valueOf$I(var0));
    var2.data[var3] = var4;
    var5 = (1) | 0;
    var6 = (java$lang$Integer.Ljava$lang$Integer$$valueOf$I(arg2));
    var2.data[var5] = var6;
    jdk$internal$util$Preconditions.$i;
    var7 = (jdk$internal$util$Preconditions.Ljava$lang$RuntimeException$$outOfBounds$Ljava$util$function$BiFunction$$Ljava$lang$String$$$Ljava$lang$Number$(arg0,var1,var2));
    return var7;
  }

  V$$init$$$() {
    // source file is Preconditions.java
    // line number 37
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class org$jbox2d$dynamics$contacts$PositionSolverManifold extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;
  normal = null;
  point = null;
  separation = 0.0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$dynamics$contacts$PositionSolverManifold,[org$jbox2d$dynamics$contacts$PositionSolverManifold,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is ContactSolver.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    // line number 993
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(org$jbox2d$dynamics$contacts$PositionSolverManifold.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    org$jbox2d$dynamics$contacts$PositionSolverManifold.$i;
    org$jbox2d$dynamics$contacts$PositionSolverManifold.$assertionsDisabled = phi2;
    return;
  }

  V$$init$$$() {
    // source file is ContactSolver.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    // line number 993
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 995
    var0 = this;
    org$jbox2d$common$Vec2.$i;
    var1 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var1);
    var0.normal = var1;
    // line number 996
    var2 = this;
    var3 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var3);
    var2.point = var3;
    return;
  }

  V$initialize$Lorg$jbox2d$dynamics$contacts$ContactPositionConstraint$$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$common$Transform$$I(arg0,arg1,arg2,arg3) {
    // source file is ContactSolver.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var phi6 = null;
    var phi7 = null;
    var phi8 = null;
    var phi9 = null;
    var phi10 = 0;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = 0;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = 0;
    var var23 = 0;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = .0;
    var var31 = .0;
    var var32 = .0;
    var var33 = .0;
    var var34 = .0;
    var var35 = .0;
    var var36 = .0;
    var var37 = null;
    var var38 = null;
    var var39 = .0;
    var var40 = .0;
    var var41 = .0;
    var var42 = .0;
    var var43 = .0;
    var var44 = .0;
    var var45 = .0;
    var var46 = .0;
    var var47 = .0;
    var var48 = .0;
    var var49 = .0;
    var var50 = .0;
    var var51 = .0;
    var var52 = .0;
    var var53 = null;
    var var54 = null;
    var var55 = .0;
    var var56 = .0;
    var var57 = .0;
    var var58 = .0;
    var var59 = .0;
    var var60 = .0;
    var var61 = .0;
    var var62 = .0;
    var var63 = .0;
    var var64 = null;
    var var65 = null;
    var var66 = .0;
    var var67 = .0;
    var var68 = .0;
    var var69 = .0;
    var var70 = .0;
    var var71 = .0;
    var var72 = .0;
    var var73 = .0;
    var var74 = .0;
    var var75 = null;
    var var76 = null;
    var var77 = .0;
    var var78 = .0;
    var var79 = .0;
    var var80 = .0;
    var var81 = .0;
    var var82 = .0;
    var var83 = .0;
    var var84 = .0;
    var var85 = .0;
    var var86 = null;
    var var87 = null;
    var var88 = .0;
    var var89 = .0;
    var var90 = .0;
    var var91 = .0;
    var var92 = .0;
    var var93 = .0;
    var var94 = null;
    var var95 = null;
    var var96 = null;
    var var97 = .0;
    var var98 = .0;
    var var99 = null;
    var var100 = null;
    var var101 = .0;
    var var102 = .0;
    var var103 = .0;
    var var104 = null;
    var var105 = .0;
    var var106 = .0;
    var var107 = null;
    var var108 = .0;
    var var109 = .0;
    var var110 = null;
    var var111 = null;
    var var112 = null;
    var var113 = null;
    var var114 = null;
    var var115 = null;
    var var116 = .0;
    var var117 = .0;
    var var118 = null;
    var var119 = null;
    var var120 = .0;
    var var121 = .0;
    var phi122 = null;
    var phi123 = null;
    var phi124 = null;
    var phi125 = null;
    var phi126 = null;
    var phi127 = .0;
    var phi128 = .0;
    var phi129 = .0;
    var phi130 = .0;
    var phi131 = .0;
    var phi132 = .0;
    var var133 = null;
    var var134 = null;
    var var135 = null;
    var var136 = null;
    var var137 = null;
    var var138 = null;
    var var139 = .0;
    var var140 = .0;
    var var141 = .0;
    var var142 = .0;
    var var143 = .0;
    var var144 = .0;
    var var145 = .0;
    var var146 = null;
    var var147 = null;
    var var148 = .0;
    var var149 = .0;
    var var150 = .0;
    var var151 = .0;
    var var152 = .0;
    var var153 = .0;
    var var154 = .0;
    var var155 = .0;
    var var156 = .0;
    var var157 = .0;
    var var158 = .0;
    var var159 = .0;
    var var160 = .0;
    var var161 = .0;
    var var162 = null;
    var var163 = null;
    var var164 = .0;
    var var165 = .0;
    var var166 = .0;
    var var167 = .0;
    var var168 = .0;
    var var169 = .0;
    var var170 = .0;
    var var171 = .0;
    var var172 = .0;
    var var173 = null;
    var var174 = null;
    var var175 = .0;
    var var176 = .0;
    var var177 = .0;
    var var178 = .0;
    var var179 = .0;
    var var180 = .0;
    var var181 = .0;
    var var182 = .0;
    var var183 = .0;
    var var184 = null;
    var var185 = null;
    var var186 = .0;
    var var187 = .0;
    var var188 = .0;
    var var189 = .0;
    var var190 = .0;
    var var191 = .0;
    var var192 = .0;
    var var193 = .0;
    var var194 = .0;
    var var195 = null;
    var var196 = null;
    var var197 = .0;
    var var198 = .0;
    var var199 = .0;
    var var200 = .0;
    var var201 = .0;
    var var202 = .0;
    var var203 = null;
    var var204 = null;
    var var205 = null;
    var var206 = .0;
    var var207 = .0;
    var var208 = null;
    var var209 = null;
    var var210 = .0;
    var var211 = .0;
    var var212 = .0;
    var var213 = null;
    var var214 = .0;
    var var215 = .0;
    var var216 = null;
    var var217 = .0;
    var var218 = .0;
    var var219 = null;
    var var220 = null;
    var var221 = null;
    var var222 = null;
    var var223 = null;
    var var224 = null;
    var var225 = null;
    var var226 = null;
    var var227 = null;
    var var228 = .0;
    var var229 = .0;
    var var230 = .0;
    var var231 = .0;
    var var232 = .0;
    var var233 = .0;
    var var234 = .0;
    var var235 = null;
    var var236 = null;
    var var237 = .0;
    var var238 = .0;
    var var239 = .0;
    var var240 = .0;
    var var241 = .0;
    var var242 = .0;
    var var243 = .0;
    var var244 = .0;
    var var245 = .0;
    var var246 = null;
    var var247 = null;
    var var248 = .0;
    var var249 = .0;
    var var250 = .0;
    var var251 = .0;
    var var252 = .0;
    var var253 = .0;
    var var254 = .0;
    var var255 = .0;
    var var256 = .0;
    var var257 = null;
    var var258 = null;
    var var259 = .0;
    var var260 = .0;
    var var261 = .0;
    var var262 = .0;
    var var263 = .0;
    var var264 = .0;
    var var265 = .0;
    var var266 = .0;
    var var267 = .0;
    var var268 = null;
    var var269 = null;
    var var270 = .0;
    var var271 = .0;
    var var272 = null;
    var var273 = null;
    var var274 = .0;
    var var275 = .0;
    var var276 = null;
    var var277 = null;
    var var278 = .0;
    var var279 = .0;
    var var280 = null;
    var var281 = null;
    var var282 = .0;
    var var283 = null;
    var var284 = null;
    var var285 = .0;
    var var286 = .0;
    var var287 = .0;
    var var288 = null;
    var var289 = null;
    var var290 = .0;
    var var291 = .0;
    var var292 = .0;
    var var293 = .0;
    var var294 = .0;
    var var295 = .0;
    var var296 = .0;
    var var297 = null;
    var var298 = null;
    var var299 = null;
    var var300 = .0;
    var var301 = .0;
    var var302 = null;
    var var303 = null;
    var var304 = .0;
    var var305 = .0;
    var var306 = .0;
    var var307 = null;
    var var308 = .0;
    var var309 = .0;
    var var310 = null;
    var var311 = .0;
    var var312 = .0;
    var0 = arg0;
    var1 = arg2;
    // line number 1000
    org$jbox2d$dynamics$contacts$PositionSolverManifold.$i;
    var2 = (org$jbox2d$dynamics$contacts$PositionSolverManifold.$assertionsDisabled);
    If_17_0: {
     if (var2 != 0) {
      phi6 = this;
      phi7 = var0;
      phi8 = arg1;
      phi9 = var1;
      phi10 = (arg3) | 0;
      break If_17_0;
     } else {
      var3 = var0;
      var4 = ((var3.pointCount)) | 0;
      if (var4 > 0) {
       phi6 = this;
       phi7 = var0;
       phi8 = arg1;
       phi9 = var1;
       phi10 = (arg3) | 0;
       break If_17_0;
      } else {
       var5 = new java$lang$AssertionError();
       java$lang$AssertionError.prototype.V$$init$$$.call(var5);
       throw bytecoder.registerStack(var5, new Error().stack);
      }
     }
    }
    // line number 1002
    var11 = phi8;
    var12 = (var11.q);
    // line number 1003
    var13 = phi9;
    var14 = (var13.q);
    // line number 1004
    var15 = phi7;
    var16 = (var15.localPoints);
    var17 = (phi10) | 0;
    var18 = (var16.data[var17]);
    // line number 1005
    org$jbox2d$dynamics$contacts$PositionSolverManifold$1.$i;
    var19 = (org$jbox2d$dynamics$contacts$PositionSolverManifold$1.$SwitchMap$org$jbox2d$collision$Manifold$ManifoldType);
    var20 = phi7;
    var21 = (var20.type);
    var22 = ((var21.I$ordinal$$())) | 0;
    var23 = ((var19.data[var22])) | 0;
    TableSwitch_85_0: {
     if ((var23) >= 1 && (var23) <= 3) switch ((var23) - 1) {
      case 0: {
       // line number 1015
       var223 = phi7;
       var224 = (var223.localPoint);
       // line number 1016
       var225 = phi7;
       var226 = (var225.localPoints);
       var227 = (var226.data[0]);
       // line number 1017
       var228 = (var12.c);
       var229 = (var224.x);
       var230 = (var228 * var229);
       var231 = (var12.s);
       var232 = (var224.y);
       var233 = (var231 * var232);
       var234 = (var230 - var233);
       var235 = phi8;
       var236 = (var235.p);
       var237 = (var236.x);
       var238 = (var234 + var237);
       // line number 1018
       var239 = (var12.s);
       var240 = (var224.x);
       var241 = (var239 * var240);
       var242 = (var12.c);
       var243 = (var224.y);
       var244 = (var242 * var243);
       var245 = (var241 + var244);
       var246 = phi8;
       var247 = (var246.p);
       var248 = (var247.y);
       var249 = (var245 + var248);
       // line number 1019
       var250 = (var14.c);
       var251 = (var227.x);
       var252 = (var250 * var251);
       var253 = (var14.s);
       var254 = (var227.y);
       var255 = (var253 * var254);
       var256 = (var252 - var255);
       var257 = phi9;
       var258 = (var257.p);
       var259 = (var258.x);
       var260 = (var256 + var259);
       // line number 1020
       var261 = (var14.s);
       var262 = (var227.x);
       var263 = (var261 * var262);
       var264 = (var14.c);
       var265 = (var227.y);
       var266 = (var264 * var265);
       var267 = (var263 + var266);
       var268 = phi9;
       var269 = (var268.p);
       var270 = (var269.y);
       var271 = (var267 + var270);
       // line number 1021
       var272 = phi6;
       var273 = (var272.normal);
       var274 = var238;
       var275 = (var260 - var274);
       var273.x = var275;
       // line number 1022
       var276 = phi6;
       var277 = (var276.normal);
       var278 = var249;
       var279 = (var271 - var278);
       var277.y = var279;
       // line number 1023
       var280 = phi6;
       var281 = (var280.normal);
       var282 = (org$jbox2d$common$Vec2.prototype.F$normalize$$.call(var281));
       // line number 1025
       var283 = phi6;
       var284 = (var283.point);
       var285 = var260;
       var286 = (var238 + var285);
       var287 = (var286 * 0.5);
       var284.x = var287;
       // line number 1026
       var288 = phi6;
       var289 = (var288.point);
       var290 = var271;
       var291 = (var249 + var290);
       var292 = (var291 * 0.5);
       var289.y = var292;
       // line number 1027
       var293 = var238;
       var294 = (var260 - var293);
       // line number 1028
       var295 = var249;
       var296 = (var271 - var295);
       // line number 1029
       var297 = phi6;
       var298 = phi6;
       var299 = (var298.normal);
       var300 = (var299.x);
       var301 = (var294 * var300);
       var302 = phi6;
       var303 = (var302.normal);
       var304 = (var303.y);
       var305 = (var296 * var304);
       var306 = (var301 + var305);
       var307 = phi7;
       var308 = (var307.radiusA);
       var309 = (var306 - var308);
       var310 = phi7;
       var311 = (var310.radiusB);
       var312 = (var309 - var311);
       var297.separation = var312;
       // line number 1030
       // Here was a goto statement
       phi122 = var12;
       phi123 = var14;
       phi124 = var18;
       phi125 = var224;
       phi126 = var227;
       phi127 = var238;
       phi128 = var249;
       phi129 = var260;
       phi130 = var271;
       phi131 = var294;
       phi132 = var296;
       break TableSwitch_85_0;
      }
      case 1: {
       // line number 1041
       var133 = phi7;
       var134 = (var133.localNormal);
       // line number 1042
       var135 = phi7;
       var136 = (var135.localPoint);
       // line number 1043
       var137 = phi6;
       var138 = (var137.normal);
       var139 = (var12.c);
       var140 = (var134.x);
       var141 = (var139 * var140);
       var142 = (var12.s);
       var143 = (var134.y);
       var144 = (var142 * var143);
       var145 = (var141 - var144);
       var138.x = var145;
       // line number 1044
       var146 = phi6;
       var147 = (var146.normal);
       var148 = (var12.s);
       var149 = (var134.x);
       var150 = (var148 * var149);
       var151 = (var12.c);
       var152 = (var134.y);
       var153 = (var151 * var152);
       var154 = (var150 + var153);
       var147.y = var154;
       // line number 1045
       var155 = (var12.c);
       var156 = (var136.x);
       var157 = (var155 * var156);
       var158 = (var12.s);
       var159 = (var136.y);
       var160 = (var158 * var159);
       var161 = (var157 - var160);
       var162 = phi8;
       var163 = (var162.p);
       var164 = (var163.x);
       var165 = (var161 + var164);
       // line number 1046
       var166 = (var12.s);
       var167 = (var136.x);
       var168 = (var166 * var167);
       var169 = (var12.c);
       var170 = (var136.y);
       var171 = (var169 * var170);
       var172 = (var168 + var171);
       var173 = phi8;
       var174 = (var173.p);
       var175 = (var174.y);
       var176 = (var172 + var175);
       // line number 1048
       var177 = (var14.c);
       var178 = (var18.x);
       var179 = (var177 * var178);
       var180 = (var14.s);
       var181 = (var18.y);
       var182 = (var180 * var181);
       var183 = (var179 - var182);
       var184 = phi9;
       var185 = (var184.p);
       var186 = (var185.x);
       var187 = (var183 + var186);
       // line number 1049
       var188 = (var14.s);
       var189 = (var18.x);
       var190 = (var188 * var189);
       var191 = (var14.c);
       var192 = (var18.y);
       var193 = (var191 * var192);
       var194 = (var190 + var193);
       var195 = phi9;
       var196 = (var195.p);
       var197 = (var196.y);
       var198 = (var194 + var197);
       // line number 1050
       var199 = var165;
       var200 = (var187 - var199);
       // line number 1051
       var201 = var176;
       var202 = (var198 - var201);
       // line number 1052
       var203 = phi6;
       var204 = phi6;
       var205 = (var204.normal);
       var206 = (var205.x);
       var207 = (var200 * var206);
       var208 = phi6;
       var209 = (var208.normal);
       var210 = (var209.y);
       var211 = (var202 * var210);
       var212 = (var207 + var211);
       var213 = phi7;
       var214 = (var213.radiusA);
       var215 = (var212 - var214);
       var216 = phi7;
       var217 = (var216.radiusB);
       var218 = (var215 - var217);
       var203.separation = var218;
       // line number 1053
       var219 = phi6;
       var220 = (var219.point);
       var220.x = var187;
       // line number 1054
       var221 = phi6;
       var222 = (var221.point);
       var222.y = var198;
       // line number 1055
       // Here was a goto statement
       phi122 = var12;
       phi123 = var14;
       phi124 = var18;
       phi125 = var134;
       phi126 = var136;
       phi127 = var165;
       phi128 = var176;
       phi129 = var187;
       phi130 = var198;
       phi131 = var200;
       phi132 = var202;
       break TableSwitch_85_0;
      }
      case 2: {
       // line number 1069
       var24 = phi7;
       var25 = (var24.localNormal);
       // line number 1070
       var26 = phi7;
       var27 = (var26.localPoint);
       // line number 1071
       var28 = phi6;
       var29 = (var28.normal);
       var30 = (var14.c);
       var31 = (var25.x);
       var32 = (var30 * var31);
       var33 = (var14.s);
       var34 = (var25.y);
       var35 = (var33 * var34);
       var36 = (var32 - var35);
       var29.x = var36;
       // line number 1072
       var37 = phi6;
       var38 = (var37.normal);
       var39 = (var14.s);
       var40 = (var25.x);
       var41 = (var39 * var40);
       var42 = (var14.c);
       var43 = (var25.y);
       var44 = (var42 * var43);
       var45 = (var41 + var44);
       var38.y = var45;
       // line number 1073
       var46 = (var14.c);
       var47 = (var27.x);
       var48 = (var46 * var47);
       var49 = (var14.s);
       var50 = (var27.y);
       var51 = (var49 * var50);
       var52 = (var48 - var51);
       var53 = phi9;
       var54 = (var53.p);
       var55 = (var54.x);
       var56 = (var52 + var55);
       // line number 1074
       var57 = (var14.s);
       var58 = (var27.x);
       var59 = (var57 * var58);
       var60 = (var14.c);
       var61 = (var27.y);
       var62 = (var60 * var61);
       var63 = (var59 + var62);
       var64 = phi9;
       var65 = (var64.p);
       var66 = (var65.y);
       var67 = (var63 + var66);
       // line number 1076
       var68 = (var12.c);
       var69 = (var18.x);
       var70 = (var68 * var69);
       var71 = (var12.s);
       var72 = (var18.y);
       var73 = (var71 * var72);
       var74 = (var70 - var73);
       var75 = phi8;
       var76 = (var75.p);
       var77 = (var76.x);
       var78 = (var74 + var77);
       // line number 1077
       var79 = (var12.s);
       var80 = (var18.x);
       var81 = (var79 * var80);
       var82 = (var12.c);
       var83 = (var18.y);
       var84 = (var82 * var83);
       var85 = (var81 + var84);
       var86 = phi8;
       var87 = (var86.p);
       var88 = (var87.y);
       var89 = (var85 + var88);
       // line number 1078
       var90 = var56;
       var91 = (var78 - var90);
       // line number 1079
       var92 = var67;
       var93 = (var89 - var92);
       // line number 1080
       var94 = phi6;
       var95 = phi6;
       var96 = (var95.normal);
       var97 = (var96.x);
       var98 = (var91 * var97);
       var99 = phi6;
       var100 = (var99.normal);
       var101 = (var100.y);
       var102 = (var93 * var101);
       var103 = (var98 + var102);
       var104 = phi7;
       var105 = (var104.radiusA);
       var106 = (var103 - var105);
       var107 = phi7;
       var108 = (var107.radiusB);
       var109 = (var106 - var108);
       var94.separation = var109;
       // line number 1081
       var110 = phi6;
       var111 = (var110.point);
       var111.x = var78;
       // line number 1082
       var112 = phi6;
       var113 = (var112.point);
       var113.y = var89;
       // line number 1083
       var114 = phi6;
       var115 = (var114.normal);
       var116 = (var115.x);
       var117 = (var116 * -1.0);
       var115.x = var117;
       // line number 1084
       var118 = phi6;
       var119 = (var118.normal);
       var120 = (var119.y);
       var121 = (var120 * -1.0);
       var119.y = var121;
       phi122 = var12;
       phi123 = var14;
       phi124 = var18;
       phi125 = var25;
       phi126 = var27;
       phi127 = var56;
       phi128 = var67;
       phi129 = var78;
       phi130 = var89;
       phi131 = var91;
       phi132 = var93;
       break TableSwitch_85_0;
      }
     } else {
      phi122 = var12;
      phi123 = var14;
      phi124 = var18;
      break TableSwitch_85_0;
     }
    }
    // line number 1088
    return;
  }
}


class java$lang$Character extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Character,[java$lang$Character,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  static I$compare$C$C(arg0,arg1) {
    // source file is Character.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var0 = arg1;
    // line number 36
    var1 = var0;
    var2 = ((arg0 - var1)) | 0;
    return var2;
  }

  static Ljava$lang$String$$toString$C(arg0) {
    return bytecoder.imports['java.lang.Character'].Ljava$lang$String$$toString$C(arg0);
  }
}


class java$lang$Math extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Math,[java$lang$Math,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is Math.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    // line number 21
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(de$mirkosertic$bytecoder$classlib$java$lang$TMath.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    java$lang$Math.$i;
    java$lang$Math.$assertionsDisabled = phi2;
    return;
  }

  static D$ceil$D(arg0) {
    return bytecoder.imports['java.lang.Math'].D$ceil$D(arg0);
  }

  static D$sin$D(arg0) {
    return bytecoder.imports['java.lang.Math'].D$sin$D(arg0);
  }

  static D$floor$D(arg0) {
    return bytecoder.imports['java.lang.Math'].D$floor$D(arg0);
  }

  static D$cos$D(arg0) {
    return bytecoder.imports['java.lang.Math'].D$cos$D(arg0);
  }

  static I$min$I$I(arg0,arg1) {
    return bytecoder.imports['java.lang.Math'].I$min$I$I(arg0, arg1);
  }

  static I$floorMod$I$I(arg0,arg1) {
    // source file is Math.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var0 = (arg1) | 0;
    // line number 140
    var1 = (arg0) | 0;
    java$lang$Math.$i;
    var2 = ((java$lang$Math.I$floorDiv$I$I(var1,var0))) | 0;
    var3 = ((var2 * var0)) | 0;
    var4 = ((arg0 - var3)) | 0;
    return var4;
  }

  static I$floorDiv$I$I(arg0,arg1) {
    // source file is Math.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var phi8 = 0;
    var phi9 = 0;
    var phi10 = 0;
    var var11 = 0;
    var0 = (arg1) | 0;
    // line number 144
    var1 = (var0) | 0;
    var2 = (Math.floor(arg0 / var1)) | 0;
    // line number 146
    java$lang$Integer.$i;
    var3 = ((java$lang$Integer.I$signum$I(arg0))) | 0;
    var4 = ((java$lang$Integer.I$signum$I(var0))) | 0;
    If_23_0: {
     if (var3 == var4) {
      phi8 = (arg0) | 0;
      phi9 = (var0) | 0;
      phi10 = (var2) | 0;
      break If_23_0;
     } else {
      var5 = (var2) | 0;
      var6 = ((var5 * var0)) | 0;
      if (var6 == arg0) {
       phi8 = (arg0) | 0;
       phi9 = (var0) | 0;
       phi10 = (var2) | 0;
       break If_23_0;
      } else {
       // line number 147
       var7 = ((var2 + -1)) | 0;
       phi8 = (arg0) | 0;
       phi9 = (var0) | 0;
       phi10 = (var7) | 0;
       break If_23_0;
      }
     }
    }
    // line number 149
    var11 = (phi10) | 0;
    return var11;
  }

  static F$abs$F(arg0) {
    // source file is Math.java
    var var0 = .0;
    var var1 = 0;
    var var2 = .0;
    // line number 36
    var0 = 0.0;
    var1 = (bytecoder.cmp(arg0,var0)) | 0;
    if (var1 >= 0) {
     // line number 39
     return arg0;
    } else {
     // line number 37
     var2 = (0 - arg0);
     return var2;
    }
  }

  static I$getExponent$F(arg0) {
    // source file is Math.java
    var var0 = .0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var phi12 = .0;
    var phi13 = 0;
    var phi14 = null;
    var phi15 = null;
    var phi16 = null;
    var phi17 = 0;
    var phi18 = 0;
    var var19 = 0;
    var var20 = .0;
    var var21 = null;
    var var22 = 0;
    var var23 = .0;
    var var24 = 0;
    var var25 = .0;
    var var26 = null;
    var var27 = 0;
    var var28 = .0;
    var var29 = .0;
    var var30 = 0;
    var var31 = 0;
    var var32 = 0;
    var phi33 = .0;
    var phi34 = 0;
    var var35 = 0;
    var var36 = 0;
    var var37 = 0;
    var var38 = 0;
    var var39 = null;
    var var40 = 0;
    var var41 = 0;
    var var42 = 0;
    var var43 = 0;
    var var44 = .0;
    var var45 = 0;
    var var46 = .0;
    var var47 = 0;
    var phi48 = .0;
    var phi49 = 0;
    var phi50 = null;
    var phi51 = null;
    var phi52 = null;
    var phi53 = 0;
    var phi54 = 0;
    var var55 = null;
    var var56 = 0;
    var var57 = 0;
    var phi58 = 0;
    var var59 = 0;
    var var60 = .0;
    var var61 = null;
    var var62 = 0;
    var var63 = .0;
    var var64 = 0;
    var var65 = .0;
    var var66 = null;
    var var67 = 0;
    var var68 = .0;
    var var69 = .0;
    var var70 = 0;
    var var71 = 0;
    var var72 = 0;
    var phi73 = .0;
    var phi74 = 0;
    var var75 = 0;
    var var76 = 0;
    var var77 = 0;
    var var78 = 0;
    var var79 = 0;
    var var80 = 0;
    // line number 104
    java$lang$Math.$i;
    var0 = (java$lang$Math.F$abs$F(arg0));
    // line number 105
    var1 = (0) | 0;
    // line number 106
    de$mirkosertic$bytecoder$classlib$java$lang$TMath$FloatExponents.$i;
    var2 = (de$mirkosertic$bytecoder$classlib$java$lang$TMath$FloatExponents.exponents);
    // line number 107
    var3 = (de$mirkosertic$bytecoder$classlib$java$lang$TMath$FloatExponents.negativeExponents);
    // line number 108
    var4 = (de$mirkosertic$bytecoder$classlib$java$lang$TMath$FloatExponents.negativeExponents2);
    // line number 109
    var5 = (bytecoder.cmp(var0,1.0)) | 0;
    If_39_0: {
     if (var5 <= 0) {
      var38 = (bytecoder.cmp(var0,1.0)) | 0;
      if (var38 >= 0) {
       phi12 = var0;
       phi13 = (var1) | 0;
       phi14 = var2;
       phi15 = var3;
       phi16 = var4;
       break If_39_0;
      } else {
       // line number 119
       var39 = var3;
       var40 = (var39.data.length) | 0;
       var41 = ((var40 - 1)) | 0;
       var42 = ((1 << var41)) | 0;
       // line number 120
       var43 = (0) | 0;
       // line number 121
       var44 = var0;
       var45 = (bytecoder.cmp(var44,1.1754943508222875E-38)) | 0;
       If_185_0: {
        if (var45 >= 0) {
         phi48 = var0;
         phi49 = (var1) | 0;
         phi50 = var2;
         phi51 = var3;
         phi52 = var4;
         phi53 = (var42) | 0;
         phi54 = (var43) | 0;
         break If_185_0;
        } else {
         // line number 122
         var46 = (var0 * 8388608.0);
         // line number 123
         var47 = (23) | 0;
         phi48 = var46;
         phi49 = (var1) | 0;
         phi50 = var2;
         phi51 = var3;
         phi52 = var4;
         phi53 = (var42) | 0;
         phi54 = (var47) | 0;
         break If_185_0;
        }
       }
       // line number 125
       var55 = phi52;
       var56 = (var55.data.length) | 0;
       var57 = ((var56 - 1)) | 0;
       phi58 = (var57) | 0;
       L1667710030: while(true) {
        var59 = (phi58) | 0;
        if (var59 < 0) {
         // line number 132
         var77 = (phi49) | 0;
         var78 = (phi54) | 0;
         var79 = ((var77 + var78)) | 0;
         var80 = ((0 - var79)) | 0;
         phi12 = phi48;
         phi13 = (var80) | 0;
         phi14 = phi50;
         phi15 = phi51;
         phi16 = phi52;
         phi17 = (phi53) | 0;
         phi18 = (phi54) | 0;
         break If_39_0;
        } else {
         // line number 126
         var60 = phi48;
         var61 = phi52;
         var62 = (phi58) | 0;
         var63 = (var61.data[var62]);
         var64 = (bytecoder.cmp(var60,var63)) | 0;
         If_240_0: {
          if (var64 >= 0) {
           phi73 = phi48;
           phi74 = (phi49) | 0;
           break If_240_0;
          } else {
           // line number 127
           var65 = phi48;
           var66 = phi50;
           var67 = (phi58) | 0;
           var68 = (var66.data[var67]);
           var69 = (var65 * var68);
           // line number 128
           var70 = (phi49) | 0;
           var71 = (phi53) | 0;
           var72 = ((var70 | var71)) | 0;
           phi73 = var69;
           phi74 = (var72) | 0;
           break If_240_0;
          }
         }
         // line number 130
         var75 = (phi53) | 0;
         var76 = ((var75 >>> 1)) | 0;
         // line number 125
         phi58 = ((phi58 + -1)) | 0;
         // Here was a goto statement
         phi48 = phi73;
         phi49 = (phi74) | 0;
         phi53 = (var76) | 0;
         continue L1667710030;
        }
       }
      }
     } else {
      // line number 110
      var6 = var2;
      var7 = (var6.data.length) | 0;
      var8 = ((var7 - 1)) | 0;
      var9 = ((1 << var8)) | 0;
      // line number 111
      var10 = (var2.data.length) | 0;
      var11 = ((var10 - 1)) | 0;
      phi12 = var0;
      phi13 = (var1) | 0;
      phi14 = var2;
      phi15 = var3;
      phi16 = var4;
      phi17 = (var9) | 0;
      phi18 = (var11) | 0;
      L1466579903: while(true) {
       var19 = (phi18) | 0;
       if (var19 < 0) {
        // line number 118
        // Here was a goto statement
        break If_39_0;
       } else {
        // line number 112
        var20 = phi12;
        var21 = phi14;
        var22 = (phi18) | 0;
        var23 = (var21.data[var22]);
        var24 = (bytecoder.cmp(var20,var23)) | 0;
        If_94_0: {
         if (var24 < 0) {
          phi33 = phi12;
          phi34 = (phi13) | 0;
          break If_94_0;
         } else {
          // line number 113
          var25 = phi12;
          var26 = phi15;
          var27 = (phi18) | 0;
          var28 = (var26.data[var27]);
          var29 = (var25 * var28);
          // line number 114
          var30 = (phi13) | 0;
          var31 = (phi17) | 0;
          var32 = ((var30 | var31)) | 0;
          phi33 = var29;
          phi34 = (var32) | 0;
          break If_94_0;
         }
        }
        // line number 116
        var35 = (phi17) | 0;
        var36 = ((var35 >>> 1)) | 0;
        // line number 111
        phi18 = ((phi18 + -1)) | 0;
        // Here was a goto statement
        phi12 = phi33;
        phi13 = (phi34) | 0;
        phi17 = (var36) | 0;
        continue L1466579903;
       }
      }
     }
    }
    // line number 134
    var37 = (phi13) | 0;
    return var37;
  }

  V$$init$$$() {
    // source file is Math.java
    // line number 22
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class org$jbox2d$pooling$normal$OrderedStack extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;
  size = 0;
  pool = null;
  index = 0;
  container = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$pooling$normal$OrderedStack,[org$jbox2d$pooling$normal$OrderedStack,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
    this.Ljava$lang$Object$$newInstance$$ = impl;
  }

  static V$$clinit$$$() {
    // source file is OrderedStack.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    // line number 32
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(org$jbox2d$pooling$normal$OrderedStack.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    org$jbox2d$pooling$normal$OrderedStack.$i;
    org$jbox2d$pooling$normal$OrderedStack.$assertionsDisabled = phi2;
    return;
  }

  V$$init$$I$I(arg0,arg1) {
    // source file is OrderedStack.java
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var phi5 = null;
    var phi6 = 0;
    var phi7 = 0;
    var phi8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = null;
    var var12 = null;
    var var13 = 0;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = 0;
    var var19 = null;
    var0 = (arg0) | 0;
    // line number 39
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 40
    var1 = this;
    var1.size = var0;
    // line number 41
    var2 = this;
    var3 = bytecoder.newarray((var0),null);
    var2.pool = var3;
    // line number 42
    var4 = (0) | 0;
    phi5 = this;
    phi6 = (var0) | 0;
    phi7 = (arg1) | 0;
    phi8 = (var4) | 0;
    L14058862: while(true) {
     var9 = (phi8) | 0;
     var10 = (phi6) | 0;
     if (var9 >= var10) {
      // line number 45
      var16 = phi5;
      var16.index = 0;
      // line number 46
      var17 = phi5;
      var18 = (phi7) | 0;
      var19 = bytecoder.newarray((var18),null);
      var17.container = var19;
      // line number 47
      return;
     } else {
      // line number 43
      var11 = phi5;
      var12 = (var11.pool);
      var13 = (phi8) | 0;
      var14 = phi5;
      var15 = (var14.Ljava$lang$Object$$newInstance$$());
      var12.data[var13] = var15;
      // line number 42
      phi8 = ((phi8 + 1)) | 0;
      // Here was a goto statement
      continue L14058862;
     }
    }
  }

  Ljava$lang$Object$$pop$$() {
    // source file is OrderedStack.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var phi6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = 0;
    var var11 = 0;
    var var12 = null;
    // line number 51
    org$jbox2d$pooling$normal$OrderedStack.$i;
    var0 = (org$jbox2d$pooling$normal$OrderedStack.$assertionsDisabled);
    If_9_0: {
     if (var0 != 0) {
      phi6 = this;
      break If_9_0;
     } else {
      var1 = this;
      var2 = ((var1.index)) | 0;
      var3 = ((this.size)) | 0;
      if (var2 < var3) {
       phi6 = this;
       break If_9_0;
      } else {
       var4 = new java$lang$AssertionError();
       var5 = bytecoder.stringconstants[128];
       java$lang$AssertionError.prototype.V$$init$$Ljava$lang$Object$.call(var4,var5);
       throw bytecoder.registerStack(var4, new Error().stack);
      }
     }
    }
    // line number 52
    var7 = phi6;
    var8 = (var7.pool);
    var9 = phi6;
    var10 = ((var9.index)) | 0;
    var11 = ((var10 + 1)) | 0;
    var9.index = var11;
    var12 = (var8.data[var10]);
    return var12;
  }

  V$push$I(arg0) {
    // source file is OrderedStack.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = null;
    var var6 = 0;
    var var7 = null;
    var var8 = null;
    var phi9 = null;
    var phi10 = 0;
    var0 = this;
    // line number 65
    var1 = var0;
    var2 = ((var1.index)) | 0;
    var3 = ((var2 - arg0)) | 0;
    var0.index = var3;
    // line number 66
    org$jbox2d$pooling$normal$OrderedStack.$i;
    var4 = (org$jbox2d$pooling$normal$OrderedStack.$assertionsDisabled);
    If_23_0: {
     if (var4 != 0) {
      phi9 = var0;
      phi10 = (arg0) | 0;
      break If_23_0;
     } else {
      var5 = var0;
      var6 = ((var5.index)) | 0;
      if (var6 >= 0) {
       phi9 = var0;
       phi10 = (arg0) | 0;
       break If_23_0;
      } else {
       var7 = new java$lang$AssertionError();
       var8 = bytecoder.stringconstants[129];
       java$lang$AssertionError.prototype.V$$init$$Ljava$lang$Object$.call(var7,var8);
       throw bytecoder.registerStack(var7, new Error().stack);
      }
     }
    }
    // line number 67
    return;
  }
}


class org$jbox2d$dynamics$joints$JointDef extends java$lang$Object {
  nativeObject = null;

  type = null;
  userData = null;
  bodyA = null;
  bodyB = null;
  collideConnected = false;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$dynamics$joints$JointDef,[org$jbox2d$dynamics$joints$JointDef,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is JointDef.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    // line number 34
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 35
    var0 = this;
    org$jbox2d$dynamics$joints$JointType.$i;
    var1 = (org$jbox2d$dynamics$joints$JointType.UNKNOWN);
    var0.type = var1;
    // line number 36
    var2 = this;
    var2.userData = null;
    // line number 37
    var3 = this;
    var3.bodyA = null;
    // line number 38
    var4 = this;
    var4.bodyB = null;
    // line number 39
    var5 = this;
    var5.collideConnected = 0;
    // line number 40
    return;
  }
}


class jdk$internal$foreign$MemorySessionImpl extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(jdk$internal$foreign$MemorySessionImpl,[jdk$internal$foreign$MemorySessionImpl,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$checkValidStateRaw$$() {
    // source file is MemorySessionImpl.java
    // line number 29
    return;
  }

  V$$init$$$() {
    // source file is MemorySessionImpl.java
    // line number 23
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class org$jbox2d$callbacks$QueryCallback extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$callbacks$QueryCallback,[org$jbox2d$callbacks$QueryCallback,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.Z$reportFixture$Lorg$jbox2d$dynamics$Fixture$ = impl;
  }
}


class org$jbox2d$dynamics$Filter extends java$lang$Object {
  nativeObject = null;

  categoryBits = 0;
  maskBits = 0;
  groupIndex = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$dynamics$Filter,[org$jbox2d$dynamics$Filter,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is Filter.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    // line number 51
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 52
    var0 = this;
    var0.categoryBits = 1;
    // line number 53
    var1 = this;
    var1.maskBits = 65535;
    // line number 54
    var2 = this;
    var2.groupIndex = 0;
    // line number 55
    return;
  }

  V$set$Lorg$jbox2d$dynamics$Filter$(arg0) {
    // source file is Filter.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var0 = this;
    // line number 58
    var1 = arg0;
    var2 = ((var1.categoryBits)) | 0;
    var0.categoryBits = var2;
    // line number 59
    var3 = arg0;
    var4 = ((var3.maskBits)) | 0;
    var0.maskBits = var4;
    // line number 60
    var5 = ((arg0.groupIndex)) | 0;
    var0.groupIndex = var5;
    // line number 61
    return;
  }
}


class jdk$internal$misc$InternalLock extends java$lang$Object {
  nativeObject = null;

  static CAN_USE_INTERNAL_LOCK = false;
  lock = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(jdk$internal$misc$InternalLock,[jdk$internal$misc$InternalLock,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is InternalLock.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = 0;
    var phi5 = null;
    var phi6 = null;
    // line number 41
    java$lang$System.$i;
    var0 = (java$lang$System.Ljava$lang$String$$getProperty$Ljava$lang$String$(bytecoder.stringconstants[17]));
    // line number 42
    If_11_0: {
     If_11_1: {
      if (var0 == null) {
       phi6 = var0;
       break If_11_1;
      } else {
       var1 = var0;
       var2 = (var1.Z$isEmpty$$());
       If_18_0: {
        if (var2 != 0) {
         phi5 = var0;
         break If_18_0;
        } else {
         var3 = var0;
         var4 = (java$lang$String.prototype.Z$equals$Ljava$lang$Object$.call(var3,bytecoder.stringconstants[18]));
         if (var4 == 0) {
          phi6 = var0;
          break If_11_1;
         } else {
          phi5 = var0;
          break If_18_0;
         }
        }
       }
       // line number 43
       jdk$internal$misc$InternalLock.$i;
       jdk$internal$misc$InternalLock.CAN_USE_INTERNAL_LOCK = 0;
       // Here was a goto statement
       break If_11_0;
      }
     }
     // line number 45
     jdk$internal$misc$InternalLock.$i;
     jdk$internal$misc$InternalLock.CAN_USE_INTERNAL_LOCK = 1;
     phi5 = phi6;
     break If_11_0;
    }
    // line number 47
    return;
  }

  static Ljava$lang$Object$$newLockOr$Ljava$lang$Object$(arg0) {
    // source file is InternalLock.java
    var var0 = 0;
    var var1 = null;
    var phi2 = null;
    var phi3 = null;
    // line number 66
    jdk$internal$misc$InternalLock.$i;
    var0 = (jdk$internal$misc$InternalLock.CAN_USE_INTERNAL_LOCK);
    If_9_0: {
     if (var0 == 0) {
      phi2 = arg0;
      phi3 = arg0;
      break If_9_0;
     } else {
      var1 = new jdk$internal$misc$InternalLock();
      jdk$internal$misc$InternalLock.prototype.V$$init$$$.call(var1);
      // Here was a goto statement
      phi2 = arg0;
      phi3 = var1;
      break If_9_0;
     }
    }
    return phi3;
  }

  V$$init$$$() {
    // source file is InternalLock.java
    var var0 = null;
    var var1 = null;
    // line number 51
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 52
    var0 = this;
    var1 = new java$util$concurrent$locks$ReentrantLock();
    java$util$concurrent$locks$ReentrantLock.prototype.V$$init$$$.call(var1);
    var0.lock = var1;
    // line number 53
    return;
  }

  static Ljdk$internal$misc$InternalLock$$newLockOrNull$$() {
    // source file is InternalLock.java
    var var0 = 0;
    var var1 = null;
    var phi2 = null;
    // line number 59
    jdk$internal$misc$InternalLock.$i;
    var0 = (jdk$internal$misc$InternalLock.CAN_USE_INTERNAL_LOCK);
    If_8_0: {
     if (var0 == 0) {
      phi2 = null;
      break If_8_0;
     } else {
      var1 = new jdk$internal$misc$InternalLock();
      jdk$internal$misc$InternalLock.prototype.V$$init$$$.call(var1);
      // Here was a goto statement
      phi2 = var1;
      break If_8_0;
     }
    }
    return phi2;
  }
}


class java$util$Arrays extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$Arrays,[java$util$Arrays,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is Arrays.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    // line number 75
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(java$util$Arrays.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    java$util$Arrays.$i;
    java$util$Arrays.$assertionsDisabled = phi2;
    return;
  }

  static $Ljava$lang$Object$$copyOf$$Ljava$lang$Object$$I$Ljava$lang$Class$(arg0,arg1,arg2) {
    // source file is Arrays.java
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var phi3 = null;
    var phi4 = 0;
    var phi5 = null;
    var phi6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = 0;
    var var12 = null;
    var var13 = 0;
    var var14 = null;
    var var15 = 0;
    var var16 = null;
    var var17 = null;
    var0 = (arg1) | 0;
    // line number 58
    var1 = bytecoder.newarray((var0),null);
    var2 = var1;
    // line number 59
    phi3 = arg0;
    phi4 = (var0) | 0;
    phi5 = var2;
    phi6 = (0) | 0;
    L124499441: while(true) {
     var7 = (phi6) | 0;
     var8 = (phi4) | 0;
     var9 = phi3;
     var10 = (var9.data.length) | 0;
     java$lang$Math.$i;
     var11 = ((java$lang$Math.I$min$I$I(var8,var10))) | 0;
     if (var7 >= var11) {
      // line number 62
      var17 = phi5;
      return var17;
     } else {
      // line number 60
      var12 = phi5;
      var13 = (phi6) | 0;
      var14 = phi3;
      var15 = (phi6) | 0;
      var16 = (var14.data[var15]);
      var12.data[var13] = var16;
      // line number 59
      phi6 = ((phi6 + 1)) | 0;
      // Here was a goto statement
      continue L124499441;
     }
    }
  }

  static $B$copyOf$$B$I(arg0,arg1) {
    // source file is Arrays.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var phi3 = null;
    var phi4 = 0;
    var phi5 = null;
    var phi6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = 0;
    var var12 = null;
    var var13 = 0;
    var var14 = null;
    var var15 = 0;
    var var16 = 0;
    var var17 = null;
    var0 = (arg1) | 0;
    // line number 82
    var1 = bytecoder.newarray((var0),0);
    // line number 83
    var2 = (0) | 0;
    phi3 = arg0;
    phi4 = (var0) | 0;
    phi5 = var1;
    phi6 = (var2) | 0;
    L614890505: while(true) {
     var7 = (phi6) | 0;
     var8 = (phi4) | 0;
     var9 = phi3;
     var10 = (var9.data.length) | 0;
     java$lang$Math.$i;
     var11 = ((java$lang$Math.I$min$I$I(var8,var10))) | 0;
     if (var7 >= var11) {
      // line number 86
      var17 = phi5;
      return var17;
     } else {
      // line number 84
      var12 = phi5;
      var13 = (phi6) | 0;
      var14 = phi3;
      var15 = (phi6) | 0;
      var16 = (var14.data[var15]);
      var12.data[var13] = var16;
      // line number 83
      phi6 = ((phi6 + 1)) | 0;
      // Here was a goto statement
      continue L614890505;
     }
    }
  }

  static V$sort$$Ljava$lang$Object$$I$I(arg0,arg1,arg2) {
    // source file is Arrays.java
    var var0 = 0;
    var var1 = 0;
    var0 = (arg1) | 0;
    // line number 30
    var1 = (var0) | 0;
    de$mirkosertic$bytecoder$classlib$java$util$Quicksort.V$quickSortComparable$$Ljava$lang$Object$$I$I(arg0,var1,arg2);
    // line number 31
    return;
  }

  V$$init$$$() {
    // source file is Arrays.java
    // line number 78
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }

  static $Ljava$lang$Object$$copyOf$$Ljava$lang$Object$$I(arg0,arg1) {
    // source file is Arrays.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var0 = (arg1) | 0;
    // line number 54
    var1 = (var0) | 0;
    java$util$Arrays.$i;
    var2 = (java$util$Arrays.$Ljava$lang$Object$$copyOf$$Ljava$lang$Object$$I$Ljava$lang$Class$(arg0,var1,null));
    return var2;
  }
}


class org$jbox2d$collision$Distance$Simplex extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;
  this$0 = null;
  m_v1 = null;
  m_v2 = null;
  m_v3 = null;
  vertices = null;
  e12 = null;
  case2 = null;
  case22 = null;
  case3 = null;
  case33 = null;
  e13 = null;
  e23 = null;
  w1 = null;
  w2 = null;
  w3 = null;
  m_count = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$collision$Distance$Simplex,[org$jbox2d$collision$Distance$Simplex,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is Distance.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    // line number 104
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(org$jbox2d$collision$Distance.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    org$jbox2d$collision$Distance$Simplex.$i;
    org$jbox2d$collision$Distance$Simplex.$assertionsDisabled = phi2;
    return;
  }

  V$$init$$Lorg$jbox2d$collision$Distance$$Lorg$jbox2d$collision$Distance$1$(arg0,arg1) {
    // source file is Distance.java
    var var0 = null;
    var var1 = null;
    var0 = arg0;
    // line number 104
    var1 = var0;
    org$jbox2d$collision$Distance$Simplex.prototype.V$$init$$Lorg$jbox2d$collision$Distance$.call(this,var1);
    return;
  }

  V$$init$$Lorg$jbox2d$collision$Distance$(arg0) {
    // source file is Distance.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var0 = this;
    // line number 104
    var1 = arg0;
    var0.this$0 = var1;
    java$lang$Object.prototype.V$$init$$$.call(var0);
    // line number 105
    var2 = new org$jbox2d$collision$Distance$SimplexVertex();
    var3 = var0;
    var4 = (var3.this$0);
    org$jbox2d$collision$Distance$SimplexVertex.prototype.V$$init$$Lorg$jbox2d$collision$Distance$$Lorg$jbox2d$collision$Distance$1$.call(var2,var4,null);
    var0.m_v1 = var2;
    // line number 106
    var5 = new org$jbox2d$collision$Distance$SimplexVertex();
    var6 = var0;
    var7 = (var6.this$0);
    org$jbox2d$collision$Distance$SimplexVertex.prototype.V$$init$$Lorg$jbox2d$collision$Distance$$Lorg$jbox2d$collision$Distance$1$.call(var5,var7,null);
    var0.m_v2 = var5;
    // line number 107
    var8 = new org$jbox2d$collision$Distance$SimplexVertex();
    var9 = var0;
    var10 = (var9.this$0);
    org$jbox2d$collision$Distance$SimplexVertex.prototype.V$$init$$Lorg$jbox2d$collision$Distance$$Lorg$jbox2d$collision$Distance$1$.call(var8,var10,null);
    var0.m_v3 = var8;
    // line number 108
    var11 = bytecoder.newarray((3),null);
    var12 = var0;
    var13 = (var12.m_v1);
    var11.data[0] = var13;
    var14 = var0;
    var15 = (var14.m_v2);
    var11.data[1] = var15;
    var16 = var0;
    var17 = (var16.m_v3);
    var11.data[2] = var17;
    var0.vertices = var11;
    // line number 165
    org$jbox2d$common$Vec2.$i;
    var18 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var18);
    var0.e12 = var18;
    // line number 195
    var19 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var19);
    var0.case2 = var19;
    // line number 196
    var20 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var20);
    var0.case22 = var20;
    // line number 228
    var21 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var21);
    var0.case3 = var21;
    // line number 229
    var22 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var22);
    var0.case33 = var22;
    // line number 352
    var23 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var23);
    var0.e13 = var23;
    // line number 353
    var24 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var24);
    var0.e23 = var24;
    // line number 354
    var25 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var25);
    var0.w1 = var25;
    // line number 355
    var26 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var26);
    var0.w2 = var26;
    // line number 356
    var27 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var27);
    var0.w3 = var27;
    return;
  }

  V$readCache$Lorg$jbox2d$collision$Distance$SimplexCache$$Lorg$jbox2d$collision$Distance$DistanceProxy$$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$collision$Distance$DistanceProxy$$Lorg$jbox2d$common$Transform$(arg0,arg1,arg2,arg3,arg4) {
    // source file is Distance.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var phi7 = null;
    var phi8 = null;
    var phi9 = null;
    var phi10 = null;
    var phi11 = null;
    var phi12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = 0;
    var phi16 = 0;
    var var17 = 0;
    var var18 = null;
    var var19 = 0;
    var var20 = null;
    var var21 = null;
    var var22 = 0;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = 0;
    var var27 = 0;
    var var28 = null;
    var var29 = null;
    var var30 = 0;
    var var31 = 0;
    var var32 = null;
    var var33 = 0;
    var var34 = null;
    var var35 = null;
    var var36 = 0;
    var var37 = null;
    var var38 = null;
    var var39 = null;
    var var40 = null;
    var var41 = null;
    var var42 = null;
    var var43 = null;
    var var44 = null;
    var var45 = null;
    var var46 = null;
    var var47 = null;
    var var48 = null;
    var var49 = null;
    var var50 = 0;
    var var51 = null;
    var var52 = .0;
    var var53 = null;
    var var54 = .0;
    var var55 = .0;
    var var56 = .0;
    var var57 = 0;
    var var58 = .0;
    var var59 = .0;
    var var60 = 0;
    var var61 = .0;
    var var62 = 0;
    var phi63 = .0;
    var phi64 = .0;
    var var65 = null;
    var var66 = null;
    var var67 = 0;
    var var68 = null;
    var var69 = null;
    var var70 = null;
    var var71 = null;
    var var72 = null;
    var var73 = null;
    var var74 = null;
    var var75 = null;
    var var76 = null;
    var var77 = null;
    var var78 = null;
    var var79 = null;
    var var80 = null;
    var var81 = null;
    var var82 = null;
    var var83 = null;
    var var84 = null;
    var var85 = null;
    var var86 = null;
    var phi87 = null;
    var phi88 = null;
    var0 = arg0;
    var1 = arg2;
    var2 = arg4;
    // line number 113
    org$jbox2d$collision$Distance$Simplex.$i;
    var3 = (org$jbox2d$collision$Distance$Simplex.$assertionsDisabled);
    If_20_0: {
     if (var3 != 0) {
      phi7 = this;
      phi8 = var0;
      phi9 = arg1;
      phi10 = var1;
      phi11 = arg3;
      phi12 = var2;
      break If_20_0;
     } else {
      var4 = var0;
      var5 = ((var4.count)) | 0;
      if (var5 <= 3) {
       phi7 = this;
       phi8 = var0;
       phi9 = arg1;
       phi10 = var1;
       phi11 = arg3;
       phi12 = var2;
       break If_20_0;
      } else {
       var6 = new java$lang$AssertionError();
       java$lang$AssertionError.prototype.V$$init$$$.call(var6);
       throw bytecoder.registerStack(var6, new Error().stack);
      }
     }
    }
    // line number 116
    var13 = phi7;
    var14 = phi8;
    var15 = ((var14.count)) | 0;
    var13.m_count = var15;
    // line number 118
    phi16 = (0) | 0;
    L944989534: while(true) {
     var17 = (phi16) | 0;
     var18 = phi7;
     var19 = ((var18.m_count)) | 0;
     if (var17 >= var19) {
      // line number 132
      var49 = phi7;
      var50 = ((var49.m_count)) | 0;
      If_187_0: {
       if (var50 <= 1) {
        phi63 = phi16;
        break If_187_0;
       } else {
        // line number 133
        var51 = phi8;
        var52 = (var51.metric);
        // line number 134
        var53 = phi7;
        var54 = (org$jbox2d$collision$Distance$Simplex.prototype.F$getMetric$$.call(var53));
        // line number 135
        var55 = var52;
        var56 = (0.5 * var55);
        var57 = (bytecoder.cmp(var54,var56)) | 0;
        If_214_0: {
         if (var57 < 0) {
          phi63 = var52;
          phi64 = var54;
          break If_214_0;
         } else {
          var58 = 2.0;
          var59 = (var58 * var52);
          var60 = (bytecoder.cmp(var59,var54)) | 0;
          if (var60 < 0) {
           phi63 = var52;
           phi64 = var54;
           break If_214_0;
          } else {
           var61 = var54;
           var62 = (bytecoder.cmp(var61,1.1920929E-7)) | 0;
           if (var62 >= 0) {
            phi63 = var52;
            phi64 = var54;
            break If_187_0;
           } else {
            phi63 = var52;
            phi64 = var54;
            break If_214_0;
           }
          }
         }
        }
        // line number 137
        var65 = phi7;
        var65.m_count = 0;
        break If_187_0;
       }
      }
      // line number 142
      var66 = phi7;
      var67 = ((var66.m_count)) | 0;
      If_255_0: {
       if (var67 != 0) {
        phi87 = phi63;
        phi88 = phi64;
        break If_255_0;
       } else {
        // line number 143
        var68 = phi7;
        var69 = (var68.vertices);
        var70 = (var69.data[0]);
        // line number 144
        var70.indexA = 0;
        // line number 145
        var70.indexB = 0;
        // line number 146
        var71 = phi9;
        var72 = (org$jbox2d$collision$Distance$DistanceProxy.prototype.Lorg$jbox2d$common$Vec2$$getVertex$I.call(var71,0));
        // line number 147
        var73 = phi11;
        var74 = (org$jbox2d$collision$Distance$DistanceProxy.prototype.Lorg$jbox2d$common$Vec2$$getVertex$I.call(var73,0));
        // line number 148
        var75 = phi10;
        var76 = var70;
        var77 = (var76.wA);
        org$jbox2d$common$Transform.$i;
        org$jbox2d$common$Transform.V$mulToOutUnsafe$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var75,var72,var77);
        // line number 149
        var78 = phi12;
        var79 = var70;
        var80 = (var79.wB);
        org$jbox2d$common$Transform.V$mulToOutUnsafe$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var78,var74,var80);
        // line number 150
        var81 = (var70.w);
        var82 = (var70.wB);
        var83 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var81,var82));
        var84 = (var70.wA);
        var85 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var83,var84));
        // line number 151
        var86 = phi7;
        var86.m_count = 1;
        phi87 = var70;
        phi88 = var72;
        break If_255_0;
       }
      }
      // line number 153
      return;
     } else {
      // line number 119
      var20 = phi7;
      var21 = (var20.vertices);
      var22 = (phi16) | 0;
      var23 = (var21.data[var22]);
      // line number 120
      var24 = phi8;
      var25 = (var24.indexA);
      var26 = (phi16) | 0;
      var27 = ((var25.data[var26])) | 0;
      var23.indexA = var27;
      // line number 121
      var28 = phi8;
      var29 = (var28.indexB);
      var30 = (phi16) | 0;
      var31 = ((var29.data[var30])) | 0;
      var23.indexB = var31;
      // line number 122
      var32 = phi9;
      var33 = ((var23.indexA)) | 0;
      var34 = (org$jbox2d$collision$Distance$DistanceProxy.prototype.Lorg$jbox2d$common$Vec2$$getVertex$I.call(var32,var33));
      // line number 123
      var35 = phi11;
      var36 = ((var23.indexB)) | 0;
      var37 = (org$jbox2d$collision$Distance$DistanceProxy.prototype.Lorg$jbox2d$common$Vec2$$getVertex$I.call(var35,var36));
      // line number 124
      var38 = phi10;
      var39 = var23;
      var40 = (var39.wA);
      org$jbox2d$common$Transform.$i;
      org$jbox2d$common$Transform.V$mulToOutUnsafe$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var38,var34,var40);
      // line number 125
      var41 = phi12;
      var42 = var23;
      var43 = (var42.wB);
      org$jbox2d$common$Transform.V$mulToOutUnsafe$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var41,var37,var43);
      // line number 126
      var44 = (var23.w);
      var45 = (var23.wB);
      var46 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var44,var45));
      var47 = (var23.wA);
      var48 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var46,var47));
      // line number 127
      var23.a = 0.0;
      // line number 118
      phi16 = ((phi16 + 1)) | 0;
      // Here was a goto statement
      continue L944989534;
     }
    }
  }

  F$getMetric$$() {
    // source file is Distance.java
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = .0;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = .0;
    var var23 = 0;
    var var24 = null;
    var var25 = 0;
    var var26 = null;
    // line number 270
    var0 = ((this.m_count)) | 0;
    if ((var0) >= 0 && (var0) <= 3) switch ((var0) - 0) {
     case 0: {
      // line number 272
      org$jbox2d$collision$Distance$Simplex.$i;
      var23 = (org$jbox2d$collision$Distance$Simplex.$assertionsDisabled);
      if (var23 != 0) {
       // line number 273
       return 0.0;
      } else {
       var24 = new java$lang$AssertionError();
       java$lang$AssertionError.prototype.V$$init$$$.call(var24);
       throw bytecoder.registerStack(var24, new Error().stack);
      }
     }
     case 1: {
      // line number 276
      return 0.0;
     }
     case 2: {
      // line number 279
      var18 = (this.m_v1);
      var19 = (var18.w);
      var20 = (this.m_v2);
      var21 = (var20.w);
      org$jbox2d$common$MathUtils.$i;
      var22 = (org$jbox2d$common$MathUtils.F$distance$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var19,var21));
      return var22;
     }
     case 3: {
      // line number 282
      var1 = (this.case3);
      var2 = (this.m_v2);
      var3 = (var2.w);
      var4 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var1,var3));
      var5 = (this.m_v1);
      var6 = (var5.w);
      var7 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var4,var6));
      // line number 283
      var8 = (this.case33);
      var9 = (this.m_v3);
      var10 = (var9.w);
      var11 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var8,var10));
      var12 = (this.m_v1);
      var13 = (var12.w);
      var14 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var11,var13));
      // line number 285
      var15 = (this.case3);
      var16 = (this.case33);
      org$jbox2d$common$Vec2.$i;
      var17 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var15,var16));
      return var17;
     }
    } else {
     // line number 288
     org$jbox2d$collision$Distance$Simplex.$i;
     var25 = (org$jbox2d$collision$Distance$Simplex.$assertionsDisabled);
     if (var25 != 0) {
      // line number 289
      return 0.0;
     } else {
      var26 = new java$lang$AssertionError();
      java$lang$AssertionError.prototype.V$$init$$$.call(var26);
      throw bytecoder.registerStack(var26, new Error().stack);
     }
    }
  }

  V$getClosestPoint$Lorg$jbox2d$common$Vec2$(arg0) {
    // source file is Distance.java
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = .0;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = .0;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = 0;
    var var26 = null;
    var var27 = 0;
    var var28 = null;
    var0 = arg0;
    // line number 204
    var1 = ((this.m_count)) | 0;
    if ((var1) >= 0 && (var1) <= 3) switch ((var1) - 0) {
     case 0: {
      // line number 206
      org$jbox2d$collision$Distance$Simplex.$i;
      var25 = (org$jbox2d$collision$Distance$Simplex.$assertionsDisabled);
      if (var25 != 0) {
       // line number 207
       org$jbox2d$common$Vec2.prototype.V$setZero$$.call(var0);
       // line number 208
       return;
      } else {
       var26 = new java$lang$AssertionError();
       java$lang$AssertionError.prototype.V$$init$$$.call(var26);
       throw bytecoder.registerStack(var26, new Error().stack);
      }
     }
     case 1: {
      // line number 210
      var21 = this;
      var22 = (var21.m_v1);
      var23 = (var22.w);
      var24 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var0,var23));
      // line number 211
      return;
     }
     case 2: {
      // line number 213
      var2 = (this.case22);
      var3 = (this.m_v2);
      var4 = (var3.w);
      var5 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var2,var4));
      var6 = (this.m_v2);
      var7 = (var6.a);
      var8 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var5,var7));
      // line number 214
      var9 = (this.case2);
      var10 = (this.m_v1);
      var11 = (var10.w);
      var12 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var9,var11));
      var13 = (this.m_v1);
      var14 = (var13.a);
      var15 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var12,var14));
      var16 = (this.case22);
      var17 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var15,var16));
      // line number 215
      var18 = this;
      var19 = (var18.case2);
      var20 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var0,var19));
      // line number 216
      return;
     }
     case 3: {
      // line number 218
      org$jbox2d$common$Vec2.prototype.V$setZero$$.call(var0);
      // line number 219
      return;
     }
    } else {
     // line number 221
     org$jbox2d$collision$Distance$Simplex.$i;
     var27 = (org$jbox2d$collision$Distance$Simplex.$assertionsDisabled);
     if (var27 != 0) {
      // line number 222
      org$jbox2d$common$Vec2.prototype.V$setZero$$.call(var0);
      // line number 223
      return;
     } else {
      var28 = new java$lang$AssertionError();
      java$lang$AssertionError.prototype.V$$init$$$.call(var28);
      throw bytecoder.registerStack(var28, new Error().stack);
     }
    }
  }

  V$solve3$$() {
    // source file is Distance.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = .0;
    var var20 = null;
    var var21 = null;
    var var22 = .0;
    var var23 = .0;
    var var24 = .0;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = null;
    var var31 = null;
    var var32 = .0;
    var var33 = null;
    var var34 = null;
    var var35 = .0;
    var var36 = .0;
    var var37 = .0;
    var var38 = null;
    var var39 = null;
    var var40 = null;
    var var41 = null;
    var var42 = null;
    var var43 = null;
    var var44 = null;
    var var45 = .0;
    var var46 = null;
    var var47 = null;
    var var48 = .0;
    var var49 = .0;
    var var50 = .0;
    var var51 = null;
    var var52 = null;
    var var53 = .0;
    var var54 = null;
    var var55 = null;
    var var56 = null;
    var var57 = .0;
    var var58 = .0;
    var var59 = null;
    var var60 = null;
    var var61 = null;
    var var62 = .0;
    var var63 = .0;
    var var64 = null;
    var var65 = null;
    var var66 = null;
    var var67 = .0;
    var var68 = .0;
    var var69 = .0;
    var var70 = 0;
    var var71 = .0;
    var var72 = 0;
    var var73 = null;
    var var74 = null;
    var phi75 = null;
    var phi76 = .0;
    var phi77 = .0;
    var phi78 = .0;
    var phi79 = .0;
    var phi80 = .0;
    var phi81 = .0;
    var phi82 = .0;
    var phi83 = .0;
    var phi84 = .0;
    var phi85 = .0;
    var phi86 = .0;
    var phi87 = .0;
    var phi88 = .0;
    var phi89 = .0;
    var phi90 = .0;
    var phi91 = .0;
    var var92 = .0;
    var var93 = 0;
    var var94 = .0;
    var var95 = 0;
    var var96 = .0;
    var var97 = 0;
    var var98 = .0;
    var var99 = .0;
    var var100 = .0;
    var var101 = .0;
    var var102 = null;
    var var103 = null;
    var var104 = .0;
    var var105 = .0;
    var var106 = null;
    var var107 = null;
    var var108 = .0;
    var var109 = .0;
    var var110 = null;
    var var111 = .0;
    var var112 = 0;
    var var113 = .0;
    var var114 = 0;
    var var115 = .0;
    var var116 = 0;
    var var117 = .0;
    var var118 = .0;
    var var119 = .0;
    var var120 = .0;
    var var121 = null;
    var var122 = null;
    var var123 = .0;
    var var124 = .0;
    var var125 = null;
    var var126 = null;
    var var127 = .0;
    var var128 = .0;
    var var129 = null;
    var var130 = null;
    var var131 = null;
    var var132 = null;
    var var133 = null;
    var var134 = .0;
    var var135 = 0;
    var var136 = .0;
    var var137 = 0;
    var var138 = null;
    var var139 = null;
    var var140 = null;
    var var141 = null;
    var var142 = null;
    var var143 = null;
    var var144 = null;
    var var145 = .0;
    var var146 = 0;
    var var147 = .0;
    var var148 = 0;
    var var149 = null;
    var var150 = null;
    var var151 = null;
    var var152 = null;
    var var153 = null;
    var var154 = null;
    var var155 = null;
    var var156 = .0;
    var var157 = 0;
    var var158 = .0;
    var var159 = 0;
    var var160 = .0;
    var var161 = 0;
    var var162 = .0;
    var var163 = .0;
    var var164 = .0;
    var var165 = .0;
    var var166 = null;
    var var167 = null;
    var var168 = .0;
    var var169 = .0;
    var var170 = null;
    var var171 = null;
    var var172 = .0;
    var var173 = .0;
    var var174 = null;
    var var175 = null;
    var var176 = null;
    var var177 = null;
    var var178 = null;
    var var179 = .0;
    var var180 = .0;
    var var181 = .0;
    var var182 = .0;
    var var183 = .0;
    var var184 = .0;
    var var185 = null;
    var var186 = null;
    var var187 = .0;
    var var188 = .0;
    var var189 = null;
    var var190 = null;
    var var191 = .0;
    var var192 = .0;
    var var193 = null;
    var var194 = null;
    var var195 = .0;
    var var196 = .0;
    var var197 = null;
    // line number 367
    var0 = (this.w1);
    var1 = (this.m_v1);
    var2 = (var1.w);
    var3 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var0,var2));
    // line number 368
    var4 = (this.w2);
    var5 = (this.m_v2);
    var6 = (var5.w);
    var7 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var4,var6));
    // line number 369
    var8 = (this.w3);
    var9 = (this.m_v3);
    var10 = (var9.w);
    var11 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var8,var10));
    // line number 375
    var12 = (this.e12);
    var13 = (this.w2);
    var14 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var12,var13));
    var15 = (this.w1);
    var16 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var14,var15));
    // line number 376
    var17 = (this.w1);
    var18 = (this.e12);
    org$jbox2d$common$Vec2.$i;
    var19 = (org$jbox2d$common$Vec2.F$dot$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var17,var18));
    // line number 377
    var20 = (this.w2);
    var21 = (this.e12);
    var22 = (org$jbox2d$common$Vec2.F$dot$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var20,var21));
    // line number 378
    var23 = var22;
    // line number 379
    var24 = (0 - var19);
    // line number 385
    var25 = (this.e13);
    var26 = (this.w3);
    var27 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var25,var26));
    var28 = (this.w1);
    var29 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var27,var28));
    // line number 386
    var30 = (this.w1);
    var31 = (this.e13);
    var32 = (org$jbox2d$common$Vec2.F$dot$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var30,var31));
    // line number 387
    var33 = (this.w3);
    var34 = (this.e13);
    var35 = (org$jbox2d$common$Vec2.F$dot$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var33,var34));
    // line number 388
    var36 = var35;
    // line number 389
    var37 = (0 - var32);
    // line number 395
    var38 = (this.e23);
    var39 = (this.w3);
    var40 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var38,var39));
    var41 = (this.w2);
    var42 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var40,var41));
    // line number 396
    var43 = (this.w2);
    var44 = (this.e23);
    var45 = (org$jbox2d$common$Vec2.F$dot$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var43,var44));
    // line number 397
    var46 = (this.w3);
    var47 = (this.e23);
    var48 = (org$jbox2d$common$Vec2.F$dot$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var46,var47));
    // line number 398
    var49 = var48;
    // line number 399
    var50 = (0 - var45);
    // line number 402
    var51 = (this.e12);
    var52 = (this.e13);
    var53 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var51,var52));
    // line number 404
    var54 = this;
    var55 = (var54.w2);
    var56 = (this.w3);
    var57 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var55,var56));
    var58 = (var53 * var57);
    // line number 405
    var59 = this;
    var60 = (var59.w3);
    var61 = (this.w1);
    var62 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var60,var61));
    var63 = (var53 * var62);
    // line number 406
    var64 = this;
    var65 = (var64.w1);
    var66 = (this.w2);
    var67 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var65,var66));
    var68 = (var53 * var67);
    // line number 409
    var69 = 0.0;
    var70 = (bytecoder.cmp(var24,var69)) | 0;
    If_266_0: {
     if (var70 > 0) {
      phi75 = this;
      phi76 = var19;
      phi77 = var22;
      phi78 = var23;
      phi79 = var24;
      phi80 = var32;
      phi81 = var35;
      phi82 = var36;
      phi83 = var37;
      phi84 = var45;
      phi85 = var48;
      phi86 = var49;
      phi87 = var50;
      phi88 = var53;
      phi89 = var58;
      phi90 = var63;
      phi91 = var68;
      break If_266_0;
     } else {
      var71 = var37;
      var72 = (bytecoder.cmp(var71,0.0)) | 0;
      if (var72 > 0) {
       phi75 = this;
       phi76 = var19;
       phi77 = var22;
       phi78 = var23;
       phi79 = var24;
       phi80 = var32;
       phi81 = var35;
       phi82 = var36;
       phi83 = var37;
       phi84 = var45;
       phi85 = var48;
       phi86 = var49;
       phi87 = var50;
       phi88 = var53;
       phi89 = var58;
       phi90 = var63;
       phi91 = var68;
       break If_266_0;
      } else {
       // line number 410
       var73 = (this.m_v1);
       var73.a = 1.0;
       // line number 411
       var74 = this;
       var74.m_count = 1;
       // line number 412
       return;
      }
     }
    }
    // line number 416
    var92 = phi78;
    var93 = (bytecoder.cmp(var92,0.0)) | 0;
    If_320_0: {
     if (var93 <= 0) {
      break If_320_0;
     } else {
      var94 = phi79;
      var95 = (bytecoder.cmp(var94,0.0)) | 0;
      if (var95 <= 0) {
       break If_320_0;
      } else {
       var96 = phi91;
       var97 = (bytecoder.cmp(var96,0.0)) | 0;
       if (var97 > 0) {
        break If_320_0;
       } else {
        // line number 417
        var98 = phi78;
        var99 = phi79;
        var100 = (var98 + var99);
        var101 = (1.0 / var100);
        // line number 418
        var102 = phi75;
        var103 = (var102.m_v1);
        var104 = phi78;
        var105 = (var104 * var101);
        var103.a = var105;
        // line number 419
        var106 = phi75;
        var107 = (var106.m_v2);
        var108 = phi79;
        var109 = (var108 * var101);
        var107.a = var109;
        // line number 420
        var110 = phi75;
        var110.m_count = 2;
        // line number 421
        return;
       }
      }
     }
    }
    // line number 425
    var111 = phi82;
    var112 = (bytecoder.cmp(var111,0.0)) | 0;
    If_398_0: {
     if (var112 <= 0) {
      break If_398_0;
     } else {
      var113 = phi83;
      var114 = (bytecoder.cmp(var113,0.0)) | 0;
      if (var114 <= 0) {
       break If_398_0;
      } else {
       var115 = phi90;
       var116 = (bytecoder.cmp(var115,0.0)) | 0;
       if (var116 > 0) {
        break If_398_0;
       } else {
        // line number 426
        var117 = phi82;
        var118 = phi83;
        var119 = (var117 + var118);
        var120 = (1.0 / var119);
        // line number 427
        var121 = phi75;
        var122 = (var121.m_v1);
        var123 = phi82;
        var124 = (var123 * var120);
        var122.a = var124;
        // line number 428
        var125 = phi75;
        var126 = (var125.m_v3);
        var127 = phi83;
        var128 = (var127 * var120);
        var126.a = var128;
        // line number 429
        var129 = phi75;
        var129.m_count = 2;
        // line number 430
        var130 = phi75;
        var131 = (var130.m_v2);
        var132 = phi75;
        var133 = (var132.m_v3);
        org$jbox2d$collision$Distance$SimplexVertex.prototype.V$set$Lorg$jbox2d$collision$Distance$SimplexVertex$.call(var131,var133);
        // line number 431
        return;
       }
      }
     }
    }
    // line number 435
    var134 = phi78;
    var135 = (bytecoder.cmp(var134,0.0)) | 0;
    If_489_0: {
     if (var135 > 0) {
      break If_489_0;
     } else {
      var136 = phi87;
      var137 = (bytecoder.cmp(var136,0.0)) | 0;
      if (var137 > 0) {
       break If_489_0;
      } else {
       // line number 436
       var138 = phi75;
       var139 = (var138.m_v2);
       var139.a = 1.0;
       // line number 437
       var140 = phi75;
       var140.m_count = 1;
       // line number 438
       var141 = phi75;
       var142 = (var141.m_v1);
       var143 = phi75;
       var144 = (var143.m_v2);
       org$jbox2d$collision$Distance$SimplexVertex.prototype.V$set$Lorg$jbox2d$collision$Distance$SimplexVertex$.call(var142,var144);
       // line number 439
       return;
      }
     }
    }
    // line number 443
    var145 = phi82;
    var146 = (bytecoder.cmp(var145,0.0)) | 0;
    If_541_0: {
     if (var146 > 0) {
      break If_541_0;
     } else {
      var147 = phi86;
      var148 = (bytecoder.cmp(var147,0.0)) | 0;
      if (var148 > 0) {
       break If_541_0;
      } else {
       // line number 444
       var149 = phi75;
       var150 = (var149.m_v3);
       var150.a = 1.0;
       // line number 445
       var151 = phi75;
       var151.m_count = 1;
       // line number 446
       var152 = phi75;
       var153 = (var152.m_v1);
       var154 = phi75;
       var155 = (var154.m_v3);
       org$jbox2d$collision$Distance$SimplexVertex.prototype.V$set$Lorg$jbox2d$collision$Distance$SimplexVertex$.call(var153,var155);
       // line number 447
       return;
      }
     }
    }
    // line number 451
    var156 = phi86;
    var157 = (bytecoder.cmp(var156,0.0)) | 0;
    If_593_0: {
     if (var157 <= 0) {
      break If_593_0;
     } else {
      var158 = phi87;
      var159 = (bytecoder.cmp(var158,0.0)) | 0;
      if (var159 <= 0) {
       break If_593_0;
      } else {
       var160 = phi89;
       var161 = (bytecoder.cmp(var160,0.0)) | 0;
       if (var161 > 0) {
        break If_593_0;
       } else {
        // line number 452
        var162 = phi86;
        var163 = phi87;
        var164 = (var162 + var163);
        var165 = (1.0 / var164);
        // line number 453
        var166 = phi75;
        var167 = (var166.m_v2);
        var168 = phi86;
        var169 = (var168 * var165);
        var167.a = var169;
        // line number 454
        var170 = phi75;
        var171 = (var170.m_v3);
        var172 = phi87;
        var173 = (var172 * var165);
        var171.a = var173;
        // line number 455
        var174 = phi75;
        var174.m_count = 2;
        // line number 456
        var175 = phi75;
        var176 = (var175.m_v1);
        var177 = phi75;
        var178 = (var177.m_v3);
        org$jbox2d$collision$Distance$SimplexVertex.prototype.V$set$Lorg$jbox2d$collision$Distance$SimplexVertex$.call(var176,var178);
        // line number 457
        return;
       }
      }
     }
    }
    // line number 461
    var179 = phi89;
    var180 = phi90;
    var181 = (var179 + var180);
    var182 = phi91;
    var183 = (var181 + var182);
    var184 = (1.0 / var183);
    // line number 462
    var185 = phi75;
    var186 = (var185.m_v1);
    var187 = phi89;
    var188 = (var187 * var184);
    var186.a = var188;
    // line number 463
    var189 = phi75;
    var190 = (var189.m_v2);
    var191 = phi90;
    var192 = (var191 * var184);
    var190.a = var192;
    // line number 464
    var193 = phi75;
    var194 = (var193.m_v3);
    var195 = phi91;
    var196 = (var195 * var184);
    var194.a = var196;
    // line number 465
    var197 = phi75;
    var197.m_count = 3;
    // line number 466
    return;
  }

  V$getWitnessPoints$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(arg0,arg1) {
    // source file is Distance.java
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = .0;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = .0;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = .0;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var phi29 = null;
    var phi30 = null;
    var phi31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = null;
    var var37 = .0;
    var var38 = null;
    var var39 = null;
    var var40 = null;
    var var41 = null;
    var var42 = null;
    var var43 = null;
    var var44 = .0;
    var var45 = null;
    var var46 = null;
    var var47 = null;
    var var48 = null;
    var var49 = null;
    var var50 = null;
    var var51 = null;
    var var52 = null;
    var var53 = .0;
    var var54 = null;
    var var55 = null;
    var var56 = null;
    var var57 = null;
    var var58 = null;
    var var59 = null;
    var var60 = .0;
    var var61 = null;
    var var62 = null;
    var var63 = null;
    var var64 = null;
    var var65 = null;
    var var66 = null;
    var var67 = null;
    var var68 = null;
    var var69 = null;
    var var70 = null;
    var var71 = null;
    var var72 = 0;
    var var73 = null;
    var var74 = 0;
    var var75 = null;
    var0 = arg0;
    // line number 232
    var1 = ((this.m_count)) | 0;
    TableSwitch_11_0: {
     if ((var1) >= 0 && (var1) <= 3) switch ((var1) - 0) {
      case 0: {
       // line number 234
       org$jbox2d$collision$Distance$Simplex.$i;
       var72 = (org$jbox2d$collision$Distance$Simplex.$assertionsDisabled);
       if (var72 != 0) {
        phi29 = this;
        phi30 = var0;
        phi31 = arg1;
        break TableSwitch_11_0;
       } else {
        var73 = new java$lang$AssertionError();
        java$lang$AssertionError.prototype.V$$init$$$.call(var73);
        throw bytecoder.registerStack(var73, new Error().stack);
       }
      }
      case 1: {
       // line number 238
       var64 = this;
       var65 = (var64.m_v1);
       var66 = (var65.wA);
       var67 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var0,var66));
       // line number 239
       var68 = this;
       var69 = (var68.m_v1);
       var70 = (var69.wB);
       var71 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(arg1,var70));
       // line number 240
       // Here was a goto statement
       phi29 = this;
       phi30 = var0;
       phi31 = arg1;
       break TableSwitch_11_0;
      }
      case 2: {
       // line number 243
       var32 = (this.case2);
       var33 = (this.m_v1);
       var34 = (var33.wA);
       var35 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var32,var34));
       var36 = (this.m_v1);
       var37 = (var36.a);
       var38 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var35,var37));
       // line number 244
       var39 = this;
       var40 = (var39.m_v2);
       var41 = (var40.wA);
       var42 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var0,var41));
       var43 = (this.m_v2);
       var44 = (var43.a);
       var45 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var42,var44));
       var46 = (this.case2);
       var47 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var45,var46));
       // line number 247
       var48 = (this.case2);
       var49 = (this.m_v1);
       var50 = (var49.wB);
       var51 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var48,var50));
       var52 = (this.m_v1);
       var53 = (var52.a);
       var54 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var51,var53));
       // line number 248
       var55 = this;
       var56 = (var55.m_v2);
       var57 = (var56.wB);
       var58 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(arg1,var57));
       var59 = (this.m_v2);
       var60 = (var59.a);
       var61 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var58,var60));
       var62 = (this.case2);
       var63 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var61,var62));
       // line number 250
       // Here was a goto statement
       phi29 = this;
       phi30 = var0;
       phi31 = arg1;
       break TableSwitch_11_0;
      }
      case 3: {
       // line number 253
       var2 = this;
       var3 = (var2.m_v1);
       var4 = (var3.wA);
       var5 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var0,var4));
       var6 = (this.m_v1);
       var7 = (var6.a);
       var8 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var5,var7));
       // line number 254
       var9 = (this.case3);
       var10 = (this.m_v2);
       var11 = (var10.wA);
       var12 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var9,var11));
       var13 = (this.m_v2);
       var14 = (var13.a);
       var15 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var12,var14));
       // line number 255
       var16 = (this.case33);
       var17 = (this.m_v3);
       var18 = (var17.wA);
       var19 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var16,var18));
       var20 = (this.m_v3);
       var21 = (var20.a);
       var22 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var19,var21));
       // line number 256
       var23 = this;
       var24 = (var23.case3);
       var25 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var0,var24));
       var26 = (this.case33);
       var27 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var25,var26));
       // line number 257
       var28 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(arg1,var0));
       // line number 260
       // Here was a goto statement
       phi29 = this;
       phi30 = var0;
       phi31 = arg1;
       break TableSwitch_11_0;
      }
     } else {
      // line number 263
      org$jbox2d$collision$Distance$Simplex.$i;
      var74 = (org$jbox2d$collision$Distance$Simplex.$assertionsDisabled);
      if (var74 != 0) {
       phi29 = this;
       phi30 = var0;
       phi31 = arg1;
       break TableSwitch_11_0;
      } else {
       var75 = new java$lang$AssertionError();
       java$lang$AssertionError.prototype.V$$init$$$.call(var75);
       throw bytecoder.registerStack(var75, new Error().stack);
      }
     }
    }
    // line number 266
    return;
  }

  V$writeCache$Lorg$jbox2d$collision$Distance$SimplexCache$(arg0) {
    // source file is Distance.java
    var var0 = null;
    var var1 = null;
    var var2 = .0;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var phi6 = null;
    var phi7 = null;
    var phi8 = 0;
    var var9 = 0;
    var var10 = null;
    var var11 = 0;
    var var12 = null;
    var var13 = null;
    var var14 = 0;
    var var15 = null;
    var var16 = null;
    var var17 = 0;
    var var18 = null;
    var var19 = 0;
    var var20 = null;
    var var21 = null;
    var var22 = 0;
    var var23 = null;
    var var24 = null;
    var var25 = 0;
    var var26 = null;
    var var27 = 0;
    var0 = arg0;
    // line number 156
    var1 = this;
    var2 = (org$jbox2d$collision$Distance$Simplex.prototype.F$getMetric$$.call(var1));
    var0.metric = var2;
    // line number 157
    var3 = this;
    var4 = ((var3.m_count)) | 0;
    var0.count = var4;
    // line number 159
    var5 = (0) | 0;
    phi6 = this;
    phi7 = var0;
    phi8 = (var5) | 0;
    L1543934786: while(true) {
     var9 = (phi8) | 0;
     var10 = phi6;
     var11 = ((var10.m_count)) | 0;
     if (var9 >= var11) {
      // line number 163
      return;
     } else {
      // line number 160
      var12 = phi7;
      var13 = (var12.indexA);
      var14 = (phi8) | 0;
      var15 = phi6;
      var16 = (var15.vertices);
      var17 = (phi8) | 0;
      var18 = (var16.data[var17]);
      var19 = ((var18.indexA)) | 0;
      var13.data[var14] = var19;
      // line number 161
      var20 = phi7;
      var21 = (var20.indexB);
      var22 = (phi8) | 0;
      var23 = phi6;
      var24 = (var23.vertices);
      var25 = (phi8) | 0;
      var26 = (var24.data[var25]);
      var27 = ((var26.indexB)) | 0;
      var21.data[var22] = var27;
      // line number 159
      phi8 = ((phi8 + 1)) | 0;
      // Here was a goto statement
      continue L1543934786;
     }
    }
  }

  V$getSearchDirection$Lorg$jbox2d$common$Vec2$(arg0) {
    // source file is Distance.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = .0;
    var var18 = 0;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var0 = arg0;
    // line number 168
    var1 = ((this.m_count)) | 0;
    switch (var1) {
     case 2: {
      // line number 173
      var4 = (this.e12);
      var5 = (this.m_v2);
      var6 = (var5.w);
      var7 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var4,var6));
      var8 = (this.m_v1);
      var9 = (var8.w);
      var10 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var7,var9));
      // line number 175
      var11 = this;
      var12 = (var11.m_v1);
      var13 = (var12.w);
      var14 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var0,var13));
      var15 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$negateLocal$$.call(var14));
      // line number 176
      var16 = (this.e12);
      org$jbox2d$common$Vec2.$i;
      var17 = (org$jbox2d$common$Vec2.F$cross$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var16,var0));
      // line number 178
      var18 = (bytecoder.cmp(var17,0.0)) | 0;
      if (var18 <= 0) {
       // line number 184
       var21 = (this.e12);
       var22 = var0;
       org$jbox2d$common$Vec2.V$crossToOutUnsafe$Lorg$jbox2d$common$Vec2$$F$Lorg$jbox2d$common$Vec2$(var21,1.0,var22);
       // line number 185
       return;
      } else {
       // line number 180
       var19 = this;
       var20 = (var19.e12);
       org$jbox2d$common$Vec2.V$crossToOutUnsafe$F$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(1.0,var20,var0);
       // line number 181
       return;
      }
     }
     case 1: {
      // line number 170
      var23 = (this.m_v1);
      var24 = (var23.w);
      var25 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var0,var24));
      var26 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$negateLocal$$.call(var25));
      // line number 171
      return;
     }
     default: {
      // line number 188
      org$jbox2d$collision$Distance$Simplex.$i;
      var2 = (org$jbox2d$collision$Distance$Simplex.$assertionsDisabled);
      if (var2 != 0) {
       // line number 189
       org$jbox2d$common$Vec2.prototype.V$setZero$$.call(var0);
       // line number 190
       return;
      } else {
       var3 = new java$lang$AssertionError();
       java$lang$AssertionError.prototype.V$$init$$$.call(var3);
       throw bytecoder.registerStack(var3, new Error().stack);
      }
     }
    }
  }

  V$solve2$$() {
    // source file is Distance.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = .0;
    var var9 = .0;
    var var10 = 0;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = .0;
    var var15 = 0;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = .0;
    var var21 = .0;
    var var22 = .0;
    var var23 = null;
    var var24 = .0;
    var var25 = .0;
    var var26 = null;
    var var27 = .0;
    var var28 = .0;
    var var29 = null;
    // line number 321
    var0 = (this.m_v1);
    var1 = (var0.w);
    // line number 322
    var2 = (this.m_v2);
    var3 = (var2.w);
    // line number 323
    var4 = (this.e12);
    var5 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var4,var3));
    var6 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var5,var1));
    // line number 326
    var7 = (this.e12);
    org$jbox2d$common$Vec2.$i;
    var8 = (org$jbox2d$common$Vec2.F$dot$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var1,var7));
    var9 = (0 - var8);
    // line number 327
    var10 = (bytecoder.cmp(var9,0.0)) | 0;
    if (var10 > 0) {
     // line number 335
     var13 = (this.e12);
     var14 = (org$jbox2d$common$Vec2.F$dot$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var3,var13));
     // line number 336
     var15 = (bytecoder.cmp(var14,0.0)) | 0;
     if (var15 > 0) {
      // line number 345
      var20 = var9;
      var21 = (var14 + var20);
      var22 = (1.0 / var21);
      // line number 346
      var23 = (this.m_v1);
      var24 = var22;
      var25 = (var14 * var24);
      var23.a = var25;
      // line number 347
      var26 = (this.m_v2);
      var27 = var22;
      var28 = (var9 * var27);
      var26.a = var28;
      // line number 348
      var29 = this;
      var29.m_count = 2;
      // line number 349
      return;
     } else {
      // line number 338
      var16 = (this.m_v2);
      var16.a = 1.0;
      // line number 339
      var17 = this;
      var17.m_count = 1;
      // line number 340
      var18 = (this.m_v1);
      var19 = (this.m_v2);
      org$jbox2d$collision$Distance$SimplexVertex.prototype.V$set$Lorg$jbox2d$collision$Distance$SimplexVertex$.call(var18,var19);
      // line number 341
      return;
     }
    } else {
     // line number 329
     var11 = (this.m_v1);
     var11.a = 1.0;
     // line number 330
     var12 = this;
     var12.m_count = 1;
     // line number 331
     return;
    }
  }
}


class java$lang$System extends java$lang$Object {
  nativeObject = null;

  static PROPERTIES = null;
  static in = null;
  static out = null;
  static err = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$System,[java$lang$System,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is System.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    // line number 33
    java$util$Properties.$i;
    var0 = new java$util$Properties();
    java$util$Properties.prototype.V$$init$$$.call(var0);
    java$lang$System.$i;
    java$lang$System.PROPERTIES = var0;
    // line number 34
    var1 = (java$lang$System.PROPERTIES);
    var2 = bytecoder.stringconstants[14];
    var3 = (java$util$Properties.prototype.Ljava$lang$Object$$setProperty$Ljava$lang$String$$Ljava$lang$String$.call(var1,bytecoder.stringconstants[13],var2));
    // line number 37
    var4 = new java$io$FileInputStream();
    java$io$FileDescriptor.$i;
    var5 = (java$io$FileDescriptor.in);
    java$io$FileInputStream.prototype.V$$init$$Ljava$io$FileDescriptor$.call(var4,var5);
    java$lang$System.in = var4;
    // line number 39
    java$io$PrintStream.$i;
    var6 = new java$io$PrintStream();
    var7 = new java$io$FileOutputStream();
    var8 = (java$io$FileDescriptor.out);
    java$io$FileOutputStream.prototype.V$$init$$Ljava$io$FileDescriptor$.call(var7,var8);
    java$io$PrintStream.prototype.V$$init$$Ljava$io$OutputStream$.call(var6,var7);
    java$lang$System.out = var6;
    // line number 41
    var9 = new java$io$PrintStream();
    var10 = new java$io$FileOutputStream();
    var11 = (java$io$FileDescriptor.err);
    java$io$FileOutputStream.prototype.V$$init$$Ljava$io$FileDescriptor$.call(var10,var11);
    java$io$PrintStream.prototype.V$$init$$Ljava$io$OutputStream$.call(var9,var10);
    java$lang$System.err = var9;
    return;
  }

  static Ljava$lang$String$$getProperty$Ljava$lang$String$(arg0) {
    // source file is System.java
    var var0 = null;
    var var1 = null;
    // line number 114
    java$lang$System.$i;
    var0 = (java$lang$System.PROPERTIES);
    var1 = (java$util$Properties.prototype.Ljava$lang$String$$getProperty$Ljava$lang$String$.call(var0,arg0));
    return var1;
  }

  static V$arraycopy$Ljava$lang$Object$$I$Ljava$lang$Object$$I$I(arg0,arg1,arg2,arg3,arg4) {
    // source file is System.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var phi6 = 0;
    var phi7 = 0;
    var phi8 = 0;
    var phi9 = null;
    var phi10 = null;
    var phi11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = null;
    var var15 = 0;
    var var16 = 0;
    var var17 = 0;
    var var18 = null;
    var var19 = 0;
    var var20 = 0;
    var var21 = 0;
    var var22 = null;
    var0 = (arg1) | 0;
    var1 = (arg3) | 0;
    // line number 98
    var2 = arg0;
    var3 = var2;
    // line number 99
    var4 = arg2;
    var5 = var4;
    // line number 100
    phi6 = (var0) | 0;
    phi7 = (var1) | 0;
    phi8 = (arg4) | 0;
    phi9 = var3;
    phi10 = var5;
    phi11 = (0) | 0;
    L570211866: while(true) {
     var12 = (phi11) | 0;
     var13 = (phi8) | 0;
     if (var12 >= var13) {
      // line number 103
      return;
     } else {
      // line number 101
      var14 = phi10;
      var15 = (phi7) | 0;
      var16 = (phi11) | 0;
      var17 = ((var15 + var16)) | 0;
      var18 = phi9;
      var19 = (phi6) | 0;
      var20 = (phi11) | 0;
      var21 = ((var19 + var20)) | 0;
      var22 = (var18.data[var21]);
      var14.data[var17] = var22;
      // line number 100
      phi11 = ((phi11 + 1)) | 0;
      // Here was a goto statement
      continue L570211866;
     }
    }
  }

  static J$nanoTime$$() {
    // source file is System.java
    var var0 = 0;
    var var1 = 0;
    // line number 44
    java$lang$System.$i;
    var0 = (java$lang$System.J$currentTimeMillis$$());
    var1 = (var0 * 1000000);
    return var1;
  }

  static J$currentTimeMillis$$() {
    return bytecoder.imports['java.lang.System'].J$currentTimeMillis$$();
  }

  static V$arraycopy$$I$I$$I$I$I(arg0,arg1,arg2,arg3,arg4) {
    // source file is System.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    var phi4 = null;
    var phi5 = 0;
    var phi6 = 0;
    var phi7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = null;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = null;
    var var15 = 0;
    var var16 = 0;
    var var17 = 0;
    var var18 = 0;
    var0 = (arg1) | 0;
    var1 = (arg3) | 0;
    // line number 74
    phi2 = arg0;
    phi3 = (var0) | 0;
    phi4 = arg2;
    phi5 = (var1) | 0;
    phi6 = (arg4) | 0;
    phi7 = (0) | 0;
    L2075825263: while(true) {
     var8 = (phi7) | 0;
     var9 = (phi6) | 0;
     if (var8 >= var9) {
      // line number 77
      return;
     } else {
      // line number 75
      var10 = phi4;
      var11 = (phi5) | 0;
      var12 = (phi7) | 0;
      var13 = ((var11 + var12)) | 0;
      var14 = phi2;
      var15 = (phi3) | 0;
      var16 = (phi7) | 0;
      var17 = ((var15 + var16)) | 0;
      var18 = ((var14.data[var17])) | 0;
      var10.data[var13] = var18;
      // line number 74
      phi7 = ((phi7 + 1)) | 0;
      // Here was a goto statement
      continue L2075825263;
     }
    }
  }

  static I$identityHashCode$Ljava$lang$Object$(arg0) {
    // source file is System.java
    var var0 = 0;
    // line number 106
    var0 = ((arg0.I$hashCode$$())) | 0;
    return var0;
  }

  V$$init$$$() {
    // source file is System.java
    // line number 28
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }

  static V$arraycopy$$B$I$$B$I$I(arg0,arg1,arg2,arg3,arg4) {
    // source file is System.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    var phi4 = null;
    var phi5 = 0;
    var phi6 = 0;
    var phi7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = null;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = null;
    var var15 = 0;
    var var16 = 0;
    var var17 = 0;
    var var18 = 0;
    var0 = (arg1) | 0;
    var1 = (arg3) | 0;
    // line number 56
    phi2 = arg0;
    phi3 = (var0) | 0;
    phi4 = arg2;
    phi5 = (var1) | 0;
    phi6 = (arg4) | 0;
    phi7 = (0) | 0;
    L1669473288: while(true) {
     var8 = (phi7) | 0;
     var9 = (phi6) | 0;
     if (var8 >= var9) {
      // line number 59
      return;
     } else {
      // line number 57
      var10 = phi4;
      var11 = (phi5) | 0;
      var12 = (phi7) | 0;
      var13 = ((var11 + var12)) | 0;
      var14 = phi2;
      var15 = (phi3) | 0;
      var16 = (phi7) | 0;
      var17 = ((var15 + var16)) | 0;
      var18 = (var14.data[var17]);
      var10.data[var13] = var18;
      // line number 56
      phi7 = ((phi7 + 1)) | 0;
      // Here was a goto statement
      continue L1669473288;
     }
    }
  }

  static V$arraycopy$$C$I$$C$I$I(arg0,arg1,arg2,arg3,arg4) {
    // source file is System.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    var phi4 = null;
    var phi5 = 0;
    var phi6 = 0;
    var phi7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = null;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = null;
    var var15 = 0;
    var var16 = 0;
    var var17 = 0;
    var var18 = 0;
    var0 = (arg1) | 0;
    var1 = (arg3) | 0;
    // line number 50
    phi2 = arg0;
    phi3 = (var0) | 0;
    phi4 = arg2;
    phi5 = (var1) | 0;
    phi6 = (arg4) | 0;
    phi7 = (0) | 0;
    L541874793: while(true) {
     var8 = (phi7) | 0;
     var9 = (phi6) | 0;
     if (var8 >= var9) {
      // line number 53
      return;
     } else {
      // line number 51
      var10 = phi4;
      var11 = (phi5) | 0;
      var12 = (phi7) | 0;
      var13 = ((var11 + var12)) | 0;
      var14 = phi2;
      var15 = (phi3) | 0;
      var16 = (phi7) | 0;
      var17 = ((var15 + var16)) | 0;
      var18 = (var14.data[var17]);
      var10.data[var13] = var18;
      // line number 50
      phi7 = ((phi7 + 1)) | 0;
      // Here was a goto statement
      continue L541874793;
     }
    }
  }
}


class java$nio$charset$CharsetEncoder extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;
  static stateNames = null;
  malformedInputAction = null;
  unmappableCharacterAction = null;
  charset = null;
  state = 0;
  cachedDecoder = null;
  replacement = null;
  averageBytesPerChar = 0.0;
  maxBytesPerChar = 0.0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$nio$charset$CharsetEncoder,[java$nio$charset$CharsetEncoder,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is CharsetEncoder.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    // line number 137
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(java$nio$charset$CharsetEncoder.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    java$nio$charset$CharsetEncoder.$i;
    java$nio$charset$CharsetEncoder.$assertionsDisabled = phi2;
    // line number 158
    var3 = bytecoder.newarray((4),null);
    var4 = (0) | 0;
    var3.data[var4] = bytecoder.stringconstants[19];
    var5 = (1) | 0;
    var3.data[var5] = bytecoder.stringconstants[20];
    var6 = (2) | 0;
    var3.data[var6] = bytecoder.stringconstants[21];
    var7 = (3) | 0;
    var3.data[var7] = bytecoder.stringconstants[22];
    java$nio$charset$CharsetEncoder.stateNames = var3;
    return;
  }

  Ljava$nio$charset$CharsetEncoder$$onMalformedInput$Ljava$nio$charset$CodingErrorAction$(arg0) {
    // source file is CharsetEncoder.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var0 = arg0;
    // line number 381
    if (var0 != null) {
     // line number 383
     var3 = this;
     var3.malformedInputAction = var0;
     // line number 384
     var4 = var0;
     java$nio$charset$CharsetEncoder.prototype.V$implOnMalformedInput$Ljava$nio$charset$CodingErrorAction$.call(this,var4);
     // line number 385
     return this;
    } else {
     // line number 382
     var1 = new java$lang$IllegalArgumentException();
     var2 = bytecoder.stringconstants[26];
     java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var1,var2);
     throw bytecoder.registerStack(var1, new Error().stack);
    }
  }

  V$implOnMalformedInput$Ljava$nio$charset$CodingErrorAction$(arg0) {
    // source file is CharsetEncoder.java
    var var0 = null;
    var0 = arg0;
    // line number 397
    return;
  }

  Ljava$nio$charset$CharsetEncoder$$onUnmappableCharacter$Ljava$nio$charset$CodingErrorAction$(arg0) {
    // source file is CharsetEncoder.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var0 = arg0;
    // line number 425
    if (var0 != null) {
     // line number 427
     var3 = this;
     var3.unmappableCharacterAction = var0;
     // line number 428
     var4 = var0;
     java$nio$charset$CharsetEncoder.prototype.V$implOnUnmappableCharacter$Ljava$nio$charset$CodingErrorAction$.call(this,var4);
     // line number 429
     return this;
    } else {
     // line number 426
     var1 = new java$lang$IllegalArgumentException();
     var2 = bytecoder.stringconstants[26];
     java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var1,var2);
     throw bytecoder.registerStack(var1, new Error().stack);
    }
  }

  V$implOnUnmappableCharacter$Ljava$nio$charset$CodingErrorAction$(arg0) {
    // source file is CharsetEncoder.java
    var var0 = null;
    var0 = arg0;
    // line number 441
    return;
  }

  Ljava$nio$charset$Charset$$charset$$() {
    // source file is CharsetEncoder.java
    var var0 = null;
    // line number 244
    var0 = (this.charset);
    return var0;
  }

  V$$init$$Ljava$nio$charset$Charset$$F$F(arg0,arg1,arg2) {
    // source file is CharsetEncoder.java
    var var0 = null;
    var var1 = .0;
    var var2 = null;
    var var3 = .0;
    var var4 = null;
    var var5 = 0;
    var0 = arg0;
    var1 = arg2;
    // line number 233
    var2 = var0;
    var3 = var1;
    var4 = bytecoder.newarray((1),0);
    var5 = (0) | 0;
    var4.data[var5] = 63;
    java$nio$charset$CharsetEncoder.prototype.V$$init$$Ljava$nio$charset$Charset$$F$F$$B.call(this,var2,arg1,var3,var4);
    // line number 236
    return;
  }

  V$$init$$Ljava$nio$charset$Charset$$F$F$$B(arg0,arg1,arg2,arg3) {
    // source file is CharsetEncoder.java
    var var0 = null;
    var var1 = .0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = .0;
    var var10 = 0;
    var var11 = null;
    var var12 = null;
    var var13 = .0;
    var var14 = 0;
    var var15 = null;
    var var16 = null;
    var var17 = 0;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var0 = arg0;
    var1 = arg2;
    // line number 190
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 144
    var2 = this;
    java$nio$charset$CodingErrorAction.$i;
    var3 = (java$nio$charset$CodingErrorAction.REPORT);
    var2.malformedInputAction = var3;
    // line number 146
    var4 = this;
    var5 = (java$nio$charset$CodingErrorAction.REPORT);
    var4.unmappableCharacterAction = var5;
    // line number 156
    var6 = this;
    var6.state = 0;
    // line number 320
    var7 = this;
    var7.cachedDecoder = null;
    // line number 191
    var8 = this;
    var8.charset = var0;
    // line number 193
    var9 = 0.0;
    var10 = (bytecoder.cmp(arg1,var9)) | 0;
    if (var10 > 0) {
     // line number 197
     var13 = 0.0;
     var14 = (bytecoder.cmp(var1,var13)) | 0;
     if (var14 > 0) {
      // line number 200
      var17 = (bytecoder.cmp(arg1,var1)) | 0;
      if (var17 <= 0) {
       // line number 204
       var20 = this;
       var20.replacement = arg3;
       // line number 205
       var21 = this;
       var21.averageBytesPerChar = arg1;
       // line number 206
       var22 = this;
       var22.maxBytesPerChar = var1;
       // line number 207
       var23 = arg3;
       var24 = (java$nio$charset$CharsetEncoder.prototype.Ljava$nio$charset$CharsetEncoder$$replaceWith$$B.call(this,var23));
       // line number 208
       return;
      } else {
       // line number 201
       var18 = new java$lang$IllegalArgumentException();
       var19 = bytecoder.stringconstants[78];
       java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var18,var19);
       throw bytecoder.registerStack(var18, new Error().stack);
      }
     } else {
      // line number 198
      var15 = new java$lang$IllegalArgumentException();
      var16 = bytecoder.stringconstants[77];
      java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var15,var16);
      throw bytecoder.registerStack(var15, new Error().stack);
     }
    } else {
     // line number 194
     var11 = new java$lang$IllegalArgumentException();
     var12 = bytecoder.stringconstants[76];
     java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var11,var12);
     throw bytecoder.registerStack(var11, new Error().stack);
    }
  }

  Ljava$nio$charset$CharsetEncoder$$replaceWith$$B(arg0) {
    // source file is CharsetEncoder.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = .0;
    var var6 = .0;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = 0;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var0 = arg0;
    // line number 287
    if (var0 != null) {
     // line number 289
     var3 = (var0.data.length) | 0;
     // line number 290
     if (var3 != 0) {
      // line number 292
      var5 = var3;
      var6 = (this.maxBytesPerChar);
      var7 = (bytecoder.cmp(var5,var6)) | 0;
      if (var7 <= 0) {
       // line number 298
       var9 = var0;
       var10 = (java$nio$charset$CharsetEncoder.prototype.Z$isLegalReplacement$$B.call(this,var9));
       if (var10 != 0) {
        // line number 300
        var12 = this;
        var13 = var0;
        var14 = (var13.data.length) | 0;
        java$util$Arrays.$i;
        var15 = (java$util$Arrays.$B$copyOf$$B$I(var0,var14));
        var12.replacement = var15;
        // line number 302
        var16 = this;
        var17 = (var16.replacement);
        java$nio$charset$CharsetEncoder.prototype.V$implReplaceWith$$B.call(this,var17);
        // line number 303
        return this;
       } else {
        // line number 299
        var11 = new java$lang$IllegalArgumentException();
        java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var11,bytecoder.stringconstants[110]);
        throw bytecoder.registerStack(var11, new Error().stack);
       }
      } else {
       // line number 293
       var8 = new java$lang$IllegalArgumentException();
       java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var8,bytecoder.stringconstants[81]);
       throw bytecoder.registerStack(var8, new Error().stack);
      }
     } else {
      // line number 291
      var4 = new java$lang$IllegalArgumentException();
      java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var4,bytecoder.stringconstants[80]);
      throw bytecoder.registerStack(var4, new Error().stack);
     }
    } else {
     // line number 288
     var1 = new java$lang$IllegalArgumentException();
     var2 = bytecoder.stringconstants[79];
     java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var1,var2);
     throw bytecoder.registerStack(var1, new Error().stack);
    }
  }

  Z$isLegalReplacement$$B(arg0) {
    // source file is CharsetEncoder.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var phi7 = null;
    var phi8 = null;
    var phi9 = null;
    var phi10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var phi21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = 0;
    var var25 = .0;
    var var26 = null;
    var var27 = .0;
    var var28 = .0;
    var var29 = 0;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = 0;
    var var35 = 0;
    var phi36 = null;
    var phi37 = null;
    var phi38 = null;
    var phi39 = 0;
    var var40 = null;
    var0 = arg0;
    // line number 339
    var1 = (this.cachedDecoder);
    // line number 340
    var2 = null;
    // line number 341
    If_17_0: {
     If_17_1: {
      if (var1 == null) {
       phi7 = this;
       phi8 = var0;
       phi9 = var1;
       phi10 = var2;
       break If_17_1;
      } else {
       var3 = var1;
       var4 = (var3.Ljava$lang$Object$$get$$());
       var5 = var4;
       var6 = var5;
       if (var5 != null) {
        // line number 347
        var40 = (java$nio$charset$CharsetDecoder.prototype.Ljava$nio$charset$CharsetDecoder$$reset$$.call(var6));
        phi7 = this;
        phi8 = var0;
        phi9 = var1;
        phi21 = var6;
        break If_17_0;
       } else {
        phi7 = this;
        phi8 = var0;
        phi9 = var1;
        phi10 = var6;
        break If_17_1;
       }
      }
     }
     // line number 342
     var11 = phi7;
     var12 = (java$nio$charset$CharsetEncoder.prototype.Ljava$nio$charset$Charset$$charset$$.call(var11));
     var13 = (var12.Ljava$nio$charset$CharsetDecoder$$newDecoder$$());
     // line number 343
     java$nio$charset$CodingErrorAction.$i;
     var14 = (java$nio$charset$CodingErrorAction.REPORT);
     var15 = (java$nio$charset$CharsetDecoder.prototype.Ljava$nio$charset$CharsetDecoder$$onMalformedInput$Ljava$nio$charset$CodingErrorAction$.call(var13,var14));
     // line number 344
     var16 = (java$nio$charset$CodingErrorAction.REPORT);
     var17 = (java$nio$charset$CharsetDecoder.prototype.Ljava$nio$charset$CharsetDecoder$$onUnmappableCharacter$Ljava$nio$charset$CodingErrorAction$.call(var13,var16));
     // line number 345
     var18 = phi7;
     var19 = new java$lang$ref$WeakReference();
     var20 = var13;
     java$lang$ref$WeakReference.prototype.V$$init$$Ljava$lang$Object$.call(var19,var20);
     var18.cachedDecoder = var19;
     // Here was a goto statement
     phi21 = var13;
     break If_17_0;
    }
    // line number 349
    var22 = phi8;
    java$nio$ByteBuffer.$i;
    var23 = (java$nio$ByteBuffer.Ljava$nio$ByteBuffer$$wrap$$B(var22));
    // line number 350
    var24 = ((var23.I$remaining$$())) | 0;
    var25 = var24;
    var26 = phi21;
    // line number 351
    var27 = (java$nio$charset$CharsetDecoder.prototype.F$maxCharsPerByte$$.call(var26));
    var28 = (var25 * var27);
    var29 = ((var28 | 0)) | 0;
    // line number 350
    java$nio$CharBuffer.$i;
    var30 = (java$nio$CharBuffer.Ljava$nio$CharBuffer$$allocate$I(var29));
    // line number 352
    var31 = phi21;
    var32 = var30;
    var33 = (java$nio$charset$CharsetDecoder.prototype.Ljava$nio$charset$CoderResult$$decode$Ljava$nio$ByteBuffer$$Ljava$nio$CharBuffer$$Z.call(var31,var23,var32,1));
    // line number 353
    var34 = (java$nio$charset$CoderResult.prototype.Z$isError$$.call(var33));
    If_133_0: {
     if (var34 != 0) {
      phi36 = var23;
      phi37 = var30;
      phi38 = var33;
      phi39 = (0) | 0;
      break If_133_0;
     } else {
      var35 = (1) | 0;
      // Here was a goto statement
      phi36 = var23;
      phi37 = var30;
      phi38 = var33;
      phi39 = (var35) | 0;
      break If_133_0;
     }
    }
    return phi39;
  }

  V$implReplaceWith$$B(arg0) {
    // source file is CharsetEncoder.java
    var var0 = null;
    var0 = arg0;
    // line number 316
    return;
  }
}


class org$jbox2d$collision$Distance extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;
  static GJK_CALLS = 0;
  static GJK_ITERS = 0;
  static GJK_MAX_ITERS = 0;
  simplex = null;
  saveA = null;
  saveB = null;
  closestPoint = null;
  d = null;
  temp = null;
  normal = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$collision$Distance,[org$jbox2d$collision$Distance,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is Distance.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    // line number 44
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(org$jbox2d$collision$Distance.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    org$jbox2d$collision$Distance.$i;
    org$jbox2d$collision$Distance.$assertionsDisabled = phi2;
    // line number 46
    org$jbox2d$collision$Distance.GJK_CALLS = 0;
    // line number 47
    org$jbox2d$collision$Distance.GJK_ITERS = 0;
    // line number 48
    org$jbox2d$collision$Distance.GJK_MAX_ITERS = 20;
    return;
  }

  V$$init$$$() {
    // source file is Distance.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    // line number 44
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 601
    var0 = this;
    org$jbox2d$collision$Distance$Simplex.$i;
    var1 = new org$jbox2d$collision$Distance$Simplex();
    var2 = this;
    org$jbox2d$collision$Distance$Simplex.prototype.V$$init$$Lorg$jbox2d$collision$Distance$$Lorg$jbox2d$collision$Distance$1$.call(var1,var2,null);
    var0.simplex = var1;
    // line number 602
    var3 = this;
    var4 = bytecoder.newarray((3),0);
    var3.saveA = var4;
    // line number 603
    var5 = this;
    var6 = bytecoder.newarray((3),0);
    var5.saveB = var6;
    // line number 604
    var7 = this;
    org$jbox2d$common$Vec2.$i;
    var8 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var8);
    var7.closestPoint = var8;
    // line number 605
    var9 = this;
    var10 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var10);
    var9.d = var10;
    // line number 606
    var11 = this;
    var12 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var12);
    var11.temp = var12;
    // line number 607
    var13 = this;
    var14 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var14);
    var13.normal = var14;
    return;
  }

  V$distance$Lorg$jbox2d$collision$DistanceOutput$$Lorg$jbox2d$collision$Distance$SimplexCache$$Lorg$jbox2d$collision$DistanceInput$(arg0,arg1,arg2) {
    // source file is Distance.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = 0;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = .0;
    var var18 = .0;
    var var19 = 0;
    var phi20 = null;
    var phi21 = null;
    var phi22 = null;
    var phi23 = null;
    var phi24 = null;
    var phi25 = null;
    var phi26 = null;
    var phi27 = null;
    var phi28 = null;
    var phi29 = 0;
    var phi30 = .0;
    var phi31 = .0;
    var phi32 = 0;
    var var33 = 0;
    var var34 = 0;
    var var35 = null;
    var var36 = null;
    var var37 = 0;
    var var38 = 0;
    var phi39 = 0;
    var phi40 = 0;
    var var41 = 0;
    var var42 = 0;
    var var43 = null;
    var var44 = null;
    var var45 = 0;
    var var46 = null;
    var var47 = 0;
    var var48 = null;
    var var49 = 0;
    var var50 = null;
    var var51 = null;
    var var52 = 0;
    var var53 = null;
    var var54 = 0;
    var var55 = null;
    var var56 = 0;
    var var57 = null;
    var var58 = null;
    var var59 = 0;
    var var60 = null;
    var var61 = null;
    var var62 = null;
    var var63 = null;
    var var64 = 0;
    var var65 = 0;
    var var66 = 0;
    var var67 = 0;
    var var68 = null;
    var var69 = null;
    var var70 = null;
    var var71 = null;
    var var72 = null;
    var var73 = null;
    var var74 = null;
    var var75 = null;
    var var76 = null;
    var var77 = null;
    var var78 = null;
    var var79 = .0;
    var var80 = null;
    var var81 = 0;
    var var82 = null;
    var var83 = null;
    var var84 = null;
    var var85 = null;
    var var86 = 0;
    var var87 = null;
    var var88 = .0;
    var var89 = null;
    var var90 = .0;
    var var91 = null;
    var var92 = .0;
    var var93 = .0;
    var var94 = .0;
    var var95 = 0;
    var var96 = null;
    var var97 = .0;
    var var98 = 0;
    var var99 = null;
    var var100 = .0;
    var var101 = .0;
    var var102 = .0;
    var var103 = .0;
    var var104 = null;
    var var105 = null;
    var var106 = null;
    var var107 = null;
    var var108 = null;
    var var109 = null;
    var var110 = null;
    var var111 = null;
    var var112 = null;
    var var113 = null;
    var var114 = .0;
    var var115 = null;
    var var116 = null;
    var var117 = null;
    var var118 = null;
    var var119 = null;
    var var120 = null;
    var var121 = null;
    var var122 = null;
    var var123 = null;
    var var124 = null;
    var var125 = null;
    var var126 = null;
    var var127 = null;
    var var128 = null;
    var var129 = null;
    var var130 = null;
    var var131 = null;
    var var132 = null;
    var var133 = null;
    var var134 = null;
    var var135 = null;
    var var136 = null;
    var phi137 = .0;
    var phi138 = .0;
    var phi139 = .0;
    var phi140 = .0;
    var var141 = null;
    var var142 = null;
    var var143 = null;
    var var144 = null;
    var var145 = null;
    var var146 = null;
    var var147 = null;
    var var148 = null;
    var var149 = null;
    var var150 = null;
    var var151 = null;
    var var152 = null;
    var var153 = null;
    var var154 = null;
    var var155 = null;
    var var156 = null;
    var var157 = null;
    var var158 = null;
    var var159 = .0;
    var var160 = .0;
    var var161 = 0;
    var var162 = .0;
    var var163 = null;
    var var164 = null;
    var var165 = null;
    var var166 = null;
    var var167 = null;
    var var168 = null;
    var var169 = .0;
    var var170 = 0;
    var var171 = null;
    var var172 = null;
    var var173 = null;
    var var174 = 0;
    var var175 = null;
    var var176 = null;
    var var177 = null;
    var var178 = null;
    var var179 = null;
    var var180 = null;
    var var181 = null;
    var var182 = null;
    var var183 = null;
    var var184 = null;
    var var185 = null;
    var var186 = 0;
    var var187 = null;
    var var188 = null;
    var var189 = 0;
    var var190 = null;
    var var191 = null;
    var var192 = null;
    var var193 = null;
    var var194 = null;
    var var195 = null;
    var var196 = null;
    var var197 = null;
    var var198 = null;
    var var199 = null;
    var var200 = null;
    var var201 = null;
    var var202 = 0;
    var var203 = null;
    var var204 = null;
    var var205 = 0;
    var var206 = null;
    var var207 = null;
    var var208 = null;
    var var209 = null;
    var var210 = null;
    var var211 = null;
    var var212 = null;
    var var213 = 0;
    var var214 = 0;
    var var215 = 0;
    var var216 = 0;
    var phi217 = .0;
    var phi218 = .0;
    var phi219 = null;
    var phi220 = 0;
    var phi221 = 0;
    var var222 = 0;
    var var223 = 0;
    var var224 = null;
    var var225 = 0;
    var var226 = null;
    var var227 = null;
    var var228 = 0;
    var var229 = 0;
    var var230 = null;
    var var231 = 0;
    var var232 = null;
    var var233 = null;
    var var234 = 0;
    var var235 = 0;
    var var236 = 0;
    var phi237 = 0;
    var var238 = 0;
    var var239 = null;
    var var240 = null;
    var var241 = 0;
    var var242 = 0;
    var var243 = null;
    var var244 = null;
    var var245 = 0;
    var var246 = null;
    var0 = arg0;
    var1 = arg2;
    // line number 620
    org$jbox2d$collision$Distance.$i;
    var2 = ((org$jbox2d$collision$Distance.GJK_CALLS)) | 0;
    var3 = ((var2 + 1)) | 0;
    org$jbox2d$collision$Distance.GJK_CALLS = var3;
    // line number 622
    var4 = (var1.proxyA);
    // line number 623
    var5 = (var1.proxyB);
    // line number 625
    var6 = (var1.transformA);
    // line number 626
    var7 = (var1.transformB);
    // line number 629
    var8 = (this.simplex);
    var9 = var4;
    var10 = var5;
    org$jbox2d$collision$Distance$Simplex.prototype.V$readCache$Lorg$jbox2d$collision$Distance$SimplexCache$$Lorg$jbox2d$collision$Distance$DistanceProxy$$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$collision$Distance$DistanceProxy$$Lorg$jbox2d$common$Transform$.call(var8,arg1,var9,var6,var10,var7);
    // line number 632
    var11 = (this.simplex);
    var12 = (var11.vertices);
    // line number 637
    var13 = (0) | 0;
    // line number 639
    var14 = (this.simplex);
    var15 = (this.closestPoint);
    org$jbox2d$collision$Distance$Simplex.prototype.V$getClosestPoint$Lorg$jbox2d$common$Vec2$.call(var14,var15);
    // line number 640
    var16 = (this.closestPoint);
    var17 = (org$jbox2d$common$Vec2.prototype.F$lengthSquared$$.call(var16));
    // line number 641
    var18 = var17;
    // line number 644
    var19 = (0) | 0;
    phi20 = this;
    phi21 = var0;
    phi22 = arg1;
    phi23 = var1;
    phi24 = var4;
    phi25 = var5;
    phi26 = var6;
    phi27 = var7;
    phi28 = var12;
    phi29 = (var13) | 0;
    phi30 = var17;
    phi31 = var18;
    phi32 = (var19) | 0;
    L774221940: while(true) {
     // line number 645
     var33 = (phi32) | 0;
     var34 = ((org$jbox2d$collision$Distance.GJK_MAX_ITERS)) | 0;
     If_113_0: {
      if (var33 >= var34) {
       phi39 = (phi29) | 0;
       break If_113_0;
      } else {
       // line number 648
       var35 = phi20;
       var36 = (var35.simplex);
       var37 = ((var36.m_count)) | 0;
       // line number 649
       var38 = (0) | 0;
       phi39 = (var37) | 0;
       phi40 = (var38) | 0;
       L1921963024: while(true) {
        var41 = (phi40) | 0;
        var42 = (phi39) | 0;
        if (var41 >= var42) {
         // line number 654
         var57 = phi20;
         var58 = (var57.simplex);
         var59 = ((var58.m_count)) | 0;
         TableSwitch_197_0: {
          if ((var59) >= 1 && (var59) <= 3) switch ((var59) - 1) {
           case 0: {
            // line number 656
            // Here was a goto statement
            break TableSwitch_197_0;
           }
           case 1: {
            // line number 658
            var243 = phi20;
            var244 = (var243.simplex);
            org$jbox2d$collision$Distance$Simplex.prototype.V$solve2$$.call(var244);
            // line number 659
            // Here was a goto statement
            break TableSwitch_197_0;
           }
           case 2: {
            // line number 661
            var60 = phi20;
            var61 = (var60.simplex);
            org$jbox2d$collision$Distance$Simplex.prototype.V$solve3$$.call(var61);
            // line number 662
            // Here was a goto statement
            break TableSwitch_197_0;
           }
          } else {
           // line number 664
           var245 = (org$jbox2d$collision$Distance.$assertionsDisabled);
           if (var245 != 0) {
            break TableSwitch_197_0;
           } else {
            var246 = new java$lang$AssertionError();
            java$lang$AssertionError.prototype.V$$init$$$.call(var246);
            throw bytecoder.registerStack(var246, new Error().stack);
           }
          }
         }
         // line number 668
         var62 = phi20;
         var63 = (var62.simplex);
         var64 = ((var63.m_count)) | 0;
         if (var64 != 3) {
          // line number 673
          var153 = phi20;
          var154 = (var153.simplex);
          var155 = phi20;
          var156 = (var155.closestPoint);
          org$jbox2d$collision$Distance$Simplex.prototype.V$getClosestPoint$Lorg$jbox2d$common$Vec2$.call(var154,var156);
          // line number 674
          var157 = phi20;
          var158 = (var157.closestPoint);
          var159 = (org$jbox2d$common$Vec2.prototype.F$lengthSquared$$.call(var158));
          // line number 677
          var160 = phi30;
          var161 = (bytecoder.cmp(var159,var160)) | 0;
          if (var161 < 0) {
           // line number 680
           var162 = var159;
           // line number 683
           var163 = phi20;
           var164 = (var163.simplex);
           var165 = phi20;
           var166 = (var165.d);
           org$jbox2d$collision$Distance$Simplex.prototype.V$getSearchDirection$Lorg$jbox2d$common$Vec2$.call(var164,var166);
           // line number 686
           var167 = phi20;
           var168 = (var167.d);
           var169 = (org$jbox2d$common$Vec2.prototype.F$lengthSquared$$.call(var168));
           var170 = (bytecoder.cmp(var169,1.4210855E-14)) | 0;
           if (var170 >= 0) {
            // line number 704
            var171 = phi28;
            var172 = phi20;
            var173 = (var172.simplex);
            var174 = ((var173.m_count)) | 0;
            var175 = (var171.data[var174]);
            // line number 706
            var176 = phi26;
            var177 = (var176.q);
            var178 = phi20;
            var179 = (var178.d);
            var180 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$negateLocal$$.call(var179));
            var181 = phi20;
            var182 = (var181.temp);
            org$jbox2d$common$Rot.$i;
            org$jbox2d$common$Rot.V$mulTransUnsafe$Lorg$jbox2d$common$Rot$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var177,var180,var182);
            // line number 707
            var183 = phi24;
            var184 = phi20;
            var185 = (var184.temp);
            var186 = ((org$jbox2d$collision$Distance$DistanceProxy.prototype.I$getSupport$Lorg$jbox2d$common$Vec2$.call(var183,var185))) | 0;
            var175.indexA = var186;
            // line number 708
            var187 = phi26;
            var188 = phi24;
            var189 = ((var175.indexA)) | 0;
            var190 = (org$jbox2d$collision$Distance$DistanceProxy.prototype.Lorg$jbox2d$common$Vec2$$getVertex$I.call(var188,var189));
            var191 = (var175.wA);
            org$jbox2d$common$Transform.$i;
            org$jbox2d$common$Transform.V$mulToOutUnsafe$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var187,var190,var191);
            // line number 710
            var192 = phi27;
            var193 = (var192.q);
            var194 = phi20;
            var195 = (var194.d);
            var196 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$negateLocal$$.call(var195));
            var197 = phi20;
            var198 = (var197.temp);
            org$jbox2d$common$Rot.V$mulTransUnsafe$Lorg$jbox2d$common$Rot$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var193,var196,var198);
            // line number 711
            var199 = phi25;
            var200 = phi20;
            var201 = (var200.temp);
            var202 = ((org$jbox2d$collision$Distance$DistanceProxy.prototype.I$getSupport$Lorg$jbox2d$common$Vec2$.call(var199,var201))) | 0;
            var175.indexB = var202;
            // line number 712
            var203 = phi27;
            var204 = phi25;
            var205 = ((var175.indexB)) | 0;
            var206 = (org$jbox2d$collision$Distance$DistanceProxy.prototype.Lorg$jbox2d$common$Vec2$$getVertex$I.call(var204,var205));
            var207 = (var175.wB);
            org$jbox2d$common$Transform.V$mulToOutUnsafe$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var203,var206,var207);
            // line number 713
            var208 = (var175.w);
            var209 = (var175.wB);
            var210 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var208,var209));
            var211 = (var175.wA);
            var212 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var210,var211));
            // line number 716
            phi32 = ((phi32 + 1)) | 0;
            // line number 717
            var213 = ((org$jbox2d$collision$Distance.GJK_ITERS)) | 0;
            var214 = ((var213 + 1)) | 0;
            org$jbox2d$collision$Distance.GJK_ITERS = var214;
            // line number 720
            var215 = (0) | 0;
            // line number 721
            var216 = (0) | 0;
            phi217 = var162;
            phi218 = var159;
            phi219 = var175;
            phi220 = (var215) | 0;
            phi221 = (var216) | 0;
            L603895616: while(true) {
             var222 = (phi221) | 0;
             var223 = (phi39) | 0;
             If_765_0: {
              if (var222 >= var223) {
               phi237 = (phi220) | 0;
               break If_765_0;
              } else {
               // line number 722
               var224 = phi219;
               var225 = ((var224.indexA)) | 0;
               var226 = phi20;
               var227 = (var226.saveA);
               var228 = (phi221) | 0;
               var229 = ((var227.data[var228])) | 0;
               If_784_0: {
                if (var225 != var229) {
                 break If_784_0;
                } else {
                 var230 = phi219;
                 var231 = ((var230.indexB)) | 0;
                 var232 = phi20;
                 var233 = (var232.saveB);
                 var234 = (phi221) | 0;
                 var235 = ((var233.data[var234])) | 0;
                 if (var231 != var235) {
                  break If_784_0;
                 } else {
                  // line number 723
                  var236 = (1) | 0;
                  // line number 724
                  // Here was a goto statement
                  phi237 = (var236) | 0;
                  break If_765_0;
                 }
                }
               }
               // line number 721
               phi221 = ((phi221 + 1)) | 0;
               // Here was a goto statement
               continue L603895616;
              }
             }
             // line number 729
             var238 = (phi237) | 0;
             if (var238 == 0) {
              // line number 734
              var239 = phi20;
              var240 = (var239.simplex);
              var241 = ((var240.m_count)) | 0;
              var242 = ((var241 + 1)) | 0;
              var240.m_count = var242;
              // line number 735
              // Here was a goto statement
              phi29 = (phi39) | 0;
              phi30 = phi217;
              phi31 = phi218;
              continue L774221940;
             } else {
              // line number 730
              // Here was a goto statement
              phi30 = phi217;
              phi31 = phi218;
              break If_113_0;
             }
            }
           } else {
            // line number 693
            // Here was a goto statement
            phi30 = var162;
            phi31 = var159;
            break If_113_0;
           }
          } else {
           // line number 680
           var162 = var159;
           // line number 683
           var163 = phi20;
           var164 = (var163.simplex);
           var165 = phi20;
           var166 = (var165.d);
           org$jbox2d$collision$Distance$Simplex.prototype.V$getSearchDirection$Lorg$jbox2d$common$Vec2$.call(var164,var166);
           // line number 686
           var167 = phi20;
           var168 = (var167.d);
           var169 = (org$jbox2d$common$Vec2.prototype.F$lengthSquared$$.call(var168));
           var170 = (bytecoder.cmp(var169,1.4210855E-14)) | 0;
           if (var170 >= 0) {
            // line number 704
            var171 = phi28;
            var172 = phi20;
            var173 = (var172.simplex);
            var174 = ((var173.m_count)) | 0;
            var175 = (var171.data[var174]);
            // line number 706
            var176 = phi26;
            var177 = (var176.q);
            var178 = phi20;
            var179 = (var178.d);
            var180 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$negateLocal$$.call(var179));
            var181 = phi20;
            var182 = (var181.temp);
            org$jbox2d$common$Rot.$i;
            org$jbox2d$common$Rot.V$mulTransUnsafe$Lorg$jbox2d$common$Rot$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var177,var180,var182);
            // line number 707
            var183 = phi24;
            var184 = phi20;
            var185 = (var184.temp);
            var186 = ((org$jbox2d$collision$Distance$DistanceProxy.prototype.I$getSupport$Lorg$jbox2d$common$Vec2$.call(var183,var185))) | 0;
            var175.indexA = var186;
            // line number 708
            var187 = phi26;
            var188 = phi24;
            var189 = ((var175.indexA)) | 0;
            var190 = (org$jbox2d$collision$Distance$DistanceProxy.prototype.Lorg$jbox2d$common$Vec2$$getVertex$I.call(var188,var189));
            var191 = (var175.wA);
            org$jbox2d$common$Transform.$i;
            org$jbox2d$common$Transform.V$mulToOutUnsafe$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var187,var190,var191);
            // line number 710
            var192 = phi27;
            var193 = (var192.q);
            var194 = phi20;
            var195 = (var194.d);
            var196 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$negateLocal$$.call(var195));
            var197 = phi20;
            var198 = (var197.temp);
            org$jbox2d$common$Rot.V$mulTransUnsafe$Lorg$jbox2d$common$Rot$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var193,var196,var198);
            // line number 711
            var199 = phi25;
            var200 = phi20;
            var201 = (var200.temp);
            var202 = ((org$jbox2d$collision$Distance$DistanceProxy.prototype.I$getSupport$Lorg$jbox2d$common$Vec2$.call(var199,var201))) | 0;
            var175.indexB = var202;
            // line number 712
            var203 = phi27;
            var204 = phi25;
            var205 = ((var175.indexB)) | 0;
            var206 = (org$jbox2d$collision$Distance$DistanceProxy.prototype.Lorg$jbox2d$common$Vec2$$getVertex$I.call(var204,var205));
            var207 = (var175.wB);
            org$jbox2d$common$Transform.V$mulToOutUnsafe$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var203,var206,var207);
            // line number 713
            var208 = (var175.w);
            var209 = (var175.wB);
            var210 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var208,var209));
            var211 = (var175.wA);
            var212 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var210,var211));
            // line number 716
            phi32 = ((phi32 + 1)) | 0;
            // line number 717
            var213 = ((org$jbox2d$collision$Distance.GJK_ITERS)) | 0;
            var214 = ((var213 + 1)) | 0;
            org$jbox2d$collision$Distance.GJK_ITERS = var214;
            // line number 720
            var215 = (0) | 0;
            // line number 721
            var216 = (0) | 0;
            phi217 = var162;
            phi218 = var159;
            phi219 = var175;
            phi220 = (var215) | 0;
            phi221 = (var216) | 0;
            L603895616: while(true) {
             var222 = (phi221) | 0;
             var223 = (phi39) | 0;
             If_765_0: {
              if (var222 >= var223) {
               phi237 = (phi220) | 0;
               break If_765_0;
              } else {
               // line number 722
               var224 = phi219;
               var225 = ((var224.indexA)) | 0;
               var226 = phi20;
               var227 = (var226.saveA);
               var228 = (phi221) | 0;
               var229 = ((var227.data[var228])) | 0;
               If_784_0: {
                if (var225 != var229) {
                 break If_784_0;
                } else {
                 var230 = phi219;
                 var231 = ((var230.indexB)) | 0;
                 var232 = phi20;
                 var233 = (var232.saveB);
                 var234 = (phi221) | 0;
                 var235 = ((var233.data[var234])) | 0;
                 if (var231 != var235) {
                  break If_784_0;
                 } else {
                  // line number 723
                  var236 = (1) | 0;
                  // line number 724
                  // Here was a goto statement
                  phi237 = (var236) | 0;
                  break If_765_0;
                 }
                }
               }
               // line number 721
               phi221 = ((phi221 + 1)) | 0;
               // Here was a goto statement
               continue L603895616;
              }
             }
             // line number 729
             var238 = (phi237) | 0;
             if (var238 == 0) {
              // line number 734
              var239 = phi20;
              var240 = (var239.simplex);
              var241 = ((var240.m_count)) | 0;
              var242 = ((var241 + 1)) | 0;
              var240.m_count = var242;
              // line number 735
              // Here was a goto statement
              phi29 = (phi39) | 0;
              phi30 = phi217;
              phi31 = phi218;
              continue L774221940;
             } else {
              // line number 730
              // Here was a goto statement
              phi30 = phi217;
              phi31 = phi218;
              break If_113_0;
             }
            }
           } else {
            // line number 693
            // Here was a goto statement
            phi30 = var162;
            phi31 = var159;
            break If_113_0;
           }
          }
         } else {
          // line number 669
          // Here was a goto statement
          break If_113_0;
         }
        } else {
         // line number 650
         var43 = phi20;
         var44 = (var43.saveA);
         var45 = (phi40) | 0;
         var46 = phi28;
         var47 = (phi40) | 0;
         var48 = (var46.data[var47]);
         var49 = ((var48.indexA)) | 0;
         var44.data[var45] = var49;
         // line number 651
         var50 = phi20;
         var51 = (var50.saveB);
         var52 = (phi40) | 0;
         var53 = phi28;
         var54 = (phi40) | 0;
         var55 = (var53.data[var54]);
         var56 = ((var55.indexB)) | 0;
         var51.data[var52] = var56;
         // line number 649
         phi40 = ((phi40 + 1)) | 0;
         // Here was a goto statement
         continue L1921963024;
        }
       }
      }
     }
     // line number 737
     var65 = ((org$jbox2d$collision$Distance.GJK_MAX_ITERS)) | 0;
     var66 = (phi32) | 0;
     org$jbox2d$common$MathUtils.$i;
     var67 = ((org$jbox2d$common$MathUtils.I$max$I$I(var65,var66))) | 0;
     org$jbox2d$collision$Distance.GJK_MAX_ITERS = var67;
     // line number 740
     var68 = phi20;
     var69 = (var68.simplex);
     var70 = phi21;
     var71 = (var70.pointA);
     var72 = phi21;
     var73 = (var72.pointB);
     org$jbox2d$collision$Distance$Simplex.prototype.V$getWitnessPoints$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$.call(var69,var71,var73);
     // line number 741
     var74 = phi21;
     var75 = phi21;
     var76 = (var75.pointA);
     var77 = phi21;
     var78 = (var77.pointB);
     var79 = (org$jbox2d$common$MathUtils.F$distance$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$common$Vec2$(var76,var78));
     var74.distance = var79;
     // line number 742
     var80 = phi21;
     var81 = (phi32) | 0;
     var80.iterations = var81;
     // line number 745
     var82 = phi20;
     var83 = (var82.simplex);
     var84 = phi22;
     org$jbox2d$collision$Distance$Simplex.prototype.V$writeCache$Lorg$jbox2d$collision$Distance$SimplexCache$.call(var83,var84);
     // line number 748
     var85 = phi23;
     var86 = (var85.useRadii);
     If_304_0: {
      if (var86 == 0) {
       phi137 = phi40;
       break If_304_0;
      } else {
       // line number 749
       var87 = phi24;
       var88 = (var87.m_radius);
       // line number 750
       var89 = phi25;
       var90 = (var89.m_radius);
       // line number 752
       var91 = phi21;
       var92 = (var91.distance);
       var93 = var90;
       var94 = (var88 + var93);
       var95 = (bytecoder.cmp(var92,var94)) | 0;
       If_336_0: {
        if (var95 <= 0) {
         phi139 = var88;
         phi140 = var90;
         break If_336_0;
        } else {
         var96 = phi21;
         var97 = (var96.distance);
         var98 = (bytecoder.cmp(var97,1.1920929E-7)) | 0;
         if (var98 <= 0) {
          phi139 = var88;
          phi140 = var90;
          break If_336_0;
         } else {
          // line number 755
          var99 = phi21;
          var100 = (var99.distance);
          var101 = var90;
          var102 = (var88 + var101);
          var103 = (var100 - var102);
          var99.distance = var103;
          // line number 756
          var104 = phi20;
          var105 = (var104.normal);
          var106 = phi21;
          var107 = (var106.pointB);
          var108 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var105,var107));
          var109 = phi21;
          var110 = (var109.pointA);
          var111 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var108,var110));
          // line number 757
          var112 = phi20;
          var113 = (var112.normal);
          var114 = (org$jbox2d$common$Vec2.prototype.F$normalize$$.call(var113));
          // line number 758
          var115 = phi20;
          var116 = (var115.temp);
          var117 = phi20;
          var118 = (var117.normal);
          var119 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var116,var118));
          var120 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var119,var88));
          // line number 759
          var121 = phi21;
          var122 = (var121.pointA);
          var123 = phi20;
          var124 = (var123.temp);
          var125 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var122,var124));
          // line number 760
          var126 = phi20;
          var127 = (var126.temp);
          var128 = phi20;
          var129 = (var128.normal);
          var130 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var127,var129));
          var131 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var130,var90));
          // line number 761
          var132 = phi21;
          var133 = (var132.pointB);
          var134 = phi20;
          var135 = (var134.temp);
          var136 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$subLocal$Lorg$jbox2d$common$Vec2$.call(var133,var135));
          // Here was a goto statement
          phi137 = var88;
          phi138 = var90;
          break If_304_0;
         }
        }
       }
       // line number 766
       var141 = phi21;
       var142 = (var141.pointA);
       var143 = phi21;
       var144 = (var143.pointB);
       var145 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$addLocal$Lorg$jbox2d$common$Vec2$.call(var142,var144));
       var146 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$mulLocal$F.call(var145,0.5));
       // line number 767
       var147 = phi21;
       var148 = (var147.pointB);
       var149 = phi21;
       var150 = (var149.pointA);
       var151 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var148,var150));
       // line number 768
       var152 = phi21;
       var152.distance = 0.0;
       phi137 = phi139;
       phi138 = phi140;
       break If_304_0;
      }
     }
     // line number 771
     return;
    }
  }
}


class org$jbox2d$collision$Manifold extends java$lang$Object {
  nativeObject = null;

  pointCount = 0;
  points = null;
  type = null;
  localNormal = null;
  localPoint = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$collision$Manifold,[org$jbox2d$collision$Manifold,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$set$Lorg$jbox2d$collision$Manifold$(arg0) {
    // source file is Manifold.java
    var var0 = null;
    var phi1 = null;
    var phi2 = null;
    var phi3 = 0;
    var var4 = 0;
    var var5 = null;
    var var6 = 0;
    var var7 = null;
    var var8 = null;
    var var9 = 0;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = 0;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = 0;
    var0 = arg0;
    // line number 107
    phi1 = this;
    phi2 = var0;
    phi3 = (0) | 0;
    L247188702: while(true) {
     var4 = (phi3) | 0;
     var5 = phi2;
     var6 = ((var5.pointCount)) | 0;
     if (var4 >= var6) {
      // line number 111
      var15 = phi1;
      var16 = phi2;
      var17 = (var16.type);
      var15.type = var17;
      // line number 112
      var18 = phi1;
      var19 = (var18.localNormal);
      var20 = phi2;
      var21 = (var20.localNormal);
      var22 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var19,var21));
      // line number 113
      var23 = phi1;
      var24 = (var23.localPoint);
      var25 = phi2;
      var26 = (var25.localPoint);
      var27 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var24,var26));
      // line number 114
      var28 = phi1;
      var29 = phi2;
      var30 = ((var29.pointCount)) | 0;
      var28.pointCount = var30;
      // line number 115
      return;
     } else {
      // line number 108
      var7 = phi1;
      var8 = (var7.points);
      var9 = (phi3) | 0;
      var10 = (var8.data[var9]);
      var11 = phi2;
      var12 = (var11.points);
      var13 = (phi3) | 0;
      var14 = (var12.data[var13]);
      org$jbox2d$collision$ManifoldPoint.prototype.V$set$Lorg$jbox2d$collision$ManifoldPoint$.call(var10,var14);
      // line number 107
      phi3 = ((phi3 + 1)) | 0;
      // Here was a goto statement
      continue L247188702;
     }
    }
  }

  V$$init$$$() {
    // source file is Manifold.java
    var var0 = null;
    var var1 = null;
    var phi2 = null;
    var phi3 = 0;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    // line number 74
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 75
    var0 = this;
    var1 = bytecoder.newarray((2),null);
    var0.points = var1;
    // line number 76
    phi2 = this;
    phi3 = (0) | 0;
    L1622136229: while(true) {
     var4 = (phi3) | 0;
     if (var4 >= 2) {
      // line number 79
      var9 = phi2;
      org$jbox2d$common$Vec2.$i;
      var10 = new org$jbox2d$common$Vec2();
      org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var10);
      var9.localNormal = var10;
      // line number 80
      var11 = phi2;
      var12 = new org$jbox2d$common$Vec2();
      org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var12);
      var11.localPoint = var12;
      // line number 81
      var13 = phi2;
      var13.pointCount = 0;
      // line number 82
      return;
     } else {
      // line number 77
      var5 = phi2;
      var6 = (var5.points);
      var7 = (phi3) | 0;
      var8 = new org$jbox2d$collision$ManifoldPoint();
      org$jbox2d$collision$ManifoldPoint.prototype.V$$init$$$.call(var8);
      var6.data[var7] = var8;
      // line number 76
      phi3 = ((phi3 + 1)) | 0;
      // Here was a goto statement
      continue L1622136229;
     }
    }
  }
}


class org$jbox2d$dynamics$BodyDef extends java$lang$Object {
  nativeObject = null;

  userData = null;
  position = null;
  angle = 0.0;
  linearVelocity = null;
  angularVelocity = 0.0;
  linearDamping = 0.0;
  angularDamping = 0.0;
  allowSleep = false;
  awake = false;
  fixedRotation = false;
  bullet = false;
  type = null;
  active = false;
  gravityScale = 0.0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$dynamics$BodyDef,[org$jbox2d$dynamics$BodyDef,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is BodyDef.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    // line number 119
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 120
    var0 = this;
    var0.userData = null;
    // line number 121
    var1 = this;
    org$jbox2d$common$Vec2.$i;
    var2 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var2);
    var1.position = var2;
    // line number 122
    var3 = this;
    var3.angle = 0.0;
    // line number 123
    var4 = this;
    var5 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var5);
    var4.linearVelocity = var5;
    // line number 124
    var6 = this;
    var6.angularVelocity = 0.0;
    // line number 125
    var7 = this;
    var7.linearDamping = 0.0;
    // line number 126
    var8 = this;
    var8.angularDamping = 0.0;
    // line number 127
    var9 = this;
    var9.allowSleep = 1;
    // line number 128
    var10 = this;
    var10.awake = 1;
    // line number 129
    var11 = this;
    var11.fixedRotation = 0;
    // line number 130
    var12 = this;
    var12.bullet = 0;
    // line number 131
    var13 = this;
    org$jbox2d$dynamics$BodyType.$i;
    var14 = (org$jbox2d$dynamics$BodyType.STATIC);
    var13.type = var14;
    // line number 132
    var15 = this;
    var15.active = 1;
    // line number 133
    var16 = this;
    var16.gravityScale = 1.0;
    // line number 134
    return;
  }
}


class java$util$function$Supplier extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$function$Supplier,[java$util$function$Supplier,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.Ljava$lang$Object$$get$$ = impl;
  }
}


class org$jbox2d$callbacks$TreeRayCastCallback extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$callbacks$TreeRayCastCallback,[org$jbox2d$callbacks$TreeRayCastCallback,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class jdk$internal$access$JavaIOPrintStreamAccess extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(jdk$internal$access$JavaIOPrintStreamAccess,[jdk$internal$access$JavaIOPrintStreamAccess,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class org$jbox2d$collision$broadphase$DynamicTree$TreeNodeStack extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;
  this$0 = null;
  stack = null;
  position = 0;
  size = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$collision$broadphase$DynamicTree$TreeNodeStack,[org$jbox2d$collision$broadphase$DynamicTree$TreeNodeStack,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is DynamicTree.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    // line number 882
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(org$jbox2d$collision$broadphase$DynamicTree.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    org$jbox2d$collision$broadphase$DynamicTree$TreeNodeStack.$i;
    org$jbox2d$collision$broadphase$DynamicTree$TreeNodeStack.$assertionsDisabled = phi2;
    return;
  }

  V$$init$$Lorg$jbox2d$collision$broadphase$DynamicTree$$I(arg0,arg1) {
    // source file is DynamicTree.java
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = 0;
    var0 = this;
    var1 = (arg1) | 0;
    // line number 887
    var2 = arg0;
    var0.this$0 = var2;
    java$lang$Object.prototype.V$$init$$$.call(var0);
    // line number 888
    var3 = (var1) | 0;
    var4 = bytecoder.newarray((var3),null);
    var0.stack = var4;
    // line number 889
    var0.position = 0;
    // line number 890
    var5 = (var1) | 0;
    var0.size = var5;
    // line number 891
    return;
  }

  V$reset$$() {
    // source file is DynamicTree.java
    var var0 = null;
    var var1 = 0;
    var0 = this;
    // line number 894
    var1 = (0) | 0;
    var0.position = var1;
    // line number 895
    return;
  }

  V$push$Lorg$jbox2d$collision$broadphase$DynamicTreeNode$(arg0) {
    // source file is DynamicTree.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = 0;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = 0;
    var var11 = 0;
    var var12 = null;
    var var13 = 0;
    var phi14 = null;
    var phi15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = 0;
    var var20 = 0;
    var var21 = 0;
    var var22 = null;
    var0 = arg0;
    // line number 903
    var1 = ((this.position)) | 0;
    var2 = ((this.size)) | 0;
    If_13_0: {
     if (var1 != var2) {
      phi14 = this;
      phi15 = var0;
      break If_13_0;
     } else {
      // line number 904
      var3 = (this.stack);
      // line number 905
      var4 = this;
      var5 = ((this.size)) | 0;
      var6 = ((var5 * 2)) | 0;
      var7 = bytecoder.newarray((var6),null);
      var4.stack = var7;
      // line number 906
      var8 = this;
      var9 = (this.stack);
      var10 = (var9.data.length) | 0;
      var8.size = var10;
      // line number 907
      var11 = (0) | 0;
      var12 = (this.stack);
      var13 = (var3.data.length) | 0;
      java$lang$System.V$arraycopy$Ljava$lang$Object$$I$Ljava$lang$Object$$I$I(var3,var11,var12,0,var13);
      phi14 = this;
      phi15 = var0;
      break If_13_0;
     }
    }
    // line number 909
    var16 = phi14;
    var17 = (var16.stack);
    var18 = phi14;
    var19 = ((var18.position)) | 0;
    var20 = (1) | 0;
    var21 = ((var19 + var20)) | 0;
    var18.position = var21;
    var22 = phi15;
    var17.data[var19] = var22;
    // line number 910
    return;
  }

  I$getCount$$() {
    // source file is DynamicTree.java
    var var0 = 0;
    // line number 913
    var0 = ((this.position)) | 0;
    return var0;
  }

  Lorg$jbox2d$collision$broadphase$DynamicTreeNode$$pop$$() {
    // source file is DynamicTree.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var phi4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = 0;
    var var10 = null;
    // line number 898
    org$jbox2d$collision$broadphase$DynamicTree$TreeNodeStack.$i;
    var0 = (org$jbox2d$collision$broadphase$DynamicTree$TreeNodeStack.$assertionsDisabled);
    If_9_0: {
     if (var0 != 0) {
      phi4 = this;
      break If_9_0;
     } else {
      var1 = this;
      var2 = ((var1.position)) | 0;
      if (var2 > 0) {
       phi4 = this;
       break If_9_0;
      } else {
       var3 = new java$lang$AssertionError();
       java$lang$AssertionError.prototype.V$$init$$$.call(var3);
       throw bytecoder.registerStack(var3, new Error().stack);
      }
     }
    }
    // line number 899
    var5 = phi4;
    var6 = (var5.stack);
    var7 = phi4;
    var8 = ((var7.position)) | 0;
    var9 = ((var8 - 1)) | 0;
    var7.position = var9;
    var10 = (var6.data[var9]);
    return var10;
  }
}


class java$util$HashMap$HashIterator extends java$lang$Object {
  nativeObject = null;

  this$0 = null;
  expectedModCount = 0;
  next = null;
  current = null;
  index = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$HashMap$HashIterator,[java$util$HashMap$HashIterator,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Ljava$util$HashMap$(arg0) {
    // source file is HashMap.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var phi8 = null;
    var phi9 = null;
    var phi10 = null;
    var var11 = null;
    var var12 = 0;
    var var13 = null;
    var var14 = 0;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = 0;
    var var19 = 0;
    var var20 = null;
    var0 = this;
    // line number 1587
    var1 = arg0;
    var0.this$0 = var1;
    java$lang$Object.prototype.V$$init$$$.call(var0);
    // line number 1588
    var2 = ((arg0.modCount)) | 0;
    var0.expectedModCount = var2;
    // line number 1589
    var3 = (arg0.table);
    // line number 1590
    var4 = var0;
    var5 = null;
    var4.next = var5;
    var0.current = null;
    // line number 1591
    var0.index = 0;
    // line number 1592
    If_37_0: {
     if (var3 == null) {
      phi8 = var0;
      phi9 = arg0;
      phi10 = var3;
      break If_37_0;
     } else {
      var6 = arg0;
      var7 = ((var6.size)) | 0;
      if (var7 <= 0) {
       phi8 = var0;
       phi9 = arg0;
       phi10 = var3;
       break If_37_0;
      } else {
       phi8 = var0;
       phi9 = arg0;
       phi10 = var3;
       L1078095439: while(true) {
        // line number 1593
        var11 = phi8;
        var12 = ((var11.index)) | 0;
        var13 = phi10;
        var14 = (var13.data.length) | 0;
        if (var12 >= var14) {
         break If_37_0;
        } else {
         var15 = phi8;
         var16 = phi10;
         var17 = phi8;
         var18 = ((var17.index)) | 0;
         var19 = ((var18 + 1)) | 0;
         var17.index = var19;
         var20 = (var16.data[var18]);
         var15.next = var20;
         if (var20 == null) {
          continue L1078095439;
         } else {
          break If_37_0;
         }
        }
       }
      }
     }
    }
    // line number 1595
    return;
  }

  Z$hasNext$$() {
    // source file is HashMap.java
    var var0 = null;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    // line number 1598
    var0 = (this.next);
    If_7_0: {
     if (var0 == null) {
      phi2 = this;
      phi3 = (0) | 0;
      break If_7_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = this;
      phi3 = (var1) | 0;
      break If_7_0;
     }
    }
    return phi3;
  }

  Ljava$util$HashMap$Node$$nextNode$$() {
    // source file is HashMap.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var phi14 = null;
    var phi15 = null;
    var phi16 = null;
    var var17 = null;
    var var18 = 0;
    var var19 = null;
    var var20 = 0;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = 0;
    var var25 = 0;
    var var26 = null;
    var var27 = null;
    // line number 1603
    var0 = (this.next);
    // line number 1604
    var1 = (this.this$0);
    var2 = ((var1.modCount)) | 0;
    var3 = ((this.expectedModCount)) | 0;
    if (var2 == var3) {
     // line number 1606
     if (var0 != null) {
      // line number 1608
      var6 = this;
      var7 = this;
      var8 = var0;
      var7.current = var8;
      var9 = (var0.next);
      var6.next = var9;
      If_57_0: {
       if (var9 != null) {
        phi14 = this;
        phi16 = var0;
        break If_57_0;
       } else {
        var10 = this;
        var11 = (var10.this$0);
        var12 = (var11.table);
        var13 = var12;
        if (var12 == null) {
         phi14 = this;
         phi15 = var13;
         phi16 = var0;
         break If_57_0;
        } else {
         phi14 = this;
         phi15 = var13;
         phi16 = var0;
         L327432375: while(true) {
          // line number 1609
          var17 = phi14;
          var18 = ((var17.index)) | 0;
          var19 = phi15;
          var20 = (var19.data.length) | 0;
          if (var18 >= var20) {
           break If_57_0;
          } else {
           var21 = phi14;
           var22 = phi15;
           var23 = phi14;
           var24 = ((var23.index)) | 0;
           var25 = ((var24 + 1)) | 0;
           var23.index = var25;
           var26 = (var22.data[var24]);
           var21.next = var26;
           if (var26 == null) {
            continue L327432375;
           } else {
            break If_57_0;
           }
          }
         }
        }
       }
      }
      // line number 1611
      var27 = phi16;
      return var27;
     } else {
      // line number 1607
      var5 = new java$util$NoSuchElementException();
      java$util$NoSuchElementException.prototype.V$$init$$$.call(var5);
      throw bytecoder.registerStack(var5, new Error().stack);
     }
    } else {
     // line number 1605
     var4 = new java$util$ConcurrentModificationException();
     java$util$ConcurrentModificationException.prototype.V$$init$$$.call(var4);
     throw bytecoder.registerStack(var4, new Error().stack);
    }
  }
}


class java$lang$ClassLoader extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$ClassLoader,[java$lang$ClassLoader,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is ClassLoader.java
    // line number 22
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class java$lang$Void extends java$lang$Object {
  nativeObject = null;

  static TYPE = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Void,[java$lang$Void,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is Void.java
    var var0 = null;
    // line number 43
    var0 = (java$lang$Class.Ljava$lang$Class$$getPrimitiveClass$Ljava$lang$String$(bytecoder.stringconstants[2]));
    java$lang$Void.$i;
    java$lang$Void.TYPE = var0;
    return;
  }

  V$$init$$$() {
    // source file is Void.java
    // line number 48
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class java$lang$Throwable extends java$lang$Object {
  nativeObject = null;

  message = null;
  cause = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Throwable,[java$lang$Throwable,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  Ljava$lang$String$$getMessage$$() {
    // source file is Throwable.java
    var var0 = null;
    // line number 71
    var0 = (this.message);
    return var0;
  }

  V$$init$$Ljava$lang$String$(arg0) {
    // source file is Throwable.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    // line number 29
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 30
    var1 = this;
    var1.message = var0;
    // line number 31
    var2 = this;
    var2.cause = null;
    // line number 32
    return;
  }

  V$$init$$$() {
    // source file is Throwable.java
    var var0 = null;
    var var1 = null;
    // line number 49
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 50
    var0 = this;
    var0.message = null;
    // line number 51
    var1 = this;
    var1.cause = null;
    // line number 52
    return;
  }

  Ljava$lang$Throwable$$initCause$Ljava$lang$Throwable$(arg0) {
    // source file is Throwable.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = this;
    // line number 83
    var1 = arg0;
    var0.cause = var1;
    // line number 84
    var2 = var0;
    return var2;
  }

  V$$init$$Ljava$lang$Throwable$(arg0) {
    // source file is Throwable.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    // line number 44
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 45
    var1 = this;
    var1.message = null;
    // line number 46
    var2 = this;
    var2.cause = var0;
    // line number 47
    return;
  }
}


class de$mirkosertic$bytecoder$api$OpaqueReferenceType extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(de$mirkosertic$bytecoder$api$OpaqueReferenceType,[de$mirkosertic$bytecoder$api$OpaqueReferenceType,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class java$util$Collections extends java$lang$Object {
  nativeObject = null;

  static EMPTY_SET = null;
  static EMPTY_LIST = null;
  static EMPTY_MAP = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$Collections,[java$util$Collections,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is Collections.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    // line number 4403
    var0 = new java$util$Collections$EmptySet();
    java$util$Collections$EmptySet.prototype.V$$init$$$.call(var0);
    java$util$Collections.$i;
    java$util$Collections.EMPTY_SET = var0;
    // line number 4529
    var1 = new java$util$Collections$EmptyList();
    java$util$Collections$EmptyList.prototype.V$$init$$$.call(var1);
    java$util$Collections.EMPTY_LIST = var1;
    // line number 4633
    var2 = new java$util$Collections$EmptyMap();
    java$util$Collections$EmptyMap.prototype.V$$init$$$.call(var2);
    java$util$Collections.EMPTY_MAP = var2;
    return;
  }

  static Ljava$util$Set$$synchronizedSet$Ljava$util$Set$$Ljava$lang$Object$(arg0,arg1) {
    // source file is Collections.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg1;
    // line number 2188
    var1 = new java$util$Collections$SynchronizedSet();
    var2 = arg0;
    java$util$Collections$SynchronizedSet.prototype.V$$init$$Ljava$util$Set$$Ljava$lang$Object$.call(var1,var2,var0);
    return var1;
  }

  static Ljava$util$Iterator$$emptyIterator$$() {
    // source file is Collections.java
    var var0 = null;
    // line number 4304
    java$util$Collections$EmptyIterator.$i;
    var0 = (java$util$Collections$EmptyIterator.EMPTY_ITERATOR);
    return var0;
  }

  V$$init$$$() {
    // source file is Collections.java
    // line number 86
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 87
    return;
  }

  static Ljava$util$Set$$emptySet$$() {
    // source file is Collections.java
    var var0 = null;
    // line number 4426
    java$util$Collections.$i;
    var0 = (java$util$Collections.EMPTY_SET);
    return var0;
  }

  static Ljava$util$ListIterator$$emptyListIterator$$() {
    // source file is Collections.java
    var var0 = null;
    // line number 4348
    java$util$Collections$EmptyListIterator.$i;
    var0 = (java$util$Collections$EmptyListIterator.EMPTY_ITERATOR);
    return var0;
  }
}


class java$lang$invoke$MethodHandle extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$invoke$MethodHandle,[java$lang$invoke$MethodHandle,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.Ljava$lang$Object$$invokeExact$$Ljava$lang$Object$ = impl;
  }

  V$$init$$$() {
    // source file is MethodHandle.java
    // line number 21
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class org$jbox2d$collision$Distance$SimplexCache extends java$lang$Object {
  nativeObject = null;

  indexA = null;
  indexB = null;
  metric = 0.0;
  count = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$collision$Distance$SimplexCache,[org$jbox2d$collision$Distance$SimplexCache,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is Distance.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = 0;
    var var10 = null;
    var var11 = 0;
    var var12 = null;
    var var13 = 0;
    var var14 = null;
    var var15 = 0;
    var var16 = null;
    var var17 = 0;
    // line number 85
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 81
    var0 = this;
    var1 = bytecoder.newarray((3),0);
    var0.indexA = var1;
    // line number 83
    var2 = this;
    var3 = bytecoder.newarray((3),0);
    var2.indexB = var3;
    // line number 86
    var4 = this;
    var4.metric = 0.0;
    // line number 87
    var5 = this;
    var5.count = 0;
    // line number 88
    var6 = (this.indexA);
    var7 = (2147483647) | 0;
    var6.data[0] = var7;
    // line number 89
    var8 = (this.indexA);
    var9 = (2147483647) | 0;
    var8.data[1] = var9;
    // line number 90
    var10 = (this.indexA);
    var11 = (2147483647) | 0;
    var10.data[2] = var11;
    // line number 91
    var12 = (this.indexB);
    var13 = (2147483647) | 0;
    var12.data[0] = var13;
    // line number 92
    var14 = (this.indexB);
    var15 = (2147483647) | 0;
    var14.data[1] = var15;
    // line number 93
    var16 = (this.indexB);
    var17 = (2147483647) | 0;
    var16.data[2] = var17;
    // line number 94
    return;
  }
}


class org$jbox2d$dynamics$joints$JointEdge extends java$lang$Object {
  nativeObject = null;

  other = null;
  joint = null;
  prev = null;
  next = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$dynamics$joints$JointEdge,[org$jbox2d$dynamics$joints$JointEdge,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is JointEdge.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    // line number 36
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 41
    var0 = this;
    var0.other = null;
    // line number 46
    var1 = this;
    var1.joint = null;
    // line number 51
    var2 = this;
    var2.prev = null;
    // line number 56
    var3 = this;
    var3.next = null;
    return;
  }
}


class java$lang$AbstractStringBuilder extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$AbstractStringBuilder,[java$lang$AbstractStringBuilder,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class org$jbox2d$dynamics$Fixture extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;
  pool1 = null;
  pool2 = null;
  displacement = null;
  m_userData = null;
  m_body = null;
  m_next = null;
  m_proxies = null;
  m_proxyCount = 0;
  m_shape = null;
  m_filter = null;
  m_friction = 0.0;
  m_restitution = 0.0;
  m_isSensor = false;
  m_density = 0.0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$dynamics$Fixture,[org$jbox2d$dynamics$Fixture,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is Fixture.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    // line number 48
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(org$jbox2d$dynamics$Fixture.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    org$jbox2d$dynamics$Fixture.$i;
    org$jbox2d$dynamics$Fixture.$assertionsDisabled = phi2;
    return;
  }

  V$$init$$$() {
    // source file is Fixture.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    // line number 69
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 406
    var0 = this;
    var1 = new org$jbox2d$collision$AABB();
    org$jbox2d$collision$AABB.prototype.V$$init$$$.call(var1);
    var0.pool1 = var1;
    // line number 407
    var2 = this;
    var3 = new org$jbox2d$collision$AABB();
    org$jbox2d$collision$AABB.prototype.V$$init$$$.call(var3);
    var2.pool2 = var3;
    // line number 408
    var4 = this;
    org$jbox2d$common$Vec2.$i;
    var5 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var5);
    var4.displacement = var5;
    // line number 70
    var6 = this;
    var6.m_userData = null;
    // line number 71
    var7 = this;
    var7.m_body = null;
    // line number 72
    var8 = this;
    var8.m_next = null;
    // line number 73
    var9 = this;
    var9.m_proxies = null;
    // line number 74
    var10 = this;
    var10.m_proxyCount = 0;
    // line number 75
    var11 = this;
    var11.m_shape = null;
    // line number 76
    var12 = this;
    var13 = new org$jbox2d$dynamics$Filter();
    org$jbox2d$dynamics$Filter.prototype.V$$init$$$.call(var13);
    var12.m_filter = var13;
    // line number 77
    return;
  }

  V$create$Lorg$jbox2d$dynamics$Body$$Lorg$jbox2d$dynamics$FixtureDef$(arg0,arg1) {
    // source file is Fixture.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = .0;
    var var6 = null;
    var var7 = .0;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = 0;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = 0;
    var var17 = null;
    var var18 = 0;
    var var19 = null;
    var var20 = 0;
    var phi21 = null;
    var phi22 = null;
    var phi23 = null;
    var phi24 = 0;
    var phi25 = 0;
    var var26 = 0;
    var var27 = 0;
    var var28 = null;
    var var29 = null;
    var var30 = 0;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = 0;
    var var35 = null;
    var var36 = null;
    var var37 = null;
    var var38 = 0;
    var var39 = null;
    var var40 = null;
    var var41 = null;
    var var42 = 0;
    var var43 = 0;
    var var44 = null;
    var var45 = null;
    var var46 = 0;
    var var47 = 0;
    var var48 = 0;
    var var49 = 0;
    var var50 = null;
    var var51 = null;
    var var52 = null;
    var var53 = null;
    var var54 = null;
    var var55 = 0;
    var var56 = 0;
    var phi57 = null;
    var phi58 = 0;
    var phi59 = 0;
    var var60 = 0;
    var var61 = 0;
    var var62 = 0;
    var var63 = null;
    var var64 = 0;
    var var65 = null;
    var var66 = null;
    var var67 = 0;
    var var68 = null;
    var var69 = null;
    var var70 = null;
    var var71 = 0;
    var var72 = null;
    var var73 = null;
    var var74 = null;
    var var75 = 0;
    var var76 = null;
    var var77 = null;
    var var78 = null;
    var var79 = null;
    var var80 = .0;
    var0 = this;
    var1 = arg1;
    // line number 318
    var2 = var1;
    var3 = (var2.userData);
    var0.m_userData = var3;
    // line number 319
    var4 = var1;
    var5 = (var4.friction);
    var0.m_friction = var5;
    // line number 320
    var6 = var1;
    var7 = (var6.restitution);
    var0.m_restitution = var7;
    // line number 322
    var0.m_body = arg0;
    // line number 323
    var0.m_next = null;
    // line number 326
    var8 = (var0.m_filter);
    var9 = (var1.filter);
    org$jbox2d$dynamics$Filter.prototype.V$set$Lorg$jbox2d$dynamics$Filter$.call(var8,var9);
    // line number 328
    var10 = var1;
    var11 = (var10.isSensor);
    var0.m_isSensor = var11;
    // line number 330
    var12 = var1;
    var13 = (var12.shape);
    var14 = (var13.Lorg$jbox2d$collision$shapes$Shape$$clone$$());
    var0.m_shape = var14;
    // line number 333
    var15 = (var0.m_shape);
    var16 = ((var15.I$getChildCount$$())) | 0;
    // line number 334
    var17 = (var0.m_proxies);
    If_80_0: {
     if (var17 != null) {
      phi21 = var0;
      phi22 = arg0;
      phi23 = var1;
      phi24 = (var16) | 0;
      break If_80_0;
     } else {
      // line number 335
      var18 = (var16) | 0;
      var19 = bytecoder.newarray((var18),null);
      var0.m_proxies = var19;
      // line number 336
      var20 = (0) | 0;
      phi21 = var0;
      phi22 = arg0;
      phi23 = var1;
      phi24 = (var16) | 0;
      phi25 = (var20) | 0;
      L2069279849: while(true) {
       var26 = (phi25) | 0;
       var27 = (phi24) | 0;
       if (var26 >= var27) {
        break If_80_0;
       } else {
        // line number 337
        var28 = phi21;
        var29 = (var28.m_proxies);
        var30 = (phi25) | 0;
        var31 = new org$jbox2d$dynamics$FixtureProxy();
        org$jbox2d$dynamics$FixtureProxy.prototype.V$$init$$$.call(var31);
        var29.data[var30] = var31;
        // line number 338
        var32 = phi21;
        var33 = (var32.m_proxies);
        var34 = (phi25) | 0;
        var35 = (var33.data[var34]);
        var35.fixture = null;
        // line number 339
        var36 = phi21;
        var37 = (var36.m_proxies);
        var38 = (phi25) | 0;
        var39 = (var37.data[var38]);
        var39.proxyId = -1;
        // line number 336
        phi25 = ((phi25 + 1)) | 0;
        // Here was a goto statement
        continue L2069279849;
       }
      }
     }
    }
    // line number 343
    var40 = phi21;
    var41 = (var40.m_proxies);
    var42 = (var41.data.length) | 0;
    var43 = (phi24) | 0;
    If_171_0: {
     if (var42 >= var43) {
      phi57 = phi25;
      break If_171_0;
     } else {
      // line number 344
      var44 = phi21;
      var45 = (var44.m_proxies);
      // line number 345
      var46 = (var45.data.length) | 0;
      var47 = ((var46 * 2)) | 0;
      var48 = (phi24) | 0;
      org$jbox2d$common$MathUtils.$i;
      var49 = ((org$jbox2d$common$MathUtils.I$max$I$I(var47,var48))) | 0;
      // line number 346
      var50 = phi21;
      var51 = bytecoder.newarray((var49),null);
      var50.m_proxies = var51;
      // line number 347
      var52 = phi21;
      var53 = (var52.m_proxies);
      var54 = var45;
      var55 = (var54.data.length) | 0;
      java$lang$System.V$arraycopy$Ljava$lang$Object$$I$Ljava$lang$Object$$I$I(var45,0,var53,0,var55);
      // line number 348
      var56 = (0) | 0;
      phi57 = var45;
      phi58 = (var49) | 0;
      phi59 = (var56) | 0;
      L383680486: while(true) {
       var60 = (phi59) | 0;
       var61 = (phi58) | 0;
       if (var60 >= var61) {
        break If_171_0;
       } else {
        // line number 349
        var62 = (phi59) | 0;
        var63 = phi57;
        var64 = (var63.data.length) | 0;
        If_245_0: {
         if (var62 < var64) {
          break If_245_0;
         } else {
          // line number 350
          var65 = phi21;
          var66 = (var65.m_proxies);
          var67 = (phi59) | 0;
          var68 = new org$jbox2d$dynamics$FixtureProxy();
          org$jbox2d$dynamics$FixtureProxy.prototype.V$$init$$$.call(var68);
          var66.data[var67] = var68;
          break If_245_0;
         }
        }
        // line number 352
        var69 = phi21;
        var70 = (var69.m_proxies);
        var71 = (phi59) | 0;
        var72 = (var70.data[var71]);
        var72.fixture = null;
        // line number 353
        var73 = phi21;
        var74 = (var73.m_proxies);
        var75 = (phi59) | 0;
        var76 = (var74.data[var75]);
        var76.proxyId = -1;
        // line number 348
        phi59 = ((phi59 + 1)) | 0;
        // Here was a goto statement
        continue L383680486;
       }
      }
     }
    }
    // line number 356
    var77 = phi21;
    var77.m_proxyCount = 0;
    // line number 358
    var78 = phi21;
    var79 = phi23;
    var80 = (var79.density);
    var78.m_density = var80;
    // line number 359
    return;
  }

  V$createProxies$Lorg$jbox2d$collision$broadphase$BroadPhase$$Lorg$jbox2d$common$Transform$(arg0,arg1) {
    // source file is Fixture.java
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var phi5 = null;
    var phi6 = null;
    var phi7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = 0;
    var phi12 = 0;
    var var13 = 0;
    var var14 = null;
    var var15 = 0;
    var var16 = null;
    var var17 = null;
    var var18 = 0;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = 0;
    var var25 = null;
    var var26 = null;
    var var27 = 0;
    var var28 = null;
    var var29 = 0;
    var0 = arg0;
    // line number 376
    org$jbox2d$dynamics$Fixture.$i;
    var1 = (org$jbox2d$dynamics$Fixture.$assertionsDisabled);
    If_13_0: {
     if (var1 != 0) {
      phi5 = this;
      phi6 = var0;
      phi7 = arg1;
      break If_13_0;
     } else {
      var2 = this;
      var3 = ((var2.m_proxyCount)) | 0;
      if (var3 == 0) {
       phi5 = this;
       phi6 = var0;
       phi7 = arg1;
       break If_13_0;
      } else {
       var4 = new java$lang$AssertionError();
       java$lang$AssertionError.prototype.V$$init$$$.call(var4);
       throw bytecoder.registerStack(var4, new Error().stack);
      }
     }
    }
    // line number 379
    var8 = phi5;
    var9 = phi5;
    var10 = (var9.m_shape);
    var11 = ((var10.I$getChildCount$$())) | 0;
    var8.m_proxyCount = var11;
    // line number 381
    phi12 = (0) | 0;
    L1612517962: while(true) {
     var13 = (phi12) | 0;
     var14 = phi5;
     var15 = ((var14.m_proxyCount)) | 0;
     if (var13 >= var15) {
      // line number 388
      return;
     } else {
      // line number 382
      var16 = phi5;
      var17 = (var16.m_proxies);
      var18 = (phi12) | 0;
      var19 = (var17.data[var18]);
      // line number 383
      var20 = phi5;
      var21 = (var20.m_shape);
      var22 = (var19.aabb);
      var23 = phi7;
      var24 = (phi12) | 0;
      var21.V$computeAABB$Lorg$jbox2d$collision$AABB$$Lorg$jbox2d$common$Transform$$I(var22,var23,var24);
      // line number 384
      var25 = phi6;
      var26 = (var19.aabb);
      var27 = ((org$jbox2d$collision$broadphase$BroadPhase.prototype.I$createProxy$Lorg$jbox2d$collision$AABB$$Ljava$lang$Object$.call(var25,var26,var19))) | 0;
      var19.proxyId = var27;
      // line number 385
      var28 = phi5;
      var19.fixture = var28;
      // line number 386
      var29 = (phi12) | 0;
      var19.childIndex = var29;
      // line number 381
      phi12 = ((phi12 + 1)) | 0;
      // Here was a goto statement
      continue L1612517962;
     }
    }
  }

  V$getMassData$Lorg$jbox2d$collision$shapes$MassData$(arg0) {
    // source file is Fixture.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = .0;
    var0 = arg0;
    // line number 253
    var1 = (this.m_shape);
    var2 = this;
    var3 = (var2.m_density);
    var1.V$computeMass$Lorg$jbox2d$collision$shapes$MassData$$F(var0,var3);
    // line number 254
    return;
  }

  Lorg$jbox2d$dynamics$Body$$getBody$$() {
    // source file is Fixture.java
    var var0 = null;
    // line number 183
    var0 = (this.m_body);
    return var0;
  }

  Z$isSensor$$() {
    // source file is Fixture.java
    var var0 = 0;
    // line number 105
    var0 = (this.m_isSensor);
    return var0;
  }

  Lorg$jbox2d$collision$shapes$ShapeType$$getType$$() {
    // source file is Fixture.java
    var var0 = null;
    var var1 = null;
    // line number 85
    var0 = (this.m_shape);
    var1 = (org$jbox2d$collision$shapes$Shape.prototype.Lorg$jbox2d$collision$shapes$ShapeType$$getType$$.call(var0));
    return var1;
  }

  Lorg$jbox2d$dynamics$Filter$$getFilterData$$() {
    // source file is Fixture.java
    var var0 = null;
    // line number 139
    var0 = (this.m_filter);
    return var0;
  }

  Lorg$jbox2d$collision$shapes$Shape$$getShape$$() {
    // source file is Fixture.java
    var var0 = null;
    // line number 95
    var0 = (this.m_shape);
    return var0;
  }

  V$synchronize$Lorg$jbox2d$collision$broadphase$BroadPhase$$Lorg$jbox2d$common$Transform$$Lorg$jbox2d$common$Transform$(arg0,arg1,arg2) {
    // source file is Fixture.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var phi3 = null;
    var phi4 = null;
    var phi5 = null;
    var phi6 = null;
    var phi7 = 0;
    var var8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = null;
    var var13 = 0;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = 0;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = 0;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = .0;
    var var31 = null;
    var var32 = .0;
    var var33 = 0;
    var var34 = null;
    var var35 = null;
    var var36 = .0;
    var phi37 = null;
    var phi38 = null;
    var phi39 = null;
    var phi40 = null;
    var phi41 = .0;
    var var42 = null;
    var var43 = null;
    var var44 = null;
    var var45 = null;
    var var46 = null;
    var var47 = .0;
    var var48 = null;
    var var49 = null;
    var var50 = .0;
    var var51 = 0;
    var var52 = null;
    var var53 = null;
    var var54 = .0;
    var phi55 = null;
    var phi56 = .0;
    var var57 = null;
    var var58 = null;
    var var59 = null;
    var var60 = null;
    var var61 = null;
    var var62 = .0;
    var var63 = null;
    var var64 = null;
    var var65 = .0;
    var var66 = 0;
    var var67 = null;
    var var68 = null;
    var var69 = .0;
    var phi70 = null;
    var phi71 = .0;
    var var72 = null;
    var var73 = null;
    var var74 = null;
    var var75 = null;
    var var76 = null;
    var var77 = .0;
    var var78 = null;
    var var79 = null;
    var var80 = .0;
    var var81 = 0;
    var var82 = null;
    var var83 = null;
    var var84 = .0;
    var phi85 = null;
    var phi86 = .0;
    var var87 = null;
    var var88 = null;
    var var89 = null;
    var var90 = null;
    var var91 = .0;
    var var92 = null;
    var var93 = null;
    var var94 = .0;
    var var95 = .0;
    var var96 = null;
    var var97 = null;
    var var98 = null;
    var var99 = null;
    var var100 = .0;
    var var101 = null;
    var var102 = null;
    var var103 = .0;
    var var104 = .0;
    var var105 = null;
    var var106 = null;
    var var107 = 0;
    var var108 = null;
    var var109 = null;
    var var110 = null;
    var var111 = null;
    var var112 = null;
    var var113 = null;
    var var114 = .0;
    var var115 = null;
    var var116 = null;
    var var117 = .0;
    var var118 = null;
    var var119 = null;
    var var120 = .0;
    var var121 = null;
    var var122 = .0;
    var0 = arg0;
    var1 = arg2;
    // line number 419
    var2 = ((this.m_proxyCount)) | 0;
    if (var2 != 0) {
     // line number 423
     phi3 = this;
     phi4 = var0;
     phi5 = arg1;
     phi6 = var1;
     phi7 = (0) | 0;
     L1081078809: while(true) {
      var8 = (phi7) | 0;
      var9 = phi3;
      var10 = ((var9.m_proxyCount)) | 0;
      if (var8 >= var10) {
       // line number 441
       return;
      } else {
       // line number 424
       var11 = phi3;
       var12 = (var11.m_proxies);
       var13 = (phi7) | 0;
       var14 = (var12.data[var13]);
       // line number 427
       var15 = phi3;
       var16 = (var15.pool1);
       // line number 428
       var17 = phi3;
       var18 = (var17.pool2);
       // line number 429
       var19 = phi3;
       var20 = (var19.m_shape);
       var21 = phi5;
       var22 = ((var14.childIndex)) | 0;
       var20.V$computeAABB$Lorg$jbox2d$collision$AABB$$Lorg$jbox2d$common$Transform$$I(var16,var21,var22);
       // line number 430
       var23 = phi3;
       var24 = (var23.m_shape);
       var25 = phi6;
       var26 = ((var14.childIndex)) | 0;
       var24.V$computeAABB$Lorg$jbox2d$collision$AABB$$Lorg$jbox2d$common$Transform$$I(var18,var25,var26);
       // line number 432
       var27 = (var14.aabb);
       var28 = (var27.lowerBound);
       var29 = (var16.lowerBound);
       var30 = (var29.x);
       var31 = (var18.lowerBound);
       var32 = (var31.x);
       var33 = (bytecoder.cmp(var30,var32)) | 0;
       If_115_0: {
        if (var33 >= 0) {
         var121 = (var18.lowerBound);
         var122 = (var121.x);
         phi37 = var14;
         phi38 = var16;
         phi39 = var18;
         phi40 = var28;
         phi41 = var122;
         break If_115_0;
        } else {
         var34 = var16;
         var35 = (var34.lowerBound);
         var36 = (var35.x);
         // Here was a goto statement
         phi37 = var14;
         phi38 = var16;
         phi39 = var18;
         phi40 = var28;
         phi41 = var36;
         break If_115_0;
        }
       }
       phi40.x = phi41;
       // line number 433
       var42 = phi37;
       var43 = (var42.aabb);
       var44 = (var43.lowerBound);
       var45 = phi38;
       var46 = (var45.lowerBound);
       var47 = (var46.y);
       var48 = phi39;
       var49 = (var48.lowerBound);
       var50 = (var49.y);
       var51 = (bytecoder.cmp(var47,var50)) | 0;
       If_164_0: {
        if (var51 >= 0) {
         var118 = phi39;
         var119 = (var118.lowerBound);
         var120 = (var119.y);
         phi55 = var44;
         phi56 = var120;
         break If_164_0;
        } else {
         var52 = phi38;
         var53 = (var52.lowerBound);
         var54 = (var53.y);
         // Here was a goto statement
         phi55 = var44;
         phi56 = var54;
         break If_164_0;
        }
       }
       phi55.y = phi56;
       // line number 434
       var57 = phi37;
       var58 = (var57.aabb);
       var59 = (var58.upperBound);
       var60 = phi38;
       var61 = (var60.upperBound);
       var62 = (var61.x);
       var63 = phi39;
       var64 = (var63.upperBound);
       var65 = (var64.x);
       var66 = (bytecoder.cmp(var62,var65)) | 0;
       If_210_0: {
        if (var66 <= 0) {
         var115 = phi39;
         var116 = (var115.upperBound);
         var117 = (var116.x);
         phi70 = var59;
         phi71 = var117;
         break If_210_0;
        } else {
         var67 = phi38;
         var68 = (var67.upperBound);
         var69 = (var68.x);
         // Here was a goto statement
         phi70 = var59;
         phi71 = var69;
         break If_210_0;
        }
       }
       phi70.x = phi71;
       // line number 435
       var72 = phi37;
       var73 = (var72.aabb);
       var74 = (var73.upperBound);
       var75 = phi38;
       var76 = (var75.upperBound);
       var77 = (var76.y);
       var78 = phi39;
       var79 = (var78.upperBound);
       var80 = (var79.y);
       var81 = (bytecoder.cmp(var77,var80)) | 0;
       If_256_0: {
        if (var81 <= 0) {
         var112 = phi39;
         var113 = (var112.upperBound);
         var114 = (var113.y);
         phi85 = var74;
         phi86 = var114;
         break If_256_0;
        } else {
         var82 = phi38;
         var83 = (var82.upperBound);
         var84 = (var83.y);
         // Here was a goto statement
         phi85 = var74;
         phi86 = var84;
         break If_256_0;
        }
       }
       phi85.y = phi86;
       // line number 436
       var87 = phi3;
       var88 = (var87.displacement);
       var89 = phi6;
       var90 = (var89.p);
       var91 = (var90.x);
       var92 = phi5;
       var93 = (var92.p);
       var94 = (var93.x);
       var95 = (var91 - var94);
       var88.x = var95;
       // line number 437
       var96 = phi3;
       var97 = (var96.displacement);
       var98 = phi6;
       var99 = (var98.p);
       var100 = (var99.y);
       var101 = phi5;
       var102 = (var101.p);
       var103 = (var102.y);
       var104 = (var100 - var103);
       var97.y = var104;
       // line number 439
       var105 = phi4;
       var106 = phi37;
       var107 = ((var106.proxyId)) | 0;
       var108 = phi37;
       var109 = (var108.aabb);
       var110 = phi3;
       var111 = (var110.displacement);
       org$jbox2d$collision$broadphase$BroadPhase.prototype.V$moveProxy$I$Lorg$jbox2d$collision$AABB$$Lorg$jbox2d$common$Vec2$.call(var105,var107,var109,var111);
       // line number 423
       phi7 = ((phi7 + 1)) | 0;
       // Here was a goto statement
       continue L1081078809;
      }
     }
    } else {
     // line number 420
     return;
    }
  }

  Lorg$jbox2d$dynamics$Fixture$$getNext$$() {
    // source file is Fixture.java
    var var0 = null;
    // line number 193
    var0 = (this.m_next);
    return var0;
  }
}


class java$lang$Comparable extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Comparable,[java$lang$Comparable,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.I$compareTo$Ljava$lang$Object$ = impl;
  }
}


class java$lang$Appendable extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Appendable,[java$lang$Appendable,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class org$jbox2d$collision$Collision$EdgeResults extends java$lang$Object {
  nativeObject = null;

  edgeIndex = 0;
  separation = 0.0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$collision$Collision$EdgeResults,[org$jbox2d$collision$Collision$EdgeResults,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Lorg$jbox2d$collision$Collision$1$(arg0) {
    // source file is Collision.java
    var var0 = null;
    var0 = arg0;
    // line number 988
    org$jbox2d$collision$Collision$EdgeResults.prototype.V$$init$$$.call(this);
    return;
  }

  V$$init$$$() {
    // source file is Collision.java
    // line number 988
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class java$util$Objects extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$Objects,[java$util$Objects,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  static Ljava$lang$Object$$requireNonNull$Ljava$lang$Object$(arg0) {
    // source file is Objects.java
    var var0 = null;
    // line number 232
    if (arg0 != null) {
     // line number 234
     return arg0;
    } else {
     // line number 233
     var0 = new java$lang$NullPointerException();
     java$lang$NullPointerException.prototype.V$$init$$$.call(var0);
     throw bytecoder.registerStack(var0, new Error().stack);
    }
  }

  static I$checkFromIndexSize$I$I$I(arg0,arg1,arg2) {
    // source file is Objects.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var0 = (arg1) | 0;
    // line number 437
    var1 = (var0) | 0;
    var2 = null;
    jdk$internal$util$Preconditions.$i;
    var3 = ((jdk$internal$util$Preconditions.I$checkFromIndexSize$I$I$I$Ljava$util$function$BiFunction$(arg0,var1,arg2,var2))) | 0;
    return var3;
  }

  static I$checkIndex$I$I(arg0,arg1) {
    // source file is Objects.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var0 = (arg1) | 0;
    // line number 385
    var1 = (var0) | 0;
    jdk$internal$util$Preconditions.$i;
    var2 = ((jdk$internal$util$Preconditions.I$checkIndex$I$I$Ljava$util$function$BiFunction$(arg0,var1,null))) | 0;
    return var2;
  }

  static Z$equals$Ljava$lang$Object$$Ljava$lang$Object$(arg0,arg1) {
    // source file is Objects.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var phi5 = null;
    var phi6 = null;
    var phi7 = 0;
    var phi8 = null;
    var phi9 = null;
    var0 = arg1;
    // line number 64
    var1 = var0;
    If_9_0: {
     If_9_1: {
      if (arg0 == var1) {
       phi5 = arg0;
       phi6 = var0;
       break If_9_1;
      } else {
       var2 = arg0;
       If_13_0: {
        if (var2 == null) {
         phi8 = arg0;
         phi9 = var0;
         break If_13_0;
        } else {
         var3 = arg0;
         var4 = (var3.Z$equals$Ljava$lang$Object$(var0));
         if (var4 == 0) {
          phi8 = arg0;
          phi9 = var0;
          break If_13_0;
         } else {
          phi5 = arg0;
          phi6 = var0;
          break If_9_1;
         }
        }
       }
       phi5 = phi8;
       phi6 = phi9;
       phi7 = (0) | 0;
       break If_9_0;
      }
     }
     // Here was a goto statement
     phi7 = (1) | 0;
     break If_9_0;
    }
    return phi7;
  }

  static I$hashCode$Ljava$lang$Object$(arg0) {
    // source file is Objects.java
    var var0 = null;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    // line number 103
    If_4_0: {
     if (arg0 == null) {
      phi2 = arg0;
      phi3 = (0) | 0;
      break If_4_0;
     } else {
      var0 = arg0;
      var1 = ((var0.I$hashCode$$())) | 0;
      // Here was a goto statement
      phi2 = arg0;
      phi3 = (var1) | 0;
      break If_4_0;
     }
    }
    return phi3;
  }

  V$$init$$$() {
    // source file is Objects.java
    var var0 = null;
    var var1 = null;
    // line number 43
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 44
    var0 = new java$lang$AssertionError();
    var1 = bytecoder.stringconstants[148];
    java$lang$AssertionError.prototype.V$$init$$Ljava$lang$Object$.call(var0,var1);
    throw bytecoder.registerStack(var0, new Error().stack);
  }
}


class jdk$internal$util$ArraysSupport extends java$lang$Object {
  nativeObject = null;

  static U = null;
  static BIG_ENDIAN = false;
  static LOG2_ARRAY_BOOLEAN_INDEX_SCALE = 0;
  static LOG2_ARRAY_BYTE_INDEX_SCALE = 0;
  static LOG2_ARRAY_CHAR_INDEX_SCALE = 0;
  static LOG2_ARRAY_SHORT_INDEX_SCALE = 0;
  static LOG2_ARRAY_INT_INDEX_SCALE = 0;
  static LOG2_ARRAY_LONG_INDEX_SCALE = 0;
  static LOG2_ARRAY_FLOAT_INDEX_SCALE = 0;
  static LOG2_ARRAY_DOUBLE_INDEX_SCALE = 0;
  static LOG2_BYTE_BIT_SIZE = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(jdk$internal$util$ArraysSupport,[jdk$internal$util$ArraysSupport,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is ArraysSupport.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = 0;
    var var17 = 0;
    var var18 = 0;
    var var19 = 0;
    // line number 56
    jdk$internal$misc$Unsafe.$i;
    var0 = (jdk$internal$misc$Unsafe.Ljdk$internal$misc$Unsafe$$getUnsafe$$());
    jdk$internal$util$ArraysSupport.$i;
    jdk$internal$util$ArraysSupport.U = var0;
    // line number 58
    var1 = (jdk$internal$util$ArraysSupport.U);
    var2 = (jdk$internal$misc$Unsafe.prototype.Z$isBigEndian$$.call(var1));
    jdk$internal$util$ArraysSupport.BIG_ENDIAN = var2;
    // line number 60
    var3 = ((jdk$internal$misc$Unsafe.ARRAY_BOOLEAN_INDEX_SCALE)) | 0;
    var4 = ((jdk$internal$util$ArraysSupport.I$exactLog2$I(var3))) | 0;
    jdk$internal$util$ArraysSupport.LOG2_ARRAY_BOOLEAN_INDEX_SCALE = var4;
    // line number 61
    var5 = ((jdk$internal$misc$Unsafe.ARRAY_BYTE_INDEX_SCALE)) | 0;
    var6 = ((jdk$internal$util$ArraysSupport.I$exactLog2$I(var5))) | 0;
    jdk$internal$util$ArraysSupport.LOG2_ARRAY_BYTE_INDEX_SCALE = var6;
    // line number 62
    var7 = ((jdk$internal$misc$Unsafe.ARRAY_CHAR_INDEX_SCALE)) | 0;
    var8 = ((jdk$internal$util$ArraysSupport.I$exactLog2$I(var7))) | 0;
    jdk$internal$util$ArraysSupport.LOG2_ARRAY_CHAR_INDEX_SCALE = var8;
    // line number 63
    var9 = ((jdk$internal$misc$Unsafe.ARRAY_SHORT_INDEX_SCALE)) | 0;
    var10 = ((jdk$internal$util$ArraysSupport.I$exactLog2$I(var9))) | 0;
    jdk$internal$util$ArraysSupport.LOG2_ARRAY_SHORT_INDEX_SCALE = var10;
    // line number 64
    var11 = ((jdk$internal$misc$Unsafe.ARRAY_INT_INDEX_SCALE)) | 0;
    var12 = ((jdk$internal$util$ArraysSupport.I$exactLog2$I(var11))) | 0;
    jdk$internal$util$ArraysSupport.LOG2_ARRAY_INT_INDEX_SCALE = var12;
    // line number 65
    var13 = ((jdk$internal$misc$Unsafe.ARRAY_LONG_INDEX_SCALE)) | 0;
    var14 = ((jdk$internal$util$ArraysSupport.I$exactLog2$I(var13))) | 0;
    jdk$internal$util$ArraysSupport.LOG2_ARRAY_LONG_INDEX_SCALE = var14;
    // line number 66
    var15 = ((jdk$internal$misc$Unsafe.ARRAY_FLOAT_INDEX_SCALE)) | 0;
    var16 = ((jdk$internal$util$ArraysSupport.I$exactLog2$I(var15))) | 0;
    jdk$internal$util$ArraysSupport.LOG2_ARRAY_FLOAT_INDEX_SCALE = var16;
    // line number 67
    var17 = ((jdk$internal$misc$Unsafe.ARRAY_DOUBLE_INDEX_SCALE)) | 0;
    var18 = ((jdk$internal$util$ArraysSupport.I$exactLog2$I(var17))) | 0;
    jdk$internal$util$ArraysSupport.LOG2_ARRAY_DOUBLE_INDEX_SCALE = var18;
    // line number 69
    var19 = ((jdk$internal$util$ArraysSupport.I$exactLog2$I(8))) | 0;
    jdk$internal$util$ArraysSupport.LOG2_BYTE_BIT_SIZE = var19;
    return;
  }

  static I$exactLog2$I(arg0) {
    // source file is ArraysSupport.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    // line number 72
    var0 = (arg0) | 0;
    var1 = ((var0 - 1)) | 0;
    var2 = ((arg0 & var1)) | 0;
    if (var2 == 0) {
     // line number 74
     java$lang$Integer.$i;
     var5 = ((java$lang$Integer.I$numberOfTrailingZeros$I(arg0))) | 0;
     return var5;
    } else {
     // line number 73
     var3 = new java$lang$Error();
     var4 = bytecoder.stringconstants[130];
     java$lang$Error.prototype.V$$init$$Ljava$lang$String$.call(var3,var4);
     throw bytecoder.registerStack(var3, new Error().stack);
    }
  }

  static I$vectorizedMismatch$Ljava$lang$Object$$J$Ljava$lang$Object$$J$I$I(arg0,arg1,arg2,arg3,arg4,arg5) {
    // source file is ArraysSupport.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var phi5 = null;
    var phi6 = 0;
    var phi7 = null;
    var phi8 = 0;
    var phi9 = 0;
    var phi10 = 0;
    var phi11 = 0;
    var phi12 = 0;
    var var13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = 0;
    var var17 = 0;
    var var18 = 0;
    var var19 = 0;
    var var20 = 0;
    var var21 = null;
    var var22 = null;
    var var23 = 0;
    var var24 = 0;
    var var25 = 0;
    var var26 = null;
    var var27 = null;
    var var28 = 0;
    var var29 = 0;
    var var30 = 0;
    var var31 = 0;
    var var32 = 0;
    var var33 = 0;
    var var34 = 0;
    var var35 = 0;
    var var36 = 0;
    var var37 = 0;
    var var38 = 0;
    var var39 = 0;
    var var40 = 0;
    var phi41 = 0;
    var phi42 = 0;
    var phi43 = 0;
    var phi44 = 0;
    var phi45 = 0;
    var var46 = 0;
    var var47 = 0;
    var var48 = 0;
    var var49 = 0;
    var var50 = 0;
    var var51 = 0;
    var var52 = 0;
    var var53 = 0;
    var var54 = 0;
    var var55 = 0;
    var var56 = 0;
    var var57 = 0;
    var var58 = 0;
    var var59 = 0;
    var var60 = 0;
    var var61 = 0;
    var var62 = 0;
    var var63 = 0;
    var var64 = 0;
    var var65 = 0;
    var var66 = 0;
    var var67 = 0;
    var var68 = 0;
    var var69 = 0;
    var var70 = 0;
    var var71 = 0;
    var var72 = null;
    var var73 = null;
    var var74 = 0;
    var var75 = 0;
    var var76 = 0;
    var var77 = null;
    var var78 = null;
    var var79 = 0;
    var var80 = 0;
    var var81 = 0;
    var var82 = 0;
    var var83 = 0;
    var var84 = 0;
    var var85 = 0;
    var var86 = 0;
    var var87 = 0;
    var var88 = 0;
    var var89 = 0;
    var var90 = 0;
    var phi91 = 0;
    var phi92 = 0;
    var phi93 = 0;
    var phi94 = 0;
    var phi95 = 0;
    var phi96 = 0;
    var phi97 = 0;
    var var98 = 0;
    var var99 = 0;
    var var100 = 0;
    var var101 = 0;
    var var102 = 0;
    var var103 = 0;
    var var104 = 0;
    var var105 = 0;
    var var106 = 0;
    var var107 = 0;
    var var108 = 0;
    var var109 = 0;
    var phi110 = 0;
    var phi111 = 0;
    var phi112 = 0;
    var var113 = 0;
    var var114 = 0;
    var var115 = 0;
    var0 = arg1;
    var1 = arg3;
    var2 = (arg5) | 0;
    // line number 122
    jdk$internal$util$ArraysSupport.$i;
    var3 = ((jdk$internal$util$ArraysSupport.LOG2_ARRAY_LONG_INDEX_SCALE)) | 0;
    var4 = ((var3 - var2)) | 0;
    // line number 123
    phi5 = arg0;
    phi6 = var0;
    phi7 = arg2;
    phi8 = var1;
    phi9 = (arg4) | 0;
    phi10 = (var2) | 0;
    phi11 = (var4) | 0;
    phi12 = (0) | 0;
    L783521196: while(true) {
     // line number 124
     var13 = (phi12) | 0;
     var14 = (phi9) | 0;
     var15 = (phi11) | 0;
     var16 = ((var14 >> var15)) | 0;
     if (var13 >= var16) {
      // line number 138
      var56 = (phi9) | 0;
      var57 = (phi12) | 0;
      var58 = (phi11) | 0;
      var59 = ((var57 << var58)) | 0;
      var60 = ((var56 - var59)) | 0;
      // line number 140
      var61 = (phi10) | 0;
      var62 = ((jdk$internal$util$ArraysSupport.LOG2_ARRAY_INT_INDEX_SCALE)) | 0;
      if (var61 >= var62) {
       // line number 159
       var115 = ((var60 ^ -1)) | 0;
       return var115;
      } else {
       // line number 141
       var63 = ((jdk$internal$util$ArraysSupport.LOG2_ARRAY_INT_INDEX_SCALE)) | 0;
       var64 = (phi10) | 0;
       var65 = ((var63 - var64)) | 0;
       var66 = ((1 << var65)) | 0;
       // line number 143
       var67 = (var66) | 0;
       If_232_0: {
        if (var60 < var67) {
         phi110 = (var60) | 0;
         phi111 = (var66) | 0;
         break If_232_0;
        } else {
         // line number 144
         var68 = (phi12) | 0;
         var69 = (var68 | 0);
         var70 = ((jdk$internal$util$ArraysSupport.LOG2_ARRAY_LONG_INDEX_SCALE)) | 0;
         var71 = (var69 << var70);
         // line number 145
         var72 = (jdk$internal$util$ArraysSupport.U);
         var73 = phi5;
         var74 = phi6;
         var75 = (var74 + var71);
         var76 = ((jdk$internal$misc$Unsafe.prototype.I$getIntUnaligned$Ljava$lang$Object$$J.call(var72,var73,var75))) | 0;
         // line number 146
         var77 = (jdk$internal$util$ArraysSupport.U);
         var78 = phi7;
         var79 = phi8;
         var80 = (var79 + var71);
         var81 = ((jdk$internal$misc$Unsafe.prototype.I$getIntUnaligned$Ljava$lang$Object$$J.call(var77,var78,var80))) | 0;
         // line number 147
         var82 = (var81) | 0;
         if (var76 == var82) {
          // line number 154
          var108 = (var66) | 0;
          var109 = ((var60 - var108)) | 0;
          phi110 = (var109) | 0;
          phi111 = (var66) | 0;
          phi112 = (var76) | 0;
          break If_232_0;
         } else {
          // line number 148
          var83 = (var81) | 0;
          var84 = ((var76 ^ var83)) | 0;
          // line number 149
          var85 = (jdk$internal$util$ArraysSupport.BIG_ENDIAN);
          If_299_0: {
           if (var85 == 0) {
            // line number 151
            java$lang$Integer.$i;
            var103 = ((java$lang$Integer.I$numberOfTrailingZeros$I(var84))) | 0;
            var104 = ((jdk$internal$util$ArraysSupport.LOG2_BYTE_BIT_SIZE)) | 0;
            var105 = (phi10) | 0;
            var106 = ((var104 + var105)) | 0;
            var107 = ((var103 >> var106)) | 0;
            phi91 = (var60) | 0;
            phi92 = (var66) | 0;
            phi93 = var71;
            phi94 = (var76) | 0;
            phi95 = (var81) | 0;
            phi96 = (var84) | 0;
            phi97 = (var107) | 0;
            break If_299_0;
           } else {
            // line number 150
            java$lang$Integer.$i;
            var86 = ((java$lang$Integer.I$numberOfLeadingZeros$I(var84))) | 0;
            var87 = ((jdk$internal$util$ArraysSupport.LOG2_BYTE_BIT_SIZE)) | 0;
            var88 = (phi10) | 0;
            var89 = ((var87 + var88)) | 0;
            var90 = ((var86 >> var89)) | 0;
            // Here was a goto statement
            phi91 = (var60) | 0;
            phi92 = (var66) | 0;
            phi93 = var71;
            phi94 = (var76) | 0;
            phi95 = (var81) | 0;
            phi96 = (var84) | 0;
            phi97 = (var90) | 0;
            break If_299_0;
           }
          }
          var98 = (phi97) | 0;
          // line number 152
          var99 = (phi12) | 0;
          var100 = (phi11) | 0;
          var101 = ((var99 << var100)) | 0;
          var102 = ((var101 + var98)) | 0;
          return var102;
         }
        }
       }
       // line number 156
       var113 = (phi110) | 0;
       var114 = ((var113 ^ -1)) | 0;
       return var114;
      }
     } else {
      // line number 125
      var17 = (phi12) | 0;
      var18 = (var17 | 0);
      var19 = ((jdk$internal$util$ArraysSupport.LOG2_ARRAY_LONG_INDEX_SCALE)) | 0;
      var20 = (var18 << var19);
      // line number 126
      var21 = (jdk$internal$util$ArraysSupport.U);
      var22 = phi5;
      var23 = phi6;
      var24 = (var23 + var20);
      var25 = (jdk$internal$misc$Unsafe.prototype.J$getLongUnaligned$Ljava$lang$Object$$J.call(var21,var22,var24));
      // line number 127
      var26 = (jdk$internal$util$ArraysSupport.U);
      var27 = phi7;
      var28 = phi8;
      var29 = (var28 + var20);
      var30 = (jdk$internal$misc$Unsafe.prototype.J$getLongUnaligned$Ljava$lang$Object$$J.call(var26,var27,var29));
      // line number 128
      var31 = var30;
      var32 = (bytecoder.cmp(var25,var31)) | 0;
      if (var32 == 0) {
       // line number 124
       phi12 = ((phi12 + 1)) | 0;
       // Here was a goto statement
       continue L783521196;
      } else {
       // line number 129
       var33 = var30;
       var34 = (var25 ^ var33);
       // line number 130
       var35 = (jdk$internal$util$ArraysSupport.BIG_ENDIAN);
       If_117_0: {
        if (var35 == 0) {
         // line number 132
         java$lang$Long.$i;
         var51 = ((java$lang$Long.I$numberOfTrailingZeros$J(var34))) | 0;
         var52 = ((jdk$internal$util$ArraysSupport.LOG2_BYTE_BIT_SIZE)) | 0;
         var53 = (phi10) | 0;
         var54 = ((var52 + var53)) | 0;
         var55 = ((var51 >> var54)) | 0;
         phi41 = var20;
         phi42 = var25;
         phi43 = var30;
         phi44 = var34;
         phi45 = (var55) | 0;
         break If_117_0;
        } else {
         // line number 131
         java$lang$Long.$i;
         var36 = ((java$lang$Long.I$numberOfLeadingZeros$J(var34))) | 0;
         var37 = ((jdk$internal$util$ArraysSupport.LOG2_BYTE_BIT_SIZE)) | 0;
         var38 = (phi10) | 0;
         var39 = ((var37 + var38)) | 0;
         var40 = ((var36 >> var39)) | 0;
         // Here was a goto statement
         phi41 = var20;
         phi42 = var25;
         phi43 = var30;
         phi44 = var34;
         phi45 = (var40) | 0;
         break If_117_0;
        }
       }
       var46 = (phi45) | 0;
       // line number 133
       var47 = (phi12) | 0;
       var48 = (phi11) | 0;
       var49 = ((var47 << var48)) | 0;
       var50 = ((var49 + var46)) | 0;
       return var50;
      }
     }
    }
  }

  V$$init$$$() {
    // source file is ArraysSupport.java
    // line number 77
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class org$jbox2d$pooling$arrays$IntArray extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;
  map = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$pooling$arrays$IntArray,[org$jbox2d$pooling$arrays$IntArray,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is IntArray.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    // line number 35
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(org$jbox2d$pooling$arrays$IntArray.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    org$jbox2d$pooling$arrays$IntArray.$i;
    org$jbox2d$pooling$arrays$IntArray.$assertionsDisabled = phi2;
    return;
  }

  $I$get$I(arg0) {
    // source file is IntArray.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = null;
    var phi4 = null;
    var phi5 = 0;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = null;
    var var13 = 0;
    var var14 = null;
    var var15 = null;
    var var16 = 0;
    var var17 = null;
    var var18 = null;
    var var19 = 0;
    var var20 = null;
    var var21 = null;
    var var22 = 0;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = 0;
    var var27 = 0;
    var var28 = null;
    var var29 = null;
    var var30 = null;
    var var31 = 0;
    var var32 = null;
    var var33 = null;
    var var34 = null;
    var0 = (arg0) | 0;
    // line number 40
    org$jbox2d$pooling$arrays$IntArray.$i;
    var1 = (org$jbox2d$pooling$arrays$IntArray.$assertionsDisabled);
    If_12_0: {
     if (var1 != 0) {
      phi4 = this;
      phi5 = (var0) | 0;
      break If_12_0;
     } else {
      var2 = (var0) | 0;
      if (var2 > 0) {
       phi4 = this;
       phi5 = (var0) | 0;
       break If_12_0;
      } else {
       var3 = new java$lang$AssertionError();
       java$lang$AssertionError.prototype.V$$init$$$.call(var3);
       throw bytecoder.registerStack(var3, new Error().stack);
      }
     }
    }
    // line number 42
    var6 = phi4;
    var7 = (var6.map);
    var8 = (phi5) | 0;
    java$lang$Integer.$i;
    var9 = (java$lang$Integer.Ljava$lang$Integer$$valueOf$I(var8));
    var10 = (java$util$HashMap.prototype.Z$containsKey$Ljava$lang$Object$.call(var7,var9));
    If_47_0: {
     if (var10 != 0) {
      break If_47_0;
     } else {
      // line number 43
      var11 = phi4;
      var12 = (var11.map);
      var13 = (phi5) | 0;
      var14 = (java$lang$Integer.Ljava$lang$Integer$$valueOf$I(var13));
      var15 = phi4;
      var16 = (phi5) | 0;
      var17 = (org$jbox2d$pooling$arrays$IntArray.prototype.$I$getInitializedArray$I.call(var15,var16));
      var18 = (java$util$HashMap.prototype.Ljava$lang$Object$$put$Ljava$lang$Object$$Ljava$lang$Object$.call(var12,var14,var17));
      break If_47_0;
     }
    }
    // line number 46
    var19 = (org$jbox2d$pooling$arrays$IntArray.$assertionsDisabled);
    If_80_0: {
     if (var19 != 0) {
      break If_80_0;
     } else {
      var20 = phi4;
      var21 = (var20.map);
      var22 = (phi5) | 0;
      var23 = (java$lang$Integer.Ljava$lang$Integer$$valueOf$I(var22));
      var24 = (java$util$HashMap.prototype.Ljava$lang$Object$$get$Ljava$lang$Object$.call(var21,var23));
      var25 = var24;
      var26 = (var25.data.length) | 0;
      var27 = (phi5) | 0;
      if (var26 == var27) {
       break If_80_0;
      } else {
       var28 = new java$lang$AssertionError();
       java$lang$AssertionError.prototype.V$$init$$Ljava$lang$Object$.call(var28,bytecoder.stringconstants[53]);
       throw bytecoder.registerStack(var28, new Error().stack);
      }
     }
    }
    // line number 47
    var29 = phi4;
    var30 = (var29.map);
    var31 = (phi5) | 0;
    var32 = (java$lang$Integer.Ljava$lang$Integer$$valueOf$I(var31));
    var33 = (java$util$HashMap.prototype.Ljava$lang$Object$$get$Ljava$lang$Object$.call(var30,var32));
    var34 = var33;
    return var34;
  }

  $I$getInitializedArray$I(arg0) {
    // source file is IntArray.java
    var var0 = 0;
    var var1 = null;
    var0 = (arg0) | 0;
    // line number 51
    var1 = bytecoder.newarray((var0),0);
    return var1;
  }

  V$$init$$$() {
    // source file is IntArray.java
    var var0 = null;
    var var1 = null;
    // line number 35
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 37
    var0 = this;
    var1 = new java$util$HashMap();
    java$util$HashMap.prototype.V$$init$$$.call(var1);
    var0.map = var1;
    return;
  }
}


class de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation extends java$lang$Object {
  nativeObject = null;

  static scene = null;
  static window = null;
  static renderingContext2D = null;
  static animationCallback = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation,[de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  static V$main$$Ljava$lang$String$(arg0) {
    // source file is JBox2DSimulation.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    // line number 177
    var0 = new de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation$Scene();
    de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation$Scene.prototype.V$$init$$$.call(var0);
    de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.scene = var0;
    // line number 178
    var1 = (de$mirkosertic$bytecoder$api$web$Window.Lde$mirkosertic$bytecoder$api$web$Window$$window$$());
    de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.window = var1;
    // line number 179
    var2 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.window);
    var3 = (var2.Lde$mirkosertic$bytecoder$api$web$HTMLDocument$$document$$());
    // line number 180
    var4 = bytecoder.wrapNativeIntoTypeInstance(de$mirkosertic$bytecoder$api$web$Element,var3.nativeObject.getElementById(bytecoder.stringconstants[72].nativeObject));
    var5 = var4;
    // line number 181
    var6 = bytecoder.wrapNativeIntoTypeInstance(de$mirkosertic$bytecoder$api$web$CanvasRenderingContext2D,var5.nativeObject.getContext(bytecoder.stringconstants[73].nativeObject));
    de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.renderingContext2D = var6;
    // line number 183
    var7 = new de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation$1();
    de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation$1.prototype.V$$init$$$.call(var7);
    de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.animationCallback = var7;
    // line number 203
    var8 = bytecoder.wrapNativeIntoTypeInstance(de$mirkosertic$bytecoder$api$web$Element,var3.nativeObject.getElementById(bytecoder.stringconstants[74].nativeObject));
    var9 = var8;
    // line number 204
    var10 = new de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation$2();
    var11 = var9;
    de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation$2.prototype.V$$init$$Lde$mirkosertic$bytecoder$api$web$HTMLButton$.call(var10,var11);
    var9.nativeObject.addEventListener(bytecoder.stringconstants[75].nativeObject, function(arg0) {this.V$run$Lde$mirkosertic$bytecoder$api$web$Event$(bytecoder.wrapNativeIntoTypeInstance(de$mirkosertic$bytecoder$api$web$Event, arg0))}.bind(var10));
    // line number 217
    return;
  }

  static V$statsBegin$$() {
    bytecoder.imports['stats'].begin();
  }

  static Lde$mirkosertic$bytecoder$integrationtest$JBox2DSimulation$Scene$$access$000$$() {
    // source file is JBox2DSimulation.java
    var var0 = null;
    // line number 40
    var0 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.scene);
    return var0;
  }

  static V$access$100$$() {
    // source file is JBox2DSimulation.java
    // line number 40
    de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.V$render$$();
    return;
  }

  static V$render$$() {
    // source file is JBox2DSimulation.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = .0;
    var var4 = .0;
    var var5 = null;
    var var6 = null;
    var var7 = .0;
    var var8 = null;
    var var9 = .0;
    var var10 = null;
    var var11 = .0;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var phi16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = .0;
    var var23 = .0;
    var var24 = null;
    var var25 = null;
    var var26 = .0;
    var var27 = null;
    var var28 = null;
    var phi29 = null;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = null;
    var var37 = null;
    var var38 = null;
    var var39 = .0;
    var var40 = .0;
    var var41 = null;
    var var42 = .0;
    var var43 = .0;
    var var44 = .0;
    var var45 = .0;
    var var46 = .0;
    var var47 = null;
    var var48 = null;
    var phi49 = null;
    var phi50 = null;
    var var51 = null;
    var var52 = null;
    var var53 = null;
    var var54 = null;
    var var55 = null;
    var var56 = null;
    var var57 = null;
    var var58 = null;
    var var59 = null;
    var var60 = .0;
    var var61 = null;
    var var62 = .0;
    var var63 = 0;
    var phi64 = null;
    var phi65 = null;
    var phi66 = null;
    var phi67 = 0;
    var var68 = 0;
    var var69 = null;
    var var70 = 0;
    var var71 = null;
    var var72 = null;
    var var73 = 0;
    var var74 = null;
    var var75 = .0;
    var var76 = null;
    var var77 = 0;
    var var78 = null;
    var var79 = .0;
    var var80 = null;
    var var81 = null;
    var var82 = null;
    var var83 = null;
    var var84 = null;
    var var85 = null;
    // line number 229
    var0 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.renderingContext2D);
    var0.nativeObject.fillStyle = bytecoder.stringconstants[123].nativeObject;
    // line number 230
    var1 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.renderingContext2D);
    var1.nativeObject.strokeStyle = bytecoder.stringconstants[124].nativeObject;
    // line number 231
    var2 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.renderingContext2D);
    var3 = 0.0;
    var4 = 600.0;
    var2.nativeObject.fillRect(0.0, var3, 600.0, var4);
    // line number 232
    var5 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.renderingContext2D);
    var5.nativeObject.save();
    // line number 233
    var6 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.renderingContext2D);
    var7 = 600.0;
    var6.nativeObject.translate(0.0, var7);
    // line number 234
    var8 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.renderingContext2D);
    var9 = -1.0;
    var8.nativeObject.scale(1.0, var9);
    // line number 235
    var10 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.renderingContext2D);
    var11 = 100.0;
    var10.nativeObject.scale(100.0, var11);
    // line number 236
    var12 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.renderingContext2D);
    var12.nativeObject.lineWidth = 0.01;
    // line number 237
    var13 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.scene);
    var14 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation$Scene.prototype.Lorg$jbox2d$dynamics$World$$getWorld$$.call(var13));
    var15 = (org$jbox2d$dynamics$World.prototype.Lorg$jbox2d$dynamics$Body$$getBodyList$$.call(var14));
    phi16 = var15;
    L1443947032: while(true) {
     var17 = phi16;
     if (var17 == null) {
      // line number 264
      var85 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.renderingContext2D);
      var85.nativeObject.restore();
      // line number 265
      return;
     } else {
      // line number 238
      var18 = phi16;
      var19 = (org$jbox2d$dynamics$Body.prototype.Lorg$jbox2d$common$Vec2$$getPosition$$.call(var18));
      // line number 239
      var20 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.renderingContext2D);
      var20.nativeObject.save();
      // line number 240
      var21 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.renderingContext2D);
      var22 = (var19.x);
      var23 = (var19.y);
      var21.nativeObject.translate(var22, var23);
      // line number 241
      var24 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.renderingContext2D);
      var25 = phi16;
      var26 = (org$jbox2d$dynamics$Body.prototype.F$getAngle$$.call(var25));
      var24.nativeObject.rotate(var26);
      // line number 242
      var27 = phi16;
      var28 = (org$jbox2d$dynamics$Body.prototype.Lorg$jbox2d$dynamics$Fixture$$getFixtureList$$.call(var27));
      phi29 = var28;
      L1390815071: while(true) {
       var30 = phi29;
       if (var30 == null) {
        // line number 262
        var82 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.renderingContext2D);
        var82.nativeObject.restore();
        // line number 237
        var83 = phi16;
        var84 = (org$jbox2d$dynamics$Body.prototype.Lorg$jbox2d$dynamics$Body$$getNext$$.call(var83));
        // Here was a goto statement
        phi16 = var84;
        continue L1443947032;
       } else {
        // line number 243
        var31 = phi29;
        var32 = (org$jbox2d$dynamics$Fixture.prototype.Lorg$jbox2d$collision$shapes$Shape$$getShape$$.call(var31));
        // line number 244
        var33 = (org$jbox2d$collision$shapes$Shape.prototype.Lorg$jbox2d$collision$shapes$ShapeType$$getType$$.call(var32));
        org$jbox2d$collision$shapes$ShapeType.$i;
        var34 = (org$jbox2d$collision$shapes$ShapeType.CIRCLE);
        If_170_0: {
         if (var33 != var34) {
          var53 = (org$jbox2d$collision$shapes$Shape.prototype.Lorg$jbox2d$collision$shapes$ShapeType$$getType$$.call(var32));
          var54 = (org$jbox2d$collision$shapes$ShapeType.POLYGON);
          if (var53 != var54) {
           phi49 = var32;
           break If_170_0;
          } else {
           // line number 251
           var55 = var32;
           // line number 252
           var56 = (org$jbox2d$collision$shapes$PolygonShape.prototype.$Lorg$jbox2d$common$Vec2$$getVertices$$.call(var55));
           // line number 253
           var57 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.renderingContext2D);
           var57.nativeObject.beginPath();
           // line number 254
           var58 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.renderingContext2D);
           var59 = (var56.data[0]);
           var60 = (var59.x);
           var61 = (var56.data[0]);
           var62 = (var61.y);
           var58.nativeObject.moveTo(var60, var62);
           // line number 255
           var63 = (1) | 0;
           phi64 = var32;
           phi65 = var55;
           phi66 = var56;
           phi67 = (var63) | 0;
           L613213425: while(true) {
            var68 = (phi67) | 0;
            var69 = phi65;
            var70 = ((org$jbox2d$collision$shapes$PolygonShape.prototype.I$getVertexCount$$.call(var69))) | 0;
            if (var68 >= var70) {
             // line number 258
             var80 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.renderingContext2D);
             var80.nativeObject.closePath();
             // line number 259
             var81 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.renderingContext2D);
             var81.nativeObject.stroke();
             phi49 = phi64;
             phi50 = phi65;
             break If_170_0;
            } else {
             // line number 256
             var71 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.renderingContext2D);
             var72 = phi66;
             var73 = (phi67) | 0;
             var74 = (var72.data[var73]);
             var75 = (var74.x);
             var76 = phi66;
             var77 = (phi67) | 0;
             var78 = (var76.data[var77]);
             var79 = (var78.y);
             var71.nativeObject.lineTo(var75, var79);
             // line number 255
             phi67 = ((phi67 + 1)) | 0;
             // Here was a goto statement
             continue L613213425;
            }
           }
          }
         } else {
          // line number 245
          var35 = var32;
          // line number 246
          var36 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.renderingContext2D);
          var36.nativeObject.beginPath();
          // line number 247
          var37 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.renderingContext2D);
          var38 = (var35.m_p);
          var39 = (var38.x);
          var40 = var39;
          var41 = (var35.m_p);
          var42 = (var41.y);
          var43 = var42;
          var44 = (var35.F$getRadius$$());
          var45 = var44;
          var46 = 6.283185307179586;
          var37.nativeObject.arc(var40, var43, var45, 0.0, var46, (1 === 1 ? true : false));
          // line number 248
          var47 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.renderingContext2D);
          var47.nativeObject.closePath();
          // line number 249
          var48 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.renderingContext2D);
          var48.nativeObject.stroke();
          // line number 250
          // Here was a goto statement
          phi49 = var32;
          phi50 = var35;
          break If_170_0;
         }
        }
        // line number 242
        var51 = phi29;
        var52 = (org$jbox2d$dynamics$Fixture.prototype.Lorg$jbox2d$dynamics$Fixture$$getNext$$.call(var51));
        // Here was a goto statement
        phi29 = var52;
        continue L1390815071;
       }
      }
     }
    }
  }

  static V$statsEnd$$() {
    bytecoder.imports['stats'].end();
  }

  static V$logRuntime$I(arg0) {
    bytecoder.imports['debug'].logRuntime(arg0);
  }

  static Lde$mirkosertic$bytecoder$api$web$Window$$access$300$$() {
    // source file is JBox2DSimulation.java
    var var0 = null;
    // line number 40
    var0 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.window);
    return var0;
  }

  static Lde$mirkosertic$bytecoder$api$web$AnimationFrameCallback$$access$200$$() {
    // source file is JBox2DSimulation.java
    var var0 = null;
    // line number 40
    var0 = (de$mirkosertic$bytecoder$integrationtest$JBox2DSimulation.animationCallback);
    return var0;
  }

  V$$init$$$() {
    // source file is JBox2DSimulation.java
    // line number 40
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class org$jbox2d$dynamics$contacts$ContactRegister extends java$lang$Object {
  nativeObject = null;

  creator = null;
  primary = false;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$dynamics$contacts$ContactRegister,[org$jbox2d$dynamics$contacts$ContactRegister,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is ContactRegister.java
    // line number 28
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class org$jbox2d$pooling$IWorldPool extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$pooling$IWorldPool,[org$jbox2d$pooling$IWorldPool,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class de$mirkosertic$bytecoder$classlib$Array extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(de$mirkosertic$bytecoder$classlib$Array,[de$mirkosertic$bytecoder$classlib$Array,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  static $Ljava$lang$Object$$newObjectArray$I(arg0) {
    // source file is Array.java
    var var0 = null;
    // line number 101
    var0 = bytecoder.newarray((arg0),null);
    return var0;
  }

  static $C$newCharArray$I(arg0) {
    // source file is Array.java
    var var0 = null;
    // line number 106
    var0 = bytecoder.newarray((arg0),0);
    return var0;
  }

  static I$charArrayLength$$C(arg0) {
    // source file is Array.java
    var var0 = 0;
    // line number 111
    var0 = (arg0.data.length) | 0;
    return var0;
  }

  static C$getCharArrayEntry$$C$I(arg0,arg1) {
    // source file is Array.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var0 = (arg1) | 0;
    // line number 116
    var1 = (var0) | 0;
    var2 = (arg0.data[var1]);
    return var2;
  }

  static V$setCharArrayEntry$$C$I$C(arg0,arg1,arg2) {
    // source file is Array.java
    var var0 = 0;
    var var1 = 0;
    var0 = (arg1) | 0;
    // line number 121
    var1 = (var0) | 0;
    arg0.data[var1] = arg2;
    // line number 122
    return;
  }

  static $B$newByteArray$I(arg0) {
    // source file is Array.java
    var var0 = null;
    // line number 126
    var0 = bytecoder.newarray((arg0),0);
    return var0;
  }

  static I$byteArrayLength$$B(arg0) {
    // source file is Array.java
    var var0 = 0;
    // line number 131
    var0 = (arg0.data.length) | 0;
    return var0;
  }

  static B$getByteArrayEntry$$B$I(arg0,arg1) {
    // source file is Array.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var0 = (arg1) | 0;
    // line number 136
    var1 = (var0) | 0;
    var2 = (arg0.data[var1]);
    return var2;
  }

  static V$setByteArrayEntry$$B$I$B(arg0,arg1,arg2) {
    // source file is Array.java
    var var0 = 0;
    var var1 = 0;
    var0 = (arg1) | 0;
    // line number 141
    var1 = (var0) | 0;
    arg0.data[var1] = arg2;
    // line number 142
    return;
  }

  static I$getIntArrayEntry$$I$I(arg0,arg1) {
    // source file is Array.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var0 = (arg1) | 0;
    // line number 146
    var1 = (var0) | 0;
    var2 = ((arg0.data[var1])) | 0;
    return var2;
  }

  static Ljava$lang$Object$$newObjectArray2Dim$I$I(arg0,arg1) {
    // source file is Array.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var phi3 = 0;
    var phi4 = 0;
    var phi5 = null;
    var phi6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = 0;
    var var12 = null;
    var var13 = null;
    var0 = (arg1) | 0;
    // line number 28
    var1 = bytecoder.newarray((arg0),null);
    // line number 29
    var2 = (0) | 0;
    phi3 = (arg0) | 0;
    phi4 = (var0) | 0;
    phi5 = var1;
    phi6 = (var2) | 0;
    L1919379480: while(true) {
     var7 = (phi6) | 0;
     var8 = (phi3) | 0;
     if (var7 >= var8) {
      // line number 32
      var13 = phi5;
      return var13;
     } else {
      // line number 30
      var9 = phi5;
      var10 = (phi6) | 0;
      var11 = (phi4) | 0;
      var12 = bytecoder.newarray((var11),null);
      var9.data[var10] = var12;
      // line number 29
      phi6 = ((phi6 + 1)) | 0;
      // Here was a goto statement
      continue L1919379480;
     }
    }
  }

  V$$init$$$() {
    // source file is Array.java
    // line number 20
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }

  Ljava$lang$Object$$clone$$() {
    // source file is Array.java
    // line number 24
    return this;
  }
}


class de$mirkosertic$bytecoder$classlib$java$util$Quicksort extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(de$mirkosertic$bytecoder$classlib$java$util$Quicksort,[de$mirkosertic$bytecoder$classlib$java$util$Quicksort,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  static V$quickSortComparable$$Ljava$lang$Object$$I$I(arg0,arg1,arg2) {
    // source file is Quicksort.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var0 = (arg1) | 0;
    // line number 69
    var1 = (var0) | 0;
    if (arg2 > var1) {
     // line number 70
     var2 = (arg2) | 0;
     var3 = ((de$mirkosertic$bytecoder$classlib$java$util$Quicksort.I$partitionComparable$$Ljava$lang$Object$$I$I(arg0,var0,var2))) | 0;
     // line number 71
     var4 = (var3) | 0;
     var5 = ((var4 - 1)) | 0;
     de$mirkosertic$bytecoder$classlib$java$util$Quicksort.V$quickSortComparable$$Ljava$lang$Object$$I$I(arg0,var0,var5);
     // line number 72
     var6 = (1) | 0;
     var7 = ((var3 + var6)) | 0;
     de$mirkosertic$bytecoder$classlib$java$util$Quicksort.V$quickSortComparable$$Ljava$lang$Object$$I$I(arg0,var7,arg2);
     // line number 73
     return;
    } else {
     return;
    }
  }

  static I$partitionComparable$$Ljava$lang$Object$$I$I(arg0,arg1,arg2) {
    // source file is Quicksort.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var phi4 = null;
    var phi5 = 0;
    var phi6 = 0;
    var phi7 = 0;
    var phi8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = null;
    var var12 = 0;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = 0;
    var var17 = null;
    var var18 = 0;
    var var19 = null;
    var var20 = 0;
    var var21 = null;
    var var22 = null;
    var var23 = 0;
    var var24 = null;
    var var25 = 0;
    var var26 = null;
    var var27 = null;
    var var28 = 0;
    var var29 = null;
    var var30 = 0;
    var var31 = null;
    var var32 = null;
    var var33 = 0;
    var var34 = null;
    var var35 = 0;
    var var36 = null;
    var var37 = null;
    var var38 = 0;
    var var39 = 0;
    var0 = (arg1) | 0;
    // line number 43
    var1 = (arg2) | 0;
    // line number 45
    var2 = (var0) | 0;
    // line number 46
    var3 = (var0) | 0;
    phi4 = arg0;
    phi5 = (arg2) | 0;
    phi6 = (var1) | 0;
    phi7 = (var2) | 0;
    phi8 = (var3) | 0;
    L1492284113: while(true) {
     var9 = (phi8) | 0;
     var10 = (phi5) | 0;
     if (var9 >= var10) {
      // line number 54
      var29 = phi4;
      var30 = (phi6) | 0;
      var31 = (var29.data[var30]);
      // line number 55
      var32 = phi4;
      var33 = (phi6) | 0;
      var34 = phi4;
      var35 = (phi7) | 0;
      var36 = (var34.data[var35]);
      var32.data[var33] = var36;
      // line number 56
      var37 = phi4;
      var38 = (phi7) | 0;
      var37.data[var38] = var31;
      // line number 58
      var39 = (phi7) | 0;
      return var39;
     } else {
      // line number 47
      var11 = phi4;
      var12 = (phi8) | 0;
      var13 = (var11.data[var12]);
      var14 = var13;
      var15 = phi4;
      var16 = (phi6) | 0;
      var17 = (var15.data[var16]);
      var18 = ((var14.I$compareTo$Ljava$lang$Object$(var17))) | 0;
      If_53_0: {
       if (var18 >= 0) {
        break If_53_0;
       } else {
        // line number 48
        var19 = phi4;
        var20 = (phi7) | 0;
        var21 = (var19.data[var20]);
        // line number 49
        var22 = phi4;
        var23 = (phi7) | 0;
        var24 = phi4;
        var25 = (phi8) | 0;
        var26 = (var24.data[var25]);
        var22.data[var23] = var26;
        // line number 50
        var27 = phi4;
        var28 = (phi8) | 0;
        var27.data[var28] = var21;
        // line number 51
        phi7 = ((phi7 + 1)) | 0;
        break If_53_0;
       }
      }
      // line number 46
      phi8 = ((phi8 + 1)) | 0;
      // Here was a goto statement
      continue L1492284113;
     }
    }
  }

  V$$init$$$() {
    // source file is Quicksort.java
    // line number 21
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class org$jbox2d$dynamics$World extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;
  static LIQUID_INT = null;
  activeContacts = 0;
  contactPoolCount = 0;
  m_gravity = null;
  contactStacks = null;
  step = null;
  stepTimer = null;
  tempTimer = null;
  color = null;
  xf = null;
  cA = null;
  cB = null;
  avs = null;
  wqwrapper = null;
  wrcwrapper = null;
  input = null;
  island = null;
  stack = null;
  islandProfile = null;
  broadphaseTimer = null;
  toiIsland = null;
  toiInput = null;
  toiOutput = null;
  subStep = null;
  tempBodies = null;
  backup1 = null;
  backup2 = null;
  liquidLength = 0.0;
  averageLinearVel = 0.0;
  liquidOffset = null;
  circCenterMoved = null;
  liquidColor = null;
  center = null;
  axis = null;
  v1 = null;
  v2 = null;
  tlvertices = null;
  pool = null;
  m_destructionListener = null;
  m_debugDraw = null;
  m_bodyList = null;
  m_jointList = null;
  m_bodyCount = 0;
  m_jointCount = 0;
  m_warmStarting = false;
  m_continuousPhysics = false;
  m_subStepping = false;
  m_stepComplete = false;
  m_allowSleep = false;
  m_flags = 0;
  m_inv_dt0 = 0.0;
  m_contactManager = null;
  m_profile = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$dynamics$World,[org$jbox2d$dynamics$World,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is World.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    var var3 = null;
    var var4 = 0;
    // line number 73
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(org$jbox2d$dynamics$World.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    org$jbox2d$dynamics$World.$i;
    org$jbox2d$dynamics$World.$assertionsDisabled = phi2;
    // line number 1453
    java$lang$Integer.$i;
    var3 = new java$lang$Integer();
    var4 = (1234598372) | 0;
    java$lang$Integer.prototype.V$$init$$I.call(var3,var4);
    org$jbox2d$dynamics$World.LIQUID_INT = var3;
    return;
  }

  V$$init$$Lorg$jbox2d$common$Vec2$(arg0) {
    // source file is World.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var0 = arg0;
    // line number 130
    var1 = var0;
    org$jbox2d$pooling$normal$DefaultWorldPool.$i;
    var2 = new org$jbox2d$pooling$normal$DefaultWorldPool();
    var3 = (100) | 0;
    org$jbox2d$pooling$normal$DefaultWorldPool.prototype.V$$init$$I$I.call(var2,var3,10);
    org$jbox2d$dynamics$World.prototype.V$$init$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$pooling$IWorldPool$.call(this,var1,var2);
    // line number 131
    return;
  }

  V$$init$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$pooling$IWorldPool$(arg0,arg1) {
    // source file is World.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    // line number 139
    var1 = var0;
    org$jbox2d$collision$broadphase$DynamicTree.$i;
    var2 = new org$jbox2d$collision$broadphase$DynamicTree();
    org$jbox2d$collision$broadphase$DynamicTree.prototype.V$$init$$$.call(var2);
    org$jbox2d$dynamics$World.prototype.V$$init$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$pooling$IWorldPool$$Lorg$jbox2d$collision$broadphase$BroadPhaseStrategy$.call(this,var1,arg1,var2);
    // line number 140
    return;
  }

  V$$init$$Lorg$jbox2d$common$Vec2$$Lorg$jbox2d$pooling$IWorldPool$$Lorg$jbox2d$collision$broadphase$BroadPhaseStrategy$(arg0,arg1,arg2) {
    // source file is World.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = null;
    var var37 = null;
    var var38 = null;
    var var39 = null;
    var var40 = null;
    var var41 = null;
    var var42 = null;
    var var43 = null;
    var var44 = null;
    var var45 = null;
    var var46 = null;
    var var47 = null;
    var var48 = null;
    var var49 = null;
    var var50 = null;
    var var51 = null;
    var var52 = null;
    var var53 = null;
    var var54 = null;
    var var55 = null;
    var var56 = null;
    var var57 = null;
    var var58 = null;
    var var59 = null;
    var var60 = null;
    var var61 = null;
    var var62 = null;
    var var63 = null;
    var var64 = .0;
    var var65 = null;
    var var66 = null;
    var var67 = null;
    var var68 = null;
    var var69 = null;
    var var70 = null;
    var var71 = null;
    var var72 = null;
    var var73 = null;
    var var74 = null;
    var var75 = null;
    var var76 = null;
    var var77 = null;
    var var78 = null;
    var var79 = null;
    var var80 = null;
    var var81 = null;
    var var82 = null;
    var var83 = null;
    var var84 = null;
    var var85 = null;
    var var86 = null;
    var var87 = null;
    var var88 = null;
    var var89 = null;
    var var90 = null;
    var var91 = null;
    var var92 = null;
    var var93 = null;
    var var94 = null;
    var var95 = null;
    var0 = arg0;
    var1 = arg2;
    // line number 142
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 83
    var2 = this;
    var2.activeContacts = 0;
    // line number 84
    var3 = this;
    var3.contactPoolCount = 0;
    // line number 96
    var4 = this;
    org$jbox2d$common$Vec2.$i;
    var5 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var5);
    var4.m_gravity = var5;
    // line number 121
    var6 = this;
    org$jbox2d$collision$shapes$ShapeType.$i;
    var7 = (org$jbox2d$collision$shapes$ShapeType.$Lorg$jbox2d$collision$shapes$ShapeType$$values$$());
    var8 = (var7.data.length) | 0;
    var9 = (org$jbox2d$collision$shapes$ShapeType.$Lorg$jbox2d$collision$shapes$ShapeType$$values$$());
    var10 = (var9.data.length) | 0;
    var11 = (de$mirkosertic$bytecoder$classlib$Array.Ljava$lang$Object$$newObjectArray2Dim$I$I(var8,var10));
    var6.contactStacks = var11;
    // line number 554
    var12 = this;
    var13 = new org$jbox2d$dynamics$TimeStep();
    org$jbox2d$dynamics$TimeStep.prototype.V$$init$$$.call(var13);
    var12.step = var13;
    // line number 555
    var14 = this;
    var15 = new org$jbox2d$common$Timer();
    org$jbox2d$common$Timer.prototype.V$$init$$$.call(var15);
    var14.stepTimer = var15;
    // line number 556
    var16 = this;
    var17 = new org$jbox2d$common$Timer();
    org$jbox2d$common$Timer.prototype.V$$init$$$.call(var17);
    var16.tempTimer = var17;
    // line number 637
    var18 = this;
    org$jbox2d$common$Color3f.$i;
    var19 = new org$jbox2d$common$Color3f();
    org$jbox2d$common$Color3f.prototype.V$$init$$$.call(var19);
    var18.color = var19;
    // line number 638
    var20 = this;
    org$jbox2d$common$Transform.$i;
    var21 = new org$jbox2d$common$Transform();
    org$jbox2d$common$Transform.prototype.V$$init$$$.call(var21);
    var20.xf = var21;
    // line number 639
    var22 = this;
    var23 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var23);
    var22.cA = var23;
    // line number 640
    var24 = this;
    var25 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var25);
    var24.cB = var25;
    // line number 641
    var26 = this;
    org$jbox2d$pooling$arrays$Vec2Array.$i;
    var27 = new org$jbox2d$pooling$arrays$Vec2Array();
    org$jbox2d$pooling$arrays$Vec2Array.prototype.V$$init$$$.call(var27);
    var26.avs = var27;
    // line number 730
    var28 = this;
    var29 = new org$jbox2d$dynamics$WorldQueryWrapper();
    org$jbox2d$dynamics$WorldQueryWrapper.prototype.V$$init$$$.call(var29);
    var28.wqwrapper = var29;
    // line number 744
    var30 = this;
    var31 = new org$jbox2d$dynamics$WorldRayCastWrapper();
    org$jbox2d$dynamics$WorldRayCastWrapper.prototype.V$$init$$$.call(var31);
    var30.wrcwrapper = var31;
    // line number 745
    var32 = this;
    var33 = new org$jbox2d$collision$RayCastInput();
    org$jbox2d$collision$RayCastInput.prototype.V$$init$$$.call(var33);
    var32.input = var33;
    // line number 958
    var34 = this;
    org$jbox2d$dynamics$Island.$i;
    var35 = new org$jbox2d$dynamics$Island();
    org$jbox2d$dynamics$Island.prototype.V$$init$$$.call(var35);
    var34.island = var35;
    // line number 959
    var36 = this;
    var37 = bytecoder.newarray((10),null);
    var36.stack = var37;
    // line number 960
    var38 = this;
    var39 = new org$jbox2d$dynamics$Profile();
    org$jbox2d$dynamics$Profile.prototype.V$$init$$$.call(var39);
    var38.islandProfile = var39;
    // line number 961
    var40 = this;
    var41 = new org$jbox2d$common$Timer();
    org$jbox2d$common$Timer.prototype.V$$init$$$.call(var41);
    var40.broadphaseTimer = var41;
    // line number 1121
    var42 = this;
    var43 = new org$jbox2d$dynamics$Island();
    org$jbox2d$dynamics$Island.prototype.V$$init$$$.call(var43);
    var42.toiIsland = var43;
    // line number 1122
    var44 = this;
    var45 = new org$jbox2d$collision$TimeOfImpact$TOIInput();
    org$jbox2d$collision$TimeOfImpact$TOIInput.prototype.V$$init$$$.call(var45);
    var44.toiInput = var45;
    // line number 1123
    var46 = this;
    var47 = new org$jbox2d$collision$TimeOfImpact$TOIOutput();
    org$jbox2d$collision$TimeOfImpact$TOIOutput.prototype.V$$init$$$.call(var47);
    var46.toiOutput = var47;
    // line number 1124
    var48 = this;
    var49 = new org$jbox2d$dynamics$TimeStep();
    org$jbox2d$dynamics$TimeStep.prototype.V$$init$$$.call(var49);
    var48.subStep = var49;
    // line number 1125
    var50 = this;
    var51 = bytecoder.newarray((2),null);
    var50.tempBodies = var51;
    // line number 1126
    var52 = this;
    org$jbox2d$common$Sweep.$i;
    var53 = new org$jbox2d$common$Sweep();
    org$jbox2d$common$Sweep.prototype.V$$init$$$.call(var53);
    var52.backup1 = var53;
    // line number 1127
    var54 = this;
    var55 = new org$jbox2d$common$Sweep();
    org$jbox2d$common$Sweep.prototype.V$$init$$$.call(var55);
    var54.backup2 = var55;
    // line number 1454
    var56 = this;
    var56.liquidLength = 0.12;
    // line number 1455
    var57 = this;
    var57.averageLinearVel = -1.0;
    // line number 1456
    var58 = this;
    var59 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var59);
    var58.liquidOffset = var59;
    // line number 1457
    var60 = this;
    var61 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var61);
    var60.circCenterMoved = var61;
    // line number 1458
    var62 = this;
    var63 = new org$jbox2d$common$Color3f();
    var64 = 0.4;
    org$jbox2d$common$Color3f.prototype.V$$init$$F$F$F.call(var63,0.4,var64,1.0);
    var62.liquidColor = var63;
    // line number 1460
    var65 = this;
    var66 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var66);
    var65.center = var66;
    // line number 1461
    var67 = this;
    var68 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var68);
    var67.axis = var68;
    // line number 1462
    var69 = this;
    var70 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var70);
    var69.v1 = var70;
    // line number 1463
    var71 = this;
    var72 = new org$jbox2d$common$Vec2();
    org$jbox2d$common$Vec2.prototype.V$$init$$$.call(var72);
    var71.v2 = var72;
    // line number 1464
    var73 = this;
    var74 = new org$jbox2d$pooling$arrays$Vec2Array();
    org$jbox2d$pooling$arrays$Vec2Array.prototype.V$$init$$$.call(var74);
    var73.tlvertices = var74;
    // line number 143
    var75 = this;
    var75.pool = arg1;
    // line number 144
    var76 = this;
    var76.m_destructionListener = null;
    // line number 145
    var77 = this;
    var77.m_debugDraw = null;
    // line number 147
    var78 = this;
    var78.m_bodyList = null;
    // line number 148
    var79 = this;
    var79.m_jointList = null;
    // line number 150
    var80 = this;
    var80.m_bodyCount = 0;
    // line number 151
    var81 = this;
    var81.m_jointCount = 0;
    // line number 153
    var82 = this;
    var82.m_warmStarting = 1;
    // line number 154
    var83 = this;
    var83.m_continuousPhysics = 1;
    // line number 155
    var84 = this;
    var84.m_subStepping = 0;
    // line number 156
    var85 = this;
    var85.m_stepComplete = 1;
    // line number 158
    var86 = this;
    var86.m_allowSleep = 1;
    // line number 159
    var87 = (this.m_gravity);
    var88 = (org$jbox2d$common$Vec2.prototype.Lorg$jbox2d$common$Vec2$$set$Lorg$jbox2d$common$Vec2$.call(var87,var0));
    // line number 161
    var89 = this;
    var89.m_flags = 4;
    // line number 163
    var90 = this;
    var90.m_inv_dt0 = 0.0;
    // line number 165
    var91 = this;
    var92 = new org$jbox2d$dynamics$ContactManager();
    var93 = var1;
    org$jbox2d$dynamics$ContactManager.prototype.V$$init$$Lorg$jbox2d$dynamics$World$$Lorg$jbox2d$collision$broadphase$BroadPhaseStrategy$.call(var92,this,var93);
    var91.m_contactManager = var92;
    // line number 166
    var94 = this;
    var95 = new org$jbox2d$dynamics$Profile();
    org$jbox2d$dynamics$Profile.prototype.V$$init$$$.call(var95);
    var94.m_profile = var95;
    // line number 168
    org$jbox2d$dynamics$World.prototype.V$initializeRegisters$$.call(this);
    // line number 169
    return;
  }

  V$initializeRegisters$$() {
    // source file is World.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = null;
    // line number 211
    var0 = this;
    var1 = (var0.pool);
    var2 = (var1.Lorg$jbox2d$pooling$IDynamicStack$$getCircleContactStack$$());
    org$jbox2d$collision$shapes$ShapeType.$i;
    var3 = (org$jbox2d$collision$shapes$ShapeType.CIRCLE);
    var4 = (org$jbox2d$collision$shapes$ShapeType.CIRCLE);
    org$jbox2d$dynamics$World.prototype.V$addType$Lorg$jbox2d$pooling$IDynamicStack$$Lorg$jbox2d$collision$shapes$ShapeType$$Lorg$jbox2d$collision$shapes$ShapeType$.call(this,var2,var3,var4);
    // line number 212
    var5 = this;
    var6 = (var5.pool);
    var7 = (var6.Lorg$jbox2d$pooling$IDynamicStack$$getPolyCircleContactStack$$());
    var8 = (org$jbox2d$collision$shapes$ShapeType.POLYGON);
    var9 = (org$jbox2d$collision$shapes$ShapeType.CIRCLE);
    org$jbox2d$dynamics$World.prototype.V$addType$Lorg$jbox2d$pooling$IDynamicStack$$Lorg$jbox2d$collision$shapes$ShapeType$$Lorg$jbox2d$collision$shapes$ShapeType$.call(this,var7,var8,var9);
    // line number 213
    var10 = this;
    var11 = (var10.pool);
    var12 = (var11.Lorg$jbox2d$pooling$IDynamicStack$$getPolyContactStack$$());
    var13 = (org$jbox2d$collision$shapes$ShapeType.POLYGON);
    var14 = (org$jbox2d$collision$shapes$ShapeType.POLYGON);
    org$jbox2d$dynamics$World.prototype.V$addType$Lorg$jbox2d$pooling$IDynamicStack$$Lorg$jbox2d$collision$shapes$ShapeType$$Lorg$jbox2d$collision$shapes$ShapeType$.call(this,var12,var13,var14);
    // line number 214
    var15 = this;
    var16 = (var15.pool);
    var17 = (var16.Lorg$jbox2d$pooling$IDynamicStack$$getEdgeCircleContactStack$$());
    var18 = (org$jbox2d$collision$shapes$ShapeType.EDGE);
    var19 = (org$jbox2d$collision$shapes$ShapeType.CIRCLE);
    org$jbox2d$dynamics$World.prototype.V$addType$Lorg$jbox2d$pooling$IDynamicStack$$Lorg$jbox2d$collision$shapes$ShapeType$$Lorg$jbox2d$collision$shapes$ShapeType$.call(this,var17,var18,var19);
    // line number 215
    var20 = this;
    var21 = (var20.pool);
    var22 = (var21.Lorg$jbox2d$pooling$IDynamicStack$$getEdgePolyContactStack$$());
    var23 = (org$jbox2d$collision$shapes$ShapeType.EDGE);
    var24 = (org$jbox2d$collision$shapes$ShapeType.POLYGON);
    org$jbox2d$dynamics$World.prototype.V$addType$Lorg$jbox2d$pooling$IDynamicStack$$Lorg$jbox2d$collision$shapes$ShapeType$$Lorg$jbox2d$collision$shapes$ShapeType$.call(this,var22,var23,var24);
    // line number 216
    var25 = this;
    var26 = (var25.pool);
    var27 = (var26.Lorg$jbox2d$pooling$IDynamicStack$$getChainCircleContactStack$$());
    var28 = (org$jbox2d$collision$shapes$ShapeType.CHAIN);
    var29 = (org$jbox2d$collision$shapes$ShapeType.CIRCLE);
    org$jbox2d$dynamics$World.prototype.V$addType$Lorg$jbox2d$pooling$IDynamicStack$$Lorg$jbox2d$collision$shapes$ShapeType$$Lorg$jbox2d$collision$shapes$ShapeType$.call(this,var27,var28,var29);
    // line number 217
    var30 = this;
    var31 = (var30.pool);
    var32 = (var31.Lorg$jbox2d$pooling$IDynamicStack$$getChainPolyContactStack$$());
    var33 = (org$jbox2d$collision$shapes$ShapeType.CHAIN);
    var34 = (org$jbox2d$collision$shapes$ShapeType.POLYGON);
    org$jbox2d$dynamics$World.prototype.V$addType$Lorg$jbox2d$pooling$IDynamicStack$$Lorg$jbox2d$collision$shapes$ShapeType$$Lorg$jbox2d$collision$shapes$ShapeType$.call(this,var32,var33,var34);
    // line number 218
    return;
  }

  V$addType$Lorg$jbox2d$pooling$IDynamicStack$$Lorg$jbox2d$collision$shapes$ShapeType$$Lorg$jbox2d$collision$shapes$ShapeType$(arg0,arg1,arg2) {
    // source file is World.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = 0;
    var var13 = null;
    var var14 = 0;
    var phi15 = null;
    var phi16 = null;
    var phi17 = null;
    var phi18 = null;
    var phi19 = null;
    var0 = arg0;
    var1 = arg2;
    // line number 197
    var2 = new org$jbox2d$dynamics$contacts$ContactRegister();
    org$jbox2d$dynamics$contacts$ContactRegister.prototype.V$$init$$$.call(var2);
    // line number 198
    var3 = var0;
    var2.creator = var3;
    // line number 199
    var2.primary = 1;
    // line number 200
    var4 = (this.contactStacks);
    var5 = ((arg1.I$ordinal$$())) | 0;
    var6 = (var4.data[var5]);
    var7 = ((var1.I$ordinal$$())) | 0;
    var6.data[var7] = var2;
    // line number 202
    var8 = var1;
    If_45_0: {
     if (arg1 == var8) {
      phi15 = this;
      phi16 = var0;
      phi17 = arg1;
      phi18 = var1;
      phi19 = var2;
      break If_45_0;
     } else {
      // line number 203
      var9 = new org$jbox2d$dynamics$contacts$ContactRegister();
      org$jbox2d$dynamics$contacts$ContactRegister.prototype.V$$init$$$.call(var9);
      // line number 204
      var10 = var0;
      var9.creator = var10;
      // line number 205
      var9.primary = 0;
      // line number 206
      var11 = (this.contactStacks);
      var12 = ((var1.I$ordinal$$())) | 0;
      var13 = (var11.data[var12]);
      var14 = ((arg1.I$ordinal$$())) | 0;
      var13.data[var14] = var9;
      phi15 = this;
      phi16 = var0;
      phi17 = arg1;
      phi18 = var1;
      phi19 = var2;
      break If_45_0;
     }
    }
    // line number 208
    return;
  }

  Lorg$jbox2d$dynamics$Body$$createBody$Lorg$jbox2d$dynamics$BodyDef$(arg0) {
    // source file is World.java
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var phi5 = null;
    var phi6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var phi18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = 0;
    var var23 = 0;
    var var24 = null;
    var0 = arg0;
    // line number 307
    org$jbox2d$dynamics$World.$i;
    var1 = (org$jbox2d$dynamics$World.$assertionsDisabled);
    If_12_0: {
     if (var1 != 0) {
      phi5 = this;
      phi6 = var0;
      break If_12_0;
     } else {
      var2 = this;
      var3 = (org$jbox2d$dynamics$World.prototype.Z$isLocked$$.call(var2));
      if (var3 == 0) {
       phi5 = this;
       phi6 = var0;
       break If_12_0;
      } else {
       var4 = new java$lang$AssertionError();
       java$lang$AssertionError.prototype.V$$init$$$.call(var4);
       throw bytecoder.registerStack(var4, new Error().stack);
      }
     }
    }
    // line number 308
    var7 = phi5;
    var8 = (org$jbox2d$dynamics$World.prototype.Z$isLocked$$.call(var7));
    if (var8 == 0) {
     // line number 312
     org$jbox2d$dynamics$Body.$i;
     var9 = new org$jbox2d$dynamics$Body();
     var10 = phi6;
     var11 = phi5;
     org$jbox2d$dynamics$Body.prototype.V$$init$$Lorg$jbox2d$dynamics$BodyDef$$Lorg$jbox2d$dynamics$World$.call(var9,var10,var11);
     // line number 315
     var9.m_prev = null;
     // line number 316
     var12 = phi5;
     var13 = (var12.m_bodyList);
     var9.m_next = var13;
     // line number 317
     var14 = phi5;
     var15 = (var14.m_bodyList);
     If_79_0: {
      if (var15 == null) {
       phi18 = var9;
       break If_79_0;
      } else {
       // line number 318
       var16 = phi5;
       var17 = (var16.m_bodyList);
       var17.m_prev = var9;
       phi18 = var9;
       break If_79_0;
      }
     }
     // line number 320
     var19 = phi5;
     var20 = phi18;
     var19.m_bodyList = var20;
     // line number 321
     var21 = phi5;
     var22 = ((var21.m_bodyCount)) | 0;
     var23 = ((var22 + 1)) | 0;
     var21.m_bodyCount = var23;
     // line number 323
     var24 = phi18;
     return var24;
    } else {
     // line number 309
     return null;
    }
  }

  Z$isLocked$$() {
    // source file is World.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var phi3 = null;
    var phi4 = 0;
    // line number 920
    var0 = ((this.m_flags)) | 0;
    var1 = ((var0 & 2)) | 0;
    If_12_0: {
     if (var1 != 2) {
      phi3 = this;
      phi4 = (0) | 0;
      break If_12_0;
     } else {
      var2 = (1) | 0;
      // Here was a goto statement
      phi3 = this;
      phi4 = (var2) | 0;
      break If_12_0;
     }
    }
    return phi4;
  }

  Lorg$jbox2d$pooling$IWorldPool$$getPool$$() {
    // source file is World.java
    var var0 = null;
    // line number 258
    var0 = (this.pool);
    return var0;
  }

  Lorg$jbox2d$dynamics$joints$Joint$$createJoint$Lorg$jbox2d$dynamics$joints$JointDef$(arg0) {
    // source file is World.java
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var phi5 = null;
    var phi6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var phi19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = 0;
    var var24 = 0;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = null;
    var var37 = null;
    var var38 = null;
    var var39 = null;
    var var40 = null;
    var var41 = null;
    var var42 = null;
    var var43 = null;
    var var44 = null;
    var var45 = null;
    var var46 = null;
    var var47 = null;
    var var48 = null;
    var var49 = null;
    var var50 = null;
    var var51 = null;
    var var52 = null;
    var var53 = null;
    var var54 = null;
    var var55 = null;
    var var56 = null;
    var var57 = null;
    var var58 = null;
    var var59 = null;
    var var60 = null;
    var var61 = null;
    var var62 = null;
    var var63 = null;
    var var64 = null;
    var var65 = null;
    var var66 = null;
    var var67 = null;
    var var68 = null;
    var var69 = null;
    var var70 = null;
    var var71 = null;
    var var72 = null;
    var var73 = null;
    var var74 = null;
    var var75 = null;
    var var76 = null;
    var var77 = null;
    var var78 = null;
    var var79 = null;
    var var80 = null;
    var var81 = null;
    var var82 = 0;
    var var83 = null;
    var phi84 = null;
    var phi85 = null;
    var phi86 = null;
    var var87 = null;
    var var88 = null;
    var var89 = null;
    var var90 = null;
    var var91 = null;
    var var92 = null;
    var var93 = null;
    var var94 = null;
    var var95 = null;
    var0 = arg0;
    // line number 409
    org$jbox2d$dynamics$World.$i;
    var1 = (org$jbox2d$dynamics$World.$assertionsDisabled);
    If_12_0: {
     if (var1 != 0) {
      phi5 = this;
      phi6 = var0;
      break If_12_0;
     } else {
      var2 = this;
      var3 = (org$jbox2d$dynamics$World.prototype.Z$isLocked$$.call(var2));
      if (var3 == 0) {
       phi5 = this;
       phi6 = var0;
       break If_12_0;
      } else {
       var4 = new java$lang$AssertionError();
       java$lang$AssertionError.prototype.V$$init$$$.call(var4);
       throw bytecoder.registerStack(var4, new Error().stack);
      }
     }
    }
    // line number 410
    var7 = phi5;
    var8 = (org$jbox2d$dynamics$World.prototype.Z$isLocked$$.call(var7));
    if (var8 == 0) {
     // line number 414
     var9 = phi5;
     var10 = phi6;
     org$jbox2d$dynamics$joints$Joint.$i;
     var11 = (org$jbox2d$dynamics$joints$Joint.Lorg$jbox2d$dynamics$joints$Joint$$create$Lorg$jbox2d$dynamics$World$$Lorg$jbox2d$dynamics$joints$JointDef$(var9,var10));
     // line number 417
     var12 = null;
     var11.m_prev = var12;
     // line number 418
     var13 = phi5;
     var14 = (var13.m_jointList);
     var11.m_next = var14;
     // line number 419
     var15 = phi5;
     var16 = (var15.m_jointList);
     If_80_0: {
      if (var16 == null) {
       phi19 = var11;
       break If_80_0;
      } else {
       // line number 420
       var17 = phi5;
       var18 = (var17.m_jointList);
       var18.m_prev = var11;
       phi19 = var11;
       break If_80_0;
      }
     }
     // line number 422
     var20 = phi5;
     var21 = phi19;
     var20.m_jointList = var21;
     // line number 423
     var22 = phi5;
     var23 = ((var22.m_jointCount)) | 0;
     var24 = ((var23 + 1)) | 0;
     var22.m_jointCount = var24;
     // line number 426
     var25 = phi19;
     var26 = (var25.m_edgeA);
     var27 = phi19;
     var26.joint = var27;
     // line number 427
     var28 = phi19;
     var29 = (var28.m_edgeA);
     var30 = phi19;
     var31 = (org$jbox2d$dynamics$joints$Joint.prototype.Lorg$jbox2d$dynamics$Body$$getBodyB$$.call(var30));
     var29.other = var31;
     // line number 428
     var32 = phi19;
     var33 = (var32.m_edgeA);
     var33.prev = null;
     // line number 429
     var34 = phi19;
     var35 = (var34.m_edgeA);
     var36 = phi19;
     var37 = (org$jbox2d$dynamics$joints$Joint.prototype.Lorg$jbox2d$dynamics$Body$$getBodyA$$.call(var36));
     var38 = (var37.m_jointList);
     var35.next = var38;
     // line number 430
     var39 = phi19;
     var40 = (org$jbox2d$dynamics$joints$Joint.prototype.Lorg$jbox2d$dynamics$Body$$getBodyA$$.call(var39));
     var41 = (var40.m_jointList);
     If_169_0: {
      if (var41 == null) {
       break If_169_0;
      } else {
       // line number 431
       var42 = phi19;
       var43 = (org$jbox2d$dynamics$joints$Joint.prototype.Lorg$jbox2d$dynamics$Body$$getBodyA$$.call(var42));
       var44 = (var43.m_jointList);
       var45 = phi19;
       var46 = (var45.m_edgeA);
       var44.prev = var46;
       break If_169_0;
      }
     }
     // line number 433
     var47 = phi19;
     var48 = (org$jbox2d$dynamics$joints$Joint.prototype.Lorg$jbox2d$dynamics$Body$$getBodyA$$.call(var47));
     var49 = phi19;
     var50 = (var49.m_edgeA);
     var48.m_jointList = var50;
     // line number 435
     var51 = phi19;
     var52 = (var51.m_edgeB);
     var53 = phi19;
     var52.joint = var53;
     // line number 436
     var54 = phi19;
     var55 = (var54.m_edgeB);
     var56 = phi19;
     var57 = (org$jbox2d$dynamics$joints$Joint.prototype.Lorg$jbox2d$dynamics$Body$$getBodyA$$.call(var56));
     var55.other = var57;
     // line number 437
     var58 = phi19;
     var59 = (var58.m_edgeB);
     var59.prev = null;
     // line number 438
     var60 = phi19;
     var61 = (var60.m_edgeB);
     var62 = phi19;
     var63 = (org$jbox2d$dynamics$joints$Joint.prototype.Lorg$jbox2d$dynamics$Body$$getBodyB$$.call(var62));
     var64 = (var63.m_jointList);
     var61.next = var64;
     // line number 439
     var65 = phi19;
     var66 = (org$jbox2d$dynamics$joints$Joint.prototype.Lorg$jbox2d$dynamics$Body$$getBodyB$$.call(var65));
     var67 = (var66.m_jointList);
     If_259_0: {
      if (var67 == null) {
       break If_259_0;
      } else {
       // line number 440
       var68 = phi19;
       var69 = (org$jbox2d$dynamics$joints$Joint.prototype.Lorg$jbox2d$dynamics$Body$$getBodyB$$.call(var68));
       var70 = (var69.m_jointList);
       var71 = phi19;
       var72 = (var71.m_edgeB);
       var70.prev = var72;
       break If_259_0;
      }
     }
     // line number 442
     var73 = phi19;
     var74 = (org$jbox2d$dynamics$joints$Joint.prototype.Lorg$jbox2d$dynamics$Body$$getBodyB$$.call(var73));
     var75 = phi19;
     var76 = (var75.m_edgeB);
     var74.m_jointList = var76;
     // line number 444
     var77 = phi6;
     var78 = (var77.bodyA);
     // line number 445
     var79 = phi6;
     var80 = (var79.bodyB);
     // line number 448
     var81 = phi6;
     var82 = (var81.collideConnected);
     If_312_0: {
      if (var82 != 0) {
       phi84 = var78;
       phi85 = var80;
       break If_312_0;
      } else {
       // line number 449
       var83 = (org$jbox2d$dynamics$Body.prototype.Lorg$jbox2d$dynamics$contacts$ContactEdge$$getContactList$$.call(var80));
       phi84 = var78;
       phi85 = var80;
       phi86 = var83;
       L591452346: while(true) {
        // line number 450
        var87 = phi86;
        if (var87 == null) {
         break If_312_0;
        } else {
         // line number 451
         var88 = phi86;
         var89 = (var88.other);
         var90 = phi84;
         If_339_0: {
          if (var89 != var90) {
           break If_339_0;
          } else {
           // line number 454
           var91 = phi86;
           var92 = (var91.contact);
           org$jbox2d$dynamics$contacts$Contact.prototype.V$flagForFiltering$$.call(var92);
           break If_339_0;
          }
         }
         // line number 457
         var93 = phi86;
         var94 = (var93.next);
         // Here was a goto statement
         phi86 = var94;
         continue L591452346;
        }
       }
      }
     }
     // line number 463
     var95 = phi19;
     return var95;
    } else {
     // line number 411
     return null;
    }
  }

  V$step$F$I$I(arg0,arg1,arg2) {
    // source file is World.java
    var var0 = .0;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = 0;
    var phi9 = null;
    var phi10 = .0;
    var phi11 = 0;
    var phi12 = 0;
    var var13 = null;
    var var14 = 0;
    var var15 = 0;
    var var16 = null;
    var var17 = null;
    var var18 = .0;
    var var19 = null;
    var var20 = null;
    var var21 = 0;
    var var22 = null;
    var var23 = null;
    var var24 = 0;
    var var25 = .0;
    var var26 = 0;
    var var27 = null;
    var var28 = null;
    var var29 = .0;
    var var30 = .0;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = .0;
    var var35 = .0;
    var var36 = .0;
    var var37 = null;
    var var38 = null;
    var var39 = null;
    var var40 = 0;
    var var41 = null;
    var var42 = null;
    var var43 = null;
    var var44 = null;
    var var45 = null;
    var var46 = null;
    var var47 = null;
    var var48 = null;
    var var49 = .0;
    var var50 = null;
    var var51 = 0;
    var var52 = null;
    var var53 = null;
    var var54 = .0;
    var var55 = 0;
    var var56 = null;
    var var57 = null;
    var var58 = null;
    var var59 = null;
    var var60 = null;
    var var61 = null;
    var var62 = null;
    var var63 = null;
    var var64 = null;
    var var65 = .0;
    var var66 = null;
    var var67 = 0;
    var var68 = null;
    var var69 = null;
    var var70 = .0;
    var var71 = 0;
    var var72 = null;
    var var73 = null;
    var var74 = null;
    var var75 = null;
    var var76 = null;
    var var77 = null;
    var var78 = null;
    var var79 = null;
    var var80 = null;
    var var81 = .0;
    var var82 = null;
    var var83 = null;
    var var84 = .0;
    var var85 = 0;
    var var86 = null;
    var var87 = null;
    var var88 = null;
    var var89 = .0;
    var var90 = null;
    var var91 = 0;
    var var92 = 0;
    var var93 = null;
    var var94 = null;
    var var95 = 0;
    var var96 = 0;
    var var97 = null;
    var var98 = null;
    var var99 = null;
    var var100 = null;
    var var101 = .0;
    var var102 = null;
    var var103 = null;
    var0 = arg0;
    var1 = (arg2) | 0;
    // line number 566
    var2 = (this.stepTimer);
    org$jbox2d$common$Timer.prototype.V$reset$$.call(var2);
    // line number 569
    var3 = ((this.m_flags)) | 0;
    var4 = ((var3 & 1)) | 0;
    If_25_0: {
     if (var4 != 1) {
      phi9 = this;
      phi10 = var0;
      phi11 = (arg1) | 0;
      phi12 = (var1) | 0;
      break If_25_0;
     } else {
      // line number 571
      var5 = (this.m_contactManager);
      org$jbox2d$dynamics$ContactManager.prototype.V$findNewContacts$$.call(var5);
      // line number 572
      var6 = this;
      var7 = ((var6.m_flags)) | 0;
      var8 = ((var7 & -2)) | 0;
      var6.m_flags = var8;
      phi9 = this;
      phi10 = var0;
      phi11 = (arg1) | 0;
      phi12 = (var1) | 0;
      break If_25_0;
     }
    }
    // line number 575
    var13 = phi9;
    var14 = ((var13.m_flags)) | 0;
    var15 = ((var14 | 2)) | 0;
    var13.m_flags = var15;
    // line number 577
    var16 = phi9;
    var17 = (var16.step);
    var18 = phi10;
    var17.dt = var18;
    // line number 578
    var19 = phi9;
    var20 = (var19.step);
    var21 = (phi11) | 0;
    var20.velocityIterations = var21;
    // line number 579
    var22 = phi9;
    var23 = (var22.step);
    var24 = (phi12) | 0;
    var23.positionIterations = var24;
    // line number 580
    var25 = phi10;
    var26 = (bytecoder.cmp(var25,0.0)) | 0;
    If_100_0: {
     if (var26 <= 0) {
      // line number 583
      var102 = phi9;
      var103 = (var102.step);
      var103.inv_dt = 0.0;
      break If_100_0;
     } else {
      // line number 581
      var27 = phi9;
      var28 = (var27.step);
      var29 = phi10;
      var30 = (1.0 / var29);
      var28.inv_dt = var30;
      // Here was a goto statement
      break If_100_0;
     }
    }
    // line number 586
    var31 = phi9;
    var32 = (var31.step);
    var33 = phi9;
    var34 = (var33.m_inv_dt0);
    var35 = phi10;
    var36 = (var34 * var35);
    var32.dtRatio = var36;
    // line number 588
    var37 = phi9;
    var38 = (var37.step);
    var39 = phi9;
    var40 = (var39.m_warmStarting);
    var38.warmStarting = var40;
    // line number 591
    var41 = phi9;
    var42 = (var41.tempTimer);
    org$jbox2d$common$Timer.prototype.V$reset$$.call(var42);
    // line number 592
    var43 = phi9;
    var44 = (var43.m_contactManager);
    org$jbox2d$dynamics$ContactManager.prototype.V$collide$$.call(var44);
    // line number 593
    var45 = phi9;
    var46 = (var45.m_profile);
    var47 = phi9;
    var48 = (var47.tempTimer);
    var49 = (org$jbox2d$common$Timer.prototype.F$getMilliseconds$$.call(var48));
    var46.collide = var49;
    // line number 596
    var50 = phi9;
    var51 = (var50.m_stepComplete);
    If_189_0: {
     if (var51 == 0) {
      break If_189_0;
     } else {
      var52 = phi9;
      var53 = (var52.step);
      var54 = (var53.dt);
      var55 = (bytecoder.cmp(var54,0.0)) | 0;
      if (var55 <= 0) {
       break If_189_0;
      } else {
       // line number 597
       var56 = phi9;
       var57 = (var56.tempTimer);
       org$jbox2d$common$Timer.prototype.V$reset$$.call(var57);
       // line number 598
       var58 = phi9;
       var59 = phi9;
       var60 = (var59.step);
       org$jbox2d$dynamics$World.prototype.V$solve$Lorg$jbox2d$dynamics$TimeStep$.call(var58,var60);
       // line number 599
       var61 = phi9;
       var62 = (var61.m_profile);
       var63 = phi9;
       var64 = (var63.tempTimer);
       var65 = (org$jbox2d$common$Timer.prototype.F$getMilliseconds$$.call(var64));
       var62.solve = var65;
       break If_189_0;
      }
     }
    }
    // line number 603
    var66 = phi9;
    var67 = (var66.m_continuousPhysics);
    If_249_0: {
     if (var67 == 0) {
      break If_249_0;
     } else {
      var68 = phi9;
      var69 = (var68.step);
      var70 = (var69.dt);
      var71 = (bytecoder.cmp(var70,0.0)) | 0;
      if (var71 <= 0) {
       break If_249_0;
      } else {
       // line number 604
       var72 = phi9;
       var73 = (var72.tempTimer);
       org$jbox2d$common$Timer.prototype.V$reset$$.call(var73);
       // line number 605
       var74 = phi9;
       var75 = phi9;
       var76 = (var75.step);
       org$jbox2d$dynamics$World.prototype.V$solveTOI$Lorg$jbox2d$dynamics$TimeStep$.call(var74,var76);
       // line number 606
       var77 = phi9;
       var78 = (var77.m_profile);
       var79 = phi9;
       var80 = (var79.tempTimer);
       var81 = (org$jbox2d$common$Timer.prototype.F$getMilliseconds$$.call(var80));
       var78.solveTOI = var81;
       break If_249_0;
      }
     }
    }
    // line number 609
    var82 = phi9;
    var83 = (var82.step);
    var84 = (var83.dt);
    var85 = (bytecoder.cmp(var84,0.0)) | 0;
    If_316_0: {
     if (var85 <= 0) {
      break If_316_0;
     } else {
      // line number 610
      var86 = phi9;
      var87 = phi9;
      var88 = (var87.step);
      var89 = (var88.inv_dt);
      var86.m_inv_dt0 = var89;
      break If_316_0;
     }
    }
    // line number 613
    var90 = phi9;
    var91 = ((var90.m_flags)) | 0;
    var92 = ((var91 & 4)) | 0;
    If_345_0: {
     if (var92 != 4) {
      break If_345_0;
     } else {
      // line number 614
      var93 = phi9;
      org$jbox2d$dynamics$World.prototype.V$clearForces$$.call(var93);
      break If_345_0;
     }
    }
    // line number 617
    var94 = phi9;
    var95 = ((var94.m_flags)) | 0;
    var96 = ((var95 & -3)) | 0;
    var94.m_flags = var96;
    // line number 620
    var97 = phi9;
    var98 = (var97.m_profile);
    var99 = phi9;
    var100 = (var99.stepTimer);
    var101 = (org$jbox2d$common$Timer.prototype.F$getMilliseconds$$.call(var100));
    var98.step = var101;
    // line number 621
    return;
  }

  V$pushContact$Lorg$jbox2d$dynamics$contacts$Contact$(arg0) {
    // source file is World.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = 0;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = null;
    var phi11 = null;
    var phi12 = null;
    var phi13 = null;
    var phi14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = 0;
    var var22 = null;
    var var23 = 0;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var0 = arg0;
    // line number 242
    var1 = (org$jbox2d$dynamics$contacts$Contact.prototype.Lorg$jbox2d$dynamics$Fixture$$getFixtureA$$.call(var0));
    // line number 243
    var2 = (org$jbox2d$dynamics$contacts$Contact.prototype.Lorg$jbox2d$dynamics$Fixture$$getFixtureB$$.call(var0));
    // line number 245
    var3 = (var0.m_manifold);
    var4 = ((var3.pointCount)) | 0;
    If_23_0: {
     if (var4 <= 0) {
      phi11 = this;
      phi12 = var0;
      phi13 = var1;
      phi14 = var2;
      break If_23_0;
     } else {
      var5 = var1;
      var6 = (org$jbox2d$dynamics$Fixture.prototype.Z$isSensor$$.call(var5));
      if (var6 != 0) {
       phi11 = this;
       phi12 = var0;
       phi13 = var1;
       phi14 = var2;
       break If_23_0;
      } else {
       var7 = var2;
       var8 = (org$jbox2d$dynamics$Fixture.prototype.Z$isSensor$$.call(var7));
       if (var8 != 0) {
        phi11 = this;
        phi12 = var0;
        phi13 = var1;
        phi14 = var2;
        break If_23_0;
       } else {
        // line number 246
        var9 = (org$jbox2d$dynamics$Fixture.prototype.Lorg$jbox2d$dynamics$Body$$getBody$$.call(var1));
        org$jbox2d$dynamics$Body.prototype.V$setAwake$Z.call(var9,1);
        // line number 247
        var10 = (org$jbox2d$dynamics$Fixture.prototype.Lorg$jbox2d$dynamics$Body$$getBody$$.call(var2));
        org$jbox2d$dynamics$Body.prototype.V$setAwake$Z.call(var10,1);
        phi11 = this;
        phi12 = var0;
        phi13 = var1;
        phi14 = var2;
        break If_23_0;
       }
      }
     }
    }
    // line number 250
    var15 = phi13;
    var16 = (org$jbox2d$dynamics$Fixture.prototype.Lorg$jbox2d$collision$shapes$ShapeType$$getType$$.call(var15));
    // line number 251
    var17 = phi14;
    var18 = (org$jbox2d$dynamics$Fixture.prototype.Lorg$jbox2d$collision$shapes$ShapeType$$getType$$.call(var17));
    // line number 253
    var19 = phi11;
    var20 = (var19.contactStacks);
    var21 = ((var16.I$ordinal$$())) | 0;
    var22 = (var20.data[var21]);
    var23 = ((var18.I$ordinal$$())) | 0;
    var24 = (var22.data[var23]);
    var25 = (var24.creator);
    // line number 254
    var26 = phi12;
    var25.V$push$Ljava$lang$Object$(var26);
    // line number 255
    return;
  }

  V$solve$Lorg$jbox2d$dynamics$TimeStep$(arg0) {
    // source file is World.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var var7 = 0;
    var var8 = 0;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var phi12 = null;
    var phi13 = null;
    var phi14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = 0;
    var var18 = 0;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var phi24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = 0;
    var var28 = 0;
    var var29 = null;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var phi33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = null;
    var var37 = null;
    var var38 = null;
    var var39 = 0;
    var var40 = null;
    var var41 = null;
    var var42 = 0;
    var var43 = null;
    var var44 = null;
    var phi45 = 0;
    var var46 = null;
    var var47 = null;
    var phi48 = null;
    var var49 = null;
    var var50 = null;
    var var51 = 0;
    var var52 = 0;
    var var53 = null;
    var var54 = null;
    var var55 = null;
    var var56 = 0;
    var var57 = null;
    var var58 = 0;
    var var59 = null;
    var var60 = null;
    var var61 = null;
    var var62 = null;
    var var63 = null;
    var var64 = null;
    var var65 = null;
    var var66 = 0;
    var var67 = null;
    var var68 = null;
    var var69 = 0;
    var var70 = 0;
    var phi71 = 0;
    var var72 = 0;
    var var73 = null;
    var var74 = null;
    var var75 = 0;
    var var76 = null;
    var var77 = 0;
    var var78 = null;
    var var79 = 0;
    var var80 = null;
    var phi81 = null;
    var var82 = null;
    var var83 = null;
    var var84 = null;
    var var85 = null;
    var var86 = null;
    var var87 = null;
    var var88 = null;
    var var89 = null;
    var var90 = null;
    var phi91 = null;
    var var92 = null;
    var var93 = null;
    var var94 = null;
    var var95 = 0;
    var var96 = 0;
    var phi97 = null;
    var var98 = null;
    var var99 = null;
    var var100 = 0;
    var var101 = null;
    var var102 = 0;
    var var103 = null;
    var var104 = 0;
    var var105 = null;
    var var106 = 0;
    var var107 = 0;
    var var108 = null;
    var var109 = null;
    var var110 = null;
    var var111 = 0;
    var var112 = 0;
    var var113 = null;
    var var114 = null;
    var var115 = 0;
    var var116 = 0;
    var var117 = 0;
    var var118 = 0;
    var var119 = 0;
    var var120 = null;
    var phi121 = null;
    var phi122 = 0;
    var phi123 = 0;
    var phi124 = null;
    var var125 = null;
    var var126 = null;
    var var127 = 0;
    var var128 = null;
    var var129 = null;
    var var130 = 0;
    var var131 = 0;
    var var132 = null;
    var var133 = null;
    var phi134 = null;
    var var135 = null;
    var var136 = null;
    var var137 = null;
    var var138 = 0;
    var var139 = null;
    var var140 = null;
    var var141 = null;
    var var142 = null;
    var var143 = 0;
    var var144 = null;
    var var145 = null;
    var var146 = null;
    var var147 = null;
    var var148 = null;
    var var149 = null;
    var var150 = 0;
    var var151 = 0;
    var var152 = 0;
    var var153 = 0;
    var var154 = 0;
    var var155 = null;
    var phi156 = null;
    var var157 = null;
    var var158 = null;
    var var159 = 0;
    var var160 = null;
    var var161 = null;
    var var162 = 0;
    var var163 = 0;
    var var164 = null;
    var var165 = null;
    var var166 = null;
    var var167 = null;
    var var168 = null;
    var var169 = null;
    var var170 = null;
    var var171 = null;
    var var172 = 0;
    var var173 = null;
    var var174 = null;
    var var175 = .0;
    var var176 = null;
    var var177 = null;
    var var178 = .0;
    var var179 = .0;
    var var180 = null;
    var var181 = null;
    var var182 = .0;
    var var183 = null;
    var var184 = null;
    var var185 = .0;
    var var186 = .0;
    var var187 = null;
    var var188 = null;
    var var189 = .0;
    var var190 = null;
    var var191 = null;
    var var192 = .0;
    var var193 = .0;
    var var194 = 0;
    var phi195 = 0;
    var var196 = 0;
    var var197 = null;
    var var198 = null;
    var var199 = 0;
    var var200 = null;
    var var201 = null;
    var var202 = null;
    var var203 = 0;
    var var204 = null;
    var var205 = null;
    var var206 = null;
    var var207 = null;
    var var208 = 0;
    var var209 = 0;
    var phi210 = null;
    var var211 = null;
    var var212 = null;
    var var213 = null;
    var var214 = null;
    var phi215 = null;
    var var216 = null;
    var var217 = null;
    var var218 = 0;
    var var219 = 0;
    var var220 = null;
    var var221 = null;
    var var222 = null;
    var var223 = null;
    var var224 = null;
    var var225 = null;
    var var226 = null;
    var var227 = null;
    var var228 = null;
    var var229 = null;
    var var230 = null;
    var var231 = null;
    var var232 = .0;
    var0 = arg0;
    // line number 964
    var1 = (this.m_profile);
    var1.solveInit = 0.0;
    // line number 965
    var2 = (this.m_profile);
    var2.solveVelocity = 0.0;
    // line number 966
    var3 = (this.m_profile);
    var3.solvePosition = 0.0;
    // line number 969
    var4 = (this.island);
    var5 = ((this.m_bodyCount)) | 0;
    var6 = (this.m_contactManager);
    var7 = ((var6.m_contactCount)) | 0;
    var8 = ((this.m_jointCount)) | 0;
    var9 = (this.m_contactManager);
    var10 = (var9.m_contactListener);
    org$jbox2d$dynamics$Island.prototype.V$init$I$I$I$Lorg$jbox2d$callbacks$ContactListener$.call(var4,var5,var7,var8,var10);
    // line number 973
    var11 = (this.m_bodyList);
    phi12 = this;
    phi13 = var0;
    phi14 = var11;
    L1967283011: while(true) {
     var15 = phi14;
     if (var15 == null) {
      // line number 976
      var21 = phi12;
      var22 = (var21.m_contactManager);
      var23 = (var22.m_contactList);
      phi24 = var23;
      L405381713: while(true) {
       var25 = phi24;
       if (var25 == null) {
        // line number 979
        var31 = phi12;
        var32 = (var31.m_jointList);
        phi33 = var32;
        L1483799720: while(true) {
         var34 = phi33;
         if (var34 == null) {
          // line number 984
          var38 = phi12;
          var39 = ((var38.m_bodyCount)) | 0;
          // line number 985
          var40 = phi12;
          var41 = (var40.stack);
          var42 = (var41.data.length) | 0;
          If_169_0: {
           if (var42 >= var39) {
            phi45 = (var39) | 0;
            break If_169_0;
           } else {
            // line number 986
            var43 = phi12;
            var44 = bytecoder.newarray((var39),null);
            var43.stack = var44;
            phi45 = (var39) | 0;
            break If_169_0;
           }
          }
          // line number 988
          var46 = phi12;
          var47 = (var46.m_bodyList);
          phi48 = var47;
          L769987179: while(true) {
           var49 = phi48;
           if (var49 == null) {
            // line number 1100
            var211 = phi12;
            var212 = (var211.broadphaseTimer);
            org$jbox2d$common$Timer.prototype.V$reset$$.call(var212);
            // line number 1102
            var213 = phi12;
            var214 = (var213.m_bodyList);
            phi215 = var214;
            L1328919029: while(true) {
             var216 = phi215;
             if (var216 == null) {
              // line number 1117
              var226 = phi12;
              var227 = (var226.m_contactManager);
              org$jbox2d$dynamics$ContactManager.prototype.V$findNewContacts$$.call(var227);
              // line number 1118
              var228 = phi12;
              var229 = (var228.m_profile);
              var230 = phi12;
              var231 = (var230.broadphaseTimer);
              var232 = (org$jbox2d$common$Timer.prototype.F$getMilliseconds$$.call(var231));
              var229.broadphase = var232;
              // line number 1119
              return;
             } else {
              // line number 1104
              var217 = phi215;
              var218 = ((var217.m_flags)) | 0;
              var219 = ((var218 & 1)) | 0;
              If_920_0: {
               if (var219 != 0) {
                // line number 1108
                var222 = phi215;
                var223 = (org$jbox2d$dynamics$Body.prototype.Lorg$jbox2d$dynamics$BodyType$$getType$$.call(var222));
                org$jbox2d$dynamics$BodyType.$i;
                var224 = (org$jbox2d$dynamics$BodyType.STATIC);
                if (var223 != var224) {
                 // line number 1113
                 var225 = phi215;
                 org$jbox2d$dynamics$Body.prototype.V$synchronizeFixtures$$.call(var225);
                 break If_920_0;
                } else {
                 // line number 1109
                 // Here was a goto statement
                 break If_920_0;
                }
               } else {
                // line number 1105
                // Here was a goto statement
                break If_920_0;
               }
              }
              // line number 1102
              var220 = phi215;
              var221 = (org$jbox2d$dynamics$Body.prototype.Lorg$jbox2d$dynamics$Body$$getNext$$.call(var220));
              // Here was a goto statement
              phi215 = var221;
              continue L1328919029;
             }
            }
           } else {
            // line number 989
            var50 = phi48;
            var51 = ((var50.m_flags)) | 0;
            var52 = ((var51 & 1)) | 0;
            If_207_0: {
             if (var52 != 1) {
              // line number 993
              var55 = phi48;
              var56 = (org$jbox2d$dynamics$Body.prototype.Z$isAwake$$.call(var55));
              if (var56 == 0) {
               break If_207_0;
              } else {
               var57 = phi48;
               var58 = (org$jbox2d$dynamics$Body.prototype.Z$isActive$$.call(var57));
               if (var58 != 0) {
                // line number 998
                var59 = phi48;
                var60 = (org$jbox2d$dynamics$Body.prototype.Lorg$jbox2d$dynamics$BodyType$$getType$$.call(var59));
                org$jbox2d$dynamics$BodyType.$i;
                var61 = (org$jbox2d$dynamics$BodyType.STATIC);
                if (var60 != var61) {
                 // line number 1003
                 var62 = phi12;
                 var63 = (var62.island);
                 org$jbox2d$dynamics$Island.prototype.V$clear$$.call(var63);
                 // line number 1004
                 // line number 1005
                 var64 = phi12;
                 var65 = (var64.stack);
                 var66 = ((0 + 1)) | 0;
                 var67 = phi48;
                 var65.data[0] = var67;
                 // line number 1006
                 var68 = phi48;
                 var69 = ((var68.m_flags)) | 0;
                 var70 = ((var69 | 1)) | 0;
                 var68.m_flags = var70;
                 phi71 = (var66) | 0;
                 L1349284619: while(true) {
                  // line number 1009
                  var72 = (phi71) | 0;
                  if (var72 <= 0) {
                   // line number 1085
                   var164 = phi12;
                   var165 = (var164.island);
                   var166 = phi12;
                   var167 = (var166.islandProfile);
                   var168 = phi13;
                   var169 = phi12;
                   var170 = (var169.m_gravity);
                   var171 = phi12;
                   var172 = (var171.m_allowSleep);
                   org$jbox2d$dynamics$Island.prototype.V$solve$Lorg$jbox2d$dynamics$Profile$$Lorg$jbox2d$dynamics$TimeStep$$Lorg$jbox2d$common$Vec2$$Z.call(var165,var167,var168,var170,var172);
                   // line number 1086
                   var173 = phi12;
                   var174 = (var173.m_profile);
                   var175 = (var174.solveInit);
                   var176 = phi12;
                   var177 = (var176.islandProfile);
                   var178 = (var177.solveInit);
                   var179 = (var175 + var178);
                   var174.solveInit = var179;
                   // line number 1087
                   var180 = phi12;
                   var181 = (var180.m_profile);
                   var182 = (var181.solveVelocity);
                   var183 = phi12;
                   var184 = (var183.islandProfile);
                   var185 = (var184.solveVelocity);
                   var186 = (var182 + var185);
                   var181.solveVelocity = var186;
                   // line number 1088
                   var187 = phi12;
                   var188 = (var187.m_profile);
                   var189 = (var188.solvePosition);
                   var190 = phi12;
                   var191 = (var190.islandProfile);
                   var192 = (var191.solvePosition);
                   var193 = (var189 + var192);
                   var188.solvePosition = var193;
                   // line number 1091
                   var194 = (0) | 0;
                   phi195 = (var194) | 0;
                   L1080210590: while(true) {
                    var196 = (phi195) | 0;
                    var197 = phi12;
                    var198 = (var197.island);
                    var199 = ((var198.m_bodyCount)) | 0;
                    if (var196 >= var199) {
                     break If_207_0;
                    } else {
                     // line number 1093
                     var200 = phi12;
                     var201 = (var200.island);
                     var202 = (var201.m_bodies);
                     var203 = (phi195) | 0;
                     var204 = (var202.data[var203]);
                     // line number 1094
                     var205 = (org$jbox2d$dynamics$Body.prototype.Lorg$jbox2d$dynamics$BodyType$$getType$$.call(var204));
                     var206 = (org$jbox2d$dynamics$BodyType.STATIC);
                     If_864_0: {
                      if (var205 != var206) {
                       phi210 = var204;
                       break If_864_0;
                      } else {
                       // line number 1095
                       var207 = var204;
                       var208 = ((var207.m_flags)) | 0;
                       var209 = ((var208 & -2)) | 0;
                       var204.m_flags = var209;
                       phi210 = var204;
                       break If_864_0;
                      }
                     }
                     // line number 1091
                     phi195 = ((phi195 + 1)) | 0;
                     // Here was a goto statement
                     continue L1080210590;
                    }
                   }
                  } else {
                   // line number 1011
                   var73 = phi12;
                   var74 = (var73.stack);
                   phi71 = ((phi71 + -1)) | 0;
                   var75 = (phi71) | 0;
                   var76 = (var74.data[var75]);
                   // line number 1012
                   org$jbox2d$dynamics$World.$i;
                   var77 = (org$jbox2d$dynamics$World.$assertionsDisabled);
                   If_330_0: {
                    if (var77 != 0) {
                     phi81 = var76;
                     break If_330_0;
                    } else {
                     var78 = var76;
                     var79 = (org$jbox2d$dynamics$Body.prototype.Z$isActive$$.call(var78));
                     if (var79 == 1) {
                      phi81 = var76;
                      break If_330_0;
                     } else {
                      var80 = new java$lang$AssertionError();
                      java$lang$AssertionError.prototype.V$$init$$$.call(var80);
                      throw bytecoder.registerStack(var80, new Error().stack);
                     }
                    }
                   }
                   // line number 1013
                   var82 = phi12;
                   var83 = (var82.island);
                   var84 = phi81;
                   org$jbox2d$dynamics$Island.prototype.V$add$Lorg$jbox2d$dynamics$Body$.call(var83,var84);
                   // line number 1016
                   var85 = phi81;
                   org$jbox2d$dynamics$Body.prototype.V$setAwake$Z.call(var85,1);
                   // line number 1020
                   var86 = phi81;
                   var87 = (org$jbox2d$dynamics$Body.prototype.Lorg$jbox2d$dynamics$BodyType$$getType$$.call(var86));
                   var88 = (org$jbox2d$dynamics$BodyType.STATIC);
                   if (var87 != var88) {
                    // line number 1025
                    var89 = phi81;
                    var90 = (var89.m_contactList);
                    phi91 = var90;
                    L13447885: while(true) {
                     var92 = phi91;
                     if (var92 == null) {
                      // line number 1061
                      var132 = phi81;
                      var133 = (var132.m_jointList);
                      phi134 = var133;
                      L341451325: while(true) {
                       var135 = phi134;
                       if (var135 == null) {
                        // line number 1084
                        // Here was a goto statement
                        continue L1349284619;
                       } else {
                        // line number 1062
                        var136 = phi134;
                        var137 = (var136.joint);
                        var138 = (var137.m_islandFlag);
                        If_602_0: {
                         if (var138 != 1) {
                          // line number 1066
                          var141 = phi134;
                          var142 = (var141.other);
                          // line number 1069
                          var143 = (org$jbox2d$dynamics$Body.prototype.Z$isActive$$.call(var142));
                          if (var143 != 0) {
                           // line number 1073
                           var144 = phi12;
                           var145 = (var144.island);
                           var146 = phi134;
                           var147 = (var146.joint);
                           org$jbox2d$dynamics$Island.prototype.V$add$Lorg$jbox2d$dynamics$joints$Joint$.call(var145,var147);
                           // line number 1074
                           var148 = phi134;
                           var149 = (var148.joint);
                           var149.m_islandFlag = 1;
                           // line number 1076
                           var150 = ((var142.m_flags)) | 0;
                           var151 = ((var150 & 1)) | 0;
                           if (var151 != 1) {
                            // line number 1080
                            var152 = (org$jbox2d$dynamics$World.$assertionsDisabled);
                            If_680_0: {
                             if (var152 != 0) {
                              phi156 = var142;
                              break If_680_0;
                             } else {
                              var153 = (phi71) | 0;
                              var154 = (phi45) | 0;
                              if (var153 < var154) {
                               phi156 = var142;
                               break If_680_0;
                              } else {
                               var155 = new java$lang$AssertionError();
                               java$lang$AssertionError.prototype.V$$init$$$.call(var155);
                               throw bytecoder.registerStack(var155, new Error().stack);
                              }
                             }
                            }
                            // line number 1081
                            var157 = phi12;
                            var158 = (var157.stack);
                            var159 = (phi71) | 0;
                            phi71 = ((phi71 + 1)) | 0;
                            var160 = phi156;
                            var158.data[var159] = var160;
                            // line number 1082
                            var161 = phi156;
                            var162 = ((var161.m_flags)) | 0;
                            var163 = ((var162 | 1)) | 0;
                            var161.m_flags = var163;
                            break If_602_0;
                           } else {
                            // line number 1077
                            // Here was a goto statement
                            break If_602_0;
                           }
                          } else {
                           // line number 1070
                           // Here was a goto statement
                           break If_602_0;
                          }
                         } else {
                          // line number 1063
                          // Here was a goto statement
                          break If_602_0;
                         }
                        }
                        // line number 1061
                        var139 = phi134;
                        var140 = (var139.next);
                        // Here was a goto statement
                        phi134 = var140;
                        continue L341451325;
                       }
                      }
                     } else {
                      // line number 1026
                      var93 = phi91;
                      var94 = (var93.contact);
                      // line number 1029
                      var95 = ((var94.m_flags)) | 0;
                      var96 = ((var95 & 1)) | 0;
                      If_414_0: {
                       if (var96 != 1) {
                        // line number 1034
                        var100 = (org$jbox2d$dynamics$contacts$Contact.prototype.Z$isEnabled$$.call(var94));
                        if (var100 == 0) {
                         phi97 = var94;
                         break If_414_0;
                        } else {
                         var101 = var94;
                         var102 = (org$jbox2d$dynamics$contacts$Contact.prototype.Z$isTouching$$.call(var101));
                         if (var102 != 0) {
                          // line number 1039
                          var103 = (var94.m_fixtureA);
                          var104 = (var103.m_isSensor);
                          // line number 1040
                          var105 = (var94.m_fixtureB);
                          var106 = (var105.m_isSensor);
                          // line number 1041
                          if (var104 != 0) {
                           phi97 = var94;
                           break If_414_0;
                          } else {
                           var107 = var106;
                           if (var107 == 0) {
                            // line number 1045
                            var108 = phi12;
                            var109 = (var108.island);
                            org$jbox2d$dynamics$Island.prototype.V$add$Lorg$jbox2d$dynamics$contacts$Contact$.call(var109,var94);
                            // line number 1046
                            var110 = var94;
                            var111 = ((var110.m_flags)) | 0;
                            var112 = ((var111 | 1)) | 0;
                            var94.m_flags = var112;
                            // line number 1048
                            var113 = phi91;
                            var114 = (var113.other);
                            // line number 1051
                            var115 = ((var114.m_flags)) | 0;
                            var116 = ((var115 & 1)) | 0;
                            if (var116 != 1) {
                             // line number 1055
                             var117 = (org$jbox2d$dynamics$World.$assertionsDisabled);
                             If_529_0: {
                              if (var117 != 0) {
                               phi121 = var94;
                               phi122 = var104;
                               phi123 = var106;
                               phi124 = var114;
                               break If_529_0;
                              } else {
                               var118 = (phi71) | 0;
                               var119 = (phi45) | 0;
                               if (var118 < var119) {
                                phi121 = var94;
                                phi122 = var104;
                                phi123 = var106;
                                phi124 = var114;
                                break If_529_0;
                               } else {
                                var120 = new java$lang$AssertionError();
                                java$lang$AssertionError.prototype.V$$init$$$.call(var120);
                                throw bytecoder.registerStack(var120, new Error().stack);
                               }
                              }
                             }
                             // line number 1056
                             var125 = phi12;
                             var126 = (var125.stack);
                             var127 = (phi71) | 0;
                             phi71 = ((phi71 + 1)) | 0;
                             var128 = phi124;
                             var126.data[var127] = var128;
                             // line number 1057
                             var129 = phi124;
                             var130 = ((var129.m_flags)) | 0;
                             var131 = ((var130 | 1)) | 0;
                             var129.m_flags = var131;
                             phi97 = phi121;
                             break If_414_0;
                            } else {
                             // line number 1052
                             // Here was a goto statement
                             phi97 = var94;
                             break If_414_0;
                            }
                           } else {
                            // line number 1042
                            // Here was a goto statement
                            phi97 = var94;
                            break If_414_0;
                           }
                          }
                         } else {
                          // line number 1035
                          // Here was a goto statement
                          phi97 = var94;
                          break If_414_0;
                         }
                        }
                       } else {
                        // line number 1030
                        // Here was a goto statement
                        phi97 = var94;
                        break If_414_0;
                       }
                      }
                      // line number 1025
                      var98 = phi91;
                      var99 = (var98.next);
                      // Here was a goto statement
                      phi91 = var99;
                      continue L13447885;
                     }
                    }
                   } else {
                    // line number 1021
                    // Here was a goto statement
                    continue L1349284619;
                   }
                  }
                 }
                } else {
                 // line number 999
                 // Here was a goto statement
                 break If_207_0;
                }
               } else {
                // line number 994
                // Here was a goto statement
                break If_207_0;
               }
              }
             } else {
              // line number 990
              // Here was a goto statement
              break If_207_0;
             }
            }
            // line number 988
            var53 = phi48;
            var54 = (var53.m_next);
            // Here was a goto statement
            phi48 = var54;
            continue L769987179;
           }
          }
         } else {
          // line number 980
          var35 = phi33;
          var35.m_islandFlag = 0;
          // line number 979
          var36 = phi33;
          var37 = (var36.m_next);
          // Here was a goto statement
          phi33 = var37;
          continue L1483799720;
         }
        }
       } else {
        // line number 977
        var26 = phi24;
        var27 = ((var26.m_flags)) | 0;
        var28 = ((var27 & -2)) | 0;
        var26.m_flags = var28;
        // line number 976
        var29 = phi24;
        var30 = (var29.m_next);
        // Here was a goto statement
        phi24 = var30;
        continue L405381713;
       }
      }
     } else {
      // line number 974
      var16 = phi14;
      var17 = ((var16.m_flags)) | 0;
      var18 = ((var17 & -2)) | 0;
      var16.m_flags = var18;
      // line number 973
      var19 = phi14;
      var20 = (var19.m_next);
      // Here was a goto statement
      phi14 = var20;
      continue L1967283011;
     }
    }
  }

  V$solveTOI$Lorg$jbox2d$dynamics$TimeStep$(arg0) {
    // source file is World.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = null;
    var phi8 = null;
    var phi9 = null;
    var phi10 = null;
    var phi11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = 0;
    var var15 = 0;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var phi23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = 0;
    var var27 = 0;
    var var28 = null;
    var var29 = null;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = null;
    var phi35 = null;
    var phi36 = .0;
    var phi37 = null;
    var var38 = null;
    var var39 = null;
    var var40 = 0;
    var var41 = null;
    var var42 = null;
    var var43 = null;
    var var44 = .0;
    var var45 = 0;
    var var46 = null;
    var var47 = 0;
    var var48 = 0;
    var var49 = null;
    var var50 = .0;
    var phi51 = .0;
    var var52 = .0;
    var var53 = .0;
    var var54 = 0;
    var var55 = null;
    var var56 = .0;
    var var57 = null;
    var var58 = null;
    var var59 = null;
    var var60 = null;
    var var61 = 0;
    var var62 = null;
    var var63 = 0;
    var var64 = null;
    var var65 = null;
    var var66 = null;
    var var67 = null;
    var var68 = 0;
    var var69 = null;
    var var70 = null;
    var var71 = null;
    var var72 = null;
    var var73 = null;
    var phi74 = .0;
    var phi75 = null;
    var phi76 = null;
    var phi77 = null;
    var phi78 = null;
    var phi79 = null;
    var phi80 = null;
    var var81 = null;
    var var82 = 0;
    var var83 = null;
    var var84 = null;
    var var85 = 0;
    var phi86 = 0;
    var var87 = 0;
    var var88 = null;
    var var89 = 0;
    var var90 = null;
    var var91 = null;
    var var92 = 0;
    var phi93 = 0;
    var phi94 = 0;
    var var95 = 0;
    var var96 = 0;
    var var97 = 0;
    var phi98 = 0;
    var var99 = null;
    var var100 = 0;
    var var101 = null;
    var var102 = null;
    var phi103 = 0;
    var var104 = 0;
    var var105 = null;
    var var106 = 0;
    var var107 = null;
    var var108 = null;
    var phi109 = 0;
    var phi110 = 0;
    var var111 = 0;
    var var112 = 0;
    var var113 = 0;
    var phi114 = 0;
    var var115 = null;
    var var116 = null;
    var var117 = .0;
    var var118 = null;
    var var119 = null;
    var var120 = .0;
    var var121 = null;
    var var122 = null;
    var var123 = .0;
    var var124 = 0;
    var var125 = null;
    var var126 = null;
    var var127 = .0;
    var var128 = null;
    var var129 = null;
    var phi130 = .0;
    var var131 = 0;
    var var132 = .0;
    var var133 = 0;
    var var134 = null;
    var var135 = null;
    var var136 = 0;
    var var137 = null;
    var var138 = 0;
    var var139 = null;
    var var140 = null;
    var var141 = null;
    var var142 = null;
    var var143 = null;
    var var144 = null;
    var var145 = null;
    var var146 = null;
    var var147 = null;
    var var148 = null;
    var var149 = null;
    var var150 = null;
    var var151 = null;
    var var152 = null;
    var var153 = null;
    var var154 = null;
    var var155 = null;
    var var156 = null;
    var var157 = null;
    var var158 = null;
    var var159 = null;
    var var160 = null;
    var var161 = null;
    var var162 = .0;
    var var163 = null;
    var var164 = null;
    var var165 = null;
    var var166 = null;
    var var167 = .0;
    var var168 = .0;
    var var169 = .0;
    var var170 = .0;
    var var171 = .0;
    var var172 = .0;
    var phi173 = .0;
    var phi174 = 0;
    var phi175 = 0;
    var phi176 = null;
    var phi177 = .0;
    var var178 = null;
    var var179 = .0;
    var var180 = null;
    var var181 = 0;
    var var182 = 0;
    var var183 = .0;
    var var184 = null;
    var var185 = null;
    var var186 = .0;
    var var187 = null;
    var var188 = null;
    var var189 = .0;
    var var190 = 0;
    var var191 = null;
    var var192 = null;
    var var193 = .0;
    var var194 = null;
    var var195 = null;
    var phi196 = 0;
    var var197 = null;
    var var198 = .0;
    var var199 = .0;
    var var200 = 0;
    var var201 = null;
    var var202 = null;
    var var203 = null;
    var var204 = null;
    var var205 = null;
    var var206 = null;
    var var207 = null;
    var var208 = null;
    var var209 = null;
    var var210 = null;
    var var211 = null;
    var var212 = null;
    var var213 = null;
    var var214 = null;
    var var215 = null;
    var var216 = .0;
    var var217 = .0;
    var var218 = null;
    var var219 = null;
    var var220 = null;
    var var221 = null;
    var var222 = null;
    var var223 = 0;
    var var224 = 0;
    var var225 = null;
    var var226 = .0;
    var var227 = .0;
    var var228 = null;
    var var229 = 0;
    var var230 = null;
    var var231 = 0;
    var phi232 = null;
    var phi233 = null;
    var phi234 = null;
    var phi235 = null;
    var var236 = null;
    var var237 = null;
    var var238 = null;
    var var239 = null;
    var var240 = null;
    var var241 = null;
    var var242 = null;
    var var243 = null;
    var var244 = null;
    var var245 = null;
    var var246 = null;
    var var247 = null;
    var var248 = null;
    var var249 = null;
    var var250 = null;
    var var251 = null;
    var var252 = null;
    var var253 = null;
    var var254 = null;
    var var255 = 0;
    var var256 = 0;
    var var257 = null;
    var var258 = 0;
    var var259 = 0;
    var var260 = null;
    var var261 = 0;
    var var262 = 0;
    var var263 = null;
    var var264 = null;
    var var265 = null;
    var var266 = null;
    var var267 = null;
    var var268 = null;
    var var269 = 0;
    var phi270 = null;
    var phi271 = null;
    var phi272 = null;
    var phi273 = 0;
    var var274 = 0;
    var var275 = null;
    var var276 = null;
    var var277 = 0;
    var var278 = null;
    var var279 = null;
    var var280 = null;
    var var281 = null;
    var phi282 = null;
    var phi283 = null;
    var var284 = null;
    var var285 = null;
    var var286 = 0;
    var var287 = null;
    var var288 = 0;
    var var289 = null;
    var var290 = 0;
    var var291 = null;
    var var292 = 0;
    var var293 = null;
    var var294 = null;
    var var295 = 0;
    var var296 = 0;
    var phi297 = null;
    var var298 = null;
    var var299 = null;
    var var300 = null;
    var var301 = null;
    var var302 = null;
    var var303 = null;
    var var304 = null;
    var var305 = 0;
    var var306 = null;
    var var307 = 0;
    var phi308 = null;
    var phi309 = null;
    var var310 = null;
    var var311 = null;
    var var312 = 0;
    var var313 = null;
    var var314 = null;
    var var315 = 0;
    var var316 = 0;
    var var317 = null;
    var var318 = null;
    var var319 = null;
    var var320 = null;
    var var321 = null;
    var var322 = null;
    var var323 = 0;
    var var324 = 0;
    var var325 = null;
    var var326 = .0;
    var phi327 = 0;
    var phi328 = 0;
    var var329 = null;
    var var330 = null;
    var var331 = null;
    var var332 = null;
    var var333 = null;
    var var334 = 0;
    var var335 = null;
    var var336 = null;
    var var337 = null;
    var var338 = null;
    var var339 = null;
    var var340 = null;
    var var341 = null;
    var var342 = 0;
    var var343 = null;
    var var344 = null;
    var var345 = null;
    var var346 = null;
    var var347 = null;
    var var348 = null;
    var var349 = null;
    var var350 = 0;
    var var351 = 0;
    var var352 = null;
    var var353 = null;
    var var354 = null;
    var var355 = 0;
    var var356 = 0;
    var var357 = null;
    var var358 = 0;
    var var359 = 0;
    var var360 = null;
    var var361 = null;
    var var362 = null;
    var var363 = null;
    var var364 = null;
    var var365 = null;
    var var366 = null;
    var var367 = null;
    var var368 = .0;
    var var369 = .0;
    var var370 = null;
    var var371 = .0;
    var var372 = .0;
    var var373 = null;
    var var374 = null;
    var var375 = null;
    var var376 = null;
    var var377 = .0;
    var var378 = .0;
    var var379 = null;
    var var380 = null;
    var var381 = null;
    var var382 = null;
    var var383 = null;
    var var384 = null;
    var var385 = null;
    var var386 = 0;
    var var387 = null;
    var var388 = null;
    var var389 = null;
    var var390 = null;
    var var391 = null;
    var var392 = null;
    var var393 = 0;
    var var394 = null;
    var var395 = 0;
    var var396 = 0;
    var phi397 = 0;
    var var398 = 0;
    var var399 = null;
    var var400 = 0;
    var var401 = null;
    var var402 = null;
    var var403 = 0;
    var var404 = null;
    var var405 = null;
    var var406 = 0;
    var var407 = 0;
    var var408 = null;
    var var409 = null;
    var phi410 = null;
    var var411 = null;
    var phi412 = null;
    var phi413 = null;
    var var414 = null;
    var var415 = null;
    var var416 = null;
    var var417 = 0;
    var var418 = 0;
    var var419 = null;
    var var420 = null;
    var var421 = null;
    var var422 = null;
    var var423 = null;
    var var424 = 0;
    var var425 = null;
    var0 = arg0;
    // line number 1131
    var1 = (this.toiIsland);
    // line number 1132
    var2 = (32) | 0;
    var3 = this;
    var4 = (var3.m_contactManager);
    var5 = (var4.m_contactListener);
    org$jbox2d$dynamics$Island.prototype.V$init$I$I$I$Lorg$jbox2d$callbacks$ContactListener$.call(var1,64,var2,0,var5);
    // line number 1134
    var6 = (this.m_stepComplete);
    If_31_0: {
     if (var6 == 0) {
      phi8 = this;
      phi9 = var0;
      phi10 = var1;
      break If_31_0;
     } else {
      // line number 1135
      var7 = (this.m_bodyList);
      phi8 = this;
      phi9 = var0;
      phi10 = var1;
      phi11 = var7;
      L43216209: while(true) {
       var12 = phi11;
       if (var12 == null) {
        // line number 1140
        var20 = phi8;
        var21 = (var20.m_contactManager);
        var22 = (var21.m_contactList);
        phi23 = var22;
        L799544196: while(true) {
         var24 = phi23;
         if (var24 == null) {
          break If_31_0;
         } else {
          // line number 1142
          var25 = phi23;
          var26 = ((var25.m_flags)) | 0;
          var27 = ((var26 & -34)) | 0;
          var25.m_flags = var27;
          // line number 1143
          var28 = phi23;
          var28.m_toiCount = 0.0;
          // line number 1144
          var29 = phi23;
          var29.m_toi = 1.0;
          // line number 1140
          var30 = phi23;
          var31 = (var30.m_next);
          // Here was a goto statement
          phi23 = var31;
          continue L799544196;
         }
        }
       } else {
        // line number 1136
        var13 = phi11;
        var14 = ((var13.m_flags)) | 0;
        var15 = ((var14 & -2)) | 0;
        var13.m_flags = var15;
        // line number 1137
        var16 = phi11;
        var17 = (var16.m_sweep);
        var17.alpha0 = 0.0;
        // line number 1135
        var18 = phi11;
        var19 = (var18.m_next);
        // Here was a goto statement
        phi11 = var19;
        continue L43216209;
       }
      }
     }
    }
    L80348506: while(true) {
     // line number 1151
     // line number 1152
     // line number 1154
     var32 = phi8;
     var33 = (var32.m_contactManager);
     var34 = (var33.m_contactList);
     phi35 = null;
     phi36 = 1.0;
     phi37 = var34;
     L1522965024: while(true) {
      var38 = phi37;
      if (var38 == null) {
       // line number 1247
       var197 = phi35;
       If_794_0: {
        If_794_1: {
         if (var197 == null) {
          break If_794_1;
         } else {
          var198 = 0.9999988;
          var199 = phi36;
          var200 = (bytecoder.cmp(var198,var199)) | 0;
          if (var200 >= 0) {
           // line number 1254
           var202 = phi35;
           var203 = (var202.Lorg$jbox2d$dynamics$Fixture$$getFixtureA$$());
           // line number 1255
           var204 = phi35;
           var205 = (var204.Lorg$jbox2d$dynamics$Fixture$$getFixtureB$$());
           // line number 1256
           var206 = (org$jbox2d$dynamics$Fixture.prototype.Lorg$jbox2d$dynamics$Body$$getBody$$.call(var203));
           // line number 1257
           var207 = (org$jbox2d$dynamics$Fixture.prototype.Lorg$jbox2d$dynamics$Body$$getBody$$.call(var205));
           // line number 1259
           var208 = phi8;
           var209 = (var208.backup1);
           var210 = (var206.m_sweep);
           var211 = (org$jbox2d$common$Sweep.prototype.Lorg$jbox2d$common$Sweep$$set$Lorg$jbox2d$common$Sweep$.call(var209,var210));
           // line number 1260
           var212 = phi8;
           var213 = (var212.backup2);
           var214 = (var207.m_sweep);
           var215 = (org$jbox2d$common$Sweep.prototype.Lorg$jbox2d$common$Sweep$$set$Lorg$jbox2d$common$Sweep$.call(var213,var214));
           // line number 1262
           var216 = phi36;
           org$jbox2d$dynamics$Body.prototype.V$advance$F.call(var206,var216);
           // line number 1263
           var217 = phi36;
           org$jbox2d$dynamics$Body.prototype.V$advance$F.call(var207,var217);
           // line number 1266
           var218 = phi35;
           var219 = phi8;
           var220 = (var219.m_contactManager);
           var221 = (var220.m_contactListener);
           var218.V$update$Lorg$jbox2d$callbacks$ContactListener$(var221);
           // line number 1267
           var222 = phi35;
           var223 = ((var222.m_flags)) | 0;
           var224 = ((var223 & -33)) | 0;
           var222.m_flags = var224;
           // line number 1268
           var225 = phi35;
           var226 = (var225.m_toiCount);
           var227 = (var226 + 1.0);
           var225.m_toiCount = var227;
           // line number 1271
           var228 = phi35;
           var229 = (var228.Z$isEnabled$$());
           If_926_0: {
            if (var229 == 0) {
             phi232 = var203;
             phi233 = var205;
             phi234 = var206;
             phi235 = var207;
             break If_926_0;
            } else {
             var230 = phi35;
             var231 = (var230.Z$isTouching$$());
             if (var231 != 0) {
              // line number 1281
              org$jbox2d$dynamics$Body.prototype.V$setAwake$Z.call(var206,1);
              // line number 1282
              org$jbox2d$dynamics$Body.prototype.V$setAwake$Z.call(var207,1);
              // line number 1285
              var249 = phi10;
              org$jbox2d$dynamics$Island.prototype.V$clear$$.call(var249);
              // line number 1286
              var250 = phi10;
              org$jbox2d$dynamics$Island.prototype.V$add$Lorg$jbox2d$dynamics$Body$.call(var250,var206);
              // line number 1287
              var251 = phi10;
              org$jbox2d$dynamics$Island.prototype.V$add$Lorg$jbox2d$dynamics$Body$.call(var251,var207);
              // line number 1288
              var252 = phi10;
              var253 = phi35;
              org$jbox2d$dynamics$Island.prototype.V$add$Lorg$jbox2d$dynamics$contacts$Contact$.call(var252,var253);
              // line number 1290
              var254 = var206;
              var255 = ((var254.m_flags)) | 0;
              var256 = ((var255 | 1)) | 0;
              var206.m_flags = var256;
              // line number 1291
              var257 = var207;
              var258 = ((var257.m_flags)) | 0;
              var259 = ((var258 | 1)) | 0;
              var207.m_flags = var259;
              // line number 1292
              var260 = phi35;
              var261 = ((var260.m_flags)) | 0;
              var262 = ((var261 | 1)) | 0;
              var260.m_flags = var262;
              // line number 1295
              var263 = phi8;
              var264 = (var263.tempBodies);
              var265 = var206;
              var264.data[0] = var265;
              // line number 1296
              var266 = phi8;
              var267 = (var266.tempBodies);
              var268 = var207;
              var267.data[1] = var268;
              // line number 1297
              var269 = (0) | 0;
              phi270 = var203;
              phi271 = var206;
              phi272 = var207;
              phi273 = (var269) | 0;
              L1609472596: while(true) {
               var274 = (phi273) | 0;
               if (var274 >= 2) {
                // line number 1374
                var366 = phi8;
                var367 = (var366.subStep);
                var368 = phi36;
                var369 = (1.0 - var368);
                var370 = phi9;
                var371 = (var370.dt);
                var372 = (var369 * var371);
                var367.dt = var372;
                // line number 1375
                var373 = phi8;
                var374 = (var373.subStep);
                var375 = phi8;
                var376 = (var375.subStep);
                var377 = (var376.dt);
                var378 = (1.0 / var377);
                var374.inv_dt = var378;
                // line number 1376
                var379 = phi8;
                var380 = (var379.subStep);
                var380.dtRatio = 1.0;
                // line number 1377
                var381 = phi8;
                var382 = (var381.subStep);
                var382.positionIterations = 20;
                // line number 1378
                var383 = phi8;
                var384 = (var383.subStep);
                var385 = phi9;
                var386 = ((var385.velocityIterations)) | 0;
                var384.velocityIterations = var386;
                // line number 1379
                var387 = phi8;
                var388 = (var387.subStep);
                var388.warmStarting = 0;
                // line number 1380
                var389 = phi10;
                var390 = phi8;
                var391 = (var390.subStep);
                var392 = phi271;
                var393 = ((var392.m_islandIndex)) | 0;
                var394 = phi272;
                var395 = ((var394.m_islandIndex)) | 0;
                org$jbox2d$dynamics$Island.prototype.V$solveTOI$Lorg$jbox2d$dynamics$TimeStep$$I$I.call(var389,var391,var393,var395);
                // line number 1383
                var396 = (0) | 0;
                phi397 = (var396) | 0;
                L1519514195: while(true) {
                 var398 = (phi397) | 0;
                 var399 = phi10;
                 var400 = ((var399.m_bodyCount)) | 0;
                 if (var398 >= var400) {
                  // line number 1401
                  var421 = phi8;
                  var422 = (var421.m_contactManager);
                  org$jbox2d$dynamics$ContactManager.prototype.V$findNewContacts$$.call(var422);
                  // line number 1403
                  var423 = phi8;
                  var424 = (var423.m_subStepping);
                  if (var424 == 0) {
                   // line number 1407
                   // Here was a goto statement
                   phi23 = phi35;
                   continue L80348506;
                  } else {
                   // line number 1404
                   var425 = phi8;
                   var425.m_stepComplete = 0;
                   // line number 1405
                   // Here was a goto statement
                   phi37 = phi270;
                   break If_794_0;
                  }
                 } else {
                  // line number 1384
                  var401 = phi10;
                  var402 = (var401.m_bodies);
                  var403 = (phi397) | 0;
                  var404 = (var402.data[var403]);
                  // line number 1385
                  var405 = var404;
                  var406 = ((var405.m_flags)) | 0;
                  var407 = ((var406 & -2)) | 0;
                  var404.m_flags = var407;
                  // line number 1387
                  var408 = (var404.m_type);
                  org$jbox2d$dynamics$BodyType.$i;
                  var409 = (org$jbox2d$dynamics$BodyType.DYNAMIC);
                  If_1631_0: {
                   if (var408 == var409) {
                    // line number 1391
                    org$jbox2d$dynamics$Body.prototype.V$synchronizeFixtures$$.call(var404);
                    // line number 1394
                    var411 = (var404.m_contactList);
                    phi412 = var404;
                    phi413 = var411;
                    L7690292: while(true) {
                     var414 = phi413;
                     if (var414 == null) {
                      phi410 = phi412;
                      break If_1631_0;
                     } else {
                      // line number 1395
                      var415 = phi413;
                      var416 = (var415.contact);
                      var417 = ((var416.m_flags)) | 0;
                      var418 = ((var417 & -34)) | 0;
                      var416.m_flags = var418;
                      // line number 1394
                      var419 = phi413;
                      var420 = (var419.next);
                      // Here was a goto statement
                      phi413 = var420;
                      continue L7690292;
                     }
                    }
                   } else {
                    // line number 1388
                    // Here was a goto statement
                    phi410 = var404;
                    break If_1631_0;
                   }
                  }
                  // line number 1383
                  phi397 = ((phi397 + 1)) | 0;
                  // Here was a goto statement
                  continue L1519514195;
                 }
                }
               } else {
                // line number 1298
                var275 = phi8;
                var276 = (var275.tempBodies);
                var277 = (phi273) | 0;
                var278 = (var276.data[var277]);
                // line number 1299
                var279 = (var278.m_type);
                org$jbox2d$dynamics$BodyType.$i;
                var280 = (org$jbox2d$dynamics$BodyType.DYNAMIC);
                If_1117_0: {
                 if (var279 != var280) {
                  phi282 = var278;
                  break If_1117_0;
                 } else {
                  // line number 1300
                  var281 = (var278.m_contactList);
                  phi282 = var278;
                  phi283 = var281;
                  L1290103884: while(true) {
                   var284 = phi283;
                   if (var284 == null) {
                    break If_1117_0;
                   } else {
                    // line number 1301
                    var285 = phi10;
                    var286 = ((var285.m_bodyCount)) | 0;
                    var287 = phi10;
                    var288 = ((var287.m_bodyCapacity)) | 0;
                    if (var286 != var288) {
                     // line number 1305
                     var289 = phi10;
                     var290 = ((var289.m_contactCount)) | 0;
                     var291 = phi10;
                     var292 = ((var291.m_contactCapacity)) | 0;
                     if (var290 != var292) {
                      // line number 1309
                      var293 = phi283;
                      var294 = (var293.contact);
                      // line number 1312
                      var295 = ((var294.m_flags)) | 0;
                      var296 = ((var295 & 1)) | 0;
                      If_1191_0: {
                       if (var296 == 0) {
                        // line number 1317
                        var300 = phi283;
                        var301 = (var300.other);
                        // line number 1318
                        var302 = (var301.m_type);
                        var303 = (org$jbox2d$dynamics$BodyType.DYNAMIC);
                        If_1224_0: {
                         if (var302 != var303) {
                          phi308 = var294;
                          phi309 = var301;
                          break If_1224_0;
                         } else {
                          var304 = phi282;
                          var305 = (org$jbox2d$dynamics$Body.prototype.Z$isBullet$$.call(var304));
                          if (var305 != 0) {
                           phi308 = var294;
                           phi309 = var301;
                           break If_1224_0;
                          } else {
                           var306 = var301;
                           var307 = (org$jbox2d$dynamics$Body.prototype.Z$isBullet$$.call(var306));
                           if (var307 != 0) {
                            phi308 = var294;
                            phi309 = var301;
                            break If_1224_0;
                           } else {
                            // line number 1320
                            // Here was a goto statement
                            phi297 = var294;
                            break If_1191_0;
                           }
                          }
                         }
                        }
                        // line number 1324
                        var310 = phi308;
                        var311 = (var310.m_fixtureA);
                        var312 = (var311.m_isSensor);
                        // line number 1325
                        var313 = phi308;
                        var314 = (var313.m_fixtureB);
                        var315 = (var314.m_isSensor);
                        // line number 1326
                        if (var312 != 0) {
                         phi297 = phi308;
                         break If_1191_0;
                        } else {
                         var316 = var315;
                         if (var316 == 0) {
                          // line number 1331
                          var317 = phi8;
                          var318 = (var317.backup1);
                          var319 = phi309;
                          var320 = (var319.m_sweep);
                          var321 = (org$jbox2d$common$Sweep.prototype.Lorg$jbox2d$common$Sweep$$set$Lorg$jbox2d$common$Sweep$.call(var318,var320));
                          // line number 1332
                          var322 = phi309;
                          var323 = ((var322.m_flags)) | 0;
                          var324 = ((var323 & 1)) | 0;
                          If_1308_0: {
                           if (var324 != 0) {
                            phi327 = var312;
                            phi328 = var315;
                            break If_1308_0;
                           } else {
                            // line number 1333
                            var325 = phi309;
                            var326 = phi36;
                            org$jbox2d$dynamics$Body.prototype.V$advance$F.call(var325,var326);
                            phi327 = var312;
                            phi328 = var315;
                            break If_1308_0;
                           }
                          }
                          // line number 1337
                          var329 = phi308;
                          var330 = phi8;
                          var331 = (var330.m_contactManager);
                          var332 = (var331.m_contactListener);
                          org$jbox2d$dynamics$contacts$Contact.prototype.V$update$Lorg$jbox2d$callbacks$ContactListener$.call(var329,var332);
                          // line number 1340
                          var333 = phi308;
                          var334 = (org$jbox2d$dynamics$contacts$Contact.prototype.Z$isEnabled$$.call(var333));
                          if (var334 != 0) {
                           // line number 1347
                           var341 = phi308;
                           var342 = (org$jbox2d$dynamics$contacts$Contact.prototype.Z$isTouching$$.call(var341));
                           if (var342 != 0) {
                            // line number 1354
                            var349 = phi308;
                            var350 = ((var349.m_flags)) | 0;
                            var351 = ((var350 | 1)) | 0;
                            var349.m_flags = var351;
                            // line number 1355
                            var352 = phi10;
                            var353 = phi308;
                            org$jbox2d$dynamics$Island.prototype.V$add$Lorg$jbox2d$dynamics$contacts$Contact$.call(var352,var353);
                            // line number 1358
                            var354 = phi309;
                            var355 = ((var354.m_flags)) | 0;
                            var356 = ((var355 & 1)) | 0;
                            if (var356 == 0) {
                             // line number 1363
                             var357 = phi309;
                             var358 = ((var357.m_flags)) | 0;
                             var359 = ((var358 | 1)) | 0;
                             var357.m_flags = var359;
                             // line number 1365
                             var360 = phi309;
                             var361 = (var360.m_type);
                             var362 = (org$jbox2d$dynamics$BodyType.STATIC);
                             If_1462_0: {
                              if (var361 == var362) {
                               break If_1462_0;
                              } else {
                               // line number 1366
                               var363 = phi309;
                               org$jbox2d$dynamics$Body.prototype.V$setAwake$Z.call(var363,1);
                               break If_1462_0;
                              }
                             }
                             // line number 1369
                             var364 = phi10;
                             var365 = phi309;
                             org$jbox2d$dynamics$Island.prototype.V$add$Lorg$jbox2d$dynamics$Body$.call(var364,var365);
                             phi297 = phi308;
                             break If_1191_0;
                            } else {
                             // line number 1359
                             // Here was a goto statement
                             phi297 = phi308;
                             break If_1191_0;
                            }
                           } else {
                            // line number 1348
                            var343 = phi309;
                            var344 = (var343.m_sweep);
                            var345 = phi8;
                            var346 = (var345.backup1);
                            var347 = (org$jbox2d$common$Sweep.prototype.Lorg$jbox2d$common$Sweep$$set$Lorg$jbox2d$common$Sweep$.call(var344,var346));
                            // line number 1349
                            var348 = phi309;
                            org$jbox2d$dynamics$Body.prototype.V$synchronizeTransform$$.call(var348);
                            // line number 1350
                            // Here was a goto statement
                            phi297 = phi308;
                            break If_1191_0;
                           }
                          } else {
                           // line number 1341
                           var335 = phi309;
                           var336 = (var335.m_sweep);
                           var337 = phi8;
                           var338 = (var337.backup1);
                           var339 = (org$jbox2d$common$Sweep.prototype.Lorg$jbox2d$common$Sweep$$set$Lorg$jbox2d$common$Sweep$.call(var336,var338));
                           // line number 1342
                           var340 = phi309;
                           org$jbox2d$dynamics$Body.prototype.V$synchronizeTransform$$.call(var340);
                           // line number 1343
                           // Here was a goto statement
                           phi297 = phi308;
                           break If_1191_0;
                          }
                         } else {
                          // line number 1327
                          // Here was a goto statement
                          phi297 = phi308;
                          break If_1191_0;
                         }
                        }
                       } else {
                        // line number 1313
                        // Here was a goto statement
                        phi297 = var294;
                        break If_1191_0;
                       }
                      }
                      // line number 1300
                      var298 = phi283;
                      var299 = (var298.next);
                      // Here was a goto statement
                      phi283 = var299;
                      continue L1290103884;
                     } else {
                      // line number 1306
                      // Here was a goto statement
                      break If_1117_0;
                     }
                    } else {
                     // line number 1302
                     // Here was a goto statement
                     break If_1117_0;
                    }
                   }
                  }
                 }
                }
                // line number 1297
                phi273 = ((phi273 + 1)) | 0;
                // Here was a goto statement
                continue L1609472596;
               }
              }
             } else {
              phi232 = var203;
              phi233 = var205;
              phi234 = var206;
              phi235 = var207;
              break If_926_0;
             }
            }
           }
           // line number 1273
           var236 = phi35;
           var236.V$setEnabled$Z(0);
           // line number 1274
           var237 = phi234;
           var238 = (var237.m_sweep);
           var239 = phi8;
           var240 = (var239.backup1);
           var241 = (org$jbox2d$common$Sweep.prototype.Lorg$jbox2d$common$Sweep$$set$Lorg$jbox2d$common$Sweep$.call(var238,var240));
           // line number 1275
           var242 = phi235;
           var243 = (var242.m_sweep);
           var244 = phi8;
           var245 = (var244.backup2);
           var246 = (org$jbox2d$common$Sweep.prototype.Lorg$jbox2d$common$Sweep$$set$Lorg$jbox2d$common$Sweep$.call(var243,var245));
           // line number 1276
           var247 = phi234;
           org$jbox2d$dynamics$Body.prototype.V$synchronizeTransform$$.call(var247);
           // line number 1277
           var248 = phi235;
           org$jbox2d$dynamics$Body.prototype.V$synchronizeTransform$$.call(var248);
           // line number 1278
           // Here was a goto statement
           phi23 = phi35;
           continue L80348506;
          } else {
           break If_794_1;
          }
         }
        }
        // line number 1249
        var201 = phi8;
        var201.m_stepComplete = 1;
        // line number 1250
        // Here was a goto statement
        break If_794_0;
       }
       // line number 1408
       return;
      } else {
       // line number 1156
       var39 = phi37;
       var40 = (org$jbox2d$dynamics$contacts$Contact.prototype.Z$isEnabled$$.call(var39));
       If_161_0: {
        if (var40 != 0) {
         // line number 1161
         var43 = phi37;
         var44 = (var43.m_toiCount);
         var45 = (bytecoder.cmp(var44,8.0)) | 0;
         if (var45 <= 0) {
          // line number 1165
          // line number 1166
          var46 = phi37;
          var47 = ((var46.m_flags)) | 0;
          var48 = ((var47 & 32)) | 0;
          If_209_0: {
           if (var48 == 0) {
            // line number 1170
            var57 = phi37;
            var58 = (org$jbox2d$dynamics$contacts$Contact.prototype.Lorg$jbox2d$dynamics$Fixture$$getFixtureA$$.call(var57));
            // line number 1171
            var59 = phi37;
            var60 = (org$jbox2d$dynamics$contacts$Contact.prototype.Lorg$jbox2d$dynamics$Fixture$$getFixtureB$$.call(var59));
            // line number 1174
            var61 = (org$jbox2d$dynamics$Fixture.prototype.Z$isSensor$$.call(var58));
            if (var61 != 0) {
             break If_161_0;
            } else {
             var62 = var60;
             var63 = (org$jbox2d$dynamics$Fixture.prototype.Z$isSensor$$.call(var62));
             if (var63 == 0) {
              // line number 1178
              var64 = (org$jbox2d$dynamics$Fixture.prototype.Lorg$jbox2d$dynamics$Body$$getBody$$.call(var58));
              // line number 1179
              var65 = (org$jbox2d$dynamics$Fixture.prototype.Lorg$jbox2d$dynamics$Body$$getBody$$.call(var60));
              // line number 1181
              var66 = (var64.m_type);
              // line number 1182
              var67 = (var65.m_type);
              // line number 1183
              org$jbox2d$dynamics$World.$i;
              var68 = (org$jbox2d$dynamics$World.$assertionsDisabled);
              If_304_0: {
               if (var68 != 0) {
                phi74 = 1.0;
                phi75 = var58;
                phi76 = var60;
                phi77 = var64;
                phi78 = var65;
                phi79 = var66;
                phi80 = var67;
                break If_304_0;
               } else {
                var69 = var66;
                org$jbox2d$dynamics$BodyType.$i;
                var70 = (org$jbox2d$dynamics$BodyType.DYNAMIC);
                if (var69 == var70) {
                 phi74 = 1.0;
                 phi75 = var58;
                 phi76 = var60;
                 phi77 = var64;
                 phi78 = var65;
                 phi79 = var66;
                 phi80 = var67;
                 break If_304_0;
                } else {
                 var71 = var67;
                 var72 = (org$jbox2d$dynamics$BodyType.DYNAMIC);
                 if (var71 == var72) {
                  phi74 = 1.0;
                  phi75 = var58;
                  phi76 = var60;
                  phi77 = var64;
                  phi78 = var65;
                  phi79 = var66;
                  phi80 = var67;
                  break If_304_0;
                 } else {
                  var73 = new java$lang$AssertionError();
                  java$lang$AssertionError.prototype.V$$init$$$.call(var73);
                  throw bytecoder.registerStack(var73, new Error().stack);
                 }
                }
               }
              }
              // line number 1185
              var81 = phi77;
              var82 = (org$jbox2d$dynamics$Body.prototype.Z$isAwake$$.call(var81));
              If_346_0: {
               If_346_1: {
                if (var82 == 0) {
                 break If_346_1;
                } else {
                 var83 = phi79;
                 org$jbox2d$dynamics$BodyType.$i;
                 var84 = (org$jbox2d$dynamics$BodyType.STATIC);
                 if (var83 == var84) {
                  break If_346_1;
                 } else {
                  var85 = (1) | 0;
                  // Here was a goto statement
                  phi86 = (var85) | 0;
                  break If_346_0;
                 }
                }
               }
               phi86 = (0) | 0;
               break If_346_0;
              }
              var87 = (phi86) | 0;
              // line number 1186
              var88 = phi78;
              var89 = (org$jbox2d$dynamics$Body.prototype.Z$isAwake$$.call(var88));
              If_373_0: {
               If_373_1: {
                if (var89 == 0) {
                 phi196 = (var87) | 0;
                 break If_373_1;
                } else {
                 var90 = phi80;
                 org$jbox2d$dynamics$BodyType.$i;
                 var91 = (org$jbox2d$dynamics$BodyType.STATIC);
                 if (var90 == var91) {
                  phi196 = (var87) | 0;
                  break If_373_1;
                 } else {
                  var92 = (1) | 0;
                  // Here was a goto statement
                  phi93 = (var87) | 0;
                  phi94 = (var92) | 0;
                  break If_373_0;
                 }
                }
               }
               phi93 = (phi196) | 0;
               phi94 = (0) | 0;
               break If_373_0;
              }
              var95 = (phi94) | 0;
              // line number 1189
              var96 = (phi93) | 0;
              If_398_0: {
               if (var96 != 0) {
                phi98 = (var95) | 0;
                break If_398_0;
               } else {
                var97 = (var95) | 0;
                if (var97 != 0) {
                 phi98 = (var95) | 0;
                 break If_398_0;
                } else {
                 // line number 1190
                 // Here was a goto statement
                 break If_161_0;
                }
               }
              }
              // line number 1193
              var99 = phi77;
              var100 = (org$jbox2d$dynamics$Body.prototype.Z$isBullet$$.call(var99));
              If_418_0: {
               If_418_1: {
                if (var100 != 0) {
                 break If_418_1;
                } else {
                 var101 = phi79;
                 org$jbox2d$dynamics$BodyType.$i;
                 var102 = (org$jbox2d$dynamics$BodyType.DYNAMIC);
                 if (var101 == var102) {
                  phi103 = (0) | 0;
                  break If_418_0;
                 } else {
                  break If_418_1;
                 }
                }
               }
               // Here was a goto statement
               phi103 = (1) | 0;
               break If_418_0;
              }
              var104 = (phi103) | 0;
              // line number 1194
              var105 = phi78;
              var106 = (org$jbox2d$dynamics$Body.prototype.Z$isBullet$$.call(var105));
              If_445_0: {
               If_445_1: {
                if (var106 != 0) {
                 phi109 = (var104) | 0;
                 break If_445_1;
                } else {
                 var107 = phi80;
                 org$jbox2d$dynamics$BodyType.$i;
                 var108 = (org$jbox2d$dynamics$BodyType.DYNAMIC);
                 if (var107 == var108) {
                  phi109 = (var104) | 0;
                  phi110 = (0) | 0;
                  break If_445_0;
                 } else {
                  phi109 = (var104) | 0;
                  break If_445_1;
                 }
                }
               }
               // Here was a goto statement
               phi110 = (1) | 0;
               break If_445_0;
              }
              var111 = (phi110) | 0;
              // line number 1197
              var112 = (phi109) | 0;
              If_470_0: {
               if (var112 != 0) {
                phi114 = (var111) | 0;
                break If_470_0;
               } else {
                var113 = (var111) | 0;
                if (var113 != 0) {
                 phi114 = (var111) | 0;
                 break If_470_0;
                } else {
                 // line number 1198
                 // Here was a goto statement
                 break If_161_0;
                }
               }
              }
              // line number 1203
              var115 = phi77;
              var116 = (var115.m_sweep);
              var117 = (var116.alpha0);
              // line number 1205
              var118 = phi77;
              var119 = (var118.m_sweep);
              var120 = (var119.alpha0);
              var121 = phi78;
              var122 = (var121.m_sweep);
              var123 = (var122.alpha0);
              var124 = (bytecoder.cmp(var120,var123)) | 0;
              If_514_0: {
               if (var124 >= 0) {
                // line number 1208
                var184 = phi78;
                var185 = (var184.m_sweep);
                var186 = (var185.alpha0);
                var187 = phi77;
                var188 = (var187.m_sweep);
                var189 = (var188.alpha0);
                var190 = (bytecoder.cmp(var186,var189)) | 0;
                if (var190 >= 0) {
                 phi130 = var117;
                 break If_514_0;
                } else {
                 // line number 1209
                 var191 = phi77;
                 var192 = (var191.m_sweep);
                 var193 = (var192.alpha0);
                 // line number 1210
                 var194 = phi78;
                 var195 = (var194.m_sweep);
                 org$jbox2d$common$Sweep.prototype.V$advance$F.call(var195,var193);
                 phi130 = var193;
                 break If_514_0;
                }
               } else {
                // line number 1206
                var125 = phi78;
                var126 = (var125.m_sweep);
                var127 = (var126.alpha0);
                // line number 1207
                var128 = phi77;
                var129 = (var128.m_sweep);
                org$jbox2d$common$Sweep.prototype.V$advance$F.call(var129,var127);
                // Here was a goto statement
                phi130 = var127;
                break If_514_0;
               }
              }
              // line number 1213
              var131 = (org$jbox2d$dynamics$World.$assertionsDisabled);
              If_544_0: {
               if (var131 != 0) {
                break If_544_0;
               } else {
                var132 = phi130;
                var133 = (bytecoder.cmp(var132,1.0)) | 0;
                if (var133 < 0) {
                 break If_544_0;
                } else {
                 var134 = new java$lang$AssertionError();
                 java$lang$AssertionError.prototype.V$$init$$$.call(var134);
                 throw bytecoder.registerStack(var134, new Error().stack);
                }
               }
              }
              // line number 1215
              var135 = phi37;
              var136 = ((org$jbox2d$dynamics$contacts$Contact.prototype.I$getChildIndexA$$.call(var135))) | 0;
              // line number 1216
              var137 = phi37;
              var138 = ((org$jbox2d$dynamics$contacts$Contact.prototype.I$getChildIndexB$$.call(var137))) | 0;
              // line number 1219
              var139 = phi8;
              var140 = (var139.toiInput);
              // line number 1220
              var141 = (var140.proxyA);
              var142 = phi75;
              var143 = (org$jbox2d$dynamics$Fixture.prototype.Lorg$jbox2d$collision$shapes$Shape$$getShape$$.call(var142));
              org$jbox2d$collision$Distance$DistanceProxy.prototype.V$set$Lorg$jbox2d$collision$shapes$Shape$$I.call(var141,var143,var136);
              // line number 1221
              var144 = (var140.proxyB);
              var145 = phi76;
              var146 = (org$jbox2d$dynamics$Fixture.prototype.Lorg$jbox2d$collision$shapes$Shape$$getShape$$.call(var145));
              org$jbox2d$collision$Distance$DistanceProxy.prototype.V$set$Lorg$jbox2d$collision$shapes$Shape$$I.call(var144,var146,var138);
              // line number 1222
              var147 = (var140.sweepA);
              var148 = phi77;
              var149 = (var148.m_sweep);
              var150 = (org$jbox2d$common$Sweep.prototype.Lorg$jbox2d$common$Sweep$$set$Lorg$jbox2d$common$Sweep$.call(var147,var149));
              // line number 1223
              var151 = (var140.sweepB);
              var152 = phi78;
              var153 = (var152.m_sweep);
              var154 = (org$jbox2d$common$Sweep.prototype.Lorg$jbox2d$common$Sweep$$set$Lorg$jbox2d$common$Sweep$.call(var151,var153));
              // line number 1224
              var140.tMax = 1.0;
              // line number 1226
              var155 = phi8;
              var156 = (var155.pool);
              var157 = (var156.Lorg$jbox2d$collision$TimeOfImpact$$getTimeOfImpact$$());
              var158 = phi8;
              var159 = (var158.toiOutput);
              org$jbox2d$collision$TimeOfImpact.prototype.V$timeOfImpact$Lorg$jbox2d$collision$TimeOfImpact$TOIOutput$$Lorg$jbox2d$collision$TimeOfImpact$TOIInput$.call(var157,var159,var140);
              // line number 1229
              var160 = phi8;
              var161 = (var160.toiOutput);
              var162 = (var161.t);
              // line number 1230
              var163 = phi8;
              var164 = (var163.toiOutput);
              var165 = (var164.state);
              org$jbox2d$collision$TimeOfImpact$TOIOutputState.$i;
              var166 = (org$jbox2d$collision$TimeOfImpact$TOIOutputState.TOUCHING);
              If_677_0: {
               if (var165 != var166) {
                // line number 1233
                var183 = 1.0;
                phi173 = var183;
                phi174 = (var136) | 0;
                phi175 = (var138) | 0;
                phi176 = var140;
                phi177 = var162;
                break If_677_0;
               } else {
                // line number 1231
                var167 = phi130;
                var168 = phi130;
                var169 = (1.0 - var168);
                var170 = (var169 * var162);
                var171 = (var167 + var170);
                org$jbox2d$common$MathUtils.$i;
                var172 = (org$jbox2d$common$MathUtils.F$min$F$F(var171,1.0));
                // Here was a goto statement
                phi173 = var172;
                phi174 = (var136) | 0;
                phi175 = (var138) | 0;
                phi176 = var140;
                phi177 = var162;
                break If_677_0;
               }
              }
              // line number 1236
              var178 = phi37;
              var179 = phi173;
              var178.m_toi = var179;
              // line number 1237
              var180 = phi37;
              var181 = ((var180.m_flags)) | 0;
              var182 = ((var181 | 32)) | 0;
              var180.m_flags = var182;
              phi51 = phi173;
              break If_209_0;
             } else {
              // line number 1175
              // Here was a goto statement
              break If_161_0;
             }
            }
           } else {
            // line number 1168
            var49 = phi37;
            var50 = (var49.m_toi);
            // Here was a goto statement
            phi51 = var50;
            break If_209_0;
           }
          }
          // line number 1240
          var52 = phi51;
          var53 = phi36;
          var54 = (bytecoder.cmp(var52,var53)) | 0;
          if (var54 >= 0) {
           break If_161_0;
          } else {
           // line number 1242
           var55 = phi37;
           // line number 1243
           var56 = phi51;
           phi35 = var55;
           phi36 = var56;
           break If_161_0;
          }
         } else {
          // line number 1162
          // Here was a goto statement
          break If_161_0;
         }
        } else {
         // line number 1157
         // Here was a goto statement
         break If_161_0;
        }
       }
       // line number 1154
       var41 = phi37;
       var42 = (var41.m_next);
       // Here was a goto statement
       phi37 = var42;
       continue L1522965024;
      }
     }
    }
  }

  V$clearForces$$() {
    // source file is World.java
    var var0 = null;
    var phi1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    // line number 631
    var0 = (this.m_bodyList);
    phi1 = var0;
    L2147235252: while(true) {
     var2 = phi1;
     if (var2 == null) {
      // line number 635
      return;
     } else {
      // line number 632
      var3 = phi1;
      var4 = (var3.m_force);
      org$jbox2d$common$Vec2.prototype.V$setZero$$.call(var4);
      // line number 633
      var5 = phi1;
      var5.m_torque = 0.0;
      // line number 631
      var6 = phi1;
      var7 = (org$jbox2d$dynamics$Body.prototype.Lorg$jbox2d$dynamics$Body$$getNext$$.call(var6));
      // Here was a goto statement
      phi1 = var7;
      continue L2147235252;
     }
    }
  }

  Lorg$jbox2d$dynamics$Body$$getBodyList$$() {
    // source file is World.java
    var var0 = null;
    // line number 772
    var0 = (this.m_bodyList);
    return var0;
  }

  Lorg$jbox2d$dynamics$contacts$Contact$$popContact$Lorg$jbox2d$dynamics$Fixture$$I$Lorg$jbox2d$dynamics$Fixture$$I(arg0,arg1,arg2,arg3) {
    // source file is World.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var0 = arg0;
    var1 = arg2;
    // line number 221
    var2 = (org$jbox2d$dynamics$Fixture.prototype.Lorg$jbox2d$collision$shapes$ShapeType$$getType$$.call(var0));
    // line number 222
    var3 = (org$jbox2d$dynamics$Fixture.prototype.Lorg$jbox2d$collision$shapes$ShapeType$$getType$$.call(var1));
    // line number 224
    var4 = (this.contactStacks);
    var5 = ((var2.I$ordinal$$())) | 0;
    var6 = (var4.data[var5]);
    var7 = ((var3.I$ordinal$$())) | 0;
    var8 = (var6.data[var7]);
    // line number 225
    var9 = (var8.creator);
    // line number 226
    if (var9 == null) {
     // line number 237
     return null;
    } else {
     // line number 227
     var10 = (var8.primary);
     if (var10 == 0) {
      // line number 232
      var15 = (var9.Ljava$lang$Object$$pop$$());
      var16 = var15;
      // line number 233
      var17 = var1;
      var18 = var0;
      var16.V$init$Lorg$jbox2d$dynamics$Fixture$$I$Lorg$jbox2d$dynamics$Fixture$$I(var17,arg3,var18,arg1);
      // line number 234
      return var16;
     } else {
      // line number 228
      var11 = (var9.Ljava$lang$Object$$pop$$());
      var12 = var11;
      // line number 229
      var13 = var0;
      var14 = var1;
      var12.V$init$Lorg$jbox2d$dynamics$Fixture$$I$Lorg$jbox2d$dynamics$Fixture$$I(var13,arg1,var14,arg3);
      // line number 230
      return var12;
     }
    }
  }
}


class org$jbox2d$collision$broadphase$DynamicTreeNode extends java$lang$Object {
  nativeObject = null;

  aabb = null;
  id = 0;
  parent = null;
  height = 0;
  child1 = null;
  child2 = null;
  userData = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$collision$broadphase$DynamicTreeNode,[org$jbox2d$collision$broadphase$DynamicTreeNode,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$I(arg0) {
    // source file is DynamicTreeNode.java
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var0 = (arg0) | 0;
    // line number 59
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 32
    var1 = this;
    var2 = new org$jbox2d$collision$AABB();
    org$jbox2d$collision$AABB.prototype.V$$init$$$.call(var2);
    var1.aabb = var2;
    // line number 59
    var3 = this;
    var3.id = var0;
    return;
  }

  Z$isLeaf$$() {
    // source file is DynamicTreeNode.java
    var var0 = null;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    // line number 45
    var0 = (this.child1);
    If_7_0: {
     if (var0 != null) {
      phi2 = this;
      phi3 = (0) | 0;
      break If_7_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = this;
      phi3 = (var1) | 0;
      break If_7_0;
     }
    }
    return phi3;
  }
}


class org$jbox2d$common$Color3f extends java$lang$Object {
  nativeObject = null;

  x = 0.0;
  y = 0.0;
  z = 0.0;
  static WHITE = null;
  static BLACK = null;
  static BLUE = null;
  static GREEN = null;
  static RED = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$jbox2d$common$Color3f,[org$jbox2d$common$Color3f,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is Color3f.java
    var var0 = null;
    var var1 = .0;
    var var2 = .0;
    var var3 = null;
    var var4 = .0;
    var var5 = .0;
    var var6 = null;
    var var7 = .0;
    var var8 = .0;
    var var9 = null;
    var var10 = .0;
    var var11 = .0;
    var var12 = null;
    var var13 = .0;
    var var14 = .0;
    // line number 57
    org$jbox2d$common$Color3f.$i;
    var0 = new org$jbox2d$common$Color3f();
    var1 = 1.0;
    var2 = 1.0;
    org$jbox2d$common$Color3f.prototype.V$$init$$F$F$F.call(var0,var1,1.0,var2);
    org$jbox2d$common$Color3f.WHITE = var0;
    // line number 58
    var3 = new org$jbox2d$common$Color3f();
    var4 = 0.0;
    var5 = 0.0;
    org$jbox2d$common$Color3f.prototype.V$$init$$F$F$F.call(var3,var4,0.0,var5);
    org$jbox2d$common$Color3f.BLACK = var3;
    // line number 59
    var6 = new org$jbox2d$common$Color3f();
    var7 = 0.0;
    var8 = 1.0;
    org$jbox2d$common$Color3f.prototype.V$$init$$F$F$F.call(var6,var7,0.0,var8);
    org$jbox2d$common$Color3f.BLUE = var6;
    // line number 60
    var9 = new org$jbox2d$common$Color3f();
    var10 = 0.0;
    var11 = 0.0;
    org$jbox2d$common$Color3f.prototype.V$$init$$F$F$F.call(var9,var10,1.0,var11);
    org$jbox2d$common$Color3f.GREEN = var9;
    // line number 61
    var12 = new org$jbox2d$common$Color3f();
    var13 = 1.0;
    var14 = 0.0;
    org$jbox2d$common$Color3f.prototype.V$$init$$F$F$F.call(var12,var13,0.0,var14);
    org$jbox2d$common$Color3f.RED = var12;
    return;
  }

  V$$init$$F$F$F(arg0,arg1,arg2) {
    // source file is Color3f.java
    var var0 = .0;
    var var1 = .0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var0 = arg0;
    var1 = arg2;
    // line number 71
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 72
    var2 = this;
    var2.x = var0;
    // line number 73
    var3 = this;
    var3.y = arg1;
    // line number 74
    var4 = this;
    var4.z = var1;
    // line number 75
    return;
  }

  V$$init$$$() {
    // source file is Color3f.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    // line number 68
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 69
    var0 = this;
    var1 = this;
    var2 = this;
    var2.z = 0.0;
    var1.y = 0.0;
    var0.x = 0.0;
    // line number 70
    return;
  }
}


class org$jbox2d$dynamics$contacts$ContactSolver$ContactSolverDef extends java$lang$Object {
  nativeObject = null;

  step = null;
  contacts = null;
  count = 0;
  positions = null;
  velocities = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt(