const bytecoder = {
    imports: {
        "java.lang.System": {
            J$currentTimeMillis$$: function () {
                return Date.now();
            },
        },
        "java.lang.Object": {
            Ljava$lang$Class$$getClass$$: function (inst) {
                return inst.constructor.$rt;
            },
        },
        "java.lang.NullPointerException": {
            Ljava$lang$String$$getExtendedNPEMessage$$: function(inst) {
                return null;
            }
        },
        "jdk.internal.misc.ScopedMemoryAccess": {
            V$registerNatives$$: function () {
            },
        },
        "java.lang.Float": {
            I$floatToRawIntBits$F: function (value) {
                let fl = new Float32Array(1);
                fl[0] = value;
                let br = new Int32Array(fl.buffer);
                return br[0];
            },
            Z$isNaN$D: function (a) {
                return isNaN(a) ? 1 : 0
            },
            Z$isNaN$F: function (a) {
                return isNaN(a) ? 1 : 0
            },
            Z$isInfinite$F: function (a) {
                return (a === Number.POSITIVE_INFINITY || a === Number.NEGATIVE_INFINITY) ? 1 : 0
            },
            Ljava$lang$String$$toString$F: function (value) {
                let str = value.toString();
                if (str.indexOf(".") < 0) {
                    str += '.0';
                }
                return bytecoder.toBytecoderString(str);
            },
            F$parseFloat$Ljava$lang$String$: function (value) {
                return parseFloat(value.nativeObject);
            },
        },
        "java.lang.Math": {
            I$min$I$I: function (a, b) {
                return Math.min(a, b);
            },
            J$min$J$J: function (a, b) {
                return Math.min(a, b);
            },
            D$min$D$D: function (a, b) {
                return Math.min(a, b);
            },
            F$min$F$F: function (a, b) {
                return Math.min(a, b);
            },
            D$max$D$D: function (a, b) {
                return Math.max(a, b);
            },
            I$max$I$I: function (a, b) {
                return Math.max(a, b);
            },
            J$max$J$J: function (a, b) {
                return Math.max(a, b);
            },
            D$floor$D: function (a) {
                return Math.floor(a);
            },
            F$floor$F: function (a) {
                return Math.floor(a);
            },
            D$ceil$D: function (a) {
                return Math.ceil(a);
            },
            F$ceil$F: function (a) {
                return Math.ceil(a);
            },
            D$toRadians$D: function (a) {
                return a * (Math.PI / 180.0);
            },
            D$toDegrees$D: function (a) {
                return a * (180. / Math.PI);
            },
            D$cos$D: function (a) {
                return Math.cos(a);
            },
            D$sin$D: function (a) {
                return Math.sin(a);
            },
            D$tan$D: function (a) {
                return Math.tan(a);
            },
            D$sqrt$D: function (a) {
                return Math.sqrt(a);
            },
            D$cbrt$D: function (a) {
                return Math.cbrt(a);
            },
            D$log$D: function (a) {
                return Math.log(a);
            },
            D$random$$: function () {
                return Math.random();
            },
        },
        "java.lang.StrictMath": {
            D$sqrt$D: function (a) {
                return Math.sqrt(a);
            },
            I$round$F: function(a) {
                return Math.round(a);
            },
            D$sin$D: function(a) {
                return Math.sin(a);
            },
            D$cos$D: function(a) {
                return Math.sin(a);
            }
        },
        "java.lang.reflect.Array": {
            Ljava$lang$Object$$newArray$Ljava$lang$Class$$I: function (t, l) {
                return bytecoder.newarray(l, null);
            },
        },
        "jdk.internal.misc.CDS": {
            Z$isDumpingClassList0$$: function () {
                return 0;
            },
            Z$isDumpingArchive0$$: function () {
                return 0;
            },
            Z$isSharingEnabled0$$: function () {
                return 0;
            },
            V$initializeFromArchive$Ljava$lang$Class$: function (cls) {
            },
            J$getRandomSeedForDumping$$: function(cls) {
                return Math.trunc(Math.random() * 10000000);
            },
        },
        "java.io.UnixFileSystem": {
            I$getBooleanAttributes0$Ljava$lang$String$: function (fsref, path) {
                let jsPath = bytecoder.toJSString(path);
                try {
                    let request = new XMLHttpRequest();
                    request.open('HEAD', jsPath, false);
                    request.send(null);
                    if (request.status === 200) {
                        let length = request.getResponseHeader('content-length');
                        return 0x01;
                    }
                    return 0;
                } catch (e) {
                    return 0;
                }
            },
        },
        "java.lang.Class": {
            Ljava$lang$ClassLoader$$getClassLoader$$: function (classRef) {
                return null;
            },
            Ljava$lang$Class$$forName$Ljava$lang$String$$Z$Ljava$lang$ClassLoader$: function(className, initialize, classLoader) {
                throw 'Not supported class for reflective access';
            },
            Z$desiredAssertionStatus$$: function(classRef) {
                return false;
            }
        },
        "java.io.FileInputStream": {
            I$open0$Ljava$io$FileDescriptor$$Ljava$lang$String$: function (fis, fdd, name) {
                let fd = bytecoder.openForRead(bytecoder.toJSString(name));
                if (fd >= 0) {
                    bytecoder.exports["setFileDescriptorHandle"].call(fdd, fd);
                }
                return fd;
            },
            J$skip0$Ljava$io$FileDescriptor$$I: function (fis, fdd, amount) {
                let fd = bytecoder.exports["getFileDescriptorHandle"].call(fdd);
                let x = bytecoder.filehandles[fd];
                return x.J$skip0$I(fd, amount);
            },
            I$available0$Ljava$io$FileDescriptor$: function (fis, fdd) {
                let fd = bytecoder.exports["getFileDescriptorHandle"].call(fdd);
                let x = bytecoder.filehandles[fd];
                return x.I$available0$$(fd);
            },
            I$read0$Ljava$io$FileDescriptor$: function (fis, fdd) {
                let fd = bytecoder.exports["getFileDescriptorHandle"].call(fdd);
                let x = bytecoder.filehandles[fd];
                return x.I$read0$$(fd);
            },
            I$readBytes$Ljava$io$FileDescriptor$$$B$I$I: function (fis, fdd, b, off, len) {
                let fd = bytecoder.exports["getFileDescriptorHandle"].call(fdd);
                let x = bytecoder.filehandles[fd];
                return x.I$readBytes$$B$I$I(fd, b, off, len);
            },
        },
        "java.io.FileOutputStream": {
            V$writeBytes$Ljava$io$FileDescriptor$$$B$I$I: function (fis, fdd, b, off, len) {
                let fd = bytecoder.exports["getFileDescriptorHandle"].call(fdd);
                let x = bytecoder.filehandles[fd];
                x.V$writeBytes$$B$I$I(fd, b, off, len);
            },
            V$writeInt$Ljava$io$FileDescriptor$$I: function (fis, fdd, cp) {
                let fd = bytecoder.exports["getFileDescriptorHandle"].call(fdd);
                let x = bytecoder.filehandles[fd];
                x.V$writeInt$I(fd, cp);
            },
            V$close0$Ljava$io$FileDescriptor$: function(fis, fdd) {
                let fd = bytecoder.exports["getFileDescriptorHandle"].call(fdd);
                bytecoder.filehandles[fd] = null;
            }
        },
        "de.mirkosertic.bytecoder.classlib.BytecoderCharsetDecoder": {
            $C$decodeFromBytes$Ljava$lang$String$$$B: function (decoder, charsetName, data) {
                let targetCharacterSet = charsetName.nativeObject;
                let byteData = new Uint8Array(data.data);
                let dec = new TextDecoder(targetCharacterSet);

                let str = dec.decode(byteData);

                let charArray = bytecoder.newarray(str.length, 0);
                for (let i = 0; i < str.length; i++) {
                    charArray.data[i] = str.codePointAt(i);
                }
                return charArray;
            },
        },
        "de.mirkosertic.bytecoder.classlib.BytecoderCharsetEncoder": {
            $B$encodeToBytes$Ljava$lang$String$$$C: function (encoder, charsetName, data) {
                let str = '';
                for (var i = 0; i < data.data.length; i++) {
                    str += String.fromCodePoint(data.data[i]);
                }

                let targetCharacterSet = charsetName.nativeObject;
                if (targetCharacterSet !== 'UTF-8') {
                    throw 'Not supported character set!';
                }

                let enc = new TextEncoder();
                let byteData = enc.encode(str);

                let bytes = bytecoder.newarray(byteData.length, 0);
                for (var i = 0; i < byteData.length; i++) {
                    bytes.data[i] = byteData[i];
                }

                return bytes;
            },
        },
        "java.lang.StringBuffer": {
            V$initializeWith$I: function (buffer, size) {
                buffer.nativeObject = '';
            },
            Ljava$lang$StringBuffer$$append$Ljava$lang$String$: function (buffer, str) {
                buffer.nativeObject += str.nativeObject;
            },
            Ljava$lang$String$$toString$$: function (buffer) {
                return bytecoder.toBytecoderString(buffer.nativeObject);
            },
        },
        "java.lang.StringBuilder": {
            V$initializeWith$I: function (builder, size) {
                builder.nativeObject = '';
            },
            Ljava$lang$StringBuilder$$append$Ljava$lang$String$: function (builder, str) {
                builder.nativeObject += str.nativeObject;
                return builder;
            },
            Ljava$lang$StringBuilder$$append$Ljava$lang$CharSequence$$I$I: function (builder, str, start, end) {
                builder.nativeObject += str.nativeObject.substring(start, end);
                return builder;
            },
            Ljava$lang$String$$toString$$: function (builder) {
                return bytecoder.toBytecoderString(builder.nativeObject);
            },
            I$length$$: function (builder) {
                return builder.nativeObject.length;
            },
            V$setLength$I: function (builder, size) {
            },
            Ljava$lang$StringBuilder$$append$$C$I$I: function (builder, chars, offset, count) {
                for (let i = offset; i < offset + count; i++) {
                    builder.nativeObject += String.fromCodePoint(chars.data[i]);
                }
                return builder;
            },
            Ljava$lang$StringBuilder$$deleteCharAt$I: function(builder, index) {
                const current = builder.nativeObject;
                builder.nativeObject = current.slice(0, index) + current.slice(index + 1);
                return builder;
            },
            V$setCharAt$I$C: function(builder, index, char) {
                const current = builder.nativeObject;
                builder.nativeObject = current.slice(0, index) + String.fromCodePoint(char) + current.slice(index + 1);
            },
            Ljava$lang$StringBuilder$$insert$I$C: function(builder, index, char) {
                const current = builder.nativeObject;
                builder.nativeObject = current.slice(0, index) + String.fromCodePoint(char) + current.slice(index);
                return builder
            },
            C$charAt$I: function(builder, index) {
                const current = builder.nativeObject;
                return current.codePointAt(index);
            }
        },
        "java.lang.String": {
            C$charAt$I: function (str, index) {
                return str.nativeObject.codePointAt(index);
            },
            I$length$$: function (str) {
                return str.nativeObject.length;
            },
            V$getChars$I$I$$C$I: function (str, srcBegin, srcEnd, dst, dstBegin) {
                let dstOffset = dstBegin;
                let s = str.nativeObject;
                for (let i = srcBegin; i < srcEnd; i++) {
                    dst.data[dstOffset] = s.codePointAt(i);
                    dstOffset++;
                }
            },
            I$indexOf$I: function (str, cp) {
                if (cp >= 0) {
                    return str.nativeObject.indexOf(String.fromCodePoint(cp));
                }
                return -1;
            },
            I$lastIndexOf$I: function (str, cp) {
                if (cp >= 0) {
                    const a = bytecoder.toJSString(str);
                    return a.lastIndexOf(String.fromCodePoint(cp));
                }
                return -1;
            },
            Z$startsWith$Ljava$lang$String$: function (str, otherstr) {
                const a = bytecoder.toJSString(str);
                const b = bytecoder.toJSString(otherstr);
                if (a.startsWith(b)) {
                    return 1;
                }
                return 0;
            },
            Z$endsWith$Ljava$lang$String$: function (str, otherstr) {
                const a = bytecoder.toJSString(str);
                const b = bytecoder.toJSString(otherstr);
                if (a.endsWith(b)) {
                    return 1;
                }
                return 0;
            },
            Ljava$lang$String$$replaceAll$Ljava$lang$String$$Ljava$lang$String$(str, regex, replacement) {
                return str;
            },
            I$lastIndexOf$Ljava$lang$String$: function (str, s) {
                return str.nativeObject.lastIndexOf(s.nativeObject);
            },
            Ljava$lang$String$$trim$$: function (str) {
                return bytecoder.toBytecoderString(str.nativeObject.trim());
            },
            Ljava$lang$String$$substring$I: function(str, i) {
                return bytecoder.toBytecoderString(str.nativeObject.substring(i));
            },
            Ljava$lang$String$$substring$I$I: function(str, i, b) {
                return bytecoder.toBytecoderString(str.nativeObject.substring(i, b));
            },
            Ljava$lang$String$$repeat$I: function (str, amount) {
                return bytecoder.toBytecoderString(str.nativeObject.repeat(amount));
            },
            Z$equals0$Ljava$lang$String$: function (str, otherstr) {
                if (str.nativeObject === otherstr.nativeObject) {
                    return 1;
                }
                return 0;
            },
            Z$equalsIgnoreCase$Ljava$lang$String$: function (str, otherstr) {
                if (str == null) {
                    return 0;
                }
                if (otherstr == null) {
                    return 0;
                }
                if (str.nativeObject.toUpperCase() === otherstr.nativeObject.toUpperCase()) {
                    return 1;
                }
                return 0;
            },
            V$initializeWith$$C$I$I: function (str, chars, offset, count) {
                str.nativeObject = '';
                for (let i = offset; i < offset + count; i++) {
                    str.nativeObject += String.fromCodePoint(chars.data[i]);
                }
            },
            V$initializeWith$$I$I$I: function (str, points, offset, count) {
                str.nativeObject = '';
                for (let i = offset; i < offset + count; i++) {
                    str.nativeObject += String.fromCodePoint(points.data[i]);
                }
            },
            $C$toCharArray$$: function (str) {
                let arr = bytecoder.newarray(str.nativeObject.length, 0);
                for (let i = 0; i < str.nativeObject.length; i++) {
                    arr.data[i] = str.nativeObject.codePointAt(i);
                }
                return arr;
            },
            V$initializeWith$Ljava$lang$String$: function (str, otherstr) {
                str.nativeObject = otherstr.nativeObject;
            },
            V$initializeWith$$B$I$I$B: function(str, bytes, index, count, coder) {
                const arr = new Uint8Array(bytecoder.exports.byteArrayLength(bytes))
                for (var i = index; i < index + count; i++) {
                    arr[i - index] = bytecoder.exports.getByteArrayEntry(bytes, i);
                }
                const jsstr = new TextDecoder().decode(arr);
                str.nativeObject = jsstr;
            },
            $B$getBytes$$: function(str) {
                const jsstr = str.nativeObject;
                const bytes = new TextEncoder().encode(jsstr);

                const arr = bytecoder.exports.newByteArray(bytes.length);
                for (var i = 0; i < bytes.length; i++) {
                    bytecoder.exports.setByteArrayEntry(arr, i, bytes[i]);
                }

                return arr;
            },
            Ljava$lang$String$$toUpperCase$$: function(str) {
                return bytecoder.toBytecoderString(str.nativeObject.toUpperCase());
            },
            Ljava$lang$String$$toLowerCase$$: function(str) {
                return bytecoder.toBytecoderString(str.nativeObject.toLowerCase());
            }
        },
        "java.lang.Character": {
            Z$isDigit$C: function (char) {
                if ("0123456789".indexOf(String.fromCodePoint(char)) >= 0) {
                    return 1;
                }
                return 0;
            },
            Z$isLowerCase$C: function (char) {
                let str = String.fromCodePoint(char);
                if (str.toLowerCase() === str) {
                    return 1;
                }
                return 0;
            },
            Z$isUpperCase$C: function (char) {
                let str = String.fromCodePoint(char);
                if (str.toUpperCase() === str) {
                    return 1;
                }
                return 0;
            },
            C$toLowerCase$C: function (char) {
                let str = String.fromCodePoint(char).toLowerCase();
                return str.codePointAt(0);
            },
            C$toUpperCase$C: function (char) {
                let str = String.fromCodePoint(char).toUpperCase();
                return str.codePointAt(0);
            },
            I$digit$C$I: function (char, radix) {
                let str = String.fromCodePoint(char).toUpperCase();
                if ('0' === str) {
                    return 0;
                }
                if ('1' === str) {
                    return 1;
                }
                if ('2' === str) {
                    return 2;
                }
                if ('3' === str) {
                    return 3;
                }
                if ('4' === str) {
                    return 4;
                }
                if ('5' === str) {
                    return 5;
                }
                if ('6' === str) {
                    return 6;
                }
                if ('7' === str) {
                    return 7;
                }
                if ('8' === str) {
                    return 8;
                }
                if ('9' === str) {
                    return 9;
                }
                if ('A' === str) {
                    return 10;
                }
                if ('B' === str) {
                    return 11;
                }
                if ('C' === str) {
                    return 12;
                }
                if ('D' === str) {
                    return 13;
                }
                if ('E' === str) {
                    return 14;
                }
                if ('15' === str) {
                    return 15;
                }
                return -1;
            },
            Ljava$lang$String$$toString$C: function (char) {
                return bytecoder.toBytecoderString(String.fromCodePoint(char));
            },
        },
        "java.lang.Byte": {
            Ljava$lang$String$$toString$B$I: function (value, radix) {
                return bytecoder.toBytecoderString(value.toString(radix));
            },
            B$parseByte$Ljava$lang$String$: function (str) {
                return parseInt(str.nativeObject);Ljava$lang$String$$replaceAll$Ljava$lang$String$$Ljava$lang$String$
            },
        },
        "java.lang.Short": {
            Ljava$lang$String$$toString$S$I: function (value, radix) {
                return bytecoder.toBytecoderString(value.toString(radix));
            },
            S$parseShort$Ljava$lang$String$$I: function (value, radix) {
                return parseInt(value.nativeObject, radix);
            },
        },
        "java.lang.Integer": {
            Ljava$lang$String$$toString$I$I: function (value, radix) {
                return bytecoder.toBytecoderString(value.toString(radix));
            },
            Ljava$lang$String$$toHexString$I: function (value) {
                return bytecoder.toBytecoderString(value.toString(16));
            },
            I$parseInt$Ljava$lang$String$$I: function (value, radix) {
                return parseInt(value.nativeObject, radix);
            },
        },
        "java.lang.Long": {
            Ljava$lang$String$$toString$J$I: function (value, radix) {
                return bytecoder.toBytecoderString(value.toString(radix));
            },
            J$parseLong$Ljava$lang$String$$I: function (value, radix) {
                return parseInt(value.nativeObject, radix);
            },
        },
        "java.lang.Double": {
            Ljava$lang$String$$toString$D: function (value) {
                let str = value.toString();
                if (str.indexOf(".") < 0) {
                    str += '.0';
                }
                return bytecoder.toBytecoderString(str);
            },
            D$parseDouble$Ljava$lang$String$: function (str) {
                return parseFloat(str.nativeObject);
            },
            Z$isNaN$D: function (d) {
                return isNaN(d) ? 1 : 0;
            },
            Z$isInfinite$D: function (d) {
                return isFinite(d) ? 1 : 0;
            }
        },
        "runtime": {
            nativeconsole: function() {
                return console;
            },
            nativewindow: function() {
                return window;
            },
            nativedocument: function() {
                return document;
            }
        },
        "de.mirkosertic.bytecoder.api.web.OpaqueArrays": {
            Lde$mirkosertic$bytecoder$api$web$FloatArray$$createFloatArray$I: function(length) {
                return new Float32Array(length);
            },
            'Lde$mirkosertic$bytecoder$api$web$IntArray$$createIntArray$I': function(length) {
                return new Int32Array(length);
            },
            'Lde$mirkosertic$bytecoder$api$web$Int16Array$$createInt16Array$I': function(length) {
                return new Int16Array(length);
            },
            'Lde$mirkosertic$bytecoder$api$web$Int8Array$$createInt8Array$I': function(length) {
                return new Int8Array(length);
            },
            'Lde$mirkosertic$bytecoder$api$web$OpaqueReferenceArray$$createObjectArray$$': function(length) {
                return [];
            }
        },
    },
    exports: {},
    filehandles : [],
    stringconstants: [],
    generated: [],
    cmp: function(a,b) {
        if (a > b) return 1;
        if (a < b) return -1;
        return 0;
    },
    instanceOf: function(a,b) {
        if (a) {
            let rt = a.constructor.$rt;
            return rt.instanceOf(a, b);
        }
        return 0;
    },
    registerStack: function(exception, stack) {
        exception.stack = stack;
        return exception;
    },
    toJSString: function(str) {
        if (str) {
            return str.nativeObject;
        }
        return '';
    },
    newarray: function(len, defaultvalue) {
        let x = new de$mirkosertic$bytecoder$classlib$Array();
        x.data = new Array(len);
        x.data.fill(defaultvalue);
        return x;
    },
    toBytecoderString: function(jsstring) {
        const x = new java$lang$String();
        x.V$$init$$$.call(x);
        x.nativeObject = jsstring;
        return x;
    },
    toBytecoderBoolean: function(v) {
        return v ? 1: 0;
    },
    instanceWithLambdaImpl: function(instType, lambdaImpl) {
        let inst = new instType();
        inst.$lambdaimpl = lambdaImpl.bind(inst);
        return inst;
    },
    primitives: {
        byte: {
        },
        char: {
        },
        short: {
        },
        int: {
        },
        float: {
        },
        double: {
        },
        long: {
        },
        boolean: {
        },
        void: {
        }
    },
    openForRead :  function(path) {
        try {
            let request = new XMLHttpRequest();
            request.open('GET',path,false);
            request.overrideMimeType('text/plain; charset=x-user-defined');
            request.send(null);
            if (request.status === 200) {
                let length = request.getResponseHeader('content-length');
                let responsetext = request.response;
                let buf = new ArrayBuffer(responsetext.length);
                let bufView = new Uint8Array(buf);
                let i = 0;
                const strLen = responsetext.length;
                for (; i < strLen; i++) {
                    bufView[i] = responsetext.charCodeAt(i) & 0xff;
                }
                let handle = bytecoder.filehandles.length;
                bytecoder.filehandles[handle] = {
                    currentpos: 0,
                    data: bufView,
                    size: length,
                    J$skip0$I: function(fd, amount) {
                        let remaining = this.size - this.currentpos;
                        let possible = Math.min(remaining, amount);
                        this.currentpos += possible;
                        return possible;
                    },
                    I$available0$$: function(fd) {
                        return this.size - this.currentpos;
                    },
                    I$read0$$: function(fd) {
                        return this.data[this.currentpos++];
                    },
                    I$readBytes$$B$I$I: function(fd, target, offset, length) {
                        if (length === 0) {return 0;}
                        let remaining = this.size - this.currentpos;
                        let possible = Math.min(remaining, length);
                        if (possible === 0) {return -1;}
                        for (let j=0; j<possible; j++) {
                            target.data[offset++] = this.data[this.currentpos++];
                        }
                        return possible;
                    }
                };
                return handle;
            }
            return -1;
        } catch(e) {
            return -1;
        }
    },
    newRuntimeClassFor: function(type,supportedtypes) {
        return {
            Ljava$lang$ClassLoader$$getClassLoader$$: function() {
                return null;
            },
            Ljava$lang$ClassLoader$$getClassLoader0$$: function() {
                return null;
            },
            Z$desiredAssertionStatus$$: function() {
                return false;
            },
            Ljava$lang$Object$$newInstance$$: function() {
                const x = new type.$i();
                x.V$$init$$$();
                return x;
            },
            $Ljava$lang$Object$$getEnumConstants$$: function() {
                return type.$i.$VALUES;
            },
            instanceOf: function(a, b) {
                if (supportedtypes.includes(b)) {
                    return 1;
                }
                return 0;
            },
        };
    },
    wrapNativeIntoTypeInstance: function(instType, value) {
        let inst = new instType();
        inst.nativeObject = value;
        return inst;
    }
};

bytecoder.filehandles[1] = {
    V$writeBytes$$B$I$I: function(fd, b, off, len) {
        let decoder = new TextDecoder();
        let arr = new Uint8Array(b.data.slice(off, off +  len));
        console.log(decoder.decode(arr).replace('\n', ''));
    },
    V$writeInt$I: function(fd, cp) {
        let decoder = new TextDecoder();
        let arr = new Uint8Array([cp]);
        console.log(decoder.decode(arr).replace('\n', ''));
    },
};

bytecoder.imports["java.lang.Class"]["Ljava$lang$Class$$forName$Ljava$lang$String$$Z$Ljava$lang$ClassLoader$"] = function(className, initialize, classLoader) {
  throw 'Not supported class for reflective access';
};


class java$lang$Object {
  nativeObject = null;
  constructor() {
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Object,[java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  Ljava$lang$String$$toString$$() {
    // source file is Object.java
    // line number 36
    return bytecoder.stringconstants[1];
  }

  Z$equals$Ljava$lang$Object$(arg0) {
    // source file is Object.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var phi3 = null;
    var phi4 = null;
    var phi5 = 0;
    var0 = arg0;
    // line number 40
    var1 = var0;
    If_9_0: {
     if (this != var1) {
      phi3 = this;
      phi4 = var0;
      phi5 = (0) | 0;
      break If_9_0;
     } else {
      var2 = (1) | 0;
      // Here was a goto statement
      phi3 = this;
      phi4 = var0;
      phi5 = (var2) | 0;
      break If_9_0;
     }
    }
    return phi5;
  }

  V$$init$$$() {
    // source file is Object.java
    return;
  }

  I$hashCode$$() {
    // source file is Object.java
    // line number 44
    return 0;
  }
}


class java$util$RandomAccess extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$RandomAccess,[java$util$RandomAccess,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class org$luaj$vm2$UpValue extends java$lang$Object {
  nativeObject = null;

  array = null;
  index = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$UpValue,[java$lang$Object,org$luaj$vm2$UpValue]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$Lorg$luaj$vm2$LuaValue$$I(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    java$lang$Object.prototype.V$$init$$$.call(this);
    var1 = this;
    var1.array = var0;
    var2 = this;
    var2.index = arg1;
    return;
  }

  Ljava$lang$String$$toString$$() {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = 0;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var0 = new java$lang$StringBuffer();
    java$lang$StringBuffer.prototype.V$$init$$$.call(var0);
    var1 = ((this.index)) | 0;
    var2 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var0,var1));
    var3 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var2,bytecoder.stringconstants[140]));
    var4 = (this.array);
    var5 = (var4.data.length) | 0;
    var6 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var3,var5));
    var7 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var6,bytecoder.stringconstants[141]));
    var8 = (this.array);
    var9 = ((this.index)) | 0;
    var10 = (var8.data[var9]);
    var11 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$Object$.call(var7,var10));
    var12 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var11));
    return var12;
  }

  V$close$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var var5 = null;
    var var6 = 0;
    var var7 = null;
    var0 = (this.array);
    var1 = this;
    var2 = bytecoder.newarray((1),null);
    var3 = (0) | 0;
    var4 = ((this.index)) | 0;
    var5 = (var0.data[var4]);
    var2.data[var3] = var5;
    var1.array = var2;
    var6 = ((this.index)) | 0;
    var0.data[var6] = null;
    var7 = this;
    var7.index = 0;
    return;
  }

  V$setValue$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var0 = arg0;
    var1 = (this.array);
    var2 = ((this.index)) | 0;
    var1.data[var2] = var0;
    return;
  }

  Lorg$luaj$vm2$LuaValue$$getValue$$() {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var0 = (this.array);
    var1 = ((this.index)) | 0;
    var2 = (var0.data[var1]);
    return var2;
  }
}


class java$lang$Class extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Class,[java$lang$Object,java$lang$Class]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  static Ljava$lang$Class$$getPrimitiveClass$Ljava$lang$String$(arg0) {
    // source file is Class.java
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = null;
    var var8 = null;
    var var9 = 0;
    var var10 = null;
    var var11 = null;
    var var12 = 0;
    var var13 = null;
    var var14 = null;
    var var15 = 0;
    var var16 = null;
    var var17 = null;
    var var18 = 0;
    var var19 = null;
    var var20 = null;
    var var21 = 0;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    // line number 124
    var0 = (java$lang$String.prototype.Z$equals$Ljava$lang$Object$.call(bytecoder.stringconstants[33],arg0));
    if (var0 == 0) {
     // line number 127
     var2 = arg0;
     var3 = (java$lang$String.prototype.Z$equals$Ljava$lang$Object$.call(bytecoder.stringconstants[34],var2));
     if (var3 == 0) {
      // line number 130
      var5 = arg0;
      var6 = (java$lang$String.prototype.Z$equals$Ljava$lang$Object$.call(bytecoder.stringconstants[35],var5));
      if (var6 == 0) {
       // line number 133
       var8 = arg0;
       var9 = (java$lang$String.prototype.Z$equals$Ljava$lang$Object$.call(bytecoder.stringconstants[36],var8));
       if (var9 == 0) {
        // line number 136
        var11 = arg0;
        var12 = (java$lang$String.prototype.Z$equals$Ljava$lang$Object$.call(bytecoder.stringconstants[37],var11));
        if (var12 == 0) {
         // line number 139
         var14 = arg0;
         var15 = (java$lang$String.prototype.Z$equals$Ljava$lang$Object$.call(bytecoder.stringconstants[38],var14));
         if (var15 == 0) {
          // line number 142
          var17 = arg0;
          var18 = (java$lang$String.prototype.Z$equals$Ljava$lang$Object$.call(bytecoder.stringconstants[39],var17));
          if (var18 == 0) {
           // line number 145
           var20 = arg0;
           var21 = (java$lang$String.prototype.Z$equals$Ljava$lang$Object$.call(bytecoder.stringconstants[3],var20));
           if (var21 == 0) {
            // line number 148
            var23 = new java$lang$RuntimeException();
            var24 = arg0;
            java$lang$RuntimeException.prototype.V$$init$$Ljava$lang$String$.call(var23,var24);
            throw bytecoder.registerStack(var23, new Error().stack);
           } else {
            // line number 146
            var22 = bytecoder.primitives.boolean;
            return var22;
           }
          } else {
           // line number 143
           var19 = bytecoder.primitives.long;
           return var19;
          }
         } else {
          // line number 140
          var16 = bytecoder.primitives.double;
          return var16;
         }
        } else {
         // line number 137
         var13 = bytecoder.primitives.float;
         return var13;
        }
       } else {
        // line number 134
        var10 = bytecoder.primitives.int;
        return var10;
       }
      } else {
       // line number 131
       var7 = bytecoder.primitives.short;
       return var7;
      }
     } else {
      // line number 128
      var4 = bytecoder.primitives.char;
      return var4;
     }
    } else {
     // line number 125
     var1 = bytecoder.primitives.byte;
     return var1;
    }
  }

  Z$desiredAssertionStatus$$() {
    return bytecoder.imports['java.lang.Class'].Z$desiredAssertionStatus$$(this);
  }

  $Ljava$lang$reflect$Type$$getGenericInterfaces$$() {
    // source file is Class.java
    var var0 = null;
    // line number 178
    var0 = bytecoder.newarray((0),null);
    return var0;
  }

  Ljava$lang$String$$getName$$() {
    return bytecoder.imports['java.lang.Class'].Ljava$lang$String$$getName$$(this);
  }

  V$$init$$$() {
    // source file is Class.java
    // line number 35
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }

  I$hashCode$$() {
    // source file is Class.java
    // line number 281
    return 42;
  }
}


class jdk$internal$access$JavaIOPrintStreamAccess extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(jdk$internal$access$JavaIOPrintStreamAccess,[java$lang$Object,jdk$internal$access$JavaIOPrintStreamAccess]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class java$lang$ref$Reference extends java$lang$Object {
  nativeObject = null;

  referent = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$ref$Reference,[java$lang$Object,java$lang$ref$Reference]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  Ljava$lang$Object$$get$$() {
    // source file is Reference.java
    var var0 = null;
    // line number 40
    var0 = (this.referent);
    return var0;
  }

  static V$reachabilityFence$Ljava$lang$Object$(arg0) {
    // source file is Reference.java
    // line number 48
    return;
  }
}


class java$lang$Cloneable extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Cloneable,[java$lang$Object,java$lang$Cloneable]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class java$util$function$Function extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$function$Function,[java$lang$Object,java$util$function$Function]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.Ljava$lang$Object$$apply$Ljava$lang$Object$ = impl;
  }
}


class org$luaj$vm2$compiler$LexState$SemInfo extends java$lang$Object {
  nativeObject = null;

  r = null;
  ts = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$compiler$LexState$SemInfo,[java$lang$Object,org$luaj$vm2$compiler$LexState$SemInfo]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Lorg$luaj$vm2$compiler$LexState$1$(arg0) {
    var var0 = null;
    var0 = arg0;
    org$luaj$vm2$compiler$LexState$SemInfo.prototype.V$$init$$$.call(this);
    return;
  }

  V$$init$$$() {
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class java$io$Serializable extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$io$Serializable,[java$lang$Object,java$io$Serializable]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class java$lang$System extends java$lang$Object {
  nativeObject = null;

  static PROPERTIES = null;
  static in = null;
  static out = null;
  static err = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$System,[java$lang$Object,java$lang$System]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is System.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    // line number 33
    java$util$Properties.$i;
    var0 = new java$util$Properties();
    java$util$Properties.prototype.V$$init$$$.call(var0);
    java$lang$System.$i;
    java$lang$System.PROPERTIES = var0;
    // line number 34
    var1 = (java$lang$System.PROPERTIES);
    var2 = bytecoder.stringconstants[43];
    var3 = (java$util$Properties.prototype.Ljava$lang$Object$$setProperty$Ljava$lang$String$$Ljava$lang$String$.call(var1,bytecoder.stringconstants[42],var2));
    // line number 37
    var4 = new java$io$FileInputStream();
    java$io$FileDescriptor.$i;
    var5 = (java$io$FileDescriptor.in);
    java$io$FileInputStream.prototype.V$$init$$Ljava$io$FileDescriptor$.call(var4,var5);
    java$lang$System.in = var4;
    // line number 39
    java$io$PrintStream.$i;
    var6 = new java$io$PrintStream();
    var7 = new java$io$FileOutputStream();
    var8 = (java$io$FileDescriptor.out);
    java$io$FileOutputStream.prototype.V$$init$$Ljava$io$FileDescriptor$.call(var7,var8);
    java$io$PrintStream.prototype.V$$init$$Ljava$io$OutputStream$.call(var6,var7);
    java$lang$System.out = var6;
    // line number 41
    var9 = new java$io$PrintStream();
    var10 = new java$io$FileOutputStream();
    var11 = (java$io$FileDescriptor.err);
    java$io$FileOutputStream.prototype.V$$init$$Ljava$io$FileDescriptor$.call(var10,var11);
    java$io$PrintStream.prototype.V$$init$$Ljava$io$OutputStream$.call(var9,var10);
    java$lang$System.err = var9;
    return;
  }

  static Ljava$lang$String$$getProperty$Ljava$lang$String$(arg0) {
    // source file is System.java
    var var0 = null;
    var var1 = null;
    // line number 114
    java$lang$System.$i;
    var0 = (java$lang$System.PROPERTIES);
    var1 = (java$util$Properties.prototype.Ljava$lang$String$$getProperty$Ljava$lang$String$.call(var0,arg0));
    return var1;
  }

  static J$nanoTime$$() {
    // source file is System.java
    var var0 = 0;
    var var1 = 0;
    // line number 44
    java$lang$System.$i;
    var0 = (java$lang$System.J$currentTimeMillis$$());
    var1 = (var0 * 1000000);
    return var1;
  }

  static J$currentTimeMillis$$() {
    return bytecoder.imports['java.lang.System'].J$currentTimeMillis$$();
  }

  static I$identityHashCode$Ljava$lang$Object$(arg0) {
    // source file is System.java
    var var0 = 0;
    // line number 106
    var0 = ((arg0.I$hashCode$$())) | 0;
    return var0;
  }

  static V$arraycopy$$B$I$$B$I$I(arg0,arg1,arg2,arg3,arg4) {
    // source file is System.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    var phi4 = null;
    var phi5 = 0;
    var phi6 = 0;
    var phi7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = null;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = null;
    var var15 = 0;
    var var16 = 0;
    var var17 = 0;
    var var18 = 0;
    var0 = (arg1) | 0;
    var1 = (arg3) | 0;
    // line number 56
    phi2 = arg0;
    phi3 = (var0) | 0;
    phi4 = arg2;
    phi5 = (var1) | 0;
    phi6 = (arg4) | 0;
    phi7 = (0) | 0;
    L1245992125: while(true) {
     var8 = (phi7) | 0;
     var9 = (phi6) | 0;
     if (var8 >= var9) {
      // line number 59
      return;
     } else {
      // line number 57
      var10 = phi4;
      var11 = (phi5) | 0;
      var12 = (phi7) | 0;
      var13 = ((var11 + var12)) | 0;
      var14 = phi2;
      var15 = (phi3) | 0;
      var16 = (phi7) | 0;
      var17 = ((var15 + var16)) | 0;
      var18 = (var14.data[var17]);
      var10.data[var13] = var18;
      // line number 56
      phi7 = ((phi7 + 1)) | 0;
      // Here was a goto statement
      continue L1245992125;
     }
    }
  }

  V$$init$$$() {
    // source file is System.java
    // line number 28
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }

  static V$arraycopy$Ljava$lang$Object$$I$Ljava$lang$Object$$I$I(arg0,arg1,arg2,arg3,arg4) {
    // source file is System.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var phi6 = 0;
    var phi7 = 0;
    var phi8 = 0;
    var phi9 = null;
    var phi10 = null;
    var phi11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = null;
    var var15 = 0;
    var var16 = 0;
    var var17 = 0;
    var var18 = null;
    var var19 = 0;
    var var20 = 0;
    var var21 = 0;
    var var22 = null;
    var0 = (arg1) | 0;
    var1 = (arg3) | 0;
    // line number 98
    var2 = arg0;
    var3 = var2;
    // line number 99
    var4 = arg2;
    var5 = var4;
    // line number 100
    phi6 = (var0) | 0;
    phi7 = (var1) | 0;
    phi8 = (arg4) | 0;
    phi9 = var3;
    phi10 = var5;
    phi11 = (0) | 0;
    L379343824: while(true) {
     var12 = (phi11) | 0;
     var13 = (phi8) | 0;
     if (var12 >= var13) {
      // line number 103
      return;
     } else {
      // line number 101
      var14 = phi10;
      var15 = (phi7) | 0;
      var16 = (phi11) | 0;
      var17 = ((var15 + var16)) | 0;
      var18 = phi9;
      var19 = (phi6) | 0;
      var20 = (phi11) | 0;
      var21 = ((var19 + var20)) | 0;
      var22 = (var18.data[var21]);
      var14.data[var17] = var22;
      // line number 100
      phi11 = ((phi11 + 1)) | 0;
      // Here was a goto statement
      continue L379343824;
     }
    }
  }

  static Ljava$lang$String$$lineSeparator$$() {
    // source file is System.java
    // line number 130
    return bytecoder.stringconstants[181];
  }

  static V$arraycopy$$C$I$$C$I$I(arg0,arg1,arg2,arg3,arg4) {
    // source file is System.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    var phi4 = null;
    var phi5 = 0;
    var phi6 = 0;
    var phi7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = null;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = null;
    var var15 = 0;
    var var16 = 0;
    var var17 = 0;
    var var18 = 0;
    var0 = (arg1) | 0;
    var1 = (arg3) | 0;
    // line number 50
    phi2 = arg0;
    phi3 = (var0) | 0;
    phi4 = arg2;
    phi5 = (var1) | 0;
    phi6 = (arg4) | 0;
    phi7 = (0) | 0;
    L1216568433: while(true) {
     var8 = (phi7) | 0;
     var9 = (phi6) | 0;
     if (var8 >= var9) {
      // line number 53
      return;
     } else {
      // line number 51
      var10 = phi4;
      var11 = (phi5) | 0;
      var12 = (phi7) | 0;
      var13 = ((var11 + var12)) | 0;
      var14 = phi2;
      var15 = (phi3) | 0;
      var16 = (phi7) | 0;
      var17 = ((var15 + var16)) | 0;
      var18 = (var14.data[var17]);
      var10.data[var13] = var18;
      // line number 50
      phi7 = ((phi7 + 1)) | 0;
      // Here was a goto statement
      continue L1216568433;
     }
    }
  }

  static V$arraycopy$$I$I$$I$I$I(arg0,arg1,arg2,arg3,arg4) {
    // source file is System.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    var phi4 = null;
    var phi5 = 0;
    var phi6 = 0;
    var phi7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = null;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = null;
    var var15 = 0;
    var var16 = 0;
    var var17 = 0;
    var var18 = 0;
    var0 = (arg1) | 0;
    var1 = (arg3) | 0;
    // line number 74
    phi2 = arg0;
    phi3 = (var0) | 0;
    phi4 = arg2;
    phi5 = (var1) | 0;
    phi6 = (arg4) | 0;
    phi7 = (0) | 0;
    L1233453421: while(true) {
     var8 = (phi7) | 0;
     var9 = (phi6) | 0;
     if (var8 >= var9) {
      // line number 77
      return;
     } else {
      // line number 75
      var10 = phi4;
      var11 = (phi5) | 0;
      var12 = (phi7) | 0;
      var13 = ((var11 + var12)) | 0;
      var14 = phi2;
      var15 = (phi3) | 0;
      var16 = (phi7) | 0;
      var17 = ((var15 + var16)) | 0;
      var18 = ((var14.data[var17])) | 0;
      var10.data[var13] = var18;
      // line number 74
      phi7 = ((phi7 + 1)) | 0;
      // Here was a goto statement
      continue L1233453421;
     }
    }
  }
}


class org$luaj$vm2$compiler$LexState$expdesc extends java$lang$Object {
  nativeObject = null;

  u = null;
  t = null;
  f = null;
  k = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$compiler$LexState$expdesc,[java$lang$Object,org$luaj$vm2$compiler$LexState$expdesc]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    java$lang$Object.prototype.V$$init$$$.call(this);
    var0 = this;
    var1 = new org$luaj$vm2$compiler$LexState$expdesc$U();
    org$luaj$vm2$compiler$LexState$expdesc$U.prototype.V$$init$$$.call(var1);
    var0.u = var1;
    var2 = this;
    var3 = new org$luaj$vm2$compiler$IntPtr();
    org$luaj$vm2$compiler$IntPtr.prototype.V$$init$$$.call(var3);
    var2.t = var3;
    var4 = this;
    var5 = new org$luaj$vm2$compiler$IntPtr();
    org$luaj$vm2$compiler$IntPtr.prototype.V$$init$$$.call(var5);
    var4.f = var5;
    return;
  }

  V$init$I$I(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var0 = (arg0) | 0;
    var1 = (this.f);
    var1.i = -1;
    var2 = (this.t);
    var2.i = -1;
    var3 = this;
    var3.k = var0;
    var4 = (this.u);
    var4.info = arg1;
    return;
  }

  Z$hasjumps$$() {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var phi5 = null;
    var phi6 = 0;
    var0 = (this.t);
    var1 = ((var0.i)) | 0;
    var2 = (this.f);
    var3 = ((var2.i)) | 0;
    If_14_0: {
     if (var1 == var3) {
      phi5 = this;
      phi6 = (0) | 0;
      break If_14_0;
     } else {
      var4 = (1) | 0;
      // Here was a goto statement
      phi5 = this;
      phi6 = (var4) | 0;
      break If_14_0;
     }
    }
    return phi6;
  }

  Z$isnumeral$$() {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var phi8 = null;
    var phi9 = 0;
    var phi10 = null;
    var0 = ((this.k)) | 0;
    If_6_0: {
     If_6_1: {
      if (var0 != 5) {
       phi10 = this;
       break If_6_1;
      } else {
       var1 = this;
       var2 = (var1.t);
       var3 = ((var2.i)) | 0;
       if (var3 != -1) {
        phi10 = this;
        break If_6_1;
       } else {
        var4 = this;
        var5 = (var4.f);
        var6 = ((var5.i)) | 0;
        if (var6 != -1) {
         phi10 = this;
         break If_6_1;
        } else {
         var7 = (1) | 0;
         // Here was a goto statement
         phi8 = this;
         phi9 = (var7) | 0;
         break If_6_0;
        }
       }
      }
     }
     phi8 = phi10;
     phi9 = (0) | 0;
     break If_6_0;
    }
    return phi9;
  }

  V$setvalue$Lorg$luaj$vm2$compiler$LexState$expdesc$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = 0;
    var var16 = null;
    var var17 = null;
    var var18 = 0;
    var var19 = null;
    var var20 = null;
    var var21 = 0;
    var var22 = null;
    var var23 = null;
    var var24 = 0;
    var0 = arg0;
    var1 = (this.f);
    var2 = (var0.f);
    var3 = ((var2.i)) | 0;
    var1.i = var3;
    var4 = this;
    var5 = ((var0.k)) | 0;
    var4.k = var5;
    var6 = (this.t);
    var7 = (var0.t);
    var8 = ((var7.i)) | 0;
    var6.i = var8;
    var9 = (this.u);
    var10 = (var0.u);
    var11 = (org$luaj$vm2$compiler$LexState$expdesc$U.Lorg$luaj$vm2$LuaValue$$access$200$Lorg$luaj$vm2$compiler$LexState$expdesc$U$(var10));
    var12 = (org$luaj$vm2$compiler$LexState$expdesc$U.Lorg$luaj$vm2$LuaValue$$access$202$Lorg$luaj$vm2$compiler$LexState$expdesc$U$$Lorg$luaj$vm2$LuaValue$(var9,var11));
    var13 = (this.u);
    var14 = (var0.u);
    var15 = (var14.ind_idx);
    var13.ind_idx = var15;
    var16 = (this.u);
    var17 = (var0.u);
    var18 = (var17.ind_t);
    var16.ind_t = var18;
    var19 = (this.u);
    var20 = (var0.u);
    var21 = (var20.ind_vt);
    var19.ind_vt = var21;
    var22 = (this.u);
    var23 = (var0.u);
    var24 = ((var23.info)) | 0;
    var22.info = var24;
    return;
  }
}


class java$io$Flushable extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$io$Flushable,[java$lang$Object,java$io$Flushable]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class java$nio$charset$CoderResult$Cache extends java$lang$Object {
  nativeObject = null;

  unmappable = null;
  malformed = null;
  static INSTANCE = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$nio$charset$CoderResult$Cache,[java$lang$Object,java$nio$charset$CoderResult$Cache]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is CoderResult.java
    var var0 = null;
    // line number 194
    java$nio$charset$CoderResult$Cache.$i;
    var0 = new java$nio$charset$CoderResult$Cache();
    java$nio$charset$CoderResult$Cache.prototype.V$$init$$$.call(var0);
    java$nio$charset$CoderResult$Cache.INSTANCE = var0;
    return;
  }

  V$$init$$$() {
    // source file is CoderResult.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    // line number 195
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 197
    var0 = this;
    var1 = new java$util$concurrent$ConcurrentHashMap();
    java$util$concurrent$ConcurrentHashMap.prototype.V$$init$$$.call(var1);
    var0.unmappable = var1;
    // line number 198
    var2 = this;
    var3 = new java$util$concurrent$ConcurrentHashMap();
    java$util$concurrent$ConcurrentHashMap.prototype.V$$init$$$.call(var3);
    var2.malformed = var3;
    // line number 195
    return;
  }
}


class org$luaj$vm2$compiler$LexState$Token extends java$lang$Object {
  nativeObject = null;

  seminfo = null;
  token = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$compiler$LexState$Token,[java$lang$Object,org$luaj$vm2$compiler$LexState$Token]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Lorg$luaj$vm2$compiler$LexState$1$(arg0) {
    var var0 = null;
    var0 = arg0;
    org$luaj$vm2$compiler$LexState$Token.prototype.V$$init$$$.call(this);
    return;
  }

  V$$init$$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    java$lang$Object.prototype.V$$init$$$.call(this);
    var0 = this;
    var1 = new org$luaj$vm2$compiler$LexState$SemInfo();
    var2 = null;
    org$luaj$vm2$compiler$LexState$SemInfo.prototype.V$$init$$Lorg$luaj$vm2$compiler$LexState$1$.call(var1,var2);
    var0.seminfo = var1;
    return;
  }

  V$set$Lorg$luaj$vm2$compiler$LexState$Token$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var0 = this;
    var1 = arg0;
    var2 = ((var1.token)) | 0;
    var0.token = var2;
    var3 = (var0.seminfo);
    var4 = (arg0.seminfo);
    var5 = (var4.r);
    var3.r = var5;
    var6 = (var0.seminfo);
    var7 = (arg0.seminfo);
    var8 = (var7.ts);
    var6.ts = var8;
    return;
  }
}


class java$nio$charset$CoderResult extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;
  static names = null;
  type = 0;
  length = 0;
  static UNDERFLOW = null;
  static OVERFLOW = null;
  static malformed4 = null;
  static unmappable4 = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$nio$charset$CoderResult,[java$lang$Object,java$nio$charset$CoderResult]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is CoderResult.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = null;
    var var9 = 0;
    var var10 = null;
    var var11 = 0;
    var var12 = null;
    var var13 = 0;
    var var14 = null;
    var var15 = 0;
    var var16 = 0;
    var var17 = null;
    var var18 = 0;
    var var19 = 0;
    var var20 = null;
    var var21 = 0;
    var var22 = 0;
    var var23 = null;
    var var24 = 0;
    var var25 = null;
    var var26 = 0;
    var var27 = null;
    var var28 = 0;
    var var29 = null;
    var var30 = 0;
    var var31 = null;
    var var32 = 0;
    var var33 = null;
    var var34 = 0;
    // line number 84
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(java$nio$charset$CoderResult.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    java$nio$charset$CoderResult.$i;
    java$nio$charset$CoderResult.$assertionsDisabled = phi2;
    // line number 92
    var3 = bytecoder.newarray((4),null);
    var4 = (0) | 0;
    var3.data[var4] = bytecoder.stringconstants[89];
    var5 = (1) | 0;
    var3.data[var5] = bytecoder.stringconstants[90];
    var6 = (2) | 0;
    var3.data[var6] = bytecoder.stringconstants[91];
    var7 = (3) | 0;
    var3.data[var7] = bytecoder.stringconstants[92];
    java$nio$charset$CoderResult.names = var3;
    // line number 183
    var8 = new java$nio$charset$CoderResult();
    var9 = (0) | 0;
    java$nio$charset$CoderResult.prototype.V$$init$$I$I.call(var8,var9,0);
    java$nio$charset$CoderResult.UNDERFLOW = var8;
    // line number 190
    var10 = new java$nio$charset$CoderResult();
    var11 = (1) | 0;
    java$nio$charset$CoderResult.prototype.V$$init$$I$I.call(var10,var11,0);
    java$nio$charset$CoderResult.OVERFLOW = var10;
    // line number 201
    var12 = bytecoder.newarray((4),null);
    var13 = (0) | 0;
    var14 = new java$nio$charset$CoderResult();
    var15 = (2) | 0;
    java$nio$charset$CoderResult.prototype.V$$init$$I$I.call(var14,var15,1);
    var12.data[var13] = var14;
    var16 = (1) | 0;
    var17 = new java$nio$charset$CoderResult();
    var18 = (2) | 0;
    java$nio$charset$CoderResult.prototype.V$$init$$I$I.call(var17,var18,2);
    var12.data[var16] = var17;
    var19 = (2) | 0;
    var20 = new java$nio$charset$CoderResult();
    var21 = (2) | 0;
    java$nio$charset$CoderResult.prototype.V$$init$$I$I.call(var20,var21,3);
    var12.data[var19] = var20;
    var22 = (3) | 0;
    var23 = new java$nio$charset$CoderResult();
    var24 = (4) | 0;
    java$nio$charset$CoderResult.prototype.V$$init$$I$I.call(var23,2,var24);
    var12.data[var22] = var23;
    java$nio$charset$CoderResult.malformed4 = var12;
    // line number 226
    var25 = bytecoder.newarray((4),null);
    var26 = (0) | 0;
    var27 = new java$nio$charset$CoderResult();
    var28 = (1) | 0;
    java$nio$charset$CoderResult.prototype.V$$init$$I$I.call(var27,3,var28);
    var25.data[var26] = var27;
    var29 = new java$nio$charset$CoderResult();
    var30 = (2) | 0;
    java$nio$charset$CoderResult.prototype.V$$init$$I$I.call(var29,3,var30);
    var25.data[1] = var29;
    var31 = new java$nio$charset$CoderResult();
    var32 = (3) | 0;
    java$nio$charset$CoderResult.prototype.V$$init$$I$I.call(var31,3,var32);
    var25.data[2] = var31;
    var33 = new java$nio$charset$CoderResult();
    var34 = (4) | 0;
    java$nio$charset$CoderResult.prototype.V$$init$$I$I.call(var33,3,var34);
    var25.data[3] = var33;
    java$nio$charset$CoderResult.unmappable4 = var25;
    return;
  }

  V$$init$$I$I(arg0,arg1) {
    // source file is CoderResult.java
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var0 = (arg0) | 0;
    // line number 98
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 99
    var1 = this;
    var1.type = var0;
    // line number 100
    var2 = this;
    var2.length = arg1;
    // line number 101
    return;
  }

  Z$isOverflow$$() {
    // source file is CoderResult.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    // line number 128
    var0 = ((this.type)) | 0;
    If_8_0: {
     if (var0 != 1) {
      phi2 = this;
      phi3 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = this;
      phi3 = (var1) | 0;
      break If_8_0;
     }
    }
    return phi3;
  }

  Z$isUnderflow$$() {
    // source file is CoderResult.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    // line number 119
    var0 = ((this.type)) | 0;
    If_7_0: {
     if (var0 != 0) {
      phi2 = this;
      phi3 = (0) | 0;
      break If_7_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = this;
      phi3 = (var1) | 0;
      break If_7_0;
     }
    }
    return phi3;
  }

  static Ljava$nio$charset$CoderResult$$malformedForLength$I(arg0) {
    // source file is CoderResult.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    // line number 218
    if (arg0 > 0) {
     // line number 220
     var2 = (4) | 0;
     if (arg0 > var2) {
      // line number 222
      java$nio$charset$CoderResult$Cache.$i;
      var7 = (java$nio$charset$CoderResult$Cache.INSTANCE);
      var8 = (var7.malformed);
      java$lang$Integer.$i;
      var9 = (java$lang$Integer.Ljava$lang$Integer$$valueOf$I(arg0));
      var10 = bytecoder.instanceWithLambdaImpl(java$util$function$Function, function(arg0) { return java$nio$charset$CoderResult.Ljava$nio$charset$CoderResult$$lambda$malformedForLength$0$Ljava$lang$Integer$.call(this, arg0);});
      var11 = (var8.Ljava$lang$Object$$computeIfAbsent$Ljava$lang$Object$$Ljava$util$function$Function$(var9,var10));
      var12 = var11;
      return var12;
     } else {
      // line number 221
      java$nio$charset$CoderResult.$i;
      var3 = (java$nio$charset$CoderResult.malformed4);
      var4 = (1) | 0;
      var5 = ((arg0 - var4)) | 0;
      var6 = (var3.data[var5]);
      return var6;
     }
    } else {
     // line number 219
     var0 = new java$lang$IllegalArgumentException();
     var1 = bytecoder.stringconstants[95];
     java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var0,var1);
     throw bytecoder.registerStack(var0, new Error().stack);
    }
  }

  static Ljava$nio$charset$CoderResult$$lambda$malformedForLength$0$Ljava$lang$Integer$(arg0) {
    // source file is CoderResult.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    // line number 223
    java$nio$charset$CoderResult.$i;
    var0 = new java$nio$charset$CoderResult();
    var1 = (2) | 0;
    var2 = ((java$lang$Integer.prototype.I$intValue$$.call(arg0))) | 0;
    java$nio$charset$CoderResult.prototype.V$$init$$I$I.call(var0,var1,var2);
    return var0;
  }

  Z$isMalformed$$() {
    // source file is CoderResult.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    // line number 148
    var0 = ((this.type)) | 0;
    If_8_0: {
     if (var0 != 2) {
      phi2 = this;
      phi3 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = this;
      phi3 = (var1) | 0;
      break If_8_0;
     }
    }
    return phi3;
  }

  I$length$$() {
    // source file is CoderResult.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    // line number 173
    var0 = (java$nio$charset$CoderResult.prototype.Z$isError$$.call(this));
    if (var0 != 0) {
     // line number 175
     var2 = ((this.length)) | 0;
     return var2;
    } else {
     // line number 174
     var1 = new java$lang$UnsupportedOperationException();
     java$lang$UnsupportedOperationException.prototype.V$$init$$$.call(var1);
     throw bytecoder.registerStack(var1, new Error().stack);
    }
  }

  Z$isError$$() {
    // source file is CoderResult.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    // line number 138
    var0 = ((this.type)) | 0;
    If_8_0: {
     if (var0 < 2) {
      phi2 = this;
      phi3 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = this;
      phi3 = (var1) | 0;
      break If_8_0;
     }
    }
    return phi3;
  }

  Z$isUnmappable$$() {
    // source file is CoderResult.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    // line number 159
    var0 = ((this.type)) | 0;
    If_8_0: {
     if (var0 != 3) {
      phi2 = this;
      phi3 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = this;
      phi3 = (var1) | 0;
      break If_8_0;
     }
    }
    return phi3;
  }

  Ljava$lang$String$$toString$$() {
    // source file is CoderResult.java
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var phi11 = null;
    var phi12 = null;
    var phi13 = null;
    // line number 109
    java$nio$charset$CoderResult.$i;
    var0 = (java$nio$charset$CoderResult.names);
    var1 = ((this.type)) | 0;
    var2 = (var0.data[var1]);
    // line number 110
    var3 = (java$nio$charset$CoderResult.prototype.Z$isError$$.call(this));
    If_20_0: {
     if (var3 == 0) {
      phi11 = this;
      phi12 = var2;
      phi13 = var2;
      break If_20_0;
     } else {
      var4 = new java$lang$StringBuilder();
      java$lang$StringBuilder.prototype.V$$init$$$.call(var4);
      var5 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var4,var2));
      var6 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var5,bytecoder.stringconstants[115]));
      var7 = ((this.length)) | 0;
      var8 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var6,var7));
      var9 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var8,bytecoder.stringconstants[116]));
      var10 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var9));
      // Here was a goto statement
      phi11 = this;
      phi12 = var2;
      phi13 = var10;
      break If_20_0;
     }
    }
    return phi13;
  }

  V$throwException$$() {
    // source file is CoderResult.java
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    // line number 271
    var0 = ((this.type)) | 0;
    if ((var0) >= 0 && (var0) <= 3) switch ((var0) - 0) {
     case 0: {
      // line number 272
      var7 = new java$nio$BufferUnderflowException();
      java$nio$BufferUnderflowException.prototype.V$$init$$$.call(var7);
      throw bytecoder.registerStack(var7, new Error().stack);
     }
     case 1: {
      // line number 273
      var6 = new java$nio$BufferOverflowException();
      java$nio$BufferOverflowException.prototype.V$$init$$$.call(var6);
      throw bytecoder.registerStack(var6, new Error().stack);
     }
     case 2: {
      // line number 274
      var4 = new java$nio$charset$MalformedInputException();
      var5 = ((this.length)) | 0;
      java$nio$charset$MalformedInputException.prototype.V$$init$$I.call(var4,var5);
      throw bytecoder.registerStack(var4, new Error().stack);
     }
     case 3: {
      // line number 275
      var1 = new java$nio$charset$UnmappableCharacterException();
      var2 = this;
      var3 = ((var2.length)) | 0;
      java$nio$charset$UnmappableCharacterException.prototype.V$$init$$I.call(var1,var3);
      throw bytecoder.registerStack(var1, new Error().stack);
     }
    } else {
     // line number 277
     java$nio$charset$CoderResult.$i;
     var8 = (java$nio$charset$CoderResult.$assertionsDisabled);
     if (var8 != 0) {
      // line number 279
      return;
     } else {
      var9 = new java$lang$AssertionError();
      java$lang$AssertionError.prototype.V$$init$$$.call(var9);
      throw bytecoder.registerStack(var9, new Error().stack);
     }
    }
  }
}


class jdk$internal$misc$VM extends java$lang$Object {
  nativeObject = null;

  static lock = null;
  static directMemory = 0;
  static initLevel = 0;
  static savedProps = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(jdk$internal$misc$VM,[java$lang$Object,jdk$internal$misc$VM]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is VM.java
    var var0 = null;
    var var1 = null;
    // line number 37
    var0 = new java$lang$Object();
    java$lang$Object.prototype.V$$init$$$.call(var0);
    jdk$internal$misc$VM.$i;
    jdk$internal$misc$VM.lock = var0;
    // line number 76
    jdk$internal$misc$VM.directMemory = 67108864;
    // line number 183
    var1 = new java$util$HashMap();
    java$util$HashMap.prototype.V$$init$$$.call(var1);
    jdk$internal$misc$VM.V$saveProperties$Ljava$util$Map$(var1);
    // line number 184
    return;
  }

  static V$saveProperties$Ljava$util$Map$(arg0) {
    // source file is VM.java
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var phi4 = null;
    // line number 113
    jdk$internal$misc$VM.$i;
    var0 = ((jdk$internal$misc$VM.I$initLevel$$())) | 0;
    if (var0 == 0) {
     // line number 118
     var3 = (jdk$internal$misc$VM.savedProps);
     If_31_0: {
      if (var3 != null) {
       phi4 = arg0;
       break If_31_0;
      } else {
       // line number 119
       jdk$internal$misc$VM.savedProps = arg0;
       phi4 = arg0;
       break If_31_0;
      }
     }
     // line number 121
     return;
    } else {
     // line number 114
     var1 = new java$lang$IllegalStateException();
     var2 = bytecoder.stringconstants[70];
     java$lang$IllegalStateException.prototype.V$$init$$Ljava$lang$String$.call(var1,var2);
     throw bytecoder.registerStack(var1, new Error().stack);
    }
  }

  static I$initLevel$$() {
    // source file is VM.java
    var var0 = 0;
    // line number 49
    jdk$internal$misc$VM.$i;
    var0 = ((jdk$internal$misc$VM.initLevel)) | 0;
    return var0;
  }

  static Z$isBooted$$() {
    // source file is VM.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    // line number 65
    jdk$internal$misc$VM.$i;
    var0 = ((jdk$internal$misc$VM.initLevel)) | 0;
    If_9_0: {
     if (var0 < 4) {
      phi2 = (0) | 0;
      break If_9_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_9_0;
     }
    }
    return phi2;
  }

  V$$init$$$() {
    // source file is VM.java
    // line number 25
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class org$luaj$vm2$Globals$Undumper extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$Globals$Undumper,[java$lang$Object,org$luaj$vm2$Globals$Undumper]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.Lorg$luaj$vm2$Prototype$$undump$Ljava$io$InputStream$$Ljava$lang$String$ = impl;
  }
}


class java$lang$Character extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Character,[java$lang$Object,java$lang$Character]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  static I$compare$C$C(arg0,arg1) {
    // source file is Character.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var0 = arg1;
    // line number 36
    var1 = var0;
    var2 = ((arg0 - var1)) | 0;
    return var2;
  }

  static Ljava$lang$String$$toString$C(arg0) {
    return bytecoder.imports['java.lang.Character'].Ljava$lang$String$$toString$C(arg0);
  }
}


class java$nio$charset$CodingErrorAction extends java$lang$Object {
  nativeObject = null;

  name = null;
  static IGNORE = null;
  static REPLACE = null;
  static REPORT = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$nio$charset$CodingErrorAction,[java$lang$Object,java$nio$charset$CodingErrorAction]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is CodingErrorAction.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    // line number 55
    java$nio$charset$CodingErrorAction.$i;
    var0 = new java$nio$charset$CodingErrorAction();
    var1 = bytecoder.stringconstants[52];
    java$nio$charset$CodingErrorAction.prototype.V$$init$$Ljava$lang$String$.call(var0,var1);
    java$nio$charset$CodingErrorAction.IGNORE = var0;
    // line number 63
    var2 = new java$nio$charset$CodingErrorAction();
    java$nio$charset$CodingErrorAction.prototype.V$$init$$Ljava$lang$String$.call(var2,bytecoder.stringconstants[53]);
    java$nio$charset$CodingErrorAction.REPLACE = var2;
    // line number 72
    var3 = new java$nio$charset$CodingErrorAction();
    java$nio$charset$CodingErrorAction.prototype.V$$init$$Ljava$lang$String$.call(var3,bytecoder.stringconstants[54]);
    java$nio$charset$CodingErrorAction.REPORT = var3;
    return;
  }

  V$$init$$Ljava$lang$String$(arg0) {
    // source file is CodingErrorAction.java
    var var0 = null;
    var var1 = null;
    var0 = arg0;
    // line number 47
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 48
    var1 = this;
    var1.name = var0;
    // line number 49
    return;
  }

  Ljava$lang$String$$toString$$() {
    // source file is CodingErrorAction.java
    var var0 = null;
    // line number 81
    var0 = (this.name);
    return var0;
  }
}


class java$util$Objects extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$Objects,[java$lang$Object,java$util$Objects]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  static Ljava$lang$Object$$requireNonNull$Ljava$lang$Object$(arg0) {
    // source file is Objects.java
    var var0 = null;
    // line number 232
    if (arg0 != null) {
     // line number 234
     return arg0;
    } else {
     // line number 233
     var0 = new java$lang$NullPointerException();
     java$lang$NullPointerException.prototype.V$$init$$$.call(var0);
     throw bytecoder.registerStack(var0, new Error().stack);
    }
  }

  static I$checkFromIndexSize$I$I$I(arg0,arg1,arg2) {
    // source file is Objects.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var0 = (arg1) | 0;
    // line number 437
    var1 = (var0) | 0;
    var2 = null;
    jdk$internal$util$Preconditions.$i;
    var3 = ((jdk$internal$util$Preconditions.I$checkFromIndexSize$I$I$I$Ljava$util$function$BiFunction$(arg0,var1,arg2,var2))) | 0;
    return var3;
  }

  static Z$equals$Ljava$lang$Object$$Ljava$lang$Object$(arg0,arg1) {
    // source file is Objects.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var phi5 = null;
    var phi6 = null;
    var phi7 = 0;
    var phi8 = null;
    var phi9 = null;
    var0 = arg1;
    // line number 64
    var1 = var0;
    If_9_0: {
     If_9_1: {
      if (arg0 == var1) {
       phi5 = arg0;
       phi6 = var0;
       break If_9_1;
      } else {
       var2 = arg0;
       If_13_0: {
        if (var2 == null) {
         phi8 = arg0;
         phi9 = var0;
         break If_13_0;
        } else {
         var3 = arg0;
         var4 = (var3.Z$equals$Ljava$lang$Object$(var0));
         if (var4 == 0) {
          phi8 = arg0;
          phi9 = var0;
          break If_13_0;
         } else {
          phi5 = arg0;
          phi6 = var0;
          break If_9_1;
         }
        }
       }
       phi5 = phi8;
       phi6 = phi9;
       phi7 = (0) | 0;
       break If_9_0;
      }
     }
     // Here was a goto statement
     phi7 = (1) | 0;
     break If_9_0;
    }
    return phi7;
  }

  static I$hashCode$Ljava$lang$Object$(arg0) {
    // source file is Objects.java
    var var0 = null;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    // line number 103
    If_4_0: {
     if (arg0 == null) {
      phi2 = arg0;
      phi3 = (0) | 0;
      break If_4_0;
     } else {
      var0 = arg0;
      var1 = ((var0.I$hashCode$$())) | 0;
      // Here was a goto statement
      phi2 = arg0;
      phi3 = (var1) | 0;
      break If_4_0;
     }
    }
    return phi3;
  }

  V$$init$$$() {
    // source file is Objects.java
    var var0 = null;
    var var1 = null;
    // line number 43
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 44
    var0 = new java$lang$AssertionError();
    var1 = bytecoder.stringconstants[152];
    java$lang$AssertionError.prototype.V$$init$$Ljava$lang$Object$.call(var0,var1);
    throw bytecoder.registerStack(var0, new Error().stack);
  }

  static I$checkIndex$I$I(arg0,arg1) {
    // source file is Objects.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var0 = (arg1) | 0;
    // line number 385
    var1 = (var0) | 0;
    jdk$internal$util$Preconditions.$i;
    var2 = ((jdk$internal$util$Preconditions.I$checkIndex$I$I$Ljava$util$function$BiFunction$(arg0,var1,null))) | 0;
    return var2;
  }
}


class java$nio$Buffer extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;
  static UNSAFE = null;
  static SCOPED_MEMORY_ACCESS = null;
  mark = 0;
  position = 0;
  capacity = 0;
  segment = null;
  limit = 0;
  address = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$nio$Buffer,[java$lang$Object,java$nio$Buffer]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
    this.Z$isReadOnly$$ = impl;
  }

  static V$$clinit$$$() {
    // source file is Buffer.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    // line number 197
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(java$nio$Buffer.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    java$nio$Buffer.$i;
    java$nio$Buffer.$assertionsDisabled = phi2;
    // line number 201
    jdk$internal$misc$Unsafe.$i;
    var3 = (jdk$internal$misc$Unsafe.Ljdk$internal$misc$Unsafe$$getUnsafe$$());
    java$nio$Buffer.UNSAFE = var3;
    // line number 203
    jdk$internal$misc$ScopedMemoryAccess.$i;
    var4 = (jdk$internal$misc$ScopedMemoryAccess.Ljdk$internal$misc$ScopedMemoryAccess$$getScopedMemoryAccess$$());
    java$nio$Buffer.SCOPED_MEMORY_ACCESS = var4;
    // line number 781
    var5 = new java$nio$Buffer$1();
    java$nio$Buffer$1.prototype.V$$init$$$.call(var5);
    jdk$internal$access$SharedSecrets.V$setJavaNioAccess$Ljdk$internal$access$JavaNioAccess$(var5);
    // line number 894
    return;
  }

  static Ljava$lang$IllegalArgumentException$$createCapacityException$I(arg0) {
    // source file is Buffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var phi4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    // line number 283
    java$nio$Buffer.$i;
    var0 = (java$nio$Buffer.$assertionsDisabled);
    If_9_0: {
     if (var0 != 0) {
      phi4 = (arg0) | 0;
      break If_9_0;
     } else {
      var1 = (arg0) | 0;
      if (var1 < 0) {
       phi4 = (arg0) | 0;
       break If_9_0;
      } else {
       var2 = new java$lang$AssertionError();
       var3 = bytecoder.stringconstants[56];
       java$lang$AssertionError.prototype.V$$init$$Ljava$lang$Object$.call(var2,var3);
       throw bytecoder.registerStack(var2, new Error().stack);
      }
     }
    }
    // line number 284
    var5 = new java$lang$IllegalArgumentException();
    var6 = new java$lang$StringBuilder();
    java$lang$StringBuilder.prototype.V$$init$$$.call(var6);
    var7 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var6,bytecoder.stringconstants[57]));
    var8 = (phi4) | 0;
    var9 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var7,var8));
    var10 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var9,bytecoder.stringconstants[58]));
    var11 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var10));
    java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var5,var11);
    return var5;
  }

  V$$init$$I$I$I$I$Ljava$lang$foreign$MemorySegment$(arg0,arg1,arg2,arg3,arg4) {
    // source file is Buffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = 0;
    var var10 = null;
    var var11 = 0;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var phi21 = null;
    var phi22 = 0;
    var phi23 = 0;
    var phi24 = 0;
    var phi25 = 0;
    var phi26 = null;
    var0 = (arg0) | 0;
    var1 = (arg2) | 0;
    var2 = arg4;
    // line number 245
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 213
    var3 = this;
    var3.mark = -1;
    // line number 214
    var4 = this;
    var4.position = 0;
    // line number 246
    if (arg3 >= 0) {
     // line number 248
     var6 = this;
     var6.capacity = arg3;
     // line number 249
     var7 = this;
     var7.segment = var2;
     // line number 250
     var8 = (this.Ljava$nio$Buffer$$limit$I(var1));
     // line number 251
     var9 = (arg1) | 0;
     var10 = (this.Ljava$nio$Buffer$$position$I(var9));
     // line number 252
     If_66_0: {
      if (var0 < 0) {
       phi21 = this;
       phi22 = (var0) | 0;
       phi23 = (arg1) | 0;
       phi24 = (var1) | 0;
       phi25 = (arg3) | 0;
       phi26 = var2;
       break If_66_0;
      } else {
       // line number 253
       var11 = (arg1) | 0;
       if (var0 <= var11) {
        // line number 256
        var20 = this;
        var20.mark = var0;
        phi21 = this;
        phi22 = (var0) | 0;
        phi23 = (arg1) | 0;
        phi24 = (var1) | 0;
        phi25 = (arg3) | 0;
        phi26 = var2;
        break If_66_0;
       } else {
        // line number 254
        var12 = new java$lang$IllegalArgumentException();
        var13 = new java$lang$StringBuilder();
        java$lang$StringBuilder.prototype.V$$init$$$.call(var13);
        var14 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var13,bytecoder.stringconstants[67]));
        var15 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var14,var0));
        var16 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var15,bytecoder.stringconstants[60]));
        var17 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var16,arg1));
        var18 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var17,bytecoder.stringconstants[61]));
        var19 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var18));
        java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var12,var19);
        throw bytecoder.registerStack(var12, new Error().stack);
       }
      }
     }
     // line number 258
     return;
    } else {
     // line number 247
     java$nio$Buffer.$i;
     var5 = (java$nio$Buffer.Ljava$lang$IllegalArgumentException$$createCapacityException$I(arg3));
     throw bytecoder.registerStack(var5, new Error().stack);
    }
  }

  Ljava$nio$Buffer$$limit$I(arg0) {
    // source file is Buffer.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var phi4 = null;
    var phi5 = 0;
    var phi6 = 0;
    var var7 = 0;
    var var8 = 0;
    var phi9 = 0;
    var var10 = 0;
    var var11 = null;
    var var12 = 0;
    var var13 = null;
    var var14 = null;
    var var15 = 0;
    var var16 = null;
    var var17 = 0;
    var var18 = 0;
    var var19 = null;
    var var20 = 0;
    var var21 = null;
    var var22 = 0;
    var var23 = 0;
    var var24 = null;
    var var25 = null;
    var0 = (arg0) | 0;
    // line number 373
    var1 = this;
    var2 = ((var1.capacity)) | 0;
    If_12_0: {
     if (var0 <= var2) {
      phi4 = this;
      phi5 = (var0) | 0;
      phi6 = (0) | 0;
      break If_12_0;
     } else {
      var3 = (1) | 0;
      // Here was a goto statement
      phi4 = this;
      phi5 = (var0) | 0;
      phi6 = (var3) | 0;
      break If_12_0;
     }
    }
    var7 = (phi5) | 0;
    If_25_0: {
     if (var7 >= 0) {
      phi9 = (0) | 0;
      break If_25_0;
     } else {
      var8 = (1) | 0;
      // Here was a goto statement
      phi9 = (var8) | 0;
      break If_25_0;
     }
    }
    var10 = ((phi6 | phi9)) | 0;
    if (var10 == 0) {
     // line number 375
     var14 = phi4;
     var15 = (phi5) | 0;
     var14.limit = var15;
     // line number 376
     var16 = phi4;
     var17 = ((var16.position)) | 0;
     var18 = (phi5) | 0;
     If_68_0: {
      if (var17 <= var18) {
       break If_68_0;
      } else {
       var19 = phi4;
       var20 = (phi5) | 0;
       var19.position = var20;
       break If_68_0;
      }
     }
     // line number 377
     var21 = phi4;
     var22 = ((var21.mark)) | 0;
     var23 = (phi5) | 0;
     If_85_0: {
      if (var22 <= var23) {
       break If_85_0;
      } else {
       var24 = phi4;
       var24.mark = -1;
       break If_85_0;
      }
     }
     // line number 378
     var25 = phi4;
     return var25;
    } else {
     // line number 374
     var11 = phi4;
     var12 = (phi5) | 0;
     var13 = (java$nio$Buffer.prototype.Ljava$lang$IllegalArgumentException$$createLimitException$I.call(var11,var12));
     throw bytecoder.registerStack(var13, new Error().stack);
    }
  }

  Ljava$lang$IllegalArgumentException$$createLimitException$I(arg0) {
    // source file is Buffer.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var phi11 = null;
    var phi12 = 0;
    var phi13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = 0;
    var var17 = 0;
    var var18 = null;
    var var19 = null;
    var phi20 = null;
    var phi21 = 0;
    var phi22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = 0;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var0 = (arg0) | 0;
    // line number 391
    // line number 393
    var1 = this;
    var2 = ((var1.capacity)) | 0;
    If_15_0: {
     if (var0 <= var2) {
      // line number 396
      java$nio$Buffer.$i;
      var16 = (java$nio$Buffer.$assertionsDisabled);
      If_73_0: {
       if (var16 != 0) {
        phi20 = this;
        phi21 = (var0) | 0;
        phi22 = null;
        break If_73_0;
       } else {
        var17 = (var0) | 0;
        if (var17 < 0) {
         phi20 = this;
         phi21 = (var0) | 0;
         phi22 = null;
         break If_73_0;
        } else {
         var18 = new java$lang$AssertionError();
         var19 = bytecoder.stringconstants[62];
         java$lang$AssertionError.prototype.V$$init$$Ljava$lang$Object$.call(var18,var19);
         throw bytecoder.registerStack(var18, new Error().stack);
        }
       }
      }
      // line number 397
      var23 = new java$lang$StringBuilder();
      java$lang$StringBuilder.prototype.V$$init$$$.call(var23);
      var24 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var23,bytecoder.stringconstants[63]));
      var25 = (phi21) | 0;
      var26 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var24,var25));
      var27 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var26,bytecoder.stringconstants[58]));
      var28 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var27));
      phi11 = phi20;
      phi12 = (phi21) | 0;
      phi13 = var28;
      break If_15_0;
     } else {
      // line number 394
      var3 = new java$lang$StringBuilder();
      java$lang$StringBuilder.prototype.V$$init$$$.call(var3);
      var4 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var3,bytecoder.stringconstants[59]));
      var5 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var4,var0));
      var6 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var5,bytecoder.stringconstants[60]));
      var7 = ((this.capacity)) | 0;
      var8 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var6,var7));
      var9 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var8,bytecoder.stringconstants[61]));
      var10 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var9));
      // Here was a goto statement
      phi11 = this;
      phi12 = (var0) | 0;
      phi13 = var10;
      break If_15_0;
     }
    }
    // line number 400
    var14 = new java$lang$IllegalArgumentException();
    var15 = phi13;
    java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var14,var15);
    return var14;
  }

  Ljava$nio$Buffer$$position$I(arg0) {
    // source file is Buffer.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var phi4 = null;
    var phi5 = 0;
    var phi6 = 0;
    var var7 = 0;
    var var8 = 0;
    var phi9 = 0;
    var var10 = 0;
    var var11 = null;
    var var12 = 0;
    var var13 = null;
    var var14 = null;
    var var15 = 0;
    var var16 = 0;
    var var17 = null;
    var var18 = null;
    var var19 = 0;
    var var20 = null;
    var0 = (arg0) | 0;
    // line number 320
    var1 = this;
    var2 = ((var1.limit)) | 0;
    If_12_0: {
     if (var0 <= var2) {
      phi4 = this;
      phi5 = (var0) | 0;
      phi6 = (0) | 0;
      break If_12_0;
     } else {
      var3 = (1) | 0;
      // Here was a goto statement
      phi4 = this;
      phi5 = (var0) | 0;
      phi6 = (var3) | 0;
      break If_12_0;
     }
    }
    var7 = (phi5) | 0;
    If_25_0: {
     if (var7 >= 0) {
      phi9 = (0) | 0;
      break If_25_0;
     } else {
      var8 = (1) | 0;
      // Here was a goto statement
      phi9 = (var8) | 0;
      break If_25_0;
     }
    }
    var10 = ((phi6 | phi9)) | 0;
    if (var10 == 0) {
     // line number 322
     var14 = phi4;
     var15 = ((var14.mark)) | 0;
     var16 = (phi5) | 0;
     If_61_0: {
      if (var15 <= var16) {
       break If_61_0;
      } else {
       var17 = phi4;
       var17.mark = -1;
       break If_61_0;
      }
     }
     // line number 323
     var18 = phi4;
     var19 = (phi5) | 0;
     var18.position = var19;
     // line number 324
     var20 = phi4;
     return var20;
    } else {
     // line number 321
     var11 = phi4;
     var12 = (phi5) | 0;
     var13 = (java$nio$Buffer.prototype.Ljava$lang$IllegalArgumentException$$createPositionException$I.call(var11,var12));
     throw bytecoder.registerStack(var13, new Error().stack);
    }
  }

  Ljava$lang$IllegalArgumentException$$createPositionException$I(arg0) {
    // source file is Buffer.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var phi11 = null;
    var phi12 = 0;
    var phi13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = 0;
    var var17 = 0;
    var var18 = null;
    var var19 = null;
    var phi20 = null;
    var phi21 = 0;
    var phi22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = 0;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var0 = (arg0) | 0;
    // line number 337
    // line number 339
    var1 = this;
    var2 = ((var1.limit)) | 0;
    If_15_0: {
     if (var0 <= var2) {
      // line number 342
      java$nio$Buffer.$i;
      var16 = (java$nio$Buffer.$assertionsDisabled);
      If_73_0: {
       if (var16 != 0) {
        phi20 = this;
        phi21 = (var0) | 0;
        phi22 = null;
        break If_73_0;
       } else {
        var17 = (var0) | 0;
        if (var17 < 0) {
         phi20 = this;
         phi21 = (var0) | 0;
         phi22 = null;
         break If_73_0;
        } else {
         var18 = new java$lang$AssertionError();
         var19 = bytecoder.stringconstants[65];
         java$lang$AssertionError.prototype.V$$init$$Ljava$lang$Object$.call(var18,var19);
         throw bytecoder.registerStack(var18, new Error().stack);
        }
       }
      }
      // line number 343
      var23 = new java$lang$StringBuilder();
      java$lang$StringBuilder.prototype.V$$init$$$.call(var23);
      var24 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var23,bytecoder.stringconstants[66]));
      var25 = (phi21) | 0;
      var26 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var24,var25));
      var27 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var26,bytecoder.stringconstants[58]));
      var28 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var27));
      phi11 = phi20;
      phi12 = (phi21) | 0;
      phi13 = var28;
      break If_15_0;
     } else {
      // line number 340
      var3 = new java$lang$StringBuilder();
      java$lang$StringBuilder.prototype.V$$init$$$.call(var3);
      var4 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var3,bytecoder.stringconstants[64]));
      var5 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var4,var0));
      var6 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var5,bytecoder.stringconstants[60]));
      var7 = ((this.limit)) | 0;
      var8 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var6,var7));
      var9 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var8,bytecoder.stringconstants[61]));
      var10 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var9));
      // Here was a goto statement
      phi11 = this;
      phi12 = (var0) | 0;
      phi13 = var10;
      break If_15_0;
     }
    }
    // line number 346
    var14 = new java$lang$IllegalArgumentException();
    var15 = phi13;
    java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var14,var15);
    return var14;
  }

  I$remaining$$() {
    // source file is Buffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var phi4 = null;
    var phi5 = 0;
    var phi6 = 0;
    // line number 512
    var0 = ((this.limit)) | 0;
    var1 = ((this.position)) | 0;
    var2 = ((var0 - var1)) | 0;
    // line number 513
    If_15_0: {
     if (var2 <= 0) {
      phi4 = this;
      phi5 = (var2) | 0;
      phi6 = (0) | 0;
      break If_15_0;
     } else {
      var3 = (var2) | 0;
      // Here was a goto statement
      phi4 = this;
      phi5 = (var2) | 0;
      phi6 = (var3) | 0;
      break If_15_0;
     }
    }
    return phi6;
  }

  Z$hasRemaining$$() {
    // source file is Buffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var phi3 = null;
    var phi4 = 0;
    // line number 524
    var0 = ((this.position)) | 0;
    var1 = ((this.limit)) | 0;
    If_10_0: {
     if (var0 >= var1) {
      phi3 = this;
      phi4 = (0) | 0;
      break If_10_0;
     } else {
      var2 = (1) | 0;
      // Here was a goto statement
      phi3 = this;
      phi4 = (var2) | 0;
      break If_10_0;
     }
    }
    return phi4;
  }

  I$position$$() {
    // source file is Buffer.java
    var var0 = 0;
    // line number 303
    var0 = ((this.position)) | 0;
    return var0;
  }

  V$checkSession$$() {
    // source file is Buffer.java
    return;
  }

  I$limit$$() {
    // source file is Buffer.java
    var var0 = 0;
    // line number 355
    var0 = ((this.limit)) | 0;
    return var0;
  }

  I$nextPutIndex$$() {
    // source file is Buffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    // line number 725
    var0 = ((this.position)) | 0;
    // line number 726
    var1 = ((this.limit)) | 0;
    if (var0 < var1) {
     // line number 728
     var3 = this;
     var4 = ((var0 + 1)) | 0;
     var3.position = var4;
     // line number 729
     return var0;
    } else {
     // line number 727
     var2 = new java$nio$BufferOverflowException();
     java$nio$BufferOverflowException.prototype.V$$init$$$.call(var2);
     throw bytecoder.registerStack(var2, new Error().stack);
    }
  }

  Ljdk$internal$foreign$MemorySessionImpl$$session$$() {
    // source file is Buffer.java
    var var0 = null;
    var0 = null;
    return var0;
  }

  I$capacity$$() {
    // source file is Buffer.java
    var var0 = 0;
    // line number 294
    var0 = ((this.capacity)) | 0;
    return var0;
  }

  Ljava$nio$Buffer$$flip$$() {
    // source file is Buffer.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var0 = this;
    // line number 478
    var1 = var0;
    var2 = ((var1.position)) | 0;
    var0.limit = var2;
    // line number 479
    var0.position = 0;
    // line number 480
    var0.mark = -1;
    // line number 481
    return var0;
  }

  Ljava$nio$Buffer$$clear$$() {
    // source file is Buffer.java
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var0 = this;
    // line number 450
    var1 = (0) | 0;
    var0.position = var1;
    // line number 451
    var2 = var0;
    var3 = ((var2.capacity)) | 0;
    var0.limit = var3;
    // line number 452
    var0.mark = -1;
    // line number 453
    return var0;
  }

  I$checkIndex$I(arg0) {
    // source file is Buffer.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var0 = (arg0) | 0;
    // line number 746
    var1 = this;
    var2 = ((var1.limit)) | 0;
    var3 = ((java$util$Objects.I$checkIndex$I$I(var0,var2))) | 0;
    return var3;
  }

  I$nextGetIndex$$() {
    // source file is Buffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    // line number 702
    var0 = ((this.position)) | 0;
    // line number 703
    var1 = ((this.limit)) | 0;
    if (var0 < var1) {
     // line number 705
     var3 = this;
     var4 = ((var0 + 1)) | 0;
     var3.position = var4;
     // line number 706
     return var0;
    } else {
     // line number 704
     var2 = new java$nio$BufferUnderflowException();
     java$nio$BufferUnderflowException.prototype.V$$init$$$.call(var2);
     throw bytecoder.registerStack(var2, new Error().stack);
    }
  }
}


class java$lang$Comparable extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Comparable,[java$lang$Object,java$lang$Comparable]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.I$compareTo$Ljava$lang$Object$ = impl;
  }
}


class jdk$internal$misc$CDS extends java$lang$Object {
  nativeObject = null;

  static isDumpingClassList = false;
  static isDumpingArchive = false;
  static isSharingEnabled = false;
  static excludeFlags = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(jdk$internal$misc$CDS,[java$lang$Object,jdk$internal$misc$CDS]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is CDS.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    // line number 48
    jdk$internal$misc$CDS.$i;
    var0 = (jdk$internal$misc$CDS.Z$isDumpingClassList0$$());
    jdk$internal$misc$CDS.isDumpingClassList = var0;
    // line number 49
    var1 = (jdk$internal$misc$CDS.Z$isDumpingArchive0$$());
    jdk$internal$misc$CDS.isDumpingArchive = var1;
    // line number 50
    var2 = (jdk$internal$misc$CDS.Z$isSharingEnabled0$$());
    jdk$internal$misc$CDS.isSharingEnabled = var2;
    // line number 232
    var3 = bytecoder.newarray((6),null);
    var4 = (0) | 0;
    var3.data[var4] = bytecoder.stringconstants[98];
    var5 = (1) | 0;
    var3.data[var5] = bytecoder.stringconstants[99];
    var6 = (2) | 0;
    var3.data[var6] = bytecoder.stringconstants[100];
    var7 = (3) | 0;
    var3.data[var7] = bytecoder.stringconstants[101];
    var8 = (4) | 0;
    var3.data[var8] = bytecoder.stringconstants[102];
    var9 = (5) | 0;
    var3.data[var9] = bytecoder.stringconstants[103];
    jdk$internal$misc$CDS.excludeFlags = var3;
    return;
  }

  static Z$isDumpingClassList0$$() {
    return bytecoder.imports['jdk.internal.misc.CDS'].Z$isDumpingClassList0$$();
  }

  static Z$isDumpingArchive0$$() {
    return bytecoder.imports['jdk.internal.misc.CDS'].Z$isDumpingArchive0$$();
  }

  static Z$isSharingEnabled0$$() {
    return bytecoder.imports['jdk.internal.misc.CDS'].Z$isSharingEnabled0$$();
  }

  static J$getRandomSeedForDumping$$() {
    return bytecoder.imports['jdk.internal.misc.CDS'].J$getRandomSeedForDumping$$();
  }

  static V$initializeFromArchive$Ljava$lang$Class$(arg0) {
    bytecoder.imports['jdk.internal.misc.CDS'].V$initializeFromArchive$Ljava$lang$Class$(arg0);
  }

  V$$init$$$() {
    // source file is CDS.java
    // line number 43
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class java$lang$reflect$Type extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$reflect$Type,[java$lang$Object,java$lang$reflect$Type]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class java$nio$ByteOrder extends java$lang$Object {
  nativeObject = null;

  name = null;
  static BIG_ENDIAN = null;
  static LITTLE_ENDIAN = null;
  static NATIVE_ORDER = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$nio$ByteOrder,[java$lang$Object,java$nio$ByteOrder]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is ByteOrder.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var phi6 = null;
    var var7 = null;
    // line number 50
    java$nio$ByteOrder.$i;
    var0 = new java$nio$ByteOrder();
    var1 = bytecoder.stringconstants[68];
    java$nio$ByteOrder.prototype.V$$init$$Ljava$lang$String$.call(var0,var1);
    java$nio$ByteOrder.BIG_ENDIAN = var0;
    // line number 58
    var2 = new java$nio$ByteOrder();
    java$nio$ByteOrder.prototype.V$$init$$Ljava$lang$String$.call(var2,bytecoder.stringconstants[69]);
    java$nio$ByteOrder.LITTLE_ENDIAN = var2;
    // line number 64
    jdk$internal$misc$Unsafe.$i;
    var3 = (jdk$internal$misc$Unsafe.Ljdk$internal$misc$Unsafe$$getUnsafe$$());
    var4 = (jdk$internal$misc$Unsafe.prototype.Z$isBigEndian$$.call(var3));
    If_34_0: {
     if (var4 == 0) {
      var7 = (java$nio$ByteOrder.LITTLE_ENDIAN);
      phi6 = var7;
      break If_34_0;
     } else {
      // line number 65
      var5 = (java$nio$ByteOrder.BIG_ENDIAN);
      // Here was a goto statement
      phi6 = var5;
      break If_34_0;
     }
    }
    java$nio$ByteOrder.NATIVE_ORDER = phi6;
    // line number 63
    return;
  }

  V$$init$$Ljava$lang$String$(arg0) {
    // source file is ByteOrder.java
    var var0 = null;
    var var1 = null;
    var0 = arg0;
    // line number 42
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 43
    var1 = this;
    var1.name = var0;
    // line number 44
    return;
  }

  static Ljava$nio$ByteOrder$$nativeOrder$$() {
    // source file is ByteOrder.java
    var var0 = null;
    // line number 79
    java$nio$ByteOrder.$i;
    var0 = (java$nio$ByteOrder.NATIVE_ORDER);
    return var0;
  }

  Ljava$lang$String$$toString$$() {
    // source file is ByteOrder.java
    var var0 = null;
    // line number 92
    var0 = (this.name);
    return var0;
  }
}


class java$lang$Void extends java$lang$Object {
  nativeObject = null;

  static TYPE = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Void,[java$lang$Object,java$lang$Void]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is Void.java
    var var0 = null;
    // line number 43
    var0 = (java$lang$Class.Ljava$lang$Class$$getPrimitiveClass$Ljava$lang$String$(bytecoder.stringconstants[32]));
    java$lang$Void.$i;
    java$lang$Void.TYPE = var0;
    return;
  }

  V$$init$$$() {
    // source file is Void.java
    // line number 48
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class de$mirkosertic$bytecoder$api$Callback extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(de$mirkosertic$bytecoder$api$Callback,[de$mirkosertic$bytecoder$api$Callback,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class java$lang$invoke$CallSite extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$invoke$CallSite,[java$lang$Object,java$lang$invoke$CallSite]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.Ljava$lang$invoke$MethodHandle$$getTarget$$ = impl;
  }

  V$$init$$$() {
    // source file is CallSite.java
    // line number 23
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class java$io$FileDescriptor extends java$lang$Object {
  nativeObject = null;

  fd = 0;
  static in = null;
  static out = null;
  static err = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$io$FileDescriptor,[java$lang$Object,java$io$FileDescriptor]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  I$getFileDescriptorHandle$$() {
    // source file is FileDescriptor.java
    var var0 = 0;
    // line number 62
    var0 = ((this.fd)) | 0;
    return var0;
  }

  V$setFileDescriptorHandle$I(arg0) {
    // source file is FileDescriptor.java
    var var0 = null;
    var var1 = 0;
    var0 = this;
    // line number 67
    var1 = (arg0) | 0;
    var0.fd = var1;
    // line number 68
    return;
  }

  static V$$clinit$$$() {
    // source file is FileDescriptor.java
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    // line number 28
    java$io$FileDescriptor.$i;
    var0 = new java$io$FileDescriptor();
    var1 = (0) | 0;
    java$io$FileDescriptor.prototype.V$$init$$I.call(var0,var1);
    var2 = var0;
    java$io$FileDescriptor.in = var2;
    // line number 30
    var3 = new java$io$FileDescriptor();
    java$io$FileDescriptor.prototype.V$$init$$I.call(var3,1);
    var4 = var3;
    java$io$FileDescriptor.out = var4;
    // line number 32
    var5 = new java$io$FileDescriptor();
    java$io$FileDescriptor.prototype.V$$init$$I.call(var5,2);
    var6 = var5;
    java$io$FileDescriptor.err = var6;
    return;
  }

  V$$init$$I(arg0) {
    // source file is FileDescriptor.java
    var var0 = 0;
    var var1 = null;
    var0 = (arg0) | 0;
    // line number 40
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 41
    var1 = this;
    var1.fd = var0;
    // line number 42
    return;
  }

  V$$init$$$() {
    // source file is FileDescriptor.java
    var var0 = null;
    // line number 36
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 37
    var0 = this;
    var0.fd = -1;
    // line number 38
    return;
  }
}


class org$luaj$vm2$compiler$LuaC$CompileState extends java$lang$Object {
  nativeObject = null;

  nCcalls = 0;
  strings = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$compiler$LuaC$CompileState,[java$lang$Object,org$luaj$vm2$compiler$LuaC$CompileState]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    java$lang$Object.prototype.V$$init$$$.call(this);
    var0 = this;
    var0.nCcalls = 0;
    var1 = this;
    var2 = new java$util$Hashtable();
    java$util$Hashtable.prototype.V$$init$$$.call(var2);
    var1.strings = var2;
    return;
  }

  static Lorg$luaj$vm2$Prototype$$access$000$Lorg$luaj$vm2$compiler$LuaC$CompileState$$Ljava$io$InputStream$$Ljava$lang$String$(arg0,arg1,arg2) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg1;
    var1 = var0;
    var2 = (org$luaj$vm2$compiler$LuaC$CompileState.prototype.Lorg$luaj$vm2$Prototype$$luaY_parser$Ljava$io$InputStream$$Ljava$lang$String$.call(arg0,var1,arg2));
    return var2;
  }

  Lorg$luaj$vm2$Prototype$$luaY_parser$Ljava$io$InputStream$$Ljava$lang$String$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = 0;
    var phi14 = null;
    var phi15 = null;
    var phi16 = null;
    var phi17 = null;
    var phi18 = null;
    var phi19 = 0;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = 0;
    var var25 = null;
    var var26 = null;
    var var27 = 0;
    var var28 = null;
    var var29 = null;
    var var30 = 0;
    var phi31 = 0;
    var var32 = null;
    var var33 = null;
    var0 = arg0;
    org$luaj$vm2$compiler$LexState.$i;
    var1 = new org$luaj$vm2$compiler$LexState();
    var2 = this;
    org$luaj$vm2$compiler$LexState.prototype.V$$init$$Lorg$luaj$vm2$compiler$LuaC$CompileState$$Ljava$io$InputStream$.call(var1,var2,var0);
    org$luaj$vm2$compiler$FuncState.$i;
    var3 = new org$luaj$vm2$compiler$FuncState();
    org$luaj$vm2$compiler$FuncState.prototype.V$$init$$$.call(var3);
    var4 = var1;
    var4.fs = var3;
    var5 = var0;
    var6 = ((var5.I$read$$())) | 0;
    org$luaj$vm2$LuaValue.$i;
    var7 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(arg1));
    org$luaj$vm2$compiler$LexState.prototype.V$setinput$Lorg$luaj$vm2$compiler$LuaC$CompileState$$I$Ljava$io$InputStream$$Lorg$luaj$vm2$LuaString$.call(var1,this,var6,var0,var7);
    org$luaj$vm2$Prototype.$i;
    var8 = new org$luaj$vm2$Prototype();
    org$luaj$vm2$Prototype.prototype.V$$init$$$.call(var8);
    var3.f = var8;
    var9 = (var3.f);
    var10 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(arg1));
    var9.source = var10;
    var11 = var3;
    org$luaj$vm2$compiler$LexState.prototype.V$mainfunc$Lorg$luaj$vm2$compiler$FuncState$.call(var1,var11);
    var12 = (var3.prev);
    If_55_0: {
     if (var12 != null) {
      phi14 = this;
      phi15 = var0;
      phi16 = arg1;
      phi17 = var1;
      phi18 = var3;
      phi19 = (0) | 0;
      break If_55_0;
     } else {
      var13 = (1) | 0;
      // Here was a goto statement
      phi14 = this;
      phi15 = var0;
      phi16 = arg1;
      phi17 = var1;
      phi18 = var3;
      phi19 = (var13) | 0;
      break If_55_0;
     }
    }
    org$luaj$vm2$compiler$LuaC.$i;
    org$luaj$vm2$compiler$Constants.V$_assert$Z(phi19);
    var20 = phi17;
    var21 = (var20.dyd);
    If_76_0: {
     If_76_1: {
      if (var21 == null) {
       break If_76_1;
      } else {
       var22 = phi17;
       var23 = (var22.dyd);
       var24 = ((var23.n_actvar)) | 0;
       If_86_0: {
        if (var24 != 0) {
         break If_86_0;
        } else {
         var25 = phi17;
         var26 = (var25.dyd);
         var27 = ((var26.n_gt)) | 0;
         if (var27 != 0) {
          break If_86_0;
         } else {
          var28 = phi17;
          var29 = (var28.dyd);
          var30 = ((var29.n_label)) | 0;
          if (var30 != 0) {
           break If_86_0;
          } else {
           break If_76_1;
          }
         }
        }
       }
       phi31 = (0) | 0;
       break If_76_0;
      }
     }
     // Here was a goto statement
     phi31 = (1) | 0;
     break If_76_0;
    }
    org$luaj$vm2$compiler$Constants.V$_assert$Z(phi31);
    var32 = phi18;
    var33 = (var32.f);
    return var33;
  }

  Ljava$lang$String$$pushfstring$Ljava$lang$String$(arg0) {
    var var0 = null;
    var0 = arg0;
    return var0;
  }

  Lorg$luaj$vm2$LuaString$$newTString$Ljava$lang$String$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var0 = arg0;
    var1 = var0;
    org$luaj$vm2$LuaString.$i;
    var2 = (org$luaj$vm2$LuaString.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(var1));
    var3 = (org$luaj$vm2$compiler$LuaC$CompileState.prototype.Lorg$luaj$vm2$LuaString$$cachedLuaString$Lorg$luaj$vm2$LuaString$.call(this,var2));
    return var3;
  }

  Lorg$luaj$vm2$LuaString$$cachedLuaString$Lorg$luaj$vm2$LuaString$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var0 = arg0;
    var1 = (this.strings);
    var2 = (var1.Ljava$lang$Object$$get$Ljava$lang$Object$(var0));
    var3 = var2;
    var4 = var3;
    if (var4 == null) {
     var6 = (this.strings);
     var7 = var0;
     var8 = (var6.Ljava$lang$Object$$put$Ljava$lang$Object$$Ljava$lang$Object$(var0,var7));
     var9 = var0;
     return var9;
    } else {
     var5 = var3;
     return var5;
    }
  }

  Lorg$luaj$vm2$LuaString$$newTString$Lorg$luaj$vm2$LuaString$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    var1 = var0;
    var2 = (org$luaj$vm2$compiler$LuaC$CompileState.prototype.Lorg$luaj$vm2$LuaString$$cachedLuaString$Lorg$luaj$vm2$LuaString$.call(this,var1));
    return var2;
  }
}


class jdk$internal$util$Preconditions extends java$lang$Object {
  nativeObject = null;

  static SIOOBE_FORMATTER = null;
  static AIOOBE_FORMATTER = null;
  static IOOBE_FORMATTER = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(jdk$internal$util$Preconditions,[java$lang$Object,jdk$internal$util$Preconditions]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is Preconditions.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    // line number 52
    var0 = new jdk$internal$util$Preconditions$1();
    jdk$internal$util$Preconditions$1.prototype.V$$init$$$.call(var0);
    jdk$internal$util$Preconditions.$i;
    var1 = (jdk$internal$util$Preconditions.Ljava$util$function$BiFunction$$outOfBoundsExceptionFormatter$Ljava$util$function$Function$(var0));
    jdk$internal$util$Preconditions.SIOOBE_FORMATTER = var1;
    // line number 60
    var2 = new jdk$internal$util$Preconditions$2();
    jdk$internal$util$Preconditions$2.prototype.V$$init$$$.call(var2);
    var3 = (jdk$internal$util$Preconditions.Ljava$util$function$BiFunction$$outOfBoundsExceptionFormatter$Ljava$util$function$Function$(var2));
    jdk$internal$util$Preconditions.AIOOBE_FORMATTER = var3;
    // line number 68
    var4 = new jdk$internal$util$Preconditions$3();
    jdk$internal$util$Preconditions$3.prototype.V$$init$$$.call(var4);
    var5 = (jdk$internal$util$Preconditions.Ljava$util$function$BiFunction$$outOfBoundsExceptionFormatter$Ljava$util$function$Function$(var4));
    jdk$internal$util$Preconditions.IOOBE_FORMATTER = var5;
    return;
  }

  static Ljava$util$function$BiFunction$$outOfBoundsExceptionFormatter$Ljava$util$function$Function$(arg0) {
    // source file is Preconditions.java
    var var0 = null;
    var var1 = null;
    // line number 210
    var0 = new jdk$internal$util$Preconditions$4();
    var1 = arg0;
    jdk$internal$util$Preconditions$4.prototype.V$$init$$Ljava$util$function$Function$.call(var0,var1);
    return var0;
  }

  static I$checkFromIndexSize$I$I$I$Ljava$util$function$BiFunction$(arg0,arg1,arg2,arg3) {
    // source file is Preconditions.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var phi8 = 0;
    var phi9 = 0;
    var phi10 = 0;
    var phi11 = null;
    var var12 = null;
    var var13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = null;
    var0 = (arg1) | 0;
    var1 = arg3;
    // line number 396
    var2 = (arg0) | 0;
    var3 = ((arg2 | var2)) | 0;
    var4 = ((var3 | var0)) | 0;
    If_19_0: {
     if (var4 < 0) {
      phi8 = (arg0) | 0;
      phi9 = (var0) | 0;
      phi10 = (arg2) | 0;
      phi11 = var1;
      break If_19_0;
     } else {
      var5 = (var0) | 0;
      var6 = (arg0) | 0;
      var7 = ((arg2 - var6)) | 0;
      if (var5 <= var7) {
       // line number 398
       return arg0;
      } else {
       phi8 = (arg0) | 0;
       phi9 = (var0) | 0;
       phi10 = (arg2) | 0;
       phi11 = var1;
       break If_19_0;
      }
     }
    }
    // line number 397
    var12 = phi11;
    var13 = (phi8) | 0;
    var14 = (phi9) | 0;
    var15 = (phi10) | 0;
    jdk$internal$util$Preconditions.$i;
    var16 = (jdk$internal$util$Preconditions.Ljava$lang$RuntimeException$$outOfBoundsCheckFromIndexSize$Ljava$util$function$BiFunction$$I$I$I(var12,var13,var14,var15));
    throw bytecoder.registerStack(var16, new Error().stack);
  }

  static Ljava$lang$RuntimeException$$outOfBoundsCheckFromIndexSize$Ljava$util$function$BiFunction$$I$I$I(arg0,arg1,arg2,arg3) {
    // source file is Preconditions.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = 0;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = null;
    var0 = (arg1) | 0;
    var1 = (arg3) | 0;
    // line number 118
    var2 = bytecoder.stringconstants[97];
    var3 = bytecoder.newarray((3),null);
    var4 = (0) | 0;
    java$lang$Integer.$i;
    var5 = (java$lang$Integer.Ljava$lang$Integer$$valueOf$I(var0));
    var3.data[var4] = var5;
    var6 = (1) | 0;
    var7 = (java$lang$Integer.Ljava$lang$Integer$$valueOf$I(arg2));
    var3.data[var6] = var7;
    var8 = (2) | 0;
    var9 = (java$lang$Integer.Ljava$lang$Integer$$valueOf$I(var1));
    var3.data[var8] = var9;
    jdk$internal$util$Preconditions.$i;
    var10 = (jdk$internal$util$Preconditions.Ljava$lang$RuntimeException$$outOfBounds$Ljava$util$function$BiFunction$$Ljava$lang$String$$$Ljava$lang$Number$(arg0,var2,var3));
    return var10;
  }

  static Ljava$lang$RuntimeException$$outOfBounds$Ljava$util$function$BiFunction$$Ljava$lang$String$$$Ljava$lang$Number$(arg0,arg1,arg2) {
    // source file is Preconditions.java
    var var0 = null;
    var var1 = null;
    var phi2 = null;
    var phi3 = null;
    var phi4 = null;
    var phi5 = null;
    var phi6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var phi12 = null;
    var phi13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var0 = arg1;
    // line number 96
    var1 = (java$util$List.Ljava$util$List$$of$$Ljava$lang$Object$(arg2));
    // line number 97
    If_15_0: {
     if (arg0 != null) {
      var14 = var0;
      var15 = (arg0.Ljava$lang$Object$$apply$Ljava$lang$Object$$Ljava$lang$Object$(var14,var1));
      var16 = var15;
      phi2 = arg0;
      phi3 = var0;
      phi4 = arg2;
      phi5 = var1;
      phi6 = var16;
      break If_15_0;
     } else {
      // line number 98
      // Here was a goto statement
      phi2 = arg0;
      phi3 = var0;
      phi4 = arg2;
      phi5 = var1;
      phi6 = null;
      break If_15_0;
     }
    }
    var7 = phi6;
    // line number 99
    If_32_0: {
     if (var7 != null) {
      phi12 = var7;
      phi13 = var7;
      break If_32_0;
     } else {
      // line number 100
      var8 = new java$lang$IndexOutOfBoundsException();
      var9 = phi3;
      var10 = phi5;
      jdk$internal$util$Preconditions.$i;
      var11 = (jdk$internal$util$Preconditions.Ljava$lang$String$$outOfBoundsMessage$Ljava$lang$String$$Ljava$util$List$(var9,var10));
      java$lang$IndexOutOfBoundsException.prototype.V$$init$$Ljava$lang$String$.call(var8,var11);
      // Here was a goto statement
      phi12 = var7;
      phi13 = var8;
      break If_32_0;
     }
    }
    // line number 99
    return phi13;
  }

  static Ljava$lang$String$$outOfBoundsMessage$Ljava$lang$String$$Ljava$util$List$(arg0,arg1) {
    // source file is Preconditions.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var phi5 = null;
    var phi6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = 0;
    var var15 = null;
    var var16 = 0;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = 0;
    var var21 = null;
    var var22 = 0;
    var phi23 = 0;
    var phi24 = null;
    var phi25 = 0;
    var var26 = 0;
    var var27 = 0;
    var phi28 = 0;
    var var29 = null;
    var var30 = 0;
    var var31 = 0;
    var var32 = null;
    var phi33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = 0;
    var phi37 = null;
    var phi38 = 0;
    var var39 = 0;
    var var40 = 0;
    var var41 = null;
    var var42 = 0;
    var var43 = null;
    var var44 = null;
    var var45 = 0;
    var var46 = null;
    var var47 = null;
    var var48 = 0;
    var var49 = null;
    var var50 = null;
    var var51 = null;
    var var52 = 0;
    var var53 = null;
    var var54 = 0;
    var var55 = null;
    var var56 = null;
    var var57 = 0;
    var var58 = null;
    var var59 = null;
    var var60 = 0;
    var var61 = null;
    var var62 = null;
    var var63 = null;
    var var64 = 0;
    var var65 = null;
    var var66 = 0;
    var var67 = null;
    var var68 = null;
    var var69 = 0;
    var var70 = null;
    var var71 = null;
    var var72 = null;
    var var73 = 0;
    var var74 = null;
    var var75 = 0;
    var var76 = null;
    var var77 = 0;
    var var78 = null;
    var var79 = null;
    var var80 = null;
    var var81 = 0;
    var var82 = 0;
    var var83 = null;
    var var84 = 0;
    var var85 = 0;
    var var86 = 0;
    var var87 = 0;
    var var88 = null;
    var var89 = 0;
    var var90 = 0;
    var var91 = 0;
    var var92 = 0;
    var var93 = 0;
    var var94 = 0;
    var var95 = 0;
    var0 = arg1;
    // line number 219
    If_7_0: {
     if (arg0 != null) {
      phi5 = arg0;
      phi6 = var0;
      break If_7_0;
     } else {
      var1 = var0;
      if (var1 != null) {
       phi5 = arg0;
       phi6 = var0;
       break If_7_0;
      } else {
       // line number 220
       var2 = (0) | 0;
       var3 = bytecoder.newarray((var2),null);
       var4 = (java$lang$String.Ljava$lang$String$$format$Ljava$lang$String$$$Ljava$lang$Object$(bytecoder.stringconstants[107],var3));
       return var4;
      }
     }
    }
    // line number 221
    var7 = phi5;
    if (var7 != null) {
     // line number 223
     var13 = phi6;
     if (var13 != null) {
      // line number 227
      // line number 228
      var19 = phi5;
      var20 = (-1) | 0;
      var21 = var19;
      var22 = ((java$lang$String.prototype.I$hashCode$$.call(var21))) | 0;
      LookupSwitch_100_0: {
       switch (var22) {
        case 1844394469: {
         var92 = (java$lang$String.prototype.Z$equals$Ljava$lang$Object$.call(var19,bytecoder.stringconstants[113]));
         if (var92 == 0) {
          phi23 = (0) | 0;
          phi24 = var19;
          phi25 = (var20) | 0;
          break LookupSwitch_100_0;
         } else {
          var93 = (1) | 0;
          // Here was a goto statement
          phi23 = (0) | 0;
          phi24 = var19;
          phi25 = (var93) | 0;
          break LookupSwitch_100_0;
         }
        }
        case -538822486: {
         var94 = (java$lang$String.prototype.Z$equals$Ljava$lang$Object$.call(var19,bytecoder.stringconstants[114]));
         if (var94 == 0) {
          phi23 = (0) | 0;
          phi24 = var19;
          phi25 = (var20) | 0;
          break LookupSwitch_100_0;
         } else {
          var95 = (0) | 0;
          // Here was a goto statement
          phi23 = (0) | 0;
          phi24 = var19;
          phi25 = (var95) | 0;
          break LookupSwitch_100_0;
         }
        }
        case 1848935233: {
         var90 = (java$lang$String.prototype.Z$equals$Ljava$lang$Object$.call(var19,bytecoder.stringconstants[97]));
         if (var90 == 0) {
          phi23 = (0) | 0;
          phi24 = var19;
          phi25 = (var20) | 0;
          break LookupSwitch_100_0;
         } else {
          var91 = (2) | 0;
          phi23 = (0) | 0;
          phi24 = var19;
          phi25 = (var91) | 0;
          break LookupSwitch_100_0;
         }
        }
        default: {
         phi23 = (0) | 0;
         phi24 = var19;
         phi25 = (var20) | 0;
         break LookupSwitch_100_0;
        }
       }
      }
      var26 = (phi25) | 0;
      TableSwitch_108_0: {
       if ((var26) >= 0 && (var26) <= 2) switch ((var26) - 0) {
        case 0: {
         // line number 230
         var89 = (2) | 0;
         // line number 231
         // Here was a goto statement
         phi28 = (var89) | 0;
         break TableSwitch_108_0;
        }
        case 1: {
         // line number 234
         var27 = (3) | 0;
         // line number 235
         // Here was a goto statement
         phi28 = (var27) | 0;
         break TableSwitch_108_0;
        }
        case 2: {
         // line number 234
         var27 = (3) | 0;
         // line number 235
         // Here was a goto statement
         phi28 = (var27) | 0;
         break TableSwitch_108_0;
        }
       } else {
        phi28 = (phi23) | 0;
        break TableSwitch_108_0;
       }
      }
      // line number 240
      var29 = phi6;
      var30 = ((var29.I$size$$())) | 0;
      var31 = (phi28) | 0;
      If_129_0: {
       if (var30 == var31) {
        var88 = phi5;
        phi33 = var88;
        break If_129_0;
       } else {
        var32 = bytecoder.stringconstants[1];
        // Here was a goto statement
        phi33 = var32;
        break If_129_0;
       }
      }
      var34 = phi33;
      var35 = var34;
      var36 = ((java$lang$String.prototype.I$hashCode$$.call(var35))) | 0;
      LookupSwitch_146_0: {
       switch (var36) {
        case 1848935233: {
         var80 = bytecoder.stringconstants[97];
         var81 = (java$lang$String.prototype.Z$equals$Ljava$lang$Object$.call(var34,var80));
         if (var81 == 0) {
          phi37 = var34;
          phi38 = (-1) | 0;
          break LookupSwitch_146_0;
         } else {
          var82 = (2) | 0;
          phi37 = var34;
          phi38 = (var82) | 0;
          break LookupSwitch_146_0;
         }
        }
        case -538822486: {
         var86 = (java$lang$String.prototype.Z$equals$Ljava$lang$Object$.call(var34,bytecoder.stringconstants[114]));
         if (var86 == 0) {
          phi37 = var34;
          phi38 = (-1) | 0;
          break LookupSwitch_146_0;
         } else {
          var87 = (0) | 0;
          // Here was a goto statement
          phi37 = var34;
          phi38 = (var87) | 0;
          break LookupSwitch_146_0;
         }
        }
        case 1844394469: {
         var83 = bytecoder.stringconstants[113];
         var84 = (java$lang$String.prototype.Z$equals$Ljava$lang$Object$.call(var34,var83));
         if (var84 == 0) {
          phi37 = var34;
          phi38 = (-1) | 0;
          break LookupSwitch_146_0;
         } else {
          var85 = (1) | 0;
          // Here was a goto statement
          phi37 = var34;
          phi38 = (var85) | 0;
          break LookupSwitch_146_0;
         }
        }
        default: {
         phi37 = var34;
         phi38 = (-1) | 0;
         break LookupSwitch_146_0;
        }
       }
      }
      var39 = (phi38) | 0;
      if ((var39) >= 0 && (var39) <= 2) switch ((var39) - 0) {
       case 0: {
        // line number 242
        var64 = (2) | 0;
        var65 = bytecoder.newarray((var64),null);
        var66 = (0) | 0;
        var67 = phi6;
        // line number 243
        var68 = (var67.Ljava$lang$Object$$get$I(0));
        var65.data[var66] = var68;
        var69 = (1) | 0;
        var70 = phi6;
        var71 = (var70.Ljava$lang$Object$$get$I(1));
        var65.data[var69] = var71;
        // line number 242
        var72 = (java$lang$String.Ljava$lang$String$$format$Ljava$lang$String$$$Ljava$lang$Object$(bytecoder.stringconstants[111],var65));
        return var72;
       }
       case 1: {
        // line number 245
        var52 = (3) | 0;
        var53 = bytecoder.newarray((var52),null);
        var54 = (0) | 0;
        var55 = phi6;
        // line number 246
        var56 = (var55.Ljava$lang$Object$$get$I(0));
        var53.data[var54] = var56;
        var57 = (1) | 0;
        var58 = phi6;
        var59 = (var58.Ljava$lang$Object$$get$I(1));
        var53.data[var57] = var59;
        var60 = (2) | 0;
        var61 = phi6;
        var62 = (var61.Ljava$lang$Object$$get$I(2));
        var53.data[var60] = var62;
        // line number 245
        var63 = (java$lang$String.Ljava$lang$String$$format$Ljava$lang$String$$$Ljava$lang$Object$(bytecoder.stringconstants[110],var53));
        return var63;
       }
       case 2: {
        // line number 248
        var40 = (3) | 0;
        var41 = bytecoder.newarray((var40),null);
        var42 = (0) | 0;
        var43 = phi6;
        // line number 249
        var44 = (var43.Ljava$lang$Object$$get$I(0));
        var41.data[var42] = var44;
        var45 = (1) | 0;
        var46 = phi6;
        var47 = (var46.Ljava$lang$Object$$get$I(1));
        var41.data[var45] = var47;
        var48 = (2) | 0;
        var49 = phi6;
        var50 = (var49.Ljava$lang$Object$$get$I(2));
        var41.data[var48] = var50;
        // line number 248
        var51 = (java$lang$String.Ljava$lang$String$$format$Ljava$lang$String$$$Ljava$lang$Object$(bytecoder.stringconstants[109],var41));
        return var51;
       }
      } else {
       // line number 251
       var73 = (2) | 0;
       var74 = bytecoder.newarray((var73),null);
       var75 = (0) | 0;
       var76 = phi5;
       var74.data[var75] = var76;
       var77 = (1) | 0;
       var78 = phi6;
       var74.data[var77] = var78;
       var79 = (java$lang$String.Ljava$lang$String$$format$Ljava$lang$String$$$Ljava$lang$Object$(bytecoder.stringconstants[112],var74));
       return var79;
      }
     } else {
      // line number 224
      var14 = (1) | 0;
      var15 = bytecoder.newarray((var14),null);
      var16 = (0) | 0;
      var17 = phi5;
      var15.data[var16] = var17;
      var18 = (java$lang$String.Ljava$lang$String$$format$Ljava$lang$String$$$Ljava$lang$Object$(bytecoder.stringconstants[108],var15));
      return var18;
     }
    } else {
     // line number 222
     var8 = (1) | 0;
     var9 = bytecoder.newarray((var8),null);
     var10 = (0) | 0;
     var11 = phi6;
     var9.data[var10] = var11;
     var12 = (java$lang$String.Ljava$lang$String$$format$Ljava$lang$String$$$Ljava$lang$Object$(bytecoder.stringconstants[108],var9));
     return var12;
    }
  }

  V$$init$$$() {
    // source file is Preconditions.java
    // line number 37
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }

  static I$checkIndex$I$I$Ljava$util$function$BiFunction$(arg0,arg1,arg2) {
    // source file is Preconditions.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    var phi3 = 0;
    var phi4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var var8 = null;
    var0 = (arg1) | 0;
    // line number 301
    If_8_0: {
     if (arg0 < 0) {
      phi2 = (arg0) | 0;
      phi3 = (var0) | 0;
      phi4 = arg2;
      break If_8_0;
     } else {
      var1 = (arg0) | 0;
      if (var1 < var0) {
       // line number 303
       return arg0;
      } else {
       phi2 = (arg0) | 0;
       phi3 = (var0) | 0;
       phi4 = arg2;
       break If_8_0;
      }
     }
    }
    // line number 302
    var5 = phi4;
    var6 = (phi2) | 0;
    var7 = (phi3) | 0;
    jdk$internal$util$Preconditions.$i;
    var8 = (jdk$internal$util$Preconditions.Ljava$lang$RuntimeException$$outOfBoundsCheckIndex$Ljava$util$function$BiFunction$$I$I(var5,var6,var7));
    throw bytecoder.registerStack(var8, new Error().stack);
  }

  static Ljava$lang$RuntimeException$$outOfBoundsCheckIndex$Ljava$util$function$BiFunction$$I$I(arg0,arg1,arg2) {
    // source file is Preconditions.java
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var0 = (arg1) | 0;
    // line number 106
    var1 = bytecoder.stringconstants[114];
    var2 = bytecoder.newarray((2),null);
    var3 = (0) | 0;
    java$lang$Integer.$i;
    var4 = (java$lang$Integer.Ljava$lang$Integer$$valueOf$I(var0));
    var2.data[var3] = var4;
    var5 = (1) | 0;
    var6 = (java$lang$Integer.Ljava$lang$Integer$$valueOf$I(arg2));
    var2.data[var5] = var6;
    jdk$internal$util$Preconditions.$i;
    var7 = (jdk$internal$util$Preconditions.Ljava$lang$RuntimeException$$outOfBounds$Ljava$util$function$BiFunction$$Ljava$lang$String$$$Ljava$lang$Number$(arg0,var1,var2));
    return var7;
  }
}


class java$util$ImmutableCollections extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;
  static SALT32L = 0;
  static REVERSE = false;
  static archivedObjects = null;
  static EMPTY = null;
  static EMPTY_LIST = null;
  static EMPTY_LIST_NULLS = null;
  static EMPTY_SET = null;
  static EMPTY_MAP = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$ImmutableCollections,[java$lang$Object,java$util$ImmutableCollections]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is ImmutableCollections.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var phi7 = 0;
    var phi8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = 0;
    var var17 = 0;
    var var18 = 0;
    var var19 = 0;
    var phi20 = 0;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = 0;
    var var25 = null;
    var var26 = null;
    var var27 = 0;
    var var28 = null;
    var var29 = null;
    var var30 = 0;
    var var31 = null;
    var var32 = null;
    var var33 = 0;
    var var34 = null;
    var var35 = null;
    var var36 = 0;
    var var37 = null;
    var var38 = 0;
    var var39 = null;
    var var40 = null;
    var var41 = null;
    var var42 = null;
    var var43 = null;
    var var44 = null;
    var var45 = null;
    var var46 = null;
    var var47 = null;
    var var48 = null;
    var var49 = null;
    var var50 = null;
    var var51 = null;
    var var52 = null;
    var var53 = null;
    var var54 = null;
    var var55 = null;
    var var56 = null;
    // line number 51
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(java$util$ImmutableCollections.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    java$util$ImmutableCollections.$i;
    java$util$ImmutableCollections.$assertionsDisabled = phi2;
    // line number 74
    // line number 80
    jdk$internal$misc$CDS.$i;
    var3 = (jdk$internal$misc$CDS.J$getRandomSeedForDumping$$());
    // line number 81
    var4 = 0;
    var5 = (bytecoder.cmp(var3,var4)) | 0;
    If_38_0: {
     if (var5 != 0) {
      phi7 = 2611923443488327891;
      phi8 = var3;
      break If_38_0;
     } else {
      // line number 82
      java$lang$System.$i;
      var6 = (java$lang$System.J$nanoTime$$());
      phi7 = 2611923443488327891;
      phi8 = var6;
      break If_38_0;
     }
    }
    // line number 84
    var9 = phi7;
    var10 = phi8;
    var11 = (var9 * var10);
    var12 = (var11 >> 16);
    var13 = ((var12 | 0)) | 0;
    var14 = (var13 | 0);
    var15 = (var14 & 4294967295);
    java$util$ImmutableCollections.SALT32L = var15;
    // line number 86
    var16 = (java$util$ImmutableCollections.SALT32L);
    var17 = (var16 & 1);
    var18 = (bytecoder.cmp(var17,0)) | 0;
    If_90_0: {
     if (var18 != 0) {
      phi20 = (0) | 0;
      break If_90_0;
     } else {
      var19 = (1) | 0;
      // Here was a goto statement
      phi20 = (var19) | 0;
      break If_90_0;
     }
    }
    java$util$ImmutableCollections.REVERSE = phi20;
    // line number 102
    jdk$internal$misc$CDS.V$initializeFromArchive$Ljava$lang$Class$(java$util$ImmutableCollections.$rt);
    // line number 103
    var21 = (java$util$ImmutableCollections.archivedObjects);
    If_113_0: {
     if (var21 != null) {
      // line number 112
      var43 = (java$util$ImmutableCollections.archivedObjects);
      var44 = (var43.data[0]);
      java$util$ImmutableCollections.EMPTY = var44;
      // line number 113
      var45 = (java$util$ImmutableCollections.archivedObjects);
      var46 = (var45.data[1]);
      var47 = var46;
      java$util$ImmutableCollections.EMPTY_LIST = var47;
      // line number 114
      var48 = (java$util$ImmutableCollections.archivedObjects);
      var49 = (var48.data[2]);
      var50 = var49;
      java$util$ImmutableCollections.EMPTY_LIST_NULLS = var50;
      // line number 115
      var51 = (java$util$ImmutableCollections.archivedObjects);
      var52 = (var51.data[3]);
      var53 = var52;
      java$util$ImmutableCollections.EMPTY_SET = var53;
      // line number 116
      var54 = (java$util$ImmutableCollections.archivedObjects);
      var55 = (var54.data[4]);
      var56 = var55;
      java$util$ImmutableCollections.EMPTY_MAP = var56;
      break If_113_0;
     } else {
      // line number 104
      var22 = new java$lang$Object();
      java$lang$Object.prototype.V$$init$$$.call(var22);
      java$util$ImmutableCollections.EMPTY = var22;
      // line number 105
      var23 = new java$util$ImmutableCollections$ListN();
      var24 = (0) | 0;
      var25 = bytecoder.newarray((var24),null);
      java$util$ImmutableCollections$ListN.prototype.V$$init$$$Ljava$lang$Object$$Z.call(var23,var25,0);
      java$util$ImmutableCollections.EMPTY_LIST = var23;
      // line number 106
      var26 = new java$util$ImmutableCollections$ListN();
      var27 = (0) | 0;
      var28 = bytecoder.newarray((var27),null);
      java$util$ImmutableCollections$ListN.prototype.V$$init$$$Ljava$lang$Object$$Z.call(var26,var28,1);
      java$util$ImmutableCollections.EMPTY_LIST_NULLS = var26;
      // line number 107
      var29 = new java$util$ImmutableCollections$SetN();
      var30 = (0) | 0;
      var31 = bytecoder.newarray((var30),null);
      java$util$ImmutableCollections$SetN.prototype.V$$init$$$Ljava$lang$Object$.call(var29,var31);
      java$util$ImmutableCollections.EMPTY_SET = var29;
      // line number 108
      var32 = new java$util$ImmutableCollections$MapN();
      var33 = (0) | 0;
      var34 = bytecoder.newarray((var33),null);
      java$util$ImmutableCollections$MapN.prototype.V$$init$$$Ljava$lang$Object$.call(var32,var34);
      java$util$ImmutableCollections.EMPTY_MAP = var32;
      // line number 109
      var35 = bytecoder.newarray((5),null);
      var36 = (0) | 0;
      var37 = (java$util$ImmutableCollections.EMPTY);
      var35.data[var36] = var37;
      var38 = (1) | 0;
      var39 = (java$util$ImmutableCollections.EMPTY_LIST);
      var35.data[var38] = var39;
      var40 = (java$util$ImmutableCollections.EMPTY_LIST_NULLS);
      var35.data[2] = var40;
      var41 = (java$util$ImmutableCollections.EMPTY_SET);
      var35.data[3] = var41;
      var42 = (java$util$ImmutableCollections.EMPTY_MAP);
      var35.data[4] = var42;
      java$util$ImmutableCollections.archivedObjects = var35;
      // Here was a goto statement
      break If_113_0;
     }
    }
    // line number 118
    return;
  }

  static Ljava$util$List$$listFromArray$$Ljava$lang$Object$(arg0) {
    // source file is ImmutableCollections.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var phi3 = null;
    var phi4 = null;
    var phi5 = 0;
    var var6 = 0;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = 0;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    // line number 188
    var0 = (arg0.data.length) | 0;
    var1 = bytecoder.newarray((var0),null);
    // line number 189
    var2 = (0) | 0;
    phi3 = arg0;
    phi4 = var1;
    phi5 = (var2) | 0;
    L656288727: while(true) {
     var6 = (phi5) | 0;
     var7 = phi3;
     var8 = (var7.data.length) | 0;
     if (var6 >= var8) {
      // line number 192
      var15 = new java$util$ImmutableCollections$ListN();
      var16 = phi4;
      java$util$ImmutableCollections$ListN.prototype.V$$init$$$Ljava$lang$Object$$Z.call(var15,var16,0);
      return var15;
     } else {
      // line number 190
      var9 = phi4;
      var10 = (phi5) | 0;
      var11 = phi3;
      var12 = (phi5) | 0;
      var13 = (var11.data[var12]);
      var14 = (java$util$Objects.Ljava$lang$Object$$requireNonNull$Ljava$lang$Object$(var13));
      var9.data[var10] = var14;
      // line number 189
      phi5 = ((phi5 + 1)) | 0;
      // Here was a goto statement
      continue L656288727;
     }
    }
  }

  static Ljava$lang$UnsupportedOperationException$$uoe$$() {
    // source file is ImmutableCollections.java
    var var0 = null;
    // line number 142
    var0 = new java$lang$UnsupportedOperationException();
    java$lang$UnsupportedOperationException.prototype.V$$init$$$.call(var0);
    return var0;
  }

  V$$init$$$() {
    // source file is ImmutableCollections.java
    // line number 134
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class java$util$Dictionary extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$Dictionary,[java$lang$Object,java$util$Dictionary]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is Dictionary.java
    // line number 57
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 58
    return;
  }
}


class jdk$internal$access$JavaNioAccess extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(jdk$internal$access$JavaNioAccess,[jdk$internal$access$JavaNioAccess,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class org$luaj$vm2$compiler$LexState$Vardesc extends java$lang$Object {
  nativeObject = null;

  idx = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$compiler$LexState$Vardesc,[org$luaj$vm2$compiler$LexState$Vardesc,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$I(arg0) {
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var0 = (arg0) | 0;
    java$lang$Object.prototype.V$$init$$$.call(this);
    var1 = this;
    var2 = var0;
    var1.idx = var2;
    return;
  }
}


class org$luaj$vm2$Prototype extends java$lang$Object {
  nativeObject = null;

  static NOUPVALUES = null;
  static NOSUBPROTOS = null;
  upvalues = null;
  source = null;
  linedefined = 0;
  lastlinedefined = 0;
  p = null;
  maxstacksize = 0;
  numparams = 0;
  code = null;
  k = null;
  lineinfo = null;
  is_vararg = 0;
  locvars = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$Prototype,[java$lang$Object,org$luaj$vm2$Prototype]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    var var0 = null;
    var var1 = null;
    var0 = bytecoder.newarray((0),null);
    org$luaj$vm2$Prototype.$i;
    org$luaj$vm2$Prototype.NOUPVALUES = var0;
    var1 = bytecoder.newarray((0),null);
    org$luaj$vm2$Prototype.NOSUBPROTOS = var1;
    return;
  }

  Ljava$lang$String$$toString$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var0 = new java$lang$StringBuffer();
    java$lang$StringBuffer.prototype.V$$init$$$.call(var0);
    var1 = (this.source);
    var2 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$Object$.call(var0,var1));
    var3 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var2,bytecoder.stringconstants[153]));
    var4 = ((this.linedefined)) | 0;
    var5 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var3,var4));
    var6 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var5,bytecoder.stringconstants[154]));
    var7 = ((this.lastlinedefined)) | 0;
    var8 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var6,var7));
    var9 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var8));
    return var9;
  }

  V$$init$$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    java$lang$Object.prototype.V$$init$$$.call(this);
    var0 = this;
    org$luaj$vm2$Prototype.$i;
    var1 = (org$luaj$vm2$Prototype.NOSUBPROTOS);
    var0.p = var1;
    var2 = this;
    var3 = (org$luaj$vm2$Prototype.NOUPVALUES);
    var2.upvalues = var3;
    return;
  }

  Ljava$lang$String$$shortsource$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = 0;
    var phi6 = null;
    var phi7 = null;
    var var8 = null;
    var var9 = null;
    var phi10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = 0;
    var var14 = null;
    var0 = (this.source);
    var1 = (org$luaj$vm2$LuaString.prototype.Ljava$lang$String$$tojstring$$.call(var0));
    var2 = var1;
    var3 = (java$lang$String.prototype.Z$startsWith$Ljava$lang$String$.call(var2,bytecoder.stringconstants[186]));
    If_14_0: {
     If_14_1: {
      if (var3 != 0) {
       phi6 = this;
       phi7 = var1;
       break If_14_1;
      } else {
       var4 = var1;
       var5 = (java$lang$String.prototype.Z$startsWith$Ljava$lang$String$.call(var4,bytecoder.stringconstants[155]));
       if (var5 == 0) {
        var12 = bytecoder.stringconstants[187];
        var13 = (java$lang$String.prototype.Z$startsWith$Ljava$lang$String$.call(var1,var12));
        if (var13 == 0) {
         phi6 = this;
         phi10 = var1;
         break If_14_0;
        } else {
         var14 = bytecoder.stringconstants[188];
         phi6 = this;
         phi10 = var14;
         break If_14_0;
        }
       } else {
        phi6 = this;
        phi7 = var1;
        break If_14_1;
       }
      }
     }
     var8 = phi7;
     var9 = (java$lang$String.prototype.Ljava$lang$String$$substring$I.call(var8,1));
     // Here was a goto statement
     phi10 = var9;
     break If_14_0;
    }
    var11 = phi10;
    return var11;
  }

  Lorg$luaj$vm2$LuaString$$getlocalname$I$I(arg0,arg1) {
    var var0 = 0;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    var phi4 = 0;
    var phi5 = 0;
    var var6 = 0;
    var var7 = null;
    var var8 = null;
    var var9 = 0;
    var var10 = null;
    var var11 = null;
    var var12 = 0;
    var var13 = null;
    var var14 = 0;
    var var15 = 0;
    var var16 = 0;
    var var17 = null;
    var var18 = null;
    var var19 = 0;
    var var20 = null;
    var var21 = 0;
    var var22 = 0;
    var var23 = null;
    var var24 = null;
    var var25 = 0;
    var var26 = null;
    var var27 = null;
    var0 = (arg0) | 0;
    var1 = (0) | 0;
    phi2 = this;
    phi3 = (var0) | 0;
    phi4 = (arg1) | 0;
    phi5 = (var1) | 0;
    L904432720: while(true) {
     var6 = (phi5) | 0;
     var7 = phi2;
     var8 = (var7.locvars);
     var9 = (var8.data.length) | 0;
     If_24_0: {
      if (var6 >= var9) {
       break If_24_0;
      } else {
       var10 = phi2;
       var11 = (var10.locvars);
       var12 = (phi5) | 0;
       var13 = (var11.data[var12]);
       var14 = ((var13.startpc)) | 0;
       var15 = (phi4) | 0;
       if (var14 > var15) {
        break If_24_0;
       } else {
        var16 = (phi4) | 0;
        var17 = phi2;
        var18 = (var17.locvars);
        var19 = (phi5) | 0;
        var20 = (var18.data[var19]);
        var21 = ((var20.endpc)) | 0;
        If_58_0: {
         if (var16 >= var21) {
          break If_58_0;
         } else {
          phi3 = ((phi3 + -1)) | 0;
          var22 = (phi3) | 0;
          if (var22 != 0) {
           break If_58_0;
          } else {
           var23 = phi2;
           var24 = (var23.locvars);
           var25 = (phi5) | 0;
           var26 = (var24.data[var25]);
           var27 = (var26.varname);
           return var27;
          }
         }
        }
        phi5 = ((phi5 + 1)) | 0;
        // Here was a goto statement
        continue L904432720;
       }
      }
     }
     return null;
    }
  }
}


class jdk$internal$misc$Unsafe extends java$lang$Object {
  nativeObject = null;

  static INSTANCE = null;
  static ARRAY_BOOLEAN_INDEX_SCALE = 0;
  static ARRAY_BYTE_INDEX_SCALE = 0;
  static ARRAY_CHAR_INDEX_SCALE = 0;
  static ARRAY_SHORT_INDEX_SCALE = 0;
  static ARRAY_INT_INDEX_SCALE = 0;
  static ARRAY_LONG_INDEX_SCALE = 0;
  static ARRAY_FLOAT_INDEX_SCALE = 0;
  static ARRAY_DOUBLE_INDEX_SCALE = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(jdk$internal$misc$Unsafe,[java$lang$Object,jdk$internal$misc$Unsafe]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is Unsafe.java
    var var0 = null;
    // line number 23
    jdk$internal$misc$Unsafe.$i;
    var0 = new jdk$internal$misc$Unsafe();
    jdk$internal$misc$Unsafe.prototype.V$$init$$$.call(var0);
    jdk$internal$misc$Unsafe.INSTANCE = var0;
    return;
  }

  V$$init$$$() {
    // source file is Unsafe.java
    // line number 21
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }

  static Ljdk$internal$misc$Unsafe$$getUnsafe$$() {
    // source file is Unsafe.java
    var var0 = null;
    // line number 26
    jdk$internal$misc$Unsafe.$i;
    var0 = (jdk$internal$misc$Unsafe.INSTANCE);
    return var0;
  }

  V$storeFence$$() {
    // source file is Unsafe.java
    // line number 59
    return;
  }

  I$arrayBaseOffset$Ljava$lang$Class$(arg0) {
    // source file is Unsafe.java
    var var0 = null;
    var0 = arg0;
    // line number 46
    return 0;
  }

  I$arrayIndexScale$Ljava$lang$Class$(arg0) {
    // source file is Unsafe.java
    var var0 = null;
    var0 = arg0;
    // line number 51
    return 0;
  }

  Z$isBigEndian$$() {
    // source file is Unsafe.java
    // line number 65
    return 0;
  }

  J$getLongUnaligned$Ljava$lang$Object$$J(arg0,arg1) {
    // source file is Unsafe.java
    var var0 = null;
    var0 = arg0;
    // line number 69
    return arg1;
  }

  I$getIntUnaligned$Ljava$lang$Object$$J(arg0,arg1) {
    // source file is Unsafe.java
    var var0 = null;
    var var1 = 0;
    var0 = arg0;
    // line number 77
    var1 = ((arg1 | 0)) | 0;
    return var1;
  }

  V$copyMemory$Ljava$lang$Object$$J$Ljava$lang$Object$$J$J(arg0,arg1,arg2,arg3,arg4) {
    // source file is Unsafe.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var0 = arg0;
    var1 = arg2;
    var2 = arg4;
    // line number 168
    return;
  }

  V$copySwapMemory$Ljava$lang$Object$$J$Ljava$lang$Object$$J$J$J(arg0,arg1,arg2,arg3,arg4,arg5) {
    // source file is Unsafe.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var0 = arg0;
    var1 = arg2;
    var2 = arg4;
    // line number 174
    return;
  }
}


class org$luaj$vm2$lib$DebugLib$NameWhat extends java$lang$Object {
  nativeObject = null;

  name = null;
  namewhat = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$lib$DebugLib$NameWhat,[java$lang$Object,org$luaj$vm2$lib$DebugLib$NameWhat]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Ljava$lang$String$$Ljava$lang$String$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    java$lang$Object.prototype.V$$init$$$.call(this);
    var1 = this;
    var1.name = var0;
    var2 = this;
    var2.namewhat = arg1;
    return;
  }
}


class de$mirkosertic$bytecoder$api$OpaqueReferenceType extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(de$mirkosertic$bytecoder$api$OpaqueReferenceType,[java$lang$Object,de$mirkosertic$bytecoder$api$OpaqueReferenceType]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class org$luaj$vm2$Upvaldesc extends java$lang$Object {
  nativeObject = null;

  name = null;
  idx = 0;
  instack = false;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$Upvaldesc,[java$lang$Object,org$luaj$vm2$Upvaldesc]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Lorg$luaj$vm2$LuaString$$Z$I(arg0,arg1,arg2) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var0 = arg0;
    var1 = (arg2) | 0;
    java$lang$Object.prototype.V$$init$$$.call(this);
    var2 = this;
    var2.name = var0;
    var3 = this;
    var3.instack = arg1;
    var4 = this;
    var5 = var1;
    var4.idx = var5;
    return;
  }

  Ljava$lang$String$$toString$$() {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var phi5 = null;
    var phi6 = null;
    var phi7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var0 = new java$lang$StringBuffer();
    java$lang$StringBuffer.prototype.V$$init$$$.call(var0);
    var1 = (this.idx);
    var2 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var0,var1));
    var3 = (this.instack);
    If_17_0: {
     if (var3 == 0) {
      phi5 = this;
      phi6 = var2;
      phi7 = bytecoder.stringconstants[381];
      break If_17_0;
     } else {
      var4 = bytecoder.stringconstants[380];
      // Here was a goto statement
      phi5 = this;
      phi6 = var2;
      phi7 = var4;
      break If_17_0;
     }
    }
    var8 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(phi6,phi7));
    var9 = phi5;
    var10 = (var9.name);
    var11 = (java$lang$String.Ljava$lang$String$$valueOf$Ljava$lang$Object$(var10));
    var12 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var8,var11));
    var13 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var12));
    return var13;
  }
}


class java$lang$AbstractStringBuilder extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$AbstractStringBuilder,[java$lang$Object,java$lang$AbstractStringBuilder]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class java$util$concurrent$locks$Lock extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$concurrent$locks$Lock,[java$util$concurrent$locks$Lock,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class java$util$Map$Entry extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$Map$Entry,[java$lang$Object,java$util$Map$Entry]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class java$nio$BufferMismatch extends java$lang$Object {
  nativeObject = null;

  static SCOPED_MEMORY_ACCESS = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$nio$BufferMismatch,[java$lang$Object,java$nio$BufferMismatch]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is BufferMismatch.java
    var var0 = null;
    // line number 35
    jdk$internal$misc$ScopedMemoryAccess.$i;
    var0 = (jdk$internal$misc$ScopedMemoryAccess.Ljdk$internal$misc$ScopedMemoryAccess$$getScopedMemoryAccess$$());
    java$nio$BufferMismatch.$i;
    java$nio$BufferMismatch.SCOPED_MEMORY_ACCESS = var0;
    return;
  }

  static I$mismatch$Ljava$nio$CharBuffer$$I$Ljava$nio$CharBuffer$$I$I(arg0,arg1,arg2,arg3,arg4) {
    // source file is BufferMismatch.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = 0;
    var var11 = 0;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = 0;
    var var17 = 0;
    var var18 = 0;
    var var19 = 0;
    var var20 = 0;
    var var21 = null;
    var var22 = 0;
    var var23 = 0;
    var var24 = 0;
    var var25 = 0;
    var var26 = 0;
    var var27 = 0;
    var var28 = 0;
    var var29 = 0;
    var var30 = 0;
    var var31 = 0;
    var var32 = 0;
    var phi33 = null;
    var phi34 = 0;
    var phi35 = null;
    var phi36 = 0;
    var phi37 = 0;
    var phi38 = 0;
    var var39 = 0;
    var var40 = 0;
    var var41 = null;
    var var42 = 0;
    var var43 = 0;
    var var44 = 0;
    var var45 = 0;
    var var46 = null;
    var var47 = 0;
    var var48 = 0;
    var var49 = 0;
    var var50 = 0;
    var var51 = 0;
    var0 = (arg1) | 0;
    var1 = (arg3) | 0;
    // line number 58
    // line number 62
    var2 = (3) | 0;
    If_18_0: {
     if (arg4 <= var2) {
      phi33 = arg0;
      phi34 = (var0) | 0;
      phi35 = arg2;
      phi36 = (var1) | 0;
      phi37 = (arg4) | 0;
      phi38 = (0) | 0;
      break If_18_0;
     } else {
      var3 = arg0;
      var4 = (var3.Ljava$nio$ByteOrder$$charRegionOrder$$());
      var5 = (arg2.Ljava$nio$ByteOrder$$charRegionOrder$$());
      if (var4 != var5) {
       phi33 = arg0;
       phi34 = (var0) | 0;
       phi35 = arg2;
       phi36 = (var1) | 0;
       phi37 = (arg4) | 0;
       phi38 = (0) | 0;
       break If_18_0;
      } else {
       var6 = arg0;
       // line number 63
       var7 = (var6.Ljava$nio$ByteOrder$$charRegionOrder$$());
       if (var7 == null) {
        phi33 = arg0;
        phi34 = (var0) | 0;
        phi35 = arg2;
        phi36 = (var1) | 0;
        phi37 = (arg4) | 0;
        phi38 = (0) | 0;
        break If_18_0;
       } else {
        var8 = arg2;
        var9 = (var8.Ljava$nio$ByteOrder$$charRegionOrder$$());
        if (var9 == null) {
         phi33 = arg0;
         phi34 = (var0) | 0;
         phi35 = arg2;
         phi36 = (var1) | 0;
         phi37 = (arg4) | 0;
         phi38 = (0) | 0;
         break If_18_0;
        } else {
         // line number 64
         var10 = (arg0.C$get$I(var0));
         var11 = (arg2.C$get$I(var1));
         if (var10 == var11) {
          // line number 66
          java$nio$BufferMismatch.$i;
          var12 = (java$nio$BufferMismatch.SCOPED_MEMORY_ACCESS);
          var13 = (arg0.Ljdk$internal$foreign$MemorySessionImpl$$session$$());
          var14 = (arg2.Ljdk$internal$foreign$MemorySessionImpl$$session$$());
          // line number 67
          var15 = (java$nio$CharBuffer.prototype.Ljava$lang$Object$$base$$.call(arg0));
          var16 = (arg0.address);
          jdk$internal$util$ArraysSupport.$i;
          var17 = ((jdk$internal$util$ArraysSupport.LOG2_ARRAY_CHAR_INDEX_SCALE)) | 0;
          var18 = ((var0 << var17)) | 0;
          var19 = (var18 | 0);
          var20 = (var16 + var19);
          // line number 68
          var21 = (java$nio$CharBuffer.prototype.Ljava$lang$Object$$base$$.call(arg2));
          var22 = (arg2.address);
          var23 = ((jdk$internal$util$ArraysSupport.LOG2_ARRAY_CHAR_INDEX_SCALE)) | 0;
          var24 = ((var1 << var23)) | 0;
          var25 = (var24 | 0);
          var26 = (var22 + var25);
          var27 = ((jdk$internal$util$ArraysSupport.LOG2_ARRAY_CHAR_INDEX_SCALE)) | 0;
          // line number 66
          var28 = ((jdk$internal$misc$ScopedMemoryAccess.prototype.I$vectorizedMismatch$Ljdk$internal$foreign$MemorySessionImpl$$Ljdk$internal$foreign$MemorySessionImpl$$Ljava$lang$Object$$J$Ljava$lang$Object$$J$I$I.call(var12,var13,var14,var15,var20,var21,var26,arg4,var27))) | 0;
          // line number 71
          if (var28 < 0) {
           // line number 72
           var30 = (-1) | 0;
           var31 = ((var28 ^ var30)) | 0;
           var32 = ((arg4 - var31)) | 0;
           phi33 = arg0;
           phi34 = (var0) | 0;
           phi35 = arg2;
           phi36 = (var1) | 0;
           phi37 = (arg4) | 0;
           phi38 = (var32) | 0;
           break If_18_0;
          } else {
           var29 = (var28) | 0;
           return var29;
          }
         } else {
          // line number 65
          return 0;
         }
        }
       }
      }
     }
    }
    L578080577: while(true) {
     // line number 74
     var39 = (phi38) | 0;
     var40 = (phi37) | 0;
     if (var39 >= var40) {
      // line number 78
      return -1;
     } else {
      // line number 75
      var41 = phi33;
      var42 = (phi34) | 0;
      var43 = (phi38) | 0;
      var44 = ((var42 + var43)) | 0;
      var45 = (var41.C$get$I(var44));
      var46 = phi35;
      var47 = (phi36) | 0;
      var48 = (phi38) | 0;
      var49 = ((var47 + var48)) | 0;
      var50 = (var46.C$get$I(var49));
      if (var45 == var50) {
       // line number 74
       phi38 = ((phi38 + 1)) | 0;
       // Here was a goto statement
       continue L578080577;
      } else {
       // line number 76
       var51 = (phi38) | 0;
       return var51;
      }
     }
    }
  }

  static I$mismatch$Ljava$nio$ByteBuffer$$I$Ljava$nio$ByteBuffer$$I$I(arg0,arg1,arg2,arg3,arg4) {
    // source file is BufferMismatch.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = null;
    var var13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = 0;
    var var17 = 0;
    var var18 = 0;
    var var19 = 0;
    var var20 = 0;
    var var21 = 0;
    var phi22 = null;
    var phi23 = 0;
    var phi24 = null;
    var phi25 = 0;
    var phi26 = 0;
    var phi27 = 0;
    var var28 = 0;
    var var29 = 0;
    var var30 = null;
    var var31 = 0;
    var var32 = 0;
    var var33 = 0;
    var var34 = 0;
    var var35 = null;
    var var36 = 0;
    var var37 = 0;
    var var38 = 0;
    var var39 = 0;
    var var40 = 0;
    var0 = (arg1) | 0;
    var1 = (arg3) | 0;
    // line number 38
    // line number 39
    var2 = (7) | 0;
    If_18_0: {
     if (arg4 <= var2) {
      phi22 = arg0;
      phi23 = (var0) | 0;
      phi24 = arg2;
      phi25 = (var1) | 0;
      phi26 = (arg4) | 0;
      phi27 = (0) | 0;
      break If_18_0;
     } else {
      // line number 40
      var3 = (arg0.B$get$I(var0));
      var4 = (arg2.B$get$I(var1));
      if (var3 == var4) {
       // line number 42
       java$nio$BufferMismatch.$i;
       var5 = (java$nio$BufferMismatch.SCOPED_MEMORY_ACCESS);
       var6 = (arg0.Ljdk$internal$foreign$MemorySessionImpl$$session$$());
       var7 = (arg2.Ljdk$internal$foreign$MemorySessionImpl$$session$$());
       // line number 43
       var8 = (java$nio$ByteBuffer.prototype.Ljava$lang$Object$$base$$.call(arg0));
       var9 = (arg0.address);
       var10 = (var0 | 0);
       var11 = (var9 + var10);
       // line number 44
       var12 = (java$nio$ByteBuffer.prototype.Ljava$lang$Object$$base$$.call(arg2));
       var13 = (arg2.address);
       var14 = (var1 | 0);
       var15 = (var13 + var14);
       jdk$internal$util$ArraysSupport.$i;
       var16 = ((jdk$internal$util$ArraysSupport.LOG2_ARRAY_BYTE_INDEX_SCALE)) | 0;
       // line number 42
       var17 = ((jdk$internal$misc$ScopedMemoryAccess.prototype.I$vectorizedMismatch$Ljdk$internal$foreign$MemorySessionImpl$$Ljdk$internal$foreign$MemorySessionImpl$$Ljava$lang$Object$$J$Ljava$lang$Object$$J$I$I.call(var5,var6,var7,var8,var11,var12,var15,arg4,var16))) | 0;
       // line number 47
       if (var17 < 0) {
        // line number 48
        var19 = (-1) | 0;
        var20 = ((var17 ^ var19)) | 0;
        var21 = ((arg4 - var20)) | 0;
        phi22 = arg0;
        phi23 = (var0) | 0;
        phi24 = arg2;
        phi25 = (var1) | 0;
        phi26 = (arg4) | 0;
        phi27 = (var21) | 0;
        break If_18_0;
       } else {
        var18 = (var17) | 0;
        return var18;
       }
      } else {
       // line number 41
       return 0;
      }
     }
    }
    L1145597730: while(true) {
     // line number 50
     var28 = (phi27) | 0;
     var29 = (phi26) | 0;
     if (var28 >= var29) {
      // line number 54
      return -1;
     } else {
      // line number 51
      var30 = phi22;
      var31 = (phi23) | 0;
      var32 = (phi27) | 0;
      var33 = ((var31 + var32)) | 0;
      var34 = (var30.B$get$I(var33));
      var35 = phi24;
      var36 = (phi25) | 0;
      var37 = (phi27) | 0;
      var38 = ((var36 + var37)) | 0;
      var39 = (var35.B$get$I(var38));
      if (var34 == var39) {
       // line number 50
       phi27 = ((phi27 + 1)) | 0;
       // Here was a goto statement
       continue L1145597730;
      } else {
       // line number 52
       var40 = (phi27) | 0;
       return var40;
      }
     }
    }
  }

  V$$init$$$() {
    // source file is BufferMismatch.java
    // line number 33
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class org$luaj$vm2$LuaTable$Slot extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$LuaTable$Slot,[java$lang$Object,org$luaj$vm2$LuaTable$Slot]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class java$lang$Throwable extends java$lang$Object {
  nativeObject = null;

  message = null;
  cause = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Throwable,[java$lang$Object,java$lang$Throwable]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  Ljava$lang$String$$getMessage$$() {
    // source file is Throwable.java
    var var0 = null;
    // line number 71
    var0 = (this.message);
    return var0;
  }

  V$$init$$Ljava$lang$String$(arg0) {
    // source file is Throwable.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    // line number 29
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 30
    var1 = this;
    var1.message = var0;
    // line number 31
    var2 = this;
    var2.cause = null;
    // line number 32
    return;
  }

  V$$init$$$() {
    // source file is Throwable.java
    var var0 = null;
    var var1 = null;
    // line number 49
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 50
    var0 = this;
    var0.message = null;
    // line number 51
    var1 = this;
    var1.cause = null;
    // line number 52
    return;
  }

  Ljava$lang$Throwable$$initCause$Ljava$lang$Throwable$(arg0) {
    // source file is Throwable.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = this;
    // line number 83
    var1 = arg0;
    var0.cause = var1;
    // line number 84
    var2 = var0;
    return var2;
  }

  V$$init$$Ljava$lang$Throwable$(arg0) {
    // source file is Throwable.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    // line number 44
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 45
    var1 = this;
    var1.message = null;
    // line number 46
    var2 = this;
    var2.cause = var0;
    // line number 47
    return;
  }

  V$addSuppressed$Ljava$lang$Throwable$(arg0) {
    // source file is Throwable.java
    var var0 = null;
    var0 = arg0;
    // line number 88
    return;
  }

  V$printStackTrace$$() {
    // source file is Throwable.java
    // line number 58
    return;
  }
}


class jdk$internal$misc$InternalLock extends java$lang$Object {
  nativeObject = null;

  static CAN_USE_INTERNAL_LOCK = false;
  lock = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(jdk$internal$misc$InternalLock,[jdk$internal$misc$InternalLock,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is InternalLock.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = 0;
    var phi5 = null;
    var phi6 = null;
    // line number 41
    java$lang$System.$i;
    var0 = (java$lang$System.Ljava$lang$String$$getProperty$Ljava$lang$String$(bytecoder.stringconstants[46]));
    // line number 42
    If_11_0: {
     If_11_1: {
      if (var0 == null) {
       phi6 = var0;
       break If_11_1;
      } else {
       var1 = var0;
       var2 = (var1.Z$isEmpty$$());
       If_18_0: {
        if (var2 != 0) {
         phi5 = var0;
         break If_18_0;
        } else {
         var3 = var0;
         var4 = (java$lang$String.prototype.Z$equals$Ljava$lang$Object$.call(var3,bytecoder.stringconstants[47]));
         if (var4 == 0) {
          phi6 = var0;
          break If_11_1;
         } else {
          phi5 = var0;
          break If_18_0;
         }
        }
       }
       // line number 43
       jdk$internal$misc$InternalLock.$i;
       jdk$internal$misc$InternalLock.CAN_USE_INTERNAL_LOCK = 0;
       // Here was a goto statement
       break If_11_0;
      }
     }
     // line number 45
     jdk$internal$misc$InternalLock.$i;
     jdk$internal$misc$InternalLock.CAN_USE_INTERNAL_LOCK = 1;
     phi5 = phi6;
     break If_11_0;
    }
    // line number 47
    return;
  }

  static Ljava$lang$Object$$newLockOr$Ljava$lang$Object$(arg0) {
    // source file is InternalLock.java
    var var0 = 0;
    var var1 = null;
    var phi2 = null;
    var phi3 = null;
    // line number 66
    jdk$internal$misc$InternalLock.$i;
    var0 = (jdk$internal$misc$InternalLock.CAN_USE_INTERNAL_LOCK);
    If_9_0: {
     if (var0 == 0) {
      phi2 = arg0;
      phi3 = arg0;
      break If_9_0;
     } else {
      var1 = new jdk$internal$misc$InternalLock();
      jdk$internal$misc$InternalLock.prototype.V$$init$$$.call(var1);
      // Here was a goto statement
      phi2 = arg0;
      phi3 = var1;
      break If_9_0;
     }
    }
    return phi3;
  }

  V$$init$$$() {
    // source file is InternalLock.java
    var var0 = null;
    var var1 = null;
    // line number 51
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 52
    var0 = this;
    var1 = new java$util$concurrent$locks$ReentrantLock();
    java$util$concurrent$locks$ReentrantLock.prototype.V$$init$$$.call(var1);
    var0.lock = var1;
    // line number 53
    return;
  }

  static Ljdk$internal$misc$InternalLock$$newLockOrNull$$() {
    // source file is InternalLock.java
    var var0 = 0;
    var var1 = null;
    var phi2 = null;
    // line number 59
    jdk$internal$misc$InternalLock.$i;
    var0 = (jdk$internal$misc$InternalLock.CAN_USE_INTERNAL_LOCK);
    If_8_0: {
     if (var0 == 0) {
      phi2 = null;
      break If_8_0;
     } else {
      var1 = new jdk$internal$misc$InternalLock();
      jdk$internal$misc$InternalLock.prototype.V$$init$$$.call(var1);
      // Here was a goto statement
      phi2 = var1;
      break If_8_0;
     }
    }
    return phi2;
  }

  V$lock$$() {
    // source file is InternalLock.java
    var var0 = null;
    // line number 74
    var0 = (this.lock);
    java$util$concurrent$locks$ReentrantLock.prototype.V$lock$$.call(var0);
    // line number 75
    return;
  }

  V$unlock$$() {
    // source file is InternalLock.java
    var var0 = null;
    // line number 78
    var0 = (this.lock);
    java$util$concurrent$locks$ReentrantLock.prototype.V$unlock$$.call(var0);
    // line number 79
    return;
  }
}


class java$nio$charset$CharsetEncoder extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;
  static stateNames = null;
  malformedInputAction = null;
  unmappableCharacterAction = null;
  charset = null;
  state = 0;
  cachedDecoder = null;
  replacement = null;
  averageBytesPerChar = 0.0;
  maxBytesPerChar = 0.0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$nio$charset$CharsetEncoder,[java$lang$Object,java$nio$charset$CharsetEncoder]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
    this.Ljava$nio$charset$CoderResult$$encodeLoop$Ljava$nio$CharBuffer$$Ljava$nio$ByteBuffer$ = impl;
  }

  static V$$clinit$$$() {
    // source file is CharsetEncoder.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    // line number 137
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(java$nio$charset$CharsetEncoder.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    java$nio$charset$CharsetEncoder.$i;
    java$nio$charset$CharsetEncoder.$assertionsDisabled = phi2;
    // line number 158
    var3 = bytecoder.newarray((4),null);
    var4 = (0) | 0;
    var3.data[var4] = bytecoder.stringconstants[48];
    var5 = (1) | 0;
    var3.data[var5] = bytecoder.stringconstants[49];
    var6 = (2) | 0;
    var3.data[var6] = bytecoder.stringconstants[50];
    var7 = (3) | 0;
    var3.data[var7] = bytecoder.stringconstants[51];
    java$nio$charset$CharsetEncoder.stateNames = var3;
    return;
  }

  Ljava$nio$charset$CharsetEncoder$$onMalformedInput$Ljava$nio$charset$CodingErrorAction$(arg0) {
    // source file is CharsetEncoder.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var0 = arg0;
    // line number 381
    if (var0 != null) {
     // line number 383
     var3 = this;
     var3.malformedInputAction = var0;
     // line number 384
     var4 = var0;
     java$nio$charset$CharsetEncoder.prototype.V$implOnMalformedInput$Ljava$nio$charset$CodingErrorAction$.call(this,var4);
     // line number 385
     return this;
    } else {
     // line number 382
     var1 = new java$lang$IllegalArgumentException();
     var2 = bytecoder.stringconstants[55];
     java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var1,var2);
     throw bytecoder.registerStack(var1, new Error().stack);
    }
  }

  V$implOnMalformedInput$Ljava$nio$charset$CodingErrorAction$(arg0) {
    // source file is CharsetEncoder.java
    var var0 = null;
    var0 = arg0;
    // line number 397
    return;
  }

  Ljava$nio$charset$CharsetEncoder$$onUnmappableCharacter$Ljava$nio$charset$CodingErrorAction$(arg0) {
    // source file is CharsetEncoder.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var0 = arg0;
    // line number 425
    if (var0 != null) {
     // line number 427
     var3 = this;
     var3.unmappableCharacterAction = var0;
     // line number 428
     var4 = var0;
     java$nio$charset$CharsetEncoder.prototype.V$implOnUnmappableCharacter$Ljava$nio$charset$CodingErrorAction$.call(this,var4);
     // line number 429
     return this;
    } else {
     // line number 426
     var1 = new java$lang$IllegalArgumentException();
     var2 = bytecoder.stringconstants[55];
     java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var1,var2);
     throw bytecoder.registerStack(var1, new Error().stack);
    }
  }

  V$implOnUnmappableCharacter$Ljava$nio$charset$CodingErrorAction$(arg0) {
    // source file is CharsetEncoder.java
    var var0 = null;
    var0 = arg0;
    // line number 441
    return;
  }

  Ljava$nio$charset$Charset$$charset$$() {
    // source file is CharsetEncoder.java
    var var0 = null;
    // line number 244
    var0 = (this.charset);
    return var0;
  }

  V$$init$$Ljava$nio$charset$Charset$$F$F(arg0,arg1,arg2) {
    // source file is CharsetEncoder.java
    var var0 = null;
    var var1 = .0;
    var var2 = null;
    var var3 = .0;
    var var4 = null;
    var var5 = 0;
    var0 = arg0;
    var1 = arg2;
    // line number 233
    var2 = var0;
    var3 = var1;
    var4 = bytecoder.newarray((1),0);
    var5 = (0) | 0;
    var4.data[var5] = 63;
    java$nio$charset$CharsetEncoder.prototype.V$$init$$Ljava$nio$charset$Charset$$F$F$$B.call(this,var2,arg1,var3,var4);
    // line number 236
    return;
  }

  V$$init$$Ljava$nio$charset$Charset$$F$F$$B(arg0,arg1,arg2,arg3) {
    // source file is CharsetEncoder.java
    var var0 = null;
    var var1 = .0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = .0;
    var var10 = 0;
    var var11 = null;
    var var12 = null;
    var var13 = .0;
    var var14 = 0;
    var var15 = null;
    var var16 = null;
    var var17 = 0;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var0 = arg0;
    var1 = arg2;
    // line number 190
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 144
    var2 = this;
    java$nio$charset$CodingErrorAction.$i;
    var3 = (java$nio$charset$CodingErrorAction.REPORT);
    var2.malformedInputAction = var3;
    // line number 146
    var4 = this;
    var5 = (java$nio$charset$CodingErrorAction.REPORT);
    var4.unmappableCharacterAction = var5;
    // line number 156
    var6 = this;
    var6.state = 0;
    // line number 320
    var7 = this;
    var7.cachedDecoder = null;
    // line number 191
    var8 = this;
    var8.charset = var0;
    // line number 193
    var9 = 0.0;
    var10 = (bytecoder.cmp(arg1,var9)) | 0;
    if (var10 > 0) {
     // line number 197
     var13 = 0.0;
     var14 = (bytecoder.cmp(var1,var13)) | 0;
     if (var14 > 0) {
      // line number 200
      var17 = (bytecoder.cmp(arg1,var1)) | 0;
      if (var17 <= 0) {
       // line number 204
       var20 = this;
       var20.replacement = arg3;
       // line number 205
       var21 = this;
       var21.averageBytesPerChar = arg1;
       // line number 206
       var22 = this;
       var22.maxBytesPerChar = var1;
       // line number 207
       var23 = arg3;
       var24 = (java$nio$charset$CharsetEncoder.prototype.Ljava$nio$charset$CharsetEncoder$$replaceWith$$B.call(this,var23));
       // line number 208
       return;
      } else {
       // line number 201
       var18 = new java$lang$IllegalArgumentException();
       var19 = bytecoder.stringconstants[85];
       java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var18,var19);
       throw bytecoder.registerStack(var18, new Error().stack);
      }
     } else {
      // line number 198
      var15 = new java$lang$IllegalArgumentException();
      var16 = bytecoder.stringconstants[84];
      java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var15,var16);
      throw bytecoder.registerStack(var15, new Error().stack);
     }
    } else {
     // line number 194
     var11 = new java$lang$IllegalArgumentException();
     var12 = bytecoder.stringconstants[83];
     java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var11,var12);
     throw bytecoder.registerStack(var11, new Error().stack);
    }
  }

  Ljava$nio$charset$CharsetEncoder$$replaceWith$$B(arg0) {
    // source file is CharsetEncoder.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = .0;
    var var6 = .0;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = 0;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var0 = arg0;
    // line number 287
    if (var0 != null) {
     // line number 289
     var3 = (var0.data.length) | 0;
     // line number 290
     if (var3 != 0) {
      // line number 292
      var5 = var3;
      var6 = (this.maxBytesPerChar);
      var7 = (bytecoder.cmp(var5,var6)) | 0;
      if (var7 <= 0) {
       // line number 298
       var9 = var0;
       var10 = (java$nio$charset$CharsetEncoder.prototype.Z$isLegalReplacement$$B.call(this,var9));
       if (var10 != 0) {
        // line number 300
        var12 = this;
        var13 = var0;
        var14 = (var13.data.length) | 0;
        java$util$Arrays.$i;
        var15 = (java$util$Arrays.$B$copyOf$$B$I(var0,var14));
        var12.replacement = var15;
        // line number 302
        var16 = this;
        var17 = (var16.replacement);
        java$nio$charset$CharsetEncoder.prototype.V$implReplaceWith$$B.call(this,var17);
        // line number 303
        return this;
       } else {
        // line number 299
        var11 = new java$lang$IllegalArgumentException();
        java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var11,bytecoder.stringconstants[117]);
        throw bytecoder.registerStack(var11, new Error().stack);
       }
      } else {
       // line number 293
       var8 = new java$lang$IllegalArgumentException();
       java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var8,bytecoder.stringconstants[88]);
       throw bytecoder.registerStack(var8, new Error().stack);
      }
     } else {
      // line number 291
      var4 = new java$lang$IllegalArgumentException();
      java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var4,bytecoder.stringconstants[87]);
      throw bytecoder.registerStack(var4, new Error().stack);
     }
    } else {
     // line number 288
     var1 = new java$lang$IllegalArgumentException();
     var2 = bytecoder.stringconstants[86];
     java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var1,var2);
     throw bytecoder.registerStack(var1, new Error().stack);
    }
  }

  Z$isLegalReplacement$$B(arg0) {
    // source file is CharsetEncoder.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var phi7 = null;
    var phi8 = null;
    var phi9 = null;
    var phi10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var phi21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = 0;
    var var25 = .0;
    var var26 = null;
    var var27 = .0;
    var var28 = .0;
    var var29 = 0;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = 0;
    var var35 = 0;
    var phi36 = null;
    var phi37 = null;
    var phi38 = null;
    var phi39 = 0;
    var var40 = null;
    var0 = arg0;
    // line number 339
    var1 = (this.cachedDecoder);
    // line number 340
    var2 = null;
    // line number 341
    If_17_0: {
     If_17_1: {
      if (var1 == null) {
       phi7 = this;
       phi8 = var0;
       phi9 = var1;
       phi10 = var2;
       break If_17_1;
      } else {
       var3 = var1;
       var4 = (var3.Ljava$lang$Object$$get$$());
       var5 = var4;
       var6 = var5;
       if (var5 != null) {
        // line number 347
        var40 = (java$nio$charset$CharsetDecoder.prototype.Ljava$nio$charset$CharsetDecoder$$reset$$.call(var6));
        phi7 = this;
        phi8 = var0;
        phi9 = var1;
        phi21 = var6;
        break If_17_0;
       } else {
        phi7 = this;
        phi8 = var0;
        phi9 = var1;
        phi10 = var6;
        break If_17_1;
       }
      }
     }
     // line number 342
     var11 = phi7;
     var12 = (java$nio$charset$CharsetEncoder.prototype.Ljava$nio$charset$Charset$$charset$$.call(var11));
     var13 = (var12.Ljava$nio$charset$CharsetDecoder$$newDecoder$$());
     // line number 343
     java$nio$charset$CodingErrorAction.$i;
     var14 = (java$nio$charset$CodingErrorAction.REPORT);
     var15 = (java$nio$charset$CharsetDecoder.prototype.Ljava$nio$charset$CharsetDecoder$$onMalformedInput$Ljava$nio$charset$CodingErrorAction$.call(var13,var14));
     // line number 344
     var16 = (java$nio$charset$CodingErrorAction.REPORT);
     var17 = (java$nio$charset$CharsetDecoder.prototype.Ljava$nio$charset$CharsetDecoder$$onUnmappableCharacter$Ljava$nio$charset$CodingErrorAction$.call(var13,var16));
     // line number 345
     var18 = phi7;
     var19 = new java$lang$ref$WeakReference();
     var20 = var13;
     java$lang$ref$WeakReference.prototype.V$$init$$Ljava$lang$Object$.call(var19,var20);
     var18.cachedDecoder = var19;
     // Here was a goto statement
     phi21 = var13;
     break If_17_0;
    }
    // line number 349
    var22 = phi8;
    java$nio$ByteBuffer.$i;
    var23 = (java$nio$ByteBuffer.Ljava$nio$ByteBuffer$$wrap$$B(var22));
    // line number 350
    var24 = ((var23.I$remaining$$())) | 0;
    var25 = var24;
    var26 = phi21;
    // line number 351
    var27 = (java$nio$charset$CharsetDecoder.prototype.F$maxCharsPerByte$$.call(var26));
    var28 = (var25 * var27);
    var29 = ((var28 | 0)) | 0;
    // line number 350
    java$nio$CharBuffer.$i;
    var30 = (java$nio$CharBuffer.Ljava$nio$CharBuffer$$allocate$I(var29));
    // line number 352
    var31 = phi21;
    var32 = var30;
    var33 = (java$nio$charset$CharsetDecoder.prototype.Ljava$nio$charset$CoderResult$$decode$Ljava$nio$ByteBuffer$$Ljava$nio$CharBuffer$$Z.call(var31,var23,var32,1));
    // line number 353
    var34 = (java$nio$charset$CoderResult.prototype.Z$isError$$.call(var33));
    If_133_0: {
     if (var34 != 0) {
      phi36 = var23;
      phi37 = var30;
      phi38 = var33;
      phi39 = (0) | 0;
      break If_133_0;
     } else {
      var35 = (1) | 0;
      // Here was a goto statement
      phi36 = var23;
      phi37 = var30;
      phi38 = var33;
      phi39 = (var35) | 0;
      break If_133_0;
     }
    }
    return phi39;
  }

  V$implReplaceWith$$B(arg0) {
    // source file is CharsetEncoder.java
    var var0 = null;
    var0 = arg0;
    // line number 316
    return;
  }

  Ljava$nio$charset$CoderResult$$encode$Ljava$nio$CharBuffer$$Ljava$nio$ByteBuffer$$Z(arg0,arg1,arg2) {
    // source file is CharsetEncoder.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var phi3 = null;
    var phi4 = null;
    var phi5 = null;
    var phi6 = 0;
    var phi7 = 0;
    var var8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = 0;
    var var13 = 0;
    var var14 = null;
    var var15 = 0;
    var phi16 = 0;
    var var17 = null;
    var var18 = null;
    var var19 = 0;
    var var20 = 0;
    var var21 = null;
    var var22 = 0;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = 0;
    var var30 = 0;
    var var31 = 0;
    var var32 = null;
    var var33 = 0;
    var var34 = null;
    var var35 = 0;
    var var36 = null;
    var phi37 = null;
    var var38 = null;
    var var39 = null;
    var var40 = 0;
    var var41 = null;
    var var42 = null;
    var phi43 = null;
    var var44 = null;
    var var45 = null;
    var var46 = null;
    var var47 = null;
    var var48 = null;
    var var49 = null;
    var var50 = 0;
    var var51 = null;
    var var52 = null;
    var var53 = 0;
    var var54 = null;
    var var55 = null;
    var var56 = null;
    var var57 = null;
    var var58 = null;
    var var59 = null;
    var var60 = null;
    var var61 = null;
    var var62 = null;
    var var63 = null;
    var var64 = null;
    var var65 = 0;
    var var66 = null;
    var var67 = 0;
    var var68 = 0;
    var var69 = null;
    var var70 = 0;
    var var71 = null;
    var var72 = null;
    var var73 = 0;
    var var74 = null;
    var var75 = null;
    var var76 = 0;
    var var77 = null;
    var var78 = null;
    var var79 = null;
    var phi80 = null;
    var var81 = null;
    var0 = arg0;
    var1 = arg2;
    // line number 575
    If_11_0: {
     if (var1 == 0) {
      phi3 = this;
      phi4 = var0;
      phi5 = arg1;
      phi6 = var1;
      phi7 = (1) | 0;
      break If_11_0;
     } else {
      var2 = (2) | 0;
      // Here was a goto statement
      phi3 = this;
      phi4 = var0;
      phi5 = arg1;
      phi6 = var1;
      phi7 = (var2) | 0;
      break If_11_0;
     }
    }
    var8 = (phi7) | 0;
    // line number 576
    var9 = phi3;
    var10 = ((var9.state)) | 0;
    If_34_0: {
     if (var10 == 0) {
      phi16 = (var8) | 0;
      break If_34_0;
     } else {
      var11 = phi3;
      var12 = ((var11.state)) | 0;
      if (var12 == 1) {
       phi16 = (var8) | 0;
       break If_34_0;
      } else {
       var13 = phi6;
       If_47_0: {
        if (var13 == 0) {
         phi16 = (var8) | 0;
         break If_47_0;
        } else {
         var14 = phi3;
         var15 = ((var14.state)) | 0;
         if (var15 == 2) {
          phi16 = (var8) | 0;
          break If_34_0;
         } else {
          phi16 = (var8) | 0;
          break If_47_0;
         }
        }
       }
       // line number 578
       var17 = phi3;
       var18 = phi3;
       var19 = ((var18.state)) | 0;
       var20 = (phi16) | 0;
       java$nio$charset$CharsetEncoder.prototype.V$throwIllegalStateException$I$I.call(var17,var19,var20);
       break If_34_0;
      }
     }
    }
    // line number 579
    var21 = phi3;
    var22 = (phi16) | 0;
    var21.state = var22;
    TryCatch_80: while(true) {
     TryCatch_80_0: {
      try {
       // line number 585
       var25 = phi3;
       var26 = phi4;
       var27 = phi5;
       var28 = (var25.Ljava$nio$charset$CoderResult$$encodeLoop$Ljava$nio$CharBuffer$$Ljava$nio$ByteBuffer$(var26,var27));
       break TryCatch_80_0;
      } catch (__ex) {
       if (__ex instanceof java$lang$RuntimeException) {
        // line number 586
        // line number 587
        var23 = new java$nio$charset$CoderMalfunctionError();
        var24 = __ex;
        java$nio$charset$CoderMalfunctionError.prototype.V$$init$$Ljava$lang$Exception$.call(var23,var24);
        throw bytecoder.registerStack(var23, new Error().stack);
       }
       throw __ex;
      }
     }
     // line number 588
     // Here was a goto statement
     // line number 590
     var29 = (java$nio$charset$CoderResult.prototype.Z$isOverflow$$.call(var28));
     if (var29 == 0) {
      // line number 593
      var30 = (java$nio$charset$CoderResult.prototype.Z$isUnderflow$$.call(var28));
      If_128_0: {
       if (var30 == 0) {
        phi37 = var28;
        break If_128_0;
       } else {
        // line number 594
        var31 = phi6;
        If_135_0: {
         if (var31 == 0) {
          phi80 = var28;
          break If_135_0;
         } else {
          var32 = phi4;
          var33 = (var32.Z$hasRemaining$$());
          if (var33 == 0) {
           phi80 = var28;
           break If_135_0;
          } else {
           // line number 595
           var34 = phi4;
           var35 = ((var34.I$remaining$$())) | 0;
           java$nio$charset$CoderResult.$i;
           var36 = (java$nio$charset$CoderResult.Ljava$nio$charset$CoderResult$$malformedForLength$I(var35));
           // Here was a goto statement
           phi37 = var36;
           break If_128_0;
          }
         }
        }
        // line number 598
        var81 = phi80;
        return var81;
       }
      }
      // line number 602
      var38 = null;
      // line number 603
      var39 = phi37;
      var40 = (java$nio$charset$CoderResult.prototype.Z$isMalformed$$.call(var39));
      If_173_0: {
       if (var40 == 0) {
        // line number 605
        var72 = phi37;
        var73 = (java$nio$charset$CoderResult.prototype.Z$isUnmappable$$.call(var72));
        if (var73 == 0) {
         // line number 608
         java$nio$charset$CharsetEncoder.$i;
         var76 = (java$nio$charset$CharsetEncoder.$assertionsDisabled);
         if (var76 != 0) {
          phi43 = var38;
          break If_173_0;
         } else {
          var77 = new java$lang$AssertionError();
          var78 = phi37;
          var79 = (java$nio$charset$CoderResult.prototype.Ljava$lang$String$$toString$$.call(var78));
          java$lang$AssertionError.prototype.V$$init$$Ljava$lang$Object$.call(var77,var79);
          throw bytecoder.registerStack(var77, new Error().stack);
         }
        } else {
         // line number 606
         var74 = phi3;
         var75 = (var74.unmappableCharacterAction);
         // Here was a goto statement
         phi43 = var75;
         break If_173_0;
        }
       } else {
        // line number 604
        var41 = phi3;
        var42 = (var41.malformedInputAction);
        // Here was a goto statement
        phi43 = var42;
        break If_173_0;
       }
      }
      // line number 610
      var44 = phi43;
      java$nio$charset$CodingErrorAction.$i;
      var45 = (java$nio$charset$CodingErrorAction.REPORT);
      if (var44 != var45) {
       // line number 613
       var47 = phi43;
       var48 = (java$nio$charset$CodingErrorAction.REPLACE);
       If_211_0: {
        if (var47 != var48) {
         break If_211_0;
        } else {
         // line number 614
         var49 = phi5;
         var50 = ((var49.I$remaining$$())) | 0;
         var51 = phi3;
         var52 = (var51.replacement);
         var53 = (var52.data.length) | 0;
         if (var50 >= var53) {
          // line number 616
          var55 = phi5;
          var56 = phi3;
          var57 = (var56.replacement);
          var58 = (java$nio$ByteBuffer.prototype.Ljava$nio$ByteBuffer$$put$$B.call(var55,var57));
          break If_211_0;
         } else {
          // line number 615
          java$nio$charset$CoderResult.$i;
          var54 = (java$nio$charset$CoderResult.OVERFLOW);
          return var54;
         }
        }
       }
       // line number 619
       var59 = phi43;
       var60 = (java$nio$charset$CodingErrorAction.IGNORE);
       If_259_0: {
        if (var59 == var60) {
         break If_259_0;
        } else {
         var61 = phi43;
         var62 = (java$nio$charset$CodingErrorAction.REPLACE);
         if (var61 != var62) {
          // line number 626
          java$nio$charset$CharsetEncoder.$i;
          var70 = (java$nio$charset$CharsetEncoder.$assertionsDisabled);
          if (var70 != 0) {
           // line number 627
           // Here was a goto statement
           continue TryCatch_80;
          } else {
           var71 = new java$lang$AssertionError();
           java$lang$AssertionError.prototype.V$$init$$$.call(var71);
           throw bytecoder.registerStack(var71, new Error().stack);
          }
         } else {
          break If_259_0;
         }
        }
       }
       // line number 622
       var63 = phi4;
       var64 = phi4;
       var65 = ((var64.I$position$$())) | 0;
       var66 = phi37;
       var67 = ((java$nio$charset$CoderResult.prototype.I$length$$.call(var66))) | 0;
       var68 = ((var65 + var67)) | 0;
       var69 = (java$nio$CharBuffer.prototype.Ljava$nio$CharBuffer$$position$I.call(var63,var68));
       // line number 623
       // Here was a goto statement
       continue TryCatch_80;
      } else {
       // line number 611
       var46 = phi37;
       return var46;
      }
     } else {
      // line number 591
      return var28;
     }
    }
  }

  V$throwIllegalStateException$I$I(arg0,arg1) {
    // source file is CharsetEncoder.java
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var0 = (arg0) | 0;
    // line number 996
    var1 = new java$lang$IllegalStateException();
    var2 = new java$lang$StringBuilder();
    java$lang$StringBuilder.prototype.V$$init$$$.call(var2);
    var3 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var2,bytecoder.stringconstants[93]));
    java$nio$charset$CharsetEncoder.$i;
    var4 = (java$nio$charset$CharsetEncoder.stateNames);
    var5 = (var4.data[var0]);
    var6 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var3,var5));
    var7 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var6,bytecoder.stringconstants[94]));
    var8 = (java$nio$charset$CharsetEncoder.stateNames);
    var9 = (var8.data[arg1]);
    var10 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var7,var9));
    var11 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var10));
    java$lang$IllegalStateException.prototype.V$$init$$Ljava$lang$String$.call(var1,var11);
    throw bytecoder.registerStack(var1, new Error().stack);
  }

  F$maxBytesPerChar$$() {
    // source file is CharsetEncoder.java
    var var0 = .0;
    // line number 471
    var0 = (this.maxBytesPerChar);
    return var0;
  }

  Ljava$nio$charset$CharsetEncoder$$reset$$() {
    // source file is CharsetEncoder.java
    var var0 = null;
    // line number 713
    java$nio$charset$CharsetEncoder.prototype.V$implReset$$.call(this);
    // line number 714
    var0 = this;
    var0.state = 0;
    // line number 715
    return this;
  }

  V$implReset$$() {
    // source file is CharsetEncoder.java
    // line number 724
    return;
  }

  Ljava$nio$charset$CoderResult$$flush$Ljava$nio$ByteBuffer$(arg0) {
    // source file is CharsetEncoder.java
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var phi5 = null;
    var phi6 = null;
    var phi7 = null;
    var var8 = null;
    var var9 = 0;
    var var10 = null;
    var var11 = 0;
    var phi12 = null;
    var phi13 = null;
    var var14 = null;
    var0 = arg0;
    // line number 671
    var1 = ((this.state)) | 0;
    if (var1 != 2) {
     // line number 678
     var9 = ((this.state)) | 0;
     If_48_0: {
      if (var9 == 3) {
       phi12 = this;
       phi13 = var0;
       break If_48_0;
      } else {
       // line number 679
       var10 = this;
       var11 = ((var10.state)) | 0;
       java$nio$charset$CharsetEncoder.prototype.V$throwIllegalStateException$I$I.call(this,var11,3);
       phi12 = this;
       phi13 = var0;
       break If_48_0;
      }
     }
     // line number 681
     java$nio$charset$CoderResult.$i;
     var14 = (java$nio$charset$CoderResult.UNDERFLOW);
     return var14;
    } else {
     // line number 672
     var2 = (java$nio$charset$CharsetEncoder.prototype.Ljava$nio$charset$CoderResult$$implFlush$Ljava$nio$ByteBuffer$.call(this,var0));
     // line number 673
     var3 = (java$nio$charset$CoderResult.prototype.Z$isUnderflow$$.call(var2));
     If_23_0: {
      if (var3 == 0) {
       phi5 = this;
       phi6 = var0;
       phi7 = var2;
       break If_23_0;
      } else {
       // line number 674
       var4 = this;
       var4.state = 3;
       phi5 = this;
       phi6 = var0;
       phi7 = var2;
       break If_23_0;
      }
     }
     // line number 675
     var8 = phi7;
     return var8;
    }
  }

  Ljava$nio$charset$CoderResult$$implFlush$Ljava$nio$ByteBuffer$(arg0) {
    // source file is CharsetEncoder.java
    var var0 = null;
    var var1 = null;
    var0 = arg0;
    // line number 699
    java$nio$charset$CoderResult.$i;
    var1 = (java$nio$charset$CoderResult.UNDERFLOW);
    return var1;
  }
}


class org$luaj$vm2$compiler$LexState$Labeldesc extends java$lang$Object {
  nativeObject = null;

  name = null;
  pc = 0;
  line = 0;
  nactvar = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$compiler$LexState$Labeldesc,[org$luaj$vm2$compiler$LexState$Labeldesc,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Lorg$luaj$vm2$LuaString$$I$I$S(arg0,arg1,arg2,arg3) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var0 = arg0;
    var1 = (arg2) | 0;
    java$lang$Object.prototype.V$$init$$$.call(this);
    var2 = this;
    var2.name = var0;
    var3 = this;
    var3.pc = arg1;
    var4 = this;
    var4.line = var1;
    var5 = this;
    var5.nactvar = arg3;
    return;
  }
}


class org$luaj$vm2$compiler$LexState$LHS_assign extends java$lang$Object {
  nativeObject = null;

  v = null;
  prev = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$compiler$LexState$LHS_assign,[java$lang$Object,org$luaj$vm2$compiler$LexState$LHS_assign]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    var var0 = null;
    var var1 = null;
    java$lang$Object.prototype.V$$init$$$.call(this);
    var0 = this;
    var1 = new org$luaj$vm2$compiler$LexState$expdesc();
    org$luaj$vm2$compiler$LexState$expdesc.prototype.V$$init$$$.call(var1);
    var0.v = var1;
    return;
  }
}


class java$util$Collections extends java$lang$Object {
  nativeObject = null;

  static EMPTY_SET = null;
  static EMPTY_LIST = null;
  static EMPTY_MAP = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$Collections,[java$lang$Object,java$util$Collections]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is Collections.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    // line number 4403
    var0 = new java$util$Collections$EmptySet();
    java$util$Collections$EmptySet.prototype.V$$init$$$.call(var0);
    java$util$Collections.$i;
    java$util$Collections.EMPTY_SET = var0;
    // line number 4529
    var1 = new java$util$Collections$EmptyList();
    java$util$Collections$EmptyList.prototype.V$$init$$$.call(var1);
    java$util$Collections.EMPTY_LIST = var1;
    // line number 4633
    var2 = new java$util$Collections$EmptyMap();
    java$util$Collections$EmptyMap.prototype.V$$init$$$.call(var2);
    java$util$Collections.EMPTY_MAP = var2;
    return;
  }

  static Ljava$util$Set$$synchronizedSet$Ljava$util$Set$$Ljava$lang$Object$(arg0,arg1) {
    // source file is Collections.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg1;
    // line number 2188
    var1 = new java$util$Collections$SynchronizedSet();
    var2 = arg0;
    java$util$Collections$SynchronizedSet.prototype.V$$init$$Ljava$util$Set$$Ljava$lang$Object$.call(var1,var2,var0);
    return var1;
  }

  static Ljava$util$Iterator$$emptyIterator$$() {
    // source file is Collections.java
    var var0 = null;
    // line number 4304
    java$util$Collections$EmptyIterator.$i;
    var0 = (java$util$Collections$EmptyIterator.EMPTY_ITERATOR);
    return var0;
  }

  V$$init$$$() {
    // source file is Collections.java
    // line number 86
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 87
    return;
  }

  static Ljava$util$Set$$emptySet$$() {
    // source file is Collections.java
    var var0 = null;
    // line number 4426
    java$util$Collections.$i;
    var0 = (java$util$Collections.EMPTY_SET);
    return var0;
  }

  static Ljava$util$ListIterator$$emptyListIterator$$() {
    // source file is Collections.java
    var var0 = null;
    // line number 4348
    java$util$Collections$EmptyListIterator.$i;
    var0 = (java$util$Collections$EmptyListIterator.EMPTY_ITERATOR);
    return var0;
  }
}


class java$util$Iterator extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$Iterator,[java$util$Iterator,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class org$luaj$vm2$compiler$LexState$Dyndata extends java$lang$Object {
  nativeObject = null;

  n_actvar = 0;
  n_gt = 0;
  n_label = 0;
  actvar = null;
  label = null;
  gt = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$compiler$LexState$Dyndata,[java$lang$Object,org$luaj$vm2$compiler$LexState$Dyndata]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    java$lang$Object.prototype.V$$init$$$.call(this);
    var0 = this;
    var0.n_actvar = 0;
    var1 = this;
    var1.n_gt = 0;
    var2 = this;
    var2.n_label = 0;
    return;
  }
}


class org$luaj$vm2$compiler$LexState$expdesc$U extends java$lang$Object {
  nativeObject = null;

  info = 0;
  ind_t = 0;
  ind_idx = 0;
  ind_vt = 0;
  _nval = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$compiler$LexState$expdesc$U,[java$lang$Object,org$luaj$vm2$compiler$LexState$expdesc$U]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }

  Lorg$luaj$vm2$LuaValue$$nval$$() {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var phi4 = null;
    var phi5 = null;
    var var6 = null;
    var0 = (this._nval);
    If_5_0: {
     if (var0 != null) {
      var6 = (this._nval);
      phi4 = this;
      phi5 = var6;
      break If_5_0;
     } else {
      var1 = this;
      var2 = ((var1.info)) | 0;
      org$luaj$vm2$LuaInteger.$i;
      var3 = (org$luaj$vm2$LuaInteger.Lorg$luaj$vm2$LuaInteger$$valueOf$I(var2));
      // Here was a goto statement
      phi4 = this;
      phi5 = var3;
      break If_5_0;
     }
    }
    return phi5;
  }

  V$setNval$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var0 = this;
    var1 = arg0;
    var0._nval = var1;
    return;
  }

  static Lorg$luaj$vm2$LuaValue$$access$200$Lorg$luaj$vm2$compiler$LexState$expdesc$U$(arg0) {
    var var0 = null;
    var0 = (arg0._nval);
    return var0;
  }

  static Lorg$luaj$vm2$LuaValue$$access$202$Lorg$luaj$vm2$compiler$LexState$expdesc$U$$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var0 = arg0;
    var1 = arg1;
    var0._nval = var1;
    return var1;
  }
}


class de$mirkosertic$bytecoder$classlib$VM extends java$lang$Object {
  nativeObject = null;

  static SYSTEM_LOADER = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(de$mirkosertic$bytecoder$classlib$VM,[java$lang$Object,de$mirkosertic$bytecoder$classlib$VM]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static Ljava$lang$String$$exceptionMessage$Ljava$lang$Exception$(arg0) {
    // source file is VM.java
    var var0 = null;
    // line number 75
    var0 = (arg0.Ljava$lang$String$$getMessage$$());
    return var0;
  }

  static Ljava$lang$String$$objectToString$Ljava$lang$Object$(arg0) {
    // source file is VM.java
    var var0 = null;
    // line number 80
    if (arg0 != null) {
     // line number 83
     var0 = (arg0.Ljava$lang$String$$toString$$());
     return var0;
    } else {
     // line number 81
     return bytecoder.stringconstants[0];
    }
  }

  static Z$nullsafeEquals$Ljava$lang$Object$$Ljava$lang$Object$(arg0,arg1) {
    // source file is VM.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var0 = arg1;
    // line number 88
    var1 = var0;
    if (arg0 != var1) {
     // line number 91
     if (arg0 == null) {
      // line number 94
      return 0;
     } else {
      // line number 92
      var2 = (arg0.Z$equals$Ljava$lang$Object$(var0));
      return var2;
     }
    } else {
     // line number 89
     return 1;
    }
  }

  static Ljava$lang$Byte$$toByte$B(arg0) {
    // source file is VM.java
    var var0 = null;
    // line number 99
    java$lang$Byte.$i;
    var0 = (java$lang$Byte.Ljava$lang$Byte$$valueOf$B(arg0));
    return var0;
  }

  static Ljava$lang$Short$$toShort$S(arg0) {
    // source file is VM.java
    var var0 = null;
    // line number 104
    java$lang$Short.$i;
    var0 = (java$lang$Short.Ljava$lang$Short$$valueOf$S(arg0));
    return var0;
  }

  static Ljava$lang$Integer$$toInteger$I(arg0) {
    // source file is VM.java
    var var0 = null;
    // line number 109
    java$lang$Integer.$i;
    var0 = (java$lang$Integer.Ljava$lang$Integer$$valueOf$I(arg0));
    return var0;
  }

  static Ljava$lang$Long$$toLong$J(arg0) {
    // source file is VM.java
    var var0 = null;
    // line number 114
    java$lang$Long.$i;
    var0 = (java$lang$Long.Ljava$lang$Long$$valueOf$J(arg0));
    return var0;
  }

  static Ljava$lang$Float$$toFloat$F(arg0) {
    // source file is VM.java
    var var0 = null;
    // line number 119
    java$lang$Float.$i;
    var0 = (java$lang$Float.Ljava$lang$Float$$valueOf$F(arg0));
    return var0;
  }

  static Ljava$lang$Double$$toDouble$F(arg0) {
    // source file is VM.java
    var var0 = .0;
    var var1 = null;
    // line number 124
    var0 = arg0;
    java$lang$Double.$i;
    var1 = (java$lang$Double.Ljava$lang$Double$$valueOf$D(var0));
    return var1;
  }

  static V$$clinit$$$() {
    // source file is VM.java
    var var0 = null;
    // line number 26
    var0 = new de$mirkosertic$bytecoder$classlib$VM$1();
    de$mirkosertic$bytecoder$classlib$VM$1.prototype.V$$init$$$.call(var0);
    de$mirkosertic$bytecoder$classlib$VM.$i;
    de$mirkosertic$bytecoder$classlib$VM.SYSTEM_LOADER = var0;
    return;
  }

  V$$init$$$() {
    // source file is VM.java
    // line number 24
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class java$lang$invoke$MethodHandle extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$invoke$MethodHandle,[java$lang$Object,java$lang$invoke$MethodHandle]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.Ljava$lang$Object$$invokeExact$$Ljava$lang$Object$ = impl;
  }

  V$$init$$$() {
    // source file is MethodHandle.java
    // line number 21
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class java$nio$charset$CharsetDecoder extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;
  static stateNames = null;
  malformedInputAction = null;
  unmappableCharacterAction = null;
  maxCharsPerByte = 0.0;
  state = 0;
  replacement = null;
  charset = null;
  averageCharsPerByte = 0.0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$nio$charset$CharsetDecoder,[java$lang$Object,java$nio$charset$CharsetDecoder]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
    this.Ljava$nio$charset$CoderResult$$decodeLoop$Ljava$nio$ByteBuffer$$Ljava$nio$CharBuffer$ = impl;
  }

  static V$$clinit$$$() {
    // source file is CharsetDecoder.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    // line number 137
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(java$nio$charset$CharsetDecoder.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    java$nio$charset$CharsetDecoder.$i;
    java$nio$charset$CharsetDecoder.$assertionsDisabled = phi2;
    // line number 158
    var3 = bytecoder.newarray((4),null);
    var4 = (0) | 0;
    var3.data[var4] = bytecoder.stringconstants[48];
    var5 = (1) | 0;
    var3.data[var5] = bytecoder.stringconstants[49];
    var6 = (2) | 0;
    var3.data[var6] = bytecoder.stringconstants[50];
    var7 = (3) | 0;
    var3.data[var7] = bytecoder.stringconstants[51];
    java$nio$charset$CharsetDecoder.stateNames = var3;
    return;
  }

  Ljava$nio$charset$CharsetDecoder$$onMalformedInput$Ljava$nio$charset$CodingErrorAction$(arg0) {
    // source file is CharsetDecoder.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var0 = arg0;
    // line number 381
    if (var0 != null) {
     // line number 383
     var3 = this;
     var3.malformedInputAction = var0;
     // line number 384
     var4 = var0;
     java$nio$charset$CharsetDecoder.prototype.V$implOnMalformedInput$Ljava$nio$charset$CodingErrorAction$.call(this,var4);
     // line number 385
     return this;
    } else {
     // line number 382
     var1 = new java$lang$IllegalArgumentException();
     var2 = bytecoder.stringconstants[55];
     java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var1,var2);
     throw bytecoder.registerStack(var1, new Error().stack);
    }
  }

  V$implOnMalformedInput$Ljava$nio$charset$CodingErrorAction$(arg0) {
    // source file is CharsetDecoder.java
    var var0 = null;
    var0 = arg0;
    // line number 397
    return;
  }

  Ljava$nio$charset$CharsetDecoder$$onUnmappableCharacter$Ljava$nio$charset$CodingErrorAction$(arg0) {
    // source file is CharsetDecoder.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var0 = arg0;
    // line number 425
    if (var0 != null) {
     // line number 427
     var3 = this;
     var3.unmappableCharacterAction = var0;
     // line number 428
     var4 = var0;
     java$nio$charset$CharsetDecoder.prototype.V$implOnUnmappableCharacter$Ljava$nio$charset$CodingErrorAction$.call(this,var4);
     // line number 429
     return this;
    } else {
     // line number 426
     var1 = new java$lang$IllegalArgumentException();
     var2 = bytecoder.stringconstants[55];
     java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var1,var2);
     throw bytecoder.registerStack(var1, new Error().stack);
    }
  }

  V$implOnUnmappableCharacter$Ljava$nio$charset$CodingErrorAction$(arg0) {
    // source file is CharsetDecoder.java
    var var0 = null;
    var0 = arg0;
    // line number 441
    return;
  }

  F$maxCharsPerByte$$() {
    // source file is CharsetDecoder.java
    var var0 = .0;
    // line number 471
    var0 = (this.maxCharsPerByte);
    return var0;
  }

  Ljava$nio$charset$CoderResult$$decode$Ljava$nio$ByteBuffer$$Ljava$nio$CharBuffer$$Z(arg0,arg1,arg2) {
    // source file is CharsetDecoder.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var phi3 = null;
    var phi4 = null;
    var phi5 = null;
    var phi6 = 0;
    var phi7 = 0;
    var var8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = 0;
    var var13 = 0;
    var var14 = null;
    var var15 = 0;
    var phi16 = 0;
    var var17 = null;
    var var18 = null;
    var var19 = 0;
    var var20 = 0;
    var var21 = null;
    var var22 = 0;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = 0;
    var var30 = 0;
    var var31 = 0;
    var var32 = null;
    var var33 = 0;
    var var34 = null;
    var var35 = 0;
    var var36 = null;
    var phi37 = null;
    var var38 = null;
    var var39 = null;
    var var40 = 0;
    var var41 = null;
    var var42 = null;
    var phi43 = null;
    var var44 = null;
    var var45 = null;
    var var46 = null;
    var var47 = null;
    var var48 = null;
    var var49 = null;
    var var50 = 0;
    var var51 = null;
    var var52 = null;
    var var53 = 0;
    var var54 = null;
    var var55 = null;
    var var56 = null;
    var var57 = null;
    var var58 = null;
    var var59 = null;
    var var60 = null;
    var var61 = null;
    var var62 = null;
    var var63 = null;
    var var64 = null;
    var var65 = 0;
    var var66 = null;
    var var67 = 0;
    var var68 = 0;
    var var69 = null;
    var var70 = 0;
    var var71 = null;
    var var72 = null;
    var var73 = 0;
    var var74 = null;
    var var75 = null;
    var var76 = 0;
    var var77 = null;
    var var78 = null;
    var var79 = null;
    var phi80 = null;
    var var81 = null;
    var0 = arg0;
    var1 = arg2;
    // line number 575
    If_11_0: {
     if (var1 == 0) {
      phi3 = this;
      phi4 = var0;
      phi5 = arg1;
      phi6 = var1;
      phi7 = (1) | 0;
      break If_11_0;
     } else {
      var2 = (2) | 0;
      // Here was a goto statement
      phi3 = this;
      phi4 = var0;
      phi5 = arg1;
      phi6 = var1;
      phi7 = (var2) | 0;
      break If_11_0;
     }
    }
    var8 = (phi7) | 0;
    // line number 576
    var9 = phi3;
    var10 = ((var9.state)) | 0;
    If_34_0: {
     if (var10 == 0) {
      phi16 = (var8) | 0;
      break If_34_0;
     } else {
      var11 = phi3;
      var12 = ((var11.state)) | 0;
      if (var12 == 1) {
       phi16 = (var8) | 0;
       break If_34_0;
      } else {
       var13 = phi6;
       If_47_0: {
        if (var13 == 0) {
         phi16 = (var8) | 0;
         break If_47_0;
        } else {
         var14 = phi3;
         var15 = ((var14.state)) | 0;
         if (var15 == 2) {
          phi16 = (var8) | 0;
          break If_34_0;
         } else {
          phi16 = (var8) | 0;
          break If_47_0;
         }
        }
       }
       // line number 578
       var17 = phi3;
       var18 = phi3;
       var19 = ((var18.state)) | 0;
       var20 = (phi16) | 0;
       java$nio$charset$CharsetDecoder.prototype.V$throwIllegalStateException$I$I.call(var17,var19,var20);
       break If_34_0;
      }
     }
    }
    // line number 579
    var21 = phi3;
    var22 = (phi16) | 0;
    var21.state = var22;
    TryCatch_80: while(true) {
     TryCatch_80_0: {
      try {
       // line number 585
       var25 = phi3;
       var26 = phi4;
       var27 = phi5;
       var28 = (var25.Ljava$nio$charset$CoderResult$$decodeLoop$Ljava$nio$ByteBuffer$$Ljava$nio$CharBuffer$(var26,var27));
       break TryCatch_80_0;
      } catch (__ex) {
       if (__ex instanceof java$lang$RuntimeException) {
        // line number 586
        // line number 587
        var23 = new java$nio$charset$CoderMalfunctionError();
        var24 = __ex;
        java$nio$charset$CoderMalfunctionError.prototype.V$$init$$Ljava$lang$Exception$.call(var23,var24);
        throw bytecoder.registerStack(var23, new Error().stack);
       }
       throw __ex;
      }
     }
     // line number 588
     // Here was a goto statement
     // line number 590
     var29 = (java$nio$charset$CoderResult.prototype.Z$isOverflow$$.call(var28));
     if (var29 == 0) {
      // line number 593
      var30 = (java$nio$charset$CoderResult.prototype.Z$isUnderflow$$.call(var28));
      If_128_0: {
       if (var30 == 0) {
        phi37 = var28;
        break If_128_0;
       } else {
        // line number 594
        var31 = phi6;
        If_135_0: {
         if (var31 == 0) {
          phi80 = var28;
          break If_135_0;
         } else {
          var32 = phi4;
          var33 = (var32.Z$hasRemaining$$());
          if (var33 == 0) {
           phi80 = var28;
           break If_135_0;
          } else {
           // line number 595
           var34 = phi4;
           var35 = ((var34.I$remaining$$())) | 0;
           java$nio$charset$CoderResult.$i;
           var36 = (java$nio$charset$CoderResult.Ljava$nio$charset$CoderResult$$malformedForLength$I(var35));
           // Here was a goto statement
           phi37 = var36;
           break If_128_0;
          }
         }
        }
        // line number 598
        var81 = phi80;
        return var81;
       }
      }
      // line number 602
      var38 = null;
      // line number 603
      var39 = phi37;
      var40 = (java$nio$charset$CoderResult.prototype.Z$isMalformed$$.call(var39));
      If_173_0: {
       if (var40 == 0) {
        // line number 605
        var72 = phi37;
        var73 = (java$nio$charset$CoderResult.prototype.Z$isUnmappable$$.call(var72));
        if (var73 == 0) {
         // line number 608
         java$nio$charset$CharsetDecoder.$i;
         var76 = (java$nio$charset$CharsetDecoder.$assertionsDisabled);
         if (var76 != 0) {
          phi43 = var38;
          break If_173_0;
         } else {
          var77 = new java$lang$AssertionError();
          var78 = phi37;
          var79 = (java$nio$charset$CoderResult.prototype.Ljava$lang$String$$toString$$.call(var78));
          java$lang$AssertionError.prototype.V$$init$$Ljava$lang$Object$.call(var77,var79);
          throw bytecoder.registerStack(var77, new Error().stack);
         }
        } else {
         // line number 606
         var74 = phi3;
         var75 = (var74.unmappableCharacterAction);
         // Here was a goto statement
         phi43 = var75;
         break If_173_0;
        }
       } else {
        // line number 604
        var41 = phi3;
        var42 = (var41.malformedInputAction);
        // Here was a goto statement
        phi43 = var42;
        break If_173_0;
       }
      }
      // line number 610
      var44 = phi43;
      java$nio$charset$CodingErrorAction.$i;
      var45 = (java$nio$charset$CodingErrorAction.REPORT);
      if (var44 != var45) {
       // line number 613
       var47 = phi43;
       var48 = (java$nio$charset$CodingErrorAction.REPLACE);
       If_211_0: {
        if (var47 != var48) {
         break If_211_0;
        } else {
         // line number 614
         var49 = phi5;
         var50 = ((var49.I$remaining$$())) | 0;
         var51 = phi3;
         var52 = (var51.replacement);
         var53 = ((java$lang$String.prototype.I$length$$.call(var52))) | 0;
         if (var50 >= var53) {
          // line number 616
          var55 = phi5;
          var56 = phi3;
          var57 = (var56.replacement);
          var58 = (java$nio$CharBuffer.prototype.Ljava$nio$CharBuffer$$put$Ljava$lang$String$.call(var55,var57));
          break If_211_0;
         } else {
          // line number 615
          java$nio$charset$CoderResult.$i;
          var54 = (java$nio$charset$CoderResult.OVERFLOW);
          return var54;
         }
        }
       }
       // line number 619
       var59 = phi43;
       var60 = (java$nio$charset$CodingErrorAction.IGNORE);
       If_259_0: {
        if (var59 == var60) {
         break If_259_0;
        } else {
         var61 = phi43;
         var62 = (java$nio$charset$CodingErrorAction.REPLACE);
         if (var61 != var62) {
          // line number 626
          java$nio$charset$CharsetDecoder.$i;
          var70 = (java$nio$charset$CharsetDecoder.$assertionsDisabled);
          if (var70 != 0) {
           // line number 627
           // Here was a goto statement
           continue TryCatch_80;
          } else {
           var71 = new java$lang$AssertionError();
           java$lang$AssertionError.prototype.V$$init$$$.call(var71);
           throw bytecoder.registerStack(var71, new Error().stack);
          }
         } else {
          break If_259_0;
         }
        }
       }
       // line number 622
       var63 = phi4;
       var64 = phi4;
       var65 = ((var64.I$position$$())) | 0;
       var66 = phi37;
       var67 = ((java$nio$charset$CoderResult.prototype.I$length$$.call(var66))) | 0;
       var68 = ((var65 + var67)) | 0;
       var69 = (java$nio$ByteBuffer.prototype.Ljava$nio$ByteBuffer$$position$I.call(var63,var68));
       // line number 623
       // Here was a goto statement
       continue TryCatch_80;
      } else {
       // line number 611
       var46 = phi37;
       return var46;
      }
     } else {
      // line number 591
      return var28;
     }
    }
  }

  V$throwIllegalStateException$I$I(arg0,arg1) {
    // source file is CharsetDecoder.java
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var0 = (arg0) | 0;
    // line number 996
    var1 = new java$lang$IllegalStateException();
    var2 = new java$lang$StringBuilder();
    java$lang$StringBuilder.prototype.V$$init$$$.call(var2);
    var3 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var2,bytecoder.stringconstants[93]));
    java$nio$charset$CharsetDecoder.$i;
    var4 = (java$nio$charset$CharsetDecoder.stateNames);
    var5 = (var4.data[var0]);
    var6 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var3,var5));
    var7 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var6,bytecoder.stringconstants[94]));
    var8 = (java$nio$charset$CharsetDecoder.stateNames);
    var9 = (var8.data[arg1]);
    var10 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var7,var9));
    var11 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var10));
    java$lang$IllegalStateException.prototype.V$$init$$Ljava$lang$String$.call(var1,var11);
    throw bytecoder.registerStack(var1, new Error().stack);
  }

  Ljava$nio$charset$CharsetDecoder$$reset$$() {
    // source file is CharsetDecoder.java
    var var0 = null;
    // line number 713
    java$nio$charset$CharsetDecoder.prototype.V$implReset$$.call(this);
    // line number 714
    var0 = this;
    var0.state = 0;
    // line number 715
    return this;
  }

  V$implReset$$() {
    // source file is CharsetDecoder.java
    // line number 724
    return;
  }

  V$$init$$Ljava$nio$charset$Charset$$F$F(arg0,arg1,arg2) {
    // source file is CharsetDecoder.java
    var var0 = null;
    var var1 = .0;
    var var2 = null;
    var var3 = .0;
    var0 = arg0;
    var1 = arg2;
    // line number 233
    var2 = var0;
    var3 = var1;
    java$nio$charset$CharsetDecoder.prototype.V$$init$$Ljava$nio$charset$Charset$$F$F$Ljava$lang$String$.call(this,var2,arg1,var3,bytecoder.stringconstants[118]);
    // line number 236
    return;
  }

  V$$init$$Ljava$nio$charset$Charset$$F$F$Ljava$lang$String$(arg0,arg1,arg2,arg3) {
    // source file is CharsetDecoder.java
    var var0 = null;
    var var1 = .0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = .0;
    var var9 = 0;
    var var10 = null;
    var var11 = null;
    var var12 = .0;
    var var13 = 0;
    var var14 = null;
    var var15 = null;
    var var16 = 0;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var0 = arg0;
    var1 = arg2;
    // line number 190
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 144
    var2 = this;
    java$nio$charset$CodingErrorAction.$i;
    var3 = (java$nio$charset$CodingErrorAction.REPORT);
    var2.malformedInputAction = var3;
    // line number 146
    var4 = this;
    var5 = (java$nio$charset$CodingErrorAction.REPORT);
    var4.unmappableCharacterAction = var5;
    // line number 156
    var6 = this;
    var6.state = 0;
    // line number 191
    var7 = this;
    var7.charset = var0;
    // line number 193
    var8 = 0.0;
    var9 = (bytecoder.cmp(arg1,var8)) | 0;
    if (var9 > 0) {
     // line number 197
     var12 = 0.0;
     var13 = (bytecoder.cmp(var1,var12)) | 0;
     if (var13 > 0) {
      // line number 200
      var16 = (bytecoder.cmp(arg1,var1)) | 0;
      if (var16 <= 0) {
       // line number 204
       var19 = this;
       var19.replacement = arg3;
       // line number 205
       var20 = this;
       var20.averageCharsPerByte = arg1;
       // line number 206
       var21 = this;
       var21.maxCharsPerByte = var1;
       // line number 207
       var22 = arg3;
       var23 = (java$nio$charset$CharsetDecoder.prototype.Ljava$nio$charset$CharsetDecoder$$replaceWith$Ljava$lang$String$.call(this,var22));
       // line number 208
       return;
      } else {
       // line number 201
       var17 = new java$lang$IllegalArgumentException();
       var18 = bytecoder.stringconstants[121];
       java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var17,var18);
       throw bytecoder.registerStack(var17, new Error().stack);
      }
     } else {
      // line number 198
      var14 = new java$lang$IllegalArgumentException();
      var15 = bytecoder.stringconstants[120];
      java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var14,var15);
      throw bytecoder.registerStack(var14, new Error().stack);
     }
    } else {
     // line number 194
     var10 = new java$lang$IllegalArgumentException();
     var11 = bytecoder.stringconstants[119];
     java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var10,var11);
     throw bytecoder.registerStack(var10, new Error().stack);
    }
  }

  Ljava$nio$charset$CharsetDecoder$$replaceWith$Ljava$lang$String$(arg0) {
    // source file is CharsetDecoder.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = .0;
    var var6 = .0;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var0 = arg0;
    // line number 287
    if (var0 != null) {
     // line number 289
     var3 = ((java$lang$String.prototype.I$length$$.call(var0))) | 0;
     // line number 290
     if (var3 != 0) {
      // line number 292
      var5 = var3;
      var6 = (this.maxCharsPerByte);
      var7 = (bytecoder.cmp(var5,var6)) | 0;
      if (var7 <= 0) {
       // line number 295
       var9 = this;
       var9.replacement = var0;
       // line number 302
       var10 = this;
       var11 = (var10.replacement);
       java$nio$charset$CharsetDecoder.prototype.V$implReplaceWith$Ljava$lang$String$.call(this,var11);
       // line number 303
       return this;
      } else {
       // line number 293
       var8 = new java$lang$IllegalArgumentException();
       java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var8,bytecoder.stringconstants[88]);
       throw bytecoder.registerStack(var8, new Error().stack);
      }
     } else {
      // line number 291
      var4 = new java$lang$IllegalArgumentException();
      java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var4,bytecoder.stringconstants[87]);
      throw bytecoder.registerStack(var4, new Error().stack);
     }
    } else {
     // line number 288
     var1 = new java$lang$IllegalArgumentException();
     var2 = bytecoder.stringconstants[86];
     java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var1,var2);
     throw bytecoder.registerStack(var1, new Error().stack);
    }
  }

  V$implReplaceWith$Ljava$lang$String$(arg0) {
    // source file is CharsetDecoder.java
    var var0 = null;
    var0 = arg0;
    // line number 316
    return;
  }

  Ljava$nio$charset$Charset$$charset$$() {
    // source file is CharsetDecoder.java
    var var0 = null;
    // line number 244
    var0 = (this.charset);
    return var0;
  }
}


class org$luaj$vm2$Varargs extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$Varargs,[java$lang$Object,org$luaj$vm2$Varargs]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }

  Ljava$lang$String$$toString$$() {
    var var0 = null;
    var0 = (this.Ljava$lang$String$$tojstring$$());
    return var0;
  }

  Ljava$lang$String$$tojstring$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var phi5 = null;
    var phi6 = null;
    var phi7 = 0;
    var phi8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = 0;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    org$luaj$vm2$Buffer.$i;
    var0 = new org$luaj$vm2$Buffer();
    org$luaj$vm2$Buffer.prototype.V$$init$$$.call(var0);
    var1 = var0;
    var2 = (org$luaj$vm2$Buffer.prototype.Lorg$luaj$vm2$Buffer$$append$Ljava$lang$String$.call(var1,bytecoder.stringconstants[146]));
    var3 = (1) | 0;
    var4 = ((this.I$narg$$())) | 0;
    phi5 = this;
    phi6 = var0;
    phi7 = (var3) | 0;
    phi8 = (var4) | 0;
    L472792509: while(true) {
     var9 = (phi7) | 0;
     var10 = (phi8) | 0;
     if (var9 > var10) {
      var20 = phi6;
      var21 = (org$luaj$vm2$Buffer.prototype.Lorg$luaj$vm2$Buffer$$append$Ljava$lang$String$.call(var20,bytecoder.stringconstants[61]));
      var22 = phi6;
      var23 = (org$luaj$vm2$Buffer.prototype.Ljava$lang$String$$tojstring$$.call(var22));
      return var23;
     } else {
      var11 = (phi7) | 0;
      If_34_0: {
       if (var11 <= 1) {
        break If_34_0;
       } else {
        var12 = phi6;
        var13 = (org$luaj$vm2$Buffer.prototype.Lorg$luaj$vm2$Buffer$$append$Ljava$lang$String$.call(var12,bytecoder.stringconstants[147]));
        break If_34_0;
       }
      }
      var14 = phi6;
      var15 = phi5;
      var16 = (phi7) | 0;
      var17 = (var15.Lorg$luaj$vm2$LuaValue$$arg$I(var16));
      var18 = (var17.Ljava$lang$String$$tojstring$$());
      var19 = (org$luaj$vm2$Buffer.prototype.Lorg$luaj$vm2$Buffer$$append$Ljava$lang$String$.call(var14,var18));
      phi7 = ((phi7 + 1)) | 0;
      // Here was a goto statement
      continue L472792509;
     }
    }
  }

  V$copyto$$Lorg$luaj$vm2$LuaValue$$I$I(arg0,arg1,arg2) {
    var var0 = null;
    var var1 = 0;
    var phi2 = null;
    var phi3 = null;
    var phi4 = 0;
    var phi5 = 0;
    var phi6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var var13 = null;
    var var14 = 0;
    var var15 = 0;
    var var16 = null;
    var0 = arg0;
    var1 = (arg2) | 0;
    phi2 = this;
    phi3 = var0;
    phi4 = (arg1) | 0;
    phi5 = (var1) | 0;
    phi6 = (0) | 0;
    L402535689: while(true) {
     var7 = (phi6) | 0;
     var8 = (phi5) | 0;
     if (var7 >= var8) {
      return;
     } else {
      var9 = phi3;
      var10 = (phi4) | 0;
      var11 = (phi6) | 0;
      var12 = ((var10 + var11)) | 0;
      var13 = phi2;
      var14 = (phi6) | 0;
      var15 = ((var14 + 1)) | 0;
      var16 = (var13.Lorg$luaj$vm2$LuaValue$$arg$I(var15));
      var9.data[var12] = var16;
      phi6 = ((phi6 + 1)) | 0;
      // Here was a goto statement
      continue L402535689;
     }
    }
  }

  Lorg$luaj$vm2$Varargs$$dealias$$() {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var0 = ((this.I$narg$$())) | 0;
    var1 = (var0) | 0;
    if ((var1) >= 0 && (var1) <= 2) switch ((var1) - 0) {
     case 0: {
      org$luaj$vm2$LuaValue.$i;
      var7 = (org$luaj$vm2$LuaValue.NONE);
      return var7;
     }
     case 1: {
      var6 = (this.Lorg$luaj$vm2$LuaValue$$arg1$$());
      return var6;
     }
     case 2: {
      var2 = new org$luaj$vm2$Varargs$PairVarargs();
      var3 = (this.Lorg$luaj$vm2$LuaValue$$arg1$$());
      var4 = (2) | 0;
      var5 = (this.Lorg$luaj$vm2$LuaValue$$arg$I(var4));
      org$luaj$vm2$Varargs$PairVarargs.prototype.V$$init$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$Varargs$.call(var2,var3,var5);
      return var2;
     }
    } else {
     var8 = bytecoder.newarray((var0),null);
     var9 = this;
     var10 = (var0) | 0;
     var9.V$copyto$$Lorg$luaj$vm2$LuaValue$$I$I(var8,0,var10);
     var11 = new org$luaj$vm2$Varargs$ArrayVarargs();
     var12 = var8;
     org$luaj$vm2$LuaValue.$i;
     var13 = (org$luaj$vm2$LuaValue.NONE);
     org$luaj$vm2$Varargs$ArrayVarargs.prototype.V$$init$$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$Varargs$.call(var11,var12,var13);
     return var11;
    }
  }

  Lorg$luaj$vm2$Varargs$$eval$$() {
    return this;
  }

  Z$isTailcall$$() {
    var var0 = 0;
    var0 = (0) | 0;
    return var0;
  }

  Z$isthread$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var0 = (arg0) | 0;
    var1 = (var0) | 0;
    var2 = (this.Lorg$luaj$vm2$LuaValue$$arg$I(var1));
    var3 = (var2.Z$isthread$$());
    return var3;
  }

  Lorg$luaj$vm2$LuaThread$$checkthread$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var0 = (arg0) | 0;
    var1 = (var0) | 0;
    var2 = (this.Lorg$luaj$vm2$LuaValue$$arg$I(var1));
    var3 = (var2.Lorg$luaj$vm2$LuaThread$$checkthread$$());
    return var3;
  }

  Lorg$luaj$vm2$LuaFunction$$optfunction$I$Lorg$luaj$vm2$LuaFunction$(arg0,arg1) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var0 = (arg0) | 0;
    var1 = (var0) | 0;
    var2 = (this.Lorg$luaj$vm2$LuaValue$$arg$I(var1));
    var3 = (var2.Lorg$luaj$vm2$LuaFunction$$optfunction$Lorg$luaj$vm2$LuaFunction$(arg1));
    return var3;
  }

  Ljava$lang$String$$optjstring$I$Ljava$lang$String$(arg0,arg1) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var0 = (arg0) | 0;
    var1 = (var0) | 0;
    var2 = (this.Lorg$luaj$vm2$LuaValue$$arg$I(var1));
    var3 = (var2.Ljava$lang$String$$optjstring$Ljava$lang$String$(arg1));
    return var3;
  }

  I$optint$I$I(arg0,arg1) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var0 = (arg0) | 0;
    var1 = (var0) | 0;
    var2 = (this.Lorg$luaj$vm2$LuaValue$$arg$I(var1));
    var3 = ((var2.I$optint$I(arg1))) | 0;
    return var3;
  }

  I$checkint$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var0 = (arg0) | 0;
    var1 = (var0) | 0;
    var2 = (this.Lorg$luaj$vm2$LuaValue$$arg$I(var1));
    var3 = (var2.Lorg$luaj$vm2$LuaNumber$$checknumber$$());
    var4 = ((var3.I$toint$$())) | 0;
    return var4;
  }

  Lorg$luaj$vm2$LuaFunction$$checkfunction$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var0 = (arg0) | 0;
    var1 = (var0) | 0;
    var2 = (this.Lorg$luaj$vm2$LuaValue$$arg$I(var1));
    var3 = (var2.Lorg$luaj$vm2$LuaFunction$$checkfunction$$());
    return var3;
  }

  D$checkdouble$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = .0;
    var0 = (arg0) | 0;
    var1 = (var0) | 0;
    var2 = (this.Lorg$luaj$vm2$LuaValue$$arg$I(var1));
    var3 = (var2.Lorg$luaj$vm2$LuaNumber$$checknumber$$());
    var4 = (var3.D$todouble$$());
    return var4;
  }

  Ljava$lang$Object$$checkuserdata$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var0 = (arg0) | 0;
    var1 = (var0) | 0;
    var2 = (this.Lorg$luaj$vm2$LuaValue$$arg$I(var1));
    var3 = (var2.Ljava$lang$Object$$checkuserdata$$());
    return var3;
  }

  Lorg$luaj$vm2$LuaValue$$checkvalue$I(arg0) {
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var phi5 = null;
    var phi6 = 0;
    var phi7 = null;
    var var8 = null;
    var0 = (arg0) | 0;
    var1 = this;
    var2 = ((var1.I$narg$$())) | 0;
    If_10_0: {
     if (var0 > var2) {
      org$luaj$vm2$LuaValue.$i;
      var8 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaValue$$argerror$I$Ljava$lang$String$(var0,bytecoder.stringconstants[441]));
      phi5 = this;
      phi6 = (var0) | 0;
      phi7 = var8;
      break If_10_0;
     } else {
      var3 = this;
      var4 = (var3.Lorg$luaj$vm2$LuaValue$$arg$I(var0));
      // Here was a goto statement
      phi5 = this;
      phi6 = (var0) | 0;
      phi7 = var4;
      break If_10_0;
     }
    }
    return phi7;
  }

  Lorg$luaj$vm2$LuaClosure$$checkclosure$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var0 = (arg0) | 0;
    var1 = (var0) | 0;
    var2 = (this.Lorg$luaj$vm2$LuaValue$$arg$I(var1));
    var3 = (var2.Lorg$luaj$vm2$LuaClosure$$checkclosure$$());
    return var3;
  }
}


class org$luaj$vm2$lib$DebugLib$CallFrame extends java$lang$Object {
  nativeObject = null;

  previous = null;
  f = null;
  v = null;
  stack = null;
  pc = 0;
  top = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$lib$DebugLib$CallFrame,[java$lang$Object,org$luaj$vm2$lib$DebugLib$CallFrame]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }

  V$set$Lorg$luaj$vm2$LuaClosure$$Lorg$luaj$vm2$Varargs$$$Lorg$luaj$vm2$LuaValue$(arg0,arg1,arg2) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var0 = this;
    var1 = arg1;
    var2 = arg0;
    var0.f = var2;
    var3 = var1;
    var0.v = var3;
    var4 = arg2;
    var0.stack = var4;
    return;
  }

  V$reset$$() {
    var var0 = null;
    var var1 = null;
    var0 = this;
    var1 = null;
    var0.f = var1;
    var0.v = null;
    var0.stack = null;
    return;
  }

  Ljava$lang$String$$shortsource$$() {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var phi7 = null;
    var phi8 = null;
    var0 = (this.f);
    var1 = (var0.Z$isclosure$$());
    If_8_0: {
     if (var1 == 0) {
      phi7 = this;
      phi8 = bytecoder.stringconstants[189];
      break If_8_0;
     } else {
      var2 = this;
      var3 = (var2.f);
      var4 = (var3.Lorg$luaj$vm2$LuaClosure$$checkclosure$$());
      var5 = (var4.p);
      var6 = (org$luaj$vm2$Prototype.prototype.Ljava$lang$String$$shortsource$$.call(var5));
      // Here was a goto statement
      phi7 = this;
      phi8 = var6;
      break If_8_0;
     }
    }
    return phi8;
  }

  I$currentline$$() {
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = 0;
    var var10 = null;
    var var11 = 0;
    var var12 = 0;
    var phi13 = null;
    var phi14 = null;
    var phi15 = 0;
    var var16 = null;
    var var17 = 0;
    var var18 = 0;
    var0 = (this.f);
    var1 = (var0.Z$isclosure$$());
    if (var1 != 0) {
     var3 = (this.f);
     var4 = (var3.Lorg$luaj$vm2$LuaClosure$$checkclosure$$());
     var5 = (var4.p);
     var6 = (var5.lineinfo);
     var7 = var6;
     If_30_0: {
      If_30_1: {
       if (var7 == null) {
        phi13 = this;
        phi14 = var6;
        break If_30_1;
       } else {
        var8 = this;
        var9 = ((var8.pc)) | 0;
        if (var9 < 0) {
         phi13 = this;
         phi14 = var6;
         break If_30_1;
        } else {
         var10 = this;
         var11 = ((var10.pc)) | 0;
         var12 = (var6.data.length) | 0;
         if (var11 < var12) {
          var16 = this;
          var17 = ((var16.pc)) | 0;
          var18 = ((var6.data[var17])) | 0;
          phi13 = this;
          phi14 = var6;
          phi15 = (var18) | 0;
          break If_30_0;
         } else {
          phi13 = this;
          phi14 = var6;
          break If_30_1;
         }
        }
       }
      }
      // Here was a goto statement
      phi15 = (-1) | 0;
      break If_30_0;
     }
     return phi15;
    } else {
     var2 = (-1) | 0;
     return var2;
    }
  }

  static I$access$1500$Lorg$luaj$vm2$lib$DebugLib$CallFrame$(arg0) {
    var var0 = 0;
    var0 = ((org$luaj$vm2$lib$DebugLib$CallFrame.prototype.I$linedefined$$.call(arg0))) | 0;
    return var0;
  }

  I$linedefined$$() {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var phi7 = null;
    var phi8 = 0;
    var0 = (this.f);
    var1 = (var0.Z$isclosure$$());
    If_8_0: {
     if (var1 == 0) {
      phi7 = this;
      phi8 = (-1) | 0;
      break If_8_0;
     } else {
      var2 = this;
      var3 = (var2.f);
      var4 = (var3.Lorg$luaj$vm2$LuaClosure$$checkclosure$$());
      var5 = (var4.p);
      var6 = ((var5.linedefined)) | 0;
      // Here was a goto statement
      phi7 = this;
      phi8 = (var6) | 0;
      break If_8_0;
     }
    }
    return phi8;
  }

  V$instr$I$Lorg$luaj$vm2$Varargs$$I(arg0,arg1,arg2) {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var phi11 = null;
    var phi12 = 0;
    var phi13 = null;
    var phi14 = 0;
    var0 = this;
    var1 = arg1;
    var2 = (arg0) | 0;
    var0.pc = var2;
    var3 = var1;
    var0.v = var3;
    var4 = (arg2) | 0;
    var0.top = var4;
    org$luaj$vm2$lib$DebugLib.$i;
    var5 = (org$luaj$vm2$lib$DebugLib.TRACE);
    If_23_0: {
     if (var5 == 0) {
      phi11 = var0;
      phi12 = (arg0) | 0;
      phi13 = var1;
      phi14 = (arg2) | 0;
      break If_23_0;
     } else {
      var6 = var0;
      var7 = (var6.f);
      var8 = (var7.Lorg$luaj$vm2$LuaClosure$$checkclosure$$());
      var9 = var0;
      var10 = (var9.stack);
      org$luaj$vm2$Print.$i;
      org$luaj$vm2$Print.V$printState$Lorg$luaj$vm2$LuaClosure$$I$$Lorg$luaj$vm2$LuaValue$$I$Lorg$luaj$vm2$Varargs$(var8,arg0,var10,arg2,var1);
      phi11 = var0;
      phi12 = (arg0) | 0;
      phi13 = var1;
      phi14 = (arg2) | 0;
      break If_23_0;
     }
    }
    return;
  }

  Lorg$luaj$vm2$Varargs$$setLocal$I$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var var8 = null;
    var0 = (arg0) | 0;
    var1 = (var0) | 0;
    var2 = (org$luaj$vm2$lib$DebugLib$CallFrame.prototype.Lorg$luaj$vm2$LuaString$$getlocalname$I.call(this,var1));
    var3 = var2;
    if (var3 == null) {
     org$luaj$vm2$LuaValue.$i;
     var8 = (org$luaj$vm2$LuaValue.NIL);
     return var8;
    } else {
     var4 = this;
     var5 = (var4.stack);
     var6 = (1) | 0;
     var7 = ((var0 - var6)) | 0;
     var5.data[var7] = arg1;
     return var2;
    }
  }

  Lorg$luaj$vm2$LuaString$$getlocalname$I(arg0) {
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var0 = (arg0) | 0;
    var1 = (this.f);
    var2 = (var1.Z$isclosure$$());
    if (var2 != 0) {
     var4 = (this.f);
     var5 = (var4.Lorg$luaj$vm2$LuaClosure$$checkclosure$$());
     var6 = (var5.p);
     var7 = this;
     var8 = ((var7.pc)) | 0;
     var9 = (org$luaj$vm2$Prototype.prototype.Lorg$luaj$vm2$LuaString$$getlocalname$I$I.call(var6,var0,var8));
     return var9;
    } else {
     var3 = null;
     return var3;
    }
  }

  Lorg$luaj$vm2$Varargs$$getLocal$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var0 = (arg0) | 0;
    var1 = (var0) | 0;
    var2 = (org$luaj$vm2$lib$DebugLib$CallFrame.prototype.Lorg$luaj$vm2$LuaString$$getlocalname$I.call(this,var1));
    var3 = var2;
    if (var3 == null) {
     org$luaj$vm2$LuaValue.$i;
     var10 = (org$luaj$vm2$LuaValue.NIL);
     return var10;
    } else {
     var4 = var2;
     var5 = (this.stack);
     var6 = (1) | 0;
     var7 = ((var0 - var6)) | 0;
     var8 = (var5.data[var7]);
     org$luaj$vm2$LuaValue.$i;
     var9 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$Varargs$$varargsOf$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$Varargs$(var4,var8));
     return var9;
    }
  }
}


class jdk$internal$util$ArraysSupport extends java$lang$Object {
  nativeObject = null;

  static U = null;
  static BIG_ENDIAN = false;
  static LOG2_ARRAY_BOOLEAN_INDEX_SCALE = 0;
  static LOG2_ARRAY_BYTE_INDEX_SCALE = 0;
  static LOG2_ARRAY_CHAR_INDEX_SCALE = 0;
  static LOG2_ARRAY_SHORT_INDEX_SCALE = 0;
  static LOG2_ARRAY_INT_INDEX_SCALE = 0;
  static LOG2_ARRAY_LONG_INDEX_SCALE = 0;
  static LOG2_ARRAY_FLOAT_INDEX_SCALE = 0;
  static LOG2_ARRAY_DOUBLE_INDEX_SCALE = 0;
  static LOG2_BYTE_BIT_SIZE = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(jdk$internal$util$ArraysSupport,[java$lang$Object,jdk$internal$util$ArraysSupport]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is ArraysSupport.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = 0;
    var var17 = 0;
    var var18 = 0;
    var var19 = 0;
    // line number 56
    jdk$internal$misc$Unsafe.$i;
    var0 = (jdk$internal$misc$Unsafe.Ljdk$internal$misc$Unsafe$$getUnsafe$$());
    jdk$internal$util$ArraysSupport.$i;
    jdk$internal$util$ArraysSupport.U = var0;
    // line number 58
    var1 = (jdk$internal$util$ArraysSupport.U);
    var2 = (jdk$internal$misc$Unsafe.prototype.Z$isBigEndian$$.call(var1));
    jdk$internal$util$ArraysSupport.BIG_ENDIAN = var2;
    // line number 60
    var3 = ((jdk$internal$misc$Unsafe.ARRAY_BOOLEAN_INDEX_SCALE)) | 0;
    var4 = ((jdk$internal$util$ArraysSupport.I$exactLog2$I(var3))) | 0;
    jdk$internal$util$ArraysSupport.LOG2_ARRAY_BOOLEAN_INDEX_SCALE = var4;
    // line number 61
    var5 = ((jdk$internal$misc$Unsafe.ARRAY_BYTE_INDEX_SCALE)) | 0;
    var6 = ((jdk$internal$util$ArraysSupport.I$exactLog2$I(var5))) | 0;
    jdk$internal$util$ArraysSupport.LOG2_ARRAY_BYTE_INDEX_SCALE = var6;
    // line number 62
    var7 = ((jdk$internal$misc$Unsafe.ARRAY_CHAR_INDEX_SCALE)) | 0;
    var8 = ((jdk$internal$util$ArraysSupport.I$exactLog2$I(var7))) | 0;
    jdk$internal$util$ArraysSupport.LOG2_ARRAY_CHAR_INDEX_SCALE = var8;
    // line number 63
    var9 = ((jdk$internal$misc$Unsafe.ARRAY_SHORT_INDEX_SCALE)) | 0;
    var10 = ((jdk$internal$util$ArraysSupport.I$exactLog2$I(var9))) | 0;
    jdk$internal$util$ArraysSupport.LOG2_ARRAY_SHORT_INDEX_SCALE = var10;
    // line number 64
    var11 = ((jdk$internal$misc$Unsafe.ARRAY_INT_INDEX_SCALE)) | 0;
    var12 = ((jdk$internal$util$ArraysSupport.I$exactLog2$I(var11))) | 0;
    jdk$internal$util$ArraysSupport.LOG2_ARRAY_INT_INDEX_SCALE = var12;
    // line number 65
    var13 = ((jdk$internal$misc$Unsafe.ARRAY_LONG_INDEX_SCALE)) | 0;
    var14 = ((jdk$internal$util$ArraysSupport.I$exactLog2$I(var13))) | 0;
    jdk$internal$util$ArraysSupport.LOG2_ARRAY_LONG_INDEX_SCALE = var14;
    // line number 66
    var15 = ((jdk$internal$misc$Unsafe.ARRAY_FLOAT_INDEX_SCALE)) | 0;
    var16 = ((jdk$internal$util$ArraysSupport.I$exactLog2$I(var15))) | 0;
    jdk$internal$util$ArraysSupport.LOG2_ARRAY_FLOAT_INDEX_SCALE = var16;
    // line number 67
    var17 = ((jdk$internal$misc$Unsafe.ARRAY_DOUBLE_INDEX_SCALE)) | 0;
    var18 = ((jdk$internal$util$ArraysSupport.I$exactLog2$I(var17))) | 0;
    jdk$internal$util$ArraysSupport.LOG2_ARRAY_DOUBLE_INDEX_SCALE = var18;
    // line number 69
    var19 = ((jdk$internal$util$ArraysSupport.I$exactLog2$I(8))) | 0;
    jdk$internal$util$ArraysSupport.LOG2_BYTE_BIT_SIZE = var19;
    return;
  }

  static I$exactLog2$I(arg0) {
    // source file is ArraysSupport.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    // line number 72
    var0 = (arg0) | 0;
    var1 = ((var0 - 1)) | 0;
    var2 = ((arg0 & var1)) | 0;
    if (var2 == 0) {
     // line number 74
     java$lang$Integer.$i;
     var5 = ((java$lang$Integer.I$numberOfTrailingZeros$I(arg0))) | 0;
     return var5;
    } else {
     // line number 73
     var3 = new java$lang$Error();
     var4 = bytecoder.stringconstants[139];
     java$lang$Error.prototype.V$$init$$Ljava$lang$String$.call(var3,var4);
     throw bytecoder.registerStack(var3, new Error().stack);
    }
  }

  static I$vectorizedMismatch$Ljava$lang$Object$$J$Ljava$lang$Object$$J$I$I(arg0,arg1,arg2,arg3,arg4,arg5) {
    // source file is ArraysSupport.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var phi5 = null;
    var phi6 = 0;
    var phi7 = null;
    var phi8 = 0;
    var phi9 = 0;
    var phi10 = 0;
    var phi11 = 0;
    var phi12 = 0;
    var var13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = 0;
    var var17 = 0;
    var var18 = 0;
    var var19 = 0;
    var var20 = 0;
    var var21 = null;
    var var22 = null;
    var var23 = 0;
    var var24 = 0;
    var var25 = 0;
    var var26 = null;
    var var27 = null;
    var var28 = 0;
    var var29 = 0;
    var var30 = 0;
    var var31 = 0;
    var var32 = 0;
    var var33 = 0;
    var var34 = 0;
    var var35 = 0;
    var var36 = 0;
    var var37 = 0;
    var var38 = 0;
    var var39 = 0;
    var var40 = 0;
    var phi41 = 0;
    var phi42 = 0;
    var phi43 = 0;
    var phi44 = 0;
    var phi45 = 0;
    var var46 = 0;
    var var47 = 0;
    var var48 = 0;
    var var49 = 0;
    var var50 = 0;
    var var51 = 0;
    var var52 = 0;
    var var53 = 0;
    var var54 = 0;
    var var55 = 0;
    var var56 = 0;
    var var57 = 0;
    var var58 = 0;
    var var59 = 0;
    var var60 = 0;
    var var61 = 0;
    var var62 = 0;
    var var63 = 0;
    var var64 = 0;
    var var65 = 0;
    var var66 = 0;
    var var67 = 0;
    var var68 = 0;
    var var69 = 0;
    var var70 = 0;
    var var71 = 0;
    var var72 = null;
    var var73 = null;
    var var74 = 0;
    var var75 = 0;
    var var76 = 0;
    var var77 = null;
    var var78 = null;
    var var79 = 0;
    var var80 = 0;
    var var81 = 0;
    var var82 = 0;
    var var83 = 0;
    var var84 = 0;
    var var85 = 0;
    var var86 = 0;
    var var87 = 0;
    var var88 = 0;
    var var89 = 0;
    var var90 = 0;
    var phi91 = 0;
    var phi92 = 0;
    var phi93 = 0;
    var phi94 = 0;
    var phi95 = 0;
    var phi96 = 0;
    var phi97 = 0;
    var var98 = 0;
    var var99 = 0;
    var var100 = 0;
    var var101 = 0;
    var var102 = 0;
    var var103 = 0;
    var var104 = 0;
    var var105 = 0;
    var var106 = 0;
    var var107 = 0;
    var var108 = 0;
    var var109 = 0;
    var phi110 = 0;
    var phi111 = 0;
    var phi112 = 0;
    var var113 = 0;
    var var114 = 0;
    var var115 = 0;
    var0 = arg1;
    var1 = arg3;
    var2 = (arg5) | 0;
    // line number 122
    jdk$internal$util$ArraysSupport.$i;
    var3 = ((jdk$internal$util$ArraysSupport.LOG2_ARRAY_LONG_INDEX_SCALE)) | 0;
    var4 = ((var3 - var2)) | 0;
    // line number 123
    phi5 = arg0;
    phi6 = var0;
    phi7 = arg2;
    phi8 = var1;
    phi9 = (arg4) | 0;
    phi10 = (var2) | 0;
    phi11 = (var4) | 0;
    phi12 = (0) | 0;
    L1195577304: while(true) {
     // line number 124
     var13 = (phi12) | 0;
     var14 = (phi9) | 0;
     var15 = (phi11) | 0;
     var16 = ((var14 >> var15)) | 0;
     if (var13 >= var16) {
      // line number 138
      var56 = (phi9) | 0;
      var57 = (phi12) | 0;
      var58 = (phi11) | 0;
      var59 = ((var57 << var58)) | 0;
      var60 = ((var56 - var59)) | 0;
      // line number 140
      var61 = (phi10) | 0;
      var62 = ((jdk$internal$util$ArraysSupport.LOG2_ARRAY_INT_INDEX_SCALE)) | 0;
      if (var61 >= var62) {
       // line number 159
       var115 = ((var60 ^ -1)) | 0;
       return var115;
      } else {
       // line number 141
       var63 = ((jdk$internal$util$ArraysSupport.LOG2_ARRAY_INT_INDEX_SCALE)) | 0;
       var64 = (phi10) | 0;
       var65 = ((var63 - var64)) | 0;
       var66 = ((1 << var65)) | 0;
       // line number 143
       var67 = (var66) | 0;
       If_232_0: {
        if (var60 < var67) {
         phi110 = (var60) | 0;
         phi111 = (var66) | 0;
         break If_232_0;
        } else {
         // line number 144
         var68 = (phi12) | 0;
         var69 = (var68 | 0);
         var70 = ((jdk$internal$util$ArraysSupport.LOG2_ARRAY_LONG_INDEX_SCALE)) | 0;
         var71 = (var69 << var70);
         // line number 145
         var72 = (jdk$internal$util$ArraysSupport.U);
         var73 = phi5;
         var74 = phi6;
         var75 = (var74 + var71);
         var76 = ((jdk$internal$misc$Unsafe.prototype.I$getIntUnaligned$Ljava$lang$Object$$J.call(var72,var73,var75))) | 0;
         // line number 146
         var77 = (jdk$internal$util$ArraysSupport.U);
         var78 = phi7;
         var79 = phi8;
         var80 = (var79 + var71);
         var81 = ((jdk$internal$misc$Unsafe.prototype.I$getIntUnaligned$Ljava$lang$Object$$J.call(var77,var78,var80))) | 0;
         // line number 147
         var82 = (var81) | 0;
         if (var76 == var82) {
          // line number 154
          var108 = (var66) | 0;
          var109 = ((var60 - var108)) | 0;
          phi110 = (var109) | 0;
          phi111 = (var66) | 0;
          phi112 = (var76) | 0;
          break If_232_0;
         } else {
          // line number 148
          var83 = (var81) | 0;
          var84 = ((var76 ^ var83)) | 0;
          // line number 149
          var85 = (jdk$internal$util$ArraysSupport.BIG_ENDIAN);
          If_299_0: {
           if (var85 == 0) {
            // line number 151
            java$lang$Integer.$i;
            var103 = ((java$lang$Integer.I$numberOfTrailingZeros$I(var84))) | 0;
            var104 = ((jdk$internal$util$ArraysSupport.LOG2_BYTE_BIT_SIZE)) | 0;
            var105 = (phi10) | 0;
            var106 = ((var104 + var105)) | 0;
            var107 = ((var103 >> var106)) | 0;
            phi91 = (var60) | 0;
            phi92 = (var66) | 0;
            phi93 = var71;
            phi94 = (var76) | 0;
            phi95 = (var81) | 0;
            phi96 = (var84) | 0;
            phi97 = (var107) | 0;
            break If_299_0;
           } else {
            // line number 150
            java$lang$Integer.$i;
            var86 = ((java$lang$Integer.I$numberOfLeadingZeros$I(var84))) | 0;
            var87 = ((jdk$internal$util$ArraysSupport.LOG2_BYTE_BIT_SIZE)) | 0;
            var88 = (phi10) | 0;
            var89 = ((var87 + var88)) | 0;
            var90 = ((var86 >> var89)) | 0;
            // Here was a goto statement
            phi91 = (var60) | 0;
            phi92 = (var66) | 0;
            phi93 = var71;
            phi94 = (var76) | 0;
            phi95 = (var81) | 0;
            phi96 = (var84) | 0;
            phi97 = (var90) | 0;
            break If_299_0;
           }
          }
          var98 = (phi97) | 0;
          // line number 152
          var99 = (phi12) | 0;
          var100 = (phi11) | 0;
          var101 = ((var99 << var100)) | 0;
          var102 = ((var101 + var98)) | 0;
          return var102;
         }
        }
       }
       // line number 156
       var113 = (phi110) | 0;
       var114 = ((var113 ^ -1)) | 0;
       return var114;
      }
     } else {
      // line number 125
      var17 = (phi12) | 0;
      var18 = (var17 | 0);
      var19 = ((jdk$internal$util$ArraysSupport.LOG2_ARRAY_LONG_INDEX_SCALE)) | 0;
      var20 = (var18 << var19);
      // line number 126
      var21 = (jdk$internal$util$ArraysSupport.U);
      var22 = phi5;
      var23 = phi6;
      var24 = (var23 + var20);
      var25 = (jdk$internal$misc$Unsafe.prototype.J$getLongUnaligned$Ljava$lang$Object$$J.call(var21,var22,var24));
      // line number 127
      var26 = (jdk$internal$util$ArraysSupport.U);
      var27 = phi7;
      var28 = phi8;
      var29 = (var28 + var20);
      var30 = (jdk$internal$misc$Unsafe.prototype.J$getLongUnaligned$Ljava$lang$Object$$J.call(var26,var27,var29));
      // line number 128
      var31 = var30;
      var32 = (bytecoder.cmp(var25,var31)) | 0;
      if (var32 == 0) {
       // line number 124
       phi12 = ((phi12 + 1)) | 0;
       // Here was a goto statement
       continue L1195577304;
      } else {
       // line number 129
       var33 = var30;
       var34 = (var25 ^ var33);
       // line number 130
       var35 = (jdk$internal$util$ArraysSupport.BIG_ENDIAN);
       If_117_0: {
        if (var35 == 0) {
         // line number 132
         java$lang$Long.$i;
         var51 = ((java$lang$Long.I$numberOfTrailingZeros$J(var34))) | 0;
         var52 = ((jdk$internal$util$ArraysSupport.LOG2_BYTE_BIT_SIZE)) | 0;
         var53 = (phi10) | 0;
         var54 = ((var52 + var53)) | 0;
         var55 = ((var51 >> var54)) | 0;
         phi41 = var20;
         phi42 = var25;
         phi43 = var30;
         phi44 = var34;
         phi45 = (var55) | 0;
         break If_117_0;
        } else {
         // line number 131
         java$lang$Long.$i;
         var36 = ((java$lang$Long.I$numberOfLeadingZeros$J(var34))) | 0;
         var37 = ((jdk$internal$util$ArraysSupport.LOG2_BYTE_BIT_SIZE)) | 0;
         var38 = (phi10) | 0;
         var39 = ((var37 + var38)) | 0;
         var40 = ((var36 >> var39)) | 0;
         // Here was a goto statement
         phi41 = var20;
         phi42 = var25;
         phi43 = var30;
         phi44 = var34;
         phi45 = (var40) | 0;
         break If_117_0;
        }
       }
       var46 = (phi45) | 0;
       // line number 133
       var47 = (phi12) | 0;
       var48 = (phi11) | 0;
       var49 = ((var47 << var48)) | 0;
       var50 = ((var49 + var46)) | 0;
       return var50;
      }
     }
    }
  }

  V$$init$$$() {
    // source file is ArraysSupport.java
    // line number 77
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }

  static I$newLength$I$I$I(arg0,arg1,arg2) {
    // source file is ArraysSupport.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var phi6 = 0;
    var phi7 = 0;
    var phi8 = 0;
    var phi9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var0 = (arg1) | 0;
    // line number 637
    var1 = (var0) | 0;
    java$lang$Math.$i;
    var2 = ((java$lang$Math.I$max$I$I(var1,arg2))) | 0;
    var3 = ((arg0 + var2)) | 0;
    // line number 638
    var4 = (var3) | 0;
    If_23_0: {
     if (0 >= var4) {
      phi6 = (arg0) | 0;
      phi7 = (var0) | 0;
      phi8 = (arg2) | 0;
      phi9 = (var3) | 0;
      break If_23_0;
     } else {
      var5 = (var3) | 0;
      if (var5 > 2147483639) {
       phi6 = (arg0) | 0;
       phi7 = (var0) | 0;
       phi8 = (arg2) | 0;
       phi9 = (var3) | 0;
       break If_23_0;
      } else {
       // line number 639
       return var3;
      }
     }
    }
    // line number 642
    var10 = (phi6) | 0;
    var11 = (phi7) | 0;
    jdk$internal$util$ArraysSupport.$i;
    var12 = ((jdk$internal$util$ArraysSupport.I$hugeLength$I$I(var10,var11))) | 0;
    return var12;
  }

  static I$hugeLength$I$I(arg0,arg1) {
    // source file is ArraysSupport.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var0 = (arg1) | 0;
    // line number 647
    var1 = (var0) | 0;
    var2 = ((arg0 + var1)) | 0;
    // line number 648
    if (var2 >= 0) {
     // line number 651
     if (var2 > 2147483639) {
      // line number 654
      return var2;
     } else {
      // line number 652
      return 2147483639;
     }
    } else {
     // line number 649
     var3 = new java$lang$OutOfMemoryError();
     var4 = new java$lang$StringBuilder();
     java$lang$StringBuilder.prototype.V$$init$$$.call(var4);
     var5 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var4,bytecoder.stringconstants[377]));
     var6 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var5,arg0));
     var7 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var6,bytecoder.stringconstants[378]));
     var8 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var7,var0));
     var9 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var8,bytecoder.stringconstants[379]));
     var10 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var9));
     java$lang$OutOfMemoryError.prototype.V$$init$$Ljava$lang$String$.call(var3,var10);
     throw bytecoder.registerStack(var3, new Error().stack);
    }
  }
}


class jdk$internal$access$SharedSecrets extends java$lang$Object {
  nativeObject = null;

  static javaIOPrintStreamAccess = null;
  static javaNioAccess = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(jdk$internal$access$SharedSecrets,[java$lang$Object,jdk$internal$access$SharedSecrets]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  static V$setJavaIOCPrintStreamAccess$Ljdk$internal$access$JavaIOPrintStreamAccess$(arg0) {
    // source file is SharedSecrets.java
    // line number 297
    jdk$internal$access$SharedSecrets.javaIOPrintStreamAccess = arg0;
    // line number 298
    return;
  }

  static V$setJavaNioAccess$Ljdk$internal$access$JavaNioAccess$(arg0) {
    // source file is SharedSecrets.java
    // line number 256
    jdk$internal$access$SharedSecrets.javaNioAccess = arg0;
    // line number 257
    return;
  }

  V$$init$$$() {
    // source file is SharedSecrets.java
    // line number 57
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class java$lang$ClassLoader extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$ClassLoader,[java$lang$Object,java$lang$ClassLoader]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is ClassLoader.java
    // line number 22
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class java$lang$CharSequence extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$CharSequence,[java$lang$Object,java$lang$CharSequence]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.I$length$$ = impl;
  }

  Z$isEmpty$$() {
    // source file is CharSequence.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    // line number 101
    var0 = ((this.I$length$$())) | 0;
    If_7_0: {
     if (var0 != 0) {
      phi2 = this;
      phi3 = (0) | 0;
      break If_7_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = this;
      phi3 = (var1) | 0;
      break If_7_0;
     }
    }
    return phi3;
  }
}


class de$mirkosertic$bytecoder$classlib$Array extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(de$mirkosertic$bytecoder$classlib$Array,[de$mirkosertic$bytecoder$classlib$Array,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  static $Ljava$lang$Object$$newObjectArray$I(arg0) {
    // source file is Array.java
    var var0 = null;
    // line number 101
    var0 = bytecoder.newarray((arg0),null);
    return var0;
  }

  static $C$newCharArray$I(arg0) {
    // source file is Array.java
    var var0 = null;
    // line number 106
    var0 = bytecoder.newarray((arg0),0);
    return var0;
  }

  static I$charArrayLength$$C(arg0) {
    // source file is Array.java
    var var0 = 0;
    // line number 111
    var0 = (arg0.data.length) | 0;
    return var0;
  }

  static C$getCharArrayEntry$$C$I(arg0,arg1) {
    // source file is Array.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var0 = (arg1) | 0;
    // line number 116
    var1 = (var0) | 0;
    var2 = (arg0.data[var1]);
    return var2;
  }

  static V$setCharArrayEntry$$C$I$C(arg0,arg1,arg2) {
    // source file is Array.java
    var var0 = 0;
    var var1 = 0;
    var0 = (arg1) | 0;
    // line number 121
    var1 = (var0) | 0;
    arg0.data[var1] = arg2;
    // line number 122
    return;
  }

  static $B$newByteArray$I(arg0) {
    // source file is Array.java
    var var0 = null;
    // line number 126
    var0 = bytecoder.newarray((arg0),0);
    return var0;
  }

  static I$byteArrayLength$$B(arg0) {
    // source file is Array.java
    var var0 = 0;
    // line number 131
    var0 = (arg0.data.length) | 0;
    return var0;
  }

  static B$getByteArrayEntry$$B$I(arg0,arg1) {
    // source file is Array.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var0 = (arg1) | 0;
    // line number 136
    var1 = (var0) | 0;
    var2 = (arg0.data[var1]);
    return var2;
  }

  static V$setByteArrayEntry$$B$I$B(arg0,arg1,arg2) {
    // source file is Array.java
    var var0 = 0;
    var var1 = 0;
    var0 = (arg1) | 0;
    // line number 141
    var1 = (var0) | 0;
    arg0.data[var1] = arg2;
    // line number 142
    return;
  }

  static I$getIntArrayEntry$$I$I(arg0,arg1) {
    // source file is Array.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var0 = (arg1) | 0;
    // line number 146
    var1 = (var0) | 0;
    var2 = ((arg0.data[var1])) | 0;
    return var2;
  }

  V$$init$$$() {
    // source file is Array.java
    // line number 20
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class java$util$Arrays extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$Arrays,[java$lang$Object,java$util$Arrays]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is Arrays.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    // line number 75
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(java$util$Arrays.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    java$util$Arrays.$i;
    java$util$Arrays.$assertionsDisabled = phi2;
    return;
  }

  static $B$copyOf$$B$I(arg0,arg1) {
    // source file is Arrays.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var phi3 = null;
    var phi4 = 0;
    var phi5 = null;
    var phi6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = 0;
    var var12 = null;
    var var13 = 0;
    var var14 = null;
    var var15 = 0;
    var var16 = 0;
    var var17 = null;
    var0 = (arg1) | 0;
    // line number 82
    var1 = bytecoder.newarray((var0),0);
    // line number 83
    var2 = (0) | 0;
    phi3 = arg0;
    phi4 = (var0) | 0;
    phi5 = var1;
    phi6 = (var2) | 0;
    L121737480: while(true) {
     var7 = (phi6) | 0;
     var8 = (phi4) | 0;
     var9 = phi3;
     var10 = (var9.data.length) | 0;
     java$lang$Math.$i;
     var11 = ((java$lang$Math.I$min$I$I(var8,var10))) | 0;
     if (var7 >= var11) {
      // line number 86
      var17 = phi5;
      return var17;
     } else {
      // line number 84
      var12 = phi5;
      var13 = (phi6) | 0;
      var14 = phi3;
      var15 = (phi6) | 0;
      var16 = (var14.data[var15]);
      var12.data[var13] = var16;
      // line number 83
      phi6 = ((phi6 + 1)) | 0;
      // Here was a goto statement
      continue L121737480;
     }
    }
  }

  V$$init$$$() {
    // source file is Arrays.java
    // line number 78
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }

  static $C$copyOf$$C$I(arg0,arg1) {
    // source file is Arrays.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var phi3 = null;
    var phi4 = 0;
    var phi5 = null;
    var phi6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = 0;
    var var12 = null;
    var var13 = 0;
    var var14 = null;
    var var15 = 0;
    var var16 = 0;
    var var17 = null;
    var0 = (arg1) | 0;
    // line number 106
    var1 = bytecoder.newarray((var0),0);
    // line number 107
    var2 = (0) | 0;
    phi3 = arg0;
    phi4 = (var0) | 0;
    phi5 = var1;
    phi6 = (var2) | 0;
    L1036339722: while(true) {
     var7 = (phi6) | 0;
     var8 = (phi4) | 0;
     var9 = phi3;
     var10 = (var9.data.length) | 0;
     java$lang$Math.$i;
     var11 = ((java$lang$Math.I$min$I$I(var8,var10))) | 0;
     if (var7 >= var11) {
      // line number 110
      var17 = phi5;
      return var17;
     } else {
      // line number 108
      var12 = phi5;
      var13 = (phi6) | 0;
      var14 = phi3;
      var15 = (phi6) | 0;
      var16 = (var14.data[var15]);
      var12.data[var13] = var16;
      // line number 107
      phi6 = ((phi6 + 1)) | 0;
      // Here was a goto statement
      continue L1036339722;
     }
    }
  }
}


class java$lang$ThreadGroup extends java$lang$Object {
  nativeObject = null;

  name = null;
  parent = null;
  static SYSTEM = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$ThreadGroup,[java$lang$Object,java$lang$ThreadGroup]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is ThreadGroup.java
    var var0 = null;
    // line number 23
    java$lang$ThreadGroup.$i;
    var0 = new java$lang$ThreadGroup();
    java$lang$ThreadGroup.prototype.V$$init$$$.call(var0);
    java$lang$ThreadGroup.SYSTEM = var0;
    return;
  }

  V$$init$$$() {
    // source file is ThreadGroup.java
    var var0 = null;
    var var1 = null;
    // line number 28
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 29
    var0 = this;
    var0.name = bytecoder.stringconstants[71];
    // line number 30
    var1 = this;
    var1.parent = null;
    // line number 31
    return;
  }

  V$$init$$Ljava$lang$ThreadGroup$$Ljava$lang$String$(arg0,arg1) {
    // source file is ThreadGroup.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    // line number 38
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 39
    var1 = this;
    var1.name = arg1;
    // line number 40
    var2 = this;
    var2.parent = var0;
    // line number 41
    return;
  }
}


class java$util$HashMap$HashIterator extends java$lang$Object {
  nativeObject = null;

  this$0 = null;
  expectedModCount = 0;
  next = null;
  current = null;
  index = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$HashMap$HashIterator,[java$lang$Object,java$util$HashMap$HashIterator]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Ljava$util$HashMap$(arg0) {
    // source file is HashMap.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var phi8 = null;
    var phi9 = null;
    var phi10 = null;
    var var11 = null;
    var var12 = 0;
    var var13 = null;
    var var14 = 0;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = 0;
    var var19 = 0;
    var var20 = null;
    var0 = this;
    // line number 1587
    var1 = arg0;
    var0.this$0 = var1;
    java$lang$Object.prototype.V$$init$$$.call(var0);
    // line number 1588
    var2 = ((arg0.modCount)) | 0;
    var0.expectedModCount = var2;
    // line number 1589
    var3 = (arg0.table);
    // line number 1590
    var4 = var0;
    var5 = null;
    var4.next = var5;
    var0.current = null;
    // line number 1591
    var0.index = 0;
    // line number 1592
    If_37_0: {
     if (var3 == null) {
      phi8 = var0;
      phi9 = arg0;
      phi10 = var3;
      break If_37_0;
     } else {
      var6 = arg0;
      var7 = ((var6.size)) | 0;
      if (var7 <= 0) {
       phi8 = var0;
       phi9 = arg0;
       phi10 = var3;
       break If_37_0;
      } else {
       phi8 = var0;
       phi9 = arg0;
       phi10 = var3;
       L1735386282: while(true) {
        // line number 1593
        var11 = phi8;
        var12 = ((var11.index)) | 0;
        var13 = phi10;
        var14 = (var13.data.length) | 0;
        if (var12 >= var14) {
         break If_37_0;
        } else {
         var15 = phi8;
         var16 = phi10;
         var17 = phi8;
         var18 = ((var17.index)) | 0;
         var19 = ((var18 + 1)) | 0;
         var17.index = var19;
         var20 = (var16.data[var18]);
         var15.next = var20;
         if (var20 == null) {
          continue L1735386282;
         } else {
          break If_37_0;
         }
        }
       }
      }
     }
    }
    // line number 1595
    return;
  }

  Z$hasNext$$() {
    // source file is HashMap.java
    var var0 = null;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    // line number 1598
    var0 = (this.next);
    If_7_0: {
     if (var0 == null) {
      phi2 = this;
      phi3 = (0) | 0;
      break If_7_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = this;
      phi3 = (var1) | 0;
      break If_7_0;
     }
    }
    return phi3;
  }

  Ljava$util$HashMap$Node$$nextNode$$() {
    // source file is HashMap.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var phi14 = null;
    var phi15 = null;
    var phi16 = null;
    var var17 = null;
    var var18 = 0;
    var var19 = null;
    var var20 = 0;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = 0;
    var var25 = 0;
    var var26 = null;
    var var27 = null;
    // line number 1603
    var0 = (this.next);
    // line number 1604
    var1 = (this.this$0);
    var2 = ((var1.modCount)) | 0;
    var3 = ((this.expectedModCount)) | 0;
    if (var2 == var3) {
     // line number 1606
     if (var0 != null) {
      // line number 1608
      var6 = this;
      var7 = this;
      var8 = var0;
      var7.current = var8;
      var9 = (var0.next);
      var6.next = var9;
      If_57_0: {
       if (var9 != null) {
        phi14 = this;
        phi16 = var0;
        break If_57_0;
       } else {
        var10 = this;
        var11 = (var10.this$0);
        var12 = (var11.table);
        var13 = var12;
        if (var12 == null) {
         phi14 = this;
         phi15 = var13;
         phi16 = var0;
         break If_57_0;
        } else {
         phi14 = this;
         phi15 = var13;
         phi16 = var0;
         L988870804: while(true) {
          // line number 1609
          var17 = phi14;
          var18 = ((var17.index)) | 0;
          var19 = phi15;
          var20 = (var19.data.length) | 0;
          if (var18 >= var20) {
           break If_57_0;
          } else {
           var21 = phi14;
           var22 = phi15;
           var23 = phi14;
           var24 = ((var23.index)) | 0;
           var25 = ((var24 + 1)) | 0;
           var23.index = var25;
           var26 = (var22.data[var24]);
           var21.next = var26;
           if (var26 == null) {
            continue L988870804;
           } else {
            break If_57_0;
           }
          }
         }
        }
       }
      }
      // line number 1611
      var27 = phi16;
      return var27;
     } else {
      // line number 1607
      var5 = new java$util$NoSuchElementException();
      java$util$NoSuchElementException.prototype.V$$init$$$.call(var5);
      throw bytecoder.registerStack(var5, new Error().stack);
     }
    } else {
     // line number 1605
     var4 = new java$util$ConcurrentModificationException();
     java$util$ConcurrentModificationException.prototype.V$$init$$$.call(var4);
     throw bytecoder.registerStack(var4, new Error().stack);
    }
  }
}


class java$lang$constant$Constable extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$constant$Constable,[java$lang$Object,java$lang$constant$Constable]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class java$lang$Runnable extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Runnable,[java$lang$Object,java$lang$Runnable]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class org$luaj$vm2$compiler$LexState$ConsControl extends java$lang$Object {
  nativeObject = null;

  v = null;
  tostore = 0;
  nh = 0;
  na = 0;
  t = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$compiler$LexState$ConsControl,[java$lang$Object,org$luaj$vm2$compiler$LexState$ConsControl]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    var var0 = null;
    var var1 = null;
    java$lang$Object.prototype.V$$init$$$.call(this);
    var0 = this;
    var1 = new org$luaj$vm2$compiler$LexState$expdesc();
    org$luaj$vm2$compiler$LexState$expdesc.prototype.V$$init$$$.call(var1);
    var0.v = var1;
    return;
  }
}


class org$luaj$vm2$LocVars extends java$lang$Object {
  nativeObject = null;

  startpc = 0;
  endpc = 0;
  varname = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$LocVars,[java$lang$Object,org$luaj$vm2$LocVars]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Lorg$luaj$vm2$LuaString$$I$I(arg0,arg1,arg2) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var0 = arg0;
    var1 = (arg2) | 0;
    java$lang$Object.prototype.V$$init$$$.call(this);
    var2 = this;
    var2.varname = var0;
    var3 = this;
    var3.startpc = arg1;
    var4 = this;
    var4.endpc = var1;
    return;
  }
}


class java$lang$Readable extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Readable,[java$lang$Readable,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class java$lang$AutoCloseable extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$AutoCloseable,[java$lang$Object,java$lang$AutoCloseable]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class org$luaj$vm2$Buffer extends java$lang$Object {
  nativeObject = null;

  static NOBYTES = null;
  bytes = null;
  length = 0;
  offset = 0;
  value = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$Buffer,[java$lang$Object,org$luaj$vm2$Buffer]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    var var0 = null;
    var0 = bytecoder.newarray((0),0);
    org$luaj$vm2$Buffer.$i;
    org$luaj$vm2$Buffer.NOBYTES = var0;
    return;
  }

  V$$init$$$() {
    var var0 = 0;
    var0 = (64) | 0;
    org$luaj$vm2$Buffer.prototype.V$$init$$I.call(this,var0);
    return;
  }

  V$$init$$I(arg0) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var0 = (arg0) | 0;
    java$lang$Object.prototype.V$$init$$$.call(this);
    var1 = this;
    var2 = bytecoder.newarray((var0),0);
    var1.bytes = var2;
    var3 = this;
    var3.length = 0;
    var4 = this;
    var4.offset = 0;
    var5 = this;
    var5.value = null;
    return;
  }

  Lorg$luaj$vm2$Buffer$$append$Ljava$lang$String$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var var5 = null;
    var var6 = 0;
    var var7 = null;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = null;
    var var13 = 0;
    var var14 = 0;
    var0 = arg0;
    var1 = (java$lang$String.prototype.$C$toCharArray$$.call(var0));
    var2 = var1;
    org$luaj$vm2$LuaString.$i;
    var3 = ((org$luaj$vm2$LuaString.I$lengthAsUtf8$$C(var2))) | 0;
    var4 = (0) | 0;
    org$luaj$vm2$Buffer.prototype.V$makeroom$I$I.call(this,var4,var3);
    var5 = var1;
    var6 = (var5.data.length) | 0;
    var7 = (this.bytes);
    var8 = ((this.offset)) | 0;
    var9 = ((this.length)) | 0;
    var10 = ((var8 + var9)) | 0;
    var11 = ((org$luaj$vm2$LuaString.I$encodeToUtf8$$C$I$$B$I(var1,var6,var7,var10))) | 0;
    var12 = this;
    var13 = ((var12.length)) | 0;
    var14 = ((var13 + var3)) | 0;
    var12.length = var14;
    return this;
  }

  V$makeroom$I$I(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var var13 = null;
    var var14 = null;
    var var15 = 0;
    var var16 = null;
    var var17 = 0;
    var var18 = 0;
    var phi19 = null;
    var phi20 = 0;
    var phi21 = 0;
    var phi22 = null;
    var var23 = 0;
    var var24 = 0;
    var var25 = 0;
    var var26 = 0;
    var var27 = null;
    var var28 = 0;
    var var29 = null;
    var var30 = 0;
    var phi31 = null;
    var phi32 = 0;
    var phi33 = 0;
    var var34 = 0;
    var var35 = null;
    var var36 = 0;
    var var37 = 0;
    var var38 = 0;
    var var39 = 0;
    var var40 = 0;
    var var41 = 0;
    var phi42 = 0;
    var phi43 = 0;
    var var44 = 0;
    var var45 = null;
    var var46 = 0;
    var var47 = 0;
    var phi48 = 0;
    var phi49 = null;
    var phi50 = 0;
    var phi51 = 0;
    var var52 = null;
    var var53 = 0;
    var var54 = 0;
    var var55 = 0;
    var var56 = 0;
    var var57 = null;
    var var58 = 0;
    var var59 = 0;
    var var60 = null;
    var var61 = 0;
    var var62 = 0;
    var0 = (arg0) | 0;
    var1 = (this.value);
    If_9_0: {
     if (var1 == null) {
      var23 = ((this.offset)) | 0;
      var24 = ((this.length)) | 0;
      var25 = ((var23 + var24)) | 0;
      var26 = ((var25 + arg1)) | 0;
      var27 = (this.bytes);
      var28 = (var27.data.length) | 0;
      If_90_0: {
       if (var26 > var28) {
        phi31 = this;
        phi32 = (var0) | 0;
        phi33 = (arg1) | 0;
        break If_90_0;
       } else {
        var29 = this;
        var30 = ((var29.offset)) | 0;
        if (var30 >= var0) {
         phi19 = this;
         phi20 = (var0) | 0;
         phi21 = (arg1) | 0;
         break If_9_0;
        } else {
         phi31 = this;
         phi32 = (var0) | 0;
         phi33 = (arg1) | 0;
         break If_90_0;
        }
       }
      }
      var34 = (phi32) | 0;
      var35 = phi31;
      var36 = ((var35.length)) | 0;
      var37 = ((var34 + var36)) | 0;
      var38 = (phi33) | 0;
      var39 = ((var37 + var38)) | 0;
      var40 = (var39) | 0;
      If_121_0: {
       if (var40 >= 32) {
        var57 = phi31;
        var58 = ((var57.length)) | 0;
        var59 = ((var58 * 2)) | 0;
        if (var39 >= var59) {
         phi42 = (var39) | 0;
         phi43 = (var39) | 0;
         break If_121_0;
        } else {
         var60 = phi31;
         var61 = ((var60.length)) | 0;
         var62 = ((var61 * 2)) | 0;
         // Here was a goto statement
         phi42 = (var39) | 0;
         phi43 = (var62) | 0;
         break If_121_0;
        }
       } else {
        var41 = (32) | 0;
        // Here was a goto statement
        phi42 = (var39) | 0;
        phi43 = (var41) | 0;
        break If_121_0;
       }
      }
      var44 = (phi43) | 0;
      var45 = phi31;
      var46 = (phi32) | 0;
      If_136_0: {
       if (var46 != 0) {
        var52 = phi31;
        var53 = ((var52.length)) | 0;
        var54 = ((var44 - var53)) | 0;
        var55 = (phi33) | 0;
        var56 = ((var54 - var55)) | 0;
        phi48 = (var44) | 0;
        phi49 = var45;
        phi50 = (var44) | 0;
        phi51 = (var56) | 0;
        break If_136_0;
       } else {
        var47 = (0) | 0;
        // Here was a goto statement
        phi48 = (var44) | 0;
        phi49 = var45;
        phi50 = (var44) | 0;
        phi51 = (var47) | 0;
        break If_136_0;
       }
      }
      org$luaj$vm2$Buffer.prototype.V$realloc$I$I.call(phi49,phi50,phi51);
      phi19 = phi31;
      phi20 = (phi32) | 0;
      phi21 = (phi33) | 0;
      phi22 = phi42;
      break If_9_0;
     } else {
      var2 = this;
      var3 = (var2.value);
      var4 = (var3.Lorg$luaj$vm2$LuaString$$strvalue$$());
      var5 = this;
      var5.value = null;
      var6 = this;
      var7 = ((var4.m_length)) | 0;
      var6.length = var7;
      var8 = this;
      var8.offset = var0;
      var9 = this;
      var10 = ((this.length)) | 0;
      var11 = ((var0 + var10)) | 0;
      var12 = ((var11 + arg1)) | 0;
      var13 = bytecoder.newarray((var12),0);
      var9.bytes = var13;
      var14 = (var4.m_bytes);
      var15 = ((var4.m_offset)) | 0;
      var16 = (this.bytes);
      var17 = ((this.offset)) | 0;
      var18 = ((this.length)) | 0;
      java$lang$System.V$arraycopy$$B$I$$B$I$I(var14,var15,var16,var17,var18);
      // Here was a goto statement
      phi19 = this;
      phi20 = (var0) | 0;
      phi21 = (arg1) | 0;
      phi22 = var4;
      break If_9_0;
     }
    }
    return;
  }

  V$realloc$I$I(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = null;
    var var12 = null;
    var phi13 = null;
    var phi14 = 0;
    var phi15 = 0;
    var0 = (arg0) | 0;
    var1 = this;
    var2 = (var1.bytes);
    var3 = (var2.data.length) | 0;
    If_14_0: {
     if (var0 == var3) {
      phi13 = this;
      phi14 = (var0) | 0;
      phi15 = (arg1) | 0;
      break If_14_0;
     } else {
      var4 = (var0) | 0;
      var5 = bytecoder.newarray((var4),0);
      var6 = this;
      var7 = (var6.bytes);
      var8 = ((this.offset)) | 0;
      var9 = (arg1) | 0;
      var10 = ((this.length)) | 0;
      java$lang$System.V$arraycopy$$B$I$$B$I$I(var7,var8,var5,var9,var10);
      var11 = this;
      var11.bytes = var5;
      var12 = this;
      var12.offset = arg1;
      phi13 = this;
      phi14 = (var0) | 0;
      phi15 = (arg1) | 0;
      break If_14_0;
     }
    }
    return;
  }

  Ljava$lang$String$$tojstring$$() {
    var var0 = null;
    var var1 = null;
    var0 = (org$luaj$vm2$Buffer.prototype.Lorg$luaj$vm2$LuaValue$$value$$.call(this));
    var1 = (var0.Ljava$lang$String$$tojstring$$());
    return var1;
  }

  Lorg$luaj$vm2$LuaValue$$value$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var phi3 = null;
    var phi4 = null;
    var var5 = null;
    var0 = (this.value);
    If_5_0: {
     if (var0 == null) {
      var5 = (org$luaj$vm2$Buffer.prototype.Lorg$luaj$vm2$LuaString$$tostring$$.call(this));
      phi3 = this;
      phi4 = var5;
      break If_5_0;
     } else {
      var1 = this;
      var2 = (var1.value);
      // Here was a goto statement
      phi3 = this;
      phi4 = var2;
      break If_5_0;
     }
    }
    return phi4;
  }

  Lorg$luaj$vm2$LuaString$$tostring$$() {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var var5 = null;
    var0 = this;
    var1 = ((var0.length)) | 0;
    org$luaj$vm2$Buffer.prototype.V$realloc$I$I.call(this,var1,0);
    var2 = (this.bytes);
    var3 = ((this.offset)) | 0;
    var4 = ((this.length)) | 0;
    org$luaj$vm2$LuaString.$i;
    var5 = (org$luaj$vm2$LuaString.Lorg$luaj$vm2$LuaString$$valueOf$$B$I$I(var2,var3,var4));
    return var5;
  }

  V$$init$$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var0 = arg0;
    java$lang$Object.prototype.V$$init$$$.call(this);
    var1 = this;
    org$luaj$vm2$Buffer.$i;
    var2 = (org$luaj$vm2$Buffer.NOBYTES);
    var1.bytes = var2;
    var3 = this;
    var4 = this;
    var4.offset = 0;
    var3.length = 0;
    var5 = this;
    var5.value = var0;
    return;
  }

  Lorg$luaj$vm2$Buffer$$concatTo$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var0 = arg0;
    var1 = var0;
    var2 = (org$luaj$vm2$Buffer.prototype.Lorg$luaj$vm2$LuaValue$$value$$.call(this));
    var3 = (var1.Lorg$luaj$vm2$LuaValue$$concat$Lorg$luaj$vm2$LuaValue$(var2));
    var4 = (org$luaj$vm2$Buffer.prototype.Lorg$luaj$vm2$Buffer$$setvalue$Lorg$luaj$vm2$LuaValue$.call(this,var3));
    return var4;
  }

  Lorg$luaj$vm2$Buffer$$setvalue$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var0 = this;
    org$luaj$vm2$Buffer.$i;
    var1 = (org$luaj$vm2$Buffer.NOBYTES);
    var0.bytes = var1;
    var2 = var0;
    var3 = (0) | 0;
    var2.length = var3;
    var0.offset = 0;
    var4 = arg0;
    var0.value = var4;
    return var0;
  }

  Ljava$lang$String$$toString$$() {
    var var0 = null;
    var0 = (org$luaj$vm2$Buffer.prototype.Ljava$lang$String$$tojstring$$.call(this));
    return var0;
  }

  Lorg$luaj$vm2$Buffer$$concatTo$Lorg$luaj$vm2$LuaNumber$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var phi10 = null;
    var phi11 = null;
    var phi12 = null;
    var phi13 = null;
    var phi14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var0 = arg0;
    var1 = (this.value);
    If_8_0: {
     If_8_1: {
      if (var1 == null) {
       phi13 = this;
       phi14 = var0;
       break If_8_1;
      } else {
       var2 = this;
       var3 = (var2.value);
       var4 = (var3.Z$isstring$$());
       if (var4 != 0) {
        phi13 = this;
        phi14 = var0;
        break If_8_1;
       } else {
        var5 = this;
        var6 = this;
        var7 = (var6.value);
        var8 = (org$luaj$vm2$LuaNumber.prototype.Lorg$luaj$vm2$LuaValue$$concat$Lorg$luaj$vm2$LuaValue$.call(var0,var7));
        var9 = (org$luaj$vm2$Buffer.prototype.Lorg$luaj$vm2$Buffer$$setvalue$Lorg$luaj$vm2$LuaValue$.call(var5,var8));
        // Here was a goto statement
        phi10 = this;
        phi11 = var0;
        phi12 = var9;
        break If_8_0;
       }
      }
     }
     var15 = phi13;
     var16 = phi14;
     var17 = (var16.Lorg$luaj$vm2$LuaString$$strvalue$$());
     var18 = (org$luaj$vm2$Buffer.prototype.Lorg$luaj$vm2$Buffer$$prepend$Lorg$luaj$vm2$LuaString$.call(var15,var17));
     phi10 = phi13;
     phi11 = phi14;
     phi12 = var18;
     break If_8_0;
    }
    return phi12;
  }

  Lorg$luaj$vm2$Buffer$$prepend$Lorg$luaj$vm2$LuaString$(arg0) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var var8 = null;
    var var9 = 0;
    var var10 = 0;
    var var11 = null;
    var var12 = 0;
    var var13 = 0;
    var var14 = null;
    var0 = arg0;
    var1 = ((var0.m_length)) | 0;
    var2 = this;
    org$luaj$vm2$Buffer.prototype.V$makeroom$I$I.call(var2,var1,0);
    var3 = (var0.m_bytes);
    var4 = ((var0.m_offset)) | 0;
    var5 = (this.bytes);
    var6 = ((this.offset)) | 0;
    var7 = ((var6 - var1)) | 0;
    java$lang$System.V$arraycopy$$B$I$$B$I$I(var3,var4,var5,var7,var1);
    var8 = this;
    var9 = ((var8.offset)) | 0;
    var10 = ((var9 - var1)) | 0;
    var8.offset = var10;
    var11 = this;
    var12 = ((var11.length)) | 0;
    var13 = ((var12 + var1)) | 0;
    var11.length = var13;
    var14 = this;
    var14.value = null;
    return this;
  }

  Lorg$luaj$vm2$Buffer$$concatTo$Lorg$luaj$vm2$LuaString$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var phi10 = null;
    var phi11 = null;
    var phi12 = null;
    var phi13 = null;
    var phi14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var0 = arg0;
    var1 = (this.value);
    If_8_0: {
     If_8_1: {
      if (var1 == null) {
       phi13 = this;
       phi14 = var0;
       break If_8_1;
      } else {
       var2 = this;
       var3 = (var2.value);
       var4 = (var3.Z$isstring$$());
       if (var4 != 0) {
        phi13 = this;
        phi14 = var0;
        break If_8_1;
       } else {
        var5 = this;
        var6 = this;
        var7 = (var6.value);
        var8 = (org$luaj$vm2$LuaString.prototype.Lorg$luaj$vm2$LuaValue$$concat$Lorg$luaj$vm2$LuaValue$.call(var0,var7));
        var9 = (org$luaj$vm2$Buffer.prototype.Lorg$luaj$vm2$Buffer$$setvalue$Lorg$luaj$vm2$LuaValue$.call(var5,var8));
        // Here was a goto statement
        phi10 = this;
        phi11 = var0;
        phi12 = var9;
        break If_8_0;
       }
      }
     }
     var15 = phi13;
     var16 = phi14;
     var17 = (org$luaj$vm2$Buffer.prototype.Lorg$luaj$vm2$Buffer$$prepend$Lorg$luaj$vm2$LuaString$.call(var15,var16));
     phi10 = phi13;
     phi11 = phi14;
     phi12 = var17;
     break If_8_0;
    }
    return phi12;
  }
}


class java$lang$Appendable extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Appendable,[java$lang$Object,java$lang$Appendable]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class org$luaj$vm2$Globals$Compiler extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$Globals$Compiler,[java$lang$Object,org$luaj$vm2$Globals$Compiler]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.Lorg$luaj$vm2$Prototype$$compile$Ljava$io$InputStream$$Ljava$lang$String$ = impl;
  }
}


class org$luaj$vm2$compiler$IntPtr extends java$lang$Object {
  nativeObject = null;

  i = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$compiler$IntPtr,[java$lang$Object,org$luaj$vm2$compiler$IntPtr]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$I(arg0) {
    var var0 = 0;
    var var1 = null;
    var0 = (arg0) | 0;
    java$lang$Object.prototype.V$$init$$$.call(this);
    var1 = this;
    var1.i = var0;
    return;
  }

  V$$init$$$() {
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class java$util$Random extends java$lang$Object {
  nativeObject = null;

  seed = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$Random,[java$lang$Object,java$util$Random]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is Random.java
    // line number 25
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 26
    return;
  }

  D$nextDouble$$() {
    // source file is Random.java
    var var0 = .0;
    // line number 37
    java$lang$Math.$i;
    var0 = (java$lang$Math.D$random$$());
    return var0;
  }

  I$nextInt$I(arg0) {
    // source file is Random.java
    var var0 = 0;
    var var1 = .0;
    var var2 = 0;
    var0 = (arg0) | 0;
    // line number 45
    java$lang$Math.$i;
    var1 = (java$lang$Math.D$random$$());
    var2 = ((var1 | 0)) | 0;
    return var2;
  }

  V$$init$$J(arg0) {
    // source file is Random.java
    var var0 = 0;
    var var1 = null;
    var0 = arg0;
    // line number 28
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 29
    var1 = this;
    var1.seed = var0;
    // line number 30
    return;
  }
}


class de$mirkosertic$bytecoder$classlib$java$lang$TThreadGroup extends java$lang$Object {
  nativeObject = null;

  name = null;
  parent = null;
  static SYSTEM = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(de$mirkosertic$bytecoder$classlib$java$lang$TThreadGroup,[java$lang$Object,de$mirkosertic$bytecoder$classlib$java$lang$TThreadGroup]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is TThreadGroup.java
    var var0 = null;
    // line number 23
    de$mirkosertic$bytecoder$classlib$java$lang$TThreadGroup.$i;
    var0 = new de$mirkosertic$bytecoder$classlib$java$lang$TThreadGroup();
    de$mirkosertic$bytecoder$classlib$java$lang$TThreadGroup.prototype.V$$init$$$.call(var0);
    de$mirkosertic$bytecoder$classlib$java$lang$TThreadGroup.SYSTEM = var0;
    return;
  }

  V$$init$$$() {
    // source file is TThreadGroup.java
    var var0 = null;
    var var1 = null;
    // line number 28
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 29
    var0 = this;
    var0.name = bytecoder.stringconstants[71];
    // line number 30
    var1 = this;
    var1.parent = null;
    // line number 31
    return;
  }
}


class de$mirkosertic$bytecoder$classlib$java$lang$TMath extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(de$mirkosertic$bytecoder$classlib$java$lang$TMath,[java$lang$Object,de$mirkosertic$bytecoder$classlib$java$lang$TMath]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is TMath.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    // line number 21
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(de$mirkosertic$bytecoder$classlib$java$lang$TMath.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    de$mirkosertic$bytecoder$classlib$java$lang$TMath.$i;
    de$mirkosertic$bytecoder$classlib$java$lang$TMath.$assertionsDisabled = phi2;
    return;
  }

  V$$init$$$() {
    // source file is TMath.java
    // line number 22
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class jdk$internal$foreign$MemorySessionImpl extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(jdk$internal$foreign$MemorySessionImpl,[java$lang$Object,jdk$internal$foreign$MemorySessionImpl]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$checkValidStateRaw$$() {
    // source file is MemorySessionImpl.java
    // line number 29
    return;
  }

  V$$init$$$() {
    // source file is MemorySessionImpl.java
    // line number 23
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class org$luaj$vm2$Globals$Loader extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$Globals$Loader,[java$lang$Object,org$luaj$vm2$Globals$Loader]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.Lorg$luaj$vm2$LuaFunction$$load$Lorg$luaj$vm2$Prototype$$Ljava$lang$String$$Lorg$luaj$vm2$LuaValue$ = impl;
  }
}


class java$util$Map extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$Map,[java$lang$Object,java$util$Map]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  Ljava$lang$Object$$computeIfAbsent$Ljava$lang$Object$$Ljava$util$function$Function$(arg0,arg1) {
    // source file is Map.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var phi9 = null;
    var phi10 = null;
    var phi11 = null;
    var phi12 = null;
    var var13 = null;
    var0 = arg0;
    // line number 1048
    var1 = (java$util$Objects.Ljava$lang$Object$$requireNonNull$Ljava$lang$Object$(arg1));
    // line number 1050
    var2 = (this.Ljava$lang$Object$$get$Ljava$lang$Object$(var0));
    var3 = var2;
    If_21_0: {
     if (var2 != null) {
      phi9 = this;
      phi10 = var0;
      phi11 = arg1;
      phi12 = var3;
      break If_21_0;
     } else {
      // line number 1052
      var4 = var0;
      var5 = (arg1.Ljava$lang$Object$$apply$Ljava$lang$Object$(var4));
      var6 = var5;
      if (var5 == null) {
       phi9 = this;
       phi10 = var0;
       phi11 = arg1;
       phi12 = var3;
       break If_21_0;
      } else {
       // line number 1053
       var7 = var0;
       var8 = (this.Ljava$lang$Object$$put$Ljava$lang$Object$$Ljava$lang$Object$(var7,var6));
       // line number 1054
       return var6;
      }
     }
    }
    // line number 1058
    var13 = phi12;
    return var13;
  }
}


class de$mirkosertic$bytecoder$integrationtest$LuaDemo extends java$lang$Object {
  nativeObject = null;

  static globals = null;
  static inputCode = null;
  static output = null;
  static button = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(de$mirkosertic$bytecoder$integrationtest$LuaDemo,[java$lang$Object,de$mirkosertic$bytecoder$integrationtest$LuaDemo]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  static V$main$$Ljava$lang$String$(arg0) {
    // source file is LuaDemo.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    // line number 39
    org$luaj$vm2$Globals.$i;
    var0 = new org$luaj$vm2$Globals();
    org$luaj$vm2$Globals.prototype.V$$init$$$.call(var0);
    de$mirkosertic$bytecoder$integrationtest$LuaDemo.globals = var0;
    // line number 40
    var1 = (de$mirkosertic$bytecoder$integrationtest$LuaDemo.globals);
    org$luaj$vm2$compiler$LuaC.$i;
    org$luaj$vm2$compiler$LuaC.V$install$Lorg$luaj$vm2$Globals$(var1);
    // line number 41
    var2 = (de$mirkosertic$bytecoder$api$web$Window.Lde$mirkosertic$bytecoder$api$web$Window$$window$$());
    // line number 42
    var3 = (var2.Lde$mirkosertic$bytecoder$api$web$HTMLDocument$$document$$());
    // line number 43
    var4 = bytecoder.wrapNativeIntoTypeInstance(de$mirkosertic$bytecoder$api$web$Element,var3.nativeObject.getElementById(bytecoder.stringconstants[79].nativeObject));
    var5 = var4;
    de$mirkosertic$bytecoder$integrationtest$LuaDemo.inputCode = var5;
    // line number 44
    var6 = bytecoder.wrapNativeIntoTypeInstance(de$mirkosertic$bytecoder$api$web$Element,var3.nativeObject.getElementById(bytecoder.stringconstants[80].nativeObject));
    var7 = var6;
    de$mirkosertic$bytecoder$integrationtest$LuaDemo.output = var7;
    // line number 45
    var8 = bytecoder.wrapNativeIntoTypeInstance(de$mirkosertic$bytecoder$api$web$Element,var3.nativeObject.getElementById(bytecoder.stringconstants[81].nativeObject));
    var9 = var8;
    de$mirkosertic$bytecoder$integrationtest$LuaDemo.button = var9;
    // line number 46
    var10 = (de$mirkosertic$bytecoder$integrationtest$LuaDemo.button);
    var11 = new de$mirkosertic$bytecoder$integrationtest$LuaDemo$1();
    de$mirkosertic$bytecoder$integrationtest$LuaDemo$1.prototype.V$$init$$$.call(var11);
    var10.nativeObject.addEventListener(bytecoder.stringconstants[82].nativeObject, function(arg0) {this.V$run$Lde$mirkosertic$bytecoder$api$web$Event$(bytecoder.wrapNativeIntoTypeInstance(de$mirkosertic$bytecoder$api$web$Event, arg0))}.bind(var11));
    // line number 52
    return;
  }

  static V$access$000$$() {
    // source file is LuaDemo.java
    // line number 31
    de$mirkosertic$bytecoder$integrationtest$LuaDemo.V$runLua$$();
    return;
  }

  static V$runLua$$() {
    // source file is LuaDemo.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    // line number 55
    var0 = (de$mirkosertic$bytecoder$integrationtest$LuaDemo.inputCode);
    var1 = bytecoder.toBytecoderString(var0.nativeObject.value);
    // line number 56
    var2 = (de$mirkosertic$bytecoder$integrationtest$LuaDemo.globals);
    var3 = (org$luaj$vm2$Globals.prototype.Lorg$luaj$vm2$LuaValue$$load$Ljava$lang$String$.call(var2,var1));
    // line number 57
    var4 = (var3.Lorg$luaj$vm2$LuaValue$$call$$());
    var5 = (var4.Lorg$luaj$vm2$LuaString$$strvalue$$());
    // line number 58
    var6 = (de$mirkosertic$bytecoder$integrationtest$LuaDemo.output);
    var7 = (org$luaj$vm2$LuaString.prototype.Ljava$lang$String$$tojstring$$.call(var5));
    var6.nativeObject.innerHTML = var7.nativeObject;
    // line number 59
    return;
  }

  V$$init$$$() {
    // source file is LuaDemo.java
    // line number 31
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class jdk$internal$misc$ScopedMemoryAccess extends java$lang$Object {
  nativeObject = null;

  static UNSAFE = null;
  static theScopedMemoryAccess = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(jdk$internal$misc$ScopedMemoryAccess,[java$lang$Object,jdk$internal$misc$ScopedMemoryAccess]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is ScopedMemoryAccess.java
    var var0 = null;
    var var1 = null;
    // line number 79
    jdk$internal$misc$Unsafe.$i;
    var0 = (jdk$internal$misc$Unsafe.Ljdk$internal$misc$Unsafe$$getUnsafe$$());
    jdk$internal$misc$ScopedMemoryAccess.$i;
    jdk$internal$misc$ScopedMemoryAccess.UNSAFE = var0;
    // line number 83
    jdk$internal$misc$ScopedMemoryAccess.V$registerNatives$$();
    // line number 94
    var1 = new jdk$internal$misc$ScopedMemoryAccess();
    jdk$internal$misc$ScopedMemoryAccess.prototype.V$$init$$$.call(var1);
    jdk$internal$misc$ScopedMemoryAccess.theScopedMemoryAccess = var1;
    return;
  }

  static V$registerNatives$$() {
    bytecoder.imports['jdk.internal.misc.ScopedMemoryAccess'].V$registerNatives$$();
  }

  V$$init$$$() {
    // source file is ScopedMemoryAccess.java
    // line number 92
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }

  static Ljdk$internal$misc$ScopedMemoryAccess$$getScopedMemoryAccess$$() {
    // source file is ScopedMemoryAccess.java
    var var0 = null;
    // line number 97
    jdk$internal$misc$ScopedMemoryAccess.$i;
    var0 = (jdk$internal$misc$ScopedMemoryAccess.theScopedMemoryAccess);
    return var0;
  }

  I$vectorizedMismatch$Ljdk$internal$foreign$MemorySessionImpl$$Ljdk$internal$foreign$MemorySessionImpl$$Ljava$lang$Object$$J$Ljava$lang$Object$$J$I$I(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7) {
    // source file is ScopedMemoryAccess.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var0 = arg0;
    var1 = arg2;
    var2 = arg4;
    var3 = (arg6) | 0;
    TryCatch_18_0: {
     try {
      // line number 213
      var5 = arg1;
      var6 = arg3;
      var7 = arg5;
      var8 = (arg7) | 0;
      var9 = ((jdk$internal$misc$ScopedMemoryAccess.prototype.I$vectorizedMismatchInternal$Ljdk$internal$foreign$MemorySessionImpl$$Ljdk$internal$foreign$MemorySessionImpl$$Ljava$lang$Object$$J$Ljava$lang$Object$$J$I$I.call(this,var0,var5,var1,var6,var2,var7,var3,var8))) | 0;
      break TryCatch_18_0;
     } catch (__ex) {
      if (__ex instanceof jdk$internal$misc$ScopedMemoryAccess$ScopedAccessError) {
       // line number 214
       // line number 215
       var4 = (jdk$internal$misc$ScopedMemoryAccess$ScopedAccessError.prototype.Ljava$lang$RuntimeException$$newRuntimeException$$.call(__ex));
       throw bytecoder.registerStack(var4, new Error().stack);
      }
      throw __ex;
     }
    }
    return var9;
  }

  I$vectorizedMismatchInternal$Ljdk$internal$foreign$MemorySessionImpl$$Ljdk$internal$foreign$MemorySessionImpl$$Ljava$lang$Object$$J$Ljava$lang$Object$$J$I$I(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7) {
    // source file is ScopedMemoryAccess.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var phi4 = null;
    var phi5 = null;
    var phi6 = null;
    var phi7 = null;
    var phi8 = 0;
    var phi9 = null;
    var phi10 = 0;
    var phi11 = 0;
    var phi12 = 0;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = 0;
    var var17 = null;
    var var18 = 0;
    var var19 = 0;
    var var20 = 0;
    var var21 = 0;
    var var22 = null;
    var var23 = null;
    var0 = arg0;
    var1 = arg2;
    var2 = arg4;
    var3 = (arg6) | 0;
    TryCatch_18_0: {
     try {
      // line number 226
      If_35_0: {
       if (var0 == null) {
        phi4 = this;
        phi5 = var0;
        phi6 = arg1;
        phi7 = var1;
        phi8 = arg3;
        phi9 = var2;
        phi10 = arg5;
        phi11 = (var3) | 0;
        phi12 = (arg7) | 0;
        break If_35_0;
       } else {
        // line number 227
        jdk$internal$foreign$MemorySessionImpl.prototype.V$checkValidStateRaw$$.call(var0);
        phi4 = this;
        phi5 = var0;
        phi6 = arg1;
        phi7 = var1;
        phi8 = arg3;
        phi9 = var2;
        phi10 = arg5;
        phi11 = (var3) | 0;
        phi12 = (arg7) | 0;
        break If_35_0;
       }
      }
      // line number 229
      var13 = phi6;
      If_54_0: {
       if (var13 == null) {
        break If_54_0;
       } else {
        // line number 230
        var14 = phi6;
        jdk$internal$foreign$MemorySessionImpl.prototype.V$checkValidStateRaw$$.call(var14);
        break If_54_0;
       }
      }
      // line number 232
      var15 = phi7;
      var16 = phi8;
      var17 = phi9;
      var18 = phi10;
      var19 = (phi11) | 0;
      var20 = (phi12) | 0;
      jdk$internal$util$ArraysSupport.$i;
      var21 = ((jdk$internal$util$ArraysSupport.I$vectorizedMismatch$Ljava$lang$Object$$J$Ljava$lang$Object$$J$I$I(var15,var16,var17,var18,var19,var20))) | 0;
      break TryCatch_18_0;
     } catch (__ex) {
      if (__ex instanceof java$lang$Throwable) {
       TryCatch_19_0: {
        // line number 234
        break TryCatch_19_0;
       }
       java$lang$ref$Reference.V$reachabilityFence$Ljava$lang$Object$(var0);
       // line number 235
       java$lang$ref$Reference.V$reachabilityFence$Ljava$lang$Object$(arg1);
       // line number 236
       throw bytecoder.registerStack(__ex, new Error().stack);
      }
      throw __ex;
     }
    }
    // line number 234
    var22 = phi5;
    java$lang$ref$Reference.V$reachabilityFence$Ljava$lang$Object$(var22);
    // line number 235
    var23 = phi6;
    java$lang$ref$Reference.V$reachabilityFence$Ljava$lang$Object$(var23);
    // line number 232
    return var21;
  }

  V$copyMemory$Ljdk$internal$foreign$MemorySessionImpl$$Ljdk$internal$foreign$MemorySessionImpl$$Ljava$lang$Object$$J$Ljava$lang$Object$$J$J(arg0,arg1,arg2,arg3,arg4,arg5,arg6) {
    // source file is ScopedMemoryAccess.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var0 = arg0;
    var1 = arg2;
    var2 = arg4;
    var3 = arg6;
    TryCatch_17_0: {
     try {
      // line number 129
      var5 = arg1;
      var6 = arg3;
      var7 = arg5;
      jdk$internal$misc$ScopedMemoryAccess.prototype.V$copyMemoryInternal$Ljdk$internal$foreign$MemorySessionImpl$$Ljdk$internal$foreign$MemorySessionImpl$$Ljava$lang$Object$$J$Ljava$lang$Object$$J$J.call(this,var0,var5,var1,var6,var2,var7,var3);
      break TryCatch_17_0;
     } catch (__ex) {
      if (__ex instanceof jdk$internal$misc$ScopedMemoryAccess$ScopedAccessError) {
       // line number 130
       // line number 131
       var4 = (jdk$internal$misc$ScopedMemoryAccess$ScopedAccessError.prototype.Ljava$lang$RuntimeException$$newRuntimeException$$.call(__ex));
       throw bytecoder.registerStack(var4, new Error().stack);
      }
      throw __ex;
     }
    }
    // line number 132
    // Here was a goto statement
    // line number 133
    return;
  }

  V$copyMemoryInternal$Ljdk$internal$foreign$MemorySessionImpl$$Ljdk$internal$foreign$MemorySessionImpl$$Ljava$lang$Object$$J$Ljava$lang$Object$$J$J(arg0,arg1,arg2,arg3,arg4,arg5,arg6) {
    // source file is ScopedMemoryAccess.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var phi4 = null;
    var phi5 = null;
    var phi6 = null;
    var phi7 = null;
    var phi8 = 0;
    var phi9 = null;
    var phi10 = 0;
    var phi11 = 0;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = 0;
    var var17 = null;
    var var18 = 0;
    var var19 = 0;
    var var20 = null;
    var var21 = null;
    var0 = arg0;
    var1 = arg2;
    var2 = arg4;
    var3 = arg6;
    TryCatch_17_0: {
     try {
      // line number 141
      If_34_0: {
       if (var0 == null) {
        phi4 = this;
        phi5 = var0;
        phi6 = arg1;
        phi7 = var1;
        phi8 = arg3;
        phi9 = var2;
        phi10 = arg5;
        phi11 = var3;
        break If_34_0;
       } else {
        // line number 142
        jdk$internal$foreign$MemorySessionImpl.prototype.V$checkValidStateRaw$$.call(var0);
        phi4 = this;
        phi5 = var0;
        phi6 = arg1;
        phi7 = var1;
        phi8 = arg3;
        phi9 = var2;
        phi10 = arg5;
        phi11 = var3;
        break If_34_0;
       }
      }
      // line number 144
      var12 = phi6;
      If_52_0: {
       if (var12 == null) {
        break If_52_0;
       } else {
        // line number 145
        var13 = phi6;
        jdk$internal$foreign$MemorySessionImpl.prototype.V$checkValidStateRaw$$.call(var13);
        break If_52_0;
       }
      }
      // line number 147
      jdk$internal$misc$ScopedMemoryAccess.$i;
      var14 = (jdk$internal$misc$ScopedMemoryAccess.UNSAFE);
      var15 = phi7;
      var16 = phi8;
      var17 = phi9;
      var18 = phi10;
      var19 = phi11;
      jdk$internal$misc$Unsafe.prototype.V$copyMemory$Ljava$lang$Object$$J$Ljava$lang$Object$$J$J.call(var14,var15,var16,var17,var18,var19);
      break TryCatch_17_0;
     } catch (__ex) {
      if (__ex instanceof java$lang$Throwable) {
       TryCatch_18_0: {
        // line number 149
        break TryCatch_18_0;
       }
       java$lang$ref$Reference.V$reachabilityFence$Ljava$lang$Object$(var0);
       // line number 150
       java$lang$ref$Reference.V$reachabilityFence$Ljava$lang$Object$(arg1);
       // line number 151
       throw bytecoder.registerStack(__ex, new Error().stack);
      }
      throw __ex;
     }
    }
    // line number 149
    var20 = phi5;
    java$lang$ref$Reference.V$reachabilityFence$Ljava$lang$Object$(var20);
    // line number 150
    var21 = phi6;
    java$lang$ref$Reference.V$reachabilityFence$Ljava$lang$Object$(var21);
    // line number 151
    // Here was a goto statement
    // line number 152
    return;
  }

  V$copySwapMemory$Ljdk$internal$foreign$MemorySessionImpl$$Ljdk$internal$foreign$MemorySessionImpl$$Ljava$lang$Object$$J$Ljava$lang$Object$$J$J$J(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7) {
    // source file is ScopedMemoryAccess.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var0 = arg0;
    var1 = arg2;
    var2 = arg4;
    var3 = arg6;
    TryCatch_18_0: {
     try {
      // line number 160
      var5 = arg1;
      var6 = arg3;
      var7 = arg5;
      var8 = arg7;
      jdk$internal$misc$ScopedMemoryAccess.prototype.V$copySwapMemoryInternal$Ljdk$internal$foreign$MemorySessionImpl$$Ljdk$internal$foreign$MemorySessionImpl$$Ljava$lang$Object$$J$Ljava$lang$Object$$J$J$J.call(this,var0,var5,var1,var6,var2,var7,var3,var8);
      break TryCatch_18_0;
     } catch (__ex) {
      if (__ex instanceof jdk$internal$misc$ScopedMemoryAccess$ScopedAccessError) {
       // line number 161
       // line number 162
       var4 = (jdk$internal$misc$ScopedMemoryAccess$ScopedAccessError.prototype.Ljava$lang$RuntimeException$$newRuntimeException$$.call(__ex));
       throw bytecoder.registerStack(var4, new Error().stack);
      }
      throw __ex;
     }
    }
    // line number 163
    // Here was a goto statement
    // line number 164
    return;
  }

  V$copySwapMemoryInternal$Ljdk$internal$foreign$MemorySessionImpl$$Ljdk$internal$foreign$MemorySessionImpl$$Ljava$lang$Object$$J$Ljava$lang$Object$$J$J$J(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7) {
    // source file is ScopedMemoryAccess.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var phi4 = null;
    var phi5 = null;
    var phi6 = null;
    var phi7 = null;
    var phi8 = 0;
    var phi9 = null;
    var phi10 = 0;
    var phi11 = 0;
    var phi12 = 0;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = 0;
    var var18 = null;
    var var19 = 0;
    var var20 = 0;
    var var21 = 0;
    var var22 = null;
    var var23 = null;
    var0 = arg0;
    var1 = arg2;
    var2 = arg4;
    var3 = arg6;
    TryCatch_18_0: {
     try {
      // line number 172
      If_35_0: {
       if (var0 == null) {
        phi4 = this;
        phi5 = var0;
        phi6 = arg1;
        phi7 = var1;
        phi8 = arg3;
        phi9 = var2;
        phi10 = arg5;
        phi11 = var3;
        phi12 = arg7;
        break If_35_0;
       } else {
        // line number 173
        jdk$internal$foreign$MemorySessionImpl.prototype.V$checkValidStateRaw$$.call(var0);
        phi4 = this;
        phi5 = var0;
        phi6 = arg1;
        phi7 = var1;
        phi8 = arg3;
        phi9 = var2;
        phi10 = arg5;
        phi11 = var3;
        phi12 = arg7;
        break If_35_0;
       }
      }
      // line number 175
      var13 = phi6;
      If_54_0: {
       if (var13 == null) {
        break If_54_0;
       } else {
        // line number 176
        var14 = phi6;
        jdk$internal$foreign$MemorySessionImpl.prototype.V$checkValidStateRaw$$.call(var14);
        break If_54_0;
       }
      }
      // line number 178
      jdk$internal$misc$ScopedMemoryAccess.$i;
      var15 = (jdk$internal$misc$ScopedMemoryAccess.UNSAFE);
      var16 = phi7;
      var17 = phi8;
      var18 = phi9;
      var19 = phi10;
      var20 = phi11;
      var21 = phi12;
      jdk$internal$misc$Unsafe.prototype.V$copySwapMemory$Ljava$lang$Object$$J$Ljava$lang$Object$$J$J$J.call(var15,var16,var17,var18,var19,var20,var21);
      break TryCatch_18_0;
     } catch (__ex) {
      if (__ex instanceof java$lang$Throwable) {
       TryCatch_19_0: {
        // line number 180
        break TryCatch_19_0;
       }
       java$lang$ref$Reference.V$reachabilityFence$Ljava$lang$Object$(var0);
       // line number 181
       java$lang$ref$Reference.V$reachabilityFence$Ljava$lang$Object$(arg1);
       // line number 182
       throw bytecoder.registerStack(__ex, new Error().stack);
      }
      throw __ex;
     }
    }
    // line number 180
    var22 = phi5;
    java$lang$ref$Reference.V$reachabilityFence$Ljava$lang$Object$(var22);
    // line number 181
    var23 = phi6;
    java$lang$ref$Reference.V$reachabilityFence$Ljava$lang$Object$(var23);
    // line number 182
    // Here was a goto statement
    // line number 183
    return;
  }
}


class org$luaj$vm2$compiler$LexState$Priority extends java$lang$Object {
  nativeObject = null;

  left = 0;
  right = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$compiler$LexState$Priority,[java$lang$Object,org$luaj$vm2$compiler$LexState$Priority]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$I$I(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = 0;
    var0 = (arg0) | 0;
    java$lang$Object.prototype.V$$init$$$.call(this);
    var1 = this;
    var2 = var0;
    var1.left = var2;
    var3 = this;
    var4 = arg1;
    var3.right = var4;
    return;
  }
}


class java$lang$Iterable extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Iterable,[java$lang$Object,java$lang$Iterable]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class org$luaj$vm2$lib$DebugLib$DebugInfo extends java$lang$Object {
  nativeObject = null;

  nups = 0;
  nparams = 0;
  isvararg = false;
  istailcall = false;
  name = null;
  namewhat = null;
  currentline = 0;
  source = null;
  linedefined = 0;
  lastlinedefined = 0;
  what = null;
  short_src = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$lib$DebugLib$DebugInfo,[java$lang$Object,org$luaj$vm2$lib$DebugLib$DebugInfo]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }

  V$funcinfo$Lorg$luaj$vm2$LuaFunction$(arg0) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var phi10 = null;
    var phi11 = null;
    var phi12 = null;
    var phi13 = null;
    var phi14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = 0;
    var var18 = null;
    var var19 = null;
    var var20 = 0;
    var var21 = null;
    var var22 = null;
    var var23 = 0;
    var var24 = null;
    var phi25 = null;
    var phi26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = null;
    var var35 = null;
    var0 = arg0;
    var1 = (var0.Z$isclosure$$());
    If_8_0: {
     if (var1 == 0) {
      var30 = this;
      var30.source = bytecoder.stringconstants[202];
      var31 = this;
      var31.linedefined = -1;
      var32 = this;
      var32.lastlinedefined = -1;
      var33 = this;
      var33.what = bytecoder.stringconstants[191];
      var34 = this;
      var35 = (var0.Ljava$lang$String$$name$$());
      var34.short_src = var35;
      phi10 = this;
      phi11 = var0;
      break If_8_0;
     } else {
      var2 = var0;
      var3 = (var2.Lorg$luaj$vm2$LuaClosure$$checkclosure$$());
      var4 = (var3.p);
      var5 = this;
      var6 = (var4.source);
      If_24_0: {
       if (var6 == null) {
        phi10 = this;
        phi11 = var0;
        phi12 = var4;
        phi13 = var5;
        phi14 = bytecoder.stringconstants[201];
        break If_24_0;
       } else {
        var7 = var4;
        var8 = (var7.source);
        var9 = (org$luaj$vm2$LuaString.prototype.Ljava$lang$String$$tojstring$$.call(var8));
        // Here was a goto statement
        phi10 = this;
        phi11 = var0;
        phi12 = var4;
        phi13 = var5;
        phi14 = var9;
        break If_24_0;
       }
      }
      phi13.source = phi14;
      var15 = phi10;
      var16 = phi12;
      var17 = ((var16.linedefined)) | 0;
      var15.linedefined = var17;
      var18 = phi10;
      var19 = phi12;
      var20 = ((var19.lastlinedefined)) | 0;
      var18.lastlinedefined = var20;
      var21 = phi10;
      var22 = phi10;
      var23 = ((var22.linedefined)) | 0;
      If_65_0: {
       if (var23 != 0) {
        phi25 = var21;
        phi26 = bytecoder.stringconstants[159];
        break If_65_0;
       } else {
        var24 = bytecoder.stringconstants[72];
        // Here was a goto statement
        phi25 = var21;
        phi26 = var24;
        break If_65_0;
       }
      }
      phi25.what = phi26;
      var27 = phi10;
      var28 = phi12;
      var29 = (org$luaj$vm2$Prototype.prototype.Ljava$lang$String$$shortsource$$.call(var28));
      var27.short_src = var29;
      // Here was a goto statement
      break If_8_0;
     }
    }
    return;
  }
}


class java$util$function$Supplier extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$function$Supplier,[java$lang$Object,java$util$function$Supplier]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.Ljava$lang$Object$$get$$ = impl;
  }
}


class java$util$function$BiFunction extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$function$BiFunction,[java$lang$Object,java$util$function$BiFunction]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.Ljava$lang$Object$$apply$Ljava$lang$Object$$Ljava$lang$Object$ = impl;
  }
}


class org$luaj$vm2$LuaString$RecentShortStrings extends java$lang$Object {
  nativeObject = null;

  static recent_short_strings = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$LuaString$RecentShortStrings,[java$lang$Object,org$luaj$vm2$LuaString$RecentShortStrings]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    var var0 = null;
    var0 = bytecoder.newarray((128),null);
    org$luaj$vm2$LuaString$RecentShortStrings.$i;
    org$luaj$vm2$LuaString$RecentShortStrings.recent_short_strings = var0;
    return;
  }

  static $Lorg$luaj$vm2$LuaString$$access$000$$() {
    var var0 = null;
    org$luaj$vm2$LuaString$RecentShortStrings.$i;
    var0 = (org$luaj$vm2$LuaString$RecentShortStrings.recent_short_strings);
    return var0;
  }

  V$$init$$$() {
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class org$luaj$vm2$Metatable extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$Metatable,[java$lang$Object,org$luaj$vm2$Metatable]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class org$luaj$vm2$lib$DebugLib$CallStack extends java$lang$Object {
  nativeObject = null;

  static EMPTY = null;
  frame = null;
  calls = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$lib$DebugLib$CallStack,[java$lang$Object,org$luaj$vm2$lib$DebugLib$CallStack]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    var var0 = null;
    var0 = bytecoder.newarray((0),null);
    org$luaj$vm2$lib$DebugLib$CallStack.$i;
    org$luaj$vm2$lib$DebugLib$CallStack.EMPTY = var0;
    return;
  }

  V$$init$$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    java$lang$Object.prototype.V$$init$$$.call(this);
    var0 = this;
    org$luaj$vm2$lib$DebugLib$CallStack.$i;
    var1 = (org$luaj$vm2$lib$DebugLib$CallStack.EMPTY);
    var0.frame = var1;
    var2 = this;
    var2.calls = 0;
    return;
  }

  V$onCall$Lorg$luaj$vm2$LuaClosure$$Lorg$luaj$vm2$Varargs$$$Lorg$luaj$vm2$LuaValue$(arg0,arg1,arg2) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var0 = arg0;
    var1 = arg2;
    var2 = (org$luaj$vm2$lib$DebugLib$CallStack.prototype.Lorg$luaj$vm2$lib$DebugLib$CallFrame$$pushcall$$.call(this));
    var3 = arg1;
    org$luaj$vm2$lib$DebugLib$CallFrame.prototype.V$set$Lorg$luaj$vm2$LuaClosure$$Lorg$luaj$vm2$Varargs$$$Lorg$luaj$vm2$LuaValue$.call(var2,var0,var3,var1);
    return;
  }

  Lorg$luaj$vm2$lib$DebugLib$CallFrame$$pushcall$$() {
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = null;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = 0;
    var var14 = null;
    var var15 = 0;
    var var16 = null;
    var var17 = 0;
    var phi18 = null;
    var phi19 = 0;
    var phi20 = null;
    var phi21 = 0;
    var var22 = 0;
    var var23 = 0;
    var var24 = null;
    var var25 = 0;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var phi29 = 0;
    var var30 = 0;
    var var31 = 0;
    var var32 = null;
    var var33 = 0;
    var var34 = null;
    var var35 = null;
    var var36 = 0;
    var var37 = 0;
    var var38 = null;
    var var39 = null;
    var var40 = null;
    var var41 = null;
    var var42 = 0;
    var var43 = 0;
    var var44 = 0;
    var var45 = null;
    var0 = ((this.calls)) | 0;
    var1 = (this.frame);
    var2 = (var1.data.length) | 0;
    If_11_0: {
     if (var0 < var2) {
      phi18 = this;
      break If_11_0;
     } else {
      var3 = (4) | 0;
      var4 = (this.frame);
      var5 = (var4.data.length) | 0;
      var6 = ((var5 * 3)) | 0;
      var7 = (Math.floor(var6 / 2)) | 0;
      java$lang$Math.$i;
      var8 = ((java$lang$Math.I$max$I$I(var3,var7))) | 0;
      var9 = (var8) | 0;
      var10 = bytecoder.newarray((var9),null);
      var11 = this;
      var12 = (var11.frame);
      var13 = (0) | 0;
      var14 = (this.frame);
      var15 = (var14.data.length) | 0;
      java$lang$System.V$arraycopy$Ljava$lang$Object$$I$Ljava$lang$Object$$I$I(var12,0,var10,var13,var15);
      var16 = (this.frame);
      var17 = (var16.data.length) | 0;
      phi18 = this;
      phi19 = (var8) | 0;
      phi20 = var10;
      phi21 = (var17) | 0;
      L825947534: while(true) {
       var22 = (phi21) | 0;
       var23 = (phi19) | 0;
       if (var22 >= var23) {
        var27 = phi18;
        var28 = phi20;
        var27.frame = var28;
        phi29 = (1) | 0;
        L4774154: while(true) {
         var30 = (phi29) | 0;
         var31 = (phi19) | 0;
         if (var30 >= var31) {
          break If_11_0;
         } else {
          var32 = phi20;
          var33 = (phi29) | 0;
          var34 = (var32.data[var33]);
          var35 = phi20;
          var36 = (phi29) | 0;
          var37 = ((var36 - 1)) | 0;
          var38 = (var35.data[var37]);
          var34.previous = var38;
          phi29 = ((phi29 + 1)) | 0;
          // Here was a goto statement
          continue L4774154;
         }
        }
       } else {
        var24 = phi20;
        var25 = (phi21) | 0;
        var26 = new org$luaj$vm2$lib$DebugLib$CallFrame();
        org$luaj$vm2$lib$DebugLib$CallFrame.prototype.V$$init$$$.call(var26);
        var24.data[var25] = var26;
        phi21 = ((phi21 + 1)) | 0;
        // Here was a goto statement
        continue L825947534;
       }
      }
     }
    }
    var39 = phi18;
    var40 = (var39.frame);
    var41 = phi18;
    var42 = ((var41.calls)) | 0;
    var43 = (1) | 0;
    var44 = ((var42 + var43)) | 0;
    var41.calls = var44;
    var45 = (var40.data[var42]);
    return var45;
  }

  V$onReturn$$() {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var var6 = null;
    var phi7 = null;
    var0 = ((this.calls)) | 0;
    If_5_0: {
     if (var0 <= 0) {
      phi7 = this;
      break If_5_0;
     } else {
      var1 = this;
      var2 = (var1.frame);
      var3 = this;
      var4 = ((var3.calls)) | 0;
      var5 = ((var4 - 1)) | 0;
      var3.calls = var5;
      var6 = (var2.data[var5]);
      org$luaj$vm2$lib$DebugLib$CallFrame.prototype.V$reset$$.call(var6);
      phi7 = this;
      break If_5_0;
     }
    }
    return;
  }

  Ljava$lang$String$$traceback$I(arg0) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var phi4 = null;
    var phi5 = 0;
    var phi6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = 0;
    var var20 = null;
    var var21 = null;
    var var22 = 0;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var phi27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = 0;
    var var37 = null;
    var var38 = null;
    var phi39 = null;
    var var40 = null;
    var var41 = null;
    var var42 = null;
    var var43 = null;
    var var44 = null;
    var var45 = null;
    var var46 = null;
    var var47 = null;
    var var48 = null;
    var var49 = null;
    var var50 = null;
    var var51 = null;
    var var52 = null;
    var var53 = null;
    var var54 = null;
    var var55 = null;
    var var56 = 0;
    var var57 = null;
    var var58 = null;
    var var59 = null;
    var var60 = null;
    var var61 = null;
    var var62 = null;
    var var63 = null;
    var var64 = null;
    var0 = (arg0) | 0;
    var1 = new java$lang$StringBuffer();
    java$lang$StringBuffer.prototype.V$$init$$$.call(var1);
    var2 = var1;
    var3 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var2,bytecoder.stringconstants[182]));
    phi4 = this;
    phi5 = (var0) | 0;
    phi6 = var1;
    L1792975865: while(true) {
     var7 = phi4;
     var8 = (phi5) | 0;
     phi5 = ((phi5 + 1)) | 0;
     var9 = (org$luaj$vm2$lib$DebugLib$CallStack.prototype.Lorg$luaj$vm2$lib$DebugLib$CallFrame$$getCallFrame$I.call(var7,var8));
     var10 = var9;
     if (var9 == null) {
      var61 = phi6;
      var62 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var61,bytecoder.stringconstants[207]));
      var63 = phi6;
      var64 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var63));
      return var64;
     } else {
      var11 = phi6;
      var12 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var11,bytecoder.stringconstants[183]));
      var13 = phi6;
      var14 = (org$luaj$vm2$lib$DebugLib$CallFrame.prototype.Ljava$lang$String$$shortsource$$.call(var10));
      var15 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var13,var14));
      var16 = phi6;
      var17 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$C.call(var16,58));
      var18 = var10;
      var19 = ((org$luaj$vm2$lib$DebugLib$CallFrame.prototype.I$currentline$$.call(var18))) | 0;
      If_60_0: {
       if (var19 <= 0) {
        phi27 = var10;
        break If_60_0;
       } else {
        var20 = phi6;
        var21 = new java$lang$StringBuffer();
        java$lang$StringBuffer.prototype.V$$init$$$.call(var21);
        var22 = ((org$luaj$vm2$lib$DebugLib$CallFrame.prototype.I$currentline$$.call(var10))) | 0;
        var23 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var21,var22));
        var24 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var23,bytecoder.stringconstants[153]));
        var25 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var24));
        var26 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var20,var25));
        phi27 = var10;
        break If_60_0;
       }
      }
      var28 = phi6;
      var29 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var28,bytecoder.stringconstants[190]));
      var30 = phi4;
      var31 = phi27;
      var32 = (var31.f);
      var33 = phi27;
      var34 = (org$luaj$vm2$lib$DebugLib$CallStack.prototype.Lorg$luaj$vm2$lib$DebugLib$DebugInfo$$auxgetinfo$Ljava$lang$String$$Lorg$luaj$vm2$LuaFunction$$Lorg$luaj$vm2$lib$DebugLib$CallFrame$.call(var30,bytecoder.stringconstants[31],var32,var33));
      var35 = phi27;
      var36 = ((org$luaj$vm2$lib$DebugLib$CallFrame.I$access$1500$Lorg$luaj$vm2$lib$DebugLib$CallFrame$(var35))) | 0;
      If_114_0: {
       if (var36 != 0) {
        var40 = (var34.name);
        if (var40 == null) {
         var48 = phi6;
         var49 = new java$lang$StringBuffer();
         java$lang$StringBuffer.prototype.V$$init$$$.call(var49);
         var50 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var49,bytecoder.stringconstants[205]));
         var51 = phi27;
         var52 = (org$luaj$vm2$lib$DebugLib$CallFrame.prototype.Ljava$lang$String$$shortsource$$.call(var51));
         var53 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var50,var52));
         var54 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var53,bytecoder.stringconstants[153]));
         var55 = phi27;
         var56 = ((org$luaj$vm2$lib$DebugLib$CallFrame.I$access$1500$Lorg$luaj$vm2$lib$DebugLib$CallFrame$(var55))) | 0;
         var57 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var54,var56));
         var58 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var57,bytecoder.stringconstants[206]));
         var59 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var58));
         var60 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var48,var59));
         phi39 = var34;
         break If_114_0;
        } else {
         var41 = phi6;
         var42 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var41,bytecoder.stringconstants[204]));
         var43 = phi6;
         var44 = (var34.name);
         var45 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var43,var44));
         var46 = phi6;
         var47 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$C.call(var46,39));
         // Here was a goto statement
         phi39 = var34;
         break If_114_0;
        }
       } else {
        var37 = phi6;
        var38 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var37,bytecoder.stringconstants[203]));
        // Here was a goto statement
        phi39 = var34;
        break If_114_0;
       }
      }
      // Here was a goto statement
      continue L1792975865;
     }
    }
  }

  Lorg$luaj$vm2$lib$DebugLib$CallFrame$$getCallFrame$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var phi4 = null;
    var phi5 = 0;
    var var6 = null;
    var var7 = 0;
    var var8 = 0;
    var var9 = null;
    var0 = (arg0) | 0;
    var1 = (1) | 0;
    If_8_0: {
     if (var0 < var1) {
      phi4 = this;
      phi5 = (var0) | 0;
      break If_8_0;
     } else {
      var2 = (var0) | 0;
      var3 = ((this.calls)) | 0;
      if (var2 <= var3) {
       var6 = (this.frame);
       var7 = ((this.calls)) | 0;
       var8 = ((var7 - var0)) | 0;
       var9 = (var6.data[var8]);
       return var9;
      } else {
       phi4 = this;
       phi5 = (var0) | 0;
       break If_8_0;
      }
     }
    }
    return null;
  }

  Lorg$luaj$vm2$lib$DebugLib$DebugInfo$$auxgetinfo$Ljava$lang$String$$Lorg$luaj$vm2$LuaFunction$$Lorg$luaj$vm2$lib$DebugLib$CallFrame$(arg0,arg1,arg2) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = 0;
    var phi6 = null;
    var phi7 = null;
    var phi8 = null;
    var phi9 = null;
    var phi10 = 0;
    var phi11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = null;
    var var15 = 0;
    var var16 = 0;
    var var17 = null;
    var var18 = null;
    var var19 = 0;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = 0;
    var var26 = 0;
    var var27 = null;
    var var28 = 0;
    var var29 = 0;
    var var30 = null;
    var var31 = 0;
    var var32 = 0;
    var phi33 = null;
    var phi34 = null;
    var phi35 = 0;
    var var36 = null;
    var var37 = null;
    var var38 = null;
    var var39 = null;
    var var40 = null;
    var var41 = null;
    var var42 = null;
    var var43 = null;
    var var44 = null;
    var var45 = null;
    var var46 = 0;
    var var47 = null;
    var var48 = null;
    var var49 = null;
    var var50 = null;
    var var51 = null;
    var var52 = null;
    var var53 = null;
    var var54 = null;
    var phi55 = null;
    var var56 = null;
    var var57 = null;
    var var58 = null;
    var var59 = null;
    var var60 = null;
    var var61 = null;
    var var62 = null;
    var var63 = null;
    var var64 = 0;
    var var65 = null;
    var var66 = 0;
    var phi67 = null;
    var phi68 = 0;
    var phi69 = null;
    var var70 = null;
    var var71 = null;
    var var72 = null;
    var0 = arg0;
    var1 = arg2;
    var2 = new org$luaj$vm2$lib$DebugLib$DebugInfo();
    org$luaj$vm2$lib$DebugLib$DebugInfo.prototype.V$$init$$$.call(var2);
    var3 = (0) | 0;
    var4 = var0;
    var5 = ((java$lang$String.prototype.I$length$$.call(var4))) | 0;
    phi6 = var0;
    phi7 = arg1;
    phi8 = var1;
    phi9 = var2;
    phi10 = (var3) | 0;
    phi11 = (var5) | 0;
    L1536325201: while(true) {
     var12 = (phi10) | 0;
     var13 = (phi11) | 0;
     if (var12 >= var13) {
      var72 = phi9;
      return var72;
     } else {
      var14 = phi6;
      var15 = (phi10) | 0;
      var16 = (java$lang$String.prototype.C$charAt$I.call(var14,var15));
      LookupSwitch_43_0: {
       switch (var16) {
        case 102: {
         // Here was a goto statement
         break LookupSwitch_43_0;
        }
        case 83: {
         var70 = phi9;
         var71 = phi7;
         org$luaj$vm2$lib$DebugLib$DebugInfo.prototype.V$funcinfo$Lorg$luaj$vm2$LuaFunction$.call(var70,var71);
         // Here was a goto statement
         break LookupSwitch_43_0;
        }
        case 117: {
         var17 = phi7;
         If_52_0: {
          if (var17 == null) {
           break If_52_0;
          } else {
           var18 = phi7;
           var19 = (var18.Z$isclosure$$());
           if (var19 == 0) {
            break If_52_0;
           } else {
            var20 = phi7;
            var21 = (var20.Lorg$luaj$vm2$LuaClosure$$checkclosure$$());
            var22 = (var21.p);
            var23 = phi9;
            var24 = (var22.upvalues);
            var25 = (var24.data.length) | 0;
            var26 = var25;
            var23.nups = var26;
            var27 = phi9;
            var28 = ((var22.numparams)) | 0;
            var29 = var28;
            var27.nparams = var29;
            var30 = phi9;
            var31 = ((var22.is_vararg)) | 0;
            If_96_0: {
             if (var31 == 0) {
              phi33 = var22;
              phi34 = var30;
              phi35 = (0) | 0;
              break If_96_0;
             } else {
              var32 = (1) | 0;
              // Here was a goto statement
              phi33 = var22;
              phi34 = var30;
              phi35 = (var32) | 0;
              break If_96_0;
             }
            }
            phi34.isvararg = phi35;
            // Here was a goto statement
            break LookupSwitch_43_0;
           }
          }
         }
         var36 = phi9;
         var36.nups = 0;
         var37 = phi9;
         var37.isvararg = 1;
         var38 = phi9;
         var38.nparams = 0;
         // Here was a goto statement
         break LookupSwitch_43_0;
        }
        case 116: {
         var39 = phi9;
         var39.istailcall = 0;
         // Here was a goto statement
         break LookupSwitch_43_0;
        }
        case 110: {
         var40 = phi8;
         If_134_0: {
          if (var40 == null) {
           break If_134_0;
          } else {
           var41 = phi8;
           var42 = (var41.previous);
           if (var42 == null) {
            break If_134_0;
           } else {
            var43 = phi8;
            var44 = (var43.previous);
            var45 = (var44.f);
            var46 = (var45.Z$isclosure$$());
            if (var46 == 0) {
             break If_134_0;
            } else {
             var47 = phi8;
             var48 = (var47.previous);
             org$luaj$vm2$lib$DebugLib.$i;
             var49 = (org$luaj$vm2$lib$DebugLib.Lorg$luaj$vm2$lib$DebugLib$NameWhat$$getfuncname$Lorg$luaj$vm2$lib$DebugLib$CallFrame$(var48));
             var50 = var49;
             if (var50 == null) {
              phi55 = var49;
              break If_134_0;
             } else {
              var51 = phi9;
              var52 = (var49.name);
              var51.name = var52;
              var53 = phi9;
              var54 = (var49.namewhat);
              var53.namewhat = var54;
              phi55 = var49;
              break If_134_0;
             }
            }
           }
          }
         }
         var56 = phi9;
         var57 = (var56.namewhat);
         if (var57 != null) {
          break LookupSwitch_43_0;
         } else {
          var58 = phi9;
          var58.namewhat = bytecoder.stringconstants[1];
          var59 = phi9;
          var59.name = null;
          // Here was a goto statement
          break LookupSwitch_43_0;
         }
        }
        case 108: {
         var60 = phi9;
         var61 = phi8;
         If_206_0: {
          If_206_1: {
           if (var61 == null) {
            phi69 = var60;
            break If_206_1;
           } else {
            var62 = phi8;
            var63 = (var62.f);
            var64 = (var63.Z$isclosure$$());
            if (var64 == 0) {
             phi69 = var60;
             break If_206_1;
            } else {
             var65 = phi8;
             var66 = ((org$luaj$vm2$lib$DebugLib$CallFrame.prototype.I$currentline$$.call(var65))) | 0;
             // Here was a goto statement
             phi67 = var60;
             phi68 = (var66) | 0;
             break If_206_0;
            }
           }
          }
          phi67 = phi69;
          phi68 = (-1) | 0;
          break If_206_0;
         }
         phi67.currentline = phi68;
         // Here was a goto statement
         break LookupSwitch_43_0;
        }
        case 76: {
         // Here was a goto statement
         break LookupSwitch_43_0;
        }
        default: {
         break LookupSwitch_43_0;
        }
       }
      }
      phi10 = ((phi10 + 1)) | 0;
      // Here was a goto statement
      continue L1536325201;
     }
    }
  }

  V$onInstruction$I$Lorg$luaj$vm2$Varargs$$I(arg0,arg1,arg2) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = 0;
    var var7 = null;
    var var8 = null;
    var phi9 = null;
    var phi10 = 0;
    var phi11 = null;
    var phi12 = 0;
    var0 = (arg0) | 0;
    var1 = (arg2) | 0;
    var2 = ((this.calls)) | 0;
    If_12_0: {
     if (var2 <= 0) {
      phi9 = this;
      phi10 = (var0) | 0;
      phi11 = arg1;
      phi12 = (var1) | 0;
      break If_12_0;
     } else {
      var3 = this;
      var4 = (var3.frame);
      var5 = ((this.calls)) | 0;
      var6 = ((var5 - 1)) | 0;
      var7 = (var4.data[var6]);
      var8 = arg1;
      org$luaj$vm2$lib$DebugLib$CallFrame.prototype.V$instr$I$Lorg$luaj$vm2$Varargs$$I.call(var7,var0,var8,var1);
      phi9 = this;
      phi10 = (var0) | 0;
      phi11 = arg1;
      phi12 = (var1) | 0;
      break If_12_0;
     }
    }
    return;
  }

  I$currentline$$() {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var var5 = null;
    var var6 = 0;
    var phi7 = null;
    var phi8 = 0;
    var0 = ((this.calls)) | 0;
    If_5_0: {
     if (var0 <= 0) {
      phi7 = this;
      phi8 = (-1) | 0;
      break If_5_0;
     } else {
      var1 = this;
      var2 = (var1.frame);
      var3 = ((this.calls)) | 0;
      var4 = ((var3 - 1)) | 0;
      var5 = (var2.data[var4]);
      var6 = ((org$luaj$vm2$lib$DebugLib$CallFrame.prototype.I$currentline$$.call(var5))) | 0;
      // Here was a goto statement
      phi7 = this;
      phi8 = (var6) | 0;
      break If_5_0;
     }
    }
    return phi8;
  }

  Lorg$luaj$vm2$lib$DebugLib$CallFrame$$findCallFrame$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var phi1 = null;
    var phi2 = null;
    var phi3 = 0;
    var var4 = 0;
    var var5 = null;
    var var6 = 0;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = 0;
    var var19 = null;
    var0 = arg0;
    phi1 = this;
    phi2 = var0;
    phi3 = (1) | 0;
    L736910244: while(true) {
     var4 = (phi3) | 0;
     var5 = phi1;
     var6 = ((var5.calls)) | 0;
     if (var4 > var6) {
      return null;
     } else {
      var7 = phi1;
      var8 = (var7.frame);
      var9 = phi1;
      var10 = ((var9.calls)) | 0;
      var11 = (phi3) | 0;
      var12 = ((var10 - var11)) | 0;
      var13 = (var8.data[var12]);
      var14 = (var13.f);
      var15 = phi2;
      if (var14 != var15) {
       phi3 = ((phi3 + 1)) | 0;
       // Here was a goto statement
       continue L736910244;
      } else {
       var16 = phi1;
       var17 = (var16.frame);
       var18 = (phi3) | 0;
       var19 = (var17.data[var18]);
       return var19;
      }
     }
    }
  }
}


class de$mirkosertic$bytecoder$classlib$java$lang$ref$TReference extends java$lang$Object {
  nativeObject = null;

  referent = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(de$mirkosertic$bytecoder$classlib$java$lang$ref$TReference,[java$lang$Object,de$mirkosertic$bytecoder$classlib$java$lang$ref$TReference]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Ljava$lang$Object$(arg0) {
    // source file is TReference.java
    var var0 = null;
    var var1 = null;
    var0 = arg0;
    // line number 30
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 31
    var1 = this;
    var1.referent = var0;
    // line number 32
    return;
  }
}


class org$luaj$vm2$Lua extends java$lang$Object {
  nativeObject = null;

  static luaP_opmodes = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$Lua,[java$lang$Object,org$luaj$vm2$Lua]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = 0;
    var var17 = 0;
    var var18 = 0;
    var var19 = 0;
    var var20 = 0;
    var var21 = 0;
    var var22 = 0;
    var var23 = 0;
    var var24 = 0;
    var var25 = 0;
    var var26 = 0;
    var var27 = 0;
    var var28 = 0;
    var var29 = 0;
    var var30 = 0;
    var var31 = 0;
    var var32 = 0;
    var var33 = 0;
    var var34 = 0;
    var var35 = 0;
    var var36 = 0;
    var var37 = 0;
    var var38 = 0;
    var var39 = 0;
    var var40 = 0;
    var0 = bytecoder.newarray((40),0);
    var1 = (0) | 0;
    var0.data[var1] = 96;
    var2 = (1) | 0;
    var0.data[var2] = 113;
    var3 = (2) | 0;
    var0.data[var3] = 65;
    var4 = (3) | 0;
    var0.data[var4] = 84;
    var5 = (4) | 0;
    var0.data[var5] = 80;
    var6 = (5) | 0;
    var0.data[var6] = 80;
    var7 = (6) | 0;
    var0.data[var7] = 92;
    var8 = (7) | 0;
    var0.data[var8] = 108;
    var9 = (8) | 0;
    var0.data[var9] = 60;
    var10 = (9) | 0;
    var0.data[var10] = 16;
    var11 = (10) | 0;
    var0.data[var11] = 60;
    var12 = (11) | 0;
    var0.data[var12] = 84;
    var13 = (12) | 0;
    var0.data[var13] = 108;
    var14 = (13) | 0;
    var0.data[var14] = 124;
    var15 = (14) | 0;
    var0.data[var15] = 124;
    var16 = (15) | 0;
    var0.data[var16] = 124;
    var17 = (16) | 0;
    var0.data[var17] = 124;
    var18 = (17) | 0;
    var0.data[var18] = 124;
    var19 = (18) | 0;
    var0.data[var19] = 124;
    var20 = (19) | 0;
    var0.data[var20] = 96;
    var21 = (20) | 0;
    var0.data[var21] = 96;
    var22 = (21) | 0;
    var0.data[var22] = 96;
    var23 = (22) | 0;
    var0.data[var23] = 104;
    var24 = (23) | 0;
    var0.data[var24] = 34;
    var25 = (24) | 0;
    var0.data[var25] = 188;
    var26 = (25) | 0;
    var0.data[var26] = 188;
    var27 = (26) | 0;
    var0.data[var27] = 188;
    var28 = (27) | 0;
    var0.data[var28] = 132;
    var29 = (28) | 0;
    var0.data[var29] = 228;
    var30 = (29) | 0;
    var0.data[var30] = 84;
    var31 = (30) | 0;
    var0.data[var31] = 84;
    var32 = (31) | 0;
    var0.data[var32] = 16;
    var33 = (32) | 0;
    var0.data[var33] = 98;
    var34 = (33) | 0;
    var0.data[var34] = 98;
    var35 = (34) | 0;
    var0.data[var35] = 4;
    var36 = (35) | 0;
    var0.data[var36] = 226;
    var37 = (36) | 0;
    var0.data[var37] = 20;
    var38 = (37) | 0;
    var0.data[var38] = 81;
    var39 = (38) | 0;
    var0.data[var39] = 80;
    var40 = (39) | 0;
    var0.data[var40] = 23;
    org$luaj$vm2$Lua.$i;
    org$luaj$vm2$Lua.luaP_opmodes = var0;
    return;
  }

  V$$init$$$() {
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }

  static I$GET_OPCODE$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var0 = (0) | 0;
    var1 = ((arg0 >> var0)) | 0;
    var2 = ((var1 & 63)) | 0;
    return var2;
  }

  static I$GETARG_A$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var0 = (6) | 0;
    var1 = ((arg0 >> var0)) | 0;
    var2 = ((var1 & 255)) | 0;
    return var2;
  }

  static Z$testAMode$I(arg0) {
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var phi5 = 0;
    var phi6 = 0;
    var0 = (0) | 0;
    org$luaj$vm2$Lua.$i;
    var1 = (org$luaj$vm2$Lua.luaP_opmodes);
    var2 = ((var1.data[arg0])) | 0;
    var3 = ((var2 & 64)) | 0;
    If_17_0: {
     if (var0 == var3) {
      phi5 = (arg0) | 0;
      phi6 = (0) | 0;
      break If_17_0;
     } else {
      var4 = (1) | 0;
      // Here was a goto statement
      phi5 = (arg0) | 0;
      phi6 = (var4) | 0;
      break If_17_0;
     }
    }
    return phi6;
  }

  static I$GETARG_sBx$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var0 = (14) | 0;
    var1 = ((arg0 >> var0)) | 0;
    var2 = ((var1 & 262143)) | 0;
    var3 = ((var2 - 131071)) | 0;
    return var3;
  }

  static I$GETARG_B$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var0 = (23) | 0;
    var1 = ((arg0 >> var0)) | 0;
    var2 = ((var1 & 511)) | 0;
    return var2;
  }

  static I$GETARG_C$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var0 = (14) | 0;
    var1 = ((arg0 >> var0)) | 0;
    var2 = ((var1 & 511)) | 0;
    return var2;
  }

  static Z$ISK$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var phi4 = 0;
    var phi5 = 0;
    var0 = (0) | 0;
    var1 = 256;
    var2 = ((arg0 & var1)) | 0;
    If_11_0: {
     if (var0 == var2) {
      phi4 = (arg0) | 0;
      phi5 = (0) | 0;
      break If_11_0;
     } else {
      var3 = (1) | 0;
      // Here was a goto statement
      phi4 = (arg0) | 0;
      phi5 = (var3) | 0;
      break If_11_0;
     }
    }
    return phi5;
  }

  static I$INDEXK$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var0 = -257;
    var1 = ((arg0 & var0)) | 0;
    return var1;
  }

  static I$GETARG_Bx$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var0 = (14) | 0;
    var1 = ((arg0 >> var0)) | 0;
    var2 = ((var1 & 262143)) | 0;
    return var2;
  }

  static I$GETARG_Ax$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var0 = (6) | 0;
    var1 = ((arg0 >> var0)) | 0;
    var2 = ((var1 & 67108863)) | 0;
    return var2;
  }

  static I$getOpMode$I(arg0) {
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    org$luaj$vm2$Lua.$i;
    var0 = (org$luaj$vm2$Lua.luaP_opmodes);
    var1 = ((var0.data[arg0])) | 0;
    var2 = ((var1 & 3)) | 0;
    return var2;
  }

  static I$getBMode$I(arg0) {
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    org$luaj$vm2$Lua.$i;
    var0 = (org$luaj$vm2$Lua.luaP_opmodes);
    var1 = ((var0.data[arg0])) | 0;
    var2 = ((var1 >> 4)) | 0;
    var3 = ((var2 & 3)) | 0;
    return var3;
  }

  static I$getCMode$I(arg0) {
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    org$luaj$vm2$Lua.$i;
    var0 = (org$luaj$vm2$Lua.luaP_opmodes);
    var1 = ((var0.data[arg0])) | 0;
    var2 = ((var1 >> 2)) | 0;
    var3 = ((var2 & 3)) | 0;
    return var3;
  }

  static Ljava$lang$String$$chunkid$Ljava$lang$String$(arg0) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var phi8 = null;
    var phi9 = null;
    var var10 = null;
    var var11 = 0;
    var var12 = null;
    var var13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = null;
    var var17 = null;
    var var18 = 0;
    var var19 = null;
    var var20 = 0;
    var var21 = 0;
    var var22 = 0;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var phi27 = null;
    var phi28 = 0;
    var var29 = null;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = null;
    var var37 = null;
    var var38 = null;
    var var39 = null;
    var0 = bytecoder.stringconstants[155];
    var1 = (java$lang$String.prototype.Z$startsWith$Ljava$lang$String$.call(arg0,var0));
    if (var1 == 0) {
     var4 = arg0;
     var5 = (java$lang$String.prototype.Z$startsWith$Ljava$lang$String$.call(var4,bytecoder.stringconstants[186]));
     If_26_0: {
      if (var5 == 0) {
       var35 = new java$lang$StringBuffer();
       java$lang$StringBuffer.prototype.V$$init$$$.call(var35);
       var36 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var35,bytecoder.stringconstants[331]));
       var37 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var36,arg0));
       var38 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var37));
       var39 = bytecoder.stringconstants[332];
       phi8 = var38;
       phi9 = var39;
       break If_26_0;
      } else {
       var6 = arg0;
       var7 = (java$lang$String.prototype.Ljava$lang$String$$substring$I.call(var6,1));
       // Here was a goto statement
       phi8 = var7;
       phi9 = bytecoder.stringconstants[1];
       break If_26_0;
      }
     }
     var10 = phi8;
     var11 = ((java$lang$String.prototype.I$length$$.call(var10))) | 0;
     var12 = phi9;
     var13 = ((java$lang$String.prototype.I$length$$.call(var12))) | 0;
     var14 = ((var11 + var13)) | 0;
     var15 = (var14) | 0;
     If_55_0: {
      if (var15 <= 80) {
       phi27 = phi8;
       phi28 = (var14) | 0;
       break If_55_0;
      } else {
       var16 = new java$lang$StringBuffer();
       java$lang$StringBuffer.prototype.V$$init$$$.call(var16);
       var17 = phi8;
       var18 = (80) | 0;
       var19 = phi9;
       var20 = ((java$lang$String.prototype.I$length$$.call(var19))) | 0;
       var21 = ((var18 - var20)) | 0;
       var22 = ((var21 - 3)) | 0;
       var23 = (java$lang$String.prototype.Ljava$lang$String$$substring$I$I.call(var17,0,var22));
       var24 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var16,var23));
       var25 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var24,bytecoder.stringconstants[317]));
       var26 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var25));
       phi27 = var26;
       phi28 = (var14) | 0;
       break If_55_0;
      }
     }
     var29 = new java$lang$StringBuffer();
     java$lang$StringBuffer.prototype.V$$init$$$.call(var29);
     var30 = phi27;
     var31 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var29,var30));
     var32 = phi9;
     var33 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var31,var32));
     var34 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var33));
     return var34;
    } else {
     var2 = arg0;
     var3 = (java$lang$String.prototype.Ljava$lang$String$$substring$I.call(var2,1));
     return var3;
    }
  }

  static Z$testTMode$I(arg0) {
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var phi5 = 0;
    var phi6 = 0;
    var0 = (0) | 0;
    org$luaj$vm2$Lua.$i;
    var1 = (org$luaj$vm2$Lua.luaP_opmodes);
    var2 = ((var1.data[arg0])) | 0;
    var3 = ((var2 & 128)) | 0;
    If_17_0: {
     if (var0 == var3) {
      phi5 = (arg0) | 0;
      phi6 = (0) | 0;
      break If_17_0;
     } else {
      var4 = (1) | 0;
      // Here was a goto statement
      phi5 = (arg0) | 0;
      phi6 = (var4) | 0;
      break If_17_0;
     }
    }
    return phi6;
  }

  static I$RKASK$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var0 = 256;
    var1 = ((arg0 | var0)) | 0;
    return var1;
  }
}


class org$luaj$vm2$compiler$InstructionPtr extends java$lang$Object {
  nativeObject = null;

  code = null;
  idx = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$compiler$InstructionPtr,[java$lang$Object,org$luaj$vm2$compiler$InstructionPtr]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$I$I(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    java$lang$Object.prototype.V$$init$$$.call(this);
    var1 = this;
    var1.code = var0;
    var2 = this;
    var2.idx = arg1;
    return;
  }

  I$get$$() {
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var0 = (this.code);
    var1 = ((this.idx)) | 0;
    var2 = ((var0.data[var1])) | 0;
    return var2;
  }

  V$set$I(arg0) {
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var0 = (arg0) | 0;
    var1 = (this.code);
    var2 = ((this.idx)) | 0;
    var1.data[var2] = var0;
    return;
  }
}


class org$luaj$vm2$compiler$FuncState$BlockCnt extends java$lang$Object {
  nativeObject = null;

  isloop = false;
  nactvar = 0;
  firstlabel = 0;
  firstgoto = 0;
  upval = false;
  previous = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$compiler$FuncState$BlockCnt,[java$lang$Object,org$luaj$vm2$compiler$FuncState$BlockCnt]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class java$lang$Math extends java$lang$Object {
  nativeObject = null;

  static $assertionsDisabled = false;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Math,[java$lang$Object,java$lang$Math]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is Math.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    // line number 21
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(de$mirkosertic$bytecoder$classlib$java$lang$TMath.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    java$lang$Math.$i;
    java$lang$Math.$assertionsDisabled = phi2;
    return;
  }

  static I$floorMod$I$I(arg0,arg1) {
    // source file is Math.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var0 = (arg1) | 0;
    // line number 140
    var1 = (arg0) | 0;
    java$lang$Math.$i;
    var2 = ((java$lang$Math.I$floorDiv$I$I(var1,var0))) | 0;
    var3 = ((var2 * var0)) | 0;
    var4 = ((arg0 - var3)) | 0;
    return var4;
  }

  static I$floorDiv$I$I(arg0,arg1) {
    // source file is Math.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var phi8 = 0;
    var phi9 = 0;
    var phi10 = 0;
    var var11 = 0;
    var0 = (arg1) | 0;
    // line number 144
    var1 = (var0) | 0;
    var2 = (Math.floor(arg0 / var1)) | 0;
    // line number 146
    java$lang$Integer.$i;
    var3 = ((java$lang$Integer.I$signum$I(arg0))) | 0;
    var4 = ((java$lang$Integer.I$signum$I(var0))) | 0;
    If_23_0: {
     if (var3 == var4) {
      phi8 = (arg0) | 0;
      phi9 = (var0) | 0;
      phi10 = (var2) | 0;
      break If_23_0;
     } else {
      var5 = (var2) | 0;
      var6 = ((var5 * var0)) | 0;
      if (var6 == arg0) {
       phi8 = (arg0) | 0;
       phi9 = (var0) | 0;
       phi10 = (var2) | 0;
       break If_23_0;
      } else {
       // line number 147
       var7 = ((var2 + -1)) | 0;
       phi8 = (arg0) | 0;
       phi9 = (var0) | 0;
       phi10 = (var7) | 0;
       break If_23_0;
      }
     }
    }
    // line number 149
    var11 = (phi10) | 0;
    return var11;
  }

  static I$min$I$I(arg0,arg1) {
    return bytecoder.imports['java.lang.Math'].I$min$I$I(arg0, arg1);
  }

  V$$init$$$() {
    // source file is Math.java
    // line number 22
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }

  static I$max$I$I(arg0,arg1) {
    return bytecoder.imports['java.lang.Math'].I$max$I$I(arg0, arg1);
  }

  static F$min$F$F(arg0,arg1) {
    return bytecoder.imports['java.lang.Math'].F$min$F$F(arg0, arg1);
  }

  static D$sqrt$D(arg0) {
    return bytecoder.imports['java.lang.Math'].D$sqrt$D(arg0);
  }

  static I$abs$I(arg0) {
    // source file is Math.java
    var var0 = 0;
    // line number 50
    if (arg0 >= 0) {
     // line number 53
     return arg0;
    } else {
     // line number 51
     var0 = ((0 - arg0)) | 0;
     return var0;
    }
  }

  static I$round$F(arg0) {
    // source file is Math.java
    var var0 = 0;
    // line number 199
    var0 = ((arg0 | 0)) | 0;
    return var0;
  }

  static D$floor$D(arg0) {
    return bytecoder.imports['java.lang.Math'].D$floor$D(arg0);
  }

  static D$ceil$D(arg0) {
    return bytecoder.imports['java.lang.Math'].D$ceil$D(arg0);
  }

  static D$min$D$D(arg0,arg1) {
    return bytecoder.imports['java.lang.Math'].D$min$D$D(arg0, arg1);
  }

  static D$max$D$D(arg0,arg1) {
    return bytecoder.imports['java.lang.Math'].D$max$D$D(arg0, arg1);
  }

  static D$random$$() {
    return bytecoder.imports['java.lang.Math'].D$random$$();
  }

  static D$cos$D(arg0) {
    return bytecoder.imports['java.lang.Math'].D$cos$D(arg0);
  }

  static D$sin$D(arg0) {
    return bytecoder.imports['java.lang.Math'].D$sin$D(arg0);
  }

  static D$tan$D(arg0) {
    return bytecoder.imports['java.lang.Math'].D$tan$D(arg0);
  }

  static D$abs$D(arg0) {
    // source file is Math.java
    var var0 = .0;
    var var1 = 0;
    var var2 = .0;
    // line number 43
    var0 = 0.0;
    var1 = (bytecoder.cmp(arg0,var0)) | 0;
    if (var1 >= 0) {
     // line number 46
     return arg0;
    } else {
     // line number 44
     var2 = (0 - arg0);
     return var2;
    }
  }

  static D$toRadians$D(arg0) {
    return bytecoder.imports['java.lang.Math'].D$toRadians$D(arg0);
  }

  static D$toDegrees$D(arg0) {
    return bytecoder.imports['java.lang.Math'].D$toDegrees$D(arg0);
  }
}


class java$util$AbstractList$Itr extends java$lang$Object {
  nativeObject = null;

  this$0 = null;
  cursor = 0;
  lastRet = 0;
  expectedModCount = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$AbstractList$Itr,[java$util$Iterator,java$lang$Object,java$util$AbstractList$Itr]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Ljava$util$AbstractList$(arg0) {
    // source file is AbstractList.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var0 = this;
    // line number 345
    var1 = arg0;
    var0.this$0 = var1;
    java$lang$Object.prototype.V$$init$$$.call(var0);
    // line number 349
    var0.cursor = 0;
    // line number 356
    var0.lastRet = -1;
    // line number 363
    var2 = var0;
    var3 = (var2.this$0);
    var4 = ((var3.modCount)) | 0;
    var0.expectedModCount = var4;
    return;
  }

  Z$hasNext$$() {
    // source file is AbstractList.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var phi4 = null;
    var phi5 = 0;
    // line number 366
    var0 = ((this.cursor)) | 0;
    var1 = (this.this$0);
    var2 = ((var1.I$size$$())) | 0;
    If_13_0: {
     if (var0 == var2) {
      phi4 = this;
      phi5 = (0) | 0;
      break If_13_0;
     } else {
      var3 = (1) | 0;
      // Here was a goto statement
      phi4 = this;
      phi5 = (var3) | 0;
      break If_13_0;
     }
    }
    return phi5;
  }

  Ljava$lang$Object$$next$$() {
    // source file is AbstractList.java
    var phi0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = 0;
    // line number 370
    java$util$AbstractList$Itr.prototype.V$checkForComodification$$.call(this);
    phi0 = this;
    TryCatch_6_0: {
     try {
      // line number 372
      var4 = phi0;
      var5 = ((var4.cursor)) | 0;
      // line number 373
      var6 = phi0;
      var7 = (var6.this$0);
      var8 = (var7.Ljava$lang$Object$$get$I(var5));
      // line number 374
      var9 = phi0;
      var9.lastRet = var5;
      // line number 375
      var10 = phi0;
      var11 = ((var5 + 1)) | 0;
      var10.cursor = var11;
      // line number 376
      break TryCatch_6_0;
     } catch (__ex) {
      if (__ex instanceof java$lang$IndexOutOfBoundsException) {
       // line number 377
       // line number 378
       var1 = phi0;
       java$util$AbstractList$Itr.prototype.V$checkForComodification$$.call(var1);
       // line number 379
       var2 = new java$util$NoSuchElementException();
       var3 = __ex;
       java$util$NoSuchElementException.prototype.V$$init$$Ljava$lang$Throwable$.call(var2,var3);
       throw bytecoder.registerStack(var2, new Error().stack);
      }
      throw __ex;
     }
    }
    return var8;
  }

  V$checkForComodification$$() {
    // source file is AbstractList.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = null;
    // line number 400
    var0 = (this.this$0);
    var1 = ((var0.modCount)) | 0;
    var2 = ((this.expectedModCount)) | 0;
    if (var1 == var2) {
     // line number 402
     return;
    } else {
     // line number 401
     var3 = new java$util$ConcurrentModificationException();
     java$util$ConcurrentModificationException.prototype.V$$init$$$.call(var3);
     throw bytecoder.registerStack(var3, new Error().stack);
    }
  }
}


class java$util$Collections$EmptyIterator extends java$lang$Object {
  nativeObject = null;

  static EMPTY_ITERATOR = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$Collections$EmptyIterator,[java$util$Iterator,java$util$Collections$EmptyIterator,java$lang$Object]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is Collections.java
    var var0 = null;
    // line number 4308
    java$util$Collections$EmptyIterator.$i;
    var0 = new java$util$Collections$EmptyIterator();
    java$util$Collections$EmptyIterator.prototype.V$$init$$$.call(var0);
    java$util$Collections$EmptyIterator.EMPTY_ITERATOR = var0;
    return;
  }

  V$$init$$$() {
    // source file is Collections.java
    // line number 4307
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }

  Z$hasNext$$() {
    // source file is Collections.java
    // line number 4311
    return 0;
  }

  Ljava$lang$Object$$next$$() {
    // source file is Collections.java
    var var0 = null;
    // line number 4312
    var0 = new java$util$NoSuchElementException();
    java$util$NoSuchElementException.prototype.V$$init$$$.call(var0);
    throw bytecoder.registerStack(var0, new Error().stack);
  }
}


class java$lang$Number extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Number,[java$lang$Object,java$io$Serializable,java$lang$Number]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.I$intValue$$ = impl;
  }

  V$$init$$$() {
    // source file is Number.java
    // line number 59
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }

  S$shortValue$$() {
    // source file is Number.java
    var var0 = 0;
    var var1 = 0;
    // line number 120
    var0 = ((this.I$intValue$$())) | 0;
    var1 = var0;
    return var1;
  }

  B$byteValue$$() {
    // source file is Number.java
    var var0 = 0;
    var var1 = 0;
    // line number 105
    var0 = ((this.I$intValue$$())) | 0;
    var1 = var0;
    return var1;
  }
}


class java$nio$charset$Charset extends java$lang$Object {
  nativeObject = null;

  static defaultCharset = null;
  canonicalName = null;
  aliases = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$nio$charset$Charset,[java$lang$Object,java$lang$Comparable,java$nio$charset$Charset]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  static Ljava$nio$charset$Charset$$defaultCharset$$() {
    // source file is Charset.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    // line number 35
    var0 = (java$nio$charset$Charset.defaultCharset);
    If_8_0: {
     if (var0 != null) {
      break If_8_0;
     } else {
      // line number 36
      var1 = new de$mirkosertic$bytecoder$classlib$BytecoderCharset();
      var2 = bytecoder.stringconstants[74];
      var3 = bytecoder.newarray((0),null);
      de$mirkosertic$bytecoder$classlib$BytecoderCharset.prototype.V$$init$$Ljava$lang$String$$$Ljava$lang$String$.call(var1,var2,var3);
      java$nio$charset$Charset.defaultCharset = var1;
      break If_8_0;
     }
    }
    // line number 38
    var4 = (java$nio$charset$Charset.defaultCharset);
    return var4;
  }

  V$$init$$Ljava$lang$String$$$Ljava$lang$String$(arg0,arg1) {
    // source file is Charset.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    // line number 45
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 46
    var1 = this;
    var1.canonicalName = var0;
    // line number 47
    var2 = this;
    var2.aliases = arg1;
    // line number 48
    return;
  }

  Ljava$lang$String$$name$$() {
    // source file is Charset.java
    var var0 = null;
    // line number 51
    var0 = (this.canonicalName);
    return var0;
  }
}


class org$luaj$vm2$WeakTable$WeakSlot extends java$lang$Object {
  nativeObject = null;

  key = null;
  value = null;
  next = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$WeakTable$WeakSlot,[java$lang$Object,org$luaj$vm2$LuaTable$Slot,org$luaj$vm2$WeakTable$WeakSlot]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Ljava$lang$Object$$Ljava$lang$Object$$Lorg$luaj$vm2$LuaTable$Slot$(arg0,arg1,arg2) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var0 = arg0;
    var1 = arg2;
    java$lang$Object.prototype.V$$init$$$.call(this);
    var2 = this;
    var2.key = var0;
    var3 = this;
    var3.value = arg1;
    var4 = this;
    var4.next = var1;
    return;
  }

  Lorg$luaj$vm2$LuaTable$StrongSlot$$find$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var phi5 = null;
    var phi6 = null;
    var phi7 = null;
    var phi8 = null;
    var0 = arg0;
    var1 = (org$luaj$vm2$WeakTable$WeakSlot.prototype.Lorg$luaj$vm2$LuaTable$StrongSlot$$first$$.call(this));
    var2 = var1;
    If_10_0: {
     if (var2 == null) {
      phi5 = this;
      phi6 = var0;
      phi7 = var1;
      phi8 = null;
      break If_10_0;
     } else {
      var3 = var1;
      var4 = (var3.Lorg$luaj$vm2$LuaTable$StrongSlot$$find$Lorg$luaj$vm2$LuaValue$(var0));
      // Here was a goto statement
      phi5 = this;
      phi6 = var0;
      phi7 = var1;
      phi8 = var4;
      break If_10_0;
     }
    }
    return phi8;
  }

  Lorg$luaj$vm2$LuaTable$StrongSlot$$first$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var phi7 = null;
    var phi8 = null;
    var phi9 = null;
    var var10 = null;
    var var11 = null;
    var0 = (this.Lorg$luaj$vm2$LuaValue$$strongkey$$());
    var1 = this;
    var2 = (var1.Lorg$luaj$vm2$LuaValue$$strongvalue$$());
    var3 = var0;
    If_12_0: {
     if (var3 == null) {
      phi7 = this;
      phi8 = var0;
      phi9 = var2;
      break If_12_0;
     } else {
      var4 = var2;
      if (var4 == null) {
       phi7 = this;
       phi8 = var0;
       phi9 = var2;
       break If_12_0;
      } else {
       var5 = new org$luaj$vm2$LuaTable$NormalEntry();
       var6 = var0;
       org$luaj$vm2$LuaTable$NormalEntry.prototype.V$$init$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$.call(var5,var6,var2);
       return var5;
      }
     }
    }
    var10 = phi7;
    var10.key = null;
    var11 = phi7;
    var11.value = null;
    return null;
  }

  Lorg$luaj$vm2$LuaValue$$strongkey$$() {
    var var0 = null;
    var var1 = null;
    var0 = (this.key);
    var1 = var0;
    return var1;
  }

  Lorg$luaj$vm2$LuaValue$$strongvalue$$() {
    var var0 = null;
    var var1 = null;
    var0 = (this.value);
    var1 = var0;
    return var1;
  }

  Lorg$luaj$vm2$LuaTable$Slot$$rest$$() {
    var var0 = null;
    var0 = (this.next);
    return var0;
  }

  Lorg$luaj$vm2$LuaTable$Slot$$remove$Lorg$luaj$vm2$LuaTable$StrongSlot$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var0 = arg0;
    var1 = (this.Lorg$luaj$vm2$LuaValue$$strongkey$$());
    var2 = var1;
    if (var2 != null) {
     var6 = var1;
     var7 = (var0.Z$keyeq$Lorg$luaj$vm2$LuaValue$(var6));
     if (var7 == 0) {
      var9 = this;
      var10 = (this.next);
      var11 = (var10.Lorg$luaj$vm2$LuaTable$Slot$$remove$Lorg$luaj$vm2$LuaTable$StrongSlot$(var0));
      var9.next = var11;
      return this;
     } else {
      var8 = this;
      var8.value = null;
      return this;
     }
    } else {
     var3 = this;
     var4 = (var3.next);
     var5 = (var4.Lorg$luaj$vm2$LuaTable$Slot$$remove$Lorg$luaj$vm2$LuaTable$StrongSlot$(var0));
     return var5;
    }
  }

  Lorg$luaj$vm2$LuaTable$Slot$$set$Lorg$luaj$vm2$LuaTable$StrongSlot$$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var phi7 = null;
    var phi8 = null;
    var phi9 = null;
    var phi10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var0 = arg0;
    var1 = (this.Lorg$luaj$vm2$LuaValue$$strongkey$$());
    var2 = var1;
    If_11_0: {
     if (var2 == null) {
      phi7 = this;
      phi8 = var0;
      phi9 = arg1;
      phi10 = var1;
      break If_11_0;
     } else {
      var3 = var0;
      var4 = (var3.Lorg$luaj$vm2$LuaTable$StrongSlot$$find$Lorg$luaj$vm2$LuaValue$(var1));
      if (var4 == null) {
       phi7 = this;
       phi8 = var0;
       phi9 = arg1;
       phi10 = var1;
       break If_11_0;
      } else {
       var5 = this;
       var6 = (var5.Lorg$luaj$vm2$LuaTable$Slot$$set$Lorg$luaj$vm2$LuaValue$(arg1));
       return var6;
      }
     }
    }
    var11 = phi10;
    if (var11 == null) {
     var19 = phi7;
     var20 = (var19.next);
     var21 = phi8;
     var22 = phi9;
     var23 = (var20.Lorg$luaj$vm2$LuaTable$Slot$$set$Lorg$luaj$vm2$LuaTable$StrongSlot$$Lorg$luaj$vm2$LuaValue$(var21,var22));
     return var23;
    } else {
     var12 = phi7;
     var13 = phi7;
     var14 = (var13.next);
     var15 = phi8;
     var16 = phi9;
     var17 = (var14.Lorg$luaj$vm2$LuaTable$Slot$$set$Lorg$luaj$vm2$LuaTable$StrongSlot$$Lorg$luaj$vm2$LuaValue$(var15,var16));
     var12.next = var17;
     var18 = phi7;
     return var18;
    }
  }

  I$arraykey$I(arg0) {
    var var0 = 0;
    var0 = (arg0) | 0;
    return 0;
  }

  Lorg$luaj$vm2$LuaTable$Slot$$relink$Lorg$luaj$vm2$LuaTable$Slot$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var phi8 = null;
    var phi9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var phi13 = null;
    var phi14 = null;
    var var15 = null;
    var0 = arg0;
    var1 = (this.Lorg$luaj$vm2$LuaValue$$strongkey$$());
    If_8_0: {
     if (var1 == null) {
      phi13 = this;
      phi14 = var0;
      break If_8_0;
     } else {
      var2 = this;
      var3 = (var2.Lorg$luaj$vm2$LuaValue$$strongvalue$$());
      if (var3 == null) {
       phi13 = this;
       phi14 = var0;
       break If_8_0;
      } else {
       var4 = var0;
       If_19_0: {
        if (var4 != null) {
         phi8 = this;
         phi9 = var0;
         break If_19_0;
        } else {
         var5 = this;
         var6 = (var5.next);
         if (var6 != null) {
          phi8 = this;
          phi9 = var0;
          break If_19_0;
         } else {
          var7 = this;
          return var7;
         }
        }
       }
       var10 = phi8;
       var11 = phi9;
       var12 = (var10.Lorg$luaj$vm2$WeakTable$WeakSlot$$copy$Lorg$luaj$vm2$LuaTable$Slot$(var11));
       return var12;
      }
     }
    }
    var15 = phi14;
    return var15;
  }

  Lorg$luaj$vm2$LuaTable$Slot$$add$Lorg$luaj$vm2$LuaTable$Slot$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var phi6 = null;
    var phi7 = null;
    var phi8 = null;
    var phi9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var0 = arg0;
    var1 = this;
    var2 = (var1.next);
    If_10_0: {
     if (var2 == null) {
      phi6 = this;
      phi7 = var0;
      phi8 = this;
      phi9 = var0;
      break If_10_0;
     } else {
      var3 = this;
      var4 = (var3.next);
      var5 = (var4.Lorg$luaj$vm2$LuaTable$Slot$$add$Lorg$luaj$vm2$LuaTable$Slot$(var0));
      // Here was a goto statement
      phi6 = this;
      phi7 = var0;
      phi8 = this;
      phi9 = var5;
      break If_10_0;
     }
    }
    phi8.next = phi9;
    var10 = phi6;
    var11 = (var10.Lorg$luaj$vm2$LuaValue$$strongkey$$());
    If_32_0: {
     if (var11 == null) {
      break If_32_0;
     } else {
      var12 = phi6;
      var13 = (var12.Lorg$luaj$vm2$LuaValue$$strongvalue$$());
      if (var13 == null) {
       break If_32_0;
      } else {
       var14 = phi6;
       return var14;
      }
     }
    }
    var15 = phi6;
    var16 = (var15.next);
    return var16;
  }
}


class java$lang$ref$WeakReference extends java$lang$ref$Reference {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$ref$WeakReference,[java$lang$Object,java$lang$ref$WeakReference,java$lang$ref$Reference]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Ljava$lang$Object$(arg0) {
    // source file is WeakReference.java
    var var0 = null;
    var var1 = null;
    var0 = arg0;
    // line number 26
    var1 = var0;
    de$mirkosertic$bytecoder$classlib$java$lang$ref$TReference.prototype.V$$init$$Ljava$lang$Object$.call(this,var1);
    // line number 27
    return;
  }
}


class java$lang$String extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$String,[java$lang$Object,java$lang$Comparable,java$lang$String,java$lang$CharSequence]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  $C$toCharArray$$() {
    return bytecoder.imports['java.lang.String'].$C$toCharArray$$(this);
  }

  Z$equals$Ljava$lang$Object$(arg0) {
    // source file is String.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var0 = arg0;
    // line number 123
    if (var0 != null) {
     // line number 126
     var1 = this;
     if (var0 != var1) {
      // line number 129
      var2 = (var0.Ljava$lang$String$$toString$$());
      var3 = (java$lang$String.prototype.Z$equals0$Ljava$lang$String$.call(this,var2));
      return var3;
     } else {
      // line number 127
      return 1;
     }
    } else {
     // line number 124
     return 0;
    }
  }

  Z$equals0$Ljava$lang$String$(arg0) {
    return bytecoder.imports['java.lang.String'].Z$equals0$Ljava$lang$String$(this, arg0);
  }

  static Ljava$lang$String$$valueOf$Ljava$lang$Object$(arg0) {
    // source file is String.java
    var var0 = null;
    // line number 76
    if (arg0 != null) {
     // line number 79
     var0 = (arg0.Ljava$lang$String$$toString$$());
     return var0;
    } else {
     // line number 77
     return bytecoder.stringconstants[0];
    }
  }

  V$$init$$$() {
    // source file is String.java
    // line number 25
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 26
    return;
  }

  I$length$$() {
    return bytecoder.imports['java.lang.String'].I$length$$(this);
  }

  static Ljava$lang$String$$format$Ljava$lang$String$$$Ljava$lang$Object$(arg0,arg1) {
    return bytecoder.imports['java.lang.String'].Ljava$lang$String$$format$Ljava$lang$String$$$Ljava$lang$Object$(arg0, arg1);
  }

  I$hashCode$$() {
    // source file is String.java
    var var0 = null;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    var phi4 = 0;
    var var5 = 0;
    var var6 = null;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = null;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = 0;
    // line number 194
    var0 = (java$lang$String.prototype.$B$getBytes$$.call(this));
    // line number 195
    var1 = (0) | 0;
    // line number 196
    phi2 = var0;
    phi3 = (var1) | 0;
    phi4 = (0) | 0;
    L1844974188: while(true) {
     var5 = (phi4) | 0;
     var6 = phi2;
     var7 = (var6.data.length) | 0;
     if (var5 >= var7) {
      // line number 199
      var14 = (phi3) | 0;
      return var14;
     } else {
      // line number 197
      var8 = (phi3) | 0;
      var9 = ((31 * var8)) | 0;
      var10 = phi2;
      var11 = (phi4) | 0;
      var12 = (var10.data[var11]);
      var13 = ((var9 + var12)) | 0;
      // line number 196
      phi4 = ((phi4 + 1)) | 0;
      // Here was a goto statement
      phi3 = (var13) | 0;
      continue L1844974188;
     }
    }
  }

  $B$getBytes$$() {
    return bytecoder.imports['java.lang.String'].$B$getBytes$$(this);
  }

  C$charAt$I(arg0) {
    return bytecoder.imports['java.lang.String'].C$charAt$I(this, arg0);
  }

  I$compareTo$Ljava$lang$String$(arg0) {
    // source file is String.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = null;
    var var8 = null;
    var var9 = 0;
    var phi10 = null;
    var phi11 = null;
    var phi12 = 0;
    var phi13 = 0;
    var phi14 = 0;
    var phi15 = null;
    var phi16 = null;
    var phi17 = 0;
    var var18 = 0;
    var var19 = 0;
    var var20 = null;
    var var21 = 0;
    var var22 = 0;
    var var23 = null;
    var var24 = 0;
    var var25 = 0;
    var var26 = 0;
    var var27 = 0;
    var var28 = 0;
    var var29 = 0;
    var var30 = 0;
    var var31 = 0;
    var0 = arg0;
    // line number 141
    var1 = (java$lang$String.prototype.$C$toCharArray$$.call(this));
    // line number 142
    var2 = (java$lang$String.prototype.$C$toCharArray$$.call(var0));
    // line number 144
    var3 = (var1.data.length) | 0;
    // line number 145
    var4 = (var2.data.length) | 0;
    // line number 146
    var5 = (var4) | 0;
    java$lang$Math.$i;
    var6 = ((java$lang$Math.I$min$I$I(var3,var5))) | 0;
    // line number 147
    var7 = var1;
    // line number 148
    var8 = var2;
    // line number 150
    var9 = (0) | 0;
    phi10 = var0;
    phi11 = var2;
    phi12 = (var3) | 0;
    phi13 = (var4) | 0;
    phi14 = (var6) | 0;
    phi15 = var7;
    phi16 = var8;
    phi17 = (var9) | 0;
    L905191449: while(true) {
     // line number 151
     var18 = (phi17) | 0;
     var19 = (phi14) | 0;
     if (var18 >= var19) {
      // line number 159
      var29 = (phi12) | 0;
      var30 = (phi13) | 0;
      var31 = ((var29 - var30)) | 0;
      return var31;
     } else {
      // line number 152
      var20 = phi15;
      var21 = (phi17) | 0;
      var22 = (var20.data[var21]);
      // line number 153
      var23 = phi16;
      var24 = (phi17) | 0;
      var25 = (var23.data[var24]);
      // line number 154
      var26 = var25;
      if (var22 == var26) {
       // line number 157
       phi17 = ((phi17 + 1)) | 0;
       // line number 158
       // Here was a goto statement
       continue L905191449;
      } else {
       // line number 155
       var27 = var25;
       var28 = ((var22 - var27)) | 0;
       return var28;
      }
     }
    }
  }

  V$getChars$I$I$$C$I(arg0,arg1,arg2,arg3) {
    bytecoder.imports['java.lang.String'].V$getChars$I$I$$C$I(this, arg0, arg1, arg2, arg3);
  }

  I$indexOf$I(arg0) {
    return bytecoder.imports['java.lang.String'].I$indexOf$I(this, arg0);
  }

  V$$init$$$C(arg0) {
    // source file is String.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var0 = arg0;
    // line number 54
    java$lang$String.prototype.V$$init$$$.call(this);
    // line number 55
    var1 = (0) | 0;
    var2 = (var0.data.length) | 0;
    java$lang$String.prototype.V$initializeWith$$C$I$I.call(this,var0,var1,var2);
    // line number 56
    return;
  }

  V$initializeWith$$C$I$I(arg0,arg1,arg2) {
    bytecoder.imports['java.lang.String'].V$initializeWith$$C$I$I(this, arg0, arg1, arg2);
  }

  I$compareTo$Ljava$lang$Object$(arg0) {
    // source file is String.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var0 = arg0;
    // line number 22
    var1 = var0;
    var2 = var1;
    var3 = ((java$lang$String.prototype.I$compareTo$Ljava$lang$String$.call(this,var2))) | 0;
    return var3;
  }

  Ljava$lang$String$$toString$$() {
    // source file is String.java
    var var0 = null;
    // line number 72
    var0 = this;
    return var0;
  }

  static Ljava$lang$String$$valueOf$I(arg0) {
    // source file is String.java
    var var0 = null;
    // line number 95
    java$lang$Integer.$i;
    var0 = (java$lang$Integer.Ljava$lang$String$$toString$I(arg0));
    return var0;
  }

  Z$startsWith$Ljava$lang$String$(arg0) {
    return bytecoder.imports['java.lang.String'].Z$startsWith$Ljava$lang$String$(this, arg0);
  }

  Ljava$lang$String$$substring$I(arg0) {
    return bytecoder.imports['java.lang.String'].Ljava$lang$String$$substring$I(this, arg0);
  }

  I$lastIndexOf$I(arg0) {
    return bytecoder.imports['java.lang.String'].I$lastIndexOf$I(this, arg0);
  }

  static Ljava$lang$String$$valueOf$C(arg0) {
    // source file is String.java
    var var0 = null;
    // line number 87
    var0 = (java$lang$Character.Ljava$lang$String$$toString$C(arg0));
    return var0;
  }

  V$$init$$$B$I$I(arg0,arg1,arg2) {
    // source file is String.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var0 = arg0;
    var1 = (arg2) | 0;
    // line number 44
    java$lang$String.prototype.V$$init$$$.call(this);
    // line number 45
    var2 = (arg1) | 0;
    var3 = (0) | 0;
    java$lang$String.prototype.V$initializeWith$$B$I$I$B.call(this,var0,var2,var1,var3);
    // line number 46
    return;
  }

  V$initializeWith$$B$I$I$B(arg0,arg1,arg2,arg3) {
    bytecoder.imports['java.lang.String'].V$initializeWith$$B$I$I$B(this, arg0, arg1, arg2, arg3);
  }

  Ljava$lang$String$$substring$I$I(arg0,arg1) {
    return bytecoder.imports['java.lang.String'].Ljava$lang$String$$substring$I$I(this, arg0, arg1);
  }

  V$$init$$$C$I$I(arg0,arg1,arg2) {
    // source file is String.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var0 = arg0;
    var1 = (arg2) | 0;
    // line number 49
    java$lang$String.prototype.V$$init$$$.call(this);
    // line number 50
    var2 = (arg1) | 0;
    java$lang$String.prototype.V$initializeWith$$C$I$I.call(this,var0,var2,var1);
    // line number 51
    return;
  }

  Ljava$lang$String$$trim$$() {
    return bytecoder.imports['java.lang.String'].Ljava$lang$String$$trim$$(this);
  }

  static Ljava$lang$String$$valueOf$Z(arg0) {
    // source file is String.java
    var var0 = null;
    var phi1 = 0;
    var phi2 = null;
    // line number 111
    If_4_0: {
     if (arg0 == 0) {
      phi1 = arg0;
      phi2 = bytecoder.stringconstants[156];
      break If_4_0;
     } else {
      var0 = bytecoder.stringconstants[47];
      // Here was a goto statement
      phi1 = arg0;
      phi2 = var0;
      break If_4_0;
     }
    }
    return phi2;
  }
}

java$lang$String.prototype.Z$isEmpty$$ = java$lang$CharSequence.prototype.Z$isEmpty$$;

class java$util$KeyValueHolder extends java$lang$Object {
  nativeObject = null;

  key = null;
  value = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$KeyValueHolder,[java$util$KeyValueHolder,java$lang$Object,java$util$Map$Entry]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Ljava$lang$Object$$Ljava$lang$Object$(arg0,arg1) {
    // source file is KeyValueHolder.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var0 = arg0;
    // line number 60
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 61
    var1 = this;
    var2 = (java$util$Objects.Ljava$lang$Object$$requireNonNull$Ljava$lang$Object$(var0));
    var1.key = var2;
    // line number 62
    var3 = this;
    var4 = (java$util$Objects.Ljava$lang$Object$$requireNonNull$Ljava$lang$Object$(arg1));
    var3.value = var4;
    // line number 63
    return;
  }

  Ljava$lang$String$$toString$$() {
    // source file is KeyValueHolder.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    // line number 129
    var0 = new java$lang$StringBuilder();
    java$lang$StringBuilder.prototype.V$$init$$$.call(var0);
    var1 = (this.key);
    var2 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$Object$.call(var0,var1));
    var3 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var2,bytecoder.stringconstants[155]));
    var4 = (this.value);
    var5 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$Object$.call(var3,var4));
    var6 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var5));
    return var6;
  }

  Z$equals$Ljava$lang$Object$(arg0) {
    // source file is KeyValueHolder.java
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = 0;
    var var10 = 0;
    var phi11 = null;
    var phi12 = null;
    var phi13 = null;
    var phi14 = 0;
    var phi15 = null;
    var phi16 = null;
    var phi17 = null;
    var0 = arg0;
    // line number 106
    var1 = (bytecoder.instanceOf(var0,java$util$Map$Entry)) | 0;
    If_11_0: {
     If_11_1: {
      if (var1 == 0) {
       phi15 = this;
       phi16 = var0;
       break If_11_1;
      } else {
       // line number 104
       var2 = var0;
       var3 = (this.key);
       // line number 105
       var4 = (var2.Ljava$lang$Object$$getKey$$());
       var5 = (var3.Z$equals$Ljava$lang$Object$(var4));
       if (var5 == 0) {
        phi15 = this;
        phi16 = var0;
        phi17 = var2;
        break If_11_1;
       } else {
        var6 = this;
        var7 = (var6.value);
        // line number 106
        var8 = (var2.Ljava$lang$Object$$getValue$$());
        var9 = (var7.Z$equals$Ljava$lang$Object$(var8));
        if (var9 == 0) {
         phi15 = this;
         phi16 = var0;
         phi17 = var2;
         break If_11_1;
        } else {
         var10 = (1) | 0;
         // Here was a goto statement
         phi11 = this;
         phi12 = var0;
         phi13 = var2;
         phi14 = (var10) | 0;
         break If_11_0;
        }
       }
      }
     }
     phi11 = phi15;
     phi12 = phi16;
     phi13 = phi17;
     phi14 = (0) | 0;
     break If_11_0;
    }
    // line number 104
    return phi14;
  }

  I$hashCode$$() {
    // source file is KeyValueHolder.java
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    // line number 116
    var0 = (this.key);
    var1 = ((var0.I$hashCode$$())) | 0;
    var2 = (this.value);
    var3 = ((var2.I$hashCode$$())) | 0;
    var4 = ((var1 ^ var3)) | 0;
    return var4;
  }

  Ljava$lang$Object$$getKey$$() {
    // source file is KeyValueHolder.java
    var var0 = null;
    // line number 72
    var0 = (this.key);
    return var0;
  }

  Ljava$lang$Object$$getValue$$() {
    // source file is KeyValueHolder.java
    var var0 = null;
    // line number 82
    var0 = (this.value);
    return var0;
  }
}


class de$mirkosertic$bytecoder$api$web$WindowOrWorkerGlobalScope extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(de$mirkosertic$bytecoder$api$web$WindowOrWorkerGlobalScope,[java$lang$Object,de$mirkosertic$bytecoder$api$web$WindowOrWorkerGlobalScope,de$mirkosertic$bytecoder$api$OpaqueReferenceType]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class java$util$ImmutableCollections$SetN$SetNIterator extends java$lang$Object {
  nativeObject = null;

  this$0 = null;
  remaining = 0;
  idx = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$ImmutableCollections$SetN$SetNIterator,[java$util$Iterator,java$lang$Object,java$util$ImmutableCollections$SetN$SetNIterator]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Ljava$util$ImmutableCollections$SetN$(arg0) {
    // source file is ImmutableCollections.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = null;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var0 = this;
    // line number 947
    var1 = arg0;
    var0.this$0 = var1;
    java$lang$Object.prototype.V$$init$$$.call(var0);
    // line number 948
    var2 = ((arg0.size)) | 0;
    var0.remaining = var2;
    // line number 951
    java$util$ImmutableCollections.$i;
    var3 = (java$util$ImmutableCollections.SALT32L);
    var4 = (arg0.elements);
    var5 = (var4.data.length) | 0;
    var6 = (var5 | 0);
    var7 = (var3 * var6);
    var8 = (var7 >>> 32);
    var9 = ((var8 | 0)) | 0;
    var0.idx = var9;
    // line number 952
    return;
  }

  Z$hasNext$$() {
    // source file is ImmutableCollections.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    // line number 956
    var0 = ((this.remaining)) | 0;
    If_7_0: {
     if (var0 <= 0) {
      phi2 = this;
      phi3 = (0) | 0;
      break If_7_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = this;
      phi3 = (var1) | 0;
      break If_7_0;
     }
    }
    return phi3;
  }

  Ljava$lang$Object$$next$$() {
    // source file is ImmutableCollections.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var phi5 = null;
    var phi6 = 0;
    var phi7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var phi11 = 0;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = 0;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = 0;
    var var20 = null;
    var var21 = 0;
    var var22 = 0;
    var var23 = 0;
    var var24 = 0;
    var var25 = 0;
    var var26 = null;
    // line number 961
    var0 = ((this.remaining)) | 0;
    if (var0 <= 0) {
     // line number 981
     var26 = new java$util$NoSuchElementException();
     java$util$NoSuchElementException.prototype.V$$init$$$.call(var26);
     throw bytecoder.registerStack(var26, new Error().stack);
    } else {
     // line number 963
     var1 = ((this.idx)) | 0;
     // line number 964
     var2 = (this.this$0);
     var3 = (var2.elements);
     var4 = (var3.data.length) | 0;
     phi5 = this;
     phi6 = (var1) | 0;
     phi7 = (var4) | 0;
     L946146041: while(true) {
      // line number 967
      java$util$ImmutableCollections.$i;
      var8 = (java$util$ImmutableCollections.REVERSE);
      If_37_0: {
       if (var8 == 0) {
        // line number 972
        phi6 = ((phi6 + -1)) | 0;
        var23 = (phi6) | 0;
        if (var23 >= 0) {
         phi11 = (phi6) | 0;
         break If_37_0;
        } else {
         // line number 973
         var24 = (phi7) | 0;
         var25 = ((var24 - 1)) | 0;
         phi11 = (var25) | 0;
         break If_37_0;
        }
       } else {
        // line number 968
        phi6 = ((phi6 + 1)) | 0;
        var9 = (phi6) | 0;
        var10 = (phi7) | 0;
        if (var9 < var10) {
         phi11 = (phi6) | 0;
         break If_37_0;
        } else {
         // line number 969
         // Here was a goto statement
         phi11 = (0) | 0;
         break If_37_0;
        }
       }
      }
      // line number 976
      var12 = phi5;
      var13 = (var12.this$0);
      var14 = (var13.elements);
      var15 = (phi11) | 0;
      var16 = (var14.data[var15]);
      var17 = var16;
      if (var16 == null) {
       phi6 = (phi11) | 0;
       continue L946146041;
      } else {
       // line number 977
       var18 = phi5;
       var19 = (phi11) | 0;
       var18.idx = var19;
       // line number 978
       var20 = phi5;
       var21 = ((var20.remaining)) | 0;
       var22 = ((var21 - 1)) | 0;
       var20.remaining = var22;
       // line number 979
       return var17;
      }
     }
    }
  }
}


class jdk$internal$util$Preconditions$3 extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(jdk$internal$util$Preconditions$3,[java$lang$Object,jdk$internal$util$Preconditions$3,java$util$function$Function]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.Ljava$lang$Object$$apply$Ljava$lang$Object$ = impl;
  }

  V$$init$$$() {
    // source file is Preconditions.java
    // line number 68
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }

  Ljava$lang$Object$$apply$Ljava$lang$Object$(arg0) {
    // source file is Preconditions.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var0 = arg0;
    // line number 68
    var1 = var0;
    var2 = var1;
    var3 = (jdk$internal$util$Preconditions$3.prototype.Ljava$lang$IndexOutOfBoundsException$$apply$Ljava$lang$String$.call(this,var2));
    return var3;
  }

  Ljava$lang$IndexOutOfBoundsException$$apply$Ljava$lang$String$(arg0) {
    // source file is Preconditions.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    // line number 71
    var1 = new java$lang$IndexOutOfBoundsException();
    var2 = var0;
    java$lang$IndexOutOfBoundsException.prototype.V$$init$$Ljava$lang$String$.call(var1,var2);
    return var1;
  }
}


class java$util$Hashtable$Entry extends java$lang$Object {
  nativeObject = null;

  hash = 0;
  key = null;
  value = null;
  next = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$Hashtable$Entry,[java$lang$Object,java$util$Map$Entry,java$util$Hashtable$Entry]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$I$Ljava$lang$Object$$Ljava$lang$Object$$Ljava$util$Hashtable$Entry$(arg0,arg1,arg2,arg3) {
    // source file is Hashtable.java
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var0 = (arg0) | 0;
    var1 = arg2;
    // line number 1373
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 1374
    var2 = this;
    var2.hash = var0;
    // line number 1375
    var3 = this;
    var3.key = arg1;
    // line number 1376
    var4 = this;
    var4.value = var1;
    // line number 1377
    var5 = this;
    var5.next = arg3;
    // line number 1378
    return;
  }

  Ljava$lang$String$$toString$$() {
    // source file is Hashtable.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    // line number 1418
    var0 = new java$lang$StringBuilder();
    java$lang$StringBuilder.prototype.V$$init$$$.call(var0);
    var1 = (this.key);
    var2 = (var1.Ljava$lang$String$$toString$$());
    var3 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var0,var2));
    var4 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var3,bytecoder.stringconstants[155]));
    var5 = (this.value);
    var6 = (var5.Ljava$lang$String$$toString$$());
    var7 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var4,var6));
    var8 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var7));
    return var8;
  }

  Z$equals$Ljava$lang$Object$(arg0) {
    // source file is Hashtable.java
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var phi7 = null;
    var phi8 = null;
    var phi9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var phi14 = 0;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = 0;
    var var20 = null;
    var var21 = null;
    var var22 = 0;
    var0 = arg0;
    // line number 1406
    var1 = (bytecoder.instanceOf(var0,java$util$Map$Entry)) | 0;
    if (var1 == 0) {
     // line number 1407
     return 0;
    } else {
     var2 = var0;
     var3 = var2;
     // Here was a goto statement
     // line number 1409
     var4 = (this.key);
     If_27_0: {
      If_27_1: {
       If_27_2: {
        if (var4 != null) {
         var20 = (this.key);
         var21 = (var3.Ljava$lang$Object$$getKey$$());
         var22 = (var20.Z$equals$Ljava$lang$Object$(var21));
         if (var22 == 0) {
          phi7 = this;
          phi8 = var0;
          phi9 = var3;
          break If_27_1;
         } else {
          phi7 = this;
          phi8 = var0;
          phi9 = var3;
          break If_27_2;
         }
        } else {
         var5 = var3;
         var6 = (var5.Ljava$lang$Object$$getKey$$());
         if (var6 != null) {
          phi7 = this;
          phi8 = var0;
          phi9 = var3;
          break If_27_1;
         } else {
          // Here was a goto statement
          phi7 = this;
          phi8 = var0;
          phi9 = var3;
          break If_27_2;
         }
        }
       }
       var10 = phi7;
       var11 = (var10.value);
       If_47_0: {
        if (var11 != null) {
         var15 = phi7;
         var16 = (var15.value);
         var17 = phi9;
         var18 = (var17.Ljava$lang$Object$$getValue$$());
         var19 = (var16.Z$equals$Ljava$lang$Object$(var18));
         if (var19 == 0) {
          break If_27_1;
         } else {
          break If_47_0;
         }
        } else {
         var12 = phi9;
         // line number 1410
         var13 = (var12.Ljava$lang$Object$$getValue$$());
         if (var13 != null) {
          break If_27_1;
         } else {
          // Here was a goto statement
          break If_47_0;
         }
        }
       }
       // Here was a goto statement
       phi14 = (1) | 0;
       break If_27_0;
      }
      phi14 = (0) | 0;
      break If_27_0;
     }
     // line number 1409
     return phi14;
    }
  }

  I$hashCode$$() {
    // source file is Hashtable.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    // line number 1414
    var0 = ((this.hash)) | 0;
    var1 = (this.value);
    var2 = ((java$util$Objects.I$hashCode$Ljava$lang$Object$(var1))) | 0;
    var3 = ((var0 ^ var2)) | 0;
    return var3;
  }

  Ljava$lang$Object$$getKey$$() {
    // source file is Hashtable.java
    var var0 = null;
    // line number 1389
    var0 = (this.key);
    return var0;
  }

  Ljava$lang$Object$$getValue$$() {
    // source file is Hashtable.java
    var var0 = null;
    // line number 1393
    var0 = (this.value);
    return var0;
  }
}


class jdk$internal$util$Preconditions$2 extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(jdk$internal$util$Preconditions$2,[jdk$internal$util$Preconditions$2,java$lang$Object,java$util$function$Function]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.Ljava$lang$Object$$apply$Ljava$lang$Object$ = impl;
  }

  V$$init$$$() {
    // source file is Preconditions.java
    // line number 60
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }

  Ljava$lang$Object$$apply$Ljava$lang$Object$(arg0) {
    // source file is Preconditions.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var0 = arg0;
    // line number 60
    var1 = var0;
    var2 = var1;
    var3 = (jdk$internal$util$Preconditions$2.prototype.Ljava$lang$ArrayIndexOutOfBoundsException$$apply$Ljava$lang$String$.call(this,var2));
    return var3;
  }

  Ljava$lang$ArrayIndexOutOfBoundsException$$apply$Ljava$lang$String$(arg0) {
    // source file is Preconditions.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    // line number 63
    var1 = new java$lang$ArrayIndexOutOfBoundsException();
    var2 = var0;
    java$lang$ArrayIndexOutOfBoundsException.prototype.V$$init$$Ljava$lang$String$.call(var1,var2);
    return var1;
  }
}


class org$luaj$vm2$TailcallVarargs extends org$luaj$vm2$Varargs {
  nativeObject = null;

  func = null;
  args = null;
  result = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$TailcallVarargs,[java$lang$Object,org$luaj$vm2$TailcallVarargs,org$luaj$vm2$Varargs]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$Varargs$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    org$luaj$vm2$Varargs.prototype.V$$init$$$.call(this);
    var1 = this;
    var1.func = var0;
    var2 = this;
    var2.args = arg1;
    return;
  }

  I$narg$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var phi3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var0 = (this.result);
    If_5_0: {
     if (var0 != null) {
      phi3 = this;
      break If_5_0;
     } else {
      var1 = this;
      var2 = (org$luaj$vm2$TailcallVarargs.prototype.Lorg$luaj$vm2$Varargs$$eval$$.call(var1));
      phi3 = this;
      break If_5_0;
     }
    }
    var4 = phi3;
    var5 = (var4.result);
    var6 = ((var5.I$narg$$())) | 0;
    return var6;
  }

  Lorg$luaj$vm2$Varargs$$eval$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var phi14 = null;
    var phi15 = null;
    var var16 = null;
    var var17 = null;
    var0 = this;
    L1113619979: while(true) {
     var1 = (var0.result);
     if (var1 != null) {
      var17 = (var0.result);
      return var17;
     } else {
      var2 = var0;
      var3 = (var2.func);
      var4 = (var0.args);
      var5 = (var3.Lorg$luaj$vm2$Varargs$$onInvoke$Lorg$luaj$vm2$Varargs$(var4));
      var6 = var5;
      var7 = (var6.Z$isTailcall$$());
      If_26_0: {
       if (var7 == 0) {
        var16 = var5;
        var0.result = var16;
        var0.func = null;
        var0.args = null;
        phi14 = var0;
        phi15 = var5;
        break If_26_0;
       } else {
        var8 = var5;
        var9 = var8;
        var10 = var0;
        var11 = (var9.func);
        var10.func = var11;
        var12 = var9;
        var13 = (var12.args);
        var0.args = var13;
        // Here was a goto statement
        phi14 = var0;
        phi15 = var5;
        break If_26_0;
       }
      }
      // Here was a goto statement
      var0 = phi14;
      continue L1113619979;
     }
    }
  }

  Lorg$luaj$vm2$LuaValue$$arg1$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var phi3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var0 = (this.result);
    If_5_0: {
     if (var0 != null) {
      phi3 = this;
      break If_5_0;
     } else {
      var1 = this;
      var2 = (org$luaj$vm2$TailcallVarargs.prototype.Lorg$luaj$vm2$Varargs$$eval$$.call(var1));
      phi3 = this;
      break If_5_0;
     }
    }
    var4 = phi3;
    var5 = (var4.result);
    var6 = (var5.Lorg$luaj$vm2$LuaValue$$arg1$$());
    return var6;
  }

  Lorg$luaj$vm2$LuaValue$$arg$I(arg0) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var phi4 = null;
    var phi5 = 0;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var0 = (arg0) | 0;
    var1 = (this.result);
    If_8_0: {
     if (var1 != null) {
      phi4 = this;
      phi5 = (var0) | 0;
      break If_8_0;
     } else {
      var2 = this;
      var3 = (org$luaj$vm2$TailcallVarargs.prototype.Lorg$luaj$vm2$Varargs$$eval$$.call(var2));
      phi4 = this;
      phi5 = (var0) | 0;
      break If_8_0;
     }
    }
    var6 = phi4;
    var7 = (var6.result);
    var8 = (phi5) | 0;
    var9 = (var7.Lorg$luaj$vm2$LuaValue$$arg$I(var8));
    return var9;
  }

  Lorg$luaj$vm2$Varargs$$subargs$I(arg0) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var phi4 = null;
    var phi5 = 0;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var0 = (arg0) | 0;
    var1 = (this.result);
    If_8_0: {
     if (var1 != null) {
      phi4 = this;
      phi5 = (var0) | 0;
      break If_8_0;
     } else {
      var2 = this;
      var3 = (org$luaj$vm2$TailcallVarargs.prototype.Lorg$luaj$vm2$Varargs$$eval$$.call(var2));
      phi4 = this;
      phi5 = (var0) | 0;
      break If_8_0;
     }
    }
    var6 = phi4;
    var7 = (var6.result);
    var8 = (phi5) | 0;
    var9 = (var7.Lorg$luaj$vm2$Varargs$$subargs$I(var8));
    return var9;
  }

  Z$isTailcall$$() {
    var var0 = 0;
    var0 = (1) | 0;
    return var0;
  }
}


class de$mirkosertic$bytecoder$api$web$EventTarget extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(de$mirkosertic$bytecoder$api$web$EventTarget,[java$lang$Object,de$mirkosertic$bytecoder$api$web$EventTarget,de$mirkosertic$bytecoder$api$OpaqueReferenceType]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.V$addEventListener$Ljava$lang$String$$Lde$mirkosertic$bytecoder$api$web$EventListener$ = impl;
  }

  V$addEventListener$Ljava$lang$String$$Lde$mirkosertic$bytecoder$api$web$EventListener$(arg0,arg1) {
    this.nativeObject.addEventListener(arg0.nativeObject, function(arg0) {this.V$run$Lde$mirkosertic$bytecoder$api$web$Event$(bytecoder.wrapNativeIntoTypeInstance(de$mirkosertic$bytecoder$api$web$Event, arg0))}.bind(arg1));
  }
}


class de$mirkosertic$bytecoder$classlib$VM$1 extends java$lang$ClassLoader {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(de$mirkosertic$bytecoder$classlib$VM$1,[java$lang$Object,java$lang$ClassLoader,de$mirkosertic$bytecoder$classlib$VM$1]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is VM.java
    // line number 26
    java$lang$ClassLoader.prototype.V$$init$$$.call(this);
    return;
  }
}


class java$util$concurrent$locks$ReentrantLock extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$concurrent$locks$ReentrantLock,[java$util$concurrent$locks$Lock,java$lang$Object,java$util$concurrent$locks$ReentrantLock]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is ReentrantLock.java
    // line number 26
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }

  V$lock$$() {
    // source file is ReentrantLock.java
    // line number 30
    return;
  }

  V$unlock$$() {
    // source file is ReentrantLock.java
    // line number 49
    return;
  }
}


class java$nio$Buffer$1 extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$nio$Buffer$1,[jdk$internal$access$JavaNioAccess,java$lang$Object,java$nio$Buffer$1]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is Buffer.java
    // line number 782
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class java$util$Hashtable extends java$util$Dictionary {
  nativeObject = null;

  modCount = 0;
  loadFactor = 0.0;
  table = null;
  threshold = 0;
  count = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$Hashtable,[java$lang$Object,java$util$Hashtable,java$lang$Cloneable,java$io$Serializable,java$util$Dictionary,java$util$Map]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Ljava$lang$Void$(arg0) {
    // source file is Hashtable.java
    var var0 = null;
    var var1 = null;
    var0 = arg0;
    // line number 240
    java$util$Dictionary.prototype.V$$init$$$.call(this);
    // line number 171
    var1 = this;
    var1.modCount = 0;
    // line number 240
    return;
  }

  V$$init$$$() {
    // source file is Hashtable.java
    var var0 = 0;
    // line number 217
    var0 = (11) | 0;
    java$util$Hashtable.prototype.V$$init$$I$F.call(this,var0,0.75);
    // line number 218
    return;
  }

  V$$init$$I$F(arg0,arg1) {
    // source file is Hashtable.java
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = .0;
    var var8 = 0;
    var var9 = .0;
    var var10 = 0;
    var phi11 = null;
    var phi12 = 0;
    var phi13 = .0;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = .0;
    var var18 = null;
    var var19 = null;
    var var20 = 0;
    var phi21 = null;
    var phi22 = 0;
    var phi23 = .0;
    var var24 = null;
    var var25 = .0;
    var var26 = null;
    var var27 = 0;
    var var28 = null;
    var var29 = null;
    var var30 = 0;
    var var31 = .0;
    var var32 = .0;
    var var33 = .0;
    var var34 = .0;
    var var35 = 0;
    var0 = (arg0) | 0;
    // line number 186
    java$util$Dictionary.prototype.V$$init$$$.call(this);
    // line number 171
    var1 = this;
    var1.modCount = 0;
    // line number 187
    if (var0 >= 0) {
     // line number 190
     var7 = 0.0;
     var8 = (bytecoder.cmp(arg1,var7)) | 0;
     If_54_0: {
      if (var8 <= 0) {
       phi11 = this;
       phi12 = (var0) | 0;
       phi13 = arg1;
       break If_54_0;
      } else {
       var9 = arg1;
       java$lang$Float.$i;
       var10 = (java$lang$Float.Z$isNaN$F(var9));
       if (var10 == 0) {
        // line number 193
        If_99_0: {
         if (var0 != 0) {
          phi21 = this;
          phi22 = (var0) | 0;
          phi23 = arg1;
          break If_99_0;
         } else {
          // line number 194
          var20 = (1) | 0;
          phi21 = this;
          phi22 = (var20) | 0;
          phi23 = arg1;
          break If_99_0;
         }
        }
        // line number 195
        var24 = phi21;
        var25 = phi23;
        var24.loadFactor = var25;
        // line number 196
        var26 = phi21;
        var27 = (phi22) | 0;
        var28 = bytecoder.newarray((var27),null);
        var26.table = var28;
        // line number 197
        var29 = phi21;
        var30 = (phi22) | 0;
        var31 = var30;
        var32 = phi23;
        var33 = (var31 * var32);
        java$lang$Math.$i;
        var34 = (java$lang$Math.F$min$F$F(var33,2.14748365E9));
        var35 = ((var34 | 0)) | 0;
        var29.threshold = var35;
        // line number 198
        return;
       } else {
        phi11 = this;
        phi12 = (var0) | 0;
        phi13 = arg1;
        break If_54_0;
       }
      }
     }
     // line number 191
     var14 = new java$lang$IllegalArgumentException();
     var15 = new java$lang$StringBuilder();
     java$lang$StringBuilder.prototype.V$$init$$$.call(var15);
     var16 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var15,bytecoder.stringconstants[293]));
     var17 = phi13;
     var18 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$F.call(var16,var17));
     var19 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var18));
     java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var14,var19);
     throw bytecoder.registerStack(var14, new Error().stack);
    } else {
     // line number 188
     var2 = new java$lang$IllegalArgumentException();
     var3 = new java$lang$StringBuilder();
     java$lang$StringBuilder.prototype.V$$init$$$.call(var3);
     var4 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var3,bytecoder.stringconstants[292]));
     var5 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var4,var0));
     var6 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var5));
     java$lang$IllegalArgumentException.prototype.V$$init$$Ljava$lang$String$.call(var2,var6);
     throw bytecoder.registerStack(var2, new Error().stack);
    }
  }

  Ljava$lang$Object$$put$Ljava$lang$Object$$Ljava$lang$Object$(arg0,arg1) {
    // source file is Hashtable.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = null;
    var phi9 = null;
    var phi10 = null;
    var phi11 = null;
    var phi12 = 0;
    var phi13 = 0;
    var phi14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = 0;
    var var18 = 0;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = 0;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = 0;
    var var31 = null;
    var var32 = null;
    var var33 = 0;
    var0 = arg0;
    // line number 475
    if (arg1 != null) {
     // line number 480
     var2 = (this.table);
     // line number 481
     var3 = ((var0.I$hashCode$$())) | 0;
     // line number 482
     var4 = ((var3 & 2147483647)) | 0;
     var5 = (var2.data.length) | 0;
     var6 = ((var4 % var5)) | 0;
     // line number 484
     var7 = (var6) | 0;
     var8 = (var2.data[var7]);
     phi9 = this;
     phi10 = var0;
     phi11 = arg1;
     phi12 = (var3) | 0;
     phi13 = (var6) | 0;
     phi14 = var8;
     L1111471385: while(true) {
      // line number 485
      var15 = phi14;
      if (var15 == null) {
       // line number 493
       var29 = phi9;
       var30 = (phi12) | 0;
       var31 = phi10;
       var32 = phi11;
       var33 = (phi13) | 0;
       java$util$Hashtable.prototype.V$addEntry$I$Ljava$lang$Object$$Ljava$lang$Object$$I.call(var29,var30,var31,var32,var33);
       // line number 494
       return null;
      } else {
       // line number 486
       var16 = phi14;
       var17 = ((var16.hash)) | 0;
       var18 = (phi12) | 0;
       If_71_0: {
        if (var17 != var18) {
         break If_71_0;
        } else {
         var19 = phi14;
         var20 = (var19.key);
         var21 = phi10;
         var22 = (var20.Z$equals$Ljava$lang$Object$(var21));
         if (var22 == 0) {
          break If_71_0;
         } else {
          // line number 487
          var23 = phi14;
          var24 = (var23.value);
          // line number 488
          var25 = phi14;
          var26 = phi11;
          var25.value = var26;
          // line number 489
          return var24;
         }
        }
       }
       // line number 485
       var27 = phi14;
       var28 = (var27.next);
       // Here was a goto statement
       phi14 = var28;
       continue L1111471385;
      }
     }
    } else {
     // line number 476
     var1 = new java$lang$NullPointerException();
     java$lang$NullPointerException.prototype.V$$init$$$.call(var1);
     throw bytecoder.registerStack(var1, new Error().stack);
    }
  }

  V$addEntry$I$Ljava$lang$Object$$Ljava$lang$Object$$I(arg0,arg1,arg2,arg3) {
    // source file is Hashtable.java
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var phi11 = null;
    var phi12 = 0;
    var phi13 = null;
    var phi14 = null;
    var phi15 = 0;
    var phi16 = null;
    var var17 = null;
    var var18 = 0;
    var var19 = null;
    var var20 = null;
    var var21 = 0;
    var var22 = null;
    var var23 = 0;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = 0;
    var var28 = 0;
    var var29 = null;
    var var30 = 0;
    var var31 = 0;
    var0 = (arg0) | 0;
    var1 = arg2;
    // line number 438
    var2 = (this.table);
    // line number 439
    var3 = ((this.count)) | 0;
    var4 = ((this.threshold)) | 0;
    If_23_0: {
     if (var3 < var4) {
      phi11 = this;
      phi12 = (var0) | 0;
      phi13 = arg1;
      phi14 = var1;
      phi15 = (arg3) | 0;
      phi16 = var2;
      break If_23_0;
     } else {
      // line number 441
      this.V$rehash$$();
      // line number 443
      var5 = (this.table);
      // line number 444
      var6 = ((arg1.I$hashCode$$())) | 0;
      // line number 445
      var7 = (2147483647) | 0;
      var8 = ((var6 & var7)) | 0;
      var9 = (var5.data.length) | 0;
      var10 = ((var8 % var9)) | 0;
      phi11 = this;
      phi12 = (var6) | 0;
      phi13 = arg1;
      phi14 = var1;
      phi15 = (var10) | 0;
      phi16 = var5;
      break If_23_0;
     }
    }
    // line number 450
    var17 = phi16;
    var18 = (phi15) | 0;
    var19 = (var17.data[var18]);
    // line number 451
    var20 = phi16;
    var21 = (phi15) | 0;
    var22 = new java$util$Hashtable$Entry();
    var23 = (phi12) | 0;
    var24 = phi13;
    var25 = phi14;
    java$util$Hashtable$Entry.prototype.V$$init$$I$Ljava$lang$Object$$Ljava$lang$Object$$Ljava$util$Hashtable$Entry$.call(var22,var23,var24,var25,var19);
    var20.data[var21] = var22;
    // line number 452
    var26 = phi11;
    var27 = ((var26.count)) | 0;
    var28 = ((var27 + 1)) | 0;
    var26.count = var28;
    // line number 453
    var29 = phi11;
    var30 = ((var29.modCount)) | 0;
    var31 = ((var30 + 1)) | 0;
    var29.modCount = var31;
    // line number 454
    return;
  }

  V$rehash$$() {
    // source file is Hashtable.java
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var phi7 = null;
    var phi8 = 0;
    var phi9 = null;
    var phi10 = 0;
    var var11 = 0;
    var var12 = null;
    var var13 = null;
    var var14 = 0;
    var var15 = 0;
    var var16 = null;
    var var17 = 0;
    var var18 = .0;
    var var19 = null;
    var var20 = .0;
    var var21 = .0;
    var var22 = .0;
    var var23 = 0;
    var var24 = null;
    var var25 = 0;
    var phi26 = null;
    var phi27 = 0;
    var var28 = 0;
    var var29 = null;
    var var30 = 0;
    var var31 = null;
    var phi32 = null;
    var var33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = null;
    var var37 = 0;
    var var38 = 0;
    var var39 = 0;
    var var40 = 0;
    var var41 = null;
    var var42 = null;
    var var43 = null;
    var var44 = null;
    // line number 408
    var0 = (this.table);
    var1 = (var0.data.length) | 0;
    // line number 409
    var2 = (this.table);
    // line number 412
    var3 = ((var1 << 1)) | 0;
    var4 = ((var3 + 1)) | 0;
    // line number 413
    var5 = ((var4 - 2147483639)) | 0;
    If_31_0: {
     if (var5 <= 0) {
      phi7 = this;
      phi8 = (var1) | 0;
      phi9 = var2;
      phi10 = (var4) | 0;
      break If_31_0;
     } else {
      // line number 414
      if (var1 != 2147483639) {
       // line number 417
       var6 = (2147483639) | 0;
       phi7 = this;
       phi8 = (var1) | 0;
       phi9 = var2;
       phi10 = (var6) | 0;
       break If_31_0;
      } else {
       // line number 416
       return;
      }
     }
    }
    // line number 419
    var11 = (phi10) | 0;
    var12 = bytecoder.newarray((var11),null);
    // line number 421
    var13 = phi7;
    var14 = ((var13.modCount)) | 0;
    var15 = ((var14 + 1)) | 0;
    var13.modCount = var15;
    // line number 422
    var16 = phi7;
    var17 = (phi10) | 0;
    var18 = var17;
    var19 = phi7;
    var20 = (var19.loadFactor);
    var21 = (var18 * var20);
    java$lang$Math.$i;
    var22 = (java$lang$Math.F$min$F$F(var21,2.14748365E9));
    var23 = ((var22 | 0)) | 0;
    var16.threshold = var23;
    // line number 423
    var24 = phi7;
    var24.table = var12;
    // line number 425
    var25 = (phi8) | 0;
    phi26 = var12;
    phi27 = (var25) | 0;
    L798937612: while(true) {
     var28 = (phi27) | 0;
     phi27 = ((phi27 + -1)) | 0;
     if (var28 <= 0) {
      // line number 435
      return;
     } else {
      // line number 426
      var29 = phi9;
      var30 = (phi27) | 0;
      var31 = (var29.data[var30]);
      phi32 = var31;
      L1630641736: while(true) {
       var33 = phi32;
       if (var33 == null) {
        // Here was a goto statement
        continue L798937612;
       } else {
        // line number 427
        var34 = phi32;
        // line number 428
        var35 = phi32;
        var36 = (var35.next);
        // line number 430
        var37 = ((var34.hash)) | 0;
        var38 = ((var37 & 2147483647)) | 0;
        var39 = (phi10) | 0;
        var40 = ((var38 % var39)) | 0;
        // line number 431
        var41 = phi26;
        var42 = (var41.data[var40]);
        var34.next = var42;
        // line number 432
        var43 = phi26;
        var44 = var34;
        var43.data[var40] = var44;
        // line number 433
        // Here was a goto statement
        phi32 = var36;
        continue L1630641736;
       }
      }
     }
    }
  }

  Ljava$lang$Object$$get$Ljava$lang$Object$(arg0) {
    // source file is Hashtable.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = null;
    var phi8 = null;
    var phi9 = 0;
    var phi10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = 0;
    var var14 = 0;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = 0;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var0 = arg0;
    // line number 380
    var1 = (this.table);
    // line number 381
    var2 = ((var0.I$hashCode$$())) | 0;
    // line number 382
    var3 = ((var2 & 2147483647)) | 0;
    var4 = (var1.data.length) | 0;
    var5 = ((var3 % var4)) | 0;
    // line number 383
    var6 = (var5) | 0;
    var7 = (var1.data[var6]);
    phi8 = var0;
    phi9 = (var2) | 0;
    phi10 = var7;
    L954176493: while(true) {
     var11 = phi10;
     if (var11 == null) {
      // line number 388
      return null;
     } else {
      // line number 384
      var12 = phi10;
      var13 = ((var12.hash)) | 0;
      var14 = (phi9) | 0;
      If_52_0: {
       if (var13 != var14) {
        break If_52_0;
       } else {
        var15 = phi10;
        var16 = (var15.key);
        var17 = phi8;
        var18 = (var16.Z$equals$Ljava$lang$Object$(var17));
        if (var18 == 0) {
         break If_52_0;
        } else {
         // line number 385
         var19 = phi10;
         var20 = (var19.value);
         return var20;
        }
       }
      }
      // line number 383
      var21 = phi10;
      var22 = (var21.next);
      // Here was a goto statement
      phi10 = var22;
      continue L954176493;
     }
    }
  }

  Z$containsKey$Ljava$lang$Object$(arg0) {
    // source file is Hashtable.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = null;
    var phi8 = null;
    var phi9 = 0;
    var phi10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = 0;
    var var14 = 0;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = 0;
    var var19 = null;
    var var20 = null;
    var0 = arg0;
    // line number 352
    var1 = (this.table);
    // line number 353
    var2 = ((var0.I$hashCode$$())) | 0;
    // line number 354
    var3 = ((var2 & 2147483647)) | 0;
    var4 = (var1.data.length) | 0;
    var5 = ((var3 % var4)) | 0;
    // line number 355
    var6 = (var5) | 0;
    var7 = (var1.data[var6]);
    phi8 = var0;
    phi9 = (var2) | 0;
    phi10 = var7;
    L1456312293: while(true) {
     var11 = phi10;
     if (var11 == null) {
      // line number 360
      return 0;
     } else {
      // line number 356
      var12 = phi10;
      var13 = ((var12.hash)) | 0;
      var14 = (phi9) | 0;
      If_52_0: {
       if (var13 != var14) {
        break If_52_0;
       } else {
        var15 = phi10;
        var16 = (var15.key);
        var17 = phi8;
        var18 = (var16.Z$equals$Ljava$lang$Object$(var17));
        if (var18 == 0) {
         break If_52_0;
        } else {
         // line number 357
         return 1;
        }
       }
      }
      // line number 355
      var19 = phi10;
      var20 = (var19.next);
      // Here was a goto statement
      phi10 = var20;
      continue L1456312293;
     }
    }
  }
}

java$util$Hashtable.prototype.Ljava$lang$Object$$computeIfAbsent$Ljava$lang$Object$$Ljava$util$function$Function$ = java$util$Map.prototype.Ljava$lang$Object$$computeIfAbsent$Ljava$lang$Object$$Ljava$util$function$Function$;

class java$util$concurrent$ConcurrentMap extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$concurrent$ConcurrentMap,[java$lang$Object,java$util$concurrent$ConcurrentMap,java$util$Map]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}

java$util$concurrent$ConcurrentMap.prototype.Ljava$lang$Object$$computeIfAbsent$Ljava$lang$Object$$Ljava$util$function$Function$ = java$util$Map.prototype.Ljava$lang$Object$$computeIfAbsent$Ljava$lang$Object$$Ljava$util$function$Function$;

class java$lang$reflect$ParameterizedType extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$reflect$ParameterizedType,[java$lang$reflect$ParameterizedType,java$lang$Object,java$lang$reflect$Type]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class java$util$HashMap$EntryIterator extends java$util$HashMap$HashIterator {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$HashMap$EntryIterator,[java$util$Iterator,java$lang$Object,java$util$HashMap$HashIterator,java$util$HashMap$EntryIterator]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Ljava$util$HashMap$(arg0) {
    // source file is HashMap.java
    var var0 = null;
    var var1 = null;
    var0 = arg0;
    // line number 1636
    var1 = var0;
    java$util$HashMap$HashIterator.prototype.V$$init$$Ljava$util$HashMap$.call(this,var1);
    return;
  }

  Ljava$lang$Object$$next$$() {
    // source file is HashMap.java
    var var0 = null;
    // line number 1636
    var0 = (java$util$HashMap$EntryIterator.prototype.Ljava$util$Map$Entry$$next$$.call(this));
    return var0;
  }

  Ljava$util$Map$Entry$$next$$() {
    // source file is HashMap.java
    var var0 = null;
    // line number 1638
    var0 = (this.Ljava$util$HashMap$Node$$nextNode$$());
    return var0;
  }
}


class org$luaj$vm2$compiler$Constants extends org$luaj$vm2$Lua {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$compiler$Constants,[java$lang$Object,org$luaj$vm2$Lua,org$luaj$vm2$compiler$Constants]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      org$luaj$vm2$Lua.$i;
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    org$luaj$vm2$Lua.prototype.V$$init$$$.call(this);
    return;
  }

  static V$_assert$Z(arg0) {
    var var0 = null;
    var var1 = null;
    if (arg0 != 0) {
     return;
    } else {
     var0 = new org$luaj$vm2$LuaError();
     var1 = bytecoder.stringconstants[328];
     org$luaj$vm2$LuaError.prototype.V$$init$$Ljava$lang$String$.call(var0,var1);
     throw bytecoder.registerStack(var0, new Error().stack);
    }
  }

  static $Lorg$luaj$vm2$Upvaldesc$$realloc$$Lorg$luaj$vm2$Upvaldesc$$I(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var phi8 = null;
    var phi9 = 0;
    var phi10 = null;
    var var11 = null;
    var0 = (arg1) | 0;
    var1 = bytecoder.newarray((var0),null);
    var2 = arg0;
    If_10_0: {
     if (var2 == null) {
      phi8 = arg0;
      phi9 = (var0) | 0;
      phi10 = var1;
      break If_10_0;
     } else {
      var3 = arg0;
      var4 = var1;
      var5 = arg0;
      var6 = (var5.data.length) | 0;
      java$lang$Math.$i;
      var7 = ((java$lang$Math.I$min$I$I(var6,var0))) | 0;
      java$lang$System.V$arraycopy$Ljava$lang$Object$$I$Ljava$lang$Object$$I$I(var3,0,var4,0,var7);
      phi8 = arg0;
      phi9 = (var0) | 0;
      phi10 = var1;
      break If_10_0;
     }
    }
    var11 = phi10;
    return var11;
  }

  static $C$realloc$$C$I(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var phi8 = null;
    var phi9 = 0;
    var phi10 = null;
    var var11 = null;
    var0 = (arg1) | 0;
    var1 = bytecoder.newarray((var0),0);
    var2 = arg0;
    If_10_0: {
     if (var2 == null) {
      phi8 = arg0;
      phi9 = (var0) | 0;
      phi10 = var1;
      break If_10_0;
     } else {
      var3 = arg0;
      var4 = var1;
      var5 = arg0;
      var6 = (var5.data.length) | 0;
      java$lang$Math.$i;
      var7 = ((java$lang$Math.I$min$I$I(var6,var0))) | 0;
      java$lang$System.V$arraycopy$$C$I$$C$I$I(var3,0,var4,0,var7);
      phi8 = arg0;
      phi9 = (var0) | 0;
      phi10 = var1;
      break If_10_0;
     }
    }
    var11 = phi10;
    return var11;
  }

  static $Lorg$luaj$vm2$LuaValue$$realloc$$Lorg$luaj$vm2$LuaValue$$I(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var phi8 = null;
    var phi9 = 0;
    var phi10 = null;
    var var11 = null;
    var0 = (arg1) | 0;
    var1 = bytecoder.newarray((var0),null);
    var2 = arg0;
    If_10_0: {
     if (var2 == null) {
      phi8 = arg0;
      phi9 = (var0) | 0;
      phi10 = var1;
      break If_10_0;
     } else {
      var3 = arg0;
      var4 = var1;
      var5 = arg0;
      var6 = (var5.data.length) | 0;
      java$lang$Math.$i;
      var7 = ((java$lang$Math.I$min$I$I(var6,var0))) | 0;
      java$lang$System.V$arraycopy$Ljava$lang$Object$$I$Ljava$lang$Object$$I$I(var3,0,var4,0,var7);
      phi8 = arg0;
      phi9 = (var0) | 0;
      phi10 = var1;
      break If_10_0;
     }
    }
    var11 = phi10;
    return var11;
  }

  static V$SETARG_B$Lorg$luaj$vm2$compiler$InstructionPtr$$I(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var0 = (arg1) | 0;
    var1 = arg0;
    var2 = ((org$luaj$vm2$compiler$InstructionPtr.prototype.I$get$$.call(var1))) | 0;
    var3 = ((var2 & 8388607)) | 0;
    var4 = (23) | 0;
    var5 = ((var0 << var4)) | 0;
    var6 = ((var5 & -8388608)) | 0;
    var7 = ((var3 | var6)) | 0;
    org$luaj$vm2$compiler$InstructionPtr.prototype.V$set$I.call(arg0,var7);
    return;
  }

  static I$CREATE_ABC$I$I$I$I(arg0,arg1,arg2,arg3) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = 0;
    var0 = (arg1) | 0;
    var1 = (arg3) | 0;
    var2 = (0) | 0;
    var3 = ((arg0 << var2)) | 0;
    var4 = ((var3 & 63)) | 0;
    var5 = (6) | 0;
    var6 = ((var0 << var5)) | 0;
    var7 = ((var6 & 16320)) | 0;
    var8 = ((var4 | var7)) | 0;
    var9 = (23) | 0;
    var10 = ((arg2 << var9)) | 0;
    var11 = ((var10 & -8388608)) | 0;
    var12 = ((var8 | var11)) | 0;
    var13 = (14) | 0;
    var14 = ((var1 << var13)) | 0;
    var15 = ((var14 & 8372224)) | 0;
    var16 = ((var12 | var15)) | 0;
    return var16;
  }

  static V$SETARG_A$Lorg$luaj$vm2$compiler$InstructionPtr$$I(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var0 = (arg1) | 0;
    var1 = arg0;
    var2 = ((org$luaj$vm2$compiler$InstructionPtr.prototype.I$get$$.call(var1))) | 0;
    var3 = ((var2 & -16321)) | 0;
    var4 = (6) | 0;
    var5 = ((var0 << var4)) | 0;
    var6 = ((var5 & 16320)) | 0;
    var7 = ((var3 | var6)) | 0;
    org$luaj$vm2$compiler$InstructionPtr.prototype.V$set$I.call(arg0,var7);
    return;
  }

  static V$SETARG_sBx$Lorg$luaj$vm2$compiler$InstructionPtr$$I(arg0,arg1) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var0 = (arg1) | 0;
    var1 = (var0) | 0;
    var2 = ((var1 + 131071)) | 0;
    org$luaj$vm2$compiler$Constants.$i;
    org$luaj$vm2$compiler$Constants.V$SETARG_Bx$Lorg$luaj$vm2$compiler$InstructionPtr$$I(arg0,var2);
    return;
  }

  static V$SETARG_Bx$Lorg$luaj$vm2$compiler$InstructionPtr$$I(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var0 = (arg1) | 0;
    var1 = arg0;
    var2 = ((org$luaj$vm2$compiler$InstructionPtr.prototype.I$get$$.call(var1))) | 0;
    var3 = ((var2 & 16383)) | 0;
    var4 = (14) | 0;
    var5 = ((var0 << var4)) | 0;
    var6 = ((var5 & -16384)) | 0;
    var7 = ((var3 | var6)) | 0;
    org$luaj$vm2$compiler$InstructionPtr.prototype.V$set$I.call(arg0,var7);
    return;
  }

  static $I$realloc$$I$I(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var phi8 = null;
    var phi9 = 0;
    var phi10 = null;
    var var11 = null;
    var0 = (arg1) | 0;
    var1 = bytecoder.newarray((var0),0);
    var2 = arg0;
    If_10_0: {
     if (var2 == null) {
      phi8 = arg0;
      phi9 = (var0) | 0;
      phi10 = var1;
      break If_10_0;
     } else {
      var3 = arg0;
      var4 = var1;
      var5 = arg0;
      var6 = (var5.data.length) | 0;
      java$lang$Math.$i;
      var7 = ((java$lang$Math.I$min$I$I(var6,var0))) | 0;
      java$lang$System.V$arraycopy$$I$I$$I$I$I(var3,0,var4,0,var7);
      phi8 = arg0;
      phi9 = (var0) | 0;
      phi10 = var1;
      break If_10_0;
     }
    }
    var11 = phi10;
    return var11;
  }

  static I$CREATE_ABx$I$I$I(arg0,arg1,arg2) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var0 = (arg1) | 0;
    var1 = (0) | 0;
    var2 = ((arg0 << var1)) | 0;
    var3 = ((var2 & 63)) | 0;
    var4 = (6) | 0;
    var5 = ((var0 << var4)) | 0;
    var6 = ((var5 & 16320)) | 0;
    var7 = ((var3 | var6)) | 0;
    var8 = (14) | 0;
    var9 = ((arg2 << var8)) | 0;
    var10 = ((var9 & -16384)) | 0;
    var11 = ((var7 | var10)) | 0;
    return var11;
  }

  static $Lorg$luaj$vm2$Prototype$$realloc$$Lorg$luaj$vm2$Prototype$$I(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var phi8 = null;
    var phi9 = 0;
    var phi10 = null;
    var var11 = null;
    var0 = (arg1) | 0;
    var1 = bytecoder.newarray((var0),null);
    var2 = arg0;
    If_10_0: {
     if (var2 == null) {
      phi8 = arg0;
      phi9 = (var0) | 0;
      phi10 = var1;
      break If_10_0;
     } else {
      var3 = arg0;
      var4 = var1;
      var5 = arg0;
      var6 = (var5.data.length) | 0;
      java$lang$Math.$i;
      var7 = ((java$lang$Math.I$min$I$I(var6,var0))) | 0;
      java$lang$System.V$arraycopy$Ljava$lang$Object$$I$Ljava$lang$Object$$I$I(var3,0,var4,0,var7);
      phi8 = arg0;
      phi9 = (var0) | 0;
      phi10 = var1;
      break If_10_0;
     }
    }
    var11 = phi10;
    return var11;
  }

  static $Lorg$luaj$vm2$LocVars$$realloc$$Lorg$luaj$vm2$LocVars$$I(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var phi8 = null;
    var phi9 = 0;
    var phi10 = null;
    var var11 = null;
    var0 = (arg1) | 0;
    var1 = bytecoder.newarray((var0),null);
    var2 = arg0;
    If_10_0: {
     if (var2 == null) {
      phi8 = arg0;
      phi9 = (var0) | 0;
      phi10 = var1;
      break If_10_0;
     } else {
      var3 = arg0;
      var4 = var1;
      var5 = arg0;
      var6 = (var5.data.length) | 0;
      java$lang$Math.$i;
      var7 = ((java$lang$Math.I$min$I$I(var6,var0))) | 0;
      java$lang$System.V$arraycopy$Ljava$lang$Object$$I$Ljava$lang$Object$$I$I(var3,0,var4,0,var7);
      phi8 = arg0;
      phi9 = (var0) | 0;
      phi10 = var1;
      break If_10_0;
     }
    }
    var11 = phi10;
    return var11;
  }

  static $Lorg$luaj$vm2$compiler$LexState$Vardesc$$realloc$$Lorg$luaj$vm2$compiler$LexState$Vardesc$$I(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var phi8 = null;
    var phi9 = 0;
    var phi10 = null;
    var var11 = null;
    var0 = (arg1) | 0;
    var1 = bytecoder.newarray((var0),null);
    var2 = arg0;
    If_10_0: {
     if (var2 == null) {
      phi8 = arg0;
      phi9 = (var0) | 0;
      phi10 = var1;
      break If_10_0;
     } else {
      var3 = arg0;
      var4 = var1;
      var5 = arg0;
      var6 = (var5.data.length) | 0;
      java$lang$Math.$i;
      var7 = ((java$lang$Math.I$min$I$I(var6,var0))) | 0;
      java$lang$System.V$arraycopy$Ljava$lang$Object$$I$Ljava$lang$Object$$I$I(var3,0,var4,0,var7);
      phi8 = arg0;
      phi9 = (var0) | 0;
      phi10 = var1;
      break If_10_0;
     }
    }
    var11 = phi10;
    return var11;
  }

  static V$SETARG_A$$I$I$I(arg0,arg1,arg2) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var0 = (arg1) | 0;
    var1 = (var0) | 0;
    var2 = ((arg0.data[var0])) | 0;
    var3 = ((var2 & -16321)) | 0;
    var4 = (6) | 0;
    var5 = ((arg2 << var4)) | 0;
    var6 = ((var5 & 16320)) | 0;
    var7 = ((var3 | var6)) | 0;
    arg0.data[var1] = var7;
    return;
  }

  static $Lorg$luaj$vm2$compiler$LexState$Labeldesc$$grow$$Lorg$luaj$vm2$compiler$LexState$Labeldesc$$I(arg0,arg1) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var phi3 = null;
    var phi4 = 0;
    var phi5 = null;
    var var6 = 0;
    var var7 = null;
    var var8 = 0;
    var var9 = 0;
    var var10 = null;
    var0 = (arg1) | 0;
    If_5_0: {
     if (arg0 != null) {
      var6 = (arg0.data.length) | 0;
      if (var6 >= var0) {
       phi3 = arg0;
       phi4 = (var0) | 0;
       phi5 = arg0;
       break If_5_0;
      } else {
       var7 = arg0;
       var8 = (arg0.data.length) | 0;
       var9 = ((var8 * 2)) | 0;
       org$luaj$vm2$compiler$Constants.$i;
       var10 = (org$luaj$vm2$compiler$Constants.$Lorg$luaj$vm2$compiler$LexState$Labeldesc$$realloc$$Lorg$luaj$vm2$compiler$LexState$Labeldesc$$I(var7,var9));
       // Here was a goto statement
       phi3 = arg0;
       phi4 = (var0) | 0;
       phi5 = var10;
       break If_5_0;
      }
     } else {
      var1 = (2) | 0;
      var2 = bytecoder.newarray((var1),null);
      // Here was a goto statement
      phi3 = arg0;
      phi4 = (var0) | 0;
      phi5 = var2;
      break If_5_0;
     }
    }
    return phi5;
  }

  static $Lorg$luaj$vm2$compiler$LexState$Labeldesc$$realloc$$Lorg$luaj$vm2$compiler$LexState$Labeldesc$$I(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var phi8 = null;
    var phi9 = 0;
    var phi10 = null;
    var var11 = null;
    var0 = (arg1) | 0;
    var1 = bytecoder.newarray((var0),null);
    var2 = arg0;
    If_10_0: {
     if (var2 == null) {
      phi8 = arg0;
      phi9 = (var0) | 0;
      phi10 = var1;
      break If_10_0;
     } else {
      var3 = arg0;
      var4 = var1;
      var5 = arg0;
      var6 = (var5.data.length) | 0;
      java$lang$Math.$i;
      var7 = ((java$lang$Math.I$min$I$I(var6,var0))) | 0;
      java$lang$System.V$arraycopy$Ljava$lang$Object$$I$Ljava$lang$Object$$I$I(var3,0,var4,0,var7);
      phi8 = arg0;
      phi9 = (var0) | 0;
      phi10 = var1;
      break If_10_0;
     }
    }
    var11 = phi10;
    return var11;
  }

  static V$SETARG_C$Lorg$luaj$vm2$compiler$InstructionPtr$$I(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var0 = (arg1) | 0;
    var1 = arg0;
    var2 = ((org$luaj$vm2$compiler$InstructionPtr.prototype.I$get$$.call(var1))) | 0;
    var3 = ((var2 & -8372225)) | 0;
    var4 = (14) | 0;
    var5 = ((var0 << var4)) | 0;
    var6 = ((var5 & 8372224)) | 0;
    var7 = ((var3 | var6)) | 0;
    org$luaj$vm2$compiler$InstructionPtr.prototype.V$set$I.call(arg0,var7);
    return;
  }

  static V$SET_OPCODE$Lorg$luaj$vm2$compiler$InstructionPtr$$I(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var0 = (arg1) | 0;
    var1 = arg0;
    var2 = ((org$luaj$vm2$compiler$InstructionPtr.prototype.I$get$$.call(var1))) | 0;
    var3 = ((var2 & -64)) | 0;
    var4 = (0) | 0;
    var5 = ((var0 << var4)) | 0;
    var6 = ((var5 & 63)) | 0;
    var7 = ((var3 | var6)) | 0;
    org$luaj$vm2$compiler$InstructionPtr.prototype.V$set$I.call(arg0,var7);
    return;
  }
}


class java$util$HashMap$Node extends java$lang$Object {
  nativeObject = null;

  next = null;
  hash = 0;
  key = null;
  value = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$HashMap$Node,[java$lang$Object,java$util$Map$Entry,java$util$HashMap$Node]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$I$Ljava$lang$Object$$Ljava$lang$Object$$Ljava$util$HashMap$Node$(arg0,arg1,arg2,arg3) {
    // source file is HashMap.java
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var0 = (arg0) | 0;
    var1 = arg2;
    // line number 287
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 288
    var2 = this;
    var2.hash = var0;
    // line number 289
    var3 = this;
    var3.key = arg1;
    // line number 290
    var4 = this;
    var4.value = var1;
    // line number 291
    var5 = this;
    var5.next = arg3;
    // line number 292
    return;
  }

  Ljava$lang$String$$toString$$() {
    // source file is HashMap.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    // line number 296
    var0 = new java$lang$StringBuilder();
    java$lang$StringBuilder.prototype.V$$init$$$.call(var0);
    var1 = (this.key);
    var2 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$Object$.call(var0,var1));
    var3 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var2,bytecoder.stringconstants[155]));
    var4 = (this.value);
    var5 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$Object$.call(var3,var4));
    var6 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var5));
    return var6;
  }

  Z$equals$Ljava$lang$Object$(arg0) {
    // source file is HashMap.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = 0;
    var var11 = 0;
    var phi12 = null;
    var phi13 = null;
    var phi14 = null;
    var phi15 = 0;
    var phi16 = null;
    var phi17 = null;
    var phi18 = null;
    var0 = arg0;
    // line number 309
    var1 = this;
    if (var0 != var1) {
     // line number 314
     var2 = (bytecoder.instanceOf(var0,java$util$Map$Entry)) | 0;
     If_22_0: {
      If_22_1: {
       if (var2 == 0) {
        phi16 = this;
        phi17 = var0;
        break If_22_1;
       } else {
        // line number 312
        var3 = var0;
        var4 = (this.key);
        // line number 313
        var5 = (var3.Ljava$lang$Object$$getKey$$());
        var6 = (java$util$Objects.Z$equals$Ljava$lang$Object$$Ljava$lang$Object$(var4,var5));
        if (var6 == 0) {
         phi16 = this;
         phi17 = var0;
         phi18 = var3;
         break If_22_1;
        } else {
         var7 = this;
         var8 = (var7.value);
         // line number 314
         var9 = (var3.Ljava$lang$Object$$getValue$$());
         var10 = (java$util$Objects.Z$equals$Ljava$lang$Object$$Ljava$lang$Object$(var8,var9));
         if (var10 == 0) {
          phi16 = this;
          phi17 = var0;
          phi18 = var3;
          break If_22_1;
         } else {
          var11 = (1) | 0;
          // Here was a goto statement
          phi12 = this;
          phi13 = var0;
          phi14 = var3;
          phi15 = (var11) | 0;
          break If_22_0;
         }
        }
       }
      }
      phi12 = phi16;
      phi13 = phi17;
      phi14 = phi18;
      phi15 = (0) | 0;
      break If_22_0;
     }
     // line number 312
     return phi15;
    } else {
     // line number 310
     return 1;
    }
  }

  I$hashCode$$() {
    // source file is HashMap.java
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    // line number 299
    var0 = (this.key);
    var1 = ((java$util$Objects.I$hashCode$Ljava$lang$Object$(var0))) | 0;
    var2 = (this.value);
    var3 = ((java$util$Objects.I$hashCode$Ljava$lang$Object$(var2))) | 0;
    var4 = ((var1 ^ var3)) | 0;
    return var4;
  }

  Ljava$lang$Object$$getKey$$() {
    // source file is HashMap.java
    var var0 = null;
    // line number 294
    var0 = (this.key);
    return var0;
  }

  Ljava$lang$Object$$getValue$$() {
    // source file is HashMap.java
    var var0 = null;
    // line number 295
    var0 = (this.value);
    return var0;
  }
}


class de$mirkosertic$bytecoder$classlib$BytecoderCharsetEncoder extends java$nio$charset$CharsetEncoder {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(de$mirkosertic$bytecoder$classlib$BytecoderCharsetEncoder,[java$lang$Object,de$mirkosertic$bytecoder$classlib$BytecoderCharsetEncoder,java$nio$charset$CharsetEncoder]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      java$nio$charset$CharsetEncoder.$i;
    }
    return this;
  }

  set $lambdaimpl(impl) {
    this.Ljava$nio$charset$CoderResult$$encodeLoop$Ljava$nio$CharBuffer$$Ljava$nio$ByteBuffer$ = impl;
  }

  V$$init$$Ljava$nio$charset$Charset$(arg0) {
    // source file is BytecoderCharsetEncoder.java
    var var0 = null;
    var var1 = null;
    var var2 = .0;
    var0 = arg0;
    // line number 27
    var1 = var0;
    var2 = 3.0;
    java$nio$charset$CharsetEncoder.prototype.V$$init$$Ljava$nio$charset$Charset$$F$F.call(this,var1,1.1,var2);
    // line number 28
    return;
  }

  Ljava$nio$charset$CoderResult$$encodeLoop$Ljava$nio$CharBuffer$$Ljava$nio$ByteBuffer$(arg0,arg1) {
    // source file is BytecoderCharsetEncoder.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var phi13 = null;
    var phi14 = null;
    var phi15 = null;
    var phi16 = null;
    var phi17 = null;
    var var18 = null;
    var0 = arg0;
    // line number 32
    var1 = (this.Ljava$nio$charset$Charset$$charset$$());
    // line number 33
    var2 = (var0.Z$hasRemaining$$());
    If_16_0: {
     if (var2 == 0) {
      phi13 = this;
      phi14 = var0;
      phi15 = arg1;
      phi16 = var1;
      break If_16_0;
     } else {
      // line number 34
      var3 = ((var0.I$remaining$$())) | 0;
      // line number 35
      var4 = bytecoder.newarray((var3),0);
      // line number 37
      var5 = var4;
      var6 = (var3) | 0;
      var7 = (var0.Ljava$nio$CharBuffer$$get$$C$I$I(var5,0,var6));
      // line number 39
      var8 = var1;
      var9 = (java$nio$charset$Charset.prototype.Ljava$lang$String$$name$$.call(var8));
      var10 = (de$mirkosertic$bytecoder$classlib$BytecoderCharsetEncoder.prototype.$B$encodeToBytes$Ljava$lang$String$$$C.call(this,var9,var4));
      // line number 40
      var11 = var10;
      var12 = (java$nio$ByteBuffer.prototype.Ljava$nio$ByteBuffer$$put$$B.call(arg1,var11));
      phi13 = this;
      phi14 = var0;
      phi15 = arg1;
      phi16 = var1;
      phi17 = var4;
      break If_16_0;
     }
    }
    // line number 42
    java$nio$charset$CoderResult.$i;
    var18 = (java$nio$charset$CoderResult.UNDERFLOW);
    return var18;
  }

  $B$encodeToBytes$Ljava$lang$String$$$C(arg0,arg1) {
    return bytecoder.imports['de.mirkosertic.bytecoder.classlib.BytecoderCharsetEncoder'].$B$encodeToBytes$Ljava$lang$String$$$C(this, arg0, arg1);
  }
}


class java$lang$StringBuilder extends java$lang$AbstractStringBuilder {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$StringBuilder,[java$lang$Object,java$lang$StringBuilder,java$lang$AbstractStringBuilder,java$lang$CharSequence]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.I$length$$ = impl;
  }

  V$$init$$$() {
    // source file is StringBuilder.java
    var var0 = 0;
    // line number 9
    var0 = (10) | 0;
    java$lang$StringBuilder.prototype.V$$init$$I.call(this,var0);
    // line number 10
    return;
  }

  V$$init$$I(arg0) {
    // source file is StringBuilder.java
    var var0 = 0;
    var0 = (arg0) | 0;
    // line number 12
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 13
    java$lang$StringBuilder.prototype.V$initializeWith$I.call(this,var0);
    // line number 14
    return;
  }

  V$initializeWith$I(arg0) {
    bytecoder.imports['java.lang.StringBuilder'].V$initializeWith$I(this, arg0);
  }

  Ljava$lang$StringBuilder$$append$Ljava$lang$String$(arg0) {
    return bytecoder.imports['java.lang.StringBuilder'].Ljava$lang$StringBuilder$$append$Ljava$lang$String$(this, arg0);
  }

  Ljava$lang$StringBuilder$$append$I(arg0) {
    // source file is StringBuilder.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var0 = (arg0) | 0;
    // line number 38
    var1 = (var0) | 0;
    java$lang$Integer.$i;
    var2 = (java$lang$Integer.Ljava$lang$String$$toString$I(var1));
    var3 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(this,var2));
    return var3;
  }

  Ljava$lang$String$$toString$$() {
    return bytecoder.imports['java.lang.StringBuilder'].Ljava$lang$String$$toString$$(this);
  }

  Ljava$lang$StringBuilder$$append$F(arg0) {
    // source file is StringBuilder.java
    var var0 = .0;
    var var1 = .0;
    var var2 = null;
    var var3 = null;
    var0 = arg0;
    // line number 46
    var1 = var0;
    java$lang$Float.$i;
    var2 = (java$lang$Float.Ljava$lang$String$$toString$F(var1));
    var3 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(this,var2));
    return var3;
  }

  Ljava$lang$StringBuilder$$append$Ljava$lang$Object$(arg0) {
    // source file is StringBuilder.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var0 = arg0;
    // line number 58
    if (var0 == null) {
     // line number 61
     var3 = bytecoder.stringconstants[0];
     var4 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(this,var3));
     return var4;
    } else {
     // line number 59
     var1 = (var0.Ljava$lang$String$$toString$$());
     var2 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(this,var1));
     return var2;
    }
  }

  Ljava$lang$StringBuilder$$append$C(arg0) {
    // source file is StringBuilder.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var0 = arg0;
    // line number 30
    var1 = var0;
    var2 = (java$lang$Character.Ljava$lang$String$$toString$C(var1));
    var3 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(this,var2));
    return var3;
  }
}

java$lang$StringBuilder.prototype.Z$isEmpty$$ = java$lang$CharSequence.prototype.Z$isEmpty$$;

class jdk$internal$util$Preconditions$1 extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(jdk$internal$util$Preconditions$1,[java$lang$Object,java$util$function$Function,jdk$internal$util$Preconditions$1]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.Ljava$lang$Object$$apply$Ljava$lang$Object$ = impl;
  }

  V$$init$$$() {
    // source file is Preconditions.java
    // line number 52
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }

  Ljava$lang$Object$$apply$Ljava$lang$Object$(arg0) {
    // source file is Preconditions.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var0 = arg0;
    // line number 52
    var1 = var0;
    var2 = var1;
    var3 = (jdk$internal$util$Preconditions$1.prototype.Ljava$lang$StringIndexOutOfBoundsException$$apply$Ljava$lang$String$.call(this,var2));
    return var3;
  }

  Ljava$lang$StringIndexOutOfBoundsException$$apply$Ljava$lang$String$(arg0) {
    // source file is Preconditions.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    // line number 55
    var1 = new java$lang$StringIndexOutOfBoundsException();
    var2 = var0;
    java$lang$StringIndexOutOfBoundsException.prototype.V$$init$$Ljava$lang$String$.call(var1,var2);
    return var1;
  }
}


class java$lang$StringBuffer extends java$lang$AbstractStringBuilder {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$StringBuffer,[java$lang$Object,java$lang$AbstractStringBuilder,java$lang$StringBuffer]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is StringBuffer.java
    var var0 = 0;
    // line number 24
    var0 = (10) | 0;
    java$lang$StringBuffer.prototype.V$$init$$I.call(this,var0);
    // line number 25
    return;
  }

  V$$init$$I(arg0) {
    // source file is StringBuffer.java
    var var0 = 0;
    var0 = (arg0) | 0;
    // line number 27
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 28
    java$lang$StringBuffer.prototype.V$initializeWith$I.call(this,var0);
    // line number 29
    return;
  }

  V$initializeWith$I(arg0) {
    bytecoder.imports['java.lang.StringBuffer'].V$initializeWith$I(this, arg0);
  }

  Ljava$lang$StringBuffer$$append$Ljava$lang$String$(arg0) {
    return bytecoder.imports['java.lang.StringBuffer'].Ljava$lang$StringBuffer$$append$Ljava$lang$String$(this, arg0);
  }

  Ljava$lang$StringBuffer$$append$Ljava$lang$Object$(arg0) {
    // source file is StringBuffer.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var0 = arg0;
    // line number 69
    if (var0 != null) {
     // line number 72
     var3 = (var0.Ljava$lang$String$$toString$$());
     var4 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(this,var3));
     return var4;
    } else {
     // line number 70
     var1 = bytecoder.stringconstants[0];
     var2 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(this,var1));
     return var2;
    }
  }

  Ljava$lang$String$$toString$$() {
    return bytecoder.imports['java.lang.StringBuffer'].Ljava$lang$String$$toString$$(this);
  }

  Ljava$lang$StringBuffer$$append$I(arg0) {
    // source file is StringBuffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var0 = (arg0) | 0;
    // line number 53
    var1 = (var0) | 0;
    java$lang$Integer.$i;
    var2 = (java$lang$Integer.Ljava$lang$String$$toString$I(var1));
    var3 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(this,var2));
    return var3;
  }

  Ljava$lang$StringBuffer$$append$C(arg0) {
    // source file is StringBuffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var0 = arg0;
    // line number 45
    var1 = var0;
    var2 = (java$lang$Character.Ljava$lang$String$$toString$C(var1));
    var3 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(this,var2));
    return var3;
  }
}


class java$util$AbstractMap extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$AbstractMap,[java$lang$Object,java$util$AbstractMap,java$util$Map]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is AbstractMap.java
    // line number 72
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 73
    return;
  }

  Ljava$lang$String$$toString$$() {
    // source file is AbstractMap.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var phi5 = null;
    var phi6 = null;
    var phi7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var phi16 = null;
    var phi17 = null;
    var phi18 = null;
    var phi19 = null;
    var phi20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var phi28 = null;
    var phi29 = null;
    var var30 = null;
    var var31 = null;
    var var32 = 0;
    var var33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = null;
    var var37 = null;
    var var38 = null;
    var var39 = null;
    // line number 540
    var0 = (this.Ljava$util$Set$$entrySet$$());
    var1 = (var0.Ljava$util$Iterator$$iterator$$());
    // line number 541
    var2 = (var1.Z$hasNext$$());
    if (var2 != 0) {
     // line number 544
     var3 = new java$lang$StringBuilder();
     java$lang$StringBuilder.prototype.V$$init$$$.call(var3);
     // line number 545
     var4 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$C.call(var3,123));
     phi5 = this;
     phi6 = var1;
     phi7 = var3;
     L1930748928: while(true) {
      // line number 547
      var8 = phi6;
      var9 = (var8.Ljava$lang$Object$$next$$());
      var10 = var9;
      // line number 548
      var11 = (var10.Ljava$lang$Object$$getKey$$());
      // line number 549
      var12 = (var10.Ljava$lang$Object$$getValue$$());
      // line number 550
      var13 = phi7;
      var14 = phi5;
      If_67_0: {
       if (var11 != var14) {
        phi16 = var10;
        phi17 = var11;
        phi18 = var12;
        phi19 = var13;
        phi20 = var11;
        break If_67_0;
       } else {
        var15 = bytecoder.stringconstants[143];
        // Here was a goto statement
        phi16 = var10;
        phi17 = var11;
        phi18 = var12;
        phi19 = var13;
        phi20 = var15;
        break If_67_0;
       }
      }
      var21 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$Object$.call(phi19,phi20));
      // line number 551
      var22 = phi7;
      var23 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$C.call(var22,61));
      // line number 552
      var24 = phi7;
      var25 = phi18;
      var26 = phi5;
      If_99_0: {
       if (var25 != var26) {
        var39 = phi18;
        phi28 = var24;
        phi29 = var39;
        break If_99_0;
       } else {
        var27 = bytecoder.stringconstants[143];
        // Here was a goto statement
        phi28 = var24;
        phi29 = var27;
        break If_99_0;
       }
      }
      var30 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$Object$.call(phi28,phi29));
      // line number 553
      var31 = phi6;
      var32 = (var31.Z$hasNext$$());
      if (var32 != 0) {
       // line number 555
       var36 = phi7;
       var37 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$C.call(var36,44));
       var38 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$C.call(var37,32));
       // line number 556
       // Here was a goto statement
       continue L1930748928;
      } else {
       // line number 554
       var33 = phi7;
       var34 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$C.call(var33,125));
       var35 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var34));
       return var35;
      }
     }
    } else {
     // line number 542
     return bytecoder.stringconstants[142];
    }
  }

  Z$equals$Ljava$lang$Object$(arg0) {
    // source file is AbstractMap.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = 0;
    var phi7 = null;
    var phi8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var phi12 = null;
    var var13 = null;
    var var14 = 0;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = 0;
    var phi24 = null;
    var phi25 = null;
    var phi26 = null;
    var phi27 = null;
    var phi28 = null;
    var phi29 = null;
    var phi30 = null;
    var phi31 = null;
    var phi32 = null;
    var var33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = null;
    var var37 = 0;
    var0 = arg0;
    // line number 475
    var1 = this;
    if (var0 != var1) {
     // line number 478
     var2 = (bytecoder.instanceOf(var0,java$util$Map)) | 0;
     if (var2 == 0) {
      // line number 479
      return 0;
     } else {
      var3 = var0;
      var4 = var3;
      // Here was a goto statement
      // line number 480
      var5 = ((var4.I$size$$())) | 0;
      var6 = ((this.I$size$$())) | 0;
      if (var5 == var6) {
       phi7 = this;
       phi8 = var4;
       TryCatch_49_0: {
        TryCatch_49_1: {
         try {
          // line number 484
          var9 = phi7;
          var10 = (var9.Ljava$util$Set$$entrySet$$());
          var11 = (var10.Ljava$util$Iterator$$iterator$$());
          phi12 = var11;
          L2063642989: while(true) {
           var13 = phi12;
           var14 = (var13.Z$hasNext$$());
           if (var14 == 0) {
            // line number 497
            // Here was a goto statement
            // line number 499
            return 1;
           } else {
            var15 = phi12;
            var16 = (var15.Ljava$lang$Object$$next$$());
            var17 = var16;
            // line number 485
            var18 = (var17.Ljava$lang$Object$$getKey$$());
            // line number 486
            var19 = (var17.Ljava$lang$Object$$getValue$$());
            // line number 487
            If_99_0: {
             if (var19 != null) {
              phi30 = var17;
              phi31 = var18;
              phi32 = var19;
              TryCatch_137_0: {
               try {
                // line number 491
                var33 = phi32;
                var34 = phi8;
                var35 = phi31;
                var36 = (var34.Ljava$lang$Object$$get$Ljava$lang$Object$(var35));
                var37 = (var33.Z$equals$Ljava$lang$Object$(var36));
                if (var37 != 0) {
                 phi27 = phi30;
                 phi28 = phi31;
                 phi29 = phi32;
                 break If_99_0;
                } else {
                 // line number 492
                 break TryCatch_137_0;
                }
               } catch (__ex) {
                if (__ex instanceof java$lang$ClassCastException) {
                 // line number 495
                 // line number 496
                 return 0;
                }
                if (__ex instanceof java$lang$NullPointerException) {
                 // line number 495
                 // line number 496
                 return 0;
                }
                throw __ex;
               }
              }
              return 0;
             } else {
              // line number 488
              var20 = phi8;
              var21 = (var20.Ljava$lang$Object$$get$Ljava$lang$Object$(var18));
              If_108_0: {
               if (var21 != null) {
                phi24 = var17;
                phi25 = var18;
                phi26 = var19;
                break If_108_0;
               } else {
                var22 = phi8;
                var23 = (var22.Z$containsKey$Ljava$lang$Object$(var18));
                if (var23 != 0) {
                 phi27 = var17;
                 phi28 = var18;
                 phi29 = var19;
                 break If_99_0;
                } else {
                 phi24 = var17;
                 phi25 = var18;
                 phi26 = var19;
                 break If_108_0;
                }
               }
              }
              // line number 489
              break TryCatch_49_1;
             }
            }
            try {
             // line number 494
             // Here was a goto statement
             continue L2063642989;
            } catch (__ex) {
             if (__ex instanceof java$lang$ClassCastException) {
              // line number 495
              // line number 496
              return 0;
             }
             if (__ex instanceof java$lang$NullPointerException) {
              // line number 495
              // line number 496
              return 0;
             }
             throw __ex;
            }
           }
          }
         } catch (__ex) {
          if (__ex instanceof java$lang$ClassCastException) {
           // line number 495
           // line number 496
           return 0;
          }
          if (__ex instanceof java$lang$NullPointerException) {
           // line number 495
           // line number 496
           return 0;
          }
          throw __ex;
         }
        }
        return 0;
       }
       // line number 495
       // line number 496
       return 0;
      } else {
       // line number 481
       return 0;
      }
     }
    } else {
     // line number 476
     return 1;
    }
  }

  I$size$$() {
    // source file is AbstractMap.java
    var var0 = null;
    var var1 = 0;
    // line number 84
    var0 = (this.Ljava$util$Set$$entrySet$$());
    var1 = ((var0.I$size$$())) | 0;
    return var1;
  }

  I$hashCode$$() {
    // source file is AbstractMap.java
    var var0 = null;
    var var1 = null;
    var phi2 = 0;
    var phi3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    // line number 521
    // line number 522
    var0 = (this.Ljava$util$Set$$entrySet$$());
    var1 = (var0.Ljava$util$Iterator$$iterator$$());
    phi2 = (0) | 0;
    phi3 = var1;
    L866550952: while(true) {
     var4 = phi3;
     var5 = (var4.Z$hasNext$$());
     if (var5 == 0) {
      // line number 524
      var12 = (phi2) | 0;
      return var12;
     } else {
      var6 = phi3;
      var7 = (var6.Ljava$lang$Object$$next$$());
      var8 = var7;
      // line number 523
      var9 = (phi2) | 0;
      var10 = ((var8.I$hashCode$$())) | 0;
      var11 = ((var9 + var10)) | 0;
      // Here was a goto statement
      phi2 = (var11) | 0;
      continue L866550952;
     }
    }
  }

  Ljava$lang$Object$$put$Ljava$lang$Object$$Ljava$lang$Object$(arg0,arg1) {
    // source file is AbstractMap.java
    var var0 = null;
    var var1 = null;
    var0 = arg0;
    // line number 208
    var1 = new java$lang$UnsupportedOperationException();
    java$lang$UnsupportedOperationException.prototype.V$$init$$$.call(var1);
    throw bytecoder.registerStack(var1, new Error().stack);
  }
}

java$util$AbstractMap.prototype.Ljava$lang$Object$$computeIfAbsent$Ljava$lang$Object$$Ljava$util$function$Function$ = java$util$Map.prototype.Ljava$lang$Object$$computeIfAbsent$Ljava$lang$Object$$Ljava$util$function$Function$;

class org$luaj$vm2$Varargs$ArrayVarargs extends org$luaj$vm2$Varargs {
  nativeObject = null;

  v = null;
  r = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$Varargs$ArrayVarargs,[java$lang$Object,org$luaj$vm2$Varargs$ArrayVarargs,org$luaj$vm2$Varargs]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$Varargs$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    org$luaj$vm2$Varargs.prototype.V$$init$$$.call(this);
    var1 = this;
    var1.v = var0;
    var2 = this;
    var2.r = arg1;
    return;
  }

  I$narg$$() {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var0 = (this.v);
    var1 = (var0.data.length) | 0;
    var2 = (this.r);
    var3 = ((var2.I$narg$$())) | 0;
    var4 = ((var1 + var3)) | 0;
    return var4;
  }

  Lorg$luaj$vm2$LuaValue$$arg1$$() {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var phi5 = null;
    var phi6 = null;
    var var7 = null;
    var var8 = null;
    var0 = (this.v);
    var1 = (var0.data.length) | 0;
    If_8_0: {
     if (var1 <= 0) {
      var7 = (this.r);
      var8 = (var7.Lorg$luaj$vm2$LuaValue$$arg1$$());
      phi5 = this;
      phi6 = var8;
      break If_8_0;
     } else {
      var2 = this;
      var3 = (var2.v);
      var4 = (var3.data[0]);
      // Here was a goto statement
      phi5 = this;
      phi6 = var4;
      break If_8_0;
     }
    }
    return phi6;
  }

  Lorg$luaj$vm2$LuaValue$$arg$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var phi3 = null;
    var phi4 = 0;
    var phi5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = null;
    var var11 = 0;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = 0;
    var var17 = 0;
    var var18 = null;
    var0 = (arg0) | 0;
    var1 = (1) | 0;
    If_8_0: {
     if (var0 >= var1) {
      var6 = this;
      var7 = (var6.v);
      var8 = (var7.data.length) | 0;
      if (var0 > var8) {
       var13 = (this.r);
       var14 = this;
       var15 = (var14.v);
       var16 = (var15.data.length) | 0;
       var17 = ((var0 - var16)) | 0;
       var18 = (var13.Lorg$luaj$vm2$LuaValue$$arg$I(var17));
       phi3 = this;
       phi4 = (var0) | 0;
       phi5 = var18;
       break If_8_0;
      } else {
       var9 = this;
       var10 = (var9.v);
       var11 = ((var0 - 1)) | 0;
       var12 = (var10.data[var11]);
       // Here was a goto statement
       phi3 = this;
       phi4 = (var0) | 0;
       phi5 = var12;
       break If_8_0;
      }
     } else {
      org$luaj$vm2$LuaValue.$i;
      var2 = (org$luaj$vm2$LuaValue.NIL);
      // Here was a goto statement
      phi3 = this;
      phi4 = (var0) | 0;
      phi5 = var2;
      break If_8_0;
     }
    }
    return phi5;
  }

  V$copyto$$Lorg$luaj$vm2$LuaValue$$I$I(arg0,arg1,arg2) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var0 = arg0;
    var1 = (arg2) | 0;
    var2 = (this.v);
    var3 = (var2.data.length) | 0;
    java$lang$Math.$i;
    var4 = ((java$lang$Math.I$min$I$I(var3,var1))) | 0;
    var5 = this;
    var6 = (var5.v);
    var7 = var0;
    java$lang$System.V$arraycopy$Ljava$lang$Object$$I$Ljava$lang$Object$$I$I(var6,0,var7,arg1,var4);
    var8 = (this.r);
    var9 = (arg1) | 0;
    var10 = ((var9 + var4)) | 0;
    var11 = (var4) | 0;
    var12 = ((var1 - var11)) | 0;
    var8.V$copyto$$Lorg$luaj$vm2$LuaValue$$I$I(var0,var10,var12);
    return;
  }

  Lorg$luaj$vm2$Varargs$$subargs$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var phi3 = null;
    var phi4 = 0;
    var var5 = 0;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = null;
    var var13 = 0;
    var var14 = null;
    var var15 = null;
    var var16 = 0;
    var var17 = 0;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = 0;
    var var22 = 0;
    var var23 = null;
    var var24 = null;
    var var25 = 0;
    var var26 = 0;
    var var27 = 0;
    var var28 = 0;
    var var29 = null;
    var var30 = null;
    var var31 = null;
    var0 = (arg0) | 0;
    If_5_0: {
     if (var0 > 0) {
      phi3 = this;
      phi4 = (var0) | 0;
      break If_5_0;
     } else {
      var1 = (1) | 0;
      org$luaj$vm2$LuaValue.$i;
      var2 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaValue$$argerror$I$Ljava$lang$String$(var1,bytecoder.stringconstants[290]));
      phi3 = this;
      phi4 = (var0) | 0;
      break If_5_0;
     }
    }
    var5 = (phi4) | 0;
    if (var5 != 1) {
     var7 = (phi4) | 0;
     var8 = phi3;
     var9 = (var8.v);
     var10 = (var9.data.length) | 0;
     if (var7 <= var10) {
      var19 = phi3;
      var20 = (var19.v);
      var21 = (phi4) | 0;
      var22 = ((var21 - 1)) | 0;
      var23 = phi3;
      var24 = (var23.v);
      var25 = (var24.data.length) | 0;
      var26 = (phi4) | 0;
      var27 = ((var26 - 1)) | 0;
      var28 = ((var25 - var27)) | 0;
      var29 = phi3;
      var30 = (var29.r);
      org$luaj$vm2$LuaValue.$i;
      var31 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$Varargs$$varargsOf$$Lorg$luaj$vm2$LuaValue$$I$I$Lorg$luaj$vm2$Varargs$(var20,var22,var28,var30));
      return var31;
     } else {
      var11 = phi3;
      var12 = (var11.r);
      var13 = (phi4) | 0;
      var14 = phi3;
      var15 = (var14.v);
      var16 = (var15.data.length) | 0;
      var17 = ((var13 - var16)) | 0;
      var18 = (var12.Lorg$luaj$vm2$Varargs$$subargs$I(var17));
      return var18;
     }
    } else {
     var6 = phi3;
     return var6;
    }
  }
}


class org$luaj$vm2$LuaTable$DeadSlot extends java$lang$Object {
  nativeObject = null;

  key = null;
  next = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$LuaTable$DeadSlot,[org$luaj$vm2$LuaTable$DeadSlot,java$lang$Object,org$luaj$vm2$LuaTable$Slot]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaTable$Slot$$Lorg$luaj$vm2$LuaTable$1$(arg0,arg1,arg2) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    var1 = arg2;
    var2 = var0;
    org$luaj$vm2$LuaTable$DeadSlot.prototype.V$$init$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaTable$Slot$.call(this,var2,arg1);
    return;
  }

  V$$init$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaTable$Slot$(arg0,arg1) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var phi4 = null;
    var phi5 = null;
    var phi6 = null;
    var phi7 = null;
    var phi8 = null;
    var var9 = null;
    var var10 = null;
    var0 = arg0;
    java$lang$Object.prototype.V$$init$$$.call(this);
    org$luaj$vm2$LuaTable.$i;
    var1 = (org$luaj$vm2$LuaTable.Z$isLargeKey$Lorg$luaj$vm2$LuaValue$(var0));
    If_12_0: {
     if (var1 == 0) {
      phi4 = this;
      phi5 = var0;
      phi6 = arg1;
      phi7 = this;
      phi8 = var0;
      break If_12_0;
     } else {
      var2 = new java$lang$ref$WeakReference();
      var3 = var0;
      java$lang$ref$WeakReference.prototype.V$$init$$Ljava$lang$Object$.call(var2,var3);
      // Here was a goto statement
      phi4 = this;
      phi5 = var0;
      phi6 = arg1;
      phi7 = this;
      phi8 = var2;
      break If_12_0;
     }
    }
    phi7.key = phi8;
    var9 = phi4;
    var10 = phi6;
    var9.next = var10;
    return;
  }

  Ljava$lang$String$$toString$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var phi11 = null;
    var phi12 = null;
    var phi13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var0 = new java$lang$StringBuffer();
    java$lang$StringBuffer.prototype.V$$init$$$.call(var0);
    var1 = var0;
    var2 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var1,bytecoder.stringconstants[432]));
    var3 = this;
    var4 = (org$luaj$vm2$LuaTable$DeadSlot.prototype.Lorg$luaj$vm2$LuaValue$$key$$.call(var3));
    var5 = var4;
    If_21_0: {
     if (var5 == null) {
      phi11 = this;
      phi12 = var0;
      phi13 = var4;
      break If_21_0;
     } else {
      var6 = var0;
      var7 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var6,bytecoder.stringconstants[124]));
      var8 = var0;
      var9 = (var4.Ljava$lang$String$$toString$$());
      var10 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var8,var9));
      phi11 = this;
      phi12 = var0;
      phi13 = var4;
      break If_21_0;
     }
    }
    var14 = phi12;
    var15 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$C.call(var14,62));
    var16 = phi11;
    var17 = (var16.next);
    If_52_0: {
     if (var17 == null) {
      break If_52_0;
     } else {
      var18 = phi12;
      var19 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var18,bytecoder.stringconstants[433]));
      var20 = phi12;
      var21 = phi11;
      var22 = (var21.next);
      var23 = (var22.Ljava$lang$String$$toString$$());
      var24 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var20,var23));
      break If_52_0;
     }
    }
    var25 = phi12;
    var26 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var25));
    return var26;
  }

  Lorg$luaj$vm2$LuaValue$$key$$() {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var phi6 = null;
    var phi7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var0 = (this.key);
    var1 = (bytecoder.instanceOf(var0,java$lang$ref$WeakReference)) | 0;
    If_9_0: {
     if (var1 == 0) {
      var10 = (this.key);
      phi6 = this;
      phi7 = var10;
      break If_9_0;
     } else {
      var2 = this;
      var3 = (var2.key);
      var4 = var3;
      var5 = (var4.Ljava$lang$Object$$get$$());
      // Here was a goto statement
      phi6 = this;
      phi7 = var5;
      break If_9_0;
     }
    }
    var8 = phi7;
    var9 = var8;
    return var9;
  }

  Lorg$luaj$vm2$LuaTable$StrongSlot$$find$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var0 = arg0;
    return null;
  }

  Lorg$luaj$vm2$LuaTable$Slot$$rest$$() {
    var var0 = null;
    var0 = (this.next);
    return var0;
  }

  Lorg$luaj$vm2$LuaTable$Slot$$remove$Lorg$luaj$vm2$LuaTable$StrongSlot$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var0 = arg0;
    var1 = (org$luaj$vm2$LuaTable$DeadSlot.prototype.Lorg$luaj$vm2$LuaValue$$key$$.call(this));
    if (var1 == null) {
     var5 = (this.next);
     return var5;
    } else {
     var2 = this;
     var3 = (this.next);
     var4 = (var3.Lorg$luaj$vm2$LuaTable$Slot$$remove$Lorg$luaj$vm2$LuaTable$StrongSlot$(var0));
     var2.next = var4;
     return this;
    }
  }

  Lorg$luaj$vm2$LuaTable$Slot$$set$Lorg$luaj$vm2$LuaTable$StrongSlot$$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var phi6 = null;
    var phi7 = null;
    var phi8 = null;
    var phi9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var0 = arg0;
    var1 = (this.next);
    If_9_0: {
     if (var1 == null) {
      phi6 = this;
      phi7 = var0;
      phi8 = arg1;
      phi9 = null;
      break If_9_0;
     } else {
      var2 = this;
      var3 = (var2.next);
      var4 = arg1;
      var5 = (var3.Lorg$luaj$vm2$LuaTable$Slot$$set$Lorg$luaj$vm2$LuaTable$StrongSlot$$Lorg$luaj$vm2$LuaValue$(var0,var4));
      // Here was a goto statement
      phi6 = this;
      phi7 = var0;
      phi8 = arg1;
      phi9 = var5;
      break If_9_0;
     }
    }
    var10 = phi9;
    var11 = phi6;
    var12 = (org$luaj$vm2$LuaTable$DeadSlot.prototype.Lorg$luaj$vm2$LuaValue$$key$$.call(var11));
    if (var12 == null) {
     return var10;
    } else {
     var13 = phi6;
     var13.next = var10;
     var14 = phi6;
     return var14;
    }
  }

  Lorg$luaj$vm2$LuaTable$StrongSlot$$first$$() {
    var var0 = null;
    var0 = null;
    return var0;
  }

  I$arraykey$I(arg0) {
    var var0 = 0;
    var0 = (arg0) | 0;
    return -1;
  }

  I$keyindex$I(arg0) {
    var var0 = 0;
    var0 = (arg0) | 0;
    return 0;
  }

  Lorg$luaj$vm2$LuaTable$Slot$$relink$Lorg$luaj$vm2$LuaTable$Slot$(arg0) {
    var var0 = null;
    var0 = arg0;
    return var0;
  }

  Lorg$luaj$vm2$LuaTable$Slot$$add$Lorg$luaj$vm2$LuaTable$Slot$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var phi5 = null;
    var phi6 = null;
    var phi7 = null;
    var0 = arg0;
    var1 = (this.next);
    If_8_0: {
     if (var1 == null) {
      phi5 = this;
      phi6 = var0;
      phi7 = var0;
      break If_8_0;
     } else {
      var2 = this;
      var3 = (var2.next);
      var4 = (var3.Lorg$luaj$vm2$LuaTable$Slot$$add$Lorg$luaj$vm2$LuaTable$Slot$(var0));
      // Here was a goto statement
      phi5 = this;
      phi6 = var0;
      phi7 = var4;
      break If_8_0;
     }
    }
    return phi7;
  }
}


class de$mirkosertic$bytecoder$api$web$EventListener extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(de$mirkosertic$bytecoder$api$web$EventListener,[de$mirkosertic$bytecoder$api$Callback,java$lang$Object,de$mirkosertic$bytecoder$api$web$EventListener]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.V$run$Lde$mirkosertic$bytecoder$api$web$Event$ = impl;
  }
}


class org$luaj$vm2$Varargs$PairVarargs extends org$luaj$vm2$Varargs {
  nativeObject = null;

  v1 = null;
  v2 = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$Varargs$PairVarargs,[java$lang$Object,org$luaj$vm2$Varargs$PairVarargs,org$luaj$vm2$Varargs]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$Varargs$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    org$luaj$vm2$Varargs.prototype.V$$init$$$.call(this);
    var1 = this;
    var1.v1 = var0;
    var2 = this;
    var2.v2 = arg1;
    return;
  }

  I$narg$$() {
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var0 = (1) | 0;
    var1 = (this.v2);
    var2 = ((var1.I$narg$$())) | 0;
    var3 = ((var0 + var2)) | 0;
    return var3;
  }

  Lorg$luaj$vm2$LuaValue$$arg1$$() {
    var var0 = null;
    var0 = (this.v1);
    return var0;
  }

  Lorg$luaj$vm2$LuaValue$$arg$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var phi4 = null;
    var phi5 = 0;
    var phi6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = 0;
    var var10 = null;
    var0 = (arg0) | 0;
    var1 = (1) | 0;
    If_8_0: {
     if (var0 != var1) {
      var7 = (this.v2);
      var8 = (1) | 0;
      var9 = ((var0 - var8)) | 0;
      var10 = (var7.Lorg$luaj$vm2$LuaValue$$arg$I(var9));
      phi4 = this;
      phi5 = (var0) | 0;
      phi6 = var10;
      break If_8_0;
     } else {
      var2 = this;
      var3 = (var2.v1);
      // Here was a goto statement
      phi4 = this;
      phi5 = (var0) | 0;
      phi6 = var3;
      break If_8_0;
     }
    }
    return phi6;
  }

  Lorg$luaj$vm2$Varargs$$subargs$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var0 = (arg0) | 0;
    var1 = (1) | 0;
    if (var0 != var1) {
     var3 = (2) | 0;
     if (var0 != var3) {
      if (var0 <= 2) {
       var10 = bytecoder.stringconstants[290];
       org$luaj$vm2$LuaValue.$i;
       var11 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaValue$$argerror$I$Ljava$lang$String$(1,var10));
       return var11;
      } else {
       var6 = this;
       var7 = (var6.v2);
       var8 = ((var0 - 1)) | 0;
       var9 = (var7.Lorg$luaj$vm2$Varargs$$subargs$I(var8));
       return var9;
      }
     } else {
      var4 = this;
      var5 = (var4.v2);
      return var5;
     }
    } else {
     var2 = this;
     return var2;
    }
  }
}


class java$util$ImmutableCollections$MapN$MapNIterator extends java$lang$Object {
  nativeObject = null;

  this$0 = null;
  remaining = 0;
  idx = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$ImmutableCollections$MapN$MapNIterator,[java$util$ImmutableCollections$MapN$MapNIterator,java$util$Iterator,java$lang$Object]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Ljava$util$ImmutableCollections$MapN$(arg0) {
    // source file is ImmutableCollections.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = null;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var0 = this;
    // line number 1259
    var1 = arg0;
    var0.this$0 = var1;
    java$lang$Object.prototype.V$$init$$$.call(var0);
    // line number 1260
    var2 = ((arg0.size)) | 0;
    var0.remaining = var2;
    // line number 1263
    java$util$ImmutableCollections.$i;
    var3 = (java$util$ImmutableCollections.SALT32L);
    var4 = (arg0.table);
    var5 = (var4.data.length) | 0;
    var6 = ((var5 >> 1)) | 0;
    var7 = (var6 | 0);
    var8 = (var3 * var7);
    var9 = (var8 >>> 32);
    var10 = ((var9 | 0)) | 0;
    var11 = ((var10 << 1)) | 0;
    var0.idx = var11;
    // line number 1264
    return;
  }

  Z$hasNext$$() {
    // source file is ImmutableCollections.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    // line number 1268
    var0 = ((this.remaining)) | 0;
    If_7_0: {
     if (var0 <= 0) {
      phi2 = this;
      phi3 = (0) | 0;
      break If_7_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = this;
      phi3 = (var1) | 0;
      break If_7_0;
     }
    }
    return phi3;
  }

  Ljava$lang$Object$$next$$() {
    // source file is ImmutableCollections.java
    var var0 = null;
    // line number 1253
    var0 = (java$util$ImmutableCollections$MapN$MapNIterator.prototype.Ljava$util$Map$Entry$$next$$.call(this));
    return var0;
  }

  Ljava$util$Map$Entry$$next$$() {
    // source file is ImmutableCollections.java
    var var0 = 0;
    var phi1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = 0;
    var var18 = null;
    var var19 = null;
    var var20 = 0;
    var var21 = 0;
    var var22 = null;
    // line number 1287
    var0 = ((this.remaining)) | 0;
    if (var0 <= 0) {
     // line number 1296
     var22 = new java$util$NoSuchElementException();
     java$util$NoSuchElementException.prototype.V$$init$$$.call(var22);
     throw bytecoder.registerStack(var22, new Error().stack);
    } else {
     phi1 = this;
     L363286210: while(true) {
      // line number 1289
      var2 = phi1;
      var3 = (var2.this$0);
      var4 = (var3.table);
      var5 = phi1;
      var6 = ((java$util$ImmutableCollections$MapN$MapNIterator.prototype.I$nextIndex$$.call(var5))) | 0;
      var7 = (var6) | 0;
      var8 = (var4.data[var6]);
      if (var8 != null) {
       // line number 1291
       var9 = new java$util$KeyValueHolder();
       var10 = phi1;
       var11 = (var10.this$0);
       var12 = (var11.table);
       var13 = (var12.data[var7]);
       var14 = phi1;
       var15 = (var14.this$0);
       var16 = (var15.table);
       var17 = ((var7 + 1)) | 0;
       var18 = (var16.data[var17]);
       java$util$KeyValueHolder.prototype.V$$init$$Ljava$lang$Object$$Ljava$lang$Object$.call(var9,var13,var18);
       // line number 1293
       var19 = phi1;
       var20 = ((var19.remaining)) | 0;
       var21 = ((var20 - 1)) | 0;
       var19.remaining = var21;
       // line number 1294
       return var9;
      } else {
       // Here was a goto statement
       continue L363286210;
      }
     }
    }
  }

  I$nextIndex$$() {
    // source file is ImmutableCollections.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = 0;
    var phi7 = null;
    var phi8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = 0;
    var var12 = null;
    var var13 = null;
    var var14 = 0;
    var var15 = 0;
    // line number 1272
    var0 = ((this.idx)) | 0;
    // line number 1273
    java$util$ImmutableCollections.$i;
    var1 = (java$util$ImmutableCollections.REVERSE);
    If_14_0: {
     if (var1 == 0) {
      // line number 1278
      var11 = ((var0 + -2)) | 0;
      if (var11 >= 0) {
       phi7 = this;
       phi8 = (var11) | 0;
       break If_14_0;
      } else {
       // line number 1279
       var12 = (this.this$0);
       var13 = (var12.table);
       var14 = (var13.data.length) | 0;
       var15 = ((var14 - 2)) | 0;
       phi7 = this;
       phi8 = (var15) | 0;
       break If_14_0;
      }
     } else {
      // line number 1274
      var2 = ((var0 + 2)) | 0;
      var3 = (this.this$0);
      var4 = (var3.table);
      var5 = (var4.data.length) | 0;
      if (var2 < var5) {
       phi7 = this;
       phi8 = (var2) | 0;
       break If_14_0;
      } else {
       // line number 1275
       var6 = (0) | 0;
       // Here was a goto statement
       phi7 = this;
       phi8 = (var6) | 0;
       break If_14_0;
      }
     }
    }
    // line number 1282
    var9 = phi7;
    var10 = (phi8) | 0;
    var9.idx = var10;
    return var10;
  }
}


class java$util$ListIterator extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$ListIterator,[java$util$Iterator,java$lang$Object,java$util$ListIterator]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class org$luaj$vm2$LuaTable$StrongSlot extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$LuaTable$StrongSlot,[java$lang$Object,org$luaj$vm2$LuaTable$Slot,org$luaj$vm2$LuaTable$StrongSlot]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class de$mirkosertic$bytecoder$api$web$ParentNode extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(de$mirkosertic$bytecoder$api$web$ParentNode,[java$lang$Object,de$mirkosertic$bytecoder$api$OpaqueReferenceType,de$mirkosertic$bytecoder$api$web$ParentNode]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.Lde$mirkosertic$bytecoder$api$web$Element$$getElementById$Ljava$lang$String$ = impl;
  }

  Lde$mirkosertic$bytecoder$api$web$Element$$getElementById$Ljava$lang$String$(arg0) {
    return bytecoder.wrapNativeIntoTypeInstance(de$mirkosertic$bytecoder$api$web$Element,this.nativeObject.getElementById(arg0.nativeObject));
  }
}


class java$io$Closeable extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$io$Closeable,[java$lang$Object,java$lang$AutoCloseable,java$io$Closeable]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class org$luaj$vm2$NonTableMetatable extends java$lang$Object {
  nativeObject = null;

  value = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$NonTableMetatable,[org$luaj$vm2$NonTableMetatable,java$lang$Object,org$luaj$vm2$Metatable]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var0 = arg0;
    java$lang$Object.prototype.V$$init$$$.call(this);
    var1 = this;
    var1.value = var0;
    return;
  }

  Lorg$luaj$vm2$LuaValue$$toLuaValue$$() {
    var var0 = null;
    var0 = (this.value);
    return var0;
  }

  Lorg$luaj$vm2$LuaValue$$arrayget$$Lorg$luaj$vm2$LuaValue$$I(arg0,arg1) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var0 = arg0;
    var1 = (arg1) | 0;
    var2 = (var0.data[var1]);
    return var2;
  }

  Lorg$luaj$vm2$LuaValue$$wrap$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var0 = arg0;
    return var0;
  }

  Z$useWeakKeys$$() {
    var var0 = 0;
    var0 = (0) | 0;
    return var0;
  }

  Z$useWeakValues$$() {
    var var0 = 0;
    var0 = (0) | 0;
    return var0;
  }

  Lorg$luaj$vm2$LuaTable$Slot$$entry$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    var1 = arg1;
    org$luaj$vm2$LuaTable.$i;
    var2 = (org$luaj$vm2$LuaTable.Lorg$luaj$vm2$LuaTable$Entry$$defaultEntry$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(var0,var1));
    return var2;
  }
}


class org$luaj$vm2$LuaValue extends org$luaj$vm2$Varargs {
  nativeObject = null;

  static TYPE_NAMES = null;
  static NIL = null;
  static TRUE = null;
  static FALSE = null;
  static NONE = null;
  static ZERO = null;
  static ONE = null;
  static MINUSONE = null;
  static NOVALS = null;
  static ENV = null;
  static INDEX = null;
  static NEWINDEX = null;
  static CALL = null;
  static MODE = null;
  static METATABLE = null;
  static ADD = null;
  static SUB = null;
  static DIV = null;
  static MUL = null;
  static POW = null;
  static MOD = null;
  static UNM = null;
  static LEN = null;
  static EQ = null;
  static LT = null;
  static LE = null;
  static TOSTRING = null;
  static CONCAT = null;
  static EMPTYSTRING = null;
  static MAXSTACK = 0;
  static NILS = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$LuaValue,[org$luaj$vm2$LuaValue,java$lang$Object,org$luaj$vm2$Varargs]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = null;
    var var37 = null;
    var var38 = null;
    var var39 = 0;
    var var40 = null;
    var phi41 = 0;
    var var42 = 0;
    var var43 = 0;
    var var44 = null;
    var var45 = 0;
    var var46 = null;
    var0 = bytecoder.newarray((10),null);
    var1 = (0) | 0;
    var0.data[var1] = bytecoder.stringconstants[2];
    var2 = (1) | 0;
    var0.data[var2] = bytecoder.stringconstants[3];
    var3 = (2) | 0;
    var0.data[var3] = bytecoder.stringconstants[4];
    var4 = (3) | 0;
    var0.data[var4] = bytecoder.stringconstants[5];
    var5 = (4) | 0;
    var0.data[var5] = bytecoder.stringconstants[6];
    var6 = (5) | 0;
    var0.data[var6] = bytecoder.stringconstants[7];
    var7 = (6) | 0;
    var0.data[var7] = bytecoder.stringconstants[8];
    var8 = (7) | 0;
    var0.data[var8] = bytecoder.stringconstants[9];
    var9 = (8) | 0;
    var0.data[var9] = bytecoder.stringconstants[10];
    var10 = (9) | 0;
    var0.data[var10] = bytecoder.stringconstants[11];
    org$luaj$vm2$LuaValue.$i;
    org$luaj$vm2$LuaValue.TYPE_NAMES = var0;
    org$luaj$vm2$LuaNil.$i;
    var11 = (org$luaj$vm2$LuaNil._NIL);
    org$luaj$vm2$LuaValue.NIL = var11;
    org$luaj$vm2$LuaBoolean.$i;
    var12 = (org$luaj$vm2$LuaBoolean._TRUE);
    org$luaj$vm2$LuaValue.TRUE = var12;
    var13 = (org$luaj$vm2$LuaBoolean._FALSE);
    org$luaj$vm2$LuaValue.FALSE = var13;
    org$luaj$vm2$LuaValue$None.$i;
    var14 = (org$luaj$vm2$LuaValue$None._NONE);
    org$luaj$vm2$LuaValue.NONE = var14;
    org$luaj$vm2$LuaInteger.$i;
    var15 = (org$luaj$vm2$LuaInteger.Lorg$luaj$vm2$LuaInteger$$valueOf$I(0));
    org$luaj$vm2$LuaValue.ZERO = var15;
    var16 = (org$luaj$vm2$LuaInteger.Lorg$luaj$vm2$LuaInteger$$valueOf$I(1));
    org$luaj$vm2$LuaValue.ONE = var16;
    var17 = (org$luaj$vm2$LuaInteger.Lorg$luaj$vm2$LuaInteger$$valueOf$I(-1));
    org$luaj$vm2$LuaValue.MINUSONE = var17;
    var18 = bytecoder.newarray((0),null);
    org$luaj$vm2$LuaValue.NOVALS = var18;
    var19 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(bytecoder.stringconstants[12]));
    org$luaj$vm2$LuaValue.ENV = var19;
    var20 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(bytecoder.stringconstants[13]));
    org$luaj$vm2$LuaValue.INDEX = var20;
    var21 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(bytecoder.stringconstants[14]));
    org$luaj$vm2$LuaValue.NEWINDEX = var21;
    var22 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(bytecoder.stringconstants[15]));
    org$luaj$vm2$LuaValue.CALL = var22;
    var23 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(bytecoder.stringconstants[16]));
    org$luaj$vm2$LuaValue.MODE = var23;
    var24 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(bytecoder.stringconstants[17]));
    org$luaj$vm2$LuaValue.METATABLE = var24;
    var25 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(bytecoder.stringconstants[18]));
    org$luaj$vm2$LuaValue.ADD = var25;
    var26 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(bytecoder.stringconstants[19]));
    org$luaj$vm2$LuaValue.SUB = var26;
    var27 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(bytecoder.stringconstants[20]));
    org$luaj$vm2$LuaValue.DIV = var27;
    var28 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(bytecoder.stringconstants[21]));
    org$luaj$vm2$LuaValue.MUL = var28;
    var29 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(bytecoder.stringconstants[22]));
    org$luaj$vm2$LuaValue.POW = var29;
    var30 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(bytecoder.stringconstants[23]));
    org$luaj$vm2$LuaValue.MOD = var30;
    var31 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(bytecoder.stringconstants[24]));
    org$luaj$vm2$LuaValue.UNM = var31;
    var32 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(bytecoder.stringconstants[25]));
    org$luaj$vm2$LuaValue.LEN = var32;
    var33 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(bytecoder.stringconstants[26]));
    org$luaj$vm2$LuaValue.EQ = var33;
    var34 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(bytecoder.stringconstants[27]));
    org$luaj$vm2$LuaValue.LT = var34;
    var35 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(bytecoder.stringconstants[28]));
    org$luaj$vm2$LuaValue.LE = var35;
    var36 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(bytecoder.stringconstants[29]));
    org$luaj$vm2$LuaValue.TOSTRING = var36;
    var37 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(bytecoder.stringconstants[30]));
    org$luaj$vm2$LuaValue.CONCAT = var37;
    var38 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(bytecoder.stringconstants[1]));
    org$luaj$vm2$LuaValue.EMPTYSTRING = var38;
    org$luaj$vm2$LuaValue.MAXSTACK = 250;
    var39 = ((org$luaj$vm2$LuaValue.MAXSTACK)) | 0;
    var40 = bytecoder.newarray((var39),null);
    org$luaj$vm2$LuaValue.NILS = var40;
    phi41 = (0) | 0;
    L878650050: while(true) {
     var42 = (phi41) | 0;
     var43 = ((org$luaj$vm2$LuaValue.MAXSTACK)) | 0;
     if (var42 >= var43) {
      return;
     } else {
      var44 = (org$luaj$vm2$LuaValue.NILS);
      var45 = (phi41) | 0;
      var46 = (org$luaj$vm2$LuaValue.NIL);
      var44.data[var45] = var46;
      phi41 = ((phi41 + 1)) | 0;
      // Here was a goto statement
      continue L878650050;
     }
    }
  }

  V$$init$$$() {
    org$luaj$vm2$Varargs.prototype.V$$init$$$.call(this);
    return;
  }

  static Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(arg0) {
    var var0 = null;
    org$luaj$vm2$LuaString.$i;
    var0 = (org$luaj$vm2$LuaString.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(arg0));
    return var0;
  }

  static Lorg$luaj$vm2$LuaValue$$error$Ljava$lang$String$(arg0) {
    var var0 = null;
    var var1 = null;
    var0 = new org$luaj$vm2$LuaError();
    var1 = arg0;
    org$luaj$vm2$LuaError.prototype.V$$init$$Ljava$lang$String$.call(var0,var1);
    throw bytecoder.registerStack(var0, new Error().stack);
  }

  Lorg$luaj$vm2$LuaValue$$call$$() {
    var var0 = null;
    var var1 = null;
    var0 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$callmt$$.call(this));
    var1 = (var0.Lorg$luaj$vm2$LuaValue$$call$Lorg$luaj$vm2$LuaValue$(this));
    return var1;
  }

  Lorg$luaj$vm2$LuaValue$$callmt$$() {
    var var0 = null;
    var var1 = null;
    org$luaj$vm2$LuaValue.$i;
    var0 = (org$luaj$vm2$LuaValue.CALL);
    var1 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$checkmetatag$Lorg$luaj$vm2$LuaValue$$Ljava$lang$String$.call(this,var0,bytecoder.stringconstants[131]));
    return var1;
  }

  Lorg$luaj$vm2$LuaValue$$checkmetatag$Lorg$luaj$vm2$LuaValue$$Ljava$lang$String$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var0 = arg0;
    var1 = var0;
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$metatag$Lorg$luaj$vm2$LuaValue$.call(this,var1));
    var3 = var2;
    var4 = (var3.Z$isnil$$());
    if (var4 == 0) {
     return var2;
    } else {
     var5 = new org$luaj$vm2$LuaError();
     var6 = new java$lang$StringBuffer();
     java$lang$StringBuffer.prototype.V$$init$$$.call(var6);
     var7 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var6,arg1));
     var8 = (this.Ljava$lang$String$$typename$$());
     var9 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var7,var8));
     var10 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var9));
     org$luaj$vm2$LuaError.prototype.V$$init$$Ljava$lang$String$.call(var5,var10);
     throw bytecoder.registerStack(var5, new Error().stack);
    }
  }

  Lorg$luaj$vm2$LuaValue$$metatag$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var0 = arg0;
    var1 = (this.Lorg$luaj$vm2$LuaValue$$getmetatable$$());
    var2 = var1;
    if (var2 != null) {
     var4 = var0;
     var5 = (var1.Lorg$luaj$vm2$LuaValue$$rawget$Lorg$luaj$vm2$LuaValue$(var4));
     return var5;
    } else {
     org$luaj$vm2$LuaValue.$i;
     var3 = (org$luaj$vm2$LuaValue.NIL);
     return var3;
    }
  }

  Lorg$luaj$vm2$LuaValue$$getmetatable$$() {
    var var0 = null;
    var0 = null;
    return var0;
  }

  Lorg$luaj$vm2$LuaValue$$rawget$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    var1 = bytecoder.stringconstants[132];
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$unimplemented$Ljava$lang$String$.call(this,var1));
    return var2;
  }

  Lorg$luaj$vm2$LuaValue$$unimplemented$Ljava$lang$String$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var0 = arg0;
    var1 = new org$luaj$vm2$LuaError();
    var2 = new java$lang$StringBuffer();
    java$lang$StringBuffer.prototype.V$$init$$$.call(var2);
    var3 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var2,bytecoder.stringconstants[130]));
    var4 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var3,var0));
    var5 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var4,bytecoder.stringconstants[133]));
    var6 = (this.Ljava$lang$String$$typename$$());
    var7 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var5,var6));
    var8 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var7));
    org$luaj$vm2$LuaError.prototype.V$$init$$Ljava$lang$String$.call(var1,var8);
    throw bytecoder.registerStack(var1, new Error().stack);
  }

  Z$isnil$$() {
    var var0 = 0;
    var0 = (0) | 0;
    return var0;
  }

  Lorg$luaj$vm2$LuaValue$$call$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    var1 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$callmt$$.call(this));
    var2 = (var1.Lorg$luaj$vm2$LuaValue$$call$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(this,var0));
    return var2;
  }

  Lorg$luaj$vm2$LuaValue$$call$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var0 = arg0;
    var1 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$callmt$$.call(this));
    var2 = arg1;
    var3 = (var1.Lorg$luaj$vm2$LuaValue$$call$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(this,var0,var2));
    return var3;
  }

  Lorg$luaj$vm2$LuaValue$$call$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(arg0,arg1,arg2) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var0 = arg0;
    var1 = arg2;
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$callmt$$.call(this));
    var3 = bytecoder.newarray((4),null);
    var4 = (0) | 0;
    var3.data[var4] = this;
    var5 = (1) | 0;
    var3.data[var5] = var0;
    var6 = (2) | 0;
    var3.data[var6] = arg1;
    var7 = (3) | 0;
    var3.data[var7] = var1;
    var8 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$Varargs$$invoke$$Lorg$luaj$vm2$LuaValue$.call(var2,var3));
    var9 = (var8.Lorg$luaj$vm2$LuaValue$$arg1$$());
    return var9;
  }

  Lorg$luaj$vm2$Varargs$$invoke$$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var0 = arg0;
    var1 = var0;
    org$luaj$vm2$LuaValue.$i;
    var2 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$Varargs$$varargsOf$$Lorg$luaj$vm2$LuaValue$(var1));
    var3 = (this.Lorg$luaj$vm2$Varargs$$invoke$Lorg$luaj$vm2$Varargs$(var2));
    return var3;
  }

  static Lorg$luaj$vm2$Varargs$$varargsOf$$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = 0;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var0 = (arg0.data.length) | 0;
    if ((var0) >= 0 && (var0) <= 2) switch ((var0) - 0) {
     case 0: {
      org$luaj$vm2$LuaValue.$i;
      var8 = (org$luaj$vm2$LuaValue.NONE);
      return var8;
     }
     case 1: {
      var6 = (0) | 0;
      var7 = (arg0.data[var6]);
      return var7;
     }
     case 2: {
      var1 = new org$luaj$vm2$Varargs$PairVarargs();
      var2 = arg0;
      var3 = (var2.data[0]);
      var4 = (1) | 0;
      var5 = (arg0.data[var4]);
      org$luaj$vm2$Varargs$PairVarargs.prototype.V$$init$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$Varargs$.call(var1,var3,var5);
      return var1;
     }
    } else {
     var9 = new org$luaj$vm2$Varargs$ArrayVarargs();
     var10 = arg0;
     org$luaj$vm2$LuaValue.$i;
     var11 = (org$luaj$vm2$LuaValue.NONE);
     org$luaj$vm2$Varargs$ArrayVarargs.prototype.V$$init$$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$Varargs$.call(var9,var10,var11);
     return var9;
    }
  }

  Lorg$luaj$vm2$Varargs$$invoke$Lorg$luaj$vm2$Varargs$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    var1 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$callmt$$.call(this));
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$Varargs$$invoke$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$Varargs$.call(var1,this,var0));
    return var2;
  }

  Lorg$luaj$vm2$Varargs$$invoke$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$Varargs$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var0 = arg0;
    var1 = var0;
    org$luaj$vm2$LuaValue.$i;
    var2 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$Varargs$$varargsOf$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$Varargs$(var1,arg1));
    var3 = (this.Lorg$luaj$vm2$Varargs$$invoke$Lorg$luaj$vm2$Varargs$(var2));
    return var3;
  }

  static Lorg$luaj$vm2$Varargs$$varargsOf$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$Varargs$(arg0,arg1) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var0 = arg1;
    var1 = ((var0.I$narg$$())) | 0;
    switch (var1) {
     case 0: {
      return arg0;
     }
     default: {
      var2 = new org$luaj$vm2$Varargs$PairVarargs();
      var3 = arg0;
      org$luaj$vm2$Varargs$PairVarargs.prototype.V$$init$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$Varargs$.call(var2,var3,var0);
      return var2;
     }
    }
  }

  Lorg$luaj$vm2$LuaString$$strvalue$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = bytecoder.stringconstants[134];
    var1 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$typerror$Ljava$lang$String$.call(this,var0));
    var2 = null;
    return var2;
  }

  Lorg$luaj$vm2$LuaValue$$typerror$Ljava$lang$String$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var0 = arg0;
    var1 = new org$luaj$vm2$LuaError();
    var2 = new java$lang$StringBuffer();
    java$lang$StringBuffer.prototype.V$$init$$$.call(var2);
    var3 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var2,var0));
    var4 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var3,bytecoder.stringconstants[135]));
    var5 = (this.Ljava$lang$String$$typename$$());
    var6 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var4,var5));
    var7 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var6));
    org$luaj$vm2$LuaError.prototype.V$$init$$Ljava$lang$String$.call(var1,var7);
    throw bytecoder.registerStack(var1, new Error().stack);
  }

  Ljava$lang$String$$toString$$() {
    var var0 = null;
    var0 = (this.Ljava$lang$String$$tojstring$$());
    return var0;
  }

  Ljava$lang$String$$tojstring$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var0 = new java$lang$StringBuffer();
    java$lang$StringBuffer.prototype.V$$init$$$.call(var0);
    var1 = (this.Ljava$lang$String$$typename$$());
    var2 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var0,var1));
    var3 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var2,bytecoder.stringconstants[124]));
    var4 = ((this.I$hashCode$$())) | 0;
    java$lang$Integer.$i;
    var5 = (java$lang$Integer.Ljava$lang$String$$toHexString$I(var4));
    var6 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var3,var5));
    var7 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var6));
    return var7;
  }

  Z$equals$Ljava$lang$Object$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var phi3 = null;
    var phi4 = null;
    var phi5 = 0;
    var0 = arg0;
    var1 = var0;
    If_7_0: {
     if (this != var1) {
      phi3 = this;
      phi4 = var0;
      phi5 = (0) | 0;
      break If_7_0;
     } else {
      var2 = (1) | 0;
      // Here was a goto statement
      phi3 = this;
      phi4 = var0;
      phi5 = (var2) | 0;
      break If_7_0;
     }
    }
    return phi5;
  }

  I$narg$$() {
    var var0 = 0;
    var0 = (1) | 0;
    return var0;
  }

  Lorg$luaj$vm2$LuaValue$$arg1$$() {
    return this;
  }

  Lorg$luaj$vm2$LuaValue$$arg$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var phi3 = null;
    var phi4 = 0;
    var phi5 = null;
    var var6 = null;
    var0 = (arg0) | 0;
    var1 = (1) | 0;
    If_8_0: {
     if (var0 != var1) {
      org$luaj$vm2$LuaValue.$i;
      var6 = (org$luaj$vm2$LuaValue.NIL);
      phi3 = this;
      phi4 = (var0) | 0;
      phi5 = var6;
      break If_8_0;
     } else {
      var2 = this;
      // Here was a goto statement
      phi3 = this;
      phi4 = (var0) | 0;
      phi5 = var2;
      break If_8_0;
     }
    }
    return phi5;
  }

  Z$isclosure$$() {
    var var0 = 0;
    var0 = (0) | 0;
    return var0;
  }

  Lorg$luaj$vm2$LuaClosure$$checkclosure$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = bytecoder.stringconstants[184];
    var1 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$argerror$Ljava$lang$String$.call(this,var0));
    var2 = null;
    return var2;
  }

  Lorg$luaj$vm2$LuaValue$$argerror$Ljava$lang$String$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var0 = arg0;
    var1 = new org$luaj$vm2$LuaError();
    var2 = new java$lang$StringBuffer();
    java$lang$StringBuffer.prototype.V$$init$$$.call(var2);
    var3 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var2,bytecoder.stringconstants[185]));
    var4 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var3,var0));
    var5 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var4,bytecoder.stringconstants[135]));
    var6 = (this.Ljava$lang$String$$typename$$());
    var7 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var5,var6));
    var8 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var7));
    org$luaj$vm2$LuaError.prototype.V$$init$$Ljava$lang$String$.call(var1,var8);
    throw bytecoder.registerStack(var1, new Error().stack);
  }

  Z$isstring$$() {
    var var0 = 0;
    var0 = (0) | 0;
    return var0;
  }

  Z$raweq$Lorg$luaj$vm2$LuaString$(arg0) {
    var var0 = null;
    var0 = arg0;
    return 0;
  }

  Ljava$lang$Object$$touserdata$$() {
    var var0 = null;
    var0 = null;
    return var0;
  }

  Lorg$luaj$vm2$LuaString$$checkstring$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = bytecoder.stringconstants[6];
    var1 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$argerror$Ljava$lang$String$.call(this,var0));
    var2 = null;
    return var2;
  }

  static Lorg$luaj$vm2$LuaInteger$$valueOf$I(arg0) {
    var var0 = null;
    org$luaj$vm2$LuaInteger.$i;
    var0 = (org$luaj$vm2$LuaInteger.Lorg$luaj$vm2$LuaInteger$$valueOf$I(arg0));
    return var0;
  }

  V$set$I$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var0 = (arg0) | 0;
    var1 = (var0) | 0;
    org$luaj$vm2$LuaInteger.$i;
    var2 = (org$luaj$vm2$LuaInteger.Lorg$luaj$vm2$LuaInteger$$valueOf$I(var1));
    this.V$set$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(var2,arg1);
    return;
  }

  V$set$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var0 = arg0;
    var1 = var0;
    org$luaj$vm2$LuaValue.$i;
    var2 = (org$luaj$vm2$LuaValue.Z$settable$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(this,var1,arg1));
    return;
  }

  static Z$settable$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(arg0,arg1,arg2) {
    var var0 = null;
    var var1 = 0;
    var phi2 = null;
    var phi3 = null;
    var phi4 = null;
    var phi5 = 0;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = 0;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = 0;
    var phi17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var phi21 = null;
    var var22 = null;
    var var23 = 0;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = 0;
    var var30 = null;
    var var31 = 0;
    var var32 = null;
    var var33 = null;
    var var34 = 0;
    var var35 = null;
    var var36 = null;
    var var37 = null;
    var var38 = null;
    var var39 = 0;
    var var40 = null;
    var var41 = null;
    var0 = arg1;
    var1 = (0) | 0;
    phi2 = arg0;
    phi3 = var0;
    phi4 = arg2;
    phi5 = (var1) | 0;
    L1224354978: while(true) {
     var6 = phi2;
     var7 = (var6.Z$istable$$());
     If_19_0: {
      if (var7 == 0) {
       var35 = phi2;
       org$luaj$vm2$LuaValue.$i;
       var36 = (org$luaj$vm2$LuaValue.NEWINDEX);
       var37 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$metatag$Lorg$luaj$vm2$LuaValue$.call(var35,var36));
       var38 = var37;
       var39 = (var37.Z$isnil$$());
       if (var39 == 0) {
        phi21 = var38;
        break If_19_0;
       } else {
        var40 = phi2;
        var41 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$typerror$Ljava$lang$String$.call(var40,bytecoder.stringconstants[273]));
        phi21 = var38;
        break If_19_0;
       }
      } else {
       var8 = phi2;
       var9 = phi3;
       var10 = (var8.Lorg$luaj$vm2$LuaValue$$rawget$Lorg$luaj$vm2$LuaValue$(var9));
       var11 = (var10.Z$isnil$$());
       If_32_0: {
        if (var11 == 0) {
         break If_32_0;
        } else {
         var12 = phi2;
         org$luaj$vm2$LuaValue.$i;
         var13 = (org$luaj$vm2$LuaValue.NEWINDEX);
         var14 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$metatag$Lorg$luaj$vm2$LuaValue$.call(var12,var13));
         var15 = var14;
         var16 = (var14.Z$isnil$$());
         if (var16 == 0) {
          phi21 = var15;
          break If_19_0;
         } else {
          phi17 = var15;
          break If_32_0;
         }
        }
       }
       var18 = phi2;
       var19 = phi3;
       var20 = phi4;
       var18.V$rawset$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(var19,var20);
       return 1;
      }
     }
     var22 = phi21;
     var23 = (var22.Z$isfunction$$());
     if (var23 == 0) {
      var30 = phi21;
      phi5 = ((phi5 + 1)) | 0;
      var31 = (phi5) | 0;
      if (var31 < 100) {
       phi2 = var30;
       continue L1224354978;
      } else {
       var32 = bytecoder.stringconstants[272];
       org$luaj$vm2$LuaValue.$i;
       var33 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaValue$$error$Ljava$lang$String$(var32));
       var34 = (0) | 0;
       return var34;
      }
     } else {
      var24 = phi21;
      var25 = phi2;
      var26 = phi3;
      var27 = phi4;
      var28 = (var24.Lorg$luaj$vm2$LuaValue$$call$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(var25,var26,var27));
      var29 = (1) | 0;
      return var29;
     }
    }
  }

  Z$istable$$() {
    var var0 = 0;
    var0 = (0) | 0;
    return var0;
  }

  V$rawset$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    var1 = bytecoder.stringconstants[271];
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$unimplemented$Ljava$lang$String$.call(this,var1));
    return;
  }

  Z$isfunction$$() {
    var var0 = 0;
    var0 = (0) | 0;
    return var0;
  }

  V$presize$I(arg0) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var0 = (arg0) | 0;
    var1 = bytecoder.stringconstants[7];
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$typerror$Ljava$lang$String$.call(this,var1));
    return;
  }

  Lorg$luaj$vm2$LuaNumber$$checknumber$Ljava$lang$String$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    var1 = new org$luaj$vm2$LuaError();
    var2 = var0;
    org$luaj$vm2$LuaError.prototype.V$$init$$Ljava$lang$String$.call(var1,var2);
    throw bytecoder.registerStack(var1, new Error().stack);
  }

  Lorg$luaj$vm2$LuaValue$$sub$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    org$luaj$vm2$LuaValue.$i;
    var1 = (org$luaj$vm2$LuaValue.SUB);
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$arithmt$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$.call(this,var1,var0));
    return var2;
  }

  Lorg$luaj$vm2$LuaValue$$arithmt$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var phi20 = null;
    var phi21 = null;
    var phi22 = null;
    var phi23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var0 = arg0;
    var1 = var0;
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$metatag$Lorg$luaj$vm2$LuaValue$.call(this,var1));
    var3 = var2;
    var4 = (var3.Z$isnil$$());
    If_16_0: {
     if (var4 == 0) {
      phi20 = this;
      phi21 = var0;
      phi22 = arg1;
      phi23 = var2;
      break If_16_0;
     } else {
      var5 = arg1;
      var6 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$metatag$Lorg$luaj$vm2$LuaValue$.call(var5,var0));
      var7 = var6;
      var8 = (var7.Z$isnil$$());
      if (var8 == 0) {
       phi20 = this;
       phi21 = var0;
       phi22 = arg1;
       phi23 = var6;
       break If_16_0;
      } else {
       var9 = new java$lang$StringBuffer();
       java$lang$StringBuffer.prototype.V$$init$$$.call(var9);
       var10 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var9,bytecoder.stringconstants[277]));
       var11 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$Object$.call(var10,var0));
       var12 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var11,bytecoder.stringconstants[278]));
       var13 = (this.Ljava$lang$String$$typename$$());
       var14 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var12,var13));
       var15 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var14,bytecoder.stringconstants[279]));
       var16 = (arg1.Ljava$lang$String$$typename$$());
       var17 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var15,var16));
       var18 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var17));
       org$luaj$vm2$LuaValue.$i;
       var19 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaValue$$error$Ljava$lang$String$(var18));
       phi20 = this;
       phi21 = var0;
       phi22 = arg1;
       phi23 = var6;
       break If_16_0;
      }
     }
    }
    var24 = phi23;
    var25 = phi20;
    var26 = phi22;
    var27 = (var24.Lorg$luaj$vm2$LuaValue$$call$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(var25,var26));
    return var27;
  }

  Lorg$luaj$vm2$LuaValue$$add$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    org$luaj$vm2$LuaValue.$i;
    var1 = (org$luaj$vm2$LuaValue.ADD);
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$arithmt$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$.call(this,var1,var0));
    return var2;
  }

  Z$gt_b$I(arg0) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var0 = (arg0) | 0;
    var1 = bytecoder.stringconstants[5];
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$compareerror$Ljava$lang$String$.call(this,var1));
    var3 = (0) | 0;
    return var3;
  }

  Lorg$luaj$vm2$LuaValue$$compareerror$Ljava$lang$String$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var0 = arg0;
    var1 = new org$luaj$vm2$LuaError();
    var2 = new java$lang$StringBuffer();
    java$lang$StringBuffer.prototype.V$$init$$$.call(var2);
    var3 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var2,bytecoder.stringconstants[280]));
    var4 = (this.Ljava$lang$String$$typename$$());
    var5 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var3,var4));
    var6 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var5,bytecoder.stringconstants[281]));
    var7 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var6,var0));
    var8 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var7));
    org$luaj$vm2$LuaError.prototype.V$$init$$Ljava$lang$String$.call(var1,var8);
    throw bytecoder.registerStack(var1, new Error().stack);
  }

  Z$lteq_b$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var0 = arg0;
    org$luaj$vm2$LuaValue.$i;
    var1 = (org$luaj$vm2$LuaValue.LE);
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$comparemt$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$.call(this,var1,var0));
    var3 = (var2.Z$toboolean$$());
    return var3;
  }

  Lorg$luaj$vm2$LuaValue$$comparemt$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var phi9 = null;
    var phi10 = null;
    var phi11 = null;
    var phi12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = 0;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = 0;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = 0;
    var phi29 = null;
    var phi30 = null;
    var phi31 = null;
    var phi32 = null;
    var var33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = null;
    var var37 = null;
    var phi38 = null;
    var phi39 = null;
    var phi40 = null;
    var phi41 = null;
    var var42 = null;
    var var43 = null;
    var var44 = null;
    var var45 = null;
    var var46 = null;
    var var47 = null;
    var var48 = null;
    var var49 = null;
    var var50 = null;
    var var51 = null;
    var var52 = null;
    var var53 = null;
    var var54 = null;
    var var55 = null;
    var0 = arg0;
    var1 = var0;
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$metatag$Lorg$luaj$vm2$LuaValue$.call(this,var1));
    var3 = var2;
    var4 = (var2.Z$isnil$$());
    If_16_0: {
     if (var4 == 0) {
      phi9 = this;
      phi10 = var0;
      phi11 = arg1;
      phi12 = var3;
      break If_16_0;
     } else {
      var5 = arg1;
      var6 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$metatag$Lorg$luaj$vm2$LuaValue$.call(var5,var0));
      var7 = var6;
      var8 = (var6.Z$isnil$$());
      if (var8 != 0) {
       org$luaj$vm2$LuaValue.$i;
       var17 = (org$luaj$vm2$LuaValue.LE);
       var18 = (org$luaj$vm2$LuaString.prototype.Z$raweq$Lorg$luaj$vm2$LuaValue$.call(var17,var0));
       If_56_0: {
        if (var18 == 0) {
         phi38 = this;
         phi39 = var0;
         phi40 = arg1;
         phi41 = var7;
         break If_56_0;
        } else {
         var19 = this;
         var20 = (org$luaj$vm2$LuaValue.LT);
         var21 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$metatag$Lorg$luaj$vm2$LuaValue$.call(var19,var20));
         var22 = var21;
         var23 = (var21.Z$isnil$$());
         If_73_0: {
          if (var23 == 0) {
           phi29 = this;
           phi30 = var0;
           phi31 = arg1;
           phi32 = var22;
           break If_73_0;
          } else {
           var24 = arg1;
           var25 = (org$luaj$vm2$LuaValue.LT);
           var26 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$metatag$Lorg$luaj$vm2$LuaValue$.call(var24,var25));
           var27 = var26;
           var28 = (var26.Z$isnil$$());
           if (var28 != 0) {
            phi38 = this;
            phi39 = var0;
            phi40 = arg1;
            phi41 = var27;
            break If_56_0;
           } else {
            phi29 = this;
            phi30 = var0;
            phi31 = arg1;
            phi32 = var27;
            break If_73_0;
           }
          }
         }
         var33 = phi32;
         var34 = phi31;
         var35 = phi29;
         var36 = (var33.Lorg$luaj$vm2$LuaValue$$call$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(var34,var35));
         var37 = (var36.Lorg$luaj$vm2$LuaValue$$not$$());
         return var37;
        }
       }
       var42 = new java$lang$StringBuffer();
       java$lang$StringBuffer.prototype.V$$init$$$.call(var42);
       var43 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var42,bytecoder.stringconstants[280]));
       var44 = phi39;
       var45 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$Object$.call(var43,var44));
       var46 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var45,bytecoder.stringconstants[278]));
       var47 = phi38;
       var48 = (var47.Ljava$lang$String$$typename$$());
       var49 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var46,var48));
       var50 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var49,bytecoder.stringconstants[279]));
       var51 = phi40;
       var52 = (var51.Ljava$lang$String$$typename$$());
       var53 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var50,var52));
       var54 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var53));
       var55 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaValue$$error$Ljava$lang$String$(var54));
       return var55;
      } else {
       phi9 = this;
       phi10 = var0;
       phi11 = arg1;
       phi12 = var7;
       break If_16_0;
      }
     }
    }
    var13 = phi12;
    var14 = phi9;
    var15 = phi11;
    var16 = (var13.Lorg$luaj$vm2$LuaValue$$call$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(var14,var15));
    return var16;
  }

  Lorg$luaj$vm2$LuaValue$$not$$() {
    var var0 = null;
    org$luaj$vm2$LuaValue.$i;
    var0 = (org$luaj$vm2$LuaValue.FALSE);
    return var0;
  }

  Z$toboolean$$() {
    var var0 = 0;
    var0 = (1) | 0;
    return var0;
  }

  Z$gteq_b$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var0 = arg0;
    org$luaj$vm2$LuaValue.$i;
    var1 = (org$luaj$vm2$LuaValue.LT);
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$comparemt$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$.call(var0,var1,this));
    var3 = (var2.Z$toboolean$$());
    return var3;
  }

  static Lorg$luaj$vm2$Varargs$$varargsOf$$Lorg$luaj$vm2$LuaValue$$I$I$Lorg$luaj$vm2$Varargs$(arg0,arg1,arg2,arg3) {
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var phi6 = null;
    var phi7 = 0;
    var phi8 = 0;
    var phi9 = null;
    var phi10 = null;
    var var11 = null;
    var var12 = 0;
    var var13 = null;
    var var14 = 0;
    var var15 = 0;
    var var16 = null;
    var var17 = 0;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var phi21 = null;
    var phi22 = 0;
    var phi23 = 0;
    var phi24 = null;
    var phi25 = null;
    var var26 = 0;
    var var27 = null;
    var var28 = null;
    var var29 = 0;
    var var30 = null;
    var0 = (arg1) | 0;
    var1 = arg3;
    if ((arg2) >= 0 && (arg2) <= 2) switch ((arg2) - 0) {
     case 0: {
      return var1;
     }
     case 1: {
      var17 = ((var1.I$narg$$())) | 0;
      If_60_0: {
       if (var17 <= 0) {
        var26 = (var0) | 0;
        var27 = (arg0.data[var26]);
        phi21 = arg0;
        phi22 = (var0) | 0;
        phi23 = (arg2) | 0;
        phi24 = var1;
        phi25 = var27;
        break If_60_0;
       } else {
        var18 = new org$luaj$vm2$Varargs$PairVarargs();
        var19 = arg0;
        var20 = (var19.data[var0]);
        org$luaj$vm2$Varargs$PairVarargs.prototype.V$$init$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$Varargs$.call(var18,var20,var1);
        // Here was a goto statement
        phi21 = arg0;
        phi22 = (var0) | 0;
        phi23 = (arg2) | 0;
        phi24 = var1;
        phi25 = var18;
        break If_60_0;
       }
      }
      return phi25;
     }
     case 2: {
      var2 = ((var1.I$narg$$())) | 0;
      If_14_0: {
       if (var2 <= 0) {
        var11 = new org$luaj$vm2$Varargs$PairVarargs();
        var12 = (var0) | 0;
        var13 = (arg0.data[var12]);
        var14 = (var0) | 0;
        var15 = ((var14 + 1)) | 0;
        var16 = (arg0.data[var15]);
        org$luaj$vm2$Varargs$PairVarargs.prototype.V$$init$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$Varargs$.call(var11,var13,var16);
        phi6 = arg0;
        phi7 = (var0) | 0;
        phi8 = (arg2) | 0;
        phi9 = var1;
        phi10 = var11;
        break If_14_0;
       } else {
        var3 = new org$luaj$vm2$Varargs$ArrayPartVarargs();
        var4 = arg0;
        var5 = var1;
        org$luaj$vm2$Varargs$ArrayPartVarargs.prototype.V$$init$$$Lorg$luaj$vm2$LuaValue$$I$I$Lorg$luaj$vm2$Varargs$.call(var3,var4,var0,arg2,var5);
        // Here was a goto statement
        phi6 = arg0;
        phi7 = (var0) | 0;
        phi8 = (arg2) | 0;
        phi9 = var1;
        phi10 = var3;
        break If_14_0;
       }
      }
      return phi10;
     }
    } else {
     var28 = new org$luaj$vm2$Varargs$ArrayPartVarargs();
     var29 = (var0) | 0;
     var30 = var1;
     org$luaj$vm2$Varargs$ArrayPartVarargs.prototype.V$$init$$$Lorg$luaj$vm2$LuaValue$$I$I$Lorg$luaj$vm2$Varargs$.call(var28,arg0,var29,arg2,var30);
     return var28;
    }
  }

  static Lorg$luaj$vm2$Varargs$$varargsOf$$Lorg$luaj$vm2$LuaValue$$I$I(arg0,arg1,arg2) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = 0;
    var var14 = null;
    var0 = (arg1) | 0;
    if ((arg2) >= 0 && (arg2) <= 2) switch ((arg2) - 0) {
     case 0: {
      org$luaj$vm2$LuaValue.$i;
      var10 = (org$luaj$vm2$LuaValue.NONE);
      return var10;
     }
     case 1: {
      var9 = (arg0.data[var0]);
      return var9;
     }
     case 2: {
      var1 = new org$luaj$vm2$Varargs$PairVarargs();
      var2 = arg0;
      var3 = (0) | 0;
      var4 = ((var0 + var3)) | 0;
      var5 = (var2.data[var4]);
      var6 = (var0) | 0;
      var7 = ((var6 + 1)) | 0;
      var8 = (arg0.data[var7]);
      org$luaj$vm2$Varargs$PairVarargs.prototype.V$$init$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$Varargs$.call(var1,var5,var8);
      return var1;
     }
    } else {
     var11 = new org$luaj$vm2$Varargs$ArrayPartVarargs();
     var12 = arg0;
     var13 = (arg2) | 0;
     org$luaj$vm2$LuaValue.$i;
     var14 = (org$luaj$vm2$LuaValue.NONE);
     org$luaj$vm2$Varargs$ArrayPartVarargs.prototype.V$$init$$$Lorg$luaj$vm2$LuaValue$$I$I$Lorg$luaj$vm2$Varargs$.call(var11,var12,var0,var13,var14);
     return var11;
    }
  }

  static Lorg$luaj$vm2$Varargs$$varargsOf$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$Varargs$(arg0,arg1,arg2) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var0 = arg1;
    var1 = ((arg2.I$narg$$())) | 0;
    switch (var1) {
     case 0: {
      var8 = new org$luaj$vm2$Varargs$PairVarargs();
      var9 = arg0;
      org$luaj$vm2$Varargs$PairVarargs.prototype.V$$init$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$Varargs$.call(var8,var9,var0);
      return var8;
     }
     default: {
      var2 = new org$luaj$vm2$Varargs$ArrayPartVarargs();
      var3 = (2) | 0;
      var4 = bytecoder.newarray((var3),null);
      var5 = (0) | 0;
      var4.data[var5] = arg0;
      var6 = (1) | 0;
      var4.data[var6] = var0;
      var7 = (2) | 0;
      org$luaj$vm2$Varargs$ArrayPartVarargs.prototype.V$$init$$$Lorg$luaj$vm2$LuaValue$$I$I$Lorg$luaj$vm2$Varargs$.call(var2,var4,0,var7,arg2);
      return var2;
     }
    }
  }

  Z$lt_b$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var0 = arg0;
    org$luaj$vm2$LuaValue.$i;
    var1 = (org$luaj$vm2$LuaValue.LT);
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$comparemt$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$.call(this,var1,var0));
    var3 = (var2.Z$toboolean$$());
    return var3;
  }

  Z$eq_b$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var phi3 = null;
    var phi4 = null;
    var phi5 = 0;
    var0 = arg0;
    var1 = var0;
    If_7_0: {
     if (this != var1) {
      phi3 = this;
      phi4 = var0;
      phi5 = (0) | 0;
      break If_7_0;
     } else {
      var2 = (1) | 0;
      // Here was a goto statement
      phi3 = this;
      phi4 = var0;
      phi5 = (var2) | 0;
      break If_7_0;
     }
    }
    return phi5;
  }

  Lorg$luaj$vm2$Buffer$$buffer$$() {
    var var0 = null;
    var var1 = null;
    org$luaj$vm2$Buffer.$i;
    var0 = new org$luaj$vm2$Buffer();
    var1 = this;
    org$luaj$vm2$Buffer.prototype.V$$init$$Lorg$luaj$vm2$LuaValue$.call(var0,var1);
    return var0;
  }

  Lorg$luaj$vm2$Buffer$$concat$Lorg$luaj$vm2$Buffer$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    var1 = this;
    var2 = (org$luaj$vm2$Buffer.prototype.Lorg$luaj$vm2$Buffer$$concatTo$Lorg$luaj$vm2$LuaValue$.call(var0,var1));
    return var2;
  }

  Lorg$luaj$vm2$LuaValue$$concat$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    var1 = var0;
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$concatmt$Lorg$luaj$vm2$LuaValue$.call(this,var1));
    return var2;
  }

  Lorg$luaj$vm2$LuaValue$$concatmt$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = 0;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var phi19 = null;
    var phi20 = null;
    var phi21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var0 = arg0;
    org$luaj$vm2$LuaValue.$i;
    var1 = (org$luaj$vm2$LuaValue.CONCAT);
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$metatag$Lorg$luaj$vm2$LuaValue$.call(this,var1));
    var3 = var2;
    var4 = (var3.Z$isnil$$());
    If_18_0: {
     if (var4 == 0) {
      phi19 = this;
      phi20 = var0;
      phi21 = var2;
      break If_18_0;
     } else {
      var5 = var0;
      var6 = (org$luaj$vm2$LuaValue.CONCAT);
      var7 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$metatag$Lorg$luaj$vm2$LuaValue$.call(var5,var6));
      var8 = var7;
      var9 = (var7.Z$isnil$$());
      if (var9 == 0) {
       phi19 = this;
       phi20 = var0;
       phi21 = var8;
       break If_18_0;
      } else {
       var10 = new java$lang$StringBuffer();
       java$lang$StringBuffer.prototype.V$$init$$$.call(var10);
       var11 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var10,bytecoder.stringconstants[282]));
       var12 = (this.Ljava$lang$String$$typename$$());
       var13 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var11,var12));
       var14 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var13,bytecoder.stringconstants[279]));
       var15 = (var0.Ljava$lang$String$$typename$$());
       var16 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var14,var15));
       var17 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var16));
       var18 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaValue$$error$Ljava$lang$String$(var17));
       phi19 = this;
       phi20 = var0;
       phi21 = var8;
       break If_18_0;
      }
     }
    }
    var22 = phi21;
    var23 = phi19;
    var24 = phi20;
    var25 = (var22.Lorg$luaj$vm2$LuaValue$$call$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(var23,var24));
    return var25;
  }

  Lorg$luaj$vm2$LuaValue$$len$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    org$luaj$vm2$LuaValue.$i;
    var0 = (org$luaj$vm2$LuaValue.LEN);
    var1 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$checkmetatag$Lorg$luaj$vm2$LuaValue$$Ljava$lang$String$.call(this,var0,bytecoder.stringconstants[283]));
    var2 = (var1.Lorg$luaj$vm2$LuaValue$$call$Lorg$luaj$vm2$LuaValue$(this));
    return var2;
  }

  Lorg$luaj$vm2$LuaValue$$neg$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    org$luaj$vm2$LuaValue.$i;
    var0 = (org$luaj$vm2$LuaValue.UNM);
    var1 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$checkmetatag$Lorg$luaj$vm2$LuaValue$$Ljava$lang$String$.call(this,var0,bytecoder.stringconstants[284]));
    var2 = (var1.Lorg$luaj$vm2$LuaValue$$call$Lorg$luaj$vm2$LuaValue$(this));
    return var2;
  }

  Lorg$luaj$vm2$LuaValue$$pow$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    org$luaj$vm2$LuaValue.$i;
    var1 = (org$luaj$vm2$LuaValue.POW);
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$arithmt$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$.call(this,var1,var0));
    return var2;
  }

  Lorg$luaj$vm2$LuaValue$$mod$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    org$luaj$vm2$LuaValue.$i;
    var1 = (org$luaj$vm2$LuaValue.MOD);
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$arithmt$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$.call(this,var1,var0));
    return var2;
  }

  Lorg$luaj$vm2$LuaValue$$div$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    org$luaj$vm2$LuaValue.$i;
    var1 = (org$luaj$vm2$LuaValue.DIV);
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$arithmt$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$.call(this,var1,var0));
    return var2;
  }

  Lorg$luaj$vm2$LuaValue$$mul$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    org$luaj$vm2$LuaValue.$i;
    var1 = (org$luaj$vm2$LuaValue.MUL);
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$arithmt$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$.call(this,var1,var0));
    return var2;
  }

  Lorg$luaj$vm2$LuaValue$$get$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    var1 = var0;
    org$luaj$vm2$LuaValue.$i;
    var2 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaValue$$gettable$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(this,var1));
    return var2;
  }

  static Lorg$luaj$vm2$LuaValue$$gettable$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = null;
    var phi1 = null;
    var phi2 = null;
    var phi3 = 0;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = 0;
    var phi16 = null;
    var phi17 = null;
    var var18 = null;
    var phi19 = null;
    var var20 = null;
    var var21 = 0;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = 0;
    var var28 = null;
    var var29 = null;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = null;
    var var35 = 0;
    var var36 = null;
    var0 = arg1;
    phi1 = arg0;
    phi2 = var0;
    phi3 = (0) | 0;
    L2124957193: while(true) {
     var4 = phi1;
     var5 = (var4.Z$istable$$());
     If_15_0: {
      if (var5 == 0) {
       var31 = phi1;
       org$luaj$vm2$LuaValue.$i;
       var32 = (org$luaj$vm2$LuaValue.INDEX);
       var33 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$metatag$Lorg$luaj$vm2$LuaValue$.call(var31,var32));
       var34 = var33;
       var35 = (var33.Z$isnil$$());
       if (var35 == 0) {
        phi19 = var34;
        break If_15_0;
       } else {
        var36 = phi1;
        org$luaj$vm2$LuaValue.prototype.V$indexerror$$.call(var36);
        phi19 = var34;
        break If_15_0;
       }
      } else {
       var6 = phi1;
       var7 = phi2;
       var8 = (var6.Lorg$luaj$vm2$LuaValue$$rawget$Lorg$luaj$vm2$LuaValue$(var7));
       var9 = var8;
       var10 = (var9.Z$isnil$$());
       If_30_0: {
        if (var10 == 0) {
         phi17 = var8;
         break If_30_0;
        } else {
         var11 = phi1;
         org$luaj$vm2$LuaValue.$i;
         var12 = (org$luaj$vm2$LuaValue.INDEX);
         var13 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$metatag$Lorg$luaj$vm2$LuaValue$.call(var11,var12));
         var14 = var13;
         var15 = (var13.Z$isnil$$());
         if (var15 == 0) {
          // Here was a goto statement
          phi19 = var14;
          break If_15_0;
         } else {
          phi16 = var14;
          phi17 = var8;
          break If_30_0;
         }
        }
       }
       var18 = phi17;
       return var18;
      }
     }
     var20 = phi19;
     var21 = (var20.Z$isfunction$$());
     if (var21 == 0) {
      var26 = phi19;
      phi3 = ((phi3 + 1)) | 0;
      var27 = (phi3) | 0;
      if (var27 < 100) {
       phi1 = var26;
       continue L2124957193;
      } else {
       var28 = bytecoder.stringconstants[285];
       org$luaj$vm2$LuaValue.$i;
       var29 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaValue$$error$Ljava$lang$String$(var28));
       var30 = (org$luaj$vm2$LuaValue.NIL);
       return var30;
      }
     } else {
      var22 = phi19;
      var23 = phi1;
      var24 = phi2;
      var25 = (var22.Lorg$luaj$vm2$LuaValue$$call$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(var23,var24));
      return var25;
     }
    }
  }

  V$indexerror$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var0 = new java$lang$StringBuffer();
    java$lang$StringBuffer.prototype.V$$init$$$.call(var0);
    var1 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var0,bytecoder.stringconstants[286]));
    var2 = (this.Ljava$lang$String$$typename$$());
    var3 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var1,var2));
    var4 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var3,bytecoder.stringconstants[287]));
    var5 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var4));
    org$luaj$vm2$LuaValue.$i;
    var6 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaValue$$error$Ljava$lang$String$(var5));
    return;
  }

  Z$isinttype$$() {
    var var0 = 0;
    var0 = (0) | 0;
    return var0;
  }

  I$toint$$() {
    var var0 = 0;
    var0 = (0) | 0;
    return var0;
  }

  Lorg$luaj$vm2$Varargs$$subargs$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var0 = (arg0) | 0;
    var1 = (1) | 0;
    if (var0 != var1) {
     var3 = (1) | 0;
     if (var0 <= var3) {
      var5 = bytecoder.stringconstants[290];
      org$luaj$vm2$LuaValue.$i;
      var6 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaValue$$argerror$I$Ljava$lang$String$(1,var5));
      return var6;
     } else {
      org$luaj$vm2$LuaValue.$i;
      var4 = (org$luaj$vm2$LuaValue.NONE);
      return var4;
     }
    } else {
     var2 = this;
     return var2;
    }
  }

  static Lorg$luaj$vm2$LuaValue$$argerror$I$Ljava$lang$String$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var0 = arg1;
    var1 = new org$luaj$vm2$LuaError();
    var2 = new java$lang$StringBuffer();
    java$lang$StringBuffer.prototype.V$$init$$$.call(var2);
    var3 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var2,bytecoder.stringconstants[291]));
    var4 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var3,arg0));
    var5 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var4,bytecoder.stringconstants[124]));
    var6 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var5,var0));
    var7 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var6));
    org$luaj$vm2$LuaError.prototype.V$$init$$Ljava$lang$String$.call(var1,var7);
    throw bytecoder.registerStack(var1, new Error().stack);
  }

  Lorg$luaj$vm2$Varargs$$onInvoke$Lorg$luaj$vm2$Varargs$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    var1 = var0;
    var2 = (this.Lorg$luaj$vm2$Varargs$$invoke$Lorg$luaj$vm2$Varargs$(var1));
    return var2;
  }

  static Lorg$luaj$vm2$LuaNumber$$valueOf$D(arg0) {
    var var0 = null;
    org$luaj$vm2$LuaDouble.$i;
    var0 = (org$luaj$vm2$LuaDouble.Lorg$luaj$vm2$LuaNumber$$valueOf$D(arg0));
    return var0;
  }

  D$todouble$$() {
    var var0 = .0;
    var0 = 0.0;
    return var0;
  }

  Lorg$luaj$vm2$LuaValue$$subFrom$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = .0;
    var var3 = null;
    var0 = (arg0) | 0;
    var1 = (var0) | 0;
    var2 = var1;
    var3 = (this.Lorg$luaj$vm2$LuaValue$$subFrom$D(var2));
    return var3;
  }

  Lorg$luaj$vm2$LuaValue$$subFrom$D(arg0) {
    var var0 = .0;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    org$luaj$vm2$LuaValue.$i;
    var1 = (org$luaj$vm2$LuaValue.SUB);
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$arithmtwith$Lorg$luaj$vm2$LuaValue$$D.call(this,var1,var0));
    return var2;
  }

  Lorg$luaj$vm2$LuaValue$$arithmtwith$Lorg$luaj$vm2$LuaValue$$D(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var phi13 = null;
    var phi14 = null;
    var phi15 = .0;
    var phi16 = null;
    var var17 = null;
    var var18 = .0;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var0 = arg0;
    var1 = var0;
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$metatag$Lorg$luaj$vm2$LuaValue$.call(this,var1));
    var3 = var2;
    var4 = (var3.Z$isnil$$());
    If_16_0: {
     if (var4 == 0) {
      phi13 = this;
      phi14 = var0;
      phi15 = arg1;
      phi16 = var2;
      break If_16_0;
     } else {
      var5 = new java$lang$StringBuffer();
      java$lang$StringBuffer.prototype.V$$init$$$.call(var5);
      var6 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var5,bytecoder.stringconstants[277]));
      var7 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$Object$.call(var6,var0));
      var8 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var7,bytecoder.stringconstants[382]));
      var9 = (this.Ljava$lang$String$$typename$$());
      var10 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var8,var9));
      var11 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var10));
      org$luaj$vm2$LuaValue.$i;
      var12 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaValue$$error$Ljava$lang$String$(var11));
      phi13 = this;
      phi14 = var0;
      phi15 = arg1;
      phi16 = var2;
      break If_16_0;
     }
    }
    var17 = phi16;
    var18 = phi15;
    org$luaj$vm2$LuaValue.$i;
    var19 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaNumber$$valueOf$D(var18));
    var20 = phi13;
    var21 = (var17.Lorg$luaj$vm2$LuaValue$$call$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(var19,var20));
    return var21;
  }

  Lorg$luaj$vm2$LuaValue$$add$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = .0;
    var var3 = null;
    var0 = (arg0) | 0;
    var1 = (var0) | 0;
    var2 = var1;
    var3 = (this.Lorg$luaj$vm2$LuaValue$$add$D(var2));
    return var3;
  }

  Lorg$luaj$vm2$LuaValue$$add$D(arg0) {
    var var0 = .0;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    org$luaj$vm2$LuaValue.$i;
    var1 = (org$luaj$vm2$LuaValue.ADD);
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$arithmtwith$Lorg$luaj$vm2$LuaValue$$D.call(this,var1,var0));
    return var2;
  }

  Z$gteq_b$I(arg0) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var0 = (arg0) | 0;
    var1 = bytecoder.stringconstants[5];
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$compareerror$Ljava$lang$String$.call(this,var1));
    var3 = (0) | 0;
    return var3;
  }

  Z$lteq_b$I(arg0) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var0 = (arg0) | 0;
    var1 = bytecoder.stringconstants[5];
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$compareerror$Ljava$lang$String$.call(this,var1));
    var3 = (0) | 0;
    return var3;
  }

  Z$raweq$I(arg0) {
    var var0 = 0;
    var0 = (arg0) | 0;
    return 0;
  }

  Lorg$luaj$vm2$LuaValue$$concatTo$Lorg$luaj$vm2$LuaNumber$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    var1 = this;
    var2 = (var0.Lorg$luaj$vm2$LuaValue$$concatmt$Lorg$luaj$vm2$LuaValue$(var1));
    return var2;
  }

  Lorg$luaj$vm2$LuaValue$$powWith$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = .0;
    var var3 = null;
    var0 = (arg0) | 0;
    var1 = (var0) | 0;
    var2 = var1;
    var3 = (this.Lorg$luaj$vm2$LuaValue$$powWith$D(var2));
    return var3;
  }

  Lorg$luaj$vm2$LuaValue$$powWith$D(arg0) {
    var var0 = .0;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    org$luaj$vm2$LuaValue.$i;
    var1 = (org$luaj$vm2$LuaValue.POW);
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$arithmtwith$Lorg$luaj$vm2$LuaValue$$D.call(this,var1,var0));
    return var2;
  }

  Lorg$luaj$vm2$LuaValue$$modFrom$D(arg0) {
    var var0 = .0;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    org$luaj$vm2$LuaValue.$i;
    var1 = (org$luaj$vm2$LuaValue.MOD);
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$arithmtwith$Lorg$luaj$vm2$LuaValue$$D.call(this,var1,var0));
    return var2;
  }

  Lorg$luaj$vm2$LuaValue$$divInto$D(arg0) {
    var var0 = .0;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    org$luaj$vm2$LuaValue.$i;
    var1 = (org$luaj$vm2$LuaValue.DIV);
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$arithmtwith$Lorg$luaj$vm2$LuaValue$$D.call(this,var1,var0));
    return var2;
  }

  Lorg$luaj$vm2$LuaValue$$mul$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = .0;
    var var3 = null;
    var0 = (arg0) | 0;
    var1 = (var0) | 0;
    var2 = var1;
    var3 = (this.Lorg$luaj$vm2$LuaValue$$mul$D(var2));
    return var3;
  }

  Lorg$luaj$vm2$LuaValue$$mul$D(arg0) {
    var var0 = .0;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    org$luaj$vm2$LuaValue.$i;
    var1 = (org$luaj$vm2$LuaValue.MUL);
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$arithmtwith$Lorg$luaj$vm2$LuaValue$$D.call(this,var1,var0));
    return var2;
  }

  V$set$Ljava$lang$String$$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    var1 = var0;
    org$luaj$vm2$LuaValue.$i;
    var2 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(var1));
    this.V$set$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(var2,arg1);
    return;
  }

  V$set$Ljava$lang$String$$D(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var0 = arg0;
    var1 = var0;
    org$luaj$vm2$LuaValue.$i;
    var2 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(var1));
    var3 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaNumber$$valueOf$D(arg1));
    this.V$set$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(var2,var3);
    return;
  }

  Lorg$luaj$vm2$LuaValue$$get$Ljava$lang$String$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var0 = arg0;
    var1 = var0;
    org$luaj$vm2$LuaValue.$i;
    var2 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(var1));
    var3 = (this.Lorg$luaj$vm2$LuaValue$$get$Lorg$luaj$vm2$LuaValue$(var2));
    return var3;
  }

  I$strcmp$Lorg$luaj$vm2$LuaString$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var0 = arg0;
    var1 = new java$lang$StringBuffer();
    java$lang$StringBuffer.prototype.V$$init$$$.call(var1);
    var2 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var1,bytecoder.stringconstants[280]));
    var3 = (this.Ljava$lang$String$$typename$$());
    var4 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var2,var3));
    var5 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var4));
    org$luaj$vm2$LuaValue.$i;
    var6 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaValue$$error$Ljava$lang$String$(var5));
    var7 = (0) | 0;
    return var7;
  }

  Lorg$luaj$vm2$LuaValue$$concatTo$Lorg$luaj$vm2$LuaString$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    var1 = this;
    var2 = (var0.Lorg$luaj$vm2$LuaValue$$concatmt$Lorg$luaj$vm2$LuaValue$(var1));
    return var2;
  }

  Z$gteq_b$D(arg0) {
    var var0 = .0;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var0 = arg0;
    var1 = bytecoder.stringconstants[5];
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$compareerror$Ljava$lang$String$.call(this,var1));
    var3 = (0) | 0;
    return var3;
  }

  Z$lteq_b$D(arg0) {
    var var0 = .0;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var0 = arg0;
    var1 = bytecoder.stringconstants[5];
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$compareerror$Ljava$lang$String$.call(this,var1));
    var3 = (0) | 0;
    return var3;
  }

  Z$gt_b$D(arg0) {
    var var0 = .0;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var0 = arg0;
    var1 = bytecoder.stringconstants[5];
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$compareerror$Ljava$lang$String$.call(this,var1));
    var3 = (0) | 0;
    return var3;
  }

  Z$raweq$D(arg0) {
    var var0 = .0;
    var0 = arg0;
    return 0;
  }

  Lorg$luaj$vm2$Globals$$checkglobals$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = bytecoder.stringconstants[411];
    var1 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$argerror$Ljava$lang$String$.call(this,var0));
    var2 = null;
    return var2;
  }

  Z$isvalidkey$$() {
    var var0 = 0;
    var0 = (1) | 0;
    return var0;
  }

  static Z$eqmtcall$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(arg0,arg1,arg2,arg3) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var phi9 = null;
    var phi10 = null;
    var phi11 = null;
    var phi12 = null;
    var phi13 = null;
    var phi14 = 0;
    var var15 = null;
    var var16 = null;
    var var17 = 0;
    var0 = arg1;
    var1 = arg3;
    org$luaj$vm2$LuaValue.$i;
    var2 = (org$luaj$vm2$LuaValue.EQ);
    var3 = (var0.Lorg$luaj$vm2$LuaValue$$rawget$Lorg$luaj$vm2$LuaValue$(var2));
    var4 = var3;
    var5 = (var4.Z$isnil$$());
    If_22_0: {
     If_22_1: {
      if (var5 != 0) {
       phi9 = arg0;
       phi10 = var0;
       phi11 = arg2;
       phi12 = var1;
       phi13 = var3;
       break If_22_1;
      } else {
       var6 = var3;
       var7 = (org$luaj$vm2$LuaValue.EQ);
       var8 = (var1.Lorg$luaj$vm2$LuaValue$$rawget$Lorg$luaj$vm2$LuaValue$(var7));
       if (var6 == var8) {
        var15 = arg0;
        var16 = (var3.Lorg$luaj$vm2$LuaValue$$call$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(var15,arg2));
        var17 = (var16.Z$toboolean$$());
        phi9 = arg0;
        phi10 = var0;
        phi11 = arg2;
        phi12 = var1;
        phi13 = var3;
        phi14 = (var17) | 0;
        break If_22_0;
       } else {
        phi9 = arg0;
        phi10 = var0;
        phi11 = arg2;
        phi12 = var1;
        phi13 = var3;
        break If_22_1;
       }
      }
     }
     // Here was a goto statement
     phi14 = (0) | 0;
     break If_22_0;
    }
    return phi14;
  }

  Lorg$luaj$vm2$LuaTable$$opttable$Lorg$luaj$vm2$LuaTable$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var0 = arg0;
    var1 = bytecoder.stringconstants[7];
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$argerror$Ljava$lang$String$.call(this,var1));
    var3 = null;
    return var3;
  }

  Lorg$luaj$vm2$LuaValue$$setmetatable$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    var1 = bytecoder.stringconstants[7];
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$argerror$Ljava$lang$String$.call(this,var1));
    return var2;
  }

  D$checkdouble$$() {
    var var0 = null;
    var var1 = null;
    var var2 = .0;
    var0 = bytecoder.stringconstants[38];
    var1 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$argerror$Ljava$lang$String$.call(this,var0));
    var2 = 0.0;
    return var2;
  }

  I$rawlen$$() {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var0 = bytecoder.stringconstants[430];
    var1 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$typerror$Ljava$lang$String$.call(this,var0));
    var2 = (0) | 0;
    return var2;
  }

  Z$isthread$$() {
    var var0 = 0;
    var0 = (0) | 0;
    return var0;
  }

  Lorg$luaj$vm2$LuaThread$$checkthread$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = bytecoder.stringconstants[10];
    var1 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$argerror$Ljava$lang$String$.call(this,var0));
    var2 = null;
    return var2;
  }

  Lorg$luaj$vm2$LuaFunction$$optfunction$Lorg$luaj$vm2$LuaFunction$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var0 = arg0;
    var1 = bytecoder.stringconstants[8];
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$argerror$Ljava$lang$String$.call(this,var1));
    var3 = null;
    return var3;
  }

  Ljava$lang$String$$optjstring$Ljava$lang$String$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var0 = arg0;
    var1 = bytecoder.stringconstants[435];
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$argerror$Ljava$lang$String$.call(this,var1));
    var3 = null;
    return var3;
  }

  I$optint$I(arg0) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var0 = (arg0) | 0;
    var1 = bytecoder.stringconstants[36];
    var2 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$argerror$Ljava$lang$String$.call(this,var1));
    var3 = (0) | 0;
    return var3;
  }

  Z$isuserdata$$() {
    var var0 = 0;
    var0 = (0) | 0;
    return var0;
  }

  Lorg$luaj$vm2$LuaNumber$$checknumber$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = bytecoder.stringconstants[5];
    var1 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$argerror$Ljava$lang$String$.call(this,var0));
    var2 = null;
    return var2;
  }

  Lorg$luaj$vm2$LuaFunction$$checkfunction$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = bytecoder.stringconstants[8];
    var1 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$argerror$Ljava$lang$String$.call(this,var0));
    var2 = null;
    return var2;
  }

  Lorg$luaj$vm2$LuaValue$$aritherror$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var0 = new org$luaj$vm2$LuaError();
    var1 = new java$lang$StringBuffer();
    java$lang$StringBuffer.prototype.V$$init$$$.call(var1);
    var2 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var1,bytecoder.stringconstants[284]));
    var3 = (this.Ljava$lang$String$$typename$$());
    var4 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var2,var3));
    var5 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var4));
    org$luaj$vm2$LuaError.prototype.V$$init$$Ljava$lang$String$.call(var0,var5);
    throw bytecoder.registerStack(var0, new Error().stack);
  }

  Z$isnumber$$() {
    var var0 = 0;
    var0 = (0) | 0;
    return var0;
  }

  Ljava$lang$Object$$checkuserdata$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = bytecoder.stringconstants[9];
    var1 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$argerror$Ljava$lang$String$.call(this,var0));
    var2 = null;
    return var2;
  }

  static Lorg$luaj$vm2$Metatable$$metatableOf$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = 0;
    var var11 = 0;
    var phi12 = null;
    var phi13 = null;
    var phi14 = null;
    var phi15 = 0;
    var var16 = 0;
    var var17 = null;
    var var18 = 0;
    var var19 = 0;
    var phi20 = 0;
    var phi21 = 0;
    var var22 = 0;
    var var23 = 0;
    var var24 = 0;
    var phi25 = 0;
    var var26 = null;
    var var27 = 0;
    var var28 = 0;
    var var29 = null;
    var phi30 = 0;
    var var31 = null;
    var var32 = null;
    var phi33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = null;
    If_2_0: {
     if (arg0 == null) {
      phi33 = arg0;
      break If_2_0;
     } else {
      var0 = arg0;
      var1 = (var0.Z$istable$$());
      if (var1 == 0) {
       phi33 = arg0;
       break If_2_0;
      } else {
       var2 = arg0;
       org$luaj$vm2$LuaValue.$i;
       var3 = (org$luaj$vm2$LuaValue.MODE);
       var4 = (var2.Lorg$luaj$vm2$LuaValue$$rawget$Lorg$luaj$vm2$LuaValue$(var3));
       var5 = var4;
       var6 = (var5.Z$isstring$$());
       If_27_0: {
        if (var6 == 0) {
         phi12 = arg0;
         phi13 = var4;
         break If_27_0;
        } else {
         var7 = var4;
         var8 = (var7.Ljava$lang$String$$tojstring$$());
         var9 = var8;
         var10 = ((java$lang$String.prototype.I$indexOf$I.call(var9,107))) | 0;
         If_41_0: {
          if (var10 < 0) {
           phi12 = arg0;
           phi13 = var4;
           phi14 = var8;
           phi15 = (0) | 0;
           break If_41_0;
          } else {
           var11 = (1) | 0;
           // Here was a goto statement
           phi12 = arg0;
           phi13 = var4;
           phi14 = var8;
           phi15 = (var11) | 0;
           break If_41_0;
          }
         }
         var16 = (phi15) | 0;
         var17 = phi14;
         var18 = ((java$lang$String.prototype.I$indexOf$I.call(var17,118))) | 0;
         If_61_0: {
          if (var18 < 0) {
           phi20 = (var16) | 0;
           phi21 = (0) | 0;
           break If_61_0;
          } else {
           var19 = (1) | 0;
           // Here was a goto statement
           phi20 = (var16) | 0;
           phi21 = (var19) | 0;
           break If_61_0;
          }
         }
         var22 = (phi21) | 0;
         var23 = (phi20) | 0;
         If_75_0: {
          if (var23 != 0) {
           phi25 = (var22) | 0;
           break If_75_0;
          } else {
           var24 = (var22) | 0;
           if (var24 == 0) {
            phi30 = (var22) | 0;
            break If_27_0;
           } else {
            phi25 = (var22) | 0;
            break If_75_0;
           }
          }
         }
         var26 = new org$luaj$vm2$WeakTable();
         var27 = (phi20) | 0;
         var28 = (phi25) | 0;
         var29 = phi12;
         org$luaj$vm2$WeakTable.prototype.V$$init$$Z$Z$Lorg$luaj$vm2$LuaValue$.call(var26,var27,var28,var29);
         return var26;
        }
       }
       var31 = phi12;
       var32 = var31;
       return var32;
      }
     }
    }
    var34 = phi33;
    if (var34 == null) {
     return null;
    } else {
     var35 = new org$luaj$vm2$NonTableMetatable();
     var36 = phi33;
     org$luaj$vm2$NonTableMetatable.prototype.V$$init$$Lorg$luaj$vm2$LuaValue$.call(var35,var36);
     return var35;
    }
  }

  I$checkint$$() {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var0 = bytecoder.stringconstants[36];
    var1 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$argerror$Ljava$lang$String$.call(this,var0));
    var2 = (0) | 0;
    return var2;
  }

  J$checklong$$() {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var0 = bytecoder.stringconstants[39];
    var1 = (org$luaj$vm2$LuaValue.prototype.Lorg$luaj$vm2$LuaValue$$argerror$Ljava$lang$String$.call(this,var0));
    var2 = 0;
    return var2;
  }

  Z$raweq$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var phi3 = null;
    var phi4 = null;
    var phi5 = 0;
    var0 = arg0;
    var1 = var0;
    If_7_0: {
     if (this != var1) {
      phi3 = this;
      phi4 = var0;
      phi5 = (0) | 0;
      break If_7_0;
     } else {
      var2 = (1) | 0;
      // Here was a goto statement
      phi3 = this;
      phi4 = var0;
      phi5 = (var2) | 0;
      break If_7_0;
     }
    }
    return phi5;
  }

  Lorg$luaj$vm2$LuaValue$$tonumber$$() {
    var var0 = null;
    org$luaj$vm2$LuaValue.$i;
    var0 = (org$luaj$vm2$LuaValue.NIL);
    return var0;
  }

  Lorg$luaj$vm2$LuaValue$$strongvalue$$() {
    return this;
  }

  Z$isboolean$$() {
    var var0 = 0;
    var0 = (0) | 0;
    return var0;
  }

  Z$raweq$Lorg$luaj$vm2$LuaUserdata$(arg0) {
    var var0 = null;
    var0 = arg0;
    return 0;
  }

  Lorg$luaj$vm2$LuaValue$$illegal$Ljava$lang$String$$Ljava$lang$String$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var0 = arg0;
    var1 = new org$luaj$vm2$LuaError();
    var2 = new java$lang$StringBuffer();
    java$lang$StringBuffer.prototype.V$$init$$$.call(var2);
    var3 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var2,bytecoder.stringconstants[449]));
    var4 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var3,var0));
    var5 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var4,bytecoder.stringconstants[450]));
    var6 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var5,arg1));
    var7 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var6));
    org$luaj$vm2$LuaError.prototype.V$$init$$Ljava$lang$String$.call(var1,var7);
    throw bytecoder.registerStack(var1, new Error().stack);
  }

  static Lorg$luaj$vm2$LuaUserdata$$userdataOf$Ljava$lang$Object$$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg1;
    org$luaj$vm2$LuaUserdata.$i;
    var1 = new org$luaj$vm2$LuaUserdata();
    var2 = arg0;
    org$luaj$vm2$LuaUserdata.prototype.V$$init$$Ljava$lang$Object$$Lorg$luaj$vm2$LuaValue$.call(var1,var2,var0);
    return var1;
  }
}


class java$lang$Thread extends java$lang$Object {
  nativeObject = null;

  static MAIN_THREAD = null;
  threadGroup = null;
  runnable = null;
  name = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Thread,[java$lang$Object,java$lang$Thread,java$lang$Runnable]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  static Ljava$lang$Thread$$currentThread$$() {
    // source file is Thread.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    // line number 26
    var0 = (java$lang$Thread.MAIN_THREAD);
    If_8_0: {
     if (var0 != null) {
      break If_8_0;
     } else {
      // line number 27
      java$lang$ThreadGroup.$i;
      var1 = new java$lang$ThreadGroup();
      de$mirkosertic$bytecoder$classlib$java$lang$TThreadGroup.$i;
      var2 = (de$mirkosertic$bytecoder$classlib$java$lang$TThreadGroup.SYSTEM);
      var3 = var2;
      java$lang$ThreadGroup.prototype.V$$init$$Ljava$lang$ThreadGroup$$Ljava$lang$String$.call(var1,var3,bytecoder.stringconstants[72]);
      // line number 28
      var4 = new java$lang$Thread();
      var5 = var1;
      java$lang$Thread.prototype.V$$init$$Ljava$lang$ThreadGroup$$Ljava$lang$String$.call(var4,var5,bytecoder.stringconstants[72]);
      java$lang$Thread.MAIN_THREAD = var4;
      break If_8_0;
     }
    }
    // line number 30
    var6 = (java$lang$Thread.MAIN_THREAD);
    return var6;
  }

  V$$init$$Ljava$lang$ThreadGroup$$Ljava$lang$String$(arg0,arg1) {
    // source file is Thread.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var0 = arg0;
    // line number 62
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 63
    var1 = this;
    var1.threadGroup = var0;
    // line number 64
    var2 = this;
    var2.runnable = null;
    // line number 65
    var3 = this;
    var3.name = arg1;
    // line number 66
    return;
  }

  Z$isVirtual$$() {
    // source file is Thread.java
    // line number 153
    return 0;
  }

  V$$init$$$() {
    // source file is Thread.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    // line number 38
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 39
    var0 = this;
    var0.runnable = null;
    // line number 40
    var1 = this;
    de$mirkosertic$bytecoder$classlib$java$lang$TThreadGroup.$i;
    var2 = (de$mirkosertic$bytecoder$classlib$java$lang$TThreadGroup.SYSTEM);
    var3 = var2;
    var1.threadGroup = var3;
    // line number 41
    var4 = this;
    var4.name = bytecoder.stringconstants[151];
    // line number 42
    return;
  }

  V$interrupt$$() {
    // source file is Thread.java
    // line number 88
    return;
  }
}


class java$lang$Boolean extends java$lang$Object {
  nativeObject = null;

  value = false;
  static TRUE = null;
  static FALSE = null;
  static TYPE = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Boolean,[java$lang$Object,java$lang$Boolean,java$io$Serializable,java$lang$Comparable,java$lang$constant$Constable]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
    this.I$compareTo$Ljava$lang$Object$ = impl;
  }

  static V$$clinit$$$() {
    // source file is Boolean.java
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    // line number 68
    java$lang$Boolean.$i;
    var0 = new java$lang$Boolean();
    var1 = (1) | 0;
    java$lang$Boolean.prototype.V$$init$$Z.call(var0,var1);
    java$lang$Boolean.TRUE = var0;
    // line number 74
    var2 = new java$lang$Boolean();
    java$lang$Boolean.prototype.V$$init$$Z.call(var2,0);
    java$lang$Boolean.FALSE = var2;
    // line number 82
    var3 = (java$lang$Class.Ljava$lang$Class$$getPrimitiveClass$Ljava$lang$String$(bytecoder.stringconstants[3]));
    java$lang$Boolean.TYPE = var3;
    return;
  }

  V$$init$$Z(arg0) {
    // source file is Boolean.java
    var var0 = 0;
    var var1 = null;
    var0 = arg0;
    // line number 109
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 110
    var1 = this;
    var1.value = var0;
    // line number 111
    return;
  }

  I$compareTo$Ljava$lang$Object$(arg0) {
    // source file is Boolean.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var0 = arg0;
    // line number 60
    var1 = var0;
    var2 = var1;
    var3 = ((java$lang$Boolean.prototype.I$compareTo$Ljava$lang$Boolean$.call(this,var2))) | 0;
    return var3;
  }

  I$compareTo$Ljava$lang$Boolean$(arg0) {
    // source file is Boolean.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var0 = arg0;
    // line number 302
    var1 = (this.value);
    var2 = (var0.value);
    java$lang$Boolean.$i;
    var3 = ((java$lang$Boolean.I$compare$Z$Z(var1,var2))) | 0;
    return var3;
  }

  static I$compare$Z$Z(arg0,arg1) {
    // source file is Boolean.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var phi3 = 0;
    var phi4 = 0;
    var phi5 = 0;
    var var6 = 0;
    var0 = arg1;
    // line number 320
    var1 = var0;
    If_9_0: {
     if (arg0 != var1) {
      if (arg0 == 0) {
       phi3 = arg0;
       phi4 = var0;
       phi5 = (-1) | 0;
       break If_9_0;
      } else {
       var6 = (1) | 0;
       // Here was a goto statement
       phi3 = arg0;
       phi4 = var0;
       phi5 = (var6) | 0;
       break If_9_0;
      }
     } else {
      var2 = (0) | 0;
      // Here was a goto statement
      phi3 = arg0;
      phi4 = var0;
      phi5 = (var2) | 0;
      break If_9_0;
     }
    }
    return phi5;
  }

  Ljava$lang$String$$toString$$() {
    // source file is Boolean.java
    var var0 = 0;
    var var1 = null;
    // line number 221
    var0 = (this.value);
    var1 = (java$lang$String.Ljava$lang$String$$valueOf$Z(var0));
    return var1;
  }

  Z$equals$Ljava$lang$Object$(arg0) {
    // source file is Boolean.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var phi6 = null;
    var phi7 = null;
    var phi8 = 0;
    var0 = arg0;
    // line number 258
    var1 = (bytecoder.instanceOf(var0,java$lang$Boolean)) | 0;
    if (var1 == 0) {
     // line number 261
     return 0;
    } else {
     // line number 259
     var2 = (this.value);
     var3 = var0;
     var4 = (java$lang$Boolean.prototype.Z$booleanValue$$.call(var3));
     If_25_0: {
      if (var2 != var4) {
       phi6 = this;
       phi7 = var0;
       phi8 = (0) | 0;
       break If_25_0;
      } else {
       var5 = (1) | 0;
       // Here was a goto statement
       phi6 = this;
       phi7 = var0;
       phi8 = (var5) | 0;
       break If_25_0;
      }
     }
     return phi8;
    }
  }

  Z$booleanValue$$() {
    // source file is Boolean.java
    var var0 = 0;
    // line number 160
    var0 = (this.value);
    return var0;
  }

  I$hashCode$$() {
    // source file is Boolean.java
    var var0 = 0;
    var var1 = 0;
    // line number 233
    var0 = (this.value);
    java$lang$Boolean.$i;
    var1 = ((java$lang$Boolean.I$hashCode$Z(var0))) | 0;
    return var1;
  }

  static I$hashCode$Z(arg0) {
    // source file is Boolean.java
    var var0 = 0;
    var phi1 = 0;
    var phi2 = 0;
    // line number 245
    If_4_0: {
     if (arg0 == 0) {
      phi1 = arg0;
      phi2 = 1237;
      break If_4_0;
     } else {
      var0 = 1231;
      // Here was a goto statement
      phi1 = arg0;
      phi2 = var0;
      break If_4_0;
     }
    }
    return phi2;
  }
}


class java$lang$Exception extends java$lang$Throwable {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Exception,[java$lang$Object,java$lang$Exception,java$lang$Throwable]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Ljava$lang$String$(arg0) {
    // source file is Exception.java
    var var0 = null;
    var var1 = null;
    var0 = arg0;
    // line number 67
    var1 = var0;
    java$lang$Throwable.prototype.V$$init$$Ljava$lang$String$.call(this,var1);
    // line number 68
    return;
  }

  V$$init$$$() {
    // source file is Exception.java
    // line number 55
    java$lang$Throwable.prototype.V$$init$$$.call(this);
    // line number 56
    return;
  }

  V$$init$$Ljava$lang$Throwable$(arg0) {
    // source file is Exception.java
    var var0 = null;
    var var1 = null;
    var0 = arg0;
    // line number 103
    var1 = var0;
    java$lang$Throwable.prototype.V$$init$$Ljava$lang$Throwable$.call(this,var1);
    // line number 104
    return;
  }
}


class java$util$Collection extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$Collection,[java$lang$Object,java$lang$Iterable,java$util$Collection]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class org$luaj$vm2$WeakTable extends java$lang$Object {
  nativeObject = null;

  weakkeys = false;
  weakvalues = false;
  backing = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$WeakTable,[java$lang$Object,org$luaj$vm2$WeakTable,org$luaj$vm2$Metatable]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Z$Z$Lorg$luaj$vm2$LuaValue$(arg0,arg1,arg2) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var0 = arg0;
    var1 = arg2;
    java$lang$Object.prototype.V$$init$$$.call(this);
    var2 = this;
    var2.weakkeys = var0;
    var3 = this;
    var3.weakvalues = arg1;
    var4 = this;
    var4.backing = var1;
    return;
  }

  Lorg$luaj$vm2$LuaValue$$toLuaValue$$() {
    var var0 = null;
    var0 = (this.backing);
    return var0;
  }

  Lorg$luaj$vm2$LuaValue$$arrayget$$Lorg$luaj$vm2$LuaValue$$I(arg0,arg1) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var phi9 = null;
    var phi10 = null;
    var phi11 = 0;
    var phi12 = null;
    var var13 = null;
    var0 = arg0;
    var1 = (arg1) | 0;
    var2 = (var0.data[var1]);
    var3 = var2;
    If_13_0: {
     if (var3 == null) {
      phi9 = this;
      phi10 = var0;
      phi11 = (arg1) | 0;
      phi12 = var2;
      break If_13_0;
     } else {
      var4 = var2;
      var5 = (org$luaj$vm2$WeakTable.Lorg$luaj$vm2$LuaValue$$strengthen$Ljava$lang$Object$(var4));
      var6 = var5;
      if (var6 != null) {
       phi9 = this;
       phi10 = var0;
       phi11 = (arg1) | 0;
       phi12 = var5;
       break If_13_0;
      } else {
       var7 = var0;
       var8 = null;
       var7.data[arg1] = var8;
       phi9 = this;
       phi10 = var0;
       phi11 = (arg1) | 0;
       phi12 = var5;
       break If_13_0;
      }
     }
    }
    var13 = phi12;
    return var13;
  }

  static Lorg$luaj$vm2$LuaValue$$strengthen$Ljava$lang$Object$(arg0) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var phi4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var0 = (bytecoder.instanceOf(arg0,java$lang$ref$WeakReference)) | 0;
    If_6_0: {
     if (var0 == 0) {
      phi4 = arg0;
      break If_6_0;
     } else {
      var1 = arg0;
      var2 = var1;
      var3 = (var2.Ljava$lang$Object$$get$$());
      phi4 = var3;
      break If_6_0;
     }
    }
    var5 = phi4;
    var6 = (bytecoder.instanceOf(var5,org$luaj$vm2$WeakTable$WeakValue)) | 0;
    if (var6 == 0) {
     var10 = phi4;
     var11 = var10;
     return var11;
    } else {
     var7 = phi4;
     var8 = var7;
     var9 = (var8.Lorg$luaj$vm2$LuaValue$$strongvalue$$());
     return var9;
    }
  }

  Lorg$luaj$vm2$LuaValue$$wrap$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var phi4 = null;
    var phi5 = null;
    var phi6 = null;
    var0 = arg0;
    var1 = (this.weakvalues);
    If_8_0: {
     if (var1 == 0) {
      phi4 = this;
      phi5 = var0;
      phi6 = var0;
      break If_8_0;
     } else {
      var2 = var0;
      var3 = (org$luaj$vm2$WeakTable.Lorg$luaj$vm2$LuaValue$$weaken$Lorg$luaj$vm2$LuaValue$(var2));
      // Here was a goto statement
      phi4 = this;
      phi5 = var0;
      phi6 = var3;
      break If_8_0;
     }
    }
    return phi6;
  }

  static Lorg$luaj$vm2$LuaValue$$weaken$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var0 = ((arg0.I$type$$())) | 0;
    if ((var0) >= 5 && (var0) <= 8) switch ((var0) - 5) {
     case 0: {
      org$luaj$vm2$WeakTable$WeakValue.$i;
      var1 = new org$luaj$vm2$WeakTable$WeakValue();
      var2 = arg0;
      org$luaj$vm2$WeakTable$WeakValue.prototype.V$$init$$Lorg$luaj$vm2$LuaValue$.call(var1,var2);
      return var1;
     }
     case 1: {
      org$luaj$vm2$WeakTable$WeakValue.$i;
      var1 = new org$luaj$vm2$WeakTable$WeakValue();
      var2 = arg0;
      org$luaj$vm2$WeakTable$WeakValue.prototype.V$$init$$Lorg$luaj$vm2$LuaValue$.call(var1,var2);
      return var1;
     }
     case 2: {
      org$luaj$vm2$WeakTable$WeakUserdata.$i;
      var3 = new org$luaj$vm2$WeakTable$WeakUserdata();
      var4 = null;
      org$luaj$vm2$WeakTable$WeakUserdata.prototype.V$$init$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$WeakTable$1$.call(var3,arg0,var4);
      return var3;
     }
     case 3: {
      org$luaj$vm2$WeakTable$WeakValue.$i;
      var1 = new org$luaj$vm2$WeakTable$WeakValue();
      var2 = arg0;
      org$luaj$vm2$WeakTable$WeakValue.prototype.V$$init$$Lorg$luaj$vm2$LuaValue$.call(var1,var2);
      return var1;
     }
    } else {
     return arg0;
    }
  }

  Z$useWeakKeys$$() {
    var var0 = 0;
    var0 = (this.weakkeys);
    return var0;
  }

  Z$useWeakValues$$() {
    var var0 = 0;
    var0 = (this.weakvalues);
    return var0;
  }

  Lorg$luaj$vm2$LuaTable$Slot$$entry$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = 0;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = 0;
    var var13 = null;
    var var14 = 0;
    var var15 = null;
    var var16 = 0;
    var var17 = null;
    var var18 = 0;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var phi22 = null;
    var phi23 = null;
    var phi24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var phi28 = null;
    var phi29 = null;
    var phi30 = null;
    var var31 = null;
    var var32 = 0;
    var var33 = null;
    var var34 = 0;
    var var35 = null;
    var var36 = 0;
    var var37 = null;
    var var38 = 0;
    var var39 = null;
    var var40 = null;
    var var41 = null;
    var var42 = null;
    var var43 = null;
    var var44 = null;
    var0 = arg0;
    var1 = (arg1.Lorg$luaj$vm2$LuaValue$$strongvalue$$());
    var2 = var1;
    if (var2 != null) {
     var4 = (this.weakkeys);
     If_21_0: {
      if (var4 == 0) {
       phi28 = this;
       phi29 = var0;
       phi30 = var1;
       break If_21_0;
      } else {
       var5 = var0;
       var6 = (var5.Z$isnumber$$());
       if (var6 != 0) {
        phi28 = this;
        phi29 = var0;
        phi30 = var1;
        break If_21_0;
       } else {
        var7 = var0;
        var8 = (var7.Z$isstring$$());
        if (var8 != 0) {
         phi28 = this;
         phi29 = var0;
         phi30 = var1;
         break If_21_0;
        } else {
         var9 = var0;
         var10 = (var9.Z$isboolean$$());
         if (var10 != 0) {
          phi28 = this;
          phi29 = var0;
          phi30 = var1;
          break If_21_0;
         } else {
          var11 = this;
          var12 = (var11.weakvalues);
          If_53_0: {
           if (var12 == 0) {
            phi22 = this;
            phi23 = var0;
            phi24 = var1;
            break If_53_0;
           } else {
            var13 = var1;
            var14 = (var13.Z$isnumber$$());
            if (var14 != 0) {
             phi22 = this;
             phi23 = var0;
             phi24 = var1;
             break If_53_0;
            } else {
             var15 = var1;
             var16 = (var15.Z$isstring$$());
             if (var16 != 0) {
              phi22 = this;
              phi23 = var0;
              phi24 = var1;
              break If_53_0;
             } else {
              var17 = var1;
              var18 = (var17.Z$isboolean$$());
              if (var18 != 0) {
               phi22 = this;
               phi23 = var0;
               phi24 = var1;
               break If_53_0;
              } else {
               var19 = new org$luaj$vm2$WeakTable$WeakKeyAndValueSlot();
               var20 = var0;
               var21 = null;
               org$luaj$vm2$WeakTable$WeakKeyAndValueSlot.prototype.V$$init$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaTable$Slot$.call(var19,var20,var1,var21);
               return var19;
              }
             }
            }
           }
          }
          var25 = new org$luaj$vm2$WeakTable$WeakKeySlot();
          var26 = phi23;
          var27 = phi24;
          org$luaj$vm2$WeakTable$WeakKeySlot.prototype.V$$init$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaTable$Slot$.call(var25,var26,var27,null);
          return var25;
         }
        }
       }
      }
     }
     var31 = phi28;
     var32 = (var31.weakvalues);
     If_117_0: {
      if (var32 == 0) {
       break If_117_0;
      } else {
       var33 = phi30;
       var34 = (var33.Z$isnumber$$());
       if (var34 != 0) {
        break If_117_0;
       } else {
        var35 = phi30;
        var36 = (var35.Z$isstring$$());
        if (var36 != 0) {
         break If_117_0;
        } else {
         var37 = phi30;
         var38 = (var37.Z$isboolean$$());
         if (var38 != 0) {
          break If_117_0;
         } else {
          var39 = new org$luaj$vm2$WeakTable$WeakValueSlot();
          var40 = phi29;
          var41 = phi30;
          org$luaj$vm2$WeakTable$WeakValueSlot.prototype.V$$init$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaTable$Slot$.call(var39,var40,var41,null);
          return var39;
         }
        }
       }
      }
     }
     var42 = phi29;
     var43 = phi30;
     org$luaj$vm2$LuaTable.$i;
     var44 = (org$luaj$vm2$LuaTable.Lorg$luaj$vm2$LuaTable$Entry$$defaultEntry$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(var42,var43));
     return var44;
    } else {
     var3 = null;
     return var3;
    }
  }
}


class de$mirkosertic$bytecoder$classlib$BytecoderCharsetDecoder extends java$nio$charset$CharsetDecoder {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(de$mirkosertic$bytecoder$classlib$BytecoderCharsetDecoder,[java$lang$Object,de$mirkosertic$bytecoder$classlib$BytecoderCharsetDecoder,java$nio$charset$CharsetDecoder]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      java$nio$charset$CharsetDecoder.$i;
    }
    return this;
  }

  set $lambdaimpl(impl) {
    this.Ljava$nio$charset$CoderResult$$decodeLoop$Ljava$nio$ByteBuffer$$Ljava$nio$CharBuffer$ = impl;
  }

  V$$init$$Ljava$nio$charset$Charset$(arg0) {
    // source file is BytecoderCharsetDecoder.java
    var var0 = null;
    var var1 = null;
    var var2 = .0;
    var0 = arg0;
    // line number 27
    var1 = var0;
    var2 = 3.0;
    java$nio$charset$CharsetDecoder.prototype.V$$init$$Ljava$nio$charset$Charset$$F$F.call(this,var1,1.1,var2);
    // line number 28
    return;
  }

  Ljava$nio$charset$CoderResult$$decodeLoop$Ljava$nio$ByteBuffer$$Ljava$nio$CharBuffer$(arg0,arg1) {
    // source file is BytecoderCharsetDecoder.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var phi13 = null;
    var phi14 = null;
    var phi15 = null;
    var phi16 = null;
    var phi17 = null;
    var var18 = null;
    var0 = arg0;
    // line number 32
    var1 = (this.Ljava$nio$charset$Charset$$charset$$());
    // line number 33
    var2 = (var0.Z$hasRemaining$$());
    If_16_0: {
     if (var2 == 0) {
      phi13 = this;
      phi14 = var0;
      phi15 = arg1;
      phi16 = var1;
      break If_16_0;
     } else {
      // line number 34
      var3 = ((var0.I$remaining$$())) | 0;
      // line number 35
      var4 = bytecoder.newarray((var3),0);
      // line number 36
      var5 = var4;
      var6 = (var3) | 0;
      var7 = (var0.Ljava$nio$ByteBuffer$$get$$B$I$I(var5,0,var6));
      // line number 38
      var8 = var1;
      var9 = (java$nio$charset$Charset.prototype.Ljava$lang$String$$name$$.call(var8));
      var10 = (de$mirkosertic$bytecoder$classlib$BytecoderCharsetDecoder.prototype.$C$decodeFromBytes$Ljava$lang$String$$$B.call(this,var9,var4));
      // line number 39
      var11 = var10;
      var12 = (java$nio$CharBuffer.prototype.Ljava$nio$CharBuffer$$put$$C.call(arg1,var11));
      phi13 = this;
      phi14 = var0;
      phi15 = arg1;
      phi16 = var1;
      phi17 = var4;
      break If_16_0;
     }
    }
    // line number 41
    java$nio$charset$CoderResult.$i;
    var18 = (java$nio$charset$CoderResult.UNDERFLOW);
    return var18;
  }

  $C$decodeFromBytes$Ljava$lang$String$$$B(arg0,arg1) {
    return bytecoder.imports['de.mirkosertic.bytecoder.classlib.BytecoderCharsetDecoder'].$C$decodeFromBytes$Ljava$lang$String$$$B(this, arg0, arg1);
  }
}


class jdk$internal$util$Preconditions$4 extends java$lang$Object {
  nativeObject = null;

  val$f = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(jdk$internal$util$Preconditions$4,[java$lang$Object,java$util$function$BiFunction,jdk$internal$util$Preconditions$4]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.Ljava$lang$Object$$apply$Ljava$lang$Object$$Ljava$lang$Object$ = impl;
  }

  V$$init$$Ljava$util$function$Function$(arg0) {
    // source file is Preconditions.java
    var var0 = null;
    var var1 = null;
    var0 = this;
    // line number 210
    var1 = arg0;
    var0.val$f = var1;
    java$lang$Object.prototype.V$$init$$$.call(var0);
    return;
  }

  Ljava$lang$Object$$apply$Ljava$lang$Object$$Ljava$lang$Object$(arg0,arg1) {
    // source file is Preconditions.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var0 = arg0;
    // line number 210
    var1 = var0;
    var2 = var1;
    var3 = arg1;
    var4 = (jdk$internal$util$Preconditions$4.prototype.Ljava$lang$RuntimeException$$apply$Ljava$lang$String$$Ljava$util$List$.call(this,var2,var3));
    return var4;
  }

  Ljava$lang$RuntimeException$$apply$Ljava$lang$String$$Ljava$util$List$(arg0,arg1) {
    // source file is Preconditions.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var0 = arg0;
    // line number 213
    var1 = (this.val$f);
    var2 = arg1;
    jdk$internal$util$Preconditions.$i;
    var3 = (jdk$internal$util$Preconditions.Ljava$lang$String$$outOfBoundsMessage$Ljava$lang$String$$Ljava$util$List$(var0,var2));
    var4 = (var1.Ljava$lang$Object$$apply$Ljava$lang$Object$(var3));
    var5 = var4;
    return var5;
  }
}


class java$lang$Error extends java$lang$Throwable {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Error,[java$lang$Object,java$lang$Throwable,java$lang$Error]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Ljava$lang$String$(arg0) {
    // source file is Error.java
    var var0 = null;
    var var1 = null;
    var0 = arg0;
    // line number 67
    var1 = var0;
    java$lang$Throwable.prototype.V$$init$$Ljava$lang$String$.call(this,var1);
    // line number 68
    return;
  }

  V$$init$$Ljava$lang$Throwable$(arg0) {
    // source file is Error.java
    var var0 = null;
    var var1 = null;
    var0 = arg0;
    // line number 102
    var1 = var0;
    java$lang$Throwable.prototype.V$$init$$Ljava$lang$Throwable$.call(this,var1);
    // line number 103
    return;
  }

  V$$init$$$() {
    // source file is Error.java
    // line number 55
    java$lang$Throwable.prototype.V$$init$$$.call(this);
    // line number 56
    return;
  }
}


class org$luaj$vm2$Varargs$ArrayPartVarargs extends org$luaj$vm2$Varargs {
  nativeObject = null;

  v = null;
  offset = 0;
  length = 0;
  more = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$Varargs$ArrayPartVarargs,[java$lang$Object,org$luaj$vm2$Varargs$ArrayPartVarargs,org$luaj$vm2$Varargs]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$Lorg$luaj$vm2$LuaValue$$I$I$Lorg$luaj$vm2$Varargs$(arg0,arg1,arg2,arg3) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var0 = arg0;
    var1 = (arg2) | 0;
    org$luaj$vm2$Varargs.prototype.V$$init$$$.call(this);
    var2 = this;
    var2.v = var0;
    var3 = this;
    var3.offset = arg1;
    var4 = this;
    var4.length = var1;
    var5 = this;
    var5.more = arg3;
    return;
  }

  I$narg$$() {
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var0 = ((this.length)) | 0;
    var1 = (this.more);
    var2 = ((var1.I$narg$$())) | 0;
    var3 = ((var0 + var2)) | 0;
    return var3;
  }

  Lorg$luaj$vm2$LuaValue$$arg1$$() {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var phi5 = null;
    var phi6 = null;
    var var7 = null;
    var var8 = null;
    var0 = ((this.length)) | 0;
    If_5_0: {
     if (var0 <= 0) {
      var7 = (this.more);
      var8 = (var7.Lorg$luaj$vm2$LuaValue$$arg1$$());
      phi5 = this;
      phi6 = var8;
      break If_5_0;
     } else {
      var1 = this;
      var2 = (var1.v);
      var3 = ((this.offset)) | 0;
      var4 = (var2.data[var3]);
      // Here was a goto statement
      phi5 = this;
      phi6 = var4;
      break If_5_0;
     }
    }
    return phi6;
  }

  Lorg$luaj$vm2$LuaValue$$arg$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var phi3 = null;
    var phi4 = 0;
    var phi5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = 0;
    var var17 = 0;
    var var18 = null;
    var0 = (arg0) | 0;
    var1 = (1) | 0;
    If_8_0: {
     if (var0 >= var1) {
      var6 = this;
      var7 = ((var6.length)) | 0;
      if (var0 > var7) {
       var14 = (this.more);
       var15 = this;
       var16 = ((var15.length)) | 0;
       var17 = ((var0 - var16)) | 0;
       var18 = (var14.Lorg$luaj$vm2$LuaValue$$arg$I(var17));
       phi3 = this;
       phi4 = (var0) | 0;
       phi5 = var18;
       break If_8_0;
      } else {
       var8 = this;
       var9 = (var8.v);
       var10 = ((this.offset)) | 0;
       var11 = ((var10 + var0)) | 0;
       var12 = ((var11 - 1)) | 0;
       var13 = (var9.data[var12]);
       // Here was a goto statement
       phi3 = this;
       phi4 = (var0) | 0;
       phi5 = var13;
       break If_8_0;
      }
     } else {
      org$luaj$vm2$LuaValue.$i;
      var2 = (org$luaj$vm2$LuaValue.NIL);
      // Here was a goto statement
      phi3 = this;
      phi4 = (var0) | 0;
      phi5 = var2;
      break If_8_0;
     }
    }
    return phi5;
  }

  V$copyto$$Lorg$luaj$vm2$LuaValue$$I$I(arg0,arg1,arg2) {
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var var8 = null;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var0 = arg0;
    var1 = (arg2) | 0;
    var2 = ((this.length)) | 0;
    java$lang$Math.$i;
    var3 = ((java$lang$Math.I$min$I$I(var2,var1))) | 0;
    var4 = this;
    var5 = (var4.v);
    var6 = ((this.offset)) | 0;
    var7 = (arg1) | 0;
    java$lang$System.V$arraycopy$Ljava$lang$Object$$I$Ljava$lang$Object$$I$I(var5,var6,var0,var7,var3);
    var8 = (this.more);
    var9 = (var3) | 0;
    var10 = ((arg1 + var9)) | 0;
    var11 = (var3) | 0;
    var12 = ((var1 - var11)) | 0;
    var8.V$copyto$$Lorg$luaj$vm2$LuaValue$$I$I(var0,var10,var12);
    return;
  }

  Lorg$luaj$vm2$Varargs$$subargs$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var phi3 = null;
    var phi4 = 0;
    var var5 = 0;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = 0;
    var var10 = null;
    var var11 = null;
    var var12 = 0;
    var var13 = null;
    var var14 = 0;
    var var15 = 0;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = 0;
    var var21 = 0;
    var var22 = 0;
    var var23 = 0;
    var var24 = null;
    var var25 = 0;
    var var26 = 0;
    var var27 = 0;
    var var28 = 0;
    var var29 = null;
    var var30 = null;
    var var31 = null;
    var0 = (arg0) | 0;
    If_5_0: {
     if (var0 > 0) {
      phi3 = this;
      phi4 = (var0) | 0;
      break If_5_0;
     } else {
      var1 = (1) | 0;
      org$luaj$vm2$LuaValue.$i;
      var2 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaValue$$argerror$I$Ljava$lang$String$(var1,bytecoder.stringconstants[290]));
      phi3 = this;
      phi4 = (var0) | 0;
      break If_5_0;
     }
    }
    var5 = (phi4) | 0;
    if (var5 != 1) {
     var7 = (phi4) | 0;
     var8 = phi3;
     var9 = ((var8.length)) | 0;
     if (var7 <= var9) {
      var17 = phi3;
      var18 = (var17.v);
      var19 = phi3;
      var20 = ((var19.offset)) | 0;
      var21 = (phi4) | 0;
      var22 = ((var20 + var21)) | 0;
      var23 = ((var22 - 1)) | 0;
      var24 = phi3;
      var25 = ((var24.length)) | 0;
      var26 = (phi4) | 0;
      var27 = ((var26 - 1)) | 0;
      var28 = ((var25 - var27)) | 0;
      var29 = phi3;
      var30 = (var29.more);
      org$luaj$vm2$LuaValue.$i;
      var31 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$Varargs$$varargsOf$$Lorg$luaj$vm2$LuaValue$$I$I$Lorg$luaj$vm2$Varargs$(var18,var23,var28,var30));
      return var31;
     } else {
      var10 = phi3;
      var11 = (var10.more);
      var12 = (phi4) | 0;
      var13 = phi3;
      var14 = ((var13.length)) | 0;
      var15 = ((var12 - var14)) | 0;
      var16 = (var11.Lorg$luaj$vm2$Varargs$$subargs$I(var15));
      return var16;
     }
    } else {
     var6 = phi3;
     return var6;
    }
  }
}


class org$luaj$vm2$LuaThread$State extends java$lang$Object {
  nativeObject = null;

  args = null;
  result = null;
  error = null;
  status = 0;
  globals = null;
  lua_thread = null;
  function = null;
  inhook = false;
  hookcall = false;
  hookfunc = null;
  hookrtrn = false;
  hookcount = 0;
  bytecodes = 0;
  hookline = false;
  lastline = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$LuaThread$State,[org$luaj$vm2$LuaThread$State,java$lang$Object,java$lang$Runnable]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Lorg$luaj$vm2$Globals$$Lorg$luaj$vm2$LuaThread$$Lorg$luaj$vm2$LuaValue$(arg0,arg1,arg2) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var0 = arg0;
    var1 = arg2;
    java$lang$Object.prototype.V$$init$$$.call(this);
    var2 = this;
    org$luaj$vm2$LuaValue.$i;
    var3 = (org$luaj$vm2$LuaValue.NONE);
    var2.args = var3;
    var4 = this;
    var5 = (org$luaj$vm2$LuaValue.NONE);
    var4.result = var5;
    var6 = this;
    var6.error = null;
    var7 = this;
    var7.status = 0;
    var8 = this;
    var8.globals = var0;
    var9 = this;
    var10 = new java$lang$ref$WeakReference();
    var11 = arg1;
    java$lang$ref$WeakReference.prototype.V$$init$$Ljava$lang$Object$.call(var10,var11);
    var9.lua_thread = var10;
    var12 = this;
    var12.function = var1;
    return;
  }
}


class org$luaj$vm2$Print extends org$luaj$vm2$Lua {
  nativeObject = null;

  static ps = null;
  static OPNAMES = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$Print,[java$lang$Object,org$luaj$vm2$Print,org$luaj$vm2$Lua]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      org$luaj$vm2$Lua.$i;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = 0;
    var var17 = 0;
    var var18 = 0;
    var var19 = 0;
    var var20 = 0;
    var var21 = 0;
    var var22 = 0;
    var var23 = 0;
    var var24 = 0;
    var var25 = 0;
    var var26 = 0;
    var var27 = 0;
    var var28 = 0;
    var var29 = 0;
    var var30 = 0;
    var var31 = 0;
    var var32 = 0;
    var var33 = 0;
    var var34 = 0;
    var var35 = 0;
    var var36 = 0;
    var var37 = 0;
    var var38 = 0;
    var var39 = 0;
    var var40 = 0;
    var var41 = 0;
    var var42 = 0;
    java$lang$System.$i;
    var0 = (java$lang$System.out);
    org$luaj$vm2$Print.$i;
    org$luaj$vm2$Print.ps = var0;
    var1 = bytecoder.newarray((41),null);
    var2 = (0) | 0;
    var1.data[var2] = bytecoder.stringconstants[209];
    var3 = (1) | 0;
    var1.data[var3] = bytecoder.stringconstants[210];
    var4 = (2) | 0;
    var1.data[var4] = bytecoder.stringconstants[211];
    var5 = (3) | 0;
    var1.data[var5] = bytecoder.stringconstants[212];
    var6 = (4) | 0;
    var1.data[var6] = bytecoder.stringconstants[213];
    var7 = (5) | 0;
    var1.data[var7] = bytecoder.stringconstants[214];
    var8 = (6) | 0;
    var1.data[var8] = bytecoder.stringconstants[215];
    var9 = (7) | 0;
    var1.data[var9] = bytecoder.stringconstants[216];
    var10 = (8) | 0;
    var1.data[var10] = bytecoder.stringconstants[217];
    var11 = (9) | 0;
    var1.data[var11] = bytecoder.stringconstants[218];
    var12 = (10) | 0;
    var1.data[var12] = bytecoder.stringconstants[219];
    var13 = (11) | 0;
    var1.data[var13] = bytecoder.stringconstants[220];
    var14 = (12) | 0;
    var1.data[var14] = bytecoder.stringconstants[221];
    var15 = (13) | 0;
    var1.data[var15] = bytecoder.stringconstants[222];
    var16 = (14) | 0;
    var1.data[var16] = bytecoder.stringconstants[223];
    var17 = (15) | 0;
    var1.data[var17] = bytecoder.stringconstants[224];
    var18 = (16) | 0;
    var1.data[var18] = bytecoder.stringconstants[225];
    var19 = (17) | 0;
    var1.data[var19] = bytecoder.stringconstants[226];
    var20 = (18) | 0;
    var1.data[var20] = bytecoder.stringconstants[227];
    var21 = (19) | 0;
    var1.data[var21] = bytecoder.stringconstants[228];
    var22 = (20) | 0;
    var1.data[var22] = bytecoder.stringconstants[229];
    var23 = (21) | 0;
    var1.data[var23] = bytecoder.stringconstants[230];
    var24 = (22) | 0;
    var1.data[var24] = bytecoder.stringconstants[231];
    var25 = (23) | 0;
    var1.data[var25] = bytecoder.stringconstants[232];
    var26 = (24) | 0;
    var1.data[var26] = bytecoder.stringconstants[233];
    var27 = (25) | 0;
    var1.data[var27] = bytecoder.stringconstants[234];
    var28 = (26) | 0;
    var1.data[var28] = bytecoder.stringconstants[235];
    var29 = (27) | 0;
    var1.data[var29] = bytecoder.stringconstants[236];
    var30 = (28) | 0;
    var1.data[var30] = bytecoder.stringconstants[237];
    var31 = (29) | 0;
    var1.data[var31] = bytecoder.stringconstants[238];
    var32 = (30) | 0;
    var1.data[var32] = bytecoder.stringconstants[239];
    var33 = (31) | 0;
    var1.data[var33] = bytecoder.stringconstants[240];
    var34 = (32) | 0;
    var1.data[var34] = bytecoder.stringconstants[241];
    var35 = (33) | 0;
    var1.data[var35] = bytecoder.stringconstants[242];
    var36 = (34) | 0;
    var1.data[var36] = bytecoder.stringconstants[243];
    var37 = (35) | 0;
    var1.data[var37] = bytecoder.stringconstants[244];
    var38 = (36) | 0;
    var1.data[var38] = bytecoder.stringconstants[245];
    var39 = (37) | 0;
    var1.data[var39] = bytecoder.stringconstants[246];
    var40 = (38) | 0;
    var1.data[var40] = bytecoder.stringconstants[247];
    var41 = (39) | 0;
    var1.data[var41] = bytecoder.stringconstants[248];
    var42 = (40) | 0;
    var1.data[var42] = null;
    org$luaj$vm2$Print.OPNAMES = var1;
    return;
  }

  static V$printState$Lorg$luaj$vm2$LuaClosure$$I$$Lorg$luaj$vm2$LuaValue$$I$Lorg$luaj$vm2$Varargs$(arg0,arg1,arg2,arg3,arg4) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var0 = (arg1) | 0;
    var1 = (arg3) | 0;
    org$luaj$vm2$Print.$i;
    var2 = (org$luaj$vm2$Print.ps);
    var3 = new java$io$ByteArrayOutputStream();
    java$io$ByteArrayOutputStream.prototype.V$$init$$$.call(var3);
    java$io$PrintStream.$i;
    var4 = new java$io$PrintStream();
    var5 = var3;
    java$io$PrintStream.prototype.V$$init$$Ljava$io$OutputStream$.call(var4,var5);
    org$luaj$vm2$Print.ps = var4;
    var6 = (arg0.p);
    org$luaj$vm2$Print.V$printOpCode$Lorg$luaj$vm2$Prototype$$I(var6,var0);
    var7 = (org$luaj$vm2$Print.ps);
    java$io$PrintStream.prototype.V$flush$$.call(var7);
    var8 = (org$luaj$vm2$Print.ps);
    java$io$PrintStream.prototype.V$close$$.call(var8);
    org$luaj$vm2$Print.ps = var2;
    var9 = (java$io$ByteArrayOutputStream.prototype.Ljava$lang$String$$toString$$.call(var3));
    org$luaj$vm2$Print.V$format$Ljava$lang$String$$I(var9,50);
    var10 = (var1) | 0;
    org$luaj$vm2$Print.V$printStack$$Lorg$luaj$vm2$LuaValue$$I$Lorg$luaj$vm2$Varargs$(arg2,var10,arg4);
    var11 = (org$luaj$vm2$Print.ps);
    java$io$PrintStream.prototype.V$println$$.call(var11);
    return;
  }

  static V$printOpCode$Lorg$luaj$vm2$Prototype$$I(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var0 = (arg1) | 0;
    org$luaj$vm2$Print.$i;
    var1 = (org$luaj$vm2$Print.ps);
    var2 = (var0) | 0;
    org$luaj$vm2$Print.V$printOpCode$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var1,arg0,var2);
    return;
  }

  static V$printOpCode$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(arg0,arg1,arg2) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = null;
    var var17 = 0;
    var var18 = null;
    var var19 = null;
    var var20 = 0;
    var var21 = 0;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = null;
    var phi31 = null;
    var phi32 = null;
    var phi33 = 0;
    var phi34 = null;
    var phi35 = 0;
    var phi36 = 0;
    var phi37 = 0;
    var phi38 = 0;
    var phi39 = 0;
    var phi40 = 0;
    var phi41 = 0;
    var phi42 = 0;
    var var43 = null;
    var var44 = null;
    var var45 = null;
    var var46 = 0;
    var var47 = null;
    var var48 = null;
    var var49 = null;
    var var50 = null;
    var var51 = 0;
    var var52 = 0;
    var var53 = 0;
    var var54 = null;
    var var55 = 0;
    var var56 = 0;
    var var57 = null;
    var var58 = null;
    var var59 = null;
    var var60 = null;
    var var61 = 0;
    var var62 = null;
    var var63 = null;
    var var64 = null;
    var var65 = null;
    var var66 = null;
    var var67 = null;
    var var68 = null;
    var var69 = 0;
    var var70 = null;
    var var71 = null;
    var var72 = null;
    var var73 = null;
    var var74 = null;
    var var75 = 0;
    var var76 = null;
    var var77 = null;
    var var78 = null;
    var var79 = null;
    var var80 = 0;
    var var81 = 0;
    var var82 = null;
    var var83 = null;
    var var84 = null;
    var var85 = null;
    var var86 = null;
    var var87 = 0;
    var var88 = null;
    var var89 = null;
    var var90 = null;
    var var91 = null;
    var var92 = null;
    var var93 = 0;
    var var94 = 0;
    var var95 = 0;
    var var96 = 0;
    var var97 = null;
    var var98 = null;
    var var99 = 0;
    var var100 = 0;
    var var101 = 0;
    var var102 = 0;
    var var103 = null;
    var var104 = 0;
    var var105 = 0;
    var var106 = null;
    var var107 = null;
    var var108 = 0;
    var var109 = 0;
    var var110 = null;
    var var111 = 0;
    var var112 = 0;
    var var113 = null;
    var var114 = null;
    var var115 = 0;
    var var116 = 0;
    var var117 = null;
    var var118 = null;
    var var119 = 0;
    var var120 = 0;
    var var121 = null;
    var var122 = null;
    var var123 = null;
    var var124 = 0;
    var var125 = 0;
    var var126 = null;
    var var127 = null;
    var var128 = null;
    var var129 = null;
    var var130 = 0;
    var var131 = null;
    var var132 = null;
    var var133 = null;
    var var134 = null;
    var var135 = null;
    var var136 = 0;
    var var137 = null;
    var var138 = null;
    var var139 = 0;
    var var140 = 0;
    var var141 = null;
    var var142 = null;
    var var143 = 0;
    var var144 = 0;
    var var145 = null;
    var var146 = 0;
    var var147 = 0;
    var var148 = null;
    var var149 = null;
    var var150 = 0;
    var var151 = 0;
    var var152 = null;
    var var153 = null;
    var var154 = null;
    var var155 = null;
    var var156 = null;
    var var157 = null;
    var var158 = 0;
    var var159 = null;
    var var160 = null;
    var var161 = 0;
    var var162 = 0;
    var var163 = null;
    var var164 = null;
    var var165 = 0;
    var var166 = 0;
    var var167 = null;
    var var168 = null;
    var var169 = null;
    var var170 = null;
    var var171 = 0;
    var var172 = null;
    var var173 = null;
    var var174 = 0;
    var var175 = null;
    var var176 = null;
    var var177 = 0;
    var var178 = null;
    var var179 = null;
    var var180 = 0;
    var var181 = 0;
    var var182 = null;
    var var183 = null;
    var var184 = 0;
    var var185 = null;
    var var186 = null;
    var var187 = 0;
    var var188 = 0;
    var var189 = null;
    var var190 = null;
    var var191 = null;
    var var192 = null;
    var var193 = 0;
    var var194 = null;
    var var195 = null;
    var var196 = 0;
    var var197 = null;
    var var198 = null;
    var var199 = null;
    var var200 = 0;
    var var201 = 0;
    var var202 = 0;
    var var203 = null;
    var var204 = null;
    var var205 = null;
    var var206 = 0;
    var var207 = 0;
    var var208 = 0;
    var var209 = 0;
    var var210 = 0;
    var var211 = 0;
    var phi212 = null;
    var phi213 = null;
    var phi214 = 0;
    var var215 = null;
    var var216 = null;
    var var217 = 0;
    var var218 = 0;
    var var219 = null;
    var var220 = null;
    var var221 = null;
    var var222 = 0;
    var var223 = 0;
    var var224 = 0;
    var var225 = 0;
    var var226 = 0;
    var var227 = 0;
    var phi228 = null;
    var phi229 = null;
    var phi230 = 0;
    var var231 = null;
    var var232 = null;
    var var233 = 0;
    var var234 = 0;
    var var235 = null;
    var0 = arg1;
    var1 = (var0.code);
    var2 = var1;
    var3 = ((var2.data[arg2])) | 0;
    var4 = (var3) | 0;
    org$luaj$vm2$Print.$i;
    var5 = ((org$luaj$vm2$Lua.I$GET_OPCODE$I(var4))) | 0;
    var6 = (var3) | 0;
    var7 = ((org$luaj$vm2$Lua.I$GETARG_A$I(var6))) | 0;
    var8 = (var3) | 0;
    var9 = ((org$luaj$vm2$Lua.I$GETARG_B$I(var8))) | 0;
    var10 = (var3) | 0;
    var11 = ((org$luaj$vm2$Lua.I$GETARG_C$I(var10))) | 0;
    var12 = (var3) | 0;
    var13 = ((org$luaj$vm2$Lua.I$GETARG_Bx$I(var12))) | 0;
    var14 = (var3) | 0;
    var15 = ((org$luaj$vm2$Lua.I$GETARG_sBx$I(var14))) | 0;
    var16 = var0;
    var17 = ((org$luaj$vm2$Print.I$getline$Lorg$luaj$vm2$Prototype$$I(var16,arg2))) | 0;
    var18 = new java$lang$StringBuffer();
    java$lang$StringBuffer.prototype.V$$init$$$.call(var18);
    var19 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var18,bytecoder.stringconstants[250]));
    var20 = (1) | 0;
    var21 = ((arg2 + var20)) | 0;
    var22 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var19,var21));
    var23 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var22,bytecoder.stringconstants[250]));
    var24 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var23));
    java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(arg0,var24);
    If_84_0: {
     if (var17 <= 0) {
      var235 = bytecoder.stringconstants[265];
      java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(arg0,var235);
      phi31 = arg0;
      phi32 = var0;
      phi33 = (arg2) | 0;
      phi34 = var1;
      phi35 = (var3) | 0;
      phi36 = (var5) | 0;
      phi37 = (var7) | 0;
      phi38 = (var9) | 0;
      phi39 = (var11) | 0;
      phi40 = (var13) | 0;
      phi41 = (var15) | 0;
      phi42 = (var17) | 0;
      break If_84_0;
     } else {
      var25 = arg0;
      var26 = new java$lang$StringBuffer();
      java$lang$StringBuffer.prototype.V$$init$$$.call(var26);
      var27 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var26,bytecoder.stringconstants[115]));
      var28 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var27,var17));
      var29 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var28,bytecoder.stringconstants[252]));
      var30 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var29));
      java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var25,var30);
      // Here was a goto statement
      phi31 = arg0;
      phi32 = var0;
      phi33 = (arg2) | 0;
      phi34 = var1;
      phi35 = (var3) | 0;
      phi36 = (var5) | 0;
      phi37 = (var7) | 0;
      phi38 = (var9) | 0;
      phi39 = (var11) | 0;
      phi40 = (var13) | 0;
      phi41 = (var15) | 0;
      phi42 = (var17) | 0;
      break If_84_0;
     }
    }
    var43 = phi31;
    var44 = new java$lang$StringBuffer();
    java$lang$StringBuffer.prototype.V$$init$$$.call(var44);
    var45 = (org$luaj$vm2$Print.OPNAMES);
    var46 = (phi36) | 0;
    var47 = (var45.data[var46]);
    var48 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var44,var47));
    var49 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var48,bytecoder.stringconstants[250]));
    var50 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var49));
    java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var43,var50);
    var51 = (phi36) | 0;
    var52 = ((org$luaj$vm2$Lua.I$getOpMode$I(var51))) | 0;
    TableSwitch_156_0: {
     if ((var52) >= 0 && (var52) <= 2) switch ((var52) - 0) {
      case 0: {
       var199 = phi31;
       var200 = (phi37) | 0;
       java$io$PrintStream.prototype.V$print$I.call(var199,var200);
       var201 = (phi36) | 0;
       var202 = ((org$luaj$vm2$Lua.I$getBMode$I(var201))) | 0;
       If_708_0: {
        if (var202 == 0) {
         break If_708_0;
        } else {
         var203 = phi31;
         var204 = new java$lang$StringBuffer();
         java$lang$StringBuffer.prototype.V$$init$$$.call(var204);
         var205 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var204,bytecoder.stringconstants[141]));
         var206 = (phi38) | 0;
         var207 = (org$luaj$vm2$Lua.Z$ISK$I(var206));
         If_728_0: {
          if (var207 == 0) {
           var234 = (phi38) | 0;
           phi212 = var203;
           phi213 = var205;
           phi214 = (var234) | 0;
           break If_728_0;
          } else {
           var208 = (-1) | 0;
           var209 = (phi38) | 0;
           var210 = ((org$luaj$vm2$Lua.I$INDEXK$I(var209))) | 0;
           var211 = ((var208 - var210)) | 0;
           // Here was a goto statement
           phi212 = var203;
           phi213 = var205;
           phi214 = (var211) | 0;
           break If_728_0;
          }
         }
         var215 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(phi213,phi214));
         var216 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var215));
         java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(phi212,var216);
         break If_708_0;
        }
       }
       var217 = (phi36) | 0;
       var218 = ((org$luaj$vm2$Lua.I$getCMode$I(var217))) | 0;
       if (var218 == 0) {
        break TableSwitch_156_0;
       } else {
        var219 = phi31;
        var220 = new java$lang$StringBuffer();
        java$lang$StringBuffer.prototype.V$$init$$$.call(var220);
        var221 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var220,bytecoder.stringconstants[141]));
        var222 = (phi39) | 0;
        var223 = (org$luaj$vm2$Lua.Z$ISK$I(var222));
        If_782_0: {
         if (var223 == 0) {
          var233 = (phi39) | 0;
          phi228 = var219;
          phi229 = var221;
          phi230 = (var233) | 0;
          break If_782_0;
         } else {
          var224 = (-1) | 0;
          var225 = (phi39) | 0;
          var226 = ((org$luaj$vm2$Lua.I$INDEXK$I(var225))) | 0;
          var227 = ((var224 - var226)) | 0;
          // Here was a goto statement
          phi228 = var219;
          phi229 = var221;
          phi230 = (var227) | 0;
          break If_782_0;
         }
        }
        var231 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(phi229,phi230));
        var232 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var231));
        java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(phi228,var232);
        // Here was a goto statement
        break TableSwitch_156_0;
       }
      }
      case 1: {
       var180 = (phi36) | 0;
       var181 = ((org$luaj$vm2$Lua.I$getBMode$I(var180))) | 0;
       if (var181 != 3) {
        var191 = phi31;
        var192 = new java$lang$StringBuffer();
        java$lang$StringBuffer.prototype.V$$init$$$.call(var192);
        var193 = (phi37) | 0;
        var194 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var192,var193));
        var195 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var194,bytecoder.stringconstants[141]));
        var196 = (phi40) | 0;
        var197 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var195,var196));
        var198 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var197));
        java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var191,var198);
        // Here was a goto statement
        break TableSwitch_156_0;
       } else {
        var182 = phi31;
        var183 = new java$lang$StringBuffer();
        java$lang$StringBuffer.prototype.V$$init$$$.call(var183);
        var184 = (phi37) | 0;
        var185 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var183,var184));
        var186 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var185,bytecoder.stringconstants[141]));
        var187 = (phi40) | 0;
        var188 = ((-1 - var187)) | 0;
        var189 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var186,var188));
        var190 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var189));
        java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var182,var190);
        // Here was a goto statement
        break TableSwitch_156_0;
       }
      }
      case 2: {
       var53 = (phi36) | 0;
       if (var53 != 23) {
        var172 = phi31;
        var173 = new java$lang$StringBuffer();
        java$lang$StringBuffer.prototype.V$$init$$$.call(var173);
        var174 = (phi37) | 0;
        var175 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var173,var174));
        var176 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var175,bytecoder.stringconstants[141]));
        var177 = (phi41) | 0;
        var178 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var176,var177));
        var179 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var178));
        java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var172,var179);
        break TableSwitch_156_0;
       } else {
        var54 = phi31;
        var55 = (phi41) | 0;
        java$io$PrintStream.prototype.V$print$I.call(var54,var55);
        // Here was a goto statement
        break TableSwitch_156_0;
       }
      }
     } else {
      break TableSwitch_156_0;
     }
    }
    var56 = (phi36) | 0;
    TableSwitch_172_0: {
     if ((var56) >= 1 && (var56) <= 38) switch ((var56) - 1) {
      case 0: {
       var168 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var168,bytecoder.stringconstants[254]);
       var169 = phi31;
       var170 = phi32;
       var171 = (phi40) | 0;
       org$luaj$vm2$Print.V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var169,var170,var171);
       // Here was a goto statement
       break TableSwitch_172_0;
      }
      case 1: {
       break TableSwitch_172_0;
      }
      case 2: {
       break TableSwitch_172_0;
      }
      case 3: {
       break TableSwitch_172_0;
      }
      case 4: {
       var126 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var126,bytecoder.stringconstants[254]);
       var127 = phi31;
       var128 = phi32;
       var129 = (var128.upvalues);
       var130 = (phi38) | 0;
       var131 = (var129.data[var130]);
       org$luaj$vm2$Print.V$printUpvalue$Ljava$io$PrintStream$$Lorg$luaj$vm2$Upvaldesc$(var127,var131);
       // Here was a goto statement
       break TableSwitch_172_0;
      }
      case 5: {
       var154 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var154,bytecoder.stringconstants[254]);
       var155 = phi31;
       var156 = phi32;
       var157 = (var156.upvalues);
       var158 = (phi38) | 0;
       var159 = (var157.data[var158]);
       org$luaj$vm2$Print.V$printUpvalue$Ljava$io$PrintStream$$Lorg$luaj$vm2$Upvaldesc$(var155,var159);
       var160 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var160,bytecoder.stringconstants[141]);
       var161 = (phi39) | 0;
       var162 = (org$luaj$vm2$Lua.Z$ISK$I(var161));
       if (var162 == 0) {
        var167 = phi31;
        java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var167,bytecoder.stringconstants[154]);
        // Here was a goto statement
        break TableSwitch_172_0;
       } else {
        var163 = phi31;
        var164 = phi32;
        var165 = (phi39) | 0;
        var166 = ((org$luaj$vm2$Lua.I$INDEXK$I(var165))) | 0;
        org$luaj$vm2$Print.V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var163,var164,var166);
        // Here was a goto statement
        break TableSwitch_172_0;
       }
      }
      case 6: {
       var119 = (phi39) | 0;
       var120 = (org$luaj$vm2$Lua.Z$ISK$I(var119));
       if (var120 == 0) {
        break TableSwitch_172_0;
       } else {
        var121 = phi31;
        java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var121,bytecoder.stringconstants[254]);
        var122 = phi31;
        var123 = phi32;
        var124 = (phi39) | 0;
        var125 = ((org$luaj$vm2$Lua.I$INDEXK$I(var124))) | 0;
        org$luaj$vm2$Print.V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var122,var123,var125);
        // Here was a goto statement
        break TableSwitch_172_0;
       }
      }
      case 7: {
       var132 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var132,bytecoder.stringconstants[254]);
       var133 = phi31;
       var134 = phi32;
       var135 = (var134.upvalues);
       var136 = (phi37) | 0;
       var137 = (var135.data[var136]);
       org$luaj$vm2$Print.V$printUpvalue$Ljava$io$PrintStream$$Lorg$luaj$vm2$Upvaldesc$(var133,var137);
       var138 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var138,bytecoder.stringconstants[141]);
       var139 = (phi38) | 0;
       var140 = (org$luaj$vm2$Lua.Z$ISK$I(var139));
       If_484_0: {
        if (var140 == 0) {
         var153 = phi31;
         java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var153,bytecoder.stringconstants[154]);
         break If_484_0;
        } else {
         var141 = phi31;
         var142 = phi32;
         var143 = (phi38) | 0;
         var144 = ((org$luaj$vm2$Lua.I$INDEXK$I(var143))) | 0;
         org$luaj$vm2$Print.V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var141,var142,var144);
         // Here was a goto statement
         break If_484_0;
        }
       }
       var145 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var145,bytecoder.stringconstants[141]);
       var146 = (phi39) | 0;
       var147 = (org$luaj$vm2$Lua.Z$ISK$I(var146));
       if (var147 == 0) {
        var152 = phi31;
        java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var152,bytecoder.stringconstants[154]);
        // Here was a goto statement
        break TableSwitch_172_0;
       } else {
        var148 = phi31;
        var149 = phi32;
        var150 = (phi39) | 0;
        var151 = ((org$luaj$vm2$Lua.I$INDEXK$I(var150))) | 0;
        org$luaj$vm2$Print.V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var148,var149,var151);
        // Here was a goto statement
        break TableSwitch_172_0;
       }
      }
      case 8: {
       var126 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var126,bytecoder.stringconstants[254]);
       var127 = phi31;
       var128 = phi32;
       var129 = (var128.upvalues);
       var130 = (phi38) | 0;
       var131 = (var129.data[var130]);
       org$luaj$vm2$Print.V$printUpvalue$Ljava$io$PrintStream$$Lorg$luaj$vm2$Upvaldesc$(var127,var131);
       // Here was a goto statement
       break TableSwitch_172_0;
      }
      case 9: {
       var99 = (phi38) | 0;
       var100 = (org$luaj$vm2$Lua.Z$ISK$I(var99));
       If_331_0: {
        if (var100 != 0) {
         break If_331_0;
        } else {
         var101 = (phi39) | 0;
         var102 = (org$luaj$vm2$Lua.Z$ISK$I(var101));
         if (var102 == 0) {
          break TableSwitch_172_0;
         } else {
          break If_331_0;
         }
        }
       }
       var103 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var103,bytecoder.stringconstants[254]);
       var104 = (phi38) | 0;
       var105 = (org$luaj$vm2$Lua.Z$ISK$I(var104));
       If_354_0: {
        if (var105 == 0) {
         var118 = phi31;
         java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var118,bytecoder.stringconstants[154]);
         break If_354_0;
        } else {
         var106 = phi31;
         var107 = phi32;
         var108 = (phi38) | 0;
         var109 = ((org$luaj$vm2$Lua.I$INDEXK$I(var108))) | 0;
         org$luaj$vm2$Print.V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var106,var107,var109);
         // Here was a goto statement
         break If_354_0;
        }
       }
       var110 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var110,bytecoder.stringconstants[141]);
       var111 = (phi39) | 0;
       var112 = (org$luaj$vm2$Lua.Z$ISK$I(var111));
       if (var112 == 0) {
        var117 = phi31;
        java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var117,bytecoder.stringconstants[154]);
        // Here was a goto statement
        break TableSwitch_172_0;
       } else {
        var113 = phi31;
        var114 = phi32;
        var115 = (phi39) | 0;
        var116 = ((org$luaj$vm2$Lua.I$INDEXK$I(var115))) | 0;
        org$luaj$vm2$Print.V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var113,var114,var116);
        // Here was a goto statement
        break TableSwitch_172_0;
       }
      }
      case 10: {
       break TableSwitch_172_0;
      }
      case 11: {
       var119 = (phi39) | 0;
       var120 = (org$luaj$vm2$Lua.Z$ISK$I(var119));
       if (var120 == 0) {
        break TableSwitch_172_0;
       } else {
        var121 = phi31;
        java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var121,bytecoder.stringconstants[254]);
        var122 = phi31;
        var123 = phi32;
        var124 = (phi39) | 0;
        var125 = ((org$luaj$vm2$Lua.I$INDEXK$I(var124))) | 0;
        org$luaj$vm2$Print.V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var122,var123,var125);
        // Here was a goto statement
        break TableSwitch_172_0;
       }
      }
      case 12: {
       var99 = (phi38) | 0;
       var100 = (org$luaj$vm2$Lua.Z$ISK$I(var99));
       If_331_0: {
        if (var100 != 0) {
         break If_331_0;
        } else {
         var101 = (phi39) | 0;
         var102 = (org$luaj$vm2$Lua.Z$ISK$I(var101));
         if (var102 == 0) {
          break TableSwitch_172_0;
         } else {
          break If_331_0;
         }
        }
       }
       var103 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var103,bytecoder.stringconstants[254]);
       var104 = (phi38) | 0;
       var105 = (org$luaj$vm2$Lua.Z$ISK$I(var104));
       If_354_0: {
        if (var105 == 0) {
         var118 = phi31;
         java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var118,bytecoder.stringconstants[154]);
         break If_354_0;
        } else {
         var106 = phi31;
         var107 = phi32;
         var108 = (phi38) | 0;
         var109 = ((org$luaj$vm2$Lua.I$INDEXK$I(var108))) | 0;
         org$luaj$vm2$Print.V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var106,var107,var109);
         // Here was a goto statement
         break If_354_0;
        }
       }
       var110 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var110,bytecoder.stringconstants[141]);
       var111 = (phi39) | 0;
       var112 = (org$luaj$vm2$Lua.Z$ISK$I(var111));
       if (var112 == 0) {
        var117 = phi31;
        java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var117,bytecoder.stringconstants[154]);
        // Here was a goto statement
        break TableSwitch_172_0;
       } else {
        var113 = phi31;
        var114 = phi32;
        var115 = (phi39) | 0;
        var116 = ((org$luaj$vm2$Lua.I$INDEXK$I(var115))) | 0;
        org$luaj$vm2$Print.V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var113,var114,var116);
        // Here was a goto statement
        break TableSwitch_172_0;
       }
      }
      case 13: {
       var99 = (phi38) | 0;
       var100 = (org$luaj$vm2$Lua.Z$ISK$I(var99));
       If_331_0: {
        if (var100 != 0) {
         break If_331_0;
        } else {
         var101 = (phi39) | 0;
         var102 = (org$luaj$vm2$Lua.Z$ISK$I(var101));
         if (var102 == 0) {
          break TableSwitch_172_0;
         } else {
          break If_331_0;
         }
        }
       }
       var103 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var103,bytecoder.stringconstants[254]);
       var104 = (phi38) | 0;
       var105 = (org$luaj$vm2$Lua.Z$ISK$I(var104));
       If_354_0: {
        if (var105 == 0) {
         var118 = phi31;
         java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var118,bytecoder.stringconstants[154]);
         break If_354_0;
        } else {
         var106 = phi31;
         var107 = phi32;
         var108 = (phi38) | 0;
         var109 = ((org$luaj$vm2$Lua.I$INDEXK$I(var108))) | 0;
         org$luaj$vm2$Print.V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var106,var107,var109);
         // Here was a goto statement
         break If_354_0;
        }
       }
       var110 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var110,bytecoder.stringconstants[141]);
       var111 = (phi39) | 0;
       var112 = (org$luaj$vm2$Lua.Z$ISK$I(var111));
       if (var112 == 0) {
        var117 = phi31;
        java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var117,bytecoder.stringconstants[154]);
        // Here was a goto statement
        break TableSwitch_172_0;
       } else {
        var113 = phi31;
        var114 = phi32;
        var115 = (phi39) | 0;
        var116 = ((org$luaj$vm2$Lua.I$INDEXK$I(var115))) | 0;
        org$luaj$vm2$Print.V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var113,var114,var116);
        // Here was a goto statement
        break TableSwitch_172_0;
       }
      }
      case 14: {
       var99 = (phi38) | 0;
       var100 = (org$luaj$vm2$Lua.Z$ISK$I(var99));
       If_331_0: {
        if (var100 != 0) {
         break If_331_0;
        } else {
         var101 = (phi39) | 0;
         var102 = (org$luaj$vm2$Lua.Z$ISK$I(var101));
         if (var102 == 0) {
          break TableSwitch_172_0;
         } else {
          break If_331_0;
         }
        }
       }
       var103 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var103,bytecoder.stringconstants[254]);
       var104 = (phi38) | 0;
       var105 = (org$luaj$vm2$Lua.Z$ISK$I(var104));
       If_354_0: {
        if (var105 == 0) {
         var118 = phi31;
         java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var118,bytecoder.stringconstants[154]);
         break If_354_0;
        } else {
         var106 = phi31;
         var107 = phi32;
         var108 = (phi38) | 0;
         var109 = ((org$luaj$vm2$Lua.I$INDEXK$I(var108))) | 0;
         org$luaj$vm2$Print.V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var106,var107,var109);
         // Here was a goto statement
         break If_354_0;
        }
       }
       var110 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var110,bytecoder.stringconstants[141]);
       var111 = (phi39) | 0;
       var112 = (org$luaj$vm2$Lua.Z$ISK$I(var111));
       if (var112 == 0) {
        var117 = phi31;
        java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var117,bytecoder.stringconstants[154]);
        // Here was a goto statement
        break TableSwitch_172_0;
       } else {
        var113 = phi31;
        var114 = phi32;
        var115 = (phi39) | 0;
        var116 = ((org$luaj$vm2$Lua.I$INDEXK$I(var115))) | 0;
        org$luaj$vm2$Print.V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var113,var114,var116);
        // Here was a goto statement
        break TableSwitch_172_0;
       }
      }
      case 15: {
       var99 = (phi38) | 0;
       var100 = (org$luaj$vm2$Lua.Z$ISK$I(var99));
       If_331_0: {
        if (var100 != 0) {
         break If_331_0;
        } else {
         var101 = (phi39) | 0;
         var102 = (org$luaj$vm2$Lua.Z$ISK$I(var101));
         if (var102 == 0) {
          break TableSwitch_172_0;
         } else {
          break If_331_0;
         }
        }
       }
       var103 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var103,bytecoder.stringconstants[254]);
       var104 = (phi38) | 0;
       var105 = (org$luaj$vm2$Lua.Z$ISK$I(var104));
       If_354_0: {
        if (var105 == 0) {
         var118 = phi31;
         java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var118,bytecoder.stringconstants[154]);
         break If_354_0;
        } else {
         var106 = phi31;
         var107 = phi32;
         var108 = (phi38) | 0;
         var109 = ((org$luaj$vm2$Lua.I$INDEXK$I(var108))) | 0;
         org$luaj$vm2$Print.V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var106,var107,var109);
         // Here was a goto statement
         break If_354_0;
        }
       }
       var110 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var110,bytecoder.stringconstants[141]);
       var111 = (phi39) | 0;
       var112 = (org$luaj$vm2$Lua.Z$ISK$I(var111));
       if (var112 == 0) {
        var117 = phi31;
        java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var117,bytecoder.stringconstants[154]);
        // Here was a goto statement
        break TableSwitch_172_0;
       } else {
        var113 = phi31;
        var114 = phi32;
        var115 = (phi39) | 0;
        var116 = ((org$luaj$vm2$Lua.I$INDEXK$I(var115))) | 0;
        org$luaj$vm2$Print.V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var113,var114,var116);
        // Here was a goto statement
        break TableSwitch_172_0;
       }
      }
      case 16: {
       break TableSwitch_172_0;
      }
      case 17: {
       var99 = (phi38) | 0;
       var100 = (org$luaj$vm2$Lua.Z$ISK$I(var99));
       If_331_0: {
        if (var100 != 0) {
         break If_331_0;
        } else {
         var101 = (phi39) | 0;
         var102 = (org$luaj$vm2$Lua.Z$ISK$I(var101));
         if (var102 == 0) {
          break TableSwitch_172_0;
         } else {
          break If_331_0;
         }
        }
       }
       var103 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var103,bytecoder.stringconstants[254]);
       var104 = (phi38) | 0;
       var105 = (org$luaj$vm2$Lua.Z$ISK$I(var104));
       If_354_0: {
        if (var105 == 0) {
         var118 = phi31;
         java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var118,bytecoder.stringconstants[154]);
         break If_354_0;
        } else {
         var106 = phi31;
         var107 = phi32;
         var108 = (phi38) | 0;
         var109 = ((org$luaj$vm2$Lua.I$INDEXK$I(var108))) | 0;
         org$luaj$vm2$Print.V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var106,var107,var109);
         // Here was a goto statement
         break If_354_0;
        }
       }
       var110 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var110,bytecoder.stringconstants[141]);
       var111 = (phi39) | 0;
       var112 = (org$luaj$vm2$Lua.Z$ISK$I(var111));
       if (var112 == 0) {
        var117 = phi31;
        java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var117,bytecoder.stringconstants[154]);
        // Here was a goto statement
        break TableSwitch_172_0;
       } else {
        var113 = phi31;
        var114 = phi32;
        var115 = (phi39) | 0;
        var116 = ((org$luaj$vm2$Lua.I$INDEXK$I(var115))) | 0;
        org$luaj$vm2$Print.V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var113,var114,var116);
        // Here was a goto statement
        break TableSwitch_172_0;
       }
      }
      case 18: {
       break TableSwitch_172_0;
      }
      case 19: {
       break TableSwitch_172_0;
      }
      case 20: {
       break TableSwitch_172_0;
      }
      case 21: {
       break TableSwitch_172_0;
      }
      case 22: {
       var90 = phi31;
       var91 = new java$lang$StringBuffer();
       java$lang$StringBuffer.prototype.V$$init$$$.call(var91);
       var92 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var91,bytecoder.stringconstants[255]));
       var93 = (phi41) | 0;
       var94 = (phi33) | 0;
       var95 = ((var93 + var94)) | 0;
       var96 = ((var95 + 2)) | 0;
       var97 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var92,var96));
       var98 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var97));
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var90,var98);
       // Here was a goto statement
       break TableSwitch_172_0;
      }
      case 23: {
       var99 = (phi38) | 0;
       var100 = (org$luaj$vm2$Lua.Z$ISK$I(var99));
       If_331_0: {
        if (var100 != 0) {
         break If_331_0;
        } else {
         var101 = (phi39) | 0;
         var102 = (org$luaj$vm2$Lua.Z$ISK$I(var101));
         if (var102 == 0) {
          break TableSwitch_172_0;
         } else {
          break If_331_0;
         }
        }
       }
       var103 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var103,bytecoder.stringconstants[254]);
       var104 = (phi38) | 0;
       var105 = (org$luaj$vm2$Lua.Z$ISK$I(var104));
       If_354_0: {
        if (var105 == 0) {
         var118 = phi31;
         java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var118,bytecoder.stringconstants[154]);
         break If_354_0;
        } else {
         var106 = phi31;
         var107 = phi32;
         var108 = (phi38) | 0;
         var109 = ((org$luaj$vm2$Lua.I$INDEXK$I(var108))) | 0;
         org$luaj$vm2$Print.V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var106,var107,var109);
         // Here was a goto statement
         break If_354_0;
        }
       }
       var110 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var110,bytecoder.stringconstants[141]);
       var111 = (phi39) | 0;
       var112 = (org$luaj$vm2$Lua.Z$ISK$I(var111));
       if (var112 == 0) {
        var117 = phi31;
        java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var117,bytecoder.stringconstants[154]);
        // Here was a goto statement
        break TableSwitch_172_0;
       } else {
        var113 = phi31;
        var114 = phi32;
        var115 = (phi39) | 0;
        var116 = ((org$luaj$vm2$Lua.I$INDEXK$I(var115))) | 0;
        org$luaj$vm2$Print.V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var113,var114,var116);
        // Here was a goto statement
        break TableSwitch_172_0;
       }
      }
      case 24: {
       var99 = (phi38) | 0;
       var100 = (org$luaj$vm2$Lua.Z$ISK$I(var99));
       If_331_0: {
        if (var100 != 0) {
         break If_331_0;
        } else {
         var101 = (phi39) | 0;
         var102 = (org$luaj$vm2$Lua.Z$ISK$I(var101));
         if (var102 == 0) {
          break TableSwitch_172_0;
         } else {
          break If_331_0;
         }
        }
       }
       var103 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var103,bytecoder.stringconstants[254]);
       var104 = (phi38) | 0;
       var105 = (org$luaj$vm2$Lua.Z$ISK$I(var104));
       If_354_0: {
        if (var105 == 0) {
         var118 = phi31;
         java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var118,bytecoder.stringconstants[154]);
         break If_354_0;
        } else {
         var106 = phi31;
         var107 = phi32;
         var108 = (phi38) | 0;
         var109 = ((org$luaj$vm2$Lua.I$INDEXK$I(var108))) | 0;
         org$luaj$vm2$Print.V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var106,var107,var109);
         // Here was a goto statement
         break If_354_0;
        }
       }
       var110 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var110,bytecoder.stringconstants[141]);
       var111 = (phi39) | 0;
       var112 = (org$luaj$vm2$Lua.Z$ISK$I(var111));
       if (var112 == 0) {
        var117 = phi31;
        java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var117,bytecoder.stringconstants[154]);
        // Here was a goto statement
        break TableSwitch_172_0;
       } else {
        var113 = phi31;
        var114 = phi32;
        var115 = (phi39) | 0;
        var116 = ((org$luaj$vm2$Lua.I$INDEXK$I(var115))) | 0;
        org$luaj$vm2$Print.V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var113,var114,var116);
        // Here was a goto statement
        break TableSwitch_172_0;
       }
      }
      case 25: {
       var99 = (phi38) | 0;
       var100 = (org$luaj$vm2$Lua.Z$ISK$I(var99));
       If_331_0: {
        if (var100 != 0) {
         break If_331_0;
        } else {
         var101 = (phi39) | 0;
         var102 = (org$luaj$vm2$Lua.Z$ISK$I(var101));
         if (var102 == 0) {
          break TableSwitch_172_0;
         } else {
          break If_331_0;
         }
        }
       }
       var103 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var103,bytecoder.stringconstants[254]);
       var104 = (phi38) | 0;
       var105 = (org$luaj$vm2$Lua.Z$ISK$I(var104));
       If_354_0: {
        if (var105 == 0) {
         var118 = phi31;
         java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var118,bytecoder.stringconstants[154]);
         break If_354_0;
        } else {
         var106 = phi31;
         var107 = phi32;
         var108 = (phi38) | 0;
         var109 = ((org$luaj$vm2$Lua.I$INDEXK$I(var108))) | 0;
         org$luaj$vm2$Print.V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var106,var107,var109);
         // Here was a goto statement
         break If_354_0;
        }
       }
       var110 = phi31;
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var110,bytecoder.stringconstants[141]);
       var111 = (phi39) | 0;
       var112 = (org$luaj$vm2$Lua.Z$ISK$I(var111));
       if (var112 == 0) {
        var117 = phi31;
        java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var117,bytecoder.stringconstants[154]);
        // Here was a goto statement
        break TableSwitch_172_0;
       } else {
        var113 = phi31;
        var114 = phi32;
        var115 = (phi39) | 0;
        var116 = ((org$luaj$vm2$Lua.I$INDEXK$I(var115))) | 0;
        org$luaj$vm2$Print.V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(var113,var114,var116);
        // Here was a goto statement
        break TableSwitch_172_0;
       }
      }
      case 26: {
       break TableSwitch_172_0;
      }
      case 27: {
       break TableSwitch_172_0;
      }
      case 28: {
       break TableSwitch_172_0;
      }
      case 29: {
       break TableSwitch_172_0;
      }
      case 30: {
       break TableSwitch_172_0;
      }
      case 31: {
       var90 = phi31;
       var91 = new java$lang$StringBuffer();
       java$lang$StringBuffer.prototype.V$$init$$$.call(var91);
       var92 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var91,bytecoder.stringconstants[255]));
       var93 = (phi41) | 0;
       var94 = (phi33) | 0;
       var95 = ((var93 + var94)) | 0;
       var96 = ((var95 + 2)) | 0;
       var97 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var92,var96));
       var98 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var97));
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var90,var98);
       // Here was a goto statement
       break TableSwitch_172_0;
      }
      case 32: {
       var90 = phi31;
       var91 = new java$lang$StringBuffer();
       java$lang$StringBuffer.prototype.V$$init$$$.call(var91);
       var92 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var91,bytecoder.stringconstants[255]));
       var93 = (phi41) | 0;
       var94 = (phi33) | 0;
       var95 = ((var93 + var94)) | 0;
       var96 = ((var95 + 2)) | 0;
       var97 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var92,var96));
       var98 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var97));
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var90,var98);
       // Here was a goto statement
       break TableSwitch_172_0;
      }
      case 33: {
       break TableSwitch_172_0;
      }
      case 34: {
       break TableSwitch_172_0;
      }
      case 35: {
       var75 = (phi39) | 0;
       if (var75 != 0) {
        var84 = phi31;
        var85 = new java$lang$StringBuffer();
        java$lang$StringBuffer.prototype.V$$init$$$.call(var85);
        var86 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var85,bytecoder.stringconstants[254]));
        var87 = (phi39) | 0;
        var88 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var86,var87));
        var89 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var88));
        java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var84,var89);
        // Here was a goto statement
        break TableSwitch_172_0;
       } else {
        var76 = phi31;
        var77 = new java$lang$StringBuffer();
        java$lang$StringBuffer.prototype.V$$init$$$.call(var77);
        var78 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var77,bytecoder.stringconstants[254]));
        var79 = phi34;
        phi33 = ((phi33 + 1)) | 0;
        var80 = (phi33) | 0;
        var81 = ((var79.data[var80])) | 0;
        var82 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var78,var81));
        var83 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var82));
        java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var76,var83);
        // Here was a goto statement
        break TableSwitch_172_0;
       }
      }
      case 36: {
       var64 = phi31;
       var65 = new java$lang$StringBuffer();
       java$lang$StringBuffer.prototype.V$$init$$$.call(var65);
       var66 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var65,bytecoder.stringconstants[254]));
       var67 = phi32;
       var68 = (var67.p);
       var69 = (phi40) | 0;
       var70 = (var68.data[var69]);
       var71 = ((var70).constructor.$rt);
       var72 = (java$lang$Class.prototype.Ljava$lang$String$$getName$$.call(var71));
       var73 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var66,var72));
       var74 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var73));
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var64,var74);
       // Here was a goto statement
       break TableSwitch_172_0;
      }
      case 37: {
       var57 = phi31;
       var58 = new java$lang$StringBuffer();
       java$lang$StringBuffer.prototype.V$$init$$$.call(var58);
       var59 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var58,bytecoder.stringconstants[253]));
       var60 = phi32;
       var61 = ((var60.is_vararg)) | 0;
       var62 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var59,var61));
       var63 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var62));
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var57,var63);
       // Here was a goto statement
       break TableSwitch_172_0;
      }
     } else {
      break TableSwitch_172_0;
     }
    }
    return;
  }

  static I$getline$Lorg$luaj$vm2$Prototype$$I(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var phi9 = null;
    var phi10 = 0;
    var phi11 = 0;
    var phi12 = null;
    var phi13 = 0;
    var0 = (arg1) | 0;
    If_5_0: {
     If_5_1: {
      if (var0 <= 0) {
       phi12 = arg0;
       phi13 = (var0) | 0;
       break If_5_1;
      } else {
       var1 = arg0;
       var2 = (var1.lineinfo);
       if (var2 == null) {
        phi12 = arg0;
        phi13 = (var0) | 0;
        break If_5_1;
       } else {
        var3 = (var0) | 0;
        var4 = (arg0.lineinfo);
        var5 = (var4.data.length) | 0;
        if (var3 >= var5) {
         phi12 = arg0;
         phi13 = (var0) | 0;
         break If_5_1;
        } else {
         var6 = arg0;
         var7 = (var6.lineinfo);
         var8 = ((var7.data[var0])) | 0;
         // Here was a goto statement
         phi9 = arg0;
         phi10 = (var0) | 0;
         phi11 = (var8) | 0;
         break If_5_0;
        }
       }
      }
     }
     phi9 = phi12;
     phi10 = (phi13) | 0;
     phi11 = (-1) | 0;
     break If_5_0;
    }
    return phi11;
  }

  static V$printConstant$Ljava$io$PrintStream$$Lorg$luaj$vm2$Prototype$$I(arg0,arg1,arg2) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var0 = arg1;
    var1 = var0;
    var2 = (var1.k);
    var3 = (var2.data[arg2]);
    org$luaj$vm2$Print.$i;
    org$luaj$vm2$Print.V$printValue$Ljava$io$PrintStream$$Lorg$luaj$vm2$LuaValue$(arg0,var3);
    return;
  }

  static V$printValue$Ljava$io$PrintStream$$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var phi3 = null;
    var phi4 = null;
    var var5 = null;
    var0 = arg1;
    var1 = ((var0.I$type$$())) | 0;
    LookupSwitch_8_0: {
     switch (var1) {
      case 4: {
       var5 = var0;
       org$luaj$vm2$Print.$i;
       org$luaj$vm2$Print.V$printString$Ljava$io$PrintStream$$Lorg$luaj$vm2$LuaString$(arg0,var5);
       // Here was a goto statement
       phi3 = arg0;
       phi4 = var0;
       break LookupSwitch_8_0;
      }
      default: {
       var2 = (var0.Ljava$lang$String$$tojstring$$());
       java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(arg0,var2);
       phi3 = arg0;
       phi4 = var0;
       break LookupSwitch_8_0;
      }
     }
    }
    return;
  }

  static V$printString$Ljava$io$PrintStream$$Lorg$luaj$vm2$LuaString$(arg0,arg1) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var phi4 = null;
    var phi5 = null;
    var phi6 = 0;
    var phi7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = 0;
    var var17 = 0;
    var var18 = 0;
    var var19 = 0;
    var var20 = 0;
    var var21 = null;
    var var22 = 0;
    var phi23 = 0;
    var phi24 = 0;
    var var25 = 0;
    var var26 = null;
    var var27 = null;
    var var28 = 0;
    var var29 = 0;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = null;
    var var37 = null;
    var var38 = null;
    var var39 = null;
    var var40 = null;
    var var41 = null;
    var0 = arg1;
    var1 = (34) | 0;
    java$io$PrintStream.prototype.V$print$C.call(arg0,var1);
    var2 = var0;
    var3 = ((var2.m_length)) | 0;
    phi4 = arg0;
    phi5 = var0;
    phi6 = (0) | 0;
    phi7 = (var3) | 0;
    L965896385: while(true) {
     var8 = (phi6) | 0;
     var9 = (phi7) | 0;
     if (var8 >= var9) {
      var41 = phi4;
      java$io$PrintStream.prototype.V$print$C.call(var41,34);
      return;
     } else {
      var10 = phi5;
      var11 = (var10.m_bytes);
      var12 = phi5;
      var13 = ((var12.m_offset)) | 0;
      var14 = (phi6) | 0;
      var15 = ((var13 + var14)) | 0;
      var16 = (var11.data[var15]);
      var17 = var16;
      If_47_0: {
       If_47_1: {
        if (var17 < 32) {
         phi24 = var16;
         break If_47_1;
        } else {
         var18 = var16;
         if (var18 > 126) {
          phi24 = var16;
          break If_47_1;
         } else {
          var19 = var16;
          if (var19 == 34) {
           phi24 = var16;
           break If_47_1;
          } else {
           var20 = var16;
           if (var20 == 92) {
            phi24 = var16;
            break If_47_1;
           } else {
            var21 = phi4;
            var22 = var16;
            java$io$PrintStream.prototype.V$print$C.call(var21,var22);
            // Here was a goto statement
            phi23 = var16;
            break If_47_0;
           }
          }
         }
        }
       }
       var25 = phi24;
       switch (var25) {
        case 12: {
         var35 = phi4;
         java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var35,bytecoder.stringconstants[259]);
         // Here was a goto statement
         phi23 = phi24;
         break If_47_0;
        }
        case 92: {
         var32 = phi4;
         java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var32,bytecoder.stringconstants[256]);
         // Here was a goto statement
         phi23 = phi24;
         break If_47_0;
        }
        case 9: {
         var38 = phi4;
         java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var38,bytecoder.stringconstants[262]);
         // Here was a goto statement
         phi23 = phi24;
         break If_47_0;
        }
        case 8: {
         var39 = phi4;
         java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var39,bytecoder.stringconstants[263]);
         // Here was a goto statement
         phi23 = phi24;
         break If_47_0;
        }
        case 7: {
         var40 = phi4;
         java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var40,bytecoder.stringconstants[264]);
         // Here was a goto statement
         phi23 = phi24;
         break If_47_0;
        }
        case 34: {
         var33 = phi4;
         java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var33,bytecoder.stringconstants[257]);
         // Here was a goto statement
         phi23 = phi24;
         break If_47_0;
        }
        case 13: {
         var34 = phi4;
         java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var34,bytecoder.stringconstants[258]);
         // Here was a goto statement
         phi23 = phi24;
         break If_47_0;
        }
        case 10: {
         var37 = phi4;
         java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var37,bytecoder.stringconstants[261]);
         // Here was a goto statement
         phi23 = phi24;
         break If_47_0;
        }
        case 11: {
         var36 = phi4;
         java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var36,bytecoder.stringconstants[260]);
         // Here was a goto statement
         phi23 = phi24;
         break If_47_0;
        }
        default: {
         var26 = phi4;
         java$io$PrintStream.prototype.V$print$C.call(var26,92);
         var27 = phi4;
         var28 = phi24;
         var29 = ((1255 & var28)) | 0;
         java$lang$Integer.$i;
         var30 = (java$lang$Integer.Ljava$lang$String$$toString$I(var29));
         var31 = (java$lang$String.prototype.Ljava$lang$String$$substring$I.call(var30,1));
         java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var27,var31);
         phi23 = phi24;
         break If_47_0;
        }
       }
      }
      phi6 = ((phi6 + 1)) | 0;
      // Here was a goto statement
      continue L965896385;
     }
    }
  }

  static V$printUpvalue$Ljava$io$PrintStream$$Lorg$luaj$vm2$Upvaldesc$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var0 = arg1;
    var1 = new java$lang$StringBuffer();
    java$lang$StringBuffer.prototype.V$$init$$$.call(var1);
    var2 = (var0.idx);
    var3 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var1,var2));
    var4 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var3,bytecoder.stringconstants[141]));
    var5 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var4));
    java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(arg0,var5);
    var6 = var0;
    var7 = (var6.name);
    org$luaj$vm2$Print.$i;
    org$luaj$vm2$Print.V$printValue$Ljava$io$PrintStream$$Lorg$luaj$vm2$LuaValue$(arg0,var7);
    return;
  }

  static V$format$Ljava$lang$String$$I(arg0,arg1) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var phi6 = null;
    var phi7 = 0;
    var phi8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = 0;
    var phi12 = null;
    var phi13 = 0;
    var phi14 = 0;
    var phi15 = 0;
    var var16 = 0;
    var var17 = null;
    var0 = (arg1) | 0;
    var1 = ((java$lang$String.prototype.I$length$$.call(arg0))) | 0;
    var2 = (var1) | 0;
    If_10_0: {
     if (var2 <= var0) {
      org$luaj$vm2$Print.$i;
      var9 = (org$luaj$vm2$Print.ps);
      java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var9,arg0);
      var10 = (var1) | 0;
      var11 = ((var0 - var10)) | 0;
      phi12 = arg0;
      phi13 = (var0) | 0;
      phi14 = (var1) | 0;
      phi15 = (var11) | 0;
      L138840337: while(true) {
       phi15 = ((phi15 + -1)) | 0;
       var16 = (phi15) | 0;
       if (var16 < 0) {
        phi6 = phi12;
        phi7 = (phi13) | 0;
        phi8 = (phi14) | 0;
        break If_10_0;
       } else {
        var17 = (org$luaj$vm2$Print.ps);
        java$io$PrintStream.prototype.V$print$C.call(var17,32);
        // Here was a goto statement
        continue L138840337;
       }
      }
     } else {
      org$luaj$vm2$Print.$i;
      var3 = (org$luaj$vm2$Print.ps);
      var4 = (0) | 0;
      var5 = (java$lang$String.prototype.Ljava$lang$String$$substring$I$I.call(arg0,var4,var0));
      java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var3,var5);
      // Here was a goto statement
      phi6 = arg0;
      phi7 = (var0) | 0;
      phi8 = (var1) | 0;
      break If_10_0;
     }
    }
    return;
  }

  static V$printStack$$Lorg$luaj$vm2$LuaValue$$I$Lorg$luaj$vm2$Varargs$(arg0,arg1,arg2) {
    var var0 = 0;
    var var1 = null;
    var phi2 = null;
    var phi3 = 0;
    var phi4 = null;
    var phi5 = 0;
    var var6 = 0;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var phi14 = null;
    var var15 = 0;
    var var16 = 0;
    var var17 = 0;
    var var18 = null;
    var var19 = null;
    var var20 = 0;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = 0;
    var var28 = 0;
    var var29 = 0;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = null;
    var var35 = 0;
    var var36 = null;
    var var37 = null;
    var var38 = null;
    var var39 = null;
    var var40 = null;
    var var41 = null;
    var var42 = null;
    var var43 = null;
    var var44 = null;
    var var45 = null;
    var var46 = null;
    var var47 = 0;
    var var48 = null;
    var var49 = null;
    var phi50 = null;
    var phi51 = null;
    var phi52 = null;
    var phi53 = null;
    var var54 = null;
    var var55 = 0;
    var var56 = null;
    var var57 = null;
    var var58 = null;
    var var59 = null;
    var var60 = 0;
    var var61 = 0;
    var var62 = null;
    var var63 = null;
    var var64 = null;
    var var65 = null;
    var var66 = null;
    var0 = (arg1) | 0;
    org$luaj$vm2$Print.$i;
    var1 = (org$luaj$vm2$Print.ps);
    java$io$PrintStream.prototype.V$print$C.call(var1,91);
    phi2 = arg0;
    phi3 = (var0) | 0;
    phi4 = arg2;
    phi5 = (0) | 0;
    L665213014: while(true) {
     var6 = (phi5) | 0;
     var7 = phi2;
     var8 = (var7.data.length) | 0;
     if (var6 >= var8) {
      var65 = (org$luaj$vm2$Print.ps);
      var66 = phi4;
      java$io$PrintStream.prototype.V$print$Ljava$lang$Object$.call(var65,var66);
      return;
     } else {
      var9 = phi2;
      var10 = (phi5) | 0;
      var11 = (var9.data[var10]);
      var12 = var11;
      If_37_0: {
       if (var12 != null) {
        var20 = ((var11.I$type$$())) | 0;
        if ((var20) >= 4 && (var20) <= 7) switch ((var20) - 4) {
         case 0: {
          var45 = (var11.Lorg$luaj$vm2$LuaString$$checkstring$$());
          var46 = (org$luaj$vm2$Print.ps);
          var47 = ((org$luaj$vm2$LuaString.prototype.I$length$$.call(var45))) | 0;
          If_185_0: {
           if (var47 >= 48) {
            var54 = new java$lang$StringBuffer();
            java$lang$StringBuffer.prototype.V$$init$$$.call(var54);
            var55 = (32) | 0;
            var56 = (org$luaj$vm2$LuaString.prototype.Lorg$luaj$vm2$LuaString$$substring$I$I.call(var45,0,var55));
            var57 = (org$luaj$vm2$LuaString.prototype.Ljava$lang$String$$tojstring$$.call(var56));
            var58 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var54,var57));
            var59 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var58,bytecoder.stringconstants[267]));
            var60 = ((org$luaj$vm2$LuaString.prototype.I$length$$.call(var45))) | 0;
            var61 = ((var60 - 32)) | 0;
            var62 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var59,var61));
            var63 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var62,bytecoder.stringconstants[268]));
            var64 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var63));
            phi50 = var11;
            phi51 = var45;
            phi52 = var46;
            phi53 = var64;
            break If_185_0;
           } else {
            var48 = var45;
            var49 = (org$luaj$vm2$LuaString.prototype.Ljava$lang$String$$tojstring$$.call(var48));
            // Here was a goto statement
            phi50 = var11;
            phi51 = var45;
            phi52 = var46;
            phi53 = var49;
            break If_185_0;
           }
          }
          java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(phi52,phi53);
          // Here was a goto statement
          phi14 = phi50;
          break If_37_0;
         }
         case 1: {
          var43 = (org$luaj$vm2$Print.ps);
          var44 = (var11.Ljava$lang$String$$tojstring$$());
          java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var43,var44);
          phi14 = var11;
          break If_37_0;
         }
         case 2: {
          var41 = (org$luaj$vm2$Print.ps);
          var42 = (var11.Ljava$lang$String$$tojstring$$());
          java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var41,var42);
          // Here was a goto statement
          phi14 = var11;
          break If_37_0;
         }
         case 3: {
          var21 = (var11.Ljava$lang$Object$$touserdata$$());
          var22 = var21;
          if (var22 == null) {
           var39 = (org$luaj$vm2$Print.ps);
           var40 = (var11.Ljava$lang$String$$toString$$());
           java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var39,var40);
           // Here was a goto statement
           phi14 = var11;
           break If_37_0;
          } else {
           var23 = var21;
           var24 = ((var23).constructor.$rt);
           var25 = (java$lang$Class.prototype.Ljava$lang$String$$getName$$.call(var24));
           var26 = var25;
           var27 = (46) | 0;
           var28 = ((java$lang$String.prototype.I$lastIndexOf$I.call(var25,var27))) | 0;
           var29 = ((var28 + 1)) | 0;
           var30 = (java$lang$String.prototype.Ljava$lang$String$$substring$I.call(var26,var29));
           var31 = (org$luaj$vm2$Print.ps);
           var32 = new java$lang$StringBuffer();
           java$lang$StringBuffer.prototype.V$$init$$$.call(var32);
           var33 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var32,var30));
           var34 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var33,bytecoder.stringconstants[124]));
           var35 = ((var21.I$hashCode$$())) | 0;
           java$lang$Integer.$i;
           var36 = (java$lang$Integer.Ljava$lang$String$$toHexString$I(var35));
           var37 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var34,var36));
           var38 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var37));
           java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var31,var38);
           // Here was a goto statement
           phi14 = var11;
           break If_37_0;
          }
         }
        } else {
         var43 = (org$luaj$vm2$Print.ps);
         var44 = (var11.Ljava$lang$String$$tojstring$$());
         java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var43,var44);
         phi14 = var11;
         break If_37_0;
        }
       } else {
        var13 = (org$luaj$vm2$Print.ps);
        java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var13,bytecoder.stringconstants[0]);
        // Here was a goto statement
        phi14 = var11;
        break If_37_0;
       }
      }
      var15 = (phi5) | 0;
      var16 = ((var15 + 1)) | 0;
      var17 = (phi3) | 0;
      If_56_0: {
       if (var16 != var17) {
        break If_56_0;
       } else {
        var18 = (org$luaj$vm2$Print.ps);
        java$io$PrintStream.prototype.V$print$C.call(var18,93);
        break If_56_0;
       }
      }
      var19 = (org$luaj$vm2$Print.ps);
      java$io$PrintStream.prototype.V$print$Ljava$lang$String$.call(var19,bytecoder.stringconstants[266]);
      phi5 = ((phi5 + 1)) | 0;
      // Here was a goto statement
      continue L665213014;
     }
    }
  }

  V$$init$$$() {
    org$luaj$vm2$Lua.prototype.V$$init$$$.call(this);
    return;
  }
}


class de$mirkosertic$bytecoder$api$web$Event extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(de$mirkosertic$bytecoder$api$web$Event,[java$lang$Object,de$mirkosertic$bytecoder$api$web$Event,de$mirkosertic$bytecoder$api$OpaqueReferenceType]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }
}


class java$nio$CharBuffer extends java$nio$Buffer {
  nativeObject = null;

  static $assertionsDisabled = false;
  static ARRAY_BASE_OFFSET = 0;
  hb = null;
  offset = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$nio$CharBuffer,[java$lang$Readable,java$lang$Object,java$nio$Buffer,java$lang$Comparable,java$nio$CharBuffer,java$lang$Appendable,java$lang$CharSequence]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      java$nio$Buffer.$i;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is CharBuffer.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    // line number 268
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(java$nio$CharBuffer.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    java$nio$CharBuffer.$i;
    java$nio$CharBuffer.$assertionsDisabled = phi2;
    // line number 283
    var3 = (java$nio$CharBuffer.UNSAFE);
    var4 = ((jdk$internal$misc$Unsafe.prototype.I$arrayBaseOffset$Ljava$lang$Class$.call(var3,de$mirkosertic$bytecoder$classlib$Array.$rt))) | 0;
    var5 = (var4 | 0);
    java$nio$CharBuffer.ARRAY_BASE_OFFSET = var5;
    return;
  }

  static Ljava$nio$CharBuffer$$allocate$I(arg0) {
    // source file is CharBuffer.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    // line number 372
    if (arg0 >= 0) {
     // line number 374
     java$nio$HeapCharBuffer.$i;
     var1 = new java$nio$HeapCharBuffer();
     var2 = (arg0) | 0;
     var3 = null;
     java$nio$HeapCharBuffer.prototype.V$$init$$I$I$Ljava$lang$foreign$MemorySegment$.call(var1,var2,arg0,var3);
     return var1;
    } else {
     // line number 373
     java$nio$CharBuffer.$i;
     var0 = (java$nio$Buffer.Ljava$lang$IllegalArgumentException$$createCapacityException$I(arg0));
     throw bytecoder.registerStack(var0, new Error().stack);
    }
  }

  V$$init$$I$I$I$I$$C$I$Ljava$lang$foreign$MemorySegment$(arg0,arg1,arg2,arg3,arg4,arg5,arg6) {
    // source file is CharBuffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var0 = (arg0) | 0;
    var1 = (arg2) | 0;
    var2 = arg4;
    var3 = arg6;
    // line number 299
    var4 = (var0) | 0;
    var5 = (var1) | 0;
    var6 = var3;
    java$nio$Buffer.prototype.V$$init$$I$I$I$I$Ljava$lang$foreign$MemorySegment$.call(this,var4,arg1,var5,arg3,var6);
    // line number 300
    var7 = this;
    var7.hb = var2;
    // line number 301
    var8 = this;
    var8.offset = arg5;
    // line number 302
    return;
  }

  Ljava$nio$CharBuffer$$put$Ljava$lang$String$(arg0) {
    // source file is CharBuffer.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var0 = arg0;
    // line number 1438
    var1 = var0;
    var2 = ((java$lang$String.prototype.I$length$$.call(var0))) | 0;
    var3 = (this.Ljava$nio$CharBuffer$$put$Ljava$lang$String$$I$I(var1,0,var2));
    return var3;
  }

  Ljava$nio$CharBuffer$$put$Ljava$lang$String$$I$I(arg0,arg1,arg2) {
    // source file is CharBuffer.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = null;
    var var8 = 0;
    var var9 = 0;
    var var10 = null;
    var var11 = 0;
    var phi12 = null;
    var phi13 = null;
    var phi14 = 0;
    var phi15 = 0;
    var var16 = 0;
    var var17 = 0;
    var var18 = null;
    var var19 = null;
    var var20 = 0;
    var var21 = 0;
    var var22 = null;
    var var23 = null;
    var0 = arg0;
    var1 = (arg2) | 0;
    // line number 1406
    var2 = (var1) | 0;
    var3 = ((var2 - arg1)) | 0;
    var4 = ((java$lang$String.prototype.I$length$$.call(var0))) | 0;
    var5 = ((java$util$Objects.I$checkFromIndexSize$I$I$I(arg1,var3,var4))) | 0;
    // line number 1407
    var6 = (this.Z$isReadOnly$$());
    if (var6 == 0) {
     // line number 1409
     var8 = ((var1 - arg1)) | 0;
     var9 = ((this.I$remaining$$())) | 0;
     if (var8 <= var9) {
      // line number 1411
      var11 = (arg1) | 0;
      phi12 = this;
      phi13 = var0;
      phi14 = (var1) | 0;
      phi15 = (var11) | 0;
      L853755517: while(true) {
       var16 = (phi15) | 0;
       var17 = (phi14) | 0;
       if (var16 >= var17) {
        // line number 1413
        var23 = phi12;
        return var23;
       } else {
        // line number 1412
        var18 = phi12;
        var19 = phi13;
        var20 = (phi15) | 0;
        var21 = (java$lang$String.prototype.C$charAt$I.call(var19,var20));
        var22 = (var18.Ljava$nio$CharBuffer$$put$C(var21));
        // line number 1411
        phi15 = ((phi15 + 1)) | 0;
        // Here was a goto statement
        continue L853755517;
       }
      }
     } else {
      // line number 1410
      var10 = new java$nio$BufferOverflowException();
      java$nio$BufferOverflowException.prototype.V$$init$$$.call(var10);
      throw bytecoder.registerStack(var10, new Error().stack);
     }
    } else {
     // line number 1408
     var7 = new java$nio$ReadOnlyBufferException();
     java$nio$ReadOnlyBufferException.prototype.V$$init$$$.call(var7);
     throw bytecoder.registerStack(var7, new Error().stack);
    }
  }

  Z$isEmpty$$() {
    // source file is CharBuffer.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    // line number 1901
    var0 = ((this.I$remaining$$())) | 0;
    If_7_0: {
     if (var0 != 0) {
      phi2 = this;
      phi3 = (0) | 0;
      break If_7_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = this;
      phi3 = (var1) | 0;
      break If_7_0;
     }
    }
    return phi3;
  }

  I$length$$() {
    // source file is CharBuffer.java
    var var0 = 0;
    // line number 1889
    var0 = ((this.I$remaining$$())) | 0;
    return var0;
  }

  V$$init$$I$I$I$I$Ljava$lang$foreign$MemorySegment$(arg0,arg1,arg2,arg3,arg4) {
    // source file is CharBuffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var var5 = null;
    var0 = (arg0) | 0;
    var1 = (arg2) | 0;
    var2 = arg4;
    // line number 307
    var3 = (var0) | 0;
    var4 = (var1) | 0;
    var5 = null;
    java$nio$CharBuffer.prototype.V$$init$$I$I$I$I$$C$I$Ljava$lang$foreign$MemorySegment$.call(this,var3,arg1,var4,arg3,var5,0,var2);
    // line number 308
    return;
  }

  Ljava$nio$Buffer$$limit$I(arg0) {
    // source file is CharBuffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var0 = (arg0) | 0;
    // line number 268
    var1 = (var0) | 0;
    var2 = (java$nio$CharBuffer.prototype.Ljava$nio$CharBuffer$$limit$I.call(this,var1));
    return var2;
  }

  Ljava$nio$CharBuffer$$limit$I(arg0) {
    // source file is CharBuffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var0 = (arg0) | 0;
    // line number 1540
    var1 = (var0) | 0;
    var2 = (java$nio$Buffer.prototype.Ljava$nio$Buffer$$limit$I.call(this,var1));
    // line number 1541
    return this;
  }

  Ljava$nio$Buffer$$position$I(arg0) {
    // source file is CharBuffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var0 = (arg0) | 0;
    // line number 268
    var1 = (var0) | 0;
    var2 = (java$nio$CharBuffer.prototype.Ljava$nio$CharBuffer$$position$I.call(this,var1));
    return var2;
  }

  Ljava$nio$CharBuffer$$position$I(arg0) {
    // source file is CharBuffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var0 = (arg0) | 0;
    // line number 1527
    var1 = (var0) | 0;
    var2 = (java$nio$Buffer.prototype.Ljava$nio$Buffer$$position$I.call(this,var1));
    // line number 1528
    return this;
  }

  I$compareTo$Ljava$lang$Object$(arg0) {
    // source file is CharBuffer.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var0 = arg0;
    // line number 268
    var1 = var0;
    var2 = var1;
    var3 = ((java$nio$CharBuffer.prototype.I$compareTo$Ljava$nio$CharBuffer$.call(this,var2))) | 0;
    return var3;
  }

  I$compareTo$Ljava$nio$CharBuffer$(arg0) {
    // source file is CharBuffer.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = 0;
    var var17 = 0;
    var var18 = 0;
    var var19 = 0;
    var var20 = 0;
    var0 = arg0;
    // line number 1790
    var1 = ((this.I$position$$())) | 0;
    // line number 1791
    var2 = ((this.I$limit$$())) | 0;
    var3 = ((var2 - var1)) | 0;
    // line number 1792
    var4 = ((var0.I$position$$())) | 0;
    // line number 1793
    var5 = ((var0.I$limit$$())) | 0;
    var6 = ((var5 - var4)) | 0;
    // line number 1794
    var7 = (var6) | 0;
    java$lang$Math.$i;
    var8 = ((java$lang$Math.I$min$I$I(var3,var7))) | 0;
    // line number 1795
    if (var8 >= 0) {
     // line number 1797
     var9 = (var1) | 0;
     var10 = (var4) | 0;
     java$nio$BufferMismatch.$i;
     var11 = ((java$nio$BufferMismatch.I$mismatch$Ljava$nio$CharBuffer$$I$Ljava$nio$CharBuffer$$I$I(this,var9,var0,var10,var8))) | 0;
     // line number 1800
     if (var11 < 0) {
      // line number 1803
      var19 = (var6) | 0;
      var20 = ((var3 - var19)) | 0;
      return var20;
     } else {
      // line number 1801
      var12 = (var1) | 0;
      var13 = ((var12 + var11)) | 0;
      var14 = (this.C$get$I(var13));
      var15 = (var4) | 0;
      var16 = ((var15 + var11)) | 0;
      var17 = (var0.C$get$I(var16));
      java$nio$CharBuffer.$i;
      var18 = ((java$nio$CharBuffer.I$compare$C$C(var14,var17))) | 0;
      return var18;
     }
    } else {
     // line number 1796
     return -1;
    }
  }

  Ljava$lang$Object$$base$$() {
    // source file is CharBuffer.java
    var var0 = null;
    // line number 320
    var0 = (this.hb);
    return var0;
  }

  static I$compare$C$C(arg0,arg1) {
    // source file is CharBuffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var0 = arg1;
    // line number 1813
    var1 = var0;
    var2 = ((java$lang$Character.I$compare$C$C(arg0,var1))) | 0;
    return var2;
  }

  Ljava$lang$String$$toString$$() {
    // source file is CharBuffer.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = null;
    // line number 1870
    var0 = this;
    var1 = ((var0.I$position$$())) | 0;
    var2 = ((this.I$limit$$())) | 0;
    var3 = (this.Ljava$lang$String$$toString$I$I(var1,var2));
    return var3;
  }

  Z$equals$Ljava$lang$Object$(arg0) {
    // source file is CharBuffer.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var phi11 = null;
    var phi12 = null;
    var phi13 = null;
    var phi14 = 0;
    var phi15 = 0;
    var phi16 = 0;
    var phi17 = 0;
    var var18 = 0;
    var var19 = 0;
    var var20 = 0;
    var var21 = 0;
    var phi22 = null;
    var phi23 = null;
    var phi24 = null;
    var phi25 = 0;
    var phi26 = 0;
    var phi27 = 0;
    var phi28 = 0;
    var phi29 = 0;
    var0 = arg0;
    // line number 1750
    var1 = var0;
    if (this != var1) {
     // line number 1752
     var2 = (bytecoder.instanceOf(var0,java$nio$CharBuffer)) | 0;
     if (var2 != 0) {
      // line number 1754
      var3 = var0;
      // line number 1755
      var4 = ((this.I$position$$())) | 0;
      // line number 1756
      var5 = ((this.I$limit$$())) | 0;
      var6 = ((var5 - var4)) | 0;
      // line number 1757
      var7 = ((var3.I$position$$())) | 0;
      // line number 1758
      var8 = ((var3.I$limit$$())) | 0;
      var9 = ((var8 - var7)) | 0;
      // line number 1759
      If_63_0: {
       if (var6 < 0) {
        phi11 = this;
        phi12 = var0;
        phi13 = var3;
        phi14 = (var4) | 0;
        phi15 = (var6) | 0;
        phi16 = (var7) | 0;
        phi17 = (var9) | 0;
        break If_63_0;
       } else {
        var10 = (var6) | 0;
        if (var10 == var9) {
         // line number 1761
         var18 = (var4) | 0;
         var19 = (var7) | 0;
         java$nio$BufferMismatch.$i;
         var20 = ((java$nio$BufferMismatch.I$mismatch$Ljava$nio$CharBuffer$$I$Ljava$nio$CharBuffer$$I$I(this,var18,var3,var19,var6))) | 0;
         If_94_0: {
          if (var20 >= 0) {
           phi22 = this;
           phi23 = var0;
           phi24 = var3;
           phi25 = (var4) | 0;
           phi26 = (var6) | 0;
           phi27 = (var7) | 0;
           phi28 = (var9) | 0;
           phi29 = (0) | 0;
           break If_94_0;
          } else {
           var21 = (1) | 0;
           // Here was a goto statement
           phi22 = this;
           phi23 = var0;
           phi24 = var3;
           phi25 = (var4) | 0;
           phi26 = (var6) | 0;
           phi27 = (var7) | 0;
           phi28 = (var9) | 0;
           phi29 = (var21) | 0;
           break If_94_0;
          }
         }
         return phi29;
        } else {
         phi11 = this;
         phi12 = var0;
         phi13 = var3;
         phi14 = (var4) | 0;
         phi15 = (var6) | 0;
         phi16 = (var7) | 0;
         phi17 = (var9) | 0;
         break If_63_0;
        }
       }
      }
      // line number 1760
      return 0;
     } else {
      // line number 1753
      return 0;
     }
    } else {
     // line number 1751
     return 1;
    }
  }

  I$hashCode$$() {
    // source file is CharBuffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var phi3 = null;
    var phi4 = 0;
    var phi5 = 0;
    var phi6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = null;
    var var12 = 0;
    var var13 = 0;
    var var14 = 0;
    var var15 = 0;
    // line number 1706
    // line number 1707
    var0 = ((this.I$position$$())) | 0;
    // line number 1708
    var1 = ((this.I$limit$$())) | 0;
    var2 = ((var1 - 1)) | 0;
    phi3 = this;
    phi4 = (1) | 0;
    phi5 = (var0) | 0;
    phi6 = (var2) | 0;
    L2075270532: while(true) {
     var7 = (phi6) | 0;
     var8 = (phi5) | 0;
     if (var7 < var8) {
      // line number 1714
      var15 = (phi4) | 0;
      return var15;
     } else {
      // line number 1712
      var9 = (phi4) | 0;
      var10 = ((31 * var9)) | 0;
      var11 = phi3;
      var12 = (phi6) | 0;
      var13 = (var11.C$get$I(var12));
      var14 = ((var10 + var13)) | 0;
      // line number 1708
      phi6 = ((phi6 + -1)) | 0;
      // Here was a goto statement
      phi4 = (var14) | 0;
      continue L2075270532;
     }
    }
  }

  Ljava$nio$CharBuffer$$put$$C(arg0) {
    // source file is CharBuffer.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var0 = arg0;
    // line number 1221
    var1 = var0;
    var2 = (var0.data.length) | 0;
    var3 = (this.Ljava$nio$CharBuffer$$put$$C$I$I(var1,0,var2));
    return var3;
  }

  Ljava$nio$CharBuffer$$put$$C$I$I(arg0,arg1,arg2) {
    // source file is CharBuffer.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = null;
    var var11 = 0;
    var var12 = 0;
    var var13 = null;
    var var14 = 0;
    var var15 = 0;
    var var16 = null;
    var0 = arg0;
    var1 = (arg2) | 0;
    // line number 1185
    var2 = (this.Z$isReadOnly$$());
    if (var2 == 0) {
     // line number 1187
     var4 = var0;
     var5 = (var4.data.length) | 0;
     var6 = ((java$util$Objects.I$checkFromIndexSize$I$I$I(arg1,var1,var5))) | 0;
     // line number 1188
     var7 = ((this.I$position$$())) | 0;
     // line number 1189
     var8 = ((this.I$limit$$())) | 0;
     var9 = ((var8 - var7)) | 0;
     if (var1 <= var9) {
      // line number 1192
      var11 = (var7) | 0;
      var12 = (var1) | 0;
      var13 = (java$nio$CharBuffer.prototype.Ljava$nio$CharBuffer$$putArray$I$$C$I$I.call(this,var11,var0,arg1,var12));
      // line number 1194
      var14 = (var7) | 0;
      var15 = ((var14 + var1)) | 0;
      var16 = (java$nio$CharBuffer.prototype.Ljava$nio$CharBuffer$$position$I.call(this,var15));
      // line number 1195
      return this;
     } else {
      // line number 1190
      var10 = new java$nio$BufferOverflowException();
      java$nio$BufferOverflowException.prototype.V$$init$$$.call(var10);
      throw bytecoder.registerStack(var10, new Error().stack);
     }
    } else {
     // line number 1186
     var3 = new java$nio$ReadOnlyBufferException();
     java$nio$ReadOnlyBufferException.prototype.V$$init$$$.call(var3);
     throw bytecoder.registerStack(var3, new Error().stack);
    }
  }

  Ljava$nio$CharBuffer$$putArray$I$$C$I$I(arg0,arg1,arg2,arg3) {
    // source file is CharBuffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = 0;
    var phi17 = null;
    var phi18 = 0;
    var phi19 = null;
    var phi20 = 0;
    var phi21 = 0;
    var phi22 = 0;
    var phi23 = 0;
    var phi24 = 0;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = 0;
    var var34 = null;
    var var35 = null;
    var var36 = 0;
    var var37 = 0;
    var var38 = null;
    var var39 = null;
    var var40 = null;
    var var41 = null;
    var var42 = null;
    var var43 = null;
    var var44 = 0;
    var var45 = null;
    var var46 = null;
    var var47 = 0;
    var var48 = 0;
    var phi49 = null;
    var phi50 = 0;
    var phi51 = null;
    var phi52 = 0;
    var phi53 = 0;
    var var54 = 0;
    var var55 = 0;
    var var56 = 0;
    var var57 = 0;
    var var58 = 0;
    var phi59 = 0;
    var phi60 = 0;
    var phi61 = 0;
    var var62 = 0;
    var var63 = 0;
    var var64 = null;
    var var65 = 0;
    var var66 = null;
    var var67 = 0;
    var var68 = 0;
    var var69 = null;
    var0 = (arg0) | 0;
    var1 = (arg2) | 0;
    // line number 1315
    // line number 1317
    var2 = (java$nio$CharBuffer.prototype.Z$isAddressable$$.call(this));
    If_17_0: {
     If_17_1: {
      if (var2 == 0) {
       phi49 = this;
       phi50 = (var0) | 0;
       phi51 = arg1;
       phi52 = (var1) | 0;
       phi53 = (arg3) | 0;
       break If_17_1;
      } else {
       var3 = (arg3) | 0;
       var4 = (var3 | 0);
       var5 = (var4 << 1);
       var6 = (bytecoder.cmp(var5,6)) | 0;
       if (var6 <= 0) {
        phi49 = this;
        phi50 = (var0) | 0;
        phi51 = arg1;
        phi52 = (var1) | 0;
        phi53 = (arg3) | 0;
        break If_17_1;
       } else {
        // line number 1320
        var7 = (this.address);
        var8 = (var0 | 0);
        var9 = (var8 << 1);
        var10 = (var7 + var9);
        // line number 1321
        java$nio$CharBuffer.$i;
        var11 = (java$nio$CharBuffer.ARRAY_BASE_OFFSET);
        var12 = (var1 | 0);
        var13 = (var12 << 1);
        var14 = (var11 + var13);
        // line number 1323
        var15 = (arg3 | 0);
        var16 = (var15 << 1);
        phi17 = this;
        phi18 = (var0) | 0;
        phi19 = arg1;
        phi20 = (var1) | 0;
        phi21 = (arg3) | 0;
        phi22 = var10;
        phi23 = var14;
        phi24 = var16;
        TryCatch_85_0: {
         try {
          // line number 1327
          var26 = phi17;
          var27 = (var26.Ljava$nio$ByteOrder$$order$$());
          java$nio$ByteOrder.$i;
          var28 = (java$nio$ByteOrder.Ljava$nio$ByteOrder$$nativeOrder$$());
          if (var27 == var28) {
           // line number 1333
           var40 = (java$nio$CharBuffer.SCOPED_MEMORY_ACCESS);
           var41 = phi17;
           // line number 1334
           var42 = (var41.Ljdk$internal$foreign$MemorySessionImpl$$session$$());
           var43 = phi19;
           var44 = phi23;
           var45 = phi17;
           // line number 1335
           var46 = (java$nio$CharBuffer.prototype.Ljava$lang$Object$$base$$.call(var45));
           var47 = phi22;
           var48 = phi24;
           // line number 1333
           jdk$internal$misc$ScopedMemoryAccess.prototype.V$copyMemory$Ljdk$internal$foreign$MemorySessionImpl$$Ljdk$internal$foreign$MemorySessionImpl$$Ljava$lang$Object$$J$Ljava$lang$Object$$J$J.call(var40,null,var42,var43,var44,var46,var47,var48);
           break TryCatch_85_0;
          } else {
           // line number 1328
           var29 = (java$nio$CharBuffer.SCOPED_MEMORY_ACCESS);
           var30 = phi17;
           // line number 1329
           var31 = (var30.Ljdk$internal$foreign$MemorySessionImpl$$session$$());
           var32 = phi19;
           var33 = phi23;
           var34 = phi17;
           // line number 1330
           var35 = (java$nio$CharBuffer.prototype.Ljava$lang$Object$$base$$.call(var34));
           var36 = phi22;
           var37 = phi24;
           // line number 1328
           jdk$internal$misc$ScopedMemoryAccess.prototype.V$copySwapMemory$Ljdk$internal$foreign$MemorySessionImpl$$Ljdk$internal$foreign$MemorySessionImpl$$Ljava$lang$Object$$J$Ljava$lang$Object$$J$J$J.call(var29,null,var31,var32,var33,var35,var36,var37,2);
           // Here was a goto statement
           break TryCatch_85_0;
          }
         } catch (__ex) {
          if (__ex instanceof java$lang$Throwable) {
           TryCatch_86_0: {
            // line number 1337
            break TryCatch_86_0;
           }
           var25 = phi17;
           java$lang$ref$Reference.V$reachabilityFence$Ljava$lang$Object$(var25);
           // line number 1338
           throw bytecoder.registerStack(__ex, new Error().stack);
          }
          throw __ex;
         }
        }
        // line number 1337
        var38 = phi17;
        java$lang$ref$Reference.V$reachabilityFence$Ljava$lang$Object$(var38);
        // line number 1338
        // Here was a goto statement
        // line number 1339
        // Here was a goto statement
        break If_17_0;
       }
      }
     }
     // line number 1340
     var54 = (phi52) | 0;
     var55 = (phi53) | 0;
     var56 = ((var54 + var55)) | 0;
     // line number 1341
     var57 = (phi52) | 0;
     var58 = (phi50) | 0;
     phi59 = (var56) | 0;
     phi60 = (var57) | 0;
     phi61 = (var58) | 0;
     L1030438675: while(true) {
      var62 = (phi60) | 0;
      var63 = (phi59) | 0;
      if (var62 >= var63) {
       phi17 = phi49;
       phi18 = (phi50) | 0;
       phi19 = phi51;
       phi20 = (phi52) | 0;
       phi21 = (phi53) | 0;
       phi22 = phi59;
       phi23 = phi61;
       break If_17_0;
      } else {
       // line number 1342
       var64 = phi49;
       var65 = (phi61) | 0;
       var66 = phi51;
       var67 = (phi60) | 0;
       var68 = (var66.data[var67]);
       var69 = (var64.Ljava$nio$CharBuffer$$put$I$C(var65,var68));
       // line number 1341
       phi60 = ((phi60 + 1)) | 0;
       phi61 = ((phi61 + 1)) | 0;
       // Here was a goto statement
       continue L1030438675;
      }
     }
    }
    // line number 1344
    var39 = phi17;
    return var39;
  }

  Z$isAddressable$$() {
    // source file is CharBuffer.java
    // line number 1668
    return 1;
  }

  Ljava$nio$Buffer$$flip$$() {
    // source file is CharBuffer.java
    var var0 = null;
    // line number 268
    var0 = (java$nio$CharBuffer.prototype.Ljava$nio$CharBuffer$$flip$$.call(this));
    return var0;
  }

  Ljava$nio$CharBuffer$$flip$$() {
    // source file is CharBuffer.java
    var var0 = null;
    // line number 1592
    var0 = (java$nio$Buffer.prototype.Ljava$nio$Buffer$$flip$$.call(this));
    // line number 1593
    return this;
  }

  Ljava$nio$Buffer$$clear$$() {
    // source file is CharBuffer.java
    var var0 = null;
    // line number 268
    var0 = (java$nio$CharBuffer.prototype.Ljava$nio$CharBuffer$$clear$$.call(this));
    return var0;
  }

  Ljava$nio$CharBuffer$$clear$$() {
    // source file is CharBuffer.java
    var var0 = null;
    // line number 1579
    var0 = (java$nio$Buffer.prototype.Ljava$nio$Buffer$$clear$$.call(this));
    // line number 1580
    return this;
  }

  static Ljava$nio$CharBuffer$$wrap$$C$I$I(arg0,arg1,arg2) {
    // source file is CharBuffer.java
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var0 = (arg1) | 0;
    TryCatch_6_0: {
     try {
      // line number 419
      java$nio$HeapCharBuffer.$i;
      var2 = new java$nio$HeapCharBuffer();
      var3 = arg0;
      var4 = (arg2) | 0;
      java$nio$HeapCharBuffer.prototype.V$$init$$$C$I$I$Ljava$lang$foreign$MemorySegment$.call(var2,var3,var0,var4,null);
      break TryCatch_6_0;
     } catch (__ex) {
      if (__ex instanceof java$lang$IllegalArgumentException) {
       // line number 420
       // line number 421
       var1 = new java$lang$IndexOutOfBoundsException();
       java$lang$IndexOutOfBoundsException.prototype.V$$init$$$.call(var1);
       throw bytecoder.registerStack(var1, new Error().stack);
      }
      throw __ex;
     }
    }
    return var2;
  }

  Ljava$nio$CharBuffer$$get$$C$I$I(arg0,arg1,arg2) {
    // source file is CharBuffer.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = null;
    var var9 = 0;
    var var10 = 0;
    var var11 = null;
    var var12 = 0;
    var var13 = 0;
    var var14 = null;
    var0 = arg0;
    var1 = (arg2) | 0;
    // line number 806
    var2 = (var1) | 0;
    var3 = (var0.data.length) | 0;
    var4 = ((java$util$Objects.I$checkFromIndexSize$I$I$I(arg1,var2,var3))) | 0;
    // line number 807
    var5 = ((this.I$position$$())) | 0;
    // line number 808
    var6 = ((this.I$limit$$())) | 0;
    var7 = ((var6 - var5)) | 0;
    if (var1 <= var7) {
     // line number 811
     var9 = (var5) | 0;
     var10 = (var1) | 0;
     var11 = (java$nio$CharBuffer.prototype.Ljava$nio$CharBuffer$$getArray$I$$C$I$I.call(this,var9,var0,arg1,var10));
     // line number 813
     var12 = (var5) | 0;
     var13 = ((var12 + var1)) | 0;
     var14 = (java$nio$CharBuffer.prototype.Ljava$nio$CharBuffer$$position$I.call(this,var13));
     // line number 814
     return this;
    } else {
     // line number 809
     var8 = new java$nio$BufferUnderflowException();
     java$nio$BufferUnderflowException.prototype.V$$init$$$.call(var8);
     throw bytecoder.registerStack(var8, new Error().stack);
    }
  }

  Ljava$nio$CharBuffer$$getArray$I$$C$I$I(arg0,arg1,arg2,arg3) {
    // source file is CharBuffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = 0;
    var phi17 = null;
    var phi18 = 0;
    var phi19 = null;
    var phi20 = 0;
    var phi21 = 0;
    var phi22 = 0;
    var phi23 = 0;
    var phi24 = 0;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = 0;
    var var35 = null;
    var var36 = 0;
    var var37 = 0;
    var var38 = null;
    var var39 = null;
    var var40 = null;
    var var41 = null;
    var var42 = null;
    var var43 = null;
    var var44 = null;
    var var45 = 0;
    var var46 = null;
    var var47 = 0;
    var var48 = 0;
    var phi49 = null;
    var phi50 = 0;
    var phi51 = null;
    var phi52 = 0;
    var phi53 = 0;
    var var54 = 0;
    var var55 = 0;
    var var56 = 0;
    var var57 = 0;
    var var58 = 0;
    var phi59 = 0;
    var phi60 = 0;
    var phi61 = 0;
    var var62 = 0;
    var var63 = 0;
    var var64 = null;
    var var65 = 0;
    var var66 = null;
    var var67 = 0;
    var var68 = 0;
    var0 = (arg0) | 0;
    var1 = (arg2) | 0;
    // line number 925
    // line number 927
    var2 = (java$nio$CharBuffer.prototype.Z$isAddressable$$.call(this));
    If_17_0: {
     If_17_1: {
      if (var2 == 0) {
       phi49 = this;
       phi50 = (var0) | 0;
       phi51 = arg1;
       phi52 = (var1) | 0;
       phi53 = (arg3) | 0;
       break If_17_1;
      } else {
       var3 = (arg3) | 0;
       var4 = (var3 | 0);
       var5 = (var4 << 1);
       var6 = (bytecoder.cmp(var5,6)) | 0;
       if (var6 <= 0) {
        phi49 = this;
        phi50 = (var0) | 0;
        phi51 = arg1;
        phi52 = (var1) | 0;
        phi53 = (arg3) | 0;
        break If_17_1;
       } else {
        // line number 930
        var7 = (this.address);
        var8 = (var0 | 0);
        var9 = (var8 << 1);
        var10 = (var7 + var9);
        // line number 931
        java$nio$CharBuffer.$i;
        var11 = (java$nio$CharBuffer.ARRAY_BASE_OFFSET);
        var12 = (var1 | 0);
        var13 = (var12 << 1);
        var14 = (var11 + var13);
        // line number 933
        var15 = (arg3 | 0);
        var16 = (var15 << 1);
        phi17 = this;
        phi18 = (var0) | 0;
        phi19 = arg1;
        phi20 = (var1) | 0;
        phi21 = (arg3) | 0;
        phi22 = var10;
        phi23 = var14;
        phi24 = var16;
        TryCatch_85_0: {
         try {
          // line number 937
          var26 = phi17;
          var27 = (var26.Ljava$nio$ByteOrder$$order$$());
          java$nio$ByteOrder.$i;
          var28 = (java$nio$ByteOrder.Ljava$nio$ByteOrder$$nativeOrder$$());
          if (var27 == var28) {
           // line number 943
           var40 = (java$nio$CharBuffer.SCOPED_MEMORY_ACCESS);
           var41 = phi17;
           // line number 944
           var42 = (var41.Ljdk$internal$foreign$MemorySessionImpl$$session$$());
           var43 = phi17;
           var44 = (java$nio$CharBuffer.prototype.Ljava$lang$Object$$base$$.call(var43));
           var45 = phi22;
           var46 = phi19;
           var47 = phi23;
           var48 = phi24;
           // line number 943
           jdk$internal$misc$ScopedMemoryAccess.prototype.V$copyMemory$Ljdk$internal$foreign$MemorySessionImpl$$Ljdk$internal$foreign$MemorySessionImpl$$Ljava$lang$Object$$J$Ljava$lang$Object$$J$J.call(var40,var42,null,var44,var45,var46,var47,var48);
           break TryCatch_85_0;
          } else {
           // line number 938
           var29 = (java$nio$CharBuffer.SCOPED_MEMORY_ACCESS);
           var30 = phi17;
           // line number 939
           var31 = (var30.Ljdk$internal$foreign$MemorySessionImpl$$session$$());
           var32 = phi17;
           var33 = (java$nio$CharBuffer.prototype.Ljava$lang$Object$$base$$.call(var32));
           var34 = phi22;
           var35 = phi19;
           var36 = phi23;
           var37 = phi24;
           // line number 938
           jdk$internal$misc$ScopedMemoryAccess.prototype.V$copySwapMemory$Ljdk$internal$foreign$MemorySessionImpl$$Ljdk$internal$foreign$MemorySessionImpl$$Ljava$lang$Object$$J$Ljava$lang$Object$$J$J$J.call(var29,var31,null,var33,var34,var35,var36,var37,2);
           // Here was a goto statement
           break TryCatch_85_0;
          }
         } catch (__ex) {
          if (__ex instanceof java$lang$Throwable) {
           TryCatch_86_0: {
            // line number 947
            break TryCatch_86_0;
           }
           var25 = phi17;
           java$lang$ref$Reference.V$reachabilityFence$Ljava$lang$Object$(var25);
           // line number 948
           throw bytecoder.registerStack(__ex, new Error().stack);
          }
          throw __ex;
         }
        }
        // line number 947
        var38 = phi17;
        java$lang$ref$Reference.V$reachabilityFence$Ljava$lang$Object$(var38);
        // line number 948
        // Here was a goto statement
        // line number 949
        // Here was a goto statement
        break If_17_0;
       }
      }
     }
     // line number 950
     var54 = (phi52) | 0;
     var55 = (phi53) | 0;
     var56 = ((var54 + var55)) | 0;
     // line number 951
     var57 = (phi52) | 0;
     var58 = (phi50) | 0;
     phi59 = (var56) | 0;
     phi60 = (var57) | 0;
     phi61 = (var58) | 0;
     L1059014433: while(true) {
      var62 = (phi60) | 0;
      var63 = (phi59) | 0;
      if (var62 >= var63) {
       phi17 = phi49;
       phi18 = (phi50) | 0;
       phi19 = phi51;
       phi20 = (phi52) | 0;
       phi21 = (phi53) | 0;
       phi22 = phi59;
       phi23 = phi61;
       break If_17_0;
      } else {
       // line number 952
       var64 = phi51;
       var65 = (phi60) | 0;
       var66 = phi49;
       var67 = (phi61) | 0;
       var68 = (var66.C$get$I(var67));
       var64.data[var65] = var68;
       // line number 951
       phi60 = ((phi60 + 1)) | 0;
       phi61 = ((phi61 + 1)) | 0;
       // Here was a goto statement
       continue L1059014433;
      }
     }
    }
    // line number 955
    var39 = phi17;
    return var39;
  }
}


class java$nio$ByteBuffer extends java$nio$Buffer {
  nativeObject = null;

  static $assertionsDisabled = false;
  static ARRAY_BASE_OFFSET = 0;
  bigEndian = false;
  nativeByteOrder = false;
  hb = null;
  offset = 0;
  isReadOnly = false;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$nio$ByteBuffer,[java$lang$Object,java$nio$Buffer,java$lang$Comparable,java$nio$ByteBuffer]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      java$nio$Buffer.$i;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is ByteBuffer.java
    var var0 = 0;
    var var1 = 0;
    var phi2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    // line number 268
    var0 = (java$lang$Class.prototype.Z$desiredAssertionStatus$$.call(java$nio$ByteBuffer.$rt));
    If_8_0: {
     if (var0 != 0) {
      phi2 = (0) | 0;
      break If_8_0;
     } else {
      var1 = (1) | 0;
      // Here was a goto statement
      phi2 = (var1) | 0;
      break If_8_0;
     }
    }
    java$nio$ByteBuffer.$i;
    java$nio$ByteBuffer.$assertionsDisabled = phi2;
    // line number 283
    var3 = (java$nio$ByteBuffer.UNSAFE);
    var4 = ((jdk$internal$misc$Unsafe.prototype.I$arrayBaseOffset$Ljava$lang$Class$.call(var3,de$mirkosertic$bytecoder$classlib$Array.$rt))) | 0;
    var5 = (var4 | 0);
    java$nio$ByteBuffer.ARRAY_BASE_OFFSET = var5;
    return;
  }

  static Ljava$nio$ByteBuffer$$allocate$I(arg0) {
    // source file is ByteBuffer.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    // line number 372
    if (arg0 >= 0) {
     // line number 374
     java$nio$HeapByteBuffer.$i;
     var1 = new java$nio$HeapByteBuffer();
     var2 = (arg0) | 0;
     var3 = null;
     java$nio$HeapByteBuffer.prototype.V$$init$$I$I$Ljava$lang$foreign$MemorySegment$.call(var1,var2,arg0,var3);
     return var1;
    } else {
     // line number 373
     java$nio$ByteBuffer.$i;
     var0 = (java$nio$Buffer.Ljava$lang$IllegalArgumentException$$createCapacityException$I(arg0));
     throw bytecoder.registerStack(var0, new Error().stack);
    }
  }

  V$$init$$I$I$I$I$$B$I$Ljava$lang$foreign$MemorySegment$(arg0,arg1,arg2,arg3,arg4,arg5,arg6) {
    // source file is ByteBuffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = 0;
    var phi11 = null;
    var phi12 = 0;
    var phi13 = 0;
    var phi14 = 0;
    var phi15 = 0;
    var phi16 = null;
    var phi17 = 0;
    var phi18 = null;
    var phi19 = null;
    var phi20 = 0;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = 0;
    var0 = (arg0) | 0;
    var1 = (arg2) | 0;
    var2 = arg4;
    var3 = arg6;
    // line number 299
    var4 = (var0) | 0;
    var5 = (var1) | 0;
    var6 = var3;
    java$nio$Buffer.prototype.V$$init$$I$I$I$I$Ljava$lang$foreign$MemorySegment$.call(this,var4,arg1,var5,arg3,var6);
    // line number 2091
    var7 = this;
    var7.bigEndian = 1;
    // line number 2093
    // line number 2094
    java$nio$ByteOrder.$i;
    var8 = (java$nio$ByteOrder.Ljava$nio$ByteOrder$$nativeOrder$$());
    var9 = (java$nio$ByteOrder.BIG_ENDIAN);
    If_45_0: {
     if (var8 != var9) {
      phi11 = this;
      phi12 = (var0) | 0;
      phi13 = (arg1) | 0;
      phi14 = (var1) | 0;
      phi15 = (arg3) | 0;
      phi16 = var2;
      phi17 = (arg5) | 0;
      phi18 = var3;
      phi19 = this;
      phi20 = (0) | 0;
      break If_45_0;
     } else {
      var10 = (1) | 0;
      // Here was a goto statement
      phi11 = this;
      phi12 = (var0) | 0;
      phi13 = (arg1) | 0;
      phi14 = (var1) | 0;
      phi15 = (arg3) | 0;
      phi16 = var2;
      phi17 = (arg5) | 0;
      phi18 = var3;
      phi19 = this;
      phi20 = (var10) | 0;
      break If_45_0;
     }
    }
    phi19.nativeByteOrder = phi20;
    // line number 300
    var21 = phi11;
    var22 = phi16;
    var21.hb = var22;
    // line number 301
    var23 = phi11;
    var24 = (phi17) | 0;
    var23.offset = var24;
    // line number 302
    return;
  }

  static Ljava$nio$ByteBuffer$$wrap$$B(arg0) {
    // source file is ByteBuffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    // line number 448
    var0 = (0) | 0;
    var1 = (arg0.data.length) | 0;
    java$nio$ByteBuffer.$i;
    var2 = (java$nio$ByteBuffer.Ljava$nio$ByteBuffer$$wrap$$B$I$I(arg0,var0,var1));
    return var2;
  }

  static Ljava$nio$ByteBuffer$$wrap$$B$I$I(arg0,arg1,arg2) {
    // source file is ByteBuffer.java
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var0 = (arg1) | 0;
    TryCatch_6_0: {
     try {
      // line number 419
      java$nio$HeapByteBuffer.$i;
      var2 = new java$nio$HeapByteBuffer();
      var3 = arg0;
      var4 = (arg2) | 0;
      java$nio$HeapByteBuffer.prototype.V$$init$$$B$I$I$Ljava$lang$foreign$MemorySegment$.call(var2,var3,var0,var4,null);
      break TryCatch_6_0;
     } catch (__ex) {
      if (__ex instanceof java$lang$IllegalArgumentException) {
       // line number 420
       // line number 421
       var1 = new java$lang$IndexOutOfBoundsException();
       java$lang$IndexOutOfBoundsException.prototype.V$$init$$$.call(var1);
       throw bytecoder.registerStack(var1, new Error().stack);
      }
      throw __ex;
     }
    }
    return var2;
  }

  Ljava$nio$ByteBuffer$$position$I(arg0) {
    // source file is ByteBuffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var0 = (arg0) | 0;
    // line number 1527
    var1 = (var0) | 0;
    var2 = (java$nio$Buffer.prototype.Ljava$nio$Buffer$$position$I.call(this,var1));
    // line number 1528
    return this;
  }

  V$$init$$I$I$I$I$Ljava$lang$foreign$MemorySegment$(arg0,arg1,arg2,arg3,arg4) {
    // source file is ByteBuffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var var5 = null;
    var0 = (arg0) | 0;
    var1 = (arg2) | 0;
    var2 = arg4;
    // line number 307
    var3 = (var0) | 0;
    var4 = (var1) | 0;
    var5 = null;
    java$nio$ByteBuffer.prototype.V$$init$$I$I$I$I$$B$I$Ljava$lang$foreign$MemorySegment$.call(this,var3,arg1,var4,arg3,var5,0,var2);
    // line number 308
    return;
  }

  Ljava$nio$Buffer$$limit$I(arg0) {
    // source file is ByteBuffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var0 = (arg0) | 0;
    // line number 268
    var1 = (var0) | 0;
    var2 = (java$nio$ByteBuffer.prototype.Ljava$nio$ByteBuffer$$limit$I.call(this,var1));
    return var2;
  }

  Ljava$nio$ByteBuffer$$limit$I(arg0) {
    // source file is ByteBuffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var0 = (arg0) | 0;
    // line number 1540
    var1 = (var0) | 0;
    var2 = (java$nio$Buffer.prototype.Ljava$nio$Buffer$$limit$I.call(this,var1));
    // line number 1541
    return this;
  }

  Ljava$nio$Buffer$$position$I(arg0) {
    // source file is ByteBuffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var0 = (arg0) | 0;
    // line number 268
    var1 = (var0) | 0;
    var2 = (java$nio$ByteBuffer.prototype.Ljava$nio$ByteBuffer$$position$I.call(this,var1));
    return var2;
  }

  I$compareTo$Ljava$lang$Object$(arg0) {
    // source file is ByteBuffer.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var0 = arg0;
    // line number 268
    var1 = var0;
    var2 = var1;
    var3 = ((java$nio$ByteBuffer.prototype.I$compareTo$Ljava$nio$ByteBuffer$.call(this,var2))) | 0;
    return var3;
  }

  I$compareTo$Ljava$nio$ByteBuffer$(arg0) {
    // source file is ByteBuffer.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = 0;
    var var17 = 0;
    var var18 = 0;
    var var19 = 0;
    var var20 = 0;
    var0 = arg0;
    // line number 1790
    var1 = ((this.I$position$$())) | 0;
    // line number 1791
    var2 = ((this.I$limit$$())) | 0;
    var3 = ((var2 - var1)) | 0;
    // line number 1792
    var4 = ((var0.I$position$$())) | 0;
    // line number 1793
    var5 = ((var0.I$limit$$())) | 0;
    var6 = ((var5 - var4)) | 0;
    // line number 1794
    var7 = (var6) | 0;
    java$lang$Math.$i;
    var8 = ((java$lang$Math.I$min$I$I(var3,var7))) | 0;
    // line number 1795
    if (var8 >= 0) {
     // line number 1797
     var9 = (var1) | 0;
     var10 = (var4) | 0;
     java$nio$BufferMismatch.$i;
     var11 = ((java$nio$BufferMismatch.I$mismatch$Ljava$nio$ByteBuffer$$I$Ljava$nio$ByteBuffer$$I$I(this,var9,var0,var10,var8))) | 0;
     // line number 1800
     if (var11 < 0) {
      // line number 1803
      var19 = (var6) | 0;
      var20 = ((var3 - var19)) | 0;
      return var20;
     } else {
      // line number 1801
      var12 = (var1) | 0;
      var13 = ((var12 + var11)) | 0;
      var14 = (this.B$get$I(var13));
      var15 = (var4) | 0;
      var16 = ((var15 + var11)) | 0;
      var17 = (var0.B$get$I(var16));
      java$nio$ByteBuffer.$i;
      var18 = ((java$nio$ByteBuffer.I$compare$B$B(var14,var17))) | 0;
      return var18;
     }
    } else {
     // line number 1796
     return -1;
    }
  }

  Ljava$lang$Object$$base$$() {
    // source file is ByteBuffer.java
    var var0 = null;
    // line number 320
    var0 = (this.hb);
    return var0;
  }

  static I$compare$B$B(arg0,arg1) {
    // source file is ByteBuffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var0 = arg1;
    // line number 1813
    var1 = var0;
    java$lang$Byte.$i;
    var2 = ((java$lang$Byte.I$compare$B$B(arg0,var1))) | 0;
    return var2;
  }

  Ljava$lang$String$$toString$$() {
    // source file is ByteBuffer.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = null;
    var var11 = 0;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    // line number 1680
    var0 = new java$lang$StringBuilder();
    java$lang$StringBuilder.prototype.V$$init$$$.call(var0);
    var1 = ((this).constructor.$rt);
    var2 = (java$lang$Class.prototype.Ljava$lang$String$$getName$$.call(var1));
    var3 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var0,var2));
    var4 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var3,bytecoder.stringconstants[148]));
    // line number 1681
    var5 = ((this.I$position$$())) | 0;
    var6 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var4,var5));
    var7 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var6,bytecoder.stringconstants[149]));
    // line number 1682
    var8 = ((this.I$limit$$())) | 0;
    var9 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var7,var8));
    var10 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var9,bytecoder.stringconstants[150]));
    // line number 1683
    var11 = ((this.I$capacity$$())) | 0;
    var12 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$I.call(var10,var11));
    var13 = (java$lang$StringBuilder.prototype.Ljava$lang$StringBuilder$$append$Ljava$lang$String$.call(var12,bytecoder.stringconstants[116]));
    var14 = (java$lang$StringBuilder.prototype.Ljava$lang$String$$toString$$.call(var13));
    // line number 1680
    return var14;
  }

  Z$equals$Ljava$lang$Object$(arg0) {
    // source file is ByteBuffer.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var phi11 = null;
    var phi12 = null;
    var phi13 = null;
    var phi14 = 0;
    var phi15 = 0;
    var phi16 = 0;
    var phi17 = 0;
    var var18 = 0;
    var var19 = 0;
    var var20 = 0;
    var var21 = 0;
    var phi22 = null;
    var phi23 = null;
    var phi24 = null;
    var phi25 = 0;
    var phi26 = 0;
    var phi27 = 0;
    var phi28 = 0;
    var phi29 = 0;
    var0 = arg0;
    // line number 1750
    var1 = var0;
    if (this != var1) {
     // line number 1752
     var2 = (bytecoder.instanceOf(var0,java$nio$ByteBuffer)) | 0;
     if (var2 != 0) {
      // line number 1754
      var3 = var0;
      // line number 1755
      var4 = ((this.I$position$$())) | 0;
      // line number 1756
      var5 = ((this.I$limit$$())) | 0;
      var6 = ((var5 - var4)) | 0;
      // line number 1757
      var7 = ((var3.I$position$$())) | 0;
      // line number 1758
      var8 = ((var3.I$limit$$())) | 0;
      var9 = ((var8 - var7)) | 0;
      // line number 1759
      If_63_0: {
       if (var6 < 0) {
        phi11 = this;
        phi12 = var0;
        phi13 = var3;
        phi14 = (var4) | 0;
        phi15 = (var6) | 0;
        phi16 = (var7) | 0;
        phi17 = (var9) | 0;
        break If_63_0;
       } else {
        var10 = (var6) | 0;
        if (var10 == var9) {
         // line number 1761
         var18 = (var4) | 0;
         var19 = (var7) | 0;
         java$nio$BufferMismatch.$i;
         var20 = ((java$nio$BufferMismatch.I$mismatch$Ljava$nio$ByteBuffer$$I$Ljava$nio$ByteBuffer$$I$I(this,var18,var3,var19,var6))) | 0;
         If_94_0: {
          if (var20 >= 0) {
           phi22 = this;
           phi23 = var0;
           phi24 = var3;
           phi25 = (var4) | 0;
           phi26 = (var6) | 0;
           phi27 = (var7) | 0;
           phi28 = (var9) | 0;
           phi29 = (0) | 0;
           break If_94_0;
          } else {
           var21 = (1) | 0;
           // Here was a goto statement
           phi22 = this;
           phi23 = var0;
           phi24 = var3;
           phi25 = (var4) | 0;
           phi26 = (var6) | 0;
           phi27 = (var7) | 0;
           phi28 = (var9) | 0;
           phi29 = (var21) | 0;
           break If_94_0;
          }
         }
         return phi29;
        } else {
         phi11 = this;
         phi12 = var0;
         phi13 = var3;
         phi14 = (var4) | 0;
         phi15 = (var6) | 0;
         phi16 = (var7) | 0;
         phi17 = (var9) | 0;
         break If_63_0;
        }
       }
      }
      // line number 1760
      return 0;
     } else {
      // line number 1753
      return 0;
     }
    } else {
     // line number 1751
     return 1;
    }
  }

  I$hashCode$$() {
    // source file is ByteBuffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var phi3 = null;
    var phi4 = 0;
    var phi5 = 0;
    var phi6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = null;
    var var12 = 0;
    var var13 = 0;
    var var14 = 0;
    var var15 = 0;
    // line number 1706
    // line number 1707
    var0 = ((this.I$position$$())) | 0;
    // line number 1708
    var1 = ((this.I$limit$$())) | 0;
    var2 = ((var1 - 1)) | 0;
    phi3 = this;
    phi4 = (1) | 0;
    phi5 = (var0) | 0;
    phi6 = (var2) | 0;
    L1751224242: while(true) {
     var7 = (phi6) | 0;
     var8 = (phi5) | 0;
     if (var7 < var8) {
      // line number 1714
      var15 = (phi4) | 0;
      return var15;
     } else {
      // line number 1712
      var9 = (phi4) | 0;
      var10 = ((31 * var9)) | 0;
      var11 = phi3;
      var12 = (phi6) | 0;
      var13 = (var11.B$get$I(var12));
      var14 = ((var10 + var13)) | 0;
      // line number 1708
      phi6 = ((phi6 + -1)) | 0;
      // Here was a goto statement
      phi4 = (var14) | 0;
      continue L1751224242;
     }
    }
  }

  Ljava$nio$ByteBuffer$$get$$B$I$I(arg0,arg1,arg2) {
    // source file is ByteBuffer.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = null;
    var var9 = 0;
    var var10 = 0;
    var var11 = null;
    var var12 = 0;
    var var13 = 0;
    var var14 = null;
    var0 = arg0;
    var1 = (arg2) | 0;
    // line number 806
    var2 = (var1) | 0;
    var3 = (var0.data.length) | 0;
    var4 = ((java$util$Objects.I$checkFromIndexSize$I$I$I(arg1,var2,var3))) | 0;
    // line number 807
    var5 = ((this.I$position$$())) | 0;
    // line number 808
    var6 = ((this.I$limit$$())) | 0;
    var7 = ((var6 - var5)) | 0;
    if (var1 <= var7) {
     // line number 811
     var9 = (var5) | 0;
     var10 = (var1) | 0;
     var11 = (java$nio$ByteBuffer.prototype.Ljava$nio$ByteBuffer$$getArray$I$$B$I$I.call(this,var9,var0,arg1,var10));
     // line number 813
     var12 = (var5) | 0;
     var13 = ((var12 + var1)) | 0;
     var14 = (java$nio$ByteBuffer.prototype.Ljava$nio$ByteBuffer$$position$I.call(this,var13));
     // line number 814
     return this;
    } else {
     // line number 809
     var8 = new java$nio$BufferUnderflowException();
     java$nio$BufferUnderflowException.prototype.V$$init$$$.call(var8);
     throw bytecoder.registerStack(var8, new Error().stack);
    }
  }

  Ljava$nio$ByteBuffer$$getArray$I$$B$I$I(arg0,arg1,arg2,arg3) {
    // source file is ByteBuffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = 0;
    var phi15 = null;
    var phi16 = 0;
    var phi17 = null;
    var phi18 = 0;
    var phi19 = 0;
    var phi20 = 0;
    var phi21 = 0;
    var phi22 = 0;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = 0;
    var var30 = null;
    var var31 = 0;
    var var32 = 0;
    var var33 = null;
    var var34 = null;
    var var35 = 0;
    var var36 = 0;
    var var37 = 0;
    var var38 = 0;
    var phi39 = null;
    var phi40 = 0;
    var phi41 = null;
    var phi42 = 0;
    var phi43 = 0;
    var phi44 = 0;
    var phi45 = 0;
    var phi46 = 0;
    var var47 = 0;
    var var48 = 0;
    var var49 = null;
    var var50 = 0;
    var var51 = null;
    var var52 = 0;
    var var53 = 0;
    var0 = (arg0) | 0;
    var1 = (arg2) | 0;
    // line number 925
    var2 = (arg3 | 0);
    var3 = (var2 << 0);
    var4 = (bytecoder.cmp(var3,6)) | 0;
    If_23_0: {
     if (var4 <= 0) {
      // line number 950
      var35 = (arg3) | 0;
      var36 = ((var1 + var35)) | 0;
      // line number 951
      var37 = (var1) | 0;
      var38 = (var0) | 0;
      phi39 = this;
      phi40 = (var0) | 0;
      phi41 = arg1;
      phi42 = (var1) | 0;
      phi43 = (arg3) | 0;
      phi44 = (var36) | 0;
      phi45 = (var37) | 0;
      phi46 = (var38) | 0;
      L1965812860: while(true) {
       var47 = (phi45) | 0;
       var48 = (phi44) | 0;
       if (var47 >= var48) {
        phi15 = phi39;
        phi16 = (phi40) | 0;
        phi17 = phi41;
        phi18 = (phi42) | 0;
        phi19 = (phi43) | 0;
        phi20 = phi44;
        phi21 = phi46;
        break If_23_0;
       } else {
        // line number 952
        var49 = phi41;
        var50 = (phi45) | 0;
        var51 = phi39;
        var52 = (phi46) | 0;
        var53 = (var51.B$get$I(var52));
        var49.data[var50] = var53;
        // line number 951
        phi45 = ((phi45 + 1)) | 0;
        phi46 = ((phi46 + 1)) | 0;
        // Here was a goto statement
        continue L1965812860;
       }
      }
     } else {
      // line number 930
      var5 = (this.address);
      var6 = (var0 | 0);
      var7 = (var6 << 0);
      var8 = (var5 + var7);
      // line number 931
      java$nio$ByteBuffer.$i;
      var9 = (java$nio$ByteBuffer.ARRAY_BASE_OFFSET);
      var10 = (var1 | 0);
      var11 = (var10 << 0);
      var12 = (var9 + var11);
      // line number 933
      var13 = (arg3 | 0);
      var14 = (var13 << 0);
      phi15 = this;
      phi16 = (var0) | 0;
      phi17 = arg1;
      phi18 = (var1) | 0;
      phi19 = (arg3) | 0;
      phi20 = var8;
      phi21 = var12;
      phi22 = var14;
      TryCatch_75_0: {
       try {
        // line number 943
        var24 = (java$nio$ByteBuffer.SCOPED_MEMORY_ACCESS);
        var25 = phi15;
        // line number 944
        var26 = (var25.Ljdk$internal$foreign$MemorySessionImpl$$session$$());
        var27 = phi15;
        var28 = (java$nio$ByteBuffer.prototype.Ljava$lang$Object$$base$$.call(var27));
        var29 = phi20;
        var30 = phi17;
        var31 = phi21;
        var32 = phi22;
        // line number 943
        jdk$internal$misc$ScopedMemoryAccess.prototype.V$copyMemory$Ljdk$internal$foreign$MemorySessionImpl$$Ljdk$internal$foreign$MemorySessionImpl$$Ljava$lang$Object$$J$Ljava$lang$Object$$J$J.call(var24,var26,null,var28,var29,var30,var31,var32);
        break TryCatch_75_0;
       } catch (__ex) {
        if (__ex instanceof java$lang$Throwable) {
         TryCatch_76_0: {
          // line number 947
          break TryCatch_76_0;
         }
         var23 = phi15;
         java$lang$ref$Reference.V$reachabilityFence$Ljava$lang$Object$(var23);
         // line number 948
         throw bytecoder.registerStack(__ex, new Error().stack);
        }
        throw __ex;
       }
      }
      // line number 947
      var33 = phi15;
      java$lang$ref$Reference.V$reachabilityFence$Ljava$lang$Object$(var33);
      // line number 948
      // Here was a goto statement
      // line number 949
      // Here was a goto statement
      break If_23_0;
     }
    }
    // line number 955
    var34 = phi15;
    return var34;
  }

  Ljava$nio$ByteBuffer$$flip$$() {
    // source file is ByteBuffer.java
    var var0 = null;
    // line number 1592
    var0 = (java$nio$Buffer.prototype.Ljava$nio$Buffer$$flip$$.call(this));
    // line number 1593
    return this;
  }

  Ljava$nio$ByteBuffer$$clear$$() {
    // source file is ByteBuffer.java
    var var0 = null;
    // line number 1579
    var0 = (java$nio$Buffer.prototype.Ljava$nio$Buffer$$clear$$.call(this));
    // line number 1580
    return this;
  }

  $B$array$$() {
    // source file is ByteBuffer.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    // line number 1481
    var0 = (this.hb);
    if (var0 != null) {
     // line number 1483
     var2 = (this.isReadOnly);
     if (var2 == 0) {
      // line number 1485
      var4 = (this.hb);
      return var4;
     } else {
      // line number 1484
      var3 = new java$nio$ReadOnlyBufferException();
      java$nio$ReadOnlyBufferException.prototype.V$$init$$$.call(var3);
      throw bytecoder.registerStack(var3, new Error().stack);
     }
    } else {
     // line number 1482
     var1 = new java$lang$UnsupportedOperationException();
     java$lang$UnsupportedOperationException.prototype.V$$init$$$.call(var1);
     throw bytecoder.registerStack(var1, new Error().stack);
    }
  }

  I$arrayOffset$$() {
    // source file is ByteBuffer.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = 0;
    // line number 1509
    var0 = (this.hb);
    if (var0 != null) {
     // line number 1511
     var2 = (this.isReadOnly);
     if (var2 == 0) {
      // line number 1513
      var4 = ((this.offset)) | 0;
      return var4;
     } else {
      // line number 1512
      var3 = new java$nio$ReadOnlyBufferException();
      java$nio$ReadOnlyBufferException.prototype.V$$init$$$.call(var3);
      throw bytecoder.registerStack(var3, new Error().stack);
     }
    } else {
     // line number 1510
     var1 = new java$lang$UnsupportedOperationException();
     java$lang$UnsupportedOperationException.prototype.V$$init$$$.call(var1);
     throw bytecoder.registerStack(var1, new Error().stack);
    }
  }

  Ljava$nio$Buffer$$flip$$() {
    // source file is ByteBuffer.java
    var var0 = null;
    // line number 268
    var0 = (java$nio$ByteBuffer.prototype.Ljava$nio$ByteBuffer$$flip$$.call(this));
    return var0;
  }

  Ljava$nio$Buffer$$clear$$() {
    // source file is ByteBuffer.java
    var var0 = null;
    // line number 268
    var0 = (java$nio$ByteBuffer.prototype.Ljava$nio$ByteBuffer$$clear$$.call(this));
    return var0;
  }

  Ljava$nio$ByteBuffer$$put$$B(arg0) {
    // source file is ByteBuffer.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var0 = arg0;
    // line number 1221
    var1 = var0;
    var2 = (var0.data.length) | 0;
    var3 = (this.Ljava$nio$ByteBuffer$$put$$B$I$I(var1,0,var2));
    return var3;
  }

  Ljava$nio$ByteBuffer$$put$$B$I$I(arg0,arg1,arg2) {
    // source file is ByteBuffer.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = null;
    var var11 = 0;
    var var12 = 0;
    var var13 = null;
    var var14 = 0;
    var var15 = 0;
    var var16 = null;
    var0 = arg0;
    var1 = (arg2) | 0;
    // line number 1185
    var2 = (this.Z$isReadOnly$$());
    if (var2 == 0) {
     // line number 1187
     var4 = var0;
     var5 = (var4.data.length) | 0;
     var6 = ((java$util$Objects.I$checkFromIndexSize$I$I$I(arg1,var1,var5))) | 0;
     // line number 1188
     var7 = ((this.I$position$$())) | 0;
     // line number 1189
     var8 = ((this.I$limit$$())) | 0;
     var9 = ((var8 - var7)) | 0;
     if (var1 <= var9) {
      // line number 1192
      var11 = (var7) | 0;
      var12 = (var1) | 0;
      var13 = (java$nio$ByteBuffer.prototype.Ljava$nio$ByteBuffer$$putArray$I$$B$I$I.call(this,var11,var0,arg1,var12));
      // line number 1194
      var14 = (var7) | 0;
      var15 = ((var14 + var1)) | 0;
      var16 = (java$nio$ByteBuffer.prototype.Ljava$nio$ByteBuffer$$position$I.call(this,var15));
      // line number 1195
      return this;
     } else {
      // line number 1190
      var10 = new java$nio$BufferOverflowException();
      java$nio$BufferOverflowException.prototype.V$$init$$$.call(var10);
      throw bytecoder.registerStack(var10, new Error().stack);
     }
    } else {
     // line number 1186
     var3 = new java$nio$ReadOnlyBufferException();
     java$nio$ReadOnlyBufferException.prototype.V$$init$$$.call(var3);
     throw bytecoder.registerStack(var3, new Error().stack);
    }
  }

  Ljava$nio$ByteBuffer$$putArray$I$$B$I$I(arg0,arg1,arg2,arg3) {
    // source file is ByteBuffer.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = 0;
    var phi15 = null;
    var phi16 = 0;
    var phi17 = null;
    var phi18 = 0;
    var phi19 = 0;
    var phi20 = 0;
    var phi21 = 0;
    var phi22 = 0;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = 0;
    var var29 = null;
    var var30 = null;
    var var31 = 0;
    var var32 = 0;
    var var33 = null;
    var var34 = null;
    var var35 = 0;
    var var36 = 0;
    var var37 = 0;
    var var38 = 0;
    var phi39 = null;
    var phi40 = 0;
    var phi41 = null;
    var phi42 = 0;
    var phi43 = 0;
    var phi44 = 0;
    var phi45 = 0;
    var phi46 = 0;
    var var47 = 0;
    var var48 = 0;
    var var49 = null;
    var var50 = 0;
    var var51 = null;
    var var52 = 0;
    var var53 = 0;
    var var54 = null;
    var0 = (arg0) | 0;
    var1 = (arg2) | 0;
    // line number 1315
    var2 = (arg3 | 0);
    var3 = (var2 << 0);
    var4 = (bytecoder.cmp(var3,6)) | 0;
    If_23_0: {
     if (var4 <= 0) {
      // line number 1340
      var35 = (arg3) | 0;
      var36 = ((var1 + var35)) | 0;
      // line number 1341
      var37 = (var1) | 0;
      var38 = (var0) | 0;
      phi39 = this;
      phi40 = (var0) | 0;
      phi41 = arg1;
      phi42 = (var1) | 0;
      phi43 = (arg3) | 0;
      phi44 = (var36) | 0;
      phi45 = (var37) | 0;
      phi46 = (var38) | 0;
      L2117054553: while(true) {
       var47 = (phi45) | 0;
       var48 = (phi44) | 0;
       if (var47 >= var48) {
        phi15 = phi39;
        phi16 = (phi40) | 0;
        phi17 = phi41;
        phi18 = (phi42) | 0;
        phi19 = (phi43) | 0;
        phi20 = phi44;
        phi21 = phi46;
        break If_23_0;
       } else {
        // line number 1342
        var49 = phi39;
        var50 = (phi46) | 0;
        var51 = phi41;
        var52 = (phi45) | 0;
        var53 = (var51.data[var52]);
        var54 = (var49.Ljava$nio$ByteBuffer$$put$I$B(var50,var53));
        // line number 1341
        phi45 = ((phi45 + 1)) | 0;
        phi46 = ((phi46 + 1)) | 0;
        // Here was a goto statement
        continue L2117054553;
       }
      }
     } else {
      // line number 1320
      var5 = (this.address);
      var6 = (var0 | 0);
      var7 = (var6 << 0);
      var8 = (var5 + var7);
      // line number 1321
      java$nio$ByteBuffer.$i;
      var9 = (java$nio$ByteBuffer.ARRAY_BASE_OFFSET);
      var10 = (var1 | 0);
      var11 = (var10 << 0);
      var12 = (var9 + var11);
      // line number 1323
      var13 = (arg3 | 0);
      var14 = (var13 << 0);
      phi15 = this;
      phi16 = (var0) | 0;
      phi17 = arg1;
      phi18 = (var1) | 0;
      phi19 = (arg3) | 0;
      phi20 = var8;
      phi21 = var12;
      phi22 = var14;
      TryCatch_75_0: {
       try {
        // line number 1333
        var24 = (java$nio$ByteBuffer.SCOPED_MEMORY_ACCESS);
        var25 = phi15;
        // line number 1334
        var26 = (var25.Ljdk$internal$foreign$MemorySessionImpl$$session$$());
        var27 = phi17;
        var28 = phi21;
        var29 = phi15;
        // line number 1335
        var30 = (java$nio$ByteBuffer.prototype.Ljava$lang$Object$$base$$.call(var29));
        var31 = phi20;
        var32 = phi22;
        // line number 1333
        jdk$internal$misc$ScopedMemoryAccess.prototype.V$copyMemory$Ljdk$internal$foreign$MemorySessionImpl$$Ljdk$internal$foreign$MemorySessionImpl$$Ljava$lang$Object$$J$Ljava$lang$Object$$J$J.call(var24,null,var26,var27,var28,var30,var31,var32);
        break TryCatch_75_0;
       } catch (__ex) {
        if (__ex instanceof java$lang$Throwable) {
         TryCatch_76_0: {
          // line number 1337
          break TryCatch_76_0;
         }
         var23 = phi15;
         java$lang$ref$Reference.V$reachabilityFence$Ljava$lang$Object$(var23);
         // line number 1338
         throw bytecoder.registerStack(__ex, new Error().stack);
        }
        throw __ex;
       }
      }
      // line number 1337
      var33 = phi15;
      java$lang$ref$Reference.V$reachabilityFence$Ljava$lang$Object$(var33);
      // line number 1338
      // Here was a goto statement
      // line number 1339
      // Here was a goto statement
      break If_23_0;
     }
    }
    // line number 1344
    var34 = phi15;
    return var34;
  }
}


class java$io$PrintStream$1 extends java$lang$Object {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$io$PrintStream$1,[java$lang$Object,jdk$internal$access$JavaIOPrintStreamAccess,java$io$PrintStream$1]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is PrintStream.java
    // line number 1541
    java$lang$Object.prototype.V$$init$$$.call(this);
    return;
  }
}


class java$util$Collections$SynchronizedCollection extends java$lang$Object {
  nativeObject = null;

  c = null;
  mutex = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$Collections$SynchronizedCollection,[java$lang$Object,java$util$Collections$SynchronizedCollection,java$io$Serializable,java$lang$Iterable,java$util$Collection]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Ljava$util$Collection$$Ljava$lang$Object$(arg0,arg1) {
    // source file is Collections.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var0 = arg0;
    // line number 2076
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 2077
    var1 = this;
    var2 = (java$util$Objects.Ljava$lang$Object$$requireNonNull$Ljava$lang$Object$(var0));
    var3 = var2;
    var1.c = var3;
    // line number 2078
    var4 = this;
    var5 = (java$util$Objects.Ljava$lang$Object$$requireNonNull$Ljava$lang$Object$(arg1));
    var4.mutex = var5;
    // line number 2079
    return;
  }

  Ljava$util$Iterator$$iterator$$() {
    // source file is Collections.java
    var var0 = null;
    var var1 = null;
    // line number 2101
    var0 = (this.c);
    var1 = (var0.Ljava$util$Iterator$$iterator$$());
    return var1;
  }

  I$size$$() {
    // source file is Collections.java
    var var0 = null;
    var var1 = null;
    var phi2 = null;
    var phi3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    // line number 2082
    var0 = (this.mutex);
    var1 = var0;
    // Monitor enter on var0
    phi2 = this;
    phi3 = var1;
    TryCatch_12_0: {
     try {
      var5 = phi2;
      var6 = (var5.c);
      var7 = ((var6.I$size$$())) | 0;
      var8 = phi3;
      // Monitor exit on var8
      break TryCatch_12_0;
     } catch (__ex) {
      if (__ex instanceof java$lang$Throwable) {
       TryCatch_13_0: {
        var4 = phi3;
        // Monitor exit on var4
        break TryCatch_13_0;
       }
       throw bytecoder.registerStack(__ex, new Error().stack);
      }
      throw __ex;
     }
    }
    return var7;
  }

  Ljava$lang$String$$toString$$() {
    // source file is Collections.java
    var var0 = null;
    var var1 = null;
    var phi2 = null;
    var phi3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    // line number 2127
    var0 = (this.mutex);
    var1 = var0;
    // Monitor enter on var0
    phi2 = this;
    phi3 = var1;
    TryCatch_12_0: {
     try {
      var5 = phi2;
      var6 = (var5.c);
      var7 = (var6.Ljava$lang$String$$toString$$());
      var8 = phi3;
      // Monitor exit on var8
      break TryCatch_12_0;
     } catch (__ex) {
      if (__ex instanceof java$lang$Throwable) {
       TryCatch_13_0: {
        var4 = phi3;
        // Monitor exit on var4
        break TryCatch_13_0;
       }
       throw bytecoder.registerStack(__ex, new Error().stack);
      }
      throw __ex;
     }
    }
    return var7;
  }

  Z$isEmpty$$() {
    // source file is Collections.java
    var var0 = null;
    var var1 = null;
    var phi2 = null;
    var phi3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    // line number 2085
    var0 = (this.mutex);
    var1 = var0;
    // Monitor enter on var0
    phi2 = this;
    phi3 = var1;
    TryCatch_12_0: {
     try {
      var5 = phi2;
      var6 = (var5.c);
      var7 = (var6.Z$isEmpty$$());
      var8 = phi3;
      // Monitor exit on var8
      break TryCatch_12_0;
     } catch (__ex) {
      if (__ex instanceof java$lang$Throwable) {
       TryCatch_13_0: {
        var4 = phi3;
        // Monitor exit on var4
        break TryCatch_13_0;
       }
       throw bytecoder.registerStack(__ex, new Error().stack);
      }
      throw __ex;
     }
    }
    return var7;
  }
}


class java$lang$Double extends java$lang$Number {
  nativeObject = null;

  static TYPE = null;
  value = 0.0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Double,[java$lang$Object,java$lang$Comparable,java$io$Serializable,java$lang$Number,java$lang$Double]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is Double.java
    var var0 = null;
    // line number 26
    var0 = bytecoder.primitives.double;
    java$lang$Double.$i;
    java$lang$Double.TYPE = var0;
    return;
  }

  static Ljava$lang$Double$$valueOf$D(arg0) {
    // source file is Double.java
    var var0 = null;
    var var1 = .0;
    // line number 85
    java$lang$Double.$i;
    var0 = new java$lang$Double();
    var1 = arg0;
    java$lang$Double.prototype.V$$init$$D.call(var0,var1);
    return var0;
  }

  V$$init$$D(arg0) {
    // source file is Double.java
    var var0 = .0;
    var var1 = null;
    var0 = arg0;
    // line number 31
    java$lang$Number.prototype.V$$init$$$.call(this);
    // line number 32
    var1 = this;
    var1.value = var0;
    // line number 33
    return;
  }

  I$compareTo$Ljava$lang$Object$(arg0) {
    // source file is Double.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var0 = arg0;
    // line number 23
    var1 = var0;
    var2 = var1;
    var3 = ((java$lang$Double.prototype.I$compareTo$Ljava$lang$Double$.call(this,var2))) | 0;
    return var3;
  }

  I$compareTo$Ljava$lang$Double$(arg0) {
    // source file is Double.java
    var var0 = null;
    var var1 = .0;
    var var2 = .0;
    var var3 = 0;
    var0 = arg0;
    // line number 110
    var1 = (this.value);
    var2 = (java$lang$Double.prototype.D$doubleValue$$.call(var0));
    java$lang$Double.$i;
    var3 = ((java$lang$Double.I$compare$D$D(var1,var2))) | 0;
    return var3;
  }

  D$doubleValue$$() {
    // source file is Double.java
    var var0 = .0;
    // line number 52
    var0 = (this.value);
    return var0;
  }

  static I$compare$D$D(arg0,arg1) {
    // source file is Double.java
    var var0 = .0;
    var var1 = .0;
    var var2 = 0;
    var var3 = 0;
    var phi4 = .0;
    var phi5 = .0;
    var phi6 = 0;
    var var7 = 0;
    var var8 = 0;
    var0 = arg1;
    // line number 114
    var1 = var0;
    var2 = (bytecoder.cmp(arg0,var1)) | 0;
    If_12_0: {
     if (var2 >= 0) {
      var7 = (bytecoder.cmp(arg0,var0)) | 0;
      if (var7 != 0) {
       phi4 = arg0;
       phi5 = var0;
       phi6 = (1) | 0;
       break If_12_0;
      } else {
       var8 = (0) | 0;
       // Here was a goto statement
       phi4 = arg0;
       phi5 = var0;
       phi6 = (var8) | 0;
       break If_12_0;
      }
     } else {
      var3 = (-1) | 0;
      // Here was a goto statement
      phi4 = arg0;
      phi5 = var0;
      phi6 = (var3) | 0;
      break If_12_0;
     }
    }
    return phi6;
  }

  I$intValue$$() {
    // source file is Double.java
    var var0 = .0;
    var var1 = 0;
    // line number 37
    var0 = (this.value);
    var1 = ((var0 | 0)) | 0;
    return var1;
  }

  Ljava$lang$String$$toString$$() {
    // source file is Double.java
    var var0 = .0;
    var var1 = null;
    // line number 77
    var0 = (this.value);
    java$lang$Double.$i;
    var1 = (java$lang$Double.Ljava$lang$String$$toString$D(var0));
    return var1;
  }

  static Ljava$lang$String$$toString$D(arg0) {
    return bytecoder.imports['java.lang.Double'].Ljava$lang$String$$toString$D(arg0);
  }

  Z$equals$Ljava$lang$Object$(arg0) {
    // source file is Double.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var phi5 = null;
    var phi6 = null;
    var var7 = null;
    var var8 = .0;
    var var9 = .0;
    var var10 = 0;
    var var11 = 0;
    var phi12 = null;
    var phi13 = null;
    var phi14 = null;
    var phi15 = 0;
    var0 = arg0;
    // line number 57
    var1 = var0;
    if (this != var1) {
     // line number 60
     If_18_0: {
      if (var0 == null) {
       phi5 = this;
       phi6 = var0;
       break If_18_0;
      } else {
       var2 = this;
       var3 = ((var2).constructor.$rt);
       var4 = ((var0).constructor.$rt);
       if (var3 == var4) {
        // line number 63
        var7 = var0;
        // line number 65
        var8 = (this.value);
        var9 = (java$lang$Double.prototype.D$doubleValue$$.call(var7));
        var10 = (bytecoder.cmp(var8,var9)) | 0;
        If_54_0: {
         if (var10 != 0) {
          phi12 = this;
          phi13 = var0;
          phi14 = var7;
          phi15 = (0) | 0;
          break If_54_0;
         } else {
          var11 = (1) | 0;
          // Here was a goto statement
          phi12 = this;
          phi13 = var0;
          phi14 = var7;
          phi15 = (var11) | 0;
          break If_54_0;
         }
        }
        return phi15;
       } else {
        phi5 = this;
        phi6 = var0;
        break If_18_0;
       }
      }
     }
     // line number 61
     return 0;
    } else {
     // line number 58
     return 1;
    }
  }

  I$hashCode$$() {
    // source file is Double.java
    var var0 = .0;
    var var1 = 0;
    // line number 70
    var0 = (this.value);
    var1 = ((var0 | 0)) | 0;
    return var1;
  }

  static D$parseDouble$Ljava$lang$String$(arg0) {
    return bytecoder.imports['java.lang.Double'].D$parseDouble$Ljava$lang$String$(arg0);
  }

  static Z$isNaN$D(arg0) {
    return bytecoder.imports['java.lang.Double'].Z$isNaN$D(arg0);
  }

  static J$doubleToLongBits$D(arg0) {
    // source file is Double.java
    // line number 118
    return 0;
  }

  static Z$isInfinite$D(arg0) {
    return bytecoder.imports['java.lang.Double'].Z$isInfinite$D(arg0);
  }

  static D$longBitsToDouble$J(arg0) {
    // source file is Double.java
    // line number 122
    return 0.0;
  }
}


class java$nio$charset$CoderMalfunctionError extends java$lang$Error {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$nio$charset$CoderMalfunctionError,[java$lang$Object,java$nio$charset$CoderMalfunctionError,java$lang$Throwable,java$lang$Error]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Ljava$lang$Exception$(arg0) {
    // source file is CoderMalfunctionError.java
    var var0 = null;
    var var1 = null;
    var0 = arg0;
    // line number 52
    var1 = var0;
    java$lang$Error.prototype.V$$init$$Ljava$lang$Throwable$.call(this,var1);
    // line number 53
    return;
  }
}


class java$util$AbstractList$ListItr extends java$util$AbstractList$Itr {
  nativeObject = null;

  this$0 = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$AbstractList$ListItr,[java$util$Iterator,java$lang$Object,java$util$AbstractList$ListItr,java$util$AbstractList$Itr,java$util$ListIterator]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Ljava$util$AbstractList$$I(arg0,arg1) {
    // source file is AbstractList.java
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var0 = this;
    var1 = (arg1) | 0;
    // line number 406
    var2 = arg0;
    var0.this$0 = var2;
    var3 = arg0;
    java$util$AbstractList$Itr.prototype.V$$init$$Ljava$util$AbstractList$.call(var0,var3);
    // line number 407
    var4 = (var1) | 0;
    var0.cursor = var4;
    // line number 408
    return;
  }

  I$previousIndex$$() {
    // source file is AbstractList.java
    var var0 = 0;
    var var1 = 0;
    // line number 432
    var0 = ((this.cursor)) | 0;
    var1 = ((var0 - 1)) | 0;
    return var1;
  }
}


class java$util$ImmutableCollections$AbstractImmutableMap extends java$util$AbstractMap {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$ImmutableCollections$AbstractImmutableMap,[java$lang$Object,java$util$ImmutableCollections$AbstractImmutableMap,java$io$Serializable,java$util$AbstractMap,java$util$Map]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    // source file is ImmutableCollections.java
    // line number 1066
    java$util$AbstractMap.prototype.V$$init$$$.call(this);
    return;
  }

  Ljava$lang$Object$$put$Ljava$lang$Object$$Ljava$lang$Object$(arg0,arg1) {
    // source file is ImmutableCollections.java
    var var0 = null;
    var var1 = null;
    var0 = arg0;
    // line number 1072
    java$util$ImmutableCollections.$i;
    var1 = (java$util$ImmutableCollections.Ljava$lang$UnsupportedOperationException$$uoe$$());
    throw bytecoder.registerStack(var1, new Error().stack);
  }

  Ljava$lang$Object$$computeIfAbsent$Ljava$lang$Object$$Ljava$util$function$Function$(arg0,arg1) {
    // source file is ImmutableCollections.java
    var var0 = null;
    var var1 = null;
    var0 = arg0;
    // line number 1069
    java$util$ImmutableCollections.$i;
    var1 = (java$util$ImmutableCollections.Ljava$lang$UnsupportedOperationException$$uoe$$());
    throw bytecoder.registerStack(var1, new Error().stack);
  }
}


class org$luaj$vm2$LuaTable extends org$luaj$vm2$LuaValue {
  nativeObject = null;

  static N = null;
  static NOBUCKETS = null;
  array = null;
  hash = null;
  hashEntries = 0;
  m_metatable = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$LuaTable,[java$lang$Object,org$luaj$vm2$LuaValue,org$luaj$vm2$LuaTable,org$luaj$vm2$Metatable,org$luaj$vm2$Varargs]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      org$luaj$vm2$LuaValue.$i;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    var var0 = null;
    var var1 = null;
    org$luaj$vm2$LuaTable.$i;
    var0 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaString$$valueOf$Ljava$lang$String$(bytecoder.stringconstants[31]));
    org$luaj$vm2$LuaTable.N = var0;
    var1 = bytecoder.newarray((0),null);
    org$luaj$vm2$LuaTable.NOBUCKETS = var1;
    return;
  }

  V$$init$$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    org$luaj$vm2$LuaValue.prototype.V$$init$$$.call(this);
    var0 = this;
    org$luaj$vm2$LuaTable.$i;
    var1 = (org$luaj$vm2$LuaTable.NOVALS);
    var0.array = var1;
    var2 = this;
    var3 = (org$luaj$vm2$LuaTable.NOBUCKETS);
    var2.hash = var3;
    return;
  }

  V$$init$$I$I(arg0,arg1) {
    var var0 = 0;
    var var1 = 0;
    var0 = (arg0) | 0;
    org$luaj$vm2$LuaValue.prototype.V$$init$$$.call(this);
    var1 = (arg1) | 0;
    org$luaj$vm2$LuaTable.prototype.V$presize$I$I.call(this,var0,var1);
    return;
  }

  V$presize$I$I(arg0,arg1) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var phi3 = null;
    var phi4 = 0;
    var phi5 = 0;
    var var6 = null;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = null;
    var phi13 = null;
    var phi14 = null;
    var var15 = null;
    var var16 = 0;
    var var17 = 0;
    var var18 = 0;
    var var19 = 0;
    var var20 = 0;
    var var21 = null;
    var phi22 = null;
    var phi23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var0 = (arg0) | 0;
    If_6_0: {
     if (arg1 <= 0) {
      phi3 = this;
      phi4 = (var0) | 0;
      phi5 = (arg1) | 0;
      break If_6_0;
     } else {
      var1 = (arg1) | 0;
      if (var1 >= 2) {
       phi3 = this;
       phi4 = (var0) | 0;
       phi5 = (arg1) | 0;
       break If_6_0;
      } else {
       var2 = (2) | 0;
       phi3 = this;
       phi4 = (var0) | 0;
       phi5 = (var2) | 0;
       break If_6_0;
      }
     }
    }
    var6 = phi3;
    var7 = (phi4) | 0;
    If_25_0: {
     if (var7 <= 0) {
      org$luaj$vm2$LuaTable.$i;
      var26 = (org$luaj$vm2$LuaTable.NOVALS);
      phi13 = var6;
      phi14 = var26;
      break If_25_0;
     } else {
      var8 = (1) | 0;
      var9 = (phi4) | 0;
      org$luaj$vm2$LuaTable.$i;
      var10 = ((org$luaj$vm2$LuaTable.I$log2$I(var9))) | 0;
      var11 = ((var8 << var10)) | 0;
      var12 = bytecoder.newarray((var11),null);
      // Here was a goto statement
      phi13 = var6;
      phi14 = var12;
      break If_25_0;
     }
    }
    phi13.array = phi14;
    var15 = phi3;
    var16 = (phi5) | 0;
    If_53_0: {
     if (var16 <= 0) {
      org$luaj$vm2$LuaTable.$i;
      var25 = (org$luaj$vm2$LuaTable.NOBUCKETS);
      phi22 = var15;
      phi23 = var25;
      break If_53_0;
     } else {
      var17 = (1) | 0;
      var18 = (phi5) | 0;
      org$luaj$vm2$LuaTable.$i;
      var19 = ((org$luaj$vm2$LuaTable.I$log2$I(var18))) | 0;
      var20 = ((var17 << var19)) | 0;
      var21 = bytecoder.newarray((var20),null);
      // Here was a goto statement
      phi22 = var15;
      phi23 = var21;
      break If_53_0;
     }
    }
    phi22.hash = phi23;
    var24 = phi3;
    var24.hashEntries = 0;
    return;
  }

  static I$log2$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var phi7 = 0;
    var phi8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var phi13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = 0;
    var var17 = 0;
    var phi18 = 0;
    var var19 = 0;
    var var20 = 0;
    var0 = (0) | 0;
    var1 = ((arg0 + -1)) | 0;
    if (var1 >= 0) {
     var3 = ((var1 & -65536)) | 0;
     If_21_0: {
      if (var3 == 0) {
       phi7 = (var1) | 0;
       phi8 = (var0) | 0;
       break If_21_0;
      } else {
       var4 = (16) | 0;
       var5 = (var1) | 0;
       var6 = ((var5 >>> 16)) | 0;
       phi7 = (var6) | 0;
       phi8 = (var4) | 0;
       break If_21_0;
      }
     }
     var9 = (phi7) | 0;
     var10 = ((var9 & 65280)) | 0;
     If_42_0: {
      if (var10 == 0) {
       phi13 = (phi7) | 0;
       break If_42_0;
      } else {
       phi8 = ((phi8 + 8)) | 0;
       var11 = (phi7) | 0;
       var12 = ((var11 >>> 8)) | 0;
       phi13 = (var12) | 0;
       break If_42_0;
      }
     }
     var14 = (phi13) | 0;
     var15 = ((var14 & 240)) | 0;
     If_62_0: {
      if (var15 == 0) {
       phi18 = (phi13) | 0;
       break If_62_0;
      } else {
       phi8 = ((phi8 + 4)) | 0;
       var16 = (phi13) | 0;
       var17 = ((var16 >>> 4)) | 0;
       phi18 = (var17) | 0;
       break If_62_0;
      }
     }
     var19 = (phi18) | 0;
     TableSwitch_78_0: {
      if ((var19) >= 0 && (var19) <= 15) switch ((var19) - 0) {
       case 0: {
        return 0;
       }
       case 1: {
        phi8 = ((phi8 + 1)) | 0;
        // Here was a goto statement
        break TableSwitch_78_0;
       }
       case 2: {
        phi8 = ((phi8 + 2)) | 0;
        // Here was a goto statement
        break TableSwitch_78_0;
       }
       case 3: {
        phi8 = ((phi8 + 2)) | 0;
        // Here was a goto statement
        break TableSwitch_78_0;
       }
       case 4: {
        phi8 = ((phi8 + 3)) | 0;
        // Here was a goto statement
        break TableSwitch_78_0;
       }
       case 5: {
        phi8 = ((phi8 + 3)) | 0;
        // Here was a goto statement
        break TableSwitch_78_0;
       }
       case 6: {
        phi8 = ((phi8 + 3)) | 0;
        // Here was a goto statement
        break TableSwitch_78_0;
       }
       case 7: {
        phi8 = ((phi8 + 3)) | 0;
        // Here was a goto statement
        break TableSwitch_78_0;
       }
       case 8: {
        phi8 = ((phi8 + 4)) | 0;
        // Here was a goto statement
        break TableSwitch_78_0;
       }
       case 9: {
        phi8 = ((phi8 + 4)) | 0;
        // Here was a goto statement
        break TableSwitch_78_0;
       }
       case 10: {
        phi8 = ((phi8 + 4)) | 0;
        // Here was a goto statement
        break TableSwitch_78_0;
       }
       case 11: {
        phi8 = ((phi8 + 4)) | 0;
        // Here was a goto statement
        break TableSwitch_78_0;
       }
       case 12: {
        phi8 = ((phi8 + 4)) | 0;
        // Here was a goto statement
        break TableSwitch_78_0;
       }
       case 13: {
        phi8 = ((phi8 + 4)) | 0;
        // Here was a goto statement
        break TableSwitch_78_0;
       }
       case 14: {
        phi8 = ((phi8 + 4)) | 0;
        // Here was a goto statement
        break TableSwitch_78_0;
       }
       case 15: {
        phi8 = ((phi8 + 4)) | 0;
        break TableSwitch_78_0;
       }
      } else {
       break TableSwitch_78_0;
      }
     }
     var20 = (phi8) | 0;
     return var20;
    } else {
     var2 = (-2147483648) | 0;
     return var2;
    }
  }

  Lorg$luaj$vm2$LuaValue$$getmetatable$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var phi4 = null;
    var phi5 = null;
    var0 = (this.m_metatable);
    If_5_0: {
     if (var0 == null) {
      phi4 = this;
      phi5 = null;
      break If_5_0;
     } else {
      var1 = this;
      var2 = (var1.m_metatable);
      var3 = (var2.Lorg$luaj$vm2$LuaValue$$toLuaValue$$());
      // Here was a goto statement
      phi4 = this;
      phi5 = var3;
      break If_5_0;
     }
    }
    return phi5;
  }

  Lorg$luaj$vm2$LuaValue$$rawget$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = 0;
    var var13 = 0;
    var var14 = null;
    var phi15 = null;
    var phi16 = null;
    var phi17 = 0;
    var phi18 = null;
    var var19 = null;
    var var20 = null;
    var phi21 = null;
    var phi22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = 0;
    var var27 = 0;
    var var28 = null;
    var phi29 = null;
    var phi30 = null;
    var phi31 = 0;
    var var32 = null;
    var var33 = null;
    var var34 = null;
    var0 = arg0;
    var1 = (var0.Z$isinttype$$());
    If_8_0: {
     if (var1 == 0) {
      phi29 = this;
      phi30 = var0;
      break If_8_0;
     } else {
      var2 = var0;
      var3 = ((var2.I$toint$$())) | 0;
      var4 = (var3) | 0;
      if (var4 <= 0) {
       phi29 = this;
       phi30 = var0;
       phi31 = (var3) | 0;
       break If_8_0;
      } else {
       var5 = (var3) | 0;
       var6 = (this.array);
       var7 = (var6.data.length) | 0;
       if (var5 > var7) {
        phi29 = this;
        phi30 = var0;
        phi31 = (var3) | 0;
        break If_8_0;
       } else {
        var8 = this;
        var9 = (var8.m_metatable);
        If_36_0: {
         if (var9 != null) {
          var24 = (this.m_metatable);
          var25 = (this.array);
          var26 = (1) | 0;
          var27 = ((var3 - var26)) | 0;
          var28 = (var24.Lorg$luaj$vm2$LuaValue$$arrayget$$Lorg$luaj$vm2$LuaValue$$I(var25,var27));
          phi15 = this;
          phi16 = var0;
          phi17 = (var3) | 0;
          phi18 = var28;
          break If_36_0;
         } else {
          var10 = this;
          var11 = (var10.array);
          var12 = (1) | 0;
          var13 = ((var3 - var12)) | 0;
          var14 = (var11.data[var13]);
          // Here was a goto statement
          phi15 = this;
          phi16 = var0;
          phi17 = (var3) | 0;
          phi18 = var14;
          break If_36_0;
         }
        }
        var19 = phi18;
        If_60_0: {
         if (var19 == null) {
          org$luaj$vm2$LuaTable.$i;
          var23 = (org$luaj$vm2$LuaTable.NIL);
          phi21 = var19;
          phi22 = var23;
          break If_60_0;
         } else {
          var20 = var19;
          // Here was a goto statement
          phi21 = var19;
          phi22 = var20;
          break If_60_0;
         }
        }
        return phi22;
       }
      }
     }
    }
    var32 = phi29;
    var33 = phi30;
    var34 = (org$luaj$vm2$LuaTable.prototype.Lorg$luaj$vm2$LuaValue$$hashget$Lorg$luaj$vm2$LuaValue$.call(var32,var33));
    return var34;
  }

  Lorg$luaj$vm2$LuaValue$$hashget$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var phi6 = null;
    var phi7 = null;
    var phi8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var0 = arg0;
    var1 = ((this.hashEntries)) | 0;
    If_8_0: {
     if (var1 <= 0) {
      phi6 = this;
      phi7 = var0;
      break If_8_0;
     } else {
      var2 = this;
      var3 = (var2.hash);
      var4 = ((org$luaj$vm2$LuaTable.prototype.I$hashSlot$Lorg$luaj$vm2$LuaValue$.call(this,var0))) | 0;
      var5 = (var3.data[var4]);
      phi6 = this;
      phi7 = var0;
      phi8 = var5;
      L1519708858: while(true) {
       var9 = phi8;
       if (var9 == null) {
        break If_8_0;
       } else {
        var10 = phi8;
        var11 = phi7;
        var12 = (var10.Lorg$luaj$vm2$LuaTable$StrongSlot$$find$Lorg$luaj$vm2$LuaValue$(var11));
        var13 = var12;
        if (var12 == null) {
         var16 = phi8;
         var17 = (var16.Lorg$luaj$vm2$LuaTable$Slot$$rest$$());
         // Here was a goto statement
         phi8 = var17;
         continue L1519708858;
        } else {
         var14 = var13;
         var15 = (var14.Lorg$luaj$vm2$LuaValue$$value$$());
         return var15;
        }
       }
      }
     }
    }
    org$luaj$vm2$LuaTable.$i;
    var18 = (org$luaj$vm2$LuaTable.NIL);
    return var18;
  }

  I$hashSlot$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var0 = arg0;
    var1 = this;
    var2 = (var1.hash);
    var3 = (var2.data.length) | 0;
    var4 = ((var3 - 1)) | 0;
    org$luaj$vm2$LuaTable.$i;
    var5 = ((org$luaj$vm2$LuaTable.I$hashSlot$Lorg$luaj$vm2$LuaValue$$I(var0,var4))) | 0;
    return var5;
  }

  static I$hashSlot$Lorg$luaj$vm2$LuaValue$$I(arg0,arg1) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var0 = (arg1) | 0;
    var1 = ((arg0.I$type$$())) | 0;
    if ((var1) >= 2 && (var1) <= 8) switch ((var1) - 2) {
     case 0: {
      var2 = ((arg0.I$hashCode$$())) | 0;
      org$luaj$vm2$LuaTable.$i;
      var3 = ((org$luaj$vm2$LuaTable.I$hashmod$I$I(var2,var0))) | 0;
      return var3;
     }
     case 1: {
      var2 = ((arg0.I$hashCode$$())) | 0;
      org$luaj$vm2$LuaTable.$i;
      var3 = ((org$luaj$vm2$LuaTable.I$hashmod$I$I(var2,var0))) | 0;
      return var3;
     }
     case 2: {
      var4 = ((arg0.I$hashCode$$())) | 0;
      org$luaj$vm2$LuaTable.$i;
      var5 = ((org$luaj$vm2$LuaTable.I$hashpow2$I$I(var4,var0))) | 0;
      return var5;
     }
     case 3: {
      var2 = ((arg0.I$hashCode$$())) | 0;
      org$luaj$vm2$LuaTable.$i;
      var3 = ((org$luaj$vm2$LuaTable.I$hashmod$I$I(var2,var0))) | 0;
      return var3;
     }
     case 4: {
      var4 = ((arg0.I$hashCode$$())) | 0;
      org$luaj$vm2$LuaTable.$i;
      var5 = ((org$luaj$vm2$LuaTable.I$hashpow2$I$I(var4,var0))) | 0;
      return var5;
     }
     case 5: {
      var2 = ((arg0.I$hashCode$$())) | 0;
      org$luaj$vm2$LuaTable.$i;
      var3 = ((org$luaj$vm2$LuaTable.I$hashmod$I$I(var2,var0))) | 0;
      return var3;
     }
     case 6: {
      var2 = ((arg0.I$hashCode$$())) | 0;
      org$luaj$vm2$LuaTable.$i;
      var3 = ((org$luaj$vm2$LuaTable.I$hashmod$I$I(var2,var0))) | 0;
      return var3;
     }
    } else {
     var4 = ((arg0.I$hashCode$$())) | 0;
     org$luaj$vm2$LuaTable.$i;
     var5 = ((org$luaj$vm2$LuaTable.I$hashpow2$I$I(var4,var0))) | 0;
     return var5;
    }
  }

  static I$hashmod$I$I(arg0,arg1) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var0 = (arg1) | 0;
    var1 = (2147483647) | 0;
    var2 = ((arg0 & var1)) | 0;
    var3 = ((var2 % var0)) | 0;
    return var3;
  }

  static I$hashpow2$I$I(arg0,arg1) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var0 = (arg1) | 0;
    var1 = (var0) | 0;
    var2 = ((arg0 & var1)) | 0;
    return var2;
  }

  Ljava$lang$String$$typename$$() {
    var var0 = null;
    var0 = bytecoder.stringconstants[7];
    return var0;
  }

  Lorg$luaj$vm2$LuaValue$$toLuaValue$$() {
    return this;
  }

  Lorg$luaj$vm2$LuaValue$$arrayget$$Lorg$luaj$vm2$LuaValue$$I(arg0,arg1) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var0 = arg0;
    var1 = (arg1) | 0;
    var2 = (var0.data[var1]);
    return var2;
  }

  I$type$$() {
    var var0 = 0;
    var0 = (5) | 0;
    return var0;
  }

  V$set$I$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var phi8 = null;
    var phi9 = 0;
    var phi10 = null;
    var var11 = null;
    var var12 = 0;
    var var13 = null;
    var0 = (arg0) | 0;
    var1 = (this.m_metatable);
    If_9_0: {
     If_9_1: {
      if (var1 == null) {
       phi8 = this;
       phi9 = (var0) | 0;
       phi10 = arg1;
       break If_9_1;
      } else {
       var2 = this;
       var3 = (org$luaj$vm2$LuaTable.prototype.Lorg$luaj$vm2$LuaValue$$rawget$I.call(var2,var0));
       var4 = (var3.Z$isnil$$());
       if (var4 == 0) {
        phi8 = this;
        phi9 = (var0) | 0;
        phi10 = arg1;
        break If_9_1;
       } else {
        var5 = this;
        org$luaj$vm2$LuaInteger.$i;
        var6 = (org$luaj$vm2$LuaInteger.Lorg$luaj$vm2$LuaInteger$$valueOf$I(var0));
        org$luaj$vm2$LuaTable.$i;
        var7 = (org$luaj$vm2$LuaValue.Z$settable$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(var5,var6,arg1));
        if (var7 != 0) {
         phi8 = this;
         phi9 = (var0) | 0;
         phi10 = arg1;
         break If_9_0;
        } else {
         phi8 = this;
         phi9 = (var0) | 0;
         phi10 = arg1;
         break If_9_1;
        }
       }
      }
     }
     var11 = phi8;
     var12 = (phi9) | 0;
     var13 = phi10;
     org$luaj$vm2$LuaTable.prototype.V$rawset$I$Lorg$luaj$vm2$LuaValue$.call(var11,var12,var13);
     break If_9_0;
    }
    return;
  }

  Lorg$luaj$vm2$LuaValue$$rawget$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = 0;
    var var10 = null;
    var phi11 = null;
    var phi12 = 0;
    var phi13 = null;
    var var14 = null;
    var var15 = null;
    var phi16 = null;
    var phi17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = 0;
    var var22 = 0;
    var var23 = null;
    var phi24 = null;
    var phi25 = 0;
    var var26 = null;
    var var27 = 0;
    var var28 = null;
    var var29 = null;
    var0 = (arg0) | 0;
    If_5_0: {
     if (var0 <= 0) {
      phi24 = this;
      phi25 = (var0) | 0;
      break If_5_0;
     } else {
      var1 = (var0) | 0;
      var2 = (this.array);
      var3 = (var2.data.length) | 0;
      if (var1 > var3) {
       phi24 = this;
       phi25 = (var0) | 0;
       break If_5_0;
      } else {
       var4 = this;
       var5 = (var4.m_metatable);
       If_23_0: {
        if (var5 != null) {
         var19 = (this.m_metatable);
         var20 = (this.array);
         var21 = (1) | 0;
         var22 = ((var0 - var21)) | 0;
         var23 = (var19.Lorg$luaj$vm2$LuaValue$$arrayget$$Lorg$luaj$vm2$LuaValue$$I(var20,var22));
         phi11 = this;
         phi12 = (var0) | 0;
         phi13 = var23;
         break If_23_0;
        } else {
         var6 = this;
         var7 = (var6.array);
         var8 = (1) | 0;
         var9 = ((var0 - var8)) | 0;
         var10 = (var7.data[var9]);
         // Here was a goto statement
         phi11 = this;
         phi12 = (var0) | 0;
         phi13 = var10;
         break If_23_0;
        }
       }
       var14 = phi13;
       If_46_0: {
        if (var14 == null) {
         org$luaj$vm2$LuaTable.$i;
         var18 = (org$luaj$vm2$LuaTable.NIL);
         phi16 = var14;
         phi17 = var18;
         break If_46_0;
        } else {
         var15 = var14;
         // Here was a goto statement
         phi16 = var14;
         phi17 = var15;
         break If_46_0;
        }
       }
       return phi17;
      }
     }
    }
    var26 = phi24;
    var27 = (phi25) | 0;
    org$luaj$vm2$LuaInteger.$i;
    var28 = (org$luaj$vm2$LuaInteger.Lorg$luaj$vm2$LuaInteger$$valueOf$I(var27));
    var29 = (org$luaj$vm2$LuaTable.prototype.Lorg$luaj$vm2$LuaValue$$hashget$Lorg$luaj$vm2$LuaValue$.call(var26,var28));
    return var29;
  }

  V$rawset$I$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var phi5 = null;
    var phi6 = 0;
    var phi7 = null;
    var0 = (arg0) | 0;
    var1 = (var0) | 0;
    var2 = (org$luaj$vm2$LuaTable.prototype.Z$arrayset$I$Lorg$luaj$vm2$LuaValue$.call(this,var1,arg1));
    If_11_0: {
     if (var2 != 0) {
      phi5 = this;
      phi6 = (var0) | 0;
      phi7 = arg1;
      break If_11_0;
     } else {
      var3 = this;
      org$luaj$vm2$LuaInteger.$i;
      var4 = (org$luaj$vm2$LuaInteger.Lorg$luaj$vm2$LuaInteger$$valueOf$I(var0));
      org$luaj$vm2$LuaTable.prototype.V$hashset$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$.call(var3,var4,arg1);
      phi5 = this;
      phi6 = (var0) | 0;
      phi7 = arg1;
      break If_11_0;
     }
    }
    return;
  }

  Z$arrayset$I$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = null;
    var phi10 = null;
    var phi11 = 0;
    var phi12 = null;
    var phi13 = null;
    var phi14 = 0;
    var phi15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var phi20 = null;
    var phi21 = 0;
    var phi22 = null;
    var0 = (arg0) | 0;
    If_6_0: {
     if (var0 <= 0) {
      phi20 = this;
      phi21 = (var0) | 0;
      phi22 = arg1;
      break If_6_0;
     } else {
      var1 = (var0) | 0;
      var2 = (this.array);
      var3 = (var2.data.length) | 0;
      if (var1 > var3) {
       phi20 = this;
       phi21 = (var0) | 0;
       phi22 = arg1;
       break If_6_0;
      } else {
       var4 = this;
       var5 = (var4.array);
       var6 = (1) | 0;
       var7 = ((var0 - var6)) | 0;
       var8 = (arg1.Z$isnil$$());
       If_33_0: {
        if (var8 == 0) {
         var16 = (this.m_metatable);
         if (var16 == null) {
          phi10 = this;
          phi11 = (var0) | 0;
          phi12 = arg1;
          phi13 = var5;
          phi14 = (var7) | 0;
          phi15 = arg1;
          break If_33_0;
         } else {
          var17 = this;
          var18 = (var17.m_metatable);
          var19 = (var18.Lorg$luaj$vm2$LuaValue$$wrap$Lorg$luaj$vm2$LuaValue$(arg1));
          // Here was a goto statement
          phi10 = this;
          phi11 = (var0) | 0;
          phi12 = arg1;
          phi13 = var5;
          phi14 = (var7) | 0;
          phi15 = var19;
          break If_33_0;
         }
        } else {
         var9 = null;
         // Here was a goto statement
         phi10 = this;
         phi11 = (var0) | 0;
         phi12 = arg1;
         phi13 = var5;
         phi14 = (var7) | 0;
         phi15 = var9;
         break If_33_0;
        }
       }
       phi13.data[phi14] = phi15;
       return 1;
      }
     }
    }
    return 0;
  }

  V$hashset$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var phi3 = null;
    var phi4 = null;
    var phi5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = null;
    var phi13 = null;
    var phi14 = null;
    var phi15 = null;
    var phi16 = 0;
    var phi17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = 0;
    var var26 = null;
    var var27 = null;
    var var28 = 0;
    var var29 = null;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = null;
    var var35 = 0;
    var var36 = null;
    var var37 = 0;
    var var38 = null;
    var var39 = 0;
    var var40 = null;
    var var41 = null;
    var var42 = 0;
    var var43 = null;
    var var44 = null;
    var var45 = 0;
    var var46 = null;
    var var47 = 0;
    var var48 = null;
    var var49 = null;
    var var50 = 0;
    var phi51 = 0;
    var var52 = null;
    var var53 = null;
    var var54 = null;
    var var55 = null;
    var var56 = null;
    var var57 = null;
    var var58 = null;
    var phi59 = null;
    var var60 = null;
    var var61 = null;
    var var62 = null;
    var var63 = 0;
    var var64 = null;
    var var65 = null;
    var var66 = 0;
    var var67 = null;
    var var68 = null;
    var var69 = null;
    var var70 = 0;
    var var71 = null;
    var var72 = null;
    var phi73 = null;
    var phi74 = null;
    var phi75 = 0;
    var phi76 = null;
    var var77 = null;
    var var78 = 0;
    var var79 = 0;
    var var80 = null;
    var var81 = null;
    var var82 = null;
    var var83 = null;
    var0 = arg0;
    var1 = (arg1.Z$isnil$$());
    If_9_0: {
     if (var1 == 0) {
      var6 = this;
      var7 = (var6.hash);
      var8 = (var7.data.length) | 0;
      If_31_0: {
       if (var8 <= 0) {
        phi13 = this;
        phi14 = var0;
        phi15 = arg1;
        phi16 = (0) | 0;
        break If_31_0;
       } else {
        var9 = this;
        var10 = ((org$luaj$vm2$LuaTable.prototype.I$hashSlot$Lorg$luaj$vm2$LuaValue$.call(var9,var0))) | 0;
        var11 = (this.hash);
        var12 = (var11.data[var10]);
        phi13 = this;
        phi14 = var0;
        phi15 = arg1;
        phi16 = (var10) | 0;
        phi17 = var12;
        L198082337: while(true) {
         var18 = phi17;
         if (var18 == null) {
          break If_31_0;
         } else {
          var19 = phi17;
          var20 = phi14;
          var21 = (var19.Lorg$luaj$vm2$LuaTable$StrongSlot$$find$Lorg$luaj$vm2$LuaValue$(var20));
          var22 = var21;
          if (var21 == null) {
           var32 = phi17;
           var33 = (var32.Lorg$luaj$vm2$LuaTable$Slot$$rest$$());
           // Here was a goto statement
           phi17 = var33;
           continue L198082337;
          } else {
           var23 = phi13;
           var24 = (var23.hash);
           var25 = (phi16) | 0;
           var26 = phi13;
           var27 = (var26.hash);
           var28 = (phi16) | 0;
           var29 = (var27.data[var28]);
           var30 = phi15;
           var31 = (var29.Lorg$luaj$vm2$LuaTable$Slot$$set$Lorg$luaj$vm2$LuaTable$StrongSlot$$Lorg$luaj$vm2$LuaValue$(var22,var30));
           var24.data[var25] = var31;
           return;
          }
         }
        }
       }
      }
      var34 = phi13;
      var35 = (org$luaj$vm2$LuaTable.prototype.Z$checkLoadFactor$$.call(var34));
      If_103_0: {
       if (var35 == 0) {
        phi51 = (phi16) | 0;
        break If_103_0;
       } else {
        var36 = phi14;
        var37 = (var36.Z$isinttype$$());
        If_111_0: {
         If_111_1: {
          if (var37 == 0) {
           break If_111_1;
          } else {
           var38 = phi14;
           var39 = ((var38.I$toint$$())) | 0;
           if (var39 <= 0) {
            break If_111_1;
           } else {
            var40 = phi13;
            var41 = phi14;
            var42 = ((var41.I$toint$$())) | 0;
            org$luaj$vm2$LuaTable.prototype.V$rehash$I.call(var40,var42);
            var43 = phi13;
            var44 = phi14;
            var45 = ((var44.I$toint$$())) | 0;
            var46 = phi15;
            var47 = (org$luaj$vm2$LuaTable.prototype.Z$arrayset$I$Lorg$luaj$vm2$LuaValue$.call(var43,var45,var46));
            if (var47 == 0) {
             break If_111_0;
            } else {
             return;
            }
           }
          }
         }
         var83 = phi13;
         org$luaj$vm2$LuaTable.prototype.V$rehash$I.call(var83,-1);
         break If_111_0;
        }
        var48 = phi13;
        var49 = phi14;
        var50 = ((org$luaj$vm2$LuaTable.prototype.I$hashSlot$Lorg$luaj$vm2$LuaValue$.call(var48,var49))) | 0;
        phi51 = (var50) | 0;
        break If_103_0;
       }
      }
      var52 = phi13;
      var53 = (var52.m_metatable);
      If_161_0: {
       if (var53 == null) {
        var80 = phi14;
        var81 = phi15;
        org$luaj$vm2$LuaTable.$i;
        var82 = (org$luaj$vm2$LuaTable.Lorg$luaj$vm2$LuaTable$Entry$$defaultEntry$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(var80,var81));
        phi59 = var82;
        break If_161_0;
       } else {
        var54 = phi13;
        var55 = (var54.m_metatable);
        var56 = phi14;
        var57 = phi15;
        var58 = (var55.Lorg$luaj$vm2$LuaTable$Slot$$entry$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(var56,var57));
        // Here was a goto statement
        phi59 = var58;
        break If_161_0;
       }
      }
      var60 = phi59;
      var61 = phi13;
      var62 = (var61.hash);
      var63 = (phi51) | 0;
      var64 = phi13;
      var65 = (var64.hash);
      var66 = (phi51) | 0;
      var67 = (var65.data[var66]);
      If_197_0: {
       if (var67 == null) {
        phi73 = var60;
        phi74 = var62;
        phi75 = (var63) | 0;
        phi76 = var60;
        break If_197_0;
       } else {
        var68 = phi13;
        var69 = (var68.hash);
        var70 = (phi51) | 0;
        var71 = (var69.data[var70]);
        var72 = (var71.Lorg$luaj$vm2$LuaTable$Slot$$add$Lorg$luaj$vm2$LuaTable$Slot$(var60));
        // Here was a goto statement
        phi73 = var60;
        phi74 = var62;
        phi75 = (var63) | 0;
        phi76 = var72;
        break If_197_0;
       }
      }
      phi74.data[phi75] = phi76;
      var77 = phi13;
      var78 = ((var77.hashEntries)) | 0;
      var79 = ((var78 + 1)) | 0;
      var77.hashEntries = var79;
      phi3 = phi13;
      phi4 = phi14;
      phi5 = phi15;
      break If_9_0;
     } else {
      var2 = this;
      org$luaj$vm2$LuaTable.prototype.V$hashRemove$Lorg$luaj$vm2$LuaValue$.call(var2,var0);
      // Here was a goto statement
      phi3 = this;
      phi4 = var0;
      phi5 = arg1;
      break If_9_0;
     }
    }
    return;
  }

  V$hashRemove$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var phi7 = null;
    var phi8 = null;
    var phi9 = 0;
    var phi10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = 0;
    var var19 = null;
    var var20 = null;
    var var21 = 0;
    var var22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = 0;
    var var26 = 0;
    var var27 = null;
    var var28 = null;
    var0 = arg0;
    var1 = (this.hash);
    var2 = (var1.data.length) | 0;
    If_11_0: {
     if (var2 <= 0) {
      phi7 = this;
      phi8 = var0;
      break If_11_0;
     } else {
      var3 = this;
      var4 = ((org$luaj$vm2$LuaTable.prototype.I$hashSlot$Lorg$luaj$vm2$LuaValue$.call(var3,var0))) | 0;
      var5 = (this.hash);
      var6 = (var5.data[var4]);
      phi7 = this;
      phi8 = var0;
      phi9 = (var4) | 0;
      phi10 = var6;
      L1338166319: while(true) {
       var11 = phi10;
       if (var11 == null) {
        break If_11_0;
       } else {
        var12 = phi10;
        var13 = phi8;
        var14 = (var12.Lorg$luaj$vm2$LuaTable$StrongSlot$$find$Lorg$luaj$vm2$LuaValue$(var13));
        var15 = var14;
        if (var14 == null) {
         var27 = phi10;
         var28 = (var27.Lorg$luaj$vm2$LuaTable$Slot$$rest$$());
         // Here was a goto statement
         phi10 = var28;
         continue L1338166319;
        } else {
         var16 = phi7;
         var17 = (var16.hash);
         var18 = (phi9) | 0;
         var19 = phi7;
         var20 = (var19.hash);
         var21 = (phi9) | 0;
         var22 = (var20.data[var21]);
         var23 = (var22.Lorg$luaj$vm2$LuaTable$Slot$$remove$Lorg$luaj$vm2$LuaTable$StrongSlot$(var15));
         var17.data[var18] = var23;
         var24 = phi7;
         var25 = ((var24.hashEntries)) | 0;
         var26 = ((var25 - 1)) | 0;
         var24.hashEntries = var26;
         return;
        }
       }
      }
     }
    }
    return;
  }

  Z$checkLoadFactor$$() {
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var phi4 = null;
    var phi5 = 0;
    var0 = ((this.hashEntries)) | 0;
    var1 = (this.hash);
    var2 = (var1.data.length) | 0;
    If_11_0: {
     if (var0 < var2) {
      phi4 = this;
      phi5 = (0) | 0;
      break If_11_0;
     } else {
      var3 = (1) | 0;
      // Here was a goto statement
      phi4 = this;
      phi5 = (var3) | 0;
      break If_11_0;
     }
    }
    return phi5;
  }

  V$rehash$I(arg0) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var phi8 = null;
    var phi9 = 0;
    var var10 = null;
    var var11 = null;
    var var12 = 0;
    var var13 = null;
    var var14 = null;
    var var15 = 0;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = 0;
    var var20 = 0;
    var var21 = 0;
    var var22 = 0;
    var var23 = 0;
    var var24 = null;
    var var25 = 0;
    var var26 = 0;
    var phi27 = null;
    var phi28 = 0;
    var var29 = null;
    var var30 = 0;
    var var31 = 0;
    var var32 = 0;
    var phi33 = 0;
    var phi34 = 0;
    var phi35 = 0;
    var var36 = 0;
    var var37 = 0;
    var var38 = null;
    var var39 = 0;
    var var40 = 0;
    var var41 = 0;
    var var42 = 0;
    var var43 = 0;
    var var44 = 0;
    var var45 = 0;
    var phi46 = 0;
    var var47 = null;
    var var48 = null;
    var var49 = null;
    var var50 = null;
    var var51 = 0;
    var var52 = 0;
    var var53 = 0;
    var var54 = 0;
    var var55 = 0;
    var phi56 = null;
    var phi57 = null;
    var phi58 = 0;
    var var59 = 0;
    var var60 = null;
    var var61 = 0;
    var var62 = 0;
    var var63 = null;
    var var64 = 0;
    var var65 = null;
    var var66 = 0;
    var var67 = null;
    var var68 = 0;
    var var69 = 0;
    var var70 = 0;
    var var71 = 0;
    var var72 = 0;
    var var73 = 0;
    var phi74 = null;
    var phi75 = 0;
    var phi76 = 0;
    var var77 = 0;
    var var78 = 0;
    var var79 = 0;
    var var80 = null;
    var var81 = 0;
    var var82 = 0;
    var var83 = 0;
    var var84 = null;
    var var85 = null;
    var var86 = null;
    var var87 = 0;
    var var88 = 0;
    var var89 = 0;
    var var90 = null;
    var var91 = 0;
    var var92 = 0;
    var var93 = 0;
    var var94 = 0;
    var var95 = 0;
    var var96 = 0;
    var phi97 = 0;
    var phi98 = 0;
    var var99 = 0;
    var var100 = null;
    var var101 = 0;
    var var102 = 0;
    var var103 = 0;
    var var104 = 0;
    var phi105 = 0;
    var phi106 = 0;
    var phi107 = 0;
    var var108 = 0;
    var var109 = 0;
    var var110 = 0;
    var var111 = null;
    var phi112 = null;
    var phi113 = 0;
    var phi114 = 0;
    var var115 = 0;
    var phi116 = 0;
    var var117 = 0;
    var var118 = 0;
    var var119 = null;
    var var120 = 0;
    var var121 = null;
    var phi122 = null;
    var var123 = null;
    var var124 = null;
    var var125 = 0;
    var var126 = 0;
    var var127 = 0;
    var var128 = null;
    var var129 = null;
    var var130 = null;
    var var131 = null;
    var var132 = 0;
    var var133 = null;
    var phi134 = 0;
    var phi135 = null;
    var var136 = null;
    var var137 = null;
    var var138 = null;
    var var139 = 0;
    var var140 = 0;
    var var141 = null;
    var var142 = null;
    var var143 = null;
    var var144 = null;
    var var145 = null;
    var var146 = 0;
    var phi147 = 0;
    var var148 = 0;
    var var149 = null;
    var var150 = 0;
    var var151 = null;
    var var152 = 0;
    var var153 = null;
    var var154 = null;
    var var155 = 0;
    var var156 = 0;
    var var157 = 0;
    var var158 = 0;
    var var159 = null;
    var var160 = null;
    var var161 = null;
    var var162 = null;
    var var163 = 0;
    var var164 = null;
    var var165 = null;
    var var166 = null;
    var phi167 = null;
    var phi168 = 0;
    var phi169 = null;
    var var170 = null;
    var var171 = 0;
    var var172 = null;
    var var173 = 0;
    var var174 = null;
    var var175 = null;
    var var176 = 0;
    var var177 = null;
    var var178 = null;
    var var179 = null;
    var phi180 = null;
    var phi181 = 0;
    var phi182 = null;
    var var183 = null;
    var var184 = 0;
    var var185 = null;
    var var186 = null;
    var var187 = null;
    var var188 = null;
    var var189 = null;
    var var190 = null;
    var var191 = null;
    var var192 = 0;
    var var193 = 0;
    var var194 = 0;
    var var195 = 0;
    var var196 = 0;
    var var197 = 0;
    var var198 = 0;
    var var199 = 0;
    var var200 = null;
    var var201 = null;
    var var202 = 0;
    var var203 = 0;
    var var204 = 0;
    var var205 = 0;
    var var206 = 0;
    var var207 = null;
    var var208 = 0;
    var var209 = 0;
    var var210 = 0;
    var phi211 = null;
    var phi212 = 0;
    var phi213 = 0;
    var var214 = 0;
    var var215 = 0;
    var var216 = 0;
    var var217 = null;
    var var218 = 0;
    var var219 = 0;
    var var220 = 0;
    var var221 = null;
    var var222 = null;
    var var223 = 0;
    var var224 = 0;
    var var225 = 0;
    var var226 = 0;
    var var227 = 0;
    var var228 = 0;
    var phi229 = 0;
    var phi230 = 0;
    var0 = (arg0) | 0;
    var1 = (this.m_metatable);
    If_8_0: {
     if (var1 == null) {
      phi8 = this;
      phi9 = (var0) | 0;
      break If_8_0;
     } else {
      var2 = this;
      var3 = (var2.m_metatable);
      var4 = (var3.Z$useWeakKeys$$());
      If_18_0: {
       if (var4 != 0) {
        phi8 = this;
        phi9 = (var0) | 0;
        break If_18_0;
       } else {
        var5 = this;
        var6 = (var5.m_metatable);
        var7 = (var6.Z$useWeakValues$$());
        if (var7 == 0) {
         phi8 = this;
         phi9 = (var0) | 0;
         break If_8_0;
        } else {
         phi8 = this;
         phi9 = (var0) | 0;
         break If_18_0;
        }
       }
      }
      var10 = phi8;
      var11 = phi8;
      var12 = ((org$luaj$vm2$LuaTable.prototype.I$countHashKeys$$.call(var11))) | 0;
      var10.hashEntries = var12;
      var13 = phi8;
      var14 = (var13.m_metatable);
      var15 = (var14.Z$useWeakValues$$());
      if (var15 == 0) {
       break If_8_0;
      } else {
       var16 = phi8;
       org$luaj$vm2$LuaTable.prototype.V$dropWeakArrayValues$$.call(var16);
       break If_8_0;
      }
     }
    }
    var17 = bytecoder.newarray((32),0);
    var18 = phi8;
    var19 = ((org$luaj$vm2$LuaTable.prototype.I$countIntKeys$$I.call(var18,var17))) | 0;
    var20 = (phi9) | 0;
    If_69_0: {
     if (var20 <= 0) {
      phi27 = var17;
      phi28 = (var19) | 0;
      break If_69_0;
     } else {
      var21 = ((var19 + 1)) | 0;
      var22 = (phi9) | 0;
      org$luaj$vm2$LuaTable.$i;
      var23 = ((org$luaj$vm2$LuaTable.I$log2$I(var22))) | 0;
      var24 = var17;
      var25 = ((var24.data[var23])) | 0;
      var26 = ((var25 + 1)) | 0;
      var17.data[var23] = var26;
      phi27 = var17;
      phi28 = (var21) | 0;
      break If_69_0;
     }
    }
    var29 = phi27;
    var30 = ((var29.data[0])) | 0;
    var31 = (0) | 0;
    var32 = (1) | 0;
    phi33 = (var30) | 0;
    phi34 = (var31) | 0;
    phi35 = (var32) | 0;
    L1344968689: while(true) {
     var36 = (phi35) | 0;
     If_115_0: {
      if (var36 >= 32) {
       phi46 = (phi33) | 0;
       break If_115_0;
      } else {
       var37 = (phi33) | 0;
       var38 = phi27;
       var39 = (phi35) | 0;
       var40 = ((var38.data[var39])) | 0;
       var41 = ((var37 + var40)) | 0;
       var42 = (phi28) | 0;
       var43 = ((var42 * 2)) | 0;
       var44 = (phi35) | 0;
       var45 = ((1 << var44)) | 0;
       if (var43 >= var45) {
        var223 = (phi35) | 0;
        var224 = ((var223 - 1)) | 0;
        var225 = ((1 << var224)) | 0;
        If_677_0: {
         if (var41 < var225) {
          phi229 = (var41) | 0;
          phi230 = (phi34) | 0;
          break If_677_0;
         } else {
          var226 = (1) | 0;
          var227 = (phi35) | 0;
          var228 = ((var226 << var227)) | 0;
          phi229 = (var41) | 0;
          phi230 = (var228) | 0;
          break If_677_0;
         }
        }
        phi35 = ((phi35 + 1)) | 0;
        // Here was a goto statement
        phi33 = (phi229) | 0;
        phi34 = (phi230) | 0;
        continue L1344968689;
       } else {
        // Here was a goto statement
        phi46 = (var41) | 0;
        break If_115_0;
       }
      }
     }
     var47 = phi8;
     var48 = (var47.array);
     var49 = phi8;
     var50 = (var49.hash);
     var51 = (0) | 0;
     var52 = (phi9) | 0;
     If_161_0: {
      if (var52 <= 0) {
       phi56 = var48;
       phi57 = var50;
       phi58 = (var51) | 0;
       break If_161_0;
      } else {
       var53 = (phi9) | 0;
       var54 = (phi34) | 0;
       if (var53 > var54) {
        phi56 = var48;
        phi57 = var50;
        phi58 = (var51) | 0;
        break If_161_0;
       } else {
        var55 = ((var51 + -1)) | 0;
        phi56 = var48;
        phi57 = var50;
        phi58 = (var55) | 0;
        break If_161_0;
       }
      }
     }
     var59 = (phi34) | 0;
     var60 = phi56;
     var61 = (var60.data.length) | 0;
     If_185_0: {
      if (var59 == var61) {
       var221 = phi8;
       var222 = (var221.array);
       phi74 = var222;
       break If_185_0;
      } else {
       var62 = (phi34) | 0;
       var63 = bytecoder.newarray((var62),null);
       var64 = (phi34) | 0;
       var65 = phi56;
       var66 = (var65.data.length) | 0;
       If_199_0: {
        if (var64 <= var66) {
         var201 = phi56;
         var202 = (var201.data.length) | 0;
         var203 = (phi34) | 0;
         if (var202 <= var203) {
          phi74 = var63;
          break If_199_0;
         } else {
          var204 = (phi34) | 0;
          var205 = ((var204 + 1)) | 0;
          org$luaj$vm2$LuaTable.$i;
          var206 = ((org$luaj$vm2$LuaTable.I$log2$I(var205))) | 0;
          var207 = phi56;
          var208 = (var207.data.length) | 0;
          var209 = ((org$luaj$vm2$LuaTable.I$log2$I(var208))) | 0;
          var210 = ((var209 + 1)) | 0;
          phi211 = var63;
          phi212 = (var206) | 0;
          phi213 = (var210) | 0;
          L1799959941: while(true) {
           var214 = (phi212) | 0;
           var215 = (phi213) | 0;
           if (var214 >= var215) {
            phi74 = phi211;
            phi75 = (phi212) | 0;
            phi76 = (phi213) | 0;
            break If_199_0;
           } else {
            var216 = (phi58) | 0;
            var217 = phi27;
            var218 = (phi212) | 0;
            var219 = ((var217.data[var218])) | 0;
            var220 = ((var216 - var219)) | 0;
            phi212 = ((phi212 + 1)) | 0;
            // Here was a goto statement
            phi58 = (var220) | 0;
            continue L1799959941;
           }
          }
         }
        } else {
         var67 = phi56;
         var68 = (var67.data.length) | 0;
         var69 = ((var68 + 1)) | 0;
         org$luaj$vm2$LuaTable.$i;
         var70 = ((org$luaj$vm2$LuaTable.I$log2$I(var69))) | 0;
         var71 = (phi34) | 0;
         var72 = ((org$luaj$vm2$LuaTable.I$log2$I(var71))) | 0;
         var73 = ((var72 + 1)) | 0;
         phi74 = var63;
         phi75 = (var70) | 0;
         phi76 = (var73) | 0;
         L859445621: while(true) {
          var77 = (phi75) | 0;
          var78 = (phi76) | 0;
          if (var77 >= var78) {
           // Here was a goto statement
           break If_199_0;
          } else {
           var79 = (phi58) | 0;
           var80 = phi27;
           var81 = (phi75) | 0;
           var82 = ((var80.data[var81])) | 0;
           var83 = ((var79 + var82)) | 0;
           phi75 = ((phi75 + 1)) | 0;
           // Here was a goto statement
           phi58 = (var83) | 0;
           continue L859445621;
          }
         }
        }
       }
       var84 = phi56;
       var85 = phi74;
       var86 = phi56;
       var87 = (var86.data.length) | 0;
       var88 = (phi34) | 0;
       java$lang$Math.$i;
       var89 = ((java$lang$Math.I$min$I$I(var87,var88))) | 0;
       java$lang$System.V$arraycopy$Ljava$lang$Object$$I$Ljava$lang$Object$$I$I(var84,0,var85,0,var89);
       // Here was a goto statement
       break If_185_0;
      }
     }
     var90 = phi8;
     var91 = ((var90.hashEntries)) | 0;
     var92 = (phi58) | 0;
     var93 = ((var91 - var92)) | 0;
     var94 = (phi9) | 0;
     If_287_0: {
      If_287_1: {
       if (var94 < 0) {
        phi97 = (var93) | 0;
        break If_287_1;
       } else {
        var95 = (phi9) | 0;
        var96 = (phi34) | 0;
        if (var95 <= var96) {
         phi97 = (var93) | 0;
         phi98 = (0) | 0;
         break If_287_0;
        } else {
         phi97 = (var93) | 0;
         break If_287_1;
        }
       }
      }
      // Here was a goto statement
      phi98 = (1) | 0;
      break If_287_0;
     }
     var99 = ((phi97 + phi98)) | 0;
     var100 = phi57;
     var101 = (var100.data.length) | 0;
     var102 = (var99) | 0;
     If_312_0: {
      if (var102 <= 0) {
       var198 = (0) | 0;
       var199 = (0) | 0;
       org$luaj$vm2$LuaTable.$i;
       var200 = (org$luaj$vm2$LuaTable.NOBUCKETS);
       phi112 = var200;
       phi105 = (var99) | 0;
       phi106 = (var101) | 0;
       phi113 = (var198) | 0;
       phi114 = (var199) | 0;
       break If_312_0;
      } else {
       var103 = (var99) | 0;
       If_318_0: {
        if (var103 >= 2) {
         var195 = (var99) | 0;
         org$luaj$vm2$LuaTable.$i;
         var196 = ((org$luaj$vm2$LuaTable.I$log2$I(var195))) | 0;
         var197 = ((1 << var196)) | 0;
         phi105 = (var99) | 0;
         phi106 = (var101) | 0;
         phi107 = (var197) | 0;
         break If_318_0;
        } else {
         var104 = (2) | 0;
         // Here was a goto statement
         phi105 = (var99) | 0;
         phi106 = (var101) | 0;
         phi107 = (var104) | 0;
         break If_318_0;
        }
       }
       var108 = (phi107) | 0;
       var109 = ((var108 - 1)) | 0;
       var110 = (var108) | 0;
       var111 = bytecoder.newarray((var110),null);
       // Here was a goto statement
       phi112 = var111;
       phi113 = (var108) | 0;
       phi114 = (var109) | 0;
       break If_312_0;
      }
     }
     var115 = (0) | 0;
     phi116 = (var115) | 0;
     L915662084: while(true) {
      var117 = (phi116) | 0;
      var118 = (phi106) | 0;
      if (var117 >= var118) {
       var146 = (phi34) | 0;
       phi147 = (var146) | 0;
       L1019922306: while(true) {
        var148 = (phi147) | 0;
        var149 = phi56;
        var150 = (var149.data.length) | 0;
        if (var148 >= var150) {
         var187 = phi8;
         var188 = phi112;
         var187.hash = var188;
         var189 = phi8;
         var190 = phi74;
         var189.array = var190;
         var191 = phi8;
         var192 = ((var191.hashEntries)) | 0;
         var193 = (phi58) | 0;
         var194 = ((var192 - var193)) | 0;
         var191.hashEntries = var194;
         return;
        } else {
         var151 = phi56;
         var152 = (phi147) | 0;
         phi147 = ((phi147 + 1)) | 0;
         var153 = (var151.data[var152]);
         var154 = var153;
         If_462_0: {
          if (var153 == null) {
           phi167 = var154;
           break If_462_0;
          } else {
           var155 = (phi147) | 0;
           org$luaj$vm2$LuaInteger.$i;
           var156 = ((org$luaj$vm2$LuaInteger.I$hashCode$I(var155))) | 0;
           var157 = (phi114) | 0;
           org$luaj$vm2$LuaTable.$i;
           var158 = ((org$luaj$vm2$LuaTable.I$hashmod$I$I(var156,var157))) | 0;
           var159 = phi8;
           var160 = (var159.m_metatable);
           If_482_0: {
            if (var160 == null) {
             var184 = (phi147) | 0;
             var185 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaInteger$$valueOf$I(var184));
             var186 = (org$luaj$vm2$LuaTable.Lorg$luaj$vm2$LuaTable$Entry$$defaultEntry$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(var185,var154));
             phi167 = var154;
             phi168 = (var158) | 0;
             phi169 = var186;
             break If_482_0;
            } else {
             var161 = phi8;
             var162 = (var161.m_metatable);
             var163 = (phi147) | 0;
             var164 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaInteger$$valueOf$I(var163));
             var165 = (var162.Lorg$luaj$vm2$LuaTable$Slot$$entry$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(var164,var154));
             var166 = var165;
             if (var166 != null) {
              phi167 = var154;
              phi168 = (var158) | 0;
              phi169 = var165;
              break If_482_0;
             } else {
              // Here was a goto statement
              continue L1019922306;
             }
            }
           }
           var170 = phi112;
           var171 = (phi168) | 0;
           var172 = phi112;
           var173 = (phi168) | 0;
           var174 = (var172.data[var173]);
           If_518_0: {
            if (var174 == null) {
             var183 = phi169;
             phi180 = var170;
             phi181 = (var171) | 0;
             phi182 = var183;
             break If_518_0;
            } else {
             var175 = phi112;
             var176 = (phi168) | 0;
             var177 = (var175.data[var176]);
             var178 = phi169;
             var179 = (var177.Lorg$luaj$vm2$LuaTable$Slot$$add$Lorg$luaj$vm2$LuaTable$Slot$(var178));
             // Here was a goto statement
             phi180 = var170;
             phi181 = (var171) | 0;
             phi182 = var179;
             break If_518_0;
            }
           }
           phi180.data[phi181] = phi182;
           break If_462_0;
          }
         }
         // Here was a goto statement
         continue L1019922306;
        }
       }
      } else {
       var119 = phi57;
       var120 = (phi116) | 0;
       var121 = (var119.data[var120]);
       phi122 = var121;
       L958959611: while(true) {
        var123 = phi122;
        if (var123 == null) {
         phi116 = ((phi116 + 1)) | 0;
         // Here was a goto statement
         continue L915662084;
        } else {
         var124 = phi122;
         var125 = (phi34) | 0;
         var126 = ((var124.I$arraykey$I(var125))) | 0;
         var127 = (var126) | 0;
         If_377_0: {
          if (var126 <= 0) {
           var138 = phi122;
           var139 = (phi114) | 0;
           var140 = ((var138.I$keyindex$I(var139))) | 0;
           var141 = phi112;
           var142 = phi122;
           var143 = phi112;
           var144 = (var143.data[var140]);
           var145 = (var142.Lorg$luaj$vm2$LuaTable$Slot$$relink$Lorg$luaj$vm2$LuaTable$Slot$(var144));
           var141.data[var140] = var145;
           phi134 = (var127) | 0;
           phi135 = var140;
           break If_377_0;
          } else {
           var128 = phi122;
           var129 = (var128.Lorg$luaj$vm2$LuaTable$StrongSlot$$first$$());
           var130 = var129;
           If_387_0: {
            if (var130 == null) {
             phi134 = (var127) | 0;
             phi135 = var129;
             break If_387_0;
            } else {
             var131 = phi74;
             var132 = ((var127 - 1)) | 0;
             var133 = (var129.Lorg$luaj$vm2$LuaValue$$value$$());
             var131.data[var132] = var133;
             phi134 = (var127) | 0;
             phi135 = var129;
             break If_387_0;
            }
           }
           // Here was a goto statement
           break If_377_0;
          }
         }
         var136 = phi122;
         var137 = (var136.Lorg$luaj$vm2$LuaTable$Slot$$rest$$());
         // Here was a goto statement
         phi122 = var137;
         continue L958959611;
        }
       }
      }
     }
    }
  }

  I$countHashKeys$$() {
    var var0 = 0;
    var var1 = 0;
    var phi2 = null;
    var phi3 = 0;
    var phi4 = 0;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = null;
    var var11 = 0;
    var var12 = null;
    var phi13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = 0;
    var0 = (0) | 0;
    var1 = (0) | 0;
    phi2 = this;
    phi3 = (var0) | 0;
    phi4 = (var1) | 0;
    L776277749: while(true) {
     var5 = (phi4) | 0;
     var6 = phi2;
     var7 = (var6.hash);
     var8 = (var7.data.length) | 0;
     if (var5 >= var8) {
      var19 = (phi3) | 0;
      return var19;
     } else {
      var9 = phi2;
      var10 = (var9.hash);
      var11 = (phi4) | 0;
      var12 = (var10.data[var11]);
      phi13 = var12;
      L110086350: while(true) {
       var14 = phi13;
       if (var14 == null) {
        phi4 = ((phi4 + 1)) | 0;
        // Here was a goto statement
        continue L776277749;
       } else {
        var15 = phi13;
        var16 = (var15.Lorg$luaj$vm2$LuaTable$StrongSlot$$first$$());
        If_45_0: {
         if (var16 == null) {
          break If_45_0;
         } else {
          phi3 = ((phi3 + 1)) | 0;
          break If_45_0;
         }
        }
        var17 = phi13;
        var18 = (var17.Lorg$luaj$vm2$LuaTable$Slot$$rest$$());
        // Here was a goto statement
        phi13 = var18;
        continue L110086350;
       }
      }
     }
    }
  }

  V$dropWeakArrayValues$$() {
    var var0 = 0;
    var phi1 = null;
    var phi2 = 0;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = 0;
    var var12 = null;
    var0 = (0) | 0;
    phi1 = this;
    phi2 = (var0) | 0;
    L703558028: while(true) {
     var3 = (phi2) | 0;
     var4 = phi1;
     var5 = (var4.array);
     var6 = (var5.data.length) | 0;
     if (var3 >= var6) {
      return;
     } else {
      var7 = phi1;
      var8 = (var7.m_metatable);
      var9 = phi1;
      var10 = (var9.array);
      var11 = (phi2) | 0;
      var12 = (var8.Lorg$luaj$vm2$LuaValue$$arrayget$$Lorg$luaj$vm2$LuaValue$$I(var10,var11));
      phi2 = ((phi2 + 1)) | 0;
      // Here was a goto statement
      continue L703558028;
     }
    }
  }

  I$countIntKeys$$I(arg0) {
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var phi3 = null;
    var phi4 = null;
    var phi5 = 0;
    var phi6 = 0;
    var phi7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = null;
    var var11 = null;
    var var12 = 0;
    var phi13 = 0;
    var var14 = 0;
    var var15 = null;
    var var16 = null;
    var var17 = 0;
    var var18 = null;
    var var19 = null;
    var var20 = 0;
    var var21 = null;
    var phi22 = null;
    var var23 = null;
    var var24 = null;
    var var25 = 0;
    var var26 = 0;
    var var27 = null;
    var var28 = 0;
    var var29 = null;
    var var30 = 0;
    var var31 = 0;
    var phi32 = 0;
    var var33 = null;
    var var34 = null;
    var var35 = 0;
    var var36 = null;
    var var37 = null;
    var var38 = 0;
    var var39 = 0;
    var var40 = 0;
    var var41 = 0;
    var var42 = 0;
    var phi43 = 0;
    var phi44 = 0;
    var var45 = 0;
    var var46 = 0;
    var var47 = null;
    var var48 = null;
    var var49 = 0;
    var var50 = 0;
    var var51 = null;
    var var52 = null;
    var var53 = 0;
    var var54 = 0;
    var var55 = 0;
    var var56 = 0;
    var var57 = 0;
    var0 = arg0;
    var1 = (1) | 0;
    var2 = (0) | 0;
    phi3 = this;
    phi4 = var0;
    phi5 = (0) | 0;
    phi6 = (var1) | 0;
    phi7 = (var2) | 0;
    L257156026: while(true) {
     var8 = (phi7) | 0;
     If_21_0: {
      if (var8 >= 31) {
       break If_21_0;
      } else {
       var9 = (phi6) | 0;
       var10 = phi3;
       var11 = (var10.array);
       var12 = (var11.data.length) | 0;
       if (var9 <= var12) {
        var36 = phi3;
        var37 = (var36.array);
        var38 = (var37.data.length) | 0;
        var39 = (phi7) | 0;
        var40 = ((1 << var39)) | 0;
        java$lang$Math.$i;
        var41 = ((java$lang$Math.I$min$I$I(var38,var40))) | 0;
        var42 = (0) | 0;
        phi43 = (var41) | 0;
        phi44 = (var42) | 0;
        L278764239: while(true) {
         var45 = (phi6) | 0;
         var46 = (phi43) | 0;
         if (var45 > var46) {
          var52 = phi4;
          var53 = (phi7) | 0;
          var54 = (phi44) | 0;
          var52.data[var53] = var54;
          var55 = (phi5) | 0;
          var56 = (phi44) | 0;
          var57 = ((var55 + var56)) | 0;
          phi7 = ((phi7 + 1)) | 0;
          // Here was a goto statement
          phi5 = (var57) | 0;
          continue L257156026;
         } else {
          var47 = phi3;
          var48 = (var47.array);
          var49 = (phi6) | 0;
          phi6 = ((phi6 + 1)) | 0;
          var50 = ((var49 - 1)) | 0;
          var51 = (var48.data[var50]);
          if (var51 == null) {
           continue L278764239;
          } else {
           phi44 = ((phi44 + 1)) | 0;
           // Here was a goto statement
           continue L278764239;
          }
         }
        }
       } else {
        // Here was a goto statement
        break If_21_0;
       }
      }
     }
     phi13 = (0) | 0;
     L2050246085: while(true) {
      var14 = (phi13) | 0;
      var15 = phi3;
      var16 = (var15.hash);
      var17 = (var16.data.length) | 0;
      if (var14 >= var17) {
       var35 = (phi5) | 0;
       return var35;
      } else {
       var18 = phi3;
       var19 = (var18.hash);
       var20 = (phi13) | 0;
       var21 = (var19.data[var20]);
       phi22 = var21;
       L583924776: while(true) {
        var23 = phi22;
        if (var23 == null) {
         phi13 = ((phi13 + 1)) | 0;
         // Here was a goto statement
         continue L2050246085;
        } else {
         var24 = phi22;
         var25 = ((var24.I$arraykey$I(2147483647))) | 0;
         var26 = (var25) | 0;
         If_76_0: {
          if (var25 <= 0) {
           phi32 = (var26) | 0;
           break If_76_0;
          } else {
           var27 = phi4;
           org$luaj$vm2$LuaTable.$i;
           var28 = ((org$luaj$vm2$LuaTable.I$log2$I(var26))) | 0;
           var29 = var27;
           var30 = ((var29.data[var28])) | 0;
           var31 = ((var30 + 1)) | 0;
           var27.data[var28] = var31;
           phi5 = ((phi5 + 1)) | 0;
           phi32 = (var26) | 0;
           break If_76_0;
          }
         }
         var33 = phi22;
         var34 = (var33.Lorg$luaj$vm2$LuaTable$Slot$$rest$$());
         // Here was a goto statement
         phi22 = var34;
         continue L583924776;
        }
       }
      }
     }
    }
  }

  static Lorg$luaj$vm2$LuaTable$Entry$$defaultEntry$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var var8 = .0;
    var var9 = null;
    var var10 = null;
    var0 = arg1;
    var1 = (arg0.Z$isinttype$$());
    if (var1 == 0) {
     var5 = ((var0.I$type$$())) | 0;
     if (var5 != 3) {
      var9 = new org$luaj$vm2$LuaTable$NormalEntry();
      var10 = var0;
      org$luaj$vm2$LuaTable$NormalEntry.prototype.V$$init$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$.call(var9,arg0,var10);
      return var9;
     } else {
      var6 = new org$luaj$vm2$LuaTable$NumberValueEntry();
      var7 = var0;
      var8 = (var7.D$todouble$$());
      org$luaj$vm2$LuaTable$NumberValueEntry.prototype.V$$init$$Lorg$luaj$vm2$LuaValue$$D.call(var6,arg0,var8);
      return var6;
     }
    } else {
     var2 = new org$luaj$vm2$LuaTable$IntKeyEntry();
     var3 = arg0;
     var4 = ((var3.I$toint$$())) | 0;
     org$luaj$vm2$LuaTable$IntKeyEntry.prototype.V$$init$$I$Lorg$luaj$vm2$LuaValue$.call(var2,var4,var0);
     return var2;
    }
  }

  V$set$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var phi8 = null;
    var phi9 = null;
    var phi10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = 0;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = 0;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var0 = arg0;
    var1 = (var0.Z$isvalidkey$$());
    If_9_0: {
     if (var1 != 0) {
      phi8 = this;
      phi9 = var0;
      phi10 = arg1;
      break If_9_0;
     } else {
      var2 = this;
      org$luaj$vm2$LuaTable.$i;
      var3 = (org$luaj$vm2$LuaTable.NEWINDEX);
      var4 = (var2.Lorg$luaj$vm2$LuaValue$$metatag$Lorg$luaj$vm2$LuaValue$(var3));
      var5 = (var4.Z$isfunction$$());
      if (var5 != 0) {
       phi8 = this;
       phi9 = var0;
       phi10 = arg1;
       break If_9_0;
      } else {
       var6 = this;
       var7 = (var6.Lorg$luaj$vm2$LuaValue$$typerror$Ljava$lang$String$(bytecoder.stringconstants[428]));
       phi8 = this;
       phi9 = var0;
       phi10 = arg1;
       break If_9_0;
      }
     }
    }
    var11 = phi8;
    var12 = (var11.m_metatable);
    If_43_0: {
     If_43_1: {
      if (var12 == null) {
       break If_43_1;
      } else {
       var13 = phi8;
       var14 = phi9;
       var15 = (org$luaj$vm2$LuaTable.prototype.Lorg$luaj$vm2$LuaValue$$rawget$Lorg$luaj$vm2$LuaValue$.call(var13,var14));
       var16 = (var15.Z$isnil$$());
       if (var16 == 0) {
        break If_43_1;
       } else {
        var17 = phi8;
        var18 = phi9;
        var19 = phi10;
        org$luaj$vm2$LuaTable.$i;
        var20 = (org$luaj$vm2$LuaValue.Z$settable$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(var17,var18,var19));
        if (var20 != 0) {
         break If_43_0;
        } else {
         break If_43_1;
        }
       }
      }
     }
     var21 = phi8;
     var22 = phi9;
     var23 = phi10;
     org$luaj$vm2$LuaTable.prototype.V$rawset$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$.call(var21,var22,var23);
     break If_43_0;
    }
    return;
  }

  V$rawset$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var phi5 = null;
    var phi6 = null;
    var phi7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var0 = arg0;
    var1 = (var0.Z$isinttype$$());
    If_9_0: {
     If_9_1: {
      if (var1 == 0) {
       phi5 = this;
       phi6 = var0;
       phi7 = arg1;
       break If_9_1;
      } else {
       var2 = this;
       var3 = ((var0.I$toint$$())) | 0;
       var4 = (org$luaj$vm2$LuaTable.prototype.Z$arrayset$I$Lorg$luaj$vm2$LuaValue$.call(var2,var3,arg1));
       if (var4 != 0) {
        phi5 = this;
        phi6 = var0;
        phi7 = arg1;
        break If_9_0;
       } else {
        phi5 = this;
        phi6 = var0;
        phi7 = arg1;
        break If_9_1;
       }
      }
     }
     var8 = phi5;
     var9 = phi6;
     var10 = phi7;
     org$luaj$vm2$LuaTable.prototype.V$hashset$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$.call(var8,var9,var10);
     break If_9_0;
    }
    return;
  }

  Z$istable$$() {
    var var0 = 0;
    var0 = (1) | 0;
    return var0;
  }

  V$presize$I(arg0) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var var8 = null;
    var phi9 = null;
    var phi10 = 0;
    var0 = (arg0) | 0;
    var1 = this;
    var2 = (var1.array);
    var3 = (var2.data.length) | 0;
    If_13_0: {
     if (var0 <= var3) {
      phi9 = this;
      phi10 = (var0) | 0;
      break If_13_0;
     } else {
      var4 = this;
      var5 = (this.array);
      org$luaj$vm2$LuaTable.$i;
      var6 = ((org$luaj$vm2$LuaTable.I$log2$I(var0))) | 0;
      var7 = ((1 << var6)) | 0;
      var8 = (org$luaj$vm2$LuaTable.$Lorg$luaj$vm2$LuaValue$$resize$$Lorg$luaj$vm2$LuaValue$$I(var5,var7));
      var4.array = var8;
      phi9 = this;
      phi10 = (var0) | 0;
      break If_13_0;
     }
    }
    return;
  }

  static $Lorg$luaj$vm2$LuaValue$$resize$$Lorg$luaj$vm2$LuaValue$$I(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var0 = (arg1) | 0;
    var1 = bytecoder.newarray((var0),null);
    var2 = arg0;
    var3 = var1;
    var4 = arg0;
    var5 = (var4.data.length) | 0;
    java$lang$System.V$arraycopy$Ljava$lang$Object$$I$Ljava$lang$Object$$I$I(var2,0,var3,0,var5);
    return var1;
  }

  Z$eq_b$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var phi6 = null;
    var phi7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = 0;
    var var15 = 0;
    var phi16 = null;
    var phi17 = null;
    var phi18 = null;
    var phi19 = 0;
    var phi20 = null;
    var phi21 = null;
    var phi22 = null;
    var0 = arg0;
    var1 = var0;
    if (this != var1) {
     var3 = (this.m_metatable);
     If_17_0: {
      if (var3 == null) {
       phi6 = this;
       phi7 = var0;
       break If_17_0;
      } else {
       var4 = var0;
       var5 = (var4.Z$istable$$());
       if (var5 != 0) {
        var8 = (var0.Lorg$luaj$vm2$LuaValue$$getmetatable$$());
        var9 = var8;
        If_38_0: {
         If_38_1: {
          if (var9 == null) {
           phi20 = this;
           phi21 = var0;
           phi22 = var8;
           break If_38_1;
          } else {
           var10 = this;
           var11 = (this.m_metatable);
           var12 = (var11.Lorg$luaj$vm2$LuaValue$$toLuaValue$$());
           var13 = var8;
           org$luaj$vm2$LuaValue.$i;
           var14 = (org$luaj$vm2$LuaValue.Z$eqmtcall$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(var10,var12,var0,var13));
           if (var14 == 0) {
            phi20 = this;
            phi21 = var0;
            phi22 = var8;
            break If_38_1;
           } else {
            var15 = (1) | 0;
            // Here was a goto statement
            phi16 = this;
            phi17 = var0;
            phi18 = var8;
            phi19 = (var15) | 0;
            break If_38_0;
           }
          }
         }
         phi16 = phi20;
         phi17 = phi21;
         phi18 = phi22;
         phi19 = (0) | 0;
         break If_38_0;
        }
        return phi19;
       } else {
        phi6 = this;
        phi7 = var0;
        break If_17_0;
       }
      }
     }
     return 0;
    } else {
     var2 = (1) | 0;
     return var2;
    }
  }

  Lorg$luaj$vm2$LuaValue$$len$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = null;
    org$luaj$vm2$LuaTable.$i;
    var0 = (org$luaj$vm2$LuaTable.LEN);
    var1 = (this.Lorg$luaj$vm2$LuaValue$$metatag$Lorg$luaj$vm2$LuaValue$(var0));
    var2 = var1;
    var3 = (var2.Z$toboolean$$());
    if (var3 == 0) {
     var6 = ((org$luaj$vm2$LuaTable.prototype.I$rawlen$$.call(this))) | 0;
     org$luaj$vm2$LuaInteger.$i;
     var7 = (org$luaj$vm2$LuaInteger.Lorg$luaj$vm2$LuaInteger$$valueOf$I(var6));
     return var7;
    } else {
     var4 = var1;
     var5 = (var4.Lorg$luaj$vm2$LuaValue$$call$Lorg$luaj$vm2$LuaValue$(this));
     return var5;
    }
  }

  I$rawlen$$() {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var phi4 = null;
    var phi5 = 0;
    var phi6 = 0;
    var phi7 = 0;
    var var8 = null;
    var var9 = 0;
    var var10 = null;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = 0;
    var var15 = null;
    var var16 = 0;
    var var17 = 0;
    var var18 = 0;
    var var19 = 0;
    var var20 = 0;
    var var21 = 0;
    var var22 = 0;
    var var23 = 0;
    var var24 = 0;
    var var25 = 0;
    var var26 = 0;
    var var27 = null;
    var var28 = null;
    var var29 = 0;
    var var30 = 0;
    var phi31 = 0;
    var phi32 = 0;
    var var33 = 0;
    var var34 = 0;
    var0 = ((org$luaj$vm2$LuaTable.prototype.I$getArrayLength$$.call(this))) | 0;
    var1 = (var0) | 0;
    var2 = ((var1 + 1)) | 0;
    var3 = (0) | 0;
    phi4 = this;
    phi5 = (var0) | 0;
    phi6 = (var2) | 0;
    phi7 = (var3) | 0;
    L1457033575: while(true) {
     var8 = phi4;
     var9 = (phi6) | 0;
     var10 = (org$luaj$vm2$LuaTable.prototype.Lorg$luaj$vm2$LuaValue$$rawget$I.call(var8,var9));
     var11 = (var10.Z$isnil$$());
     If_29_0: {
      if (var11 != 0) {
       break If_29_0;
      } else {
       var12 = (phi6) | 0;
       var13 = (phi6) | 0;
       var14 = (phi5) | 0;
       var15 = phi4;
       var16 = ((org$luaj$vm2$LuaTable.prototype.I$getHashLength$$.call(var15))) | 0;
       var17 = ((var14 + var16)) | 0;
       var18 = ((var17 + 1)) | 0;
       var19 = ((var13 + var18)) | 0;
       // Here was a goto statement
       phi6 = (var19) | 0;
       phi7 = (var12) | 0;
       continue L1457033575;
      }
     }
     L239343039: while(true) {
      var20 = (phi6) | 0;
      var21 = (phi7) | 0;
      var22 = ((var21 + 1)) | 0;
      if (var20 <= var22) {
       var34 = (phi7) | 0;
       return var34;
      } else {
       var23 = (phi6) | 0;
       var24 = (phi7) | 0;
       var25 = ((var23 + var24)) | 0;
       var26 = (Math.floor(var25 / 2)) | 0;
       var27 = phi4;
       var28 = (org$luaj$vm2$LuaTable.prototype.Lorg$luaj$vm2$LuaValue$$rawget$I.call(var27,var26));
       var29 = (var28.Z$isnil$$());
       If_84_0: {
        if (var29 != 0) {
         var33 = (var26) | 0;
         phi6 = (var33) | 0;
         phi31 = (phi7) | 0;
         phi32 = (var26) | 0;
         break If_84_0;
        } else {
         var30 = (var26) | 0;
         // Here was a goto statement
         phi31 = (var30) | 0;
         phi32 = (var26) | 0;
         break If_84_0;
        }
       }
       // Here was a goto statement
       phi7 = (phi31) | 0;
       continue L239343039;
      }
     }
    }
  }

  I$getArrayLength$$() {
    var var0 = null;
    var var1 = 0;
    var0 = (this.array);
    var1 = (var0.data.length) | 0;
    return var1;
  }

  I$getHashLength$$() {
    var var0 = null;
    var var1 = 0;
    var0 = (this.hash);
    var1 = (var0.data.length) | 0;
    return var1;
  }

  Lorg$luaj$vm2$LuaValue$$get$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var phi9 = null;
    var phi10 = null;
    var phi11 = null;
    var phi12 = null;
    var phi13 = null;
    var phi14 = null;
    var phi15 = null;
    var var16 = null;
    var0 = arg0;
    var1 = var0;
    var2 = (org$luaj$vm2$LuaTable.prototype.Lorg$luaj$vm2$LuaValue$$rawget$Lorg$luaj$vm2$LuaValue$.call(this,var1));
    var3 = var2;
    var4 = (var3.Z$isnil$$());
    If_15_0: {
     If_15_1: {
      if (var4 == 0) {
       phi13 = this;
       phi14 = var0;
       phi15 = var2;
       break If_15_1;
      } else {
       var5 = this;
       var6 = (var5.m_metatable);
       if (var6 == null) {
        phi13 = this;
        phi14 = var0;
        phi15 = var2;
        break If_15_1;
       } else {
        var7 = this;
        org$luaj$vm2$LuaTable.$i;
        var8 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$LuaValue$$gettable$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(var7,var0));
        // Here was a goto statement
        phi9 = this;
        phi10 = var0;
        phi11 = var2;
        phi12 = var8;
        break If_15_0;
       }
      }
     }
     var16 = phi15;
     phi9 = phi13;
     phi10 = phi14;
     phi11 = phi15;
     phi12 = var16;
     break If_15_0;
    }
    return phi12;
  }

  static Z$isLargeKey$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var phi3 = null;
    var phi4 = 0;
    var0 = ((arg0.I$type$$())) | 0;
    if ((var0) >= 1 && (var0) <= 4) switch ((var0) - 1) {
     case 0: {
      return 0;
     }
     case 1: {
      return 1;
     }
     case 2: {
      return 0;
     }
     case 3: {
      var1 = ((arg0.I$rawlen$$())) | 0;
      If_11_0: {
       if (var1 <= 32) {
        phi3 = arg0;
        phi4 = (0) | 0;
        break If_11_0;
       } else {
        var2 = (1) | 0;
        // Here was a goto statement
        phi3 = arg0;
        phi4 = (var2) | 0;
        break If_11_0;
       }
      }
      return phi4;
     }
    } else {
     return 1;
    }
  }

  Lorg$luaj$vm2$LuaValue$$wrap$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var0 = arg0;
    return var0;
  }

  Z$useWeakKeys$$() {
    var var0 = 0;
    var0 = (0) | 0;
    return var0;
  }

  Z$useWeakValues$$() {
    var var0 = 0;
    var0 = (0) | 0;
    return var0;
  }

  Lorg$luaj$vm2$LuaTable$Slot$$entry$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    var1 = arg1;
    org$luaj$vm2$LuaTable.$i;
    var2 = (org$luaj$vm2$LuaTable.Lorg$luaj$vm2$LuaTable$Entry$$defaultEntry$Lorg$luaj$vm2$LuaValue$$Lorg$luaj$vm2$LuaValue$(var0,var1));
    return var2;
  }

  V$insert$I$Lorg$luaj$vm2$LuaValue$(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var phi4 = null;
    var phi5 = 0;
    var phi6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = null;
    var var13 = 0;
    var var14 = null;
    var var15 = null;
    var0 = (arg0) | 0;
    If_6_0: {
     if (var0 != 0) {
      phi4 = this;
      phi5 = (var0) | 0;
      phi6 = arg1;
      break If_6_0;
     } else {
      var1 = this;
      var2 = ((org$luaj$vm2$LuaTable.prototype.I$rawlen$$.call(var1))) | 0;
      var3 = ((var2 + 1)) | 0;
      phi4 = this;
      phi5 = (var3) | 0;
      phi6 = arg1;
      break If_6_0;
     }
    }
    L1866092750: while(true) {
     var7 = phi6;
     var8 = (var7.Z$isnil$$());
     if (var8 != 0) {
      return;
     } else {
      var9 = phi4;
      var10 = (phi5) | 0;
      var11 = (org$luaj$vm2$LuaTable.prototype.Lorg$luaj$vm2$LuaValue$$rawget$I.call(var9,var10));
      var12 = phi4;
      var13 = (phi5) | 0;
      phi5 = ((phi5 + 1)) | 0;
      var14 = phi6;
      org$luaj$vm2$LuaTable.prototype.V$rawset$I$Lorg$luaj$vm2$LuaValue$.call(var12,var13,var14);
      var15 = var11;
      // Here was a goto statement
      phi6 = var15;
      continue L1866092750;
     }
    }
  }

  Lorg$luaj$vm2$LuaTable$$opttable$Lorg$luaj$vm2$LuaTable$(arg0) {
    var var0 = null;
    var0 = arg0;
    return this;
  }

  Lorg$luaj$vm2$LuaValue$$setmetatable$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var phi6 = null;
    var phi7 = null;
    var phi8 = 0;
    var var9 = 0;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = 0;
    var var15 = 0;
    var phi16 = 0;
    var phi17 = 0;
    var var18 = 0;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = 0;
    var var23 = null;
    var var24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = 0;
    var var28 = 0;
    var phi29 = 0;
    var phi30 = 0;
    var phi31 = 0;
    var var32 = 0;
    var var33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = null;
    var var37 = 0;
    var var38 = 0;
    var phi39 = 0;
    var phi40 = 0;
    var var41 = null;
    var var42 = null;
    var phi43 = 0;
    var phi44 = 0;
    var phi45 = 0;
    var phi46 = 0;
    var phi47 = null;
    var phi48 = null;
    var0 = arg0;
    var1 = (this.m_metatable);
    If_8_0: {
     If_8_1: {
      if (var1 == null) {
       phi47 = this;
       phi48 = var0;
       break If_8_1;
      } else {
       var2 = this;
       var3 = (var2.m_metatable);
       var4 = (var3.Z$useWeakKeys$$());
       if (var4 == 0) {
        phi47 = this;
        phi48 = var0;
        break If_8_1;
       } else {
        var5 = (1) | 0;
        // Here was a goto statement
        phi6 = this;
        phi7 = var0;
        phi8 = (var5) | 0;
        break If_8_0;
       }
      }
     }
     phi6 = phi47;
     phi7 = phi48;
     phi8 = (0) | 0;
     break If_8_0;
    }
    var9 = (phi8) | 0;
    var10 = phi6;
    var11 = (var10.m_metatable);
    If_36_0: {
     If_36_1: {
      if (var11 == null) {
       phi46 = (var9) | 0;
       break If_36_1;
      } else {
       var12 = phi6;
       var13 = (var12.m_metatable);
       var14 = (var13.Z$useWeakValues$$());
       if (var14 == 0) {
        phi46 = (var9) | 0;
        break If_36_1;
       } else {
        var15 = (1) | 0;
        // Here was a goto statement
        phi16 = (var9) | 0;
        phi17 = (var15) | 0;
        break If_36_0;
       }
      }
     }
     phi16 = (phi46) | 0;
     phi17 = (0) | 0;
     break If_36_0;
    }
    var18 = (phi17) | 0;
    var19 = phi6;
    var20 = phi7;
    org$luaj$vm2$LuaTable.$i;
    var21 = (org$luaj$vm2$LuaValue.Lorg$luaj$vm2$Metatable$$metatableOf$Lorg$luaj$vm2$LuaValue$(var20));
    var19.m_metatable = var21;
    var22 = (phi16) | 0;
    var23 = phi6;
    var24 = (var23.m_metatable);
    If_75_0: {
     If_75_1: {
      if (var24 == null) {
       phi44 = (var18) | 0;
       phi45 = (var22) | 0;
       break If_75_1;
      } else {
       var25 = phi6;
       var26 = (var25.m_metatable);
       var27 = (var26.Z$useWeakKeys$$());
       if (var27 == 0) {
        phi44 = (var18) | 0;
        phi45 = (var22) | 0;
        break If_75_1;
       } else {
        var28 = (1) | 0;
        // Here was a goto statement
        phi29 = (var18) | 0;
        phi30 = (var22) | 0;
        phi31 = (var28) | 0;
        break If_75_0;
       }
      }
     }
     phi29 = (phi44) | 0;
     phi30 = (phi45) | 0;
     phi31 = (0) | 0;
     break If_75_0;
    }
    If_96_0: {
     If_96_1: {
      if (phi30 != phi31) {
       break If_96_1;
      } else {
       var32 = (phi29) | 0;
       var33 = phi6;
       var34 = (var33.m_metatable);
       If_105_0: {
        If_105_1: {
         if (var34 == null) {
          phi43 = (var32) | 0;
          break If_105_1;
         } else {
          var35 = phi6;
          var36 = (var35.m_metatable);
          var37 = (var36.Z$useWeakValues$$());
          if (var37 == 0) {
           phi43 = (var32) | 0;
           break If_105_1;
          } else {
           var38 = (1) | 0;
           // Here was a goto statement
           phi39 = (var32) | 0;
           phi40 = (var38) | 0;
           break If_105_0;
          }
         }
        }
        phi39 = (phi43) | 0;
        phi40 = (0) | 0;
        break If_105_0;
       }
       if (phi39 == phi40) {
        break If_96_0;
       } else {
        break If_96_1;
       }
      }
     }
     var41 = phi6;
     org$luaj$vm2$LuaTable.prototype.V$rehash$I.call(var41,0);
     break If_96_0;
    }
    var42 = phi6;
    return var42;
  }
}


class org$luaj$vm2$compiler$LuaC extends org$luaj$vm2$compiler$Constants {
  nativeObject = null;

  static instance = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$compiler$LuaC,[java$lang$Object,org$luaj$vm2$Globals$Compiler,org$luaj$vm2$Globals$Loader,org$luaj$vm2$Lua,org$luaj$vm2$compiler$Constants,org$luaj$vm2$compiler$LuaC]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      org$luaj$vm2$compiler$Constants.$i;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    var var0 = null;
    org$luaj$vm2$compiler$LuaC.$i;
    var0 = new org$luaj$vm2$compiler$LuaC();
    org$luaj$vm2$compiler$LuaC.prototype.V$$init$$$.call(var0);
    org$luaj$vm2$compiler$LuaC.instance = var0;
    return;
  }

  V$$init$$$() {
    org$luaj$vm2$compiler$Constants.prototype.V$$init$$$.call(this);
    return;
  }

  static V$install$Lorg$luaj$vm2$Globals$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    org$luaj$vm2$compiler$LuaC.$i;
    var1 = (org$luaj$vm2$compiler$LuaC.instance);
    var0.compiler = var1;
    var2 = (org$luaj$vm2$compiler$LuaC.instance);
    var0.loader = var2;
    return;
  }

  Lorg$luaj$vm2$LuaFunction$$load$Lorg$luaj$vm2$Prototype$$Ljava$lang$String$$Lorg$luaj$vm2$LuaValue$(arg0,arg1,arg2) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var0 = arg0;
    var1 = arg2;
    org$luaj$vm2$LuaClosure.$i;
    var2 = new org$luaj$vm2$LuaClosure();
    var3 = var0;
    org$luaj$vm2$LuaClosure.prototype.V$$init$$Lorg$luaj$vm2$Prototype$$Lorg$luaj$vm2$LuaValue$.call(var2,var3,var1);
    return var2;
  }

  Lorg$luaj$vm2$Prototype$$compile$Ljava$io$InputStream$$Ljava$lang$String$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var0 = arg0;
    var1 = new org$luaj$vm2$compiler$LuaC$CompileState();
    org$luaj$vm2$compiler$LuaC$CompileState.prototype.V$$init$$$.call(var1);
    var2 = arg1;
    var3 = (org$luaj$vm2$compiler$LuaC$CompileState.Lorg$luaj$vm2$Prototype$$access$000$Lorg$luaj$vm2$compiler$LuaC$CompileState$$Ljava$io$InputStream$$Ljava$lang$String$(var1,var0,var2));
    return var3;
  }
}


class java$util$concurrent$ConcurrentHashMap extends java$util$AbstractMap {
  nativeObject = null;

  delegate = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$concurrent$ConcurrentHashMap,[java$util$concurrent$ConcurrentHashMap,java$lang$Object,java$util$concurrent$ConcurrentMap,java$io$Serializable,java$util$Map,java$util$AbstractMap]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$I(arg0) {
    // source file is ConcurrentHashMap.java
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var0 = (arg0) | 0;
    // line number 42
    java$util$AbstractMap.prototype.V$$init$$$.call(this);
    // line number 43
    var1 = this;
    var2 = new java$util$HashMap();
    var3 = (var0) | 0;
    java$util$HashMap.prototype.V$$init$$I.call(var2,var3);
    var1.delegate = var2;
    // line number 44
    return;
  }

  Ljava$lang$Object$$put$Ljava$lang$Object$$Ljava$lang$Object$(arg0,arg1) {
    // source file is ConcurrentHashMap.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var0 = arg0;
    // line number 141
    var1 = (this.delegate);
    var2 = arg1;
    var3 = (var1.Ljava$lang$Object$$put$Ljava$lang$Object$$Ljava$lang$Object$(var0,var2));
    return var3;
  }

  Ljava$lang$Object$$get$Ljava$lang$Object$(arg0) {
    // source file is ConcurrentHashMap.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    // line number 136
    var1 = (this.delegate);
    var2 = (var1.Ljava$lang$Object$$get$Ljava$lang$Object$(var0));
    return var2;
  }

  V$$init$$$() {
    // source file is ConcurrentHashMap.java
    var var0 = null;
    var var1 = null;
    // line number 38
    java$util$AbstractMap.prototype.V$$init$$$.call(this);
    // line number 39
    var0 = this;
    var1 = new java$util$HashMap();
    java$util$HashMap.prototype.V$$init$$$.call(var1);
    var0.delegate = var1;
    // line number 40
    return;
  }

  Ljava$lang$Object$$computeIfAbsent$Ljava$lang$Object$$Ljava$util$function$Function$(arg0,arg1) {
    // source file is ConcurrentHashMap.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var0 = arg0;
    // line number 96
    var1 = (this.delegate);
    var2 = arg1;
    var3 = (var1.Ljava$lang$Object$$computeIfAbsent$Ljava$lang$Object$$Ljava$util$function$Function$(var0,var2));
    return var3;
  }

  Ljava$lang$String$$toString$$() {
    // source file is ConcurrentHashMap.java
    var var0 = null;
    var var1 = null;
    // line number 181
    var0 = (this.delegate);
    var1 = (var0.Ljava$lang$String$$toString$$());
    return var1;
  }

  Z$equals$Ljava$lang$Object$(arg0) {
    // source file is ConcurrentHashMap.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var0 = arg0;
    // line number 171
    var1 = (this.delegate);
    var2 = (var1.Z$equals$Ljava$lang$Object$(var0));
    return var2;
  }

  I$hashCode$$() {
    // source file is ConcurrentHashMap.java
    var var0 = null;
    var var1 = 0;
    // line number 176
    var0 = (this.delegate);
    var1 = ((var0.I$hashCode$$())) | 0;
    return var1;
  }

  Ljava$util$Set$$entrySet$$() {
    // source file is ConcurrentHashMap.java
    var var0 = null;
    var var1 = null;
    // line number 61
    var0 = (this.delegate);
    var1 = (var0.Ljava$util$Set$$entrySet$$());
    return var1;
  }

  I$size$$() {
    // source file is ConcurrentHashMap.java
    var var0 = null;
    var var1 = 0;
    // line number 116
    var0 = (this.delegate);
    var1 = ((var0.I$size$$())) | 0;
    return var1;
  }

  Z$containsKey$Ljava$lang$Object$(arg0) {
    // source file is ConcurrentHashMap.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var0 = arg0;
    // line number 131
    var1 = (this.delegate);
    var2 = (var1.Z$containsKey$Ljava$lang$Object$(var0));
    return var2;
  }

  Z$isEmpty$$() {
    // source file is ConcurrentHashMap.java
    var var0 = null;
    var var1 = 0;
    // line number 121
    var0 = (this.delegate);
    var1 = (var0.Z$isEmpty$$());
    return var1;
  }
}


class java$util$ImmutableCollections$ListItr extends java$lang$Object {
  nativeObject = null;

  list = null;
  size = 0;
  cursor = 0;
  isListIterator = false;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$ImmutableCollections$ListItr,[java$util$Iterator,java$lang$Object,java$util$ImmutableCollections$ListItr,java$util$ListIterator]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Ljava$util$List$$I(arg0,arg1) {
    // source file is ImmutableCollections.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var0 = arg0;
    // line number 350
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 351
    var1 = this;
    var1.list = var0;
    // line number 352
    var2 = this;
    var2.size = arg1;
    // line number 353
    var3 = this;
    var3.cursor = 0;
    // line number 354
    var4 = this;
    var4.isListIterator = 0;
    // line number 355
    return;
  }

  Z$hasNext$$() {
    // source file is ImmutableCollections.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var phi3 = null;
    var phi4 = 0;
    // line number 365
    var0 = ((this.cursor)) | 0;
    var1 = ((this.size)) | 0;
    If_10_0: {
     if (var0 == var1) {
      phi3 = this;
      phi4 = (0) | 0;
      break If_10_0;
     } else {
      var2 = (1) | 0;
      // Here was a goto statement
      phi3 = this;
      phi4 = (var2) | 0;
      break If_10_0;
     }
    }
    return phi4;
  }

  Ljava$lang$Object$$next$$() {
    // source file is ImmutableCollections.java
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = 0;
    TryCatch_2_0: {
     try {
      // line number 370
      var1 = ((this.cursor)) | 0;
      // line number 371
      var2 = (this.list);
      var3 = (var2.Ljava$lang$Object$$get$I(var1));
      // line number 372
      var4 = this;
      var5 = (1) | 0;
      var6 = ((var1 + var5)) | 0;
      var4.cursor = var6;
      // line number 373
      break TryCatch_2_0;
     } catch (__ex) {
      if (__ex instanceof java$lang$IndexOutOfBoundsException) {
       // line number 374
       // line number 375
       var0 = new java$util$NoSuchElementException();
       java$util$NoSuchElementException.prototype.V$$init$$$.call(var0);
       throw bytecoder.registerStack(var0, new Error().stack);
      }
      throw __ex;
     }
    }
    return var3;
  }

  I$previousIndex$$() {
    // source file is ImmutableCollections.java
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    // line number 412
    var0 = (this.isListIterator);
    if (var0 != 0) {
     // line number 415
     var2 = ((this.cursor)) | 0;
     var3 = ((var2 - 1)) | 0;
     return var3;
    } else {
     // line number 413
     java$util$ImmutableCollections.$i;
     var1 = (java$util$ImmutableCollections.Ljava$lang$UnsupportedOperationException$$uoe$$());
     throw bytecoder.registerStack(var1, new Error().stack);
    }
  }
}


class java$io$Reader extends java$lang$Object {
  nativeObject = null;

  skipBuffer = null;
  lock = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$io$Reader,[java$io$Reader,java$lang$Readable,java$lang$Object,java$lang$AutoCloseable,java$io$Closeable]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
    this.I$read$$C$I$I = impl;
  }

  V$$init$$$() {
    // source file is Reader.java
    var var0 = null;
    var var1 = null;
    // line number 156
    java$lang$Object.prototype.V$$init$$$.call(this);
    // line number 297
    var0 = this;
    var0.skipBuffer = null;
    // line number 157
    var1 = this;
    var1.lock = this;
    // line number 158
    return;
  }

  I$read$$C(arg0) {
    // source file is Reader.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var0 = arg0;
    // line number 265
    var1 = var0;
    var2 = (var0.data.length) | 0;
    var3 = ((this.I$read$$C$I$I(var1,0,var2))) | 0;
    return var3;
  }

  I$read$$() {
    // source file is Reader.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    // line number 239
    var0 = bytecoder.newarray((1),0);
    // line number 240
    var1 = (0) | 0;
    var2 = ((this.I$read$$C$I$I(var0,var1,1))) | 0;
    if (var2 != -1) {
     // line number 243
     var3 = (0) | 0;
     var4 = (var0.data[var3]);
     return var4;
    } else {
     // line number 241
     return -1;
    }
  }
}


class java$io$IOException extends java$lang$Exception {
  nativeObject = null;
  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$io$IOException,[java$lang$Object,java$io$IOException,java$lang$Exception,java$lang$Throwable]);
    }
    return this.#rt;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$Ljava$lang$String$(arg0) {
    // source file is IOException.java
    var var0 = null;
    var var1 = null;
    var0 = arg0;
    // line number 57
    var1 = var0;
    java$lang$Exception.prototype.V$$init$$Ljava$lang$String$.call(this,var1);
    // line number 58
    return;
  }

  V$$init$$$() {
    // source file is IOException.java
    // line number 46
    java$lang$Exception.prototype.V$$init$$$.call(this);
    // line number 47
    return;
  }

  V$$init$$Ljava$lang$Throwable$(arg0) {
    // source file is IOException.java
    var var0 = null;
    var var1 = null;
    var0 = arg0;
    // line number 98
    var1 = var0;
    java$lang$Exception.prototype.V$$init$$Ljava$lang$Throwable$.call(this,var1);
    // line number 99
    return;
  }
}


class java$util$Properties extends java$util$Hashtable {
  nativeObject = null;

  static UNSAFE = null;
  map = null;
  defaults = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$Properties,[java$lang$Object,java$util$Hashtable,java$lang$Cloneable,java$io$Serializable,java$util$Properties,java$util$Dictionary,java$util$Map]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is Properties.java
    var var0 = null;
    // line number 151
    jdk$internal$misc$Unsafe.$i;
    var0 = (jdk$internal$misc$Unsafe.Ljdk$internal$misc$Unsafe$$getUnsafe$$());
    java$util$Properties.$i;
    java$util$Properties.UNSAFE = var0;
    return;
  }

  V$$init$$$() {
    // source file is Properties.java
    var var0 = null;
    // line number 176
    var0 = null;
    java$util$Properties.prototype.V$$init$$Ljava$util$Properties$$I.call(this,var0,8);
    // line number 177
    return;
  }

  V$$init$$Ljava$util$Properties$$I(arg0,arg1) {
    // source file is Properties.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var0 = arg0;
    // line number 208
    var1 = null;
    var2 = var1;
    java$util$Hashtable.prototype.V$$init$$Ljava$lang$Void$.call(this,var2);
    // line number 209
    var3 = this;
    var4 = new java$util$concurrent$ConcurrentHashMap();
    var5 = (arg1) | 0;
    java$util$concurrent$ConcurrentHashMap.prototype.V$$init$$I.call(var4,var5);
    var3.map = var4;
    // line number 210
    var6 = this;
    var6.defaults = var0;
    // line number 213
    java$util$Properties.$i;
    var7 = (java$util$Properties.UNSAFE);
    jdk$internal$misc$Unsafe.prototype.V$storeFence$$.call(var7);
    // line number 214
    return;
  }

  Ljava$lang$Object$$setProperty$Ljava$lang$String$$Ljava$lang$String$(arg0,arg1) {
    // source file is Properties.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    // line number 230
    var1 = var0;
    var2 = (java$util$Properties.prototype.Ljava$lang$Object$$put$Ljava$lang$Object$$Ljava$lang$Object$.call(this,var1,arg1));
    return var2;
  }

  Ljava$lang$Object$$put$Ljava$lang$Object$$Ljava$lang$Object$(arg0,arg1) {
    // source file is Properties.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var0 = arg0;
    // line number 1340
    var1 = (this.map);
    var2 = arg1;
    var3 = (java$util$concurrent$ConcurrentHashMap.prototype.Ljava$lang$Object$$put$Ljava$lang$Object$$Ljava$lang$Object$.call(var1,var0,var2));
    return var3;
  }

  Ljava$lang$String$$getProperty$Ljava$lang$String$(arg0) {
    // source file is Properties.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var phi6 = null;
    var phi7 = null;
    var phi8 = null;
    var phi9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var phi17 = null;
    var phi18 = null;
    var phi19 = null;
    var phi20 = null;
    var phi21 = null;
    var var22 = null;
    var0 = arg0;
    // line number 1141
    var1 = (this.map);
    var2 = (java$util$concurrent$ConcurrentHashMap.prototype.Ljava$lang$Object$$get$Ljava$lang$Object$.call(var1,var0));
    // line number 1142
    var3 = (bytecoder.instanceOf(var2,java$lang$String)) | 0;
    If_19_0: {
     if (var3 == 0) {
      phi6 = this;
      phi7 = var0;
      phi8 = var2;
      phi9 = null;
      break If_19_0;
     } else {
      var4 = var2;
      var5 = var4;
      // Here was a goto statement
      phi6 = this;
      phi7 = var0;
      phi8 = var2;
      phi9 = var5;
      break If_19_0;
     }
    }
    var10 = phi9;
    // line number 1144
    If_38_0: {
     If_38_1: {
      if (var10 != null) {
       phi20 = var10;
       break If_38_1;
      } else {
       var11 = phi6;
       var12 = (var11.defaults);
       var13 = var12;
       if (var12 == null) {
        phi20 = var10;
        phi21 = var13;
        break If_38_1;
       } else {
        var14 = var13;
        var15 = phi7;
        var16 = (java$util$Properties.prototype.Ljava$lang$String$$getProperty$Ljava$lang$String$.call(var14,var15));
        // Here was a goto statement
        phi17 = var10;
        phi18 = var13;
        phi19 = var16;
        break If_38_0;
       }
      }
     }
     var22 = phi20;
     phi17 = phi20;
     phi18 = phi21;
     phi19 = var22;
     break If_38_0;
    }
    return phi19;
  }

  Ljava$lang$Object$$get$Ljava$lang$Object$(arg0) {
    // source file is Properties.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = arg0;
    // line number 1335
    var1 = (this.map);
    var2 = (java$util$concurrent$ConcurrentHashMap.prototype.Ljava$lang$Object$$get$Ljava$lang$Object$.call(var1,var0));
    return var2;
  }

  Ljava$lang$Object$$computeIfAbsent$Ljava$lang$Object$$Ljava$util$function$Function$(arg0,arg1) {
    // source file is Properties.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var0 = arg0;
    // line number 1492
    var1 = (this.map);
    var2 = arg1;
    var3 = (java$util$concurrent$ConcurrentHashMap.prototype.Ljava$lang$Object$$computeIfAbsent$Ljava$lang$Object$$Ljava$util$function$Function$.call(var1,var0,var2));
    return var3;
  }

  Ljava$lang$String$$toString$$() {
    // source file is Properties.java
    var var0 = null;
    var var1 = null;
    // line number 1360
    var0 = (this.map);
    var1 = (java$util$concurrent$ConcurrentHashMap.prototype.Ljava$lang$String$$toString$$.call(var0));
    return var1;
  }

  Z$equals$Ljava$lang$Object$(arg0) {
    // source file is Properties.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var0 = arg0;
    // line number 1446
    var1 = (this.map);
    var2 = (java$util$concurrent$ConcurrentHashMap.prototype.Z$equals$Ljava$lang$Object$.call(var1,var0));
    return var2;
  }

  I$hashCode$$() {
    // source file is Properties.java
    var var0 = null;
    var var1 = 0;
    // line number 1451
    var0 = (this.map);
    var1 = ((java$util$concurrent$ConcurrentHashMap.prototype.I$hashCode$$.call(var0))) | 0;
    return var1;
  }

  I$size$$() {
    // source file is Properties.java
    var var0 = null;
    var var1 = 0;
    // line number 1298
    var0 = (this.map);
    var1 = ((java$util$concurrent$ConcurrentHashMap.prototype.I$size$$.call(var0))) | 0;
    return var1;
  }

  Z$containsKey$Ljava$lang$Object$(arg0) {
    // source file is Properties.java
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var0 = arg0;
    // line number 1330
    var1 = (this.map);
    var2 = (java$util$concurrent$ConcurrentHashMap.prototype.Z$containsKey$Ljava$lang$Object$.call(var1,var0));
    return var2;
  }

  Ljava$util$Set$$entrySet$$() {
    // source file is Properties.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    // line number 1375
    var0 = new java$util$Properties$EntrySet();
    var1 = this;
    var2 = (var1.map);
    var3 = (java$util$concurrent$ConcurrentHashMap.prototype.Ljava$util$Set$$entrySet$$.call(var2));
    java$util$Properties$EntrySet.prototype.V$$init$$Ljava$util$Set$.call(var0,var3);
    java$util$Collections.$i;
    var4 = (java$util$Collections.Ljava$util$Set$$synchronizedSet$Ljava$util$Set$$Ljava$lang$Object$(var0,this));
    return var4;
  }

  V$rehash$$() {
    // source file is Properties.java
    // line number 1517
    return;
  }

  Z$isEmpty$$() {
    // source file is Properties.java
    var var0 = null;
    var var1 = 0;
    // line number 1303
    var0 = (this.map);
    var1 = (java$util$concurrent$ConcurrentHashMap.prototype.Z$isEmpty$$.call(var0));
    return var1;
  }
}


class org$luaj$vm2$WeakTable$WeakValue extends org$luaj$vm2$LuaValue {
  nativeObject = null;

  ref = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$WeakTable$WeakValue,[org$luaj$vm2$LuaValue,java$lang$Object,org$luaj$vm2$WeakTable$WeakValue,org$luaj$vm2$Varargs]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      org$luaj$vm2$LuaValue.$i;
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  Lorg$luaj$vm2$LuaValue$$strongvalue$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var0 = (this.ref);
    var1 = (var0.Ljava$lang$Object$$get$$());
    var2 = var1;
    var3 = var2;
    return var3;
  }

  V$$init$$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var0 = arg0;
    org$luaj$vm2$LuaValue.prototype.V$$init$$$.call(this);
    var1 = this;
    var2 = new java$lang$ref$WeakReference();
    var3 = var0;
    java$lang$ref$WeakReference.prototype.V$$init$$Ljava$lang$Object$.call(var2,var3);
    var1.ref = var2;
    return;
  }

  Ljava$lang$String$$toString$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var0 = new java$lang$StringBuffer();
    java$lang$StringBuffer.prototype.V$$init$$$.call(var0);
    var1 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var0,bytecoder.stringconstants[444]));
    var2 = (this.ref);
    var3 = (var2.Ljava$lang$Object$$get$$());
    var4 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$Object$.call(var1,var3));
    var5 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var4,bytecoder.stringconstants[206]));
    var6 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var5));
    return var6;
  }

  Ljava$lang$String$$typename$$() {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var0 = bytecoder.stringconstants[447];
    var1 = (this.Lorg$luaj$vm2$LuaValue$$illegal$Ljava$lang$String$$Ljava$lang$String$(var0,bytecoder.stringconstants[448]));
    var2 = null;
    return var2;
  }

  I$type$$() {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var0 = bytecoder.stringconstants[451];
    var1 = (this.Lorg$luaj$vm2$LuaValue$$illegal$Ljava$lang$String$$Ljava$lang$String$(var0,bytecoder.stringconstants[448]));
    var2 = (0) | 0;
    return var2;
  }

  Z$raweq$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var phi8 = null;
    var phi9 = null;
    var phi10 = null;
    var phi11 = 0;
    var phi12 = null;
    var phi13 = null;
    var phi14 = null;
    var0 = arg0;
    var1 = (this.ref);
    var2 = (var1.Ljava$lang$Object$$get$$());
    var3 = var2;
    If_13_0: {
     If_13_1: {
      if (var3 == null) {
       phi12 = this;
       phi13 = var0;
       phi14 = var2;
       break If_13_1;
      } else {
       var4 = var0;
       var5 = var2;
       var6 = (var4.Z$raweq$Lorg$luaj$vm2$LuaValue$(var5));
       if (var6 == 0) {
        phi12 = this;
        phi13 = var0;
        phi14 = var2;
        break If_13_1;
       } else {
        var7 = (1) | 0;
        // Here was a goto statement
        phi8 = this;
        phi9 = var0;
        phi10 = var2;
        phi11 = (var7) | 0;
        break If_13_0;
       }
      }
     }
     phi8 = phi12;
     phi9 = phi13;
     phi10 = phi14;
     phi11 = (0) | 0;
     break If_13_0;
    }
    return phi11;
  }
}


class java$lang$Long extends java$lang$Number {
  nativeObject = null;

  static TYPE = null;
  value = 0;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$lang$Long,[java$lang$Object,java$lang$Long,java$lang$Comparable,java$io$Serializable,java$lang$Number]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is Long.java
    var var0 = null;
    // line number 26
    var0 = bytecoder.primitives.long;
    java$lang$Long.$i;
    java$lang$Long.TYPE = var0;
    return;
  }

  static Ljava$lang$Long$$valueOf$J(arg0) {
    // source file is Long.java
    var var0 = null;
    var var1 = 0;
    // line number 79
    java$lang$Long.$i;
    var0 = new java$lang$Long();
    var1 = arg0;
    java$lang$Long.prototype.V$$init$$J.call(var0,var1);
    return var0;
  }

  V$$init$$J(arg0) {
    // source file is Long.java
    var var0 = 0;
    var var1 = null;
    var0 = arg0;
    // line number 31
    java$lang$Number.prototype.V$$init$$$.call(this);
    // line number 32
    var1 = this;
    var1.value = var0;
    // line number 33
    return;
  }

  static I$numberOfLeadingZeros$J(arg0) {
    // source file is Long.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var phi7 = 0;
    var phi8 = 0;
    var phi9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    // line number 105
    var0 = (32) | 0;
    var1 = (arg0 >>> var0);
    var2 = ((var1 | 0)) | 0;
    // line number 106
    If_15_0: {
     if (var2 != 0) {
      var10 = (var2) | 0;
      java$lang$Integer.$i;
      var11 = ((java$lang$Integer.I$numberOfLeadingZeros$I(var10))) | 0;
      var12 = ((32 + var11)) | 0;
      phi7 = arg0;
      phi8 = (var2) | 0;
      phi9 = (var12) | 0;
      break If_15_0;
     } else {
      var3 = (32) | 0;
      var4 = ((arg0 | 0)) | 0;
      java$lang$Integer.$i;
      var5 = ((java$lang$Integer.I$numberOfLeadingZeros$I(var4))) | 0;
      var6 = ((var3 + var5)) | 0;
      // Here was a goto statement
      phi7 = arg0;
      phi8 = (var2) | 0;
      phi9 = (var6) | 0;
      break If_15_0;
     }
    }
    return phi9;
  }

  static I$numberOfTrailingZeros$J(arg0) {
    // source file is Long.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var phi7 = 0;
    var phi8 = 0;
    var phi9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    // line number 110
    var0 = ((arg0 | 0)) | 0;
    // line number 111
    If_9_0: {
     if (var0 != 0) {
      var10 = (var0) | 0;
      java$lang$Integer.$i;
      var11 = ((java$lang$Integer.I$numberOfTrailingZeros$I(var10))) | 0;
      var12 = ((32 + var11)) | 0;
      phi7 = arg0;
      phi8 = (var0) | 0;
      phi9 = (var12) | 0;
      break If_9_0;
     } else {
      var1 = (32) | 0;
      var2 = (32) | 0;
      var3 = (arg0 >>> var2);
      var4 = ((var3 | 0)) | 0;
      java$lang$Integer.$i;
      var5 = ((java$lang$Integer.I$numberOfTrailingZeros$I(var4))) | 0;
      var6 = ((var1 + var5)) | 0;
      // Here was a goto statement
      phi7 = arg0;
      phi8 = (var0) | 0;
      phi9 = (var6) | 0;
      break If_9_0;
     }
    }
    return phi9;
  }

  I$compareTo$Ljava$lang$Object$(arg0) {
    // source file is Long.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var0 = arg0;
    // line number 23
    var1 = var0;
    var2 = var1;
    var3 = ((java$lang$Long.prototype.I$compareTo$Ljava$lang$Long$.call(this,var2))) | 0;
    return var3;
  }

  I$compareTo$Ljava$lang$Long$(arg0) {
    // source file is Long.java
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var0 = arg0;
    // line number 137
    var1 = (this.value);
    var2 = (java$lang$Long.prototype.J$longValue$$.call(var0));
    java$lang$Long.$i;
    var3 = ((java$lang$Long.I$compare$J$J(var1,var2))) | 0;
    return var3;
  }

  J$longValue$$() {
    // source file is Long.java
    var var0 = 0;
    // line number 52
    var0 = (this.value);
    return var0;
  }

  static I$compare$J$J(arg0,arg1) {
    // source file is Long.java
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var phi4 = 0;
    var phi5 = 0;
    var phi6 = 0;
    var var7 = 0;
    var var8 = 0;
    var0 = arg1;
    // line number 141
    var1 = var0;
    var2 = (bytecoder.cmp(arg0,var1)) | 0;
    If_12_0: {
     if (var2 >= 0) {
      var7 = (bytecoder.cmp(arg0,var0)) | 0;
      if (var7 != 0) {
       phi4 = arg0;
       phi5 = var0;
       phi6 = (1) | 0;
       break If_12_0;
      } else {
       var8 = (0) | 0;
       // Here was a goto statement
       phi4 = arg0;
       phi5 = var0;
       phi6 = (var8) | 0;
       break If_12_0;
      }
     } else {
      var3 = (-1) | 0;
      // Here was a goto statement
      phi4 = arg0;
      phi5 = var0;
      phi6 = (var3) | 0;
      break If_12_0;
     }
    }
    return phi6;
  }

  I$intValue$$() {
    // source file is Long.java
    var var0 = 0;
    var var1 = 0;
    // line number 42
    var0 = (this.value);
    var1 = ((var0 | 0)) | 0;
    return var1;
  }

  Ljava$lang$String$$toString$$() {
    // source file is Long.java
    var var0 = 0;
    var var1 = null;
    // line number 75
    var0 = (this.value);
    java$lang$Long.$i;
    var1 = (java$lang$Long.Ljava$lang$String$$toString$J$I(var0,10));
    return var1;
  }

  static Ljava$lang$String$$toString$J$I(arg0,arg1) {
    return bytecoder.imports['java.lang.Long'].Ljava$lang$String$$toString$J$I(arg0, arg1);
  }

  Z$equals$Ljava$lang$Object$(arg0) {
    // source file is Long.java
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var phi5 = null;
    var phi6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var phi12 = null;
    var phi13 = null;
    var phi14 = null;
    var phi15 = 0;
    var0 = arg0;
    // line number 62
    var1 = var0;
    if (this != var1) {
     // line number 65
     If_18_0: {
      if (var0 == null) {
       phi5 = this;
       phi6 = var0;
       break If_18_0;
      } else {
       var2 = this;
       var3 = ((var2).constructor.$rt);
       var4 = ((var0).constructor.$rt);
       if (var3 == var4) {
        // line number 68
        var7 = var0;
        // line number 70
        var8 = (this.value);
        var9 = (java$lang$Long.prototype.J$longValue$$.call(var7));
        var10 = (bytecoder.cmp(var8,var9)) | 0;
        If_54_0: {
         if (var10 != 0) {
          phi12 = this;
          phi13 = var0;
          phi14 = var7;
          phi15 = (0) | 0;
          break If_54_0;
         } else {
          var11 = (1) | 0;
          // Here was a goto statement
          phi12 = this;
          phi13 = var0;
          phi14 = var7;
          phi15 = (var11) | 0;
          break If_54_0;
         }
        }
        return phi15;
       } else {
        phi5 = this;
        phi6 = var0;
        break If_18_0;
       }
      }
     }
     // line number 66
     return 0;
    } else {
     // line number 63
     return 1;
    }
  }

  I$hashCode$$() {
    // source file is Long.java
    var var0 = 0;
    var var1 = 0;
    // line number 37
    var0 = (this.value);
    var1 = ((var0 | 0)) | 0;
    return var1;
  }

  static Ljava$lang$String$$toString$J(arg0) {
    // source file is Long.java
    var var0 = 0;
    var var1 = null;
    // line number 95
    var0 = (10) | 0;
    java$lang$Long.$i;
    var1 = (java$lang$Long.Ljava$lang$String$$toString$J$I(arg0,var0));
    return var1;
  }
}


class java$util$Collections$EmptyListIterator extends java$util$Collections$EmptyIterator {
  nativeObject = null;

  static EMPTY_ITERATOR = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(java$util$Collections$EmptyListIterator,[java$util$Iterator,java$lang$Object,java$util$Collections$EmptyIterator,java$util$ListIterator,java$util$Collections$EmptyListIterator]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      java$util$Collections$EmptyIterator.$i;
      this.V$$clinit$$$();
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  static V$$clinit$$$() {
    // source file is Collections.java
    var var0 = null;
    // line number 4355
    java$util$Collections$EmptyListIterator.$i;
    var0 = new java$util$Collections$EmptyListIterator();
    java$util$Collections$EmptyListIterator.prototype.V$$init$$$.call(var0);
    java$util$Collections$EmptyListIterator.EMPTY_ITERATOR = var0;
    return;
  }

  V$$init$$$() {
    // source file is Collections.java
    // line number 4351
    java$util$Collections$EmptyIterator.prototype.V$$init$$$.call(this);
    return;
  }

  I$previousIndex$$() {
    // source file is Collections.java
    // line number 4361
    return -1;
  }
}


class org$luaj$vm2$compiler$FuncState extends org$luaj$vm2$compiler$Constants {
  nativeObject = null;

  f = null;
  prev = null;
  ls = null;
  pc = 0;
  lasttarget = 0;
  jpc = null;
  freereg = 0;
  nk = 0;
  np = 0;
  nups = 0;
  nlocvars = 0;
  nactvar = 0;
  firstlocal = 0;
  bl = null;
  L = null;
  h = null;

  constructor() {
    super();
  }

  static #rt = undefined;
  static get $rt() {
    if (!this.#rt) {
      this.#rt = bytecoder.newRuntimeClassFor(org$luaj$vm2$compiler$FuncState,[java$lang$Object,org$luaj$vm2$compiler$FuncState,org$luaj$vm2$Lua,org$luaj$vm2$compiler$Constants]);
    }
    return this.#rt;
  }

  static #iguard = false;
  static get $i() {
    if (!this.#iguard) {
      this.#iguard = true;
      org$luaj$vm2$compiler$Constants.$i;
    }
    return this;
  }

  set $lambdaimpl(impl) {
  }

  V$$init$$$() {
    org$luaj$vm2$compiler$Constants.prototype.V$$init$$$.call(this);
    return;
  }

  V$enterblock$Lorg$luaj$vm2$compiler$FuncState$BlockCnt$$Z(arg0,arg1) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = 0;
    var var9 = null;
    var var10 = null;
    var var11 = 0;
    var var12 = 0;
    var var13 = null;
    var var14 = null;
    var var15 = 0;
    var var16 = 0;
    var var17 = 0;
    var phi18 = null;
    var phi19 = null;
    var phi20 = 0;
    var phi21 = 0;
    var0 = arg0;
    var1 = arg1;
    var0.isloop = var1;
    var2 = this;
    var3 = (var2.nactvar);
    var0.nactvar = var3;
    var4 = this;
    var5 = (var4.ls);
    var6 = (var5.dyd);
    var7 = ((var6.n_label)) | 0;
    var8 = var7;
    var0.firstlabel = var8;
    var9 = (this.ls);
    var10 = (var9.dyd);
    var11 = ((var10.n_gt)) | 0;
    var12 = var11;
    var0.firstgoto = var12;
    var0.upval = 0;
    var13 = (this.bl);
    var0.previous = var13;
    var14 = this;
    var14.bl = var0;
    var15 = (this.freereg);
    var16 = (this.nactvar);
    If_58_0: {
     if (var15 != var16) {
      phi18 = this;
      phi19 = var0;
      phi20 = arg1;
      phi21 = (0) | 0;
      break If_58_0;
     } else {
      var17 = (1) | 0;
      // Here was a goto statement
      phi18 = this;
      phi19 = var0;
      phi20 = arg1;
      phi21 = (var17) | 0;
      break If_58_0;
     }
    }
    org$luaj$vm2$compiler$FuncState.$i;
    org$luaj$vm2$compiler$Constants.V$_assert$Z(phi21);
    return;
  }

  I$newupvalue$Lorg$luaj$vm2$LuaString$$Lorg$luaj$vm2$compiler$LexState$expdesc$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = 0;
    var var10 = null;
    var var11 = null;
    var var12 = 0;
    var phi13 = null;
    var phi14 = null;
    var phi15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = 0;
    var var23 = null;
    var var24 = 0;
    var var25 = 0;
    var phi26 = null;
    var phi27 = null;
    var phi28 = 0;
    var var29 = null;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = null;
    var var34 = 0;
    var var35 = null;
    var var36 = null;
    var var37 = null;
    var var38 = 0;
    var var39 = 0;
    var phi40 = null;
    var phi41 = 0;
    var phi42 = null;
    var phi43 = null;
    var phi44 = null;
    var phi45 = 0;
    var var46 = null;
    var var47 = null;
    var var48 = 0;
    var var49 = null;
    var var50 = 0;
    var var51 = 0;
    var var52 = 0;
    var var53 = 0;
    var0 = arg0;
    var1 = this;
    var2 = (var1.nups);
    var3 = ((var2 + 1)) | 0;
    var4 = bytecoder.stringconstants[329];
    org$luaj$vm2$compiler$FuncState.prototype.V$checklimit$I$I$Ljava$lang$String$.call(this,var3,255,var4);
    var5 = (this.f);
    var6 = (var5.upvalues);
    If_26_0: {
     If_26_1: {
      if (var6 == null) {
       phi13 = this;
       phi14 = var0;
       phi15 = arg1;
       break If_26_1;
      } else {
       var7 = this;
       var8 = (var7.nups);
       var9 = ((var8 + 1)) | 0;
       var10 = (this.f);
       var11 = (var10.upvalues);
       var12 = (var11.data.length) | 0;
       if (var9 <= var12) {
        phi13 = this;
        phi14 = var0;
        phi15 = arg1;
        break If_26_0;
       } else {
        phi13 = this;
        phi14 = var0;
        phi15 = arg1;
        break If_26_1;
       }
      }
     }
     var16 = phi13;
     var17 = (var16.f);
     var18 = phi13;
     var19 = (var18.f);
     var20 = (var19.upvalues);
     var21 = phi13;
     var22 = (var21.nups);
     If_70_0: {
      if (var22 <= 0) {
       phi26 = var17;
       phi27 = var20;
       phi28 = (1) | 0;
       break If_70_0;
      } else {
       var23 = phi13;
       var24 = (var23.nups);
       var25 = ((var24 * 2)) | 0;
       // Here was a goto statement
       phi26 = var17;
       phi27 = var20;
       phi28 = (var25) | 0;
       break If_70_0;
      }
     }
     org$luaj$vm2$compiler$FuncState.$i;
     var29 = (org$luaj$vm2$compiler$Constants.$Lorg$luaj$vm2$Upvaldesc$$realloc$$Lorg$luaj$vm2$Upvaldesc$$I(phi27,phi28));
     phi26.upvalues = var29;
     break If_26_0;
    }
    var30 = phi13;
    var31 = (var30.f);
    var32 = (var31.upvalues);
    var33 = phi13;
    var34 = (var33.nups);
    var35 = new org$luaj$vm2$Upvaldesc();
    var36 = phi14;
    var37 = phi15;
    var38 = ((var37.k)) | 0;
    If_120_0: {
     if (var38 != 7) {
      phi40 = var32;
      phi41 = var34;
      phi42 = var35;
      phi43 = var35;
      phi44 = var36;
      phi45 = (0) | 0;
      break If_120_0;
     } else {
      var39 = (1) | 0;
      // Here was a goto statement
      phi40 = var32;
      phi41 = var34;
      phi42 = var35;
      phi43 = var35;
      phi44 = var36;
      phi45 = (var39) | 0;
      break If_120_0;
     }
    }
    var46 = phi15;
    var47 = (var46.u);
    var48 = ((var47.info)) | 0;
    org$luaj$vm2$Upvaldesc.prototype.V$$init$$Lorg$luaj$vm2$LuaString$$Z$I.call(phi43,phi44,phi45,var48);
    phi40.data[phi41] = phi42;
    var49 = phi13;
    var50 = (var49.nups);
    var51 = (1) | 0;
    var52 = ((var50 + var51)) | 0;
    var53 = var52;
    var49.nups = var53;
    return var50;
  }

  V$checklimit$I$I$Ljava$lang$String$(arg0,arg1,arg2) {
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var phi5 = null;
    var phi6 = 0;
    var phi7 = 0;
    var phi8 = null;
    var0 = (arg0) | 0;
    var1 = arg2;
    var2 = (arg1) | 0;
    If_11_0: {
     if (var0 <= var2) {
      phi5 = this;
      phi6 = (var0) | 0;
      phi7 = (arg1) | 0;
      phi8 = var1;
      break If_11_0;
     } else {
      var3 = this;
      var4 = var1;
      org$luaj$vm2$compiler$FuncState.prototype.V$errorlimit$I$Ljava$lang$String$.call(var3,arg1,var4);
      phi5 = this;
      phi6 = (var0) | 0;
      phi7 = (arg1) | 0;
      phi8 = var1;
      break If_11_0;
     }
    }
    return;
  }

  V$errorlimit$I$Ljava$lang$String$(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var phi12 = null;
    var phi13 = 0;
    var phi14 = null;
    var phi15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = 0;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = 0;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = null;
    var var31 = null;
    var0 = (arg0) | 0;
    var1 = (this.f);
    var2 = ((var1.linedefined)) | 0;
    If_12_0: {
     if (var2 != 0) {
      var20 = (this.L);
      var21 = new java$lang$StringBuffer();
      java$lang$StringBuffer.prototype.V$$init$$$.call(var21);
      var22 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var21,bytecoder.stringconstants[336]));
      var23 = (this.f);
      var24 = ((var23.linedefined)) | 0;
      var25 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var22,var24));
      var26 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var25,bytecoder.stringconstants[337]));
      var27 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var26,var0));
      var28 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var27,bytecoder.stringconstants[141]));
      var29 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var28,arg1));
      var30 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var29));
      var31 = (org$luaj$vm2$compiler$LuaC$CompileState.prototype.Ljava$lang$String$$pushfstring$Ljava$lang$String$.call(var20,var30));
      phi12 = this;
      phi13 = (var0) | 0;
      phi14 = arg1;
      phi15 = var31;
      break If_12_0;
     } else {
      var3 = this;
      var4 = (var3.L);
      var5 = new java$lang$StringBuffer();
      java$lang$StringBuffer.prototype.V$$init$$$.call(var5);
      var6 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var5,bytecoder.stringconstants[330]));
      var7 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$I.call(var6,var0));
      var8 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var7,bytecoder.stringconstants[141]));
      var9 = (java$lang$StringBuffer.prototype.Ljava$lang$StringBuffer$$append$Ljava$lang$String$.call(var8,arg1));
      var10 = (java$lang$StringBuffer.prototype.Ljava$lang$String$$toString$$.call(var9));
      var11 = (org$luaj$vm2$compiler$LuaC$CompileState.prototype.Ljava$lang$String$$pushfstring$Ljava$lang$String$.call(var4,var10));
      // Here was a goto statement
      phi12 = this;
      phi13 = (var0) | 0;
      phi14 = arg1;
      phi15 = var11;
      break If_12_0;
     }
    }
    var16 = phi15;
    var17 = phi12;
    var18 = (var17.ls);
    var19 = (0) | 0;
    org$luaj$vm2$compiler$LexState.prototype.V$lexerror$Ljava$lang$String$$I.call(var18,var16,var19);
    return;
  }

  static I$singlevaraux$Lorg$luaj$vm2$compiler$FuncState$$Lorg$luaj$vm2$LuaString$$Lorg$luaj$vm2$compiler$LexState$expdesc$$I(arg0,arg1,arg2,arg3) {
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var phi7 = null;
    var phi8 = null;
    var phi9 = null;
    var phi10 = 0;
    var phi11 = 0;
    var var12 = null;
    var var13 = 0;
    var var14 = 0;
    var var15 = null;
    var var16 = null;
    var var17 = 0;
    var var18 = 0;
    var var19 = 0;
    var var20 = null;
    var var21 = 0;
    var phi22 = null;
    var phi23 = null;
    var phi24 = null;
    var phi25 = 0;
    var phi26 = 0;
    var phi27 = 0;
    var var28 = null;
    var var29 = 0;
    var0 = arg1;
    var1 = (arg3) | 0;
    if (arg0 != null) {
     var3 = ((org$luaj$vm2$compiler$FuncState.prototype.I$searchvar$Lorg$luaj$vm2$LuaString$.call(arg0,var0))) | 0;
     var4 = (var3) | 0;
     if (var4 < 0) {
      var12 = var0;
      var13 = ((org$luaj$vm2$compiler$FuncState.prototype.I$searchupvalue$Lorg$luaj$vm2$LuaString$.call(arg0,var12))) | 0;
      var14 = (var13) | 0;
      If_50_0: {
       if (var14 >= 0) {
        phi22 = arg0;
        phi23 = var0;
        phi24 = arg2;
        phi25 = (var1) | 0;
        phi26 = (var3) | 0;
        phi27 = (var13) | 0;
        break If_50_0;
       } else {
        var15 = arg0;
        var16 = (var15.prev);
        var17 = (0) | 0;
        org$luaj$vm2$compiler$FuncState.$i;
        var18 = ((org$luaj$vm2$compiler$FuncState.I$singlevaraux$Lorg$luaj$vm2$compiler$FuncState$$Lorg$luaj$vm2$LuaString$$Lorg$luaj$vm2$compiler$LexState$expdesc$$I(var16,var0,arg2,var17))) | 0;
        if (var18 != 0) {
         var20 = var0;
         var21 = ((org$luaj$vm2$compiler$FuncState.prototype.I$newupvalue$Lorg$luaj$vm2$LuaString$$Lorg$luaj$vm2$compiler$LexState$expdesc$.call(arg0,var20,arg2))) | 0;
         phi22 = arg0;
         phi23 = var0;
         phi24 = arg2;
         phi25 = (var1) | 0;
         phi26 = (var3) | 0;
         phi27 = (var21) | 0;
         break If_50_0;
        } else {
         var19 = (0) | 0;
         return var19;
        }
       }
      }
      var28 = phi24;
      var29 = (phi27) | 0;
      org$luaj$vm2$compiler$LexState$expdesc.prototype.V$init$I$I.call(var28,8,var29);
      return 8;
     } else {
      var5 = arg2;
      org$luaj$vm2$compiler$LexState$expdesc.prototype.V$init$I$I.call(var5,7,var3);
      If_28_0: {
       if (var1 != 0) {
        phi7 = arg0;
        phi8 = var0;
        phi9 = arg2;
        phi10 = (var1) | 0;
        phi11 = (var3) | 0;
        break If_28_0;
       } else {
        var6 = arg0;
        org$luaj$vm2$compiler$FuncState.prototype.V$markupval$I.call(var6,var3);
        phi7 = arg0;
        phi8 = var0;
        phi9 = arg2;
        phi10 = (var1) | 0;
        phi11 = (var3) | 0;
        break If_28_0;
       }
      }
      return 7;
     }
    } else {
     var2 = (0) | 0;
     return var2;
    }
  }

  I$searchvar$Lorg$luaj$vm2$LuaString$(arg0) {
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var phi3 = null;
    var phi4 = null;
    var phi5 = 0;
    var var6 = 0;
    var var7 = null;
    var var8 = null;
    var var9 = 0;
    var var10 = null;
    var var11 = null;
    var var12 = 0;
    var var13 = 0;
    var0 = arg0;
    var1 = (this.nactvar);
    var2 = ((var1 - 1)) | 0;
    phi3 = this;
    phi4 = var0;
    phi5 = (var2) | 0;
    L1852699619: while(true) {
     var6 = (phi5) | 0;
     if (var6 < 0) {
      return -1;
     } else {
      var7 = phi4;
      var8 = phi3;
      var9 = (phi5) | 0;
      var10 = (org$luaj$vm2$compiler$FuncState.prototype.Lorg$luaj$vm2$LocVars$$getlocvar$I.call(var8,var9));
      var11 = (var10.varname);
      var12 = (org$luaj$vm2$LuaString.prototype.Z$eq_b$Lorg$luaj$vm2$LuaValue$.call(var7,var11));
      if (var12 == 0) {
       phi5 = ((phi5 + -1)) | 0;
       // Here was a goto statement
       continue L1852699619;
      } else {
       var13 = (phi5) | 0;
       return var13;
      }
     }
    }
  }

  Lorg$luaj$vm2$LocVars$$getlocvar$I(arg0) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var var6 = null;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var phi11 = null;
    var phi12 = 0;
    var phi13 = 0;
    var phi14 = 0;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = 0;
    var var19 = null;
    var0 = (arg0) | 0;
    var1 = (this.ls);
    var2 = (var1.dyd);
    var3 = (var2.actvar);
    var4 = ((this.firstlocal)) | 0;
    var5 = ((var4 + var0)) | 0;
    var6 = (var3.data[var5]);
    var7 = (var6.idx);
    var8 = var7;
    var9 = (this.nlocvars);
    If_31_0: {
     if (var8 >= var9) {
      phi11 = this;
      phi12 = (var0) | 0;
      phi13 = var7;
      phi14 = (0) | 0;
      break If_31_0;
     } else {
      var10 = (1) | 0;
      // Here was a goto statement
      phi11 = this;
      phi12 = (var0) | 0;
      phi13 = var7;
      phi14 = (var10) | 0;
      break If_31_0;
     }
    }
    org$luaj$vm2$compiler$FuncState.$i;
    org$luaj$vm2$compiler$Constants.V$_assert$Z(phi14);
    var15 = phi11;
    var16 = (var15.f);
    var17 = (var16.locvars);
    var18 = phi13;
    var19 = (var17.data[var18]);
    return var19;
  }

  V$markupval$I(arg0) {
    var var0 = 0;
    var var1 = null;
    var phi2 = 0;
    var phi3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = 0;
    var var7 = null;
    var var8 = null;
    var var9 = null;
    var0 = (arg0) | 0;
    var1 = (this.bl);
    phi2 = (var0) | 0;
    phi3 = var1;
    L1957410224: while(true) {
     var4 = phi3;
     var5 = (var4.nactvar);
     var6 = (phi2) | 0;
     if (var5 <= var6) {
      var9 = phi3;
      var9.upval = 1;
      return;
     } else {
      var7 = phi3;
      var8 = (var7.previous);
      // Here was a goto statement
      phi3 = var8;
      continue L1957410224;
     }
    }
  }

  I$searchupvalue$Lorg$luaj$vm2$LuaString$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var phi4 = null;
    var phi5 = null;
    var phi6 = 0;
    var phi7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = 0;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = 0;
    var var17 = 0;
    var0 = arg0;
    var1 = (this.f);
    var2 = (var1.upvalues);
    var3 = (0) | 0;
    phi4 = this;
    phi5 = var0;
    phi6 = (var3) | 0;
    phi7 = var2;
    L1941591139: while(true) {
     var8 = (phi6) | 0;
     var9 = phi4;
     var10 = (var9.nups);
     if (var8 >= var10) {
      return -1;
     } else {
      var11 = phi7;
      var12 = (phi6) | 0;
      var13 = (var11.data[var12]);
      var14 = (var13.name);
      var15 = phi5;
      var16 = (org$luaj$vm2$LuaString.prototype.Z$eq_b$Lorg$luaj$vm2$LuaValue$.call(var14,var15));
      if (var16 == 0) {
       phi6 = ((phi6 + 1)) | 0;
       // Here was a goto statement
       continue L1941591139;
      } else {
       var17 = (phi6) | 0;
       return var17;
      }
     }
    }
  }

  I$stringK$Lorg$luaj$vm2$LuaString$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var0 = arg0;
    var1 = var0;
    var2 = ((org$luaj$vm2$compiler$FuncState.prototype.I$addk$Lorg$luaj$vm2$LuaValue$.call(this,var1))) | 0;
    return var2;
  }

  I$addk$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var phi4 = null;
    var phi5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = 0;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = 0;
    var var20 = 0;
    var var21 = null;
    var var22 = 0;
    var phi23 = 0;
    var phi24 = null;
    var var25 = null;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = 0;
    var var30 = 0;
    var var31 = 0;
    var var32 = null;
    var var33 = null;
    var var34 = null;
    var var35 = null;
    var var36 = 0;
    var var37 = 0;
    var var38 = null;
    var var39 = 0;
    var var40 = null;
    var var41 = 0;
    var var42 = null;
    var var43 = null;
    var var44 = null;
    var var45 = null;
    var var46 = 0;
    var0 = arg0;
    var1 = (this.h);
    If_8_0: {
     if (var1 != null) {
      var40 = (this.h);
      var41 = (var40.Z$containsKey$Ljava$lang$Object$(var0));
      if (var41 == 0) {
       phi4 = this;
       phi5 = var0;
       break If_8_0;
      } else {
       var42 = this;
       var43 = (var42.h);
       var44 = (var43.Ljava$lang$Object$$get$Ljava$lang$Object$(var0));
       var45 = var44;
       var46 = ((java$lang$Integer.prototype.I$intValue$$.call(var45))) | 0;
       return var46;
      }
     } else {
      var2 = this;
      var3 = new java$util$Hashtable();
      java$util$Hashtable.prototype.V$$init$$$.call(var3);
      var2.h = var3;
      // Here was a goto statement
      phi4 = this;
      phi5 = var0;
      break If_8_0;
     }
    }
    var6 = phi4;
    var7 = ((var6.nk)) | 0;
    var8 = phi4;
    var9 = (var8.h);
    var10 = phi5;
    java$lang$Integer.$i;
    var11 = new java$lang$Integer();
    var12 = (var7) | 0;
    java$lang$Integer.prototype.V$$init$$I.call(var11,var12);
    var13 = (var9.Ljava$lang$Object$$put$Ljava$lang$Object$$Ljava$lang$Object$(var10,var11));
    var14 = phi4;
    var15 = (var14.f);
    var16 = var15;
    var17 = (var16.k);
    If_56_0: {
     If_56_1: {
      if (var17 == null) {
       phi23 = (var7) | 0;
       phi24 = var15;
       break If_56_1;
      } else {
       var18 = phi4;
       var19 = ((var18.nk)) | 0;
       var20 = ((var19 + 1)) | 0;
       var21 = (var15.k);
       var22 = (var21.data.length) | 0;
       if (var20 < var22) {
        phi23 = (var7) | 0;
        phi24 = var15;
        break If_56_0;
       } else {
        phi23 = (var7) | 0;
        phi24 = var15;
        break If_56_1;
       }
      }
     }
     var25 = phi24;
     var26 = phi24;
     var27 = (var26.k);
     var28 = phi4;
     var29 = ((var28.nk)) | 0;
     var30 = ((var29 * 2)) | 0;
     var31 = ((var30 + 1)) | 0;
     org$luaj$vm2$compiler$FuncState.$i;
     var32 = (org$luaj$vm2$compiler$Constants.$Lorg$luaj$vm2$LuaValue$$realloc$$Lorg$luaj$vm2$LuaValue$$I(var27,var31));
     var25.k = var32;
     break If_56_0;
    }
    var33 = phi24;
    var34 = (var33.k);
    var35 = phi4;
    var36 = ((var35.nk)) | 0;
    var37 = ((var36 + 1)) | 0;
    var35.nk = var37;
    var38 = phi5;
    var34.data[var36] = var38;
    var39 = (phi23) | 0;
    return var39;
  }

  V$indexed$Lorg$luaj$vm2$compiler$LexState$expdesc$$Lorg$luaj$vm2$compiler$LexState$expdesc$(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = null;
    var var11 = 0;
    var var12 = 0;
    var phi13 = null;
    var phi14 = null;
    var phi15 = null;
    var phi16 = 0;
    var var17 = null;
    var var18 = null;
    var var19 = null;
    var var20 = 0;
    var var21 = 0;
    var phi22 = null;
    var phi23 = 0;
    var var24 = 0;
    var var25 = null;
    var0 = arg0;
    var1 = (var0.u);
    var2 = (var0.u);
    var3 = ((var2.info)) | 0;
    var4 = var3;
    var1.ind_t = var4;
    var5 = (var0.u);
    var6 = arg1;
    var7 = ((org$luaj$vm2$compiler$FuncState.prototype.I$exp2RK$Lorg$luaj$vm2$compiler$LexState$expdesc$.call(this,var6))) | 0;
    var8 = var7;
    var5.ind_idx = var8;
    var9 = ((var0.k)) | 0;
    If_35_0: {
     If_35_1: {
      if (var9 == 8) {
       phi13 = this;
       phi14 = var0;
       phi15 = arg1;
       break If_35_1;
      } else {
       var10 = var0;
       var11 = ((var10.k)) | 0;
       org$luaj$vm2$compiler$FuncState.$i;
       var12 = (org$luaj$vm2$compiler$FuncState.Z$vkisinreg$I(var11));
       if (var12 == 0) {
        phi13 = this;
        phi14 = var0;
        phi15 = arg1;
        phi16 = (0) | 0;
        break If_35_0;
       } else {
        phi13 = this;
        phi14 = var0;
        phi15 = arg1;
        break If_35_1;
       }
      }
     }
     // Here was a goto statement
     phi16 = (1) | 0;
     break If_35_0;
    }
    org$luaj$vm2$compiler$LuaC.$i;
    org$luaj$vm2$compiler$Constants.V$_assert$Z(phi16);
    var17 = phi14;
    var18 = (var17.u);
    var19 = phi14;
    var20 = ((var19.k)) | 0;
    If_72_0: {
     if (var20 != 8) {
      phi22 = var18;
      phi23 = (7) | 0;
      break If_72_0;
     } else {
      var21 = (8) | 0;
      // Here was a goto statement
      phi22 = var18;
      phi23 = (var21) | 0;
      break If_72_0;
     }
    }
    var24 = phi23;
    phi22.ind_vt = var24;
    var25 = phi14;
    var25.k = 9;
    return;
  }

  I$exp2RK$Lorg$luaj$vm2$compiler$LexState$expdesc$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var phi8 = null;
    var phi9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = 0;
    var var13 = null;
    var var14 = null;
    var var15 = 0;
    var var16 = 0;
    var var17 = null;
    var var18 = null;
    var var19 = 0;
    var var20 = 0;
    var var21 = null;
    var var22 = null;
    var var23 = 0;
    var var24 = null;
    var var25 = 0;
    var phi26 = null;
    var phi27 = null;
    var phi28 = null;
    var phi29 = 0;
    var var30 = null;
    var var31 = null;
    var var32 = null;
    var var33 = 0;
    var var34 = 0;
    var var35 = 0;
    var var36 = 0;
    var phi37 = null;
    var phi38 = null;
    var phi39 = null;
    var phi40 = null;
    var phi41 = 0;
    var var42 = 0;
    var0 = arg0;
    var1 = var0;
    org$luaj$vm2$compiler$FuncState.prototype.V$exp2val$Lorg$luaj$vm2$compiler$LexState$expdesc$.call(this,var1);
    var2 = ((var0.k)) | 0;
    TableSwitch_11_0: {
     TableSwitch_11_1: {
      if ((var2) >= 1 && (var2) <= 5) switch ((var2) - 1) {
       case 0: {
        var20 = ((this.nk)) | 0;
        if (var20 > 255) {
         phi8 = this;
         phi9 = var0;
         break TableSwitch_11_0;
        } else {
         var21 = var0;
         var22 = (var21.u);
         var23 = ((var0.k)) | 0;
         If_83_0: {
          if (var23 != 1) {
           var35 = ((var0.k)) | 0;
           If_119_0: {
            if (var35 != 2) {
             phi37 = this;
             phi38 = var0;
             phi39 = var22;
             phi40 = this;
             phi41 = (0) | 0;
             break If_119_0;
            } else {
             var36 = (1) | 0;
             // Here was a goto statement
             phi37 = this;
             phi38 = var0;
             phi39 = var22;
             phi40 = this;
             phi41 = (var36) | 0;
             break If_119_0;
            }
           }
           var42 = ((org$luaj$vm2$compiler$FuncState.prototype.I$boolK$Z.call(phi40,phi41))) | 0;
           phi26 = phi37;
           phi27 = phi38;
           phi28 = phi39;
           phi29 = (var42) | 0;
           break If_83_0;
          } else {
           var24 = this;
           var25 = ((org$luaj$vm2$compiler$FuncState.prototype.I$nilK$$.call(var24))) | 0;
           // Here was a goto statement
           phi26 = this;
           phi27 = var0;
           phi28 = var22;
           phi29 = (var25) | 0;
           break If_83_0;
          }
         }
         phi28.info = phi29;
         var30 = phi27;
         var30.k = 4;
         var31 = phi27;
         var32 = (var31.u);
         var33 = ((var32.info)) | 0;
         org$luaj$vm2$compiler$FuncState.$i;
         var34 = ((org$luaj$vm2$Lua.I$RKASK$I(var33))) | 0;
         return var34;
        }
       }
       case 1: {
        var20 = ((this.nk)) | 0;
        if (var20 > 255) {
         phi8 = this;
         phi9 = var0;
         break TableSwitch_11_0;
        } else {
         var21 = var0;
         var22 = (var21.u);
         var23 = ((var0.k)) | 0;
         If_83_0: {
          if (var23 != 1) {
           var35 = ((var0.k)) | 0;
           If_119_0: {
            if (var35 != 2) {
             phi37 = this;
             phi38 = var0;
             phi39 = var22;
             phi40 = this;
             phi41 = (0) | 0;
             break If_119_0;
            } else {
             var36 = (1) | 0;
             // Here was a goto statement
             phi37 = this;
             phi38 = var0;
             phi39 = var22;
             phi40 = this;
             phi41 = (var36) | 0;
             break If_119_0;
            }
           }
           var42 = ((org$luaj$vm2$compiler$FuncState.prototype.I$boolK$Z.call(phi40,phi41))) | 0;
           phi26 = phi37;
           phi27 = phi38;
           phi28 = phi39;
           phi29 = (var42) | 0;
           break If_83_0;
          } else {
           var24 = this;
           var25 = ((org$luaj$vm2$compiler$FuncState.prototype.I$nilK$$.call(var24))) | 0;
           // Here was a goto statement
           phi26 = this;
           phi27 = var0;
           phi28 = var22;
           phi29 = (var25) | 0;
           break If_83_0;
          }
         }
         phi28.info = phi29;
         var30 = phi27;
         var30.k = 4;
         var31 = phi27;
         var32 = (var31.u);
         var33 = ((var32.info)) | 0;
         org$luaj$vm2$compiler$FuncState.$i;
         var34 = ((org$luaj$vm2$Lua.I$RKASK$I(var33))) | 0;
         return var34;
        }
       }
       case 2: {
        var20 = ((this.nk)) | 0;
        if (var20 > 255) {
         phi8 = this;
         phi9 = var0;
         break TableSwitch_11_0;
        } else {
         var21 = var0;
         var22 = (var21.u);
         var23 = ((var0.k)) | 0;
         If_83_0: {
          if (var23 != 1) {
           var35 = ((var0.k)) | 0;
           If_119_0: {
            if (var35 != 2) {
             phi37 = this;
             phi38 = var0;
             phi39 = var22;
             phi40 = this;
             phi41 = (0) | 0;
             break If_119_0;
            } else {
             var36 = (1) | 0;
             // Here was a goto statement
             phi37 = this;
             phi38 = var0;
             phi39 = var22;
             phi40 = this;
             phi41 = (var36) | 0;
             break If_119_0;
            }
           }
           var42 = ((org$luaj$vm2$compiler$FuncState.prototype.I$boolK$Z.call(phi40,phi41))) | 0;
           phi26 = phi37;
           phi27 = phi38;
           phi28 = phi39;
           phi29 = (var42) | 0;
           break If_83_0;
          } else {
           var24 = this;
           var25 = ((org$luaj$vm2$compiler$FuncState.prototype.I$nilK$$.call(var24))) | 0;
           // Here was a goto statement
           phi26 = this;
           phi27 = var0;
           phi28 = var22;
           phi29 = (var25) | 0;
           break If_83_0;
          }
         }
         phi28.info = phi29;
         var30 = phi27;
         var30.k = 4;
         var31 = phi27;
         var32 = (var31.u);
         var33 = ((var32.info)) | 0;
         org$luaj$vm2$compiler$FuncState.$i;
         var34 = ((org$luaj$vm2$Lua.I$RKASK$I(var33))) | 0;
         return var34;
        }
       }
       case 3: {
        phi8 = this;
        phi9 = var0;
        break TableSwitch_11_1;
       }
       case 4: {
        var3 = (var0.u);
        var4 = var0;
        var5 = (var4.u);
        var6 = (org$luaj$vm2$compiler$LexState$expdesc$U.prototype.Lorg$luaj$vm2$LuaValue$$nval$$.call(var5));
        var7 = ((org$luaj$vm2$compiler$FuncState.prototype.I$numberK$Lorg$luaj$vm2$LuaValue$.call(this,var6))) | 0;
        var3.info = var7;
        var0.k = 4;
        phi8 = this;
        phi9 = var0;
        break TableSwitch_11_1;
       }
      } else {
       phi8 = this;
       phi9 = var0;
       break TableSwitch_11_0;
      }
     }
     var10 = phi9;
     var11 = (var10.u);
     var12 = ((var11.info)) | 0;
     if (var12 > 255) {
      break TableSwitch_11_0;
     } else {
      var13 = phi9;
      var14 = (var13.u);
      var15 = ((var14.info)) | 0;
      org$luaj$vm2$compiler$FuncState.$i;
      var16 = ((org$luaj$vm2$Lua.I$RKASK$I(var15))) | 0;
      return var16;
     }
    }
    var17 = phi8;
    var18 = phi9;
    var19 = ((org$luaj$vm2$compiler$FuncState.prototype.I$exp2anyreg$Lorg$luaj$vm2$compiler$LexState$expdesc$.call(var17,var18))) | 0;
    return var19;
  }

  V$exp2val$Lorg$luaj$vm2$compiler$LexState$expdesc$(arg0) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var phi4 = null;
    var phi5 = null;
    var var6 = null;
    var0 = arg0;
    var1 = (org$luaj$vm2$compiler$LexState$expdesc.prototype.Z$hasjumps$$.call(var0));
    If_8_0: {
     if (var1 == 0) {
      var6 = var0;
      org$luaj$vm2$compiler$FuncState.prototype.V$dischargevars$Lorg$luaj$vm2$compiler$LexState$expdesc$.call(this,var6);
      phi4 = this;
      phi5 = var0;
      break If_8_0;
     } else {
      var2 = this;
      var3 = ((org$luaj$vm2$compiler$FuncState.prototype.I$exp2anyreg$Lorg$luaj$vm2$compiler$LexState$expdesc$.call(var2,var0))) | 0;
      // Here was a goto statement
      phi4 = this;
      phi5 = var0;
      break If_8_0;
     }
    }
    return;
  }

  I$exp2anyreg$Lorg$luaj$vm2$compiler$LexState$expdesc$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = null;
    var var6 = null;
    var var7 = 0;
    var var8 = null;
    var var9 = 0;
    var var10 = 0;
    var var11 = null;
    var var12 = null;
    var var13 = null;
    var var14 = 0;
    var var15 = null;
    var var16 = 0;
    var phi17 = null;
    var phi18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = 0;
    var0 = arg0;
    var1 = var0;
    org$luaj$vm2$compiler$FuncState.prototype.V$dischargevars$Lorg$luaj$vm2$compiler$LexState$expdesc$.call(this,var1);
    var2 = ((var0.k)) | 0;
    If_12_0: {
     if (var2 != 6) {
      phi17 = this;
      phi18 = var0;
      break If_12_0;
     } else {
      var3 = var0;
      var4 = (org$luaj$vm2$compiler$LexState$expdesc.prototype.Z$hasjumps$$.call(var3));
      if (var4 != 0) {
       var8 = (var0.u);
       var9 = ((var8.info)) | 0;
       var10 = (this.nactvar);
       if (var9 < var10) {
        phi17 = this;
        phi18 = var0;
        break If_12_0;
       } else {
        var11 = this;
        var12 = var0;
        var13 = (var12.u);
        var14 = ((var13.info)) | 0;
        org$luaj$vm2$compiler$FuncState.prototype.V$exp2reg$Lorg$luaj$vm2$compiler$LexState$expdesc$$I.call(var11,var0,var14);
        var15 = (var0.u);
        var16 = ((var15.info)) | 0;
        return var16;
       }
      } else {
       var5 = var0;
       var6 = (var5.u);
       var7 = ((var6.info)) | 0;
       return var7;
      }
     }
    }
    var19 = phi17;
    var20 = phi18;
    org$luaj$vm2$compiler$FuncState.prototype.V$exp2nextreg$Lorg$luaj$vm2$compiler$LexState$expdesc$.call(var19,var20);
    var21 = phi18;
    var22 = (var21.u);
    var23 = ((var22.info)) | 0;
    return var23;
  }

  V$dischargevars$Lorg$luaj$vm2$compiler$LexState$expdesc$(arg0) {
    var var0 = null;
    var var1 = 0;
    var phi2 = null;
    var phi3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = null;
    var var11 = 0;
    var var12 = 0;
    var phi13 = null;
    var phi14 = null;
    var phi15 = 0;
    var var16 = null;
    var var17 = null;
    var var18 = null;
    var var19 = 0;
    var var20 = null;
    var var21 = null;
    var var22 = 0;
    var var23 = null;
    var var24 = null;
    var var25 = 0;
    var var26 = 0;
    var var27 = null;
    var var28 = null;
    var var29 = 0;
    var var30 = null;
    var var31 = 0;
    var var32 = 0;
    var var33 = 0;
    var var34 = 0;
    var0 = arg0;
    var1 = ((var0.k)) | 0;
    TableSwitch_8_0: {
     if ((var1) >= 7 && (var1) <= 13) switch ((var1) - 7) {
      case 0: {
       var34 = (6) | 0;
       var0.k = var34;
       // Here was a goto statement
       phi2 = this;
       phi3 = var0;
       break TableSwitch_8_0;
      }
      case 1: {
       var28 = (var0.u);
       var29 = (5) | 0;
       var30 = (var0.u);
       var31 = ((var30.info)) | 0;
       var32 = ((org$luaj$vm2$compiler$FuncState.prototype.I$codeABC$I$I$I$I.call(this,var29,0,var31,0))) | 0;
       var28.info = var32;
       var33 = (11) | 0;
       var0.k = var33;
       // Here was a goto statement
       phi2 = this;
       phi3 = var0;
       break TableSwitch_8_0;
      }
      case 2: {
       var4 = this;
       var5 = (var0.u);
       var6 = (var5.ind_idx);
       org$luaj$vm2$compiler$FuncState.prototype.V$freereg$I.call(var4,var6);
       var7 = (var0.u);
       var8 = (var7.ind_vt);
       If_34_0: {
        if (var8 != 7) {
         phi13 = this;
         phi14 = var0;
         phi15 = (6) | 0;
         break If_34_0;
        } else {
         var9 = this;
         var10 = (var0.u);
         var11 = (var10.ind_t);
         org$luaj$vm2$compiler$FuncState.prototype.V$freereg$I.call(var9,var11);
         var12 = (7) | 0;
         phi13 = this;
         phi14 = var0;
         phi15 = (var12) | 0;
         break If_34_0;
        }
       }
       var16 = phi14;
       var17 = (var16.u);
       var18 = phi13;
       var19 = (phi15) | 0;
       var20 = phi14;
       var21 = (var20.u);
       var22 = (var21.ind_t);
       var23 = phi14;
       var24 = (var23.u);
       var25 = (var24.ind_idx);
       var26 = ((org$luaj$vm2$compiler$FuncState.prototype.I$codeABC$I$I$I$I.call(var18,var19,0,var22,var25))) | 0;
       var17.info = var26;
       var27 = phi14;
       var27.k = 11;
       // Here was a goto statement
       phi2 = phi13;
       phi3 = phi14;
       break TableSwitch_8_0;
      }
      case 3: {
       phi2 = this;
       phi3 = var0;
       break TableSwitch_8_0;
      }
      case 4: {
       phi2 = this;
       phi3 = var0;
       break TableSwitch_8_0;
      }
      case 5: {
       org$luaj$vm2$compiler$FuncState.prototype.V$setoneret$Lorg$luaj$vm2$compiler$LexState$expdesc$.call(this,var0);
       // Here was a goto statement
       phi2 = this;
       phi3 = var0;
       break TableSwitch_8_0;
      }
      case 6: {
       org$luaj$vm2$compiler$FuncState.prototype.V$setoneret$Lorg$luaj$vm2$compiler$LexState$expdesc$.call(this,var0);
       // Here was a goto statement
       phi2 = this;
       phi3 = var0;
       break TableSwitch_8_0;
      }
     } else {
      phi2 = this;
      phi3 = var0;
      break TableSwitch_8_0;
     }
    }
    return;
  }

  V$setoneret$Lorg$luaj$vm2$compiler$LexState$expdesc$(arg0) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var phi6 = null;
    var phi7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = null;
    var var11 = 0;
    var0 = arg0;
    var1 = ((var0.k)) | 0;
    If_9_0: {
     if (var1 != 12) {
      var8 = ((var0.k)) | 0;
      if (var8 != 13) {
       phi6 = this;
       phi7 = var0;
       break If_9_0;
      } else {
       var9 = this;
       var10 = (org$luaj$vm2$compiler$FuncState.prototype.Lorg$luaj$vm2$compiler$InstructionPtr$$getcodePtr$Lorg$luaj$vm2$compiler$LexState$expdesc$.call(var9,var0));
       org$luaj$vm2$compiler$FuncState.$i;
       org$luaj$vm2$compiler$Constants.V$SETARG_B$Lorg$luaj$vm2$compiler$InstructionPtr$$I(var10,2);
       var11 = (11) | 0;
       var0.k = var11;
       phi6 = this;
       phi7 = var0;
       break If_9_0;
      }
     } else {
      var2 = var0;
      var2.k = 6;
      var3 = (var0.u);
      var4 = ((org$luaj$vm2$compiler$FuncState.prototype.I$getcode$Lorg$luaj$vm2$compiler$LexState$expdesc$.call(this,var0))) | 0;
      org$luaj$vm2$compiler$FuncState.$i;
      var5 = ((org$luaj$vm2$Lua.I$GETARG_A$I(var4))) | 0;
      var3.info = var5;
      // Here was a goto statement
      phi6 = this;
      phi7 = var0;
      break If_9_0;
     }
    }
    return;
  }

  I$getcode$Lorg$luaj$vm2$compiler$LexState$expdesc$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var0 = arg0;
    var1 = (this.f);
    var2 = (var1.code);
    var3 = (var0.u);
    var4 = ((var3.info)) | 0;
    var5 = ((var2.data[var4])) | 0;
    return var5;
  }

  Lorg$luaj$vm2$compiler$InstructionPtr$$getcodePtr$Lorg$luaj$vm2$compiler$LexState$expdesc$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var0 = arg0;
    var1 = new org$luaj$vm2$compiler$InstructionPtr();
    var2 = this;
    var3 = (var2.f);
    var4 = (var3.code);
    var5 = (var0.u);
    var6 = ((var5.info)) | 0;
    org$luaj$vm2$compiler$InstructionPtr.prototype.V$$init$$$I$I.call(var1,var4,var6);
    return var1;
  }

  V$freereg$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = null;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = null;
    var var9 = 0;
    var var10 = 0;
    var phi11 = null;
    var phi12 = 0;
    var phi13 = 0;
    var0 = (arg0) | 0;
    org$luaj$vm2$compiler$FuncState.$i;
    var1 = (org$luaj$vm2$Lua.Z$ISK$I(var0));
    If_10_0: {
     if (var1 != 0) {
      phi11 = this;
      phi12 = (var0) | 0;
      break If_10_0;
     } else {
      var2 = (var0) | 0;
      var3 = (this.nactvar);
      if (var2 < var3) {
       phi11 = this;
       phi12 = (var0) | 0;
       break If_10_0;
      } else {
       var4 = this;
       var5 = (var4.freereg);
       var6 = ((var5 - 1)) | 0;
       var7 = var6;
       var4.freereg = var7;
       var8 = this;
       var9 = (var8.freereg);
       If_38_0: {
        if (var0 != var9) {
         phi11 = this;
         phi12 = (var0) | 0;
         phi13 = (0) | 0;
         break If_38_0;
        } else {
         var10 = (1) | 0;
         // Here was a goto statement
         phi11 = this;
         phi12 = (var0) | 0;
         phi13 = (var10) | 0;
         break If_38_0;
        }
       }
       org$luaj$vm2$compiler$Constants.V$_assert$Z(phi13);
       break If_10_0;
      }
     }
    }
    return;
  }

  I$codeABC$I$I$I$I(arg0,arg1,arg2,arg3) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var phi4 = null;
    var phi5 = 0;
    var phi6 = 0;
    var phi7 = 0;
    var phi8 = 0;
    var phi9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var phi13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = 0;
    var phi17 = 0;
    var var18 = null;
    var var19 = 0;
    var var20 = 0;
    var var21 = 0;
    var var22 = 0;
    var var23 = 0;
    var var24 = null;
    var var25 = null;
    var var26 = 0;
    var var27 = 0;
    var0 = (arg0) | 0;
    var1 = (arg2) | 0;
    org$luaj$vm2$compiler$FuncState.$i;
    var2 = ((org$luaj$vm2$Lua.I$getOpMode$I(var0))) | 0;
    If_15_0: {
     if (var2 != 0) {
      phi4 = this;
      phi5 = (var0) | 0;
      phi6 = (arg1) | 0;
      phi7 = (var1) | 0;
      phi8 = (arg3) | 0;
      phi9 = (0) | 0;
      break If_15_0;
     } else {
      var3 = (1) | 0;
      // Here was a goto statement
      phi4 = this;
      phi5 = (var0) | 0;
      phi6 = (arg1) | 0;
      phi7 = (var1) | 0;
      phi8 = (arg3) | 0;
      phi9 = (var3) | 0;
      break If_15_0;
     }
    }
    org$luaj$vm2$compiler$Constants.V$_assert$Z(phi9);
    var10 = (phi5) | 0;
    var11 = ((org$luaj$vm2$Lua.I$getBMode$I(var10))) | 0;
    If_37_0: {
     If_37_1: {
      if (var11 != 0) {
       break If_37_1;
      } else {
       var12 = (phi7) | 0;
       if (var12 != 0) {
        phi13 = (0) | 0;
        break If_37_0;
       } else {
        break If_37_1;
       }
      }
     }
     // Here was a goto statement
     phi13 = (1) | 0;
     break If_37_0;
    }
    org$luaj$vm2$compiler$Constants.V$_assert$Z(phi13);
    var14 = (phi5) | 0;
    var15 = ((org$luaj$vm2$Lua.I$getCMode$I(var14))) | 0;
    If_58_0: {
     If_58_1: {
      if (var15 != 0) {
       break If_58_1;
      } else {
       var16 = (phi8) | 0;
       if (var16 != 0) {
        phi17 = (0) | 0;
        break If_58_0;
       } else {
        break If_58_1;
       }
      }
     }
     // Here was a goto statement
     phi17 = (1) | 0;
     break If_58_0;
    }
    org$luaj$vm2$compiler$Constants.V$_assert$Z(phi17);
    var18 = phi4;
    var19 = (phi5) | 0;
    var20 = (phi6) | 0;
    var21 = (phi7) | 0;
    var22 = (phi8) | 0;
    var23 = ((org$luaj$vm2$compiler$Constants.I$CREATE_ABC$I$I$I$I(var19,var20,var21,var22))) | 0;
    var24 = phi4;
    var25 = (var24.ls);
    var26 = ((var25.lastline)) | 0;
    var27 = ((org$luaj$vm2$compiler$FuncState.prototype.I$code$I$I.call(var18,var23,var26))) | 0;
    return var27;
  }

  I$code$I$I(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = 0;
    var var7 = null;
    var var8 = 0;
    var phi9 = null;
    var phi10 = 0;
    var phi11 = 0;
    var phi12 = null;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = 0;
    var var18 = 0;
    var var19 = 0;
    var var20 = null;
    var var21 = null;
    var var22 = null;
    var var23 = null;
    var var24 = 0;
    var var25 = 0;
    var var26 = null;
    var var27 = null;
    var var28 = null;
    var var29 = 0;
    var var30 = 0;
    var var31 = null;
    var var32 = null;
    var var33 = 0;
    var var34 = null;
    var var35 = null;
    var var36 = null;
    var var37 = null;
    var var38 = 0;
    var var39 = 0;
    var var40 = 0;
    var var41 = null;
    var var42 = null;
    var var43 = null;
    var var44 = null;
    var var45 = 0;
    var var46 = 0;
    var var47 = null;
    var var48 = 0;
    var var49 = 0;
    var var50 = 0;
    var0 = (arg0) | 0;
    var1 = (this.f);
    var2 = this;
    org$luaj$vm2$compiler$FuncState.prototype.V$dischargejpc$$.call(var2);
    var3 = (var1.code);
    If_15_0: {
     If_15_1: {
      if (var3 == null) {
       phi9 = this;
       phi10 = (var0) | 0;
       phi11 = (arg1) | 0;
       phi12 = var1;
       break If_15_1;
      } else {
       var4 = this;
       var5 = ((var4.pc)) | 0;
       var6 = ((var5 + 1)) | 0;
       var7 = (var1.code);
       var8 = (var7.data.length) | 0;
       if (var6 <= var8) {
        phi9 = this;
        phi10 = (var0) | 0;
        phi11 = (arg1) | 0;
        phi12 = var1;
        break If_15_0;
       } else {
        phi9 = this;
        phi10 = (var0) | 0;
        phi11 = (arg1) | 0;
        phi12 = var1;
        break If_15_1;
       }
      }
     }
     var13 = phi12;
     var14 = phi12;
     var15 = (var14.code);
     var16 = phi9;
     var17 = ((var16.pc)) | 0;
     var18 = ((var17 * 2)) | 0;
     var19 = ((var18 + 1)) | 0;
     org$luaj$vm2$compiler$LuaC.$i;
     var20 = (org$luaj$vm2$compiler$Constants.$I$realloc$$I$I(var15,var19));
     var13.code = var20;
     break If_15_0;
    }
    var21 = phi12;
    var22 = (var21.code);
    var23 = phi9;
    var24 = ((var23.pc)) | 0;
    var25 = (phi10) | 0;
    var22.data[var24] = var25;
    var26 = phi12;
    var27 = (var26.lineinfo);
    If_84_0: {
     If_84_1: {
      if (var27 == null) {
       break If_84_1;
      } else {
       var28 = phi9;
       var29 = ((var28.pc)) | 0;
       var30 = ((var29 + 1)) | 0;
       var31 = phi12;
       var32 = (var31.lineinfo);
       var33 = (var32.data.length) | 0;
       if (var30 <= var33) {
        break If_84_0;
       } else {
        break If_84_1;
       }
      }
     }
     var34 = phi12;
     var35 = phi12;
     var36 = (var35.lineinfo);
     var37 = phi9;
     var38 = ((var37.pc)) | 0;
     var39 = ((var38 * 2)) | 0;
     var40 = ((var39 + 1)) | 0;
     org$luaj$vm2$compiler$LuaC.$i;
     var41 = (org$luaj$vm2$compiler$Constants.$I$realloc$$I$I(var36,var40));
     var34.lineinfo = var41;
     break If_84_0;
    }
    var42 = phi12;
    var43 = (var42.lineinfo);
    var44 = phi9;
    var45 = ((var44.pc)) | 0;
    var46 = (phi11) | 0;
    var43.data[var45] = var46;
    var47 = phi9;
    var48 = ((var47.pc)) | 0;
    var49 = (1) | 0;
    var50 = ((var48 + var49)) | 0;
    var47.pc = var50;
    return var48;
  }

  V$dischargejpc$$() {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var0 = this;
    var1 = (var0.jpc);
    var2 = ((var1.i)) | 0;
    var3 = ((this.pc)) | 0;
    var4 = this;
    var5 = ((var4.pc)) | 0;
    org$luaj$vm2$compiler$FuncState.prototype.V$patchlistaux$I$I$I$I.call(this,var2,var3,255,var5);
    var6 = (this.jpc);
    var6.i = -1;
    return;
  }

  V$patchlistaux$I$I$I$I(arg0,arg1,arg2,arg3) {
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = null;
    var var6 = 0;
    var var7 = null;
    var var8 = 0;
    var var9 = 0;
    var var10 = null;
    var var11 = 0;
    var phi12 = null;
    var phi13 = 0;
    var phi14 = 0;
    var phi15 = 0;
    var phi16 = 0;
    var phi17 = 0;
    var var18 = 0;
    var var19 = 0;
    var0 = this;
    var18 = (arg0) | 0;
    var1 = (arg1) | 0;
    var2 = (arg2) | 0;
    var3 = (arg3) | 0;
    L803620508: while(true) {
     var4 = (-1) | 0;
     if (var18 == var4) {
      return;
     } else {
      var5 = var0;
      var6 = ((org$luaj$vm2$compiler$FuncState.prototype.I$getjump$I.call(var5,var18))) | 0;
      var7 = var0;
      var8 = (var2) | 0;
      var9 = (org$luaj$vm2$compiler$FuncState.prototype.Z$patchtestreg$I$I.call(var7,var18,var8));
      If_33_0: {
       if (var9 == 0) {
        var19 = (var18) | 0;
        org$luaj$vm2$compiler$FuncState.prototype.V$fixjump$I$I.call(var0,var19,var3);
        phi12 = var0;
        phi13 = (var18) | 0;
        phi14 = (var1) | 0;
        phi15 = (var2) | 0;
        phi16 = (var3) | 0;
        phi17 = (var6) | 0;
        break If_33_0;
       } else {
        var10 = var0;
        var11 = (var1) | 0;
        org$luaj$vm2$compiler$FuncState.prototype.V$fixjump$I$I.call(var10,var18,var11);
        // Here was a goto statement
        phi12 = var0;
        phi13 = (var18) | 0;
        phi14 = (var1) | 0;
        phi15 = (var2) | 0;
        phi16 = (var3) | 0;
        phi17 = (var6) | 0;
        break If_33_0;
       }
      }
      var18 = (phi17) | 0;
      // Here was a goto statement
      var0 = phi12;
      var1 = (phi14) | 0;
      var2 = (phi15) | 0;
      var3 = (phi16) | 0;
      continue L803620508;
     }
    }
  }

  I$getjump$I(arg0) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var0 = (arg0) | 0;
    var1 = (this.f);
    var2 = (var1.code);
    var3 = ((var2.data[var0])) | 0;
    org$luaj$vm2$compiler$FuncState.$i;
    var4 = ((org$luaj$vm2$Lua.I$GETARG_sBx$I(var3))) | 0;
    var5 = (var4) | 0;
    if (var5 != -1) {
     var7 = ((var0 + 1)) | 0;
     var8 = ((var7 + var4)) | 0;
     return var8;
    } else {
     var6 = (-1) | 0;
     return var6;
    }
  }

  Z$patchtestreg$I$I(arg0,arg1) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = null;
    var phi12 = null;
    var phi13 = 0;
    var phi14 = 0;
    var phi15 = null;
    var phi16 = null;
    var phi17 = 0;
    var phi18 = 0;
    var phi19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = 0;
    var var23 = 0;
    var var24 = null;
    var var25 = 0;
    var var26 = 0;
    var var27 = 0;
    var0 = (arg0) | 0;
    var1 = (var0) | 0;
    var2 = (org$luaj$vm2$compiler$FuncState.prototype.Lorg$luaj$vm2$compiler$InstructionPtr$$getjumpcontrol$I.call(this,var1));
    var3 = var2;
    var4 = ((org$luaj$vm2$compiler$InstructionPtr.prototype.I$get$$.call(var3))) | 0;
    org$luaj$vm2$compiler$FuncState.$i;
    var5 = ((org$luaj$vm2$Lua.I$GET_OPCODE$I(var4))) | 0;
    if (var5 == 28) {
     var7 = 255;
     If_32_0: {
      If_32_1: {
       if (arg1 == var7) {
        phi16 = this;
        phi17 = (var0) | 0;
        phi18 = (arg1) | 0;
        phi19 = var2;
        break If_32_1;
       } else {
        var8 = (arg1) | 0;
        var9 = ((org$luaj$vm2$compiler$InstructionPtr.prototype.I$get$$.call(var2))) | 0;
        var10 = ((org$luaj$vm2$Lua.I$GETARG_B$I(var9))) | 0;
        if (var8 == var10) {
         phi16 = this;
         phi17 = (var0) | 0;
         phi18 = (arg1) | 0;
         phi19 = var2;
         break If_32_1;
        } else {
         var11 = var2;
         org$luaj$vm2$compiler$Constants.V$SETARG_A$Lorg$luaj$vm2$compiler$InstructionPtr$$I(var11,arg1);
         // Here was a goto statement
         phi12 = this;
         phi13 = (var0) | 0;
         phi14 = (arg1) | 0;
         phi15 = var2;
         break If_32_0;
        }
       }
      }
      var20 = phi19;
      var21 = phi19;
      var22 = ((org$luaj$vm2$compiler$InstructionPtr.prototype.I$get$$.call(var21))) | 0;
      var23 = ((org$luaj$vm2$Lua.I$GETARG_B$I(var22))) | 0;
      var24 = phi19;
      var25 = ((org$luaj$vm2$compiler$InstructionPtr.prototype.I$get$$.call(var24))) | 0;
      org$luaj$vm2$Lua.$i;
      var26 = ((org$luaj$vm2$Lua.I$GETARG_C$I(var25))) | 0;
      var27 = ((org$luaj$vm2$compiler$Constants.I$CREATE_ABC$I$I$I$I(27,var23,0,var26))) | 0;
      org$luaj$vm2$compiler$InstructionPtr.prototype.V$set$I.call(var20,var27);
      phi12 = phi16;
      phi13 = (phi17) | 0;
      phi14 = (phi18) | 0;
      phi15 = phi19;
      break If_32_0;
     }
     return 1;
    } else {
     var6 = (0) | 0;
     return var6;
    }
  }

  Lorg$luaj$vm2$compiler$InstructionPtr$$getjumpcontrol$I(arg0) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = null;
    var var7 = null;
    var var8 = 0;
    var var9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var var13 = null;
    var var14 = null;
    var var15 = null;
    var var16 = 0;
    var var17 = 0;
    var phi18 = null;
    var phi19 = 0;
    var phi20 = null;
    var var21 = null;
    var0 = (arg0) | 0;
    var1 = new org$luaj$vm2$compiler$InstructionPtr();
    var2 = this;
    var3 = (var2.f);
    var4 = (var3.code);
    org$luaj$vm2$compiler$InstructionPtr.prototype.V$$init$$$I$I.call(var1,var4,var0);
    var5 = (var0) | 0;
    If_22_0: {
     if (var5 < 1) {
      phi18 = this;
      phi19 = (var0) | 0;
      phi20 = var1;
      break If_22_0;
     } else {
      var6 = var1;
      var7 = (var6.code);
      var8 = ((var1.idx)) | 0;
      var9 = ((var8 - 1)) | 0;
      var10 = ((var7.data[var9])) | 0;
      org$luaj$vm2$compiler$FuncState.$i;
      var11 = ((org$luaj$vm2$Lua.I$GET_OPCODE$I(var10))) | 0;
      var12 = (org$luaj$vm2$Lua.Z$testTMode$I(var11));
      if (var12 == 0) {
       phi18 = this;
       phi19 = (var0) | 0;
       phi20 = var1;
       break If_22_0;
      } else {
       var13 = new org$luaj$vm2$compiler$InstructionPtr();
       var14 = var1;
       var15 = (var14.code);
       var16 = ((var1.idx)) | 0;
       var17 = ((var16 - 1)) | 0;
       org$luaj$vm2$compiler$InstructionPtr.prototype.V$$init$$$I$I.call(var13,var15,var17);
       return var13;
      }
     }
    }
    var21 = phi20;
    return var21;
  }

  V$fixjump$I$I(arg0,arg1) {
    var var0 = 0;
    var var1 = null;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var phi10 = null;
    var phi11 = 0;
    var phi12 = 0;
    var phi13 = null;
    var phi14 = 0;
    var phi15 = 0;
    var var16 = 0;
    var var17 = 0;
    var var18 = null;
    var var19 = null;
    var var20 = null;
    var var21 = 0;
    var0 = (arg0) | 0;
    var1 = new org$luaj$vm2$compiler$InstructionPtr();
    var2 = this;
    var3 = (var2.f);
    var4 = (var3.code);
    org$luaj$vm2$compiler$InstructionPtr.prototype.V$$init$$$I$I.call(var1,var4,var0);
    var5 = (arg1) | 0;
    var6 = ((var0 + 1)) | 0;
    var7 = ((var5 - var6)) | 0;
    var8 = (-1) | 0;
    If_32_0: {
     if (arg1 == var8) {
      phi10 = this;
      phi11 = (var0) | 0;
      phi12 = (arg1) | 0;
      phi13 = var1;
      phi14 = (var7) | 0;
      phi15 = (0) | 0;
      break If_32_0;
     } else {
      var9 = (1) | 0;
      // Here was a goto statement
      phi10 = this;
      phi11 = (var0) | 0;
      phi12 = (arg1) | 0;
      phi13 = var1;
      phi14 = (var7) | 0;
      phi15 = (var9) | 0;
      break If_32_0;
     }
    }
    org$luaj$vm2$compiler$FuncState.$i;
    org$luaj$vm2$compiler$Constants.V$_assert$Z(phi15);
    var16 = (phi14) | 0;
    java$lang$Math.$i;
    var17 = ((java$lang$Math.I$abs$I(var16))) | 0;
    If_56_0: {
     if (var17 <= 131071) {
      break If_56_0;
     } else {
      var18 = phi10;
      var19 = (var18.ls);
      org$luaj$vm2$compiler$LexState.prototype.V$syntaxerror$Ljava$lang$String$.call(var19,bytecoder.stringconstants[355]);
      break If_56_0;
     }
    }
    var20 = phi13;
    var21 = (phi14) | 0;
    org$luaj$vm2$compiler$Constants.V$SETARG_sBx$Lorg$luaj$vm2$compiler$InstructionPtr$$I(var20,var21);
    return;
  }

  V$exp2reg$Lorg$luaj$vm2$compiler$LexState$expdesc$$I(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var phi7 = null;
    var phi8 = null;
    var phi9 = 0;
    var var10 = null;
    var var11 = 0;
    var var12 = 0;
    var var13 = 0;
    var var14 = null;
    var var15 = null;
    var var16 = null;
    var var17 = 0;
    var var18 = 0;
    var var19 = null;
    var var20 = null;
    var var21 = null;
    var var22 = 0;
    var var23 = 0;
    var phi24 = 0;
    var phi25 = 0;
    var var26 = null;
    var var27 = 0;
    var var28 = 0;
    var phi29 = 0;
    var var30 = 0;
    var var31 = null;
    var var32 = 0;
    var var33 = 0;
    var var34 = 0;
    var var35 = null;
    var var36 = 0;
    var var37 = 0;
    var var38 = 0;
    var var39 = null;
    var phi40 = 0;
    var phi41 = 0;
    var var42 = null;
    var var43 = 0;
    var var44 = null;
    var var45 = null;
    var var46 = null;
    var var47 = 0;
    var var48 = 0;
    var var49 = 0;
    var var50 = null;
    var var51 = null;
    var var52 = null;
    var var53 = 0;
    var var54 = 0;
    var var55 = 0;
    var var56 = null;
    var var57 = null;
    var var58 = null;
    var var59 = null;
    var var60 = 0;
    var var61 = null;
    var var62 = null;
    var var63 = 0;
    var var64 = null;
    var var65 = null;
    var var66 = 0;
    var0 = arg0;
    var1 = var0;
    org$luaj$vm2$compiler$FuncState.prototype.V$discharge2reg$Lorg$luaj$vm2$compiler$LexState$expdesc$$I.call(this,var1,arg1);
    var2 = ((var0.k)) | 0;
    If_13_0: {
     if (var2 != 10) {
      phi7 = this;
      phi8 = var0;
      phi9 = (arg1) | 0;
      break If_13_0;
     } else {
      var3 = this;
      var4 = (var0.t);
      var5 = (var0.u);
      var6 = ((var5.info)) | 0;
      org$luaj$vm2$compiler$FuncState.prototype.V$concat$Lorg$luaj$vm2$compiler$IntPtr$$I.call(var3,var4,var6);
      phi7 = this;
      phi8 = var0;
      phi9 = (arg1) | 0;
      break If_13_0;
     }
    }
    var10 = phi8;
    var11 = (org$luaj$vm2$compiler$LexState$expdesc.prototype.Z$hasjumps$$.call(var10));
    If_36_0: {
     if (var11 == 0) {
      break If_36_0;
     } else {
      var12 = (-1) | 0;
      var13 = (-1) | 0;
      var14 = phi7;
      var15 = phi8;
      var16 = (var15.t);
      var17 = ((var16.i)) | 0;
      var18 = (org$luaj$vm2$compiler$FuncState.prototype.Z$need_value$I.call(var14,var17));
      If_58_0: {
       If_58_1: {
        if (var18 != 0) {
         phi24 = (var12) | 0;
         phi25 = (var13) | 0;
         break If_58_1;
        } else {
         var19 = phi7;
         var20 = phi8;
         var21 = (var20.f);
         var22 = ((var21.i)) | 0;
         var23 = (org$luaj$vm2$compiler$FuncState.prototype.Z$need_value$I.call(var19,var22));
         if (var23 == 0) {
          phi40 = (var12) | 0;
          phi41 = (var13) | 0;
          break If_58_0;
         } else {
          phi24 = (var12) | 0;
          phi25 = (var13) | 0;
          break If_58_1;
         }
        }
       }
       var26 = phi8;
       var27 = ((var26.k)) | 0;
       If_86_0: {
        if (var27 != 10) {
         var65 = phi7;
         var66 = ((org$luaj$vm2$compiler$FuncState.prototype.I$jump$$.call(var65))) | 0;
         phi29 = (var66) | 0;
         break If_86_0;
        } else {
         var28 = (-1) | 0;
         // Here was a goto statement
         phi29 = (var28) | 0;
         break If_86_0;
        }
       }
       var30 = (phi29) | 0;
       var31 = phi7;
       var32 = (phi9) | 0;
       var33 = (1) | 0;
       var34 = ((org$luaj$vm2$compiler$FuncState.prototype.I$code_label$I$I$I.call(var31,var32,0,var33))) | 0;
       var35 = phi7;
       var36 = (phi9) | 0;
       var37 = (0) | 0;
       var38 = ((org$luaj$vm2$compiler$FuncState.prototype.I$code_label$I$I$I.call(var35,var36,1,var37))) | 0;
       var39 = phi7;
       org$luaj$vm2$compiler$FuncState.prototype.V$patchtohere$I.call(var39,var30);
       phi40 = (var34) | 0;
       phi41 = (var38) | 0;
       break If_58_0;
      }
      var42 = phi7;
      var43 = ((org$luaj$vm2$compiler$FuncState.prototype.I$getlabel$$.call(var42))) | 0;
      var44 = phi7;
      var45 = phi8;
      var46 = (var45.f);
      var47 = ((var46.i)) | 0;
      var48 = (phi9) | 0;
      var49 = (phi40) | 0;
      org$luaj$vm2$compiler$FuncState.prototype.V$patchlistaux$I$I$I$I.call(var44,var47,var43,var48,var49);
      var50 = phi7;
      var51 = phi8;
      var52 = (var51.t);
      var53 = ((var52.i)) | 0;
      var54 = (phi9) | 0;
      var55 = (phi41) | 0;
      org$luaj$vm2$compiler$FuncState.prototype.V$patchlistaux$I$I$I$I.call(var50,var53,var43,var54,var55);
      break If_36_0;
     }
    }
    var56 = phi8;
    var57 = (var56.f);
    var58 = phi8;
    var59 = (var58.t);
    var60 = (-1) | 0;
    var59.i = var60;
    var57.i = -1;
    var61 = phi8;
    var62 = (var61.u);
    var63 = (phi9) | 0;
    var62.info = var63;
    var64 = phi8;
    var64.k = 6;
    return;
  }

  V$discharge2reg$Lorg$luaj$vm2$compiler$LexState$expdesc$$I(arg0,arg1) {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = null;
    var phi5 = null;
    var phi6 = null;
    var phi7 = 0;
    var var8 = null;
    var var9 = null;
    var var10 = 0;
    var var11 = null;
    var var12 = 0;
    var var13 = null;
    var var14 = 0;
    var phi15 = null;
    var phi16 = null;
    var phi17 = 0;
    var phi18 = 0;
    var var19 = null;
    var var20 = 0;
    var var21 = null;
    var var22 = 0;
    var var23 = null;
    var var24 = 0;
    var var25 = 0;
    var var26 = 0;
    var var27 = null;
    var var28 = null;
    var var29 = null;
    var var30 = 0;
    var var31 = 0;
    var var32 = 0;
    var var33 = null;
    var var34 = 0;
    var var35 = 0;
    var var36 = 0;
    var var37 = 0;
    var var38 = 0;
    var phi39 = null;
    var phi40 = null;
    var phi41 = 0;
    var phi42 = null;
    var phi43 = 0;
    var phi44 = 0;
    var phi45 = 0;
    var var46 = 0;
    var var47 = 0;
    var0 = arg0;
    var1 = var0;
    org$luaj$vm2$compiler$FuncState.prototype.V$dischargevars$Lorg$luaj$vm2$compiler$LexState$expdesc$.call(this,var1);
    var2 = ((var0.k)) | 0;
    TableSwitch_12_0: {
     if ((var2) >= 1 && (var2) <= 11) switch ((var2) - 1) {
      case 0: {
       var47 = (arg1) | 0;
       org$luaj$vm2$compiler$FuncState.prototype.V$nil$I$I.call(this,var47,1);
       // Here was a goto statement
       phi5 = this;
       phi6 = var0;
       phi7 = (arg1) | 0;
       break TableSwitch_12_0;
      }
      case 1: {
       var36 = (3) | 0;
       var37 = ((var0.k)) | 0;
       If_134_0: {
        if (var37 != 2) {
         phi39 = this;
         phi40 = var0;
         phi41 = (arg1) | 0;
         phi42 = this;
         phi43 = (var36) | 0;
         phi44 = (arg1) | 0;
         phi45 = (0) | 0;
         break If_134_0;
        } else {
         var38 = (1) | 0;
         // Here was a goto statement
         phi39 = this;
         phi40 = var0;
         phi41 = (arg1) | 0;
         phi42 = this;
         phi43 = (var36) | 0;
         phi44 = (arg1) | 0;
         phi45 = (var38) | 0;
         break If_134_0;
        }
       }
       var46 = ((org$luaj$vm2$compiler$FuncState.prototype.I$codeABC$I$I$I$I.call(phi42,phi43,phi44,phi45,0))) | 0;
       // Here was a goto statement
       phi5 = phi39;
       phi6 = phi40;
       phi7 = (phi41) | 0;
       break TableSwitch_12_0;
      }
      case 2: {
       var36 = (3) | 0;
       var37 = ((var0.k)) | 0;
       If_134_0: {
        if (var37 != 2) {
         phi39 = this;
         phi40 = var0;
         phi41 = (arg1) | 0;
         phi42 = this;
         phi43 = (var36) | 0;
         phi44 = (arg1) | 0;
         phi45 = (0) | 0;
         break If_134_0;
        } else {
         var38 = (1) | 0;
         // Here was a goto statement
         phi39 = this;
         phi40 = var0;
         phi41 = (arg1) | 0;
         phi42 = this;
         phi43 = (var36) | 0;
         phi44 = (arg1) | 0;
         phi45 = (var38) | 0;
         break If_134_0;
        }
       }
       var46 = ((org$luaj$vm2$compiler$FuncState.prototype.I$codeABC$I$I$I$I.call(phi42,phi43,phi44,phi45,0))) | 0;
       // Here was a goto statement
       phi5 = phi39;
       phi6 = phi40;
       phi7 = (phi41) | 0;
       break TableSwitch_12_0;
      }
      case 3: {
       var32 = (1) | 0;
       var33 = (var0.u);
       var34 = ((var33.info)) | 0;
       var35 = ((org$luaj$vm2$compiler$FuncState.prototype.I$codeABx$I$I$I.call(this,var32,arg1,var34))) | 0;
       // Here was a goto statement
       phi5 = this;
       phi6 = var0;
       phi7 = (arg1) | 0;
       break TableSwitch_12_0;
      }
      case 4: {
       var26 = (1) | 0;
       var27 = this;
       var28 = (var0.u);
       var29 = (org$luaj$vm2$compiler$LexState$expdesc$U.prototype.Lorg$luaj$vm2$LuaValue$$nval$$.call(var28));
       var30 = ((org$luaj$vm2$compiler$FuncState.prototype.I$numberK$Lorg$luaj$vm2$LuaValue$.call(var27,var29))) | 0;
       var31 = ((org$luaj$vm2$compiler$FuncState.prototype.I$codeABx$I$I$I.call(this,var26,arg1,var30))) | 0;
       // Here was a goto statement
       phi5 = this;
       phi6 = var0;
       phi7 = (arg1) | 0;
       break TableSwitch_12_0;
      }
      case 5: {
       var19 = (var0.u);
       var20 = ((var19.info)) | 0;
       if (arg1 == var20) {
        phi5 = this;
        phi6 = var0;
        phi7 = (arg1) | 0;
        break TableSwitch_12_0;
       } else {
        var21 = this;
        var22 = (arg1) | 0;
        var23 = (var0.u);
        var24 = ((var23.info)) | 0;
        var25 = ((org$luaj$vm2$compiler$FuncState.prototype.I$codeABC$I$I$I$I.call(var21,0,var22,var24,0))) | 0;
        // Here was a goto statement
        phi5 = this;
        phi6 = var0;
        phi7 = (arg1) | 0;
        break TableSwitch_12_0;
       }
      }
      case 6: {
       var12 = ((var0.k)) | 0;
       If_44_0: {
        If_44_1: {
         if (var12 == 0) {
          phi15 = this;
          phi16 = var0;
          phi17 = (arg1) | 0;
          break If_44_1;
         } else {
          var13 = var0;
          var14 = ((var13.k)) | 0;
          if (var14 != 10) {
           phi15 = this;
           phi16 = var0;
           phi17 = (arg1) | 0;
           phi18 = (0) | 0;
           break If_44_0;
          } else {
           phi15 = this;
           phi16 = var0;
           phi17 = (arg1) | 0;
           break If_44_1;
          }
         }
        }
        // Here was a goto statement
        phi18 = (1) | 0;
        break If_44_0;
       }
       org$luaj$vm2$compiler$FuncState.$i;
       org$luaj$vm2$compiler$Constants.V$_assert$Z(phi18);
       return;
      }
      case 7: {
       var12 = ((var0.k)) | 0;
       If_44_0: {
        If_44_1: {
         if (var12 == 0) {
          phi15 = this;
          phi16 = var0;
          phi17 = (arg1) | 0;
          break If_44_1;
         } else {
          var13 = var0;
          var14 = ((var13.k)) | 0;
          if (var14 != 10) {
           phi15 = this;
           phi16 = var0;
           phi17 = (arg1) | 0;
           phi18 = (0) | 0;
           break If_44_0;
          } else {
           phi15 = this;
           phi16 = var0;
           phi17 = (arg1) | 0;
           break If_44_1;
          }
         }
        }
        // Here was a goto statement
        phi18 = (1) | 0;
        break If_44_0;
       }
       org$luaj$vm2$compiler$FuncState.$i;
       org$luaj$vm2$compiler$Constants.V$_assert$Z(phi18);
       return;
      }
      case 8: {
       var12 = ((var0.k)) | 0;
       If_44_0: {
        If_44_1: {
         if (var12 == 0) {
          phi15 = this;
          phi16 = var0;
          phi17 = (arg1) | 0;
          break If_44_1;
         } else {
          var13 = var0;
          var14 = ((var13.k)) | 0;
          if (var14 != 10) {
           phi15 = this;
           phi16 = var0;
           phi17 = (arg1) | 0;
           phi18 = (0) | 0;
           break If_44_0;
          } else {
           phi15 = this;
           phi16 = var0;
           phi17 = (arg1) | 0;
           break If_44_1;
          }
         }
        }
        // Here was a goto statement
        phi18 = (1) | 0;
        break If_44_0;
       }
       org$luaj$vm2$compiler$FuncState.$i;
       org$luaj$vm2$compiler$Constants.V$_assert$Z(phi18);
       return;
      }
      case 9: {
       var12 = ((var0.k)) | 0;
       If_44_0: {
        If_44_1: {
         if (var12 == 0) {
          phi15 = this;
          phi16 = var0;
          phi17 = (arg1) | 0;
          break If_44_1;
         } else {
          var13 = var0;
          var14 = ((var13.k)) | 0;
          if (var14 != 10) {
           phi15 = this;
           phi16 = var0;
           phi17 = (arg1) | 0;
           phi18 = (0) | 0;
           break If_44_0;
          } else {
           phi15 = this;
           phi16 = var0;
           phi17 = (arg1) | 0;
           break If_44_1;
          }
         }
        }
        // Here was a goto statement
        phi18 = (1) | 0;
        break If_44_0;
       }
       org$luaj$vm2$compiler$FuncState.$i;
       org$luaj$vm2$compiler$Constants.V$_assert$Z(phi18);
       return;
      }
      case 10: {
       var3 = (org$luaj$vm2$compiler$FuncState.prototype.Lorg$luaj$vm2$compiler$InstructionPtr$$getcodePtr$Lorg$luaj$vm2$compiler$LexState$expdesc$.call(this,var0));
       var4 = var3;
       org$luaj$vm2$compiler$FuncState.$i;
       org$luaj$vm2$compiler$Constants.V$SETARG_A$Lorg$luaj$vm2$compiler$InstructionPtr$$I(var4,arg1);
       // Here was a goto statement
       phi5 = this;
       phi6 = var0;
       phi7 = (arg1) | 0;
       break TableSwitch_12_0;
      }
     } else {
      var12 = ((var0.k)) | 0;
      If_44_0: {
       If_44_1: {
        if (var12 == 0) {
         phi15 = this;
         phi16 = var0;
         phi17 = (arg1) | 0;
         break If_44_1;
        } else {
         var13 = var0;
         var14 = ((var13.k)) | 0;
         if (var14 != 10) {
          phi15 = this;
          phi16 = var0;
          phi17 = (arg1) | 0;
          phi18 = (0) | 0;
          break If_44_0;
         } else {
          phi15 = this;
          phi16 = var0;
          phi17 = (arg1) | 0;
          break If_44_1;
         }
        }
       }
       // Here was a goto statement
       phi18 = (1) | 0;
       break If_44_0;
      }
      org$luaj$vm2$compiler$FuncState.$i;
      org$luaj$vm2$compiler$Constants.V$_assert$Z(phi18);
      return;
     }
    }
    var8 = phi6;
    var9 = (var8.u);
    var10 = (phi7) | 0;
    var9.info = var10;
    var11 = phi6;
    var11.k = 6;
    return;
  }

  I$numberK$Lorg$luaj$vm2$LuaValue$(arg0) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = .0;
    var var4 = .0;
    var var5 = 0;
    var var6 = .0;
    var var7 = .0;
    var var8 = 0;
    var var9 = 0;
    var var10 = null;
    var phi11 = null;
    var phi12 = null;
    var phi13 = .0;
    var phi14 = 0;
    var var15 = null;
    var var16 = null;
    var var17 = 0;
    var0 = arg0;
    var1 = (bytecoder.instanceOf(var0,org$luaj$vm2$LuaDouble)) | 0;
    If_9_0: {
     if (var1 == 0) {
      phi11 = this;
      phi12 = var0;
      break If_9_0;
     } else {
      var2 = var0;
      var3 = (var2.D$todouble$$());
      var4 = var3;
      var5 = ((var4 | 0)) | 0;
      var6 = var3;
      var7 = var5;
      var8 = (bytecoder.cmp(var6,var7)) | 0;
      if (var8 != 0) {
       phi11 = this;
       phi12 = var0;
       phi13 = var3;
       phi14 = (var5) | 0;
       break If_9_0;
      } else {
       var9 = (var5) | 0;
       org$luaj$vm2$LuaInteger.$i;
       var10 = (org$luaj$vm2$LuaInteger.Lorg$luaj$vm2$LuaInteger$$valueOf$I(var9));
       phi11 = this;
       phi12 = var10;
       phi13 = var3;
       phi14 = (var5) | 0;
       break If_9_0;
      }
     }
    }
    var15 = phi11;
    var16 = phi12;
    var17 = ((org$luaj$vm2$compiler$FuncState.prototype.I$addk$Lorg$luaj$vm2$LuaValue$.call(var15,var16))) | 0;
    return var17;
  }

  I$codeABx$I$I$I(arg0,arg1,arg2) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var phi5 = null;
    var phi6 = 0;
    var phi7 = 0;
    var phi8 = 0;
    var phi9 = 0;
    var var10 = 0;
    var var11 = 0;
    var var12 = 0;
    var phi13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = 0;
    var phi17 = 0;
    var var18 = null;
    var var19 = 0;
    var var20 = 0;
    var var21 = 0;
    var var22 = 0;
    var var23 = null;
    var var24 = null;
    var var25 = 0;
    var var26 = 0;
    var0 = (arg0) | 0;
    var1 = (arg2) | 0;
    org$luaj$vm2$compiler$FuncState.$i;
    var2 = ((org$luaj$vm2$Lua.I$getOpMode$I(var0))) | 0;
    If_15_0: {
     If_15_1: {
      if (var2 == 1) {
       phi5 = this;
       phi6 = (var0) | 0;
       phi7 = (arg1) | 0;
       phi8 = (var1) | 0;
       break If_15_1;
      } else {
       var3 = (var0) | 0;
       var4 = ((org$luaj$vm2$Lua.I$getOpMode$I(var3))) | 0;
       if (var4 != 2) {
        phi5 = this;
        phi6 = (var0) | 0;
        phi7 = (arg1) | 0;
        phi8 = (var1) | 0;
        phi9 = (0) | 0;
        break If_15_0;
       } else {
        phi5 = this;
        phi6 = (var0) | 0;
        phi7 = (arg1) | 0;
        phi8 = (var1) | 0;
        break If_15_1;
       }
      }
     }
     // Here was a goto statement
     phi9 = (1) | 0;
     break If_15_0;
    }
    org$luaj$vm2$compiler$Constants.V$_assert$Z(phi9);
    var10 = (phi6) | 0;
    var11 = ((org$luaj$vm2$Lua.I$getCMode$I(var10))) | 0;
    If_43_0: {
     if (var11 != 0) {
      phi13 = (0) | 0;
      break If_43_0;
     } else {
      var12 = (1) | 0;
      // Here was a goto statement
      phi13 = (var12) | 0;
      break If_43_0;
     }
    }
    org$luaj$vm2$compiler$Constants.V$_assert$Z(phi13);
    var14 = (phi8) | 0;
    If_56_0: {
     If_56_1: {
      if (var14 < 0) {
       break If_56_1;
      } else {
       var15 = (phi8) | 0;
       if (var15 > 262143) {
        break If_56_1;
       } else {
        var16 = (1) | 0;
        // Here was a goto statement
        phi17 = (var16) | 0;
        break If_56_0;
       }
      }
     }
     phi17 = (0) | 0;
     break If_56_0;
    }
    org$luaj$vm2$compiler$Constants.V$_assert$Z(phi17);
    var18 = phi5;
    var19 = (phi6) | 0;
    var20 = (phi7) | 0;
    var21 = (phi8) | 0;
    var22 = ((org$luaj$vm2$compiler$Constants.I$CREATE_ABx$I$I$I(var19,var20,var21))) | 0;
    var23 = phi5;
    var24 = (var23.ls);
    var25 = ((var24.lastline)) | 0;
    var26 = ((org$luaj$vm2$compiler$FuncState.prototype.I$code$I$I.call(var18,var22,var25))) | 0;
    return var26;
  }

  V$nil$I$I(arg0,arg1) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = null;
    var var5 = 0;
    var var6 = 0;
    var var7 = null;
    var var8 = 0;
    var var9 = null;
    var var10 = null;
    var var11 = null;
    var var12 = 0;
    var var13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = 0;
    var var17 = 0;
    var var18 = 0;
    var var19 = 0;
    var var20 = 0;
    var var21 = 0;
    var var22 = 0;
    var var23 = 0;
    var var24 = 0;
    var var25 = 0;
    var phi26 = null;
    var phi27 = 0;
    var phi28 = 0;
    var phi29 = 0;
    var phi30 = 0;
    var phi31 = 0;
    var phi32 = 0;
    var var33 = 0;
    var var34 = 0;
    var var35 = 0;
    var var36 = 0;
    var var37 = 0;
    var var38 = 0;
    var var39 = 0;
    var var40 = 0;
    var phi41 = 0;
    var var42 = 0;
    var var43 = 0;
    var var44 = 0;
    var phi45 = 0;
    var var46 = null;
    var var47 = null;
    var var48 = null;
    var var49 = null;
    var var50 = null;
    var var51 = 0;
    var var52 = 0;
    var var53 = null;
    var var54 = 0;
    var var55 = 0;
    var var56 = 0;
    var var57 = 0;
    var var58 = null;
    var var59 = 0;
    var var60 = 0;
    var var61 = 0;
    var var62 = 0;
    var0 = (arg0) | 0;
    var1 = (arg1) | 0;
    var2 = ((var0 + var1)) | 0;
    var3 = ((var2 - 1)) | 0;
    var4 = this;
    var5 = ((var4.pc)) | 0;
    var6 = ((this.lasttarget)) | 0;
    If_23_0: {
     if (var5 <= var6) {
      phi26 = this;
      phi27 = (var0) | 0;
      phi28 = (arg1) | 0;
      phi29 = (var3) | 0;
      break If_23_0;
     } else {
      var7 = this;
      var8 = ((var7.pc)) | 0;
      if (var8 <= 0) {
       phi26 = this;
       phi27 = (var0) | 0;
       phi28 = (arg1) | 0;
       phi29 = (var3) | 0;
       break If_23_0;
      } else {
       var9 = this;
       var10 = (var9.f);
       var11 = (var10.code);
       var12 = ((this.pc)) | 0;
       var13 = ((var12 - 1)) | 0;
       var14 = ((var11.data[var13])) | 0;
       var15 = (var14) | 0;
       org$luaj$vm2$compiler$FuncState.$i;
       var16 = ((org$luaj$vm2$Lua.I$GET_OPCODE$I(var15))) | 0;
       if (var16 != 4) {
        phi26 = this;
        phi27 = (var0) | 0;
        phi28 = (arg1) | 0;
        phi29 = (var3) | 0;
        phi30 = (var14) | 0;
        break If_23_0;
       } else {
        var17 = (var14) | 0;
        var18 = ((org$luaj$vm2$Lua.I$GETARG_A$I(var17))) | 0;
        var19 = (var18) | 0;
        var20 = ((org$luaj$vm2$Lua.I$GETARG_B$I(var14))) | 0;
        var21 = ((var19 + var20)) | 0;
        var22 = (var18) | 0;
        If_78_0: {
         If_78_1: {
          if (var22 > var0) {
           phi26 = this;
           phi27 = (var0) | 0;
           phi28 = (arg1) | 0;
           phi29 = (var3) | 0;
           phi30 = (var14) | 0;
           phi31 = (var18) | 0;
           phi32 = (var21) | 0;
           break If_78_1;
          } else {
           var23 = (var0) | 0;
           var24 = (1) | 0;
           var25 = ((var21 + var24)) | 0;
           if (var23 <= var25) {
            phi26 = this;
            phi27 = (var0) | 0;
            phi28 = (arg1) | 0;
            phi29 = (var3) | 0;
            phi30 = (var14) | 0;
            phi31 = (var18) | 0;
            phi32 = (var21) | 0;
            break If_78_0;
           } else {
            phi26 = this;
            phi27 = (var0) | 0;
            phi28 = (arg1) | 0;
            phi29 = (var3) | 0;
            phi30 = (var14) | 0;
            phi31 = (var18) | 0;
            phi32 = (var21) | 0;
            break If_78_1;
           }
          }
         }
         var33 = (phi27) | 0;
         var34 = (phi31) | 0;
         if (var33 > var34) {
          break If_23_0;
         } else {
          var35 = (phi31) | 0;
          var36 = (phi29) | 0;
          var37 = ((var36 + 1)) | 0;
          if (var35 > var37) {
           break If_23_0;
          } else {
           break If_78_0;
          }
         }
        }
        var38 = (phi31) | 0;
        var39 = (phi27) | 0;
        If_119_0: {
         if (var38 >= var39) {
          phi41 = (phi27) | 0;
          break If_119_0;
         } else {
          var40 = (phi31) | 0;
          phi41 = (var40) | 0;
          break If_119_0;
         }
        }
        var42 = (phi32) | 0;
        var43 = (phi29) | 0;
        If_129_0: {
         if (var42 <= var43) {
          phi45 = (phi29) | 0;
          break If_129_0;
         } else {
          var44 = (phi32) | 0;
          phi45 = (var44) | 0;
          break If_129_0;
         }
        }
        var46 = new org$luaj$vm2$compiler$InstructionPtr();
        var47 = phi26;
        var48 = (var47.f);
        var49 = (var48.code);
        var50 = phi26;
        var51 = ((var50.pc)) | 0;
        var52 = ((var51 - 1)) | 0;
        org$luaj$vm2$compiler$InstructionPtr.prototype.V$$init$$$I$I.call(var46,var49,var52);
        var53 = var46;
        var54 = (phi41) | 0;
        org$luaj$vm2$compiler$Constants.V$SETARG_A$Lorg$luaj$vm2$compiler$InstructionPtr$$I(var53,var54);
        var55 = (phi45) | 0;
        var56 = (phi41) | 0;
        var57 = ((var55 - var56)) | 0;
        org$luaj$vm2$compiler$Constants.V$SETARG_B$Lorg$luaj$vm2$compiler$InstructionPtr$$I(var46,var57);
        return;
       }
      }
     }
    }
    var58 = phi26;
    var59 = (phi27) | 0;
    var60 = (phi28) | 0;
    var61 = ((var60 - 1)) | 0;
    var62 = ((org$luaj$vm2$compiler$FuncState.prototype.I$codeABC$I$I$I$I.call(var58,4,var59,var61,0))) | 0;
    return;
  }

  V$concat$Lorg$luaj$vm2$compiler$IntPtr$$I(arg0,arg1) {
    var var0 = null;
    var var1 = 0;
    var var2 = 0;
    var var3 = null;
    var phi4 = null;
    var phi5 = null;
    var phi6 = 0;
    var var7 = 0;
    var phi8 = null;
    var phi9 = null;
    var phi10 = 0;
    var phi11 = 0;
    var var12 = null;
    var var13 = 0;
    var var14 = 0;
    var var15 = 0;
    var var16 = 0;
    var var17 = null;
    var var18 = 0;
    var var19 = 0;
    var0 = arg0;
    var1 = (-1) | 0;
    if (arg1 != var1) {
     var2 = ((var0.i)) | 0;
     If_17_0: {
      if (var2 != -1) {
       var7 = ((var0.i)) | 0;
       phi8 = this;
       phi9 = var0;
       phi10 = (arg1) | 0;
       phi11 = (var7) | 0;
       L886723453: while(true) {
        var12 = phi8;
        var13 = (phi11) | 0;
        var14 = ((org$luaj$vm2$compiler$FuncState.prototype.I$getjump$I.call(var12,var13))) | 0;
        var15 = (var14) | 0;
        if (var14 == -1) {
         var17 = phi8;
         var18 = (phi11) | 0;
         var19 = (phi10) | 0;
         org$luaj$vm2$compiler$FuncState.prototype.V$fixjump$I$I.call(var17,var18,var19);
         phi4 = phi8;
         phi5 = phi9;
         phi6 = (phi10) | 0;
         break If_17_0;
        } else {
         var16 = (var15) | 0;
         // Here was a goto statement
         phi11 = (var16) | 0;
         continue L886723453;
        }
       }
      } else {
       var3 = var0;
       var3.i = arg1;
       // Here was a goto statement
       phi4 = this;
       phi5 = var0;
       phi6 = (arg1) | 0;
       break If_17_0;
      }
     }
     return;
    } else {
     return;
    }
  }

  Z$need_value$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var var6 = 0;
    var var7 = 0;
    var var8 = 0;
    var var9 = 0;
    var0 = (arg0) | 0;
    L213039946: while(true) {
     var1 = (-1) | 0;
     if (var0 == var1) {
      return 0;
     } else {
      var2 = this;
      var3 = (org$luaj$vm2$compiler$FuncState.prototype.Lorg$luaj$vm2$compiler$InstructionPtr$$getjumpcontrol$I.call(var2,var0));
      var4 = ((org$luaj$vm2$compiler$InstructionPtr.prototype.I$get$$.call(var3))) | 0;
      var5 = (var4) | 0;
      org$luaj$vm2$compiler$FuncState.$i;
      var6 = ((org$luaj$vm2$Lua.I$GET_OPCODE$I(var5))) | 0;
      if (var6 == 28) {
       var8 = (var0) | 0;
       var9 = ((org$luaj$vm2$compiler$FuncState.prototype.I$getjump$I.call(this,var8))) | 0;
       // Here was a goto statement
       var0 = (var9) | 0;
       continue L213039946;
      } else {
       var7 = (1) | 0;
       return var7;
      }
     }
    }
  }

  I$code_label$I$I$I(arg0,arg1,arg2) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var0 = (arg0) | 0;
    var1 = (arg2) | 0;
    var2 = ((org$luaj$vm2$compiler$FuncState.prototype.I$getlabel$$.call(this))) | 0;
    var3 = this;
    var4 = (arg1) | 0;
    var5 = ((org$luaj$vm2$compiler$FuncState.prototype.I$codeABC$I$I$I$I.call(var3,3,var0,var4,var1))) | 0;
    return var5;
  }

  I$getlabel$$() {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = 0;
    var0 = this;
    var1 = var0;
    var2 = ((var1.pc)) | 0;
    var0.lasttarget = var2;
    var3 = ((var0.pc)) | 0;
    return var3;
  }

  V$patchtohere$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var0 = (arg0) | 0;
    var1 = ((org$luaj$vm2$compiler$FuncState.prototype.I$getlabel$$.call(this))) | 0;
    var2 = this;
    var3 = (this.jpc);
    org$luaj$vm2$compiler$FuncState.prototype.V$concat$Lorg$luaj$vm2$compiler$IntPtr$$I.call(var2,var3,var0);
    return;
  }

  I$jump$$() {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = null;
    var var5 = null;
    var var6 = 0;
    var var7 = 0;
    var var8 = null;
    var var9 = 0;
    var var10 = 0;
    var0 = (this.jpc);
    var1 = ((var0.i)) | 0;
    var2 = this;
    var3 = (var2.jpc);
    var3.i = -1;
    var4 = new org$luaj$vm2$compiler$IntPtr();
    var5 = this;
    var6 = (0) | 0;
    var7 = ((org$luaj$vm2$compiler$FuncState.prototype.I$codeAsBx$I$I$I.call(var5,23,var6,-1))) | 0;
    org$luaj$vm2$compiler$IntPtr.prototype.V$$init$$I.call(var4,var7);
    var8 = this;
    var9 = (var1) | 0;
    org$luaj$vm2$compiler$FuncState.prototype.V$concat$Lorg$luaj$vm2$compiler$IntPtr$$I.call(var8,var4,var9);
    var10 = ((var4.i)) | 0;
    return var10;
  }

  I$codeAsBx$I$I$I(arg0,arg1,arg2) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var0 = (arg0) | 0;
    var1 = (arg2) | 0;
    var2 = (var0) | 0;
    var3 = (var1) | 0;
    var4 = ((var3 + 131071)) | 0;
    var5 = ((org$luaj$vm2$compiler$FuncState.prototype.I$codeABx$I$I$I.call(this,var2,arg1,var4))) | 0;
    return var5;
  }

  V$exp2nextreg$Lorg$luaj$vm2$compiler$LexState$expdesc$(arg0) {
    var var0 = null;
    var var1 = null;
    var var2 = 0;
    var var3 = null;
    var var4 = 0;
    var var5 = 0;
    var0 = arg0;
    var1 = var0;
    org$luaj$vm2$compiler$FuncState.prototype.V$dischargevars$Lorg$luaj$vm2$compiler$LexState$expdesc$.call(this,var1);
    org$luaj$vm2$compiler$FuncState.prototype.V$freeexp$Lorg$luaj$vm2$compiler$LexState$expdesc$.call(this,var0);
    var2 = (1) | 0;
    org$luaj$vm2$compiler$FuncState.prototype.V$reserveregs$I.call(this,var2);
    var3 = this;
    var4 = (var3.freereg);
    var5 = ((var4 - 1)) | 0;
    org$luaj$vm2$compiler$FuncState.prototype.V$exp2reg$Lorg$luaj$vm2$compiler$LexState$expdesc$$I.call(this,var0,var5);
    return;
  }

  V$freeexp$Lorg$luaj$vm2$compiler$LexState$expdesc$(arg0) {
    var var0 = null;
    var var1 = 0;
    var var2 = null;
    var var3 = null;
    var var4 = 0;
    var phi5 = null;
    var phi6 = null;
    var0 = arg0;
    var1 = ((var0.k)) | 0;
    If_9_0: {
     if (var1 != 6) {
      phi5 = this;
      phi6 = var0;
      break If_9_0;
     } else {
      var2 = this;
      var3 = (var0.u);
      var4 = ((var3.info)) | 0;
      org$luaj$vm2$compiler$FuncState.prototype.V$freereg$I.call(var2,var4);
      phi5 = this;
      phi6 = var0;
      break If_9_0;
     }
    }
    return;
  }

  V$reserveregs$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = null;
    var var3 = 0;
    var var4 = 0;
    var var5 = 0;
    var0 = (arg0) | 0;
    var1 = (var0) | 0;
    org$luaj$vm2$compiler$FuncState.prototype.V$checkstack$I.call(this,var1);
    var2 = this;
    var3 = (var2.freereg);
    var4 = ((var3 + var0)) | 0;
    var5 = var4;
    var2.freereg = var5;
    return;
  }

  V$checkstack$I(arg0) {
    var var0 = 0;
    var var1 = 0;
    var var2 = 0;
    var var3 = 0;
    var var4 = null;
    var var5 = 0;
    var var6 = 0;
    var var7 = null;
    var var8 = null;
    var phi9 = null;
    var phi10 = 0;
    var phi11 = 0;
    var var12 = null;
    var var13 = null;
    var var14 = 0;
    var0 = (arg0) | 0;
    var1 = (this.freereg);
    var2 = ((var1 + var0)) | 0;
    var3 = (var2) | 0;
    var4 = (this.f);
    var5 = ((var4.maxstacksize)) | 0;
    If_19_0: {
     if (var3 <= var5) {
      phi9 = this;
      phi10 = (var0) | 0;
      phi11 = (var2) | 0;
      break If_19_0;
     } else {
      var6 = (var2) | 0;
      If_24_0: {
       if (var6 < 250) {
        phi9 = this;
        phi10 = (var0) | 0;
        phi11 = (var2) | 0;
        break If_24_0;
       } else {
        var7 = this;
        var8 = (var7.ls);
        org$luaj$vm2$compiler$LexState.prototype.V$syntaxerror$Ljava$lang$String$.call(var8,bytecoder.stringconstants[356]);
        phi9 = this;
        phi10 = (var0) | 0;
        phi11 = (var2) | 0;
        break If_24_0;
    