/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.maven;

import de.mirkosertic.bytecoder.api.Logger;
import de.mirkosertic.bytecoder.core.Slf4JLogger;
import de.mirkosertic.bytecoder.core.backend.CompileOptions;
import de.mirkosertic.bytecoder.core.backend.CompileResult;
import de.mirkosertic.bytecoder.core.backend.js.JSBackend;
import de.mirkosertic.bytecoder.core.backend.js.JSCompileResult;
import de.mirkosertic.bytecoder.core.backend.js.JSIntrinsics;
import de.mirkosertic.bytecoder.core.backend.wasm.WasmBackend;
import de.mirkosertic.bytecoder.core.backend.wasm.WasmCompileResult;
import de.mirkosertic.bytecoder.core.backend.wasm.WasmIntrinsics;
import de.mirkosertic.bytecoder.core.ir.AnalysisStack;
import de.mirkosertic.bytecoder.core.loader.BytecoderLoader;
import de.mirkosertic.bytecoder.core.optimizer.Optimizations;
import de.mirkosertic.bytecoder.core.optimizer.Optimizer;
import de.mirkosertic.bytecoder.core.parser.CompileUnit;
import de.mirkosertic.bytecoder.core.parser.Intrinsic;
import de.mirkosertic.bytecoder.core.parser.Loader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.objectweb.asm.Type;

@Mojo(name="compile", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class BytecoderMavenMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File classFiles;
    @Parameter(required=true)
    protected String mainClass;
    @Parameter(required=true, defaultValue="js")
    protected String backend;
    @Parameter(defaultValue="${project.build.directory}")
    protected String buildDirectory;
    @Parameter(required=false, defaultValue="false")
    protected boolean debugOutput;
    @Parameter(required=false, defaultValue="ALL")
    protected String optimizationLevel;
    @Parameter(required=false, defaultValue="bytecoder")
    protected String filenamePrefix;
    @Parameter(required=false)
    protected String[] additionalClassesToLink = new String[0];
    @Parameter(required=false)
    protected String[] additionalResources = new String[0];

    public void execute() throws MojoExecutionException {
        File baseDirectory = new File(this.buildDirectory);
        File bytecoderDirectory = new File(baseDirectory, "bytecoder");
        bytecoderDirectory.mkdirs();
        try {
            ClassLoader classLoader = this.prepareClassLoader();
            BytecoderLoader loader = new BytecoderLoader(classLoader);
            if ("js".equals(this.backend)) {
                CompileUnit compileUnit = new CompileUnit((Loader)loader, (Logger)new Slf4JLogger(), (Intrinsic)new JSIntrinsics());
                Type invokedType = Type.getObjectType((String)this.mainClass.replace('.', '/'));
                compileUnit.resolveMainMethod(invokedType, "main", Type.getMethodType((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType((String)"[Ljava/lang/String;")}));
                for (String string : this.additionalClassesToLink) {
                    compileUnit.resolveClass(Type.getObjectType((String)string.replace('.', '/')), new AnalysisStack());
                }
                compileUnit.finalizeLinkingHierarchy();
                compileUnit.logStatistics();
                CompileOptions compileOptions = new CompileOptions((Logger)new Slf4JLogger(), (Optimizer)Optimizations.valueOf((String)this.optimizationLevel), this.additionalResources, this.filenamePrefix, this.debugOutput);
                JSBackend backend = new JSBackend();
                JSCompileResult result = backend.generateCodeFor(compileUnit, compileOptions);
                for (CompileResult.Content content : result.getContent()) {
                    File theBytecoderFileName = new File(bytecoderDirectory, content.getFileName());
                    try (FileOutputStream theFos = new FileOutputStream(theBytecoderFileName);){
                        content.writeTo((OutputStream)theFos);
                    }
                }
            } else {
                CompileUnit compileUnit = new CompileUnit((Loader)loader, (Logger)new Slf4JLogger(), (Intrinsic)new WasmIntrinsics());
                Type invokedType = Type.getObjectType((String)this.mainClass.replace('.', '/'));
                compileUnit.resolveMainMethod(invokedType, "main", Type.getMethodType((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType((String)"[Ljava/lang/String;")}));
                for (String string : this.additionalClassesToLink) {
                    compileUnit.resolveClass(Type.getObjectType((String)string.replace('.', '/')), new AnalysisStack());
                }
                compileUnit.finalizeLinkingHierarchy();
                compileUnit.logStatistics();
                CompileOptions compileOptions = new CompileOptions((Logger)new Slf4JLogger(), (Optimizer)Optimizations.valueOf((String)this.optimizationLevel), this.additionalResources, this.filenamePrefix, this.debugOutput);
                WasmBackend backend = new WasmBackend();
                WasmCompileResult result = backend.generateCodeFor(compileUnit, compileOptions);
                for (CompileResult.Content content : result.getContent()) {
                    File theBytecoderFileName = new File(bytecoderDirectory, content.getFileName());
                    try (FileOutputStream theFos = new FileOutputStream(theBytecoderFileName);){
                        content.writeTo((OutputStream)theFos);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error running bytecoder", e);
        }
    }

    protected boolean isSupportedScope(String scope) {
        switch (scope) {
            case "compile": 
            case "provided": 
            case "system": {
                return true;
            }
        }
        return false;
    }

    protected final ClassLoader prepareClassLoader() throws MojoExecutionException {
        try {
            ArrayList<URL> theURLs = new ArrayList<URL>();
            for (Artifact artifact : this.project.getArtifacts()) {
                if (!this.isSupportedScope(artifact.getScope())) continue;
                File file = artifact.getFile();
                theURLs.add(file.toURI().toURL());
            }
            theURLs.add(this.classFiles.toURI().toURL());
            return new URLClassLoader(theURLs.toArray(new URL[0]), ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Cannot create classloader", (Exception)e);
        }
    }
}

