/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.api.opencl;

import de.mirkosertic.bytecoder.api.opencl.FloatSerializable;
import de.mirkosertic.bytecoder.api.opencl.OpenCLFunction;
import de.mirkosertic.bytecoder.api.opencl.OpenCLType;
import java.nio.FloatBuffer;

@OpenCLType(name="float16", elementCount=16)
public class Float16
implements FloatSerializable {
    public float s0;
    public float s1;
    public float s2;
    public float s3;
    public float s4;
    public float s5;
    public float s6;
    public float s7;
    public float s8;
    public float s9;
    public float sa;
    public float sb;
    public float sc;
    public float sd;
    public float se;
    public float sf;

    @OpenCLFunction(value="float16", literal=true)
    public static Float16 float16(float aS0, float aS1, float aS2, float aS3, float aS4, float aS5, float aS6, float aS7, float aS8, float aS9, float aSa, float aSb, float aSc, float aSd, float aSe, float aSf) {
        return new Float16(aS0, aS1, aS2, aS3, aS4, aS5, aS6, aS7, aS8, aS9, aSa, aSb, aSc, aSd, aSe, aSf);
    }

    private Float16(float aS0, float aS1, float aS2, float aS3, float aS4, float aS5, float aS6, float aS7, float aS8, float aS9, float aSa, float aSb, float aSc, float aSd, float aSe, float aSf) {
        this.s0 = aS0;
        this.s1 = aS1;
        this.s2 = aS2;
        this.s3 = aS3;
        this.s4 = aS4;
        this.s5 = aS5;
        this.s6 = aS6;
        this.s7 = aS7;
        this.s8 = aS8;
        this.s9 = aS9;
        this.sa = aSa;
        this.sb = aSb;
        this.sc = aSc;
        this.sd = aSd;
        this.se = aSe;
        this.sf = aSf;
    }

    @Override
    public void writeTo(FloatBuffer aBuffer) {
        aBuffer.put(this.s0).put(this.s1).put(this.s2).put(this.s3).put(this.s4).put(this.s5).put(this.s6).put(this.s7).put(this.s8).put(this.s9).put(this.sa).put(this.sb).put(this.sc).put(this.sd).put(this.se).put(this.sf);
    }

    @Override
    public void readFrom(FloatBuffer aBuffer) {
        this.s0 = aBuffer.get();
        this.s1 = aBuffer.get();
        this.s2 = aBuffer.get();
        this.s3 = aBuffer.get();
        this.s4 = aBuffer.get();
        this.s5 = aBuffer.get();
        this.s6 = aBuffer.get();
        this.s7 = aBuffer.get();
        this.s8 = aBuffer.get();
        this.s9 = aBuffer.get();
        this.sa = aBuffer.get();
        this.sb = aBuffer.get();
        this.sc = aBuffer.get();
        this.sd = aBuffer.get();
        this.se = aBuffer.get();
        this.sf = aBuffer.get();
    }

    public String toString() {
        return "float16{s0=" + this.s0 + ", s1=" + this.s1 + ", s2=" + this.s2 + ", s3=" + this.s3 + ", s4=" + this.s4 + ", s5=" + this.s5 + ", s6=" + this.s6 + ", s7=" + this.s7 + ", s8=" + this.s8 + ", s9=" + this.s9 + ", sa=" + this.sa + ", sb=" + this.sb + ", sc=" + this.sc + ", sd=" + this.sd + ", se=" + this.se + ", sf=" + this.sf + '}';
    }

    static Float16 normalize(Float16 aVector) {
        throw new IllegalArgumentException("Not implemented for CPU emulation");
    }

    float length() {
        float theSquareSum = 0.0f;
        theSquareSum += this.s0 * this.s0;
        theSquareSum += this.s1 * this.s1;
        theSquareSum += this.s2 * this.s2;
        theSquareSum += this.s3 * this.s3;
        theSquareSum += this.s4 * this.s4;
        theSquareSum += this.s5 * this.s5;
        theSquareSum += this.s6 * this.s6;
        theSquareSum += this.s7 * this.s7;
        theSquareSum += this.s8 * this.s8;
        theSquareSum += this.s9 * this.s9;
        theSquareSum += this.sa * this.sa;
        theSquareSum += this.sb * this.sb;
        theSquareSum += this.sc * this.sc;
        theSquareSum += this.sd * this.sd;
        theSquareSum += this.se * this.se;
        return (float)Math.sqrt(theSquareSum += this.sf * this.sf);
    }

    Float16 cross(Float16 aOtherVector) {
        return new Float16(this.s0 * aOtherVector.s0, this.s1 * aOtherVector.s1, this.s2 * aOtherVector.s2, this.s3 * aOtherVector.s3, this.s4 * aOtherVector.s4, this.s5 * aOtherVector.s5, this.s6 * aOtherVector.s6, this.s7 * aOtherVector.s7, this.s8 * aOtherVector.s8, this.s9 * aOtherVector.s9, this.sa * aOtherVector.sa, this.sb * aOtherVector.sb, this.sc * aOtherVector.sc, this.sd * aOtherVector.sd, this.se * aOtherVector.se, this.sf * aOtherVector.sf);
    }

    float dot(Float16 aOtherVector) {
        float theDotProduct = 0.0f;
        theDotProduct += this.s0 * aOtherVector.s0;
        theDotProduct += this.s1 * aOtherVector.s1;
        theDotProduct += this.s2 * aOtherVector.s2;
        theDotProduct += this.s3 * aOtherVector.s3;
        theDotProduct += this.s4 * aOtherVector.s4;
        theDotProduct += this.s5 * aOtherVector.s5;
        theDotProduct += this.s6 * aOtherVector.s6;
        theDotProduct += this.s7 * aOtherVector.s7;
        theDotProduct += this.s8 * aOtherVector.s8;
        theDotProduct += this.s9 * aOtherVector.s9;
        theDotProduct += this.sa * aOtherVector.sa;
        theDotProduct += this.sb * aOtherVector.sb;
        theDotProduct += this.sc * aOtherVector.sc;
        theDotProduct += this.sd * aOtherVector.sd;
        theDotProduct += this.se * aOtherVector.se;
        return theDotProduct += this.sf * aOtherVector.sf;
    }
}

