/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.api.opencl;

import de.mirkosertic.bytecoder.api.opencl.FloatSerializable;
import de.mirkosertic.bytecoder.api.opencl.OpenCLFunction;
import de.mirkosertic.bytecoder.api.opencl.OpenCLType;
import java.nio.FloatBuffer;

@OpenCLType(name="float2", elementCount=2)
public class Float2
implements FloatSerializable {
    public float s0;
    public float s1;

    @OpenCLFunction(value="float2", literal=true)
    public static Float2 float2(float aS0, float aS1) {
        return new Float2(aS0, aS1);
    }

    private Float2(float aS0, float aS1) {
        this.s0 = aS0;
        this.s1 = aS1;
    }

    @Override
    public void writeTo(FloatBuffer aBuffer) {
        aBuffer.put(this.s0).put(this.s1);
    }

    @Override
    public void readFrom(FloatBuffer aBuffer) {
        this.s0 = aBuffer.get();
        this.s1 = aBuffer.get();
    }

    public String toString() {
        return "float2{s0=" + this.s0 + ", s1=" + this.s1 + '}';
    }

    static Float2 normalize(Float2 aVector) {
        float length = aVector.length();
        return Float2.float2(aVector.s0 / length, aVector.s1 / length);
    }

    float length() {
        float theSquareSum = 0.0f;
        theSquareSum += this.s0 * this.s0;
        return (float)Math.sqrt(theSquareSum += this.s1 * this.s1);
    }

    Float2 cross(Float2 aOtherVector) {
        return new Float2(this.s0 * aOtherVector.s0, this.s1 * aOtherVector.s1);
    }

    float dot(Float2 aOtherVector) {
        float theDotProduct = 0.0f;
        theDotProduct += this.s0 * aOtherVector.s0;
        return theDotProduct += this.s1 * aOtherVector.s1;
    }
}

