/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.api.opencl;

import de.mirkosertic.bytecoder.api.opencl.FloatSerializable;
import de.mirkosertic.bytecoder.api.opencl.OpenCLFunction;
import de.mirkosertic.bytecoder.api.opencl.OpenCLType;
import java.nio.FloatBuffer;

@OpenCLType(name="float4", elementCount=4)
public class Float4
implements FloatSerializable {
    public float s0;
    public float s1;
    public float s2;
    public float s3;

    @OpenCLFunction(value="float4", literal=true)
    public static Float4 float4(float aS0, float aS1, float aS2, float aS3) {
        return new Float4(aS0, aS1, aS2, aS3);
    }

    private Float4(float aS0, float aS1, float aS2, float aS3) {
        this.s0 = aS0;
        this.s1 = aS1;
        this.s2 = aS2;
        this.s3 = aS3;
    }

    @Override
    public void writeTo(FloatBuffer aBuffer) {
        aBuffer.put(this.s0).put(this.s1).put(this.s2).put(this.s3);
    }

    @Override
    public void readFrom(FloatBuffer aBuffer) {
        this.s0 = aBuffer.get();
        this.s1 = aBuffer.get();
        this.s2 = aBuffer.get();
        this.s3 = aBuffer.get();
    }

    public String toString() {
        return "float4{s0=" + this.s0 + ", s1=" + this.s1 + ", s2=" + this.s2 + ", s3=" + this.s3 + '}';
    }

    static Float4 normalize(Float4 aVector) {
        throw new IllegalArgumentException("Not implemented for CPU emulation");
    }

    float length() {
        float theSquareSum = 0.0f;
        theSquareSum += this.s0 * this.s0;
        theSquareSum += this.s1 * this.s1;
        theSquareSum += this.s2 * this.s2;
        return (float)Math.sqrt(theSquareSum += this.s3 * this.s3);
    }

    Float4 cross(Float4 aOtherVector) {
        return new Float4(this.s0 * aOtherVector.s0, this.s1 * aOtherVector.s1, this.s2 * aOtherVector.s2, this.s3 * aOtherVector.s3);
    }

    float dot(Float4 aOtherVector) {
        float theDotProduct = 0.0f;
        theDotProduct += this.s0 * aOtherVector.s0;
        theDotProduct += this.s1 * aOtherVector.s1;
        theDotProduct += this.s2 * aOtherVector.s2;
        return theDotProduct += this.s3 * aOtherVector.s3;
    }
}

