/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.api.opencl;

import de.mirkosertic.bytecoder.api.opencl.FloatSerializable;
import de.mirkosertic.bytecoder.api.opencl.OpenCLFunction;
import de.mirkosertic.bytecoder.api.opencl.OpenCLType;
import java.nio.FloatBuffer;

@OpenCLType(name="float8", elementCount=8)
public class Float8
implements FloatSerializable {
    public float s0;
    public float s1;
    public float s2;
    public float s3;
    public float s4;
    public float s5;
    public float s6;
    public float s7;

    @OpenCLFunction(value="float8", literal=true)
    public static Float8 float8(float aS0, float aS1, float aS2, float aS3, float aS4, float aS5, float aS6, float aS7) {
        return new Float8(aS0, aS1, aS2, aS3, aS4, aS5, aS6, aS7);
    }

    private Float8(float aS0, float aS1, float aS2, float aS3, float aS4, float aS5, float aS6, float aS7) {
        this.s0 = aS0;
        this.s1 = aS1;
        this.s2 = aS2;
        this.s3 = aS3;
        this.s4 = aS4;
        this.s5 = aS5;
        this.s6 = aS6;
        this.s7 = aS7;
    }

    @Override
    public void writeTo(FloatBuffer aBuffer) {
        aBuffer.put(this.s0).put(this.s1).put(this.s2).put(this.s3).put(this.s4).put(this.s5).put(this.s6).put(this.s7);
    }

    @Override
    public void readFrom(FloatBuffer aBuffer) {
        this.s0 = aBuffer.get();
        this.s1 = aBuffer.get();
        this.s2 = aBuffer.get();
        this.s3 = aBuffer.get();
        this.s4 = aBuffer.get();
        this.s5 = aBuffer.get();
        this.s6 = aBuffer.get();
        this.s7 = aBuffer.get();
    }

    public String toString() {
        return "float8{s0=" + this.s0 + ", s1=" + this.s1 + ", s2=" + this.s2 + ", s3=" + this.s3 + ", s4=" + this.s4 + ", s5=" + this.s5 + ", s6=" + this.s6 + ", s7=" + this.s7 + '}';
    }

    static Float8 normalize(Float8 aVector) {
        throw new IllegalArgumentException("Not implemented for CPU emulation");
    }

    float length() {
        float theSquareSum = 0.0f;
        theSquareSum += this.s0 * this.s0;
        theSquareSum += this.s1 * this.s1;
        theSquareSum += this.s2 * this.s2;
        theSquareSum += this.s3 * this.s3;
        theSquareSum += this.s4 * this.s4;
        theSquareSum += this.s5 * this.s5;
        theSquareSum += this.s6 * this.s6;
        return (float)Math.sqrt(theSquareSum += this.s7 * this.s7);
    }

    Float8 cross(Float8 aOtherVector) {
        return new Float8(this.s0 * aOtherVector.s0, this.s1 * aOtherVector.s1, this.s2 * aOtherVector.s2, this.s3 * aOtherVector.s3, this.s4 * aOtherVector.s4, this.s5 * aOtherVector.s5, this.s6 * aOtherVector.s6, this.s7 * aOtherVector.s7);
    }

    float dot(Float8 aOtherVector) {
        float theDotProduct = 0.0f;
        theDotProduct += this.s0 * aOtherVector.s0;
        theDotProduct += this.s1 * aOtherVector.s1;
        theDotProduct += this.s2 * aOtherVector.s2;
        theDotProduct += this.s3 * aOtherVector.s3;
        theDotProduct += this.s4 * aOtherVector.s4;
        theDotProduct += this.s5 * aOtherVector.s5;
        theDotProduct += this.s6 * aOtherVector.s6;
        return theDotProduct += this.s7 * aOtherVector.s7;
    }
}

