/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.api.opencl;

import de.mirkosertic.bytecoder.api.opencl.OpenCLFunction;

public class GlobalFunctions {
    private static final ThreadLocal<Context> currentContext = new ThreadLocal();

    private static Context current() {
        Context theCurrent = currentContext.get();
        if (theCurrent == null) {
            theCurrent = new Context();
            currentContext.set(theCurrent);
        }
        return theCurrent;
    }

    @OpenCLFunction(value="get_global_id")
    public static int get_global_id(int aDimension) {
        return GlobalFunctions.current().currentWorkItekId;
    }

    @OpenCLFunction(value="get_global_size")
    public static int get_global_size(int aDimension) {
        return GlobalFunctions.current().size;
    }

    public static void set_global_id(int aDimension, int aId) {
        GlobalFunctions.current().currentWorkItekId = aId;
    }

    public static void set_global_size(int aDimension, int aSize) {
        GlobalFunctions.current().size = aSize;
    }

    private static class Context {
        int currentWorkItekId;
        int size;

        private Context() {
        }
    }
}

