/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.api.opencl;

import de.mirkosertic.bytecoder.api.opencl.DeviceProperties;
import de.mirkosertic.bytecoder.api.opencl.PlatformProperties;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Predicate;

public class OpenCLOptions {
    private final Predicate<PlatformProperties> platformFilter;
    private final Comparator<DeviceProperties> preferredDeviceComparator;

    public Predicate<PlatformProperties> getPlatformFilter() {
        return this.platformFilter;
    }

    public Comparator<DeviceProperties> getPreferredDeviceComparator() {
        return this.preferredDeviceComparator;
    }

    private OpenCLOptions(Predicate<PlatformProperties> platformFilter, Comparator<DeviceProperties> preferredDeviceComparator) {
        this.platformFilter = platformFilter;
        this.preferredDeviceComparator = preferredDeviceComparator;
    }

    public static OpenCLOptions defaults() {
        return OpenCLOptions.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Predicate<PlatformProperties> platformFilter = p -> true;
        private Comparator<DeviceProperties> preferredDeviceComparator = Comparator.comparingInt(DeviceProperties::getNumberOfComputeUnits);

        public Builder platformFilter(Predicate<PlatformProperties> platformFilter) {
            Objects.requireNonNull(platformFilter);
            this.platformFilter = platformFilter;
            return this;
        }

        public Builder preferredDeviceComparator(Comparator<DeviceProperties> preferredDeviceComparator) {
            Objects.requireNonNull(preferredDeviceComparator);
            this.preferredDeviceComparator = preferredDeviceComparator;
            return this;
        }

        public OpenCLOptions build() {
            return new OpenCLOptions(this.platformFilter, this.preferredDeviceComparator);
        }
    }
}

