/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.flightrecorderstarter.actuator;

import de.mirkosertic.flightrecorderstarter.actuator.model.FlightRecorderPublicSession;
import de.mirkosertic.flightrecorderstarter.core.FlightRecorder;
import de.mirkosertic.flightrecorderstarter.core.StartRecordingCommand;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestControllerEndpoint(id="flightrecorder")
public class FlightRecorderEndpoint {
    private static final Logger LOGGER = Logger.getLogger(FlightRecorder.class.getCanonicalName());
    private final FlightRecorder flightRecorder;

    public FlightRecorderEndpoint(FlightRecorder flightRecorder) {
        this.flightRecorder = flightRecorder;
    }

    @GetMapping(value={"/"})
    public ResponseEntity<?> allSessions() {
        try {
            LOGGER.log(Level.INFO, "Retrieving all known recording sessions");
            List<FlightRecorderPublicSession> sessions = this.flightRecorder.sessions();
            return ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body(sessions);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/"})
    public ResponseEntity<?> startRecording(@RequestBody StartRecordingCommand command) {
        if (command.getDuration() == null || command.getTimeUnit() == null) {
            return ResponseEntity.badRequest().body((Object)"Duration and TimeUnit cannot be null");
        }
        try {
            LOGGER.log(Level.INFO, "Trying to start recording for {0} {1}", new Object[]{command.getDuration(), command.getTimeUnit()});
            long recordingId = this.flightRecorder.startRecordingFor(command);
            LOGGER.log(Level.INFO, "Created recording with ID {0}", recordingId);
            return ResponseEntity.created((URI)ServletUriComponentsBuilder.fromCurrentRequest().path("/{id}").build(new Object[]{recordingId})).build();
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getMessage());
        }
    }

    @PutMapping(value={"/{recordingId}"})
    public ResponseEntity<?> stopRecording(@Selector @PathVariable long recordingId) {
        LOGGER.log(Level.INFO, "Stopping recording with ID {0}", recordingId);
        File file = this.flightRecorder.stopRecording(recordingId);
        if (file != null) {
            return ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body((Object)this.flightRecorder.getById(recordingId));
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{recordingId}"})
    public ResponseEntity<?> deleteRecording(@Selector @PathVariable long recordingId) {
        try {
            LOGGER.log(Level.INFO, "Deleting recording with ID {0}", recordingId);
            File file = this.flightRecorder.stopRecording(recordingId);
            if (file != null) {
                this.flightRecorder.deleteRecording(recordingId);
                return ResponseEntity.noContent().build();
            }
            return ResponseEntity.notFound().build();
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getMessage());
        }
    }

    @GetMapping(value={"/{recordingId}"})
    public ResponseEntity<?> downloadRecording(@Selector @PathVariable long recordingId) {
        LOGGER.log(Level.INFO, "Closing recording with ID {0} and downloading file", recordingId);
        File file = this.flightRecorder.stopRecording(recordingId);
        if (file != null) {
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Disposition", "attachment; filename=flightrecording_" + recordingId + ".jfr");
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)new FileSystemResource(file));
        }
        return ResponseEntity.notFound().build();
    }
}

