/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.flightrecorderstarter.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.mirkosertic.flightrecorderstarter.actuator.model.FlameGraph;
import de.mirkosertic.flightrecorderstarter.core.FlightRecorder;
import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${flightrecorder.calculated-static-controller-base-path}"})
public class FlightRecorderStaticController {
    private static final Logger LOGGER = Logger.getLogger(FlightRecorderStaticController.class.getCanonicalName());
    public static final String DATA_JSON = "/data.json";
    public static final String RAWDATA_JSON = "/rawdata.json";
    private final ApplicationContext applicationContext;
    private final FlightRecorder flightRecorder;
    private final ObjectMapper objectMapper;
    static final MediaType TEXT_CSS = new MediaType("text", "css");
    static final MediaType TEXT_JAVASCRIPT = new MediaType("text", "javascript");
    static final String D3_V4_MIN_JS = "/d3.v4.min.js";
    static final String D3_FLAMEGRAPH_MIN_JS = "/d3-flamegraph.min.js";
    static final String D3_FLAMEGRAPH_COLOR_MAPPER_MIN_JS = "/d3-flamegraph-colorMapper.min.js";
    static final String D3_FLAMEGRAPH_TOOLTIP_MIN_JS = "/d3-flamegraph-tooltip.min.js";
    static final String D3_FLAMEGRAPH_CSS = "/d3-flamegraph.css";
    static final String RAM_FLAMEGRAPH_HTML = "/rawflamegraph.html";
    static final String FLAMEGRAPH_HTML = "/flamegraph.html";
    static final String RECORDING_ID = "/{recordingId}";
    static final String CACHE_CONTROL_KEY = "Cache-Control";
    static final String CACHE_CONTROL_VALUE = "no-cache, no-store, must-revalidate";
    static final String PRAGMA_KEY = "Pragma";
    static final String PRAGMA_VALUE = "no-cache";
    static final String EXPIRES_KEY = "Expires";
    static final String EXPIRES_VALUE = "0";

    public FlightRecorderStaticController(ApplicationContext applicationContext, FlightRecorder flightRecorder, ObjectMapper objectMapper) {
        this.applicationContext = applicationContext;
        this.flightRecorder = flightRecorder;
        this.objectMapper = objectMapper;
    }

    @GetMapping(value={"/d3.v4.min.js"})
    public ResponseEntity downloadRecording2() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.createHttpHeaders())).contentType(TEXT_JAVASCRIPT).body((Object)new ClassPathResource(D3_V4_MIN_JS));
    }

    @GetMapping(value={"/d3-flamegraph.min.js"})
    public ResponseEntity downloadRecording3() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.createHttpHeaders())).contentType(TEXT_JAVASCRIPT).body((Object)new ClassPathResource(D3_FLAMEGRAPH_MIN_JS));
    }

    @GetMapping(value={"/d3-flamegraph-colorMapper.min.js"})
    public ResponseEntity downloadRecording4() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.createHttpHeaders())).contentType(TEXT_JAVASCRIPT).body((Object)new ClassPathResource(D3_FLAMEGRAPH_COLOR_MAPPER_MIN_JS));
    }

    @GetMapping(value={"/d3-flamegraph-tooltip.min.js"})
    public ResponseEntity downloadRecording5() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.createHttpHeaders())).contentType(TEXT_JAVASCRIPT).body((Object)new ClassPathResource(D3_FLAMEGRAPH_TOOLTIP_MIN_JS));
    }

    @GetMapping(value={"/d3-flamegraph.css"})
    public ResponseEntity downloadRecording6() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.createHttpHeaders())).contentType(TEXT_CSS).body((Object)new ClassPathResource(D3_FLAMEGRAPH_CSS));
    }

    @GetMapping(value={"/{recordingId}/flamegraph.html"})
    public ResponseEntity downloadRecordingFlameGraph(@PathVariable long recordingId) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.createHttpHeaders())).contentType(MediaType.TEXT_HTML).body((Object)new ClassPathResource(FLAMEGRAPH_HTML));
    }

    @GetMapping(value={"/{recordingId}/rawflamegraph.html"})
    public ResponseEntity downloadRecordingRawFlameGraph(@PathVariable long recordingId) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.createHttpHeaders())).contentType(MediaType.TEXT_HTML).body((Object)new ClassPathResource(RAM_FLAMEGRAPH_HTML));
    }

    @GetMapping(value={"/{recordingId}/data.json"})
    public ResponseEntity downloadRecordingJson(@PathVariable long recordingId) {
        LOGGER.log(Level.INFO, "Closing recording with ID {0} and downloading file", recordingId);
        try {
            FlameGraph graph;
            File file = this.flightRecorder.stopRecording(recordingId);
            if (file == null) {
                return ResponseEntity.notFound().build();
            }
            String bootClass = this.findBootClass(this.applicationContext);
            if (bootClass == null) {
                graph = FlameGraph.from(file);
            } else {
                int p = bootClass.lastIndexOf(".");
                String basePackage = bootClass.substring(0, p + 1);
                graph = FlameGraph.from(file, new FlameGraph.PackageNamePrefixFrameFilter(basePackage));
            }
            String jsonData = this.objectMapper.writeValueAsString((Object)graph.getRoot());
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.createHttpHeaders())).contentType(MediaType.APPLICATION_JSON).body((Object)jsonData);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not create json data for flight recording", e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getMessage());
        }
    }

    @GetMapping(value={"/{recordingId}/rawdata.json"})
    public ResponseEntity downloadRecordingRawJson(@PathVariable long recordingId) {
        LOGGER.log(Level.INFO, "Closing recording with ID {0} and downloading file", recordingId);
        try {
            File file = this.flightRecorder.stopRecording(recordingId);
            if (file == null) {
                return ResponseEntity.notFound().build();
            }
            FlameGraph graph = FlameGraph.from(file);
            String jsonData = this.objectMapper.writeValueAsString((Object)graph.getRoot());
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.createHttpHeaders())).contentType(MediaType.APPLICATION_JSON).body((Object)jsonData);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not create json data for flight recording", e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getMessage());
        }
    }

    private HttpHeaders createHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.add(CACHE_CONTROL_KEY, CACHE_CONTROL_VALUE);
        headers.add(PRAGMA_KEY, PRAGMA_VALUE);
        headers.add(EXPIRES_KEY, EXPIRES_VALUE);
        return headers;
    }

    String findBootClass(ApplicationContext applicationContext) {
        Map annotatedBeans = applicationContext.getBeansWithAnnotation(SpringBootApplication.class);
        if (annotatedBeans.isEmpty()) {
            if (applicationContext.getParent() != null) {
                return this.findBootClass(applicationContext.getParent());
            }
            return null;
        }
        return annotatedBeans.values().toArray()[0].getClass().getName();
    }
}

