/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.flightrecorderstarter.trigger;

import de.mirkosertic.flightrecorderstarter.configuration.FlightRecorderDynamicConfiguration;
import de.mirkosertic.flightrecorderstarter.core.FlightRecorder;
import de.mirkosertic.flightrecorderstarter.core.StartRecordingCommand;
import de.mirkosertic.flightrecorderstarter.trigger.MicrometerAdapter;
import de.mirkosertic.flightrecorderstarter.trigger.Trigger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.scheduling.annotation.Scheduled;

public class TriggerChecker {
    private static final Logger LOGGER = Logger.getLogger(TriggerChecker.class.getCanonicalName());
    public static final long UNKNOWN_RECORDING_ID = -1L;
    private final FlightRecorderDynamicConfiguration dynamicConfiguration;
    private final FlightRecorder flightRecorder;
    private final StandardEvaluationContext evaluationContext;
    private final Map<TriggerSPEL, Long> latestRecordings;

    public TriggerChecker(BeanFactory beanFactory, FlightRecorderDynamicConfiguration dynamicConfiguration, FlightRecorder flightRecorder, MicrometerAdapter micrometerAdapter) {
        this.dynamicConfiguration = dynamicConfiguration;
        this.flightRecorder = flightRecorder;
        this.latestRecordings = new HashMap<TriggerSPEL, Long>();
        this.evaluationContext = new StandardEvaluationContext((Object)micrometerAdapter);
        this.evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        SpelParserConfiguration config = new SpelParserConfiguration(SpelCompilerMode.IMMEDIATE, this.getClass().getClassLoader());
        SpelExpressionParser parser = new SpelExpressionParser(config);
        if (dynamicConfiguration.getTrigger() != null) {
            for (Trigger trigger : dynamicConfiguration.getTrigger()) {
                LOGGER.log(Level.INFO, "Registering trigger {0}", trigger.getExpression());
                Expression expression = parser.parseExpression(trigger.getExpression());
                this.latestRecordings.put(new TriggerSPEL(trigger, expression), -1L);
            }
        }
    }

    @Scheduled(fixedDelayString="${flightrecorder.trigger-check-interval}")
    public void check() {
        if (this.dynamicConfiguration.isEnabled()) {
            HashSet<TriggerSPEL> triggers = new HashSet<TriggerSPEL>(this.latestRecordings.keySet());
            for (TriggerSPEL triggerSPEL : triggers) {
                long latestRecordingId = this.latestRecordings.get(triggerSPEL);
                if (latestRecordingId != -1L && !this.flightRecorder.isRecordingStopped(latestRecordingId)) continue;
                try {
                    Boolean checkResult = (Boolean)triggerSPEL.expression.getValue((EvaluationContext)this.evaluationContext, Boolean.class);
                    if (checkResult == null || !checkResult.booleanValue()) continue;
                    if (latestRecordingId != -1L) {
                        this.flightRecorder.stopRecording(latestRecordingId);
                    }
                    StartRecordingCommand startRecordingCommand = triggerSPEL.trigger.getStartRecordingCommand();
                    startRecordingCommand.setDescription(triggerSPEL.trigger.getExpression());
                    long newRecordingId = this.flightRecorder.startRecordingFor(startRecordingCommand);
                    this.latestRecordings.put(triggerSPEL, newRecordingId);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error evaluating trigger {0} : {1}", new Object[]{triggerSPEL.trigger.getExpression(), e.getMessage()});
                }
            }
        }
    }

    private static class TriggerSPEL {
        private final Trigger trigger;
        private final Expression expression;

        public TriggerSPEL(Trigger trigger, Expression expression) {
            this.trigger = trigger;
            this.expression = expression;
        }
    }
}

