/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.flightrecorderstarter.actuator;

import de.mirkosertic.flightrecorderstarter.actuator.model.FlightRecorderPublicSession;
import de.mirkosertic.flightrecorderstarter.core.FlightRecorder;
import de.mirkosertic.flightrecorderstarter.core.StartRecordingCommand;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestControllerEndpoint(id="flightrecorder")
public class ReactiveFlightRecorderEndpoint {
    private static final Logger LOGGER = Logger.getLogger(ReactiveFlightRecorderEndpoint.class.getCanonicalName());
    private final FlightRecorder flightRecorder;

    public ReactiveFlightRecorderEndpoint(FlightRecorder flightRecorder) {
        this.flightRecorder = flightRecorder;
    }

    @GetMapping(value={"/"})
    public Flux<FlightRecorderPublicSession> allSessions() {
        return Flux.defer(() -> {
            LOGGER.info("Retrieving all known recording sessions");
            return Flux.fromIterable(this.flightRecorder.sessions());
        }).doOnError(e -> ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getMessage()));
    }

    @PostMapping(value={"/"})
    public Mono<ResponseEntity<?>> startRecording(@RequestBody Mono<StartRecordingCommand> commandInput, ServerWebExchange serverWebExchange) {
        return commandInput.filter(command -> command.getDuration() != null && command.getTimeUnit() != null).doOnNext(c -> LOGGER.log(Level.INFO, "Trying to start recording for {0} {1}", new Object[]{c.getDuration(), c.getTimeUnit()})).map(command -> {
            Long recordingId = null;
            try {
                recordingId = this.flightRecorder.startRecordingFor((StartRecordingCommand)command);
            }
            catch (IOException ioe) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ioe.getMessage());
            }
            LOGGER.log(Level.INFO, "Created recording with ID {0}", recordingId);
            return ResponseEntity.created((URI)UriComponentsBuilder.fromUri((URI)serverWebExchange.getRequest().getURI()).path("/{id}").build(new Object[]{recordingId})).build();
        }).switchIfEmpty(Mono.just((Object)ResponseEntity.badRequest().body((Object)"Duration and TimeUnit cannot be null")));
    }

    @PutMapping(value={"/{recordingId}"})
    public Mono<ResponseEntity<?>> stopRecording(@Selector @PathVariable Long recordingId) {
        return Mono.just((Object)recordingId).map(recordingIdMap -> {
            LOGGER.log(Level.INFO, "Stopping recording with ID {0}", recordingIdMap);
            File file = this.flightRecorder.stopRecording((long)recordingIdMap);
            if (file != null) {
                return ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body((Object)this.flightRecorder.getById((Long)recordingIdMap));
            }
            return ResponseEntity.notFound().build();
        });
    }

    @DeleteMapping(value={"/{recordingId}"})
    public Mono<ResponseEntity<?>> deleteRecording(@Selector @PathVariable Long recordingId) {
        return Mono.just((Object)recordingId).map(recordingIdMap -> {
            try {
                LOGGER.log(Level.INFO, "Deleting recording with ID {0}", recordingIdMap);
                File file = this.flightRecorder.stopRecording((long)recordingIdMap);
                if (file != null) {
                    this.flightRecorder.deleteRecording((long)recordingIdMap);
                    return ResponseEntity.noContent().build();
                }
                return ResponseEntity.notFound().build();
            }
            catch (Exception e) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getMessage());
            }
        });
    }

    @GetMapping(value={"/{recordingId}"})
    public Mono<ResponseEntity<?>> downloadRecording(@Selector @PathVariable Long recordingId) {
        return Mono.just((Object)recordingId).map(recordingIdMap -> {
            LOGGER.log(Level.INFO, "Closing recording with ID {0} and downloading file", recordingIdMap);
            File file = this.flightRecorder.stopRecording((long)recordingIdMap);
            if (file != null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers -> {
                    headers.add("Content-Disposition", "attachment; filename=flightrecording_" + recordingIdMap + ".jfr");
                    headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
                    headers.add("Pragma", "no-cache");
                    headers.add("Expires", "0");
                })).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)new FileSystemResource(file));
            }
            return ResponseEntity.notFound().build();
        });
    }
}

