/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.flightrecorderstarter.actuator.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedFrame;
import jdk.jfr.consumer.RecordedStackTrace;
import jdk.jfr.consumer.RecordingFile;

public class FlameGraph {
    public static final FrameFilter ALL = className -> true;
    private final Node root;

    private FlameGraph(Node root) {
        this.root = root;
    }

    public static FlameGraph from(File file, FrameFilter frameFilter) throws IOException {
        Node rootNode = new Node("Recording");
        try (RecordingFile rf = new RecordingFile(file.toPath());){
            while (rf.hasMoreEvents()) {
                RecordedEvent event = rf.readEvent();
                if (!"jdk.ExecutionSample".equals(event.getEventType().getName())) continue;
                RecordedStackTrace stackTrace = event.getStackTrace();
                List<RecordedFrame> frames = stackTrace.getFrames();
                Node currentNode = rootNode;
                for (int i = frames.size() - 1; i >= 0; --i) {
                    RecordedFrame frame = frames.get(i);
                    if (!frame.isJavaFrame() || !frameFilter.includes(frame.getMethod().getType().getName())) continue;
                    currentNode = currentNode.childByName(FlameGraph.nameOf(frame));
                }
            }
        }
        return new FlameGraph(rootNode);
    }

    public static FlameGraph from(File file) throws IOException {
        return FlameGraph.from(file, ALL);
    }

    public Node getRoot() {
        return this.root;
    }

    private static String nameOf(RecordedFrame frame) {
        String className = frame.getMethod().getType().getName();
        String methodName = frame.getMethod().getName();
        String descriptor = frame.getMethod().getDescriptor();
        int lineNumber = frame.getLineNumber();
        return className + "." + methodName;
    }

    public static class Node {
        private String name;
        private int value;
        private final Map<String, Node> children;

        private Node() {
            this.children = new HashMap<String, Node>();
        }

        public Node(String name) {
            this.name = name;
            this.value = 0;
            this.children = new HashMap<String, Node>();
        }

        public Node childByName(String nameOf) {
            Node node = this.children.computeIfAbsent(nameOf, Node::new);
            ++node.value;
            return node;
        }

        public String getName() {
            return this.name;
        }

        public int getValue() {
            return this.value;
        }

        public List<Node> getChildren() {
            ArrayList<Node> nodes = new ArrayList<Node>(this.children.values());
            nodes.sort(Comparator.comparingInt(o -> o.value));
            return nodes;
        }
    }

    @FunctionalInterface
    public static interface FrameFilter {
        public boolean includes(String var1);
    }

    public static class PackageNamePrefixFrameFilter
    implements FrameFilter {
        private final String prefix;

        public PackageNamePrefixFrameFilter(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean includes(String className) {
            return className.startsWith(this.prefix) && !className.contains("$$FastClassBySpringCGLIB$$") && !className.contains("$$EnhancerBySpringCGLIB$$");
        }
    }
}

