/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.flightrecorderstarter.trigger;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.search.MeterNotFoundException;
import io.micrometer.core.instrument.search.RequiredSearch;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MeterQuery {
    private static final Logger LOGGER = Logger.getLogger(MeterQuery.class.getCanonicalName());
    private final RequiredSearch requiredSearch;

    public MeterQuery(RequiredSearch requiredSearch) {
        this.requiredSearch = requiredSearch;
    }

    public MeterQuery tag(String tagKey, String tagValue) {
        this.requiredSearch.tag(tagKey, tagValue);
        return this;
    }

    public MeterQuery tag(String tagKey) {
        this.requiredSearch.tagKeys(new String[]{tagKey});
        return this;
    }

    public double measurement(String statisticsName) {
        try {
            Meter meter = this.requiredSearch.meter();
            for (Measurement m : meter.measure()) {
                if (!m.getStatistic().getTagValueRepresentation().equals(statisticsName)) continue;
                return m.getValue();
            }
            LOGGER.log(Level.FINE, "No measurement with name {} found", statisticsName);
            return 0.0;
        }
        catch (MeterNotFoundException e) {
            LOGGER.log(Level.FINE, "No meter found", e);
            return 0.0;
        }
    }
}

