/*
 * Decompiled with CFR 0.152.
 */
package de.mkammerer.argon2;

import de.mkammerer.argon2.Argon2;

public final class Argon2Helper {
    private static final long MILLIS_IN_NANOS = 1000000L;

    private Argon2Helper() {
    }

    public static int findIterations(Argon2 argon2, long maxMillisecs, int memory, int parallelism) {
        return Argon2Helper.findIterations(argon2, maxMillisecs, memory, parallelism, new NoopLogger());
    }

    public static int findIterations(Argon2 argon2, long maxMillisecs, int memory, int parallelism, IterationLogger logger) {
        long took;
        char[] password = "password".toCharArray();
        int iterations = 0;
        do {
            long start = System.nanoTime() / 1000000L;
            argon2.hash(++iterations, memory, parallelism, password);
            long end = System.nanoTime() / 1000000L;
            took = end - start;
            logger.log(iterations, took);
        } while (took <= maxMillisecs);
        return iterations - 1;
    }

    public static class NoopLogger
    implements IterationLogger {
        @Override
        public void log(int iterations, long millisecs) {
        }
    }

    public static interface IterationLogger {
        public void log(int var1, long var2);
    }
}

